/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/rta/plugin/Plugin","sap/ui/dt/OverlayUtil","sap/ui/core/Control"],function(P,O,C){"use strict";var S=P.extend("sap.ui.rta.plugin.Stretch",{metadata:{library:"sap.ui.rta",properties:{},associations:{stretchCandidates:{type:"sap.ui.dt.ElementOverlay",multiple:true}},events:{}}});S.prototype.setDesignTime=function(d){P.prototype.setDesignTime.apply(this,arguments);if(d){d.attachEventOnce("synced",this._setStyleClassForAllStretchCandidates,this);}};S.prototype.registerElementOverlay=function(o){this._checkAndAddToStretchCandidates(o);P.prototype.registerElementOverlay.apply(this,arguments);};S.prototype.deregisterElementOverlay=function(o){if(o.getElement()instanceof C){o.getElement().removeStyleClass("sapUiRtaStretchPaddingTop");}o.detachEditableChange(this._toggleStyleClass,this);};S.prototype._isEditable=function(){return false;};S.prototype._checkAndAddToStretchCandidates=function(o){var p=o.getParentElementOverlay();if(p&&p.getElement()instanceof C){if(this._startAtSamePosition(p,o)){if(this._childrenAreSameSize(p)){this.addStretchCandidate(p);}}}};S.prototype._startAtSamePosition=function(p,o){if(p&&p.getGeometry()&&o.getGeometry()){if(p.getGeometry().position.top===o.getGeometry().position.top&&p.getGeometry().position.left===o.getGeometry().position.left){return true;}}};S.prototype._childrenAreSameSize=function(r,c){var p=r.getGeometry().size.width*r.getGeometry().size.height;c=c||O.getAllChildOverlays(r);var a=c.map(function(b){return b.getGeometry();});var o=O.getGeometry(a);if(!o){return false;}var i=o.size.width*o.size.height;return i===p;};S.prototype._atLeastOneDescendantEditable=function(r,c){var a=c.some(function(o){return o.getEditable()&&o.getGeometry();});if(a){return true;}else{var b=[];c.forEach(function(o){b=b.concat(O.getAllChildOverlays(o));});if(!b.length>0){return false;}if(this._childrenAreSameSize(r,b)){return this._atLeastOneDescendantEditable(r,b);}}};S.prototype._setStyleClassForAllStretchCandidates=function(){this.getStretchCandidates().forEach(function(o){var a=sap.ui.getCore().byId(o);var A=false;var c=O.getAllChildOverlays(a);var b=this._atLeastOneDescendantEditable(a,c);if(a.getEditable()&&b){A=true;}if(A){this._toggleStyleClass({},true,a);}a.attachEditableChange(this._toggleStyleClass,this);},this);};S.prototype._toggleStyleClass=function(p,f,o){o=o||p.getSource();if(f||p.getParameters().editable){o.getElement().addStyleClass("sapUiRtaStretchPaddingTop");}else{o.getElement().removeStyleClass("sapUiRtaStretchPaddingTop");}};return S;},true);
