/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/theming/Parameters','sap/ui/Device','./library','./TableUtils',"./TableExtension",'sap/ui/core/Renderer','sap/ui/core/IconPool',"sap/base/Log"],function(C,P,D,a,T,b,R,I,L){"use strict";var S=a.SelectionMode,V=a.VisibleRowCountMode;var c={};c.render=function(r,t){delete t._iHeaderRowCount;T.getResourceBundle();r.write("<div");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROOT");r.writeControlData(t);r.addClass("sapUiTable");if('ontouchstart'in document){r.addClass("sapUiTableTouch");}r.addClass("sapUiTableSelMode"+t.getSelectionMode());if(t.getColumnHeaderVisible()){r.addClass("sapUiTableCHdr");}if(T.hasRowHeader(t)){r.addClass("sapUiTableRowSelectors");}if(T.hasRowHighlights(t)){r.addClass("sapUiTableRowHighlights");}var s=a.TableHelper.addTableClass();if(s){r.addClass(s);}var o=t._getScrollExtension();if(o.isVerticalScrollbarRequired()&&!o.isVerticalScrollbarExternal()){r.addClass("sapUiTableVScr");}if(t.getEditable()){r.addClass("sapUiTableEdt");}if(T.hasRowActions(t)){var i=T.getRowActionCount(t);r.addClass(i==1?"sapUiTableRActS":"sapUiTableRAct");}if(T.isNoDataVisible(t)&&!T.hasPendingRequests(t)){r.addClass("sapUiTableEmpty");}if(t.getShowOverlay()){r.addClass("sapUiTableOverlay");}var m=T.Grouping.getModeCssClass(t);if(m){r.addClass(m);}if(t.getWidth()){r.addStyle("width",t.getWidth());}if(t.getVisibleRowCountMode()==V.Auto){r.addStyle("height","0px");if(t._bFirstRendering){r.addClass("sapUiTableNoOpacity");}}r.writeClasses();r.writeStyles();r.write(">");this.renderTabElement(r,"sapUiTableOuterBefore");if(t.getTitle()){this.renderHeader(r,t,t.getTitle());}if(t.getToolbar()){this.renderToolbar(r,t,t.getToolbar());}if(t.getExtension()&&t.getExtension().length>0){this.renderExtensions(r,t,t.getExtension());}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCnt");r.addClass("sapUiTableCnt");r.writeClasses();r.writeAttribute("data-sap-ui-fastnavgroup","true");r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableGridCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"CONTENT");r.write(">");this.renderColRsz(r,t);this.renderColHdr(r,t);this.renderTable(r,t);r.write("</div>");t._getAccRenderExtension().writeHiddenAccTexts(r,t);r.write("<div");r.addClass("sapUiTableOverlayArea");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-overlay");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"OVERLAY");r.write("></div>");r.write("</div>");if(t.getFooter()){this.renderFooter(r,t,t.getFooter());}if(t.getVisibleRowCountMode()==V.Interactive){this.renderVariableHeight(r,t);}this.renderTabElement(r,"sapUiTableOuterAfter");r.write("</div>");};c.renderHeader=function(r,t,o){r.write("<div");r.addClass("sapUiTableHdr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEHEADER");r.write(">");r.renderControl(o);r.write("</div>");};c.renderToolbar=function(r,t,o){r.write("<div");r.addClass("sapUiTableTbr");if(typeof o.getStandalone==="function"&&o.getStandalone()){o.setStandalone(false);}if(o.isA("sap.m.Toolbar")){o.setDesign(P.get("_sap_ui_table_Table_ToolbarDesign"),true);o.addStyleClass("sapMTBHeader-CTX");r.addClass("sapUiTableMTbr");}r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");r.renderControl(o);r.write("</div>");};c.renderExtensions=function(r,t,e){for(var i=0,l=e.length;i<l;i++){this.renderExtension(r,t,e[i]);}};c.renderExtension=function(r,t,e){r.write("<div");r.addClass("sapUiTableExt");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLESUBHEADER");r.write(">");r.renderControl(e);r.write("</div>");};c.renderTable=function(r,t){this.renderTabElement(r,"sapUiTableCtrlBefore");r.write("<div");r.writeAttribute("id",t.getId()+"-tableCCnt");r.addClass("sapUiTableCCnt");r.writeClasses();r.write(">");this.renderTableCCnt(r,t);r.write("</div>");this.renderTabElement(r,"sapUiTableCtrlAfter");if(!t._getScrollExtension().isVerticalScrollbarExternal()){this.renderVSbBackground(r,t);this.renderVSb(r,t);}this.renderHSbBackground(r,t);this.renderHSb(r,t);};c.renderTableCCnt=function(r,t){this.renderTableCtrl(r,t);this.renderRowHdr(r,t);this.renderRowActions(r,t);r.write("<div");r.addClass("sapUiTableCtrlEmpty");r.writeClasses();r.writeAttribute("tabindex","0");r.writeAttribute("id",t.getId()+"-noDataCnt");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"NODATA");r.write(">");if(t.getNoData()instanceof C){r.renderControl(t.getNoData());}else{r.write("<span");r.writeAttribute("id",t.getId()+"-noDataMsg");r.addClass("sapUiTableCtrlEmptyMsg");r.writeClasses();r.write(">");r.writeEscaped(T.getNoDataText(t));r.write("</span>");}r.write("</div>");};c.renderFooter=function(r,t,f){r.write("<div");r.addClass("sapUiTableFtr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TABLEFOOTER");r.write(">");r.renderControl(f);r.write("</div>");};c.renderVariableHeight=function(r,t){r.write('<div id="'+t.getId()+'-sb" tabIndex="-1"');r.addClass("sapUiTableHeightResizer");r.addStyle("height","5px");r.writeClasses();r.writeStyles();r.write(">");r.write("</div>");};c.renderColHdr=function(r,t){var n=T.getHeaderRowCount(t);var d=t.getColumns();var f=t.getComputedFixedColumnCount();r.write("<div");r.addClass("sapUiTableColHdrCnt");r.writeClasses();r.write(">");this.renderColRowHdr(r,t);if(f>0){r.write("<div");r.addClass("sapUiTableCHA");r.addClass("sapUiTableCtrlScrFixed");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");this.renderTableControlCnt(r,t,true,0,f,true,false,0,n,true);r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableColHdrScr");r.addClass("sapUiTableCHA");r.addClass("sapUiTableCtrlScr");if(d.length==0){r.addClass("sapUiTableHasNoColumns");}r.writeClasses();if(f>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");this.renderTableControlCnt(r,t,false,f,d.length,false,false,0,n,true);r.write("</div>");if(T.hasRowActions(t)){r.write("<div class='sapUiTableRowActionHeader' id='"+t.getId()+"-rowacthdr'");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWACTIONHEADER");r.write("><span>");r.writeEscaped(T.getResourceText("TBL_ROW_ACTION_COLUMN_LABEL"));r.write("</span></div>");}r.write("</div>");};c.renderColRowHdr=function(r,t){var e=false;var s=false;r.write("<div");r.writeAttribute("id",t.getId()+"-selall");if(T.hasSelectAll(t)){var A=T.areAllRowsSelected(t);if(t._getShowStandardTooltips()){var d=A?"TBL_DESELECT_ALL":"TBL_SELECT_ALL";r.writeAttributeEscaped("title",T.getResourceText(d));}if(!A){r.addClass("sapUiTableSelAll");}else{s=true;}r.addClass("sapUiTableSelAllEnabled");e=true;}else{r.addClass("sapUiTableSelAllDisabled");}r.addClass("sapUiTableColRowHdr");r.writeClasses();r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNROWHEADER",{enabled:e,checked:s});r.write(">");if(t.getSelectionMode()!==S.Single){r.write("<div");r.addClass("sapUiTableColRowHdrIco");r.writeClasses();r.write("></div>");}r.write("</div>");};c.renderCol=function(r,t,o,h,n,l){var d,i=!n,e=o.getIndex(),f=o.getMultiLabels();if(f.length>0){d=f[h];}else if(h==0){d=o.getLabel();}r.write("<td");var H=o.getId();if(h===0){r.writeElementData(o);}else{H=H+"_"+h;r.writeAttribute('id',H);}r.writeAttribute('data-sap-ui-colid',o.getId());r.writeAttribute("data-sap-ui-colindex",e);r.writeAttribute("tabindex","-1");var A={column:o,headerId:H,index:e};if(n>1){r.writeAttribute("colspan",n);A.colspan=true;}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER",A);r.addClass("sapUiTableCol");if(l){r.addClass("sapUiTableColLastFixed");}if(i){r.addClass("sapUiTableColInvisible");}r.writeClasses();if(t.getColumnHeaderHeight()>0){r.addStyle("height",t.getColumnHeaderHeight()+"px");}r.writeStyles();var s=o.getTooltip_AsString();if(s){r.writeAttributeEscaped("title",s);}r.write("><div");r.addClass("sapUiTableColCell");r.writeAttribute("id",H+"-inner");r.writeClasses();var g=R.getTextAlign(o.getHAlign(),d&&d.getTextDirection&&d.getTextDirection());if(g){r.addStyle("text-align",g);}r.writeStyles();r.write(">");if(d){r.renderControl(d);}r.write("</div></td>");};c.renderColRsz=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-rsz");r.addClass("sapUiTableColRsz");r.writeClasses();r.write("></div>");};c.renderRowHdr=function(r,t){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableRowHdrScr");r.addClass("sapUiTableRowHdrScr");r.addClass("sapUiTableNoOpacity");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_COL");r.write(">");for(var d=0,e=t.getRows().length;d<e;d++){this.renderRowAddon(r,t,t.getRows()[d],d,true);}r.write("</div>");};c.renderRowActions=function(r,t){if(!T.hasRowActions(t)){return;}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableRowActionScr");r.addClass("sapUiTableRowActionScr");r.addClass("sapUiTableNoOpacity");r.writeClasses();r.write(">");for(var d=0,e=t.getRows().length;d<e;d++){this.renderRowAddon(r,t,t.getRows()[d],d,false);}r.write("</div>");};c._addFixedRowCSSClasses=function(r,t,i){var f=t.getFixedRowCount();var F=T.getFirstFixedButtomRowIndex(t);if(f>0){if(i<f){r.addClass("sapUiTableFixedTopRow");}if(i==f-1){r.addClass("sapUiTableFixedLastTopRow");}}if(F>=0&&F===i){r.addClass("sapUiTableFixedFirstBottomRow");}else if(F>=1&&F-1===i){r.addClass("sapUiTableFixedPreBottomRow");}};c.renderRowAddon=function(r,t,o,i,h){r.write("<div");r.writeAttribute("id",t.getId()+(h?"-rowsel":"-rowact")+i);r.writeAttribute("data-sap-ui-related",o.getId());r.writeAttribute("data-sap-ui-rowindex",i);r.addClass(h?"sapUiTableRowHdr":"sapUiTableRowAction");if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isTreeMode(t)){r.addClass("sapUiTableRowAlternate");}this._addFixedRowCSSClasses(r,t,i);var d=false;var e=false;if(o._bHidden){r.addClass("sapUiTableRowHidden");e=true;}else{if(t.isIndexSelected(o.getIndex())){r.addClass("sapUiTableRowSel");d=true;}}r.writeClasses();if(t.getRowHeight()>0){r.addStyle("height",t._getDefaultRowHeight()+"px");}r.writeAttribute("tabindex","-1");t._getAccRenderExtension().writeAriaAttributesFor(r,t,h?"ROWHEADER":"ROWACTION",{rowSelected:d,rowHidden:e});r.writeStyles();r.write(">");if(h){this.writeRowHighlightContent(r,t,o,i);this.writeRowSelectorContent(r,t,o,i);}else{var A=o.getAggregation("_rowAction");if(A){r.renderControl(A);}}r.write("</div>");};c.renderTableCtrl=function(r,t){if(t.getComputedFixedColumnCount()>0){r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScrFixed");r.addClass("sapUiTableCtrlScrFixed");r.writeClasses();r.write(">");this.renderTableControl(r,t,true);r.write("</div>");}r.write("<div");r.writeAttribute("id",t.getId()+"-sapUiTableCtrlScr");r.addClass("sapUiTableCtrlScr");r.writeClasses();if(t.getComputedFixedColumnCount()>0){if(t._bRtlMode){r.addStyle("margin-right","0");}else{r.addStyle("margin-left","0");}r.writeStyles();}r.write(">");r.write("<div");r.writeAttribute("id",t.getId()+"-tableCtrlCnt");r.addClass("sapUiTableCtrlCnt");r.writeClasses();if(!T.isVariableRowHeightEnabled(t)){var v=t.getVisibleRowCountMode();if(t._iTableRowContentHeight&&(v==V.Fixed||v==V.Interactive)){var s="height";if(t.getVisibleRowCountMode()==V.Fixed){s="min-height";}r.addStyle(s,t._iTableRowContentHeight+"px");r.writeStyles();}}r.write(">");this.renderTableControl(r,t,false);r.write("</div></div>");};c.renderTableControl=function(r,t,f){var s,e;if(f){s=0;e=t.getComputedFixedColumnCount();}else{s=t.getComputedFixedColumnCount();e=t.getColumns().length;}var F=t.getFixedRowCount();var i=t.getFixedBottomRowCount();var d=t.getRows();if(F>0){this.renderTableControlCnt(r,t,f,s,e,true,false,0,F);}this.renderTableControlCnt(r,t,f,s,e,false,false,F,d.length-i);if(i>0&&d.length>0){this.renderTableControlCnt(r,t,f,s,e,false,true,d.length-i,d.length);}};c.renderTableControlCnt=function(r,t,f,s,e,F,d,i,E,h){r.write("<table");var g=h?"-header":"-table";var j=t.getId()+g;if(f){j+="-fixed";r.addClass("sapUiTableCtrlFixed");}else{r.addClass("sapUiTableCtrlScroll");}if(F){j+="-fixrow";r.addClass("sapUiTableCtrlRowFixed");}else if(d){j+="-fixrow-bottom";r.addClass("sapUiTableCtrlRowFixedBottom");}else{r.addClass("sapUiTableCtrlRowScroll");}r.writeAttribute("id",j);t._getAccRenderExtension().writeAriaAttributesFor(r,t,h?"COLUMNHEADER_TABLE":"TABLE");r.addClass("sapUiTableCtrl");if(h){r.addClass("sapUiTableCHT");}r.writeClasses();r.addStyle(f?"width":"min-width",t._getColumnsWidth(s,e)+"px");r.writeStyles();r.write(">");r.write("<thead>");r.write("<tr");r.addClass("sapUiTableCtrlCol");if(i==0){r.addClass("sapUiTableCtrlFirstCol");}if(h){r.addClass("sapUiTableCHTHR");}r.writeClasses();r.write(">");var k=t.getColumns();var l=new Array(e);var m;var o;var H=false;var n=!f&&e>s;for(m=s;m<e;m++){o=k[m];var p={shouldRender:!!(o&&o.shouldRender())};if(p.shouldRender){var w=o.getWidth();if(T.isVariableWidth(w)){n=false;if(f){o._iFixWidth=o._iFixWidth||160;w=o._iFixWidth+"px";}else if(w&&w.indexOf("%")>0){H=true;}}else if(f){delete o._iFixWidth;}p.width=w;}l[m]=p;}if(T.hasRowHeader(t)&&!h){r.write("<th");if(H){r.addStyle("width","0%");}else{r.addStyle("width","0px");}r.writeStyles();if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH");if(!h){r.writeAttribute("id",t.getId()+"-colsel");}r.addClass("sapUiTableColSel");r.writeClasses();}r.write("></th>");}else{if(k.length===0){r.write("<th></th>");}}for(m=s;m<e;m++){g=h?"_hdr":"_col";o=k[m];p=l[m];if(p.shouldRender){r.write("<th");if(p.width){r.addStyle("width",p.width);r.writeStyles();}if(i==0){t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TH",{column:o});r.writeAttribute("id",t.getId()+g+m);}r.writeAttribute("data-sap-ui-headcolindex",m);r.writeAttribute("data-sap-ui-colid",o.getId());r.write(">");if(i==0&&T.getHeaderRowCount(t)==0&&!h){if(o.getMultiLabels().length>0){r.renderControl(o.getMultiLabels()[0]);}else{r.renderControl(o.getLabel());}}r.write("</th>");}}if(n){r.write("<th");if(h){r.writeAttribute("id",t.getId()+"-dummycolhdr");}t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write("></th>");}r.write("</tr>");r.write("</thead>");r.write("<tbody>");var v=t._getVisibleColumns();var q=t.getRows();var u;var x;if(h){for(u=i,x=E;u<x;u++){this.renderColumnHeaderRow(r,t,u,f,s,e,n);}}else{var y=t._getAccExtension().getAriaTextsForSelectionMode(true);var z=T.isRowSelectionAllowed(t);var A=t.getDragDropConfig().some(function(B){return B.getMetadata().isInstanceOf("sap.ui.core.dnd.IDragInfo")&&B.getSourceAggregation()==="rows";});for(u=i,x=E;u<x;u++){this.renderTableRow(r,t,q[u],u,f,s,e,false,v,n,y,z,A);}}r.write("</tbody>");r.write("</table>");};c.addTrClasses=function(r,t,o,i){return;};c.writeRowSelectorContent=function(r,t,o,i){t._getAccRenderExtension().writeAccRowSelectorText(r,t,o,i);if(T.Grouping.isGroupMode(t)){r.write("<div");r.writeAttribute("class","sapUiTableGroupShield");r.write("></div>");r.write("<div");r.writeAttribute("id",o.getId()+"-groupHeader");r.writeAttribute("class","sapUiTableGroupIcon");r.write("></div>");if(T.Grouping.showGroupMenuButton(t)){var d=I.getIconInfo("sap-icon://drop-down-list");r.write("<div class='sapUiTableGroupMenuButton'>");r.writeEscaped(d.content);r.write("</div>");}}};c.writeRowHighlightContent=function(r,t,o,i){if(!T.hasRowHighlights(t)){return;}var d=o.getAggregation("_settings");var h=d._getHighlightCSSClassName();r.write("<div");r.writeAttribute("id",o.getId()+"-highlight");r.addClass("sapUiTableRowHighlight");r.addClass(h);r.writeClasses();r.write(">");t._getAccRenderExtension().writeAccRowHighlightText(r,t,o,i);r.write("</div>");};c.renderColumnHeaderRow=function(r,t,i,f,s,e,h){r.write("<tr");r.addClass("sapUiTableColHdrTr");r.writeClasses();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"COLUMNHEADER_ROW");r.write(">");var d,n=0,l=-1;d=t.getColumns().slice(s,e).filter(function(o){return!!o&&o.shouldRender();});function g(o,k,m){var p=T.Column.getHeaderSpan(o,i),q;if(n<1){if(p>1){q=o.getIndex();p=m.slice(k+1,k+p).reduce(function(u,v){return v.getIndex()-q<p?u+1:u;},1);}o._nSpan=n=p;l=k;}else{o._nSpan=0;}n--;}d.forEach(g);function j(o,k){this.renderCol(r,t,o,i,o._nSpan,f&&(k==l));o._nSpan=undefined;}d.forEach(j.bind(this));if(!f&&h&&d.length>0){r.write('<td class="sapUiTableTDDummy"');t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write('></td>');}r.write("</tr>");};c.renderTableRow=function(r,t,o,i,f,s,e,F,v,h,m,d,g){if(!o){return;}r.write("<tr");if(o._bDummyRow){r.addStyle("opacity","0");}r.addClass("sapUiTableTr");if(f){r.writeAttribute("id",o.getId()+"-fixed");r.writeAttribute("data-sap-ui-related",o.getId());}else{r.writeElementData(o);}if(o._bHidden){r.addClass("sapUiTableRowHidden");}else{if(g&&f){r.writeAttribute("draggable",true);}if(t.isIndexSelected(o.getIndex())){r.addClass("sapUiTableRowSel");}this.addTrClasses(r,t,o,i);}if(i%2!=0&&t.getAlternateRowColors()&&!T.Grouping.isTreeMode(t)){r.addClass("sapUiTableRowAlternate");}var j=t.getRows();var k=j.length;if(k>0&&j[k-1]===o){r.addClass("sapUiTableLastRow");}else if(k>0&&j[0]===o){r.addClass("sapUiTableFirstRow");}this._addFixedRowCSSClasses(r,t,i);r.writeClasses();r.writeAttribute("data-sap-ui-rowindex",i);if(t.getRowHeight()>0){r.addStyle("height",t._getDefaultRowHeight()+"px");}r.writeStyles();t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TR",{index:i});r.write(">");var l=o.getCells();if(T.hasRowHeader(t)||l.length===0){r.write("<td");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"ROWHEADER_TD",{rowSelected:!o._bHidden&&t.isIndexSelected(o.getIndex()),index:i});r.write("></td>");}for(var n=0,p=l.length;n<p;n++){this.renderTableCell(r,t,o,l[n],n,f,s,e,v);}if(!f&&h&&l.length>0){r.write('<td class="sapUiTableTDDummy"');t._getAccRenderExtension().writeAriaAttributesFor(r,t,"PRESENTATION");r.write('></td>');}r.write("</tr>");};c.renderTableCell=function(r,t,o,d,i,f,s,e,v){var g=d.data("sap-ui-colindex");var h=t.getColumns()[g];if(h.shouldRender()&&s<=g&&e>g){r.write("<td");var j=o.getId()+"-col"+i;r.writeAttribute("id",j);r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-ui-colid",h.getId());var n=v.length;var k=n>0&&v[0]===h;var l=n>0&&v[n-1]===h;t._getAccRenderExtension().writeAriaAttributesFor(r,t,"DATACELL",{index:g,column:h,row:o,fixed:f,firstCol:k});var H=R.getTextAlign(h.getHAlign(),d&&d.getTextDirection&&d.getTextDirection());if(H){r.addStyle("text-align",H);}r.writeStyles();r.addClass("sapUiTableTd");if(k){r.addClass("sapUiTableTdFirst");}if(l){r.addClass("sapUiTableTdLast");}if(h.getGrouped()){r.addClass("sapUiTableTdGroup");}var B=t.getBinding("rows");if(B&&h.getLeadingProperty&&B.isMeasure(h.getLeadingProperty())){r.addClass("sapUiTableMeasureCell");}r.writeClasses();r.write("><div");r.addClass("sapUiTableCell");if(k&&T.Grouping.isTreeMode(t)){r.addClass("sapUiTableCellFlex");}r.writeClasses();if(t.getRowHeight()&&t.getVisibleRowCountMode()==V.Auto){r.addStyle("max-height",t.getRowHeight()+"px");}r.writeStyles();r.write(">");this.renderTableCellControl(r,t,d,k);r.write("</div></td>");}};c.renderTableCellControl=function(r,t,o,i){if(i&&T.Grouping.isTreeMode(t)&&!t._bFlatMode){var d=o.getParent();r.write("<span class='sapUiTableTreeIcon' tabindex='-1' id='"+d.getId()+"-treeicon'");t._getAccRenderExtension().writeAriaAttributesFor(r,t,"TREEICON",{row:d});r.write("></span>");}r.renderControl(o);};c.renderVSb=function(r,t,m){m=Object.assign({cssClass:"sapUiTableVSb",tabIndex:true,hidden:true},m);m.id=t.getId()+"-vsb";var s=t._getScrollExtension();r.write("<div");r.addClass(m.cssClass);if(m.hidden){r.addClass("sapUiTableHidden");}r.writeClasses();r.writeAttribute("id",m.id);if(m.tabIndex){r.writeAttribute("tabindex","-1");}r.addStyle("max-height",s.getVerticalScrollbarHeight()+"px");if(t.getFixedRowCount()>0){t._iVsbTop=(t.getFixedRowCount()*t._getDefaultRowHeight())-1;r.addStyle("top",t._iVsbTop+'px');}r.writeStyles();r.write(">");r.write("<div");r.writeAttribute("id",m.id+"-content");r.addClass("sapUiTableVSbContent");r.writeClasses();r.addStyle("height",s.getVerticalScrollHeight()+"px");r.writeStyles();r.write(">");r.write("</div>");r.write("</div>");};c.renderVSbExternal=function(r,t){if(b.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){this.renderVSb(r,t,{cssClass:"sapUiTableVSbExternal",tabIndex:false});}else{L.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal");}};c.renderVSbBackground=function(r,t){r.write("<div");r.addClass("sapUiTableVSbBg");r.writeAttribute("id",t.getId()+"-vsb-bg");r.writeClasses();r.write("></div>");};c.renderHSb=function(r,t,m){m=Object.assign({id:t.getId()+"-hsb",cssClass:"sapUiTableHSb",tabIndex:true,hidden:true,scrollWidth:0},m);r.write("<div");r.addClass(m.cssClass);if(m.hidden){r.addClass("sapUiTableHidden");}r.writeClasses();r.writeAttribute("id",m.id);if(m.tabIndex){r.writeAttribute("tabindex","-1");}r.write(">");r.write("<div");r.writeAttribute("id",m.id+"-content");r.addClass("sapUiTableHSbContent");r.writeClasses();if(m.scrollWidth>0){r.addStyle("width",m.scrollWidth+"px");}r.writeStyles();r.write(">");r.write("</div>");r.write("</div>");};c.renderHSbExternal=function(r,t,i,s){if(b.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){this.renderHSb(r,t,{id:i,cssClass:"sapUiTableHSbExternal",tabIndex:false,hidden:false,scrollWidth:s});}else{L.error("This method can only be used with synchronization enabled.",t,"TableRenderer.renderVSbExternal");}};c.renderHSbBackground=function(r,t){r.write("<div");r.addClass("sapUiTableHSbBg");r.writeAttribute("id",t.getId()+"-hsb-bg");r.writeClasses();r.write("></div>");};c.renderTabElement=function(r,s){r.write("<div");if(s){r.addClass(s);r.writeClasses();}r.writeAttribute("tabindex","0");r.write("></div>");};return c;},true);
