/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/TimesRow','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library','sap/ui/core/format/DateFormat','sap/ui/Device','sap/ui/core/Locale','sap/ui/core/library',"./CalendarTimeIntervalRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/ui/core/Popup","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,L,a,H,T,D,M,Y,U,l,b,c,d,e,f,g,h,P,i,q){"use strict";var j=e.CalendarType;var k=C.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.Month",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"},calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});k.prototype.init=function(){this._iMode=0;this._oYearFormat=b.getDateInstance({format:"y"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(new Date(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new U(new Date(Date.UTC(9999,11,31,23,59,59)));this._initializeHeader();this._initializeTimesRow();this._initilizeMonthPicker();this._initilizeYearPicker();this.setPickerPopup(false);this._iItemsHead=15;};k.prototype._initializeHeader=function(){var d1=new H(this.getId()+"--Head");d1.attachEvent("pressPrevious",this._handlePrevious,this);d1.attachEvent("pressNext",this._handleNext,this);this.setAggregation("header",d1);};k.prototype._initializeTimesRow=function(){var d1=new T(this.getId()+"--TimesRow");d1.attachEvent("focus",K,this);d1.attachEvent("select",J,this);d1._bNoThemeChange=true;this.setAggregation("timesRow",d1);};k.prototype._initilizeMonthPicker=function(){this.setAggregation("monthPicker",this._createMonthPicker());};k.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};k.prototype._createDatesRow=function(){var d1=new D(this.getId()+"--DatesRow",{days:18,selectedDates:[new sap.ui.unified.DateRange(this.getId()+"--Range")]});d1.attachEvent("focus",Q,this);d1.attachEvent("select",O,this);d1._bNoThemeChange=true;d1.getIntervalSelection=function(){return this.getProperty("intervalSelection");};d1.getSingleSelection=function(){return this.getProperty("singleSelection");};d1.getSelectedDates=function(){return this.getAggregation("selectedDates",[]);};d1.getSpecialDates=function(){return this.getAggregation("specialDates",[]);};d1.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[]);};return d1;};k.prototype._createMonthPicker=function(){var d1=new M(this.getId()+"--MP",{columns:0,months:6});d1.attachEvent("select",R,this);d1._bNoThemeChange=true;d1.attachEvent("pageChange",b1,this);return d1;};k.prototype._createYearPicker=function(){var d1=new Y(this.getId()+"--YP",{columns:0,years:6});d1.attachEvent("select",S,this);d1.attachEvent("pageChange",c1,this);d1._oMinDate.setYear(this._oMinDate.getUTCFullYear());d1._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());return d1;};k.prototype.exit=function(){if(this._sInvalidateContent){clearTimeout(this._sInvalidateContent);}};k.prototype.onBeforeRendering=function(){var d1=this.getAggregation("timesRow");var e1=this._getFocusedDate();x.call(this);d1.displayDate(a._createLocalDate(e1,true));};k.prototype._setAriaRole=function(d1){var e1=this.getAggregation("timesRow");e1._setAriaRole(d1);e1.invalidate();return this;};k.prototype._getCalendarPicker=function(){var d1=this.getAggregation("calendarPicker");if(!d1){d1=new sap.ui.unified.Calendar(this.getId()+"--Cal",{});d1.setPopupMode(true);d1.attachEvent("select",N,this);d1.attachEvent("cancel",function(e1){this._oPopup.close();var f1=this.getAggregation("header").getDomRef("B1");if(f1){f1.focus();}},this);this.setAggregation("calendarPicker",d1);}return d1;};k.prototype.setStartDate=function(d1){a._checkJSDateObject(d1);if(h(this.getStartDate(),d1)){return this;}var e1=d1.getFullYear();a._checkYearInValidRange(e1);var f1=this.getMinDate();if(f1&&d1.getTime()<f1.getTime()){i.warning("startDate < minDate -> minDate as startDate set",this);d1=new Date(f1);}var g1=this.getMaxDate();if(g1&&d1.getTime()>g1.getTime()){i.warning("startDate > maxDate -> maxDate as startDate set",this);d1=new Date(g1);}this.setProperty("startDate",d1,true);var h1=this.getAggregation("timesRow");h1.setStartDate(d1);this._oUTCStartDate=new U(h1._getStartDate().getTime());x.call(this);var i1=a._createLocalDate(this._getFocusedDate(),true);if(!h1.checkDateFocusable(i1)){this._setFocusedDate(this._oUTCStartDate);h1.displayDate(d1);}return this;};k.prototype.invalidate=function(d1){if(!this._bDateRangeChanged&&(!d1||!(d1 instanceof sap.ui.unified.DateRange))){if(!d1||(!(d1 instanceof D||d1 instanceof M||d1 instanceof Y||d1 instanceof H))){C.prototype.invalidate.apply(this,arguments);}}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=setTimeout(V.bind(this),0);}};k.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var d1=this.removeAllAggregation("selectedDates");return d1;};k.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var d1=this.destroyAggregation("selectedDates");return d1;};k.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var d1=this.removeAllAggregation("specialDates");return d1;};k.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var d1=this.destroyAggregation("specialDates");return d1;};k.prototype.setIntervalMinutes=function(d1){if(d1>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%d1>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",d1,false);var e1=this.getAggregation("timesRow");var f1=a._createLocalDate(this._getFocusedDate(),true);if(!e1.checkDateFocusable(f1)){var g1=m.call(this);this._setFocusedDate(g1);e1.setDate(a._createLocalDate(g1,true));}return this;};k.prototype.setLocale=function(d1){if(this._sLocale!=d1){this._sLocale=d1;this._oLocaleData=undefined;this.invalidate();}return this;};k.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};k.prototype._getFocusedDate=function(){if(!this._oFocusedDate){o.call(this);}return this._oFocusedDate;};k.prototype._setFocusedDate=function(d1){if(!(d1 instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(d1.getTime());};k.prototype.focusDate=function(d1){var e1=false;var f1=this.getAggregation("timesRow");if(!f1.checkDateFocusable(d1)){var g1=a._createUniversalUTCDate(d1,undefined,true);W.call(this,g1);e1=true;}E.call(this,d1,false);if(e1){this.fireStartDateChange();}return this;};k.prototype.displayDate=function(d1){E.call(this,d1,true);return this;};k.prototype.setItems=function(d1){this.setProperty("items",d1,true);d1=this._getItems();var e1=this.getAggregation("timesRow");e1.setItems(d1);var f1=a._createLocalDate(this._getFocusedDate(),true);if(!e1.checkDateFocusable(f1)){var g1=m.call(this);this._setFocusedDate(g1);e1.setDate(a._createLocalDate(g1,true));}if(!this.getPickerPopup()){var h1=this.getAggregation("datesRow");var i1=Math.floor(d1*1.5);if(i1>31){i1=31;}h1.setDays(i1);var j1=this.getAggregation("monthPicker");var k1=Math.floor(d1/2);if(k1>12){k1=12;}j1.setMonths(k1);var l1=this.getAggregation("yearPicker");var m1=Math.floor(d1/2);if(m1>20){m1=20;}l1.setYears(m1);}x.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};k.prototype._getItems=function(){var d1=this.getItems();if(c.system.phone&&d1>6){return 6;}else{return d1;}};k.prototype._getLocaleData=function(){if(!this._oLocaleData){var d1=this.getLocale();var e1=new d(d1);this._oLocaleData=L.getInstance(e1);}return this._oLocaleData;};k.prototype.setPickerPopup=function(d1){var e1=this.getAggregation("header"),f1,g1,h1;this.setProperty("pickerPopup",d1,true);if(f1){f1.destroy();}if(d1){e1.setVisibleButton0(false);e1.setVisibleButton1(true);e1.setVisibleButton2(false);e1.detachEvent("pressButton1",G,this);e1.attachEvent("pressButton1",G,this);if(this.getAggregation("datesRow")){this.getAggregation("datesRow").destroy();}if(this.getAggregation("monthPicker")){this.getAggregation("monthPicker").destroy();}if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}}else{e1.setVisibleButton0(true);e1.setVisibleButton1(true);e1.setVisibleButton2(true);e1.detachEvent("pressButton0",F,this);e1.attachEvent("pressButton0",F,this);e1.detachEvent("pressButton1",G,this);e1.attachEvent("pressButton1",G,this);e1.detachEvent("pressButton2",I,this);e1.attachEvent("pressButton2",I,this);if(!this.getAggregation("datesRow")){this.setAggregation("datesRow",this._createDatesRow());}if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}if(!this.getAggregation("monthPicker")){this.setAggregation("monthPicker",this._createMonthPicker());}g1=this.getAggregation("monthPicker");h1=this.getAggregation("yearPicker");g1.setColumns(0);g1.setMonths(6);h1.setColumns(0);h1.setYears(6);}return this;};k.prototype.setMinDate=function(d1){var e1,f1,g1,h1;if(h(d1,this.getMinDate())){return this;}if(!d1){a._updateUTCDate(this._oMinDate.getJSDate(),1,0,1,0,0,0,0);}else{a._checkJSDateObject(d1);this._oMinDate=a._createUniversalUTCDate(d1,undefined,true);e1=this.getAggregation("timesRow");this._oMinDate=e1._getIntervalStart(this._oMinDate);f1=this._oMinDate.getUTCFullYear();a._checkYearInValidRange(f1);if(this._oMaxDate.getTime()<this._oMinDate.getTime()){i.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=a._createUniversalUTCDate(d1,undefined,true);a._updateUTCDate(this._oMaxDate,null,this._oMaxDate.getUTCMonth()+1,0,23,59,59,0);this.setProperty("maxDate",a._createLocalDate(this._oMaxDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){i.warning("focused date < minDate -> minDate focused",this);this.focusDate(d1);}}if(this._oUTCStartDate&&this._oUTCStartDate.getTime()<this._oMinDate.getTime()){i.warning("start date < minDate -> minDate set as start date",this);_.call(this,new U(this._oMinDate.getTime()),true,true);}}this.setProperty("minDate",d1,false);if(this.getPickerPopup()){h1=this._getCalendarPicker();h1.setMinDate(d1);}else{g1=this.getAggregation("yearPicker");g1._oMinDate.setYear(this._oMinDate.getUTCFullYear());}return this;};k.prototype.setMaxDate=function(d1){var e1,f1,g1,h1,i1,j1;if(h(d1,this.getMaxDate())){return this;}if(!d1){a._updateUTCDate(this._oMaxDate.getJSDate(),9999,11,31,23,59,59,0);}else{a._checkJSDateObject(d1);this._oMaxDate=a._createUniversalUTCDate(d1,undefined,true);e1=this.getAggregation("timesRow");this._oMaxDate=e1._getIntervalStart(this._oMaxDate);this._oMaxDate.setUTCMinutes(this._oMaxDate.getUTCMinutes()+this.getIntervalMinutes());this._oMaxDate.setUTCMilliseconds(-1);f1=this._oMaxDate.getUTCFullYear();a._checkYearInValidRange(f1);if(this._oMinDate.getTime()>this._oMaxDate.getTime()){i.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=a._createUniversalUTCDate(d1,undefined,true);a._updateUTCDate(this._oMinDate,null,null,1,0,0,0,0);this.setProperty("minDate",a._createLocalDate(this._oMinDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){i.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(d1);}}if(this._oUTCStartDate){g1=new U(this._oUTCStartDate.getTime());g1.setUTCMinutes(g1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));if(g1.getTime()>this._oMaxDate.getTime()){h1=new U(this._oMaxDate.getTime());h1.setUTCMinutes(h1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(h1.getTime()>=this._oMinDate.getTime()){i.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,h1,true,true);}}}}this.setProperty("maxDate",d1,false);if(this.getPickerPopup()){j1=this._getCalendarPicker();j1.setMaxDate(d1);}else{i1=this.getAggregation("yearPicker");i1._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());}return this;};k.prototype.onclick=function(d1){if(d1.isMarked("delayedMouseEvent")){return;}if(d1.target.id==this.getId()+"-cancel"){this.onsapescape(d1);}};k.prototype.onmousedown=function(d1){d1.preventDefault();d1.setMark("cancelAutoClose");};k.prototype.onsapescape=function(d1){if(this.getPickerPopup()){p.call(this);this.fireCancel();}else{switch(this._iMode){case 0:this.fireCancel();break;case 1:s.call(this);break;case 2:u.call(this);break;case 3:w.call(this);break;}}};k.prototype.onsaptabnext=function(d1){var e1=this.getAggregation("header"),f1,g1,h1;if(g(this.getDomRef("content"),d1.target)){if(this.getPickerPopup()&&e1.getDomRef("B1")){e1.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&e1.getDomRef("B0")){e1.getDomRef("B0").focus();}if(!this._bPoupupMode){h1=this.getAggregation("timesRow");q(h1._oItemNavigation.getItemDomRefs()[h1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){f1=this.getAggregation("monthPicker");g1=this.getAggregation("yearPicker");if(f1.getDomRef()){q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(g1.getDomRef()){q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}d1.preventDefault();}else if(d1.target.id==e1.getId()+"-B0"){if(e1.getDomRef("B1")){e1.getDomRef("B1").focus();}d1.preventDefault();}else if(!this.getPickerPopup()&&(d1.target.id==e1.getId()+"-B1")){if(e1.getDomRef("B2")){e1.getDomRef("B2").focus();}d1.preventDefault();}};k.prototype.onsaptabprevious=function(d1){var e1=this.getAggregation("header"),f1,g1,h1;if(g(this.getDomRef("content"),d1.target)){if(this._bPoupupMode){if(e1.getDomRef("B2")){e1.getDomRef("B2").focus();}d1.preventDefault();}}else if(d1.target.id==e1.getId()+"-B0"){h1=this.getAggregation("timesRow");switch(this._iMode){case 0:h1._oItemNavigation.focusItem(h1._oItemNavigation.getFocusedIndex());break;case 2:if(!this.getPickerPopup()){f1=this.getAggregation("monthPicker");f1._oItemNavigation.focusItem(f1._oItemNavigation.getFocusedIndex());}break;case 3:if(!this.getPickerPopup()){g1=this.getAggregation("yearPicker");g1._oItemNavigation.focusItem(g1._oItemNavigation.getFocusedIndex());}break;}d1.preventDefault();}else if(d1.target.id==e1.getId()+"-B2"){if(e1.getDomRef("B1")){e1.getDomRef("B1").focus();}d1.preventDefault();}else if(d1.target.id==e1.getId()+"-B1"){if(!this.getPickerPopup()){if(e1.getDomRef("B0")){e1.getDomRef("B0").focus();}}else{h1=this.getAggregation("timesRow");h1._oItemNavigation.focusItem(h1._oItemNavigation.getFocusedIndex());}d1.preventDefault();}};k.prototype.onfocusin=function(d1){if(d1.target.id==this.getId()+"-end"){var e1=this.getAggregation("header"),f1,g1,h1;if(this.getPickerPopup()&&e1.getDomRef("B1")){e1.getDomRef("B1").focus();}else if(!this.getPickerPopup()&&e1.getDomRef("B2")){e1.getDomRef("B2").focus();}if(!this._bPoupupMode){f1=this.getAggregation("timesRow");q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(!this.getPickerPopup()){g1=this.getAggregation("monthPicker");h1=this.getAggregation("yearPicker");if(g1.getDomRef()){q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(h1.getDomRef()){q(h1._oItemNavigation.getItemDomRefs()[h1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};k.prototype.onsapfocusleave=function(d1){if(!d1.relatedControlId||!g(this.getDomRef(),sap.ui.getCore().byId(d1.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var e1,f1,g1;switch(this._iMode){case 0:e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:if(!this.getPickerPopup()){f1=this.getAggregation("monthPicker");q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 3:if(!this.getPickerPopup()){g1=this.getAggregation("yearPicker");q(g1._oItemNavigation.getItemDomRefs()[g1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};k.prototype._handlePrevious=function(d1){var e1=this._getFocusedDate(),f1,g1,h1,i1,j1,k1,l1,m1;switch(this._iMode){case 0:f1=this._getItems();g1=new U(m.call(this).getTime());h1=this.getIntervalMinutes();g1.setUTCMinutes(g1.getUTCMinutes()-f1*h1);e1.setUTCMinutes(e1.getUTCMinutes()-f1*h1);this._setFocusedDate(e1);_.call(this,g1,true);break;case 1:if(!this.getPickerPopup()){i1=this.getAggregation("datesRow");j1=a._createUniversalUTCDate(i1.getDate());k1=i1.getDays();if(j1.getUTCDate()<=k1){j1.setUTCDate(1);}else{j1.setUTCDate(j1.getUTCDate()-k1);}X.call(this,j1);}break;case 2:if(!this.getPickerPopup()){l1=this.getAggregation("monthPicker");if(l1.getMonths()<12){l1.previousPage();y.call(this);}else{e1.setUTCFullYear(e1.getUTCFullYear()-1);W.call(this,e1);this._setFocusedDate(e1);x.call(this);a1.call(this,e1.getUTCFullYear(),l1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){m1=this.getAggregation("yearPicker");m1.previousPage();z.call(this);}break;}};k.prototype._handleNext=function(d1){var e1=this._getFocusedDate();switch(this._iMode){case 0:var f1=this._getItems();var g1=new U(m.call(this).getTime());var h1=this.getIntervalMinutes();g1.setUTCMinutes(g1.getUTCMinutes()+f1*h1);e1.setUTCMinutes(e1.getUTCMinutes()+f1*h1);this._setFocusedDate(e1);_.call(this,g1,true);break;case 1:if(!this.getPickerPopup()){var i1=this.getAggregation("datesRow");var j1=a._createUniversalUTCDate(i1.getDate());var k1=new U(j1.getTime());k1.setUTCDate(1);k1.setUTCMonth(k1.getUTCMonth()+1);k1.setUTCDate(0);var l1=i1.getDays();if(j1.getUTCDate()+l1>k1.getUTCDate()){j1.setUTCDate(k1.getUTCDate());}else{j1.setUTCDate(j1.getUTCDate()+l1);}X.call(this,j1);}break;case 2:if(!this.getPickerPopup()){var m1=this.getAggregation("monthPicker");if(m1.getMonths()<12){m1.nextPage();y.call(this);}else{e1.setUTCFullYear(e1.getUTCFullYear()+1);W.call(this,e1);this._setFocusedDate(e1);x.call(this);a1.call(this,e1.getUTCFullYear(),m1);this.fireStartDateChange();}}break;case 3:if(!this.getPickerPopup()){var n1=this.getAggregation("yearPicker");n1.nextPage();z.call(this);}break;}};k.prototype._getShowItemHeader=function(){var d1=this.getItems();if(d1>this._iItemsHead){return true;}else{return false;}};function _(d1,e1,f1){var g1=new U(this._oMaxDate.getTime());g1.setUTCMinutes(g1.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(g1.getTime()<this._oMinDate.getTime()){g1=new U(this._oMinDate.getTime());g1.setUTCMinutes(g1.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));}if(d1.getTime()<this._oMinDate.getTime()){d1=new U(this._oMinDate.getTime());}else if(d1.getTime()>g1.getTime()){d1=g1;}var h1=this.getAggregation("timesRow");var i1=a._createLocalDate(d1,true);h1.setStartDate(i1);this._oUTCStartDate=new U(h1._getStartDate().getTime());i1=a._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",i1,true);x.call(this);if(e1){var j1=a._createLocalDate(this._getFocusedDate(),true);if(!h1.checkDateFocusable(j1)){this._setFocusedDate(d1);h1.setDate(i1);}else{h1.setDate(j1);}}if(!f1){this.fireStartDateChange();}}function m(){if(!this._oUTCStartDate){var d1=this.getAggregation("timesRow");d1.setStartDate(a._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new U(d1._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate);}return this._oUTCStartDate;}function n(d1){var e1=this._getFocusedDate();var f1=this.getAggregation("timesRow");if(!d1){f1.setDate(a._createLocalDate(e1,true));}else{f1.displayDate(a._createLocalDate(e1,true));}x.call(this);}function o(){var d1=this.getSelectedDates();if(d1&&d1[0]&&d1[0].getStartDate()){this._oFocusedDate=a._createUniversalUTCDate(d1[0].getStartDate(),undefined,true);}else{var e1=new Date();this._oFocusedDate=a._createUniversalUTCDate(e1,undefined,true);}if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){this._oFocusedDate=new U(this._oMinDate.getTime());}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){this._oFocusedDate=new U(this._oMaxDate.getTime());}}k.prototype._showCalendarPicker=function(){var d1=a._createLocalDate(this._getFocusedDate(),true);var e1=this._getCalendarPicker();var f1=new sap.ui.unified.DateRange({startDate:d1});e1.displayDate(d1,false);e1.removeAllSelectedDates();e1.addSelectedDate(f1);e1.setMinDate(this.getMinDate());e1.setMaxDate(this.getMaxDate());Z.call(this,e1);this._showOverlay();};k.prototype._showOverlay=function(){this.$("contentOver").css("display","");};k.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};function p(d1){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!d1){n.call(this);var e1=this.getAggregation("timesRow");q(e1._oItemNavigation.getItemDomRefs()[e1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function r(){if(this._iMode==3){w.call(this,true);}else if(this._iMode==2){u.call(this,true);}var d1=this._getFocusedDate();var e1=this._getItems();var f1=this.getAggregation("datesRow");var g1=f1.getSelectedDates()[0];g1.setStartDate(a._createLocalDate(d1,true));var h1=new U(d1.getTime());h1.setUTCDate(1);h1.setUTCMonth(h1.getUTCMonth()+1);h1.setUTCDate(0);var i1=h1.getUTCDate();var j1=Math.floor(e1*1.5);if(j1>i1){j1=i1;}f1.setDays(j1);if(f1.getDomRef()){f1.$().css("display","");}else{var k1=sap.ui.getCore().createRenderManager();var l1=this.$("content");k1.renderControl(f1);k1.flush(l1[0],false,true);k1.destroy();}this._showOverlay();X.call(this,d1);if(this._iMode==0){var m1=this.getAggregation("timesRow");q(m1._oItemNavigation.getItemDomRefs()[m1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=1;}function s(d1){this._iMode=0;var e1=this.getAggregation("datesRow");e1.$().css("display","none");this._hideOverlay();if(!d1){n.call(this);var f1=this.getAggregation("timesRow");q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function t(){if(this._iMode==1){s.call(this,true);}else if(this._iMode==3){w.call(this,true);}var d1=this._getFocusedDate();var e1=this.getAggregation("monthPicker");if(e1.getDomRef()){e1.$().css("display","");}else{var f1=sap.ui.getCore().createRenderManager();var g1=this.$("content");f1.renderControl(e1);f1.flush(g1[0],false,true);f1.destroy();}this._showOverlay();e1.setMonth(d1.getUTCMonth());a1.call(this,d1.getUTCFullYear(),e1);if(this._iMode==0){var h1=this.getAggregation("timesRow");q(h1._oItemNavigation.getItemDomRefs()[h1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=2;y.call(this);}function u(d1){this._iMode=0;var e1=this.getAggregation("monthPicker");e1.$().css("display","none");this._hideOverlay();if(!d1){n.call(this);var f1=this.getAggregation("timesRow");q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function v(){if(this._iMode==1){s.call(this,true);}else if(this._iMode==2){u.call(this,true);}var d1=this._getFocusedDate();var e1=this.getAggregation("yearPicker");if(e1.getDomRef()){e1.$().css("display","");}else{var f1=sap.ui.getCore().createRenderManager();var g1=this.$("content");f1.renderControl(e1);f1.flush(g1[0],false,true);f1.destroy();}this._showOverlay();e1.setDate(d1.getJSDate());if(this._iMode==0){var h1=this.getAggregation("timesRow");q(h1._oItemNavigation.getItemDomRefs()[h1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}z.call(this);this._iMode=3;}function w(d1){this._iMode=0;var e1=this.getAggregation("yearPicker");e1.$().css("display","none");this._hideOverlay();if(!d1){n.call(this);var f1=this.getAggregation("timesRow");q(f1._oItemNavigation.getItemDomRefs()[f1._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function x(){A.call(this);y.call(this,true);}function y(d1){var e1=new U(m.call(this).getTime());var f1=this._getItems();var g1=e1.getJSDate().getUTCFullYear();var h1=this._oMaxDate.getJSDate().getUTCFullYear();var i1=this._oMinDate.getJSDate().getUTCFullYear();var j1=e1.getJSDate().getUTCMonth();var k1=this._oMaxDate.getJSDate().getUTCMonth();var l1=this._oMinDate.getJSDate().getUTCMonth();var m1=e1.getJSDate().getUTCDate();var n1=this._oMaxDate.getJSDate().getUTCDate();var o1=this._oMinDate.getJSDate().getUTCDate();var p1=e1.getJSDate().getUTCHours();var q1=this._oMaxDate.getJSDate().getUTCHours();var r1=this._oMinDate.getJSDate().getUTCHours();var s1=e1.getJSDate().getUTCMinutes();var t1=this._oMaxDate.getJSDate().getUTCMinutes();var u1=this._oMinDate.getJSDate().getUTCMinutes();var v1=this.getAggregation("header");if(this._iMode==2&&!d1){var w1=this.getAggregation("monthPicker");var x1=w1.getMonths();var y1=w1.getStartMonth();var z1=y1+x1-1;if(y1==0||(g1==i1&&y1<=l1)){v1.setEnabledPrevious(false);}else{v1.setEnabledPrevious(true);}if(z1>10||(g1==h1&&z1>=k1)){v1.setEnabledNext(false);}else{v1.setEnabledNext(true);}return;}if((g1<i1||(g1==i1&&(!d1||(j1<l1||(j1==l1&&(m1<o1||(m1==o1&&(p1<r1||(p1==r1&&s1<=u1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){v1.setEnabledPrevious(false);}else{v1.setEnabledPrevious(true);}e1.setUTCMinutes(e1.getUTCMinutes()+(f1)*this.getIntervalMinutes()-1);g1=e1.getJSDate().getUTCFullYear();j1=e1.getJSDate().getUTCMonth();m1=e1.getJSDate().getUTCDate();p1=e1.getJSDate().getUTCHours();s1=e1.getJSDate().getUTCMinutes();if((g1>h1||(g1==h1&&(!d1||(j1>k1||(j1==k1&&(m1>n1||(m1==n1&&(p1>q1||(p1==q1&&s1>=t1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){v1.setEnabledNext(false);}else{v1.setEnabledNext(true);}}function z(){var d1=this.getAggregation("yearPicker");var e1=d1.getYears();var f1=a._createUniversalUTCDate(d1.getFirstRenderedDate());f1.setUTCFullYear(f1.getUTCFullYear()+Math.floor(e1/2));var g1=this.getAggregation("header");var h1=new U(this._oMaxDate);h1.setUTCFullYear(h1.getUTCFullYear()-Math.ceil(e1/2));h1.setUTCMonth(11,31);var i1=new U(this._oMinDate);i1.setUTCFullYear(i1.getUTCFullYear()+Math.floor(e1/2)+1);i1.setUTCMonth(0,1);if(f1.getTime()>h1.getTime()){g1.setEnabledNext(false);}else{g1.setEnabledNext(true);}if(f1.getTime()<i1.getTime()){g1.setEnabledPrevious(false);}else{g1.setEnabledPrevious(true);}}function A(){var d1=this.getAggregation("header");var e1;var f1=m.call(this);var g1;var h1=this._getLocaleData();var i1=[];var j1=[];var k1;var l1=false;var m1;var n1=j.Gregorian;var o1=false;if(h1.oLocale.sLanguage.toLowerCase()==="ja"||h1.oLocale.sLanguage.toLowerCase()==="zh"){m1=b.getDateInstance({format:"d"}).format(f1,true);}else{m1=(f1.getUTCDate()).toString();}if(this._bLongMonth||!this._bNamesLengthChecked){i1=h1.getMonthsStandAlone("wide");}else{l1=true;i1=h1.getMonthsStandAlone("abbreviated");j1=h1.getMonthsStandAlone("wide");}var p1=f1.getUTCMonth();e1=i1[p1];if(l1){k1=j1[i1[p1]];}if(!this.getPickerPopup()){d1.setTextButton0(m1);d1.setTextButton1(e1);d1.setTextButton2(this._oYearFormat.format(f1,true));}else{g1=b.getInstance({style:"long",strictParsing:true,relative:o1,calendarType:n1},h1.oLocale);k1=m1=g1.format(a._createLocalDate(f1,true));d1.setTextButton1(m1);}if(l1){d1.setAriaLabelButton1(k1);}}function B(d1,e1){var f1;var g1=false;if(d1.getTime()<this._oMinDate.getTime()){f1=this._oMinDate;g1=true;}else if(d1.getTime()>this._oMaxDate.getTime()){f1=this._oMaxDate;g1=true;}else{f1=d1;}this._setFocusedDate(f1);if(g1||e1){W.call(this,f1);n.call(this,false);this.fireStartDateChange();}}function E(d1,e1){if(d1&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=d1.getTime())){a._checkJSDateObject(d1);d1=a._createUniversalUTCDate(d1,undefined,true);var f1=d1.getUTCFullYear();a._checkYearInValidRange(f1);if(d1.getTime()<this._oMinDate.getTime()||d1.getTime()>this._oMaxDate.getTime()){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(d1);if(this.getDomRef()&&this._iMode==0){n.call(this,e1);}}}function F(d1){if(this._iMode!=1){r.call(this);}else{s.call(this);}}function G(d1){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=2){t.call(this);}else{u.call(this);}}}function I(d1){if(this._iMode!=3){v.call(this);}else{w.call(this);}}function J(d1){this.fireSelect();}function K(d1){var e1=a._createUniversalUTCDate(d1.getParameter("date"),undefined,true);var f1=d1.getParameter("notVisible");B.call(this,e1,f1);}function N(d1){var e1=d1.getSource(),f1=e1.getSelectedDates()[0].getStartDate();var g1=new U(this._getFocusedDate().getTime());var h1=a._createUniversalUTCDate(f1);g1.setUTCFullYear(h1.getUTCFullYear());g1.setUTCMonth(h1.getUTCMonth(),h1.getUTCDate());B.call(this,g1,true);p.call(this);}function O(d1){var e1=new U(this._getFocusedDate().getTime());var f1=d1.oSource;var g1=f1.getSelectedDates()[0];var h1=a._createUniversalUTCDate(g1.getStartDate());if(!this.getPickerPopup()||h1.getUTCMonth()==e1.getUTCMonth()){e1.setUTCDate(h1.getUTCDate());e1.setUTCMonth(h1.getUTCMonth());e1.setUTCFullYear(h1.getUTCFullYear());B.call(this,e1,true);s.call(this);}}function Q(d1){var e1=new U(this._getFocusedDate().getTime());var f1=a._createUniversalUTCDate(d1.getParameter("date"),undefined,true);var g1=d1.getParameter("otherMonth");if(g1&&f1.getUTCMonth()==e1.getUTCMonth()&&f1.getUTCFullYear()==e1.getUTCFullYear()){X.call(this,f1);}}function R(d1){var e1=new U(this._getFocusedDate().getTime());var f1=this.getAggregation("monthPicker");var g1=f1.getMonth();e1.setUTCMonth(g1);if(g1!=e1.getUTCMonth()){e1.setUTCDate(0);}B.call(this,e1,true);u.call(this);}function S(d1){var e1=new U(this._getFocusedDate().getTime());var f1=this.getAggregation("yearPicker");var g1=a._createUniversalUTCDate(f1.getDate());var h1=e1.getUTCMonth();g1.setUTCMonth(e1.getUTCMonth(),e1.getUTCDate());g1.setUTCHours(e1.getUTCHours());g1.setUTCMinutes(e1.getUTCMinutes());e1=g1;if(h1!=e1.getUTCMonth()){e1.setUTCDate(0);}B.call(this,e1,true);w.call(this);}function V(){this._sInvalidateContent=undefined;var d1=this.getAggregation("timesRow");d1._bDateRangeChanged=true;d1._bInvalidateSync=true;d1.invalidate();d1._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}function W(d1){var e1=this.getAggregation("timesRow");var f1=m.call(this);var g1=e1._oItemNavigation.getFocusedIndex();f1=new U(d1.getTime());f1.setUTCMinutes(f1.getUTCMinutes()-g1*this.getIntervalMinutes());_.call(this,f1,false,true);}function X(d1){var e1=this.getAggregation("datesRow");var f1=this.getAggregation("header");if(!this.getPickerPopup()){var g1=new U(d1.getTime());g1.setUTCDate(1);g1.setUTCMonth(g1.getUTCMonth()+1);g1.setUTCDate(0);var h1=e1.getDays();var i1=new U(d1.getTime());i1.setUTCDate(1+(Math.ceil(d1.getUTCDate()/h1)-1)*h1);if(g1.getUTCDate()-i1.getUTCDate()<h1){i1.setUTCDate(g1.getUTCDate()-h1+1);}e1.setStartDate(a._createLocalDate(i1,true));var j1=i1.getJSDate().getUTCFullYear();var k1=this._oMaxDate.getJSDate().getUTCFullYear();var l1=this._oMinDate.getJSDate().getUTCFullYear();var m1=i1.getJSDate().getUTCMonth();var n1=this._oMaxDate.getJSDate().getUTCMonth();var o1=this._oMinDate.getJSDate().getUTCMonth();var p1=i1.getJSDate().getUTCDate();var q1=this._oMaxDate.getJSDate().getUTCDate();var r1=this._oMinDate.getJSDate().getUTCDate();if(p1<=1||(j1==l1&&m1==o1&&p1<=r1)){f1.setEnabledPrevious(false);}else{f1.setEnabledPrevious(true);}if((p1+h1)>=g1.getUTCDate()||(j1==k1&&m1==n1&&p1>=q1)){f1.setEnabledNext(false);}else{f1.setEnabledNext(true);}}else{f1.setEnabledPrevious(false);f1.setEnabledNext(false);}e1.setDate(a._createLocalDate(d1,true));}function Z(d1){if(!this._oPopup){this._oPopup=new P();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed($,this);this._oPopup.onsapescape=function(g1){this._oCalendar.onsapescape(g1);};}this._oPopup.setContent(d1);var e1=this.getAggregation("header");var f1=P.Dock;this._oPopup.open(0,f1.CenterTop,f1.CenterTop,e1,null,"flipfit",true);}function $(d1){p.call(this);}function a1(d1,e1){var f1=0;var g1=11;if(d1==this._oMinDate.getUTCFullYear()){f1=this._oMinDate.getUTCMonth();}if(d1==this._oMaxDate.getUTCFullYear()){g1=this._oMaxDate.getUTCMonth();}e1.setMinMax(f1,g1);}function b1(d1){y.call(this);}function c1(d1){z.call(this);}return k;});
