/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/CalendarLegend','sap/ui/unified/CalendarLegendRenderer','sap/ui/core/library','sap/ui/unified/library',"sap/base/Log"],function(C,a,b,c,d,l,L){"use strict";var e=l.CalendarDayType;var f=d.CalendarType;var M={};M.render=function(r,m){var D=this.getStartDate(m);var t=m.getTooltip_AsString();var g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var i=m.getId();var A={value:i+"-Descr",append:true};var w=m.getWidth();r.write("<div");r.writeControlData(m);r.addClass(this.getClass(r,m));if(m._getSecondaryCalendarType()){r.addClass("sapUiCalMonthSecType");}r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}if(m._getShowHeader()){A.value=A.value+" "+i+"-Head";}if(w){r.addStyle("width",w);r.writeStyles();}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+g.getText("CALENDAR_DIALOG")+"</span>");if(m.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+g.getText("CALENDAR_START_DATE")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+g.getText("CALENDAR_END_DATE")+"</span>");}this.renderMonth(r,m,D);r.write("</div>");};M.getStartDate=function(m){return m._getDate();};M.getClass=function(r,m){var s="sapUiCalMonthView",g=m.getPrimaryCalendarType(),S=m.getShowWeekNumbers();if(g==f.Islamic||!S){s=s+" sapUiCalNoWeekNum";}return s;};M.renderMonth=function(r,m,D){var i=m.getId();this.renderHeader(r,m,D);r.write("<div id=\""+i+"-days\" class=\"sapUiCalItems\">");this.renderDays(r,m,D);r.write("</div>");};M.renderHeader=function(r,m,D){var o=m._getLocaleData();var F=m._getFirstDayOfWeek();var i=m.getId();var g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this.renderHeaderLine(r,m,o,D);r.write("<div");r.writeAttribute("id",i+"-CW");r.addStyle("display","none");r.writeStyles();r.writeAccessibilityState(null,{role:"columnheader"});r.write(">");r.write(g.getText("CALENDAR_WEEK"));r.write("</div>");r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.addStyle("overflow","hidden");r.writeStyles();r.write(">");this.renderDayNames(r,m,o,F,7,true,undefined);r.write("</div>");};M.renderHeaderLine=function(r,m,o,D){C._checkCalendarDate(D);if(m._getShowHeader()){var i=m.getId();var s=m.getPrimaryCalendarType();var g=o.getMonthsStandAlone("wide",s);r.write("<div id=\""+i+"-Head\"class=\"sapUiCalHeadText\" >");r.write(g[D.getMonth()]);r.write("</div>");}};M.renderDayNames=function(r,m,o,s,D,g,w){var F=m._getFirstDayOfWeek();var I=m.getId();var h="";var j=m.getPrimaryCalendarType();var W=[];if(m._bLongWeekDays||!m._bNamesLengthChecked){W=o.getDaysStandAlone("abbreviated",j);}else{W=o.getDaysStandAlone("narrow",j);}var k=o.getDaysStandAlone("wide",j);for(var i=0;i<D;i++){r.write("<div");r.addClass("sapUiCalWH");if(g){h=I+"-WH"+((i+F)%7);}else{h=I+"-WH"+i;}r.writeAttribute("id",h);if(i==0){r.addClass("sapUiCalFirstWDay");}if(w){r.addStyle("width",w);}r.writeAccessibilityState(null,{role:"columnheader",label:k[(i+s)%7]});r.writeClasses();r.writeStyles();r.write(">");r.write(W[(i+s)%7]);r.write("</div>");}};M.renderDays=function(r,m,D){var w,g,h,H,i,t,s;C._checkCalendarDate(D);if(!D){D=m._getFocusedDate();}t=D.toUTCJSDate().getTime();if(!t&&t!==0){throw new Error("Date is invalid "+m);}H=this.getDayHelper(m,D);g=m._getVisibleDays(D,true);s=m.getShowWeekNumbers();w=m.getPrimaryCalendarType()!==f.Islamic&&s;h=g.length;for(i=0;i<h;i++){this.renderDay(r,m,g[i],H,true,w,-1);}};M.getDayHelper=function(m,D){var o,s,g=m._getLocaleData(),h={sLocale:m._getLocale(),oLocaleData:g,iMonth:D.getMonth(),iYear:D.getYear(),iFirstDayOfWeek:m._getFirstDayOfWeek(),iWeekendStart:g.getWeekendStart(),iWeekendEnd:g.getWeekendEnd(),aNonWorkingDays:m._getNonWorkingDays(),sToday:g.getRelativeDay(0),oToday:a.fromLocalJSDate(new Date(),m.getPrimaryCalendarType()),sId:m.getId(),oFormatLong:m._getFormatLong(),sSecondaryCalendarType:m._getSecondaryCalendarType(),oLegend:undefined};s=m.getLegend();if(s&&typeof s==="string"){o=sap.ui.getCore().byId(s);if(o){if(!(o instanceof b)){throw new Error(o+" is not an sap.ui.unified.CalendarLegend. "+m);}h.oLegend=o;}else{L.warning("CalendarLegend "+s+" does not exist!",m);}}return h;};M.renderDay=function(r,m,D,h,o,w,n,W,g){C._checkCalendarDate(D);var s=new a(D,h.sSecondaryCalendarType),A={role:m._getAriaRole(),selected:false,label:"",describedby:""},B=D._bBeforeFirstYear,j="";var y=m._oFormatYyyymmdd.format(D.toUTCJSDate(),true);var k=D.getDay();var S=m._checkDateSelected(D);var p=m._getDateTypes(D);var E=m._checkDateEnabled(D);var i=0;if(B){E=false;}var q=0;if(w){q=C.calculateWeekNumber(D.toUTCJSDate(),h.iYear,h.sLocale,h.oLocaleData);A["describedby"]=h.sId+"-CW"+" "+h.sId+"-WNum-"+q;}if(!g){var t="";if(n<0){t=h.sId+"-WH"+k;}else{t=h.sId+"-WH"+n;}A["describedby"]=A["describedby"]+" "+t;}r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");r.addClass("sapUiCalWDay"+k);if(W){r.addStyle("width",W);}if(k==h.iFirstDayOfWeek){r.addClass("sapUiCalFirstWDay");}if(o&&h.iMonth!=D.getMonth()){r.addClass("sapUiCalItemOtherMonth");A["disabled"]=true;}if(D.isSame(h.oToday)){r.addClass("sapUiCalItemNow");A["label"]=h.sToday+" ";}if(S>0){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(S==2){r.addClass("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(S==3){r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(S==4){r.addClass("sapUiCalItemSelBetween");}else if(S==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}p.forEach(function(u){if(u.type!=e.None){if(u.type===e.NonWorking){r.addClass("sapUiCalItemWeekEnd");return;}r.addClass("sapUiCalItem"+u.type);j=u.type;if(u.tooltip){r.writeAttributeEscaped('title',u.tooltip);}}});if(m.getParent()&&m.getParent().getMetadata().getName()==="sap.ui.unified.CalendarOneMonthInterval"&&D.getMonth()!==m.getStartDate().getMonth()){r.addClass("sapUiCalItemOtherMonth");}if(!E){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}if(h.aNonWorkingDays){for(i=0;i<h.aNonWorkingDays.length;i++){if(k==h.aNonWorkingDays[i]){r.addClass("sapUiCalItemWeekEnd");break;}}}else if((k>=h.iWeekendStart&&k<=h.iWeekendEnd)||(h.iWeekendEnd<h.iWeekendStart&&(k>=h.iWeekendStart||k<=h.iWeekendEnd))){r.addClass("sapUiCalItemWeekEnd");}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-day",y);if(g){A["label"]=A["label"]+h.aWeekDaysWide[k]+" ";}A["label"]=A["label"]+h.oFormatLong.format(D.toUTCJSDate(),true);if(j!==""){c.addCalendarTypeAccInfo(A,j,h.oLegend);}if(h.sSecondaryCalendarType){A["label"]=A["label"]+" "+m._oFormatSecondaryLong.format(s.toUTCJSDate(),true);}r.writeAccessibilityState(null,A);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");if(!B){r.write(D.getDate());}r.write("</span>");if(w&&k==h.iFirstDayOfWeek){r.write("<span");r.writeAttribute("id",h.sId+"-WNum-"+q);r.addClass("sapUiCalWeekNum");r.writeClasses();r.writeAccessibilityState(null,{role:"rowheader",desribedby:h.sId+"-CW"});r.write(">");r.write(q);r.write("</span>");}if(g){r.write("<span");r.addClass("sapUiCalDayName");r.writeClasses();r.write(">");r.write(h.aWeekDays[k]);r.write("</span>");}if(h.sSecondaryCalendarType){r.write("<span");r.addClass("sapUiCalItemSecText");r.writeClasses();r.write(">");r.write(s.getDate());r.write("</span>");}r.write("</div>");};return M;},true);
