/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Element','sap/ui/model/SelectionModel','./library'],function(q,E,S,l){"use strict";var C=E.extend("sap.ui.ux3.Collection",{metadata:{library:"sap.ui.ux3",properties:{title:{type:"string",group:"Appearance",defaultValue:null},editable:{type:"boolean",group:"Appearance",defaultValue:false},multiSelection:{type:"boolean",group:"Accessibility",defaultValue:false}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item"}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},events:{selectionChanged:{},propertyChanged:{}}}});C.prototype.init=function(){this.oCollectionSelection=new S(S.SINGLE_SELECTION);};C.prototype.setMultiSelection=function(m){if(m){this.oCollectionSelection.setSelectionMode(S.MULTI_SELECTION);}else{this.oCollectionSelection.setSelectionMode(S.SINGLE_SELECTION);this.removeAllSelectedItems();}return this.setProperty("multiSelection",m);};C.prototype.setEditable=function(e){this.setProperty("editable",e,true);this.firePropertyChanged();return this;};C.prototype.setTitle=function(t){this.setProperty("title",t);this.fireEvent('_titleChanged',{newTitle:this.getProperty("title")});return this;};C.prototype.addSelectedItem=function(s){var o;if(typeof s=="object"){o=s;}else{o=sap.ui.getCore().byId(s);}if(q.inArray(o.getId(),this.getSelectedItems())>=0){return this;}var i=this.indexOfItem(o);if(i>-1){if(this.oCollectionSelection.getSelectionMode()==S.SINGLE_SELECTION){this.removeAllAssociation("selectedItems",true);this.oCollectionSelection.clearSelection();}this.oCollectionSelection.addSelectionInterval(i,i);}this.addAssociation("selectedItems",s,true);this.fireSelectionChanged();return this;};C.prototype.removeSelectedItem=function(s){if(this.getSelectedItems().length<=1){return;}var r=this.removeAssociation("selectedItems",s,true);var i;if(typeof s=="object"){i=this.indexOfItem(s);}else{i=this.indexOfItem(sap.ui.getCore().byId(s));}if(i>-1){this.oCollectionSelection.removeSelectionInterval(i,i);}this.fireSelectionChanged();return r;};C.prototype.removeAllSelectedItems=function(){var r=this.removeAllAssociation("selectedItems",true);this.oCollectionSelection.clearSelection();if(this.getItems().length>0){this.addSelectedItem(this.getItems()[0]);}else{this.fireSelectionChanged();}return r;};return C;},true);
