/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/ResizeHandler','./library',"./DataSetRenderer"],function(q,C,R,a,D){"use strict";var b=C.extend("sap.ui.ux3.DataSet",{metadata:{library:"sap.ui.ux3",properties:{showToolbar:{type:"boolean",group:"Misc",defaultValue:true},showFilter:{type:"boolean",group:"Misc",defaultValue:true},showSearchField:{type:"boolean",group:"Misc",defaultValue:true},multiSelect:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{items:{type:"sap.ui.ux3.DataSetItem",multiple:true,singularName:"item",bindable:"bindable"},views:{type:"sap.ui.ux3.DataSetView",multiple:true,singularName:"view"},filter:{type:"sap.ui.core.Control",multiple:true,singularName:"filter"},_viewSwitches:{type:"sap.ui.core.Control",multiple:true,singularName:"_viewSwitch",visibility:"hidden"},_toolbar:{type:"sap.ui.commons.Toolbar",multiple:false,visibility:"hidden"}},associations:{selectedView:{type:"sap.ui.ux3.DataSetView",multiple:false}},events:{selectionChanged:{parameters:{oldLeadSelectedIndex:{type:"int"},newLeadSelectedIndex:{type:"int"}}},search:{parameters:{query:{type:"string"}}}}}});b.prototype.init=function(){var t=this,T;q.sap.require("sap.ui.model.SelectionModel");this.selectionModel=new sap.ui.model.SelectionModel(sap.ui.model.SelectionModel.SINGLE_SELECTION);this._oSegBut=new sap.ui.commons.SegmentedButton();this._oSegBut.attachSelect(function(e){t.press(e);},t);this._oSegBut.show=false;this._oSearchField=new sap.ui.commons.SearchField(this.getId()+"-searchValue");this._oSearchField.setShowListExpander(false);this._oSearchField.setEnableListSuggest(false);this._oSearchField.setEnableFilterMode(true);this._oSearchField.setEnableClear(true);this._oSearchField.show=false;t=this;this._oSearchField.attachSearch(function(e){t.fireSearch(e.getParameters());});this.selectionModel.attachSelectionChanged(function(e){var o,n;var p=e.getParameters();if(p){n=p.leadIndex;o=p.oldIndex;}t.fireSelectionChanged({oldLeadSelectedIndex:o,newLeadSelectedIndex:n});q.sap.log.debug("Selection Change fired");});T=new sap.ui.commons.Toolbar();this._setToolbar(T);this._iShiftStart=null;};b.prototype.exit=function(){this._oSegBut.destroy();this._oSearchField.destroy();this.destroyAggregation("_toolbar");};b.prototype._prepareToolbar=function(){var v=this.getViews().length,t=this._getToolbar();if(v>1&&this._oSegBut.show==false){t.insertItem(this._oSegBut,0);this._oSegBut.show=true;}else if(v<=1&&this._oSegBut.show){t.removeItem(this._oSegBut);this._oSegBut.show=false;}if(this.getShowSearchField()&&this._oSearchField.show==false){t.insertRightItem(this._oSearchField,t.getRightItems().length);this._oSearchField.show=true;}else if(!this.getShowSearchField()&&this._oSearchField.show==true){t.removeRightItem(this._oSearchField);this._oSearchField.show=false;}};b.prototype.press=function(e,s){var B=e.getParameters().selectedButtonId,v=B.substring(B.lastIndexOf('-')+1),o=sap.ui.getCore().byId(this.getSelectedView());o.exitView(this.getItems());this.setSelectedView(v);};b.prototype.filter=function(){this.fireFilter({filterValue:this.getFilterValue()});};b.prototype.sort=function(){this.fireSort();};b.prototype.addSelectionInterval=function(i,I){this.selectionModel.addSelectionInterval(i,I);return this;};b.prototype.setSelectionInterval=function(i,I){this.selectionModel.setSelectionInterval(i,I);return this;};b.prototype.removeSelectionInterval=function(i,I){this.selectionModel.removeSelectionInterval(i,I);return this;};b.prototype.getSelectedIndex=function(){return this.selectionModel.getLeadSelectedIndex();};b.prototype.getSelectedIndices=function(){return this.selectionModel.getSelectedIndices()||[];};b.prototype.clearSelection=function(){this.selectionModel.clearSelection();return this;};b.prototype.selectItem=function(e){var p=e.getParameters(),i=e.getParameters().itemId,I=sap.ui.getCore().byId(i),c=this.getItems(),d=q.inArray(I,c),o=this.getLeadSelection();if(!this.getMultiSelect()){if(o==d&&!p.shift){this.setLeadSelection(-1);}else{this.setLeadSelection(d);}this._iShiftStart=null;}else{if(p.ctrl){if(!this.isSelectedIndex(d)){this.addSelectionInterval(d,d);}else{this.removeSelectionInterval(d,d);}if(this._iShiftStart>=0){this._iShiftStart=d;}}if(p.shift){if(!this._iShiftStart&&this._iShiftStart!==0){this._iShiftStart=o;}if(this._iShiftStart>=0&&p.ctrl){this.addSelectionInterval(this._iShiftStart,d);}else if(this._iShiftStart>=0&!p.ctrl){this.setSelectionInterval(this._iShiftStart,d);}else{this.setLeadSelection(d);this._iShiftStart=d;}}if(!p.shift&&!p.ctrl){if(o==d&&d!=this._iShiftStart){this.setLeadSelection(-1);}else{this.setLeadSelection(d);}this._iShiftStart=null;}}};b.prototype.prepareRendering=function(){var v,V=this.getViews().length;if(V==0){return;}this._prepareToolbar();if(this._bDirty){v=sap.ui.getCore().byId(this.getSelectedView());if(v.exitView){v.exitView(this.getItems());}if(v.initView){v.initView(this.getItems());}this._bDirty=false;}};b.prototype.getLeadSelection=function(){return this.selectionModel.getLeadSelectedIndex();};b.prototype.setLeadSelection=function(i){this.selectionModel.setLeadSelectedIndex(i);};b.prototype.isSelectedIndex=function(i){return(this.selectionModel.isSelectedIndex(i));};b.prototype.getSelectedItemId=function(i){return this.getItems()[i].getId();};b.prototype.createViewSwitch=function(v,i){var V;if(v.getIcon()){V=new sap.ui.commons.Button({id:this.getId()+"-view-"+v.getId(),lite:true,icon:v.getIcon(),iconHovered:v.getIconHovered(),iconSelected:v.getIconSelected()});}else if(v.getName()){V=new sap.ui.commons.Button({id:this.getId()+"-view-"+v.getId(),text:v.getName(),lite:true});}else{V=new sap.ui.commons.Button({id:this.getId()+"-view-"+v.getId(),text:v.getId(),lite:true});}V._viewIndex=i;return V;};b.prototype._rerenderToolbar=function(){var $=this.$("toolbar");this._prepareToolbar();if($.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.DataSetRenderer.renderToolbar(r,this);r.flush($[0]);r.destroy();}};b.prototype._rerenderFilter=function(){var $=this.$("filter");if($.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.DataSetRenderer.renderFilterArea(r,this);r.flush($[0]);if(this.getShowFilter()){$.removeClass("noPadding");}else{$.addClass("noPadding");}r.destroy();}};b.prototype.setMultiSelect=function(m){this.clearSelection();if(!m){this.setProperty("multiSelect",false);if(!!this.selectionModel){this.selectionModel.setSelectionMode(sap.ui.model.SelectionModel.SINGLE_SELECTION);}}else{this.setProperty("multiSelect",true);if(!!this.selectionModel){this.selectionModel.setSelectionMode(sap.ui.model.SelectionModel.MULTI_SELECTION);}}return this;};b.prototype.removeItem=function(i){var r=this.removeAggregation("items",i,true);if(r){r.detachSelected(this.selectItem,this);r.destroyAggregation("_template",true);this._bDirty=true;}return r;};b.prototype.removeAllItems=function(){var I=this.getItems(),r;q.each(I,function(i,o){o.destroyAggregation("_template",true);o.detachSelected(this.selectItem,this);});r=this.removeAllAggregation("items");this._bDirty=true;return r;};b.prototype.destroyItems=function(){var r=this.destroyAggregation("items");this._bDirty=true;return r;};b.prototype.addItem=function(i){this.addAggregation("items",i,true);i.attachSelected(this.selectItem,this);this._bDirty=true;return this;};b.prototype.insertItem=function(i,I){this.insertAggregation("items",i,I,true);i.attachSelected(this.selectItem,this);this._bDirty=true;return this;};b.prototype.setFilterValue=function(f){this.setProperty("filterValue",f,true);return this;};b.prototype.getFilterValue=function(){return this.getProperty("filterValue");};b.prototype.insertView=function(v,i){var V=this.createViewSwitch(v,i,true);if(!this.getSelectedView()){this.setSelectedView(v);}this.insertAggregation("views",v,i);this._oSegBut.insertButton(V,i);this._rerenderToolbar();return this;};b.prototype.addView=function(v){var i=this.getViews().length,V=this.createViewSwitch(v,i);if(!this.getSelectedView()){this.setSelectedView(v);}this.addAggregation("views",v,true);this._oSegBut.addButton(V);this._rerenderToolbar();return this;};b.prototype.removeView=function(v){var r=this.removeAggregation("views",v,true);if(r){if(this.getSelectedView()==r.getId()){this.setSelectedView(this.getViews()[0]);this._bDirty=true;r.invalidate();}else{this._rerenderToolbar();}this._oSegBut.removeButton(this.getId()+"-view-"+r.getId()).destroy();}return r;};b.prototype.destroyViews=function(){this._oSegBut.destroyButtons();this.destroyAggregation("views");return this;};b.prototype.removeAllViews=function(){var r=this.removeAllAggregation("views");this._oSegBut.destroyButtons();return r;};b.prototype.setEnableSorting=function(e){this.setProperty("enableSorting",e,true);this._rerenderToolbar();return this;};b.prototype.setEnableFiltering=function(e){this.setProperty("enableFiltering",e,true);this._rerenderToolbar();return this;};b.prototype.setSelectedView=function(v){var o=this.getSelectedView();this.setAssociation("selectedView",v);if(o!=this.getSelectedView()){this._bDirty=true;}if(this.getId()+"-view-"+this.getSelectedView()!==this._oSegBut.getSelectedButton()){this._oSegBut.setSelectedButton(this.getId()+"-view-"+this.getSelectedView());}return this;};b.prototype.addToolbarItem=function(t){this._getToolbar().addItem(t);this._rerenderToolbar();};b.prototype.removeToolbarItem=function(t){this._getToolbar().removeItem(t);this._rerenderToolbar();};b.prototype.setShowToolbar=function(s){this.setProperty("showToolbar",s,true);this._rerenderToolbar();return this;};b.prototype.setShowFilter=function(s){this.setProperty("showFilter",s,true);this._rerenderFilter();return this;};b.prototype.setShowSearchField=function(s){this.setProperty("showSearchField",s,true);this._rerenderToolbar();return this;};b.prototype._setToolbar=function(t){this.setAggregation("_toolbar",t,true);this._rerenderToolbar();};b.prototype._getToolbar=function(){return this.getAggregation("_toolbar");};b.prototype.refreshItems=function(){var B=this.getBinding("items"),s=sap.ui.getCore().byId(this.getSelectedView());B.bUseExtendedChangeDetection=true;if(s&&s.getItemCount&&s.getItemCount()){var i=Math.max(s.getItemCount(),this.getItems().length);if(i){B.getContexts(0,i);}else{B.getContexts();}}else{B.getContexts();}};b.prototype.updateItems=function(c){var B=this.mBindingInfos["items"],A=this.getMetadata().getAggregation("items"),s=sap.ui.getCore().byId(this.getSelectedView()),o=B.binding,f=B.factory,d,I,e,g,t=this,h=[];o.bUseExtendedChangeDetection=true;if(s&&s.getItemCount&&s.getItemCount()){var j=Math.max(s.getItemCount(),this.getItems().length);if(j){h=o.getContexts(0,j);}else{h=o.getContexts();}}else{h=o.getContexts();}if(h.diff&&c){var k=h.diff;for(var i=0;i<k.length;i++){I=this.getItems();g=k[i].index;if(k[i].type==="delete"){e=I[g];k[i].item=e;this.removeItem(e);}else if(h.diff[i].type==="insert"){e=f("",h[g]);e.setBindingContext(h[g],B.model);k[i].item=e;this.insertItem(e,g);}}if(s&&s.updateView){s.updateView(k);}}else{this[A._sDestructor]();q.each(h,function(g,m){var n=t.getId()+"-"+g;d=f(n,m);d.setBindingContext(m,B.model);t[A._sMutator](d);});}I=this.getItems();for(var i=0,l=h.length;i<l;i++){I[i].setBindingContext(h[i],B.model);}};return b;},true);
