/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./Dialog','./ComboBoxTextField','./Toolbar','./Button','./Bar','./Text','./Title','sap/ui/core/InvisibleText','sap/ui/core/IconPool','sap/ui/core/ValueStateSupport','sap/base/Log','./library','sap/ui/Device','sap/ui/core/library','./ComboBoxBaseRenderer',"sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery","sap/base/security/encodeXML","sap/base/strings/escapeRegExp"],function(D,C,T,B,a,b,c,I,d,V,L,l,e,f,g,h,K,q,j,k){"use strict";var P=l.PlacementType;var m=f.ValueState;var n=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m","abstract":true,defaultAggregation:"items",properties:{showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}}}});n.DEFAULT_TEXT_FILTER=function(i,o,p){var s,r,M;if(!o[p]){return false;}s=o[p]().toLowerCase();r=i.toLowerCase();M=new RegExp('(^|\\s)'+k(r)+".*",'g');return M.test(s);};n.prototype.oncompositionstart=function(){this._bIsComposingCharacter=true;};n.prototype.oncompositionend=function(E){this._bIsComposingCharacter=false;this._sComposition=E.target.value;if(!e.browser.edge&&!e.browser.firefox){C.prototype.handleInput.apply(this,arguments);this.handleInputValidation(E,this.isComposingCharacter());}};n.prototype.isComposingCharacter=function(){return this._bIsComposingCharacter;};n.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};n.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this.fnFilter=null;return this;}if(typeof(F)!=="function"){L.warning("Passed filter is not a function and the default implementation will be used");}else{this.fnFilter=F;}return this;};n.prototype.highLightList=function(v,i){var o=v.length,v=v.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,'\\$&'),r=new RegExp("\\b"+v,"gi"),$;i.forEach(function(p){$=q(p.ref);$.html(this._boldItemRef.call(this,p.text,r,o));},this);};n.prototype._boldItemRef=function(i,r,o){r.lastIndex=0;var R,p=r.exec(i);if(p===null){return j(i);}var M=p.index;var t="<b>"+j(i.slice(M,M+o))+"</b>";var s=i.split(r);if(s.length===1){R=j(i);}else{R=s.map(function(u){return j(u);}).join(t);}return R;};n.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};n.prototype.loadItems=function(i,o){var p=typeof i==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(p){o=q.extend({action:i,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function onItemsNotLoadedAfterDelay(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(p){i.call(this);}};n.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,o,N,p;i<this.aMessageQueue.length;i++){o=this.aMessageQueue.shift();i--;p=(i+1)===this.aMessageQueue.length;N=p?null:this.aMessageQueue[i+1];if(typeof o.action==="function"){if((o.name==="input")&&!p&&(N.name==="input")){continue;}o.action.call(this);}}};n.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};n.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};n.prototype.getPickerInvisibleTextId=function(){return I.getStaticId("sap.m","COMBOBOX_AVAILABLE_OPTIONS");};n.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(e.system.phone?"Dialog":"Dropdown");this.createPicker(this.getPickerType());this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._bShouldClosePicker=false;this._oPickerValueStateText=null;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;this.getIcon().addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=this.isOpen();}},this);this.getIcon().attachPress(function(E){var p;if(!this.getEnabled()||!this.getEditable()){return;}if(this._bShouldClosePicker){this._bShouldClosePicker=false;this.close();return;}this.loadItems();this.bOpenedByKeyboardOrButton=true;if(this.isPlatformTablet()){p=this.getPicker();p.setInitialFocus(p);}this.open();},this);this._sComposition="";this.fnFilter=null;};n.prototype.onBeforeRendering=function(){var N=this.getValueState()===m.None;C.prototype.onBeforeRendering.apply(this,arguments);if(!this.isPickerDialog()&&N){this._showValueStateText(false);}};n.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oPickerValueStateText){this._oPickerValueStateText.destroy();}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;this.fnFilter=null;};n.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(E.keyCode===K.F4){this.onF4(E);}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};n.prototype.onF4=function(E){E.preventDefault();};n.prototype.onsapescape=function(E){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){E.setMarked();E.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};n.prototype.onsaphide=n.prototype.onsapshow;n.prototype.onsapfocusleave=function(E){if(!E.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(E.relatedControlId);if(r===this){return;}var p=this.getAggregation("picker"),F=r&&r.getFocusDomRef();if(p&&h(p.getFocusDomRef(),F)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};n.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};n.prototype.addContent=function(p){};n.prototype.getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};n.prototype.setPickerType=function(p){this._sPickerType=p;};n.prototype.getPickerType=function(){return this._sPickerType;};n.prototype.setValueState=function(v){var A,s=this.getValueStateText(),S=(v===m.None?false:this.getShowValueStateMessage());this._sOldValueState=this.getValueState();C.prototype.setValueState.apply(this,arguments);this._showValueStateText(S);if(s){this._setValueStateText(s);}else{A=V.getAdditionalText(this);this._setValueStateText(A);}this._alignValueStateStyles();return this;};n.prototype.setValueStateText=function(t){C.prototype.setValueStateText.apply(this,arguments);this._setValueStateText(this.getValueStateText());return this;};n.prototype.setShowValueStateMessage=function(s){C.prototype.setShowValueStateMessage.apply(this,arguments);this._showValueStateText(this.getShowValueStateMessage());return this;};n.prototype._showValueStateText=function(s){var o;if(this.isPickerDialog()){if(this._oPickerValueStateText){this._oPickerValueStateText.setVisible(s);}}else{o=this._getPickerCustomHeader();if(o){o.setVisible(s);}}};n.prototype._setValueStateText=function(t){var H;if(this.isPickerDialog()){this._oPickerValueStateText=this.getPickerValueStateText();this._oPickerValueStateText.setText(t);}else{H=this._getPickerCustomHeader();if(H){H.getContentLeft()[0].setText(t);}}};n.prototype._getPickerCustomHeader=function(){var i,o,p=this.getPicker(),s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"PickerTitle";if(!p){return null;}if(p.getCustomHeader()){return p.getCustomHeader();}i=new c({textAlign:"Left"}).addStyleClass(s);o=new a({visible:false,contentLeft:i});p.setCustomHeader(o);return o;};n.prototype._alignValueStateStyles=function(){var o=this._sOldValueState,i=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Picker",p=i+"ValueState",O=i+o+"State",s=i+this.getValueState()+"State",r;if(this.isPickerDialog()&&this._oPickerValueStateText){this._oPickerValueStateText.addStyleClass(p);this._oPickerValueStateText.removeStyleClass(O);this._oPickerValueStateText.addStyleClass(s);}else{r=this._getPickerCustomHeader();if(r){r.addStyleClass(p);r.removeStyleClass(O);r.addStyleClass(s);}}};n.prototype.shouldValueStateMessageBeOpened=function(){var s=C.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return(s&&!this.isOpen());};n.prototype.onPropertyChange=function(o,i){var N=o.getParameter("newValue"),p=o.getParameter("name"),M="set"+p.charAt(0).toUpperCase()+p.slice(1),r=(i&&i.srcControl)||this.getPickerTextField();if(/\bvalue\b|\benabled\b|\bname\b|\bplaceholder\b|\beditable\b|\btextAlign\b|\btextDirection\b|\bvalueState\b/.test(p)&&r&&(typeof r[M]==="function")){r[M](N);}};n.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};n.prototype.isPlatformTablet=function(){var N=!e.system.combi,t=e.system.tablet&&N;return t;};n.prototype.getDropdownSettings=function(){return{showArrow:false,placement:P.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined};};n.prototype.getPickerValueStateText=function(){var p=this.getPicker();if(!this._oPickerValueStateText){this._oPickerValueStateText=new b({width:"100%"});p.insertContent(this._oPickerValueStateText,0);}return this._oPickerValueStateText;};n.prototype.createPicker=function(p){};n.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;};n.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};n.prototype.getPickerTextField=function(){var p=this.getPicker(),s=p.getSubHeader();return s&&s.getContent()[0]||null;};n.prototype.getPickerTitle=function(){var p=this.getPicker(),H=p&&p.getCustomHeader();if(this.isPickerDialog()&&H){return H.getContentMiddle()[0];}return null;};n.prototype.createDialog=function(){var t=this,o=this.createPickerTextField(),i=o._handleEvent;o._handleEvent=function(E){i.apply(this,arguments);if(/keydown|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(E.type)){t._handleEvent(E);}};return new D({stretch:true,customHeader:t.createPickerHeader(),buttons:this.createPickerCloseButton(),subHeader:new T({content:o}),beforeOpen:function(){t.updatePickerHeaderTitle();},afterClose:function(){t.focus();l.closeKeyboard();},ariaLabelledBy:t.getPickerInvisibleTextId()||undefined});};n.prototype.createPickerHeader=function(){var t=this,i=d.getIconURI("decline");return new a({contentMiddle:new c(),contentRight:new B({icon:i,press:function(){t.close();t.revertSelection();}})});};n.prototype.revertSelection=function(){};n.prototype.updatePickerHeaderTitle=function(){var p=this.getPicker(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),o,i;if(!p){return;}i=this.getLabels();if(i.length){o=i[0];if(o&&(typeof o.getText==="function")){this.getPickerTitle().setText(o.getText());}}else{this.getPickerTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};n.prototype.createPickerCloseButton=function(){var t=this,o,r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("COMBOBOX_CLOSE_BUTTON"),press:function(){o=t.getPickerTextField();t.updateDomValue(o.getValue());t.onChange();t.close();}});};n.prototype.hasContent=function(){return this.getItems().length>0;};n.prototype.findFirstEnabledItem=function(i){var o=this.getList();return o?o.findFirstEnabledItem(i):null;};n.prototype.findLastEnabledItem=function(i){var o=this.getList();return o?o.findLastEnabledItem(i):null;};n.prototype.open=function(){var p=this.getPicker();if(p){p.open();}return this;};n.prototype.getVisibleItems=function(){var o=this.getList();return o?o.getVisibleItems():[];};n.prototype.isItemSelected=function(){};n.prototype.getKeys=function(o){o=o||this.getItems();for(var i=0,p=[];i<o.length;i++){p[i]=o[i].getKey();}return p;};n.prototype.getSelectableItems=function(){var o=this.getList();return o?o.getSelectableItems():[];};n.prototype.findItem=function(p,v){var o=this.getList();return o?o.findItem(p,v):null;};n.prototype.getItemByText=function(t){return this.findItem("text",t);};n.prototype.scrollToItem=function(i){var p=this.getPicker(),o=p.getDomRef("cont"),r=i&&i.getDomRef();if(!p||!o||!r){return;}var s=o.scrollTop,t=r.offsetTop,u=o.clientHeight,v=r.offsetHeight;if(s>t){o.scrollTop=t;}else if((t+v)>(s+u)){o.scrollTop=Math.ceil(t+v-u);}};n.prototype.clearFilter=function(){for(var i=0,o=this.getItems();i<o.length;i++){o[i].bVisible=true;}};n.prototype.onItemChange=function(o){};n.prototype.clearSelection=function(){};n.prototype.setInternalBusyIndicator=function(i){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};n.prototype.setInternalBusyIndicatorDelay=function(i){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};n.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};n.prototype.insertItem=function(i,o){this.insertAggregation("items",i,o,true);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};n.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};n.prototype.getFirstItem=function(){return this.getItems()[0]||null;};n.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};n.prototype.getEnabledItems=function(i){var o=this.getList();return o?o.getEnabledItems(i):[];};n.prototype.getItemByKey=function(s){var o=this.getList();return o?o.getItemByKey(s):null;};n.prototype.isOpen=function(){var p=this.getAggregation("picker");return!!(p&&p.isOpen());};n.prototype.close=function(){var p=this.getAggregation("picker");if(p){p.close();}return this;};n.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};n.prototype.removeAllItems=function(){var o=this.removeAllAggregation("items");this.clearSelection();for(var i=0;i<o.length;i++){o[i].detachEvent("_change",this.onItemChange,this);}return o;};n.prototype.intersectItems=function(i,o){return i.filter(function(p){return o.map(function(O){return O.getId();}).indexOf(p.getId())!==-1;});};return n;});
