/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/hyphenation/Hyphenation","sap/base/Log"],function(l,H,L){"use strict";var W=l.WrappingType;function i(C){if(!C.isA("sap.m.IHyphenation")){L.error("[UI5 Hyphenation] The given control does not implement interface sap.m.IHyphenation and can not use HyphenationSupport mixin.");return false;}return true;}function a(C,k){var t=C.getTextsToBeHyphenated();if(typeof t!=="object"){L.error("[UI5 Hyphenation] The result of getTextsToBeHyphenated method is not a map object.",C.getId());return false;}if(Object.keys(t).indexOf(k)<0){L.error("[UI5 Hyphenation] The key "+k+" is not found in the result of getTextsToBeHyphenated method.",C.getId());return false;}return true;}function s(D,n){n=n||"";var C=D.childNodes;if(C.length===1&&C[0].nodeType===window.Node.TEXT_NODE){C[0].nodeValue=n;}else{D.textContent=n;}}function d(t,T){var D=[];Object.keys(t).forEach(function(k){if(!(k in T&&t[k]===T[k])){D.push(k);}});return D;}function b(){var f=sap.ui.getCore().getConfiguration().getHyphenation(),o=H.getInstance();if(f==="native"){return false;}if(f==="thirdparty"){return true;}return o.isLanguageSupported()&&!o.canUseNativeHyphenation()&&o.canUseThirdPartyHyphenation();}function c(C){if(C.getWrappingType()===W.Hyphenated&&!C.getWrapping()){L.warning("[UI5 Hyphenation] The property wrappingType=Hyphenated will not take effect unless wrapping=true.",C.getId());}return C.getWrapping()&&C.getWrappingType()===W.Hyphenated;}function h(C){if(!(c(C)&&b())){C._mHyphenatedTexts={};C._mUnhyphenatedTexts={};return;}var t=C.getTextsToBeHyphenated(),f=d(t,C._mUnhyphenatedTexts);if(f.length>0){C._mUnhyphenatedTexts=t;f.forEach(function(k){delete C._mHyphenatedTexts[k];});var o=H.getInstance();if(!o.isLanguageInitialized()){o.initialize().then(function(){var D=C.isActive()?C.getDomRefsForHyphenatedTexts():null,n=false;f.forEach(function(k){C._mHyphenatedTexts[k]=o.hyphenate(t[k]);if(D&&k in D){s(D[k],C._mHyphenatedTexts[k]);}else{n=true;}});if(n){C.invalidate();}});}else{f.forEach(function(k){C._mHyphenatedTexts[k]=o.hyphenate(t[k]);});}}}var e={};e.mixInto=function(C){if(!i(C)){return;}var I=C.init;C.init=function(f){var r=I.apply(this,arguments);this._mHyphenatedTexts={};this._mUnhyphenatedTexts={};return r;};var o=C.onBeforeRendering;C.onBeforeRendering=function(){var r=o.apply(this,arguments);h(this);return r;};};e.writeHyphenationClass=function(r,C){if(!i(C)){return;}if(c(C)&&!b()){r.addClass("sapUiHyphenation");}};e.getTextForRender=function(C,k){if(!i(C)){return null;}if(!a(C,k)){return null;}var t=C.getTextsToBeHyphenated();if(c(C)&&b()){if(t[k]!==C._mUnhyphenatedTexts[k]){h(C);}if(k in C._mHyphenatedTexts){return C._mHyphenatedTexts[k];}}return t[k];};return e;});
