/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ResponsivePopover","./Button","./Toolbar","./Bar","sap/ui/core/Control","sap/ui/core/IconPool","./semantic/SemanticPage","./Popover","./MessageView","sap/ui/Device","./MessagePopoverRenderer","sap/base/Log","sap/ui/thirdparty/jquery"],function(R,B,T,a,C,I,S,P,M,D,b,L,q){"use strict";var c=C.extend("sap.m.MessagePopover",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},placement:{type:"sap.m.VerticalPlacementType",group:"Behavior",defaultValue:"Vertical"},initiallyExpanded:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",altTypes:["sap.m.MessagePopoverItem"],multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false,forwarding:{idSuffix:"-messageView",aggregation:"headerButton"}}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessagePopoverItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{},activeTitlePress:{parameters:{item:{type:"sap.m.MessageItem"}}}}}});function d(n){return n.charAt(0).toUpperCase()+n.slice(1);}var e="sapMMsgPopover",f="320px",g="440px",h={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")},A=["asyncDescriptionHandler","asyncURLHandler"],i={asyncDescriptionHandler:function(j){var l=j.item.getLongtextUrl();if(l){q.ajax({type:"GET",url:l,success:function(k){j.item.setDescription(k);j.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+l;L.error(E);j.promise.reject(E);}});}}};c.setDefaultHandlers=function(m){A.forEach(function(F){if(m.hasOwnProperty(F)){i[F]=m[F];}});};c.prototype.init=function(){var t=this;var p;this._oOpenByControl=null;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oMessageView=this._initMessageView();this._oMessageView.addEventDelegate({onBeforeRendering:function(){var s=t._oMessageView._oSegmentedButton.getVisible(),j=!t.getInitiallyExpanded()||s;t._oMessageView._oSegmentedButton.setVisible(j);t._oMessageView._listPage.setShowHeader(true);}});this._insertCloseBtn(this._oMessageView._oListHeader);this._insertCloseBtn(this._oMessageView._oDetailsHeader);this._oMessageView._oSegmentedButton.attachEvent("select",this._onSegButtonSelect,this);this._oPopover=new R(this.getId()+"-messagePopover",{showHeader:false,contentWidth:g,contentHeight:f,placement:this.getPlacement(),showCloseButton:false,verticalScrolling:false,horizontalScrolling:false,modal:false,afterOpen:function(E){t.fireAfterOpen({openBy:E.getParameter("openBy")});},afterClose:function(E){t._oMessageView._navContainer.backToTop();t.fireAfterClose({openBy:E.getParameter("openBy")});},beforeOpen:function(E){t.fireBeforeOpen({openBy:E.getParameter("openBy")});},beforeClose:function(E){t.fireBeforeClose({openBy:E.getParameter("openBy")});}}).addStyleClass(e);this._oPopover.addContent(this._oMessageView);this._oPopover.addAssociation("ariaLabelledBy",this.getId()+"-messageView-HeadingDescr",true);p=this._oPopover.getAggregation("_popup");p.oPopup.setAutoClose(false);p.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onAfterRendering:this.onAfterRenderingPopover},this);if(D.system.phone){this._oPopover.setBeginButton(new B({text:this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),press:this.close.bind(this)}));}A.forEach(function(F){if(i.hasOwnProperty(F)){this['set'+d(F)](i[F]);}},this);};c.prototype.onBeforeRendering=function(){if(this.getDependents().indexOf(this._oPopover)===-1){this.addDependent(this._oPopover);}};c.prototype.onBeforeRenderingPopover=function(){if(this._bItemsChanged){var j=this.getItems();var t=this;this._oMessageView.destroyItems();j.forEach(function(k){k._updateProperties(function(){t._bItemsChanged=true;});this._oMessageView.addItem(k.clone("","",{cloneChildren:true,cloneBinding:true}));},this);this._bItemsChanged=false;}this._setInitialFocus();if(this._oOpenByControl&&!this._oOpenByControl.getVisible()){this._oPopover.close();}};c.prototype.onAfterRenderingPopover=function(){if(this._oPopover._oControl._sFocusControlId){this._oPopover._oControl._sFocusControlId=null;}};c.prototype.exit=function(){this._oResourceBundle=null;this._oOpenByControl=null;if(this._oMessageView){this._oMessageView.destroy();this._oMessageView=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};c.prototype.openBy=function(o){var r=this._oPopover.getAggregation("_popup"),p=o.getParent();this._oOpenByControl=o;if(r instanceof P){if((p instanceof T||p instanceof a||p instanceof S)){r._minDimensions={width:400,height:128};r.setShowArrow(false);r.setResizable(true);}else{r.setShowArrow(true);}}if(this._oPopover){this._restoreExpansionDefaults();this._oPopover.openBy(o);}return this;};c.prototype.close=function(){if(this._oPopover){this._oPopover.close();}return this;};c.prototype.isOpen=function(){return this._oPopover.isOpen();};c.prototype.toggle=function(o){if(this.isOpen()){this.close();}else{this.openBy(o);}return this;};c.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._oPopover.setPlacement(p);return this;};c.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};c.prototype._initMessageView=function(){var t=this,m;m=new M(this.getId()+"-messageView",{activeTitlePress:function(E){if(sap.ui.Device.system.phone){t.close();}t.fireActiveTitlePress({item:E.getParameter("item")});},listSelect:function(E){t.fireListSelect({messageTypeFilter:E.getParameter('messageTypeFilter')});},itemSelect:function(E){t.fireItemSelect({messageTypeFilter:E.getParameter('messageTypeFilter'),item:E.getParameter('item')});},longtextLoaded:function(){t.fireLongtextLoaded();},urlValidated:function(){t.fireUrlValidated();}});m._makeAutomaticBinding=function(){var j=t.getItems();if(!t.getBindingInfo("items")&&!j.length){this._bindToMessageModel();}};return m;};c.prototype._onSegButtonSelect=function(){if(this.isOpen()&&!this.getInitiallyExpanded()&&this._oPopover.hasStyleClass(e+"-init")){this._expandMsgPopover();}};c.prototype._restoreExpansionDefaults=function(){if(!this.getInitiallyExpanded()){this._collapseMsgPopover();this._oMessageView._oSegmentedButton.setSelectedButton("none");}else{this._expandMsgPopover();}};c.prototype._expandMsgPopover=function(){var s,H=f,s=this._oPopover.$("cont").css("height");if(this.getInitiallyExpanded()&&s!=="0px"){H=parseFloat(s)?s:H;}this._oPopover.setContentHeight(H).removeStyleClass(e+"-init");};c.prototype._collapseMsgPopover=function(){this._oPopover.addStyleClass(e+"-init").setContentHeight("auto");};c.prototype._insertCloseBtn=function(o){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),j=new B({icon:h["close"],visible:!D.system.phone,tooltip:s,press:this.close.bind(this)}).addStyleClass(e+"CloseBtn");o.insertContent(j,3,true);};c.prototype._setInitialFocus=function(){if(this._oMessageView._isListPage()&&this.getInitiallyExpanded()){this._oPopover.setInitialFocus(this._oMessageView._oLists[this._sCurrentList||'all']);}};c.prototype.setAsyncDescriptionHandler=function(j){this.setProperty('asyncDescriptionHandler',j,true);this._oMessageView.setProperty('asyncDescriptionHandler',j,true);return this;};c.prototype.setAsyncURLHandler=function(j){this.setProperty('asyncURLHandler',j,true);this._oMessageView.setProperty('asyncURLHandler',j,true);return this;};c.prototype.setModel=function(m,n){this._oMessageView.setModel(m,n);return C.prototype.setModel.apply(this,arguments);};["invalidate","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getBusy","setBusy"].forEach(function(n){c.prototype[n]=function(){if(this._oPopover&&this._oPopover[n]){var p=this._oPopover;var r=p[n].apply(p,arguments);return r===p?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){c.prototype["_"+F+"Old"]=c.prototype[F];c.prototype[F]=function(){var r=c.prototype["_"+F+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){this._oPopover.invalidate();}if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return r;}return this;};});return c;});
