/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/ui/core/Control","sap/ui/core/delegate/ScrollEnablement","sap/m/Title","sap/m/Button","sap/m/Bar","sap/ui/core/ContextMenuSupport","sap/ui/core/library","sap/ui/Device","sap/ui/core/Element","./TitlePropagationSupport","./PageRenderer","sap/ui/thirdparty/jquery"],function(l,C,S,T,B,a,b,c,D,E,d,P,q){"use strict";var A=c.AccessibleLandmarkRole;var e=l.ButtonType;var f=l.PageBackgroundDesign;var g=c.TitleLevel;var h="div";var H="header";var F="footer";var i=C.extend("sap.m.Page",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:g.Auto},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},showHeader:{type:"boolean",group:"Appearance",defaultValue:true},showSubHeader:{type:"boolean",group:"Appearance",defaultValue:true},navButtonText:{type:"string",group:"Misc",defaultValue:null,deprecated:true},navButtonTooltip:{type:"string",group:"Misc",defaultValue:null},enableScrolling:{type:"boolean",group:"Behavior",defaultValue:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null,deprecated:true},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:f.Standard},navButtonType:{type:"sap.m.ButtonType",group:"Appearance",defaultValue:e.Back,deprecated:true},showFooter:{type:"boolean",group:"Appearance",defaultValue:true},contentOnlyBusy:{type:"boolean",group:"Appearance",defaultValue:false},floatingFooter:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeader:{type:"sap.m.IBar",multiple:false},footer:{type:"sap.m.IBar",multiple:false},subHeader:{type:"sap.m.IBar",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent",forwarding:{getter:"_getInternalHeader",aggregation:"contentRight"}},landmarkInfo:{type:"sap.m.PageAccessibleLandmarkInfo",multiple:false},_internalHeader:{type:"sap.m.IBar",multiple:false,visibility:"hidden"}},events:{navButtonTap:{deprecated:true},navButtonPress:{}},dnd:{draggable:false,droppable:true},designtime:"sap/m/designtime/Page.designtime"}});b.apply(i.prototype);d.call(i.prototype,"content",function(){return this._headerTitle?this._headerTitle.getId():false;});i.FOOTER_ANIMATION_DURATION=350;i.prototype.init=function(){this._initTitlePropagationSupport();};i.prototype._hasScrolling=function(){return this.getEnableScrolling();};i.prototype.onBeforeRendering=function(){if(this._oScroller&&!this._hasScrolling()){this._oScroller.destroy();this._oScroller=null;}else if(this._hasScrolling()&&!this._oScroller){this._oScroller=new S(this,null,{scrollContainerId:this.getId()+"-cont",horizontal:false,vertical:true});}if(this._headerTitle){this._headerTitle.setLevel(this.getTitleLevel());}};i.prototype.onAfterRendering=function(){setTimeout(this._adjustFooterWidth.bind(this),10);};i.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._headerTitle){this._headerTitle.destroy();this._headerTitle=null;}if(this._navBtn){this._navBtn.destroy();this._navBtn=null;}if(this._appIcon){this._appIcon.destroy();this._appIcon=null;}};i.prototype.setBackgroundDesign=function(s){var j=this.getBackgroundDesign();this.setProperty("backgroundDesign",s,true);this.$().removeClass("sapMPageBg"+j).addClass("sapMPageBg"+this.getBackgroundDesign());return this;};i.prototype.setTitle=function(t){var w=!this._headerTitle;this._headerTitle=this._headerTitle||new T(this.getId()+"-title",{level:this.getTitleLevel()});this._headerTitle.setText(t);if(w){this._updateHeaderContent(this._headerTitle,"middle",0);}this.setProperty("title",t,true);return this;};i.prototype._ensureNavButton=function(){var s=this.getNavButtonTooltip()||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PAGE_NAVBUTTON_TEXT");if(!this._navBtn){var n=this.getNavButtonType();this._navBtn=new B(this.getId()+"-navButton",{press:q.proxy(function(){this.fireNavButtonPress();this.fireNavButtonTap();},this)});if(D.os.android&&n==e.Back){this._navBtn.setType(e.Up);}else{this._navBtn.setType(n);}}this._navBtn.setTooltip(s);};i.prototype.setShowNavButton=function(s){var o=!!this.getShowNavButton();if(s===o){return this;}this.setProperty("showNavButton",s,true);if(s){this._ensureNavButton();if(this._appIcon){this._updateHeaderContent(this._appIcon,"left",-1);}this._updateHeaderContent(this._navBtn,"left",0);}else if(this._navBtn){this._updateHeaderContent(this._navBtn,"left",-1);}return this;};i.prototype.setShowFooter=function(s){if(this.getDomRef()){(s)?this.$().addClass("sapMPageWithFooter"):this.$().removeClass("sapMPageWithFooter");}var $=q(this.getDomRef()).find(".sapMPageFooter").last(),u=sap.ui.getCore().getConfiguration().getAnimation();if(!this.getFloatingFooter()){this.setProperty("showFooter",s);return this;}this.setProperty("showFooter",s,true);$.removeClass("sapUiHidden");$.toggleClass("sapMPageFooterControlShow",s);$.toggleClass("sapMPageFooterControlHide",!s);if(s){return this;}if(u){setTimeout(function(){$.toggleClass("sapUiHidden",!s);},i.FOOTER_ANIMATION_DURATION);}else{$.toggleClass("sapUiHidden",!s);}return this;};i.prototype.setNavButtonType=function(n){this._ensureNavButton();if(!D.os.ios&&n==e.Back){this._navBtn.setType(e.Up);}else{this._navBtn.setType(n);}this.setProperty("navButtonType",n,true);return this;};i.prototype.setNavButtonText=function(t){this._ensureNavButton();this.setProperty("navButtonText",t,true);return this;};i.prototype.setNavButtonTooltip=function(t){this.setProperty("navButtonTooltip",t,true);this._ensureNavButton();return this;};i.prototype.setIcon=function(I){var o=this.getIcon();if(o===I){return this;}this.setProperty("icon",I,true);return this;};i.prototype._adjustFooterWidth=function(){var j=sap.ui.getCore().getConfiguration().getRTL()?"left":"right";if(!this.getShowFooter()||!this.getFloatingFooter()||!this.getFooter()){return;}var $=q(this.getDomRef()).find(".sapMPageFooter").last();if(this._contentHasScroll()){$.css(j,q.position.scrollbarWidth()+"px");$.css("width","initial");}else{$.css(j,0);$.css("width","");}};i.prototype._contentHasScroll=function(){var $=q(document.getElementById(this.getId()+"-cont"));return $[0].scrollHeight>$.innerHeight();};i.prototype._updateHeaderContent=function(o,s,j){var I=this._getInternalHeader();if(I){switch(s){case"left":if(j==-1){if(I.getContentLeft()){I.removeContentLeft(o);}}else{if(I.indexOfContentLeft(o)!=j){I.insertContentLeft(o,j);I.invalidate();}}break;case"middle":if(j==-1){if(I.getContentMiddle()){I.removeContentMiddle(o);}}else{if(I.indexOfContentMiddle(o)!=j){I.insertContentMiddle(o,j);I.invalidate();}}break;case"right":if(j==-1){if(I.getContentRight()){I.removeContentRight(o);}}else{if(I.indexOfContentRight(o)!=j){I.insertContentRight(o,j);I.invalidate();}}break;default:break;}}};i.prototype._getInternalHeader=function(){var I=this.getAggregation("_internalHeader");if(!I){this.setAggregation("_internalHeader",new a(this.getId()+"-intHeader"),true);I=this.getAggregation("_internalHeader");if(this.getShowNavButton()&&this._navBtn){this._updateHeaderContent(this._navBtn,"left",0);}if(this.getTitle()&&this._headerTitle){this._updateHeaderContent(this._headerTitle,"middle",0);}}return I;};i.prototype._getAnyHeader=function(){var o=this.getCustomHeader();if(o){return o.addStyleClass("sapMPageHeader");}return this._getInternalHeader().addStyleClass("sapMPageHeader");};i.prototype.getScrollDelegate=function(){return this._oScroller;};i.prototype._formatLandmarkInfo=function(L,p){if(L){var r=L["get"+p+"Role"]()||"",s=L["get"+p+"Label"]()||"";if(r===A.None){r='';}return{role:r.toLowerCase(),label:s};}return{};};i.prototype._getHeaderTag=function(L){if(L&&L.getHeaderRole()!==A.None){return h;}return H;};i.prototype._getSubHeaderTag=function(L){if(L&&L.getSubHeaderRole()!==A.None){return h;}return H;};i.prototype._getFooterTag=function(L){if(L&&L.getFooterRole()!==A.None){return h;}return F;};i.prototype.scrollTo=function(y,t){if(this._oScroller){this._oScroller.scrollTo(0,y,t);}return this;};i.prototype.scrollToElement=function(o,t,O){if(o instanceof E){o=o.getDomRef();}if(this._oScroller){this._oScroller.scrollToElement(o,t,O);}return this;};i.prototype.setContentOnlyBusy=function(j){this.setProperty("contentOnlyBusy",j,true);this.$().toggleClass("sapMPageBusyCoversAll",!j);return this;};i.prototype.setBusy=function(){this._sBusySection=this.getContentOnlyBusy()?'cont':null;return C.prototype.setBusy.apply(this,arguments);};i.prototype.setCustomHeader=function(o){this.setAggregation("customHeader",o);if(o&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":o});}return this;};i.prototype._getAdaptableContent=function(){return this._getAnyHeader();};return i;});
