/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/base/ManagedObjectObserver','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/DateRange','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarRow','sap/ui/unified/CalendarRowRenderer','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarWeekInterval','sap/ui/unified/CalendarOneMonthInterval','sap/ui/Device','sap/ui/core/Element','sap/ui/core/Renderer','sap/ui/core/ResizeHandler','sap/ui/core/Item','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo','sap/ui/core/dnd/DragDropInfo','sap/m/Select','sap/m/Button','sap/m/Toolbar','sap/m/Table','sap/m/Column','sap/m/ColumnListItem','sap/m/ColumnListItemRenderer','sap/m/StandardListItem','sap/m/StandardListItemRenderer','sap/m/PlanningCalendarRow','sap/m/PlanningCalendarRenderer','sap/m/library',"sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(C,M,u,a,b,D,c,d,e,f,g,h,k,E,R,l,I,m,n,o,S,B,T,p,q,r,s,t,v,P,w,x,y,L,Q){"use strict";var z=u.CalendarDayType;var A=x.ListMode;var F=x.ToolbarDesign;var G=x.ButtonType;var H=x.PlanningCalendarBuiltInView;var J=x.ScreenSize;var K=u.CalendarAppointmentVisualization;var N=u.GroupAppointmentsMode;var O=u.CalendarIntervalType;var U="DragDropConfig";var V="ResizeConfig";var W="CreateConfig";var X="-CLI";var Y=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:O.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:N.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:K.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:false},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:false},builtInViews:{type:"string[]",group:"Appearance",defaultValue:[]},stickyHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent"},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{row:{type:"sap.m.PlanningCalendarRow"}}},designtime:"sap/m/designtime/PlanningCalendar.designtime"},constructor:function(i,j){C.prototype.constructor.apply(this,arguments);if(typeof i!=="string"){j=i;}if(j&&typeof j.customAppointmentsSorterCallback==="function"){this._fnCustomSortedAppointments=j.customAppointmentsSorterCallback;}}});var Z=["_oTimeInterval","_oDateInterval","_oMonthInterval","_oWeekInterval","_oOneMonthInterval"],$={};$[O.Day]={sInstanceName:"_oDateInterval",sIdSuffix:"-DateInt",oClass:f};$[O.Week]={sInstanceName:"_oWeekInterval",sIdSuffix:"-WeekInt",oClass:g};$[O.OneMonth]={sInstanceName:"_oOneMonthInterval",sIdSuffix:"-OneMonthInt",oClass:h};var _=J.Desktop;var a1=[H.Hour,H.Day,H.Month,H.Week,H.OneMonth];var b1={PHONE:"600",TABLET:"1024"};var c1=["sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarMonthInterval"];var d1=C.extend("CalendarHeader",{metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addClass("sapMPlanCalHead");i.writeClasses();i.write(">");var F1=j.getToolbar();if(F1){i.renderControl(F1);}var G1=j.getAllCheckBox();if(G1){i.renderControl(G1);}i.write("</div>");}});Y.prototype.init=function(){this._iBreakPointTablet=k.media._predefinedRangeSets[k.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=k.media._predefinedRangeSets[k.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=k.media._predefinedRangeSets[k.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(k.system.phone||Q('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if(k.system.tablet||Q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=this.getId();this._oIntervalTypeSelect=new S(i+"-IntType",{maxWidth:"15rem",ariaLabelledBy:i+"-SelDescr"});this._oIntervalTypeSelect.attachEvent("change",e1,this);this._oTodayButton=new B(i+"-Today",{text:this._oRB.getText("PLANNINGCALENDAR_TODAY"),type:G.Transparent});this._oTodayButton.attachEvent("press",this._handleTodayPress,this);this._oHeaderToolbar=new T(i+"-HeaderToolbar",{design:F.Transparent,content:[this._oIntervalTypeSelect,this._oTodayButton]});this._oCalendarHeader=new d1(i+"-CalHead",{toolbar:this._oHeaderToolbar});this._oInfoToolbar=new T(i+"-InfoToolbar",{height:"auto",design:F.Transparent,content:[this._oCalendarHeader,this._oTimeInterval]});var j=new p(i+"-Table",{sticky:[],infoToolbar:this._oInfoToolbar,mode:A.SingleSelectMaster,columns:[new q({styleClass:"sapMPlanCalRowHead"}),new q({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:_,demandPopin:true})],ariaLabelledBy:i+"-Descr"});j.attachEvent("selectionChange",u1,this);j.addDelegate({onBeforeRendering:function(){if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();}},onAfterRendering:function(){this._rowHeaderClickEvent=j.$().find(".sapMPlanCalRowHead > div.sapMLIB").click(function(F1){var G1=Q(F1.currentTarget).control(0),H1=q1(G1.getParent());this.fireRowHeaderClick({row:H1});}.bind(this));}},false,this);this.setAggregation("table",j,true);this.setStartDate(new Date());this._resizeProxy=Q.proxy(i1,this);this._fnCustomSortedAppointments=undefined;};Y.prototype.exit=function(){if(this._sResizeListener){l.deregister(this._sResizeListener);this._sResizeListener=undefined;}k.orientation.detachHandler(this._updateStickyHeader,this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var i=this.getAggregation("table");i.removeAllItems();Z.forEach(function(F1){if(this[F1]){this[F1]._oPlanningCalendar=undefined;this[F1].destroy();this[F1]=undefined;}},this);if(this._oViews){for(var j in this._oViews){this._oViews[j].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this.getToolbarContent().length==0&&this._oToolbar){this._oToolbar.destroy();this._oToolbar=undefined;}if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();this._rowHeaderClickEvent=null;}};Y.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;if((!this._oTimeInterval&&!this._oDateInterval&&!this._oMonthInterval&&!this._oWeekInterval&&!this._oOneMonthInterval)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}y1.call(this);if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._updateTodayButtonState();k.orientation.detachHandler(this._updateStickyHeader,this);this._bBeforeRendering=undefined;};Y.prototype.attachEvent=function(i,j,F1,G1){C.prototype.attachEvent.call(this,i,j,F1,G1);if(this.hasListeners("intervalSelect")){Z.forEach(function(H1){if(this[H1]){this[H1]._setAriaRole("button");}},this);}return this;};Y.prototype.detachEvent=function(i,j,F1){C.prototype.detachEvent.call(this,i,j,F1);if(!this.hasListeners("intervalSelect")){Z.forEach(function(G1){if(this[G1]){this[G1]._setAriaRole("gridcell");}},this);}return this;};Y.prototype._setAriaRole=function(i){if(this.hasListeners("intervalSelect")){i._setAriaRole("button");}else{i._setAriaRole("gridcell");}};Y.prototype._updateTodayButtonState=function(){if(this._oTodayButton){this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(new Date(),this.getViewKey()));}};Y.prototype._dateMatchesVisibleRange=function(i,j){var F1=this._getView(j,!this._bBeforeRendering);if(!F1){return false;}var G1=F1.getIntervalType(),H1=$[G1],I1=H1?this[H1.sInstanceName]:null,J1=false;if(I1&&I1._dateMatchesVisibleRange){J1=I1._dateMatchesVisibleRange(i);}return J1;};Y.prototype.onAfterRendering=function(i){i.size={width:this.getDomRef().offsetWidth};i1.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=l.register(this,this._resizeProxy);}if(k.system.phone&&this.getStickyHeader()){k.orientation.attachHandler(this._updateStickyHeader,this);}this._updateCurrentTimeVisualization(false);if(this.getHeight()){var j=this.getDomRef().querySelector("table");var F1=this.$().height()-this._oInfoToolbar.$().height()-this._oToolbar.$().height()+"px";j.style.height=F1;}};Y.prototype.setStartDate=function(i){var j,F1;if(!i){i=new Date();}else{a._checkJSDateObject(i);}if(this.getViewKey()===H.Week){j=a.getFirstDateOfWeek(a._createUniversalUTCDate(i,undefined,true));i.setTime(a._createLocalDate(j,true).getTime());}if(this.getViewKey()===H.OneMonth||this.getViewKey()===H.Month){F1=a.getFirstDateOfMonth(a._createUniversalUTCDate(i,undefined,true));i.setTime(a._createLocalDate(F1,true).getTime());}if(y(i,this.getStartDate())){this._updateTodayButtonState();return this;}var G1=i.getFullYear();a._checkYearInValidRange(G1);var H1=this.getMinDate();if(H1&&H1.getTime()>i.getTime()){L.warning("StartDate < minDate -> StartDate set to minDate",this);i=new Date(H1.getTime());}else{var I1=this.getMaxDate();if(I1&&I1.getTime()<i.getTime()){L.warning("StartDate > maxDate -> StartDate set to minDate",this);if(H1){i=new Date(H1.getTime());}else{i=new Date(1,0,1);i.setFullYear(1);}}}this.setProperty("startDate",i,true);Z.forEach(function(J1){if(this[J1]){this[J1].setStartDate(new Date(i.getTime()));}},this);this._setRowsStartDate(new Date(i.getTime()));if(this.getViewKey()===H.Week||this.getViewKey()===H.OneMonth){this._updateTodayButtonState();}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);}return this;};Y.prototype.setMinDate=function(i){if(y(i,this.getMinDate())){return this;}var j=this.getMaxDate();if(i){a._checkJSDateObject(i);var F1=i.getFullYear();a._checkYearInValidRange(F1);this.setProperty("minDate",i,true);this._bNoStartDateChange=true;Z.forEach(function(I1){if(this[I1]){this[I1].setMinDate(new Date(i.getTime()));}},this);if(j&&j.getTime()<i.getTime()){L.warning("minDate > maxDate -> maxDate set to end of the month",this);j=new Date(i.getTime());j.setMonth(j.getMonth()+1,0);j.setHours(23);j.setMinutes(59);j.setSeconds(59);j.setMilliseconds(0);this.setMaxDate(j);}this._bNoStartDateChange=undefined;var G1=this.getStartDate();if(G1&&G1.getTime()<i.getTime()){L.warning("StartDate < minDate -> StartDate set to minDate",this);G1=new Date(i.getTime());this.setStartDate(G1);}}else{this.setProperty("minDate",undefined,true);Z.forEach(function(I1){if(this[I1]){this[I1].setMinDate();}},this);}var H1=new Date();if(i&&H1.getTime()<i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||H1.getTime()<j.getTime()){this._oTodayButton.setVisible(true);}return this;};Y.prototype.setMaxDate=function(i){if(y(i,this.getMaxDate())){return this;}var j=this.getMinDate();if(i){a._checkJSDateObject(i);var F1=i.getFullYear();a._checkYearInValidRange(F1);this.setProperty("maxDate",i,true);this._bNoStartDateChange=true;Z.forEach(function(I1){if(this[I1]){this[I1].setMaxDate(new Date(i.getTime()));}},this);if(j&&j.getTime()>i.getTime()){L.warning("maxDate < minDate -> maxDate set to begin of the month",this);j=new Date(i.getTime());j.setDate(1);j.setHours(0);j.setMinutes(0);j.setSeconds(0);j.setMilliseconds(0);this.setMinDate(j);}this._bNoStartDateChange=undefined;var G1=this.getStartDate();if(G1&&G1.getTime()>i.getTime()){L.warning("StartDate > maxDate -> StartDate set to minDate",this);if(j){G1=new Date(j.getTime());}else{G1=new Date(1,0,1);G1.setFullYear(1);}this.setStartDate(G1);}}else{this.setProperty("maxDate",undefined,true);Z.forEach(function(I1){if(this[I1]){this[I1].setMaxDate();}},this);}var H1=new Date();if(i&&H1.getTime()>i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||H1.getTime()>j.getTime()){this._oTodayButton.setVisible(true);}return this;};Y.prototype.removeIntervalInstanceFromInfoToolbar=function(){var i=this._oInfoToolbar.getContent();i.forEach(function(j){if(j.isA(c1)){this._oInfoToolbar.removeContent(j);}}.bind(this));};Y.prototype.setViewKey=function(j){var F1,G1,H1,I1=this.getViewKey(),J1;this.setProperty("viewKey",j,true);this._oIntervalTypeSelect.setSelectedKey(j);this.removeIntervalInstanceFromInfoToolbar();if(j===H.Week||j===H.OneMonth||j===H.Month){G1=this.getStartDate();this.setStartDate(new Date(G1.getTime()));if(G1.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange();}}var K1=this.getStartDate();var L1=this.getMinDate();var M1=this.getMaxDate();var N1=this._getView(j,!this._bBeforeRendering);if(!N1){this._bCheckView=true;this.invalidate();}else{var O1=N1.getIntervalType();var P1=this._getIntervals(N1);this._bCheckView=false;switch(O1){case O.Hour:if(!this._oTimeInterval){this._oTimeInterval=new sap.ui.unified.CalendarTimeInterval(this.getId()+"-TimeInt",{startDate:new Date(K1.getTime()),items:P1,pickerPopup:true,legend:this.getLegend()});this._setAriaRole(this._oTimeInterval);this._oTimeInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oTimeInterval.attachEvent("select",this._handleCalendarSelect,this);this._oTimeInterval._oPlanningCalendar=this;this._oTimeInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(L1){this._oTimeInterval.setMinDate(new Date(L1.getTime()));}if(M1){this._oTimeInterval.setMaxDate(new Date(M1.getTime()));}}else if(this._oTimeInterval.getItems()!=P1){this._oTimeInterval.setItems(P1);}this._insertInterval(this._oTimeInterval);break;case O.Day:case O.Week:case O.OneMonth:H1=$[O1];F1=this[H1.sInstanceName];if(!F1){F1=new H1.oClass(this.getId()+H1.sIdSuffix,{startDate:new Date(K1.getTime()),days:P1,showDayNamesLine:this.getShowDayNamesLine(),pickerPopup:true,legend:this.getLegend(),showWeekNumbers:this.getShowWeekNumbers()});this._setAriaRole(F1);F1.attachEvent("startDateChange",this._handleStartDateChange,this);F1.attachEvent("select",this._handleCalendarSelect,this);if(j===H.OneMonth){F1._setRowsStartDate=this._setRowsStartDate.bind(this);}F1._oPlanningCalendar=this;F1.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(L1){F1.setMinDate(new Date(L1.getTime()));}if(M1){F1.setMaxDate(new Date(M1.getTime()));}}else if(F1.getDays()!==P1){F1.setDays(P1);}this._insertInterval(F1);this[H1.sInstanceName]=F1;break;case O.Month:if(!this._oMonthInterval){this._oMonthInterval=new sap.ui.unified.CalendarMonthInterval(this.getId()+"-MonthInt",{startDate:new Date(K1.getTime()),months:P1,pickerPopup:true,legend:this.getLegend()});this._setAriaRole(this._oMonthInterval);this._oMonthInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oMonthInterval.attachEvent("select",this._handleCalendarSelect,this);this._oMonthInterval._oPlanningCalendar=this;this._oMonthInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(L1){this._oMonthInterval.setMinDate(new Date(L1.getTime()));}if(M1){this._oMonthInterval.setMaxDate(new Date(M1.getTime()));}}else if(this._oMonthInterval.setMonths()!=P1){this._oMonthInterval.setMonths(P1);}this._insertInterval(this._oMonthInterval);break;default:throw new Error("Unknown IntervalType: "+O1+"; "+this);}var Q1=this.getRows();for(var i=0;i<Q1.length;i++){var R1=Q1[i];var S1=t1(R1);S1.setIntervalType(O1);S1.setIntervals(P1);S1.setShowSubIntervals(N1.getShowSubIntervals());}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);g1.call(this,this.getShowWeekNumbers(),this._viewAllowsWeekNumbers(j));h1.call(this,this.getShowDayNamesLine(),!!F1);}}if(this._oOneMonthInterval&&j===H.OneMonth){this._oOneMonthInterval._setDisplayMode(this._iSize);this._oOneMonthInterval._adjustSelectedDate(b.fromLocalJSDate(G1));if(this._iSize<2){this._setRowsStartDate(G1);}}else if(this._oOneMonthInterval&&I1===H.OneMonth&&this._oOneMonthInterval.getSelectedDates().length){J1=this._oOneMonthInterval.getSelectedDates()[0].getStartDate();if(J1){this.setStartDate(J1);}}this._updateTodayButtonState();return this;};Y.prototype._insertInterval=function(i){if(this._iSizeScreen>1){this._oInfoToolbar.addContent(i);}else{this._oInfoToolbar.insertContent(i,1);}};Y.prototype._viewAllowsWeekNumbers=function(i){var j=this._getView(i).getIntervalType(),F1=$[j];return!!F1&&!!F1.oClass.prototype.setShowWeekNumbers;};Y.prototype._viewAllowsDayNamesLine=function(i){var j=this._getView(i).getIntervalType(),F1=$[j];return!!F1&&!!F1.oClass.prototype.setShowDayNamesLine;};Y.prototype._getIntervalInstanceByViewKey=function(i){var j=this._getView(i).getIntervalType(),F1=$[j],G1;if(F1){G1=this[F1.sInstanceName];}return G1;};Y.prototype.setShowWeekNumbers=function(i){this.setProperty("showWeekNumbers",i,true);this._getViews().forEach(function(j){var F1=j.getKey(),G1=this._viewAllowsWeekNumbers(F1),H1=this._getIntervalInstanceByViewKey(F1);if(H1&&G1){this._getIntervalInstanceByViewKey(F1).setShowWeekNumbers(i);}if(this.getDomRef()&&this.getViewKey()===F1){g1.call(this,i,G1);}},this);return this;};Y.prototype.setShowIntervalHeaders=function(j){this.setProperty("showIntervalHeaders",j,true);var F1=this.getRows();for(var i=0;i<F1.length;i++){var G1=F1[i];t1(G1).setShowIntervalHeaders(j);}return this;};Y.prototype.setShowEmptyIntervalHeaders=function(j){this.setProperty("showEmptyIntervalHeaders",j,true);var F1=this.getRows();for(var i=0;i<F1.length;i++){var G1=F1[i];t1(G1).setShowEmptyIntervalHeaders(j);}return this;};Y.prototype.setGroupAppointmentsMode=function(j){this.setProperty("groupAppointmentsMode",j,true);var F1=this.getRows();for(var i=0;i<F1.length;i++){var G1=F1[i];t1(G1).setGroupAppointmentsMode(j);}return this;};Y.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var F1=this.getRows();for(var i=0;i<F1.length;i++){var G1=F1[i];t1(G1).setAppointmentsReducedHeight(j);}return this;};Y.prototype.setAppointmentsVisualization=function(j){this.setProperty("appointmentsVisualization",j,true);var F1=this.getRows();for(var i=0;i<F1.length;i++){var G1=F1[i];t1(G1).setAppointmentsVisualization(j);}return this;};Y.prototype.setShowRowHeaders=function(i){this.setProperty("showRowHeaders",i,true);var j=this.getAggregation("table");j.getColumns()[0].setVisible(i);this._toggleAppointmentsColumnPopinState(i);this.$().toggleClass("sapMPlanCalNoHead",!i);C1.call(this);D1.call(this);return this;};Y.prototype.setShowDayNamesLine=function(i){var j,F1,G1,H1=!!this.getDomRef(),I1=this.getViewKey();for(j in $){F1=$[j].sInstanceName;if(this[F1]){G1=this[F1];G1.setShowDayNamesLine(i);if(H1&&j===I1){h1.call(this,i,true);}}}return this.setProperty("showDayNamesLine",i,false);};Y.prototype.setStickyHeader=function(i){if(this.getStickyHeader()===i){return this;}this.setProperty("stickyHeader",i,true);if(k.system.phone){if(i){k.orientation.attachHandler(this._updateStickyHeader,this);}else{k.orientation.detachHandler(this._updateStickyHeader,this);}}this._updateStickyHeader();return this;};Y.prototype._updateStickyHeader=function(){var i=[],j=this.getStickyHeader(),F1=this.getViewKey()===H.OneMonth&&this._iSize<2,G1=j&&!k.system.phone&&!F1,H1=j&&!(k.system.phone&&k.orientation.landscape)&&!F1;if(this._oToolbar&&G1){i.push(sap.m.Sticky.HeaderToolbar);}if(this._oInfoToolbar&&H1){i.push(sap.m.Sticky.InfoToolbar);}this.getAggregation("table").setSticky(i);};Y.prototype.addRow=function(i){this.addAggregation("rows",i,true);this.getAggregation("table").addItem(this._createPlanningCalendarListItem(i));return this;};Y.prototype.insertRow=function(i,j){this.insertAggregation("rows",i,j);this.getAggregation("table").insertItem(this._createPlanningCalendarListItem(i),j,true);return this;};Y.prototype.removeRow=function(i){var j=this.removeAggregation("rows",i,true),F1=this.getAggregation("table");F1.removeItem(r1(j),true);this._handleRowRemoval(j);B1.call(this);D1.call(this);return j;};Y.prototype.removeAllRows=function(){var i=this.removeAllAggregation("rows",true),j=this.getAggregation("table");j.removeAllItems(true);i.forEach(this._handleRowRemoval,this);B1.call(this);D1.call(this);return i;};Y.prototype.destroyRows=function(){var i=this.destroyAggregation("rows",true);var j=this.getAggregation("table");j.destroyItems(true);B1.call(this);D1.call(this);return i;};Y.prototype.addToolbarContent=function(i){this.addAggregation("toolbarContent",i,true);v1.call(this);return this;};Y.prototype.insertToolbarContent=function(i,j){this.insertAggregation("toolbarContent",i,j);v1.call(this);return this;};Y.prototype.removeToolbarContent=function(i){var j=this.removeAggregation("toolbarContent",i,true);v1.call(this);return j;};Y.prototype.removeAllToolbarContent=function(){var i=this.removeAllAggregation("toolbarContent",true);v1.call(this);return i;};Y.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent",true);v1.call(this);return i;};Y.prototype.indexOfContent=function(i){return this.indexOfToolbarContent(i);};Y.prototype.setSingleSelection=function(i){this.setProperty("singleSelection",i,true);C1.call(this);D1.call(this);if(i){this.selectAllRows(false);}else{B1.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!i);return this;};Y.prototype.setNoDataText=function(i){this.setProperty("noDataText",i,true);var j=this.getAggregation("table");j.setNoDataText(i);return this;};Y.prototype.setLegend=function(j){this.setAssociation("legend",j,true);var F1=this.getRows(),G1=this.getLegend()&&sap.ui.getCore().byId(this.getLegend()),H1;for(var i=0;i<F1.length;i++){var I1=F1[i];t1(I1).setLegend(j);}Z.forEach(function(J1){if(this[J1]){this[J1].setLegend(j);}},this);if(G1){H1=new M(function(J1){this.invalidate();}.bind(this));H1.observe(G1,{destroy:true});}return this;};Y.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.addAriaLabelledBy(i);return this;};Y.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.removeAriaLabelledBy(i);return this;};Y.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var i=this.getAggregation("table");i.removeAllAriaLabelledBy();i.addAriaLabelledBy(this.getId()+"-Descr");return this;};Y.prototype.invalidate=function(i){var j=i&&i instanceof D;if(!this._bIsBeingDestroyed&&(this._bDateRangeChanged||j)){if(this.getDomRef()){var F1=this.getViewKey();var G1=this._getView(F1);var H1=G1.getIntervalType();switch(H1){case O.Hour:if(this._oTimeInterval){this._oTimeInterval.invalidate(arguments);}break;case O.Day:if(this._oDateInterval){this._oDateInterval.invalidate(arguments);}break;case O.Month:if(this._oMonthInterval){this._oMonthInterval.invalidate(arguments);}break;case O.OneMonth:if(this._oOneMonthInterval){this._oOneMonthInterval.invalidate(arguments);}break;case O.Week:if(this._oWeekInterval){this._oWeekInterval.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+H1+"; "+this);}}this._bDateRangeChanged=undefined;}else{if(i&&i instanceof sap.m.PlanningCalendarView){this._bCheckView=true;}C.prototype.invalidate.apply(this,arguments);}};Y.prototype.addSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.addAggregation.call(this,"specialDates",i);};Y.prototype.insertSpecialDate=function(i,j){this._bDateRangeChanged=true;return C.prototype.insertAggregation.call(this,"specialDates",i,j);};Y.prototype.removeSpecialDate=function(i){this._bDateRangeChanged=true;return C.prototype.removeAggregation.call(this,"specialDates",i);};Y.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;return this.removeAllAggregation("specialDates");};Y.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;return this.destroyAggregation("specialDates");};Y.prototype.removeAllViews=function(){this._bCheckView=true;var i=this.removeAllAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(a1[0]);}return i;};Y.prototype.destroyViews=function(){this._bCheckView=true;var i=this.destroyAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(a1[0]);}return i;};Y.prototype.getSelectedRows=function(){return this.getRows().filter(function(i){return i.getSelected();});};Y.prototype.selectAllRows=function(j){var F1=this.getRows();if(!(j&&this.getSingleSelection())){for(var i=0;i<F1.length;i++){var G1=F1[i];G1.setSelected(j);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(j);}}return this;};Y.prototype.onsaphomemodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var F1=j[0];var G1=new Q.Event("saphome");G1._bPlanningCalendar=true;t1(F1).onsaphome(G1);i.preventDefault();i.stopPropagation();}};Y.prototype.onsapendmodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var F1=j[j.length-1];var G1=new Q.Event("sapend");G1._bPlanningCalendar=true;t1(F1).onsapend(G1);i.preventDefault();i.stopPropagation();}};Y.prototype.setBuiltInViews=function(i){this.setProperty("builtInViews",i);this.setViewKey(this._getViews()[0].getKey());return this;};Y.prototype.removeView=function(i){var j=this.removeAggregation("views",i);if(!this.getViews().length){this.setViewKey(this._getViews()[0].getKey());}return j;};Y.prototype._getIntervals=function(i){var j=0;switch(this._iSize){case 0:j=i.getIntervalsS();break;case 1:j=i.getIntervalsM();break;default:j=i.getIntervalsL();break;}return j;};Y.prototype._getView=function(j,F1){var G1=this._getViews();var H1;for(var i=0;i<G1.length;i++){H1=G1[i];if(H1.getKey()!=j){H1=undefined;}else{break;}}if(!H1&&!F1){throw new Error("PlanningCalendarView with key "+j+"not assigned "+this);}return H1;};Y.prototype._changeStartDate=function(i){if(this._bNoStartDateChange){return;}this.setStartDate(new Date(i.getTime()));this.fireStartDateChange();};Y.prototype._updateCurrentTimeVisualization=function(j){if(this._sUpdateCurrentTime){clearTimeout(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(j){var F1=this.getRows();for(var i=0;i<F1.length;i++){var G1=F1[i];t1(G1).updateCurrentTimeVisualization();}}var H1=new Date();var I1=this.getStartDate();var J1=this.getViewKey();var K1=this._getView(J1);var L1=K1.getIntervalType();var M1=this._getIntervals(K1);var N1=0;var O1=0;var P1=0;switch(L1){case O.Hour:N1=60000;O1=I1.getTime()-3600000;P1=I1.getTime()+M1*3600000;break;case O.Day:case O.Week:case O.OneMonth:N1=1800000;O1=I1.getTime()-3600000;P1=I1.getTime()+M1*86400000;break;default:N1=-1;break;}if(H1.getTime()<=P1&&H1.getTime()>=O1&&N1>0){this._sUpdateCurrentTime=setTimeout(this['_updateCurrentTimeVisualization'].bind(this,true),N1);}};function e1(i){this.setViewKey(i.getParameter("selectedItem").getKey());this.fireViewChange();}Y.prototype._handleTodayPress=function(i){var j=new Date(),F1,G1=this.getViewKey();if(G1===H.OneMonth){F1=a.getFirstDateOfMonth(a._createUniversalUTCDate(j,undefined,true));this._oOneMonthInterval._adjustSelectedDate(b.fromLocalJSDate(j),false);j=a._createLocalDate(F1,true);}if(G1===H.Week){F1=this.getStartDate();j.setHours(F1.getHours());j.setMinutes(F1.getMinutes());j.setSeconds(F1.getSeconds());}this.setStartDate(j);this.fireStartDateChange();};Y.prototype._handleStartDateChange=function(i){var j=i.oSource.getStartDate();this._changeStartDate(j);};Y.prototype._handleCalendarSelect=function(i){var j=i.oSource.getSelectedDates();var F1=new Date(j[0].getStartDate());var G1=a._createUniversalUTCDate(F1,undefined,true);var H1=this.getViewKey();var I1=this._getView(H1);var J1=I1.getIntervalType();if(J1!==O.OneMonth||this._iSize>1){j[0].setStartDate();}switch(J1){case O.Hour:G1.setUTCHours(G1.getUTCHours()+1);break;case O.Day:case O.Week:G1.setUTCDate(G1.getUTCDate()+1);break;case O.OneMonth:if(this._iSize<2){var K1=new Date(F1.getTime());if(a.monthsDiffer(this.getStartDate(),F1)){this.setStartDate(F1);}this._setRowsStartDate(K1);this._oOneMonthInterval.getAggregation('month')[0]._focusDate(b.fromLocalJSDate(K1),true);}else if(a._isNextMonth(F1,this.getStartDate())){this._oOneMonthInterval._handleNext();return;}G1.setUTCDate(G1.getUTCDate()+1);break;case O.Month:G1.setUTCMonth(G1.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+J1+"; "+this);}G1.setUTCMilliseconds(G1.getUTCMilliseconds()-1);G1=a._createLocalDate(G1,true);this.fireIntervalSelect({startDate:F1,endDate:G1,subInterval:false,row:undefined});};function f1(i){var j=i.getParameter("startDate");var F1=this.getViewKey();var G1=this._getView(F1);var H1=G1.getIntervalType();if(H1===O.OneMonth&&a._isNextMonth(j,this.getStartDate())){this._oOneMonthInterval._handleNext();return;}var I1=i.getParameter("endDate");var J1=i.getParameter("subInterval");var K1=q1(i.oSource.getParent());this.fireIntervalSelect({startDate:j,endDate:I1,subInterval:J1,row:K1});}Y.prototype._applyContextualSettings=function(){return C.prototype._applyContextualSettings.call(this,{contextualWidth:this.$().width()});};function g1(i,j){this.$().toggleClass("sapMPlanCalWithWeekNumbers",i&&j);}function h1(i,j){this.$().toggleClass("sapMPlanCalWithDayNamesLine",i&&j);}function i1(j,F1){this._applyContextualSettings();if(j.size.width<=0){return;}var G1=this.getRows();var H1;var i=0;var I1=this._iSize;w1.call(this,j.size.width);if(I1!=this._iSize){x1.call(this,this._iSize);var J1=this.getViewKey();var K1=this._getView(J1);var L1=K1.getIntervalType();var M1=this._getIntervals(K1);for(i=0;i<G1.length;i++){H1=G1[i];var N1=t1(H1);if(M1!=N1.getIntervals()){N1.setIntervals(M1);}else{N1.handleResize();}}switch(L1){case O.Hour:if(this._oTimeInterval&&this._oTimeInterval.getItems()!=M1){this._oTimeInterval.setItems(M1);}break;case O.Day:if(this._oDateInterval&&this._oDateInterval.getDays()!=M1){this._oDateInterval.setDays(M1);}break;case O.Month:if(this._oMonthInterval&&this._oMonthInterval.getMonths()!=M1){this._oMonthInterval.setMonths(M1);}break;case O.Week:if(this._oWeekInterval&&this._oWeekInterval.getDays()!=M1){this._oWeekInterval.setDays(M1);}break;case O.OneMonth:if(this._oOneMonthInterval&&this._oOneMonthInterval.getDays()!=M1){this._oOneMonthInterval.setDays(M1);if(this._iSize>1){this._setRowsStartDate(new Date(this.getStartDate().getTime()));}}break;default:throw new Error("Unknown IntervalType: "+L1+"; "+this);}C1.call(this);}else if(!F1){for(i=0;i<G1.length;i++){H1=G1[i];t1(H1).handleResize();}}if(this._oOneMonthInterval){this._oOneMonthInterval._setDisplayMode(this._iSize);}if(this.getStickyHeader()){this._updateStickyHeader();}}function j1(F1){var G1=F1.getParameter("appointment"),H1=F1.getParameter("multiSelect"),I1=F1.getParameter("appointments"),J1=F1.getParameter("domRefId"),K1,L1,M1,N1,O1,i,j;if(!H1){L1=this.getRows();for(i=0;i<L1.length;i++){M1=L1[i];if(F1.oSource!=t1(M1)){N1=M1.getAppointments();for(j=0;j<N1.length;j++){O1=N1[j];O1.setSelected(false);}}}}K1={appointment:G1,appointments:I1,multiSelect:H1,domRefId:J1};this.fireAppointmentSelect(K1);}Y.prototype._setRowsStartDate=function(j){var F1=this.getRows(),G1,i;for(i=0;i<F1.length;i++){G1=F1[i];t1(G1).setStartDate(j);}};Y.prototype._toggleAppointmentsColumnPopinState=function(i){var j=this.getAggregation("table"),F1=j.getColumns()[1];F1.setDemandPopin(i);F1.setMinScreenWidth(i?_:"");};Y.prototype._getViews=function(){var i=this.getViews(),j=this.getBuiltInViews(),F1,G1=[],H1=H,I1=O;if(!this._oViews){this._oViews={};}if(j.length){G1=j;}else{G1=i.length?[]:a1;}F1=G1.map(function(K1){switch(K1){case H1.Hour:return this._oViews[H1.Hour]||(this._oViews[H1.Hour]=new sap.m.PlanningCalendarView(this.getId()+"-HourView",{key:H1.Hour,intervalType:I1.Hour,description:this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12}));case H1.Day:return this._oViews[H1.Day]||(this._oViews[H1.Day]=new sap.m.PlanningCalendarView(this.getId()+"-DayView",{key:H1.Day,intervalType:I1.Day,description:this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14}));case H1.Month:return this._oViews[H1.Month]||(this._oViews[H1.Month]=new sap.m.PlanningCalendarView(this.getId()+"-MonthView",{key:H1.Month,intervalType:I1.Month,description:this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12}));case H1.Week:return this._oViews[H1.Week]||(this._oViews[H1.Week]=new sap.m.PlanningCalendarView(this.getId()+"-WeekView",{key:H1.Week,intervalType:I1.Week,description:this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7}));case H1.OneMonth:return this._oViews[H1.OneMonth]||(this._oViews[H1.OneMonth]=new sap.m.PlanningCalendarView(this.getId()+"-OneMonthView",{key:H1.OneMonth,intervalType:I1.OneMonth,description:this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31}));default:L.error("Cannot get PlanningCalendar views. Invalid view key "+K1);break;}},this);for(var J1 in this._oViews){if(G1.indexOf(J1)<0){this._oViews[J1].destroy();delete this._oViews[J1];}}if(i.length){F1=F1.concat(i);}return F1;};Y.prototype.getSelectedAppointments=function(){var i=[];this.getRows().filter(function(j){i.push.apply(i,t1(j).aSelectedAppointments);});return i;};Y.prototype.setCustomAppointmentsSorterCallback=function(i){if(typeof i==="function"||i===null||i===undefined){this.getRows().forEach(function(j){t1(j)._setCustomAppointmentsSorterCallback(i);});this._fnCustomSortedAppointments=i;}else{L.warning("Your custom sort function won't be used, but the old one will be preserved.",this);}return this;};Y.prototype.getCustomAppointmentsSorterCallback=function(){return this._fnCustomSortedAppointments;};Y.prototype._onRowDeselectAppointment=function(){var F1=this.getRows();for(var i=0;i<F1.length;i++){var G1=t1(F1[i]).aSelectedAppointments;for(var j=0;j<G1.length;j++){var H1=sap.ui.getCore().byId(G1[j]);if(H1){H1.setProperty("selected",false,true);H1.$().removeClass("sapUiCalendarAppSel");}}t1(F1[i]).aSelectedAppointments=[];}};Y.prototype._updateRowTimeline=function(i){var j=t1(i),F1,G1,H1,I1;j.setNonWorkingDays(i.getNonWorkingDays());j.setNonWorkingHours(i.getNonWorkingHours());j.setStartDate(this.getStartDate());j.setShowIntervalHeaders(this.getShowIntervalHeaders());j.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());j.setGroupAppointmentsMode(this.getGroupAppointmentsMode());j.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());j.setLegend(this.getLegend());j.setAppointmentsVisualization(this.getAppointmentsVisualization());j.attachEvent("select",j1,this);j.attachEvent("startDateChange",this._handleStartDateChange,this);j.attachEvent("leaveRow",A1,this);j.attachEvent("intervalSelect",f1,this);B1.call(this);if(E1.call(this)){F1=this.getViewKey();G1=this._getView(F1);H1=G1.getIntervalType();I1=this._getIntervals(G1);j.setIntervalType(H1);j.setIntervals(I1);j.setShowSubIntervals(G1.getShowSubIntervals());}D1.call(this);if(this._fnCustomSortedAppointments){j._setCustomAppointmentsSorterCallback(this._fnCustomSortedAppointments);}};Y.prototype._observeRowChanges=function(i){var j=r1(i),F1=s1(i),G1=t1(i);var H1={destroy:function(){j.destroy();},change:{title:function(I1){F1.setProperty(I1.name,I1.current);},icon:function(I1){F1.setProperty(I1.name,I1.current);},text:function(I1){G1.toggleStyleClass("sapMPlanCalRowLarge",!!I1.current);F1.setProperty("description",I1.current);},enableAppointmentsDragAndDrop:function(I1){this._enableAppointmentsDragAndDrop(i);}.bind(this),enableAppointmentsResize:function(I1){this._enableAppointmentsResize(i);}.bind(this),enableAppointmentsCreate:function(I1){this._enableAppointmentsCreate(i);}.bind(this),nonWorkingDays:function(I1){G1.setProperty(I1.name,I1.current);},nonWorkingHours:function(I1){G1.setProperty(I1.name,I1.current);},selected:function(I1){B1.call(this);j.setProperty(I1.name,I1.current);}.bind(this),tooltip:function(I1){if(I1.mutation==="insert"){F1.setTooltip(I1.child);}else if(I1.mutation==="remove"){F1.setTooltip();}},intervalHeaders:function(I1){G1.invalidate();},appointments:function(I1){G1.invalidate();}}};new M(function(I1){if(I1.type==="destroy"){H1.destroy();}else if(H1.change[I1.name]){H1.change[I1.name](I1);}}).observe(i,{properties:["icon","text","title","nonWorkingDays","nonWorkingHours","selected","enableAppointmentsDragAndDrop","enableAppointmentsResize","enableAppointmentsCreate"],aggregations:["tooltip","appointments","intervalHeaders"],destroy:true});i.invalidate=function(I1){if(!I1||!(I1 instanceof c)){E.prototype.invalidate.apply(this,arguments);}else if(j){G1.invalidate(I1);}};i.applyFocusInfo=function(I1){G1.applyFocusInfo(I1);return this;};};Y.prototype._createPlanningCalendarListItem=function(i){var j,F1,G1;F1=new k1(i.getId()+"-Head",{icon:i.getIcon(),description:i.getText(),title:i.getTitle(),tooltip:i.getTooltip()});G1=new m1(i.getId()+"-CalRow",{checkResize:false,updateCurrentTime:false,ariaLabelledBy:F1.getId()});G1.getAppointments=function(){return i.getAppointments();};G1.getIntervalHeaders=function(){return i.getIntervalHeaders();};j=new o1(i.getId()+X,{cells:[F1,G1]});this._updateRowTimeline(i);this._observeRowChanges(i);this._enableAppointmentsDragAndDrop(i);this._enableAppointmentsResize(i);this._enableAppointmentsCreate(i);return j;};Y.prototype._handleRowRemoval=function(i){var j=t1(i);j.detachEvent("select",j1,this);j.detachEvent("startDateChange",this._handleStartDateChange,this);j.detachEvent("leaveRow",A1,this);j.detachEvent("intervalSelect",f1,this);if(this._fnCustomSortedAppointments){j._fnCustomSortedAppointments=undefined;}r1(i).destroy();};var k1=t.extend("PlanningCalendarRowHeader",{renderer:R.extend(v)});PlanningCalendarRowHeaderRenderer.openItemTag=function(i,j){i.write("<div");};PlanningCalendarRowHeaderRenderer.closeItemTag=function(i,j){i.write("</div>");};PlanningCalendarRowHeaderRenderer.renderTabIndex=function(i,j){};PlanningCalendarRowHeaderRenderer.getAriaRole=function(i,j){};var l1=R.extend(e);l1.getLegendItems=function(i){var j=[],F1,G1=i.getLegend();if(G1){F1=sap.ui.getCore().byId(G1);if(F1){j=F1.getAppointmentItems?F1.getAppointmentItems():F1.getItems();}else{L.error("PlanningCalendarLegend with id '"+G1+"' does not exist!",i);}}return j;};l1.renderBeforeAppointments=function(j,F1){var G1=q1(F1.getParent()),H1;if(!G1.getEnableAppointmentsDragAndDrop()&&!G1.getEnableAppointmentsResize()&&!G1.getEnableAppointmentsCreate()||F1._isOneMonthIntervalOnSmallSizes()){return;}H1=F1.getAggregation("_intervalPlaceholders");j.write("<div class=\"sapUiCalendarRowAppsOverlay\">");if(H1){for(var i=0;i<H1.length;i++){var I1=H1[i];I1.setWidth(100/H1.length+"%");j.renderControl(I1);}}j.write("</div>");};l1.renderResizeHandle=function(i,j,F1){if(!q1(j.getParent()).getEnableAppointmentsResize()||j._isOneMonthIntervalOnSmallSizes()||(F1._aAppointments&&F1._aAppointments.length>0)){return;}i.write("<span");i.addClass("sapUiCalendarAppResizeHandle");i.writeClasses();i.write(">");i.write("</span>");};l1.writeCustomAttributes=function(i,j){if(q1(j.getParent()).getEnableAppointmentsCreate()){i.writeAttribute("draggable","true");}};l1.renderInterval=function(j,F1,G1,H1,I1,J1,K1,L1,M1,N1,O1,P1,Q1){var R1=F1.getIntervalType();if(R1===O.Day||R1===O.Week||R1===O.OneMonth){var S1=q1(F1.getParent()),T1=S1.getParent(),U1=function(c2){return c2.getType()===z.NonWorking;},V1=S1.getSpecialDates().filter(U1),W1=T1.getSpecialDates().filter(U1),X1=F1.getStartDate(),Y1,Z1,$1,_1;if(W1&&V1){Y1=W1.concat(V1);}else if(V1){Y1=V1;}if(Y1&&Y1.length){var a2=function(c2){return c2===Z1.getDay();};Z1=new Date(X1.getTime());Z1.setHours(0,0,0);Z1.setDate(X1.getDate()+G1);for(var i=0;i<Y1.length;i++){if(Y1[i].getStartDate()){$1=new Date(Y1[i].getStartDate().getTime());}if(Y1[i].getEndDate()){_1=new Date(Y1[i].getEndDate().getTime());}else{_1=new Date(Y1[i].getStartDate().getTime());_1.setHours(23,59,59);}if(Z1.getTime()>=$1.getTime()&&Z1.getTime()<=_1.getTime()){var b2=J1.some(a2);if(!b2){j.addClass("sapUiCalendarRowAppsNoWork");}}}}}e.renderInterval(j,F1,G1,H1,I1,J1,K1,L1,M1,N1,O1,P1,Q1);};var m1=d.extend("PlanningCalendarRowTimeline",{metadata:{aggregations:{intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true},_intervalPlaceholders:{type:"IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},dnd:true},renderer:l1});m1.prototype._updatePlaceholders=function(){var j=this.getProperty("intervals");if(this.getIntervalType()===O.Hour){j*=2;}this.removeAllAggregation("_intervalPlaceholders");for(var i=0;i<j;i++){this.addAggregation("_intervalPlaceholders",new n1());}};m1.prototype.onBeforeRendering=function(){d.prototype.onBeforeRendering.call(this);this._updatePlaceholders();};m1.prototype.onmousedown=function(i){var j=i.target.classList;this._isResizeHandleMouseDownTarget=j.contains("sapUiCalendarAppResizeHandle");this._isRowAppsIntervalMouseDownTarget=j.contains("sapUiCalendarRowAppsInt");};m1.prototype._isResizingPerformed=function(){return this._isResizeHandleMouseDownTarget;};m1.prototype._isDraggingPerformed=function(){return!this._isResizeHandleMouseDownTarget&&!this._isRowAppsIntervalMouseDownTarget;};m1.prototype._isCreatingPerformed=function(){return this._isRowAppsIntervalMouseDownTarget;};var n1=C.extend("IntervalPlaceholder",{metadata:{properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addStyle("width",j.getWidth());i.writeStyles();i.addClass("sapUiCalendarRowAppsPlaceholder");i.writeClasses();i.write("></div>");}});var o1=r.extend("sap.m.internal.PlanningCalendarRowListItem",{renderer:s});o1.prototype.getHeader=function(){return this.getCells()[0];};o1.prototype.getTimeline=function(){return this.getCells()[1];};o1.prototype.getCustomData=function(){return q1(this).getCustomData();};Y.prototype._enableAppointmentsDragAndDrop=function(i){var j=t1(i),F1;if(i.getEnableAppointmentsDragAndDrop()){F1=i.getDragDropConfig().some(function(G1){return G1.getGroupName()===U;});if(!F1){this._addDragDropInfo(i,t1(i));}}else{i.getDragDropConfig().forEach(function(G1){if(G1.getGroupName()===U){i.removeDragDropConfig(G1);}});j.getDragDropConfig().forEach(function(G1){if(G1.getGroupName()===U){j.removeDragDropConfig(G1);}});}};Y.prototype._enableAppointmentsResize=function(i){var j=i.getEnableAppointmentsResize(),F1=this._getConfigFromDragDropConfigAggregation(i.getAggregation("dragDropConfig"),V),G1=this._getResizeConfig(i);if(j&&!F1){i.addAggregation("dragDropConfig",G1,true);}if(!j){i.removeAggregation("dragDropConfig",F1,true);}};Y.prototype._enableAppointmentsCreate=function(i){var j=i.getEnableAppointmentsCreate(),F1=t1(i),G1=this._getConfigFromDragDropConfigAggregation(F1.getAggregation("dragDropConfig"),W),H1=this._getAppointmentsCreateConfig(i);if(j&&!G1){F1.addAggregation("dragDropConfig",H1,true);}if(!j){F1.removeAggregation("dragDropConfig",G1,true);}};Y.prototype._addDragDropInfo=function(i,j){i.addDragDropConfig(new m({groupName:U,sourceAggregation:"appointments",dragStart:function(F1){var G1=function(){var H1=Q(".sapUiCalendarRowAppsOverlay");setTimeout(function(){H1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);Q(document).one("dragend",function(){H1.removeClass("sapUiCalendarRowAppsOverlayDragging");});};if(j._isOneMonthIntervalOnSmallSizes()||!j._isDraggingPerformed()){F1.preventDefault();return;}G1();}}));j.addDragDropConfig(new n({groupName:U,targetAggregation:"_intervalPlaceholders",dragEnter:function(F1){var G1=F1.getParameter("dragSession"),H1=G1.getDragControl(),I1=j.getIntervalType(),J1=j.getStartDate(),K1=j.indexOfAggregation("_intervalPlaceholders",G1.getDropControl()),L1=j.getId(),M1,N1=function(){var P1=Q(G1.getIndicator()),Q1=G1.getDropControl().getDomRef().getBoundingClientRect(),R1=sap.ui.getCore().byId(L1).getDomRef().getBoundingClientRect(),S1=G1.getDragControl().$().outerWidth(),T1=sap.ui.getCore().getConfiguration().getRTL(),U1=T1?Math.ceil(Q1.right)-R1.left:R1.right-Math.ceil(Q1.left);P1.css("min-width",(S1<U1)?S1:U1).css(T1?"border-left-width":"border-right-width",(S1>U1)?"0":"").css("margin-left",T1?-(P1.outerWidth()-parseFloat(P1.context.style.width)):"");};if(i.hasListeners("appointmentDragEnter")){if(I1===O.Hour){M1=this._calcNewHoursAppPos(J1,H1.getStartDate(),H1.getEndDate(),K1);}else if(I1===O.Day||I1===O.Week||(I1===O.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){M1=this._calcNewDaysAppPos(J1,H1.getStartDate(),H1.getEndDate(),K1);}else if(I1===O.Month){M1=this._calcNewMonthsAppPos(J1,H1.getStartDate(),H1.getEndDate(),K1);}var O1=i.fireAppointmentDragEnter({appointment:H1,startDate:M1.startDate,endDate:M1.endDate,calendarRow:q1(j.getParent())});if(!O1){F1.preventDefault();return;}}else if(t1(H1.getParent())!==j){F1.preventDefault();return;}if(j.getIntervalType()!==O.Hour){return;}if(!G1.getIndicator()){setTimeout(N1,0);}else{N1();}}.bind(this),drop:function(F1){var G1=F1.getParameter("dragSession"),H1=G1.getDragControl(),I1=j.getIntervalType(),J1=j.getStartDate(),K1=j.indexOfAggregation("_intervalPlaceholders",G1.getDropControl()),L1,M1=F1.getParameter("browserEvent"),N1=(M1.metaKey||M1.ctrlKey);if(I1===O.Hour){L1=this._calcNewHoursAppPos(J1,H1.getStartDate(),H1.getEndDate(),K1);}else if(I1===O.Day||I1===O.Week||(I1===O.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){L1=this._calcNewDaysAppPos(J1,H1.getStartDate(),H1.getEndDate(),K1);}else if(I1===O.Month){L1=this._calcNewMonthsAppPos(J1,H1.getStartDate(),H1.getEndDate(),K1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");if(H1.getStartDate().getTime()===L1.startDate.getTime()&&H1.getParent()===q1(j.getParent())){return;}i.fireAppointmentDrop({appointment:H1,startDate:L1.startDate,endDate:L1.endDate,calendarRow:q1(j.getParent()),copy:N1});}.bind(this)}));};Y.prototype._calcNewHoursAppPos=function(i,j,F1,G1){var H1=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours());H1=new Date(H1.getTime()+(G1*30*60*1000));return{startDate:H1,endDate:new Date(H1.getTime()+F1.getTime()-j.getTime())};};Y.prototype._calcNewDaysAppPos=function(i,j,F1,G1){var H1=new Date(i);H1.setDate(H1.getDate()+G1);H1=new Date(H1.getFullYear(),H1.getMonth(),H1.getDate(),j.getHours(),j.getMinutes(),j.getSeconds());return{startDate:H1,endDate:new Date(H1.getTime()+F1.getTime()-j.getTime())};};Y.prototype._calcNewMonthsAppPos=function(i,j,F1,G1){var H1=new Date(i);H1.setMonth(H1.getMonth()+G1);H1=new Date(H1.getFullYear(),H1.getMonth(),j.getDate(),j.getHours(),j.getMinutes(),j.getSeconds());return{startDate:H1,endDate:new Date(H1.getTime()+F1.getTime()-j.getTime())};};Y.prototype._getResizeConfig=function(i){var j=t1(i),F1=new o({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",targetElement:t1(i),dragStart:function(G1){if(!i.getEnableAppointmentsResize()||j._isOneMonthIntervalOnSmallSizes()||!j._isResizingPerformed()){G1.preventDefault();return;}var H1=G1.getParameter("dragSession"),I1=j.$().find(".sapUiCalendarRowAppsOverlay"),J1=Q(H1.getIndicator()),K1=H1.getDragControl().$();J1.addClass("sapUiDnDIndicatorHide");setTimeout(function(){I1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);Q(document).one("dragend",function(){I1.removeClass("sapUiCalendarRowAppsOverlayDragging");J1.removeClass("sapUiDnDIndicatorHide");K1.css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});});if(!k.browser.msie&&!k.browser.edge){G1.getParameter("browserEvent").dataTransfer.setDragImage(p1(),0,0);}},dragEnter:function(G1){var H1=G1.getParameter("dragSession"),I1=this.getTargetElement(),J1=function(){var N1=Q(H1.getIndicator());N1.addClass("sapUiDnDIndicatorHide");},K1=H1.getDropControl().getDomRef().getBoundingClientRect(),L1=sap.ui.getCore().byId(I1).getDomRef().getBoundingClientRect(),M1={width:K1.left+K1.width-(H1.getDragControl().$().position().left+L1.left),"min-width":Math.min(H1.getDragControl().$().outerWidth(),H1.getDropControl().$().outerWidth()),"z-index":1,opacity:0.8};H1.getDragControl().$().css(M1);if(!H1.getIndicator()){setTimeout(J1,0);}else{J1();}},drop:function(G1){var j=t1(i),H1=G1.getParameter("dragSession"),I1=H1.getDragControl(),J1=j.getIntervalType(),K1=j.getStartDate(),L1=j.indexOfAggregation("_intervalPlaceholders",H1.getDropControl()),M1;if(J1===O.Hour){M1=this._calcResizeNewHoursAppPos(K1,I1.getStartDate(),I1.getEndDate(),L1);}else if(J1===O.Day||J1===O.Week||(J1===O.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){M1=this._calcResizeNewDaysAppPos(K1,I1.getStartDate(),I1.getEndDate(),L1);}else if(J1===O.Month){M1=this._calcResizeNewMonthsAppPos(K1,I1.getStartDate(),I1.getEndDate(),L1);}j.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");Q(H1.getIndicator()).removeClass("sapUiDnDIndicatorHide");I1.$().css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});if(I1.getEndDate().getTime()===M1.endDate.getTime()){return;}i.fireAppointmentResize({appointment:I1,startDate:M1.startDate,endDate:M1.endDate,calendarRow:i});}.bind(this)});F1.setProperty("groupName",V);return F1;};Y.prototype._calcResizeNewHoursAppPos=function(i,j,F1,G1){var H1=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours()),I1=30*60*1000;H1=new Date(H1.getTime()+((G1+1)*I1));if(H1.getTime()<=j.getTime()){H1=new Date(j.getTime()+I1);}return{startDate:j,endDate:H1};};Y.prototype._calcResizeNewDaysAppPos=function(i,j,F1,G1){var H1=new Date(i),I1=H1.getDate()+G1+1;if(I1<=j.getDate()){I1=j.getDate()+1;}H1.setDate(I1);H1=new Date(H1.getFullYear(),H1.getMonth(),H1.getDate());return{startDate:j,endDate:H1};};Y.prototype._calcResizeNewMonthsAppPos=function(i,j,F1,G1){var H1=new Date(i),I1=H1.getMonth()+G1+1;if(I1<=j.getMonth()){I1=j.getMonth()+1;}H1.setMonth(I1);H1=new Date(H1.getFullYear(),H1.getMonth(),1);return{startDate:j,endDate:H1};};Y.prototype._calcCreateNewAppHours=function(i,j,F1){var G1=30*60*1000,H1,I1;if(j<=F1){H1=new Date(i.getTime()+(j*G1));I1=new Date(i.getTime()+((F1+1)*G1));}else{H1=new Date(i.getTime()+(F1*G1));I1=new Date(i.getTime()+(j*G1));}return{startDate:H1,endDate:I1};};Y.prototype._calcCreateNewAppDays=function(i,j,F1){var G1=new Date(i),H1=new Date(i);if(j<=F1){G1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+j);H1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+F1+1);}else{G1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+F1);H1=new Date(i.getFullYear(),i.getMonth(),i.getDate()+j);}return{startDate:G1,endDate:H1};};Y.prototype._calcCreateNewAppMonths=function(i,j,F1){var G1=new Date(i),H1=new Date(i);if(j<=F1){G1=new Date(i.getFullYear(),i.getMonth()+j,1);H1=new Date(i.getFullYear(),i.getMonth()+F1+1,1);}else{G1=new Date(i.getFullYear(),i.getMonth()+F1,1);H1=new Date(i.getFullYear(),i.getMonth()+j,1);}return{startDate:G1,endDate:H1};};Y.prototype._getConfigFromDragDropConfigAggregation=function(j,F1){var G1=j,H1=G1&&G1.length;for(var i=0;i<H1;i++){if(G1[i].getGroupName()===F1){return G1[i];}}return null;};Y.prototype._getAppointmentsCreateConfig=function(i){var j=t1(i),F1=new o({targetAggregation:"_intervalPlaceholders",dragStart:function(G1){if(!i.getEnableAppointmentsCreate()||j._isOneMonthIntervalOnSmallSizes()||!j._isCreatingPerformed()){G1.preventDefault();return;}var H1=G1.getParameter("dragSession"),I1=j.$().find(".sapUiCalendarRowAppsOverlay"),J1=Q(H1.getIndicator());setTimeout(function(){I1.addClass("sapUiCalendarRowAppsOverlayDragging");},0);Q(document).one("dragend",function(){I1.removeClass("sapUiCalendarRowAppsOverlayDragging");J1.html("");J1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");});if(!k.browser.msie&&!k.browser.edge){G1.getParameter("browserEvent").dataTransfer.setDragImage(p1(),0,0);}},dragEnter:function(G1){var H1=G1.getParameter("dragSession"),I1=H1.getDropControl().getDomRef().getBoundingClientRect(),J1=function(){var L1=Q(H1.getIndicator());L1.addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");};var K1=H1.getData("text")?parseFloat(H1.getData("text").split("|")[0]):0;if(K1){if(K1<=I1.left){H1.setIndicatorConfig({left:K1,width:Math.max((I1.left+I1.width-K1),I1.width)});}else{H1.setIndicatorConfig({left:I1.left,width:K1-I1.left});}}else{H1.setData("text",I1.left+"|"+j.indexOfAggregation("_intervalPlaceholders",H1.getDropControl()));}if(!H1.getIndicator()){setTimeout(J1,0);}else{J1();}},drop:function(G1){var H1=G1.getParameter("dragSession"),I1=Q(H1.getIndicator()),J1=j.getIntervalType(),K1=t1(i).getStartDate(),L1=parseInt(H1.getData("text").split("|")[1],10),M1=j.indexOfAggregation("_intervalPlaceholders",H1.getDropControl()),N1;if(J1===O.Hour){N1=this._calcCreateNewAppHours(K1,L1,M1);}else if(J1===O.Day||J1===O.Week||(J1===O.OneMonth&&!j._isOneMonthIntervalOnSmallSizes())){N1=this._calcCreateNewAppDays(K1,L1,M1);}else if(J1===O.Month){N1=this._calcCreateNewAppMonths(K1,L1,M1);}i.fireAppointmentCreate({startDate:N1.startDate,endDate:N1.endDate,calendarRow:i});I1.html("");I1.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");}.bind(this)});F1.setProperty("groupName",W);return F1;};function p1(){var i=Q("<span></span>").addClass("sapUiCalAppResizeGhost");i.appendTo(document.body);setTimeout(function(){i.remove();},0);return i.get(0);}function q1(i){var j=i.getId();return sap.ui.getCore().byId(j.substring(0,j.indexOf(X)));}function r1(i){return sap.ui.getCore().byId(i.getId()+X);}function s1(i){var j=r1(i);return j?j.getHeader():null;}function t1(i){var j=r1(i);return j?j.getTimeline():null;}function u1(j){var F1=[];var G1=this.getRows();for(var i=0;i<G1.length;i++){var H1=G1[i];var I1=r1(H1);var J1=I1.getSelected();if(H1.getSelected()!=J1){H1.setProperty("selected",J1,true);F1.push(H1);}}if(!this.getSingleSelection()){B1.call(this);}if(F1.length>0){this.fireRowSelectionChange({rows:F1});}}function v1(){var i=this.getAggregation("table");if(this.getToolbarContent().length>0){if(!this._oToolbar){this._oToolbar=new sap.m.OverflowToolbar(this.getId()+"-Toolbar",{design:F.Transpaent});this._oToolbar._oPlanningCalendar=this;this._oToolbar.getContent=function(){return this._oPlanningCalendar.getToolbarContent();};}if(!i.getHeaderToolbar()){i.setHeaderToolbar(this._oToolbar);}}else if(i.getHeaderToolbar()){i.setHeaderToolbar();}this._oToolbar.invalidate();}function w1(i){if(i<this._iBreakPointTablet){this._iSize=0;}else if(i<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(i<b1.PHONE){this._iSizeScreen=0;}else if(i<b1.TABLET){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}function x1(j){var F1='sapMSize'+j,G1=this.$(),i,H1;if(G1){for(i=0;i<3;i++){H1='sapMSize'+i;if(H1===F1){G1.addClass(H1);}else{G1.removeClass(H1);}}}}function y1(){var j=this._getViews();this._oIntervalTypeSelect.destroyItems();var i;var F1;for(i=0;i<j.length;i++){var G1=j[i];F1=new I(this.getId()+"-"+i,{key:G1.getKey(),text:G1.getDescription(),tooltip:G1.getTooltip()});this._oIntervalTypeSelect.addItem(F1);}this._oIntervalTypeSelect.setVisible(!(j.length===1));}function z1(i){var j=i.getParameter("selected");var F1=this.getRows();if(j){F1=this.getRows().filter(function(G1){return!G1.getSelected();});}this.selectAllRows(j);this.fireRowSelectionChange({rows:F1});}function A1(j){var F1=j.oSource;var G1=j.getParameter("type");var H1=this.getRows();var I1;var J1;var K1;var L1;var i=0;var M1=0;var N1;for(i=0;i<H1.length;i++){I1=H1[i];if(t1(I1)==F1){M1=i;break;}}switch(G1){case"sapup":K1=F1.getFocusedAppointment();L1=K1.getStartDate();if(M1>0){M1--;}J1=H1[M1];t1(J1).focusNearestAppointment(L1);break;case"sapdown":K1=F1.getFocusedAppointment();L1=K1.getStartDate();if(M1<H1.length-1){M1++;}J1=H1[M1];t1(J1).focusNearestAppointment(L1);break;case"saphome":if(M1>0){J1=H1[0];N1=new Q.Event(G1);N1._bPlanningCalendar=true;t1(J1).onsaphome(N1);}break;case"sapend":if(M1<H1.length-1){J1=H1[H1.length-1];N1=new Q.Event(G1);N1._bPlanningCalendar=true;t1(J1).onsapend(N1);}break;default:break;}}function B1(){if(this._oSelectAllCheckBox){var i=this.getRows();var j=this.getSelectedRows();if(i.length==j.length&&j.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}function C1(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new sap.m.CheckBox(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",z1,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}function D1(){var i=this.getAggregation("table");var j=i.getMode();var F1;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){F1=A.None;}else{F1=A.SingleSelectMaster;}}else{F1=A.MultiSelect;}if(j!=F1){i.setMode(F1);}}function E1(){return this._oTimeInterval||this._oDateInterval||this._oMonthInterval||this._oWeekInterval||this._oOneMonthInterval;}return Y;});
