/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./ResponsivePopover","./Button","./Toolbar","./ToolbarSpacer","./Bar","./List","./StandardListItem","./library","sap/ui/core/Control","sap/ui/core/IconPool","./SegmentedButton","./Page","./NavContainer","./ViewSettingsItem","sap/ui/base/ManagedObject","sap/ui/Device","sap/ui/core/InvisibleText","./ViewSettingsPopoverRenderer","sap/base/Log"],function(R,B,T,a,b,L,S,l,C,I,c,P,N,V,M,D,d,e,f){"use strict";var g=l.VerticalPlacementType;var h=l.ListType;var k=l.ListMode;var m='-toolbar';var n='-segmented';var o='-listitem';var p='-group';var q='-filter';var r='-sort';var F='-filterdetailItem';var s='-navContainer';var t='-mainPage';var u='-detailspage';var v='-backbutton';var w='-title';var x='-searchfield';var y='-selectall';var z='-custom-button';var A=C.extend("sap.m.ViewSettingsPopover",{metadata:{library:"sap.m",aggregations:{sortItems:{type:"sap.ui.core.Item",multiple:true,singularName:"sortItem"},filterItems:{type:"sap.ui.core.Item",multiple:true,singularName:"filterItem"},filterDetailItems:{type:"sap.ui.core.Item",multiple:true,singularName:"filterDetailItem"},groupItems:{type:"sap.ui.core.Item",multiple:true,singularName:"groupItem"},customTabs:{type:"sap.m.ViewSettingsCustomTab",multiple:true,singularName:"customTab",bindable:"bindable"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},sortSelected:{allowPreventDefault:true,parameters:{items:{type:"array"}}},filterSelected:{allowPreventDefault:true,parameters:{items:{type:"array"}}},groupSelected:{allowPreventDefault:true,parameters:{items:{type:"array"}}},afterFilterDetailPageOpened:{parameters:{parentFilterItem:{type:"sap.m.ViewSettingsFilterItem"}}}}},constructor:function(i,j){this._stashedItems={};if(!j&&i&&typeof i==='object'){j=i;}this._stashItems(j);if(j&&Array.isArray(j['sortItems'])){j['sortItems']=null;}if(j&&Array.isArray(j['filterItems'])){j['filterItems']=null;}if(j&&Array.isArray(j['groupItems'])){j['groupItems']=null;}M.prototype.constructor.apply(this,arguments);this._getPopover().addContent(this._getNavContainer());this._addStashedItems();}});A.prototype.init=function(){this._tabMap={sort:'sort',filter:'filter',filterDetail:'filterDetail',group:'group'};};A.prototype.openBy=function(i,j){var G=this._getPopover(i),H=this._determinePageToOpen();G.openBy(i);if(H){if(D.system.phone){this._showContentFor(H);}else{this._removeSegmentedButtonSelection();if(j){this._getPopover().setContentWidth(j);}else{this._adjustInitialWidth();}}}this._initialHeight=this._getPopover().getContentHeight();if(this._getSegmentedButton().getItems()&&this._getSegmentedButton().getItems().length===1&&H){this._showContentFor(H);}if(G.getAriaLabelledBy()&&G.getAriaLabelledBy().indexOf(this._getPopoverAriaLabel())===-1){G.addAriaLabelledBy(this._getPopoverAriaLabel());}};A.prototype._removeSegmentedButtonSelection=function(){this._getSegmentedButton().setProperty('selectedKey','',true).removeAllAssociation('selectedButton',true);this._getSegmentedButton().setAssociation("selectedButton","no_selected_button",true);this._getSegmentedButton().getButtons().forEach(function(i){i.$().removeClass("sapMSegBBtnSel").attr("aria-checked",false);});};A.prototype.toggle=function(i){if(this.isOpen()){this.close();}else{this.openBy(i);}return this;};A.prototype.isOpen=function(){return this._getPopover().isOpen();};A.prototype.close=function(){this._getPopover().close();this._cleanAfterClose();return this;};A.prototype._determinePageToOpen=function(){var i,j,G,H,J,K,O,Q,U=this.getCustomTabs();for(G in this._tabMap){H=this._tabMap[G];H=H.slice(0,1).toUpperCase()+H.slice(1);J=this['_get'+H+'List']().getItems();if(J.length===1){return;}else if(J.length>1){return this._tabMap[G];}}if(U){K=this._getSegmentedButton().getItems();for(i=0;i<U.length;i++){O=U[i];Q=this.getId()+O.getId()+z;if(!this._isEmptyCustomTab(O)){for(j=0;j<K.length;j++){if(Q===K[j].getId()){return O.getId();}}}}}return this._tabMap['sort'];};A.prototype._removeFooter=function(){if(this._getPopover()._oFooter){this._getPopover()._oFooter.destroy();this._getPopover()._oFooter=null;}this._getPopover().destroyAggregation('beginButton');this._getPopover().destroyAggregation('endButton');};A.prototype._showContentFor=function(i,j,G){var H=sap.ui.getCore().byId(this._getPopoverAriaLabel()),J;this._getPopover().setContentHeight('300px');this._getPopover().setContentWidth('300px');this._removePageContents(i);this._addPageContents(i);if(i===this._tabMap['filterDetail']){J=this._getText('VIEWSETTINGS_TITLE_FILTERBY')+this._updateTitleText(j.getTitle(),true);this._goToDetailsPage(j,G);}else{if(i in this._tabMap){J=this._updateTitleText(i);if(i===this._tabMap['filter']){this._updateFilterListItemsCount();}}this._goToMainPage();}H.setText(J);this._getSegmentedButton().setSelectedKey(i);this._currentPageId=i;};A.prototype._updateTitleText=function(i,j){var G,H=i;if(!j){G=i;if(G=='filterDetail'){G='filter';}G="VIEWSETTINGS_TITLE_"+G.toUpperCase();H=this._getText(G);}if(j&&this._getDetailsPage().getHeaderContent()[0].getContentMiddle()){this._getDetailsPage().getHeaderContent()[0].getContentMiddle()[0].setText(H);}else{this._getTitle().setText(H);}return H;};A.prototype._goToDetailsPage=function(i,j){var G=this._findViewSettingsItemFromListItem(i).getMultiSelect();if(G){this._getSearchField().setValue('');this._getDetailsPage().insertAggregation('content',new T({content:[this._getSearchField().addStyleClass('sapMVSDFilterSearchField'),this._getShowSelectedOnlyButton()]}),0);this._getFilterDetailList().setHeaderToolbar(new T({content:[this._getSelectAllCheckbox(this._findViewSettingsItemFromListItem(i).getItems(),this._getFilterDetailList())]}).addStyleClass('sapMVSDFilterHeaderToolbar'));}else{this._getFilterDetailList().removeAllAggregation('headerToolbar');}this._updateFilterDetailListFor(i);this._navigateToPage('Details',j);this._addFooterButtons();this._updateSelectAllCheckBoxState();if(D.system.phone){this._hideToolbarButtons();}this._lastViewedFilterParent=i;this._oPreviousSelectedFilters={selectedItemIds:this._getFilterDetailList().getSelectedItems().map(function(H){return H.getId();})};this.fireAfterFilterDetailPageOpened({parentFilterItem:i});};A.prototype._getShowSelectedOnlyButton=function(){var i=false;if(!this._oShowSelectedOnlyButton){this._oShowSelectedOnlyButton=new B({icon:I.getIconURI("multiselect-all"),tooltip:this._getText('SHOW_SELECTED_ONLY'),press:function(j){i=!i;if(i){j.getSource().$("inner").addClass('sapMBtnActive');}this._getFilterDetailList().getItems().forEach(function(G){if(i){if(!G.getSelected()){G.setVisible(false);}}else if(!i){this._filterItemsBy(this._getSearchField().getValue());}},this);this._updateSelectAllCheckBoxState();}.bind(this)});}return this._oShowSelectedOnlyButton;};A.prototype._updateSelectAllCheckBoxState=function(){var j=sap.ui.getCore().byId(this.getId()+y),G=this._getFilterDetailList().getItems()||[],H=true,J=0,i;for(i=0;i<G.length;i++){if(G[i].getVisible()){J++;if(!G[i].getSelected()){H=false;}}}if(j){j.setSelected(H&&J>0);}};A.prototype._addFooterButtons=function(){var i=new B({text:this._getText("VIEWSETTINGS_ACCEPT"),press:this._confirmFilterDetail.bind(this)}),j=new B({text:this._getText("VIEWSETTINGS_CANCEL"),press:this._cancel.bind(this)});this._getPopover().setBeginButton(i);this._getPopover().setEndButton(j);};A.prototype._confirmFilterDetail=function(){var i=this._getFilterDetailList().getItems().filter(function(j){return j.getSelected();});this.fireFilterSelected({items:i.map(function(j){return this._findViewSettingsItemFromListItem(j);}.bind(this))});this.close();};A.prototype._cancel=function(){this._restorePreviousState();this._updateFilterListItemsCount();this.close();};A.prototype._restorePreviousState=function(){var j;if(this._oPreviousSelectedFilters){j=function(G,H,J){var i;for(i=0;i<G.length;i++){if(H.getId()===G[i]){J.setProperty('selected',true,true);break;}}};this._getFilterDetailList().getItems().forEach(function(i){var G=this._findViewSettingsItemFromListItem(i);G.setProperty('selected',false,true);j(this._oPreviousSelectedFilters.selectedItemIds,i,G);},this);this._updateSelectAllCheckBoxState();}};A.prototype._hideToolbarButtons=function(){this._getPopover().setShowHeader(false);setTimeout(function(){if(this._getPopover().getAggregation('_popup')._internalHeader){this._getPopover().getAggregation('_popup')._internalHeader.$().hide();}}.bind(this),0);};A.prototype._goToMainPage=function(){this._getPopover().setShowHeader(true);this._getPopover().setCustomHeader(this._getToolbar());this._oPreviousSelectedFilters=null;this._navigateToPage('Main');};A.prototype._adjustInitialWidth=function(){var i,j,G,H,J=this._getSegmentedButton(),K=J&&J.getButtons();if(!K||!K[0]){return;}i=K[0].$().width();j=parseInt(K[0].$().css('margin-right'),10);G=K.length;if(l._bSizeCompact||!!document.querySelector('.sapUiSizeCompact')){i=i*2;}H=(i+j)*(G+1.6);this._getPopover().setContentWidth(H+"px");};A.prototype._navigateToPage=function(i,j){var G;if(this._getNavContainer().getCurrentPage().getId()!==this['_get'+i+'PageId']()){if(i==='Details'){if(j){this._getNavContainer().to(this['_get'+i+'Page'](),'show');G=sap.ui.getCore().byId(this.getId()+v);G&&G.destroy();G=null;}else{setTimeout(this._getNavContainer()["to"].bind(this._getNavContainer(),this['_get'+i+'Page'](),"slide"),0);}}else{setTimeout(this._getNavContainer()['back'].bind(this._getNavContainer()),0);}}this._getNavContainer().attachEventOnce("afterNavigate",function(){if(this._currentPageId!==this._tabMap['filterDetail']){this._removeFooter();if(D.system.desktop&&this._lastViewedFilterParent&&this._lastViewedFilterParent.getFocusDomRef()){this._lastViewedFilterParent.getFocusDomRef().focus();}}else{if(D.system.desktop&&this._getFilterDetailList().getItems()[0]&&this._getFilterDetailList().getItems()[0].getFocusDomRef()){this._getFilterDetailList().getItems()[0].getFocusDomRef().focus();}}}.bind(this));};A.prototype._updateFilterListItemsCount=function(){var i,j,G=this._getFilterList().getItems();G.forEach(function(H){if(H.getId().indexOf('nofiltering')===-1){j=this._findViewSettingsItemFromListItem(H);if(j instanceof sap.m.ViewSettingsCustomItem){i=j.getFilterCount();}else if(j instanceof sap.m.ViewSettingsFilterItem){i=j.getItems().filter(function(J){return J.getSelected();}).length;}H.setCounter(i);}},this);};A.prototype._updateFilterDetailListFor=function(i){var j=this._findViewSettingsItemFromListItem(i).getMultiSelect();var G=sap.ui.getCore().byId(i.getId().split(o).shift());var H=G&&G.getItems()||[];var J=this._getFilterDetailList();J.destroyAggregation("items");if(j){J.setIncludeItemInSelection(true);J.setMode(k.MultiSelect);}else{J.setMode(k.SingleSelectLeft);}H.forEach(function(K){J.addItem(new S({id:K.getId()+F,title:K.getText(),type:h.Active,selected:K.getSelected()}));},this);};A.prototype._removePageContents=function(i){var j,G,H,J,K='_getMainPage';if(i==='filterDetail'){K='_getDetailsPage';}H=this[K]().getContent();J=H[0];for(j in this._tabMap){G=this._tabMap[j];if(J){if(J.getId()===G+'list'){this['_'+G+'List']=J;}}}if(!(i in this._tabMap)||E.call(this)){this.getCustomTabs().forEach(function(O){if(this._currentPageId===O.getId()){H.forEach(function(Q){O.addAggregation('content',Q,true);});}},this);}this[K]().removeAllContent();};A.prototype._addPageContents=function(i){var j,G,H,J=this.getCustomTabs(),K='_getMainPage';if(i==='filterDetail'){K='_getDetailsPage';}for(j in this._tabMap){G=this._tabMap[j];if(G===i){G=G.slice(0,1).toUpperCase()+G.slice(1);H=this['_get'+G+'List']();this[K]().addContent(H);}}if(!(i in this._tabMap)){J.forEach(function(O){if(O.getId()===i){O.getContent().forEach(function(Q){this[K]().addContent(Q);},this);}},this);}};A.prototype._stashItems=function(i){var j=['sort','filter','group'];j.forEach(function(G){if(i&&Array.isArray(i[G+'Items'])){this._stashedItems[G]=i[G+'Items'];}},this);};A.prototype._addStashedItems=function(i){var j,G,H,J;for(j in this._tabMap){var J=this._tabMap[j];G=this._stashedItems[J];for(H in G){var K=G[H];this.addAggregation(J+'Items',K);}}};A.prototype._handleBack=function(i){if(this._currentPageId==='filterDetail'){this._showContentFor('filter');}};A.prototype._getSelectAllCheckbox=function(i,j){var G=sap.ui.getCore().byId(this.getId()+y);if(G){return G;}return new sap.m.CheckBox({id:this.getId()+y,text:'Select All',selected:i&&i.every(function(H){return H&&H.getSelected();}),select:function(H){var J=H.getParameter('selected');j.getItems().filter(function(K){return K.getVisible();}).forEach(function(K){var O=this._findViewSettingsItemFromListItem(K);O.setProperty('selected',J,true);}.bind(this));this._toggleRemoveFilterItem();}.bind(this)});};A.prototype._createList=function(i){var j,G=i.slice(0,1).toUpperCase()+i.slice(1),H=new L({id:this.getId()+'-'+i+'list',itemPress:function(J){j=this._findViewSettingsItemFromListItem(J.getParameter('listItem'));if(i==='group'||i==='sort'){this['fire'+G+'Selected']({items:[j]});this.close();}}.bind(this),selectionChange:function(J){var K;var O;var Q=[];this._updateSelectAllCheckBoxState();j=this._findViewSettingsItemFromListItem(J.getParameter('listItem'));j.setProperty('selected',J.getParameter('selected'),true);if(H.getMode()!==k.MultiSelect){K=this.getFilterItems();if(K){K.forEach(function(U){O=U.getItems();if(O){Q=Q.concat(O);}});}Q.forEach(function(U){if(U.getParent().getId()===j.getParent().getId()&&U.getSelected(true)&&U.getId()!==j.getId()){U.setProperty('selected',false,true);}});}if(i==='filterDetail'){G='Filter';}else{this['fire'+G+'Selected']({items:[j]});this.close();}switch(i){case'group':this._getGroupList().addItem(this._getRemoveGroupingItem());break;}}.bind(this)});if(i!=='filter'){H.setMode(k.SingleSelectMaster);}this['_'+i+'List']=H;};A.prototype._getRemoveGroupingItem=function(){if(!this._removeGroupingItem){this._removeGroupingItem=new S({id:this.getId()+'-nogrouping',title:this._getText('NO_GROUPING'),type:h.Active});}return this._removeGroupingItem;};A.prototype._getRemoveFilterItem=function(){if(!this._removeFilteringItem){this._removeFilteringItem=new S({id:this.getId()+'-nofiltering',title:this._getText('REMOVE_FILTER'),type:h.Active,press:function(){this.getFilterItems().forEach(function(i){i.getItems().forEach(function(j){j.setProperty('selected',false,true);});});this.close();this._removeFilteringItem.destroy();this._removeFilteringItem=null;}.bind(this)});}return this._removeFilteringItem;};A.prototype._getTabButtonItem=function(i){var j=this.getId()+i.getId()+z,G=sap.ui.getCore().byId(j);if(G){return G;}else{return new sap.m.SegmentedButtonItem({key:j,id:j,icon:i.getIcon(),tooltip:i.getTooltip()});}};A.prototype._addPredefinedTab=function(i){var j=this._tabMap[i];switch(j){case'group':j=j+'-2';break;}var G=new sap.m.SegmentedButtonItem({key:i,icon:I.getIconURI(j),tooltip:this._getText("VIEWSETTINGS_TITLE_"+i.toUpperCase()),press:function onTabPress(H){var J=H.getSource().getProperty('key');var K=this['get'+J.slice(0,1).toUpperCase()+J.slice(1)+'Items']();if(this._currentPageId===J||this._currentPageId===this._tabMap['filterDetail']&&K&&K.length>1){if(D.system.phone){this._cancel();}else{this._hideContent();}}else{if(K&&K.length===1){if(J!=='filter'){K.forEach(function(O){O.setSelected(!O.getSelected());});this['fire'+J.slice(0,1).toUpperCase()+J.slice(1)+'Selected']({items:K});this.close();}else{this._showContentFor('filterDetail',this._findListItemFromViewSettingsItem(K[0]),true);}}else{this._showContentFor(J);}}}.bind(this)});switch(i){case'sort':this._getSegmentedButton().insertItem(G,0);break;case'filter':this._getSegmentedButton().insertItem(G,1);break;case'group':this._getSegmentedButton().insertItem(G,2);break;}};A.prototype.addCustomTab=function(i,j,G){var H=i.getId();if(H==='sort'||H==='filter'||H==='group'){throw new Error('Id "'+H+'" is reserved and cannot be used as custom tab id.');}this.addAggregation('customTabs',i);if(!this._isEmptyCustomTab(i)){var J=this._getTabButtonItem(i);if(!j){J.attachEvent("press",this._handleCustomTabPress,this);}else{J.attachEvent("press",j,G);}this._getSegmentedButton().addItem(J);}return this;};A.prototype._handleCustomTabPress=function(j){var i,G,H,J,K=this.getCustomTabs(),O=K.length,Q=j.getParameter('id');for(i=0;i<O;i++){G=K[i];H=this.getId()+G.getId()+z;J=this.getId()+this._currentPageId+z;if(J===Q){if(D.system.phone){this._cancel();break;}else{this._hideContent();break;}}else{if(!this._isEmptyCustomTab(G)&&Q===H){this._showContentFor(G.getId());break;}}}};A.prototype._hideContent=function(){this._removeSegmentedButtonSelection();this._cleanAfterClose();setTimeout(this['_adjustInitialWidth'].bind(this),0);};A.prototype._cleanAfterClose=function(){this._removePageContents(this._currentPageId);this._getPopover().setContentHeight(this._initialHeight);this._removeFooter();this._navigateToPage('Main');this._currentPageId=null;};A.prototype._removePredefinedTab=function(i){var j=this._getSegmentedButton().getItems();j.forEach(function(G){if(G.getKey()===i.toLowerCase()){this._getSegmentedButton().removeItem(G);}},this);if(this._currentPageId===i.toLowerCase()){this._showContentFor(this._determinePageToOpen());}};A.prototype._removeCustomTab=function(O){var i,j,G=this.getId()+this._currentPageId+z,H=false,J=this._getSegmentedButton().getItems();J.forEach(function(K){if(K.getKey().indexOf(z)!==-1){if(O){i=(this._currentPageId===O.getId());j=this.getId()+O.getId()+z;H=(O&&j===K.getId());}else{i=(G===K.getId());}if(!O||H){this._getSegmentedButton().removeItem(K);}if(i){this._showContentFor(this._determinePageToOpen());}}},this);};A.prototype._getPopoverAriaLabel=function(){var i=this.getAssociation("ariaLabelledBy");if(!i){i=new d({text:this._getText("ARIA_LABELLED_BY_POPOVER")}).toStatic().getId();this.setAssociation("ariaLabelledBy",i,true);}return i;};A.prototype._isItemsAggregation=function(i){var j=[];var G;for(G in this._tabMap){j.push(G+'Items');}if(j.indexOf(i)===-1){return false;}return true;};A.prototype.addAggregation=function(i,O,j){if(this._isItemsAggregation(i)){(!this.getAggregation(i)||this.getAggregation(i).length===0)&&this._addPredefinedTab(i.replace('Items',''));this._handleItemsAggregation.call(this,['addAggregation',i,O,j],true);}return C.prototype.addAggregation.call(this,i,O,j);};A.prototype.insertAggregation=function(i,O,j,G){if(this._isItemsAggregation(i)){(!this.getAggregation(i)||this.getAggregation(i).length===0)&&this._addPredefinedTab(i.replace('Items',''));this._handleItemsAggregation.call(this,['insertAggregation',i,O,j,G],true);}return C.prototype.insertAggregation.call(this,i,O,j,G);};A.prototype.removeAggregation=function(i,O,j){if(this._isItemsAggregation(i)){this._handleItemsAggregation.call(this,['removeAggregation',i,O,j]);if(!this['getAggregation'](i)){this._removePredefinedTab(i.replace('Items',''));}}else{this._removeCustomTab(O);}return C.prototype.removeAggregation.call(this,i,O,j);};A.prototype.removeAllAggregation=function(i,j){if(this._isItemsAggregation(i)){this._handleItemsAggregation.call(this,['removeAllAggregation',i,null,j]);this._removePredefinedTab(i.replace('Items',''));}else{this._removeCustomTab();}return C.prototype.removeAllAggregation.call(this,i,j);};A.prototype.destroyAggregation=function(i,j){if(this._isItemsAggregation(i)){var G=i.replace('Items','');this._handleItemsAggregation.call(this,['destroyAggregation',i,j]);this._removePredefinedTab(G.slice(0,1).toUpperCase()+G.slice(1));}else if(this._segmentedButton){this._removeCustomTab();}return C.prototype.destroyAggregation.call(this,i,j);};A.prototype._handleItemsAggregation=function(i,j){var G=i[0],H=i[1],O=i[2],J=i.slice(1);if(!this._isItemsAggregation(H)){return this;}if(j){this._handleItemEventListeners(O);}this._handleListItemsAggregation(J,j,G,O);return this;};A.prototype._handleListItemsAggregation=function(i,j,G,O){var H,J,K,Q,U,W=i[0],X=false;switch(W){case'sortItems':H=this._getSortList();break;case'groupItems':H=this._getGroupList();break;case'filterItems':H=this._getFilterList();break;case'filterDetailItems':H=this._getFilterDetailList();break;}if(G==='destroyAggregation'&&!H){return;}if(O===null||typeof O!=='object'){return H[G]['apply'](H,i);}if(j){X=W==='filterItems'&&O.getItems;K=this._createListItemFromViewSettingsItem(O,W.replace("Items",""),X);}else{K=this._findListItemFromViewSettingsItem(O);}i.forEach(function(Y,Z){if(Y&&typeof Y==='object'){i[Z]=K;}});for(Q in this._tabMap){U=this._tabMap[Q];i[0]=i[0].replace(U+'I','i');}J=H[G].apply(H,i);if(G=='removeAggregation'){J.destroy();}switch(W){case'filterItems':this._toggleRemoveFilterItem();break;}return J;};A.prototype._toggleRemoveFilterItem=function(){var H=false;this.getFilterItems().forEach(function(i){if(i.getItems){i.getItems().forEach(function(j){if(j.getSelected()){H=true;}});}});if(H){if(!this._getRemoveFilterItem().getParent()){this._getFilterList().addItem(this._getRemoveFilterItem());}}else{if(this._removeFilteringItem){this._removeFilteringItem.destroy();this._removeFilteringItem=null;}}};A.prototype._handleItemEventListeners=function(O){if(O instanceof V&&O.getId().indexOf('nogrouping')===-1){O.detachItemPropertyChanged(this._handleViewSettingsItemPropertyChanged,this);O.attachItemPropertyChanged(this._handleViewSettingsItemPropertyChanged,this);}if(O instanceof sap.m.ViewSettingsFilterItem){O.detachFilterDetailItemsAggregationChange(this._handleFilterDetailItemsAggregationChange,this);O.attachFilterDetailItemsAggregationChange(this._handleFilterDetailItemsAggregationChange,this);}};A.prototype._handleViewSettingsItemPropertyChanged=function(i){var j=i.getParameter('changedItem');var G=this._findListItemFromViewSettingsItem(j);var H=i.getParameter('propertyKey');var J=i.getParameter('propertyValue');if(H==='text'){H='title';}if(G&&['key','multiSelect'].indexOf(H)==-1){G.setProperty(H,J);}};A.prototype._handleFilterDetailItemsAggregationChange=function(i){var j=i.getParameters(),G=j.item||j.changedItem;if(G&&G.getParent&&G.getParent()instanceof V){this._updateFilterDetailListFor(G.getParent());}};A.prototype._createListItemFromViewSettingsItem=function(i,j,H){var G,J=o;if(!i&&!(i instanceof V)){f.error('Expecting instance of "sap.m.ViewSettingsItem": instead of '+i+' given.');return;}switch(j){case"group":J+=p;break;case"filter":J+=q;break;case"sort":J+=r;break;}G=new S({id:i.getId()+J,title:i.getText(),type:h.Active});H&&G.attachPress(this._showContentFor.bind(this,'filterDetail',G,false))&&G.setType(h.Navigation);return G;};A.prototype._findViewSettingsItemFromListItem=function(i){var j=o;if(i.getId().indexOf('filterdetail')!==-1){j=F;}return sap.ui.getCore().byId(i.getId().split(j).shift());};A.prototype._findListItemFromViewSettingsItem=function(i){var j=i.getId()+o,G=sap.ui.getCore().byId(j+p)||sap.ui.getCore().byId(j+q)||sap.ui.getCore().byId(j+r);if(!G){G=sap.ui.getCore().byId(i.getId()+F);}return G;};A.prototype._getMainPage=function(){if(!this._mainPage){this._mainPage=new P({showHeader:false,id:this._getMainPageId()});}return this._mainPage;};A.prototype._getDetailsPage=function(){var i,j;if(!this._detailsPage){this._detailsPage=new P({showHeader:true,id:this._getDetailsPageId()});var G=new sap.m.Label({text:this._getText("VIEWSETTINGS_TITLE")}).addStyleClass("sapMVSDTitle");j=new b({contentMiddle:[G]}).addStyleClass("sapMVSPCompactHeaderBar");this._getDetailsPage().addHeaderContent(j);i=new B(this.getId()+v,{icon:I.getIconURI("nav-back"),press:this._handleBack.bind(this)});j.addContentLeft(i);}return this._detailsPage;};A.prototype._getMainPageId=function(){return this.getId()+t;};A.prototype._getDetailsPageId=function(){return this.getId()+u;};A.prototype._getPopover=function(O){if(!this._popover){this._popover=new R({showHeader:true,contentWidth:"300px",placement:g.Vertical,showCloseButton:false,modal:false,afterOpen:function(i){this.fireAfterOpen({openBy:i.getParameter("openBy")});this.$().attr("aria-labelledby",this._getPopoverAriaLabel());this._getSegmentedButton().getFocusDomRef().focus();}.bind(this),afterClose:function(i){this._cleanAfterClose();this.fireAfterClose({openBy:i.getParameter("openBy")});}.bind(this),beforeOpen:function(i){this.fireBeforeOpen({openBy:i.getParameter("openBy")});}.bind(this),beforeClose:function(i){this.fireBeforeClose({openBy:i.getParameter("openBy")});}.bind(this)}).addStyleClass('sapMVSPopover');this._popover.setCustomHeader(this._getToolbar());if(this._popover.getAggregation('_popup').setShowArrow){this._popover.getAggregation('_popup').setShowArrow(false);}}if(O&&O.$()){this._popover.setOffsetY(-O.$().outerHeight());}return this._popover;};A.prototype._getNavContainer=function(){if(!this._navContainer){this._navContainer=new N(this.getId()+s,{initialPage:this._getMainPageId(),pages:[this._getMainPage(),this._getDetailsPage()]});}return this._navContainer;};A.prototype._getSortList=function(){if(!this._sortList){this._createList('sort');}return this._sortList;};A.prototype._getGroupList=function(){if(!this._groupList){this._createList('group');}return this._groupList;};A.prototype._getFilterList=function(){if(!this._filterList){this._createList('filter');}return this._filterList;};A.prototype._getFilterDetailList=function(){if(!this._filterDetailList){this._createList('filterDetail');this._filterDetailList.attachEvent('selectionChange',function(){this._toggleRemoveFilterItem();}.bind(this));}return this._filterDetailList;};A.prototype._getToolbar=function(){if(!this._toolbar){var i;this._toolbar=new T({id:this.getId()+m});i=new B({icon:I.getIconURI("decline"),press:this._cancel.bind(this)}).addStyleClass('sapMVSPCloseBtn');this._toolbar.addContent(this._getSegmentedButton());this._toolbar.addContent(new a());this._toolbar.addContent(i);}return this._toolbar;};A.prototype._getTitle=function(){if(!this._title){this._title=new sap.m.Label(this.getId()+"-title",{id:this.getId()+w,text:this._getText("VIEWSETTINGS_TITLE")}).addStyleClass("sapMVSDTitle");}return this._title;};A.prototype._getSearchField=function(){if(!this._filterSearchField){this._filterSearchField=new sap.m.SearchField({id:this.getId()+x,liveChange:function(i){this._filterItemsBy(i.getParameter('newValue').toLowerCase());}.bind(this)});this._updateSelectAllCheckBoxState();}return this._filterSearchField;};A.prototype._filterItemsBy=function(Q){this._getFilterDetailList().getItems().forEach(function(i){var j=i.getTitle().toLowerCase().indexOf(Q)===0;i.setVisible(j);});this._updateSelectAllCheckBoxState();};A.prototype._getSegmentedButton=function(){if(!this._segmentedButton){this._segmentedButton=new c(this.getId()+n);}return this._segmentedButton;};A.prototype._getText=function(K){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(K);};A.prototype.getDomRef=function(i){return this._popover&&this._popover.getAggregation("_popup").getDomRef(i);};["invalidate","close","isOpen","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","setBindingContext","getBindingContext","getBinding","getBindingInfo","getBindingPath","setBusy","getBusy","setBusyIndicatorDelay","getBusyIndicatorDelay"].forEach(function(i){A.prototype[i]=function(){if(this._popover&&this._popover[i]){var j=this._popover[i].apply(this._popover,arguments);return j===this._popover?this:j;}};});A.prototype.exit=function(){if(this._sortList){this._sortList.destroy();this._sortList=null;}if(this._filterList){this._filterList.destroy();this._filterList=null;}if(this._filterDetailList){this._filterDetailList.destroy();this._filterDetailList=null;}if(this._groupList){this._groupList.destroy();this._groupList=null;}this._popover.destroy();this._popover=null;this._title=null;this._navContainer=null;this._mainPage=null;this._detailsPage=null;this._toolbar=null;this._segmentedButton=null;this._currentPageId=null;this._tabMap=null;this._oPreviousSelectedFilters=null;var i=sap.ui.getCore().byId(this.getAssociation("ariaLabelledBy"));if(i&&i.destroy&&!i.bIsDestroyed){i.destroy();i=null;}if(this._removeFilteringItem){this._removeFilteringItem.destroy();this._removeFilteringItem=null;}};A.prototype._isEmptyCustomTab=function(i){var j=i.getContent().length,G=this._currentPageId===i.getId()&&this._getMainPage().getContent().length;return!(j||G);};function E(){return(this._getMainPage().getContent().length&&!(this._currentPageId in this._tabMap));}return A;});
