/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./BindingParser','./DataType','./EventProvider','./ManagedObjectMetadata','./Object','../model/BindingMode','../model/CompositeBinding','../model/Context','../model/FormatException','../model/ParseException','../model/Type','../model/ValidateException',"sap/ui/util/ActivityDetection","sap/base/util/ObjectPath","sap/base/Log","sap/base/assert","sap/base/util/deepEqual","sap/base/util/uid","sap/ui/thirdparty/jquery"],function(B,D,E,M,d,e,C,f,F,P,T,V,A,O,L,g,h,u,q){"use strict";var I;var j=E.extend("sap.ui.base.ManagedObject",{metadata:{"abstract":true,publicMethods:["getId","getMetadata","getModel","setModel","hasModel","bindProperty","unbindProperty","bindAggregation","unbindAggregation","bindObject","unbindObject","getObjectBinding"],library:"sap.ui.core",properties:{},aggregations:{},associations:{},events:{"validationSuccess":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"validationError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"parseError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"formatError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"modelContextChange":{}},specialSettings:{id:'sap.ui.core.ID',models:'object',bindingContexts:'object',objectBindings:'object',metadataContexts:'object',Type:{type:'string',visibility:'hidden'}}},constructor:function(i,s,a){var t=this;E.call(this);if(typeof i!=='string'&&i!==undefined){a=s;s=i;i=s&&s.id;}if(!i){i=this.getMetadata().uid();}else{var b=j._fnIdPreprocessor;i=(b?b.call(this,i):i);var c=I||(I=D.getType("sap.ui.core.ID"));if(!c.isValid(i)){throw new Error("\""+i+"\" is not a valid ID.");}}this.sId=i;this.mProperties=this.getMetadata().createPropertyBag();this.mAggregations={};this.mAssociations={};this.oParent=null;this.aDelegates=[];this.aBeforeDelegates=[];this.iSuppressInvalidate=0;this.oPropagatedProperties=j._oEmptyPropagatedProperties;this.mSkipPropagation={};this.oModels={};this.aPropagationListeners=[];this.oBindingContexts={};this.mElementBindingContexts={};this.mBindingInfos={};this.mObjectBindingInfos={};this._oContextualSettings=j._defaultContextualSettings;this._sOwnerId=j._sOwnerId;(function(){var l=false;if(t.register){t.register();}try{if(t._initCompositeSupport){t._initCompositeSupport(s);}if(t.init){t.init();}t.applySettings(s,a);l=true;}finally{if(!l&&t.deregister){t.deregister();}}}());}},M);j.create=function(v,K,s){if(!v||v instanceof j||typeof v!=="object"||v instanceof String){return v;}function a(t){if(typeof t==="function"){return t;}if(typeof t==="string"){return O.get(t);}}var c=a(v.Type)||a(K&&K.type);if(typeof c==="function"){return new c(v,s);}var b="Don't know how to create a ManagedObject from "+v+" ("+(typeof v)+")";L.fatal(b);throw new Error(b);};var S;function k(i){if(!S){S=sap.ui.require("sap/ui/core/StashedControlSupport");}if(S){return S.getStashedControls(i);}return[];}j._fnIdPreprocessor=null;j._fnSettingsPreprocessor=null;j.runWithPreprocessors=function(a,b,t){g(typeof a==="function","fn must be a function");g(!b||typeof b==="object","oPreprocessors must be an object");var c={id:this._fnIdPreprocessor,settings:this._fnSettingsPreprocessor};b=b||{};this._fnIdPreprocessor=b.id;this._fnSettingsPreprocessor=b.settings;try{return a.call(t);}finally{this._fnIdPreprocessor=c.id;this._fnSettingsPreprocessor=c.settings;}};j.prototype.applySettings=function(s,a){if(!s||q.isEmptyObject(s)){return this;}var t=this,b=this.getMetadata(),v=b.getJSONKeys(),c=j.create,n=j._fnSettingsPreprocessor,K,r,w;function x(z){for(var i=0,G=z.length;i<G;i++){var H=z[i];if(Array.isArray(H)){x(H);}else{t[w._sMutator](c(H,w,a));}}}n&&n.call(this,s);if(s.metadataContexts&&this._processMetadataContexts){this._processMetadataContexts(s.metadataContexts,s);}if(s.models){if(typeof s.models!=="object"){throw new Error("models must be a simple object");}if(d.isA(s.models,"sap.ui.model.Model")){this.setModel(s.models);}else{for(K in s.models){this.setModel(s.models[K],K==="undefined"?undefined:K);}}}if(s.bindingContexts){if(typeof s.bindingContexts!=="object"){throw new Error("bindingContexts must be a simple object");}if(s.bindingContexts instanceof f){this.setBindingContext(s.bindingContexts);}else{for(K in s.bindingContexts){this.setBindingContext(s.bindingContexts[K],K==="undefined"?undefined:K);}}}if(s.objectBindings){if(typeof s.objectBindings!=="string"&&typeof s.objectBindings!=="object"){throw new Error("binding must be a string or simple object");}if(typeof s.objectBindings==="string"||s.objectBindings.path){this.bindObject(s.objectBindings);}else{for(var K in s.objectBindings){s.objectBindings.model=K;this.bindObject(s.objectBindings[K]);}}}for(K in s){r=s[K];if((w=v[K])!==undefined){var y;switch(w._iKind){case 0:y=this.extractBindingInfo(r,a);if(y&&typeof y==="object"){this.bindProperty(K,y);}else{this[w._sMutator](y||r);}break;case 1:y=w.altTypes&&this.extractBindingInfo(r,a);if(y&&typeof y==="object"){this.bindProperty(K,y);}else{if(Array.isArray(r)){if(r.length>1){L.error("Tried to add an array of controls to a single aggregation");}r=r[0];}this[w._sMutator](c(y||r,w,a));}break;case 2:y=this.extractBindingInfo(r,a);if(y&&typeof y==="object"){this.bindAggregation(K,y);}else{r=y||r;if(r){if(Array.isArray(r)){x(r);}else{t[w._sMutator](c(r,w,a));}}}break;case 3:this[w._sMutator](r);break;case 4:if(r){if(Array.isArray(r)){for(var i=0,l=r.length;i<l;i++){this[w._sMutator](r[i]);}}else{this[w._sMutator](r);}}break;case 5:if(typeof r=="function"){this[w._sMutator](r);}else{this[w._sMutator](r[0],r[1],r[2]);}break;case-1:default:break;}}else{g(false,"ManagedObject.apply: encountered unknown setting '"+K+"' for class '"+b.getName()+"' (value:'"+r+"')");}}return this;};j.escapeSettingsValue=function(v){return(typeof v==="string")?j.bindingParser.escape(v):v;};j.prototype.toString=function(){return"ManagedObject "+this.getMetadata().getName()+"#"+this.getId();};j.prototype.getId=function(){return this.sId;};j.prototype.setProperty=function(s,v,b){var a=this.mProperties[s];v=this.validateProperty(s,v);if(h(a,v)){this.mProperties[s]=v;return this;}if(b){A.refresh();}this.mProperties[s]=v;if(!b&&!this.isInvalidateSuppressed()){this.invalidate();}this.updateModelProperty(s,v,a);if(this.mEventRegistry["_change"]){E.prototype.fireEvent.call(this,"_change",{"id":this.getId(),"name":s,"oldValue":a,"newValue":v});}if(this._observer){this._observer.propertyChange(this,s,a,v);}return this;};j.prototype.getProperty=function(s){var v=this.mProperties[s],a=this.getMetadata().getManagedProperty(s),t;if(!a){throw new Error("Property \""+s+"\" does not exist in "+this);}t=D.getType(a.type);if(t instanceof D&&t.isArrayType()&&Array.isArray(v)){v=v.slice(0);}if(v instanceof String){v=v.valueOf();}return v;};j.prototype.validateProperty=function(s,v){var a=this.getMetadata().getManagedProperty(s),t;if(!a){throw new Error("Property \""+s+"\" does not exist in "+this);}t=D.getType(a.type);if(t instanceof D&&t.isArrayType()&&Array.isArray(v)){v=v.slice(0);}if(v==null){v=a.getDefaultValue();}else if(t instanceof D){if(t.getName()=="string"){if(!(typeof v=="string"||v instanceof String)){v=""+v;}}else if(t.getName()=="string[]"){if(typeof v=="string"){v=[v];}if(!Array.isArray(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected string[]"+" for property \""+s+"\" of "+this);}for(var i=0;i<v.length;i++){if(typeof v[i]!=="string"){v[i]=""+v[i];}}}else if(!t.isValid(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected "+t.getName()+" for property \""+s+"\" of "+this);}}if(t&&t.normalize&&typeof t.normalize==="function"){v=t.normalize(v);}return v;};j.prototype.isPropertyInitial=function(s){return!Object.prototype.hasOwnProperty.call(this.mProperties,s)&&!this.isBound(s);};j.prototype.resetProperty=function(s){if(this.mProperties.hasOwnProperty(s)){var a=this.getMetadata().getManagedProperty(s);a.set(this,null);if(this.mProperties[s]===a.getDefaultValue()){delete this.mProperties[s];}}return this;};j.prototype.getOriginInfo=function(s){var v=this.mProperties[s];if(!(v instanceof String&&v.originInfo)){return null;}return v.originInfo;};j.prototype.setAssociation=function(a,i,s){if(i instanceof j){i=i.getId();}else if(i!=null&&typeof i!=="string"){g(false,"setAssociation(): sId must be a string, an instance of sap.ui.base.ManagedObject or null");return this;}if(this.mAssociations[a]===i){return this;}if(s){this.iSuppressInvalidate++;}if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"remove",this.mAssociations[a]);}this.mAssociations[a]=i;if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};j.prototype.getAssociation=function(a,b){var r=this.mAssociations[a];if(!r){r=this.mAssociations[a]=b||null;}else{if(typeof r.length==='number'&&!(r.propertyIsEnumerable('length'))){return r.slice();}return r;}return r;};j.prototype.addAssociation=function(a,i,s){if(i instanceof j){i=i.getId();}else if(typeof i!=="string"){g(false,"addAssociation(): sId must be a string or an instance of sap.ui.base.ManagedObject");return this;}if(s){this.iSuppressInvalidate++;}var b=this.mAssociations[a];if(!b){b=this.mAssociations[a]=[i];}else{b.push(i);}if(this._observer){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};j.prototype.removeAssociation=function(a,v,s){var b=this.mAssociations[a];var c=null;if(!b){return null;}if(s){this.iSuppressInvalidate++;}if(typeof(v)=="object"&&v.getId){v=v.getId();}if(typeof(v)=="string"){for(var i=0;i<b.length;i++){if(b[i]==v){v=i;break;}}}if(typeof(v)=="number"){if(v<0||v>=b.length){L.warning("ManagedObject.removeAssociation called with invalid index: "+a+", "+v);}else{c=b[v];b.splice(v,1);if(this._observer){this._observer.associationChange(this,a,"remove",c);}if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(s){this.iSuppressInvalidate--;}return c;};j.prototype.removeAllAssociation=function(a,s){var i=this.mAssociations[a];if(!i){return[];}if(s){this.iSuppressInvalidate++;}delete this.mAssociations[a];if(this._observer){this._observer.associationChange(this,a,"remove",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return i;};j.prototype.validateAggregation=function(a,b,c,l){var n=this.getMetadata(),r=n.getManagedAggregation(a),s,t,i,v;if(!r){throw new Error("Aggregation \""+a+"\" does not exist in "+this);}if(r.multiple!==c){throw new Error("Aggregation '"+a+"' of "+this+" used with wrong cardinality (declared as "+(r.multiple?"0..n":"0..1")+")");}var w=n.getAggregationForwarder(a);if(w&&!l){w.getTarget(this).validateAggregation(w.targetAggregationName,b,c);}if(!r.multiple&&!b){return b;}if(b instanceof d&&b.isA(r.type)){return b;}s=r.altTypes;if(s&&s.length){if(b==null){return b;}for(i=0;i<s.length;i++){t=D.getType(s[i]);if(t instanceof D){if(t.isValid(b)){return b;}}}}t=O.get(r.type);if(typeof t==="function"&&b instanceof t){return b;}v="\""+b+"\" is not valid for aggregation \""+a+"\" of "+this;if(D.isInterfaceType(r.type)){g(false,v);return b;}else{throw new Error(v);}};j.prototype.setAggregation=function(a,b,s){var c=this.getMetadata().getAggregationForwarder(a);if(c){b=this.validateAggregation(a,b,false,true);return c.set(this,b);}var i=this.mAggregations[a];if(i===b){return this;}b=this.validateAggregation(a,b,false);if(s){this.iSuppressInvalidate++;}this.mAggregations[a]=null;if(i instanceof j){i.setParent(null);}else{if(this._observer!=null&&i!=null){this._observer.aggregationChange(this,a,"remove",i);}}this.mAggregations[a]=b;if(b instanceof j){b.setParent(this,a,s);}else{if(!this.isInvalidateSuppressed()){this.invalidate();}if(this._observer!=null&&b!=null){this._observer.aggregationChange(this,a,"insert",b);}}if(s){this.iSuppressInvalidate--;}return this;};j.prototype.getAggregation=function(a,b){var c=this.getMetadata().getAggregationForwarder(a);if(c){return c.get(this);}var i=this.mAggregations[a];if(!i){i=this.mAggregations[a]=b||null;}if(i){if(typeof i.length==='number'&&!(i.propertyIsEnumerable('length'))){return i.slice();}return i;}else{return null;}};j.prototype.indexOfAggregation=function(a,b){var c=this.getMetadata().getAggregationForwarder(a);if(c){return c.indexOf(this,b);}var l=this.mAggregations[a];if(l){if(l.length==undefined){return-2;}for(var i=0;i<l.length;i++){if(l[i]==b){return i;}}}return-1;};j.prototype.insertAggregation=function(a,b,c,s){if(!b){return this;}b=this.validateAggregation(a,b,true,true);var l=this.getMetadata().getAggregationForwarder(a);if(l){return l.insert(this,b,c);}var n=this.mAggregations[a]||(this.mAggregations[a]=[]);var i;if(c<0){i=0;}else if(c>n.length){i=n.length;}else{i=c;}if(i!==c){L.warning("ManagedObject.insertAggregation: index '"+c+"' out of range [0,"+n.length+"], forced to "+i);}n.splice(i,0,b);b.setParent(this,a,s);return this;};j.prototype.addAggregation=function(a,b,s){if(!b){return this;}b=this.validateAggregation(a,b,true,true);var c=this.getMetadata().getAggregationForwarder(a);if(c){return c.add(this,b);}var i=this.mAggregations[a];if(!i){i=this.mAggregations[a]=[b];}else{i.push(b);}b.setParent(this,a,s);return this;};j.prototype.removeAggregation=function(a,v,s){var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.remove(this,v);}var c=this.mAggregations[a],l=null,i;if(!c){return null;}if(s){this.iSuppressInvalidate++;}if(typeof(v)=="string"){for(i=0;i<c.length;i++){if(c[i]&&c[i].getId()===v){v=i;break;}}}if(typeof(v)=="object"){for(i=0;i<c.length;i++){if(c[i]==v){v=i;break;}}}if(typeof(v)=="number"){if(v<0||v>=c.length){L.warning("ManagedObject.removeAggregation called with invalid index: "+a+", "+v);}else{l=c[v];c.splice(v,1);l.setParent(null);if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(s){this.iSuppressInvalidate--;}return l;};j.prototype.removeAllAggregation=function(a,s){var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.removeAll(this);}var c=this.mAggregations[a];if(!c){return[];}if(s){this.iSuppressInvalidate++;}delete this.mAggregations[a];for(var i=0;i<c.length;i++){c[i].setParent(null);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return c;};j.prototype.destroyAggregation=function(a,s){var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.destroy(this);}var l=this.mAggregations[a],i,n;k(this.getId()).forEach(function(c){if(c.sParentAggregationName===a){c.destroy();}});if(!l){return this;}if(s){this.iSuppressInvalidate++;}delete this.mAggregations[a];if(l instanceof j){l.destroy(s);if(this._observer){this._observer.aggregationChange(this,a,"remove",l);}}else if(Array.isArray(l)){for(i=l.length-1;i>=0;i--){n=l[i];if(n){n.destroy(s);if(this._observer){this._observer.aggregationChange(this,a,"remove",n);}}}}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};j.prototype.invalidate=function(){if(this.oParent){this.oParent.invalidate(this);}};j.prototype.isInvalidateSuppressed=function(){var i=this.iSuppressInvalidate>0;if(this.oParent&&this.oParent instanceof j){i=i||this.oParent.isInvalidateSuppressed();}return i;};j.prototype._removeChild=function(c,a,s){if(!a){L.error("Cannot remove aggregated child without aggregation name.",null,this);}else{if(s){this.iSuppressInvalidate++;}var i=this.indexOfAggregation(a,c);var b=this.getMetadata().getAggregation(a);if(i==-2){if(b&&this[b._sMutator]){this[b._sMutator](null);}else{this.setAggregation(a,null,s);}}else if(i>-1){if(b&&this[b._sRemoveMutator]){this[b._sRemoveMutator](i);}else{this.removeAggregation(a,i,s);}}if(s){this.iSuppressInvalidate--;}}};function m(a,b){while(a&&a!==b){a=a.oParent;}return!!a;}j.prototype.setParent=function(a,s,b){g(a==null||a instanceof j,"oParent either must be null, undefined or a ManagedObject");if(!a){if(this.oParent){if(this.oParent._observer){this.oParent._observer.aggregationChange(this.oParent,this.sParentAggregationName,"remove",this);}if(this.aAPIParentInfos&&this.aAPIParentInfos.forwardingCounter===0){delete this.aAPIParentInfos;}}this.oParent=null;this.sParentAggregationName=null;var c=j._oEmptyPropagatedProperties;if(c!==this.oPropagatedProperties){this.oPropagatedProperties=c;if(!this._bIsBeingDestroyed){Promise.resolve().then(function(){if(!this.oParent){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);this.fireModelContextChange();}}.bind(this));}}this._oContextualSettings=j._defaultContextualSettings;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oParent){this._propagateContextualSettings();}}.bind(this),0);}A.refresh();return;}if(m(a,this)){throw new Error("Cycle detected: new parent '"+a+"' is already a descendant of (or equal to) '"+this+"'");}if(b){A.refresh();this.iSuppressInvalidate++;}var i=this.getParent();if(i){i._removeChild(this,this.sParentAggregationName);}this.oParent=a;this.sParentAggregationName=s;var c=this.aAPIParentInfos?this.aAPIParentInfos[0].parent._getPropertiesToPropagate():a._getPropertiesToPropagate();if(c!==this.oPropagatedProperties){this.oPropagatedProperties=c;if(this.hasModel()){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);}this._callPropagationListener();this.fireModelContextChange();}this._applyContextualSettings(a._oContextualSettings);if(a&&!this.isInvalidateSuppressed()){a.invalidate(this);}if(b){this.iSuppressInvalidate--;}if(a._observer){a._observer.aggregationChange(a,s,"insert",this);}return this;};j.prototype._applyContextualSettings=function(c){if(this._oContextualSettings!==c){this._oContextualSettings=c;this._propagateContextualSettings();this._onContextualSettingsChanged();}};j.prototype._onContextualSettingsChanged=function(){};j.prototype._propagateContextualSettings=function(){var s=this._oContextualSettings,a,b,i;for(a in this.mAggregations){b=this.mAggregations[a];if(b instanceof j){b._applyContextualSettings(s);}else if(b instanceof Array){for(i=0;i<b.length;i++){if(b[i]instanceof j){b[i]._applyContextualSettings(s);}}}}};j.prototype._getContextualSettings=function(){return this._oContextualSettings;};j.prototype.getParent=function(){return this.oParent;};j.prototype.destroy=function(s){if(this.bIsDestroyed){return;}var t=this;this._bIsBeingDestroyed=true;if(s){this.iSuppressInvalidate++;}if(this.exit){this.exit();}if(this._exitCompositeSupport){this._exitCompositeSupport();}for(var a in this.mAggregations){this.destroyAggregation(a,s);}k(this.getId()).forEach(function(c){c.destroy();});if(this.deregister){this.deregister();}if(this.oParent&&this.sParentAggregationName){this.oParent._removeChild(this,this.sParentAggregationName,s);}delete this.oParent;q.each(this.mBindingInfos,function(n,b){if(b.factory){t.unbindAggregation(n,true);}else{t.unbindProperty(n,true);}});q.each(this.mObjectBindingInfos,function(n,b){t.unbindObject(n,true);});if(s){this.iSuppressInvalidate--;}if(this._observer){this._observer.objectDestroyed(this);}if(this.aAPIParentInfos){this.aAPIParentInfos=null;}E.prototype.destroy.apply(this,arguments);this.setParent=function(){throw Error("The object with ID "+t.getId()+" was destroyed and cannot be used anymore.");};this.bIsDestroyed=true;};j.bindingParser=B.simpleParser;j.prototype.isBinding=function(v,K){return typeof this.extractBindingInfo(v)==="object";};j.prototype.extractBindingInfo=function(v,s){if(v&&typeof v==="object"){if(v.ui5object){delete v.ui5object;}else if(v.path!=undefined||v.parts){if(v.template){v.template=j.create(v.template);}return v;}}if(typeof v==="string"){return j.bindingParser(v,s,true);}};j.prototype.getBindingInfo=function(n){var a=this.getMetadata().getAggregationForwarder(n);if(a&&a.forwardBinding){return a.getTarget(this).getBindingInfo(a.targetAggregationName);}return this.mBindingInfos[n];};j.prototype.bindObject=function(b){var s,a,i;if(typeof b=="string"){a=b;b={path:a,parameters:arguments[1]};}else{a=b.path;}i=a.indexOf(">");if(i>0){b.model=a.substr(0,i);b.path=a.substr(i+1);}s=b.model;if(this.mObjectBindingInfos[s]){this.unbindObject(s,true);}this.mObjectBindingInfos[s]=b;if(this.getModel(s)){this._bindObject(b);}return this;};j.prototype._bindObject=function(b){var a,c,s,i,t=this;var l=function(r){t.setElementBindingContext(a.getBoundContext(),s);};var n=function(r){var v=a.getDataState();if(!v){return;}if(t.refreshDataState){t.refreshDataState('',v);}};s=b.model;i=this.getModel(s);c=this.getBindingContext(s);a=i.bindContext(b.path,c,b.parameters);if(b.suspended){a.suspend(true);}a.attachChange(l);b.binding=a;b.modelChangeHandler=l;b.dataStateChangeHandler=n;a.attachEvents(b.events);if(this.refreshDataState){a.attachAggregatedDataStateChange(n);}a.initialize();};j.prototype.bindContext=function(s){return this.bindObject(s);};j.prototype.unbindContext=function(s){return this.unbindObject(s);};j.prototype.unbindObject=function(s,a){var b=this.mObjectBindingInfos[s];if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);b.binding.detachEvents(b.events);if(this.refreshDataState){b.binding.detachAggregatedDataStateChange(b.dataStateChangeHandler);}b.binding.destroy();}delete this.mObjectBindingInfos[s];delete this.mElementBindingContexts[s];if(!a){this.updateBindingContext(false,s);this.propagateProperties(s);this.fireModelContextChange();}}return this;};j.prototype.bindProperty=function(n,b,a,c){var s,l=true,r=this.getMetadata().getPropertyLikeSetting(n);if(!r){throw new Error("Property \""+n+"\" does not exist in "+this);}if(typeof b=="string"){b={parts:[{path:b,type:a instanceof T?a:undefined,mode:c}],formatter:typeof a==='function'?a:undefined};}if(!b.parts){b.parts=[];b.parts[0]={path:b.path,targetType:b.targetType,type:b.type,suspended:b.suspended,formatOptions:b.formatOptions,constraints:b.constraints,model:b.model,mode:b.mode};delete b.path;delete b.targetType;delete b.mode;delete b.model;}for(var i=0;i<b.parts.length;i++){var t=b.parts[i];if(typeof t=="string"){t={path:t};b.parts[i]=t;}s=t.path.indexOf(">");if(s>0){t.model=t.path.substr(0,s);t.path=t.path.substr(s+1);}if(b.formatter&&t.mode!=e.OneWay&&t.mode!=e.OneTime){t.mode=e.OneWay;}if(!this.getModel(t.model)){l=false;}}if(this.isBound(n)){this.unbindProperty(n,true);}this.mBindingInfos[n]=b;if(this._observer){this._observer.bindingChange(this,n,"prepare",b,"property");}if(l){this._bindProperty(n,b);}return this;};j.prototype._bindProperty=function(n,b){var a,c,i,s,l=e.TwoWay,t,r,v=this.getMetadata().getPropertyLikeSetting(n),w=v._iKind===0?v.type:v.altTypes[0],x=this,y=[],z=function(H){x.updateProperty(n);var J=i.getDataState();if(J){var K=J.getControlMessages();if(K&&K.length>0){var N=sap.ui.getCore().getMessageManager();J.setControlMessages([]);if(K){N.removeMessages(K);}}J.setInvalidValue(undefined);}if(i.getBindingMode()===e.OneTime&&i.isResolved()){i.detachChange(z);if(this.refreshDataState){i.detachAggregatedDataStateChange(G);}i.detachEvents(b.events);i.destroy();}},G=function(){var H=i.getDataState();if(!H){return;}if(x.refreshDataState){x.refreshDataState(n,H);}};b.parts.forEach(function(H){c=x.getBindingContext(H.model);a=x.getModel(H.model);t=H.type;if(typeof t=="string"){r=O.get(t);if(typeof r!=="function"){throw new Error("Cannot find type \""+t+"\" used in control \""+x.getId()+"\"!");}t=new r(H.formatOptions,H.constraints);}i=a.bindProperty(H.path,c,H.parameters||b.parameters);i.setType(t,H.targetType||w);i.setFormatter(H.formatter);if(H.suspended){i.suspend(true);}s=H.mode||a.getDefaultBindingMode();i.setBindingMode(s);if(s!=e.TwoWay){l=e.OneWay;}y.push(i);});if(y.length>1||(b.formatter&&b.formatter.textFragments)){t=b.type;if(typeof t=="string"){r=O.get(t);t=new r(b.formatOptions,b.constraints);}i=new C(y,b.useRawValues,b.useInternalValues);i.setType(t,b.targetType||w);i.setBindingMode(b.mode||l);}else{i=y[0];}i.attachChange(z);if(this.refreshDataState){i.attachAggregatedDataStateChange(G);}i.setFormatter(q.proxy(b.formatter,this));b.binding=i;b.modelChangeHandler=z;b.dataStateChangeHandler=G;i.attachEvents(b.events);i.initialize();if(this._observer){this._observer.bindingChange(this,n,"ready",b,"property");}};j.prototype.unbindProperty=function(n,s){var b=this.mBindingInfos[n];if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);if(this.refreshDataState){b.binding.detachAggregatedDataStateChange(b.dataStateChangeHandler);}b.binding.detachEvents(b.events);b.binding.destroy();}if(this._observer){this._observer.bindingChange(this,n,"remove",this.mBindingInfos[n],"property");}delete this.mBindingInfos[n];if(!s){this.resetProperty(n);}}return this;};j.prototype.updateProperty=function(n){var b=this.mBindingInfos[n],a=b.binding,c=this.getMetadata().getPropertyLikeSetting(n);if(b.skipPropertyUpdate){return;}try{var v=a.getExternalValue();b.skipModelUpdate=true;c.set(this,v);b.skipModelUpdate=false;}catch(i){b.skipModelUpdate=false;if(i instanceof F){this.fireFormatError({element:this,property:n,type:a.getType(),newValue:a.getValue(),oldValue:this[c._sGetter](),exception:i,message:i.message},false,true);b.skipModelUpdate=true;this.resetProperty(n);b.skipModelUpdate=false;}else{throw i;}}};j.prototype.updateModelProperty=function(n,v,a){if(this.isBound(n)){var b=this.mBindingInfos[n],c=b.binding;if(b.skipModelUpdate||(c&&c.isSuspended())){return;}if(c&&c.getBindingMode()==e.TwoWay){try{b.skipPropertyUpdate=true;c.setExternalValue(v);b.skipPropertyUpdate=false;var i=c.getExternalValue();if(v!=i){this.updateProperty(n);}if(c.hasValidation()){this.fireValidationSuccess({element:this,property:n,type:c.getType(),newValue:v,oldValue:a},false,true);}}catch(l){b.skipPropertyUpdate=false;var r={element:this,property:n,type:c.getType(),newValue:v,oldValue:a,exception:l,message:l.message};if(l instanceof P){this.fireParseError(r,false,true);}else if(l instanceof V){this.fireValidationError(r,false,true);}else{throw l;}}}}};var o=1;j.prototype.bindAggregation=function(n,b){var s,t,a,c,i=this.getMetadata(),l=i.getAggregation(n);if(!l){throw new Error("Aggregation \""+n+"\" does not exist in "+this);}if(!l.multiple){L.error("Binding of single aggregation \""+n+"\" of "+this+" is not supported!");}if(typeof b=="string"){s=arguments[1];t=arguments[2];a=arguments[3];c=arguments[4];b={path:s,sorter:a,filters:c};if(t instanceof j){b.template=t;}else if(typeof t==="function"){b.factory=t;}}var r=i.getAggregationForwarder(n);if(r&&r.forwardBinding){return r.getTarget(this).bindAggregation(r.targetAggregationName,b);}if(this.isBound(n)){this.unbindAggregation(n);}if(!(b.template||b.factory)){if(l._doesNotRequireFactory){b.factory=function(){throw new Error("dummy factory called unexpectedly ");};}else{throw new Error("Missing template or factory function for aggregation "+n+" of "+this+" !");}}if(b.template){if(b.template._sapui_candidateForDestroy){L.warning("A binding template that is marked as 'candidate for destroy' is reused in a binding. "+"You can use 'templateShareable:true' to fix this issue for all bindings that are affected "+"(The template is used in aggregation '"+n+"' of object '"+this.getId()+"'). "+"For more information, see documentation under 'Aggregation Binding'.");delete b.template._sapui_candidateForDestroy;}if(b.templateShareable===undefined){b.templateShareable=o;}b.factory=function(w){return b.template.clone(w);};}var v=b.path.indexOf(">");if(v>0){b.model=b.path.substr(0,v);b.path=b.path.substr(v+1);}this.mBindingInfos[n]=b;if(this._observer){this._observer.bindingChange(this,n,"prepare",b,"aggregation");}if(this.getModel(b.model)){this._bindAggregation(n,b);}return this;};j.prototype._bindAggregation=function(n,b){var t=this,a,c=function(s){var U="update"+n.substr(0,1).toUpperCase()+n.substr(1);if(t[U]){var v=s&&s.getParameter("reason");if(v){t[U](v);}else{t[U]();}}else{t.updateAggregation(n);}},i=function(s){var R="refresh"+n.substr(0,1).toUpperCase()+n.substr(1);if(t[R]){t[R](s.getParameter("reason"));}else{c(s);}},l=function(s){var v=a.getDataState();if(!v){return;}if(t.refreshDataState){t.refreshDataState(n,v);}};var r=this.getModel(b.model);if(this.isTreeBinding(n)){a=r.bindTree(b.path,this.getBindingContext(b.model),b.filters,b.parameters,b.sorter);}else{a=r.bindList(b.path,this.getBindingContext(b.model),b.sorter,b.filters,b.parameters);if(this.bUseExtendedChangeDetection){a.enableExtendedChangeDetection(!b.template,b.key);}}if(b.suspended){a.suspend(true);}b.binding=a;b.modelChangeHandler=c;b.modelRefreshHandler=i;b.dataStateChangeHandler=l;a.attachChange(c);a.attachRefresh(i);a.attachEvents(b.events);if(this.refreshDataState){a.attachAggregatedDataStateChange(l);}a.initialize();if(this._observer){this._observer.bindingChange(this,n,"ready",b,"aggregation");}};j.prototype.unbindAggregation=function(n,s){var a=this.getMetadata().getAggregationForwarder(n);if(a&&a.forwardBinding){return a.getTarget(this).unbindAggregation(a.targetAggregationName,s);}var b=this.mBindingInfos[n],c=this.getMetadata().getAggregation(n);if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);b.binding.detachRefresh(b.modelRefreshHandler);b.binding.detachEvents(b.events);if(this.refreshDataState){b.binding.detachAggregatedDataStateChange(b.dataStateChangeHandler);}b.binding.destroy();}if(b.template){if(!b.templateShareable&&b.template.destroy){b.template.destroy();}if(b.templateShareable===o){b.template._sapui_candidateForDestroy=true;}}if(this._observer){this._observer.bindingChange(this,n,"remove",this.mBindingInfos[n],"aggregation");}delete this.mBindingInfos[n];if(!s){this[c._sDestructor]();}}return this;};j.prototype.updateAggregation=function(n){var b=this.mBindingInfos[n],a=b.binding,c=b.factory,l=this.getMetadata().getAggregation(n),G,r,s,t=l._sMutator+"Group",v=this;function w(i,J){if(v.bUseExtendedChangeDetection){return M.uid('clone');}else{return i.getId()+"-"+J;}}function x(J,s,K,N){var Q=J[l._sGetter]()||[],R,U;if(Q.length>s.length){for(var i=s.length;i<Q.length;i++){U=Q[i];J[l._sRemoveMutator](U);U.destroy("KeepDom");}}for(var i=0;i<s.length;i++){R=s[i];U=Q[i];if(K){K(R);}if(U){U.setBindingContext(R,b.model);}else{U=c(w(J,i),R);U.setBindingContext(R,b.model);J[l._sMutator](U);}if(N){N(R,U);}}}function y(J,s){var K=s.diff,N=J[l._sGetter]()||[],Q,R,U,i;if(!K||N.length===0){x(J,s);return;}for(i=0;i<K.length;i++){Q=K[i];switch(Q.type){case"insert":U=s[Q.index];R=c(w(J,Q.index),U);R.setBindingContext(U,b.model);J[l._sInsertMutator](R,Q.index);break;case"delete":R=J[l._sRemoveMutator](Q.index);R.destroy("KeepDom");break;default:L.error("Unknown diff type \""+Q.type+"\"");}}N=J[l._sGetter]()||[];for(i=0;i<N.length;i++){N[i].setBindingContext(s[i]);}}function z(i){var N=a.getGroup(i);if(N.key!==G){var J;if(b.groupHeaderFactory){J=b.groupHeaderFactory(N);}v[t](N,J);G=N.key;}}function H(i,J){x(i,J,null,function(K,N){H(N,a.getNodeContexts(K));});}if(d.isA(a,"sap.ui.model.ListBinding")){s=a.getContexts(b.startIndex,b.length);r=a.isGrouped()&&v[t];if(r||a.bWasGrouped){this[l._sDestructor]();x(this,s,r?z:undefined);}else if(this.bUseExtendedChangeDetection){y(this,s);}else{if(!b.template){this[l._sDestructor]();}x(this,s);}a.bWasGrouped=r;}else if(d.isA(a,"sap.ui.model.TreeBinding")){if(!b.template){this[l._sDestructor]();}H(this,a.getRootContexts());}};j.prototype.refreshAggregation=function(n){var b=this.mBindingInfos[n],a=b.binding;a.getContexts(b.startIndex,b.length);};j.prototype.propagateMessages=function(n,a){L.warning("Message for "+this+", Property "+n);};j.prototype.isTreeBinding=function(n){return false;};j.prototype.updateBindings=function(U,s){var t=this,n,b;function a(b){var v=b.parts,i;if(v){if(v.length==1){return(U||v[0].model==s)&&!b.binding.updateRequired(t.getModel(v[0].model));}else{for(i=0;i<v.length;i++){if((U||v[i].model==s)&&!b.binding.aBindings[i].updateRequired(t.getModel(v[i].model))){return true;}}}}else{return(U||b.model==s)&&!b.binding.updateRequired(t.getModel(b.model));}}function c(b){var v=b.parts,i;if(v){for(i=0;i<v.length;i++){if(!t.getModel(v[i].model)){return false;}}return true;}else{return!!t.getModel(b.model);}}function r(b){if(t.refreshDataState){t.refreshDataState(n,b.binding.getDataState());}b.binding.detachChange(b.modelChangeHandler);if(b.modelRefreshHandler){b.binding.detachRefresh(b.modelRefreshHandler);}b.binding.detachEvents(b.events);b.binding.destroy();delete b.binding;delete b.modelChangeHandler;delete b.dataStateChangeHandler;delete b.modelRefreshHandler;}for(n in this.mObjectBindingInfos){b=this.mObjectBindingInfos[n];if(b.binding&&a(b)){r(b);}if(!b.binding&&c(b)){this._bindObject(b);}}for(n in this.mBindingInfos){b=this.mBindingInfos[n];if(b.binding&&a(b)){if(this._observer){var l=b.factory?"aggregation":"property";this._observer.bindingChange(this,n,"remove",b,l);}r(b);}if(!b.binding&&c(b)){if(b.factory){this._bindAggregation(n,b);}else{this._bindProperty(n,b);}}}};j.prototype.isBound=function(n){return!!this.getBindingInfo(n);};j.prototype.getObjectBinding=function(s){return this.mObjectBindingInfos[s]&&this.mObjectBindingInfos[s].binding;};j.prototype.getEventingParent=function(){return this.oParent;};j.prototype.getBinding=function(n){var i=this.getBindingInfo(n);return i&&i.binding;};j.prototype.getBindingPath=function(n){var i=this.getBindingInfo(n);return i&&(i.path||(i.parts&&i.parts[0]&&i.parts[0].path));};j.prototype.setBindingContext=function(c,s){g(s===undefined||(typeof s==="string"&&!/^(undefined|null)?$/.test(s)),"sModelName must be a string or omitted");var a=this.oBindingContexts[s];if(f.hasChanged(a,c)){if(c===undefined){delete this.oBindingContexts[s];}else{this.oBindingContexts[s]=c;}this.updateBindingContext(false,s);this.propagateProperties(s);this.fireModelContextChange();}return this;};j.prototype.setElementBindingContext=function(c,s){g(s===undefined||(typeof s==="string"&&!/^(undefined|null)?$/.test(s)),"sModelName must be a string or omitted");var a=this.mElementBindingContexts[s];if(f.hasChanged(a,c)){if(c===undefined){delete this.mElementBindingContexts[s];}else{this.mElementBindingContexts[s]=c;}this.updateBindingContext(true,s);this.propagateProperties(s);this.fireModelContextChange();}return this;};j.prototype.updateBindingContext=function(s,a,U){var b,c={},l,n,N,r,i;if(U){for(l in this.oModels){if(this.oModels.hasOwnProperty(l)){c[l]=l;}}for(l in this.oPropagatedProperties.oModels){if(this.oPropagatedProperties.oModels.hasOwnProperty(l)){c[l]=l;}}}else{c[a]=a;}for(l in c){if(c.hasOwnProperty(l)){l=l==="undefined"?undefined:l;b=this.getModel(l);r=this.mObjectBindingInfos[l];if(b&&r&&!s){if(!r.binding){this._bindObject(r);}else{n=this._getBindingContext(l);if(f.hasChanged(r.binding.getContext(),n)){r.binding.setContext(n);}}continue;}n=this.getBindingContext(l);for(N in this.mBindingInfos){var r=this.mBindingInfos[N],t=r.binding,v=r.parts;if(!t){continue;}if(v&&v.length>1){for(i=0;i<v.length;i++){if(v[i].model==l){t.aBindings[i].setContext(n);}}}else if(r.factory){if(r.model==l){t.setContext(n);}}else{if(v[0].model==l){t.setContext(n);}}}}}};j.prototype.getBindingContext=function(s){var a=this.getModel(s),b=this.mElementBindingContexts[s];if(b&&!a){return b;}else if(b&&a&&b.getModel()===a){return b;}else if(b===null){return b;}else{return this._getBindingContext(s);}};j.prototype._getBindingContext=function(s){var a=this.getModel(s),c=this.oBindingContexts[s],b=this.oPropagatedProperties.oBindingContexts[s];if(c&&!a){return this.oBindingContexts[s];}else if(c&&a&&c.getModel()===a){return this.oBindingContexts[s];}else if(c===null){return c;}else if(b&&a&&b.getModel()!==a){return undefined;}else{return b;}};j.prototype.setModel=function(a,n){g(a==null||d.isA(a,"sap.ui.model.Model"),"oModel must be an instance of sap.ui.model.Model, null or undefined");g(n===undefined||(typeof n==="string"&&!/^(undefined|null)?$/.test(n)),"sName must be a string or omitted");if(!a&&this.oModels[n]){delete this.oModels[n];this.propagateProperties(n);this.updateBindings(false,n);this.fireModelContextChange();}else if(a&&a!==this.oModels[n]){this.oModels[n]=a;this.propagateProperties(n);this.updateBindingContext(false,n);this.updateBindings(false,n);this.fireModelContextChange();}return this;};j.prototype.addPropagationListener=function(l){g(typeof l==='function',"listener must be a function");this.aPropagationListeners.push(l);this.propagateProperties(false);this._callPropagationListener(l);return this;};j.prototype.removePropagationListener=function(l){g(typeof l==='function',"listener must be a function");var a=this.aPropagationListeners;var i=a.indexOf(l);if(i>=0){a.splice(i,1);this.propagateProperties(false);}return this;};j.prototype.getPropagationListeners=function(){return this.oPropagatedProperties.aPropagationListeners.concat(this.aPropagationListeners);};j.prototype._callPropagationListener=function(l){var a;if(l){l(this);}else{a=this.getPropagationListeners();for(var i=0;i<a.length;i++){l=a[i];l(this);}}return this;};j._oEmptyPropagatedProperties={oModels:{},oBindingContexts:{},aPropagationListeners:[]};var p=Object.assign||q.extend;function _(a,c){return!c.aAPIParentInfos||c.aAPIParentInfos[0].parent===a;}j.prototype.propagateProperties=function(n){var a=this._getPropertiesToPropagate(),U=n===true,b=n===false,N=U?undefined:n,s,c,i,l=p({},this.mAggregations,this.mForwardedAggregations);for(s in l){if(this.mSkipPropagation[s]){continue;}c=l[s];if(c instanceof j){if(_(this,c)){this._propagateProperties(n,c,a,U,N,b);}}else if(c instanceof Array){for(i=0;i<c.length;i++){if(c[i]instanceof j){if(_(this,c[i])){this._propagateProperties(n,c[i],a,U,N,b);}}}}}};j.prototype._propagateProperties=function(n,a,b,U,N,c){if(!b){b=this._getPropertiesToPropagate();U=n===true;c=n===false;N=U?undefined:n;}if(a.oPropagatedProperties!==b){a.oPropagatedProperties=b;if(c!==true){a.updateBindings(U,N);a.updateBindingContext(false,N,U);}a.propagateProperties(n);if(c||U){a._callPropagationListener();}a.fireModelContextChange();}};j.prototype._getPropertiesToPropagate=function(){var n=q.isEmptyObject(this.oModels),N=q.isEmptyObject(this.oBindingContexts),b=this.aPropagationListeners.length===0,a=q.isEmptyObject(this.mElementBindingContexts);function c(l,r,s,t){return l?r:q.extend({},r,s,t);}function i(l,r,s){return l?r:r.concat(s);}if(N&&n&&a&&b){return this.oPropagatedProperties;}else{return{oModels:c(n,this.oPropagatedProperties.oModels,this.oModels),oBindingContexts:c((N&&a),this.oPropagatedProperties.oBindingContexts,this.oBindingContexts,this.mElementBindingContexts),aPropagationListeners:i(b,this.oPropagatedProperties.aPropagationListeners,this.aPropagationListeners)};}};j.prototype.getModel=function(s){g(s===undefined||(typeof s==="string"&&!/^(undefined|null)?$/.test(s)),"sModelName must be a string or omitted");return this.oModels[s]||this.oPropagatedProperties.oModels[s];};j.prototype.hasModel=function(){return!(q.isEmptyObject(this.oModels)&&q.isEmptyObject(this.oPropagatedProperties.oModels));};j.prototype.clone=function(s,a,b){var c=true,n=true;if(b){c=!!b.cloneChildren;n=!!b.cloneBindings;}if(!s){s=M.uid("clone")||u();}if(!a&&c){a=this.findAggregatedObjects(true).map(function(Z){return Z.getId();});}var r=this.getMetadata(),t=r._oClass,v=this.getId()+"-"+s,w={},x=this.mProperties,K,N,y,z=j.bindingParser.escape,i;var G=Object.keys(x);i=G.length;while(i>0){K=G[--i];if(!(this.isBound(K)&&n)){if(typeof x[K]==="string"){w[K]=z(x[K]);}else{w[K]=x[K];}}}w["models"]=this.oModels;w["bindingContexts"]=this.oBindingContexts;if(c){var H=p({},this.mAggregations,this.mForwardedAggregations);for(N in H){var J=H[N];if(r.hasAggregation(N)&&!(this.isBound(N)&&n)){if(J instanceof j){w[N]=J.clone(s,a);}else if(Array.isArray(J)){w[N]=[];for(var i=0;i<J.length;i++){w[N].push(J[i].clone(s,a));}}else{w[N]=J;}}}var Q=k(this.getId());for(var i=0,l=Q.length;i<l;i++){var R=Q[i].clone(s);R.sParentId=v;R.sParentAggregationName=Q[i].sParentAggregationName;}for(N in this.mAssociations){var U=this.mAssociations[N];if(Array.isArray(U)){U=U.slice(0);for(var i=0;i<U.length;i++){if(a.indexOf(U[i])>=0){U[i]+="-"+s;}}}else if(a.indexOf(U)>=0){U+="-"+s;}w[N]=U;}}y=new t(v,w);for(N in this.mObjectBindingInfos){y.mObjectBindingInfos[N]=q.extend({},this.mObjectBindingInfos[N]);}for(N in this.mEventRegistry){y.mEventRegistry[N]=this.mEventRegistry[N].slice();}if(n){for(N in this.mBindingInfos){var W=this.mBindingInfos[N];var X=q.extend({},W);if(!W.templateShareable&&W.template&&W.template.clone){X.template=W.template.clone(s,a);delete X.factory;}else if(W.templateShareable===o){W.templateShareable=X.templateShareable=true;L.error("During a clone operation, a template was found that neither was marked with 'templateShareable:true' nor 'templateShareable:false'. "+"The framework won't destroy the template. This could cause errors (e.g. duplicate IDs) or memory leaks "+"(The template is used in aggregation '"+N+"' of object '"+this.getId()+"')."+"For more information, see documentation under 'Aggregation Binding'.");}delete X.binding;delete X.modelChangeHandler;delete X.dataStateChangeHandler;delete X.modelRefreshHandler;if(W.factory||W.template){y.bindAggregation(N,X);}else{y.bindProperty(N,X);}}}if(j._supportInfo){j._supportInfo.addSupportInfo(y.getId(),j._supportInfo.byId(this.getId()));}if(this._cloneMetadataContexts){this._cloneMetadataContexts(y);}if(this.mForwardedAggregations){for(N in this.mForwardedAggregations){var Y=y.getMetadata().getAggregationForwarder(N);if(Y){Y.getTarget(y,true);}}}return y;};j._handleLocalizationChange=function(a){var i;if(a===1){q.each(this.oModels,function(n,b){if(b&&b._handleLocalizationChange){b._handleLocalizationChange();}});}else if(a===2){q.each(this.mBindingInfos,function(n,b){var c=b.parts;if(c){for(i=0;i<c.length;i++){if(b.type&&b.type._handleLocalizationChange){b.type._handleLocalizationChange();}}if(b.modelChangeHandler){b.modelChangeHandler();}}});}};j.prototype.findAggregatedObjects=function(r,c){var b=[];if(c&&typeof c!=="function"){c=null;}function l(s){var a,i,n;for(n in s.mAggregations){a=s.mAggregations[n];if(Array.isArray(a)){for(i=0;i<a.length;i++){if(!c||c(a[i])){b.push(a[i]);}if(r){l(a[i]);}}}else if(a instanceof j){if(!c||c(a)){b.push(a);}if(r){l(a);}}}}l(this);return b;};j._defaultContextualSettings={};return j;});
