/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ComboBox','./library','sap/ui/core/History','sap/ui/core/SeparatorItem',"./DropdownBoxRenderer"],function(q,C,a,H,S,D){"use strict";var b=C.extend("sap.ui.commons.DropdownBox",{metadata:{library:"sap.ui.commons",properties:{searchHelpEnabled:{type:"boolean",group:"Behavior",defaultValue:false},searchHelpText:{type:"string",group:"Appearance",defaultValue:null},searchHelpAdditionalText:{type:"string",group:"Appearance",defaultValue:null},searchHelpIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},maxHistoryItems:{type:"int",group:"Behavior",defaultValue:0}},events:{searchHelp:{parameters:{value:{type:"string"}}}}}});b.prototype.init=function(){C.prototype.init.apply(this,arguments);this._oValueBeforePaste=null;this._oValueBeforeOpen=null;this.__aItems=null;this._iCursorPosBeforeBackspace=null;this._searchHelpItem=null;this._iItemsForHistory=10;this._oHistory=new H(this.getId());};b.prototype.exit=function(){var I=this.getId()+"-h-";if(this._searchHelpItem){this._searchHelpItem[0].destroy();this._searchHelpItem[1].destroy();this._searchHelpItem=null;}C.prototype.exit.apply(this,arguments);function r(c){var o=sap.ui.getCore().byId(c);if(o){o.destroy();}}for(var i=0;i<this.getMaxHistoryItems();i++){r(I+i);}if(this.__oSeparator){this.__oSeparator.destroy();this.__oSeparator=null;}this._oHistory=null;this.__aItems=null;this._sWantedValue=undefined;};b.prototype.onAfterRendering=function(e){C.prototype.onAfterRendering.apply(this,arguments);if(!this._sHandleItemsChanged){this.checkValueInItems();}};b.prototype.getItems=function(){if(this.oPopup&&this.oPopup.isOpen()){return this.__aItems;}else{return C.prototype.getItems.apply(this,arguments);}};b.prototype.insertItem=function(i,I){if(this.oPopup&&this.oPopup.isOpen()){this.__aItems.splice(I,0,i);if(this.__aItems.length<=this._iItemsForHistory&&!this._searchHelpItem){this._getListBox().insertItem(i,I);}if(!this._bNoItemCheck){var r=q(this.getInputDomRef());var c=r.cursorPos();this._doTypeAhead(r.val().substr(0,c),"");}return this;}else{return C.prototype.insertItem.apply(this,arguments);}};b.prototype.addItem=function(i){if(this.oPopup&&this.oPopup.isOpen()){this.__aItems.push(i);if(this.__aItems.length<=this._iItemsForHistory&&!this._searchHelpItem){this._getListBox().addItem(i);}if(!this._bNoItemCheck){var r=q(this.getInputDomRef());var c=r.cursorPos();this._doTypeAhead(r.val().substr(0,c),"");}return this;}else{return C.prototype.addItem.apply(this,arguments);}};b.prototype.removeItem=function(e){if(this.oPopup&&this.oPopup.isOpen()){var I=null;var o=e;if(typeof(e)=="string"){e=sap.ui.getCore().byId(e);}if(typeof(e)=="object"){for(var i=0;i<this.__aItems.length;i++){if(this.__aItems[i]==e){e=i;break;}}}if(typeof(e)=="number"){if(e<0||e>=this.__aItems.length){q.sap.log.warning("Element.removeAggregation called with invalid index: Items, "+e);}else{I=this.__aItems[e];this.__aItems.splice(e,1);}}if(this.__aItems.length<=this._iItemsForHistory&&!this._searchHelpItem){this._getListBox().removeItem(o);}if(!this._bNoItemCheck){var r=q(this.getInputDomRef());var c=r.cursorPos();this._doTypeAhead(r.val().substr(0,c),"");}return I;}else{return C.prototype.removeItem.apply(this,arguments);}};b.prototype.removeAllItems=function(){if(this.oPopup&&this.oPopup.isOpen()){var i=this.__aItems;if(!i){return[];}C.prototype.removeAllItems.apply(this,arguments);this.__aItems=[];return i;}else{return C.prototype.removeAllItems.apply(this,arguments);}};b.prototype.indexOfItem=function(I){if(this.oPopup&&this.oPopup.isOpen()){if(this.__aItems){if(this.__aItems.length==undefined){return-2;}for(var i=0;i<this.__aItems.length;i++){if(this.__aItems[i]==I){return i;}}}return-1;}else{return C.prototype.indexOfItem.apply(this,arguments);}};b.prototype.destroyItems=function(){if(this.oPopup&&this.oPopup.isOpen()){if(!this.__aItems){return this;}this._getListBox().removeAllItems();for(var i=0;i<this.__aItems.length;i++){if(this.__aItems[i]){this.__aItems[i].destroy();}}this.__aItems=[];return this;}else{return C.prototype.destroyItems.apply(this,arguments);}};b.prototype.updateItems=function(){C.prototype.updateItems.apply(this,arguments);if(this.oPopup&&this.oPopup.isOpen()){var r=q(this.getInputDomRef());var c=r.cursorPos();this._doTypeAhead(r.val().substr(0,c),"");}};b.prototype._handleItemsChanged=function(e,d){if(d){this._sHandleItemsChanged=null;this._bNoItemCheck=undefined;}if(this._bNoItemCheck){return;}if(this.__aItems&&(!this.oPopup||!this.oPopup.isOpen())){throw new Error("DropdownBox "+this.getId()+" : this.__aItems is not empty!");}if(this.getListBox()&&this.oPopup&&this.oPopup.isOpen()){if(this.__aItems.length>this._iItemsForHistory||this._searchHelpItem){var I;var i=0;switch(e.getParameter("event")){case"destroyItems":for(i=0;i<this.__aItems.length;i++){I=this.__aItems[i];if(!I.bIsDestroyed){I.destroy();}}this.__aItems=[];if(this.getSearchHelpEnabled()){this._searchHelpItem=null;this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),this.getSearchHelpAdditionalText(),this.getSearchHelpIcon());}break;case"removeAllItems":this.__aItems=[];break;case"removeItem":I=e.getParameter("item");for(i=0;i<this.__aItems.length;i++){if(this.__aItems[i]==I){this.__aItems.splice(i,1);break;}}if(this.__aItems.length<=this._iItemsForHistory){this._getListBox().setItems(this.__aItems,false,true);}break;case"insertItem":this.__aItems.splice(e.getParameter("index"),0,e.getParameter("item"));break;case"addItem":this.__aItems.push(e.getParameter("item"));break;case"setItems":this.__aItems=e.getParameter("items");break;case"updateItems":for(i=0;i<this.__aItems.length;i++){I=this.__aItems[i];if(!I.bIsDestroyed){I.destroy();}}if(this.getSearchHelpEnabled()){this._searchHelpItem=null;this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),this.getSearchHelpAdditionalText(),this.getSearchHelpIcon());}this.__aItems=this._getListBox().getItems();break;default:break;}}else{this.__aItems=this._getListBox().getItems();}var r=q(this.getInputDomRef());var c=r.cursorPos();this._doTypeAhead(r.val().substr(0,c),"");}C.prototype._handleItemsChanged.apply(this,arguments);this.checkValueInItems();};b.prototype.onclick=function(e){if(!this.mobile&&this.getEnabled&&this.getEnabled()&&this.getEditable()){if(this.oPopup&&this.oPopup.isOpen()){this._close();this._doSelect();}else if(!this._F4ForClose){this._open();}this.focus();}this._F4ForClose=false;};b.prototype.onmousedown=function(e){if(!this.getEnabled()||!this.getEditable()){return;}if(this.oPopup&&this.oPopup.isOpen()){this._F4ForClose=true;}else{this._F4ForOpen=true;}C.prototype.onmousedown.apply(this,arguments);};b.prototype.onsapshow=function(e){if(this.mobile){return;}if(!this.getEnabled()||!this.getEditable()){e.preventDefault();e.stopImmediatePropagation();return;}if(e.which===q.sap.KeyCodes.F4&&this._searchHelpItem){this._close();this.fireSearchHelp({value:q(this.getInputDomRef()).val()});e.preventDefault();e.stopImmediatePropagation();return;}if(this.oPopup&&this.oPopup.isOpen()){this._close();}else{this._open();var l=this._getListBox();l.scrollToIndex(l.getSelectedIndex());this._doSelect();}e.preventDefault();e.stopImmediatePropagation();};b.prototype.onkeydown=function(e){if(e.target.id==this.getId()+"-select"){return;}if(!!sap.ui.Device.browser.webkit&&(e.which==q.sap.KeyCodes.DELETE||e.which==q.sap.KeyCodes.BACKSPACE)){this.onkeypress(e);}if(!sap.ui.Device.browser.internet_explorer||e.which!==q.sap.KeyCodes.BACKSPACE){return;}this._iCursorPosBeforeBackspace=q(this.getInputDomRef()).cursorPos();};b.prototype.onpaste=function(e){if(e.target.id==this.getId()+"-select"){return;}if(this._oValueBeforePaste===null){this._oValueBeforePaste=q(this.getInputDomRef()).val();}};b.prototype.oncut=b.prototype.onpaste;b.prototype.oninput=function(e){if(this.mobile){return;}if(!this._realOninput(e)){return;}var r=q(this.getInputDomRef());var v=r.val();if(!this.oPopup||!this.oPopup.isOpen()){this.noTypeAheadByOpen=true;this._open();this.noTypeAheadByOpen=undefined;}var V=this._doTypeAhead(v,"");if(!V&&this._oValueBeforePaste){this._doTypeAhead("",this._oValueBeforePaste);}this._oValueBeforePaste=null;this._fireLiveChange(e);};b.prototype.onkeyup=function(e){if(e.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}var k=e.which,K=q.sap.KeyCodes;sap.ui.commons.TextField.prototype.onkeyup.apply(this,arguments);if(!(!!sap.ui.Device.browser.internet_explorer&&k===K.BACKSPACE)&&this._oValueBeforePaste===null||k===K.TAB){return;}if(!this.oPopup||!this.oPopup.isOpen()){this.noTypeAheadByOpen=true;this._open();this.noTypeAheadByOpen=undefined;}var r=q(this.getInputDomRef()),v=false;if(k===K.BACKSPACE&&this._iCursorPosBeforeBackspace!==null){var c=r.cursorPos();if(this._iCursorPosBeforeBackspace!==c){c++;}this._iCursorPosBeforeBackspace=null;v=this._doTypeAhead(r.val().substr(0,c-1),"");}else if(!(v=this._doTypeAhead("",r.val()))){r.val(this._oValueBeforePaste);}if(v){this._getListBox().rerender();}this._oValueBeforePaste=null;};b.prototype.onsaphome=function(e){if(e.target.id==this.getId()+"-select"){return;}if((!this.oPopup||!this.oPopup.isOpen())&&this.getEditable()&&this.getEnabled()){sap.ui.commons.TextField.prototype.onsaphome.apply(this,arguments);var r=q(this.getInputDomRef());r.cursorPos(0);this._updateSelection();e.preventDefault();}else{C.prototype.onsaphome.apply(this,arguments);}};b.prototype.onsapdelete=function(e){if(e.target.id==this.getId()+"-select"){return;}if(!this.oPopup||!this.oPopup.isOpen()){return;}var l=this._getListBox(),i=l.getSelectedItem(),m=i.getId().match(/\-h\-([0-4])/),I=l.getSelectedIndex();if(m&&m.length===2){this._oHistory.remove(i.getText());l.removeItem(I);var L=this._oHistory.get().length;if(L===0){l.removeItem(0);}l.rerender();var n=I+(this._searchHelpItem?2:0);if(n==L){n++;}l.setSelectedIndex(n);this.setValue(l.getSelectedItem().getText());}};b.prototype.onkeypress=function(e){if(e.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}var k=e.which,K=e.keyCode,o=q.sap.KeyCodes;if((C._isHotKey(e)||(!!sap.ui.Device.browser.firefox&&K===o.HOME)||K===o.F4&&e.which===0)&&!(e.ctrlKey&&e.which==120)){return;}else if(K==o.ESCAPE){var v=this.getProperty("value");var i=this.getInputDomRef();if(i&&i.value!==v){q(i).val(v);}return;}var n=String.fromCharCode(k),r=q(this.getInputDomRef()),c=r.cursorPos(),V=r.val();if(!this.oPopup||!this.oPopup.isOpen()){this.noTypeAheadByOpen=true;this._open();this.noTypeAheadByOpen=undefined;}if(k===o.BACKSPACE){this._doTypeAhead(V.substr(0,c-1),"");}else{this._doTypeAhead(V.substr(0,c),n);}if(V!=r.val()){this._fireLiveChange(e);}this._bFocusByOpen=undefined;e.preventDefault();};b.prototype.onsapright=function(e){if(e.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}var r=sap.ui.getCore().getConfiguration().getRTL();if(!r){this._updateSelection(1);}else{this._updateSelection(-1);}e.preventDefault();};b.prototype.onsapleft=function(e){if(e.target.id==this.getId()+"-select"){return;}if(!this.getEnabled()||!this.getEditable()){return;}var r=sap.ui.getCore().getConfiguration().getRTL();if(!r){this._updateSelection(-1);}else{this._updateSelection(1);}e.preventDefault();};b.prototype.onfocusin=function(e){if(!this.oPopup||!this.oPopup.isOpen()||this._bFocusByOpen){var r=q(this.getInputDomRef()),l=r.val().length;if(l>0&&!this.mobile){this._callDoSelectAfterFocusIn(0,l);}this._bFocusByOpen=undefined;}C.prototype.onfocusin.apply(this,arguments);};b.prototype._callDoSelectAfterFocusIn=function(s,e){if(!sap.ui.Device.browser.internet_explorer){this._doSelect(s,e);}else{if(!this._eDoSelectAfterFocusIn||this._eDoSelectAfterFocusIn!=="_doSelect"){this._eDoSelectAfterFocusIn="onfocusin";this._doSelect(s,e);}else{this._eDoSelectAfterFocusIn=undefined;}}};b.prototype.onselect=function(e){var t=new Date().getTime();if(this._bIgnoreSelect){this._bIgnoreSelect=false;this.iOldTimestamp=t;return;}if(this.iOldTimestamp&&t-this.iOldTimestamp<50){return;}this.iOldTimestamp=undefined;if(!this.getEnabled()||!this.getEditable()){return;}var r=q(this.getInputDomRef()),n=r.cursorPos(),v=r.val();if(v.length>0&&n>0){this._doTypeAhead(v.substr(0,n),"");if(!this.oPopup||!this.oPopup.isOpen()){this._cleanupClose(this._getListBox());}}e.preventDefault();};b.prototype._determinePosinset=function(i,n){var p=n+1;if(this.oPopup&&this.oPopup.isOpen()){this.dontSetPoisinset=undefined;var I=i[n];var h=i[0].getId().search(this.getId()+"-h-")!=-1;if(I.getId().search(this.getId()+"-h-")==-1){if(h){p=p-1;}if(this._searchHelpItem){p=p-2;}}}return p;};b.prototype._doSelect=function(s,e){this._bIgnoreSelect=true;var d=this.getInputDomRef();if(d){var r=q(d);r.selectText(s?s:0,e?e:r.val().length);}return this;};b.prototype._updateSelection=function(m){var r=q(this.getInputDomRef()),n=r.cursorPos()+(m||0),v=r.val();this._doTypeAhead(v.substr(0,n),"");if(!this.oPopup||!this.oPopup.isOpen()){this._cleanupClose(this._getListBox());}else{this._getListBox().rerender();}};b.prototype._doTypeAhead=function(v,n,N,I){if(this.__doTypeAhead===true){return;}this.__doTypeAhead=true;this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;this._sWantedValue=undefined;var l=this._getListBox(),m=this.getMaxPopupItems(),c=this.__aItems||l.getItems(),V=c.length,h=this.getMaxHistoryItems()>0&&c.length>this._iItemsForHistory,f=!N&&h,o=v+n,s=new RegExp("[.*+?|()\\[\\]{}\\\\]","g"),r=o.toLowerCase().replace(s,"\\$&"),d=RegExp("^"+r+".*$"),M=n&&n.length||0,R=q(this.getInputDomRef());this.__aItems=c;if(V<=0){this.__doTypeAhead=false;return false;}var e,F=this._getFilteredItems(c,d),g=F.length>0;if(!g){f=false;}if(f){e=F;}else{e=c.slice(0);}var j=[];if(h){j=this._addHistoryItems(e,f&&d);l.setItems(e,false,true);V=e.length;}l.setVisibleItems(m<V?m:-1);var k,p=j.length;var i=0;if(I>=0){k=c[I];}if(!f&&p>0&&g){j=this._getFilteredItems(j,d);k=j[0];}if(f){k=F[0];}else if(!k){if(F.length>0){k=F[0];}else{var O=R.val();var t=0;for(i=0;i<e.length;i++){var u=e[i];if(u.getEnabled()){if(!t){t=i;}if(u.getText()==O){k=u;break;}}}if(!k){k=e[t];}}}var w=this._searchHelpItem;if(w){e.splice(p++,0,w[0],w[1]);l.setItems(e,false,true);}i=l.indexOfItem(k);var T=k.getText();var P=i+1;var x=e.length;if(j.length>0){x=x-1;}if(w){x=x-2;}if(P>j.length){if(j.length>0){P=P-1;}if(w){P=P-2;}}this._updatePosInSet(R,P,(k.getAdditionalText?k.getAdditionalText():""));R.attr("aria-setsize",x);R.val(T);this._sTypedChars=o;this._doSelect(v.length+M,T.length);l.setSelectedIndex(i);if(w&&i==2){l.scrollToIndex(0);}else{l.scrollToIndex(i);}this._iClosedUpDownIdx=i;if(!g){R=this.$();R.addClass("sapUiTfErr");q.sap.delayedCall(300,R,"removeClass",["sapUiTfErr"]);R.cursorPos(v.length);this._doSelect(v.length,T.length);}this.__doTypeAhead=false;return g;};b.prototype._prepareOpen=function(l,p){this._oValueBeforeOpen=q(this.getInputDomRef()).val();this._bOpening=true;if(!this.noTypeAheadByOpen){var i;if(this._iClosedUpDownIdx>=0){i=this._iClosedUpDownIdx;}else if(this.getSelectedItemId()){i=this.indexOfItem(sap.ui.getCore().byId(this.getSelectedItemId()));}this._doTypeAhead("",q(this.getInputDomRef()).val(),true,i);this._doSelect();}return this;};b.prototype._handleOpened=function(){C.prototype._handleOpened.apply(this,arguments);if(!sap.ui.Device.browser.internet_explorer){q(this.getInputDomRef()).focus();}else{this._bFocusByOpen=true;}};b.prototype._cleanupClose=function(l){if(this.__aItems){var s=l.getSelectedItem();l.setItems(this.__aItems,false,true);this._iClosedUpDownIdx=l.indexOfItem(s);l.setSelectedIndex(this._iClosedUpDownIdx);this.__aItems=undefined;}this._oValueBeforeOpen=null;this._bOpening=undefined;return this;};b.prototype._getFilteredItems=function(I,r){var t=I.slice(0),o;for(var i=t.length-1;i>=0;i--){o=t[i];if(!r.test(o.getText().toLowerCase())||!o.getEnabled()){t.splice(i,1);}}return t;};b.prototype._addHistoryItems=function(I,r){var s=this.getId()+"-h-",o,h=this._oHistory.get(),l=h.length,n=[];for(var i=0,j=0;j<this.getMaxHistoryItems()&&i<l;i++){if(!r||r.test(h[i])){o=(o=sap.ui.getCore().byId(s+j))&&o.setText(h[i])||new sap.ui.core.ListItem(s+j,{text:h[i]});n.push(o);j++;}}if(n.length>0){var c=s+"separator",d=this._getSeparator(c);n.push(d);}I.unshift.apply(I,n);return n;};b.prototype._getSeparator=function(s){if(!this.__oSeparator&&s){this.__oSeparator=sap.ui.getCore().byId(s)||new S(s);}return this.__oSeparator||null;};b.prototype.fireChange=function(A){this.fireEvent("change",A);if(A.newValue&&(this.getMaxHistoryItems()>0)){this._oHistory.add(A.newValue);}this._sWantedValue=undefined;return this;};b.prototype.setValue=function(v,n){v=(v===undefined||v===null||v==="")?"":v;var I=this.getItems(),t,V=false,f;for(var i=0,l=I.length;i<l&&!V;i++){var o=I[i];var e=o.getEnabled();t=o.getText();if(e&&!f){f=t;}V=t===v&&e;}if(V){C.prototype.setValue.call(this,v,n);this._sWantedValue=undefined;}else if(v===""&&I.length>0){C.prototype.setValue.call(this,f,n);}else{this._sWantedValue=v;}return this;};b.prototype.applyFocusInfo=function(f){C.prototype.applyFocusInfo.apply(this,arguments);if(!this._bOpening&&(!this.oPopup||!this.oPopup.isOpen())){this._cleanupClose(this._getListBox());}return this;};b.prototype._focusAfterListBoxClick=function(){if(!sap.ui.Device.browser.webkit){this.focus();}else{var l=this._getListBox();l.addDelegate({onclick:function(){l.removeDelegate(this);this.focus();}.bind(this)});}};b.prototype.onsapfocusleave=function(e){var l=this._getListBox();if(e.relatedControlId&&q.sap.containsOrEquals(l.getFocusDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){this._focusAfterListBoxClick();}else{if(this.oPopup&&this.oPopup.isOpen()){this._close();}sap.ui.commons.TextField.prototype.onsapfocusleave.apply(this,arguments);}};b.prototype.getTooltip_AsString=function(){var t=C.prototype.getTooltip_AsString.apply(this,arguments);if(!this._searchHelpItem){return t;}else{var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var s=r.getText("DDBX_SHI_ARIA");s=s==="DDBX_SHI_ARIA"?"Open search help via {0}":s;var A=this._searchHelpItem[0]&&this._searchHelpItem[0].getAdditionalText()||r.getText("DDBX_SHIF4");A=A==="DDBX_SHIF4"?"F4":A;s=s.replace("{0}",A);return(t?t+" - ":"")+s;}};b.prototype._handleSelect=function(c){if(this._searchHelpItem&&c.getParameter("selectedItem")===this._searchHelpItem[0]){var e=new q.Event("sapshow");e.which=q.sap.KeyCodes.F4;this.onsapshow(e);}else{var i=c.getParameter("selectedItem");if(!i){i=sap.ui.getCore().byId(c.getParameter("selectedId"));}if(i.getId().search(this.getId()+"-h-")!=-1){var l=this._getListBox(),I=l.getItems();var L=this._oHistory.get().length;if(L>this.getMaxHistoryItems()){L=Math.max(this.getMaxHistoryItems(),0);}for(var d=L;d<I.length;d++){if(I[d].getText()==i.getText()&&I[d].getEnabled()){c.mParameters.selectedIndex=d;if(!c.getParameter("selectedIndices")){c.mParameters.selectedIndices=new Array(1);c.mParameters.aSelectedIndices=new Array(1);}c.mParameters.selectedIndices[0]=d;c.mParameters.aSelectedIndices[0]=d;c.mParameters.selectedItem=I[d];break;}}}this._sWantedValue=undefined;return C.prototype._handleSelect.apply(this,arguments);}};b.prototype.setSearchHelpEnabled=function(e,t,A,i){this.setProperty("searchHelpEnabled",e);if(t){this.setProperty("searchHelpText",t);}else{t=this.getSearchHelpText();}if(A){this.setProperty("searchHelpAdditionalText",A);}else{A=this.getSearchHelpAdditionalText();}if(i){this.setProperty("searchHelpIcon",i);}else{i=this.getSearchHelpIcon();}if(e){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(r){t=t||r.getText("DDBX_SHI");t=t==="DDBX_SHI"?"Search Help":t;A=A||r.getText("DDBX_SHIF4");A=A==="DDBX_SHIF4"?"F4":A;}i=i||sap.ui.resource("sap.ui.commons","images/dropdown/ico12_f4.gif");if(!this._searchHelpItem){this._searchHelpItem=[new sap.ui.core.ListItem(this.getId()+"_shi",{text:t,additionalText:A,enabled:true,icon:i}),new S()];}else{this._searchHelpItem[0].setText(t).setAdditionalText(A).setIcon(i);}}else{if(this._searchHelpItem){this._searchHelpItem[0].destroy();this._searchHelpItem[1].destroy();this._searchHelpItem=null;}}return this;};b.prototype.setSearchHelpText=function(s){this.setProperty("searchHelpText",s);this.setSearchHelpEnabled(this.getSearchHelpEnabled(),s,this.getSearchHelpAdditionalText(),this.getSearchHelpIcon());return this;};b.prototype.setSearchHelpAdditionalText=function(s){this.setProperty("searchHelpAdditionalText",s);this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),s,this.getSearchHelpIcon());return this;};b.prototype.setSearchHelpIcon=function(s){this.setProperty("searchHelpIcon",s);this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),this.getSearchHelpAdditionalText(),s);return this;};b.prototype.checkValueInItems=function(){var v=this.getValue();var I=C.prototype.getItems.apply(this);var w=this._sWantedSelectedKey;var W=this._sWantedSelectedItemId;if(I&&I.length>0){var V=false;var f;var i=0,l=0;var o;var e=false;var t="";if(this._sWantedValue){for(i=0,l=I.length;i<l&&!V;i++){o=I[i];e=o.getEnabled();t=o.getText();if(e&&!f){f=t;}V=t===this._sWantedValue&&e;}if(V){v=this._sWantedValue;this._sWantedValue=undefined;w=undefined;W=undefined;C.prototype.setValue.call(this,v);}}if(!V){for(i=0,l=I.length;i<l&&!V;i++){o=I[i];e=o.getEnabled();t=o.getText();if(e&&!f){f=t;}V=t===v&&e;}}if(!V){v=f;C.prototype.setValue.call(this,v);}}else{v="";C.prototype.setValue.call(this,v);}this._sWantedSelectedKey=w;this._sWantedSelectedItemId=W;return v;};b.prototype.setMaxHistoryItems=function(m){var o=this.getMaxHistoryItems();var I=this.getId()+"-h-";var c;this.setProperty('maxHistoryItems',m,true);if(m<o){var l=this._getListBox();for(var i=Math.max(m,0);i<o;i++){c=sap.ui.getCore().byId(I+i);if(c){l.removeItem(c);c.destroy();}}if(m<=0&&this.__oSeparator){l.removeItem(this.__oSeparator);}}return this;};b.prototype.clearHistory=function(){this._oHistory.clear();var I=this.getId()+"-h-";var l=this._getListBox();var o;for(var i=0;i<this.getMaxHistoryItems();i++){o=sap.ui.getCore().byId(I+i);if(o){l.removeItem(o);o.destroy();}}if(this.__oSeparator){l.removeItem(this.__oSeparator);}};b.prototype.ondrop=function(e){e.preventDefault();};b.prototype._isSetEmptySelectedKeyAllowed=function(){return false;};return b;},true);
