/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control',"./TreeRenderer"],function(q,l,C,T){"use strict";var a=C.extend("sap.ui.commons.Tree",{metadata:{library:"sap.ui.commons",properties:{title:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'auto'},showHeader:{type:"boolean",group:"Misc",defaultValue:true},showHeaderIcons:{type:"boolean",group:"Misc",defaultValue:true},showHorizontalScrollbar:{type:"boolean",group:"Misc",defaultValue:false},minWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},selectionMode:{type:"sap.ui.commons.TreeSelectionMode",group:"Behavior",defaultValue:sap.ui.commons.TreeSelectionMode.Legacy}},defaultAggregation:"nodes",aggregations:{nodes:{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"node",bindable:"bindable"}},events:{select:{allowPreventDefault:true,parameters:{node:{type:"sap.ui.commons.TreeNode"},nodeContext:{type:"object"}}},selectionChange:{parameters:{nodes:{type:"sap.ui.commons.TreeNode[]"},nodeContexts:{type:"object[]"}}}}}});a.prototype.resizeListenerId;a.prototype.init=function(){this.bAllCollapsed=false;this.allowTextSelection(false);this.iOldScrollTop=null;this.mSelectedNodes={};this.mSelectedContexts={};this.aLeadSelection=null;var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.oCollapseAllButton=new sap.ui.commons.Button(this.getId()+"-CollapseAll",{icon:this.getIconPrefix()+"CollapseAll.png",tooltip:R.getText("TREE_COLLAPSE_ALL"),lite:true});this.oExpandAllButton=new sap.ui.commons.Button(this.getId()+"-ExpandAll",{icon:this.getIconPrefix()+"ExpandAll.png",tooltip:R.getText("TREE_EXPAND_ALL"),lite:true});this.oCollapseAllButton.attachPress(this.onCollapseAll,this);this.oExpandAllButton.attachPress(this.onExpandAll,this);this.oCollapseAllButton.addStyleClass("sapUiTreeCol");this.oExpandAllButton.addStyleClass("sapUiTreeExp");};a.prototype.exit=function(){if(this.oCollapseAllButton){this.oCollapseAllButton.destroy();this.oCollapseAllButton=null;}if(this.oExpandAllButton){this.oExpandAllButton.destroy();this.oExpandAllButton=null;}};a.SelectionType={Select:"Select",Toggle:"Toggle",Range:"Range"};a.prototype.onThemeChanged=function(){if(this.oCollapseAllButton&&this.oExpandAllButton){this.oCollapseAllButton.setIcon(this.getIconPrefix()+"CollapseAll.png");this.oExpandAllButton.setIcon(this.getIconPrefix()+"ExpandAll.png");}};a.prototype.onExpandAll=function(){this.expandAll();};a.prototype.onCollapseAll=function(){this.collapseAll();};a.prototype.expandAll=function(){var n=this._getNodes();for(var i=0;i<n.length;i++){n[i].expand(true,true);this._adjustSelectionOnExpanding(n[i]);}};a.prototype.collapseAll=function(){var n=this._getNodes();for(var i=0;i<n.length;i++){n[i].collapse(true,true);this._adjustSelectionOnCollapsing(n[i]);}this._adjustFocus();};a.prototype.onsapdown=function(e){this.moveFocus(false);e.preventDefault();};a.prototype.onsapup=function(e){this.moveFocus(true);e.preventDefault();};a.prototype.onsaphome=function(e){this.placeFocus(this.getFirstSibling(e.target));e.preventDefault();};a.prototype.onsaphomemodifiers=function(e){this.placeFocus(this.getFirst());e.preventDefault();};a.prototype.onsapend=function(e){this.placeFocus(this.getLastSibling(e.target));e.preventDefault();};a.prototype.onsapendmodifiers=function(e){this.placeFocus(this.getLast());e.preventDefault();};a.prototype.onsapcollapseall=function(e){if(this.bAllCollapsed){this.expandAll();}else{this.collapseAll();}this.bAllCollapsed=!this.bAllCollapsed;};a.prototype.getIconPrefix=function(){var i="themes/"+sap.ui.getCore().getConfiguration().getTheme()+"/";if(!sap.ui.getCore().getConfiguration().getRTL()){i+="img/tree/";}else{i+="img-RTL/tree/";}return sap.ui.resource("sap.ui.commons",i);};a.prototype.getFirstSibling=function(d){var D=q(d).siblings(".sapUiTreeNode:visible").first();if(D.length){return D[0];}return null;};a.prototype.getLastSibling=function(d){var D=q(d).siblings(".sapUiTreeNode:visible").last();if(D.length){return D[0];}return null;};a.prototype.getFirst=function(){var d=this.$().find(".sapUiTreeNode:visible").first();if(d.length){return d[0];}return null;};a.prototype.getLast=function(){var d=this.$().find(".sapUiTreeNode:visible").last();if(d.length){return d[0];}return null;};a.prototype.moveFocus=function(m){var c=q(".sapUiTreeNode:focus");if(c.length){var o=sap.ui.getCore().byId(c[0].id);var d=this.$().find(".sapUiTreeNode:visible");var e=d.index(c[0]);var n=e;if(m){n--;}else{n++;}if(n>=0&&n<d.length){var D=d.eq(n);var N=sap.ui.getCore().byId(D[0].id);o.blur();N.focus();}}};a.prototype._adjustFocus=function(){var f=this.$().find('.sapUiTreeNode[tabIndex="0"]');if(!f.is(':visible')){var d=this.$().find(".sapUiTreeNode");var c=d.index(f[0]);var D=d.filter(":lt("+c+")");var e=D.filter(":visible");var n=e[e.length-1];if(n){n.setAttribute("tabindex","0");if(q(".sapUiTreeNode:focus").is(":not(:visible)")){n.focus();}}}};a.prototype.placeFocus=function(d){if(!d){return;}var D=this.$().find(".sapUiTreeNode[tabIndex='0']");if(D.length){D[0].setAttribute("tabindex","-1");}d.setAttribute("tabindex","0");var t=sap.ui.getCore().byId(d.id);t.focus();};a.prototype._adjustSelectionOnExpanding=function(e){if(!e){return;}var E=[];if(e.getSelectedForNodes().length){E.push(e);}r(e,E,null);var $=e.$();if($&&$.hasClass('sapUiTreeNodeSelectedParent')){$.removeClass('sapUiTreeNodeSelectedParent');}var s=e.$('children').find('.sapUiTreeNodeExpanded.sapUiTreeNodeSelectedParent');s.removeClass('sapUiTreeNodeSelectedParent');};function r(n,e,f){var I=n.getExpanded(),N=false,c=I&&!!n.getSelectedForNodes().length,F=(f||I)?f:n,i;for(i=0;i<e.length;i++){if(e[i].getSelectedForNodes().indexOf(n.getId())!==-1){N=true;e[i].removeAssociation("selectedForNodes",n,true);}}if(F&&N&&F!==n){if(F.getSelectedForNodes().indexOf(n.getId())===-1){F.addAssociation("selectedForNodes",n,true);}F.$().addClass('sapUiTreeNodeSelectedParent');}if(c){e.push(n);}var d=n._getNodes();for(i=0;i<d.length;i++){r(d[i],e,F);}if(c){e.pop(n);}}function b(n,R){var N=n._getNodes(),c;for(var i=0;i<N.length;i++){c=N[i];if(c.getIsSelected()){R.addAssociation("selectedForNodes",c,true);}b(c,R);}}a.prototype._adjustSelectionOnCollapsing=function(c){if(!c){return;}b(c,c);if(c.getSelectedForNodes().length){var $=c.$();if($&&!$.hasClass('sapUiTreeNodeSelectedParent')){$.addClass('sapUiTreeNodeSelectedParent');}}};a.prototype.isTreeBinding=function(n){return(n=="nodes");};a.prototype.updateNodes=function(R){var n,N,k,c,i;if(R==="filter"){n=this.getAggregation("nodes");c=n.length;for(i=0;i<c;i++){n[i].destroy();}this.mSelectedNodes={};}this.updateAggregation("nodes");for(k in this.mSelectedContexts){N=this.getNodeByContext(this.mSelectedContexts[k]);if(N){N.setIsSelected(true);}else{this.mSelectedContexts=this._removeItemFromObject(this.mSelectedContexts,k);}}};a.prototype._removeItemFromObject=function(o,k){var K,R={};for(K in o){if(K!==k){R[K]=o[K];}}return R;};a.prototype.getNodeContext=function(n){var B=this.getBindingInfo("nodes"),m=B&&B.model;return n.getBindingContext(m);};a.prototype.getNodeByContext=function(c){var B=this.getBindingInfo("nodes"),m=B&&B.model;return this.findNode(this,function(n){var o=n.getBindingContext(m);return(c&&o&&c.getPath()===o.getPath());});};a.prototype.findNode=function(n,m){var f,t=this;if(m(n)){return n;}q.each(n._getNodes(),function(i,n){f=t.findNode(n,m);if(f){return false;}});return f;};a.prototype.setSelectionMode=function(m){m=this.validateProperty("selectionMode",m);if(this.getSelectionMode()!=m){this.setProperty("selectionMode",m);this._delSelection();}return this;};a.prototype.getSelection=function(){for(var i in this.mSelectedNodes){return this.mSelectedNodes[i];}return null;};a.prototype.setSelection=function(n,s,t){var d=true;if(!s){d=this.fireSelect({node:n,nodeContext:this.getNodeContext(n)});}if(d){switch(this.getSelectionMode()){case sap.ui.commons.TreeSelectionMode.Legacy:case sap.ui.commons.TreeSelectionMode.Single:this._setSelectedNode(n,s);break;case sap.ui.commons.TreeSelectionMode.Multi:if(t==a.SelectionType.Range){this._setSelectedNodeMapRange(n,s);}else if(t==a.SelectionType.Toggle){this._setSelectedNodeMapToggle(n,s);}else{this._setSelectedNode(n,s);}break;case sap.ui.commons.TreeSelectionMode.None:break;}}};a.prototype.onAfterRendering=function(){if(this.iOldScrollTop){this.$("TreeCont").scrollTop(this.iOldScrollTop);}};a.prototype.invalidate=function(){var t=this;C.prototype.invalidate.apply(this,arguments);if(this.iSelectionUpdateTimer){return;}this.iSelectionUpdateTimer=setTimeout(function(){t.mSelectedNodes={};t.mSelectedContexts=[];t.updateSelection(t,true);t.iSelectionUpdateTimer=null;},0);};a.prototype._addSelectedNodeContext=function(c){var p;if(c&&c.sPath){p=c.sPath;if(this.getSelectionMode()===sap.ui.commons.TreeSelectionMode.Multi){if(!(p in this.mSelectedContexts)){this.mSelectedContexts[p]=c;}}else{this.mSelectedContexts={};this.mSelectedContexts[p]=c;}}};a.prototype.updateSelection=function(n,e){var t=this;q.each(n._getNodes(),function(i,n){if(n.getIsSelected()){switch(t.getSelectionMode()){case sap.ui.commons.TreeSelectionMode.None:q.sap.log.warning("Added selected nodes in a tree with disabled selection");n.setIsSelected(false);break;case sap.ui.commons.TreeSelectionMode.Legacy:if(q.isEmptyObject(t.mSelectedNodes)){t.mSelectedNodes[n.getId()]=n;t._addSelectedNodeContext(t.getNodeContext(n));}break;case sap.ui.commons.TreeSelectionMode.Single:if(q.isEmptyObject(t.mSelectedNodes)==false){q.sap.log.warning("Added multiple selected nodes in single select tree");n.setIsSelected(false);}else{t.mSelectedNodes[n.getId()]=n;t._addSelectedNodeContext(t.getNodeContext(n));}break;case sap.ui.commons.TreeSelectionMode.Multi:if(!e){q.sap.log.warning("Added selected node inside collapsed node in multi select tree");n.setIsSelected(false);}else{t.mSelectedNodes[n.getId()]=n;t._addSelectedNodeContext(t.getNodeContext(n));}break;}}t.updateSelection(n,e&&n.getExpanded());});};a.prototype.onBeforeRendering=function(){this.iOldScrollTop=this.$("TreeCont").scrollTop();};a.prototype._setSelectedNode=function(n,s){var t=this,c=this.getNodeContext(n);q.each(this.mSelectedNodes,function(i,n){t._delMultiSelection(n,s);});n._select(s,true);this.mSelectedNodes[n.getId()]=n;this._addSelectedNodeContext(c);this.oLeadSelection=n;if(!s){this.fireSelectionChange({nodes:[n],nodeContexts:[c]});}};a.prototype._setSelectedNodeMapToggle=function(n,s){this._setNodeSelection(n,!n.getIsSelected(),s);};a.prototype._setSelectedNodeMapRange=function(n,s){var S,c=[],d=[],e,E,f,t;if(this.mSelectedNodes[n.getId()]==n){return;}else{if(this._getNodes().length>0){S=this._getSelectableNodes();e=S.indexOf(this.oLeadSelection);E=S.indexOf(n);f=e<E?e:E;t=e<E?E:e;for(var i=f;i<=t;i++){this._setMultiSelection(S[i],s);}}}if(!s){q.map(this.mSelectedNodes,function(n){c.push(n);});q.map(this.mSelectedContexts,function(o){d.push(o);});this.fireSelectionChange({nodes:c,nodeContexts:d});}};a.prototype._getSelectableNodes=function(n){var s=[];function c(n){q.each(n,function(i,N){if(N.getSelectable()){s.push(N);}if(N.getExpanded()){c(N._getNodes());}});}c(this._getNodes());return s;};a.prototype._setNodeSelection=function(n,i,s){var S=[],c=[],v;if(this.getSelectionMode()==sap.ui.commons.TreeSelectionMode.Single){if(i){var o=this.getSelection();this._setSelectedNode(n,s);if(!n.isVisible()){v=this._getVisibleNode(n);this._adjustSelectionOnCollapsing(v);}if(o&&!o.isVisible()){v=this._getVisibleNode(o);this._adjustSelectionOnExpanding(v);}return;}else{this._delMultiSelection(n,s);if(!n.isVisible()){v=this._getVisibleNode(n);this._adjustSelectionOnExpanding(v);}}}if(i){this._setMultiSelection(n,s);this.oLeadSelection=n;}else{this._delMultiSelection(n,s);this.oLeadSelection=n;}if(!s){q.map(this.mSelectedNodes,function(n){S.push(n);});q.map(this.mSelectedContexts,function(d){c.push(d);});this.fireSelectionChange({nodes:S,nodeContexts:c});}};a.prototype._setMultiSelection=function(s,S){if(!s){return;}s._select(S);this.mSelectedNodes[s.getId()]=s;this._addSelectedNodeContext(this.getNodeContext(s));};a.prototype._delMultiSelection=function(s){var c;if(!s){return;}s._deselect();this.mSelectedNodes=this._removeItemFromObject(this.mSelectedNodes,s.getId());c=s.getBindingContext();if(c&&c.sPath){if(c.sPath in this.mSelectedContexts){this.mSelectedContexts=this._removeItemFromObject(this.mSelectedContexts,c.sPath);}}};a.prototype._delSelection=function(){var t=this;if(this.oSelectedNode){this.oSelectedNode._deselect();}if(q.isEmptyObject(this.mSelectedNodes)==false){q.each(this.mSelectedNodes,function(i,n){t._delMultiSelection(n);});}};a.prototype._getNodes=function(){return this.mAggregations.nodes||[];};a.prototype._getVisibleNode=function(n){var p=n.getParent();if(p.isVisible()){var v=p;}else{v=this._getVisibleNode(p);}return v;};return a;},true);
