/*
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','./Manifest','./ComponentMetadata','sap/base/util/merge','sap/ui/base/ManagedObject','sap/ui/thirdparty/URI','sap/ui/performance/trace/Interaction','sap/base/assert','sap/base/Log','sap/base/util/ObjectPath','sap/base/util/UriParameters','sap/base/util/isPlainObject','sap/base/util/LoaderExtensions'],function(q,M,C,a,b,U,I,c,L,O,d,f,g){"use strict";var V={JSON:"JSON",XML:"XML",HTML:"HTML",JS:"JS",Template:"Template"};function h(e){['sap-client','sap-server'].forEach(function(N){if(!e.hasSearch(N)){var v=sap.ui.getCore().getConfiguration().getSAPParam(N);if(v){e.addSearch(N,v);}}});}function j(D,m,S,e){if(S){for(var N in D){if(!m[N]&&S[N]&&S[N].uri){m[N]=e;}}}}function k(m,e,K,i){var D=e.getEntry(K);if(D!==undefined&&!f(D)){return D;}var P,v;if(i&&(P=m.getParent())instanceof C){v=P.getManifestEntry(K,i);}if(v||D){D=q.extend(true,{},v,D);}return D;}function l(e,i){var v=Object.create(Object.getPrototypeOf(e));v._oMetadata=e;v._oManifest=i;for(var m in e){if(!/^(getManifest|getManifestObject|getManifestEntry|getMetadataVersion)$/.test(m)&&typeof e[m]==="function"){v[m]=e[m].bind(e);}}v.getManifest=function(){return i&&i.getJson();};v.getManifestObject=function(){return i;};v.getManifestEntry=function(K,y){return k(e,i,K,y);};v.getMetadataVersion=function(){return 2;};return v;}function r(e,i,T){c(typeof e==="function","fn must be a function");var m=b._sOwnerId;try{b._sOwnerId=i;return e.call(T);}finally{b._sOwnerId=m;}}var n=b.extend("sap.ui.core.Component",{constructor:function(i,S){var e=Array.prototype.slice.call(arguments);if(typeof i!=="string"){S=i;i=undefined;}if(S&&typeof S._metadataProxy==="object"){this._oMetadataProxy=S._metadataProxy;this._oManifest=S._metadataProxy._oManifest;delete S._metadataProxy;this.getMetadata=function(){return this._oMetadataProxy;};}if(S&&typeof S._cacheTokens==="object"){this._mCacheTokens=S._cacheTokens;delete S._cacheTokens;}if(S&&typeof S._manifestModels==="object"){this._mManifestModels=S._manifestModels;delete S._manifestModels;}else{this._mManifestModels={};}this._mServices={};b.apply(this,e);},metadata:{stereotype:"component","abstract":true,specialSettings:{componentData:'any'},version:"0.0",includes:[],dependencies:{libs:[],components:[],ui5version:""},config:{},customizing:{},library:"sap.ui.core"}},C);n.prototype.getManifest=function(){if(!this._oManifest){return this.getMetadata().getManifest();}else{return this._oManifest.getJson();}};n.prototype.getManifestEntry=function(K){return this._getManifestEntry(K);};n.prototype._getManifestEntry=function(K,m){if(!this._oManifest){return this.getMetadata().getManifestEntry(K,m);}else{return k(this.getMetadata(),this._oManifest,K,m);}};n.prototype.getManifestObject=function(){if(!this._oManifest){return this.getMetadata().getManifestObject();}else{return this._oManifest;}};n.prototype._isVariant=function(){if(this._oManifest){var e=this.getManifestEntry("/sap.ui5/componentName");return e&&e!==this.getManifestEntry("/sap.app/id");}else{return false;}};n.activateCustomizing=function(e){};n.deactivateCustomizing=function(e){};n.getOwnerIdFor=function(e){c(e instanceof b,"oObject must be given and must be a ManagedObject");var i=(e instanceof b)&&e._sOwnerId;return i||undefined;};n.getOwnerComponentFor=function(e){return n.get(n.getOwnerIdFor(e));};n.prototype.runAsOwner=function(e){return r(e,this.getId());};n.prototype.getInterface=function(){return this;};n.prototype._initCompositeSupport=function(S){this.oComponentData=S&&S.componentData;if(!this._isVariant()){this.getMetadata().init();}else{this._oManifest.init(this);var A=this._oManifest.getEntry("/sap.app/id");if(A){t(A,this._oManifest.resolveUri("./","manifest"));}}this.initComponentModels();if(this.onWindowError){this._fnWindowErrorHandler=q.proxy(function(e){var E=e.originalEvent;this.onWindowError(E.message,E.filename,E.lineno);},this);q(window).bind("error",this._fnWindowErrorHandler);}if(this.onWindowBeforeUnload){this._fnWindowBeforeUnloadHandler=q.proxy(this.onWindowBeforeUnload,this);q(window).bind("beforeunload",this._fnWindowBeforeUnloadHandler);}if(this.onWindowUnload){this._fnWindowUnloadHandler=q.proxy(this.onWindowUnload,this);q(window).bind("unload",this._fnWindowUnloadHandler);}};n.prototype.destroy=function(){for(var e in this._mServices){if(this._mServices[e].instance){this._mServices[e].instance.destroy();}}delete this._mServices;for(var m in this._mManifestModels){this._mManifestModels[m].destroy();}delete this._mManifestModels;if(this._fnWindowErrorHandler){q(window).unbind("error",this._fnWindowErrorHandler);delete this._fnWindowErrorHandler;}if(this._fnWindowBeforeUnloadHandler){q(window).unbind("beforeunload",this._fnWindowBeforeUnloadHandler);delete this._fnWindowBeforeUnloadHandler;}if(this._fnWindowUnloadHandler){q(window).unbind("unload",this._fnWindowUnloadHandler);delete this._fnWindowUnloadHandler;}if(this._oEventBus){this._oEventBus.destroy();delete this._oEventBus;}b.prototype.destroy.apply(this,arguments);sap.ui.getCore().getMessageManager().unregisterObject(this);if(!this._isVariant()){this.getMetadata().exit();}else{this._oManifest.exit(this);delete this._oManifest;}};n.prototype.getComponentData=function(){return this.oComponentData;};n.prototype.getEventBus=function(){if(!this._oEventBus){var E=sap.ui.requireSync("sap/ui/core/EventBus");this._oEventBus=new E();}return this._oEventBus;};n.prototype.initComponentModels=function(){var m=this.getMetadata();if(m.isBaseClass()){return;}var e=this._getManifestEntry("/sap.app/dataSources",true)||{};var i=this._getManifestEntry("/sap.ui5/models",true)||{};this._initComponentModels(i,e,this._mCacheTokens);};n.prototype._initComponentModels=function(m,D,e){var A=n._createManifestModelConfigurations({models:m,dataSources:D,component:this,mergeParent:true,cacheTokens:e});if(!A){return;}var i={};for(var v in A){if(!this._mManifestModels[v]){i[v]=A[v];}}var y=n._createManifestModels(i,this.toString());for(var v in y){this._mManifestModels[v]=y[v];}for(var v in this._mManifestModels){var z=this._mManifestModels[v];this.setModel(z,v||undefined);}};n.prototype.getService=function(e){if(!this._mServices[e]){this._mServices[e]={};this._mServices[e].promise=new Promise(function(R,i){sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(S){var m=this.getManifestEntry("/sap.ui5/services/"+e);var v=m&&m.factoryName;if(!v){i(new Error("Service "+e+" not declared!"));return;}var y=S.get(v);if(y){y.createInstance({scopeObject:this,scopeType:"component",settings:m.settings||{}}).then(function(A){if(!this.bIsDestroyed){this._mServices[e].instance=A;this._mServices[e].interface=A.getInterface();R(this._mServices[e].interface);}else{i(new Error("Service "+e+" could not be loaded as its Component was destroyed."));}}.bind(this)).catch(i);}else{var E="The ServiceFactory "+v+" for Service "+e+" not found in ServiceFactoryRegistry!";var z=this.getManifestEntry("/sap.ui5/services/"+e+"/optional");if(!z){L.error(E);}i(new Error(E));}}.bind(this),i);}.bind(this));}return this._mServices[e].promise;};function o(e){var S=e.getManifestEntry("/sap.ui5/services");for(var i in S){if(S[i].lazy===false){e.getService(i);}}}n.prototype.createComponent=function(v){c((typeof v==='string'&&v)||(typeof v==='object'&&typeof v.usage==='string'&&v.usage),"vUsage either must be a non-empty string or an object with a non-empty usage id");var m={async:true};if(v){var e;if(typeof v==="object"){e=v.usage;["id","async","settings","componentData"].forEach(function(N){if(v[N]!==undefined){m[N]=v[N];}});}else if(typeof v==="string"){e=v;}m=this._enhanceWithUsageConfig(e,m);}return n._createComponent(m,this);};n.prototype._enhanceWithUsageConfig=function(e,m){var i=this.getManifestEntry("/sap.ui5/componentUsages/"+e);if(!i){throw new Error("Component usage \""+e+"\" not declared in Component \""+this.getManifestObject().getComponentName()+"\"!");}return q.extend(true,i,m);};n._createComponent=function(m,e){function i(){if(m.async===true){return n.create(m);}else{return sap.ui.component(m);}}if(e){return e.runAsOwner(i);}else{return i();}};n._createManifestModelConfigurations=function(m){var e=m.component;var v=m.manifest||e.getManifestObject();var y=m.mergeParent;var z=m.cacheTokens||{};var A=e?e.toString():v.getComponentName();var B=sap.ui.getCore().getConfiguration();if(!m.models){return null;}var D={models:m.models,dataSources:m.dataSources||{},origin:{dataSources:{},models:{}}};if(e&&y){var E=e.getMetadata();while(E instanceof C){var F=E.getManifestObject();var G=E.getManifestEntry("/sap.app/dataSources");j(D.dataSources,D.origin.dataSources,G,F);var H=E.getManifestEntry("/sap.ui5/models");j(D.models,D.origin.models,H,F);E=E.getParent();}}var J={};for(var K in D.models){var N=D.models[K];var P=false;var Q=null;if(typeof N==='string'){N={dataSource:N};}if(N.dataSource){var R=D.dataSources&&D.dataSources[N.dataSource];if(typeof R==='object'){if(R.type===undefined){R.type='OData';}if(!N.type){switch(R.type){case'OData':if(R.settings&&R.settings.odataVersion==="4.0"){N.type='sap.ui.model.odata.v4.ODataModel';}else{N.type='sap.ui.model.odata.v2.ODataModel';}break;case'JSON':N.type='sap.ui.model.json.JSONModel';break;case'XML':N.type='sap.ui.model.xml.XMLModel';break;default:}}if(N.type==='sap.ui.model.odata.v4.ODataModel'&&R.settings&&R.settings.odataVersion){N.settings=N.settings||{};N.settings.odataVersion=R.settings.odataVersion;}if(!N.uri){N.uri=R.uri;P=true;}if(R.type==='OData'&&R.settings&&typeof R.settings.maxAge==="number"){N.settings=N.settings||{};N.settings.headers=N.settings.headers||{};N.settings.headers["Cache-Control"]="max-age="+R.settings.maxAge;}if(R.type==='OData'&&R.settings&&R.settings.annotations){var S=R.settings.annotations;for(var i=0;i<S.length;i++){var T=D.dataSources[S[i]];if(!T){L.error("Component Manifest: ODataAnnotation \""+S[i]+"\" for dataSource \""+N.dataSource+"\" could not be found in manifest","[\"sap.app\"][\"dataSources\"][\""+S[i]+"\"]",A);continue;}if(T.type!=='ODataAnnotation'){L.error("Component Manifest: dataSource \""+S[i]+"\" was expected to have type \"ODataAnnotation\" but was \""+T.type+"\"","[\"sap.app\"][\"dataSources\"][\""+S[i]+"\"]",A);continue;}if(!T.uri){L.error("Component Manifest: Missing \"uri\" for ODataAnnotation \""+S[i]+"\"","[\"sap.app\"][\"dataSources\"][\""+S[i]+"\"]",A);continue;}var W=new U(T.uri);if(N.type==='sap.ui.model.odata.v2.ODataModel'){["sap-language","sap-client"].forEach(function(i1){if(!W.hasQuery(i1)&&B.getSAPParam(i1)){W.setQuery(i1,B.getSAPParam(i1));}});var X=z.dataSources&&z.dataSources[T.uri];if(X){var Y=function(){if(!W.hasQuery("sap-language")){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+X+"\" for ODataAnnotation \""+S[i]+"\" ("+W.toString()+"). "+"Missing \"sap-language\" URI parameter","[\"sap.app\"][\"dataSources\"][\""+S[i]+"\"]",A);return;}if(!W.hasQuery("sap-client")){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+X+"\" for ODataAnnotation \""+S[i]+"\" ("+W.toString()+"). "+"Missing \"sap-client\" URI parameter","[\"sap.app\"][\"dataSources\"][\""+S[i]+"\"]",A);return;}if(!W.hasQuery("sap-client",B.getSAPParam("sap-client"))){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+X+"\" for ODataAnnotation \""+S[i]+"\" ("+W.toString()+"). "+"URI parameter \"sap-client="+W.query(true)["sap-client"]+"\" must be identical with configuration \"sap-client="+B.getSAPParam("sap-client")+"\"","[\"sap.app\"][\"dataSources\"][\""+S[i]+"\"]",A);return;}if(W.hasQuery("sap-context-token")&&!W.hasQuery("sap-context-token",X)){var i1=W.query(true)["sap-context-token"];L.warning("Component Manifest: Overriding existing \"sap-context-token="+i1+"\" with provided value \""+X+"\" for ODataAnnotation \""+S[i]+"\" ("+W.toString()+").","[\"sap.app\"][\"dataSources\"][\""+S[i]+"\"]",A);}W.setQuery("sap-context-token",X);};Y();}}var Z=D.origin.dataSources[S[i]]||v;var $=Z._resolveUri(W).toString();N.settings=N.settings||{};N.settings.annotationURI=N.settings.annotationURI||[];N.settings.annotationURI.push($);}}}else{L.error("Component Manifest: dataSource \""+N.dataSource+"\" for model \""+K+"\" not found or invalid","[\"sap.app\"][\"dataSources\"][\""+N.dataSource+"\"]",A);}}if(!N.type){L.error("Component Manifest: Missing \"type\" for model \""+K+"\"","[\"sap.ui5\"][\"models\"][\""+K+"\"]",A);continue;}if(N.type==='sap.ui.model.odata.ODataModel'&&(!N.settings||N.settings.json===undefined)){N.settings=N.settings||{};N.settings.json=true;}if(N.uri){var _=new U(N.uri);var a1=(P?D.origin.dataSources[N.dataSource]:D.origin.models[K])||v;_=a1._resolveUri(_);if(N.dataSource){h(_);if(N.type==='sap.ui.model.odata.v2.ODataModel'){Q=N.settings&&N.settings.metadataUrlParams;if((!Q||typeof Q['sap-language']==='undefined')&&!_.hasQuery('sap-language')&&B.getSAPParam('sap-language')){N.settings=N.settings||{};Q=N.settings.metadataUrlParams=N.settings.metadataUrlParams||{};Q['sap-language']=B.getSAPParam('sap-language');}if(z.dataSources){var X=z.dataSources[R.uri];if(X){var b1=function(){if(_.hasQuery("sap-context-token")){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+X+"\" for model \""+K+"\" ("+_.toString()+"). "+"Model URI already contains parameter \"sap-context-token="+_.query(true)["sap-context-token"]+"\"","[\"sap.ui5\"][\"models\"][\""+K+"\"]",A);return;}if((!Q||typeof Q["sap-language"]==="undefined")&&!_.hasQuery("sap-language")){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+X+"\" for model \""+K+"\" ("+_.toString()+"). "+"Missing \"sap-language\" parameter","[\"sap.ui5\"][\"models\"][\""+K+"\"]",A);return;}if(!_.hasQuery("sap-client")){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+X+"\" for model \""+K+"\" ("+_.toString()+"). "+"Missing \"sap-client\" parameter","[\"sap.ui5\"][\"models\"][\""+K+"\"]",A);return;}if(!_.hasQuery("sap-client",B.getSAPParam("sap-client"))){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+X+"\" for model \""+K+"\" ("+_.toString()+"). "+"URI parameter \"sap-client="+_.query(true)["sap-client"]+"\" must be identical with configuration \"sap-client="+B.getSAPParam("sap-client")+"\"","[\"sap.ui5\"][\"models\"][\""+K+"\"]",A);return;}if(Q&&typeof Q["sap-client"]!=="undefined"){if(Q["sap-client"]!==B.getSAPParam("sap-client")){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+X+"\" for model \""+K+"\" ("+_.toString()+"). "+"Parameter metadataUrlParams[\"sap-client\"] = \""+Q["sap-client"]+"\" must be identical with configuration \"sap-client="+B.getSAPParam("sap-client")+"\"","[\"sap.ui5\"][\"models\"][\""+K+"\"]",A);return;}}if(Q&&Q["sap-context-token"]&&Q["sap-context-token"]!==X){L.warning("Component Manifest: Overriding existing \"sap-context-token="+Q["sap-context-token"]+"\" with provided value \""+X+"\" for model \""+K+"\" ("+_.toString()+").","[\"sap.ui5\"][\"models\"][\""+K+"\"]",A);}if(!Q){N.settings=N.settings||{};Q=N.settings.metadataUrlParams=N.settings.metadataUrlParams||{};}Q["sap-context-token"]=X;};b1();}}}}N.uri=_.toString();}if(N.uriSettingName===undefined){switch(N.type){case'sap.ui.model.odata.ODataModel':case'sap.ui.model.odata.v2.ODataModel':case'sap.ui.model.odata.v4.ODataModel':N.uriSettingName='serviceUrl';break;case'sap.ui.model.resource.ResourceModel':N.uriSettingName='bundleUrl';break;default:}}var c1;var d1;if(e){d1=e.getComponentData();}else{d1=m.componentData;}c1=d1&&d1.startupParameters&&d1.startupParameters["sap-system"];if(!c1){c1=B.getSAPParam("sap-system");}var e1=false;var f1;if(c1&&["sap.ui.model.odata.ODataModel","sap.ui.model.odata.v2.ODataModel"].indexOf(N.type)!=-1){e1=true;f1=sap.ui.requireSync("sap/ui/model/odata/ODataUtils");}if(N.uri){if(e1){N.preOriginBaseUri=N.uri.split("?")[0];N.uri=f1.setOrigin(N.uri,{alias:c1});N.postOriginBaseUri=N.uri.split("?")[0];}if(N.uriSettingName!==undefined){N.settings=N.settings||{};if(!N.settings[N.uriSettingName]){N.settings[N.uriSettingName]=N.uri;}}else if(N.settings){N.settings=[N.uri,N.settings];}else{N.settings=[N.uri];}}else{if(e1&&N.uriSettingName!==undefined&&N.settings&&N.settings[N.uriSettingName]){N.preOriginBaseUri=N.settings[N.uriSettingName].split("?")[0];N.settings[N.uriSettingName]=f1.setOrigin(N.settings[N.uriSettingName],{alias:c1});N.postOriginUri=N.settings[N.uriSettingName].split("?")[0];}}if(e1&&N.settings&&N.settings.annotationURI){var g1=[].concat(N.settings.annotationURI);var h1=[];for(var i=0;i<g1.length;i++){h1.push(f1.setAnnotationOrigin(g1[i],{alias:c1,preOriginBaseUri:N.preOriginBaseUri,postOriginBaseUri:N.postOriginBaseUri}));}N.settings.annotationURI=h1;}if(N.type==='sap.ui.model.resource.ResourceModel'&&N.settings&&Array.isArray(N.settings.enhanceWith)){N.settings.enhanceWith.forEach(function(i1){if(i1.bundleUrl){i1.bundleUrl=v.resolveUri(i1.bundleUrl,i1.bundleUrlRelativeTo);}});}if(N.settings&&!Array.isArray(N.settings)){N.settings=[N.settings];}J[K]=N;}return J;};n._createManifestModels=function(m,e){var i={};for(var v in m){var y=m[v];try{sap.ui.requireSync(y.type.replace(/\./g,"/"));}catch(E){L.error("Component Manifest: Class \""+y.type+"\" for model \""+v+"\" could not be loaded. "+E,"[\"sap.ui5\"][\"models\"][\""+v+"\"]",e);continue;}var z=O.get(y.type);if(!z){L.error("Component Manifest: Class \""+y.type+"\" for model \""+v+"\" could not be found","[\"sap.ui5\"][\"models\"][\""+v+"\"]",e);continue;}var A=[null].concat(y.settings||[]);var F=z.bind.apply(z,A);var B=new F();i[v]=B;}return i;};function p(m,e,i){var v={afterManifest:{},afterPreload:{}};var y=q.extend(true,{},m.getEntry("/sap.app/dataSources"));var z=q.extend(true,{},m.getEntry("/sap.ui5/models"));var A=n._createManifestModelConfigurations({models:z,dataSources:y,manifest:m,componentData:e,cacheTokens:i});var P=new d(window.location.href).get("sap-ui-xx-preload-component-models-"+m.getComponentName());var B=P&&P.split(",");for(var D in A){var E=A[D];if(!E.preload&&B&&B.indexOf(D)>-1){E.preload=true;L.warning("FOR TESTING ONLY!!! Activating preload for model \""+D+"\" ("+E.type+")",m.getComponentName(),"sap.ui.core.Component");}if(E.type==="sap.ui.model.resource.ResourceModel"&&Array.isArray(E.settings)&&E.settings.length>0&&E.settings[0].async!==true){v.afterPreload[D]=E;}else if(E.preload){if(sap.ui.loader._.getModuleState(E.type.replace(/\./g,"/")+".js")){v.afterManifest[D]=E;}else{L.warning("Can not preload model \""+D+"\" as required class has not been loaded: \""+E.type+"\"",m.getComponentName(),"sap.ui.core.Component");}}}return v;}function s(e){return sap.ui.require.toUrl(e.replace(/\./g,"/")+"/manifest.json");}function t(m,v){g.registerResourcePath(m.replace(/\./g,"/"),v);}function u(R,e){var m=[];var v=[];function y(i,z){if(!i._oManifest){var N=i.getComponentName();var D=s(N);var A;if(z){A=Promise.resolve(JSON.parse(JSON.stringify(z.getRawJson())));}else{A=g.loadResource({url:D,dataType:"json",async:true}).catch(function(E){L.error("Failed to load component manifest from \""+D+"\" (component "+N+")! Reason: "+E);return{};});}m.push(A);v.push(i);}var P=i.getParent();if(P&&(P instanceof C)&&!P.isBaseClass()){y(P);}}y(R,e);return Promise.all(m).then(function(z){for(var i=0;i<z.length;i++){if(z[i]){v[i]._applyManifest(z[i]);}}});}n._fnLoadComponentCallback=null;n._fnOnInstanceCreated=null;n.create=function(m){if(m==null||typeof m!=="object"){throw new TypeError("Component.create() must be called with a configuration object.");}var P=a({},m);P.async=true;if(P.manifest===undefined){P.manifest=true;}return w(P);};sap.ui.component=function(v){if(!v){throw new Error("sap.ui.component cannot be called without parameter!");}var e=function(i){return{type:"sap.ui.component",name:i};};if(typeof v==='string'){L.warning("Do not use deprecated function 'sap.ui.component' for Component instance lookup. "+"Use 'Component.get' instead","sap.ui.component",null,e.bind(null,v));return sap.ui.getCore().getComponent(v);}if(v.async){L.info("Do not use deprecated factory function 'sap.ui.component'. "+"Use 'Component.create' instead","sap.ui.component",null,e.bind(null,v["name"]));}else{L.warning("Do not use synchronous component creation! "+"Use the new asynchronous factory 'Component.create' instead","sap.ui.component",null,e.bind(null,v["name"]));}return w(v);};function w(v){function e(y){var N=v.name,z=v.id,A=v.componentData,B=N+'.Component',S=v.settings;var D=new y(q.extend({},S,{id:z,componentData:A,_cacheTokens:v.asyncHints&&v.asyncHints.cacheTokens}));c(D instanceof n,"The specified component \""+B+"\" must be an instance of sap.ui.core.Component!");L.info("Component instance Id = "+D.getId());var H=D.getMetadata().handleValidation()!==undefined||v.handleValidation;if(H){if(D.getMetadata().handleValidation()!==undefined){H=D.getMetadata().handleValidation();}else{H=v.handleValidation;}sap.ui.getCore().getMessageManager().registerObject(D,H);}o(D);if(typeof n._fnOnInstanceCreated==="function"){var P=n._fnOnInstanceCreated(D,v);if(v.async&&P instanceof Promise){return P.then(function(){return D;});}}return D;}var i=x(v,{failOnError:true,createModels:true,waitFor:v.asyncHints&&v.asyncHints.waitFor});if(v.async){var m=b._sOwnerId;return i.then(function(y){return r(function(){return e(y);},m);});}else{return e(i);}}n.load=function(m){var P=a({},m);P.async=true;if(P.manifest===undefined){P.manifest=true;}return x(P,{preloadOnly:P.asyncHints&&P.asyncHints.preloadOnly});};n.get=function(i){return sap.ui.getCore().getComponent(i);};sap.ui.component.load=function(e,F){L.warning("Do not use deprecated function 'sap.ui.component.load'! Use 'Component.load' instead");return x(e,{failOnError:F,preloadOnly:e.asyncHints&&e.asyncHints.preloadOnly});};function x(m,y){var N=m.name,z=m.url,A=sap.ui.getCore().getConfiguration(),B=/^(sync|async)$/.test(A.getComponentPreload()),D=m.manifest,E,F,G,H,J,K;function P(e){var G=new M(JSON.parse(JSON.stringify(e)));return m.async?Promise.resolve(G):G;}c(!z||typeof z==='string',"sUrl must be a string or undefined");if(N&&typeof z==='string'){t(N,z);}I.setStepComponent(N);if(D===undefined){E=m.manifestFirst===undefined?A.getManifestFirst():!!m.manifestFirst;F=m.manifestUrl;}else{if(m.async===undefined){m.async=true;}E=!!D;F=D&&typeof D==='string'?D:undefined;G=D&&typeof D==='object'?P(D):undefined;}if(!G&&F){G=M.load({manifestUrl:F,componentName:N,async:m.async});}if(G&&!m.async){N=G.getComponentName();if(N&&typeof z==='string'){t(N,z);}}if(!(G&&m.async)){if(!N){throw new Error("The name of the component is undefined.");}c(typeof N==='string',"sName must be a string");}if(E&&!G){G=M.load({manifestUrl:s(N),componentName:N,async:m.async,failOnError:false});}function Q(){return(N+".Component").replace(/\./g,"/");}function R(e){var i=N+'.Component';if(!e){var v="The specified component controller '"+i+"' could not be found!";if(y.failOnError){throw new Error(v);}else{L.warning(v);}}if(G){var $=l(e.getMetadata(),G);var d1=function(){var e1=Array.prototype.slice.call(arguments);var f1;if(e1.length===0||typeof e1[0]==="object"){f1=e1[0]=e1[0]||{};}else if(typeof e1[0]==="string"){f1=e1[1]=e1[1]||{};}f1._metadataProxy=$;if(H){f1._manifestModels=H;}var g1=Object.create(e.prototype);e.apply(g1,e1);return g1;};d1.getMetadata=function(){return $;};d1.extend=function(){throw new Error("Extending Components created by Manifest is not supported!");};return d1;}else{return e;}}function S(v,i){c((typeof v==='string'&&v)||(typeof v==='object'&&typeof v.name==='string'&&v.name),"reference either must be a non-empty string or an object with a non-empty 'name' and an optional 'url' property");if(typeof v==='object'){if(v.url){t(v.name,v.url);}return(v.lazy&&i!==true)?undefined:v.name;}return v;}function T(i,v){var $=i+'.Component',d1=sap.ui.getCore().getConfiguration().getDepCache(),e1;if(B&&i!=null&&!sap.ui.loader._.getModuleState($.replace(/\./g,"/")+".js")){if(v){e1=$.replace(/\./g,"/")+(d1?'-h2-preload.js':'-preload.js');return sap.ui.loader._.loadJSResourceAsync(e1,true);}try{e1=$+'-preload';sap.ui.requireSync(e1.replace(/\./g,"/"));}catch(e){L.warning("couldn't preload component from "+e1+": "+((e&&e.message)||e));}}else if(v){return Promise.resolve();}}function W(e,G,i){var v=[];var $=i?function(l1){v.push(l1);}:function(){};G.defineResourceRoots();var d1=G.getEntry("/sap.ui5/dependencies/libs");if(d1){var e1=[];for(var f1 in d1){if(!d1[f1].lazy){e1.push(f1);}}if(e1.length>0){L.info("Component \""+e+"\" is loading libraries: \""+e1.join(", ")+"\"");$(sap.ui.getCore().loadLibraries(e1,{async:i}));}}var g1=G.getEntry("/sap.ui5/extends/component");if(g1){$(T(g1,i));}var h1=[];var i1=G.getEntry("/sap.ui5/dependencies/components");if(i1){for(var e in i1){if(!i1[e].lazy){h1.push(e);}}}var j1=G.getEntry("/sap.ui5/componentUsages");if(j1){for(var k1 in j1){if(j1[k1].lazy===false&&h1.indexOf(j1[k1].name)===-1){h1.push(j1[k1].name);}}}if(h1.length>0){h1.forEach(function(e){$(T(e,i));});}return i?Promise.all(v):undefined;}if(m.async){var X=m.asyncHints||{},Y=[],Z=function(e){e=e.then(function(v){return{result:v,rejected:false};},function(v){return{result:v,rejected:true};});return e;},_=function(e){if(e){Y.push(Z(e));}},a1=function($){return $;},b1,c1;if(G&&y.createModels){_(G.then(function(G){J=p(G,m.componentData,X.cacheTokens);return G;}).then(function(G){if(Object.keys(J.afterManifest).length>0){H=n._createManifestModels(J.afterManifest,G.getComponentName());}return G;}));}b1=[];if(Array.isArray(X.preloadBundles)){X.preloadBundles.forEach(function(v){b1.push(sap.ui.loader._.loadJSResourceAsync(S(v,true),true));});}if(Array.isArray(X.libs)){c1=X.libs.map(S).filter(a1);b1.push(sap.ui.getCore().loadLibraries(c1,{preloadOnly:true}));}b1=Promise.all(b1);if(c1&&!y.preloadOnly){b1=b1.then(function(){return sap.ui.getCore().loadLibraries(c1);});}_(b1);if(!G){_(T(N,true));}else{_(G.then(function(G){var e=G.getComponentName();if(typeof z==='string'){t(e,z);}return T(e,true).then(function(){return G._processI18n(true);}).then(function(){if(!y.createModels){return null;}var i=Object.keys(J.afterPreload);if(i.length===0){return null;}return new Promise(function(v,$){sap.ui.require(["sap/ui/model/resource/ResourceModel"],function(d1){v(d1);},$);}).then(function(v){function $(d1){var e1=J.afterPreload[d1];if(Array.isArray(e1.settings)&&e1.settings.length>0){var f1=e1.settings[0];return v.loadResourceBundle(f1,true).then(function(g1){f1.bundle=g1;},function(g1){L.error("Component Manifest: Could not preload ResourceBundle for ResourceModel. "+"The model will be skipped here and tried to be created on Component initialization.","[\"sap.ui5\"][\"models\"][\""+d1+"\"]",e);L.error(g1);delete J.afterPreload[d1];});}else{return Promise.resolve();}}return Promise.all(i.map($)).then(function(){if(Object.keys(J.afterPreload).length>0){var d1=n._createManifestModels(J.afterPreload,G.getComponentName());if(!H){H={};}for(var e1 in d1){H[e1]=d1[e1];}}});});});}));K=function(e){if(typeof n._fnLoadComponentCallback==="function"){var i=q.extend(true,{},m);var v=q.extend(true,{},e);try{n._fnLoadComponentCallback(i,v);}catch($){L.error("Callback for loading the component \""+G.getComponentName()+"\" run into an error. The callback was skipped and the component loading resumed.",$,"sap.ui.core.Component");}}};}if(X.components){q.each(X.components,function(i,v){_(T(S(v),true));});}return Promise.all(Y).then(function(v){var e=[],i=false,$;i=v.some(function(d1){if(d1&&d1.rejected){$=d1.result;return true;}e.push(d1.result);});if(i){return Promise.reject($);}return e;}).then(function(v){if(G&&K){G.then(K);}return v;}).then(function(v){L.debug("Component.load: all promises fulfilled, then "+v);if(G){return G.then(function(e){G=e;N=G.getComponentName();return W(N,G,true);});}else{return v;}}).then(function(){if(y.preloadOnly){return true;}return new Promise(function(e,i){sap.ui.require([Q()],function(v){e(v);},i);}).then(function(e){var i=e.getMetadata();var N=i.getComponentName();var v=s(N);var $;if(G&&typeof D!=="object"&&(typeof F==="undefined"||F===v)){$=u(i,G);}else{$=u(i);}return $.then(function(){return R(e);});});}).then(function(e){if(!G){return e;}var i=[];var v;var $=G.getEntry("/sap.ui5/rootView");if(typeof $==="string"){v="XML";}else if($&&typeof $==="object"&&$.type){v=$.type;}if(v&&V[v]){var d1="sap/ui/core/mvc/"+V[v]+"View";i.push(d1);}var e1=G.getEntry("/sap.ui5/routing");if(e1&&e1.routes){var f1=G.getEntry("/sap.ui5/routing/config/routerClass")||"sap.ui.core.routing.Router";var g1=f1.replace(/\./g,"/");i.push(g1);}var h1=q.extend(true,{},G.getEntry("/sap.ui5/models"));var i1=q.extend(true,{},G.getEntry("/sap.app/dataSources"));var j1=n._createManifestModelConfigurations({models:h1,dataSources:i1,manifest:G,cacheTokens:X.cacheTokens});for(var k1 in j1){if(!j1.hasOwnProperty(k1)){continue;}var l1=j1[k1];if(!l1.type){continue;}var m1=l1.type.replace(/\./g,"/");if(i.indexOf(m1)===-1){i.push(m1);}}if(i.length>0){return Promise.all(i.map(function(m1){return new Promise(function(n1,o1){var p1=false;function q1(r1){if(p1){return;}L.warning("Can not preload module \""+m1+"\". "+"This will most probably cause an error once the module is used later on.",G.getComponentName(),"sap.ui.core.Component");L.warning(r1);p1=true;n1();}sap.ui.require([m1],n1,q1);});})).then(function(){return e;});}else{return e;}}).then(function(e){var i=y.waitFor;if(i){var v=Array.isArray(i)?i:[i];return Promise.all(v).then(function(){return e;});}return e;}).catch(function(e){if(H){for(var N in H){var i=H[N];if(i&&typeof i.destroy==="function"){i.destroy();}}}throw e;});}if(G){W(N,G);}T(N);return R(sap.ui.requireSync(Q()));}if(Math.sqrt(2)<1){sap.ui.require(["sap/ui/core/Core"],function(){});}return n;});
