/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/ManagedObject','./Element','./RenderManager','sap/ui/performance/trace/Interaction',"sap/ui/dom/containsOrEquals","sap/ui/util/ActivityDetection","sap/ui/events/KeyCodes","sap/base/Log","sap/base/assert","sap/ui/performance/Measurement",'sap/ui/events/jquery/EventExtension',"sap/ui/events/ControlEvents","sap/ui/events/F6Navigation","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/control"],function(M,E,R,I,c,A,K,L,a,b,d,C,F,q){"use strict";var f;d.apply();q(document).on("keydown",function(e){F.handleF6GroupNavigation(e,null);});var r=L.getLogger("sap.ui.Rendering",((window["sap-ui-config"]&&(window["sap-ui-config"]["xx-debugRendering"]||window["sap-ui-config"]["xx-debugrendering"]))||/sap-ui-xx-debug(R|-r)endering=(true|x|X)/.test(document.location.search))?L.Level.DEBUG:Math.min(L.Level.INFO,L.getLevel())),D=function(o){return o;},g=function(){},h=function(){};if(r.isLoggable()){D=function(o){var l;try{throw new Error();}catch(e){l=e.stack||e.stacktrace||(e.sourceURL?e.sourceURL+":"+e.line:null);l=l?l.split(/\n\s*/g).slice(2):undefined;}return{obj:o,location:l};};g=function(t,m){var o=sap.ui.getCore(),e={},n,i;for(n in m){i=o.byId(n);e[n]={type:i?i.getMetadata().getName():(m[n].obj===t?"UIArea":"(no such control)"),location:m[n].location,reason:m[n].reason};}r.debug("  UIArea '"+t.getId()+"', pending updates: "+JSON.stringify(e,null,"\t"));};h=function(B,m){var n;for(n in m){if(B[n]!=null){if(B[n].obj!==m[n].obj){m[n].reason="replaced during rendering";}else{m[n].reason="invalidated again during rendering";}}else{m[n].reason="invalidated during rendering";}}};}var U=M.extend("sap.ui.core.UIArea",{constructor:function(o,e){if(arguments.length===0){return;}M.apply(this);this.oCore=o;this.bLocked=false;this.bInitial=true;this.aContentToRemove=[];this.bNeedsRerendering=false;if(e!=null){this.setRootNode(e);this.bNeedsRerendering=this.bNeedsRerendering&&!((e.id+"-Init"?window.document.getElementById(e.id+"-Init"):null));}this.mInvalidatedControls={};if(!this.bNeedsRerendering){this.bRenderSelf=false;}else{this.oCore.addInvalidatedUIArea(this);}},metadata:{publicMethods:["setRootNode","getRootNode","setRootControl","getRootControl","lock","unlock","isLocked"],aggregations:{content:{name:"content",type:"sap.ui.core.Control",multiple:true,singularName:"content"},dependents:{name:"dependents",type:"sap.ui.core.Control",multiple:true}}}});U.prototype.isInvalidateSuppressed=function(){return this.iSuppressInvalidate>0;};U.prototype.getId=function(){return this.oRootNode?this.oRootNode.id:null;};U.prototype.getUIArea=function(){return this;};U.prototype.setRootNode=function(o){if(this.oRootNode===o){return;}a(!o||(o.nodeType===1&&!q(o).attr("data-sap-ui-area")),"UIArea root node must be a DOMElement");if(this.oRootNode){this._ondetach();}this.oRootNode=o;if(this.getContent().length>0){this.invalidate();}if(this.oRootNode){this._onattach();}};U.prototype.getRootNode=function(){return this.oRootNode;};U.prototype.setRootControl=function(o){this.removeAllContent();this.addContent(o);};U.prototype.getRootControl=function(i){var e=this.getContent();if(e.length>0){if(i>=0&&i<e.length){return e[i];}return e[0];}return null;};U.prototype._addRemovedContent=function(o){if(this.oRootNode&&o){this.aContentToRemove.push(o);}};U.prototype.addContent=function(o,_){this.addAggregation("content",o,_);if(_!==true){this.invalidate();}return this;};U.prototype.removeContent=function(e,_){var o=this.removeAggregation("content",e,_);if(!_){var i;if(o&&o.getDomRef){i=o.getDomRef();}this._addRemovedContent(i);}return o;};U.prototype.removeAllContent=function(){var e=this.removeAllAggregation("content");for(var i=0;i<e.length;i++){var o;var k=e[i];if(k&&k.getDomRef){o=k.getDomRef();}this._addRemovedContent(o);}return e;};U.prototype.destroyContent=function(){var e=this.getContent();for(var i=0;i<e.length;i++){var o;var k=e[i];if(k&&k.getDomRef){o=k.getDomRef();}this._addRemovedContent(o);}this.destroyAggregation("content");return this;};U.prototype.lock=function(){this.bLocked=true;};U.prototype.unlock=function(){if(this.bLocked&&this.bNeedsRerendering){this.oCore.addInvalidatedUIArea(this);}this.bLocked=false;};U.prototype.isLocked=function(){return this.bLocked;};U.prototype.getBindingContext=function(){return null;};U.prototype.getEventingParent=function(){return this.oCore._getEventProvider();};U.prototype.isActive=function(){return((this.getId()?window.document.getElementById(this.getId()):null))!=null;};U.prototype.invalidate=function(){this.addInvalidatedControl(this);};U.prototype.addInvalidatedControl=function(o){if(this.bRenderSelf){return;}if(!this.bNeedsRerendering){this.oCore.addInvalidatedUIArea(this);}var i=o.getId();if(o===this){this.bRenderSelf=true;this.bNeedsRerendering=true;this.mInvalidatedControls={};this.mInvalidatedControls[i]=D(this);return;}if(this.mInvalidatedControls[i]){return;}if(!this.bRenderSelf){this.mInvalidatedControls[i]=D(o);this.bNeedsRerendering=true;}};U.prototype.rerender=function(k){var t=this;function l(){t.bRenderSelf=false;t.aContentToRemove=[];t.mInvalidatedControls={};t.bNeedsRerendering=false;}function m(){try{return document.activeElement;}catch(N){}}if(k){this.bNeedsRerendering=true;}if(this.bLocked||!this.bNeedsRerendering){return false;}var o=this.bRenderSelf,s=this.aContentToRemove,u=this.mInvalidatedControls,w=false;l();b.pause("renderPendingUIUpdates");b.start(this.getId()+"---rerender","Rerendering of "+this.getMetadata().getName());g(this,u);if(o){if(this.oRootNode){r.debug("Full Rendering of UIArea '"+this.getId()+"'");R.preserveContent(this.oRootNode,false,this.bInitial);this.bInitial=false;var x=function(N,O){var B=N.length;var Q;for(var i=0;i<B;i++){Q=O?N[i].getDomRef():N[i];if(Q&&!R.isPreservedContent(Q)&&t.oRootNode===Q.parentNode){q(Q).remove();}}return B;};var y=m();var S=this.oCore.oFocusHandler.getControlFocusInfo();x(s);var z=this.getContent();var B=x(z,true);var G=m();for(var i=0;i<B;i++){if(z[i]&&z[i].getParent()===this){this.oCore.oRenderManager.render(z[i],this.oRootNode,true);}}w=true;if(y&&y!=G&&G===m()){try{this.oCore.oFocusHandler.restoreFocus(S);}catch(e){L.warning("Problems while restoring the focus after full UIArea rendering: "+e,null,this);}}}else{r.debug("Full Rendering of UIArea '"+this.getId()+"' postponed, no root node");}}else{var H=function(N){for(;;){if(N.getMetadata&&N.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){break;}N=N.getParent();if(!N||N===t){return false;}if(u.hasOwnProperty(N.getId())){return true;}}};for(var n in u){var J=this.oCore.byId(n);if(J&&!H(J)){J.rerender();w=true;}}}h(u,this.mInvalidatedControls);b.end(this.getId()+"---rerender");b.resume("renderPendingUIUpdates");return w;};U.prototype._onControlRendered=function(o){var i=o.getId();if(this.mInvalidatedControls[i]){delete this.mInvalidatedControls[i];}};U.rerenderControl=function(o){var e=null;if(o){e=o.getDomRef();if(!e||R.isPreservedContent(e)){e=(R.RenderPrefixes.Invisible+o.getId()?window.document.getElementById(R.RenderPrefixes.Invisible+o.getId()):null);}}var i=e&&e.parentNode;if(i){var u=o.getUIArea();var k=u?u.oCore.oRenderManager:sap.ui.getCore().createRenderManager();r.debug("Rerender Control '"+o.getId()+"'"+(u?"":" (using a temp. RenderManager)"));R.preserveContent(e,true,false);k.render(o,i);}else{var u=o.getUIArea();u&&u._onControlRendered(o);r.warning("Couldn't rerender '"+o.getId()+"', as its DOM location couldn't be determined");}};var j=/^(mousedown|mouseup|click|keydown|keyup|keypress|touchstart|touchend|tap)$/;var p=[],P=[];var v={mousemove:1,mouseover:1,mouseout:1,scroll:1,dragover:1,dragenter:1,dragleave:1};U.addEventPreprocessor=function(e){p.push(e);};U.getEventPreprocessors=function(){return p;};U.addEventPostprocessor=function(e){P.push(e);};U.getEventPostprocessors=function(){return P;};U.prototype._handleEvent=function(e){var o=null,k;o=q(e.target).control(0);A.refresh();if(o===null){return;}if(e.isMarked("delayedMouseEvent")){return;}var H=e.getMark("handledByUIArea"),s=this.getId();if(H&&H!==s){e.setMark("firstUIArea",false);return;}e.setMarked("firstUIArea");e.srcControl=o;if(e.type==="contextmenu"&&e.shiftKey&&e.altKey&&!!(e.metaKey||e.ctrlKey)){L.info("Suppressed forwarding the contextmenu event as control event because CTRL+SHIFT+ALT is pressed!");return;}p.forEach(function(x){x(e);});this.oCore._handleControlEvent(e,s);if(this.bLocked||this.oCore.isLocked()){return;}if(I.getActive()){k=e.type.match(j);if(k){I.notifyEventStart(e);}}var l=[];if(e.getPseudoTypes){l=e.getPseudoTypes();}l.push(e.type);var G=false;while(o instanceof E&&o.isActive()&&!e.isPropagationStopped()){for(var i=0,m=l.length;i<m;i++){var t=l[i];e.type=t;e.currentTarget=o.getDomRef();o._handleEvent(e);if(e.isImmediatePropagationStopped()){break;}}if(!G&&!e.isMarked("enterKeyConsumedAsContent")){G=this._handleGroupChange(e,o);}if(e.isPropagationStopped()){break;}if(o.bStopEventBubbling){break;}var n=o.getDomRef();if(!n){break;}n=n.parentNode;o=null;if(e.isMarked("fromMouseout")&&c(n,e.relatedTarget)){break;}while(n&&n!==this.getRootNode()){if(n.id){o=q(n).control(0);if(o){break;}}n=n.parentNode;}}P.forEach(function(x){x(e);});if(k){I.notifyEventEnd(e);}e.currentTarget=this.getRootNode();e.setMark("handledByUIArea",s);if(e.isPropagationStopped()){L.debug("'"+e.type+"' propagation has been stopped");}var u=e.type;if(!v[u]){var w=q(e.target).control(0);if(w){L.debug("Event fired: '"+u+"' on "+w,"","sap.ui.core.UIArea");}else{L.debug("Event fired: '"+u+"'","","sap.ui.core.UIArea");}}};U.prototype._onattach=function(){var o=this.getRootNode();if(o==null){return;}q(o).attr("data-sap-ui-area",o.id).bind(C.events.join(" "),this._handleEvent.bind(this));};U.prototype._ondetach=function(){var o=this.getRootNode();if(o==null){return;}q(o).removeAttr("data-sap-ui-area").unbind();};U.prototype.clone=function(){throw new Error("UIArea can't be cloned");};U.prototype._handleGroupChange=function(e,o){var k=U._oFieldGroupValidationKey;if(e.type==="focusin"){if(U._iFieldGroupDelayTimer){clearTimeout(U._iFieldGroupDelayTimer);U._iFieldGroupDelayTimer=null;}U._iFieldGroupDelayTimer=setTimeout(this.setFieldGroupControl.bind(this,o),0);return true;}else if(this.getFieldGroupControl()&&e.type==="keyup"&&e.keyCode===k.keyCode&&e.shiftKey===k.shiftKey&&e.altKey===k.altKey&&e.ctrlKey===k.ctrlKey){if(U._iFieldGroupTriggerDelay){clearTimeout(U._iFieldGroupTriggerDelay);}var i=this.getFieldGroupControl(),l=(i?i._getFieldGroupIds():[]);if(l.length>0){i.triggerValidateFieldGroup(l);}return true;}return false;};U.prototype.setFieldGroupControl=function(e){function k(e,u){var w=e.getParent();if(w){if(u(w)){return w;}else{return k(w,u);}}return null;}var o=this.getFieldGroupControl();if(e!=o){var l=null;f=f||sap.ui.require('sap/ui/core/Control');if(f){if(e instanceof f){l=e;}else{l=k(e,function(e){return e instanceof f;});}}var m=(o?o._getFieldGroupIds():[]),n=(l?l._getFieldGroupIds():[]),t=[];for(var i=0;i<m.length;i++){var s=m[i];if(n.indexOf(s)===-1){t.push(s);}}if(t.length>0){o.triggerValidateFieldGroup(t);}U._oFieldGroupControl=l;}return this;};U.prototype.getFieldGroupControl=function(){if(U._oFieldGroupControl&&!U._oFieldGroupControl.bIsDestroyed){return U._oFieldGroupControl;}return null;};U._oFieldGroupControl=null;U._iFieldGroupDelayTimer=null;U._oFieldGroupValidationKey={keyCode:K.ENTER,shiftKey:false,altKey:false,ctrlKey:false};U._oRenderLog=r;return U;});
