/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/Object','sap/ui/core/Locale','sap/ui/core/LocaleData',"sap/base/strings/escapeRegExp","sap/base/assert","sap/ui/thirdparty/jquery"],function(B,L,a,e,b,q){"use strict";var N=B.extend("sap.ui.core.format.NumberFormat",{constructor:function(F){throw new Error();}});var r=/0+(\.0+)?/;var n={INTEGER:"integer",FLOAT:"float",CURRENCY:"currency",UNIT:"unit",PERCENT:"percent"};var R={FLOOR:"floor",CEILING:"ceiling",TOWARDS_ZERO:"towards_zero",AWAY_FROM_ZERO:"away_from_zero",HALF_FLOOR:"half_floor",HALF_CEILING:"half_ceiling",HALF_TOWARDS_ZERO:"half_towards_zero",HALF_AWAY_FROM_ZERO:"half_away_from_zero"};var m={};m[R.FLOOR]=Math.floor;m[R.CEILING]=Math.ceil;m[R.TOWARDS_ZERO]=function(i){return i>0?Math.floor(i):Math.ceil(i);};m[R.AWAY_FROM_ZERO]=function(i){return i>0?Math.ceil(i):Math.floor(i);};m[R.HALF_TOWARDS_ZERO]=function(i){return i>0?Math.ceil(i-0.5):Math.floor(i+0.5);};m[R.HALF_AWAY_FROM_ZERO]=function(i){return i>0?Math.floor(i+0.5):Math.ceil(i-0.5);};m[R.HALF_FLOOR]=function(i){return Math.ceil(i-0.5);};m[R.HALF_CEILING]=Math.round;N.RoundingMode=R;N.oDefaultIntegerFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:0,groupingEnabled:false,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:true,type:n.INTEGER,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.TOWARDS_ZERO,emptyString:NaN,showScale:true};N.oDefaultFloatFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.FLOAT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultPercentFormat={minIntegerDigits:1,maxIntegerDigits:99,minFractionDigits:0,maxFractionDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",percentSign:"%",isInteger:false,type:n.PERCENT,showMeasure:false,style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.oDefaultCurrencyFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.CURRENCY,showMeasure:true,currencyCode:true,currencyContext:'standard',style:"standard",parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true,ignorePrecision:true};N.oDefaultUnitFormat={minIntegerDigits:1,maxIntegerDigits:99,groupingEnabled:true,groupingSize:3,groupingSeparator:",",decimalSeparator:".",plusSign:"+",minusSign:"-",isInteger:false,type:n.UNIT,showMeasure:true,style:"standard",customUnits:undefined,allowedUnits:undefined,parseAsString:false,roundingMode:N.RoundingMode.HALF_AWAY_FROM_ZERO,emptyString:NaN,showScale:true};N.getInstance=function(F,l){return this.getFloatInstance(F,l);};N.getFloatInstance=function(F,l){var o=this.createInstance(F,l),i=this.getLocaleFormatOptions(o.oLocaleData,n.FLOAT);o.oFormatOptions=q.extend(false,{},this.oDefaultFloatFormat,i,F);return o;};N.getIntegerInstance=function(F,l){var o=this.createInstance(F,l),i=this.getLocaleFormatOptions(o.oLocaleData,n.INTEGER);o.oFormatOptions=q.extend(false,{},this.oDefaultIntegerFormat,i,F);return o;};N.getCurrencyInstance=function(F,l){var o=this.createInstance(F,l),C=F&&F.currencyContext,i=this.getLocaleFormatOptions(o.oLocaleData,n.CURRENCY,C);o.oFormatOptions=q.extend(false,{},this.oDefaultCurrencyFormat,i,F);return o;};N.getUnitInstance=function(F,l){var o=this.createInstance(F,l),i=this.getLocaleFormatOptions(o.oLocaleData,n.UNIT);o.oFormatOptions=q.extend(false,{},this.oDefaultUnitFormat,i,F);return o;};N.getPercentInstance=function(F,l){var o=this.createInstance(F,l),i=this.getLocaleFormatOptions(o.oLocaleData,n.PERCENT);o.oFormatOptions=q.extend(false,{},this.oDefaultPercentFormat,i,F);return o;};N.createInstance=function(F,l){var o=Object.create(this.prototype),P;if(F instanceof L){l=F;F=undefined;}if(!l){l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();}o.oLocale=l;o.oLocaleData=a.getInstance(l);o.oOriginalFormatOptions=F;if(F){if(F.pattern){P=this.parseNumberPattern(F.pattern);q.each(P,function(s,O){F[s]=O;});}if(F.emptyString!==undefined){b(typeof F.emptyString!=="string","The format option 'emptyString' can not be with type 'string'");b(F.emptyString===0||F.emptyString===null||F.emptyString!==F.emptyString,"The format option 'emptyString' must be either 0, null or NaN");}}return o;};N.getLocaleFormatOptions=function(l,t,C){var o,s;switch(t){case n.PERCENT:s=l.getPercentPattern();break;case n.CURRENCY:s=l.getCurrencyPattern(C);break;case n.UNIT:s=l.getDecimalPattern();break;default:s=l.getDecimalPattern();}o=this.parseNumberPattern(s);o.plusSign=l.getNumberSymbol("plusSign");o.minusSign=l.getNumberSymbol("minusSign");o.decimalSeparator=l.getNumberSymbol("decimal");o.groupingSeparator=l.getNumberSymbol("group");o.percentSign=l.getNumberSymbol("percentSign");o.pattern=s;switch(t){case n.FLOAT:case n.PERCENT:o.minFractionDigits=0;o.maxFractionDigits=99;break;case n.INTEGER:o.minFractionDigits=0;o.maxFractionDigits=0;o.groupingEnabled=false;break;case n.CURRENCY:o.minFractionDigits=undefined;o.maxFractionDigits=undefined;break;}return o;};N.parseNumberPattern=function(F){var M=0,l=0,o=0,G=false,s=0,t=0,S=F.indexOf(";"),u={Integer:0,Fraction:1},v=u.Integer;if(S!==-1){F=F.substring(0,S);}for(var i=0;i<F.length;i++){var C=F[i];switch(C){case",":if(G){s=t;t=0;}G=true;break;case".":v=u.Fraction;break;case"0":if(v===u.Integer){M++;if(G){t++;}}else{l++;o++;}break;case"#":if(v===u.Integer){if(G){t++;}}else{o++;}break;}}if(!s){s=t;t=0;}return{minIntegerDigits:M,minFractionDigits:l,maxFractionDigits:o,groupingEnabled:G,groupingSize:s,groupingBaseSize:t};};N.prototype.format=function(v,M){if(Array.isArray(v)){M=v[1];v=v[0];}var i="",F="",G="",s="",l="",P="",o=0,t=0,u=0,w=0,x=v<0,D=-1,O=q.extend({},this.oFormatOptions),y=this.oOriginalFormatOptions,I=O.type===n.CURRENCY&&M==="INR"&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",z,S,A,C,U,E;if(v===O.emptyString||(isNaN(v)&&isNaN(O.emptyString))){return"";}if(O.type===n.UNIT){if(O.customUnits&&typeof O.customUnits==="object"){U=O.customUnits[M];}else{E=this.oLocaleData.getUnitFromMapping(M)||M;U=this.oLocaleData.getUnitFormat(E);}O.decimals=(U&&(typeof U.decimals==="number"&&U.decimals>=0))?U.decimals:O.decimals;O.precision=(U&&(typeof U.precision==="number"&&U.precision>=0))?U.precision:O.precision;}if(O.decimals!==undefined){O.minFractionDigits=O.decimals;O.maxFractionDigits=O.decimals;}if(O.shortLimit===undefined||Math.abs(v)>=O.shortLimit){A=O.shortRefNumber===undefined?v:O.shortRefNumber;S=g(A,O,this.oLocaleData,I);if(S&&S.formatString!="0"){v=v/S.magnitude;if(O.shortDecimals!==undefined){O.minFractionDigits=O.shortDecimals;O.maxFractionDigits=O.shortDecimals;}else{if(y.minFractionDigits===undefined&&y.maxFractionDigits===undefined&&y.decimals===undefined&&y.precision===undefined&&y.pattern===undefined){O.precision=2;O.minFractionDigits=0;O.maxFractionDigits=99;}if(y.maxFractionDigits===undefined&&y.decimals===undefined){O.maxFractionDigits=99;}}O.roundingMode=N.RoundingMode.HALF_AWAY_FROM_ZERO;}}if((S||!O.ignorePrecision)&&O.precision!==undefined){O.maxFractionDigits=Math.min(O.maxFractionDigits,j(v,O.precision));O.minFractionDigits=Math.min(O.minFractionDigits,O.maxFractionDigits);}if(O.type==n.PERCENT){v=N._shiftDecimalPoint(v,2);}if(O.type==n.CURRENCY){var H=this.oLocaleData.getCurrencyDigits(M);if(O.maxFractionDigits===undefined){O.maxFractionDigits=H;}if(O.minFractionDigits===undefined){O.minFractionDigits=H;}}if(typeof v==="number"){v=f(v,O.maxFractionDigits,O.roundingMode);}if(v==0){x=false;}l=this.convertToDecimal(v);if(l=="NaN"){return l;}if(x){l=l.substr(1);}D=l.indexOf(".");if(D>-1){i=l.substr(0,D);F=l.substr(D+1);}else{i=l;}if(i.length<O.minIntegerDigits){i=i.padStart(O.minIntegerDigits,"0");}else if(i.length>O.maxIntegerDigits){i="".padStart(O.maxIntegerDigits,"?");}if(F.length<O.minFractionDigits){F=F.padEnd(O.minFractionDigits,"0");}else if(F.length>O.maxFractionDigits){F=F.substr(0,O.maxFractionDigits);}t=i.length;if(O.groupingEnabled){if(I){var J=[3,2,2],K,Q=0;o=i.length;while(o>0){K=J[Q%3];o-=K;if(Q>0){G=O.groupingSeparator+G;}if(o<0){K+=o;o=0;}G=i.substr(o,K)+G;Q++;}}else{u=O.groupingSize;w=O.groupingBaseSize||u;o=Math.max(t-w,0)%u||u;G=i.substr(0,o);while(t-o>=w){G+=O.groupingSeparator;G+=i.substr(o,u);o+=u;}G+=i.substr(o);}}else{G=i;}if(x){s=O.minusSign;}s+=G;if(F){s+=O.decimalSeparator+F;}if(S&&S.formatString&&O.showScale&&O.type!==n.CURRENCY){C=this.oLocaleData.getPluralCategory(i+"."+F);S.formatString=this.oLocaleData.getDecimalFormat(O.style,S.key,C);s=S.formatString.replace(S.valueSubString,s);s=s.replace(/'.'/g,".");}if(O.type===n.CURRENCY){P=O.pattern;if(S&&S.formatString&&O.showScale){C=this.oLocaleData.getPluralCategory(i+"."+F);if(I){P=d("short",S.key,C);}else{P=this.oLocaleData.getCurrencyFormat("short",S.key,C);}P=P.replace(/'.'/g,".");}z=P.split(";");if(z.length===2){P=x?z[1]:z[0];if(x){s=s.substring(1);}}if(!O.currencyCode){M=this.oLocaleData.getCurrencySymbol(M);}s=this._composeCurrencyResult(P,s,M,{showMeasure:O.showMeasure,negative:x,minusSign:O.minusSign});}if(O.type===n.PERCENT){P=O.pattern;s=P.replace(/[0#.,]+/,s);s=s.replace(/%/,O.percentSign);}if(O.showMeasure&&O.type===n.UNIT){C=this.oLocaleData.getPluralCategory(i+"."+F);b(C,"Cannot find plural category for "+(i+"."+F));var T=!O.allowedUnits||O.allowedUnits.indexOf(M)>=0;if(!T){b(T,"The given unit '"+M+"' is not part of the allowed unit types: ["+O.allowedUnits.join(",")+"].");return"";}if(U){P=U["unitPattern-count-"+C];if(!P){P=U["unitPattern-count-other"];}b(P,"Cannot find pattern 'unitPattern-count-"+C+"' in '"+M+"'");if(!P){return"";}s=P.replace("{0}",s);}else{b(U,"Unit '"+M+"' is unknown");return"";}}if(sap.ui.getCore().getConfiguration().getOriginInfo()){s=new String(s);s.originInfo={source:"Common Locale Data Repository",locale:this.oLocale.toString()};}return s;};N.prototype._composeCurrencyResult=function(P,F,M,o){var s=o.minusSign;P=P.replace(/[0#.,]+/,F);if(o.showMeasure&&M){var i="\u00a4",l={"[:digit:]":/\d/,"[:^S:]":/[^\$\xA2-\xA5\u058F\u060B\u09F2\u09F3\u09FB\u0AF1\u0BF9\u0E3F\u17DB\u20A0-\u20BD\uA838\uFDFC\uFE69\uFF04\uFFE0\uFFE1\uFFE5\uFFE6]/},t=P.indexOf(i),u=t<P.length/2?"after":"before",S=this.oLocaleData.getCurrencySpacing(u),C=(u==="after"?M.charAt(M.length-1):M.charAt(0)),v,w=l[S.currencyMatch],x=l[S.surroundingMatch],I;P=P.replace(i,M);v=(u==="after"?P.charAt(t+M.length):P.charAt(t-1));if(w&&w.test(C)&&x&&x.test(v)){if(u==="after"){I=t+M.length;}else{I=t;}P=P.slice(0,I)+S.insertBetween+P.slice(I);}else if(o.negative&&u==="after"){s="\ufeff"+o.minusSign;}}else{P=P.replace(/\s*\u00a4\s*/,"");}if(o.negative){P=P.replace(/-/,s);}return P;};N.prototype.parse=function(v){var o=this.oFormatOptions,P=h(o.plusSign+o.minusSign),G=h(o.groupingSeparator),D=h(o.decimalSeparator),s="^\\s*(["+P+"]?(?:[0-9"+G+"]+|[0-9"+G+"]*"+D+"[0-9]*)(?:[eE][+-][0-9]+)?)\\s*$",l="^\\s*(["+P+"]?[0-9"+G+"]+)\\s*$",t=new RegExp(G,"g"),u=new RegExp(D,"g"),w=this.oLocaleData.getNumberSymbol("percentSign"),I=o.type===n.CURRENCY&&this.oLocale.getLanguage()==="en"&&this.oLocale.getRegion()==="IN",x,y,M,z,A=0,S,E;if(v===""){E=o.emptyString;if(o.parseAsString&&(o.emptyString===0||isNaN(o.emptyString))){E=o.emptyString+"";}if(o.type===n.CURRENCY){return[E,undefined];}else{return E;}}z=o.type===n.PERCENT?o.pattern:this.oLocaleData.getPercentPattern();if(z.charAt(0)==="%"){s=s.slice(0,1)+"%?"+s.slice(1);}else if(z.charAt(z.length-1)==="%"){s=s.slice(0,s.length-1)+"%?"+s.slice(s.length-1);}var U;if(o.type===n.UNIT){var C;if(o.customUnits&&typeof o.customUnits==="object"){C=o.customUnits;}else{C=this.oLocaleData.getUnitFormats();}b(C,"Unit patterns cannot be loaded");if(o.allowedUnits){var F={};for(var i=0;i<o.allowedUnits.length;i++){var H=o.allowedUnits[i];F[H]=C[H];}C=F;}var J=p(C,v);U=J.cldrCode;if(U.length===1){M=U[0];}else if(U.length===0){b(U.length===1,"Cannot find unit for input: '"+(v)+"'");return null;}else{b(U.length===1,"Ambiguous unit ["+U.join(", ")+"] for input: '"+(v)+"'");M=undefined;}v=J.numberValue||v;}if(o.type===n.CURRENCY){var K=this.oLocaleData.getCurrencySymbols(),O=k(K,v),M;if(!O){return null;}v=O.numberValue;M=O.currencyCode;if(!o.showMeasure&&M){return null;}}if(typeof v==="string"||v instanceof String){v=v.replace(/[\u202a\u200e\u202c\u202b\u200f]/g,"");v=v.replace(/\s/g,"");}S=c(v,this.oLocaleData,I);if(S){v=S.number;}if(o.isInteger&&!S){x=new RegExp(l);}else{x=new RegExp(s);}if(!x.test(v)){return o.type===n.CURRENCY||o.type===n.UNIT?null:NaN;}v=v.replace(t,"");v=v.replace(o.plusSign,"+");v=v.replace(o.minusSign,"-");v=v.replace(/^\+/,"");if(S){v=v.replace(u,".");v=N._shiftDecimalPoint(v,Math.round(Math.log(S.factor)/Math.LN10));}if(o.isInteger){A=o.parseAsString?v:parseInt(v,10);}else{v=v.replace(u,".");if(v.indexOf(w)!==-1){y=true;v=v.replace(w,"");}A=o.parseAsString?v:parseFloat(v);if(y){A=N._shiftDecimalPoint(A,-2);}}if(o.parseAsString){A=N._shiftDecimalPoint(v,0);}if(o.type===n.CURRENCY||o.type===n.UNIT){return[A,M];}return A;};N.prototype.convertToDecimal=function(v){var V=""+v,l,s,D,F,E,P;if(V.indexOf("e")==-1&&V.indexOf("E")==-1){return V;}var o=V.match(/^([+-]?)((\d+)(?:\.(\d+))?)[eE]([+-]?\d+)$/);l=o[1]=="-";s=o[2].replace(/\./g,"");D=o[3]?o[3].length:0;F=o[4]?o[4].length:0;E=parseInt(o[5],10);if(E>0){if(E<F){P=D+E;V=s.substr(0,P)+"."+s.substr(P);}else{V=s;E-=F;for(var i=0;i<E;i++){V+="0";}}}else{if(-E<D){P=D+E;V=s.substr(0,P)+"."+s.substr(P);}else{V=s;E+=D;for(var i=0;i>E;i--){V="0"+V;}V="0."+V;}}if(l){V="-"+V;}return V;};N.prototype.getScale=function(){if((this.oFormatOptions.style!=="short"&&this.oFormatOptions.style!=="long")||this.oFormatOptions.shortRefNumber===undefined){return;}var s=g(this.oFormatOptions.shortRefNumber,this.oFormatOptions,this.oLocaleData),S;if(s&&s.formatString){S=s.formatString.replace(r,"").replace(/'.'/g,".").trim();if(S){return S;}}};N._shiftDecimalPoint=function(v,s){if(typeof s!=="number"){return NaN;}var M="";var E=v.toString().toLowerCase().split("e");if(typeof v==="number"){s=E[1]?(+E[1]+s):s;return+(E[0]+"e"+s);}else if(typeof v==="string"){if(parseFloat(v)===0&&s>=0){return v;}var F=E[0].charAt(0);M=F==="-"?F:"";if(M){E[0]=E[0].slice(1);}v=E[0];var D=v.indexOf("."),A,i,l;if(D===-1){v=v+".";D=v.length-1;}if(E[1]){D+=(+E[1]);}A=D+s;if(A<=0){v=v.padStart(v.length-A+1,'0');A=1;}else if(A>=v.length-1){v=v.padEnd(A+1,'0');A=v.length-1;}v=v.replace(".","");i=v.substring(0,A);l=v.substring(A);i=i.replace(/^(-?)0+(\d)/,"$1$2");return M+i+(l?("."+l):"");}else{return null;}};function g(v,o,l,I){var s,K,t,C,S=o.style,P=o.precision!==undefined?o.precision:2;if(S!="short"&&S!="long"){return undefined;}for(var i=0;i<15;i++){K=Math.pow(10,i);if(f(Math.abs(v)/K,P-1)<10){break;}}t=K.toString();if(I){C=d(S,t,"other",true);}else{C=l.getDecimalFormat(S,t,"other");}if(!C||C=="0"){return undefined;}else{s={};s.key=t;s.formatString=C;var u=C.match(r);if(u){s.valueSubString=u[0];var w=s.valueSubString.indexOf(".");if(w==-1){s.decimals=0;s.magnitude=K*Math.pow(10,1-s.valueSubString.length);}else{s.decimals=s.valueSubString.length-w-1;s.magnitude=K*Math.pow(10,1-w);}}else{return undefined;}}return s;}function c(v,l,I){var s,F=1,K=10,P=l.getPluralCategories(),C,o={number:undefined,factor:F},G=function(u,K,S,w){if(w){C=d(S,K.toString(),u,true);}else{C=l.getDecimalFormat(S,K.toString(),u);}if(C){C=C.replace(/[\s\u00a0\u200F]/g,"");C=C.replace(/'.'/g,".");var x=C.match(r);if(x){var V=x[0];var U=C.replace(V,"");if(!U){return;}var y=v.indexOf(U);if(y>=0){s=v.replace(U,"");s=s.replace(/\u200F/g,"");F=K;F*=Math.pow(10,1-V.length);if(o.number===undefined||s.length<o.number.length){o.number=s;o.factor=F;}}}}};["long","short"].forEach(function(S){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var t=P[i];G(t,K,S);}K=K*10;}});if(I&&!s){K=10;while(K<1e15){for(var i=0;i<P.length;i++){var t=P[i];G(t,K,"short",true);}K=K*10;}}if(!s){return;}return o;}function d(s,K,P,D){var F,o={"short":{"1000-one":"¤0000","1000-other":"¤0000","10000-one":"¤00000","10000-other":"¤00000","100000-one":"¤0 Lk","100000-other":"¤0 Lk","1000000-one":"¤00 Lk","1000000-other":"¤00 Lk","10000000-one":"¤0 Cr","10000000-other":"¤0 Cr","100000000-one":"¤00 Cr","100000000-other":"¤00 Cr","1000000000-one":"¤000 Cr","1000000000-other":"¤000 Cr","10000000000-one":"¤0000 Cr","10000000000-other":"¤0000 Cr","100000000000-one":"¤00000 Cr","100000000000-other":"¤00000 Cr","1000000000000-one":"¤0 Lk Cr","1000000000000-other":"¤0 Lk Cr","10000000000000-one":"¤00 Lk Cr","10000000000000-other":"¤00 Lk Cr","100000000000000-one":"¤0 Cr Cr","100000000000000-other":"¤0 Cr Cr"}};s="short";if(P!=="one"){P="other";}F=o[s][K+"-"+P];if(F&&D){F=F.substr(1);}return F;}function f(v,M,s){if(typeof v!=="number"){return NaN;}s=s||N.RoundingMode.HALF_AWAY_FROM_ZERO;M=parseInt(M,10);if(typeof s==="function"){v=s(v,M);}else{if(!M){return m[s](v);}v=N._shiftDecimalPoint(m[s](N._shiftDecimalPoint(v,M)),-M);}return v;}function h(s){return s.replace(/([.?*+^$[\]\\(){}|-])/g,"\\$1");}function j(v,P){var i=Math.floor(Math.log(Math.abs(v))/Math.LN10);return Math.max(0,P-i-1);}function p(u,v){var o={numberValue:undefined,cldrCode:[]};var i;var U,K;for(U in u){for(K in u[U]){if(K.indexOf("unitPattern")===0){var s=u[U][K];var C=s.indexOf("{0}")>-1;if(C){s="^"+e(s).replace("\\{0\\}","(.+)")+"$";var l=new RegExp(s);var t=l.exec(v);if(t&&t[1]){if(i===undefined||t[1].length<i){i=t[1].length;o.numberValue=t[1];o.cldrCode=[U];}else if(t[1].length===i&&o.cldrCode.indexOf(U)===-1){o.cldrCode.push(U);}}}else if(s===v){o.cldrCode=[U];var w;if(K.endsWith("-zero")){w="0";}else if(K.endsWith("-one")){w="1";}else if(K.endsWith("-two")){w="2";}o.numberValue=w;return o;}}}}return o;}function k(C,v){var i=/(^[A-Z]{3}|[A-Z]{3}$)/,s="",l,o,t,u;for(o in C){t=C[o];if(v.indexOf(t)>=0&&s.length<t.length){s=t;l=o;}}if(!l){u=v.match(i);l=u&&u[0];}if(l){v=v.replace(s||l,"");}return{numberValue:v,currencyCode:l||undefined};}return N;});
