/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/ManagedObject','sap/ui/base/BindingParser','sap/ui/core/Control','sap/ui/core/RenderManager','sap/base/util/ObjectPath','sap/base/Log','sap/base/assert','sap/ui/thirdparty/jquery'],function(M,B,C,R,O,L,a,q){"use strict";var T=M.extend("sap.ui.core.tmpl.Template",{constructor:function(i,s){M.apply(this,arguments);},metadata:{stereotype:"template","abstract":true,library:"sap.ui.core",properties:{"content":{type:"string",group:"Data",defaultValue:null}},publicMethods:["declareControl","createControl","placeAt","createMetadata","createRenderer"]}});var t={};T.prototype.register=function(){var i=this.getId(),o=t[i],m;if(o&&this!==o){m="adding template with duplicate id '"+i+"'";L.error(m);throw new Error("Error: "+m);}t[i]=this;};T.prototype.deregister=function(){delete t[this.getId()];};T.byId=function(i){return t[i];};T.prototype.getInterface=function(){return this;};T._mSupportedTypes={};T.registerType=function(s,c){T._mSupportedTypes[s]=c;};T.unregisterType=function(s){delete T._mSupportedTypes[s];};T.parsePath=function(p){var m,s=p.indexOf(">");if(s>0){m=p.substr(0,s);p=p.substr(s+1);}return{path:p,model:m};};T.prototype.init=function(s,S){if(this.getMetadata().getName()==="sap.ui.core.tmpl.Template"){throw new Error("The class 'sap.ui.core.tmpl.Template' is abstract and must not be instantiated!");}if(M.bindingParser===B.complexParser){T.prototype.extractBindingInfo=function(v,i,S){M.bindingParser=B.simpleParser;var r=C.prototype.extractBindingInfo.apply(this,arguments);M.bindingParser=B.complexParser;return r;};}};T.prototype.declareControl=function(c){a(!!c,"A fully qualified name must be specified!");if(c){var m=this.createMetadata(),r=this.createRenderer(),b=this;var d=sap.ui.requireSync('sap/ui/core/tmpl/TemplateControl');d.extend(c,{metadata:m,init:function(){d.prototype.init.apply(this,arguments);this.setTemplate(b);},renderer:{renderTemplate:r,hasControlData:m._hasControlData}});return O.get(c||"");}};T.prototype.createControl=function(i,c,v){var b=sap.ui.requireSync('sap/ui/core/tmpl/TemplateControl');var o=new b({id:i,template:this,context:c});o.setTemplateRenderer(this.createRenderer(v));return o;};T.prototype.placeAt=function(r,c,p,i){if(typeof c==="string"||typeof c==="number"){p=c;c=undefined;}var I;if(!(r instanceof C)&&i){var $=typeof r==="string"?q(document.getElementById(r)):q(r);if($.length>0){I=$.attr("id");r=$.get(0);var s=$.attr("data-context");c=c||s&&q.parseJSON(s);R.markInlineTemplate($);}}var o=this.createControl(I,c);o.placeAt(r,p);return o;};T.prototype.createMetadata=function(){L.error("The function createMetadata is an abstract function which needs to be implemented by subclasses.");};T.prototype.createRenderer=function(){L.error("The function createRenderer is an abstract function which needs to be implemented by subclasses.");};sap.ui.template=function(o){if(!o){var b=[];q.each(T._mSupportedTypes,function(s,h){q("script[type='"+s+"'], [data-type='"+s+"']").each(function(m,E){b.push(sap.ui.template({id:E.id,domref:E,type:s,_class:h}));});});return b;}else{if(typeof o==="string"){return sap.ui.template({id:o});}else if(o&&o.tagName&&o.nodeName&&o.ownerDocument&&o.nodeType===1){return sap.ui.template({id:o.id,domref:o});}o=q.extend({type:T.DEFAULT_TEMPLATE},o);var i,s,c,d,e=false,l=typeof o.src==="string",I=false;if(l){q.ajax({url:o.src,dataType:"text",async:false,success:function(m){i=o.id;s=o.type;c=o.control;d=m;var r=/^<!--\sUI5:Template\stype=([a-z\/\-]*)\s(?:controller=([A-Za-z.]*)\s)?-->/,n=d.match(r);if(n){s=n[1];if(n.length==3){e=n[2];}d=d.substr(n[0].length);}},error:function(){throw new Error("The template could not be loaded from "+o.src+"!");}});}else{var E=o.domref||((o.id?window.document.getElementById(o.id):null)),$=q(E);I=false;i=o.id||E&&E.id;s=$.attr("type")||o.type;c=$.attr("data-control")||o.control;if(i){var f=sap.ui.getCore().getTemplate(i);if(!f instanceof T){throw new Error("Object for id \""+i+"\" is no sap.ui.core.tmpl.Template!");}else{if(f){return f;}}}if($.length===0){throw new Error("DOM element for the Template with the id \""+i+"\" not found!");}d=$.html();var g=E.tagName.toLowerCase();if(g!=="script"){I=$.parents("body").length===1;}}var h=o._class;if(!h){h=T._mSupportedTypes[s];if(!h){throw new Error("The type \""+s+"\" is not supported.");}}var j=sap.ui.requireSync(h.replace(/\./g,"/"));j=j||O.get(h||"");var k=new j({id:i,content:d});if(c){k.declareControl(c);}if(e){k._sControllerName=e;}if(I){k.placeAt(i,o.context,undefined,true);}return k;}};T.DEFAULT_TEMPLATE="text/x-handlebars-template";T.registerType(T.DEFAULT_TEMPLATE,"sap.ui.core.tmpl.HandlebarsTemplate");return T;});
