/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/core/UIComponent","sap/ui/Device","sap/ui/documentation/sdk/model/models","sap/ui/documentation/sdk/controller/ErrorHandler","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ConfigUtil","sap/ui/documentation/sdk/controller/util/APIInfo","sap/base/util/Version","sap/ui/VersionInfo","sap/ui/documentation/sdk/util/DocumentationRouter","sap/m/ColumnListItem"],function(q,U,D,m,E,J,C,A,V,a){"use strict";var t=[],l={},T=1000000;return U.extend("sap.ui.documentation.sdk.Component",{metadata:{manifest:"json",includes:["css/style.css"]},init:function(){this._oErrorHandler=new E(this);this.setModel(m.createDeviceModel(),"device");this.setModel(new J(),"treeData");this.setModel(new J(),"libsData");this.setModel(new J(),"versionData");U.prototype.init.apply(this,arguments);this.loadVersionInfo();this.getRouter().initialize();},destroy:function(){this._oErrorHandler.destroy();this._oConfigUtil.destroy();this._oConfigUtil=null;U.prototype.destroy.apply(this,arguments);},getContentDensityClass:function(){if(this._sContentDensityClass===undefined){if(q(document.body).hasClass("sapUiSizeCozy")||q(document.body).hasClass("sapUiSizeCompact")){this._sContentDensityClass="";}this._sContentDensityClass="sapUiSizeCompact";}return this._sContentDensityClass;},getConfigUtil:function(){if(!this._oConfigUtil){this._oConfigUtil=new C(this);}return this._oConfigUtil;},loadVersionInfo:function(){if(!this._oVersionInfoPromise){this._oVersionInfoPromise=a.load().then(this._bindVersionModel.bind(this));}return this._oVersionInfoPromise;},fetchAPIIndex:function(){if(this._indexPromise){return this._indexPromise;}this._indexPromise=new Promise(function(r,b){A.getIndexJsonPromise().then(function(d){this._aLibraryElements=d;this._parseLibraryElements(d);this._bindTreeModel(t);r(d);}.bind(this));}.bind(this));return this._indexPromise;},_parseLibraryElements:function(L){for(var i=0;i<L.length;i++){if(!L[i].children){l[L[i].name]=L[i];}this._addElementToTreeData(L[i]);if(L[i].children){this._parseLibraryElements(L[i].children,true);}}},_addElementToTreeData:function(j){var n,h,b=this.aAllowedMembers;if(b.indexOf(j.visibility)!==-1){if(j.kind!=="namespace"){var N=j.name.split("."),B=N.pop(),s=N.join("."),o=this._createTreeNode(B,j.name,j.name===this._topicId,j.lib,!!j.deprecated),e=this._findNodeNamespaceInTreeStructure(s);if(e){if(!e.nodes){e.nodes=[];}e.nodes.push(o);}else if(s){h=this._aLibraryElements.some(function(c){return c.name===s&&b.indexOf(c.visibility)===-1;});if(!h){n=this._createTreeNode(s,s,s===this._topicId,j.lib,false);n.nodes=[];n.nodes.push(o);t.push(n);this._removeDuplicatedNodeFromTree(s);}}else{n=this._createTreeNode(j.name,j.name,j.name===this._topicId,j.lib,!!j.deprecated);t.push(n);}}else{n=this._createTreeNode(j.name,j.name,j.name===this._topicId,j.lib,!!j.deprecated);t.push(n);}}},_createTreeNode:function(b,n,i,L,I){var o={};o.text=b;o.name=n;o.ref="#/api/"+n;o.isSelected=i;o.bIsDeprecated=I;o.lib=L;return o;},_findNodeNamespaceInTreeStructure:function(n,b){b=b||t;for(var i=0;i<b.length;i++){var o=b[i];if(o.name===n){return o;}if(o.nodes){var c=this._findNodeNamespaceInTreeStructure(n,o.nodes);if(c){return c;}}}},_removeNodeFromNamespace:function(n,N){for(var i=0;i<N.nodes.length;i++){if(N.nodes[i].text===n){N.nodes.splice(i,1);return;}}},_removeDuplicatedNodeFromTree:function(n){if(l[n]){var N=n.substring(0,n.lastIndexOf("."));var o=this._findNodeNamespaceInTreeStructure(N);var s=n.substring(n.lastIndexOf(".")+1,n.lenght);this._removeNodeFromNamespace(s,o);}},_bindTreeModel:function(t){var b=this.getModel("treeData");b.setSizeLimit(T);if(t.length>0){t.push({isSelected:false,name:"experimental",ref:"#/api/experimental",text:"Experimental APIs",bIsDeprecated:false},{isSelected:false,name:"deprecated",ref:"#/api/deprecated",text:"Deprecated APIs",bIsDeprecated:false},{isSelected:false,name:"since",ref:"#/api/since",text:"Index by Version",bIsDeprecated:false});}b.setData(t,false);},_bindVersionModel:function(v){var o,s,O,b,i;this.aAllowedMembers=["public","protected"];if(!v){return;}o=V(v.version);b=o.getSuffix();s=/-SNAPSHOT$/i.test(b);O=v.gav&&/openui5/i.test(v.gav);if(/internal/i.test(v.name)||!!window['sap-ui-documentation-preview']){i=true;this.aAllowedMembers.push("restricted");}this.getModel("versionData").setData({versionGav:v.gav,versionName:v.name,version:[o.getMajor(),o.getMinor(),o.getPatch()].join("."),fullVersion:v.version,openUi5Version:sap.ui.version,isOpenUI5:O,isSnapshotVersion:s,isDevVersion:s||o.getMinor()%2===1,isBetaVersion:!O&&!s&&/-beta$/i.test(b),isInternal:!!i,libraries:v.libraries,allowedMembers:this.aAllowedMembers});}});});
