/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/model/formatter","sap/ui/core/library","sap/base/Log"],function(B,J,C,T,A,f,a,L){"use strict";var V=a.mvc.ViewType;return B.extend("sap.ui.documentation.sdk.controller.ApiDetail",{NOT_AVAILABLE:'N/A',NOT_FOUND:'Not found',onInit:function(){this.getRouter().getRoute("apiId").attachPatternMatched(this._onTopicMatched,this);this._oModel=new J();this._oModel.setSizeLimit(10000);this._oContainerPage=this.getView().byId("apiDetailPageContainer");},_onTopicMatched:function(e){if(this._oView){this._oView.destroy();this._oContainerPage.setBusy(true);}var c=this.getOwnerComponent();this._sTopicid=f.decodeModuleName(e.getParameter("arguments").id);this._sEntityType=e.getParameter("arguments").entityType;this._sEntityId=f.decodeModuleName(e.getParameter("arguments").entityId);c.loadVersionInfo().then(function(){this._aAllowedMembers=this.getModel("versionData").getProperty("/allowedMembers");}.bind(this)).then(c.fetchAPIIndex.bind(c)).then(this._processApiIndexAndLoadApiJson.bind(this)).then(this._findEntityInApiJsonData.bind(this)).then(this._buildBorrowedModel.bind(this)).then(this._createModelAndSubView.bind(this)).then(this._initSubView.bind(this)).catch(function(r){if(r===this.NOT_FOUND){this._oContainerPage.setBusy(false);this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}else if(typeof r==="string"){L.error(r);}else if(r.name){L.error(r.name,r.message);}else if(r.message){L.error(r.message);}}.bind(this));},_initSubView:function(v){var c=v.getController();this._oContainerPage.addContent(v);this._oContainerPage.setBusy(false);c.initiate({sTopicId:this._sTopicid,oModel:this._oModel,aApiIndex:this._aApiIndex,aAllowedMembers:this._aAllowedMembers,oEntityData:this._oEntityData,sEntityType:this._sEntityType,sEntityId:this._sEntityId,oOwnerComponent:this.getOwnerComponent(),oContainerView:this.getView(),oContainerController:this});},_createModelAndSubView:function(b){this._oControlData.borrowed=b;this._bindData(this._sTopicid);this._oView=sap.ui.view({height:"100%",viewName:"sap.ui.documentation.sdk.view.SubApiDetail",type:V.XML,async:true,preprocessors:{xml:{models:{data:this._oModel}}}});return this._oView.loaded();},_buildBorrowedModel:function(c){this._oControlData=c;return this.buildBorrowedModel(c);},_findEntityInApiJsonData:function(l){var o,b,i;for(i=0,b=l.length;i<b;i++){o=l[i];if(o.name===this._sTopicid){if(o.visibility===undefined||this._aAllowedMembers.indexOf(o.visibility)>=0){return o;}else{return Promise.reject(this.NOT_FOUND);}}}return Promise.reject(this.NOT_FOUND);},_processApiIndexAndLoadApiJson:function(d){var e,m,v,t=this._sTopicid;this._aApiIndex=d;d.some(function(E){if(E.name===t){e=E;return true;}});if(!e){d.some(function(E){if(E.name.indexOf(t)===0){e=E;v=true;return true;}});}if(e){this._oEntityData=e;if(!v&&e.deprecated){m=this.getOwnerComponent().getConfigUtil().getMasterView("apiId").getController();m.selectDeprecatedSymbol(this._sTopicid);}return A.getLibraryElementsJSONPromise(e.lib).then(function(d){return Promise.resolve(d);});}return Promise.reject(this.NOT_FOUND);},_bindData:function(t){var c=this._oControlData,m,u;u=c['ui5-metadata'];c.hasProperties=false;c.hasOwnMethods=false;c.hasControlProperties=false;c.hasAssociations=false;c.hasAggregations=false;c.hasSpecialSettings=false;c.hasAnnotations=false;var i=function(e){return(this._aAllowedMembers.indexOf(e.visibility)>=0);}.bind(this);var F=function(e){e.name&&(e.name=f.apiRefEntityName(e.name));e.code&&(e.code=f.apiRefEntityName(e.code));if(e.name){var p=e.name.replace(/[$#/]/g,".");e.placeholderId=p+"_method";e.subPlaceholderId=p+"__method";}return e;};if(c.properties){c.properties=this.transformElements(c.properties,i,F);c.hasProperties=!!c.properties.length;}if(c.methods){c.methods=this.transformElements(c.methods,i,F);c.hasOwnMethods=!!c.methods.length;}if(u){c.dnd=u.dnd;if(u.properties){u.properties=this.transformElements(u.properties,i);c.hasControlProperties=!!u.properties.length;}if(u.associations){u.associations=this.transformElements(u.associations,i);c.hasAssociations=!!u.associations.length;}if(u.aggregations){u.aggregations=this.transformElements(u.aggregations,i);c.hasAggregations=!!u.aggregations.length;c.hasAggregationAltTypes=u.aggregations.some(function(e){return!!e.altTypes;});}if(u.specialSettings){u.specialSettings=this.transformElements(u.specialSettings,i);c.hasSpecialSettings=!!u.specialSettings.length;}c.hasAnnotations=!!(u.annotations&&u.annotations.length);}c.hasChildren=!!c.nodes;c.hasConstructor=c.hasOwnProperty("constructor")&&!!c.constructor;c.hasOwnEvents=!!c.events;c.hasEvents=!!(c.hasOwnEvents||(c.borrowed&&c.borrowed.events.length>0));c.hasMethods=!!(c.hasOwnMethods||(c.borrowed&&c.borrowed.methods.length>0));if(c.implements&&c.implements.length){c.implementsParsed=c.implements.map(function(b,d,e){var D=b.split("."),s=D[D.length-1];return{href:b,name:s};});c.hasImplementsData=true;}else{c.hasImplementsData=false;}c.isClass=c.kind==="class";c.isNamespace=c.kind==="namespace";c.isDerived=!!c.extends;c.extendsText=c.extends||this.NOT_AVAILABLE;c.sinceText=c.since||this.NOT_AVAILABLE;c.module=c.module||this.NOT_AVAILABLE;this._oModel.setData(c);if(this.extHookbindData){this.extHookbindData(t,m);}},buildBorrowedModel:function(c){var b,d,s,e,m,M,I,r=[],o,i;if(!c){return Promise.resolve({events:[],methods:[]});}e={methods:[],events:[]};s=c.extends;var v=function(g){return this._aAllowedMembers.indexOf(g.visibility)!==-1;}.bind(this);m=c.methods||[];M=m.map(function(g){return g.name;});var O=function(g){return M.indexOf(g.name)===-1;};I=[s];while(s){i=this._aApiIndex.length;while(i--){o=this._aApiIndex[i];if(o.name===s){s=o.extends;if(s){I.push(s);}if(r.indexOf(o.lib)===-1){r.push(o.lib);}break;}}if(i===-1){break;}}var p=r.map(function(l){return A.getLibraryElementsJSONPromise(l);});return Promise.all(p).then(function(R){var g=[];R.forEach(function(S){g=g.concat(S);});I.forEach(function(s){var h,i=g.length;while(i--){if(g[i].name===s){h=g[i];break;}}var j=function(k){return{name:k.name,link:"#/api/"+s+"/methods/"+k.name};};var E=function(k){return{name:k.name,link:"#/api/"+s+"/events/"+k.name};};if(h){b=(h.methods||[]).filter(v).filter(O).map(j);if(b.length){e.methods.push({name:s,methods:b});}d=(h.events||[]).filter(v).map(E);if(d.length){e.events.push({name:s,events:d});}}});return e;});},transformElements:function(e,F,b){var i,l=e.length,n=[],E;for(i=0;i<l;i++){E=e[i];if(F&&!F(E)){continue;}if(b){b(E);}n.push(E);}return n;}});});
