/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/m/GroupHeaderListItem","sap/ui/model/Filter","sap/ui/model/Sorter","sap/base/util/Version","sap/ui/thirdparty/jquery","sap/base/util/UriParameters","sap/ui/util/Storage"],function(q,D,B,J,C,G,F,S,V,Q,U,a){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ControlsMaster",{_oStorage:new a(a.Type.local),_sStorageKey:"UI5_EXPLORED_LIST_SETTINGS_FROM_1_48",_oViewSettings:{compactOn:false,themeActive:"sap_belize",rtl:false},_oDefaultSettings:{compactOn:false,themeActive:"sap_belize",rtl:false},_oListSettings:{filter:{},groupProperty:"category",groupDescending:false,version:V(sap.ui.version).getMajor()+"."+V(sap.ui.version).getMinor()},_mGroupFunctions:{"name":function(c){var k=c.getProperty("name").charAt(0);return{key:k,text:k};},"namespace":true,"category":true,"since":true,"formFactors":true},_sFilterValue:"",onInit:function(){var e,d,f,o=function(c){this._oView.getModel().setData({entityCount:c.entityCount,entities:c.entities});this.getModel("filter").setData(c.filter);this._toggleListItem(this._getItemToSelect(),true);}.bind(this);this._oRouter=this.getRouter();this._bNavToEntityViaList=false;this._oView=this.getView();C.loadData().then(o);e=new J();e.setSizeLimit(100000);this._oView.setModel(e);d=new J({listMode:(D.system.phone)?"None":"SingleSelectMaster",listItemType:(D.system.phone)?"Active":"Inactive"});d.setDefaultBindingMode("OneWay");this._oView.setModel(d,"viewModel");f=new J();f.setSizeLimit(100000);this.setModel(f,"filter");this._vsFilterBar=this._oView.byId("vsFilterBar");this._vsFilterLabel=this._oView.byId("vsFilterLabel");this._oRouter.getRoute("listFilter").attachPatternMatched(this._onFilterMatched,this);this._oRouter.getRoute("group").attachPatternMatched(this._onGroupMatched,this);this._oRouter.getRoute("entity").attachPatternMatched(this._onEntityMatched,this);this._oRouter.getRoute("sample").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("code").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("controls").attachPatternMatched(this._onControlsMatched,this);this._oRouter.getRoute("controlsMaster").attachPatternMatched(this._onControlsMasterMatched,this);this.LIST_SCROLL_DURATION=0;this._iDomRenderingDelay=0;this._getList().addEventDelegate({onAfterRendering:function(){setTimeout(this._scrollToSelectedListItem.bind(this),this._iDomRenderingDelay);}},this);this._oCore.attachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.attachLocalizationChanged(this._onLocalizationChange,this);this._oView.addEventDelegate({onBeforeFirstShow:this.onBeforeFirstShow.bind(this)});this._oComponent=this.getOwnerComponent();this._oRootView=this.getRootView();this._oViewSettings.compactOn=this._oComponent.getContentDensityClass()==="sapUiSizeCompact";this._oViewSettings.rtl=this._oCore.getConfiguration().getRTL();this._oDefaultSettings.compactOn=this._oViewSettings.compactOn;this._oDefaultSettings.rtl=this._oViewSettings.rtl;this._initListSettings();},_viewSettingsResetOnNavigation:function(e){var r=e.getParameter("name");if(["group","entity","sample","code","code_file","controls","controlsMaster","listFilter"].indexOf(r)===-1){this._applyAppConfiguration(this._oDefaultSettings.themeActive,this._oDefaultSettings.compactOn,this._oDefaultSettings.rtl);this.getRouter().detachBeforeRouteMatched(this._viewSettingsResetOnNavigation,this);}},_initListSettings:function(){var j=this._oStorage.get(this._sStorageKey);if(j){this._oListSettings=JSON.parse(j);}},_applyAppConfiguration:function(t,c,r){var s,o,$,R,T,b;if(this._oViewSettings.compactOn!==c){Q(document.body).toggleClass("sapUiSizeCompact",c).toggleClass("sapUiSizeCozy",!c);this._oViewSettings.compactOn=c;b=true;}if(this._oViewSettings.rtl!==r){this._oCore.getConfiguration().setRTL(r);this._oViewSettings.rtl=r;R=true;}if(this._oViewSettings.themeActive!==t){this._oCore.applyTheme(t);this._oViewSettings.themeActive=t;T=true;}else if(b){this._oCore.notifyContentDensityChanged();}if(R||b||T){$=Q("#sampleFrame");if($.length>0){s=$[0].contentWindow;if(s){o=s.sap.ui.getCore();if(b){s.jQuery('body').toggleClass("sapUiSizeCompact",c).toggleClass("sapUiSizeCozy",!c);}if(R){o.getConfiguration().setRTL(r);}if(T){o.applyTheme(t);}else if(b){o.notifyContentDensityChanged();}}}}},_onGroupMatched:function(e){this._onMatched('#/group/',e);},_onEntityMatched:function(e){this._onMatched('#/entity/',e);},_onSampleMatched:function(e){this._onMatched('#/sample/',e);},_onMatched:function(n,e){var E=this._getList().getModel(),s=e.getParameter("arguments").id;this.showMasterSide();this._topicId=n+s;this._entityId=s;E.refresh();this._updateListSelection();},_onControlsMasterMatched:function(e){this.showMasterSide();if(!D.system.phone){this.getRouter().navTo("controls");}},_onFilterMatched:function(e){var f=e.getParameter("arguments").value,s;if(f){s=this.byId("searchField");s.setValue(f).fireLiveChange({newValue:f});setTimeout(function(){this.getSplitApp().showMaster();}.bind(this),0);if(D.system.phone){this.getRouter().navTo("controlsMaster",{});}}this._onControlsMatched(e);},_onControlsMatched:function(){this.showMasterSide();this._resetListSelection();if(D.system.desktop){setTimeout(function(){this.getView().byId("searchField").getFocusDomRef().focus();}.bind(this),0);}},_onLocalizationChange:function(e){this._iDomRenderingDelay=3000;setTimeout(function(){this._iDomRenderingDelay=0;}.bind(this),this._iDomRenderingDelay);},onNavToEntity:function(e){var i=e.getParameter("listItem"),I=(i)?i:e.getSource(),p=I.getBindingContext().getPath(),E=this.getView().getModel().getProperty(p),r=!D.system.phone;this._bNavToEntityViaList=true;this.getRouter().navTo("entity",{id:E.id,part:"samples"},r);},getGroupHeader:function(g){return new G({title:g.key,upperCase:false});},_updateListSelection:function(){var i=this._getItemToSelect();if(!i){return;}this._toggleListItem(i,true);if(!this._bNavToEntityViaList){setTimeout(this._scrollToSelectedListItem.bind(this),0);}this._bNavToEntityViaList=false;},_resetListSelection:function(){var s=this._getList().getSelectedItem();if(s){this._toggleListItem(s,false);setTimeout(this._scrollPageTo.bind(this,0,0),0);}},_toggleListItem:function(i,s){this._getList().setSelectedItem(i,s,false);},_scrollToSelectedListItem:function(){var i=this._getList().getSelectedItem();if(i){this._getPage().scrollToElement(i,this.LIST_SCROLL_DURATION);}},_scrollPageTo:function(p,d){this._getPage().scrollTo(p,d);},_getItemToSelect:function(){var l=this._getList(),e=l.getModel(),E,i,I,L=this._entityId,o=null;l.getItems().forEach(function(b){i=b.getBindingContext();if(i){I=i.getPath();E=e.getProperty(I);if(E.id===L){o=b;return false;}}});return o;},_getPage:function(){if(!this.oPage){this.oPage=this.byId("exploredMasterPage");}return this.oPage;},_getList:function(){if(!this.oList){this.oList=this.byId("exploredMasterList");}return this.oList;},onBeforeFirstShow:function(){this._updateView();},onExit:function(){this._oCore.detachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.detachLocalizationChanged(this._onLocalizationChange,this);},onConfirmViewSettings:function(e){var g=e.getParameter("groupItem");this._oListSettings.filter=e.getParameter("filterCompoundKeys");this._oListSettings.groupProperty=g?g.getKey():null;this._oListSettings.groupDescending=e.getParameter("groupDescending");this._oStorage.put(this._sStorageKey,JSON.stringify(this._oListSettings));this._updateView();},handleListSettings:function(){if(!this._oVSDialog){this._oVSDialog=sap.ui.xmlfragment(this.getView().getId(),"sap.ui.documentation.sdk.view.viewSettingsDialog",this);this.getView().addDependent(this._oVSDialog);}this._oVSDialog.setSelectedFilterCompoundKeys(this._oListSettings.filter);this._oVSDialog.setSelectedGroupItem(this._oListSettings.groupProperty);this._oVSDialog.setGroupDescending(this._oListSettings.groupDescending);this._oVSDialog.open();},handleListFilter:function(e){this._sFilterValue=e.getParameter("newValue").trim();this._updateView();},_updateListBinding:function(){var f,s,b=[],c=[],d=false,g=false,l=this._oView.byId("exploredMasterList"),o=l.getBinding("items");d=true;b.push(new F("searchTags","Contains",this._sFilterValue));Q.each(this._oListSettings.filter,function(p,v){var P=[];Q.each(v,function(k,e){var O=(p==="formFactors")?"Contains":"EQ";P.push(new F(p,O,k));});d=true;b.push(new F(P,false));});if(d&&b.length===0){o.filter(b,"Application");}else if(d&&b.length>0){f=new F(b,true);o.filter(f,"Application");}if(this._oListSettings.groupProperty&&this._oListSettings.groupProperty!==this._sCurrentGroup){g=true;}else if(this._oListSettings.groupProperty&&this._oListSettings.groupDescending!==this._bCurrentlyGroupedDescending){g=true;}if(g){s=new S(this._oListSettings.groupProperty,this._oListSettings.groupDescending,this._mGroupFunctions[this._oListSettings.groupProperty]);c.push(s);c.push(new S("name",false));o.sort(c);}this._sCurrentGroup=this._oListSettings.groupProperty;this._bCurrentlyGroupedDescending=this._oListSettings.groupDescending;this._bIsViewUpdatedAtLeastOnce=true;},_updateView:function(){this._updateFilterBarDisplay();this._updateListBinding();},_updateFilterBarDisplay:function(){var f=[];Q.each(this._oListSettings.filter,function(p,v){f=f.concat(Object.keys(v));});if(f.length>0){this._vsFilterBar.setVisible(true);this._vsFilterLabel.setText(f.join(", "));}else{this._vsFilterBar.setVisible(false);}},handleSettings:function(){if(!this._oSettingsDialog){this._oSettingsDialog=new sap.ui.xmlfragment("sap.ui.documentation.sdk.view.appSettingsDialog",this);this._oView.addDependent(this._oSettingsDialog);}setTimeout(function(){var A=this._oCore.getConfiguration(),t=this._oCore.byId("ThemeSelect"),u=new U(window.location.href).get("sap-theme"),c=this._oViewSettings.compactOn;t.setSelectedKey(u?u:A.getTheme());this._oCore.byId("RTLSwitch").setState(A.getRTL());this._oCore.byId("CompactModeSwitch").setState(c);this._oSettingsDialog.open();}.bind(this),0);},handleCloseAppSettings:function(){this._oSettingsDialog.close();},handleSaveAppSettings:function(){var b,c=this._oCore.byId('CompactModeSwitch').getState(),t=this._oCore.byId('ThemeSelect').getSelectedKey(),r=this._oCore.byId('RTLSwitch').getState();this._oSettingsDialog.close();if(!this._oBusyDialog){q.sap.require("sap.m.BusyDialog");b=sap.ui.require("sap/m/BusyDialog");this._oBusyDialog=new b();this.getView().addDependent(this._oBusyDialog);}this._oBusyDialog.open();setTimeout(function(){this._oBusyDialog.close();}.bind(this),1000);this._applyAppConfiguration(t,c,r);this.getRouter().attachBeforeRouteMatched(this._viewSettingsResetOnNavigation,this);}});});
