/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","./library","sap/ui/unified/Menu","sap/ui/base/ManagedObject","sap/m/Popover","sap/m/VBox","sap/m/HBox","sap/m/Button","sap/m/FlexItemData","sap/ui/dom/jquery/rect"],function(q,l,M,a,P,V,H,B,F){"use strict";var C=a.extend("sap.ui.dt.ContextMenuControl",{metadata:{properties:{"maxButtonsDisplayed":{type:"int",defaultValue:4},"buttons":{type:"object[]",defaultValue:[]},styleClass:{type:"string"}},events:{Opened:{},Closed:{},OverflowButtonPressed:{}}},init:function(){var p=this.getId()+"-popover";var o=new P(p,{showHeader:false,verticalScrolling:false,placement:"Top",showArrow:true,horizontalScrolling:false,content:new H(p+"ContentBox",{renderType:"Bare"})});o._getAnimationDuration=function(){return 0;};o.attachBrowserEvent("keydown",this._changeFocusOnKeyStroke,this);o.oPopup.attachClosed(this._popupClosed,this);this._oPopover=o;o.addStyleClass("sapUiDtContextMenu");var s=this.getId()+"-popoverExp";var b=new P(s,{showHeader:false,showArrow:false,verticalScrolling:false,horizontalScrolling:false,content:new V(s+"ContentBox",{renderType:"Bare"})});b._getAnimationDuration=function(){return 0;};b.attachBrowserEvent("keydown",this._changeFocusOnKeyStroke,this);b.oPopup.attachClosed(this._popupClosed,this);this._oExpandedPopover=b;b.addStyleClass("sapUiDtContextMenu");o.attachBrowserEvent("contextmenu",this._onContextMenu,this);b.attachBrowserEvent("contextmenu",this._onContextMenu,this);this.bOnInit=true;},exit:function(){this.getPopover(true).oPopup.detachClosed(this._popupClosed,this);this.getPopover(false).oPopup.detachClosed(this._popupClosed,this);this.getPopover(true).detachBrowserEvent("contextmenu",this._onContextMenu,this);this.getPopover(false).detachBrowserEvent("contextmenu",this._onContextMenu,this);this.getPopover(true).destroy();this.getPopover(false).destroy();},show:function(s,c,o){if(this._bUseExpPop===undefined){this._bUseExpPop=!!c;}this._bCompactMode=q(s.getDomRef()).closest(".sapUiSizeCompact").length>0;this._bOpenAsContextMenu=c;this._oContextMenuPosition=o;this.getPopover(true).addStyleClass(this.getStyleClass()||"");this.getPopover(false).addStyleClass(this.getStyleClass()||"");var b=this.getButtons();this._oTarget=s;if(!this._bOpenAsContextMenu){this._setButtonsForContextMenu(b,s);}else{this._makeAllButtonsVisible(b);}if(this.bOnInit||!this.getPopover().isOpen()){this.finalizeOpening();this.bOnInit=false;}},finalizeOpening:function(){if(this._bOpenAsContextMenu&&this._oContextMenuPosition.x===null&&this._oContextMenuPosition.y===null){this._bOpenAsContextMenu=false;}this.getPopover().attachAfterOpen(this._handleAfterOpen,this);this.getPopover().attachBeforeClose(this._handleBeforeClose,this);this._oTarget=this._placeContextMenu(this._oTarget,this._bOpenAsContextMenu);this.getPopover().setVisible(true);this.bOpen=true;this.bOpenNew=false;},_setButtonsForContextMenu:function(b,s){var i=this._getNumberOfEnabledButtons(b);if(i!==0){this._hideDisabledButtons(b);}this._iButtonsVisible=this._hideButtonsInOverflow(b);if(this._iButtonsVisible===this.getMaxButtonsDisplayed()&&this._iButtonsVisible!==b.length){this._replaceLastVisibleButtonWithOverflowButton(b);}else if(i<b.length-1&&i!==0){this.addOverflowButton();}i=null;},_makeAllButtonsVisible:function(b){this._iFirstVisibleButtonIndex=0;b.forEach(function(o){o.setVisible(true);o._bInOverflow=true;});},_getNumberOfEnabledButtons:function(b){var c=0;for(var i=0;i<b.length;i++){if(b[i].getEnabled()){c++;if(!this._iFirstVisibleButtonIndex){this._iFirstVisibleButtonIndex=i;}}}return c;},_hideDisabledButtons:function(b){var v=0;b.forEach(function(o){o.setVisible(o.getEnabled());if(o.getEnabled()){v++;}});return v;},_hideButtonsInOverflow:function(b){var v=0;for(var i=0;i<b.length;i++){if(v<this.getMaxButtonsDisplayed()&&b[i].getVisible()){v++;}else{b[i].setVisible(false);}}return v;},_replaceLastVisibleButtonWithOverflowButton:function(b){for(var i=b.length-1;i>=0;i--){if(b[i].getVisible()){b[i].setVisible(false);this.addOverflowButton();return;}}},_placeContextMenu:function(s,c){this.getPopover().setShowArrow(true);var o=(s.getId&&s.getId())||s.getAttribute("overlay");var f="contextMenuFakeDiv";var O=this._getOverlayDimensions(o);var v=this._getViewportDimensions();var i=O.top-10>v.top?0:v.top-(O.top-10);q("#"+f).remove();q("#"+o).append("<div id=\""+f+"\" overlay=\""+o+"\" style = \"position: absolute; top: "+i+"px; left: 0px;\" />");var b=document.getElementById(f);this.getPopover().setContentWidth(undefined);this.getPopover().setContentHeight(undefined);this.getPopover().openBy(b);var p=this._getPopoverDimensions(!c);if(p.height>=v.height*2/3){this.getPopover().setVerticalScrolling(true);p.height=(v.height*2/3).toFixed(0);this.getPopover().setContentHeight(p.height+"px");}else{this.getPopover().setVerticalScrolling(false);this.getPopover().setContentHeight(undefined);}if(p.width>400){p.width=400;this.getPopover().setContentWidth("400px");}else{this.getPopover().setContentWidth(undefined);}var d={};if(c){d=this._placeAsExpandedContextMenu(this._oContextMenuPosition,p,v);}else{d=this._placeAsCompactContextMenu(O,p,v);}d.top-=O.top;d.left-=O.left;d.top=(d.top<0)?0:d.top;d.left=(d.left<0)?0:d.left;b.style.top=d.top.toFixed(0)+"px";b.style.left=d.left.toFixed(0)+"px";o=null;return b;},_placeAsExpandedContextMenu:function(c,p,v){this.getPopover().setShowArrow(false);var o={};if(v.height-10-c.y>=p.height){o.top=c.y;this.getPopover().setPlacement("Bottom");}else if(c.y>=p.height){o.top=c.y;this.getPopover().setPlacement("Top");}else{o.top=v.height-p.height;this.getPopover().setPlacement("Bottom");}if(v.width-c.x>=p.width){o.left=c.x;}else if(c.x>=p.width){o.left=c.x-p.width/2;}else{o.left=v.width-p.width;}return o;},_placeAsCompactContextMenu:function(o,p,v){this.getPopover().setShowArrow(true);var b={top:null,left:null};if(o.top>=p.height&&!o.isOverlappedAtTop){b=this._placeContextMenuOnTop(o);}else if(v.height-o.top>=parseInt(p.height,10)+5){b=this._placeContextMenuAtTheBottom(o,p,v);}else{b=this._placeContextMenuSideways(o,p,v);}return b;},_placeContextMenuOnTop:function(o){var p={};this.getPopover().setPlacement("Top");p.top=o.top;p.left=o.left+o.width/2;return p;},_placeContextMenuAtTheBottom:function(o,p,v){this.getPopover().setPlacement("Bottom");var b={},r=q(".sapUiRtaToolbar").height(),i=r?r:v.top,c=r?v.height-r:v.height;b.left=o.left+o.width/2;if((o.height<60||o.isOverlappedAtTop)&&c-o.top-o.height>=p.height){b.top=o.bottom;}else if(o.top>=i){b.top=o.top+5;}else{b.top=i+5;}return b;},_placeContextMenuSideways:function(o,p,v){var b={};b.left=this._getContextMenuSidewaysPlacement(o,p,v);b.top=this._getMiddleOfOverlayAndViewportEdges(o,v);return b;},_getContextMenuSidewaysPlacement:function(o,p,v){var L;if(v.width-o.right>=p.width){this.getPopover().setPlacement("Right");L=o.right;}else if(o.left>=p.width){this.getPopover().setPlacement("Left");L=o.left;}else{this.getPopover().setPlacement("Right");if(p.width<=v.width-(o.left+o.width/2)){L=(o.left+o.width/2);}else{L=v.width-p.width;}}return L;},_getMiddleOfOverlayAndViewportEdges:function(o,v){var t;if(v.top>o.top){t=v.top;}else{t=o.top;}if(v.bottom<o.bottom){t+=v.bottom;}else{t+=o.bottom;}t/=2;return t;},_getPopoverDimensions:function(w){var p={};var c=this._bCompactMode;var A=this._getArrowHeight(c);var b=this._getBaseFontSize();this._iFirstVisibleButtonIndex=null;p.height=parseInt(q("#"+this.getPopover().getId()).css("height"),10)||40;p.width=parseInt(q("#"+this.getPopover().getId()).css("width"),10)||80;if(w){var i=b*A;if(i){p.height+=i;p.width+=i;}}return p;},_getArrowHeight:function(c){if(sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.edge){return c?0.5:0.5;}else{return c?0.5625:0.5625;}},_getBaseFontSize:function(){return parseInt(q(document.documentElement).css("fontSize"),10);},_getOverlayDimensions:function(o){var O=q("#"+o).rect();O.right=O.left+O.width;O.bottom=O.top+O.height;O.isOverlappedAtTop=this._isOverlayOverlapped(o,O,"top");O.isOverlappedAtBottom=this._isOverlayOverlapped(o,O,"bottom");return O;},_isOverlayOverlapped:function(s,o,t){var e;if(t==="top"){e=document.elementFromPoint(o.left+(o.width/2),(o.top+5));}if(t==="bottom"){e=document.elementFromPoint(o.left+(o.width/2),(o.bottom-5));}if(!e){return true;}else if(e.id===s){return false;}return!q("#"+s)[0].contains(e);},_getViewportDimensions:function(){var v={};v.width=window.innerWidth;v.height=window.innerHeight;v.top=parseInt(q(".type_standalone").css("height"),10)||0;v.bottom=v.top+v.height;return v;},_getIcon:function(i){if(i===undefined||i===null||typeof i!=="string"){return"sap-icon://incident";}if(i==="blank"){return" ";}return i;},addOverflowButton:function(){var o="OVERFLOW_BUTTON",b={icon:"sap-icon://overflow",type:"Transparent",enabled:true,press:this._onOverflowPress.bind(this),layoutData:new F({})};return this._addButton(o,b);},addMenuButton:function(b,c,e){var h=function(d){this.bOpen=false;this.bOpenNew=false;c(this);};var t=typeof b.text==="function"?b.text(e[0]):b.text;var E=typeof b.enabled==="function"?b.enabled(e):b.enabled;var o={icon:this._getIcon(b.icon),text:t,tooltip:t,type:"Transparent",enabled:E,press:h,layoutData:new F({})};return this._addButton(b.id,o);},_addButton:function(b,o){this.setProperty("buttons",this.getProperty("buttons").concat(o));var c={id:b,key:b};var e=new B(o);e.data(c);delete o.text;var d=new B(o);d.data(c);this.getFlexbox(true).addItem(e);this.getFlexbox(false).addItem(d);return this;},close:function(e){if(this.getPopover()){if(e){this.getPopover(true).close();this.getPopover(false).close();}if(this.getProperty("buttons").length>this.getProperty("maxButtonsDisplayed")){this.setProperty("buttons",this.getProperty("buttons").splice(0,this.getProperty("buttons").length-1));this.getFlexbox().removeItem(this.getButtons().length-1);}}return this;},removeButton:function(i){this.setProperty("buttons",this.getProperty("buttons").splice(i,1));this.getFlexbox(true).removeItem(i);return this.getFlexbox(false).removeItem(i);},removeAllButtons:function(){this.setProperty("buttons",[]);this.getFlexbox(true).removeAllItems();return this.getFlexbox(false).removeAllItems();},getButtons:function(){return this.getFlexbox().getItems();},insertButton:function(b,i){this.getFlexbox().insertItem(b,i);return this;},setButtons:function(_,c,e){this.removeAllButtons();_.forEach(function(b){this.addMenuButton(b,c,e);}.bind(this));},setMaxButtonsDisplayed:function(m){if(m<2){throw Error("maxButtonsDisplayed can't be less than two!");}this.setProperty("maxButtonsDisplayed",m);},getPopover:function(e){if(e===undefined){if(this._bUseExpPop){return this._oExpandedPopover;}else{return this._oPopover;}}else if(e){return this._oExpandedPopover;}else{return this._oPopover;}},getFlexbox:function(e){return this.getPopover(e).getContent()[0];},setOpenNew:function(v){this.bOpenNew=v;},_onOverflowPress:function(e){this.fireOverflowButtonPressed({oButton:e.oSource});},_popupClosed:function(){if(this.getPopover()){this.fireClosed();if(this.bOpenNew){this.bOpenNew=false;this.finalizeOpening();return;}}this.bOpen=false;},_setFocusOnButton:function(b){if(b.getEnabled()&&b.getVisible()){b.focus();return true;}},_changeFocusOnKeyStroke:function(e){if(document.activeElement){var i=document.activeElement.id;switch(e.key){case"ArrowRight":this._changeFocusOnButtons(i);break;case"ArrowLeft":this._changeFocusOnButtons(i,true);break;case"ArrowUp":this._changeFocusOnButtons(i,true);break;case"ArrowDown":this._changeFocusOnButtons(i);break;default:break;}}},_changeFocusOnButtons:function(i,p){this.getButtons().some(function(b,I,A){if(i===b.getId()){if(p){this._setFocusOnPreviousButton(A,I);}else{this._setFocusOnNextButton(A,I);}return true;}}.bind(this));},_setFocusOnNextButton:function(b,i){for(var c=i+1;c<b.length;c++){if(this._setFocusOnButton(b[c])){return;}}for(var d=0;d<i;d++){if(this._setFocusOnButton(b[d])){return;}}},_setFocusOnPreviousButton:function(b,i){for(var c=i-1;c>=0;c--){if(this._setFocusOnButton(b[c])){return;}}for(var d=b.length-1;d>=i;d--){if(this._setFocusOnButton(b[d])){return;}}},_onContextMenu:function(e){if(e.preventDefault){e.preventDefault();}},_handleAfterOpen:function(){this.getPopover().detachAfterOpen(this._handleAfterOpen,this);this.getPopover().addStyleClass("sapUiDtContextMenuVisible");this.fireOpened();},_handleBeforeClose:function(){this.getPopover().detachBeforeClose(this._handleBeforeClose,this);this.getPopover().removeStyleClass("sapUiDtContextMenuVisible");},setStyleClass:function(s){this.setProperty("styleClass",s);}});return C;},true);
