/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/fl/ControlPersonalizationAPI',["sap/ui/fl/Utils","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/FlexControllerFactory","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element","sap/ui/base/ManagedObject","sap/ui/fl/variants/VariantManagement","sap/ui/core/Component","sap/ui/thirdparty/jquery"],function(U,C,F,J,E,M,V,a,q){"use strict";var b="sap-ui-fl-control-variant-id";var c={_determineParameters:function(o){var A=U.getAppComponentForControl(o);var f=F.createForControl(A);var r=A.getRootControl();var v=U.getViewForControl(o);var d=A.getModel("$FlexVariants");var p={rootControl:r,view:v,variantModel:d,variantManagement:{},flexController:f};var e;var g;q.makeArray(p.rootControl.$().find(".sapUiFlVarMngmt")).map(function(h){e=sap.ui.getCore().byId(h.id);if(e.getMetadata().getName()==="sap.ui.fl.variants.VariantManagement"){g=e.getFor();g.forEach(function(s){p.variantManagement[s]=p.variantModel._getLocalId(h.id,A);});}});return p;},_getVariantManagement:function(o,p){p=p||this._determineParameters(o);var f=function(o){if(!p.variantManagement[o.getId()]&&o.getParent()&&o.getId()!==p.rootControl.getId()){return f(o.getParent());}else if(!o.getParent()||o.getId()===p.rootControl.getId()){return p.variantManagement[o.getId()]||"";}else{return p.variantManagement[o.getId()];}};return f(o);},clearVariantParameterInURL:function(o){var u=[];var A=U.getAppComponentForControl(o);var v=A instanceof a?A.getModel("$FlexVariants"):undefined;if(!v){U.setTechnicalURLParameterValues(undefined,b,u);return U.log.warning("Variant model could not be found on the provided control");}if(o instanceof V){var s=v._getLocalId(o.getId(),A);var m=v.getVariantIndexInURL(s);if(m.index>-1){m.parameters[b].splice(m.index,1);u=m.parameters[b].slice(0);}}v.updateHasherEntry({parameters:u,updateURL:true,component:A});},activateVariant:function(e,v){var o;return Promise.resolve().then(function(){if(typeof e==='string'||e instanceof String){o=a.get(e);if(!(o instanceof a)){o=sap.ui.getCore().byId(e);if(!(o instanceof E)){throw new Error("No valid component or control found for the provided ID");}}}else if(e instanceof a||e instanceof E){o=e;}var A=U.getAppComponentForControl(o);if(!A){throw new Error("A valid variant management control or component (instance or ID) should be passed as parameter");}var d=A.getModel("$FlexVariants");if(!d){throw new Error("No variant management model found for the passed control or application component");}var s=d.getVariantManagementReference(v).variantManagementReference;if(!s){throw new Error("A valid control or component, and a valid variant/ID combination are required");}return d.updateCurrentVariant(s,v,A);})["catch"](function(d){U.log.error(d);return Promise.reject(d);});},_checkChangeSpecificData:function(o,l){if(!o.changeSpecificData){return"No changeSpecificData available";}if(!o.changeSpecificData.changeType){return"No valid changeType";}if(!(o.selectorControl instanceof E)){return"No valid selectorControl";}var s=o.selectorControl.getMetadata().getName();var d=C.getInstance().getChangeHandler(o.changeSpecificData.changeType,s,o.selectorControl,J,l);if(!d){return"No valid ChangeHandler";}if(!d.revertChange){return"ChangeHandler has no revertChange function";}},addPersonalizationChanges:function(p){var s=[];var l=U.getCurrentLayer(true);var P=[];p.controlChanges.forEach(function(o){var m={};Object.assign(m,{developerMode:false,layer:l});var d=this._checkChangeSpecificData(o,l);if(d){P.push(function(){return Promise.reject({change:o,message:d});});return;}var e=this._determineParameters(o.selectorControl);if(!p.ignoreVariantManagement){if(!o.changeSpecificData.variantReference){var v=this._getVariantManagement(o.selectorControl,e);if(v){var f=e.variantModel.oData[v].currentVariant;o.changeSpecificData.variantReference=f;}}}else{delete o.changeSpecificData.variantReference;}P.push(function(){return e.flexController.createAndApplyChange(Object.assign(m,o.changeSpecificData),o.selectorControl).then(function(A){s.push(A);});});}.bind(this));return U.execPromiseQueueSequentially(P).then(function(){return s;});},saveChanges:function(d,m){if(!(m instanceof M)){U.log.error("A valid sap.ui.base.ManagedObject instance is required as a parameter");return;}return F.createForControl(m)._oChangePersistence.saveSequenceOfDirtyChanges(d);},hasVariantManagement:function(o){return!!this._getVariantManagement(o);}};return c;},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnectorLocalStorage',["sap/ui/fl/FakeLrepConnectorStorage","sap/ui/fl/FakeLrepLocalStorage"],function(F,a){"use strict";return F(a);},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnectorSessionStorage',["sap/ui/fl/FakeLrepConnectorStorage","sap/ui/fl/FakeLrepSessionStorage"],function(F,a){"use strict";return F(a);},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnectorStorage',["sap/ui/fl/FakeLrepConnector","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/Utils"],function(F,L,C,a,U){"use strict";return function(f){b._oBackendInstances={};function b(S){this.mSettings=Object.assign({"isKeyUser":true,"isAtoAvailable":false,"isProductiveSystem":false},S);}Object.assign(b.prototype,F.prototype);b.prototype.create=function(v){var r;if(Array.isArray(v)){r=v.map(function(m){return this._saveChange(m);}.bind(this));}else{r=this._saveChange(v);}return Promise.resolve({response:r,status:'success'});};b.prototype._saveChange=function(m){if(!m.creation){m.creation=new Date().toISOString();}f.saveChange(m.fileName,m);return m;};b.prototype.update=function(m,e,g,i){return Promise.resolve({response:this._saveChange(m),status:'success'});};b.prototype.send=function(u,m,D,o){function _(e,r){if((e.reference===r.parameters[1]||e.reference+".Component"===r.parameters[1])&&e.layer===r.parameters[2]){return true;}}if(m==="DELETE"){return F.prototype.send.apply(this,arguments).then(function(r){f.getChanges().forEach(function(e){if(_(e,r.response)){f.deleteChange(e.fileName);}});return Promise.resolve({response:undefined,status:"nocontent"});});}else{return F.prototype.send.apply(this,arguments);}};b.prototype.deleteChange=function(o){f.deleteChange(o.sChangeName);return Promise.resolve({response:undefined,status:"nocontent"});};b.prototype.deleteChanges=function(){f.deleteChanges();return Promise.resolve({response:undefined,status:"nocontent"});};b.prototype.loadChanges=function(e){var g=f.getChanges();return new Promise(function(r,h){var R={};if(this.mSettings.sInitialComponentJsonPath){jQuery.getJSON(this.mSettings.sInitialComponentJsonPath).done(function(o){R={changes:o,componentClassName:e};r(R);}).fail(function(i){h(i);});}else{r(R);}}.bind(this)).then(function(r){var v=[];var h=[];var i=[];var j=[];g.forEach(function(o){if(o.fileType==="ctrl_variant"&&o.variantManagementReference){v.push(o);}else if(o.fileType==="ctrl_variant_change"){h.push(o);}else if(o.fileType==="ctrl_variant_management_change"){i.push(o);}else{j.push(o);}});r=this._createChangesMap(r,v);r=this._addChangesToMap(r,j,h,i);r=this._sortChanges(r);r=this._assignVariantReferenceChanges(r);r.changes.contexts=[];r.changes.settings=this.mSettings;r.componentClassName=e;return r;}.bind(this));};b.prototype._createChangesMap=function(r,v){if(!r||!r.changes){r={changes:{}};}if(!r.changes.changes){r.changes.changes=[];}if(!r.changes.variantSection){r.changes.variantSection={};}var e=function(E,n){return E.some(function(o){return o.content.fileName===n.fileName;});};var V={};v.forEach(function(o){V=r.changes.variantSection[o.variantManagementReference];if(!V){var S=this._fakeStandardVariant(o.variantManagementReference);V=this._getVariantManagementStructure([this._getVariantStructure(S,[],{}),this._getVariantStructure(o,[],{})],{});r.changes.variantSection[o.variantManagementReference]=V;}else if(!e(V.variants,o)){V.variants.push(this._getVariantStructure(o,[],{}));}}.bind(this));return r;};b.prototype._getVariantStructure=function(v,e,V){return{content:v,controlChanges:e,variantChanges:V};};b.prototype._getVariantManagementStructure=function(v,V){return{variants:v,variantManagementChanges:V};};function s(A){A.sort(c);}function c(o,e){var l=U.getLayerIndex(o.layer);var i=U.getLayerIndex(e.layer);if(l!==i){return l-i;}return new Date(o.creation)-new Date(e.creation);}b.prototype._sortChanges=function(r){if(r.changes.changes){s(r.changes.changes);}d(r,function(v){s(v.controlChanges);});return r;};function d(r,e){Object.keys(r.changes.variantSection).forEach(function(v){var V=r.changes.variantSection[v].variants;V.forEach(e);});}b.prototype._assignVariantReferenceChanges=function(r){d(r,function(v){var V=v.content.variantReference;var e=v.controlChanges;if(V){e=this._getReferencedChanges(r,v).concat(e);}v.controlChanges=e;}.bind(this));return r;};function w(r,v,V,e){r.changes.variantSection[v].variants.some(function(o){if(o.content.fileName===V){e(o);return true;}});}b.prototype._getReferencedChanges=function(r,o){var R=[];w(r,o.content.variantManagementReference,o.content.variantReference,function(v){R=v.controlChanges.filter(function(e){return U.compareAgainstCurrentLayer(e.layer)===-1;});if(v.content.variantReference){R=R.concat(this._getReferencedChanges(r,v));}}.bind(this));return R;};b.prototype._addChangesToMap=function(r,e,g,h){var A=function(r,V,o){w(r,V,o.variantReference,function(j){j.controlChanges.push(o);});};var i=function(r,V,o){w(r,V,o.selector.id,function(j){if(!j.variantChanges[o.changeType]){j.variantChanges[o.changeType]=[];}j.variantChanges[o.changeType].push(o);});};var v={};h.forEach(function(V){var j=V.selector.id;if(Object.keys(r.changes.variantSection).length===0){r.changes.variantSection[j]=this._getVariantManagementStructure([this._getVariantStructure(this._fakeStandardVariant(j),[],{})],{});}v=r.changes.variantSection[j].variantManagementChanges;if(!v[V.changeType]){v[V.changeType]=[];}v[V.changeType].push(V);}.bind(this));e.forEach(function(o){if(!o.variantReference){r.changes.changes.push(o);}else if(Object.keys(r.changes.variantSection).length===0){r.changes.variantSection[o.variantReference]=this._getVariantManagementStructure([this._getVariantStructure(this._fakeStandardVariant(o.variantReference),[o],{})],{});}else{Object.keys(r.changes.variantSection).forEach(function(V){A(r,V,o);});}}.bind(this));g.forEach(function(V){if(Object.keys(r.changes.variantSection).length===0){var m={};m[V.changeType]=[V];r.changes.variantSection[V.selector.id]=this._getVariantManagementStructure([this._getVariantStructure(this._fakeStandardVariant(V.selector.id),[],m)],{});}else{Object.keys(r.changes.variantSection).forEach(function(j){i(r,j,V);});}}.bind(this));return r;};b.prototype._fakeStandardVariant=function(v){return{fileName:v,fileType:"ctrl_variant",variantManagementReference:v,variantReference:"",content:{title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl").getText("STANDARD_VARIANT_TITLE")}};};b.enableFakeConnector=function(S,A,e){S=S||{};function r(){b.enableFakeConnector.original=L.createConnector;L.createConnector=function(){if(!b._oFakeInstance){b._oFakeInstance=new b(S);}return b._oFakeInstance;};}if(A&&e){var o=a.getChangePersistenceForComponent(A,e);if(!(o._oConnector instanceof b)){C.clearEntry(A,e);if(!b._oBackendInstances[A]){b._oBackendInstances[A]={};}b._oBackendInstances[A][e]=o._oConnector;o._oConnector=new b(S);}r();return;}C.clearEntries();if(b.enableFakeConnector.original){return;}r();};b.disableFakeConnector=function(A,e){function r(){if(b.enableFakeConnector.original){L.createConnector=b.enableFakeConnector.original;b.enableFakeConnector.original=undefined;b._oFakeInstance=undefined;}}if(A&&e){var o=a.getChangePersistenceForComponent(A,e);if(!(o._oConnector instanceof L)){C.clearEntry(A,e);if(b._oBackendInstances[A]&&b._oBackendInstances[A][e]){o._oConnector=b._oBackendInstances[A][e];b._oBackendInstances[A][e]=undefined;}}r();return;}C.clearEntries();r();};return b;};},true);
sap.ui.predefine('sap/ui/fl/FakeLrepLocalStorage',["sap/ui/fl/FakeLrepStorage"],function(F){"use strict";return F(window.localStorage);},true);
sap.ui.predefine('sap/ui/fl/FakeLrepSessionStorage',["sap/ui/fl/FakeLrepStorage"],function(F){"use strict";return F(window.sessionStorage);},true);
sap.ui.predefine('sap/ui/fl/FakeLrepStorage',function(){"use strict";return function(s){var F="sap.ui.fl.change";var a="sap.ui.fl.variant";var b={};b.createChangeKey=function(i){if(i){return F+"."+i;}};b.createVariantKey=function(i){if(i){return a+"."+i;}};b.forEachLrepChangeInLocalStorage=function(p){for(var k in s){if(k.includes(F)||k.includes(a)){p(k);}}};b.getChange=function(i){if(i){var c=s.getItem(this.createChangeKey(i));if(!c){c=s.getItem(this.createVariantKey(i));}return JSON.parse(c);}};b.getChanges=function(){var c=[],C;this.forEachLrepChangeInLocalStorage(function(k){C=JSON.parse(s[k]);c.push(C);});return c;};b.getNumChanges=function(){var c=0;this.forEachLrepChangeInLocalStorage(function(k){c++;});return c;};b._aModifyCallbacks=[];b.attachModifyCallback=function(c){this._aModifyCallbacks.push(c);};b.detachModifyCallback=function(c){var i=this._aModifyCallbacks.indexOf(c);if(i!==-1){this._aModifyCallbacks.splice(i,1);}};b._callModifyCallbacks=function(m){this._aModifyCallbacks.forEach(function(c){c(m);});};b.deleteChange=function(i){if(i){s.removeItem(this.createChangeKey(i));s.removeItem(this.createVariantKey(i));}this._callModifyCallbacks("delete");};b.deleteChanges=function(){this.forEachLrepChangeInLocalStorage(function(k){s.removeItem(k);});this._callModifyCallbacks("delete");};b.saveChange=function(i,c){var C,d;if(i&&c){if(c.fileType==="ctrl_variant"&&c.variantManagementReference){C=this.createVariantKey(i);}else{C=this.createChangeKey(i);}d=JSON.stringify(c);s.setItem(C,d);}this._callModifyCallbacks("save");};return b;};},true);
sap.ui.predefine('sap/ui/fl/variants/VariantManagement',['sap/ui/model/Context','sap/ui/model/PropertyBinding','sap/ui/model/json/JSONModel','sap/ui/model/Filter','sap/ui/Device','sap/ui/core/InvisibleText','sap/ui/core/Control','sap/ui/core/Icon','sap/ui/layout/HorizontalLayout','sap/ui/layout/Grid','sap/m/SearchField','sap/m/RadioButton','sap/m/ColumnListItem','sap/m/Column','sap/m/Text','sap/m/Bar','sap/m/Table','sap/m/Page','sap/m/Toolbar','sap/m/ToolbarSpacer','sap/m/Button','sap/m/CheckBox','sap/m/Dialog','sap/m/Input','sap/m/Label','sap/m/Title','sap/m/ResponsivePopover','sap/m/SelectList','sap/m/ObjectIdentifier','sap/m/OverflowToolbar','sap/m/OverflowToolbarLayoutData','sap/m/VBox','sap/ui/fl/Utils','sap/ui/core/util/reflection/JsControlTreeModifier',"sap/ui/events/KeyCodes","sap/ui/core/library","sap/m/library"],function(C,P,J,F,D,I,a,b,H,G,S,R,c,d,T,B,f,g,h,i,j,k,l,m,L,n,o,p,O,q,r,V,s,t,K,u,v){"use strict";var w=v.OverflowToolbarPriority;var x=v.ButtonType;var y=v.PlacementType;var z=v.PopinDisplay;var A=v.ScreenSize;var E=u.ValueState;var M=u.TextAlign;
var N=a.extend("sap.ui.fl.variants.VariantManagement",{
metadata:{library:"sap.ui.fl",designtime:"sap/ui/fl/designtime/variants/VariantManagement.designtime",properties:{showExecuteOnSelection:{type:"boolean",group:"Misc",defaultValue:false},showSetAsDefault:{type:"boolean",group:"Misc",defaultValue:true},manualVariantKey:{type:"boolean",group:"Misc",defaultValue:false},inErrorState:{type:"boolean",group:"Misc",defaultValue:false},editable:{type:"boolean",group:"Misc",defaultValue:true},modelName:{type:"string",group:"Misc",defaultValue:null},updateVariantInURL:{type:"boolean",group:"Misc",defaultValue:false}},associations:{"for":{type:"sap.ui.core.Control",multiple:true}},events:{save:{parameters:{name:{type:"string"},overwrite:{type:"boolean"},key:{type:"string"},execute:{type:"boolean"},def:{type:"boolean"}}},manage:{},initialized:{},select:{parameters:{key:{type:"string"}}}}},
renderer:function(e,Q){e.write("<div ");e.writeControlData(Q);e.addClass("sapUiFlVarMngmt");e.writeClasses();e.write(">");e.renderControl(Q.oVariantLayout);e.write("</div>");}
});
N.MODEL_NAME="$FlexVariants";N.INNER_MODEL_NAME="$sapUiFlVariants";N.MAX_NAME_LEN=100;N.COLUMN_FAV_IDX=0;N.COLUMN_NAME_IDX=1;
N.prototype.init=function(){this._sModelName=N.MODEL_NAME;this.attachModelContextChange(this._setModel,this);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this._createInnerModel();this.oVariantInvisibleText=new I({text:{parts:[{path:'currentVariant',model:this._sModelName},{path:"modified",model:this._sModelName}],formatter:function(Q,U){if(U){Q=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT_MOD",[Q]);}else{Q=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT",[Q]);}}.bind(this)}});this.oVariantText=new n(this.getId()+"-text",{text:{path:'currentVariant',model:this._sModelName,formatter:function(Q){var U=this.getSelectedVariantText(Q);return U;}.bind(this)}});this.oVariantText.addStyleClass("sapUiFlVarMngmtClickable");this.oVariantText.addStyleClass("sapUiFlVarMngmtTitle");if(D.system.phone){this.oVariantText.addStyleClass("sapUiFlVarMngmtTextPhoneMaxWidth");}else{this.oVariantText.addStyleClass("sapUiFlVarMngmtTextMaxWidth");}var e=new L(this.getId()+"-modified",{text:"*",visible:{path:"modified",model:this._sModelName,formatter:function(Q){return(Q===null||Q===undefined)?false:Q;}}});e.setVisible(false);e.addStyleClass("sapUiFlVarMngmtModified");e.addStyleClass("sapUiFlVarMngmtClickable");e.addStyleClass("sapMTitleStyleH4");this.oVariantPopoverTrigger=new j(this.getId()+"-trigger",{icon:"sap-icon://slim-arrow-down",type:x.Transparent});this.oVariantPopoverTrigger.addAriaLabelledBy(this.oVariantInvisibleText);this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtn");this.oVariantPopoverTrigger.addStyleClass("sapMTitleStyleH4");this.oVariantLayout=new H({content:[this.oVariantText,e,this.oVariantPopoverTrigger,this.oVariantInvisibleText]});this.oVariantLayout.addStyleClass("sapUiFlVarMngmtLayout");this.addDependent(this.oVariantLayout);};
N.prototype.getTitle=function(){return this.oVariantText;};
N.prototype._createInnerModel=function(){var e=new J({showExecuteOnSelection:false,showSetAsDefault:true,editable:true,popoverTitle:this._oRb.getText("VARIANT_MANAGEMENT_VARIANTS")});this.setModel(e,N.INNER_MODEL_NAME);this._bindProperties();};
N.prototype._bindProperties=function(){this.bindProperty("showExecuteOnSelection",{path:"/showExecuteOnSelection",model:N.INNER_MODEL_NAME});this.bindProperty("showSetAsDefault",{path:"/showSetAsDefault",model:N.INNER_MODEL_NAME});this.bindProperty("editable",{path:"/editable",model:N.INNER_MODEL_NAME});};
N.prototype.getOriginalDefaultVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/originalDefaultVariant");}return null;};
N.prototype.setDefaultVariantKey=function(e){var Q=this.getModel(this._sModelName);if(Q&&this.oContext){Q.setProperty(this.oContext+"/defaultVariant",e);}};
N.prototype.getDefaultVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/defaultVariant");}return null;};
N.prototype.setCurrentVariantKey=function(e){var Q=this.getModel(this._sModelName);if(Q&&this.oContext){Q.setProperty(this.oContext+"/currentVariant",e);}return this;};
N.prototype.getCurrentVariantKey=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/currentVariant");}return null;};
N.prototype._assignPopoverTitle=function(){var e,Q,U=this.getModel(this._sModelName);if(U&&this.oContext){e=U.getProperty(this.oContext+"/popoverTitle");}if(e!==undefined){Q=this.getModel(N.INNER_MODEL_NAME);if(Q){Q.setProperty("/popoverTitle",e);}}};
N.prototype.getVariants=function(){return this._getItems();};
N.prototype.setModified=function(e){var Q=this.getModel(this._sModelName);if(Q&&this.oContext){Q.setProperty(this.oContext+"/modified",e);}};
N.prototype.getModified=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/modified");}return false;};
N.prototype.getSelectedVariantText=function(e){var Q=this._getItemByKey(e);if(Q){return Q.title;}return"";};
N.prototype.getStandardVariantKey=function(){var e=this._getItems();if(e&&e[0]){return e[0].key;}return null;};
N.prototype.getShowFavorites=function(){var e=this.getModel(this._sModelName);if(e&&this.oContext){return e.getProperty(this.oContext+"/showFavorites");}return false;};
N.prototype._clearDeletedItems=function(){this._aDeletedItems=[];};
N.prototype._addDeletedItem=function(e){this._aDeletedItems.push(e);};
N.prototype._getDeletedItems=function(e){return this._aDeletedItems;};
N.prototype._getItems=function(){var e=[];if(this.oContext&&this.oContext.getObject()){e=this.oContext.getObject().variants.filter(function(Q){if(!Q.hasOwnProperty("visible")){return true;}return Q.visible;});}return e;};
N.prototype._getItemByKey=function(e){var Q=null,U=this._getItems();U.some(function(W){if(W.key===e){Q=W;}return(Q!=null);});return Q;};
N.prototype._rebindControl=function(e){this.oVariantInvisibleText.unbindProperty("text");this.oVariantInvisibleText.bindProperty("text",{parts:[{path:'currentVariant',model:this._sModelName},{path:"modified",model:this._sModelName}],formatter:function(Q,U){if(U){Q=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT_MOD",[Q]);}else{Q=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT",[Q]);}}.bind(this)});this.oVariantText.unbindProperty("text");this.oVariantText.bindProperty("text",{path:'currentVariant',model:this._sModelName,formatter:function(Q){var U=this.getSelectedVariantText(Q);return U;}.bind(this)});this.oVariantText.unbindProperty("visible",{path:"modified",model:this._sModelName,formatter:function(Q){return(Q===null||Q===undefined)?false:Q;}});};
N.prototype.setModelName=function(e){if(this.getModelName()){this.oContext=null;}this.setProperty("modelName",e);this._sModelName=e;this._rebindControl();return this;};
N.prototype._setBindingContext=function(){var e,Q;if(!this.oContext){e=this.getModel(this._sModelName);if(e){Q=this._getLocalId();if(Q){this.oContext=new C(e,"/"+Q);this.setBindingContext(this.oContext,this._sModelName);if(!this.getModelName()&&e.registerToModel){e.registerToModel(this);}this._assignPopoverTitle();this._registerPropertyChanges(e);this.fireInitialized();}}}};
N.prototype._getLocalId=function(){if(this.getModelName()&&(this._sModelName!==N.MODEL_NAME)){return this.getId();}return t.getSelector(this,s.getAppComponentForControl(this)).id;};
N.prototype._setModel=function(){this._setBindingContext();};
N.prototype._registerPropertyChanges=function(e){var Q=new P(e,this.oContext+"/variantsEditable");Q.attachChange(function(U){if(U&&U.oSource&&U.oSource.oModel&&U.oSource.sPath){var W,X=U.oSource.oModel.getProperty(U.oSource.sPath);W=this.getModel(N.INNER_MODEL_NAME);if(W){W.setProperty("/editable",X);}}}.bind(this));};
N.prototype.handleOpenCloseVariantPopover=function(){if(!this.bPopoverOpen){this._openVariantList();}else if(this.oVariantPopOver&&this.oVariantPopOver.isOpen()){this.oVariantPopOver.close();}else if(this.getInErrorState()&&this.oErrorVariantPopOver&&this.oErrorVariantPopOver.isOpen()){this.oErrorVariantPopOver.close();}};
N.prototype.getFocusDomRef=function(){if(this.oVariantPopoverTrigger){return this.oVariantPopoverTrigger.getFocusDomRef();}};
N.prototype.onclick=function(e){if(this.oVariantPopoverTrigger&&!this.bPopoverOpen){this.oVariantPopoverTrigger.focus();}this.handleOpenCloseVariantPopover();};
N.prototype.onkeydown=function(e){if(e.which===K.F4||e.which===K.SPACE||e.altKey===true&&e.which===K.ARROW_UP||e.altKey===true&&e.which===K.ARROW_DOWN){this._openVariantList();}};
N.prototype.onAfterRendering=function(){this.oVariantText.$().off("mouseover").on("mouseover",function(){this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));this.oVariantText.$().off("mouseout").on("mouseout",function(){this.oVariantPopoverTrigger.removeStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));};
N.prototype._openInErrorState=function(){var Q;if(!this.oErrorVariantPopOver){Q=new V({fitContainer:true,alignItems:sap.m.FlexAlignItems.Center,items:[new b({size:"4rem",color:"lightgray",src:"sap-icon://message-error"}),new n({titleStyle:sap.ui.core.TitleLevel.H2,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT1")}),new T({textAlign:sap.ui.core.TextAlign.Center,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT2")})]});Q.addStyleClass("sapUiFlVarMngmtErrorPopover");this.oErrorVariantPopOver=new o(this.getId()+"-errorpopover",{title:{path:"/popoverTitle",model:N.INNER_MODEL_NAME},contentWidth:"400px",placement:y.Bottom,content:[new g(this.getId()+"-errorselpage",{showSubHeader:false,showNavButton:false,showHeader:false,content:[Q]})],afterOpen:function(){this.bPopoverOpen=true;}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oErrorVariantPopOver.attachBrowserEvent("keyup",function(e){if(e.which===32){this.oErrorVariantPopOver.close();}}.bind(this));}if(this.bPopoverOpen){return;}this.oErrorVariantPopOver.openBy(this.oVariantLayout);};
N.prototype._createVariantList=function(){if(this.oVariantPopOver){return;}this.oVariantManageBtn=new j(this.getId()+"-manage",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGE"),enabled:true,press:function(){this._openManagementDialog();}.bind(this),layoutData:new r({priority:w.Low})});this.oVariantSaveBtn=new j(this.getId()+"-mainsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),press:function(){this._handleVariantSave();}.bind(this),enabled:{path:"modified",model:this._sModelName,formatter:function(Q){return Q;}},layoutData:new r({priority:w.Low})});this.oVariantSaveAsBtn=new j(this.getId()+"-saveas",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVEAS"),press:function(){this._openSaveAsDialog();}.bind(this),layoutData:new r({priority:w.Low})});this._oVariantList=new p(this.getId()+"-list",{selectedKey:{path:"currentVariant",model:this._sModelName},itemPress:function(Q){var U=null;if(Q&&Q.getParameters()){var W=Q.getParameters().item;if(W){U=W.getKey();}}if(U){this.setCurrentVariantKey(U);this.fireEvent("select",{key:U});this.oVariantPopOver.close();}}.bind(this)});this._oVariantList.setNoDataText(this._oRb.getText("VARIANT_MANAGEMENT_NODATA"));var e=new sap.ui.core.Item({key:'{'+this._sModelName+">key}",text:'{'+this._sModelName+">title}"});this._oVariantList.bindAggregation("items",{path:"variants",model:this._sModelName,template:e});this._oSearchField=new S(this.getId()+"-search");this._oSearchField.attachLiveChange(function(Q){this._triggerSearch(Q,this._oVariantList);}.bind(this));this.oVariantSelectionPage=new g(this.getId()+"-selpage",{subHeader:new h({content:[this._oSearchField]}),content:[this._oVariantList],footer:new q({content:[new i(this.getId()+"-spacer"),this.oVariantSaveBtn,this.oVariantSaveAsBtn,this.oVariantManageBtn]}),showNavButton:false,showHeader:false,showFooter:{path:"/editable",model:N.INNER_MODEL_NAME}});this.oVariantPopOver=new o(this.getId()+"-popover",{title:{path:"/popoverTitle",model:N.INNER_MODEL_NAME},contentWidth:"400px",placement:y.Bottom,content:[this.oVariantSelectionPage],afterOpen:function(){this.bPopoverOpen=true;}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oVariantPopOver.addStyleClass("sapUiFlVarMngmtPopover");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oVariantPopOver.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oVariantPopOver);};
N.prototype._openVariantList=function(){var e;if(this.getInErrorState()){this._openInErrorState();return;}if(this.bPopoverOpen){return;}if(!this.oContext){return;}this._createVariantList();this._oSearchField.setValue("");this._oVariantList.getBinding("items").filter(this._getFilters());this.oVariantSelectionPage.setShowSubHeader(this._oVariantList.getItems().length>9?true:false);this.oVariantSaveBtn.setEnabled(false);this.oVariantSaveAsBtn.setEnabled(true);if(this.getModified()){e=this._getItemByKey(this.getCurrentVariantKey());if(e&&e.change){this.oVariantSaveBtn.setEnabled(true);}}this.oVariantPopOver.openBy(this.oVariantLayout);};
N.prototype._triggerSearch=function(e,Q){if(!e){return;}var U=e.getParameters();if(!U){return;}var W=U.newValue?U.newValue:"";var X=new F({path:"title",operator:sap.ui.model.FilterOperator.Contains,value1:W});Q.getBinding("items").filter(this._getFilters(X));};
N.prototype._createSaveAsDialog=function(){if(!this.oSaveAsDialog){this.oInputName=new m(this.getId()+"-name",{liveChange:function(U){this._checkVariantNameConstraints(this.oInputName,this.oSaveSave);}.bind(this)});var e=new L(this.getId()+"-namelabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_NAME"),required:true});e.setLabelFor(this.oInputName);this.oDefault=new k(this.getId()+"-default",{text:this._oRb.getText("VARIANT_MANAGEMENT_SETASDEFAULT"),visible:{path:"/showSetAsDefault",model:N.INNER_MODEL_NAME},width:"100%"});this.oExecuteOnSelect=new k(this.getId()+"-execute",{text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),visible:{path:"/showExecuteOnSelection",model:N.INNER_MODEL_NAME},width:"100%"});this.oInputManualKey=new m(this.getId()+"-key",{liveChange:function(U){this._checkVariantNameConstraints(this.oInputManualKey);}.bind(this)});this.oLabelKey=new L(this.getId()+"-keylabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_KEY"),required:true});this.oLabelKey.setLabelFor(this.oInputManualKey);this.oSaveSave=new j(this.getId()+"-variantsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_OK"),press:function(){this._bSaveCanceled=false;this._handleVariantSaveAs(this.oInputName.getValue());}.bind(this),enabled:true});var Q=new G({defaultSpan:"L12 M12 S12"});if(this.getShowSetAsDefault()){Q.addContent(this.oDefault);}if(this.getShowExecuteOnSelection()){Q.addContent(this.oExecuteOnSelect);}this.oSaveAsDialog=new l(this.getId()+"-savedialog",{title:this._oRb.getText("VARIANT_MANAGEMENT_SAVEDIALOG"),beginButton:this.oSaveSave,endButton:new j(this.getId()+"-variantcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._bSaveCanceled=true;this.oSaveAsDialog.close();}.bind(this)}),content:[e,this.oInputName,this.oLabelKey,this.oInputManualKey,Q],stretch:D.system.phone});this.oSaveAsDialog.addStyleClass("sapUiPopupWithPadding");this.oSaveAsDialog.addStyleClass("sapUiFlVarMngmtSaveDialog");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oSaveAsDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oSaveAsDialog);}};
N.prototype._openSaveAsDialog=function(){this._createSaveAsDialog();this.oInputName.setValue(this.getSelectedVariantText(this.getCurrentVariantKey()));this.oSaveSave.setEnabled(false);this.oInputName.setEnabled(true);this.oInputName.setValueState(E.None);this.oInputName.setValueStateText(null);this.oDefault.setSelected(false);this.oExecuteOnSelect.setSelected(false);if(this.oVariantPopOver){this.oVariantPopOver.close();}if(this.getManualVariantKey()){this.oInputManualKey.setVisible(true);this.oInputManualKey.setEnabled(true);this.oInputManualKey.setValueState(E.None);this.oInputManualKey.setValueStateText(null);this.oLabelKey.setVisible(true);}else{this.oInputManualKey.setVisible(false);this.oLabelKey.setVisible(false);}this.oSaveAsDialog.open();};
N.prototype._handleVariantSaveAs=function(e){var Q=null,U=e.trim(),W=this.oInputManualKey.getValue().trim();if(U==""){this.oInputName.setValueState(E.Error);this.oInputName.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}if(this.getManualVariantKey()){if(W==""){this.oInputManualKey.setValueState(E.Error);this.oInputManualKey.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}Q=W;}if(this.oSaveAsDialog){this.oSaveAsDialog.close();}if(this.oDefault.getSelected()){this.setDefaultVariantKey(Q);}this.setModified(false);this.fireSave({key:Q,name:U,overwrite:false,def:this.oDefault.getSelected(),execute:this.oExecuteOnSelect.getSelected()});};
N.prototype._handleVariantSave=function(){var e=this._getItemByKey(this.getCurrentVariantKey());var Q=false;if(this.getDefaultVariantKey()===e.key){Q=true;}if(this.oVariantPopOver){this.oVariantPopOver.close();}this.fireSave({name:e.title,overwrite:true,key:e.key,def:Q});this.setModified(false);};
N.prototype.openManagementDialog=function(e){if(e&&this.oManagementDialog){this.oManagementDialog.destroy();this.oManagementDialog=undefined;}this._openManagementDialog();};
N.prototype._triggerSearchInManageDialog=function(e,Q){if(!e){return;}var U=e.getParameters();if(!U){return;}var W=U.newValue?U.newValue:"";var X=[this._getVisibleFilter(),new F({filters:[new F({path:"title",operator:sap.ui.model.FilterOperator.Contains,value1:W}),new F({path:"author",operator:sap.ui.model.FilterOperator.Contains,value1:W})],and:false})];Q.getBinding("items").filter(X);this._bDeleteOccured=true;};
N.prototype._createManagementDialog=function(){if(!this.oManagementDialog){this.oManagementTable=new f(this.getId()+"-managementTable",{growing:true,columns:[new d({width:"3rem",visible:{path:"showFavorites",model:this._sModelName}}),new d({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")}),width:"14rem"}),new d({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_DEFAULT")}),width:"4rem",demandPopin:true,popinDisplay:z.Inline,minScreenWidth:A.Tablet,visible:{path:"/showSetAsDefault",model:N.INNER_MODEL_NAME}}),new d({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT")}),width:"6rem",hAlign:M.Center,demandPopin:true,popinDisplay:z.Inline,minScreenWidth:"800px",visible:{path:"/showExecuteOnSelection",model:N.INNER_MODEL_NAME}}),new d({header:new T({text:this._oRb.getText("VARIANT_MANAGEMENT_AUTHOR")}),width:"8rem",demandPopin:true,popinDisplay:z.Inline,minScreenWidth:"900px"}),new d({width:"2rem",hAlign:M.Center}),new d({visible:false})]});this.oManagementSave=new j(this.getId()+"-managementsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_OK"),enabled:true,press:function(){this._handleManageSavePressed();}.bind(this)});this.oManagementCancel=new j(this.getId()+"-managementcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this.oManagementDialog.close();this._handleManageCancelPressed();}.bind(this)});this.oManagementDialog=new l(this.getId()+"-managementdialog",{resizable:true,draggable:true,customHeader:new B(this.getId()+"-managementHeader",{contentMiddle:[new T(this.getId()+"-managementHeaderText",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGEDIALOG")})]}),beginButton:this.oManagementSave,endButton:this.oManagementCancel,content:[this.oManagementTable],stretch:D.system.phone});this.oManagementDialog.isPopupAdaptationAllowed=function(){return false;};this._oSearchFieldOnMgmtDialog=new S();this._oSearchFieldOnMgmtDialog.attachLiveChange(function(Q){this._triggerSearchInManageDialog(Q,this.oManagementTable);}.bind(this));var e=new B(this.getId()+"-mgmHeaderSearch",{contentRight:[this._oSearchFieldOnMgmtDialog]});this.oManagementDialog.setSubHeader(e);if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oManagementDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oManagementDialog);this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});this._bDeleteOccured=false;}};
N.prototype._setFavoriteIcon=function(e,Q){if(e){e.setSrc(Q?"sap-icon://favorite":"sap-icon://unfavorite");e.setTooltip(this._oRb.getText(Q?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP"));}};
N.prototype._templateFactoryManagementDialog=function(e,Q){var U=null,W,X,Y,Z=Q.getObject();if(!Z){return undefined;}var $=function(g1){this._checkVariantNameConstraints(g1.oSource,this.oManagementSave,g1.oSource.getBindingContext(this._sModelName).getObject().key);}.bind(this);var _=function(g1){this._handleManageTitleChanged(g1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var a1=function(g1){if(g1.getParameters().selected===true){this._handleManageDefaultVariantChange(g1.oSource,g1.oSource.getBindingContext(this._sModelName).getObject());}}.bind(this);var b1=function(g1){this._handleManageExecuteOnSelectionChanged(g1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var c1=function(g1){this._handleManageDeletePressed(g1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var d1=function(g1){this._handleManageFavoriteChanged(g1.oSource,g1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);if(Z.rename){Y=new m({liveChange:$,change:_,value:'{'+this._sModelName+">title}"});}else{Y=new O({title:'{'+this._sModelName+">title}"});if(U){Y.setTooltip(U);}}W=new j({icon:"sap-icon://sys-cancel",enabled:true,type:x.Transparent,press:c1,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_DELETE"),visible:Z.remove});this._assignColumnInfoForDeleteButton(W);X=this.oContext.getPath();var e1=new b({src:{path:"favorite",model:this._sModelName,formatter:function(g1){return g1?"sap-icon://favorite":"sap-icon://unfavorite";}},tooltip:{path:'favorite',model:this._sModelName,formatter:function(g1){return this._oRb.getText(g1?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP");}.bind(this)},press:d1});e1.addStyleClass("sapUiFlVarMngmtFavColor");var f1=new c({cells:[e1,Y,new R({groupName:this.getId(),select:a1,selected:{path:X+"/defaultVariant",model:this._sModelName,formatter:function(g1){return(Z.key===g1)?true:false;}}}),new k({select:b1,selected:'{'+this._sModelName+">executeOnSelect}"}),new T({text:'{'+this._sModelName+">author}",textAlign:"Begin"}),W,new T({text:'{'+this._sModelName+">key}"})]});return f1;};
N.prototype._openManagementDialog=function(){this._createManagementDialog();if(this.oVariantPopOver){this.oVariantPopOver.close();}this._clearDeletedItems();this.oManagementSave.setEnabled(false);this._oSearchFieldOnMgmtDialog.setValue("");if(this._bDeleteOccured){this._bDeleteOccured=false;this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});}this.oManagementDialog.open();};
N.prototype._assignColumnInfoForDeleteButton=function(e){if(!this._oInvisibleDeleteColumnName){this._oInvisibleDeleteColumnName=new I({text:this._oRb.getText("VARIANT_MANAGEMENT_ACTION_COLUMN")});this.oManagementDialog.addContent(this._oInvisibleDeleteColumnName);}if(this._oInvisibleDeleteColumnName){e.addAriaLabelledBy(this._oInvisibleDeleteColumnName);}};
N.prototype._handleManageDefaultVariantChange=function(e,Q){var U=Q.key;if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}if(this.getShowFavorites()&&!Q.favorite&&e){Q.favorite=!Q.favorite;this._setFavoriteIcon(e.getParent().getCells()[N.COLUMN_FAV_IDX],Q.favorite);}this.setDefaultVariantKey(U);};
N.prototype._handleManageCancelPressed=function(){var e,Q;this._getDeletedItems().forEach(function(U){U.visible=true;});this._getItems().forEach(function(U){U.title=U.originalTitle;U.favorite=U.originalFavorite;U.executeOnSelection=U.originalExecuteOnSelection;});e=this.getOriginalDefaultVariantKey();if(e!==this.getDefaultVariantKey()){this.setDefaultVariantKey(e);}Q=this.getModel(this._sModelName);if(Q){Q.checkUpdate();}};
N.prototype._handleManageFavoriteChanged=function(e,Q){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}if((this.getDefaultVariantKey()===Q.key)&&Q.favorite){return;}Q.favorite=!Q.favorite;this._setFavoriteIcon(e,Q.favorite);};
N.prototype._handleManageDeletePressed=function(e){var Q,U=e.key;if(this.oManagementTable.getItems().length===1){return;}if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}e.visible=false;this._addDeletedItem(e);if((U===this.getDefaultVariantKey())){this.setDefaultVariantKey(this.getStandardVariantKey());}Q=this.getModel(this._sModelName);if(Q){Q.checkUpdate();}this.oManagementCancel.focus();};
N.prototype._handleManageExecuteOnSelectionChanged=function(e){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}};
N.prototype._handleManageTitleChanged=function(e){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}};
N.prototype._handleManageSavePressed=function(){this._getDeletedItems().some(function(e){if(e.key===this.getCurrentVariantKey()){var Q=this.getStandardVariantKey();this.setModified(false);this.setCurrentVariantKey(Q);this.fireEvent("select",{key:Q});return true;}return false;}.bind(this));this.fireManage();this.oManagementDialog.close();};
N.prototype._anyInErrorState=function(e){var Q,U,W=false;if(e){Q=e.getItems();Q.some(function(X){U=X.getCells()[N.COLUMN_NAME_IDX];if(U&&U.getValueState&&(U.getValueState()===E.Error)){W=true;}return W;});}return W;};
N.prototype._getFilters=function(e){var Q=[];if(e){Q.push(e);}Q.push(this._getVisibleFilter());if(this.getShowFavorites()){Q.push(this._getFilterFavorites());}return Q;};
N.prototype._getVisibleFilter=function(){return new F({path:"visible",operator:sap.ui.model.FilterOperator.EQ,value1:true});};
N.prototype._getFilterFavorites=function(){return new F({path:"favorite",operator:sap.ui.model.FilterOperator.EQ,value1:true});};
N.prototype._checkVariantNameConstraints=function(e,Q,U){if(!e){return;}var W=e.getValue();W=W.trim();if(!this._checkIsDuplicate(W,U)){if(W===""){e.setValueState(E.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));}else if(W.indexOf('{')>-1){e.setValueState(E.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_NOT_ALLOWED_CHAR",["{"]));}else if(W.length>N.MAX_NAME_LEN){e.setValueState(E.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_MAX_LEN",[N.MAX_NAME_LEN]));}else{e.setValueState(E.None);e.setValueStateText(null);}}else{e.setValueState(E.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_DUPLICATE"));}if(Q){if(e.getValueState()===E.Error){Q.setEnabled(false);}else{Q.setEnabled(true);}}};
N.prototype._checkIsDuplicate=function(e,Q){var U=false,W=this._getItems(),X=e.toLowerCase();W.some(function(Y){if(Y.title.toLowerCase()===X){if(Q&&(Q===Y.key)){return false;}U=true;}return U;});return U;};
N.prototype.exit=function(){var e;if(this.oDefault&&!this.oDefault._bIsBeingDestroyed){this.oDefault.destroy();}this.oDefault=undefined;if(this.oExecuteOnSelect&&!this.oExecuteOnSelect._bIsBeingDestroyed){this.oExecuteOnSelect.destroy();}this.oExecuteOnSelect=undefined;this._oRb=undefined;this.oContext=undefined;this._oVariantList=undefined;this.oVariantSelectionPage=undefined;this.oVariantLayout=undefined;this.oVariantText=undefined;this.oVariantPopoverTrigger=undefined;this.oVariantInvisibleText=undefined;this._oSearchField=undefined;this._oSearchFieldOnMgmtDialog=undefined;e=this.getModel(N.INNER_MODEL_NAME);if(e){e.destroy();}};
return N;},true);
sap.ui.predefine('sap/ui/fl/variants/VariantModel',["sap/ui/thirdparty/jquery","sap/ui/model/json/JSONModel","sap/ui/fl/Utils","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Change","sap/ui/fl/changeHandler/Base","sap/ui/core/BusyIndicator","sap/ui/fl/variants/util/VariantUtil","sap/base/util/merge"],function(q,J,U,a,C,B,b,V,f){"use strict";
var c=J.extend("sap.ui.fl.variants.VariantModel",{constructor:function(d,F,o,O){this.pSequentialImportCompleted=Promise.resolve();J.apply(this,arguments);this.bObserve=O;this.oFlexController=F;this.oComponent=o;this.oVariantController=undefined;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");if(F&&F._oChangePersistence){this.oVariantController=F._oChangePersistence._oVariantController;this.sVariantTechnicalParameterName=this.oVariantController.sVariantTechnicalParameterName;}V.initializeHashRegister.call(this);if(d&&typeof d=="object"){Object.keys(d).forEach(function(k){d[k].variants.forEach(function(v){if(!d[k].currentVariant&&(v.key===d[k].defaultVariant)){d[k].currentVariant=v.key;}v.originalTitle=v.title;v.originalFavorite=v.favorite;v.originalVisible=v.visible;});d[k].originalCurrentVariant=d[k].currentVariant;d[k].originalDefaultVariant=d[k].defaultVariant;});this.setData(d);}}});
c.prototype.updateCurrentVariant=function(v,n,A){var s,m;var d;s=this.oData[v].originalCurrentVariant;if(this.oData[v].modified){d=this.oVariantController.getVariantChanges(v,s,true);this._removeDirtyChanges(d,v,s,A);this.oData[v].modified=false;}var p={variantManagementReference:v,currentVariantReference:s,newVariantReference:n,component:A||(Array.isArray(this._oEmbeddedComponents)?this._oEmbeddedComponents.concat([this.oComponent]):this.oComponent)};m=this.oFlexController._oChangePersistence.loadSwitchChangesMapForComponent(p);return Promise.resolve().then(this.oFlexController.revertChangesOnControl.bind(this.oFlexController,m.aRevert,m.component)).then(this.oFlexController.applyVariantChanges.bind(this.oFlexController,m.aNew,m.component)).then(function(){this.oData[v].originalCurrentVariant=n;this.oData[v].currentVariant=n;if(this.oData[v].updateVariantInURL){this._updateVariantInURL(v,n);this.oVariantController.updateCurrentVariantInMap(v,n);}this.checkUpdate();}.bind(this));};
c.prototype._updateVariantInURL=function(v,n){var t=this.getVariantIndexInURL(v);if(!t.parameters){return;}var p=Array.isArray(t.parameters[this.sVariantTechnicalParameterName])?t.parameters[this.sVariantTechnicalParameterName].slice(0):[];var i=t.index;if(n===this.oData[v].defaultVariant){if(i===-1){return;}p.splice(i,1);}else{i===-1?p.push(n):(p[i]=n);}this.updateHasherEntry({parameters:p,updateURL:!this._bAdaptationMode});};
c.prototype.updateHasherEntry=function(){V.updateHasherEntry.apply(this,arguments);};
c.prototype.getVariantIndexInURL=function(v){var h=U.getParsedURLHash().params;var p=-1;if(h){if(this._bAdaptationMode){h={};h[this.sVariantTechnicalParameterName]=V.getCurrentHashParamsFromRegister.call(this);}if(!q.isEmptyObject(h)&&Array.isArray(h[this.sVariantTechnicalParameterName])){h[this.sVariantTechnicalParameterName]=h[this.sVariantTechnicalParameterName].reduce(function(d,P,i){var s=decodeURIComponent(P);if(p===-1&&!!this.oVariantController.getVariant(v,s)){p=i;}return d.concat(s);}.bind(this),[]);}}return{parameters:h,index:p};};
c.prototype.getCurrentVariantReference=function(v){return this.oData[v].currentVariant;};
c.prototype.getVariantManagementReference=function(v){var s="";var i=-1;Object.keys(this.oData).some(function(k){return this.oData[k].variants.some(function(o,d){if(o.key===v){s=k;i=d;return true;}});}.bind(this));return{variantManagementReference:s,variantIndex:i};};
c.prototype.getVariant=function(v,s){return this.oVariantController.getVariant(s?s:this.getVariantManagementReference(v).variantManagementReference,v);};
c.prototype.getVariantProperty=function(v,p){return this.getVariant(v).content.content[p];};
c.prototype._addChange=function(o){var v=o.getVariantReference();var s=this.getVariantManagementReference(v).variantManagementReference;this.oData[s].modified=!!this.oData[s].variantsEditable;this.checkUpdate(true);return this.oVariantController.addChangeToVariant(o,s,v);};
c.prototype._removeChange=function(o){var v=o.getVariantReference();var s=this.getVariantManagementReference(v).variantManagementReference;return this.oVariantController.removeChangeFromVariant(o,s,v);};
c.prototype._removeDirtyChanges=function(v,s,d,A){var e=v.map(function(o){return o.getDefinition().fileName;});var F;var D=this.oFlexController._oChangePersistence.getDirtyChanges().filter(function(o){F=e.indexOf(o.getDefinition().fileName)>-1;if(F){this.oVariantController.removeChangeFromVariant(o,s,d);}return F;}.bind(this));D.forEach(function(o){this.oFlexController.deleteChange(o,A);}.bind(this));return this.oFlexController.revertChangesOnControl(D.reverse(),A);};
c.prototype._getVariantTitleCount=function(n,v){var d=this.getData();return d[v].variants.reduce(function(i,o){if(n.toLowerCase()===o.title.toLowerCase()&&o.visible){i++;}return i;},0);};
c.prototype._duplicateVariant=function(p){var n=p.newVariantReference,s=p.sourceVariantReference,v=p.variantManagementReference,S=this.getVariant(s);var d=this.oVariantController.getVariantChanges(v,s,true).map(function(g){return g.getDefinition();});var D={content:{},controlChanges:d,variantChanges:{}};var i=U.compareAgainstCurrentLayer(S.content.layer);Object.keys(S.content).forEach(function(k){if(k==="fileName"){D.content[k]=n;}else if(k==="variantReference"){if(i===0){D.content[k]=S.content["variantReference"];}else if(i===-1){D.content[k]=s;}}else if(k==="content"){D.content[k]=JSON.parse(JSON.stringify(S.content[k]));D.content.content.title=p.title;}else{D.content[k]=S.content[k];}});D.content["layer"]=p.layer;var d=D.controlChanges.slice();var o={};var e;D.controlChanges=d.reduce(function(g,h){if(U.compareAgainstCurrentLayer(h.layer)===0){o=f({},h);o.variantReference=D.content.fileName;if(!o.support){o.support={};}o.support.sourceChangeFileName=h.fileName;o.packageName="$TMP";e=C.createInitialFileContent(o);g.push(new C(e));}return g;},[]);return D;};
c.prototype._copyVariant=function(p){var d=this._duplicateVariant(p);var v={key:d.content.fileName,layer:p.layer,title:d.content.content.title,originalTitle:d.content.content.title,favorite:true,originalFavorite:true,rename:true,change:true,remove:true,visible:true,originalVisible:true};var o=this.oFlexController.createVariant(d,p.appComponent);var e=[];[o].concat(o.getControlChanges()).forEach(function(g){e.push(this.oFlexController._oChangePersistence.addDirtyChange(g));}.bind(this));var i=this.oVariantController.addVariantToVariantManagement(o.getDefinitionWithChanges(),p.variantManagementReference);this.oData[p.variantManagementReference].variants.splice(i,0,v);return this.updateCurrentVariant(p.variantManagementReference,o.getId(),p.appComponent).then(function(){return e;});};
c.prototype.removeVariant=function(p){var d=this.oFlexController._oChangePersistence.getDirtyChanges().filter(function(o){return(o.getVariantReference&&o.getVariantReference()===p.variant.getId())||o.getId()===p.variant.getId();});return this.updateCurrentVariant(p.variantManagementReference,p.sourceVariantReference,p.component).then(function(){var i=this.oVariantController.removeVariantFromVariantManagement(p.variant,p.variantManagementReference);this.oData[p.variantManagementReference].variants.splice(i,1);this.checkUpdate();d.forEach(function(o){this.oFlexController._oChangePersistence.deleteChange(o);}.bind(this));}.bind(this));};
c.prototype.collectModelChanges=function(v,l){var d=this.getData()[v];var m=d.variants;var e=[];var p={};m.forEach(function(o){if(o.originalTitle!==o.title){p={variantReference:o.key,changeType:"setTitle",title:o.title,originalTitle:o.originalTitle,layer:l};e.push(p);}if(o.originalFavorite!==o.favorite){p={variantReference:o.key,changeType:"setFavorite",favorite:o.favorite,originalFavorite:o.originalFavorite,layer:l};e.push(p);}if(!o.visible&&o.originalVisible){p={variantReference:o.key,changeType:"setVisible",visible:false,layer:l};e.push(p);}});if(d.originalDefaultVariant!==d.defaultVariant){p={variantManagementReference:v,changeType:"setDefault",defaultVariant:d.defaultVariant,originalDefaultVariant:d.originalDefaultVariant,layer:l};e.push(p);}return e;};
c.prototype.manageVariants=function(v,s,l){return new Promise(function(r){v.attachEventOnce("manage",{resolve:r,variantManagementReference:s,layer:l},this.fnManageClickRta,this);v.openManagementDialog(true);}.bind(this));};
c.prototype.setVariantProperties=function(v,p,A){var i=-1;var o;var d=null;var D=this.getData();if(p.variantReference){i=this.getVariantManagementReference(p.variantReference).variantIndex;o=D[v].variants[i];}var n={};var m={};switch(p.changeType){case"setTitle":m.title=p.title;o.title=p.title;o.originalTitle=o.title;break;case"setFavorite":m.favorite=p.favorite;o.favorite=p.favorite;o.originalFavorite=o.favorite;break;case"setVisible":m.visible=p.visible;m.createdByReset=false;o.visible=p.visible;o.originalVisible=o.visible;break;case"setDefault":m.defaultVariant=p.defaultVariant;D[v].defaultVariant=p.defaultVariant;D[v].originalDefaultVariant=D[v].defaultVariant;var h=V.getCurrentHashParamsFromRegister.call(this);if(h){if(D[v].defaultVariant!==D[v].currentVariant&&h.indexOf(D[v].currentVariant)===-1){this.updateHasherEntry({parameters:h.concat(D[v].currentVariant),updateURL:!this._bAdaptationMode});}else if(D[v].defaultVariant===D[v].currentVariant&&h.indexOf(D[v].currentVariant)>-1){h.splice(h.indexOf(D[v].currentVariant),1);this.updateHasherEntry({parameters:h,updateURL:!this._bAdaptationMode});}}break;default:break;}if(i>-1){var s=this.oVariantController._setVariantData(m,v,i);D[v].variants.splice(i,1);D[v].variants.splice(s,0,o);}else if(this.oVariantController._mVariantManagement[v]){this.oVariantController._mVariantManagement[v].defaultVariant=p.defaultVariant;}if(A===true){n.changeType=p.changeType;n.layer=p.layer;if(p.changeType==="setDefault"){n.fileType="ctrl_variant_management_change";n.selector={id:v};}else{if(p.changeType==="setTitle"){B.setTextInChange(n,"title",p.title,"XFLD");}n.fileType="ctrl_variant_change";n.selector={id:p.variantReference};}d=this.oFlexController.createBaseChange(n,p.appComponent);d.setContent(m);this.oVariantController._updateChangesForVariantManagementInMap(d.getDefinition(),v,true);this.oFlexController._oChangePersistence.addDirtyChange(d);}else{if(p.change){this.oVariantController._updateChangesForVariantManagementInMap(p.change.getDefinition(),v,false);this.oFlexController._oChangePersistence.deleteChange(p.change);}}this.setData(D);this.checkUpdate(true);return d;};
c.prototype._ensureStandardVariantExists=function(v){var d=this.getData();if(!d[v]){d[v]={currentVariant:v,originalCurrentVariant:v,defaultVariant:v,originalDefaultVariant:v,variants:[{key:v,title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),originalTitle:this._oResourceBundle.getText("STANDARD_VARIANT_ORIGINAL_TITLE"),favorite:true,originalFavorite:true,visible:true,originalVisible:true}]};this.setData(d);if(this.oVariantController){var o={changes:{variantSection:{}}};var D={defaultVariant:v,variantManagementChanges:{},variants:[{content:{fileName:v,fileType:"ctrl_variant",variantManagementReference:v,variantReference:"",content:{title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE")}},controlChanges:[],variantChanges:{}}]};o.changes.variantSection[v]=D;this.oVariantController._setChangeFileContent(o,{});}}};
c.prototype._setModelPropertiesForControl=function(v,A,o){var r=function(d,v,A){if((d.layer===U.getCurrentLayer(!A))&&(d.key!==v)){return true;}else{return false;}};this.oData[v].modified=false;this.oData[v].showFavorites=true;if(this._bAdaptationMode!==A){var p={};if(A){p={parameters:[],updateURL:true,ignoreRegisterUpdate:true};}else if(this._bAdaptationMode){p={parameters:V.getCurrentHashParamsFromRegister.call(this),updateURL:true,ignoreRegisterUpdate:true};}this.updateHasherEntry(p);this._bAdaptationMode=A;}if(!(typeof this.fnManageClick==="function"&&typeof this.fnManageClickRta==="function")){this._initializeManageVariantsEvents();}o.detachManage(this.fnManageClick,this);if(A){this.oData[v].variantsEditable=false;this.oData[v].variants.forEach(function(d){d.rename=true;d.change=true;d.remove=r(d,v,A);});}else{if(this.oData[v]._isEditable){o.attachManage({variantManagementReference:v},this.fnManageClick,this);this.oData[v].variantsEditable=true;this.oData[v].variants.forEach(function(d){d.remove=r(d,v,A);if(d.layer===U.getCurrentLayer(true)){d.rename=true;d.change=true;}else{d.rename=false;d.change=false;}});}else{this.oData[v].variantsEditable=false;this.oData[v].variants.forEach(function(d){d.remove=false;d.rename=false;d.change=false;});}}};
c.prototype._initializeManageVariantsEvents=function(){this.fnManageClickRta=function(e,d){var g=this.collectModelChanges(d.variantManagementReference,d.layer);d.resolve(g);};this.fnManageClick=function(e,d){if(!this.oFlexController||!this.oVariantController){return;}var g=this.collectModelChanges(d.variantManagementReference,U.getCurrentLayer(true));g.forEach(function(o){o.appComponent=this.oAppComponent;this.setVariantProperties(d.variantManagementReference,o,true);}.bind(this));this.oFlexController._oChangePersistence.saveDirtyChanges();};};
c.prototype._handleCurrentVariantChange=function(e,m){var p=e.getSource();var v=p.getContext().getPath().replace(/^\//,'');if(this.oData[v].currentVariant!==this.oData[v].originalCurrentVariant){this.updateCurrentVariant(v,p.getValue(),U.getAppComponentForControl(m.control));}};
c.prototype._handleSave=function(e){var v=e.getSource();var s=e.getParameter("def");var A=U.getAppComponentForControl(v);var d=this._getLocalId(v.getId(),A);var S=this.getCurrentVariantReference(d);var g=this.oVariantController.getVariantChanges(d,S,true);if(e.getParameter("overwrite")){var h=this.oFlexController._oChangePersistence.getDirtyChanges();var i=g.map(function(o){return o.getDefinition().fileName;});var D=h.reduce(function(r,o){if(i.indexOf(o.getId())>-1){return r.concat(o);}else{return r;}},[]);this.oFlexController._oChangePersistence.saveSequenceOfDirtyChanges(D);this.oData[d].modified=false;this.checkUpdate(true);return Promise.resolve();}else{var n=U.createDefaultFileName("Copy");var p={variantManagementReference:d,appComponent:A,layer:U.getCurrentLayer(true),title:e.getParameter("name"),sourceVariantReference:S,newVariantReference:n};return this._copyVariant(p).then(function(j){if(s){var P={changeType:"setDefault",defaultVariant:n,originalDefaultVariant:this.oData[d].defaultVariant,appComponent:A,layer:U.getCurrentLayer(true),variantManagementReference:d};var o=this.setVariantProperties(d,P,true);j.push(o);}this.oData[d].modified=false;this.checkUpdate(true);return this.oFlexController._oChangePersistence.saveSequenceOfDirtyChanges(j);}.bind(this)).then(this._removeDirtyChanges.bind(this,g,d,S,p.appComponent));}};
c.prototype._getLocalId=function(i,A){return a.getSelector(i,A).id;};
c.prototype.switchToDefaultForVariantManagement=function(v){b.show(200);this.updateCurrentVariant(v,this.oData[v].defaultVariant).then(function(){b.hide();});};
c.prototype.switchToDefaultForVariant=function(v){Object.keys(this.oData).forEach(function(s){if(!v||this.oData[s].currentVariant===v){this.switchToDefaultForVariantManagement.call(this,s);}}.bind(this));};
c.prototype.registerToModel=function(v){var s=this._getLocalId(v,U.getAppComponentForControl(v));this._ensureStandardVariantExists(s);if(v){this.oData[s]._isEditable=v.getEditable();v.getTitle().getBinding("text").attachEvent("change",{control:v},this._handleCurrentVariantChange,this);this._setModelPropertiesForControl(s,false,v);v.attachSave(this._handleSave,this);var u=v.getUpdateVariantInURL();this.oData[s].updateVariantInURL=u;V.attachHashHandlers.call(this,s,!!u);}};
c.prototype.addEmbeddedComponent=function(o){if(!Array.isArray(this._oEmbeddedComponents)){this._oEmbeddedComponents=[];}this._oEmbeddedComponents.push(o);};
c.prototype.getCurrentControlVariantIds=function(){return Object.keys(this.oData||{}).reduce(function(d,v){return d.concat([this.oData[v].currentVariant]);}.bind(this),[]);};
return c;},true);
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/fl/Cache',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/variants/util/VariantUtil","sap/base/strings/formatMessage","sap/base/Log","sap/ui/thirdparty/jquery","sap/base/util/LoaderExtensions"],function(L,U,V,f,a,q,b){"use strict";var C=function(){};C._isOn=true;C._entries={};C._switches={};C._oFlexDataPromise=undefined;
C.getSwitches=function(){return C._switches;};
C.isActive=function(){return C._isOn;};
C.setActive=function(A){C._isOn=A;};
C.getFlexDataPromise=function(){return C._oFlexDataPromise;};
C.getEntries=function(){return C._entries;};
C.clearEntries=function(){C._entries={};};
C.getEntry=function(c,A){if(!C._entries[c]){C._entries[c]={};}if(!C._entries[c][A]){C._entries[c][A]={file:{changes:{changes:[],contexts:[],variantSection:{},ui2personalization:{}}}};}return C._entries[c][A];};
C.clearEntry=function(c,A){C.getEntry(c,A);C._entries[c][A]={};};
C._deleteEntry=function(c,A){if(C._entries[c]&&C._entries[c][A]){delete C._entries[c][A];}if(q.isEmptyObject(C._entries[c])){delete C._entries[c];}};
C.getChangesFillingCache=function(l,c,p,i){var s=c.name;var A=c.appVersion||U.DEFAULT_APP_VERSION;var o=C.getEntry(s,A);if(o.promise&&!i){return o.promise;}var d=C._getChangesFromBundle(p);if(p&&p.cacheKey==="<NO CHANGES>"){var e=d.then(function(h){o.file={changes:{changes:h,contexts:[],variantSection:{},ui2personalization:{}},componentClassName:s};return o.file;});o.promise=e;return e;}var F=l.loadChanges(c,p);var g=F.then(function(r){return r;},function(E){var m="";if(E.messages&&E.messages.length!=0&&E.messages[0].text){m=E.messages[0].text;}var h=f("Loading changes for {0} failed!\nError code: {1}\nMessage: {2}",c.name,E.code,m);a.error(h);return Promise.resolve({changes:{changes:[],contexts:[],variantSection:{},ui2personalization:{}}});});var e=Promise.all([d,g]).then(function(v){var h=v[0];var m=v[1];if(m&&m.changes){if(m.changes.settings&&m.changes.settings.switchedOnBusinessFunctions){m.changes.settings.switchedOnBusinessFunctions.forEach(function(k){C._switches[k]=true;});}var j=h.concat(m.changes.changes);m.changes.changes=C._removeDuplicates(j);}o.file=m;return o.file;},function(h){C._deleteEntry(s,A);throw h;});o.promise=e;C._oFlexDataPromise=F;return e;};
C._getChangesFromBundle=function(p){var c=p&&p.appName;if(!c){return Promise.resolve([]);}var r=p.appName.replace(/\./g,"/")+"/changes/changes-bundle.json";var d=!!sap.ui.loader._.getModuleState(r);if(d){return Promise.resolve(b.loadResource(r));}else{var o=sap.ui.getCore().getConfiguration();if(o.getDebug()||o.isFlexBundleRequestForced()){try{return Promise.resolve(b.loadResource(r));}catch(e){a.warning("flexibility did not find a changesBundle.json  for the application");}}return Promise.resolve([]);}};
C._removeDuplicates=function(c){var d=[];c=c.filter(function(o){var F=o.fileName;var e=d.indexOf(F)!==-1;if(e){return false;}d.push(F);return true;});return c;};
C.NOTAG="<NoTag>";
C._concatControlVariantIdWithCacheKey=function(c,s){if(!s){return c;}return c===C.NOTAG?c.replace(/>$/,''.concat('-',s,'>')):c.concat('-',s);};
C.getCacheKey=function(c,A){if(!c||!c.name||!c.appVersion||!A){a.warning("Not all parameters were passed to determine a flexibility cache key.");return Promise.resolve(C.NOTAG);}return this.getChangesFillingCache(L.createConnector(),c).then(function(w){if(w&&w.etag){return w.etag;}else{return C.NOTAG;}}).then(function(s){var v=A.getModel("$FlexVariants");var d=v?v.getCurrentControlVariantIds():[];return C._concatControlVariantIdWithCacheKey(s,d.join("-"));});};
C._getChangeArray=function(c){var s=c.name;var A=c.appVersion||U.DEFAULT_APP_VERSION;var e=C.getEntry(s,A);return e.file.changes.changes;};
C.addChange=function(c,o){var d=C._getChangeArray(c);if(!d){return;}d.push(o);};
C.updateChange=function(c,o){var d=C._getChangeArray(c);if(!d){return;}for(var i=0;i<d.length;i++){if(d[i].fileName===o.fileName){d.splice(i,1,o);break;}}};
C.deleteChange=function(c,o){var d=C._getChangeArray(c);if(!d){return;}for(var i=0;i<d.length;i++){if(d[i].fileName===o.fileName){d.splice(i,1);break;}}};
C.getPersonalization=function(r,A,c,i){var m={name:r,appVersion:A};return this.getChangesFillingCache(L.createConnector(),m).then(function(R){if(!R||!R.changes||!R.changes.ui2personalization||!R.changes.ui2personalization[c]){return i?undefined:[];}if(!i){return R.changes.ui2personalization[c]||[];}return R.changes.ui2personalization[c].filter(function(e){return e.itemName===i;})[0];});};
C.setPersonalization=function(p){if(!p||!p.reference||!p.containerKey||!p.itemName||!p.content){return Promise.reject("not all mandatory properties were provided for the storage of the personalization");}return L.createConnector().send("/sap/bc/lrep/ui2personalization/","PUT",p,{}).then(this._addPersonalizationToEntries.bind(this,p));};
C._addPersonalizationToEntries=function(p){Object.keys(this._entries[p.reference]).forEach(function(v){var e=this._entries[p.reference][v];var P=e.file.changes.ui2personalization;if(!P[p.containerKey]){P[p.containerKey]=[];}P[p.containerKey].push(p);}.bind(this));};
C.deletePersonalization=function(r,c,i){if(!r||!c||!i){return Promise.reject("not all mandatory properties were provided for the storage of the personalization");}var u="/sap/bc/lrep/ui2personalization/?reference=";u+=r+"&containerkey="+c+"&itemname="+i;return L.createConnector().send(u,"DELETE",{}).then(this._removePersonalizationFromEntries.bind(this,r,c,i));};
C._removePersonalizationFromEntries=function(r,c,i){var d=[];Object.keys(this._entries[r]).forEach(function(A){var g=this.getPersonalization(r,A,c);var G=this.getPersonalization(r,A,c,i);var D=Promise.all([g,G]).then(function(p){var I=p[0];var t=p[1];var n=I.indexOf(t);I.splice(n,1);});d.push(D);}.bind(this));return Promise.all(d);};
return C;},true);
sap.ui.predefine('sap/ui/fl/Change',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/fl/Utils","sap/ui/fl/registry/Settings"],function(q,M,U,S){"use strict";
var C=M.extend("sap.ui.fl.Change",{
constructor:function(f){M.apply(this);if(!q.isPlainObject(f)){U.log.error("Constructor : sap.ui.fl.Change : oFile is not defined");}this._oDefinition=f;this._sRequest='';this._bUserDependent=(f.layer==="USER");this._vRevertData=null;this._aUndoOperations=null;this.setState(C.states.NEW);this.setModuleName(f.moduleName);},
metadata:{properties:{state:{type:"string"},moduleName:{type:"string"}}}
});
C.states={NEW:"NEW",PERSISTED:"NONE",DELETED:"DELETE",DIRTY:"UPDATE"};
C.prototype.setState=function(s){if(this._isValidState(s)){this.setProperty("state",s);}return this;};
C.prototype._isValidState=function(s){var b=false;Object.keys(C.states).some(function(k){if(C.states[k]===s){b=true;}return b;});if(!b){return false;}if((this.getState()===C.states.NEW)&&(s===C.states.DIRTY)){return false;}return true;};
C.prototype.isValid=function(){var i=true;if(typeof(this._oDefinition)!=="object"){i=false;}if(!this._oDefinition.fileType){i=false;}if(!this._oDefinition.fileName){i=false;}if(!this._oDefinition.changeType){i=false;}if(!this._oDefinition.layer){i=false;}if(!this._oDefinition.originalLanguage){i=false;}return i;};
C.prototype.isVariant=function(){return this._oDefinition.fileType==="variant";};
C.prototype.getChangeType=function(){if(this._oDefinition){return this._oDefinition.changeType;}};
C.prototype.getFileType=function(){if(this._oDefinition){return this._oDefinition.fileType;}};
C.prototype.getOriginalLanguage=function(){if(this._oDefinition&&this._oDefinition.originalLanguage){return this._oDefinition.originalLanguage;}return"";};
C.prototype.getContext=function(){if(this._oDefinition&&this._oDefinition.context){return this._oDefinition.context;}return"";};
C.prototype.getPackage=function(){return this._oDefinition.packageName;};
C.prototype.getNamespace=function(){return this._oDefinition.namespace;};
C.prototype.setNamespace=function(n){this._oDefinition.namespace=n;};
C.prototype.getProjectId=function(){return this._oDefinition.projectId;};
C.prototype.setProjectId=function(p){this._oDefinition.projectId=p;};
C.prototype.getId=function(){return this._oDefinition.fileName;};
C.prototype.getContent=function(){return this._oDefinition.content;};
C.prototype.setContent=function(c){this._oDefinition.content=c;this.setState(C.states.DIRTY);};
C.prototype.getVariantReference=function(){return this._oDefinition.variantReference||"";};
C.prototype.setVariantReference=function(v){this._oDefinition.variantReference=v;this.setState(C.states.DIRTY);};
C.prototype.getSelector=function(){return this._oDefinition.selector;};
C.prototype.getOwnerId=function(){return this._oDefinition.support?this._oDefinition.support.user:"";};
C.prototype.getText=function(t){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Change.getTexts : sTextId is not defined");}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){return this._oDefinition.texts[t].value;}}return"";};
C.prototype.setText=function(t,n){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Change.setTexts : sTextId is not defined");return;}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){this._oDefinition.texts[t].value=n;this.setState(C.states.DIRTY);}}};
C.prototype.isReadOnly=function(){return this._isReadOnlyDueToLayer()||this._isReadOnlyWhenNotKeyUser();};
C.prototype._isReadOnlyWhenNotKeyUser=function(){if(this.isUserDependent()){return false;}var r=this.getDefinition().reference;if(!r){return true;}var s=S.getInstanceOrUndef();if(!s){return true;}return!s.isKeyUser();};
C.prototype.isLabelReadOnly=function(){if(this._isReadOnlyDueToLayer()){return true;}return this._isReadOnlyDueToOriginalLanguage();};
C.prototype._isReadOnlyDueToLayer=function(){var c;c=U.getCurrentLayer(this._bUserDependent);return(this._oDefinition.layer!==c);};
C.prototype._isReadOnlyDueToOriginalLanguage=function(){var c,o;o=this.getOriginalLanguage();if(!o){return false;}c=U.getCurrentLanguage();return(c!==o);};
C.prototype.markForDeletion=function(){this.setState(C.states.DELETED);};
C.prototype.setRequest=function(r){if(typeof(r)!=="string"){U.log.error("sap.ui.fl.Change.setRequest : sRequest is not defined");}this._sRequest=r;};
C.prototype.getRequest=function(){return this._sRequest;};
C.prototype.getLayer=function(){return this._oDefinition.layer;};
C.prototype.getComponent=function(){return this._oDefinition.reference;};
C.prototype.setComponent=function(c){this._oDefinition.reference=c;};
C.prototype.getCreation=function(){return this._oDefinition.creation;};
C.prototype.isUserDependent=function(){return(this._bUserDependent);};
C.prototype.getPendingAction=function(){return this.getState();};
C.prototype.getDefinition=function(){return this._oDefinition;};
C.prototype.setResponse=function(r){var R=JSON.stringify(r);if(R){this._oDefinition=JSON.parse(R);this.setState(C.states.PERSISTED);}};
C.prototype.getFullFileIdentifier=function(){var l=this.getLayer();var n=this.getNamespace();var f=this.getDefinition().fileName;var F=this.getDefinition().fileType;return l+"/"+n+"/"+f+"."+F;};
C.prototype.addDependentControl=function(c,a,p,A){if(!c){throw new Error("Parameter vControl is mandatory");}if(!a){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}if(!this._oDefinition.dependentSelector){this._oDefinition.dependentSelector={};}if(this._oDefinition.dependentSelector[a]){throw new Error("Alias '"+a+"' already exists in the change.");}var m=p.modifier;var o=p.appComponent;if(Array.isArray(c)){var s=[];c.forEach(function(b){s.push(m.getSelector(b,o,A));});this._oDefinition.dependentSelector[a]=s;}else{this._oDefinition.dependentSelector[a]=m.getSelector(c,o,A);}delete this._aDependentSelectorList;};
C.prototype.getDependentControl=function(a,p){var d=[];var D;if(!a){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}var m=p.modifier;var A=p.appComponent;if(!this._oDefinition.dependentSelector){return undefined;}D=this._oDefinition.dependentSelector[a];if(Array.isArray(D)){D.forEach(function(s){d.push(m.bySelector(s,A,p.view));});return d;}else{return m.bySelector(D,A,p.view);}};
C.prototype.getDependentSelectorList=function(){var t=this;var d=[this.getSelector()];if(!this._aDependentSelectorList){if(this._oDefinition.dependentSelector){Object.keys(this._oDefinition.dependentSelector).forEach(function(a){var c=t._oDefinition.dependentSelector[a];if(!Array.isArray(c)){c=[c];}c.forEach(function(o){if(o&&U.indexOfObject(d,o)===-1){d.push(o);}});});}this._aDependentSelectorList=d;}return this._aDependentSelectorList;};
C.prototype.getDependentControlSelectorList=function(){var d=this.getDependentSelectorList().concat();if(d.length>0){var s=this.getSelector();var i=U.indexOfObject(d,s);if(i>-1){d.splice(i,1);}}return d;};
C.prototype.getRevertData=function(){return this._vRevertData;};
C.prototype.setRevertData=function(d){this._vRevertData=d;};
C.prototype.resetRevertData=function(){this.setRevertData(null);};
C.prototype.getUndoOperations=function(){return this._aUndoOperations;};
C.prototype.setUndoOperations=function(d){this._aUndoOperations=d;};
C.prototype.resetUndoOperations=function(){this.setUndoOperations(null);};
C.createInitialFileContent=function(p){if(!p){p={};}var f;if(p.fileType){f=p.fileType;}else{f=p.isVariant?"variant":"change";}var n={fileName:p.id||U.createDefaultFileName(p.changeType),fileType:f,changeType:p.changeType||"",moduleName:p.moduleName||"",reference:p.reference||"",packageName:p.packageName||"",content:p.content||{},selector:p.selector||{},layer:p.layer||U.getCurrentLayer(p.isUserDependent),texts:p.texts||{},namespace:p.namespace||U.createNamespace(p,"changes"),projectId:p.projectId||(p.reference&&p.reference.replace(".Component",""))||"",creation:"",originalLanguage:U.getCurrentLanguage(),conditions:{},context:p.context||"",support:{generator:p.generator||"Change.createInitialFileContent",service:p.service||"",user:"",sapui5Version:sap.ui.version,sourceChangeFileName:p.support&&p.support.sourceChangeFileName||"",compositeCommand:p.support&&p.support.compositeCommand||""},oDataInformation:p.oDataInformation||{},dependentSelector:p.dependentSelector||{},validAppVersions:p.validAppVersions||{},jsOnly:p.jsOnly||false,variantReference:p.variantReference||""};return n;};
return C;},true);
sap.ui.predefine('sap/ui/fl/ChangePersistence',["sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/context/ContextManager","sap/ui/fl/registry/Settings","sap/ui/fl/transport/TransportSelection","sap/ui/fl/variants/VariantController","sap/ui/core/BusyIndicator","sap/ui/core/Component","sap/m/MessageBox","sap/ui/model/json/JSONModel","sap/ui/thirdparty/jquery","sap/base/util/merge"],function(C,V,U,L,a,b,S,T,c,B,d,M,J,q,f){"use strict";var e=function(m){this._mComponent=m;this._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{},aChanges:[]};this._mChangesInitial=f({},this._mChanges);this._mVariantsChanges={};if(!this._mComponent||!this._mComponent.name){U.log.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.");}this._oVariantController=new c(this._mComponent.name,this._mComponent.appVersion,{});this._oTransportSelection=new T();this._oConnector=this._createLrepConnector();this._aDirtyChanges=[];this._oMessagebundle=undefined;this._mChangesEntries={};this._bHasChangesOverMaxLayer=false;this.HIGHER_LAYER_CHANGES_EXIST="higher_layer_changes_exist";};
e.prototype.getComponentName=function(){return this._mComponent.name;};
e.prototype._createLrepConnector=function(){return L.createConnector();};
e.prototype.getCacheKey=function(A){return a.getCacheKey(this._mComponent,A);};
e.prototype._preconditionsFulfilled=function(A,i,o){if(!o.fileName){U.log.warning("A change without fileName is detected and excluded from component: "+this._mComponent.name);return false;}function _(){if(i){return(o.fileType==="change")||(o.fileType==="variant");}return(o.fileType==="change")&&(o.changeType!=="defaultVariant");}function g(){if(i){if((o.fileType==="variant")||(o.changeType==="defaultVariant")){return o.selector&&o.selector.persistencyKey;}}return true;}function h(){return b.doesContextMatch(o,A);}function j(){if((o.fileType==="ctrl_variant")||(o.fileType==="ctrl_variant_change")||(o.fileType==="ctrl_variant_management_change")){return o.variantManagementReference||o.variantReference||(o.selector&&o.selector.id);}}if((_()&&g()&&h())||j()){return true;}return false;};
e.prototype.getChangesForComponent=function(p){return a.getChangesFillingCache(this._oConnector,this._mComponent,p).then(function(w){var A=p&&p.component&&U.getAppComponentForControl(p.component);if(w.changes&&w.changes.settings){S._storeInstance(w.changes.settings);}var F=w.changes&&Array.isArray(w.changes.changes)&&w.changes.changes.length!==0;var v=w.changes&&w.changes.variantSection&&!q.isEmptyObject(w.changes.variantSection);if(!F&&!v){return[];}var i=w.changes.changes;if(!this._oMessagebundle&&w.messagebundle&&A){if(!A.getModel("i18nFlexVendor")){if(i.some(function(t){return t.layer==="VENDOR";})){this._oMessagebundle=w.messagebundle;var m=new J(this._oMessagebundle);A.setModel(m,"i18nFlexVendor");}}}var I=p&&p.includeCtrlVariants&&v;var s=p&&p.currentLayer;var j=!(p&&p.ignoreMaxLayerParameter);if(s){i=i.filter(this._filterChangeForCurrentLayer.bind(this,s));if(!I&&v){this._getAllCtrlVariantChanges(w.changes.variantSection,false,s);}}else if(U.isLayerFilteringRequired()&&j){i=i.filter(this._filterChangeForMaxLayer.bind(this));if(!I&&v){this._getAllCtrlVariantChanges(w.changes.variantSection,true);}}else if(this._bHasChangesOverMaxLayer&&!j){this._bHasChangesOverMaxLayer=false;return this.HIGHER_LAYER_CHANGES_EXIST;}if(I){i=i.concat(this._getAllCtrlVariantChanges(w.changes.variantSection));}var o=A?A.getComponentData():(p&&p.componentData||{});if(w.changes.variantSection&&Object.keys(w.changes.variantSection).length!==0&&Object.keys(this._oVariantController._getChangeFileContent()).length===0){this._oVariantController._setChangeFileContent(w,o&&o.technicalParameters);}if(Object.keys(this._oVariantController._getChangeFileContent()).length>0){var k=this._oVariantController.loadInitialChanges();i=I?i:i.concat(k);}var l=p&&p.includeVariants;var n=w.changes.contexts||[];return new Promise(function(t){b.getActiveContexts(n).then(function(u){t(i.map(function(x){return x instanceof C?x.getDefinition():x;}).filter(this._preconditionsFulfilled.bind(this,u,l)).map(h.bind(this,w)));}.bind(this));}.bind(this));}.bind(this));function g(w,o){var F;Object.keys(w.changes.variantSection).some(function(v){return w.changes.variantSection[v].variants.some(function(i){if(i.content.fileName===o.getDefinition().variantReference){F=i;return true;}});});return F;}function r(v,o){return v.controlChanges.some(function(i,j){if(i.fileName===o.getDefinition().fileName){v.controlChanges.splice(j,1,o);return true;}});}function h(w,o){var i;if(!this._mChangesEntries[o.fileName]){this._mChangesEntries[o.fileName]=new C(o);}i=this._mChangesEntries[o.fileName];i.setState(C.states.PERSISTED);if(o.variantReference){var v=g(w,i);r(v,i);}return i;}};
e.prototype._filterChangeForMaxLayer=function(o){if(U.isOverMaxLayer(this._getLayerFromChangeOrChangeContent(o))){if(!this._bHasChangesOverMaxLayer){this._bHasChangesOverMaxLayer=true;}return false;}return true;};
e.prototype._filterChangeForCurrentLayer=function(l,o){return l===this._getLayerFromChangeOrChangeContent(o);};
e.prototype._getLayerFromChangeOrChangeContent=function(o){var s;if(o instanceof V||o instanceof C){s=o.getLayer();}else{s=o.layer;}return s;};
e.prototype._getAllCtrlVariantChanges=function(v,F,s){var g=[];var h=function(){return true;};if(F){h=this._filterChangeForMaxLayer.bind(this);}else if(typeof s==="string"&&s!==""){h=this._filterChangeForCurrentLayer.bind(this,s);}Object.keys(v).forEach(function(i){var o=v[i];o.variants=o.variants.filter(function(j){return!j.content.layer||h(j.content);});o.variants.forEach(function(j){if(Array.isArray(j.variantChanges.setVisible)){j.variantChanges.setVisible=j.variantChanges.setVisible.filter(h);var A=j.variantChanges.setVisible.slice(-1)[0];if(A&&!A.content.visible&&A.content.createdByReset){return;}else{g=g.concat(j.variantChanges.setVisible);}}Object.keys(j.variantChanges).forEach(function(k){if(k!=="setVisible"){j.variantChanges[k]=j.variantChanges[k].filter(h);g=j.variantChanges[k].length>0?g.concat(j.variantChanges[k].slice(-1)[0]):g;}});g=(j.content.fileName!==i)?g.concat([j.content]):g;j.controlChanges=j.controlChanges.filter(h);g=g.concat(j.controlChanges);});Object.keys(o.variantManagementChanges).forEach(function(j){o.variantManagementChanges[j]=o.variantManagementChanges[j].filter(h);g=o.variantManagementChanges[j].length>0?g.concat(o.variantManagementChanges[j].slice(-1)[0]):g;});});return g;};
e.prototype.getChangesForVariant=function(s,g,p){if(this._mVariantsChanges[g]){return Promise.resolve(this._mVariantsChanges[g]);}var i=function(o){var h=false;var j=o._oDefinition.selector;q.each(j,function(k,v){if(k===s&&v===g){h=true;}});return h;};var l=function(k,t){U.log.error("key : "+k+" and text : "+t.value);};return this.getChangesForComponent(p).then(function(h){return h.filter(i);}).then(function(h){if(!this._mVariantsChanges[g]){this._mVariantsChanges[g]={};}if(h&&h.length===0){return L.isFlexServiceAvailable().then(function(j){if(j===false){return Promise.reject();}return Promise.resolve(this._mVariantsChanges[g]);}.bind(this));}var I;h.forEach(function(o){I=o.getId();if(o.isValid()){if(this._mVariantsChanges[g][I]&&o.isVariant()){U.log.error("Id collision - two or more variant files having the same id detected: "+I);q.each(o.getDefinition().texts,l);U.log.error("already exists in variant : ");q.each(this._mVariantsChanges[g][I].getDefinition().texts,l);}this._mVariantsChanges[g][I]=o;}}.bind(this));return this._mVariantsChanges[g];}.bind(this));};
e.prototype.addChangeForVariant=function(s,g,p){var F,i,I,o,h;if(!p){return undefined;}if(!p.type){U.log.error("sap.ui.fl.Persistence.addChange : type is not defined");}var j=q.type(p.content);if(j!=='object'&&j!=='array'){U.log.error("mParameters.content is not of expected type object or array, but is: "+j,"sap.ui.fl.Persistence#addChange");}I={};if(typeof(p.texts)==="object"){q.each(p.texts,function(k,t){I[k]={value:t,type:"XFLD"};});}var v={creation:this._mComponent.appVersion,from:this._mComponent.appVersion};if(this._mComponent.appVersion&&p.developerMode){v.to=this._mComponent.appVersion;}i={changeType:p.type,service:p.ODataService,texts:I,content:p.content,reference:this._mComponent.name,isVariant:p.isVariant,packageName:p.packageName,isUserDependent:p.isUserDependent,validAppVersions:v};i.selector={};i.selector[s]=g;F=C.createInitialFileContent(i);if(p.id){F.fileName=p.id;}o=new C(F);h=o.getId();if(!this._mVariantsChanges[g]){this._mVariantsChanges[g]={};}this._mVariantsChanges[g][h]=o;return o.getId();};
e.prototype.saveAllChangesForVariant=function(s){var p=[];var t=this;q.each(this._mVariantsChanges[s],function(i,o){var g=o.getId();switch(o.getPendingAction()){case"NEW":p.push(t._oConnector.create(o.getDefinition(),o.getRequest(),o.isVariant()).then(function(r){o.setResponse(r.response);if(a.isActive()){a.addChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},r.response);}return r;}));break;case"UPDATE":p.push(t._oConnector.update(o.getDefinition(),o.getId(),o.getRequest(),o.isVariant()).then(function(r){o.setResponse(r.response);if(a.isActive()){a.updateChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},r.response);}return r;}));break;case"DELETE":p.push(t._oConnector.deleteChange({sChangeName:o.getId(),sLayer:o.getLayer(),sNamespace:o.getNamespace(),sChangelist:o.getRequest()},o.isVariant()).then(function(r){var o=t._mVariantsChanges[s][g];if(o.getPendingAction()==="DELETE"){delete t._mVariantsChanges[s][g];}if(a.isActive()){a.deleteChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},o.getDefinition());}return r;}));break;default:break;}});return Promise.all(p);};
e.prototype._addChangeIntoMap=function(A,o){var s=o.getSelector();if(s&&s.id){var g=s.id;if(s.idIsLocal){g=A.createId(g);}this._addMapEntry(g,o);if(s.idIsLocal===undefined&&g.indexOf("---")!=-1){var h=g.split("---")[0];if(h!==A.getId()){g=g.split("---")[1];g=A.createId(g);this._addMapEntry(g,o);}}}return this._mChanges;};
e.prototype._addMapEntry=function(s,o){if(!this._mChanges.mChanges[s]){this._mChanges.mChanges[s]=[];}if(this._mChanges.mChanges[s].indexOf(o)===-1){this._mChanges.mChanges[s].push(o);}if(this._mChanges.aChanges.indexOf(o)===-1){this._mChanges.aChanges.push(o);}};
e.prototype._addDependency=function(D,o,r){var m=r?this._mChangesInitial:this._mChanges;if(!m.mDependencies[D.getId()]){m.mDependencies[D.getId()]={changeObject:D,dependencies:[]};}m.mDependencies[D.getId()].dependencies.push(o.getId());if(!m.mDependentChangesOnMe[o.getId()]){m.mDependentChangesOnMe[o.getId()]=[];}m.mDependentChangesOnMe[o.getId()].push(D.getId());};
e.prototype._addControlsDependencies=function(D,g,r){var m=r?this._mChangesInitial:this._mChanges;if(g.length>0){if(!m.mDependencies[D.getId()]){m.mDependencies[D.getId()]={changeObject:D,dependencies:[],controlsDependencies:[]};}m.mDependencies[D.getId()].controlsDependencies=g;}};
e.prototype.loadChangesMapForComponent=function(A,p){p.component=!q.isEmptyObject(A)&&A;return this.getChangesForComponent(p).then(g.bind(this));function g(h){this._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{},aChanges:[]};h.forEach(this._addChangeAndUpdateDependencies.bind(this,A));this._mChangesInitial=f({},this._mChanges);return this.getChangesMapForComponent.bind(this);}};
e.prototype.checkForOpenDependenciesForControl=function(s,m,A){return Object.keys(this._mChanges.mDependencies).some(function(k){return this._mChanges.mDependencies[k].changeObject.getDependentSelectorList().some(function(D){return D===m.getControlIdBySelector(s,A);});},this);};
e.prototype.copyDependenciesFromInitialChangesMap=function(o,D){var i=f({},this._mChangesInitial.mDependencies);var I=i[o.getId()];if(I){var n=[];I.dependencies.forEach(function(s){if(D(s)){if(!this._mChanges.mDependentChangesOnMe[s]){this._mChanges.mDependentChangesOnMe[s]=[];}this._mChanges.mDependentChangesOnMe[s].push(o.getId());n.push(s);}}.bind(this));I.dependencies=n;this._mChanges.mDependencies[o.getId()]=I;}return this._mChanges;};
e.prototype._addChangeAndUpdateDependencies=function(A,o){this._addChangeIntoMap(A,o);this._updateDependencies(o,false);};
e.prototype._addRunTimeCreatedChangeAndUpdateDependencies=function(A,o){this._addChangeIntoMap(A,o);this._updateDependencies(o,true);};
e.prototype._updateDependencies=function(o,r){var g=this.getChangesMapForComponent().aChanges;var D=o.getDependentSelectorList();var h=o.getDependentControlSelectorList();this._addControlsDependencies(o,h,r);g.slice(0,g.length-1).reverse().forEach(function(p){var P=p.getDependentSelectorList();D.some(function(i){var j=U.indexOfObject(P,i);if(j>-1){this._addDependency(o,p,r);return true;}}.bind(this));}.bind(this));};
e.prototype.getChangesMapForComponent=function(){return this._mChanges;};
e.prototype.getChangesForView=function(v,p){var t=this;return this.getChangesForComponent(p).then(function(h){return h.filter(g.bind(t));});function g(o){var s=o.getSelector();if(!s){return false;}var h=s.id;if(!h||!p){return false;}var i=h.slice(0,h.lastIndexOf("--"));var v;if(o.getSelector().idIsLocal){var j=p.appComponent;if(j){v=j.getLocalId(p.viewId);}}else{v=p.viewId;}return i===v;}};
e.prototype.addChange=function(v,A){var o=this.addDirtyChange(v);this._addRunTimeCreatedChangeAndUpdateDependencies(A,o);this._addPropagationListener(A);return o;};
e.prototype.addDirtyChange=function(v){var n;if(v instanceof C||v instanceof V){n=v;}else{n=new C(v);}if(this._aDirtyChanges.indexOf(n)===-1){this._aDirtyChanges.push(n);}return n;};
e.prototype._addPropagationListener=function(o){var A=U.getAppComponentForControl(o);if(A instanceof d){var g=function(p){return!p._bIsSapUiFlFlexControllerApplyChangesOnControl;};var n=A.getPropagationListeners().every(g);if(n){var m=A.getManifestObject();var v=U.getAppVersionFromManifest(m);var F=sap.ui.require("sap/ui/fl/FlexControllerFactory");var h=F.create(this.getComponentName(),v);var p=h.getBoundApplyChangesOnControl(this.getChangesMapForComponent.bind(this),A);A.addPropagationListener(p);}}};
e.prototype.saveDirtyChanges=function(s){var D=this._aDirtyChanges.slice(0);var g=this._aDirtyChanges;var r=this._getRequests(D);var p=this._getPendingActions(D);if(p.length===1&&r.length===1&&p[0]==="NEW"){var R=r[0];var P=this._prepareDirtyChanges(g);return this._oConnector.create(P,R).then(function(o){this._massUpdateCacheAndDirtyState(g,D,s);return o;}.bind(this));}else{return D.reduce(function(h,o){var i=h.then(this._performSingleSaveAction(o));i.then(this._updateCacheAndDirtyState.bind(this,g,o,s));return i;}.bind(this),Promise.resolve());}};
e.prototype.saveSequenceOfDirtyChanges=function(D,s){var A=this.getDirtyChanges();return D.reduce(function(g,o){var h=g.then(this._performSingleSaveAction(o));h.then(this._updateCacheAndDirtyState.bind(this,A,o,s));return h;}.bind(this),Promise.resolve());};
e.prototype._performSingleSaveAction=function(D){return function(){if(D.getPendingAction()==="NEW"){return this._oConnector.create(D.getDefinition(),D.getRequest());}if(D.getPendingAction()==="DELETE"){return this._oConnector.deleteChange({sChangeName:D.getId(),sLayer:D.getLayer(),sNamespace:D.getNamespace(),sChangelist:D.getRequest()});}}.bind(this);};
e.prototype._updateCacheAndDirtyState=function(D,o,s){if(!s){if(o.getPendingAction()==="NEW"&&o.getFileType()!=="ctrl_variant_change"&&o.getFileType()!=="ctrl_variant_management_change"&&o.getFileType()!=="ctrl_variant"&&!o.getVariantReference()){a.addChange(this._mComponent,o.getDefinition());}else if(o.getPendingAction()==="DELETE"){a.deleteChange(this._mComponent,o.getDefinition());}}var i=D.indexOf(o);if(i>-1){D.splice(i,1);}};
e.prototype._massUpdateCacheAndDirtyState=function(D,g,s){g.forEach(function(o){this._updateCacheAndDirtyState(D,o,s);},this);};
e.prototype._getRequests=function(D){var r=[];D.forEach(function(o){var R=o.getRequest();if(r.indexOf(R)===-1){r.push(R);}});return r;};
e.prototype._getPendingActions=function(D){var p=[];D.forEach(function(o){var P=o.getPendingAction();if(p.indexOf(P)===-1){p.push(P);}});return p;};
e.prototype._prepareDirtyChanges=function(D){var g=[];D.forEach(function(o){g.push(o.getDefinition());});return g;};
e.prototype.getDirtyChanges=function(){return this._aDirtyChanges;};
e.prototype.deleteChange=function(o){var n=this._aDirtyChanges.indexOf(o);if(n>-1){if(o.getPendingAction()==="DELETE"){return;}this._aDirtyChanges.splice(n,1);this._deleteChangeInMap(o);return;}o.markForDeletion();this.addDirtyChange(o);this._deleteChangeInMap(o);};
e.prototype._deleteChangeInMap=function(o){var s=o.getId();var m=this._mChanges.mChanges;var D=this._mChanges.mDependencies;var g=this._mChanges.mDependentChangesOnMe;Object.keys(m).some(function(k){var h=m[k];var n=h.map(function(E){return E.getId();}).indexOf(o.getId());if(n!==-1){h.splice(n,1);return true;}});Object.keys(D).forEach(function(k){if(k===s){delete D[k];}else if(D[k].dependencies&&Array.isArray(D[k].dependencies)&&D[k].dependencies.indexOf(s)!==-1){D[k].dependencies.splice(D[k].dependencies.indexOf(s),1);if(D[k].dependencies.length===0){delete D[k];}}});Object.keys(g).forEach(function(k){if(k===s){delete g[k];}else if(Array.isArray(g[k])&&g[k].indexOf(s)!==-1){g[k].splice(g[k].indexOf(s),1);if(g[k].length===0){delete g[k];}}});var i=this._mChanges.aChanges.indexOf(o);if(i!==-1){this._mChanges.aChanges.splice(i,1);}};
e.prototype.loadSwitchChangesMapForComponent=function(p){p.changesMap=this._mChanges.mChanges;return this._oVariantController.getChangesForVariantSwitch(p);};
e.prototype.transportAllUIChanges=function(r,s,l,A){var h=function(E){B.hide();var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");var m=R.getText("MSG_TRANSPORT_ERROR",E?[E.message||E]:undefined);var t=R.getText("HEADER_TRANSPORT_ERROR");U.log.error("transport error"+E);M.show(m,{icon:M.Icon.ERROR,title:t,styleClass:s});return"Error";};return this._oTransportSelection.openTransportSelection(null,r,s).then(function(t){if(this._oTransportSelection.checkTransportInfo(t)){B.show(0);return this.getChangesForComponent({currentLayer:l,includeCtrlVariants:true}).then(function(g){var o={reference:this.getComponentName(),appVersion:this._mComponent.appVersion,layer:l};return this._oTransportSelection._prepareChangesForTransport(t,g,A,o).then(function(){B.hide();});}.bind(this));}else{return"Cancel";}}.bind(this))['catch'](h);};
e.prototype.resetChanges=function(l,g){return this.getChangesForComponent({currentLayer:l,includeCtrlVariants:true}).then(function(h){return S.getInstance(this.getComponentName()).then(function(s){if(!s.isProductiveSystem()&&!s.hasMergeErrorOccured()){return this._oTransportSelection.setTransports(h,d.get(this.getComponentName()));}}.bind(this)).then(function(){var u="?reference="+this.getComponentName()+"&appVersion="+this._mComponent.appVersion+"&layer="+l+"&generator="+g;var s="";h.some(function(o){if(o.getRequest()){s=o.getRequest();return true;}return false;});u=u+"&changelist="+s;return this._oConnector.send("/sap/bc/lrep/changes/"+u,"DELETE");}.bind(this));}.bind(this));};
return e;},true);
sap.ui.predefine('sap/ui/fl/ChangePersistenceFactory',["sap/ui/thirdparty/jquery","sap/ui/core/Component","sap/ui/fl/ChangePersistence","sap/ui/fl/Utils"],function(q,C,a,U){"use strict";var b={};b._instanceCache={};
b.getChangePersistenceForComponent=function(c,A){var o;A=A||U.DEFAULT_APP_VERSION;if(!b._instanceCache[c]){b._instanceCache[c]={};}o=b._instanceCache[c][A];if(!o){var d={name:c,appVersion:A};o=new a(d);b._instanceCache[c][A]=o;}return o;};
b.getChangePersistenceForControl=function(c){var s;s=this._getComponentClassNameForControl(c);var A=U.getAppVersionFromManifest(U.getAppComponentForControl(c).getManifest());return b.getChangePersistenceForComponent(s,A);};
b._getComponentClassNameForControl=function(c){return U.getComponentClassName(c);};
b.registerLoadComponentEventHandler=function(){C._fnLoadComponentCallback=this._onLoadComponent.bind(this);};
b._doLoadComponent=function(c,m){var o={oChangePersistence:{},oRequestOptions:{appName:c.name}};var s=U.getFlexReference(m);var A=U.getAppVersionFromManifest(m);var M,S,t;S=c&&c.componentData&&c.componentData.startupParameters||{};t=c&&c.componentData&&c.componentData.technicalParameters;if(S["sap-app-id"]&&S["sap-app-id"].length===1){s=S["sap-app-id"][0];}else{if(c){var d=c.asyncHints;if(d&&d.requests&&Array.isArray(d.requests)){var f=this._findFlAsyncHint(d.requests,s);if(f){o.oRequestOptions.cacheKey=f.cachebusterToken||"<NO CHANGES>";}}}}var e=t||S;if(e&&e["sap-ui-fl-max-layer"]&&e["sap-ui-fl-max-layer"].length===1){M=e["sap-ui-fl-max-layer"][0];}U.setMaxLayerParameter(M);o.oRequestOptions.siteId=U.getSiteIdByComponentData(c.componentData);o.oChangePersistence=this.getChangePersistenceForComponent(s,A);return o;};
b._onLoadComponent=function(c,m){if(!U.isApplication(m)){return;}var o=this._doLoadComponent(c,m);o.oRequestOptions.componentData={};Object.assign(o.oRequestOptions.componentData,c.componentData);o.oChangePersistence.getChangesForComponent(o.oRequestOptions);};
b._getChangesForComponentAfterInstantiation=function(c,m,o){if(!U.isApplication(m)){return Promise.resolve(function(){return{mChanges:{},mDependencies:{},mDependentChangesOnMe:{}};});}var d=this._doLoadComponent(c,m);return d.oChangePersistence.loadChangesMapForComponent(o,d.oRequestOptions);};
b._findFlAsyncHint=function(A,r){var t=this;var f;q.each(A,function(n,o){if(t._flAsyncHintMatches(o,r)){f=o;return false;}});return f;};
b._flAsyncHintMatches=function(A,r){return A.name==="sap.ui.fl.changes"&&A.reference===r;};
return b;},true);
sap.ui.predefine('sap/ui/fl/DefaultVariant',["sap/ui/fl/Change"],function(C){"use strict";var D=function(){};
D.prototype.getDefaultVariantId=function(c){var d=this.getNewestDefaultVariantChangeDeleteTheRest(c);if(d){return d.getContent().defaultVariantName;}return"";};
D.prototype.getNewestDefaultVariantChangeDeleteTheRest=function(c){var d=this.getDefaultVariantChanges(c).sort(function(a,b){var e=new Date(a.getCreation());var f=new Date(b.getCreation());if(isNaN(e.getDate())){return-1;}if(isNaN(f.getDate())){return 1;}return f-e;});var n=d.shift();d.forEach(function(o){o.markForDeletion();});return n;};
D.prototype.getDefaultVariantChanges=function(c){if(!c||typeof c!=='object'){return[];}return Object.keys(c).map(a).filter(d);function a(s){return c[s];}function d(o){return o.getChangeType()==='defaultVariant';}};
D.prototype.updateDefaultVariantId=function(c,n){var N=this.getNewestDefaultVariantChangeDeleteTheRest(c);if(N){var o=N.getContent();o.defaultVariantName=n;N.setContent(o);}return N;};
D.prototype._createChangeFile=function(p){var f;p.changeType='defaultVariant';f=C.createInitialFileContent(p);f.content.defaultVariantName=p.defaultVariantId;f.layer='USER';return f;};
D.prototype.createChangeObject=function(p){var f,c;f=this._createChangeFile(p);c=new C(f);return c;};
return new D();},true);
sap.ui.predefine('sap/ui/fl/EventHistory',function(){"use strict";var E=function(){};E._aEventIds=["ControlForPersonalizationRendered"];E._aUnsubscribedEventIds=[];E._oHistory={};
E.start=function(){E._aEventIds.forEach(function(e){if(E._aUnsubscribedEventIds.indexOf(e)===-1){sap.ui.getCore().getEventBus().subscribe("sap.ui",e,E.saveEvent);E._oHistory[e]=[];}});};
E.saveEvent=function(c,e,p){var o={"channelId":c,"eventId":e,"parameters":p.getId()};if(E._oHistory[e]){var b=E._oHistory[e].some(function(O){return(O.channelId===o.channelId&&O.eventId===o.eventId&&O.parameters===o.parameters);});if(!b){E._oHistory[e].push(o);}}};
E.getHistoryAndStop=function(e){sap.ui.getCore().getEventBus().unsubscribe("sap.ui",e,E.saveEvent);E._addUnsubscribedEvent(e);return E._oHistory[e]||[];};
E._addUnsubscribedEvent=function(e){if(E._aUnsubscribedEventIds.indexOf(e)===-1){E._aUnsubscribedEventIds.push(e);}};
return E;},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnector',["sap/ui/thirdparty/jquery","sap/ui/thirdparty/URI","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/ChangePersistenceFactory"],function(q,u,F,L,C,a){"use strict";var l=Object.create(L.prototype);b._oBackendInstances={};
function b(i){this.sInitialComponentJsonPath=i;this.mSettings={};}
for(var p in l){if(typeof l[p]==='function'){b.prototype[p]=(function(p){return function(){throw new Error('Method '+p+'() is not implemented in FakeLrepConnector.');};}(p));}}
b.prototype.loadSettings=function(){this.setFlexServiceAvailability(true);return Promise.resolve(this.mSettings);};
b.prototype.setSettings=function(s){this.mSettings=s;};
b.prototype.setFlexServiceAvailability=function(A){L._bServiceAvailability=A;};
b.prototype.loadChanges=function(s){var i=this.sInitialComponentJsonPath;return new Promise(function(r,f){q.getJSON(i).done(function(R){var g={changes:R,componentClassName:s};r(g);}).fail(function(g){f(g);});});};
b.prototype.create=function(f,g,i){if(!i){return Promise.resolve();}if(!f.creation){f.creation=new Date().toISOString();}return Promise.resolve({response:f,status:'success'});};
b.prototype.update=function(f,g,i,j){if(!j){return Promise.resolve();}return Promise.resolve({response:f,status:'success'});};
b.prototype.deleteChange=function(f,i){if(!i){return Promise.resolve();}return Promise.resolve({response:undefined,status:'nocontent'});};
b.prototype.send=function(U,m,D,o){return new Promise(function(r,f){e(U,m,D,o,r,f);d(U,m,D,o,r,f);c(U,m,D,o,r,f);h(U,m,D,o,r,f);});};
function h(U,m,D,o,r){if(U.match(/^\/sap\/bc\/lrep\/changes\//)&&m==='DELETE'){var f=[];var g=/\?reference=([\w.]+)\&.+\&layer=(\w+)\&generator=([\w.]+)/;f=U.match(g);r({response:{"parameters":f},status:"success"});}}
function c(U,m,D,o,r){if(U.match(/^\/sap\/bc\/ui2\/app_index\/ui5_app_mani_first_supported\//)&&m==='GET'){r({response:false,status:"success"});}}
function d(U,m,D,o,r){if(U.match(/^\/sap\/bc\/lrep\/actions\/make_changes_transportable\//)&&m==='POST'){r();}}
function e(U,m,D,o,r,f){if(U.match(/^\/sap\/bc\/lrep\/actions\/gettransports\//)){r({response:{"transports":[{"transportId":"U31K008488","description":"The Ultimate Transport","owner":"Fantasy Owner","locked":false}],"localonly":false,"errorCode":""}});}}
b.enableFakeConnector=function(i,A,s){function r(){b.enableFakeConnector.original=L.createConnector;L.createConnector=function(){if(!b._oFakeInstance){b._oFakeInstance=new b(i);}return b._oFakeInstance;};}if(A&&s){var o=a.getChangePersistenceForComponent(A,s);if(!(o._oConnector instanceof b)){C.clearEntry(A,s);if(!b._oBackendInstances[A]){b._oBackendInstances[A]={};}b._oBackendInstances[A][s]=o._oConnector;o._oConnector=new b(i);}r();return;}C.clearEntries();if(b.enableFakeConnector.original){return;}r();};
b.disableFakeConnector=function(A,s){function r(){if(b.enableFakeConnector.original){L.createConnector=b.enableFakeConnector.original;b.enableFakeConnector.original=undefined;b._oFakeInstance=undefined;}}if(A&&s){var o=a.getChangePersistenceForComponent(A,s);if(!(o._oConnector instanceof L)){C.clearEntry(A,s);if(b._oBackendInstances[A]&&b._oBackendInstances[A][s]){o._oConnector=b._oBackendInstances[A][s];b._oBackendInstances[A][s]=undefined;}}r();return;}C.clearEntries();r();};
return b;},true);
sap.ui.predefine('sap/ui/fl/FlexController',["sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/Utils","sap/ui/fl/FlexCustomData","sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/registry/Settings","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/context/ContextManager","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/util/reflection/XmlTreeModifier","sap/ui/core/Component","sap/ui/core/Element"],function(C,U,F,a,V,b,c,d,J,X,e,E){"use strict";var f=function(s,A){this._oChangePersistence=undefined;this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;if(this._sComponentName&&this._sAppVersion){this._createChangePersistence();}};f.PENDING="sap.ui.fl:PendingChange";f.PROCESSING="sap.ui.fl:ProcessingChange";f.variantTechnicalParameterName="sap-ui-fl-control-variant-id";
f.prototype.setComponentName=function(s){this._sComponentName=s;this._createChangePersistence();};
f.prototype.getComponentName=function(){return this._sComponentName;};
f.prototype.getAppVersion=function(){return this._sAppVersion;};
f.prototype.getVariantModelData=function(){var D;if(this._oChangePersistence&&this._oChangePersistence._oVariantController._mVariantManagement&&Object.keys(this._oChangePersistence._oVariantController._mVariantManagement).length>0){D=this._oChangePersistence._oVariantController._fillVariantModel();}return D;};
f.prototype.createBaseChange=function(o,A){var g,h;var i=d._getContextIdsFromUrl();if(i.length>1){throw new Error("More than one DesignTime Context is currently active.");}if(!A){throw new Error("No Application Component found - to offer flexibility. Valid relation to its owning component must be present.");}o.reference=this.getComponentName();o.packageName="$TMP";o.context=i.length===1?i[0]:"";o.validAppVersions=this._getValidAppVersions(o);g=a.createInitialFileContent(o);h=new a(g);if(o.variantReference){h.setVariantReference(o.variantReference);}return h;};
f.prototype.createChange=function(o,g){var h,i;if(!g){throw new Error("A flexibility change cannot be created without a targeted control.");}var s=g.id||g.getId();if(!o.selector){o.selector={};}var A=g.appComponent||U.getAppComponentForControl(g);if(!A){throw new Error("No Application Component found - to offer flexibility the control with the id '"+s+"' has to have a valid relation to its owning application component.");}Object.assign(o.selector,J.getSelector(s,A));h=this.createBaseChange(o,A);var j=g.controlType||U.getControlType(g);if(!j){throw new Error("No control type found - the change handler can not be retrieved.");}i=this._getChangeHandler(h,j,g,J);if(i){i.completeChangeContent(h,o,{modifier:J,appComponent:A});}else{throw new Error("Change handler could not be retrieved for change "+JSON.stringify(o)+".");}return h;};
f.prototype.createVariant=function(v,A){var o,g;if(!A){throw new Error("No Application Component found - to offer flexibility the variant has to have a valid relation to its owning application component.");}v.content.reference=this.getComponentName();v.content.packageName="$TMP";v.content.validAppVersions=this._getValidAppVersions(v);g=V.createInitialFileContent(v);o=new V(g);return o;};
f.prototype._getValidAppVersions=function(o){var A=this.getAppVersion();var v={creation:A,from:A};if(A&&o.developerMode&&o.scenario!==sap.ui.fl.Scenario.AdaptationProject&&o.scenario!==sap.ui.fl.Scenario.AppVariant){v.to=A;}return v;};
f.prototype.addChange=function(o,g){var h=this.createChange(o,g);var A=U.getAppComponentForControl(g);this.addPreparedChange(h,A);return h;};
f.prototype.addPreparedChange=function(o,A){if(o.getVariantReference()){var m=A.getModel("$FlexVariants");m._addChange(o);}this._oChangePersistence.addChange(o,A);return o;};
f.prototype.deleteChange=function(o,A){this._oChangePersistence.deleteChange(o);if(o.getVariantReference()){A.getModel("$FlexVariants")._removeChange(o);}};
f.prototype.createAndApplyChange=function(o,g){var h=this.addChange(o,g);var p={modifier:J,appComponent:U.getAppComponentForControl(g),view:U.getViewForControl(g)};return this.checkTargetAndApplyChange(h,g,p).then(function(r){if(!r.success){var i=r.error||new Error("The change could not be applied.");this._oChangePersistence.deleteChange(h);throw i;}return h;}.bind(this));};
f.prototype._checkDependencies=function(o,D,m,A,r){var R=this._checkChange(o,A);if(!R){return[];}r.push(o);var s=o.getId();var g=D[s]&&D[s].dependencies||[];for(var i=0,n=g.length;i<n;i++){var h=U.getChangeFromChangesMap(m,g[i]);R=this._checkDependencies(h,D,m,A,r);if(R.length===0){r=[];break;}delete D[s];}return r;};
f.prototype._checkChange=function(o,A){var s;var S=o.getSelector();if(S.idIsLocal){s=A.createId(S.id);}else{s=S.id;}var g=sap.ui.getCore().byId(s);if(!g){return false;}var h=F.hasFailedCustomDataJs(g,o,J).customData;if(h){return false;}return true;};
f.prototype.waitForChangesToBeApplied=function(o){var m=this._oChangePersistence.getChangesMapForComponent();var p=[];var D=Object.assign({},m.mDependencies);var g=m.mChanges;var h=g[o.getId()]||[];var n=h.filter(function(i){return!this._isChangeCurrentlyApplied(o,i,J);},this);var A=U.getAppComponentForControl(o);var r=[];n.forEach(function(i){var j=this._checkDependencies(i,D,m.mChanges,A,[]);r=r.concat(j);},this);r=r.filter(function(i,P,j){return j.indexOf(i)===P;});r.forEach(function(w){if(!w.aPromiseFn){w.aPromiseFn=[];}p.push(new Promise(function(i,j){w.aPromiseFn.push({resolve:i,reject:j});}).catch(function(i){var j=i.getId&&m.mDependentChangesOnMe[i.getId()]||[];j.forEach(function(s){var k=U.getChangeFromChangesMap(g,s);if(k.aPromiseFn){k.aPromiseFn.forEach(function(P){P.reject(k);});}});Promise.resolve();}));},this);return Promise.all(p);};
f.prototype.saveAll=function(s){return this._oChangePersistence.saveDirtyChanges(s);};
f.prototype.processXmlView=function(v,p){var o=e.get(p.componentId);var A=U.getAppComponentForControl(o);var m=A.getManifest();p.appComponent=A;p.appDescriptor=m;p.modifier=X;p.view=v;return this.processViewByModifier(p);};
f.prototype.processViewByModifier=function(p){p.siteId=U.getSiteId(p.appComponent);return this._oChangePersistence.getChangesForView(p.viewId,p).then(this._resolveGetChangesForView.bind(this,p),this._handlePromiseChainError.bind(this,p.view));};
f.prototype._checkForDependentSelectorControls=function(o,p){var D=o.getDependentControlSelectorList();D.forEach(function(s){var g=p.modifier.bySelector(s,p.appComponent,p.view);if(!g){throw new Error("A dependent selector control of the flexibility change is not available.");}});};
f.prototype._resolveGetChangesForView=function(p,g){var P=[];if(!Array.isArray(g)){var s="No list of changes was passed for processing the flexibility on view: "+p.view+".";U.log.error(s,undefined,"sap.ui.fl.FlexController");return[];}g.forEach(function(o){try{var S=this._getSelectorOfChange(o);if(!S||!S.id){throw new Error("No selector in change found or no selector ID.");}var h=p.modifier.bySelector(S,p.appComponent,p.view);if(!h){throw new Error("A flexibility change tries to change a nonexistent control.");}this._checkForDependentSelectorControls(o,p);P.push(function(){return this.checkTargetAndApplyChange(o,h,p).then(function(r){if(!r.success){this._logApplyChangeError(r.error||{},o);}}.bind(this));}.bind(this));}catch(i){this._logApplyChangeError(i,o);}}.bind(this));return U.execPromiseQueueSequentially(P).then(function(){return p.view;});};
f.prototype._logApplyChangeError=function(o,g){var D=g.getDefinition();var s=D.changeType;var t=D.selector.id;var h=D.namespace+D.fileName+"."+D.fileType;var w="A flexibility change could not be applied.";w+="\nThe displayed UI might not be displayed as intedend.";if(o.message){w+="\n   occurred error message: '"+o.message+"'";}w+="\n   type of change: '"+s+"'";w+="\n   LRep location of the change: "+h;w+="\n   id of targeted control: '"+t+"'.";U.log.warning(w,undefined,"sap.ui.fl.FlexController");};
f.prototype._isXmlModifier=function(p){return p.modifier.targets==="xmlTree";};
f.prototype.checkTargetAndApplyChange=function(o,g,p){var x=this._isXmlModifier(p);var m=p.modifier;var s=m.getControlType(g);var h=this._getControlIfTemplateAffected(o,g,s,p);var i=this._getChangeHandler(o,h.controlType,h.control,m);var S,r;if(!i){var j="Change handler implementation for change not found or change type not enabled for current layer - Change ignored";U.log.warning(j);return new U.FakePromise({success:false,error:new Error(j)});}if(x&&o.getDefinition().jsOnly){return new U.FakePromise({success:false,error:new Error("Change cannot be applied in XML. Retrying in JS.")});}if(!this._isChangeCurrentlyApplied(g,o,m)){var R=this.isChangeHandlerRevertible(o,h.control,i);return new U.FakePromise().then(function(){S=b.getInstanceOrUndef();if(!R&&S&&S._oSettings.recordUndo){if(x){throw new Error();}return new Promise(function(k){sap.ui.require(["sap/ui/rta/ControlTreeModifier"],function(l){if(!l){U.log.error("Please load 'sap/ui/rta' library if you want to record undo");}else{p.modifier=l;l.startRecordingUndo();r=l;}k();});});}}).then(function(){o.PROCESSING=o.PROCESSING?o.PROCESSING:true;var I=i.applyChange(o,h.control,p);if(h.bTemplateAffected){m.updateAggregation(g,o.getContent().boundAggregation);}return I;}).then(function(I){if(I instanceof E){g=I;}if(!R&&S&&S._oSettings.recordUndo&&r){o.setUndoOperations(r.stopRecordingUndo());}F.addAppliedCustomData(g,o,p,R&&x);if(o.aPromiseFn){o.aPromiseFn.forEach(function(P){P.resolve(o);});}delete o.PROCESSING;o.PROCESSED=true;return{success:true};}).catch(function(k){this._logErrorAndWriteCustomData(k,o,p,g,x);if(o.aPromiseFn){o.aPromiseFn.forEach(function(P){P.reject(o);});}delete o.PROCESSING;o.PROCESSED=true;return{success:false,error:k};}.bind(this));}return new U.FakePromise({success:true});};
f.prototype._removeFromAppliedChangesAndMaybeRevert=function(o,g,p,r){var m=p.modifier;var s=m.getControlType(g);var h=this._getControlIfTemplateAffected(o,g,s,p);var i=this._getChangeHandler(o,h.controlType,h.control,m);var R;var S;if(r&&!i){U.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored");return new U.FakePromise();}if(o.getChangeType()==="stashControl"&&s==="sap.ui.core._StashedControl"){S=true;if(r&&!o.getRevertData()){i.setChangeRevertData(o,false);}}var I=this._isChangeCurrentlyApplied(g,o,m);if(!I&&(o.PROCESSING||o.QUEUED)){R=new Promise(function(j,k){o.aPromiseFn=o.aPromiseFn||[];o.aPromiseFn.push({resolve:j,reject:k});}).then(function(){return true;});}else{R=new U.FakePromise(false);}return R.then(function(P){if(r&&(P||(!P&&I))||r&&S){if(!o.getRevertData()){o.setRevertData(F.getParsedRevertDataFromCustomData(g,o,m));}var j=i.revertChange(o,h.control,p);if(h.bTemplateAffected){m.updateAggregation(g,o.getContent().boundAggregation);}return j;}}).then(function(){g=p.modifier.bySelector(o.getSelector(),p.appComponent,p.view);F.destroyAppliedCustomData(g,o,p.modifier);}).catch(function(j){U.log.error("Change could not be reverted:",j);});};
f.prototype._logErrorAndWriteCustomData=function(r,o,p,g,x){var s=o.getId(),l="Change ''{0}'' could not be applied.",h=r instanceof Error,i=F.getCustomDataIdentifier(false,h,x);switch(i){case F.notApplicableChangesCustomDataKey:U.formatAndLogMessage("info",[l,r.message],[s]);break;case F.failedChangesCustomDataKeyXml:this._setMergeError(true);U.formatAndLogMessage("warning",[l,"Merge error detected while processing the XML tree."],[s],r.stack);break;case F.failedChangesCustomDataKeyJs:this._setMergeError(true);U.formatAndLogMessage("error",[l,"Merge error detected while processing the JS control tree."],[s],r.stack);break;}F.addFailedCustomData(g,o,p,i);};
f.prototype._isChangeCurrentlyApplied=function(o,g,m){return!!F.getAppliedCustomDataValue(o,g,m);};
f.prototype._handlePromiseChainError=function(v,o){U.log.error("Error processing view "+o+".");return v;};
f.prototype._getSelectorOfChange=function(o){if(!o||!o.getSelector){return undefined;}return o.getSelector();};
f.prototype._getChangeHandler=function(o,s,g,m){var h=o.getChangeType();var l=o.getLayer();return this._getChangeRegistry().getChangeHandler(h,s,g,m,l);};
f.prototype._getChangeRegistry=function(){var i=C.getInstance();i.initSettings();return i;};
f.prototype._getControlIfTemplateAffected=function(o,g,s,p){var h=o.getDefinition();var m={};if(o.getContent().boundAggregation&&h.dependentSelector.originalSelector){var M=p.modifier;m.control=M.bySelector(h.dependentSelector.originalSelector,p.appComponent,p.view);m.controlType=M.getControlType(m.control);m.bTemplateAffected=true;}else{m.control=g;m.controlType=s;m.bTemplateAffected=false;}return m;};
f.prototype.getComponentChanges=function(p,i){return this._oChangePersistence.getChangesForComponent(p,i);};
f.prototype.checkForOpenDependenciesForControl=function(s,m,o){return this._oChangePersistence.checkForOpenDependenciesForControl(s,m,o);};
f.prototype.hasHigherLayerChanges=function(p){p=p||{};var s=p.upToLayer||U.getCurrentLayer(false);p.includeVariants=true;p.includeCtrlVariants=true;return this.getComponentChanges(p).then(function(v){var h=v===this._oChangePersistence.HIGHER_LAYER_CHANGES_EXIST||v.some(function(o){return U.compareAgainstCurrentLayer(o.getLayer(),s)>0;});return!!h;}.bind(this));};
f.prototype._createChangePersistence=function(){this._oChangePersistence=c.getChangePersistenceForComponent(this.getComponentName(),this.getAppVersion());return this._oChangePersistence;};
f.prototype.resetChanges=function(l,g,o){return this._oChangePersistence.resetChanges(l,g).then(function(r){if(o){var m=o.getModel("$FlexVariants");if(m){m.updateHasherEntry({parameters:[],updateURL:true,component:o});}}return r;});};
f.prototype.discardChanges=function(g,D){var A=U.getCurrentLayer(!!D);var i=0;var l;var o;l=g.length;while(i<g.length){o=g[i];if(o&&o.getLayer&&o.getLayer()===A){this._oChangePersistence.deleteChange(o);}if(l===g.length){i++;}else{l=g.length;}}return this._oChangePersistence.saveDirtyChanges();};
f.prototype.discardChangesForId=function(i,D){if(!i){return Promise.resolve();}var o=this._oChangePersistence.getChangesMapForComponent();var g=o.mChanges[i]||[];return this.discardChanges(g,D);};
f.prototype._setMergeError=function(){return b.getInstance().then(function(s){s.setMergeErrorOccured(true);});};
f.prototype._checkIfDependencyIsStillValid=function(A,m,s){var o=U.getChangeFromChangesMap(this._oChangePersistence._mChanges.mChanges,s);if(!o.PROCESSED){return true;}var g=m.bySelector(o.getSelector(),A);if(!this._isChangeCurrentlyApplied(g,o,m)){return true;}return false;};
f.prototype._applyChangesOnControl=function(g,o,h){var p=[];var m=g();var i=m.mChanges;var D=m.mDependencies;var j=m.mDependentChangesOnMe;var k=i[h.getId()]||[];var A=U.getAppComponentForControl(h);var P={modifier:J,appComponent:A,view:U.getViewForControl(h)};k.forEach(function(l){if(l.PROCESSED&&!this._isChangeCurrentlyApplied(h,l,P.modifier)){m=this._oChangePersistence.copyDependenciesFromInitialChangesMap(l,this._checkIfDependencyIsStillValid.bind(this,A,P.modifier));D=m.mDependencies;j=m.mDependentChangesOnMe;delete l.PROCESSED;}if(!D[l.getId()]){l.QUEUED=true;p.push(function(){return this.checkTargetAndApplyChange(l,h,P).then(function(r){this._updateDependencies(D,j,l.getId());delete l.QUEUED;}.bind(this));}.bind(this));}else{D[l.getId()][f.PENDING]=this.checkTargetAndApplyChange.bind(this,l,h,P);}}.bind(this));return U.execPromiseQueueSequentially(p).then(function(){return this._processDependentQueue(D,j,A);}.bind(this));};
f.prototype.getBoundApplyChangesOnControl=function(g,o){var B=this._applyChangesOnControl.bind(this,g,o);B._bIsSapUiFlFlexControllerApplyChangesOnControl=true;return B;};
f.prototype.revertChangesOnControl=function(g,A){var p=[];g.forEach(function(o){p.push(function(){var s=this._getSelectorOfChange(o);var h=J.bySelector(s,A);var P={modifier:J,appComponent:A,view:U.getViewForControl(h)};return this._removeFromAppliedChangesAndMaybeRevert(o,h,P,true).then(function(){this._oChangePersistence._deleteChangeInMap(o);}.bind(this));}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};
f.prototype.isChangeHandlerRevertible=function(o,g,h){if(!h){var s=J.getControlType(g);h=this._getChangeHandler(o,s,g,J);}return!!(h&&typeof h.revertChange==="function");};
f.prototype.applyVariantChanges=function(g,A){var p=[];g.forEach(function(o){this._oChangePersistence._addChangeAndUpdateDependencies(A,o);p.push(function(){var m=J;var s=this._getSelectorOfChange(o);var h=m.bySelector(s,A);if(!h){U.log.error("A flexibility change tries to change a nonexistent control.");return new U.FakePromise();}return this._applyChangesOnControl(this._oChangePersistence.getChangesMapForComponent.bind(this._oChangePersistence),A,h);}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};
f.prototype.removeFromAppliedChangesOnControl=function(o,A,g){var p={modifier:J,appComponent:A,view:U.getViewForControl(g)};return this._removeFromAppliedChangesAndMaybeRevert(o,g,p,false);};
f.prototype._updateControlsDependencies=function(D,A){var o;Object.keys(D).forEach(function(s){var g=D[s];if(g.controlsDependencies&&g.controlsDependencies.length>0){var l=g.controlsDependencies.length;while(l--){var S=g.controlsDependencies[l];o=J.bySelector(S,A);if(o){g.controlsDependencies.splice(l,1);}}}});};
f.prototype._updateDependencies=function(D,m,s){if(m[s]){m[s].forEach(function(k){var o=D[k];var i=o.dependencies.indexOf(s);if(i>-1){o.dependencies.splice(i,1);}});delete m[s];}};
f.prototype._iterateDependentQueue=function(D,m,A){var g=[],h=[],p=[];this._updateControlsDependencies(D,A);Object.keys(D).forEach(function(s){var o=D[s];if(o[f.PENDING]&&o.dependencies.length===0&&!(o.controlsDependencies&&o.controlsDependencies.length>0)&&!o[f.PROCESSING]){o[f.PROCESSING]=true;p.push(function(){return o[f.PENDING]().then(function(r){h.push(s);g.push(o.changeObject.getId());});});}});return U.execPromiseQueueSequentially(p).then(function(){for(var j=0;j<h.length;j++){delete D[h[j]];}for(var k=0;k<g.length;k++){this._updateDependencies(D,m,g[k]);}return g;}.bind(this));};
f.prototype._processDependentQueue=function(D,m,A){return this._iterateDependentQueue(D,m,A).then(function(g){if(g.length>0){return this._processDependentQueue(D,m,A);}}.bind(this));};
return f;},true);
sap.ui.predefine('sap/ui/fl/FlexControllerFactory',["sap/ui/fl/FlexController","sap/ui/fl/Utils","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/variants/VariantModel"],function(F,U,C,V){"use strict";var a={};a._instanceCache={};
a.create=function(c,A){var A=A||U.DEFAULT_APP_VERSION;if(!a._instanceCache[c]){a._instanceCache[c]={};}var f=a._instanceCache[c][A];if(!f){f=new F(c,A);a._instanceCache[c][A]=f;}return f;};
a.createForControl=function(c,m){try{var A=U.getAppComponentForControl(c);var s=U.getComponentClassName(A?A:c);var b=U.getAppVersionFromManifest(A?A.getManifest():m);return a.create(s,b);}catch(e){U.log.error(e.message,undefined,"sap.ui.fl.FlexControllerFactory");}};
a.getChangesAndPropagate=function(c,v){var m=c.getManifestObject();var s="$FlexVariants";var f;if(U.isApplication(m)){f=a.createForControl(c,m);C._getChangesForComponentAfterInstantiation(v,m,c).then(function(g){c.addPropagationListener(f.getBoundApplyChangesOnControl(g,c));var d=f.getVariantModelData()||{};c.setModel(new V(d,f,c),s);});}else if(U.isEmbeddedComponent(c)){var A=U.getAppComponentForControl(c);if(A){var o=A&&A.getModel(s);if(o){c.setModel(o,s);o.addEmbeddedComponent(c);}}}};
return a;},true);
sap.ui.predefine('sap/ui/fl/FlexCustomData',["sap/ui/core/CustomData"],function(C){"use strict";var F={};F.appliedChangesCustomDataKey="sap.ui.fl.appliedChanges";F.failedChangesCustomDataKeyJs="sap.ui.fl.failedChanges.js";F.failedChangesCustomDataKeyXml="sap.ui.fl.failedChanges.xml";F.notApplicableChangesCustomDataKey="sap.ui.fl.notApplicableChanges";
F.getAppliedCustomDataValue=function(c,o,m){var a=this._getCustomData(c,m,this._getCustomDataKey(o,F.appliedChangesCustomDataKey));return a.customDataValue;};
F.getParsedRevertDataFromCustomData=function(c,o,m){var s=this.getAppliedCustomDataValue(c,o,m);return s&&JSON.parse(s);};
F.hasFailedCustomDataJs=function(c,o,m){var a=this._getCustomData(c,m,this._getCustomDataKey(o,F.failedChangesCustomDataKeyJs));return!!a.customDataValue;};
F.addAppliedCustomData=function(c,o,p,s){var a;var b=this._getCustomDataKey(o,F.appliedChangesCustomDataKey);if(s){a=this._escapeCurlyBracketsInString(JSON.stringify(o.getRevertData()));}else{a="true";}this._writeCustomData(c,b,a,p);};
F.addFailedCustomData=function(c,o,p,i){var s=this._getCustomDataKey(o,i);this._writeCustomData(c,s,"true",p);};
F.destroyAppliedCustomData=function(c,o,m){var k=this._getCustomDataKey(o,F.appliedChangesCustomDataKey);var a=this._getCustomData(c,m,k);if(a.customData){m.destroy(a.customData);}};
F.getCustomDataIdentifier=function(s,e,x){if(s){return F.appliedChangesCustomDataKey;}if(!e){return F.notApplicableChangesCustomDataKey;}if(x){return F.failedChangesCustomDataKeyXml;}return F.failedChangesCustomDataKeyJs;};
F._escapeCurlyBracketsInString=function(t){return t.replace(/{/g,'\\\{').replace(/}/g,'\\\}');};
F._getCustomDataKey=function(c,i){return i+"."+c.getId();};
F._writeCustomData=function(c,k,v,p){var m=this._getCustomData(c,p.modifier,k);if(!m.customData){this._createAndAddCustomDataControl(c,p,k,v);}else{p.modifier.setProperty(m.customData,"value",v);}};
F._createAndAddCustomDataControl=function(c,p,s,v){var m=p.modifier,V=p.view,o=p.appComponent;var a=m.createControl("sap.ui.core.CustomData",o,V,undefined,undefined,false);m.setProperty(a,"key",s);m.setProperty(a,"value",v);m.insertAggregation(c,"customData",a,0,V);return a;};
F._getCustomData=function(c,m,s){var a=m.getAggregation(c,"customData")||[];var r={};a.some(function(o){var k=m.getProperty(o,"key");if(k===s){r.customData=o;r.customDataValue=m.getProperty(o,"value");return true;}});return r;};
return F;},true);
sap.ui.predefine('sap/ui/fl/LrepConnector',["sap/ui/thirdparty/jquery","sap/ui/thirdparty/URI","sap/ui/fl/Utils","sap/base/util/merge"],function(q,u,F,b){"use strict";var L=function(p){this._initClientParam();this._initLanguageParam();if(p){this._sXsrfToken=p.XsrfToken;}};
L.createConnector=function(p){return new L(p);};
L._bServiceAvailability=undefined;L._oLoadSettingsPromise=undefined;L.prototype._sClient=undefined;L.prototype._sLanguage=undefined;L.prototype._aSentRequestListeners=[];L.prototype._sRequestUrlPrefix="";L.DEFAULT_CONTENT_TYPE="application/json; charset=utf-8";L.ROUTES={CONTENT:"/content/",CSRF:"/actions/getcsrftoken/",PUBLISH:"/actions/publish/",DATA:"/flex/data/",MODULES:"/flex/modules/",SETTINGS:"/flex/settings"};
L.isFlexServiceAvailable=function(){if(L._bServiceAvailability!==undefined){return Promise.resolve(L._bServiceAvailability);}return L.createConnector().loadSettings().then(function(){return Promise.resolve(L._bServiceAvailability);});};
L.prototype._getFlexibilityServicesUrlPrefix=function(){return sap.ui.getCore().getConfiguration().getFlexibilityServices();};
L.attachSentRequest=function(c){if(typeof c==="function"&&L.prototype._aSentRequestListeners.indexOf(c)===-1){L.prototype._aSentRequestListeners.push(c);}};
L.detachSentRequest=function(c){var i=L.prototype._aSentRequestListeners.indexOf(c);if(i!==-1){L.prototype._aSentRequestListeners.splice(i,1);}};
L.prototype._initClientParam=function(){var c=F.getClient();if(c){this._sClient=c;}};
L.prototype._initLanguageParam=function(){var l;l=F.getUrlParameter("sap-language")||F.getUrlParameter("sap-ui-language");if(l){this._sLanguage=l;}};
L.prototype.setRequestUrlPrefix=function(r){this._sRequestUrlPrefix=r;};
L.prototype._resolveUrl=function(r){if(!r.startsWith("/")){r="/"+r;}r=this._sRequestUrlPrefix+r;var U=u(r).absoluteTo("");return U.toString();};
L.prototype._getDefaultHeader=function(){return{headers:{"X-CSRF-Token":this._sXsrfToken||"fetch"}};};
L.prototype._getDefaultOptions=function(m,c,d){var o;if(!c){c=L.DEFAULT_CONTENT_TYPE;}else if(c.indexOf("charset")===-1){c+="; charset=utf-8";}o=b(this._getDefaultHeader(),{type:m,async:true,contentType:c,processData:false,headers:{"Content-Type":c}});if(d&&o.contentType.indexOf("application/json")===0){o.dataType="json";if(typeof d==="object"){o.data=JSON.stringify(d);}else{o.data=d;}}else if(d){o.data=d;}if(m==="DELETE"){delete o.data;delete o.contentType;}return o;};
L.prototype.send=function(U,m,d,o){m=m||"GET";m=m.toUpperCase();o=o||{};U=this._resolveUrl(U);o=b(this._getDefaultOptions(m,o.contentType,d),o);return this._sendAjaxRequest(U,o);};
L.prototype._getMessagesFromXHR=function(x){var a,m,l,i;m=[];try{a=JSON.parse(x.responseText);if(a&&a.messages&&a.messages.length>0){l=a.messages.length;for(i=0;i<l;i++){m.push({severity:a.messages[i].severity,text:a.messages[i].text});}}}catch(e){}return m;};
L.prototype._sendAjaxRequest=function(U,o){var f=this._getFlexibilityServicesUrlPrefix();if(!f){return Promise.reject({status:"warning",message:"Flexibility Services requests were not sent. The UI5 bootstrap is configured to not send any requests."});}var s=f+L.ROUTES.CSRF;var m={headers:{"X-CSRF-Token":"fetch"},type:"HEAD"};if(this._sClient){m.headers["sap-client"]=this._sClient;}return new Promise(function(r,a){function h(e,S,x){var n=x.getResponseHeader("X-CSRF-Token");this._sXsrfToken=n||this._sXsrfToken;var E=x.getResponseHeader("etag");var g={status:S,etag:E,response:e};r(g);q.each(this._aSentRequestListeners,function(i,C){C(g);});}function c(e,S,x){this._sXsrfToken=x.getResponseHeader("X-CSRF-Token");o.headers=o.headers||{};o.headers["X-CSRF-Token"]=this._sXsrfToken;q.ajax(U,o).done(h.bind(this)).fail(function(x,S,E){var g=new Error(E);g.status="error";g.code=x.statusCode().status;g.messages=this._getMessagesFromXHR(x);a(g);}.bind(this));}function d(x){if(x.status===403){q.ajax(s,m).done(c.bind(this)).fail(function(){a({status:"error"});});}else{if(o&&o.type==="DELETE"&&x.status===404){r();}else{var e;e={status:"error",code:x.statusCode().status,messages:this._getMessagesFromXHR(x)};a(e);}}}var R=true;if(o&&o.type){if(o.type==="GET"||o.type==="HEAD"){R=false;}else if(this._sXsrfToken&&this._sXsrfToken!=="fetch"){R=false;}}if(R){q.ajax(s,m).done(c.bind(this)).fail(function(x){a({status:"error",code:x.statusCode().status,messages:this._getMessagesFromXHR(x)});}.bind(this));}else{q.ajax(U,o).done(h.bind(this)).fail(d.bind(this));}}.bind(this));};
L.prototype.loadChanges=function(c,p){function _(c,p){var o={};if(p.cacheKey){o.cache=true;}if(p.siteId){if(!o.headers){o.headers={};}o.headers={"X-LRep-Site-Id":p.siteId};}if(p.appDescriptor){if(p.appDescriptor["sap.app"]){if(!o.headers){o.headers={};}o.headers={"X-LRep-AppDescriptor-Id":p.appDescriptor["sap.app"].id};}}return o;}function a(c,p,C){var U={};var f=this._getFlexibilityServicesUrlPrefix()+L.ROUTES.DATA;var s=this._getFlexibilityServicesUrlPrefix()+L.ROUTES.MODULES;var P="";if(p.cacheKey){P+="~"+p.cacheKey+"~/";}P+=c.name;if(p.layer){P+="&upToLayerType="+p.layer;}if(C){P+="&sap-client="+C;}if(c.appVersion&&(c.appVersion!==F.DEFAULT_APP_VERSION)){P+="&appVersion="+c.appVersion;}P=P.replace("&","?");U.flexDataUrl=U.flexDataUrl||f+P;U.flexModulesUrl=U.flexModulesUrl||s+P;return U;}p=p||{};if(!c.name){return Promise.reject(new Error("Component name not specified"));}var o=_(c,p);var U=a.call(this,c,p,this._sClient);return this.send(U.flexDataUrl,undefined,undefined,o).then(this._onChangeResponseReceived.bind(this,c.name,U.flexModulesUrl,p.cacheKey),function(e){if(e.code===404){L._bServiceAvailability=false;}throw(e);});};
L.prototype._onChangeResponseReceived=function(c,f,C,r){L._bServiceAvailability=true;if(r.etag===null){r.etag=C;}var m={changes:r.response,loadModules:r.response.loadModules,messagebundle:r.response.messagebundle,componentClassName:c,etag:r.etag};if(!m.loadModules){return m;}var o={"async":true,"contentType":"application/javascript","processData":true,"type":"GET"};return this.send(f,undefined,undefined,o).then(function(){return m;});};
L.prototype.loadSettings=function(){if(!L._oLoadSettingsPromise){var U=this._getFlexibilityServicesUrlPrefix()+L.ROUTES.SETTINGS;if(this._sClient){U+="?sap-client="+this._sClient;}L._oLoadSettingsPromise=this.send(U,undefined,undefined,{});}return L._oLoadSettingsPromise.then(function(r){L._bServiceAvailability=true;return r.response;},function(e){if(e.code===404){L._bServiceAvailability=false;}return Promise.resolve();});};
L.prototype._buildParams=function(p){if(!p){p=[];}if(this._sClient){p.push({name:"sap-client",value:this._sClient});}if(this._sLanguage){p.push({name:"sap-language",value:this._sLanguage});}var r="";var l=p.length;for(var i=0;i<l;i++){if(i===0){r+="?";}else if(i>0&&i<l){r+="&";}r+=p[i].name+"="+p[i].value;}return r;};
L.prototype._getUrlPrefix=function(i){if(i){return this._getFlexibilityServicesUrlPrefix()+"/variants/";}return this._getFlexibilityServicesUrlPrefix()+"/changes/";};
L.prototype.create=function(p,c,i){var r=this._getUrlPrefix(i);var P=[];if(c){P.push({name:"changelist",value:c});}r+=this._buildParams(P);return this.send(r,"POST",p,null);};
L.prototype.update=function(p,c,C,i){var r=this._getUrlPrefix(i);r+=c;var P=[];if(C){P.push({name:"changelist",value:C});}r+=this._buildParams(P);return this.send(r,"PUT",p,null);};
L.prototype.deleteChange=function(p,i){var r=this._getUrlPrefix(i);r+=p.sChangeName;var P=[];if(p.sLayer){P.push({name:"layer",value:p.sLayer});}if(p.sNamespace){P.push({name:"namespace",value:p.sNamespace});}if(p.sChangelist){P.push({name:"changelist",value:p.sChangelist});}r+=this._buildParams(P);return this.send(r,"DELETE",{},null);};
L.prototype.getStaticResource=function(n,N,t,i){var r=this._getFlexibilityServicesUrlPrefix()+L.ROUTES.CONTENT;r+=n+"/"+N+"."+t;var p=[];if(!i){p.push({name:"dt",value:"true"});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
L.prototype.getFileAttributes=function(n,N,t,l){var r=this._getFlexibilityServicesUrlPrefix()+L.ROUTES.CONTENT;r+=n+"/"+N+"."+t;var p=[];p.push({name:"metadata",value:"true"});if(l){p.push({name:"layer",value:l});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
L.prototype.upsert=function(n,N,t,l,c,C,s){var a=this;return Promise.resolve(a._fileAction("PUT",n,N,t,l,c,C,s));};
L.prototype.deleteFile=function(n,N,t,l,c){return this._fileAction("DELETE",n,N,t,l,null,null,c);};
L.prototype._fileAction=function(m,n,N,t,l,c,C,s){var r=this._getFlexibilityServicesUrlPrefix()+L.ROUTES.CONTENT;r+=n+"/"+N+"."+t;var p=[];p.push({name:"layer",value:l});if(s){p.push({name:"changelist",value:s});}r+=this._buildParams(p);var o={contentType:C||L.DEFAULT_CONTENT_TYPE};return this.send(r,m.toUpperCase(),c,o);};
L.prototype.publish=function(o,n,t,O,T,s,c){var r=this._getFlexibilityServicesUrlPrefix()+L.ROUTES.PUBLISH;r+=o+"/"+n+"."+t;var p=[];if(O){p.push({name:"layer",value:O});}if(T){p.push({name:"target-layer",value:T});}if(s){p.push({name:"target-namespace",value:s});}if(c){p.push({name:"changelist",value:c});}r+=this._buildParams(p);return this.send(r,"POST",{},null);};
L.prototype.listContent=function(n,l){var r=this._getFlexibilityServicesUrlPrefix()+L.ROUTES.CONTENT;r+=n;var p=[];if(l){p.push({name:"layer",value:l});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
return L;},true);
sap.ui.predefine('sap/ui/fl/Persistence',["sap/ui/fl/Change","sap/ui/fl/DefaultVariant","sap/ui/fl/StandardVariant","sap/ui/fl/Utils","sap/ui/fl/ChangePersistenceFactory"],function(C,d,s,U,a){"use strict";var P=function(c,S){this._oControl=c;this._sStableIdPropertyName=S||'id';this._sStableId=this._getStableId();this._sComponentName=U.getComponentClassName(c);if(!this._sComponentName){U.log.error("The Control does not belong to an SAPUI5 component. Variants and Changes for this control might not work as expected.");}this._oAppDescriptor=U.getAppDescriptor(c);this._sSiteId=U.getSiteId(c);this._oChangePersistence=a.getChangePersistenceForControl(this._oControl);this._oChanges={};};
P.prototype._getStableId=function(){if(!this._oControl){return undefined;}if((this._sStableIdPropertyName)&&(this._sStableIdPropertyName!=='id')){var S;try{S=this._oControl.getProperty(this._sStableIdPropertyName);}catch(e){S="";}return S;}if(typeof this._oControl.getId!=='function'){return undefined;}return this._oControl.getId();};
P.prototype.getChanges=function(){var p={appDescriptor:this._oAppDescriptor,siteId:this._sSiteId,includeVariants:true};if(!jQuery.isEmptyObject(this._oChanges)){return Promise.resolve(this._oChanges);}return this._oChangePersistence.getChangesForVariant(this._sStableIdPropertyName,this._sStableId,p).then(function(c){this._oChanges=c;return this._oChanges;}.bind(this));};
P.prototype.getChange=function(c){if(!c){U.log.error("sap.ui.fl.Persistence.getChange : sChangeId is not defined");return undefined;}return this._oChanges[c];};
P.prototype.addChange=function(p){return this._oChangePersistence.addChangeForVariant(this._sStableIdPropertyName,this._sStableId,p);};
P.prototype.getExecuteOnSelect=function(){return this.getChanges().then(function(c){return s.getExecuteOnSelect(c);});};
P.prototype.getExecuteOnSelectSync=function(){return s.getExecuteOnSelect(this._oChanges);};
P.prototype.setExecuteOnSelectSync=function(e){var p,c;var b={};b[this._sStableIdPropertyName]=this._sStableId;p={executeOnSelect:e,reference:this._sComponentName,selector:b};c=s.updateExecuteOnSelect(this._oChanges,e);if(c){return c;}c=s.createChangeObject(p);var f=c.getId();this._oChanges[f]=c;return c;};
P.prototype.getDefaultVariantId=function(){return this.getChanges().then(function(c){return d.getDefaultVariantId(c);});};
P.prototype.getDefaultVariantIdSync=function(){return d.getDefaultVariantId(this._oChanges);};
P.prototype.setDefaultVariantIdSync=function(D){var p,c;var b={};b[this._sStableIdPropertyName]=this._sStableId;p={defaultVariantId:D,reference:this._sComponentName,selector:b,validAppVersions:{creation:this._oChangePersistence._mComponent.appVersion,from:this._oChangePersistence._mComponent.appVersion}};c=d.updateDefaultVariantId(this._oChanges,D);if(c){return c;}c=d.createChangeObject(p);var e=c.getId();this._oChanges[e]=c;return c;};
P.prototype.saveAll=function(){return this._oChangePersistence.saveAllChangesForVariant(this._sStableId);};
P.prototype.isVariantDownport=function(){var l,i;l=U.getCurrentLayer();i=U.isHotfixMode();return((l==='VENDOR')&&(i));};
return P;},true);
sap.ui.predefine('sap/ui/fl/Preprocessor',['sap/ui/base/Object'],function(B){'use strict';return B.extend("sap.ui.fl.Preprocessor",{});},true);
sap.ui.predefine('sap/ui/fl/PreprocessorImpl',['sap/ui/core/Component','sap/ui/fl/Utils','sap/ui/fl/ChangePersistenceFactory',"sap/base/Log"],function(C,U,a,L){'use strict';
function i(c){return c.getChangeType()==="codeExt";}
function b(c,o){var s=o.getSelector().controllerName;return c===s;}
var P=function(){};
P.prototype.getControllerExtensions=function(c,s,A){if(A){if(!s){L.warning("No component ID for determining the anchor of the code extensions was passed.");return Promise.resolve([]);}var o=C.get(s);var d=U.getAppComponentForControl(o);if(!U.isApplication(d.getManifestObject())){return Promise.resolve([]);}var f=U.getComponentClassName(d);var e=U.getAppVersionFromManifest(d.getManifest());var g=a.getChangePersistenceForComponent(f,e);return g.getChangesForComponent().then(function(h){var E=h.filter(function(j){return i(j)&&b(c,j);}).map(function(j){return j.getModuleName();});return P.getExtensionModules(E);});}else{L.warning("Synchronous extensions are not supported by sap.ui.fl.PreprocessorImpl");return[];}};
P.getExtensionModules=function(c){if(c.length===0){return Promise.resolve([]);}return new Promise(function(r){sap.ui.require(c,function(){var m=Array.prototype.slice.call(arguments);r(m);},function(e){U.log.error("Code Extension not found",e.message);r([]);});});};
return P;},true);
sap.ui.predefine('sap/ui/fl/RegistrationDelegator',["sap/ui/fl/FlexControllerFactory","sap/ui/core/Component","sap/ui/fl/registry/ChangeHandlerRegistration","sap/ui/fl/ChangePersistenceFactory","sap/ui/core/mvc/Controller","sap/ui/core/mvc/XMLView","sap/ui/fl/EventHistory"],function(F,C,a,b,M,X,E){"use strict";var R={};
R.registerChangesInComponent=function(){C._fnOnInstanceCreated=F.getChangesAndPropagate;};
R.registerChangeHandlers=function(){a.getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs();};
R.registerLoadComponentEventHandler=function(){C._fnLoadComponentCallback=b._onLoadComponent.bind(b);};
R.registerExtensionProvider=function(){M.registerExtensionProvider("sap.ui.fl.PreprocessorImpl");};
R.registerXMLPreprocessor=function(){if(X.registerPreprocessor){X.registerPreprocessor("viewxml","sap.ui.fl.XmlPreprocessorImpl",true);}};
R.registerEventListener=function(){E.start();};
R.registerAll=function(){R.registerEventListener();R.registerChangeHandlers();R.registerLoadComponentEventHandler();R.registerExtensionProvider();R.registerChangesInComponent();R.registerXMLPreprocessor();};
return R;},true);
sap.ui.predefine('sap/ui/fl/StandardVariant',["sap/ui/fl/Change"],function(C){"use strict";var S=function(){};
S.prototype.getExecuteOnSelect=function(c){var a=this.getNewestStandardVariantChangeDeleteTheRest(c);if(a){return a.getContent().executeOnSelect;}return null;};
S.prototype.getNewestStandardVariantChangeDeleteTheRest=function(c){var d=this.getStandardVariantChanges(c).sort(function(a,b){var D=new Date(a.getCreation());var e=new Date(b.getCreation());if(isNaN(D.getDate())){return-1;}if(isNaN(e.getDate())){return 1;}return e-D;});var n=d.shift();d.forEach(function(o){o.markForDeletion();});return n;};
S.prototype.getStandardVariantChanges=function(c){if(!c||typeof c!=='object'){return[];}return Object.keys(c).map(a).filter(b);function a(s){return c[s];}function b(o){return o.getChangeType()==='standardVariant';}};
S.prototype.updateExecuteOnSelect=function(c,n){var N=this.getNewestStandardVariantChangeDeleteTheRest(c);if(N){var o=N.getContent();o.executeOnSelect=n;N.setContent(o);}return N;};
S.prototype._createChangeFile=function(p){var f;p.namespace=p.component+'/changes/standard';p.componentName=p.component;p.changeType='standardVariant';f=C.createInitialFileContent(p);f.content.executeOnSelect=p.executeOnSelect;f.layer='USER';return f;};
S.prototype.createChangeObject=function(p){var f,c;f=this._createChangeFile(p);c=new C(f);return c;};
return new S();},true);
sap.ui.predefine('sap/ui/fl/Utils',["sap/ui/thirdparty/jquery","sap/ui/core/Component","sap/ui/core/util/reflection/BaseTreeModifier","sap/ui/thirdparty/hasher","sap/base/Log","sap/base/util/UriParameters","sap/base/util/uid","sap/base/strings/formatMessage","sap/ui/base/ManagedObject","sap/ui/core/mvc/View"],function(q,C,B,h,L,U,u,f,M,V){"use strict";var l=["VENDOR","PARTNER","CUSTOMER_BASE","CUSTOMER","USER"];var m={};l.forEach(function(s,i){m[s]=i;});var a={_aLayers:l,_mLayersIndex:m,_sTopLayer:l[l.length-1],_sMaxLayer:l[l.length-1],DEFAULT_APP_VERSION:"DEFAULT_APP_VERSION",APP_ID_AT_DESIGN_TIME:"${pro"+"ject.art"+"ifactId}",log:{error:function(s,d,c){L.error(s,d,c);},warning:function(s,d,c){L.warning(s,d,c);},debug:function(s,d,c){L.debug(s,d,c);},info:function(s,d,c){L.info(s,d,c);}},formatAndLogMessage:function(s,b,v,c){var d=b.join(' ');d=f(d,v);this.log[s](d,c||"");},getXSRFTokenFromControl:function(c){var o;if(!c){return"";}if(c&&typeof c.getModel==="function"){o=c.getModel();return a._getXSRFTokenFromModel(o);}return"";},_getXSRFTokenFromModel:function(o){var H;if(!o){return"";}if(typeof o.getHeaders==="function"){H=o.getHeaders();if(H){return H["x-csrf-token"];}}return"";},getComponentClassName:function(c){var A;if(c){A=this.getAppComponentForControl(c);if(A){var v=this._getComponentStartUpParameter(A,"sap-app-id");if(v){return v;}if(A.getManifestEntry("sap.ui5")&&A.getManifestEntry("sap.ui5").appVariantId){return A.getManifestEntry("sap.ui5").appVariantId;}}}return a.getComponentName(A);},isVariantByStartupParameter:function(c){if(c){var A=this.getAppComponentForControl(c);if(A){return!!this._getComponentStartUpParameter(A,"sap-app-id");}}return false;},getAppComponentClassNameForComponent:function(c){return a.getComponentClassName(c);},getAppDescriptor:function(c){var o=null,b=null,d=null;if(c){b=this.getAppComponentForControl(c);if(b&&b.getMetadata){d=b.getMetadata();if(d&&d.getManifest){o=d.getManifest();}}}return o;},getSiteId:function(c){var s=null,A=null;if(c){A=this.getAppComponentForControl(c);if(A){s=this._getComponentStartUpParameter(A,"hcpApplicationId");}}return s;},getSiteIdByComponentData:function(c){var s=null;s=this._getStartUpParameter(c,"hcpApplicationId");return s;},isAppVariantMode:function(c){return(a.isVendorLayer()&&a.isApplicationVariant(c));},isBinding:function(p){var i=false;if(p&&typeof p==="string"&&p.substring(0,1)==="{"&&p.slice(-1)==="}"){i=true;}return i;},isVendorLayer:function(){if(a.getCurrentLayer(false)==="VENDOR"){return true;}return false;},isApplicationVariant:function(c){var F=a.getComponentClassName(c);var A=a.getAppComponentForControl(c);var s=a.getComponentName(A);return F!==s;},setMaxLayerParameter:function(s){this._sMaxLayer=s||this._sTopLayer;},getLayerIndex:function(s){return this._mLayersIndex[s];},isOverMaxLayer:function(s){return(this.getLayerIndex(s)>this.getLayerIndex(this._sMaxLayer));},compareAgainstCurrentLayer:function(s,c){var b=c||a.getCurrentLayer(false);if((this.getLayerIndex(b)>this.getLayerIndex(s))||!s){return-1;}else if(this.getLayerIndex(b)===this.getLayerIndex(s)){return 0;}else{return 1;}},isLayerFilteringRequired:function(){return!(this._sTopLayer===this._sMaxLayer);},_getComponentStartUpParameter:function(c,p){var s=null;if(p){if(c&&c.getComponentData){s=this._getStartUpParameter(c.getComponentData(),p);}}return s;},_getStartUpParameter:function(c,p){if(c&&c.startupParameters&&p){if(Array.isArray(c.startupParameters[p])){return c.startupParameters[p][0];}}},getComponentName:function(c){var s="";if(c){s=c.getMetadata().getName();}if(s.length>0&&s.indexOf(".Component")<0){s+=".Component";}return s;},_getComponent:function(c){var o;if(c){o=C.get(c);}return o;},_getComponentIdForControl:function(c){var s=a._getOwnerIdForControl(c);if(!s){if(c&&typeof c.getParent==="function"){return a._getComponentIdForControl(c.getParent());}}return s||"";},getComponentForControl:function(c){return a._getComponentForControl(c);},getAppComponentForControl:function(c){var o=c instanceof C?c:this._getComponentForControl(c);return this._getAppComponentForComponent(o);},_getComponentForControl:function(c){var o=null;var s=null;if(c){s=a._getComponentIdForControl(c);if(s){o=a._getComponent(s);}}return o;},_getAppComponentForComponent:function(c){var s=null;if(c&&c.getAppComponent){return c.getAppComponent();}if(c&&c.oComponentData&&c.oComponentData.appComponent){return c.oComponentData.appComponent;}if(c&&c.getManifestEntry){s=c.getManifestEntry("sap.app");}else{return c;}if(s&&s.type&&s.type!=="application"){if(c instanceof C){c=this._getComponentForControl(c);}return this.getAppComponentForControl(c);}return c;},getViewForControl:function(c){return a.getFirstAncestorOfControlWithControlType(c,sap.ui.core.mvc.View);},getFirstAncestorOfControlWithControlType:function(c,b){if(c instanceof b){return c;}if(c&&typeof c.getParent==="function"){c=c.getParent();return a.getFirstAncestorOfControlWithControlType(c,b);}},hasControlAncestorWithId:function(c,A){var o;if(c===A){return true;}o=sap.ui.getCore().byId(c);while(o){if(o.getId()===A){return true;}if(typeof o.getParent==="function"){o=o.getParent();}else{return false;}}return false;},_isView:function(c){return c instanceof V;},_getOwnerIdForControl:function(c){return C.getOwnerIdFor(c);},getCurrentLayer:function(i){var o,b;if(i){return"USER";}o=this._getUriParameters();b=o.mParams["sap-ui-layer"];if(b&&b.length>0){return b[0];}return"CUSTOMER";},doesSharedVariantRequirePackage:function(){var c;c=a.getCurrentLayer(false);if((c==="VENDOR")||(c==="PARTNER")||(c==="CUSTOMER_BASE")){return true;}return false;},getClient:function(){var o,c;o=this._getUriParameters();c=o.mParams["sap-client"];if(c&&c.length>0){return c[0];}return undefined;},_getUriParameters:function(){return new U(window.location.href);},isHotfixMode:function(){var o,i,I;o=this._getUriParameters();i=o.mParams["hotfix"];if(i&&i.length>0){I=i[0];}return(I==="true");},convertBrowserLanguageToISO639_1:function(b){if(!b||typeof b!=="string"){return"";}var n=b.indexOf("-");if((n<0)&&(b.length<=2)){return b.toUpperCase();}if(n>0&&n<=2){return b.substring(0,n).toUpperCase();}return"";},getCurrentLanguage:function(){var s=sap.ui.getCore().getConfiguration().getLanguage();return a.convertBrowserLanguageToISO639_1(s);},getControlType:function(c){var o;if(c&&typeof c.getMetadata==="function"){o=c.getMetadata();if(o&&typeof o.getElementName==="function"){return o.getElementName();}}},asciiToString:function(b){var c=b.split(",");var p="";q.each(c,function(i,d){p+=String.fromCharCode(d);});return p;},stringToAscii:function(s){var b="";for(var i=0;i<s.length;i++){b+=s.charCodeAt(i)+",";}b=b.substring(0,b.length-1);return b;},checkControlId:function(c,A,s){if(!A){c=c instanceof M?c:sap.ui.getCore().byId(c);A=a.getAppComponentForControl(c);}return B.checkControlId(c,A,s);},hasLocalIdSuffix:B.hasLocalIdSuffix,_getAllUrlParameters:function(){return window.location.search.substring(1);},getTechnicalParametersForComponent:function(c){return c&&c.getComponentData&&c.getComponentData()&&c.getComponentData().technicalParameters;},getParsedURLHash:function(){var o=a.getUshellContainer();if(o){var b=o.getService("URLParsing");var p=b.parseShellHash(h.getHash());return p?p:{};}return{};},setTechnicalURLParameterValues:function(c,p,v){var P=a.getParsedURLHash(p);if(P.params){h.changed.active=false;var t=a.getTechnicalParametersForComponent(c);if(!t){this.log.warning("Component instance not provided, so technical parameters in component data and browser history remain unchanged");}if(v.length===0){delete P.params[p];t&&delete t[p];}else{P.params[p]=v;t&&(t[p]=v);}h.replaceHash(a.getUshellContainer().getService("URLParsing").constructShellHash(P));h.changed.active=true;}},isDebugEnabled:function(){var o=this._getUriParameters();var d=o.get("sap-ui-debug")||"";if(sap.ui.getCore().getConfiguration().getDebug()||d==="true"){return true;}var D=d.split(",");return D.indexOf("sap/ui/fl")!==-1||D.indexOf("sap/ui/fl/")!==-1;},getUrlParameter:function(p){return new U(window.location.href).get(p);},getUshellContainer:function(){return sap.ushell&&sap.ushell.Container;},createDefaultFileName:function(n){var F=u().replace(/-/g,"_");if(n){F+='_'+n;}return F;},createNamespace:function(p,s){var r=p.reference.replace('.Component','');var n='apps/'+r+"/"+s+"/";return n;},buildLrepRootNamespace:function(b,s,p){var r="apps/";var e=new Error("Error in sap.ui.fl.Utils#buildLrepRootNamespace: ");if(!b){e.message+="for every scenario you need a base ID";throw e;}switch(s){case sap.ui.fl.Scenario.AppVariant:if(!p){e.message+="in an app variant scenario you additionaly need a project ID";throw e;}r+=b+"/appVariants/"+p+"/";break;case sap.ui.fl.Scenario.AdaptationProject:if(!p){e.message+="in a adaptation project scenario you additionaly need a project ID";throw e;}r+=b+"/adapt/"+p+"/";break;case sap.ui.fl.Scenario.FioriElementsFromScratch:case sap.ui.fl.Scenario.UiAdaptation:default:r+=b+"/";}return r;},isApplication:function(o){return(o&&o.getEntry&&o.getEntry("sap.app")&&o.getEntry("sap.app").type==="application");},isEmbeddedComponent:function(c){return c instanceof C&&!!c.getManifestEntry("sap.app")&&c.getManifestEntry("sap.app").type==="component";},getFlexReference:function(o){if(o){if(o.getEntry("sap.ui5")){if(o.getEntry("sap.ui5").appVariantId){return o.getEntry("sap.ui5").appVariantId;}if(o.getEntry("sap.ui5").componentName){return o.getEntry("sap.ui5").componentName+".Component";}}if(o.getEntry("sap.app")&&o.getEntry("sap.app").id){var A=o.getEntry("sap.app").id;if(A===a.APP_ID_AT_DESIGN_TIME&&o.getComponentName){A=o.getComponentName();}return A+".Component";}}this.log.warning("No Manifest received.");return"";},getAppVersionFromManifest:function(o){var v="";if(o){var s=(o.getEntry)?o.getEntry("sap.app"):o["sap.app"];if(s&&s.applicationVersion&&s.applicationVersion.version){v=s.applicationVersion.version;}}else{this.log.warning("No Manifest received.");}return v;},getODataServiceUriFromManifest:function(o){var s="";if(o){var S=(o.getEntry)?o.getEntry("sap.app"):o["sap.app"];if(S&&S.dataSources&&S.dataSources.mainService&&S.dataSources.mainService.uri){s=S.dataSources.mainService.uri;}}else{this.log.warning("No Manifest received.");}return s;},isCorrectAppVersionFormat:function(v){v=v.replace(/\s/g,"");var r=/\b\d{1,5}(.\d{1,5}){0,2}/g;var R=/\b\d{1,5}(\.\d{1,5}){0,2}/g;var n=v.match(r)?v.match(r)[0].length:0;var b=v.match(R)?v.match(R)[0].length:0;if(b<1||b!=n){return false;}if(b&&v!=v.substr(0,b)){var c=v.substr(b,1);var o=/^[0-9.]$/;if(o.test(c)){return false;}}var d=v.substr(0,b).split(".");if(d.length>3){return false;}if(!d.every(function(p){return p.length<=5;})){return false;}return true;},isCustomerDependentLayer:function(s){return(["CUSTOMER","CUSTOMER_BASE"].indexOf(s)>-1);},indexOfObject:function(A,o){var O=-1;A.some(function(b,i){var k,K;if(!b){k=[];}else{k=Object.keys(b);}if(!o){K=[];}else{K=Object.keys(o);}var s=k.length===K.length;var c=s&&!k.some(function(d){return b[d]!==o[d];});if(c){O=i;}return c;});return O;},execPromiseQueueSequentially:function(p,t,A){if(p.length===0){if(A){return Promise.resolve();}return new a.FakePromise();}var P=p.shift();if(typeof P==="function"){try{var r=P();}catch(e){r=Promise.reject(e);}return r.then(function(){if(!A&&r instanceof Promise){A=true;}}).catch(function(e){var E="Error during execPromiseQueueSequentially processing occured";E+=e?": "+e.message:"";this.log.error(E);if(t){throw new Error(E);}}.bind(this)).then(function(){return this.execPromiseQueueSequentially(p,t,A);}.bind(this));}else{this.log.error("Changes could not be applied, promise not wrapped inside function.");return this.execPromiseQueueSequentially(p,t,A);}},FakePromise:function(i,e,I){a.FakePromise.fakePromiseIdentifier="sap.ui.fl.Utils.FakePromise";this.vValue=i;this.vError=e;this.bContinueWithFakePromise=arguments.length<3||(I===a.FakePromise.fakePromiseIdentifier);a.FakePromise.prototype.then=function(b){if(!this.bContinueWithFakePromise){return Promise.resolve(b(this.vValue));}if(!this.vError){try{this.vValue=b(this.vValue,a.FakePromise.fakePromiseIdentifier);}catch(E){this.vError=E;this.vValue=null;return this;}if(this.vValue instanceof Promise||this.vValue instanceof a.FakePromise){return this.vValue;}}return this;};a.FakePromise.prototype.catch=function(b){if(!this.bContinueWithFakePromise){return Promise.reject(b(this.vError));}if(this.vError){try{this.vValue=b(this.vError,a.FakePromise.fakePromiseIdentifier);}catch(E){this.vError=E;this.vValue=null;return this;}this.vError=null;if(this.vValue instanceof Promise||this.vValue instanceof a.FakePromise){return this.vValue;}}return this;};if(this.vValue instanceof Promise||this.vValue instanceof a.FakePromise){return this.vValue;}},getChangeFromChangesMap:function(c,s){var r;Object.keys(c).forEach(function(b){c[b].some(function(o){if(o.getId()===s){r=o;return true;}});});return r;}};return a;},true);
sap.ui.predefine('sap/ui/fl/Variant',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/base/util/merge"],function(q,M,U,S,b){"use strict";
var V=M.extend("sap.ui.fl.Variant",{
constructor:function(f){M.apply(this);if(!q.isPlainObject(f)){U.log.error("Constructor : sap.ui.fl.Variant : oFile is not defined");}this._oDefinition=f;this._oOriginDefinition=b({},f);this._sRequest='';this._bUserDependent=(f.content.layer==="USER");this._vRevertData=null;this.setState(V.states.NEW);},
metadata:{properties:{state:{type:"string"}}}
});
V.states={NEW:"NEW",PERSISTED:"NONE",DELETED:"DELETE",DIRTY:"UPDATE"};V.events={markForDeletion:"markForDeletion"};
V.prototype.setState=function(s){if(this._isValidState(s)){this.setProperty("state",s);}return this;};
V.prototype._isValidState=function(s){var a=false;Object.keys(V.states).some(function(k){if(V.states[k]===s){a=true;}return a;});if(!a){return false;}if((this.getState()===V.states.NEW)&&(s===V.states.DIRTY)){return false;}return true;};
V.prototype.isValid=function(){var i=true;if(typeof(this._oDefinition)!=="object"){i=false;}if(!this._oDefinition.content.fileType||this._oDefinition.content.fileType!=="ctrl_variant"){i=false;}if(!this._oDefinition.content.fileName){i=false;}if(!this._oDefinition.content.content.title){i=false;}if(!this._oDefinition.content.variantManagementReference){i=false;}if(!this._oDefinition.content.layer){i=false;}if(!this._oDefinition.content.originalLanguage){i=false;}return i;};
V.prototype.isVariant=function(){return true;};
V.prototype.getDefinitionWithChanges=function(){return this._oDefinition;};
V.prototype.getTitle=function(){if(this._oDefinition){return this._oDefinition.content.content.title;}};
V.prototype.getFileType=function(){if(this._oDefinition){return this._oDefinition.content.fileType;}};
V.prototype.getControlChanges=function(){return this._oDefinition.controlChanges;};
V.prototype.getOriginalLanguage=function(){if(this._oDefinition&&this._oDefinition.content.originalLanguage){return this._oDefinition.content.originalLanguage;}return"";};
V.prototype.getPackage=function(){return this._oDefinition.content.packageName;};
V.prototype.getNamespace=function(){return this._oDefinition.content.namespace;};
V.prototype.setNamespace=function(n){this._oDefinition.content.namespace=n;};
V.prototype.getId=function(){return this._oDefinition.content.fileName;};
V.prototype.getContent=function(){return this._oDefinition.content.content;};
V.prototype.setContent=function(c){this._oDefinition.content.content=c;this.setState(V.states.DIRTY);};
V.prototype.getVariantManagementReference=function(){return this._oDefinition.content.variantManagementReference;};
V.prototype.getVariantReference=function(){return this._oDefinition.content.variantReference;};
V.prototype.getOwnerId=function(){return this._oDefinition.content.support?this._oDefinition.content.support.user:"";};
V.prototype.getText=function(t){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Variant.getTexts : sTextId is not defined");}if(this._oDefinition.content.texts){if(this._oDefinition.content.texts[t]){return this._oDefinition.content.texts[t].value;}}return"";};
V.prototype.setText=function(t,n){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Variant.setTexts : sTextId is not defined");return;}if(this._oDefinition.content.texts){if(this._oDefinition.content.texts[t]){this._oDefinition.content.texts[t].value=n;this.setState(V.states.DIRTY);}}};
V.prototype.isReadOnly=function(){return this._isReadOnlyDueToLayer()||this._isReadOnlyWhenNotKeyUser();};
V.prototype._isReadOnlyWhenNotKeyUser=function(){if(this.isUserDependent()){return false;}var r=this.getDefinition().reference;if(!r){return true;}var s=S.getInstanceOrUndef();if(!s){return true;}return!s.isKeyUser();};
V.prototype._isReadOnlyDueToLayer=function(){var c;c=U.getCurrentLayer(this._bUserDependent);return(this._oDefinition.content.layer!==c);};
V.prototype._isReadOnlyDueToOriginalLanguage=function(){var c,o;o=this.getOriginalLanguage();if(!o){return false;}c=U.getCurrentLanguage();return(c!==o);};
V.prototype.markForDeletion=function(){this.setState(V.states.DELETED);};
V.prototype.setRequest=function(r){if(typeof(r)!=="string"){U.log.error("sap.ui.fl.Variant.setRequest : sRequest is not defined");}this._sRequest=r;};
V.prototype.getRequest=function(){return this._sRequest;};
V.prototype.getLayer=function(){return this._oDefinition.content.layer;};
V.prototype.getComponent=function(){return this._oDefinition.content.reference;};
V.prototype.setComponent=function(c){this._oDefinition.content.reference=c;};
V.prototype.getCreation=function(){return this._oDefinition.content.creation;};
V.prototype.isUserDependent=function(){return(this._bUserDependent);};
V.prototype.getPendingAction=function(){return this.getState();};
V.prototype.getDefinition=function(){return this._oDefinition.content;};
V.prototype.setResponse=function(r){var R=JSON.stringify(r);if(R){this._oDefinition=JSON.parse(R);this._oOriginDefinition=JSON.parse(R);this.setState(V.states.PERSISTED);}};
V.prototype.getFullFileIdentifier=function(){var l=this.getLayer();var n=this.getNamespace();var f=this.getDefinition().content.fileName;var F=this.getDefinition().content.fileType;return l+"/"+n+"/"+f+"."+F;};
V.prototype.getRevertData=function(){return this._vRevertData;};
V.prototype.setRevertData=function(d){this._vRevertData=d;};
V.prototype.resetRevertData=function(){this.setRevertData(null);};
V.createInitialFileContent=function(p){if(!p){p={};}var f=p.content.fileName||U.createDefaultFileName();var n=p.content.namespace||U.createNamespace(p.content,"variants");var N={content:{fileName:f,fileType:"ctrl_variant",variantManagementReference:p.content.variantManagementReference,variantReference:p.content.variantReference||"",reference:p.content.reference||"",packageName:p.content.packageName||"",content:{title:p.content.content.title||""},self:n+f+"."+"ctrl_variant",layer:p.content.layer||U.getCurrentLayer(p.isUserDependent),texts:p.content.texts||{},namespace:n,creation:"",originalLanguage:U.getCurrentLanguage(),conditions:{},support:{generator:p.generator||"Change.createInitialFileContent",service:p.service||"",user:"",sapui5Version:sap.ui.version},validAppVersions:p.content.validAppVersions||{}},controlChanges:p.controlChanges||[],variantChanges:{}};return N;};
return V;},true);
sap.ui.predefine('sap/ui/fl/XmlPreprocessorImpl',["sap/ui/core/Component","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Utils","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/ChangePersistence"],function(C,F,U,a,b){"use strict";var X=function(){};
X.process=function(v,p){try{if(!p||p.sync){U.log.warning("Flexibility feature for applying changes on an XML view is only available for "+"asynchronous views; merge is be done later on the JS controls.");return(v);}p.viewId=p.id;var c=C.get(p.componentId);if(!c){U.log.warning("View is generated without a component. Flexibility features are not possible.");return Promise.resolve(v);}var A=U.getAppComponentForControl(c);if(!U.isApplication(A.getManifestObject())){return Promise.resolve(v);}var f=U.getComponentClassName(A);var s=U.getAppVersionFromManifest(A.getManifest());var o=F.create(f,s);return o.processXmlView(v,p).then(function(){U.log.debug("flex processing view "+p.id+" finished");return v;}).catch(function(){U.log.warning("Error happens when getting flex cache key! flexibility XML view preprocessing is skipped. "+"The processing will be done later on the JS controls.");return Promise.resolve(v);});}catch(e){var E="view "+p.id+": "+e;U.log.info(E);return Promise.resolve(v);}};
X.getCacheKey=function(p){var c=C.get(p.componentId);var A=U.getAppComponentForControl(c);if(U.isVariantByStartupParameter(A)){return Promise.resolve();}var f=U.getComponentClassName(A);var s=U.getAppVersionFromManifest(A.getManifest());var o=a.getChangePersistenceForComponent(f,s);return o.getCacheKey(A);};
return X;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/AddXML',["sap/ui/fl/changeHandler/Base","sap/ui/fl/Utils","sap/base/util/LoaderExtensions"],function(B,U,L){"use strict";var A={};var d=function(c){c.forEach(function(C){if(C.destroy){C.destroy();}});};
A.applyChange=function(c,C,p){var m=p.modifier;var o=c.getDefinition();var M=c.getModuleName();var a=o.content.targetAggregation;if(!M){throw new Error("The module name of the fragment is not set. This should happen in the backend");}var f=L.loadResource(M,{dataType:"text"});var i=o.content.index;var v=p.view;var n=c.getProjectId();var N;try{N=m.instantiateFragment(f,n,v);}catch(e){throw new Error("The following XML Fragment could not be instantiated: "+f+" Reason: "+e.message);}var b=m.findAggregation(C,a);if(!b){d(N);throw new Error("The given Aggregation is not available in the given control: "+m.getId(C));}N.forEach(function(g,I){if(!m.validateType(g,b,C,f,I)){d(N);throw new Error("The content of the xml fragment does not match the type of the targetAggregation: "+b.type);}});N.forEach(function(g,I){m.insertAggregation(C,a,g,i+I,v);});c.setRevertData(N.map(function(g){return m.getId(g);}));return true;};
A.revertChange=function(c,C,p){var m=p.modifier;var o=c.getDefinition();var a=o.content.targetAggregation;var v=p.view||U.getViewForControl(C);var b=p.appComponent;var r=c.getRevertData()||[];var e=r.map(function(i){return m.bySelector(i,b,v)||v&&v.createId&&m.bySelector(v.createId(i));});e.forEach(function(f){m.removeAggregation(C,a,f);});d(e);c.resetRevertData();return true;};
A.completeChangeContent=function(c,s){var C=c.getDefinition();var _=function(a){throw new Error("Attribute missing from the change specific content'"+a+"'");};if(!C.content){C.content={};}if(s.fragmentPath){C.content.fragmentPath=s.fragmentPath;}else{_("fragmentPath");}if(s.targetAggregation){C.content.targetAggregation=s.targetAggregation;}else{_("targetAggregation");}if(s.index!==undefined){C.content.index=s.index;}else{_("index");}var g=function(C){var m=C.reference.replace(/\./g,"/");m+="/$$flexModules/";m+=C.validAppVersions.creation;m+="/changes/";m+=C.content.fragmentPath.replace(/\.fragment\.xml/g,"");return m;};var m=g(C);c.setModuleName(m);};
return A;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/Base',function(){"use strict";var B={};
B.setTextInChange=function(c,k,t,T){if(!c.texts){c.texts={};}if(!c.texts[k]){c.texts[k]={};}c.texts[k].value=t;c.texts[k].type=T;};
B.markAsNotApplicable=function(n,a){var r={message:n};if(!a){throw r;}return Promise.reject(r);};
return B;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/BaseRename',["sap/ui/fl/changeHandler/Base","sap/ui/fl/Utils"],function(B,U){"use strict";var a={createRenameChangeHandler:function(r){r.changePropertyName=r.changePropertyName||"newText";return{applyChange:function(c,C,p){var m=p.modifier;var P=r.propertyName;var o=c.getDefinition();var t=o.texts[r.changePropertyName];var v=t.value;if(o.texts&&t&&typeof(v)==="string"){c.setRevertData(m.getProperty(C,P));if(U.isBinding(v)){m.setPropertyBinding(C,P,v);}else{m.setProperty(C,P,v);}return true;}else{U.log.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}},revertChange:function(c,C,p){var o=c.getRevertData();if(o||o===""){var m=p.modifier;var P=r.propertyName;m.setProperty(C,P,o);c.resetRevertData();return true;}else{U.log.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.");}},completeChangeContent:function(c,s,p){var C=c.getDefinition();var b=r.changePropertyName;var t=r.translationTextType;var o=p.modifier.bySelector(c.getSelector(),p.appComponent);C.content.originalControlType=p.modifier.getControlType(o);if(typeof(s.value)==="string"){B.setTextInChange(C,b,s.value,t);}else{throw new Error("oSpecificChangeInfo.value attribute required");}}};}};return a;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/BaseTreeModifier',["sap/ui/core/util/reflection/BaseTreeModifier"],function(B){"use strict";return B;});
sap.ui.predefine('sap/ui/fl/changeHandler/ChangeHandlerMediator',["sap/ui/thirdparty/jquery","sap/base/Log","sap/base/strings/capitalize"],function(q,L,c){"use strict";var C={};C._aChangeHandlerSettings=[];["addODataField","addODataFieldWithLabel"].forEach(function(s){["2.0","1.0"].forEach(function(v){C._aChangeHandlerSettings.push({key:{"scenario":s,"oDataServiceVersion":v},content:{"requiredLibraries":{"sap.ui.comp":{"minVersion":"1.48","lazy":false}}},scenarioInitialized:false});});});
C.addChangeHandlerSettings=function(k,s){var n;if(!(k&&s)){throw new Error('New entry in ChangeHandlerMediator requires a key and settings');}n={key:k,content:s,scenarioInitialized:false};var e=this.getChangeHandlerSettings(k,true);var i=this._aChangeHandlerSettings.indexOf(e);if(i>-1){Object.assign(this._aChangeHandlerSettings[i].content,n.content);this._aChangeHandlerSettings[i].scenarioInitialized=false;}else{this._aChangeHandlerSettings.push(n);this._createChangeHandlerSettingsGetter(n);}};
C.getChangeHandlerSettings=function(k,s){var K=Object.keys(k);var f;if(K.length>0){f=this._aChangeHandlerSettings.filter(function(e,i){var E=Object.keys(e.key);if(E.length===K.length){var m=K.filter(function(a){if(e.key[a]===k[a]){return true;}});if(m.length===K.length){return true;}}})[0];if(!s&&f&&!f.scenarioInitialized){f.scenarioInitialized=this._initializeScenario(f);}}if(s||(f&&f.scenarioInitialized)){return f;}};
C._initializeScenario=function(f){var l;if(f.content.requiredLibraries){try{var a=Object.keys(f.content.requiredLibraries);a.forEach(function(s){l=s;sap.ui.getCore().loadLibrary(s);});var i=this._aChangeHandlerSettings.indexOf(f);this._aChangeHandlerSettings[i].scenarioInitialized=true;return true;}catch(e){L.warning("Required library not available: "+l+" - "+f.key.scenario+" could not be initialized");return false;}}};
C._createChangeHandlerSettingsGetter=function(m){var g='get'+c(m.key.scenario)+'Settings';if(!C[g]){C[g]=function(o){var O;var f;try{O=o.getModel().getMetaModel().getProperty("/dataServices/dataServiceVersion");}catch(e){L.warning("Data service version could not be retrieved");}f=this.getChangeHandlerSettings({"scenario":m.key.scenario,"oDataServiceVersion":O});if(f&&f.content&&f.content.createFunction){return f;}};}};
C._aChangeHandlerSettings.forEach(function(m){C._createChangeHandlerSettingsGetter(m);});return C;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/HideControl',["sap/base/Log"],function(L){"use strict";var H={};
H.applyChange=function(c,C,p){c.setRevertData({originalValue:p.modifier.getVisible(C)});p.modifier.setVisible(C,false);return true;};
H.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setVisible(C,r.originalValue);c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
H.completeChangeContent=function(c,s){};
return H;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/JsControlTreeModifier',["sap/ui/core/util/reflection/JsControlTreeModifier"],function(J){"use strict";return J;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/MoveControls',["./Base","sap/ui/fl/Utils"],function(B,F){"use strict";var M={};M.SOURCE_ALIAS="source";M.TARGET_ALIAS="target";M.MOVED_ELEMENTS_ALIAS="movedElements";
M._checkConditions=function(c,m,v,a){if(!c){throw new Error("No change instance");}var C=c.getContent();if(!C||!C.movedElements||C.movedElements.length===0){throw new Error("Change format invalid");}if(!C.source||!C.source.selector){throw new Error("No source supplied for move");}if(!C.target||!C.target.selector){throw new Error("No target supplied for move");}if(!m.bySelector(C.source.selector,a,v)){throw new Error("Move source parent not found");}if(!m.bySelector(C.target.selector,a,v)){throw new Error("Move target parent not found");}if(!C.source.selector.aggregation){throw new Error("No source aggregation supplied for move");}if(!C.target.selector.aggregation){throw new Error("No target aggregation supplied for move");}};
M._getElementControlOrThrowError=function(m,o,a,v){if(!m.selector&&!m.id){throw new Error("Change format invalid - moveElements element has no id attribute");}if(typeof m.targetIndex!=="number"){throw new Error("Missing targetIndex for element with id '"+m.selector.id+"' in movedElements supplied");}var c=o.bySelector(m.selector||m.id,a,v);if(!c){throw new Error("Control to move was not found. Id: '"+m.selector.id+"'");}return c;};
M._checkCompleteChangeContentConditions=function(s){if(!s.movedElements){throw new Error("mSpecificChangeInfo.movedElements attribute required");}if(s.movedElements.length===0){throw new Error("MovedElements array is empty");}s.movedElements.forEach(function(e){if(!e.id){throw new Error("MovedControls element has no id attribute");}if(typeof(e.sourceIndex)!=="number"){throw new Error("SourceIndex attribute at MovedElements element is no number");}if(typeof(e.targetIndex)!=="number"){throw new Error("TargetIndex attribute at MovedElements element is no number");}});};
M._getSpecificChangeInfo=function(m,s,a){delete s.source.publicAggregation;delete s.target.publicAggregation;var S=s.source.parent||m.bySelector(s.source.id,a);var t=s.target.parent||m.bySelector(s.target.id,a);var b=s.source.aggregation;var T=s.target.aggregation;var A={aggregation:s.source.aggregation,type:m.getControlType(S)};var c={aggregation:s.target.aggregation,type:m.getControlType(t)};var d={source:{id:S.getId(),aggregation:b,type:A.type,selector:m.getSelector(s.source.id,a,A)},target:{id:t.getId(),aggregation:T,type:c.type,selector:m.getSelector(s.target.id,a,c)},movedElements:s.movedElements};return d;};
M.applyChange=function(c,r,p){var m=p.modifier;var v=p.view;var a=p.appComponent;this._checkConditions(c,m,v,a);var C=c.getContent();var s=p.sourceAggregation||C.source.selector.aggregation;var t=m.bySelector(C.target.selector,a,v);var T=p.targetAggregation||C.target.selector.aggregation;var R=[];C.movedElements.forEach(function(b,e){var o=this._getElementControlOrThrowError(b,m,a,v);var S=m.getParent(o);var i=b.targetIndex;var I=m.findIndexInParentAggregation(o);if(I>-1){s=p.sourceAggregation||m.getParentAggregationName(o,S);if(I===i){I=b.sourceIndex;}R.unshift({index:I,aggregation:s,sourceParentId:m.getId(S)});}m.removeAggregation(S,s,o);m.insertAggregation(t,T,o,i,v);},this);c.setRevertData(R);return true;};
M.revertChange=function(c,r,p){var m=p.modifier;var v=p.view;var a=p.appComponent;this._checkConditions(c,m,v,a);var C=c.getContent();var s=m.bySelector(C.source.selector,a,v);var S=C.source.selector.aggregation;var t=m.bySelector(C.target.selector,a,v);var T=C.target.selector.aggregation;var R=c.getRevertData();c.getContent().movedElements.reverse();C.movedElements.forEach(function(b,e){var o=this._getElementControlOrThrowError(b,m,a,v);if(!o){F.log.warning("Element to move not found");return;}var i=b.sourceIndex;if(R){var d=R[e];S=d.aggregation;i=d.index;s=m.byId(d.sourceParentId,v);}m.removeAggregation(t,T,o);m.insertAggregation(s,S,o,i,v);},this);c.resetRevertData();return true;};
M.completeChangeContent=function(c,s,p){this._checkCompleteChangeContentConditions(s);var m=p.modifier;var a=p.appComponent;var C=c.getDefinition();s=this._getSpecificChangeInfo(m,s,a);C.content={movedElements:[],source:{selector:s.source.selector},target:{selector:s.target.selector}};s.movedElements.forEach(function(e){var E=e.element||m.bySelector(e.id,a);C.content.movedElements.push({selector:m.getSelector(E,a),sourceIndex:e.sourceIndex,targetIndex:e.targetIndex});});c.addDependentControl(s.source.id,M.SOURCE_ALIAS,p);c.addDependentControl(s.target.id,M.TARGET_ALIAS,p);c.addDependentControl(s.movedElements.map(function(e){return e.id;}),M.MOVED_ELEMENTS_ALIAS,p);};
return M;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/MoveElements',["sap/ui/fl/changeHandler/Base","sap/ui/fl/Utils"],function(B,F){"use strict";var M={};M.CHANGE_TYPE="moveElements";
M.applyChange=function(c,s,p){function a(c,m,v,A){if(!c){throw new Error("No change instance");}var C=c.getContent();if(!C||!C.movedElements||C.movedElements.length===0){throw new Error("Change format invalid");}if(!c.getSelector().aggregation){throw new Error("No source aggregation supplied via selector for move");}if(!C.target||!C.target.selector){throw new Error("No target supplied for move");}if(!m.bySelector(C.target.selector,A,v)){throw new Error("Move target parent not found");}if(!C.target.selector.aggregation){throw new Error("No target aggregation supplied for move");}}function g(b,m,A,v){if(!b.selector&&!b.id){throw new Error("Change format invalid - moveElements element has no id attribute");}if(typeof b.targetIndex!=="number"){throw new Error("Missing targetIndex for element with id '"+b.selector.id+"' in movedElements supplied");}return m.bySelector(b.selector||b.id,A,v);}var m=p.modifier;var v=p.view;var A=p.appComponent;a(c,m,v,A);var C=c.getContent();var t=m.bySelector(C.target.selector,A,v);var S=c.getSelector().aggregation;var T=C.target.selector.aggregation;C.movedElements.forEach(function(b){var o=g(b,m,A,v);if(!o){F.log.warning("Element to move not found");return;}m.removeAggregation(s,S,o);m.insertAggregation(t,T,o,b.targetIndex,v);});return true;};
M.completeChangeContent=function(){throw new Error('Using deprecated change handler. Please consider of using \'MoveControls\' instead');};
M.getSpecificChangeInfo=function(m,s){var S=s.source.parent||m.bySelector(s.source.id);var t=s.target.parent||m.bySelector(s.target.id);var a=s.source.aggregation;var T=s.target.aggregation;var b={source:{id:S.getId(),aggregation:a,type:m.getControlType(S)},target:{id:t.getId(),aggregation:T,type:m.getControlType(t)},movedElements:s.movedElements};return b;};
return M;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/PropertyBindingChange',["sap/base/Log","sap/ui/fl/Utils"],function(L,F){"use strict";var P={};
P.applyChange=function(c,C,p){var d=c.getDefinition();var s=d.content.property;var v=d.content.newBinding;var m=p.modifier;var o=m.getPropertyBinding(C,s)||m.getProperty(C,s);c.setRevertData({originalValue:o});m.setPropertyBinding(C,s,v);};
P.revertChange=function(c,C,p){var r=c.getRevertData();if(r){var d=c.getDefinition();var s=d.content.property;var v=r.originalValue;var m=p.modifier;m.setPropertyBinding(C,s,v);c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
P.completeChangeContent=function(c,s){var C=c.getDefinition();if(!s.content){throw new Error("oSpecificChangeInfo attribute required");}C.content=s.content;};
return P;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/PropertyChange',["sap/ui/thirdparty/jquery","sap/ui/fl/Utils","sap/base/Log"],function(q,F,L){"use strict";var P={};
function i(p){return F.isBinding(p)||q.isPlainObject(p);}
function c(C,p,v,m){try{if(i(v)){m.setPropertyBinding(C,p,v);}else{m.setProperty(C,p,v);}}catch(e){throw new Error("Applying property changes failed: "+e);}}
P.applyChange=function(C,o,p){var d=C.getDefinition();var s=d.content.property;var v=d.content.newValue;var m=p.modifier;C.setRevertData({originalValue:m.getPropertyBinding(o,s)||m.getProperty(o,s)});c(o,s,v,m);};
P.revertChange=function(C,o,p){var r=C.getRevertData();if(r){var d=C.getDefinition();var s=d.content.property;var v=r.originalValue;var m=p.modifier;c(o,s,v,m);C.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
P.completeChangeContent=function(C,s){var o=C.getDefinition();if(!s.content){throw new Error("oSpecificChangeInfo attribute required");}o.content=s.content;};
return P;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/StashControl',["sap/base/Log"],function(L){"use strict";var S={};
S.applyChange=function(c,C,p){this.setChangeRevertData(c,p.modifier.getStashed(C));p.modifier.setStashed(C,true);return true;};
S.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setStashed(C,r.originalValue,p.appComponent);c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
S.completeChangeContent=function(c,s){};
S.setChangeRevertData=function(c,v){c.setRevertData({originalValue:v});};
return S;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/UnhideControl',["sap/base/Log"],function(L){"use strict";var U={};
U.applyChange=function(c,C,p){c.setRevertData({originalValue:p.modifier.getProperty(C,'visible')});p.modifier.setVisible(C,true);return true;};
U.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setVisible(C,r.originalValue);c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
U.completeChangeContent=function(c,s){};
return U;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/UnstashControl',["sap/base/Log"],function(L){"use strict";var U={};
U.applyChange=function(c,C,p){var m=c.getContent();var M=p.modifier;var s=false;c.setRevertData({originalValue:p.modifier.getStashed(C)});var u=M.setStashed(C,s,p.appComponent)||C;if(m.parentAggregationName){var t=m.parentAggregationName;var T=M.getParent(u);M.removeAggregation(T,t,u);M.insertAggregation(T,t,u,m.index,p.view);}return u;};
U.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setStashed(C,r.originalValue);c.resetRevertData();}else{L.error("Attempt to revert an unapplied change.");return false;}return true;};
U.completeChangeContent=function(c,s){var C=c.getDefinition();if(s.content){C.content=s.content;}};
return U;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/XmlTreeModifier',["sap/ui/core/util/reflection/XmlTreeModifier"],function(X){"use strict";return X;},true);
sap.ui.predefine('sap/ui/fl/codeExt/CodeExtManager',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/Change"],function(L,U,C){"use strict";var a;a={_oLrepConnector:L.createConnector(),createOrUpdateCodeExtChange:function(p,o){if(!p.content||!p.content.codeRef){throw new Error("no code reference passed for the code extension change");}if(!p.selector||!p.selector.id){throw new Error("no controller name passed for the code extension change");}if(!p.reference){throw new Error("no reference passed for the code extension change");}p.changeType=p.changeType||"codeExt";var c=C.createInitialFileContent(p);var u="/sap/bc/lrep/content/"+c.namespace+c.fileName+".change";u+="?layer="+c.layer;if(o){if(o.transportId){u+="&changelist="+o.transportId;}if(o.packageName){u+="&package="+o.packageName;}}var m="PUT";return this._oLrepConnector.send(u,m,c,{});},createCodeExtChanges:function(c,o){c=c||[];if(c.length===0){return Promise.resolve();}var p=[];c.forEach(function(b){b.changeType=b.changeType||"codeExt";b.packageName=o.packageName;b.content={codeRef:o.codeRef};p.push(C.createInitialFileContent(b));});return this._oLrepConnector.create(p,o.transportId);},deleteCodeExtChange:function(c,o){if(c.changeType!=="codeExt"||c.fileType!=="change"){throw new Error("the change is not of type 'code extension'");}if(!c.fileName){throw new Error("the extension does not contains a file name");}if(c.namespace===undefined){throw new Error("the extension does not contains a namespace");}var u="/sap/bc/lrep/content/"+c.namespace+c.fileName+".change";if(c.layer){u+="&layer="+c.layer;}if(o){if(o.transportId){u+="&changelist="+o.transportId;}if(o.packageName){u+="&package="+o.packageName;}}u=u.replace("&","?");var m="DELETE";return this._oLrepConnector.send(u,m,c,{});}};return a;},true);
sap.ui.predefine('sap/ui/fl/context/BaseContextProvider',['sap/ui/base/ManagedObject'],function(M){"use strict";
var B=M.extend("sap.ui.fl.context.BaseContextProvider",{metadata:{properties:{text:{type:"String"},description:{type:"String"}}}});
B.prototype.loadData=function(){return Promise.resolve({});};
B.prototype.getValue=function(r){return this.loadData().then(function(d){var R=r&&r.split(".")||[];var m=R.reduce(function(c,C){if(c&&c.hasOwnProperty(C)){return c[C];}return undefined;},d);return m;});};
B.prototype.getValueHelp=function(r){return Promise.resolve({});};
B.prototype.validate=function(k,v){return Promise.resolve(true);};
return B;},true);
sap.ui.predefine('sap/ui/fl/context/Context',['sap/ui/base/ManagedObject',"sap/base/Log"],function(M,L){"use strict";
var C=M.extend("sap.ui.fl.context.Context",{metadata:{library:"sap.ui.fl",properties:{configuration:{type:"object"},content:{type:"object"}},aggregations:{contextProviders:{type:"object",multiple:true}},events:{}}});
C.prototype.getValue=function(R){return this._getProviderContent(R,"getValue");};
C.prototype.getValueHelp=function(R){return this._getProviderContent(R,"getValueHelp");};
var r=function(d,R){if(d.indexOf(R)!==-1){return undefined;}if(R.indexOf(d+".")!==-1){return R.substring(d.length+1);}throw new Error("Invalid request for sap.ui.fl.context - domain:"+d+"request:"+R);};
C.prototype._getProviderContent=function(R,p){var t=this;var P=[];var a=[];var h=function(s){var A=t._assureDomain(s);if(A){var o=t._loadProvider(A);P.push(o);a.push({domain:A,request:r(A,s)});}else{a.push({domain:undefined,request:s});}};var m=function(D){var c=t.getConfiguration();var b=false;for(var i=0;i<D.length;i++){var o=D[i];if(o){c[o.domain]=o.provider;b=true;}}if(b){t.setConfiguration(c);}};if(R instanceof Array){R.forEach(function(s){h(s);});}else if(R===undefined){for(var d in this.getConfiguration()){P.push(this._loadProvider(d));}a=Object.keys(this.getConfiguration()).map(function(d){return{domain:d,request:undefined};});}return Promise.all(P).then(m).then(function(){return t._mergeProviderContent(a,p,R);});};
C.prototype._assureDomain=function(d){var c=this.getConfiguration();if(c.hasOwnProperty(d)){return d;}else{var k=Object.keys(c);for(var i=0;i<k.length;i++){var K=k[i];if(d.indexOf(K)===0||K.indexOf(d)===0){return K;}}}return null;};
C.prototype._loadProvider=function(d,c){var a=this.getConfiguration()[d];if(typeof(a)==="string"){return new Promise(function(b,e){try{sap.ui.require([a],function(P){var p=new P();b({"domain":d,"provider":p});},function(E){L.error(E);b();return;});}catch(E){L.error(E);b();return;}});}else{return Promise.resolve();}};
C.prototype._mergeProviderContent=function(R,p,a){var P=[];var c=this.getConfiguration();R.forEach(function(o){if(c.hasOwnProperty(o.domain)){var A=c[o.domain];if(A instanceof sap.ui.fl.context.BaseContextProvider){P.push(A[p].call(A,o.request).then(function(v){var s={};var b=o.domain;if(o.request){b=b+"."+o.request;}s[b]=v;return s;}));}}else{var s={};s[o.request]=undefined;P.push(Promise.resolve(s));}});return Promise.all(P).then(function(b){return b.reduce(function(m,d){var k=Object.keys(d)[0];m[k]=d[k];return m;},{});});};
return C;},true);
sap.ui.predefine('sap/ui/fl/context/ContextManager',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/context/Context","sap/base/Log"],function(L,U,C,a){"use strict";var b;b={_oContext:new C({configuration:{"device":"sap/ui/fl/context/DeviceContextProvider","switches":"sap/ui/fl/context/SwitchContextProvider"}}),_oLrepConnector:L.createConnector(),doesContextMatch:function(c,A){var s=c.context||"";if(!s){return true;}return A&&A.indexOf(s)!==-1;},getActiveContexts:function(c){var d=this._getContextIdsFromUrl();if(d.length===0){return this._getContextParametersFromAPI(c).then(this._getActiveContextsByAPIParameters.bind(this,c));}else{return Promise.resolve(this._getActiveContextsByUrlParameters(c,d));}},_getContextParametersFromAPI:function(c){var r=[];c.forEach(function(o){o.parameters.forEach(function(d){var s=d.selector;if(r.indexOf(s)===-1){r.push(s);}});});return this._oContext.getValue(r);},_getActiveContextsByAPIParameters:function(c,r){var t=this;var A=[];c.forEach(function(o){if(t._isContextObjectActive(o,r)){A.push(o.id);}});return A;},_getActiveContextsByUrlParameters:function(c,d){var A=[];c.forEach(function(o){var e=((d?Array.prototype.indexOf.call(d,o.id):-1))!==-1;if(e){A.push(o.id);}});return A;},_isContextObjectActive:function(c,r){var t=this;var d=true;var p=c.parameters;p.every(function(P){d=d&&t._checkContextParameter(P,r);return d;});return d;},_getContextIdsFromUrl:function(){var c=U.getUrlParameter("sap-ui-flexDesignTimeContext");if(!c){return[];}return c.split(",");},_checkContextParameter:function(p,r){var s=p.selector;var o=p.operator;var v=p.value;switch(o){case"EQ":return this._checkEquals(s,v,r);case"NE":return!this._checkEquals(s,v,r);default:a.info("A context within a flexibility change with the operator '"+o+"' could not be verified");return false;}},_checkEquals:function(s,v,r){return r[s]===v;},createOrUpdateContextObject:function(p){if(!p.reference){throw new Error("no reference passed for the context object");}if(!p.namespace){throw new Error("no namespace passed for the context object");}var i=p.id||U.createDefaultFileName();p={id:i,fileName:i,title:p.title||"",description:p.description||"",parameters:p.parameters||[],fileType:"context",reference:p.reference||"",packageName:p.packageName||"",layer:p.layer||U.getCurrentLayer(false),namespace:p.namespace,creation:p.creation||"",originalLanguage:p.originalLanguage||U.getCurrentLanguage(),support:p.support||{generator:p.generator||"",service:"",user:""},validAppVersions:p.validAppVersions||{}};var u="/sap/bc/lrep/content/"+p.namespace+p.fileName+".context";u+="?layer="+p.layer;var m="PUT";return this._oLrepConnector.send(u,m,p,{});}};return b;},true);
sap.ui.predefine('sap/ui/fl/context/DeviceContextProvider',["sap/ui/fl/context/BaseContextProvider","sap/ui/Device"],function(B,D){"use strict";
var a=B.extend("sap.ui.fl.context.DeviceContextProvider",{metadata:{properties:{text:{type:"String",defaultValue:"Device"},description:{type:"String",defaultValue:"Returns the values of sap.ui.Device"}}}});
a.prototype.loadData=function(){return Promise.resolve(D);};
a.prototype.getValueHelp=function(){return Promise.resolve({});};
a.prototype.validate=function(k,v){return Promise.resolve(true);};
return a;},true);
sap.ui.predefine('sap/ui/fl/context/SwitchContextProvider',["sap/ui/fl/context/BaseContextProvider","sap/ui/fl/Cache"],function(B,C){"use strict";
var S=B.extend("sap.ui.fl.context.SwitchContextProvider",{metadata:{properties:{text:{type:"String",defaultValue:"Switch"},description:{type:"String",defaultValue:"Returns the values of switches received in the flexibility response from the back end"}}}});
S.prototype.loadData=function(){return Promise.resolve(C.getSwitches());};
S.prototype.getValueHelp=function(){return Promise.resolve({});};
S.prototype.validate=function(k,v){return Promise.resolve(true);};
return S;},true);
sap.ui.predefine('sap/ui/fl/core/EventDelegate',["sap/ui/thirdparty/jquery","sap/ui/fl/Utils","sap/ui/base/EventProvider","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/core/FlexVisualizer"],function(q,U,E,C,F){"use strict";var a=function(c,s){if(!c){U.log.error("sap.ui.fl.core.EventDelegate: Control required");}if(!s){U.log.error("sap.ui.fl.core.EventDelegate: Supported registry items required");}E.apply(this);this._oControl=c;this._oSupportedRegistryItems=s;};a.prototype=Object.create(E.prototype||null);
a.registerControl=function(c){if(c){var i=0;if(c.aDelegates){for(i=0;i<c.aDelegates.length;i++){var t="";if(c.aDelegates[i].oDelegate&&c.aDelegates[i].oDelegate.getType){t=(c.aDelegates[i].oDelegate.getType());}if(t==="Flexibility"){return;}}}a.registerExplicitChanges(c);}};
a.registerExplicitChanges=function(c){var r=C.getInstance();var p={controlType:U.getControlType(c)};var s=r.getRegistryItems(p);if(Object.keys(s).length>0){c.addEventDelegate(new a(c,s));}};
a.unregisterControl=function(){};
a.prototype.onmouseover=function(e){e.stopPropagation();if(e.handled){return;}else{e.handled=true;}if(F.isPersonalizationMode()){if(this._oControl&&!q(this._oControl.getDomRef()).hasClass("sapuiflex-highlight")){F.showDialog(this._oControl);}}};
a.prototype.onmouseout=function(e){if(F.isPersonalizationMode()){if(this._oControl){F.closeDialog();}}};
return a;},true);
sap.ui.predefine('sap/ui/fl/core/FlexVisualizer',[],function(){"use strict";var F=function(){};
F.showDialog=function(a,i){};
F.closeDialog=function(){};
return F;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory',["sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/ChangePersistence","sap/ui/fl/Change","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/registry/Settings","sap/ui/fl/Utils","sap/ui/thirdparty/jquery","sap/base/util/merge"],function(C,a,b,U,S,F,q,B){"use strict";var D=function(m,i,s){this._mChangeFile=m;this._mChangeFile.packageName='$TMP';this._oInlineChange=i;this._sTransportRequest=null;this._oSettings=s;};
D.prototype.setTransportRequest=function(t){try{U.checkTransportRequest(t);}catch(e){return Promise.reject(e);}this._sTransportRequest=t;return Promise.resolve();};
D.prototype.setPackage=function(p){try{U.checkPackage(p);}catch(e){return Promise.reject(e);}this._mChangeFile.packageName=p;return Promise.resolve();};
D.prototype.submit=function(){this.store();var o=this._getChangePersistence(this._mChangeFile.reference);return o.saveDirtyChanges();};
D.prototype.store=function(){var s=this._mChangeFile.reference;var A=this._mChangeFile.validAppVersions.creation;var o=this._getChangePersistence(s,A);var d=this._getChangeToSubmit();o.addChange(d);return d;};
D.prototype._getChangePersistence=function(s,A){return C.getChangePersistenceForComponent(s,A);};
D.prototype._getChangeToSubmit=function(){var o=new b(this._getMap());if(this._sTransportRequest){o.setRequest(this._sTransportRequest);}else if(this._oSettings.isAtoEnabled()&&F.isCustomerDependentLayer(this._mChangeFile.layer)){o.setRequest('ATO_NOTIFICATION');}return o;};
D.prototype._getMap=function(){var i=this._oInlineChange.getMap();this._mChangeFile.content=i.content;this._mChangeFile.texts=i.texts;return this._mChangeFile;};
D.prototype.getJson=function(){return B({},this._getMap());};
var c=function(){};
c.prototype.createNew=function(r,i,l,A,t){var s=function(_,I){if(_["setHostingIdForTextKey"]){_.setHostingIdForTextKey(I);}};s(i,r);var d;if(A){var m=A.getManifest();d=F.getAppVersionFromManifest(m);}var p={};p.changeType=i._getChangeType();p.componentName=r;p.reference=r;p.validAppVersions=d?{"creation":d,"from":d}:{};p.generator=t;if(!l){p.layer='CUSTOMER';}else{if(l!='VENDOR'&&l!='PARTNER'&&!F.isCustomerDependentLayer(l)){throw new Error("Parameter \"layer\" needs to be 'VENDOR', 'PARTNER' or customer dependent");}p.layer=l;}var e=b.createInitialFileContent(p);return S.getInstance().then(function(o){return Promise.resolve(new D(e,i,o));});};
return c;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory',["sap/ui/fl/descriptorRelated/internal/Utils"],function(U){"use strict";var D=function(c,p,t){U.checkTexts(t);this._mParameters={};this._mParameters.changeType=c;this._mParameters.content=p;this._mParameters.texts=t;};
D.prototype._getChangeType=function(){return this._mParameters.changeType;};
D.prototype.getMap=function(){return this._mParameters;};
var a={};
a.getDescriptorChangeTypes=function(){return["appdescr_ovp_addNewCard","appdescr_ovp_removeCard","appdescr_ovp_changeCard","appdescr_app_addNewInbound","appdescr_app_changeInbound","appdescr_app_removeInbound","appdescr_app_removeAllInboundsExceptOne","appdescr_app_addNewOutbound","appdescr_app_changeOutbound","appdescr_app_removeOutbound","appdescr_app_addNewDataSource","appdescr_app_changeDataSource","appdescr_app_removeDataSource","appdescr_app_addAnnotationsToOData","appdescr_app_addTechnicalAttributes","appdescr_app_removeTechnicalAttributes","appdescr_app_setTitle","appdescr_app_setSubTitle","appdescr_app_setShortTitle","appdescr_app_setDescription","appdescr_app_setInfo","appdescr_app_setDestination","appdescr_app_setKeywords","appdescr_app_setAch","appdescr_flp_setConfig","appdescr_ui5_addNewModel","appdescr_ui5_addNewModelEnhanceWith","appdescr_ui5_removeModel","appdescr_ui5_replaceComponentUsage","appdescr_smb_addNamespace","appdescr_smb_changeNamespace","appdescr_ui_generic_app_setMainPage","appdescr_ui_setIcon","appdescr_ui_setDeviceTypes","appdescr_ui5_addLibraries","appdescr_url_setUri"];};
a.createNew=function(c,p,t){var d=new D(c,p,t);return new Promise(function(r,b){if(d){r(d);}else{var e={};b(e);}});};
a._createDescriptorInlineChange=function(d,p,t){var o=new D(d,p,t);return new Promise(function(r,b){if(o){r(o);}else{var e={};b(e);}});};
a.createDescriptorInlineChange=function(d,p,t){return this._createDescriptorInlineChange(d,p,t);};
a.create_ovp_addNewCard=function(p,t){U.checkParameterAndType(p,"card","object");return this._createDescriptorInlineChange('appdescr_ovp_addNewCard',p,t);};
a.create_ovp_removeCard=function(p){U.checkParameterAndType(p,"cardId","string");return this._createDescriptorInlineChange('appdescr_ovp_removeCard',p);};
a.create_ovp_changeCard=function(p,t){U.checkParameterAndType(p,"cardId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_ovp_changeCard',p,t);};
a.create_app_addNewInbound=function(p,t){U.checkParameterAndType(p,"inbound","object");return this._createDescriptorInlineChange('appdescr_app_addNewInbound',p,t);};
a.create_app_removeInbound=function(p){U.checkParameterAndType(p,"inboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeInbound',p);};
a.create_app_removeAllInboundsExceptOne=function(p){U.checkParameterAndType(p,"inboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeAllInboundsExceptOne',p);};
a.create_app_changeInbound=function(p,t){U.checkParameterAndType(p,"inboundId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeInbound',p,t);};
a.create_app_addNewOutbound=function(p){U.checkParameterAndType(p,"outbound","object");return this._createDescriptorInlineChange('appdescr_app_addNewOutbound',p);};
a.create_app_removeOutbound=function(p){U.checkParameterAndType(p,"outboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeOutbound',p);};
a.create_app_changeOutbound=function(p){U.checkParameterAndType(p,"outboundId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeOutbound',p);};
a.create_app_addNewDataSource=function(p){U.checkParameterAndType(p,"dataSource","object");return this._createDescriptorInlineChange('appdescr_app_addNewDataSource',p);};
a.create_app_removeDataSource=function(p){U.checkParameterAndType(p,"dataSourceId","string");return this._createDescriptorInlineChange('appdescr_app_removeDataSource',p);};
a.create_app_changeDataSource=function(p){U.checkParameterAndType(p,"dataSourceId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeDataSource',p);};
a.create_app_addAnnotationsToOData=function(p){U.checkParameterAndType(p,"dataSourceId","string");U.checkParameterAndType(p,"annotations","array");U.checkParameterAndType(p,"dataSource","object");return this._createDescriptorInlineChange('appdescr_app_addAnnotationsToOData',p);};
a.create_app_setTitle=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.title";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setSubTitle=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setSubTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.subTitle";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setShortTitle=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setShortTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.shortTitle";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setDescription=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setDescription',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.description";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setInfo=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setInfo',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.info";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setAch=function(p){U.checkParameterAndType(p,"ach","string");return this._createDescriptorInlineChange('appdescr_app_setAch',p);};
a.create_app_setDestination=function(p){U.checkParameterAndType(p,"destination","object");return this._createDescriptorInlineChange('appdescr_app_setDestination',p);};
a.create_app_setKeywords=function(p,t){U.checkParameterAndType(p,"keywords","array");return this._createDescriptorInlineChange('appdescr_app_setKeywords',p,t);};
a.create_app_addTechnicalAttributes=function(p){U.checkParameterAndType(p,"technicalAttributes","array");return this._createDescriptorInlineChange('appdescr_app_addTechnicalAttributes',p);};
a.create_app_removeTechnicalAttributes=function(p){U.checkParameterAndType(p,"technicalAttributes","array");return this._createDescriptorInlineChange('appdescr_app_removeTechnicalAttributes',p);};
a.create_flp_setConfig=function(p){U.checkParameterAndType(p,"config","object");return this._createDescriptorInlineChange('appdescr_flp_setConfig',p);};
a.create_ui5_addNewModel=function(p){U.checkParameterAndType(p,"model","object");return this._createDescriptorInlineChange('appdescr_ui5_addNewModel',p);};
a.create_ui5_removeModel=function(p){U.checkParameterAndType(p,"modelId","string");return this._createDescriptorInlineChange('appdescr_ui5_removeModel',p);};
a.create_ui5_addNewModelEnhanceWith=function(p,t){U.checkParameterAndType(p,"modelId","string");return this._createDescriptorInlineChange('appdescr_ui5_addNewModelEnhanceWith',p,t);};
a.create_ui5_replaceComponentUsage=function(p){U.checkParameterAndType(p,"componentUsageId","string");U.checkParameterAndType(p,"componentUsage","object");return this._createDescriptorInlineChange('appdescr_ui5_replaceComponentUsage',p);};
a.create_ui5_addLibraries=function(p){U.checkParameterAndType(p,"libraries","object");return this._createDescriptorInlineChange('appdescr_ui5_addLibraries',p);};
a.create_smb_addNamespace=function(p){U.checkParameterAndType(p,"smartBusinessApp","object");return this._createDescriptorInlineChange('appdescr_smb_addNamespace',p);};
a.create_smb_changeNamespace=function(p){U.checkParameterAndType(p,"smartBusinessApp","object");return this._createDescriptorInlineChange('appdescr_smb_changeNamespace',p);};
a.create_ui_generic_app_setMainPage=function(p,t){U.checkParameterAndType(p,"page","object");return this._createDescriptorInlineChange('appdescr_ui_generic_app_setMainPage',p,t);};
a.create_ui_setIcon=function(p){U.checkParameterAndType(p,"icon","string");return this._createDescriptorInlineChange('appdescr_ui_setIcon',p);};
a.create_ui_setDeviceTypes=function(p){U.checkParameterAndType(p,"deviceTypes","object");return this._createDescriptorInlineChange('appdescr_ui_setDeviceTypes',p);};
a.create_url_setUri=function(p){U.checkParameterAndType(p,"uri","string");return this._createDescriptorInlineChange('appdescr_url_setUri',p);};
return a;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory',["sap/ui/fl/Utils","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/registry/Settings","sap/ui/thirdparty/jquery","sap/base/util/merge"],function(F,U,S,q,b){"use strict";var D=function(p,f,d,s){if(p&&d){this._id=p.id;this._mode='DELETION';this._mMap=f;}else if(p){this._id=p.id;this._reference=p.reference;this._layer=p.layer;if(typeof p.isAppVariantRoot!="undefined"){this._isAppVariantRoot=p.isAppVariantRoot;}if(typeof p.referenceVersion!="undefined"){this._referenceVersion=p.referenceVersion;}this._mode='NEW';this._skipIam=p.skipIam;}else if(f){this._mMap=f;this._mode='FROM_EXISTING';}this._oSettings=s;this._sTransportRequest=null;this._content=[];};
D.prototype.addDescriptorInlineChange=function(d){var t=this;return new Promise(function(r){var s=function(_,i){if(_["setHostingIdForTextKey"]){_.setHostingIdForTextKey(i);}};switch(t._mode){case'NEW':s(d,t._id);t._content.push(d.getMap());break;case'FROM_EXISTING':s(d,t._mMap.id);t._mMap.content.push(d.getMap());break;default:}r(null);});};
D.prototype.setTransportRequest=function(t){try{U.checkTransportRequest(t);}catch(e){return Promise.reject(e);}this._sTransportRequest=t;return Promise.resolve();};
D.prototype.setPackage=function(p){try{U.checkPackage(p);}catch(e){return Promise.reject(e);}this._package=p;return Promise.resolve();};
D.prototype.submit=function(){var r='/sap/bc/lrep/appdescr_variants/';var m;switch(this._mode){case'NEW':m='POST';break;case'FROM_EXISTING':m='PUT';r=r+this._getMap().id;break;case'DELETION':m='DELETE';r=r+this._id;break;default:}var M=this._getMap();if(this._sTransportRequest){r+='?changelist='+this._sTransportRequest;}else if(this._oSettings.isAtoEnabled()&&F.isCustomerDependentLayer(M.layer)){r+='?changelist=ATO_NOTIFICATION';}if(this._skipIam){r+=(r.indexOf('?')<0)?'?':'&';r+='skipIam='+this._skipIam;}return U.sendRequest(r,m,M);};
D.prototype.getId=function(){return this._id;};
D.prototype.setReference=function(r){if(r===undefined||typeof r!=="string"){throw new Error("No parameter sReference of type string provided");}this._reference=r;};
D.prototype.getReference=function(){return this._reference;};
D.prototype.getNamespace=function(){return this._getMap().namespace;};
D.prototype.getSettings=function(){return this._oSettings;};
D.prototype.getJson=function(){return b({},this._getMap());};
D.prototype._getMap=function(){switch(this._mode){case'NEW':var r={"fileName":this._getNameAndNameSpace().fileName,"fileType":"appdescr_variant","namespace":this._getNameAndNameSpace().namespace,"layer":this._layer,"packageName":this._package?this._package:"$TMP","reference":this._reference,"id":this._id,"content":this._content};if(typeof this._isAppVariantRoot!="undefined"){r.isAppVariantRoot=this._isAppVariantRoot;}if(r.isAppVariantRoot!=undefined&&!r.isAppVariantRoot){r.fileType="cdmapp_config";}if(typeof this._referenceVersion!="undefined"){r.referenceVersion=this._referenceVersion;}return r;case'FROM_EXISTING':case'DELETION':{return this._mMap;}default:}};
D.prototype._getNameAndNameSpace=function(){return U.getNameAndNameSpace(this._id,this._reference);};
var a={};
a._getDescriptorVariant=function(i){var r='/sap/bc/lrep/appdescr_variants/'+i;return U.sendRequest(r,'GET');};
a.createNew=function(p){U.checkParameterAndType(p,"reference","string");U.checkParameterAndType(p,"id","string");if(!p.layer){p.layer='CUSTOMER';}else{U.checkParameterAndType(p,"layer","string");if(p.layer!='VENDOR'&&p.layer!='PARTNER'&&!F.isCustomerDependentLayer(p.layer)){throw new Error("Parameter \"layer\" needs to be 'VENDOR', 'PARTNER' or customer dependent");}}if(p.isAppVariantRoot){U.checkParameterAndType(p,"isAppVariantRoot","boolean");}if(p.skipIam){U.checkParameterAndType(p,"skipIam","boolean");}return S.getInstance().then(function(s){return Promise.resolve(new D(p,null,false,s));});};
a.createForExisting=function(i){if(i===undefined||typeof i!=="string"){throw new Error("Parameter \"sId\" must be provided of type string");}var _;return a._getDescriptorVariant(i).then(function(r){_=r;return S.getInstance();}).then(function(s){var d=_.response;if(!q.isPlainObject(d)){d=JSON.parse(d);}return Promise.resolve(new D(null,d,false,s));});};
a.createFromJson=function(p){if(!q.isPlainObject(p)){throw new Error("Parameter \"mParameters\" must be provided of type object");}return S.getInstance().then(function(s){return Promise.resolve(new D(null,p,false,s));});};
a.createDeletion=function(i){if(i===undefined||typeof i!=="string"){throw new Error("Parameter \"sId\" must be provided of type string");}var p={};p.id=i;var _;return a._getDescriptorVariant(i).then(function(r){_=r;return S.getInstance();}).then(function(s){var d=JSON.parse(_.response);return Promise.resolve(new D(p,d,true,s));});};
return a;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/internal/Utils',["sap/ui/fl/LrepConnector"],function(L){"use strict";var U=function(){};
U.prototype.sendRequest=function(r,m,M){if(!this._oLREPConnector){this._oLREPConnector=L.createConnector();}return this._oLREPConnector.send(r,m,M);};
U.prototype.getNameAndNameSpace=function(i,r){return{"fileName":"manifest","namespace":"apps/"+r+"/appVariants/"+i+"/"};};
U.prototype.checkEntityPropertyChange=function(p){this.checkParameterAndType(p,"entityPropertyChange","object");if(p.entityPropertyChange instanceof Array){for(var i=0;i<p.entityPropertyChange.length;i++){var c=p.entityPropertyChange[i];this.checkEntityPropertyChangeContent(c);}}else if(p.entityPropertyChange instanceof Object){this.checkEntityPropertyChangeContent(p.entityPropertyChange);}};
U.prototype.checkEntityPropertyChangeContent=function(c){this.checkParameterAndType(c,"propertyPath","string");this.checkParameterAndType(c,"operation","string");if(['INSERT','UPDATE','UPSERT','DELETE'].indexOf(c.operation)===-1){throw new Error("Parameter \"entityPropertyChange.operation\" needs to be one of 'INSERT', 'UPDATE', 'UPSERT', 'DELETE'");}if(c.propertyValue===undefined&&c.operation!=='DELETE'){throw new Error("No parameter \"entityPropertyChange.propertyValue\" provided");}};
U.prototype.checkParameterAndType=function(p,P,t){if(t==="array"){if(p===undefined||p[P]===undefined||!Array.isArray(p[P])){throw new Error("No parameter \""+P+"\" of type "+t+" provided");}}else{if(p===undefined||p[P]===undefined||typeof p[P]!==t){throw new Error("No parameter \""+P+"\" of type "+t+" provided");}}};
U.prototype.checkTexts=function(t){if(t!==undefined&&typeof t!=="object"){throw new Error("Wrong format for provided \"texts\" parameter");}};
U.prototype.checkTransportRequest=function(t){if(!/^[A-Z0-9]{1,20}$/.test(t)&&t!=='ATO_NOTIFICATION'){throw new Error("Wrong format for provided \"sTransportRequest\" parameter");}};
U.prototype.checkPackage=function(p){if(!/^[A-Z0-9/_]{1,30}$/.test(p)){throw new Error("Wrong format for provided \"sPackage\" parameter");}};
return new U();},true);
sap.ui.predefine('sap/ui/fl/fieldExt/Access',["sap/ui/util/Storage","sap/base/security/encodeURLParameters","sap/ui/thirdparty/jquery"],function(S,a,q){"use strict";var A={};A._mServiceType={v2:"v2",v4:"v4"};A._sODataV4ResourcePathPrefix="sap/opu/odata4/";A._sStorageKey="sap.ui.fl.fieldExt.Access";A._iValidityPeriod=1*7*24*60*60*1000;
A.getBusinessContexts=function(s,e,E){var m=this._getEntityInfo(e,E);var b=this._parseServiceUri(s);var B=this._buildBusinessContextRetrievalUri(b,m);var p=this._executeAjaxCall(B,b,m);return p;};
A.isServiceOutdated=function(s){if(!this._isSystemInfoAvailable()){return false;}var m=this._getServiceItem(this._createServiceItem(s));if(m){if(this._isServiceExpired(m)){this.setServiceValid(s);return false;}else{return true;}}else{return false;}};
A.setServiceValid=function(s){if(this._isSystemInfoAvailable()){var d=this._getDataFromLocalStorage();delete d[this._createServiceItem(s).serviceKey];this._setDataToLocalStorage(d);}};
A.setServiceInvalid=function(s){if(this._isSystemInfoAvailable()){var d=this._getDataFromLocalStorage();var i=this._createServiceItem(s);d[i.serviceKey]=i;this._setDataToLocalStorage(d);}};
A._getEntityInfo=function(e,E){var o={entityTypeName:e||"",entitySetName:E||""};if(((o.entitySetName.length===0)&&(o.entityTypeName.length===0))||(!(o.entitySetName.length===0)&&!(o.entityTypeName.length===0))){throw new Error("sap.ui.fl.fieldExt.Access._getEntityInfo()"+"Inconsistent input parameters EntityType: "+o.entityTypeName+" EntitySet: "+o.entitySetName);}return o;};
A._parseServiceUri=function(s){if(s.toLowerCase().indexOf(this._sODataV4ResourcePathPrefix)!==-1){return this._parseV4ServiceUri(s);}else{return this._parseV2ServiceUri(s);}};
A._parseV2ServiceUri=function(s){var r=/.*sap\/opu\/odata\/([^\/]+)\/([^\/]+)/i;var R=/([^;]+);v=(\d{1,4})/i;var o="sap/opu/odata";var b;if(s.toLowerCase().indexOf(o)!==-1){var c=s.match(r);if(!c||c.length!==3){throw new Error("sap.ui.fl.fieldExt.Access._parseV2ServiceUri: Malformed service URI (Invalid service name)");}if(c[1].toLowerCase()!=="sap"){b="/"+c[1]+"/"+c[2];}else{b=c[2];}}else{if(s.length>0&&s.lastIndexOf("/")+1===s.length){s=s.substring(0,s.length-1);}b=s.substring(s.lastIndexOf("/")+1);}if(b.indexOf(";v=")!==-1){var v=b.match(R);if(!v||v.length!==3){throw new Error("sap.ui.fl.fieldExt.Access._parseV2ServiceUri: Malformed service URI (Invalid version)");}return{serviceName:v[1],serviceVersion:v[2],serviceType:this._mServiceType.v2};}else{return{serviceName:b,serviceVersion:"0001",serviceType:this._mServiceType.v2};}};
A._parseV4ServiceUri=function(s){var r=/^\/?sap\/opu\/odata4((?:\/[^/]+){5})(\/[^/]+){1}(\/.*)?/i;var b=s.match(r);if(!b||b.length!==4){throw new Error("sap.ui.fl.fieldExt.Access._parseV4ServiceUri: Malformed service URI");}var n=b[1].split("/");n.splice(0,3);var R=/(\d{1,4})/i;var v=b[2].match(R);return{serviceName:n.join("/"),serviceVersion:v[1],serviceType:this._mServiceType.v4};};
A._buildBusinessContextRetrievalUri=function(s,e){var b="/sap/opu/odata/SAP/APS_CUSTOM_FIELD_MAINTENANCE_SRV/";if(s.serviceType===this._mServiceType.v4){var r=this._sODataV4ResourcePathPrefix+s.serviceName+"/"+s.serviceVersion;b+="GetBusinessContextsByResourcePath?"+a({"ResourcePath":"'"+r+"'"});}else{b+="GetBusinessContextsByEntityType?"+"ServiceName=\'"+s.serviceName+"\'"+"&ServiceVersion=\'"+s.serviceVersion+"\'";}b+="&EntitySetName=\'"+e.entitySetName+"\'"+"&EntityTypeName=\'"+e.entityTypeName+"\'"+"&$format=json";return b;};
A._executeAjaxCall=function(b,s,e){var t=this;var m=this._getAjaxSettings();var d=q.Deferred();var r={BusinessContexts:[],ServiceName:s.serviceName,ServiceVersion:s.serviceVersion};q.ajax(b,m).done(function(c,f,j){r.BusinessContexts=t._extractBusinessContexts(c);d.resolve(r);}).fail(function(j,c,f){if(j.status===404&&s.serviceType===t._mServiceType.v4){d.resolve(r);}else{var E=t._getMessagesFromXHR(j);var o={errorOccured:true,errorMessages:E,serviceName:s.serviceName,serviceVersion:s.serviceVersion,entityType:e.entityTypeName,entitySet:e.entitySetName};d.reject(o);}});return d.promise();};
A._getAjaxSettings=function(){var s={type:"GET",async:true,dataType:"json"};return s;};
A._extractBusinessContexts=function(d){var r=null;var b=[];if(d&&d.d){r=d.d.results;}if(r!==null&&r.length>0){for(var i=0;i<r.length;i++){if(r[i].BusinessContext!==null){b.push(r[i].BusinessContext);}}}return b;};
A._getMessagesFromXHR=function(x){var m=[];try{var E=JSON.parse(x.responseText);if(E&&E.error&&E.error.message&&E.error.message.value&&E.error.message.value!==''){m.push({severity:"error",text:E.error.message.value});}else{m.push({severity:"error",text:x.responseText});}}catch(e){}return m;};
A._getCurrentTime=function(){return Date.now();};
A._isServiceExpired=function(s){return s.expirationDate<=this._getCurrentTime();};
A._getLocalStorage=function(){return new S(S.Type.local);};
A.isLocalStorageAvailable=function(){return this._getLocalStorage()&&this._getLocalStorage().isSupported();};
A._getServiceItem=function(s){return this._getDataFromLocalStorage()[s.serviceKey]||null;};
A._createServiceItem=function(s){var e=this._getCurrentTime()+this._iValidityPeriod;var m=this._getSystemInfo();var p=this._extractServiceInfo(s);return{"serviceKey":m.getName()+m.getClient()+p.serviceName+p.serviceVersion,"expirationDate":e};};
A._extractServiceInfo=function(s){if(typeof s==="string"){return this._parseServiceUri(s);}else{return s;}};
A._isSystemInfoAvailable=function(){return sap&&sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getLogonSystem;};
A._getSystemInfo=function(){return sap.ushell.Container.getLogonSystem();};
A._setDataToLocalStorage=function(d){if(this.isLocalStorageAvailable()){this._getLocalStorage().put(A._sStorageKey,JSON.stringify(d));}};
A._getDataFromLocalStorage=function(){if(!this.isLocalStorageAvailable()){return{};}var s=this._getLocalStorage().get(A._sStorageKey);if(!s){return{};}else{return JSON.parse(s);}};
return A;},true);
sap.ui.predefine('sap/ui/fl/library',["sap/ui/fl/RegistrationDelegator","sap/ui/core/library","sap/m/library"],function(R){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.fl",version:"1.60.20",controls:["sap.ui.fl.variants.VariantManagement"],dependencies:["sap.ui.core","sap.m"],designtime:"sap/ui/fl/designtime/library.designtime",extensions:{"sap.ui.support":{diagnosticPlugins:["sap/ui/fl/support/Flexibility"],publicRules:true}}});sap.ui.fl.Scenario={AppVariant:"APP_VARIANT",AdaptationProject:"ADAPTATION_PROJECT",FioriElementsFromScratch:"FE_FROM_SCRATCH",UiAdaptation:"UI_ADAPTATION"};R.registerAll();return sap.ui.fl;});
sap.ui.predefine('sap/ui/fl/registry/ChangeHandlerRegistration',["sap/ui/fl/registry/ChangeRegistry","sap/ui/thirdparty/jquery"],function(C,q){"use strict";var a={getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs:function(){var t=this;var c=sap.ui.getCore();var A=c.getLoadedLibraries();q.each(A,function(l,L){if(L.extensions&&L.extensions.flChangeHandlers){t.registerFlexChangeHandlers(L.extensions.flChangeHandlers);}});c.attachLibraryChanged(this.handleLibraryRegistrationAfterFlexLibraryIsLoaded.bind(this));},registerFlexChangeHandlers:function(f){if(f){var c=C.getInstance();c.registerControlsForChanges(f);}},handleLibraryRegistrationAfterFlexLibraryIsLoaded:function(l){if(l.getParameter("operation")==="add"){var L=l.getParameter("metadata");if(L&&L.extensions&&L.extensions.flChangeHandlers){var f=L.extensions.flChangeHandlers;this.registerFlexChangeHandlers(f);}}}};return a;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeRegistry',["sap/ui/fl/Utils","sap/ui/thirdparty/jquery","sap/ui/fl/registry/ChangeRegistryItem","sap/ui/fl/registry/ChangeTypeMetadata","sap/ui/fl/registry/Settings","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl","sap/ui/fl/changeHandler/AddXML"],function(U,q,C,a,S,H,M,b,P,c,d,e,f,A){"use strict";var g=function(){this._registeredItems={};this.initSettings();this.initDeveloperModeChangeHandlers();};g._instance=undefined;g.prototype._oDefaultActiveChangeHandlers={};g.prototype._oDefaultChangeHandlers={"hideControl":H,"moveElements":M,"moveControls":b,"unhideControl":d,"stashControl":e,"unstashControl":f};g.prototype._mDeveloperModeChangeHandlers={"propertyChange":{changeHandler:P},"propertyBindingChange":{changeHandler:c},"addXML":{changeHandler:A}};
g.prototype.initDeveloperModeChangeHandlers=function(){Object.keys(this._mDeveloperModeChangeHandlers).forEach(function(s){var o=this._mDeveloperModeChangeHandlers[s].changeHandler;var l=this._oSettings.getDeveloperModeLayerPermissions();var h={changeType:s,changeHandler:o,layers:l};var i=this._createChangeRegistryItemForSimpleChange("defaultActiveForAllControls",h);this._oDefaultActiveChangeHandlers[s]=i;}.bind(this));};
g.getInstance=function(){if(!g._instance){g._instance=new g();}return g._instance;};
g.prototype.hasRegisteredChangeHandlersForControl=function(s){var h=Object.keys(this._registeredItems);return h.indexOf(s)!==-1;};
g.prototype.hasChangeHandlerForControlAndChange=function(s,h){if(!this.hasRegisteredChangeHandlersForControl(s)){return false;}var r=this._registeredItems[s];var i=Object.keys(r);return i.indexOf(h)!==-1;};
g.prototype.registerControlsForChanges=function(m){var t=this;q.each(m,function(s,h){if(Array.isArray(h)){var o={};h.forEach(function(i){o[i.changeType]=i.changeHandler;});t._registerChangeHandlersForControl(s,o);}else{t._registerChangeHandlersForControl(s,h);}});};
g.prototype._registerChangeHandlersForControl=function(s,o){var t=this;if(typeof o==="string"){try{o=sap.ui.requireSync(o+".flexibility");}catch(h){U.log.error("Flexibility change handler registration failed.\nControlType: "+s+"\n"+h.message);return;}}q.each(o,function(i,j){var k=t._getChangeHandlerEntry(i,j);var l={"changeType":i,"changeHandler":k.changeHandler,"layers":k.layers};t.registerControlForSimpleChange(s,l);});};
g.prototype._getInstanceSpecificChangeRegistryItem=function(s,o,m){var h=m.getChangeHandlerModulePath(o);var i={},v,j,k,l,n;if(typeof h!=="string"){return undefined;}try{i=sap.ui.requireSync(h);}catch(p){U.log.error("Flexibility registration for control "+m.getId(o)+" failed to load module "+h+"\n"+p.message);return undefined;}v=i[s];if(!v){return undefined;}j=this._getChangeHandlerEntry(s,v);k={"changeType":s,"changeHandler":j.changeHandler,"layers":j.layers};l=m.getControlType(o);n=this._createChangeRegistryItemForSimpleChange(l,k);return n;};
g.prototype._getChangeHandlerEntry=function(s,v){var r={};var D=Object.keys(this._mDeveloperModeChangeHandlers);if(!v||!v.changeHandler){r.changeHandler=v;}else{r=v;}if(r.changeHandler==="default"){r.changeHandler=this._oDefaultChangeHandlers[s];}else if(D.indexOf(s)>-1){throw new Error("You can't use a custom change handler for the following Developer Mode change types: "+D.toString()+". Please use 'default' instead.");}return r;};
g.prototype._getChangeRegistryItem=function(s,h,l){var m;if(!s||!h){return undefined;}m=this.getRegistryItems({"changeTypeName":s,"controlType":h,"layer":l});if(m&&m[h]&&m[h][s]){return m[h][s];}else if(m&&m[h]){return m[h];}else{return m;}};
g.prototype.getChangeHandler=function(s,h,o,m,l){var i,j;i=this._getInstanceSpecificChangeRegistryItem(s,o,m);if(i&&i.getChangeTypeMetadata){var k=i.getChangeTypeMetadata().getChangeHandler();if(k){return k;}}j=this._getChangeRegistryItem(s,h,l);if(j&&j.getChangeTypeMetadata){var O=j.getChangeTypeMetadata().getChangeHandler();if(O){return O;}}return undefined;};
g.prototype.registerControlForSimpleChange=function(s,o){var h;if(!s){return;}if(!o||!o.changeType||!o.changeHandler){return;}h=this._createChangeRegistryItemForSimpleChange(s,o);if(h){this.addRegistryItem(h);}};
g.prototype._createChangeRegistryItemForSimpleChange=function(s,o){var p,h,i,l;l=Object.assign({},this._oSettings.getDefaultLayerPermissions());var L=o.layers;if(L){Object.keys(L).forEach(function(j){if(l[j]===undefined){throw new Error("The Layer '"+j+"' is not supported. Please only use supported layers");}l[j]=L[j];});}p={name:o.changeType,changeHandler:o.changeHandler,layers:l};h=new a(p);p={changeTypeMetadata:h,controlType:s};i=new C(p);return i;};
g.prototype.addRegistryItem=function(r){var s,h;if(!r){return;}s=r.getChangeTypeName();h=r.getControlType();this._registeredItems[h]=this._registeredItems[h]||{};this._registeredItems[h][s]=r;};
g.prototype.removeRegistryItem=function(p){if(!p.changeTypeName&&!p.controlType){U.log.error("sap.ui.fl.registry.ChangeRegistry: ChangeType and/or ControlType required");return;}if(p.controlType&&p.changeTypeName){if(this._registeredItems[p.controlType]){if(Object.keys(this._registeredItems[p.controlType]).length===1){delete this._registeredItems[p.controlType];}else{delete this._registeredItems[p.controlType][p.changeTypeName];}}}else if(p.controlType){if(this._registeredItems[p.controlType]){delete this._registeredItems[p.controlType];}}else if(p.changeTypeName){for(var h in this._registeredItems){var i=this._registeredItems[h];delete i[p.changeTypeName];}}};
g.prototype.getRegistryItems=function(p){if(!p){U.log.error("sap.ui.fl.registry.ChangeRegistry: no parameters passed for getRegistryItems");}var s=p.changeTypeName;var h=p.controlType;if(!s&&!h){U.log.error("sap.ui.fl.registry.ChangeRegistry: Change Type Name and/or Control Type required");}var r=null;if(h&&s){var o=this._getOrLoadChangeHandler(h,s);if(o){r={};r[h]={};r[h][s]=o;}}else if(h){r={};r[h]={};if(this._registeredItems[h]){var i=Object.keys(this._registeredItems[h]);i.forEach(function(s){r[h][s]=this._getOrLoadChangeHandler(h,s);}.bind(this));}for(var k in this._oDefaultActiveChangeHandlers){r[h][k]=this._oDefaultActiveChangeHandlers[k];}}else if(s){r={};for(h in this._registeredItems){if(this._registeredItems[h][s]){r[h]={};r[h][s]=this._getOrLoadChangeHandler(h,s);}}r["defaultActiveForAllControls"]={};for(var j in this._oDefaultActiveChangeHandlers){r["defaultActiveForAllControls"][j]=this._oDefaultActiveChangeHandlers[j];}}this._filterChangeTypes(r,p.layer);return r;};
g.prototype._getOrLoadChangeHandler=function(s,h){var o=this._registeredItems[s];if(o){var i=o[h];if(i){var j=i.getChangeTypeMetadata();var k=j.getChangeHandler();if(typeof k==="string"){k=sap.ui.requireSync(k.replace(/\./g,"/"));j._changeHandler=k;}return i;}}var D=this._oDefaultActiveChangeHandlers[h];if(D){return D;}return null;};
g.prototype.initSettings=function(){this._oSettings=S.getInstanceOrUndef();if(!this._oSettings){this._oSettings=new S({});}};
g.prototype._filterChangeTypes=function(r,l){if(this._oSettings&&l&&r){var i=false;q.each(r,function(s,o){q.each(o,function(h,R){var L=R.getChangeTypeMetadata().getLayers();i=L[l];if(!i){U.log.warning("Change type "+h+" not enabled for layer "+l);delete o[h];}});});}};
g.prototype.getDragInfo=function(s){var h=this._registeredItems[s];if(h){return h.getDragInfo();}return null;};
return g;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeRegistryItem',["sap/ui/fl/Utils"],function(U){"use strict";var C=function(p){if(!p.changeTypeMetadata){U.log.error("sap.ui.fl.registry.ChangeRegistryItem: ChangeTypeMetadata required");}if(!p.controlType){U.log.error("sap.ui.fl.registry.ChangeRegistryItem: ControlType required");}this._changeTypeMetadata=p.changeTypeMetadata;this._controlType=p.controlType;if(p.permittedRoles){this._permittedRoles=p.permittedRoles;}if(p.dragTargets){this._dragTargets=p.dragTargets;}};C.prototype._changeTypeMetadata=undefined;C.prototype._controlType=undefined;C.prototype._permittedRoles={};C.prototype._dragTargets=[];
C.prototype.getChangeTypeMetadata=function(){return this._changeTypeMetadata;};
C.prototype.getChangeTypeName=function(){return this._changeTypeMetadata.getName();};
C.prototype.getControlType=function(){return this._controlType;};
C.prototype.getPermittedRoles=function(){return this._permittedRoles;};
C.prototype.getDragTargets=function(){return this._dragTargets;};
return C;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeTypeMetadata',["sap/ui/fl/Utils"],function(U){"use strict";var C=function(p){if(!p.name){U.log.error("sap.ui.fl.registry.ChangeType: Name required");}if(!p.changeHandler){U.log.error("sap.ui.fl.registry.ChangeType: ChangeHandler required");}this._name=p.name;this._changeHandler=p.changeHandler;this._layers=p.layers;if(p.labelKey){this._labelKey=p.labelKey;}if(p.tooltipKey){this._tooltipKey=p.tooltipKey;}if(p.iconKey){this._iconKey=p.iconKey;}if(p.sortIndex){this._sortIndex=p.sortIndex;}};C.prototype._name="";C.prototype._changeHandler="";C.prototype._layers=[];C.prototype._sortIndex=0;C.prototype._labelKey="";C.prototype._tooltipKey="";C.prototype._iconKey="";
C.prototype.getName=function(){return this._name;};
C.prototype.getChangeHandler=function(){return this._changeHandler;};
C.prototype.getLayers=function(){return this._layers;};
C.prototype.getLabel=function(){return this._labelKey;};
C.prototype.getTooltip=function(){return this._tooltipKey;};
C.prototype.getIcon=function(){return this._iconKey;};
C.prototype.getSortIndex=function(){return this._sortIndex;};
return C;},true);
sap.ui.predefine('sap/ui/fl/registry/Settings',["sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/Utils","sap/ui/base/EventProvider","sap/base/util/UriParameters"],function(L,C,U,E,a){"use strict";var S=function(s){E.apply(this);if(!s){throw new Error("no flex settings provided");}if(!s.defaultLayerPermissions){s.defaultLayerPermissions={"VENDOR":true,"CUSTOMER_BASE":true,"CUSTOMER":true,"USER":false};}if(!s.developerModeLayerPermissions){s.developerModeLayerPermissions={"VENDOR":true,"CUSTOMER_BASE":true,"CUSTOMER":false,"USER":false};}if(!(S._IS_VARIANT_SHARING_ENABLED in s)){s.isVariantSharingEnabled=true;}this._oSettings=s;this._hasMergeErrorOccured=false;};S.prototype=Object.create(E.prototype||null);S.events={flexibilityAdaptationButtonAllowedChanged:"flexibilityAdaptationButtonAllowedChanged",changeModeUpdated:"changeModeUpdated"};S._instance=undefined;S._bFlexChangeMode=true;S._bFlexibilityAdaptationButtonAllowed=false;S._oEventProvider=new E();S._IS_VARIANT_SHARING_ENABLED="isVariantSharingEnabled";
S.fireEvent=function(e,p){S._oEventProvider.fireEvent(e,p);};
S.attachEvent=function(e,c){S._oEventProvider.attachEvent(e,c);};
S.detachEvent=function(e,c){S._oEventProvider.detachEvent(e,c);};
S.getInstance=function(){if(S._instance){return Promise.resolve(S._instance);}var p=C.getFlexDataPromise();if(p){return p.then(function(f){var s={};if(f.changes&&f.changes.settings){s=f.changes.settings;}return S._storeInstance(s);},function(){return S._loadSettings();});}return S._loadSettings();};
S._loadSettings=function(){return L.createConnector().loadSettings().then(function(s){return S._storeInstance(s);});};
S._storeInstance=function(s){if(!S._instance){S._instance=new S(s);}return S._instance;};
S.getInstanceOrUndef=function(){var s;if(S._instance){s=S._instance;}return s;};
S.isFlexChangeMode=function(){var f=this._isFlexChangeModeFromUrl();if(f!==undefined){return f;}return S._bFlexChangeMode;};
S._isFlexChangeModeFromUrl=function(){var f;var u=new a(window.location.href);if(u.get('sap-ui-fl-changeMode')==='true'){f=true;}else if(u.get('sap-ui-fl-changeMode')==='false'){f=false;}return f;};
S.activateFlexChangeMode=function(){var f=true;S._setFlexChangeMode(f);};
S.leaveFlexChangeMode=function(){var f=false;S._setFlexChangeMode(f);};
S._setFlexChangeMode=function(f){if(S._bFlexChangeMode===f){return;}S._bFlexChangeMode=f;var p={bFlexChangeMode:f};S.fireEvent(S.events.changeModeUpdated,p);};
S.isFlexibilityAdaptationButtonAllowed=function(){return S._bFlexibilityAdaptationButtonAllowed;};
S.allowFlexibilityAdaptationButton=function(){var f=true;S.setFlexibilityAdaptationButtonAllowed(f);};
S.disallowFlexibilityAdaptationButton=function(){var f=false;S.setFlexibilityAdaptationButtonAllowed(f);};
S.setFlexibilityAdaptationButtonAllowed=function(f){if(S._bFlexibilityAdaptationButtonAllowed===f){return;}S._bFlexibilityAdaptationButtonAllowed=f;var p={bFlexibilityAdaptationButtonAllowed:f};S.fireEvent(S.events.flexibilityAdaptationButtonAllowedChanged,p);};
S.prototype._getBooleanProperty=function(p){var v=false;if(this._oSettings[p]){v=this._oSettings[p];}return v;};
S.prototype.isKeyUser=function(){return this._getBooleanProperty("isKeyUser");};
S.prototype.isModelS=function(){return this._getBooleanProperty("isAtoAvailable");};
S.prototype.isAtoEnabled=function(){return this._getBooleanProperty("isAtoEnabled");};
S.prototype.isAtoAvailable=function(){return this._getBooleanProperty("isAtoAvailable");};
S.prototype.isProductiveSystem=function(){return this._getBooleanProperty("isProductiveSystem");};
S.prototype.isTrial=function(){return this._getBooleanProperty("isTrial");};
S.prototype.isVariantSharingEnabled=function(){return(this._oSettings.isVariantSharingEnabled===true);};
S.prototype.setMergeErrorOccured=function(e){this._hasMergeErrorOccoured=e;};
S.prototype.hasMergeErrorOccured=function(){return this._hasMergeErrorOccured;};
S.prototype.getDefaultLayerPermissions=function(){return this._oSettings.defaultLayerPermissions;};
S.prototype.getDeveloperModeLayerPermissions=function(){return this._oSettings.developerModeLayerPermissions;};
return S;},true);
sap.ui.predefine('sap/ui/fl/registry/SimpleChanges',["sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange"],function(H,U,S,a,M,b,P,c){"use strict";var d={hideControl:{changeType:"hideControl",changeHandler:H},unhideControl:{changeType:"unhideControl",changeHandler:U},stashControl:{changeType:"stashControl",changeHandler:S},unstashControl:{changeType:"unstashControl",changeHandler:a},moveElements:{changeType:"moveElements",changeHandler:M},moveControls:{changeType:"moveControls",changeHandler:b},propertyChange:{changeType:"propertyChange",changeHandler:P},propertyBindingChange:{changeType:"propertyBindingChange",changeHandler:c}};return d;},true);
sap.ui.predefine('sap/ui/fl/transport/TransportDialog',["sap/m/List","sap/m/InputListItem",'sap/m/Button','sap/m/ComboBox','sap/m/Dialog','sap/m/DialogRenderer','sap/m/Input','sap/m/Label','sap/m/MessageToast','sap/ui/core/ListItem','sap/ui/fl/transport/Transports'],function(L,I,B,C,D,a,b,c,M,d,T){"use strict";
var e=D.extend("sap.ui.fl.transport.TransportDialog",{
metadata:{library:"sap.ui.fl",properties:{pkg:{type:"string",group:"Misc",defaultValue:null},transports:{type:"any",group:"Misc",defaultValue:null},lrepObject:{type:"any",group:"Misc",defaultValue:null},hidePackage:{type:"boolean",group:"Misc",defaultValue:null}},events:{ok:{},cancel:{}}},
renderer:a.render
});
e.prototype.init=function(){D.prototype.init.apply(this);this._oResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE"));this._oPackageLabel=null;this._oPackage=this._createPackageField();this._oTransport=this._createTransportCombo();this.addContent(this._createContentList());this._createButtons();this.setEscapeHandler(function(p){this.fireCancel();p.resolve();}.bind(this));};
e.prototype._createContentList=function(){this._oPackageListItem=new I({label:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE"),content:[this._oPackage]});this._oTransportListItem=new I({label:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT"),content:[this._oTransport]});return new L({items:[this._oPackageListItem,this._oTransportListItem]});};
e.prototype._createButtons=function(){var t=this;this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),press:function(){t._onLocal();}}));this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_OK"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_OK"),enabled:false,press:function(){t._onOkay();}}));this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),press:function(){t.fireCancel();t.close();t.destroy();}}));};
e.prototype._onLocal=function(){this.fireOk({selectedTransport:"",selectedPackage:this.getPkg()||"$TMP",dialog:true});this.close();this.destroy();};
e.prototype._onOkay=function(){var t=this._oTransport.getSelectedKey();if(this._checkOkay(t)){this.fireOk({selectedTransport:t,selectedPackage:this.getPkg()||this._oPackage.getValue(),dialog:true});this.close();this.destroy();}else{this.getButtons()[1].setEnabled(false);this._oTransport.setValueState(sap.ui.core.ValueState.Error);this._oTransport.setValueStateText(this.getTitle());}};
e.prototype._checkOkay=function(t){if(t){return true;}return false;};
e.prototype._createTransportCombo=function(){var t=this;return new C({showSecondaryValues:true,enabled:false,tooltip:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"),width:"100%",selectionChange:function(){if(t._oPackageListItem.getVisible()&&!t._oPackage.getValue()){return;}t.getButtons()[1].setEnabled(true);t._oTransport.setValueState(sap.ui.core.ValueState.None);},change:function(E){var f=function(i){if((i&&E.mParameters.newValue!==i.getText())||!i){return true;}return false;};if(E&&E.mParameters&&E.mParameters.newValue){if(f(t._oTransport.getSelectedItem())){t.getButtons()[1].setEnabled(false);t._oTransport.setValueState(sap.ui.core.ValueState.Error);t._oTransport.setValueStateText(t._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"));}}}});};
e.prototype._createPackageField=function(){var t=this;return new b({tooltip:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE_TT"),width:"100%",change:function(){var o,p,O;O=t._createObjectInfo();o=new sap.ui.fl.transport.Transports();p=o.getTransports(O);p.then(function(r){t._onPackageChangeSuccess(r);},function(r){t._onPackageChangeError(r);});},liveChange:function(E){if(E.mParameters.liveValue&&E.mParameters.liveValue.length>3){t._oTransport.setEnabled(true);}}});};
e.prototype._createObjectInfo=function(){var o,r={"package":this._oPackage.getValue()||""};o=this.getProperty("lrepObject");if(o){if(o.name){r.name=o.name;}if(o.type){r.type=o.type;}if(o.namespace){r.namespace=o.namespace;}}return r;};
e.prototype._onPackageChangeSuccess=function(t){if(t){if(t.localonly){this._oTransport.setEnabled(false);this.getButtons()[1].setEnabled(true);}else if(t.transports&&t.transports.length>0){this._oTransport.setEnabled(true);this._setTransports(t);}else if(t.errorCode){this.getButtons()[1].setEnabled(false);this._oPackage.setValueState(sap.ui.core.ValueState.Error);this._oPackage.setValueStateText(this._oResources.getText("TRANSPORT_DIALOG_"+t.errorCode));this._setTransports(t);}else{M.show(this._oResources.getText("TRANSPORT_DIALOG_NO_TRANSPORTS"));}}};
e.prototype._setTransports=function(t){var l,f;l=this._hasLock(t.transports);if(l){f=[l];}else{f=t.transports;}this.setTransports(f);if(f&&f.length===1){this._oTransport.setValue(f[0].description,true);this.getButtons()[1].setEnabled(true);}if(!f||f.length===0){this._oTransport.setSelectedKey(null);this._oTransport.setValueState(sap.ui.core.ValueState.None);this.getButtons()[1].setEnabled(false);}};
e.prototype._onPackageChangeError=function(r){M.show(r);this.setTransports([]);};
e.prototype._hasLock=function(t){var o,l=t.length;while(l--){o=t[l];if(o.locked){return o;}}return null;};
e.prototype.setPkg=function(p){if(p&&!this.getProperty("pkg")){this.setProperty("pkg",p);this._oPackage.setValue(p);this._oPackage.setEnabled(false);this._oTransport.setEnabled(true);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));this.getButtons()[0].setVisible(false);}return this;};
e.prototype.setTransports=function(s){var i,l=0,o;if(s){this.setProperty("transports",s);this._oTransport.removeAllItems();l=s.length;for(i=0;i<l;i++){o=s[i];this._oTransport.addItem(new d({key:o.transportId,text:o.transportId,additionalText:o.description}));}if(l===1){this._oTransport.setSelectedKey(s[0].transportId);this.getButtons()[1].setEnabled(true);}if(l>0){this._oTransport.setEnabled(true);}}return this;};
e.prototype.setLrepObject=function(o){if(o&&!this.getProperty("lrepObject")){this.setProperty("lrepObject",o);}return this;};
e.prototype.setHidePackage=function(h){this.setProperty("hidePackage",h);this._oPackageListItem.setVisible(!h);if(h){this.getButtons()[0].setEnabled(h);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));}return this;};
return e;},true);
sap.ui.predefine('sap/ui/fl/transport/TransportSelection',["sap/ui/fl/Utils","sap/ui/fl/transport/Transports","sap/ui/fl/transport/TransportDialog","sap/ui/fl/registry/Settings"],function(U,T,a,F){"use strict";var b=function(){this.oTransports=new sap.ui.fl.transport.Transports();};
b.prototype.selectTransport=function(o,O,e,c,C,s){var t=this;if(o){var l=U.getCurrentLayer(false);if(l&&l==='CUSTOMER'){F.getInstance().then(function(S){if(S.isAtoEnabled()){var d={transportId:"ATO_NOTIFICATION"};O(t._createEventObject(o,d));}else{t._selectTransport(o,O,e,c,s);}});}else{t._selectTransport(o,O,e,c,s);}}};
b.prototype._selectTransport=function(o,O,e,c,s){var t=this;if(o){this.oTransports.getTransports(o).then(function(g){var d;if(t._checkDialog(g)){t._openDialog({hidePackage:!U.doesSharedVariantRequirePackage(),pkg:o.package,transports:g.transports,lrepObject:t._toLREPObject(o)},O,e,c,s);}else{d=t._getTransport(g);O(t._createEventObject(o,d));}},function(r){e(r);});}};
b.prototype._createEventObject=function(o,t){return{mParameters:{selectedTransport:t.transportId,selectedPackage:o["package"],dialog:false},getParameters:function(){return this.mParameters;},getParameter:function(n){return this.mParameters[n];}};};
b.prototype._toLREPObject=function(o){var O={};if(o.namespace){O.namespace=o.namespace;}if(o.name){O.name=o.name;}if(o.type){O.type=o.type;}return O;};
b.prototype._openDialog=function(c,o,e,C,s){var d=new a(c);d.attachOk(o);d.attachCancel(e);d.addStyleClass(s);if(C){d.addStyleClass("sapUiSizeCompact");}else{d.removeStyleClass("sapUiSizeCompact");}d.open();return d;};
b.prototype._getTransport=function(t){var o;if(!t.localonly){o=this._hasLock(t.transports);}else{o={transportId:""};}return o;};
b.prototype._checkDialog=function(t){if(t){if(t.localonly||this._hasLock(t.transports)){return false;}}return true;};
b.prototype._hasLock=function(t){var l=t.length;while(l--){var o=t[l];if(o.locked){return o;}}return false;};
b.prototype.setTransports=function(c,C){var i=c.length-1;var t=this;var s=function(c,i,C,d,f){if(i>=0){var o=c[i];if(f===true){if(o.getDefinition().packageName!=="$TMP"){o.setRequest(d);}i--;return s(c,i,C,d,f);}else{if(o.getDefinition().packageName!=="$TMP"){return t.openTransportSelection(o,C).then(function(e){o.setRequest(e.transport);if(e.fromDialog===true){d=e.transport;f=true;}i--;return s(c,i,C,d,f);},function(){return null;});}else{i--;return s(c,i,C,d,f);}}}else{return Promise.resolve();}};return s(c,i,C);};
b.prototype.openTransportSelection=function(c,C,s){var t=this;return new Promise(function(r,d){var o=function(R){if(R&&R.getParameters){var f=R.getParameters().selectedTransport;var p=R.getParameters().selectedPackage;var g=R.getParameters().dialog;var h={transport:f,packageName:p,fromDialog:g};r(h);}else{r({});}};var e=function(E){if(E.sId==='cancel'){r();}else{d(E);}};var O={};if(c){O["package"]=c.getPackage();O.namespace=c.getNamespace();O.name=c.getId();O.type=c.getDefinition().fileType;}t.selectTransport(O,o,e,false,C,s);});};
b.prototype.checkTransportInfo=function(t){return t&&t.transport&&t.packageName!=="$TMP";};
b.prototype._prepareChangesForTransport=function(t,A,c,C){var o=new T();var d=o._convertToChangeTransportData(A,c);var e={};e.package=t.packageName;e.transportId=t.transport;e.changeIds=d;e.reference=C.reference;e.appVersion=C.appVersion;e.layer=C.layer;return o.makeChangesTransportable(e).then(function(){A.forEach(function(f){if(f.getPackage()==='$TMP'){var D=f.getDefinition();D.packageName=t.packageName;f.setResponse(D);}});});};
return b;},true);
sap.ui.predefine('sap/ui/fl/transport/Transports',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils"],function(L,F){"use strict";var T=function(){};
T.prototype.getTransports=function(p){var u,c,l,P;u='/sap/bc/lrep/actions/gettransports/';if(p['package']){u+='&package='+p['package'];}if(p.name){u+='&name='+p.name;}if(p.namespace){u+='&namespace='+p.namespace;}if(p.type){u+='&type='+p.type;}c=F.getClient();if(c){u+='&sap-client='+c;}u=u.replace('&','?');l=L.createConnector();P=l.send(u);return P.then(function(r){if(r.response){if(!r.response.localonly){r.response.localonly=false;}if(!r.response.errorCode){r.response.errorCode="";}return Promise.resolve(r.response);}else{return Promise.reject('response is empty');}});};
T.prototype.makeChangesTransportable=function(p){var u,c,l;u='/sap/bc/lrep/actions/make_changes_transportable/';c=F.getClient();if(c){u+='?sap-client='+c;}if(!p.transportId){return Promise.reject(new Error("no transportId provided as attribute of mParameters"));}if(!p.changeIds){return Promise.reject(new Error("no changeIds provided as attribute of mParameters"));}l=L.createConnector();return l.send(u,'POST',p);};
T.prototype._convertToChangeTransportData=function(l){var t=[];var a=l.length;for(var i=0;i<a;i++){var c=l[i];var d={};d.namespace=c.getNamespace();d.fileName=c.getId();d.fileType=c.getDefinition().fileType;t.push(d);}return t;};
return T;},true);
sap.ui.predefine('sap/ui/fl/variants/VariantController',["sap/ui/fl/Utils","sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Cache","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/base/ManagedObject","sap/ui/core/Component"],function(U,C,V,a,J,M,b){"use strict";var c=function(s,A,o){this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;this._mVariantManagement={};this._setChangeFileContent(o,{});this.sVariantTechnicalParameterName="sap-ui-fl-control-variant-id";this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");};
c.prototype.getComponentName=function(){return this._sComponentName;};
c.prototype.getAppVersion=function(){return this._sAppVersion;};
c.prototype._setChangeFileContent=function(o,t){var d=a.getEntry(this.getComponentName(),this.getAppVersion());if(Object.keys(this._mVariantManagement).length===0){this._mVariantManagement={};}if(o&&o.changes&&o.changes.variantSection){Object.keys(o.changes.variantSection).forEach(function(v){this._mVariantManagement[v]={};var e=o.changes.variantSection[v];var f=e.variants.concat();var s;var i=-1;f.forEach(function(g,h){if(g.content.fileName===v){i=h;}if(!g.content.content.favorite){g.content.content.favorite=true;}if(!g.content.content.visible){g.content.content.visible=true;}var T=g.content.content.title.match(/.i18n>(\w+)./);if(T){g.content.content.title=this._oResourceBundle.getText(T[1]);}this._applyChangesOnVariant(g);if(t&&Array.isArray(t[this.sVariantTechnicalParameterName])){t[this.sVariantTechnicalParameterName].some(function(u){if(g.content.fileName===u){s=g.content.fileName;return true;}});}}.bind(this));if(i>-1){var S=f.splice(i,1)[0];f.sort(this.compareVariants);f.splice(0,0,S);}this._mVariantManagement[v].variants=f;this._mVariantManagement[v].defaultVariant=v;if(s){this._mVariantManagement[v].currentVariant=s;}this._mVariantManagement[v].variantManagementChanges=o.changes.variantSection[v].variantManagementChanges;this._applyChangesOnVariantManagement(this._mVariantManagement[v]);}.bind(this));d.file.changes.variantSection=this._mVariantManagement;}};
c.prototype._getChangeFileContent=function(){return this._mVariantManagement;};
c.prototype.compareVariants=function(v,o){if(v.content.content.title.toLowerCase()<o.content.content.title.toLowerCase()){return-1;}else if(v.content.content.title.toLowerCase()>o.content.content.title.toLowerCase()){return 1;}else{return 0;}};
c.prototype.getVariants=function(v){var d=this._mVariantManagement[v]&&this._mVariantManagement[v].variants;return d?d:[];};
c.prototype.getVariant=function(v,s){var o;var d=this.getVariants(v);d.some(function(e){if(e.content.fileName===s){o=e;return true;}});return o;};
c.prototype.getVariantChanges=function(v,s,d){var e=s||this._mVariantManagement[v].defaultVariant;var o=this.getVariant(v,e);var r=o.controlChanges;if(d){r=r.map(function(f,i){var g;if(!f.getDefinition){g=new C(f);o.controlChanges.splice(i,1,g);}else{g=f;}return g;});}return r;};
c.prototype._getReferencedChanges=function(v,o){var r=[];if(o.content.variantReference){r=this.getVariantChanges(v,o.content.variantReference,true);return r.filter(function(R){return U.compareAgainstCurrentLayer(R.getDefinition().layer)===-1;});}return r;};
c.prototype.setVariantChanges=function(v,s,d){if(!v||!s||!Array.isArray(d)){U.log.error("Cannot set variant changes without Variant reference");return;}return this._mVariantManagement[v].variants.some(function(o,i){if(o.content.fileName===s){o.controlChanges=d;return true;}});};
c.prototype._setVariantData=function(m,v,p){var d=this._mVariantManagement[v].variants;var o=d[p];Object.keys(m).forEach(function(P){if(o.content.content[P]){o.content.content[P]=m[P];}});if(o.content.fileName!==v){d.splice(p,1);var s=this._getIndexToSortVariant(d.slice(1),o);d.splice(s+1,0,o);return s+1;}else{d.splice(p,1,o);return p;}};
c.prototype._updateChangesForVariantManagementInMap=function(o,v,A){var d=this._mVariantManagement[v];var s=o.changeType;if(o.fileType==="ctrl_variant_change"){d.variants.some(function(e){if(e.content.fileName===o.selector.id){if(!e.variantChanges[s]){e.variantChanges[s]=[];}if(A){e.variantChanges[s].push(o);}else{e.variantChanges[s].some(function(E,i){if(E.fileName===o.fileName){e.variantChanges[s].splice(i,1);return true;}});}return true;}});}else if(o.fileType==="ctrl_variant_management_change"){if(!d.variantManagementChanges){d.variantManagementChanges={};}if(!d.variantManagementChanges[s]){d.variantManagementChanges[s]=[];}if(A){d.variantManagementChanges[s].push(o);}else{d.variantManagementChanges[s].some(function(e,i){if(e.fileName===o.fileName){d.variantManagementChanges[s].splice(i,1);return true;}});}}};
c.prototype.loadInitialChanges=function(){return Object.keys(this._mVariantManagement).reduce(function(i,v){var s=this._mVariantManagement[v].currentVariant?"currentVariant":"defaultVariant";var I=this.getVariant(v,this._mVariantManagement[v][s]);if(!I||!I.content.content.visible){this._mVariantManagement[v][s]=v;}return i.concat(this.getVariantChanges(v,this._mVariantManagement[v][s],false));}.bind(this),[]);};
c.prototype.getChangesForVariantSwitch=function(p){var d=this.getVariantChanges(p.variantManagementReference,p.currentVariantReference,true);var m=[],e=[];var o=p.component instanceof b?p.component:undefined;Object.keys(p.changesMap).forEach(function(f){p.changesMap[f].forEach(function(g){m=m.concat(g);e=e.concat(g.getId());});});d=d.reduce(function(f,g){var i=e.indexOf(g.getDefinition().fileName);if(i>-1){f=f.concat(m[i]);if(!o&&Array.isArray(p.component)){o=this._getComponentForChange(m[i],p.component);}}return f;}.bind(this),[]);var n=this.getVariantChanges(p.variantManagementReference,p.newVariantReference,true);var r=[];if(n.length>0){r=d.slice();d.some(function(f){if(n[0]&&f.getId()===n[0].getId()){n.shift();r.shift();}else{return true;}});}else{r=d;}var s={aRevert:r.reverse(),aNew:n,component:o};return s;};
c.prototype._getComponentForChange=function(o,d){var s=o.getSelector&&o.getSelector();var e;if(s){d.some(function(f){if(J.bySelector(s,f)instanceof M){e=f;return true;}});}return e;};
c.prototype._applyChangesOnVariant=function(v){var m=v.variantChanges,A;Object.keys(m).forEach(function(s){switch(s){case"setTitle":A=this._getActiveChange(s,m);if(A){v.content.content.title=A.getText("title");}break;case"setFavorite":A=this._getActiveChange(s,m);if(A){v.content.content.favorite=A.getContent().favorite;}break;case"setVisible":A=this._getActiveChange(s,m);if(A){v.content.content.visible=A.getContent().visible;}break;default:U.log.error("No valid changes on variant "+v.content.content.title+" available");}}.bind(this));};
c.prototype._applyChangesOnVariantManagement=function(v){var m=v.variantManagementChanges,A;if(Object.keys(m).length>0){A=this._getActiveChange("setDefault",m);if(A){v.defaultVariant=A.getContent().defaultVariant;}}};
c.prototype._getActiveChange=function(s,m){var l=m[s].length-1;if(l>-1){return new C(m[s][l]);}return false;};
c.prototype._fillVariantModel=function(){var v={};Object.keys(this._mVariantManagement).forEach(function(k){v[k]={defaultVariant:this._mVariantManagement[k].defaultVariant,variants:[]};if(this._mVariantManagement[k].currentVariant){v[k].currentVariant=this._mVariantManagement[k].currentVariant;}this.getVariants(k).forEach(function(o,i){v[k].variants[i]=JSON.parse(JSON.stringify({key:o.content.fileName,title:o.content.content.title,layer:o.content.layer,favorite:o.content.content.favorite,visible:o.content.content.visible}));});}.bind(this));return v;};
c.prototype.updateCurrentVariantInMap=function(v,n){this._mVariantManagement[v].currentVariant=n;};
c.prototype.addChangeToVariant=function(o,v,s){var n=this.getVariantChanges(v,s,true);var d=n.map(function(o){return o.getDefinition().fileName;});var i=d.indexOf(o.getDefinition().fileName);if(i===-1){n.push(o);return this.setVariantChanges(v,s,n);}return false;};
c.prototype.removeChangeFromVariant=function(o,v,s){var n=this.getVariantChanges(v,s,true);n.forEach(function(d,i){if(d.getId&&(d.getId()===o.getId())){n.splice(i,1);}});return this.setVariantChanges(v,s,n,true);};
c.prototype.addVariantToVariantManagement=function(v,s){var d=this._mVariantManagement[s].variants.slice().splice(1);var i=this._getIndexToSortVariant(d,v);if(v.content.variantReference){var r=this._getReferencedChanges(s,v);v.controlChanges=r.concat(v.controlChanges);}this._mVariantManagement[s].variants.splice(i+1,0,v);return i+1;};
c.prototype._getIndexToSortVariant=function(v,o){var i=0;v.some(function(e,d){if(this.compareVariants(o,e)<0){i=d;return true;}i=d+1;}.bind(this));return i;};
c.prototype.removeVariantFromVariantManagement=function(v,s){var i;var f=this._mVariantManagement[s].variants.some(function(o,d){var e=new V(o);if(e.getId()===v.getId()){i=d;return true;}});if(f){this._mVariantManagement[s].variants.splice(i,1);}return i;};
c.prototype.resetMap=function(){this._mVariantManagement={};};
return c;},true);
sap.ui.predefine('sap/ui/fl/variants/util/VariantUtil',["sap/ui/thirdparty/jquery","sap/ui/core/Component","sap/ui/fl/Utils","sap/ui/core/routing/History","sap/ui/core/routing/HashChanger","sap/base/Log","sap/base/util/deepEqual","sap/ui/base/ManagedObjectObserver"],function(q,C,f,H,a,L,d,M){"use strict";var V={variantTechnicalParameterName:"sap-ui-fl-control-variant-id",initializeHashRegister:function(){this._oHashRegister={currentIndex:null,hashParams:[],variantControlIds:[]};V._setOrUnsetCustomNavigationForParameter.call(this,true);},attachHashHandlers:function(v,u){if(this._oHashRegister.currentIndex===null){var h=a.getInstance();var o=function(){V._setOrUnsetCustomNavigationForParameter.call(this,false);h.detachEvent("hashReplaced",V._handleHashReplaced,this);h.detachEvent("hashChanged",V._navigationHandler,this);this.oVariantController.resetMap();this.destroy();this.oComponentDestroyObserver.unobserve(this.oComponent,{destroy:true});this.oComponentDestroyObserver.destroy();};if(!this.oComponentDestroyObserver&&this.oComponent instanceof C){this.oComponentDestroyObserver=new M(o.bind(this));this.oComponentDestroyObserver.observe(this.oComponent,{destroy:true});}if(u){h.attachEvent("hashReplaced",V._handleHashReplaced,this);h.attachEvent("hashChanged",V._navigationHandler,this);V._navigationHandler.call(this);}}if(u){if(Array.isArray(this._oHashRegister.variantControlIds[this._oHashRegister.variantControlIds])){this._oHashRegister.variantControlIds[this._oHashRegister.currentIndex].push(v);}else{this._oHashRegister.variantControlIds[this._oHashRegister.currentIndex]=[v];}}},updateHasherEntry:function(p){if(!p||!Array.isArray(p.parameters)){L.info("Variant URL parameters could not be updated since invalid parameters were received");return;}if(p.updateURL){f.setTechnicalURLParameterValues(p.component||this.oComponent,V.variantTechnicalParameterName,p.parameters);}if(!p.ignoreRegisterUpdate){this._oHashRegister.hashParams[this._oHashRegister.currentIndex]=p.parameters;}},_handleHashReplaced:function(e){this._sReplacedHash=e.getParameter("sHash");},_navigationHandler:function(e){var D;var n=e&&e.getParameter("newHash");if(n&&this._sReplacedHash===n){delete this._sReplacedHash;return;}if(this._oHashRegister.currentIndex===null){this._oHashRegister.currentIndex=0;D="NewEntry";}else{D=H.getInstance().getDirection();switch(D){case"Backwards":this._oHashRegister.currentIndex--;break;case"Forwards":case"NewEntry":this._oHashRegister.currentIndex++;break;case"Unknown":this._oHashRegister.currentIndex=0;this._oHashRegister.hashParams=[];this._oHashRegister.variantControlIds=[];this.switchToDefaultForVariant();break;default:return;}}if(this._oHashRegister.currentIndex>=0){var v;var p={};if(D==="NewEntry"||D==="Unknown"){var h=f.getParsedURLHash()&&f.getParsedURLHash().params;v=(h&&h[V.variantTechnicalParameterName])||[];var E=this._oHashRegister.variantControlIds[this._oHashRegister.currentIndex];if(Array.isArray(E)){E.forEach(function(P){this.switchToDefaultForVariantManagement(P);}.bind(this));}p={parameters:v.map(function(P){return decodeURIComponent(P);})};}else{v=this._oHashRegister.hashParams[this._oHashRegister.currentIndex];p={parameters:v,updateURL:true,ignoreRegisterUpdate:true};}}else{p={parameters:[],updateURL:true,ignoreRegisterUpdate:true};}this.updateHasherEntry(p);},_setOrUnsetCustomNavigationForParameter:function(s){var m=s?"registerNavigationFilter":"unregisterNavigationFilter";var u=f.getUshellContainer();if(u){u.getService("ShellNavigation")[m](V._navigationFilter);}},_navigationFilter:function(n,o){var u=f.getUshellContainer();var U=u.getService("URLParsing");var s=u.getService("ShellNavigation");var O=U.parseShellHash(o);var N=U.parseShellHash(n);var S=O&&N&&(O.params.hasOwnProperty(V.variantTechnicalParameterName)||N.params.hasOwnProperty(V.variantTechnicalParameterName))&&!d(O.params[V.variantTechnicalParameterName],N.params[V.variantTechnicalParameterName]);if(S){for(var k in O){if(k!=="params"&&k!=="appSpecificRoute"&&O[k]!==N[k]){S=false;break;}}}if(S){S=!([O,N].some(function(p){if(p.params.hasOwnProperty(V.variantTechnicalParameterName)){return Object.keys(p.params).length>1;}return Object.keys(p.params).length>0;}));}if(S){var A=(N.appSpecificRoute||"  ").substring(2);var b=(O.appSpecificRoute||"  ").substring(2);s.hashChanger.fireEvent("hashChanged",{newHash:A,oldHash:b});return{status:s.NavigationFilterStatus.Custom};}return s.NavigationFilterStatus.Continue;},getCurrentHashParamsFromRegister:function(){if(q.isNumeric(this._oHashRegister.currentIndex)&&this._oHashRegister.currentIndex>=0){return Array.prototype.slice.call(this._oHashRegister.hashParams[this._oHashRegister.currentIndex]);}}};return V;},true);
sap.ui.require.preload({
	"sap/ui/fl/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.fl","type":"library","embeds":["support/apps/contentbrowser","support/apps/uiFlexibilityDiagnostics"],"applicationVersion":{"version":"1.60.20"},"title":"SAPUI5 library with sap.ui.fl controls.","description":"SAPUI5 library with sap.ui.fl controls.","ach":"CA-UI5-FL","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.60","libs":{"sap.ui.core":{"minVersion":"1.60.20"},"sap.m":{"minVersion":"1.60.20"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.ui.fl.variants.VariantManagement"]}}}}'
},"sap/ui/fl/library-preload"
);
//# sourceMappingURL=library-preload.js.map