/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/Log","sap/ui/core/format/NumberFormat","sap/ui/model/FormatException","sap/ui/model/ParseException","sap/ui/model/ValidateException","sap/ui/model/odata/ODataUtils","sap/ui/model/odata/type/ODataType","sap/ui/thirdparty/jquery"],function(L,N,F,P,V,B,O,q){"use strict";var r=/^[-+]?(\d+)(?:\.(\d+))?$/;function g(t){var f,S;if(!t.oFormat){f={groupingEnabled:true,maxIntegerDigits:Infinity};S=a(t);if(S!==Infinity){f.minFractionDigits=f.maxFractionDigits=S;}f=q.extend(f,t.oFormatOptions);f.parseAsString=true;t.oFormat=N.getFloatInstance(f);}return t.oFormat;}function a(t){return(t.oConstraints&&t.oConstraints.scale)||0;}function b(k,p){return sap.ui.getCore().getLibraryResourceBundle().getText(k,p);}function s(t,c){var n,p,v,S,d;function l(j,k){L.warning("Illegal "+k+": "+j,null,t.getName());}function e(j,k,m,o){var u=typeof j==="string"?parseInt(j,10):j;if(u===undefined){return k;}if(typeof u!=="number"||isNaN(u)||u<m){l(j,o);return k;}return u;}function f(j,k){if(j){if(j.match(r)){return j;}l(j,k);}}function h(j,k){if(j===true||j==="true"){return true;}if(j!==undefined&&j!==false&&j!=="false"){l(j,k);}}function i(j,k,m){if(k!==m){t.oConstraints=t.oConstraints||{};t.oConstraints[j]=k;}}t.oConstraints=undefined;if(c){n=c.nullable;v=c.precision;d=c.scale;S=d==="variable"?Infinity:e(d,0,0,"scale");p=e(v,Infinity,1,"precision");if(S!==Infinity&&p<=S){L.warning("Illegal scale: must be less than precision (precision="+v+", scale="+d+")",null,t.getName());S=Infinity;}i("precision",p,Infinity);i("scale",S,0);if(n===false||n==="false"){i("nullable",false,true);}else if(n!==undefined&&n!==true&&n!=="true"){l(n,"nullable");}i("minimum",f(c.minimum,"minimum"));i("minimumExclusive",h(c.minimumExclusive,"minimumExclusive"));i("maximum",f(c.maximum,"maximum"));i("maximumExclusive",h(c.maximumExclusive,"maximumExclusive"));}t._handleLocalizationChange();}var D=O.extend("sap.ui.model.odata.type.Decimal",{constructor:function(f,c){O.apply(this,arguments);this.oFormatOptions=f;s(this,c);}});D.prototype.formatValue=function(v,t){if(v===null||v===undefined){return null;}switch(this.getPrimitiveType(t)){case"any":return v;case"float":return parseFloat(v);case"int":return Math.floor(parseFloat(v));case"string":return g(this).format(v);default:throw new F("Don't know how to format "+this.getName()+" to "+t);}};D.prototype.parseValue=function(v,S){var R;if(v===null||v===""){return null;}switch(this.getPrimitiveType(S)){case"string":R=g(this).parse(v);if(!R){throw new P(sap.ui.getCore().getLibraryResourceBundle().getText("EnterNumber"));}if(R.indexOf(".")>=0){R=R.replace(/0+$/,"").replace(/\.$/,"");}break;case"int":case"float":R=N.getFloatInstance({maxIntegerDigits:Infinity,decimalSeparator:".",groupingEnabled:false}).format(v);break;default:throw new P("Don't know how to parse "+this.getName()+" from "+S);}return R;};D.prototype._handleLocalizationChange=function(){this.oFormat=null;};D.prototype.validateValue=function(v){var f,i,m,M,c,d,e,p,S;if(v===null&&(!this.oConstraints||this.oConstraints.nullable!==false)){return;}if(typeof v!=="string"){throw new V(b("EnterNumber"));}m=r.exec(v);if(!m){throw new V(b("EnterNumber"));}i=m[1].length;f=(m[2]||"").length;S=a(this);p=(this.oConstraints&&this.oConstraints.precision)||Infinity;d=this.oConstraints&&this.oConstraints.minimum;M=this.oConstraints&&this.oConstraints.maximum;if(f>S){if(S===0){throw new V(b("EnterInt"));}else if(i+S>p){throw new V(b("EnterNumberIntegerFraction",[p-S,S]));}throw new V(b("EnterNumberFraction",[S]));}if(S===Infinity){if(i+f>p){throw new V(b("EnterNumberPrecision",[p]));}}else if(i>p-S){throw new V(b("EnterNumberInteger",[p-S]));}if(d){e=this.oConstraints.minimumExclusive;if(B.compare(d,v,true)>=(e?0:1)){throw new V(b(e?"EnterNumberMinExclusive":"EnterNumberMin",[this.formatValue(d,"string")]));}}if(M){c=this.oConstraints.maximumExclusive;if(B.compare(M,v,true)<=(c?0:-1)){throw new V(b(c?"EnterNumberMaxExclusive":"EnterNumberMax",[this.formatValue(M,"string")]));}}};D.prototype.getName=function(){return"sap.ui.model.odata.type.Decimal";};return D;});
