/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/URI','sap/ui/model/BindingMode','sap/ui/model/Context','sap/ui/model/Model','sap/ui/model/odata/v2/ODataAnnotations','sap/ui/model/odata/ODataUtils','sap/ui/model/odata/CountMode','sap/ui/model/odata/UpdateMethod','sap/ui/model/odata/OperationMode','./ODataContextBinding','./ODataListBinding','sap/ui/model/odata/ODataMetadata','sap/ui/model/odata/ODataPropertyBinding','./ODataTreeBinding','sap/ui/model/FilterProcessor','sap/ui/model/odata/ODataMetaModel','sap/ui/core/message/MessageParser','sap/ui/model/odata/ODataMessageParser','sap/ui/thirdparty/datajs',"sap/base/Log","sap/base/assert","sap/base/util/uid","sap/base/util/UriParameters","sap/base/util/deepEqual","sap/base/util/merge","sap/base/security/encodeURL","sap/ui/thirdparty/jquery","sap/base/util/isPlainObject"],function(U,B,C,M,O,a,b,c,d,e,f,g,h,l,F,m,o,p,q,L,r,u,s,t,v,w,Q,x){"use strict";var y=M.extend("sap.ui.model.odata.v2.ODataModel",{constructor:function(S,P){M.apply(this,arguments);var i,j,H,T,W,k,n,R,z,D,E,G,I,J,K,N,V,X,Y,Z,$,_,a1,b1,c1,d1,e1=this;if(typeof(S)==="object"){P=S;S=P.serviceUrl;}if(P){i=P.user;j=P.password;H=P.headers;T=P.tokenHandling;W=P.withCredentials;k=P.maxDataServiceVersion;n=P.useBatch;R=P.refreshAfterChange;z=P.annotationURI;D=P.loadAnnotationsJoined;I=P.defaultBindingMode;E=P.defaultCountMode;G=P.preliminaryContext;J=P.defaultOperationMode;K=P.metadataNamespaces;N=P.serviceUrlParams;V=P.metadataUrlParams;X=P.json;Y=P.messageParser;Z=P.skipMetadataAnnotationParsing;$=P.defaultUpdateMethod;_=P.disableHeadRequestForToken;a1=P.sequentializeRequests;b1=P.disableSoftStateHeader;c1=P.bindableResponseHeaders;d1=P.warmupUrl;}this.sWarmupUrl=d1;this.bWarmup=!!d1;this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.mUnsupportedFilterOperators={"Any":true,"All":true};this.sDefaultBindingMode=I||B.OneWay;this.bJSON=X!==false;this.aPendingRequestHandles=[];this.aCallAfterUpdate=[];this.mRequests={};this.mDeferredRequests={};this.mChangedEntities={};this.mChangeHandles={};this.mDeferredGroups={};this.mLaunderingState={};this.sDefaultUpdateMethod=$||c.Merge;this.bTokenHandling=T!==false;this.bWithCredentials=W===true;this.bUseBatch=n!==false;this.bRefreshAfterChange=R!==false;this.sMaxDataServiceVersion=k;this.bLoadAnnotationsJoined=D!==false;this.sAnnotationURI=z;this.sDefaultCountMode=E||b.Request;this.sDefaultOperationMode=J||d.Default;this.sMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.sRefreshGroupId=undefined;this.bIncludeInCurrentBatch=false;this.bSkipMetadataAnnotationParsing=!!Z;this.bDisableHeadRequestForToken=!!_;this.bSequentializeRequests=!!a1;this.bDisableSoftStateHeader=!!b1;this.aBindableResponseHeaders=c1?c1:null;this.bPreliminaryContext=G||false;this.mMetadataUrlParams=V||{};if(Y){Y.setProcessor(this);}this.oMessageParser=Y;this.sDefaultChangeGroup="changes";this.setDeferredGroups([this.sDefaultChangeGroup]);this.setChangeGroups({"*":{groupId:this.sDefaultChangeGroup}});this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];this.pSequentialRequestCompleted=Promise.resolve();this.pReadyForRequest=Promise.resolve();this.sServiceUrl=S;var f1=S.split("?");if(f1.length>1){this.sServiceUrl=f1[0];if(f1[1]){this.aUrlParams.push(f1[1]);}}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");this.sUser=i;this.sPassword=j;if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true");}this.oHeaders={};this.setHeaders(H);if(!this.bDisableSoftStateHeader){this.oHeaders["sap-contextid-accept"]="header";this.mCustomHeaders["sap-contextid-accept"]="header";}var g1=this._getServerUrl();var h1=this.sWarmupUrl||this._createMetadataUrl("/$metadata");this.oSharedServerData=y._getSharedData("server",g1);this.oSharedServiceData=y._getSharedData("service",this.sServiceUrl);this.oSharedMetaData=y._getSharedData("meta",h1);this.bUseCache=this._cacheSupported(h1);if(!this.oSharedMetaData.oMetadata||this.oSharedMetaData.oMetadata.bFailed){this.oMetadata=new g(h1,{async:true,cacheKey:this.bUseCache?h1:undefined,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:K,withCredentials:this.bWithCredentials});if(!this.bWarmup){this.oSharedMetaData.oMetadata=this.oMetadata;}}else{this.oMetadata=this.oSharedMetaData.oMetadata;}this.oAnnotations=new O(this.oMetadata,{source:this.sAnnotationURI,skipMetadata:this.bSkipMetadataAnnotationParsing,headers:this.mCustomHeaders,combineEvents:true,cacheKey:this._getAnnotationCacheKey(h1),useCache:this.bUseCache});if(!this.bDisableSoftStateHeader){delete this.mCustomHeaders["sap-contextid-accept"];}this.oAnnotations.attachAllFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachSomeLoaded(this.onAnnotationsLoaded,this);this.pAnnotationsLoaded=this.oAnnotations.loaded();if(N){this.aUrlParams=this.aUrlParams.concat(a._createUrlParamsArray(N));}this.onMetadataFailed=function(i1){e1.fireMetadataFailed(i1.getParameters());};if(!this.oMetadata.isLoaded()){this.oMetadata.attachFailed(this.onMetadataFailed);}this.oMetadata.loaded().then(function(){e1._initializeMetadata();});if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata";}else{this.oHeaders["Accept"]="application/json";}}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";}if(this.bTokenHandling){if(this.oSharedServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken;}else if(this.oSharedServerData.securityToken){this.oSharedServiceData.securityToken=this.oSharedServerData.securityToken;this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken;}}this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguageTag();this.oHeaders["DataServiceVersion"]="2.0";this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion;}},metadata:{publicMethods:["read","create","update","remove","submitChanges","getServiceMetadata","metadataLoaded","hasPendingChanges","getPendingChanges","refresh","refreshMetadata","resetChanges","setDefaultCountMode","setDefaultBindingMode","getDefaultBindingMode","getDefaultCountMode","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch","setDeferredBatchGroups","getDeferredBatchGroups","setChangeBatchGroups","getChangeBatchGroups"]}});y.M_EVENTS={MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed",BatchRequestFailed:"batchRequestFailed",BatchRequestSent:"batchRequestSent",BatchRequestCompleted:"batchRequestCompleted"};y.prototype.attachBatchRequestFailed=function(D,i,j){this.attachEvent("batchRequestFailed",D,i,j);return this;};y.prototype.detachBatchRequestFailed=function(i,j){this.detachEvent("batchRequestFailed",i,j);return this;};y.prototype.fireBatchRequestFailed=function(i){this.fireEvent("batchRequestFailed",i);return this;};y.prototype.attachBatchRequestSent=function(D,i,j){this.attachEvent("batchRequestSent",D,i,j);return this;};y.prototype.detachBatchRequestSent=function(i,j){this.detachEvent("batchRequestSent",i,j);return this;};y.prototype.fireBatchRequestSent=function(i){this.fireEvent("batchRequestSent",i);return this;};y.prototype.attachBatchRequestCompleted=function(D,i,j){this.attachEvent("batchRequestCompleted",D,i,j);return this;};y.prototype.detachBatchRequestCompleted=function(i,j){this.detachEvent("batchRequestCompleted",i,j);return this;};y.prototype.fireBatchRequestCompleted=function(i){this.fireEvent("batchRequestCompleted",i);return this;};y.mSharedData={server:{},service:{},meta:{}};y._getSharedData=function(S,k){var i=this.mSharedData[S][k];if(!i){i={};this.mSharedData[S][k]=i;}return i;};y.prototype._initializeMetadata=function(){if(this.bDestroyed){return;}var i=function(){this.fireMetadataLoaded({metadata:this.oMetadata});L.debug(this+" - metadataloaded fired");}.bind(this);this.initialize();if(this.bLoadAnnotationsJoined){this.oAnnotations.loaded().then(i,this.fireMetadataFailed.bind(this));}else{i();}};y.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){return this.oMetadata.refresh();}};y.prototype.fireAnnotationsLoaded=function(i){this.fireEvent("annotationsLoaded",i);return this;};y.prototype.attachAnnotationsLoaded=function(D,i,j){this.attachEvent("annotationsLoaded",D,i,j);return this;};y.prototype.detachAnnotationsLoaded=function(i,j){this.detachEvent("annotationsLoaded",i,j);return this;};y.prototype.fireAnnotationsFailed=function(i){this.fireEvent("annotationsFailed",i);L.debug(this+" - annotationsfailed fired");return this;};y.prototype.attachAnnotationsFailed=function(D,i,j){this.attachEvent("annotationsFailed",D,i,j);return this;};y.prototype.detachAnnotationsFailed=function(i,j){this.detachEvent("annotationsFailed",i,j);return this;};y.prototype.fireMetadataLoaded=function(i){this.fireEvent("metadataLoaded",i);return this;};y.prototype.attachMetadataLoaded=function(D,i,j){this.attachEvent("metadataLoaded",D,i,j);return this;};y.prototype.detachMetadataLoaded=function(i,j){this.detachEvent("metadataLoaded",i,j);return this;};y.prototype.fireMetadataFailed=function(i){this.fireEvent("metadataFailed",i);return this;};y.prototype.attachMetadataFailed=function(D,i,j){this.attachEvent("metadataFailed",D,i,j);return this;};y.prototype.detachMetadataFailed=function(i,j){this.detachEvent("metadataFailed",i,j);return this;};y.prototype._createEventInfo=function(R,k,n){var E={};E.url=R.requestUri;E.method=R.method;E.async=R.async;E.headers=R.headers;if(n){E.requests=[];for(var i=0;i<n.length;i++){var z={};if(Array.isArray(n[i])){var D=n[i];for(var j=0;j<D.length;j++){var R=D[j].request;var I=n[i][j].response;z={};z.url=R.requestUri;z.method=R.method;z.headers=R.headers;if(I){z.response={};if(R._aborted){z.success=false;z.response.statusCode=0;z.response.statusText="abort";}else{z.success=true;if(I.message){z.response.message=I.message;I=I.response;z.response.responseText=I.body;z.success=false;}z.response.headers=I.headers;z.response.statusCode=I.statusCode;z.response.statusText=I.statusText;}}E.requests.push(z);}}else{var R=n[i].request;var I=n[i].response;z.url=R.requestUri;z.method=R.method;z.headers=R.headers;if(I){z.response={};if(R._aborted){z.success=false;z.response.statusCode=0;z.response.statusText="abort";}else{z.success=true;if(I.message){z.response.message=I.message;I=I.response;z.response.responseText=I.body;z.success=false;}z.response.headers=I.headers;z.response.statusCode=I.statusCode;z.response.statusText=I.statusText;}}E.requests.push(z);}}}if(k){E.response={};E.success=true;if(k.message){E.response.message=k.message;E.success=false;}if(k.response){k=k.response;}if(k&&k.statusCode!=undefined){E.response.headers=k.headers;E.response.statusCode=k.statusCode;E.response.statusText=k.statusText;E.response.responseText=k.body!==undefined?k.body:k.responseText;}}E.ID=R.requestID;return E;};y.prototype._createRequestID=function(){var R;R=u();return R;};y.prototype._getServerUrl=function(){var S,i;S=new U(this.sServiceUrl).absoluteTo(document.baseURI);i=new U("/").absoluteTo(S).toString();return i;};y.prototype._createMetadataUrl=function(i){if(i.indexOf(this.sServiceUrl)==-1){if(!i.startsWith("/")){i="/"+i;}i=this.sServiceUrl+i;}var j=new s(i||window.location.href).mParams||{};Object.keys(j).forEach(function(K){j[K]=j[K][0];});var k=Q.extend({},this.mMetadataUrlParams,j);var n=a._createUrlParamsArray(k);var z=i.split("?");if(z.length>1){i=z[0];}return this._addUrlParams(i,n);};y.prototype._addUrlParams=function(i,j){var k=[];if(this.aUrlParams){k=k.concat(this.aUrlParams);}if(j){k=k.concat(j);}if(k&&k.length>0){i+="?"+k.join("&");}return i;};y.prototype._createRequestUrl=function(P,i,j,k){var n,z="";n=this._normalizePath(P,i);if(!k){z=this.sServiceUrl+n;}else{z=n.substr(n.indexOf('/')+1);}return this._addUrlParams(z,j);};y.prototype._importData=function(D,j,R){var k=this,n,K,z,E;if(D.results){n=[];Q.each(D.results,function(i,N){var K=k._importData(N,j,R);if(K){n.push(K);}});return n;}else{K=this._getKey(D);if(!K){return K;}E=this._getEntity(K);if(!E||(E.__metadata&&E.__metadata.invalid)){E=D;this._addEntity(E);}if(this.aBindableResponseHeaders){var H={};for(var G in R.headers){var I=G.toLowerCase();if(this.aBindableResponseHeaders.indexOf(I)>-1){H[I]=R.headers[G];}}if(!Q.isEmptyObject(H)){if(!D.__metadata){D.__metadata={};}D.__metadata.headers=H;}}Q.each(D,function(N,P){if(P&&(P.__metadata&&P.__metadata.uri||P.results)&&!P.__deferred){z=k._importData(P,j,R);if(Array.isArray(z)){E[N]={__list:z};}else{E[N]={__ref:z};}}else if(!P||!P.__deferred){E[N]=P;}});var J={};J[K]=E;this._updateChangedEntities(J);j[K]=true;return K;}};y.prototype._removeReferences=function(D){var j=this,k;if(!D){return D;}if(D.results){k=[];Q.each(D.results,function(i,n){k.push(j._removeReferences(n));});return k;}else{Q.each(D,function(P,i){if(i){if(i["__ref"]||i["__list"]){delete D[P];}}});return D;}};y.prototype._restoreReferences=function(D,V){var j=this,k,n,R;function z(k){var n=V[k];if(!n){n=j._getObject("/"+k);r(n,"ODataModel inconsistent: "+k+" not found!");if(n){n=v({},n);V[k]=n;j._restoreReferences(n,V);}}return n;}if(!V){V={};}Q.each(D,function(P,E){if(E){if(E.__ref){k=E.__ref;n=z(k);if(n){D[P]=n;}delete E.__ref;}else if(E.__list){R=[];Q.each(E.__list,function(i,k){n=z(k);if(n){R.push(n);}});delete E.__list;E.results=R;}}});return D;};y.prototype.removeData=function(){this.oData={};};y.prototype.initialize=function(){var i=this.aBindings.slice(0);i.forEach(function(j){j.initialize();});};y.prototype.invalidate=function(i){var E;for(var k in this.oData){E=this.oData[k];if(!i||i(k,E)){E.__metadata.invalid=true;}}};y.prototype.invalidateEntry=function(E){var i;if(typeof E==="string"){if(E.indexOf("/")===0){i=this._getObject(E);}else{i=this.oData[E];}}else if(E instanceof C){i=this._getObject(E.getPath());}if(i&&i.__metadata){i.__metadata.invalid=true;}};y.prototype.invalidateEntityType=function(E){var i;for(var k in this.oData){i=this.oData[k];if(i.__metadata.type===E){i.__metadata.invalid=true;}}};y.prototype.refresh=function(i,R,G){if(typeof i==="string"){G=i;i=false;R=false;}if(R){this.removeData();}this._refresh(i,G);};y.prototype._refresh=function(i,G,j,E){var k=this.aBindings.slice(0);this.sRefreshGroupId=G;k.forEach(function(n){n._refresh(i,j,E);});this.sRefreshGroupId=undefined;};y.prototype.checkUpdate=function(i,j,k,n){if(j){if(!this.sUpdateTimer){this.sUpdateTimer=setTimeout(function(){this.checkUpdate(i,false,k);}.bind(this),0);}return;}if(this.sUpdateTimer){clearTimeout(this.sUpdateTimer);this.sUpdateTimer=null;}var z=this.aBindings.slice(0);z.forEach(function(D){if(!n||this.isMetaModelPath(D.getPath())){D.checkUpdate(i,k);}}.bind(this));this._processAfterUpdate();};y.prototype.checkDataState=function(i){var j=this.aBindings.slice(0);j.forEach(function(k){if(k.checkDataState){k.checkDataState(i);}});};y.prototype.bindProperty=function(P,i,j){var k=new h(this,P,i,j);return k;};y.prototype.bindList=function(P,i,S,j,k){var n=new f(this,P,i,S,j,k);return n;};y.prototype.bindTree=function(P,i,j,k,S){var n=new l(this,P,i,j,k,S);return n;};y.prototype.createBindingContext=function(P,i,j,k,R){var n,z,N,G,D=this;if(i!==null&&typeof i==="object"&&!(i instanceof sap.ui.model.Context)){R=k;k=j;j=i;i=undefined;}if(typeof i=="function"){R=j;k=i;j=undefined;i=undefined;}if(typeof i=="boolean"){R=i;k=undefined;j=undefined;i=undefined;}if(typeof j=="function"){R=k;k=j;j=undefined;}if(typeof j=="boolean"){R=j;k=undefined;j=undefined;}if(typeof k=="boolean"){R=k;k=undefined;}n=this.resolve(P,i);if(!n){if(k){k(null);}return null;}if(R===undefined){R=this._isReloadNeeded(n,j);}if(!R){z=this.resolve(P,i,true);N=this.getContext(z);if(k){k(N);}return N;}function E(S){var T=S?D._getKey(S):null,V=!(P===""||P.indexOf("/")>0),W=null,X,Y;N=null;if(T){N=D.getContext('/'+T);W={__ref:T};}if(i&&I&&V){X=i.getPath();X=X.substr(1);Y=D._getEntity(X);if(Y){Y[P]=W;}}k(N);}function H(S){var T;if(S.statusCode=='404'&&i&&I){var V=i.getPath();V=V.substr(1);T=D._getEntity(V);if(T){T[P]={__ref:null};}}k(null);}if(k){var I=!P.startsWith("/");if(n){var J=[],K=this.createCustomParams(j);if(K){J.push(K);}if(j&&(j.batchGroupId||j.groupId)){G=j.groupId||j.batchGroupId;}this.read(n,{groupId:G,urlParameters:J,success:E,error:H});}else{k(null);}}if(j&&j.createPreliminaryContext){n=this.resolve(P,i);N=this.getContext(n);return N;}};y.prototype._updateContext=function(i,P){if(!P.startsWith("/")){throw new Error("Path "+P+" must start with a / ");}i.sPath=P;this.mContexts[P]=i;};y.prototype._splitEntries=function(E){return E.replace(/\s/g,"").split(',').map(function(i){return i.split("/");});};y.prototype._filterOwnSelect=function(S,E){var i,j;if(!E){return[];}j=E.map(function(P){return P.name;});i=S.filter(function(k){return k.length===1;}).map(function(k){return k[0];});if(S.length===0||i.indexOf("*")!==-1||i.indexOf("**")!==-1){return j;}else{return i.filter(function(k){return j.indexOf(k)!==-1;});}};y.prototype._filterOwnExpand=function(E,S){return E.map(function(i){return i[0];}).filter(function(V,i,j){return j.indexOf(V)===i;}).filter(function(V){return S.length===0||S.some(function(i){return i.indexOf(V)===0||i.indexOf("**")===0;});});};y.prototype._filterSelectByNavProp=function(E,n){return E.filter(function(S){return S[0]===n;}).map(function(S){return S.length>1?S.slice(1):["**"];});};y.prototype._filterExpandByNavProp=function(E,n){return E.filter(function(S){return S.length>1&&S[0]===n;}).map(function(S){return S.slice(1);});};y.prototype._isReloadNeeded=function(P,k){var n=this,z=this.oMetadata,E,D=this._getObject(P),G=[],S=[];if(!this.oMetadata.isLoaded()){return true;}E=this.oMetadata._getEntityTypeByPath(P);if(this._isCreatedEntity(D)){return false;}function H(E,D,S,G){var I,J,N,K,R,T,V,W,X;if(!E){return false;}if(D===null){return false;}if(!D){return true;}if(D.__metadata&&D.__metadata.invalid){return true;}I=n._filterOwnSelect(S,E.property);for(var i=0;i<I.length;i++){X=I[i];if(D[X]===undefined){return true;}}J=n._filterOwnExpand(G,S);for(var i=0;i<J.length;i++){W=J[i];N=D[W];if(N===null){continue;}if(N===undefined||N.__deferred){return true;}K=z._getEntityTypeByNavProperty(E,W);T=n._filterSelectByNavProp(S,W);V=n._filterExpandByNavProp(G,W);if(N.__ref){R=n._getEntity(N.__ref);if(H(K,R,T,V)){return true;}}if(N.__list){for(var j=0;j<N.__list.length;j++){R=n._getEntity(N.__list[j]);if(H(K,R,T,V)){return true;}}}}return false;}if(k){if(k.select){S=this._splitEntries(k.select);}if(k.expand){G=this._splitEntries(k.expand);}}return H(E,D,S,G);};y.prototype.createCustomParams=function(P){var i=[],j,S={expand:true,select:true};for(var n in P){if(n in S){i.push("$"+n+"="+w(P[n]));}if(n==="custom"){j=P[n];for(n in j){if(n.indexOf("$")===0){L.warning(this+" - Trying to set OData parameter '"+n+"' as custom query option!");}else if(typeof j[n]==='string'){i.push(n+"="+w(j[n]));}else{i.push(n);}}}}return i.join("&");};y.prototype.bindContext=function(P,i,j){var k=new e(this,P,i,j);return k;};y.prototype.setDefaultCountMode=function(i){this.sDefaultCountMode=i;};y.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode;};y.prototype._addEntity=function(E){var k=this._getKey(E);this.oData[k]=E;};y.prototype._removeEntity=function(k){k=k&&a._normalizeKey(k);delete this.oData[k];delete this.mChangedEntities[k];delete this.mContexts["/"+k];};y.prototype._getEntity=function(k){var E=this.oData[k];if(!E){k=k&&a._normalizeKey(k);E=this.oData[k];}return E;};y.prototype._getKey=function(V){var k,i;if(V instanceof C){k=V.getPath().substr(1);}else if(V&&V.__metadata&&V.__metadata.uri){i=V.__metadata.uri;k=i.substr(i.lastIndexOf("/")+1);}else if(typeof V==='string'){k=V.substr(V.lastIndexOf("/")+1);}if(!this.oData[k]){k=k&&a._normalizeKey(k);}return k;};y.prototype.getKey=function(V){return this._getKey(V);};y.prototype.createKey=function(j,k){var E=this.oMetadata._getEntityTypeByPath(j),K=j,n=this,N,P;r(E,"Could not find entity type of collection \""+j+"\" in service metadata!");K+="(";if(E.key.propertyRef.length===1){N=E.key.propertyRef[0].name;r(N in k,"Key property \""+N+"\" is missing in object!");P=this.oMetadata._getPropertyMetadata(E,N);K+=encodeURIComponent(a.formatValue(k[N],P.type));}else{Q.each(E.key.propertyRef,function(i,z){if(i>0){K+=",";}N=z.name;r(N in k,"Key property \""+N+"\" is missing in object!");P=n.oMetadata._getPropertyMetadata(E,N);K+=N;K+="=";K+=encodeURIComponent(a.formatValue(k[N],P.type));});}K+=")";return K;};y.prototype.getProperty=function(P,i,I){var V=this._getObject(P,i);if(!I){return V;}if(!x(V)){return V;}V=v({},V);if(I===true){return this._restoreReferences(V);}else{return this._removeReferences(V);}};y.prototype.getObject=function(P,n,z){if(x(n)){z=n;n=undefined;}var D=this,R=this.resolve(P,n),V=this._getObject(R),E=this.oMetadata._getEntityTypeByPath(R),G=[],S=[];if(!E||!x(V)||!V.__metadata||!V.__metadata.uri){return V;}if(!z||!(z.select||z.expand)){return v({},V);}function H(E,V,S,G){var I,J,K,N,T,W,X,Y,Z,$,_,a1,b1;if(!V){return undefined;}if(!E){return undefined;}K=D._filterOwnSelect(S,E.property);J={};for(var i=0;i<K.length;i++){a1=K[i];if(V[a1]!==undefined){J[a1]=V[a1];}else{L.fatal("No data loaded for select property: "+a1+" of entry: "+D.getKey(V));return undefined;}}if(V.__metadata){J.__metadata=V.__metadata;}I=D._filterOwnExpand(G,S);for(var i=0;i<I.length;i++){_=I[i];T=V[_];W=D.oMetadata._getEntityTypeByNavProperty(E,_);Z=D._filterSelectByNavProp(S,_);$=D._filterExpandByNavProp(G,_);if(T&&T.__ref){Y=D._getObject("/"+T.__ref);X=H(W,Y,Z,$);if(X!==undefined){J[_]=X;}else{L.fatal("No data loaded for expand property: "+_+" of entry: "+D.getKey(X));return undefined;}}if(T&&T.__list){b1=[];for(var j=0;j<T.__list.length;j++){Y=D._getObject("/"+T.__list[j]);X=H(W,Y,Z,$);if(X!==undefined){b1.push(X);}else{L.fatal("No data loaded for expand property: "+_+" of entry: "+D.getKey(X));return undefined;}}J[_]=b1;}}N=D._filterOwnSelect(S,E.navigationProperty);for(var k=0;k<N.length;k++){_=N[k];if(I.indexOf(_)===-1){var c1=J.__metadata.uri+"/"+_;J[_]={__deferred:{uri:c1}};}}return J;}if(z.select){S=this._splitEntries(z.select);}if(z.expand){G=this._splitEntries(z.expand);}V=H(E,V,S,G);return V;};y.prototype._getObject=function(P,i,j){var n=this.isLegacySyntax()?this.oData:null,k,z,R=this.resolve(P,i),S,D,E,G,K,H;if(!R){return n;}if(this._isMetadataPath(R)){if(this.oMetadata&&this.oMetadata.isLoaded()){if(this.isMetaModelPath(R)){S=R.indexOf('/##');H=this.getMetaModel();if(!this.bMetaModelLoaded){return null;}D=R.substr(0,S);E=R.substr(S+3);G=H.getMetaContext(D);n=H.getProperty(E,G);}else{n=this.oMetadata._getAnnotation(R);}}}else{if(R==="/"){return this.oData;}var I=R.split("/"),J=0;K=I[1];I.splice(0,2);k=this.mChangedEntities[K];z=this._getEntity(K);n=j?z:k||z;while(n&&I[J]){var N=k&&k.hasOwnProperty(I[J]);k=k&&k[I[J]];z=z&&z[I[J]];n=j||!N?z:k;if(n){if(n.__ref){k=this.mChangedEntities[n.__ref];z=this._getEntity(n.__ref);n=j?z:k||z;}else if(n.__list){n=n.__list;}else if(n.__deferred){n=undefined;}}J++;}}if(x(k)){n=j?z:v({},z,k);}return n;};y.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oSharedServiceData.securityToken){this.refreshSecurityToken();}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oSharedServiceData.securityToken;}}};y.prototype.resetSecurityToken=function(){delete this.oSharedServiceData.securityToken;delete this.oHeaders["x-csrf-token"];delete this.pSecurityToken;};y.prototype.getSecurityToken=function(){var T=this.oSharedServiceData.securityToken;if(!T){this.refreshSecurityToken();T=this.oSharedServiceData.securityToken;}return T;};y.prototype.securityTokenAvailable=function(){if(!this.pSecurityToken){if(this.oSharedServiceData.securityToken){this.pSecurityToken=Promise.resolve(this.oSharedServiceData.securityToken);}else{this.pSecurityToken=new Promise(function(i,j){this.refreshSecurityToken(function(){i(this.oSharedServiceData.securityToken);}.bind(this),function(){j();},true);}.bind(this));}}return this.pSecurityToken;};y.prototype.refreshSecurityToken=function(S,E,i){var T;var j=this;var k=this._createRequestUrl("/");var n={abort:function(){this.request.abort();}};function z(I,R){if(R){T=j._getHeader("x-csrf-token",R.headers);j._setSessionContextIdHeader(j._getHeader("sap-contextid",R.headers));if(T){j.oSharedServerData.securityToken=T;j.oSharedServiceData.securityToken=T;j.pSecurityToken=Promise.resolve(T);j.oHeaders["x-csrf-token"]=T;}else{j.resetSecurityToken();j.bTokenHandling=false;}}if(S){S(I,R);}}function D(I){j.resetSecurityToken();j.bTokenHandling=false;j._handleError(I);if(E){E(I);}}function G(I){n.request=H("GET",D);}function H(R,E){var I=j._createRequest(k,R,j._getHeaders(undefined,true),null,null,!!i);I.headers["x-csrf-token"]="Fetch";return j._request(I,z,E,undefined,undefined,j.getServiceMetadata());}if(this.bDisableHeadRequestForToken){n.request=H("GET",D);}else{n.request=H("HEAD",G);}return n;};y.prototype._submitRequest=function(R,S,E){var j=this,H,k,n,z,D;z=new Promise(function(i,T){D=i;});function G(i,T){if(S){S(i,T);}D();}function I(i){if(j.bTokenHandling&&i.response){var T=j._getHeader("x-csrf-token",i.response.headers);if(!R.bTokenReset&&i.response.statusCode=='403'&&T&&T.toLowerCase()==="required"){j.resetSecurityToken();R.bTokenReset=true;K();return;}}if(E){E(i);}D();}function J(R){if(j.bTokenHandling&&R.method!=="GET"){j.pReadyForRequest=j.securityTokenAvailable();}return j.pReadyForRequest;}function K(){if(j.bTokenHandling){delete R.headers["x-csrf-token"];}J(R).then(function(T){if(j.bTokenHandling&&R.method!=="GET"){R.headers["x-csrf-token"]=T;}P();},function(){P();});}function N(T,R,V){var W,X=R.eventInfo.requests;if(X){Q.each(X,function(i,R){if(Array.isArray(R)){R.forEach(function(R){Q.each(R.parts,function(i,Y){W=j._createEventInfo(R.request,Y.fnError);j["fireRequest"+T](W);});});}else{if(R.parts){Q.each(R.parts,function(i,Y){W=j._createEventInfo(R.request,Y.fnError);j["fireRequest"+T](W);});}else{W=j._createEventInfo(R.request,R.fnError);j["fireRequest"+T](W);}}});if(R.eventInfo.batch){W=j._createEventInfo(R,V,X);j["fireBatchRequest"+T](W);}}}function P(){if(j.sSessionContextId){R.headers["sap-contextid"]=j.sSessionContextId;}k=j._request(R,G,I,H,undefined,j.getServiceMetadata());if(R.eventInfo){N("Sent",R,null);delete R.eventInfo;}if(n){k.abort();}}H=j._getODataHandler(R.requestUri);if(this.bSequentializeRequests){this.pSequentialRequestCompleted.then(function(){K();});this.pSequentialRequestCompleted=z;}else{K();}return{abort:function(){if(k){k.abort();}n=true;}};};y.prototype._setSessionContextIdHeader=function(S){if(S){this.sSessionContextId=S;}};y.prototype._submitSingleRequest=function(R){var j=this,k,n={},G={},E={};function z(H,I){if(H===undefined&&I.statusCode===200){D({message:"Response did not contain a valid OData result",response:I});return;}function J(H,I){for(var i=0;i<R.parts.length;i++){if(R.parts[i].request._aborted){j._processAborted(R.parts[i].request,I);}else if(R.parts[i].fnSuccess){R.parts[i].fnSuccess(H,I);}}if(R.request.requestUri.indexOf("$count")===-1){j.checkUpdate(false,false,G);if(R.bRefreshAfterChange){j._refresh(false,undefined,n,E);}}}j._processSuccess(R.request,I,J,G,n,E);j._setSessionContextIdHeader(j._getHeader("sap-contextid",I.headers));}function D(H){if(H.message=="Request aborted"){for(var i=0;i<R.parts.length;i++){j._processAborted(R.parts[i].request,H);}}else{for(var i=0;i<R.parts.length;i++){j._processError(R.parts[i].request,H,R.parts[i].fnError);}}j._processAfterUpdate();}R.request.eventInfo={requests:R.parts,batch:false};k=this._submitRequest(R.request,z,D);return k;};y.prototype._submitBatchRequest=function(k,R,S,E){var n=this,z={},G={},D={};function H(j,T,V){for(var i=0;i<j.parts.length;i++){if(V||j.parts[i].request._aborted){n._processAborted(j.parts[i].request,T);}else if(T.message){n._processError(j.parts[i].request,T,j.parts[i].fnError);}else{n._processSuccess(j.parts[i].request,T,j.parts[i].fnSuccess,G,z,D);}}}function I(T,V){if(T===undefined&&V.statusCode===200){J({message:"Response did not contain a valid OData batch result",response:V});return;}var W,X,Y,Z=T.__batchResponses;if(Z){var i,j;for(i=0;i<Z.length;i++){W=Z[i];if(Array.isArray(R[i])){if(W.message){for(j=0;j<R[i].length;j++){X=R[i][j];H(X,W);X.response=W;}}else{Y=W.__changeResponses;for(j=0;j<Y.length;j++){var $=Y[j];X=R[i][j];H(X,$);X.response=$;}}}else{X=R[i];H(X,W);X.response=W;}}n.checkUpdate(false,false,G);}n._processSuccess(k,V,S,G,z,D,true,R);n._setSessionContextIdHeader(n._getHeader("sap-contextid",V.headers));}function J(j){var T=j.message=="Request aborted";Q.each(R,function(i,V){if(Array.isArray(V)){V.forEach(function(V){H(V,j,T);});}else{H(V,j,T);}});n._processAfterUpdate();if(T){n._processAborted(k,j,true);}else{n._processError(k,j,E,true,R);}}k.eventInfo={requests:R,batch:true};var K=this._submitRequest(k,I,J);function N(j){var E;for(var i=0;i<j.parts.length;i++){E=j.parts[i].fnError;if(!j.parts[i].request._aborted&&E){E(A);}}}var P={abort:function(){Q.each(R,function(i,j){if(Array.isArray(j)){j.forEach(function(j){N(j);});}else{N(j);}});K.abort();}};return P;};y.prototype._createBatchRequest=function(i){var j,R,k={},P={},n=true;P.__batchRequests=i;for(var I in i){if(i[I]&&i[I].__changeRequests||i[I]&&i[I].headers&&!i[I].headers['sap-cancel-on-close']){n=false;break;}}j=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){j+="?"+this.aUrlParams.join("&");}Q.extend(k,this.mCustomHeaders,this.oHeaders);k["Accept"]="multipart/mixed";delete k["Content-Type"];k['sap-cancel-on-close']=n;R={headers:k,requestUri:j,method:"POST",data:P,user:this.sUser,password:this.sPassword,async:true};R.withCredentials=this.bWithCredentials;return R;};y.prototype.abortInternalRequest=function(k,G){var R=this.mRequests;if(G in this.mDeferredGroups){R=this.mDeferredRequests;}var j=R[G];if(j&&k in j.map){var n=j.map[k];for(var i=0;i<n.parts.length;i++){n.parts[i].requestHandle.abort();}}};y.prototype._pushToRequestQueue=function(R,G,i,j,S,E,k,n){var z=R[G],D=j.key?j.key:j.method+":"+j.requestUri;if(this.bWarmup){return;}if(!z){z={};z.map={};z.requests=[];R[G]=z;}if(D in z.map&&(j.key||j.method==='GET')){var H=z.map[D];var I=H.request;if(H.bRefreshAfterChange===undefined){H.bRefreshAfterChange=n;}if(!j.key){H.parts.push({request:j,fnSuccess:S,fnError:E,requestHandle:k});}if(j.method==="GET"){delete I.data;}else{I.method=j.method;I.headers=j.headers;I.data=j.data;I.requestUri=j.requestUri;if(j.method==="PUT"){delete I.headers["x-http-method"];}if(I._aborted){delete I._aborted;}}}else{var H={request:j,bRefreshAfterChange:n,parts:[{request:j,fnSuccess:S,fnError:E,requestHandle:k}]};if(j.method==="GET"){z.requests.push(H);}else{if(!z.changes){z.changes={};}var J=z.changes[i];if(!J){J=[];z.changes[i]=J;}H.changeSetId=i;J.push(H);}z.map[D]=H;}};y.prototype._collectChangedEntities=function(G,j,E){var k=this;if(G.changes){Q.each(G.changes,function(n,z){for(var i=0;i<z.length;i++){if(z[i].bRefreshAfterChange){var R=z[i].request,P="/"+R.requestUri.split("?")[0],D,K;if(R.method==="POST"||R.method==="DELETE"){var H=k.oMetadata._getEntityTypeByPath(P);if(H){E[H.entityType]=true;}}else{D=k._getObject(P);if(D){K=k._getKey(D);}else if(P.lastIndexOf("/")===0){K=k._getKey(P);}if(K){j[K]=true;}}}}});}};y.prototype._processRequestQueue=function(R,G,S,E){var j=this,P,k=[];function n(D,W){for(var i=0;i<D.parts.length;i++){var H=D.parts[i];if(H.request._aborted){j._processAborted(D.request,null);D.parts.splice(i,1);i--;}else if(W){H.request._handle=W;W.iRelevantRequests++;}}}function z(){return{iRelevantRequests:0,oRequestHandle:{},abort:function(){this.iRelevantRequests--;if(this.iRelevantRequests===0&&this.oRequestHandle){this.oRequestHandle.abort();}}};}if(this.bUseBatch){Q.each(R,function(i,D){if(i===G||!G){var H={},I={};j._collectChangedEntities(D,H,I);if(Object.keys(H).length||Object.keys(I).length){j.bIncludeInCurrentBatch=true;j._refresh(false,i,H,I);j.bIncludeInCurrentBatch=false;}}});Q.each(R,function(D,H){if(D===G||!G){var I=[],J=[],K,N;var W=z();if(H.changes){Q.each(H.changes,function(X,Y){K={__changeRequests:[]};N=[];for(var i=0;i<Y.length;i++){P='/'+j.getKey(Y[i].request.data);j.increaseLaundering(P,Y[i].request.data);n(Y[i],W);if(Y[i].parts.length>0){if(Y[i].request.data&&Y[i].request.data.__metadata){delete Y[i].request.data.__metadata.created;}K.__changeRequests.push(Y[i].request);N.push(Y[i]);}}if(K.__changeRequests&&K.__changeRequests.length>0){I.push(K);J.push(N);}});}if(H.requests){var T=H.requests;for(var i=0;i<T.length;i++){n(T[i],W);if(T[i].parts.length>0){I.push(T[i].request);J.push(T[i]);}}}if(I.length>0){var V=j._createBatchRequest(I);W.oRequestHandle=j._submitBatchRequest(V,J,S,E);k.push(W.oRequestHandle);}delete R[D];}});}else{Q.each(R,function(D,H){if(D===G||!G){if(H.changes){Q.each(H.changes,function(J,K){for(var i=0;i<K.length;i++){var W=z();P='/'+j.getKey(K[i].request.data);j.increaseLaundering(P,K[i].request.data);n(K[i],W);if(K[i].parts.length>0){W.oRequestHandle=j._submitSingleRequest(K[i]);k.push(W.oRequestHandle);}}});}if(H.requests){var I=H.requests;for(var i=0;i<I.length;i++){var W=z();n(I[i],W);if(I[i].parts.length>0){W.oRequestHandle=j._submitSingleRequest(I[i]);k.push(W.oRequestHandle);}}}delete R[D];}});}this.checkDataState(this.mLaunderingState);return k.length==1?k[0]:k;};y.prototype._processRequestQueueAsync=function(R){var i=this;if(!this.pCallAsnyc){this.pCallAsnyc=new Promise(function(j,k){i.oMetadata.loaded().then(function(){j();});});this.pCallAsnyc.then(function(){i._processRequestQueue(R);i.pCallAsnyc=undefined;});}};y.prototype._processSuccess=function(R,i,S,G,j,E,k,n){var z=i.data,I,D,H,P,J,K,N,T={},V={},W=this;if(!k){D=!(i.statusCode===204||i.statusCode==='204');H=R.requestUri;P=H.replace(this.sServiceUrl,"");if(!P.startsWith('/')){P='/'+P;}P=this._normalizePath(P);this.decreaseLaundering(P,R.data);if(D&&z===undefined&&i){this._parseResponse(i,R);L.fatal(this+" - No data was retrieved by service: '"+i.requestUri+"'");W.fireRequestCompleted({url:i.requestUri,type:"GET",async:i.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]},success:false});return false;}if(z&&z.results&&!Array.isArray(z.results)){z=z.results;}if(!i._imported&&z&&(Array.isArray(z)||typeof z=='object')){I=v({},z);W._importData(I,T,i);i._imported=true;}K=this._getEntity(R.key);if(T&&K&&K.__metadata.created&&K.__metadata.created.functionImport){var X=[];var Y=K["$result"];if(Y&&Y.__list){Q.each(T,function($){X.push($);});Y.__list=X;}else if(Y&&Y.__ref){Q.each(T,function($){Y.__ref=$;});}}if(!D){J=P.split("/");if(J[1]){V[J[1]]=R;var Z={};Z[J[1]]=R.data;this._updateChangedEntities(Z);}if(R.method==="DELETE"&&J[2]!=="$links"){this._removeEntity(J[1]);}}if(D&&R.method==="POST"){N=this.oMetadata._getEntityTypeByPath(P);if(N){E[N.entityType]=true;}if(R.key){if(R.created){var $=this._getKey(z);var _=this.getContext("/"+R.key);_.bCreated=false;this._updateContext(_,'/'+$);K=this._getEntity($);if(K){delete K.__metadata.created;}}this._removeEntity(R.key);}}this._parseResponse(i,R,T,V);Q.extend(G,T);Q.extend(j,V);this._updateETag(R,i);}if(S){S(z,i);}var a1=this._createEventInfo(R,i,n);if(k){this.fireBatchRequestCompleted(a1);}else{this.fireRequestCompleted(a1);}return true;};y.prototype._processError=function(R,i,E,j,k){var P,n=this._handleError(i,R);if(!j){P='/'+this.getKey(R.data);this.decreaseLaundering(P,R.data);}if(E){E(n);}var z=this._createEventInfo(R,n,k);if(j){this.fireBatchRequestCompleted(z);this.fireBatchRequestFailed(z);}else{this.fireRequestCompleted(z);this.fireRequestFailed(z);}};var A={message:"Request aborted",statusCode:0,statusText:"abort",headers:{},responseText:""};y.prototype._processAborted=function(R,i,j){var P;if(!j){P='/'+this.getKey(R.data);this.decreaseLaundering(P,R.data);}if(i){var E=this._createEventInfo(R,A);E.success=false;if(j){this.fireBatchRequestCompleted(E);}else{this.fireRequestCompleted(E);}}};y.prototype._processAfterUpdate=function(){var j=this.aCallAfterUpdate;this.aCallAfterUpdate=[];for(var i=0;i<j.length;i++){j[i]();}};y.prototype._processChange=function(k,D,i){var P,E,j,z,G,H,I,J,K,R,N,S=this;E=this.oMetadata._getEntityTypeByPath(k);if(!i){i="MERGE";}P=v({},this._getObject('/'+k,true),D);if(D.__metadata&&D.__metadata.created){z=D.__metadata.created.method?D.__metadata.created.method:"POST";k=D.__metadata.created.key;I=true;j=D.__metadata.created;if(D.__metadata.created.functionImport){j.urlParameters=this._createFunctionImportParameters(D.__metadata.created.key,z,P);P=undefined;}else{delete P.__metadata['uri'];}}else if(i==="MERGE"){z="MERGE";N=this._getEntity(k);}else{z="PUT";}if(P&&P.__metadata){for(var n in P.__metadata){if(n!=='type'&&n!=='uri'&&n!=='etag'&&n!=='content_type'&&n!=='media_src'){delete P.__metadata[n];}}}if(P&&E){var T=this.oMetadata._getNavigationPropertyNames(E);T.forEach(function(X){delete P[X];});}if(z==="MERGE"&&E&&N){Q.each(P,function(X,Y){if(X!=='__metadata'){if(t(N[X],Y)&&!S.isLaundering('/'+k+'/'+X)){delete P[X];}}});var V="/"+k,W;Q.each(P,function(X,Y){if(X!=='__metadata'){W=S.getProperty(V+"/"+X+"/#@sap:unit");if(W){if(P[W]===undefined){P[W]=N[W];}}}});}P=this._removeReferences(P);K=j&&j.urlParameters?a._createUrlParamsArray(j.urlParameters):undefined;J=j?this._getHeaders(j.headers):this._getHeaders();G=j&&j.eTag?j.eTag:this.getETag(P);H=this._createRequestUrl('/'+k,null,K,this.bUseBatch);R=this._createRequest(H,z,J,P,G);if(I){R.created=true;}if(this.bUseBatch){R.requestUri=R.requestUri.replace(this.sServiceUrl+'/','');}return R;};y.prototype._resolveGroup=function(k){var i,E,P,G,j,D;E=this.oMetadata._getEntityTypeByPath(k);D=this._getObject('/'+k);if(D){P=D.__metadata.created;if(P){return{groupId:P.groupId,changeSetId:P.changeSetId};}}if(this.mChangeGroups[E.name]){i=this.mChangeGroups[E.name];G=i.groupId;j=i.single?u():i.changeSetId;}else if(this.mChangeGroups['*']){i=this.mChangeGroups['*'];G=i.groupId;j=i.single?u():i.changeSetId;}return{groupId:G,changeSetId:j};};y.prototype._updateETag=function(R,i){var j,E,k;j=R.requestUri.replace(this.sServiceUrl+'/','');if(!j.startsWith("/")){j="/"+j;}E=this._getObject(j.split("?")[0]);k=this._getHeader("etag",i.headers);if(E&&E.__metadata&&k){E.__metadata.etag=k;}};y.prototype._handleError=function(E,R){var P={},T;var i="The following problem occurred: "+E.message;P.message=E.message;if(E.response){this._parseResponse(E.response,R);if(this.bTokenHandling){T=this._getHeader("x-csrf-token",E.response.headers);if(E.response.statusCode=='403'&&T&&T.toLowerCase()==="required"){this.resetSecurityToken();}}i+=E.response.statusCode+","+E.response.statusText+","+E.response.body;P.statusCode=E.response.statusCode;P.statusText=E.response.statusText;P.headers=E.response.headers;P.responseText=E.response.body;}L.fatal(i);return P;};y.prototype.getData=function(P,i,I){return this.getProperty(P,i,I);};y.prototype._getODataHandler=function(i){if(i.indexOf("$batch")>-1){return q.batchHandler;}else if(i.indexOf("$count")>-1){return undefined;}else if(this.bJSON){return q.jsonHandler;}else{return q.atomHandler;}};y.prototype.getETag=function(P,i,E){if(typeof P=="object"){E=P;P="";}return this._getETag(P,i,E);};y.prototype._getETag=function(P,i,D){if(!D||!D.__metadata){D=this._getObject(P,i);}if(D&&D.__metadata){return D.__metadata.etag;}return null;};y.prototype.forceEntityUpdate=function(k){var D=this.mChangedEntities[k];if(D&&D.__metadata){D.__metadata.etag='*';}else{L.error(this+" - Entity with key "+k+" does not exist or has no change");}};y.prototype._createRequest=function(i,j,H,D,E,k){k=k!==false;if(E&&j!=="GET"){H["If-Match"]=E;}if(!H["Content-Type"]&&j!=="DELETE"&&j!=="GET"){if(this.bJSON){H["Content-Type"]="application/json";}else{H["Content-Type"]="application/atom+xml";}}if(i.indexOf("$count")>-1){H["Accept"]="text/plain, */*;q=0.5";}if(j==="MERGE"&&!this.bUseBatch){H["x-http-method"]="MERGE";j="POST";}var R={headers:H,requestUri:i,method:j,user:this.sUser,password:this.sPassword,async:k};if(D){R.data=D;}if(this.bWithCredentials){R.withCredentials=this.bWithCredentials;}R.requestID=this._createRequestID();return R;};y.prototype._processRequest=function(P,E){var R,i,j=false,k=this;if(this.bWarmup){return{abort:function(){}};}R={abort:function(){if(!j&&E){E(A);}if(i){i._aborted=true;if(i._handle){i._handle.abort();}}j=true;}};this.oMetadata.loaded().then(function(){i=P(R);k._processRequestQueueAsync(k.mRequests);if(j){R.abort();}});return R;};y.prototype.update=function(P,D,i){var S,E,R,j,k,n,z,G,H,I,J,K,N,T,V=this;if(i){G=i.groupId||i.batchGroupId;H=i.changeSetId;k=i.context;S=i.success;E=i.error;n=i.eTag;J=i.headers;I=i.urlParameters;T=i.refreshAfterChange;if(i.merge!==undefined){K=i.merge?"MERGE":"PUT";}}T=this._getRefreshAfterChange(T,G);z=a._createUrlParamsArray(I);J=this._getHeaders(J);K=K?K:this.sDefaultUpdateMethod;n=n||this._getETag(P,k,D);return this._processRequest(function(W){j=V._createRequestUrl(P,k,z,V.bUseBatch);R=V._createRequest(j,K,J,D,n);N=V.mRequests;if(G in V.mDeferredGroups){N=V.mDeferredRequests;}V._pushToRequestQueue(N,G,H,R,S,E,W,T);return R;},E);};y.prototype.create=function(P,D,i){var R,j,E,k,S,n,z,G,H,I,J,K,N,T,V,W=this;if(i){k=i.context;z=i.urlParameters;S=i.success;n=i.error;K=i.groupId||i.batchGroupId;T=i.changeSetId;J=i.eTag;H=i.headers;V=i.refreshAfterChange;}V=this._getRefreshAfterChange(V,K);I=a._createUrlParamsArray(z);H=this._getHeaders(H);N="POST";return this._processRequest(function(X){j=W._createRequestUrl(P,k,I,W.bUseBatch);R=W._createRequest(j,N,H,D,J);P=W._normalizePath(P,k);E=W.oMetadata._getEntityTypeByPath(P);R.entityTypes={};if(E){R.entityTypes[E.entityType]=true;}G=W.mRequests;if(K in W.mDeferredGroups){G=W.mDeferredRequests;}W._pushToRequestQueue(G,K,T,R,S,n,X,V);return R;},n);};y.prototype.remove=function(P,i){var j,k,S,E,R,n,G,z,D,H,I,J,K,N,T,V=this;if(i){G=i.groupId||i.batchGroupId;z=i.changeSetId;j=i.context;S=i.success;E=i.error;D=i.eTag;J=i.headers;I=i.urlParameters;H=i.refreshAfterChange;}H=this._getRefreshAfterChange(H,G);K=a._createUrlParamsArray(I);J=this._getHeaders(J);N="DELETE";D=D||this._getETag(P,j);function W(X,Y){k=n.substr(n.lastIndexOf('/')+1);if(k.indexOf('?')!==-1){k=k.substr(0,k.indexOf('?'));}V._removeEntity(k);if(S){S(X,Y);}}return this._processRequest(function(X){n=V._createRequestUrl(P,j,K,V.bUseBatch);R=V._createRequest(n,N,J,undefined,D);T=V.mRequests;if(G in V.mDeferredGroups){T=V.mDeferredRequests;}V._pushToRequestQueue(T,G,z,R,W,E,X,H);return R;},E);};y.prototype.callFunction=function(i,P){var R,j,k,n,z,D,S,E,G="GET",H,I,J,K,N=this,T,V,W,X,Y,Z,$,_={};if(P){H=P.groupId||P.batchGroupId;I=P.changeSetId;G=P.method?P.method:G;z=Q.extend({},P.urlParameters);K=P.eTag;S=P.success;E=P.error;J=P.headers;$=P.refreshAfterChange;}$=this._getRefreshAfterChange($,H);if(!i.startsWith("/")){L.fatal(this+" callFunction: path '"+i+"' must be absolute!");return;}J=this._getHeaders(J);Y=new Promise(function(a1,b1){W=a1;X=b1;});Z=this._processRequest(function(a1){k=N.oMetadata._getFunctionImportMetadata(i,G);r(k,N+": Function "+i+" not found in the metadata !");if(!k){X();return;}var b1=k.entitySet||k.entitySetPath;if(b1){_.$result={__list:[]};if(k.returnType&&k.returnType.indexOf("Collection")==-1){_.$result={__ref:{}};}}if(k.parameter!=null){Q.each(k.parameter,function(c1,d1){_[d1.name]=N._createPropertyValue(d1.type);if(z&&z[d1.name]!==undefined){_[d1.name]=z[d1.name];z[d1.name]=a.formatValue(z[d1.name],d1.type);}else{L.warning(N+" - No value for parameter '"+d1.name+"' found!'");}});}T=i.substring(1)+"('"+u()+"')";_.__metadata={uri:N.sServiceUrl+'/'+T,created:{key:i.substring(1),success:S,error:E,headers:J,method:G,groupId:H,changeSetId:I,eTag:K,functionImport:true}};N._addEntity(_);V=N.getContext("/"+T);W(V);D=a._createUrlParamsArray(z);j=N._createRequestUrl(i,null,D,N.bUseBatch);R=N._createRequest(j,G,J,undefined,K);R.key=T;n=N.mRequests;if(H in N.mDeferredGroups){n=N.mDeferredRequests;}N._pushToRequestQueue(n,H,I,R,S,E,a1,$);return R;},E);Z.contextCreated=function(){return Y;};return Z;};y.prototype._createFunctionImportParameters=function(i,j,P){var k=Q.extend(true,{},P);delete k.__metadata;delete k["$result"];var n=this.oMetadata._getFunctionImportMetadata(i,j);r(n,this+": Function "+i+" not found in the metadata !");if(!n){return;}if(n.parameter!=null){Q.each(n.parameter,function(I,z){if(k&&k[z.name]!==undefined){k[z.name]=a.formatValue(k[z.name],z.type);}});}return k;};y.prototype.read=function(P,i){var R,j,k,n,S,E,z,D,G,H,I,J,N,K,T,V,W,X,Y,Z=this;if(i){k=i.context;n=i.urlParameters;S=i.success;E=i.error;z=i.filters;D=i.sorters;W=i.groupId||i.batchGroupId;T=i.headers;}if(this.sRefreshGroupId){W=this.sRefreshGroupId;}K=a._createUrlParamsArray(n);T=this._getHeaders(T,true);V="GET";X=this._getETag(P,k);var $={abort:function(){if(R){R._aborted=true;}}};function _(a1){H=a.createSortParams(D);if(H){K.push(H);}var b1=P;var c1=P.indexOf("$count");if(c1!==-1){b1=P.substring(0,c1-1);}N=Z._normalizePath(b1,k);J=Z.oMetadata._getEntityTypeByPath(N);I=F.groupFilters(z);G=a.createFilterParams(I,Z.oMetadata,J);if(G){K.push(G);}j=Z._createRequestUrl(P,k,K,Z.bUseBatch);R=Z._createRequest(j,V,T,null,X);Y=Z.mRequests;if(W in Z.mDeferredGroups){Y=Z.mDeferredRequests;}Z._pushToRequestQueue(Y,W,null,R,S,E,a1,false);return R;}if(this.bUseBatch&&this.bIncludeInCurrentBatch){R=_($);return $;}else{return this._processRequest(_,E);}};y.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata();}};y.prototype.metadataLoaded=function(){var i=this.oMetadata.loaded();if(this.bLoadAnnotationsJoined){var j=function(){return i;};return this.pAnnotationsLoaded.then(j,j);}else{return i;}};y.prototype.annotationsLoaded=function(){return this.pAnnotationsLoaded;};y.prototype.isMetadataLoadingFailed=function(){return this.oMetadata.isFailed();};y.prototype.getServiceAnnotations=function(){var i=this.oAnnotations.getData();return Q.isEmptyObject(i)?null:i;};y.prototype.onAnnotationsFailed=function(E){this.fireAnnotationsFailed(E.getParameters());};y.prototype.onAnnotationsLoaded=function(E){this.fireAnnotationsLoaded(E.getParameters());};y.prototype.addAnnotationUrl=function(i){var j=[].concat(i),k=[],n=[],E=[],z=this;j.forEach(function(D){var I=D.indexOf("$metadata");if(I>=0){D=z._createMetadataUrl(D);k.push(D);}else{n.push(D);}});return this.oMetadata._addUrl(k).then(function(P){return Promise.all(Q.map(P,function(D){E=E.concat(D.entitySets);return z.oAnnotations.addSource({type:"xml",data:D["metadataString"]});}));}).then(function(){return z.oAnnotations.addSource(n);}).then(function(P){return{annotations:z.oAnnotations.getData(),entitySets:E};});};y.prototype.addAnnotationXML=function(X,S){return this.oAnnotations.addSource({type:"xml",data:X});};y.prototype.submitChanges=function(P){var R,G,j,S,E,k,n,z=false,D,H,I=this.bRefreshAfterChange,J,K=this;if(P){G=P.groupId||P.batchGroupId;S=P.success;E=P.error;if(P.merge!==undefined){D=P.merge?"MERGE":"PUT";}}if(G&&!this.mDeferredGroups[G]){L.fatal(this+" submitChanges: \""+G+"\" is not a deferred group!");}H=v({},K.mChangedEntities);this.oMetadata.loaded().then(function(){Q.each(H,function(Y,Z){j=K._resolveGroup(Y);if(j.groupId===G||!G){R=K._processChange(Y,Z,D||K.sDefaultUpdateMethod);R.key=Y;J=Z.__metadata&&Z.__metadata.created?Z.__metadata.created:{};var k={abort:function(){R._aborted=true;}};if(j.groupId in K.mDeferredGroups){K._pushToRequestQueue(K.mDeferredRequests,j.groupId,j.changeSetId,R,J.success,J.error,k,I);}}});var N,T,V,W,X,i;for(N in K.mDeferredRequests){V=K.mDeferredRequests[N];for(T in V.changes){W=V.changes[T];for(i=W.length-1;i>=0;i--){X=W[i];if(X.bRefreshAfterChange===undefined){X.bRefreshAfterChange=I;}}}}n=K._processRequestQueue(K.mDeferredRequests,G,S,E);if(z){k.abort();}});k={abort:function(){if(n){if(Array.isArray(n)){n.forEach(function(k){k.abort();});}else{n.abort();}}else{if(!z&&E){E(A);}z=true;}}};return k;};y.prototype._updateChangedEntities=function(i){var j=this,R;function k(n,z){Q.each(z,function(K){var D=R+'/'+K;if(x(z[K])&&x(n[K])){k(n[K],z[K]);if(Q.isEmptyObject(z[K])){delete z[K];}}else if(t(z[K],n[K])&&!j.isLaundering(D)){delete z[K];}});}Q.each(i,function(K,D){if(K in j.mChangedEntities){var E=j._getObject('/'+K,null,true);var n=j._getObject('/'+K);v(E,D);R='/'+K;k(E,n);if(Q.isEmptyObject(n)){delete j.mChangedEntities[K];j.abortInternalRequest(K,j._resolveGroup(K).groupId);}else{j.mChangedEntities[K]=n;n.__metadata={};Q.extend(n.__metadata,E.__metadata);}}});};y.prototype.resetChanges=function(P){var j=this,k,E={},n,z;if(P){Q.each(P,function(I,D){j.getEntityByPath(D,null,E);k=E.propertyPath.split("/");var K=E.key;n=j.mChangedEntities[K];for(var i=0;i<k.length-1;i++){if(n.hasOwnProperty(k[i])){n=n[k[i]];}else{n=undefined;}}if(n){delete n[k[k.length-1]];}if(j.mChangedEntities[K]){z=j.mChangedEntities[K].__metadata;delete j.mChangedEntities[K].__metadata;if(Q.isEmptyObject(j.mChangedEntities[K])||!E.propertyPath){j.oMetadata.loaded().then(function(){j.abortInternalRequest(K,j._resolveGroup(K).groupId);});delete j.mChangedEntities[K];sap.ui.getCore().getMessageManager().removeMessages(j.getMessagesByEntity(K,true));}else{j.mChangedEntities[K].__metadata=z;}}else{L.warning(j+" - resetChanges: "+D+" is not changed");}});}else{Q.each(this.mChangedEntities,function(K,i){j.oMetadata.loaded().then(function(){j.abortInternalRequest(K,j._resolveGroup(K).groupId);});delete j.mChangedEntities[K];sap.ui.getCore().getMessageManager().removeMessages(j.getMessagesByEntity(K,true));});}this.checkUpdate(true);};y.prototype.setProperty=function(P,V,j,k){var n,z,R,D,E,G,H,I,K,J,N,S,T={},W={},X,Y,Z,$=false,_=this,a1;function b1(c1,d1){Q.each(d1,function(K){if(x(d1[K])&&x(c1[K])){b1(c1[K],d1[K]);if(Q.isEmptyObject(d1[K])){delete d1[K];}}else if(t(d1[K],c1[K])){delete d1[K];}});}H=this.resolve(P,j,true);G=this.getEntityByPath(H,null,W);if(!G){return false;}z=H.substring(H.lastIndexOf("/")+1);K=W.key;E=this._getObject('/'+K,null,true);n=this._getObject(P,j,true);if(!this.mChangedEntities[K]){S=G.__metadata;G={};G.__metadata=Q.extend({},S);this.mChangedEntities[K]=G;}Y=this.mChangedEntities[K];I=W.propertyPath.split("/");for(var i=0;i<I.length-1;i++){if(!Y.hasOwnProperty(I[i])){Y[I[i]]={};}Y=Y[I[i]];}$=E.__metadata.created&&E.__metadata.created.functionImport;Y[z]=V;if(t(V,n)&&!this.isLaundering('/'+K)&&!$){S=this.mChangedEntities[K].__metadata;a1=S&&S.created;delete this.mChangedEntities[K].__metadata;if(!a1){b1(E,this.mChangedEntities[K]);}if(Q.isEmptyObject(this.mChangedEntities[K])){delete this.mChangedEntities[K];T[K]=true;this.checkUpdate(false,k,T);_.oMetadata.loaded().then(function(){_.abortInternalRequest(K,_._resolveGroup(K).groupId);});return true;}this.mChangedEntities[K].__metadata=S;}J=this._resolveGroup(K);R=this.mRequests;if(J.groupId in this.mDeferredGroups){R=this.mDeferredRequests;D=this._processChange(K,{__metadata:G.__metadata});}else{D=this._processChange(K,this._getObject('/'+K));}D.key=K;X=Y.__metadata&&Y.__metadata.created?Y.__metadata.created:{};Z=this._getRefreshAfterChange(undefined,J.groupId);this.oMetadata.loaded().then(function(){N={abort:function(){D._aborted=true;}};_._pushToRequestQueue(R,J.groupId,J.changeSetId,D,X.success,X.error,N,Z);_._processRequestQueueAsync(_.mRequests);});T[K]=true;this.checkUpdate(false,k,T);return true;};y.prototype._isHeaderPrivate=function(H){switch(H.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;case"sap-contextid-accept":case"sap-contextid":return!this.bDisableSoftStateHeader;default:return false;}};y.prototype.setHeaders=function(H){var i={},j=this;this.mCustomHeaders={};if(H){Q.each(H,function(k,n){if(j._isHeaderPrivate(k)){L.warning(this+" - modifying private header: '"+k+"' not allowed!");}else{i[k]=n;}});this.mCustomHeaders=i;}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders);}};y.prototype._getHeaders=function(H,i){var j={},k=this;if(H){Q.each(H,function(n,z){if(k._isHeaderPrivate(n)){L.warning(this+" - modifying private header: '"+n+"' not allowed!");}else{j[n]=z;}});}return Q.extend({'sap-cancel-on-close':!!i},this.mCustomHeaders,j,this.oHeaders);};y.prototype.getHeaders=function(){return Q.extend({},this.mCustomHeaders,this.oHeaders);};y.prototype._getHeader=function(H,i){var j;for(j in i){if(j.toLowerCase()===H.toLowerCase()){return i[j];}}return null;};y.prototype.hasPendingChanges=function(){return!Q.isEmptyObject(this.mChangedEntities);};y.prototype.hasPendingRequests=function(){return this.aPendingRequestHandles.length>0;};y.prototype.getPendingChanges=function(){return v({},this.mChangedEntities);};y.prototype.updateBindings=function(i){this.checkUpdate(i);};y.prototype.setTokenHandlingEnabled=function(T){this.bTokenHandling=T;};y.prototype.setUseBatch=function(i){this.bUseBatch=i;};y.prototype.formatValue=function(V,T){return a.formatValue(V,T);};y.prototype.deleteCreatedEntry=function(i){var j=this,k,G;if(i){var k=i.getPath().substr(1);G=this._resolveGroup(k).groupId;j.oMetadata.loaded().then(function(){j.abortInternalRequest(k,G);});j._removeEntity(k);sap.ui.getCore().getMessageManager().removeMessages(this.getMessagesByEntity(i.getPath(),true));}};y.prototype.createEntry=function(P,j){var S,E,R,k,n,z,K,D,G,H,I,J,N,T,V,W={},X,Y="POST",Z=this;if(j){V=j.properties;G=j.groupId||j.batchGroupId;H=j.changeSetId;z=j.context;S=j.success;E=j.error;X=j.created;n=j.eTag;N=j.headers;J=j.urlParameters;I=j.refreshAfterChange;}N=N||{};I=this._getRefreshAfterChange(I,G);G=G?G:this.sDefaultChangeGroup;D=a._createUrlParamsArray(J);var $={abort:function(){if(R){R._aborted=true;}}};function _(){var a1;if(!P.startsWith("/")){P="/"+P;}var b1=Z.oMetadata._getEntityTypeByPath(P);if(!b1){r(b1,"No Metadata for collection "+P+" found");return undefined;}if(typeof V==="object"&&!Array.isArray(V)){W=v({},V);}else{for(var i=0;i<b1.property.length;i++){var c1=b1.property[i];var d1=(V?V.indexOf(c1.name):-1)>-1;if(!V||d1){W[c1.name]=Z._createPropertyValue(c1.type);if(d1){V.splice(V.indexOf(c1.name),1);}}}if(V){r(V.length===0,"No metadata for the following properties found: "+V.join(","));}}var e1=Z.oMetadata._getEntitySetByType(b1);K=e1.name+"('"+u()+"')";W.__metadata={type:""+b1.entityType,uri:Z.sServiceUrl+'/'+K,created:{key:P.substring(1),success:S,error:E,headers:N,urlParameters:J,groupId:G,changeSetId:H,eTag:n}};Z._addEntity(v({},W));Z.mChangedEntities[K]=W;k=Z._createRequestUrl(P,z,D,Z.bUseBatch);R=Z._createRequest(k,Y,N,W,n);a1=Z.getContext("/"+K);a1.bCreated=true;R.key=K;R.created=true;T=Z.mRequests;if(G in Z.mDeferredGroups){T=Z.mDeferredRequests;}Z.oMetadata.loaded().then(function(){Z._pushToRequestQueue(T,G,H,R,S,E,$,I);Z._processRequestQueueAsync(Z.mRequests);});return a1;}if(X){this.oMetadata.loaded().then(function(){X(_());});}else if(this.oMetadata.isLoaded()){return _();}else{L.error("Tried to use createEntry without created-callback, before metadata is available!");}};y.prototype._isCreatedEntity=function(E){return!!(E&&E.__metadata&&E.__metadata.created);};y.prototype._createPropertyValue=function(T){var j=this.oMetadata._splitName(T);var n=j.namespace;var k=j.name;if(n.toUpperCase()!=='EDM'){var z={};var D=this.oMetadata._getObjectMetadata("complexType",k,n);r(D,"Complex type "+T+" not found in the metadata !");for(var i=0;i<D.property.length;i++){var P=D.property[i];z[P.name]=this._createPropertyValue(P.type);}return z;}else{return this._getDefaultPropertyValue(k,n);}};y.prototype._getDefaultPropertyValue=function(T,n){return undefined;};y.prototype._normalizePath=function(P,i){if(P&&P.indexOf('?')!==-1){P=P.substr(0,P.indexOf('?'));}if(!i&&!P.startsWith("/")){L.fatal(this+" path "+P+" must be absolute if no Context is set");}return this.resolve(P,i);};y.prototype.getRefreshAfterChange=function(){return this.bRefreshAfterChange;};y.prototype.setRefreshAfterChange=function(R){this.bRefreshAfterChange=R;};y.prototype.isList=function(P,i){P=this.resolve(P,i);return P&&P.substr(P.lastIndexOf("/")).indexOf("(")===-1;};y.prototype._isMetadataPath=function(P){var i=false;if(P&&P.indexOf('/#')>-1){i=true;}return i;};y.prototype.isMetaModelPath=function(P){return P.indexOf("##")==0||P.indexOf("/##")>-1;};y.prototype._request=function(R,S,E,H,i,j){var k;if(this.bDestroyed){return{abort:function(){}};}var n=this;function z(D){return function(){if(n.aPendingRequestHandles){var I=n.aPendingRequestHandles.indexOf(k);if(I>-1){n.aPendingRequestHandles.splice(I,1);}}if(!(k&&k.bSuppressErrorHandlerCall)){D.apply(this,arguments);}};}k=q.request(R,z(S||q.defaultSuccess),z(E||q.defaultError),H,i,j);if(R.async!==false){this.aPendingRequestHandles.push(k);}return k;};y.prototype.destroy=function(){this.bDestroyed=true;M.prototype.destroy.apply(this,arguments);if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var R=this.aPendingRequestHandles[i];if(R&&R.abort){R.bSuppressErrorHandlerCall=true;R.abort();}}delete this.aPendingRequestHandles;}if(this.sMetadataLoadEvent){clearTimeout(this.sMetadataLoadEvent);}if(this.oMetadataFailedEvent){clearTimeout(this.oMetadataFailedEvent);}if(this.oMetadata){this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oSharedMetaData.oMetadata;}delete this.oMetadata;delete this.pMetadataLoaded;}if(this.oMetaModel){this.oMetaModel.destroy();delete this.oMetaModel;}if(this.oAnnotations){this.oAnnotations.detachSomeLoaded(this.onAnnotationsLoaded);this.oAnnotations.detachAllFailed(this.onAnnotationsFailed);this.oAnnotations.destroy();delete this.oAnnotations;delete this.pAnnotationsLoaded;}};y.prototype.setDeferredBatchGroups=function(G){this.setDeferredGroups(G);};y.prototype.setDeferredGroups=function(G){var i=this;this.mDeferredGroups={};Q.each(G,function(I,j){i.mDeferredGroups[j]=j;});};y.prototype.getDeferredBatchGroups=function(){return this.getDeferredGroups();};y.prototype.getDeferredGroups=function(){return Object.keys(this.mDeferredGroups);};y.prototype.setChangeBatchGroups=function(G){Q.each(G,function(E,i){i.groupId=i.batchGroupId;});this.setChangeGroups(G);};y.prototype.setChangeGroups=function(G){this.mChangeGroups=G;};y.prototype.getChangeBatchGroups=function(){return this.getChangeGroups();};y.prototype.getChangeGroups=function(){return this.mChangeGroups;};y.prototype.setMessageParser=function(P){if(!(P instanceof o)){L.error("Given MessageParser is not of type sap.ui.core.message.MessageParser");return this;}P.setProcessor(this);this.oMessageParser=P;return this;};y.prototype._parseResponse=function(R,i,G,j){try{if(!this.oMessageParser){this.oMessageParser=new p(this.sServiceUrl,this.oMetadata);this.oMessageParser.setProcessor(this);}this.oMessageParser.parse(R,i,G,j);}catch(k){L.error("Error parsing OData messages: "+k);}};y.prototype.callAfterUpdate=function(i){this.aCallAfterUpdate.push(i);};y.prototype.getMetaModel=function(){var i=this;if(!this.oMetaModel){this.oMetaModel=new m(this.oMetadata,this.oAnnotations,{addAnnotationUrl:this.addAnnotationUrl.bind(this),annotationsLoadedPromise:this.pAnnotationsLoaded});this.oMetaModel.loaded().then(function(){i.bMetaModelLoaded=true;i.checkUpdate(false,false,null,true);},function(E){var j=E.message,D;if(!j&&E.xmlDoc&&E.xmlDoc.parseError){j=E.xmlDoc.parseError.reason;D=E.xmlDoc.parseError.srcText;}L.error("error in ODataMetaModel.loaded(): "+j,D,"sap.ui.model.odata.v2.ODataModel");});}return this.oMetaModel;};y.prototype.getOriginalProperty=function(P,i){return this._getObject(P,i,true);};y.prototype.getEntityByPath=function(P,i,E){var R=M.prototype.resolve.call(this,P,i);if(!R){return null;}var j=R.split("/"),k=null,n=[];while(j.length>0){var z=j.join("/"),D=this._getObject(z);if(x(D)){var K=this._getKey(D);if(K){k=D;break;}}n.unshift(j.pop());}if(k){E.propertyPath=n.join("/");E.key=K;return k;}return null;};y.prototype.resolve=function(P,i,j){var R=M.prototype.resolve.call(this,P,i);if(!this._isMetadataPath(R)&&j){var E={},k=this.getEntityByPath(P,i,E);if(k){if(E.propertyPath){return"/"+E.key+"/"+E.propertyPath;}else{return"/"+E.key;}}else{return undefined;}}return R;};y.prototype.isLaundering=function(P,i){var R=this.resolve(P,i);return(R in this.mLaunderingState)&&this.mLaunderingState[R]>0;};y.prototype.increaseLaundering=function(P,i){if(!i){return;}for(var n in i){if(n==="__metadata"){continue;}var j=i[n];if(x(j)){this.increaseLaundering(P+"/"+n,j);}else{var T=P+"/"+n;if(!(T in this.mLaunderingState)){this.mLaunderingState[T]=0;}this.mLaunderingState[T]++;}}if(!(P in this.mLaunderingState)){this.mLaunderingState[P]=0;}this.mLaunderingState[P]++;};y.prototype.decreaseLaundering=function(P,i){if(!i){return;}for(var n in i){if(n==="__metadata"){continue;}var j=i[n],T=P+"/"+n;if(x(j)){this.decreaseLaundering(T,j);}else{if(T in this.mLaunderingState){this.mLaunderingState[T]--;if(this.mLaunderingState[T]===0){delete this.mLaunderingState[T];}}}}this.mLaunderingState[P]--;if(this.mLaunderingState[P]===0){delete this.mLaunderingState[P];}};y.prototype._getRefreshAfterChange=function(R,G){if(R===undefined&&!(G in this.mDeferredGroups)){return this.bRefreshAfterChange;}return R;};y.prototype.getMessagesByEntity=function(E,j){var k=E,n=[],P;function z(n){var D=[];for(var i=0;i<n.length;i++){if(!j||(j&&!n[i].persistent)){D.push(n[i]);}}return D;}if(!k.startsWith('/')){k='/'+k;}if(this.mMessages){for(P in this.mMessages){if(typeof k=="string"&&k.length>0&&P.startsWith(k)){n=n.concat(z(this.mMessages[P]));}}return n;}return null;};y.prototype._cacheSupported=function(i){var j=/\/~[\w\-]+~[A-Z0-9]?/;var k=[i];if(this.sAnnotationURI){if(!Array.isArray(this.sAnnotationURI)){this.sAnnotationURI=[this.sAnnotationURI];}k=k.concat(this.sAnnotationURI);}k=k.filter(function(n){return n.indexOf("sap-context-token")===-1;});k=k.filter(function(n){return!j.test(n);});return k.length===0?true:false;};y.prototype._getAnnotationCacheKey=function(i){var j;if(this.bUseCache){if(!this.bSkipMetadataAnnotationParsing){j=i+"#annotations";}if(this.sAnnotationURI){if(!Array.isArray(this.sAnnotationURI)){this.sAnnotationURI=[this.sAnnotationURI];}this.sAnnotationURI=this.sAnnotationURI.map(function(k){return k+"#annotations";});j=this.bSkipMetadataAnnotationParsing?this.sAnnotationURI.join("_"):j+"_"+this.sAnnotationURI.join("_");}}return j;};return y;});
