/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./Context","./ODataParentBinding","./lib/_AggregationCache","./lib/_AggregationHelper","./lib/_Cache","./lib/_GroupLock","./lib/_Helper","sap/base/Log","sap/ui/base/SyncPromise","sap/ui/model/Binding","sap/ui/model/ChangeReason","sap/ui/model/FilterOperator","sap/ui/model/FilterProcessor","sap/ui/model/FilterType","sap/ui/model/ListBinding","sap/ui/model/Sorter","sap/ui/model/odata/OperationMode","sap/ui/thirdparty/jquery"],function(C,a,_,b,c,d,e,L,S,B,f,F,g,h,j,k,O,q){"use strict";var s="sap.ui.model.odata.v4.ODataListBinding",m={AggregatedDataStateChange:true,change:true,dataReceived:true,dataRequested:true,DataStateChange:true,patchCompleted:true,patchSent:true,refresh:true};var l=j.extend("sap.ui.model.odata.v4.ODataListBinding",{constructor:function(M,p,o,v,i,P){j.call(this,M,p);a.call(this);if(p.slice(-1)==="/"){throw new Error("Invalid path: "+p);}this.oAggregation=null;this.mAggregatedQueryOptions={};this.bAggregatedQueryOptionsInitial=true;this.aApplicationFilters=e.toArray(i);l.checkCaseSensitiveFilters(this.aApplicationFilters);this.oCachePromise=S.resolve();this.sChangeReason=M.bAutoExpandSelect?"AddVirtualContext":undefined;this.aChildCanUseCachePromises=[];this.oDiff=undefined;this.aFilters=[];this.bHasAnalyticalInfo=false;this.mPreviousContextsByPath={};this.aPreviousData=[];this.oReadGroupLock=undefined;this.aSorters=e.toArray(v);this.applyParameters(q.extend(true,{},P));this.oHeaderContext=this.bRelative?null:C.create(this.oModel,this,p);if(!this.bRelative||o&&!o.fetchValue){this.createReadGroupLock(this.getGroupId(),true);}this.setContext(o);M.bindingCreated(this);}});a(l.prototype);l.checkCaseSensitiveFilters=function(i){function n(o){if(o.bCaseSensitive===false){throw new Error("Filter for path '"+o.sPath+"' has unsupported value for 'caseSensitive' : false");}if(o.aFilters){l.checkCaseSensitiveFilters(o.aFilters);}if(o.oCondition){n(o.oCondition);}}i.forEach(n);};l.prototype._delete=function(G,E,o){var t=this;if(!o.isTransient()&&this.hasPendingChanges()){throw new Error("Cannot delete due to pending changes");}return this.deleteFromCache(G,E,String(o.iIndex),function(I,n){var p,i,P,r;if(I===-1){o.destroy();delete t.aContexts[-1];}else{for(i=I;i<t.aContexts.length;i+=1){o=t.aContexts[i];if(o){t.mPreviousContextsByPath[o.getPath()]=o;}}r=t.oModel.resolve(t.sPath,t.oContext);t.aContexts.splice(I,1);for(i=I;i<t.aContexts.length;i+=1){if(t.aContexts[i]){P=e.getPrivateAnnotation(n[i],"predicate");p=r+(P||"/"+i);o=t.mPreviousContextsByPath[p];if(o){delete t.mPreviousContextsByPath[p];if(o.getIndex()===i){o.checkUpdate();}else{o.setIndex(i);}}else{o=C.create(t.oModel,t,p,i);}t.aContexts[i]=o;}}}t.iMaxLength-=1;t._fireChange({reason:f.Remove});});};l.prototype.applyParameters=function(p,i){var A,o;this.checkBindingParameters(p,["$$aggregation","$$groupId","$$operationMode","$$ownRequest","$$updateGroupId"]);o=p.$$operationMode||this.oModel.sOperationMode;if(!o&&(this.aSorters.length||this.aApplicationFilters.length)){throw new Error("Unsupported operation mode: "+o);}this.sOperationMode=o;this.sGroupId=p.$$groupId;this.sUpdateGroupId=p.$$updateGroupId;this.mQueryOptions=this.oModel.buildQueryOptions(p,true);this.mParameters=p;if("$$aggregation"in p){if("$apply"in this.mQueryOptions){throw new Error("Cannot combine $$aggregation and $apply");}A=e.clone(p.$$aggregation);this.mQueryOptions.$apply=b.buildApply(A).$apply;this.oAggregation=A;}this.removeCachesAndMessages();this.fetchCache(this.oContext);this.reset(i);};l.prototype.attachEvent=function(E){if(!(E in m)){throw new Error("Unsupported event '"+E+"': v4.ODataListBinding#attachEvent");}return j.prototype.attachEvent.apply(this,arguments);};l.prototype.create=function(i,n){var o,v,p,G,r=this.oModel.resolve(this.sPath,this.oContext),t=this;if(!r){throw new Error("Binding is not yet resolved: "+this);}if(this.aContexts[-1]){throw new Error("Must not create twice");}this.checkSuspended();v=r.slice(1);if(this.bRelative&&this.oContext.fetchCanonicalPath){v=this.oContext.fetchCanonicalPath().then(function(u){return e.buildPath(u,t.sPath).slice(1);});}G=this.lockGroup(this.getUpdateGroupId(),true);p=this.createInCache(G,v,"",i,function(){o.destroy();delete t.aContexts[-1];t._fireChange({reason:f.Remove});}).then(function(u){var w;t.iMaxLength+=1;if(!n&&t.isRefreshable()){w=t.getGroupId();if(!t.oModel.isDirectGroup(w)&&!t.oModel.isAutoGroup(w)){w="$auto";}return t.refreshSingle(o,t.lockGroup(w));}return u;},function(E){G.unlock(true);throw E;}).then(function(u){var P;if(!(i&&i["@$ui5.keepTransientPath"])){P=e.getPrivateAnnotation(u,"predicate");if(P){o.sPath=r+P;}}});o=C.create(this.oModel,this,r+"/-1",-1,p);this.aContexts[-1]=o;this._fireChange({reason:f.Add});return o;};l.prototype.createContexts=function(n,o,r){var p=false,t=this.oContext,u,i,v=r.$count,I=this.aContexts.length,w=this.bLengthFinal,M=this.oModel,P=M.resolve(this.sPath,t),x,y=this;function z(N){var i;for(i=N;i<y.aContexts.length;i+=1){if(y.aContexts[i]){y.aContexts[i].destroy();}}while(N>0&&!y.aContexts[N-1]){N-=1;}y.aContexts.length=N;p=true;}for(i=n;i<n+r.length;i+=1){if(this.aContexts[i]===undefined){p=true;x=e.getPrivateAnnotation(r[i-n],"predicate");u=P+(x||"/"+i);if(u in this.mPreviousContextsByPath){this.aContexts[i]=this.mPreviousContextsByPath[u];delete this.mPreviousContextsByPath[u];this.aContexts[i].setIndex(i);this.aContexts[i].checkUpdate();}else{this.aContexts[i]=C.create(M,this,u,i);}}}if(Object.keys(this.mPreviousContextsByPath).length){sap.ui.getCore().addPrerenderingTask(function(){Object.keys(y.mPreviousContextsByPath).forEach(function(P){y.mPreviousContextsByPath[P].destroy();delete y.mPreviousContextsByPath[P];});});}if(v!==undefined){if(this.aContexts.length>v){z(v);}this.iMaxLength=v;this.bLengthFinal=true;}else{if(this.aContexts.length>this.iMaxLength){this.iMaxLength=Infinity;}if(r.length<o){this.iMaxLength=n+r.length;if(this.aContexts.length>this.iMaxLength){z(this.iMaxLength);}}if(!(n>I&&r.length===0)){this.bLengthFinal=this.aContexts.length===this.iMaxLength;}}if(this.bLengthFinal!==w){p=true;}return p;};l.prototype.destroy=function(){if(this.bHasAnalyticalInfo&&this.aContexts===undefined){return;}this.aContexts.forEach(function(o){o.destroy();});if(this.oHeaderContext){this.oHeaderContext.destroy();}if(this.aContexts[-1]){this.aContexts[-1].destroy();}this.oModel.bindingDestroyed(this);this.removeReadGroupLock();this.mAggregatedQueryOptions=undefined;this.oAggregation=undefined;this.aApplicationFilters=undefined;this.oCachePromise=S.resolve();this.oContext=undefined;this.aContexts=undefined;this.aFilters=undefined;this.oHeaderContext=undefined;this.mPreviousContextsByPath=undefined;this.aPreviousData=undefined;this.aSorters=undefined;j.prototype.destroy.apply(this);};l.prototype.doCreateCache=function(r,Q,o){var A=this.oAggregation&&(this.oAggregation.groupLevels.length||b.hasMinOrMax(this.oAggregation.aggregate)||b.hasGrandTotal(this.oAggregation.aggregate));Q=this.inheritQueryOptions(Q,o);return A?_.create(this.oModel.oRequestor,r,this.oAggregation,Q):c.create(this.oModel.oRequestor,r,Q,this.oModel.bAutoExpandSelect);};l.prototype.doFetchQueryOptions=function(o){var i=this.getOrderby(this.mQueryOptions.$orderby),t=this;return this.fetchFilter(o,this.mQueryOptions.$filter).then(function(n){return t.mergeQueryOptions(t.mQueryOptions,i,n);});};l.prototype.enableExtendedChangeDetection=function(D,K){if(K!==undefined){throw new Error("Unsupported property 'key' with value '"+K+"' in binding info for "+this);}return j.prototype.enableExtendedChangeDetection.apply(this,arguments);};l.prototype.fetchFilter=function(o,i){var n,M,p;function r(v,E,W){var x,V=e.formatLiteral(v.oValue1,E),y=decodeURIComponent(v.sPath);switch(v.sOperator){case F.BT:x=y+" ge "+V+" and "+y+" le "+e.formatLiteral(v.oValue2,E);break;case F.NB:x=w(y+" lt "+V+" or "+y+" gt "+e.formatLiteral(v.oValue2,E),W);break;case F.EQ:case F.GE:case F.GT:case F.LE:case F.LT:case F.NE:x=y+" "+v.sOperator.toLowerCase()+" "+V;break;case F.Contains:case F.EndsWith:case F.NotContains:case F.NotEndsWith:case F.NotStartsWith:case F.StartsWith:x=v.sOperator.toLowerCase().replace("not","not ")+"("+y+","+V+")";break;default:throw new Error("Unsupported operator: "+v.sOperator);}return x;}function t(v,x,W){if(v.aFilters){return S.all(v.aFilters.map(function(y){return t(y,x,v.bAnd);})).then(function(y){return w(y.join(v.bAnd?" and ":" or "),W&&!v.bAnd);});}return M.fetchObject(u(v.sPath,x),p).then(function(P){var y,z,A;if(!P){throw new Error("Type cannot be determined, no metadata for path: "+p.getPath());}A=v.sOperator;if(A===F.All||A===F.Any){y=v.oCondition;z=v.sVariable;if(A===F.Any&&!y){return v.sPath+"/any()";}x=Object.create(x);x[z]=u(v.sPath,x);return t(y,x).then(function(D){return v.sPath+"/"+v.sOperator.toLowerCase()+"("+z+":"+D+")";});}return r(v,P.$Type,W);});}function u(P,v){var x=P.split("/");x[0]=v[x[0]];return x[0]?x.join("/"):P;}function w(v,W){return W?"("+v+")":v;}n=g.combineFilters(this.aFilters,this.aApplicationFilters);if(!n){return S.resolve(i);}M=this.oModel.getMetaModel();p=M.getMetaContext(this.oModel.resolve(this.sPath,o));return t(n,{},i).then(function(v){if(i){v+=" and ("+i+")";}return v;});};l.prototype.fetchValue=function(p,o,i){var t=this;return this.oCachePromise.then(function(n){var r;if(n){r=t.getRelativePath(p);if(r!==undefined){return n.fetchValue(d.$cached,r,undefined,o);}}if(t.oContext){return t.oContext.fetchValue(p,o,i);}});};l.prototype.filter=function(v,i){var n=e.toArray(v);l.checkCaseSensitiveFilters(n);this.checkSuspended();if(this.sOperationMode!==O.Server){throw new Error("Operation mode has to be sap.ui.model.odata.OperationMode.Server");}if(this.hasPendingChanges()){throw new Error("Cannot filter due to pending changes");}this.createReadGroupLock(this.getGroupId(),true);if(i===h.Control){this.aFilters=n;}else{this.aApplicationFilters=n;}this.removeCachesAndMessages();this.fetchCache(this.oContext);this.reset(f.Filter);return this;};l.prototype.getContexts=function(i,n,M){var o,p=this.oContext,r,D=false,t=false,G,P,R=!!this.sChangeReason,u,v,w=this;L.debug(this+"#getContexts("+i+", "+n+", "+M+")",undefined,s);this.checkSuspended();if(i!==0&&this.bUseExtendedChangeDetection){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" first parameter must be 0 if extended change detection is enabled, but is "+i);}if(M!==undefined&&this.bUseExtendedChangeDetection){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" third parameter must not be set if extended change detection is enabled");}if(this.bRelative&&!p){this.aPreviousData=[];return[];}o=this.sChangeReason||f.Change;this.sChangeReason=undefined;if(o==="AddVirtualContext"){sap.ui.getCore().addPrerenderingTask(function(){w.sChangeReason="RemoveVirtualContext";w._fireChange({reason:f.Change});w.reset(f.Refresh);},true);v=C.create(this.oModel,this,this.oModel.resolve(this.sPath,this.oContext)+"/-2",-2);return[v];}if(o==="RemoveVirtualContext"){return[];}i=i||0;n=n||this.oModel.iSizeLimit;if(!M||M<0){M=0;}u=this.aContexts[-1]?i-1:i;G=this.oReadGroupLock;this.oReadGroupLock=undefined;if(!this.bUseExtendedChangeDetection||!this.oDiff){P=this.oCachePromise.then(function(x){if(x){G=w.lockGroup(w.getGroupId(),G);return x.read(u,n,M,G,function(){D=true;w.fireDataRequested();});}else{if(G){G.unlock();}return p.fetchValue(w.sPath).then(function(y){var z;y=y||[];z=y.$count;if(u<0){y=[y[-1]].concat(y.slice(0,n-1));}else{y=y.slice(u,u+n);}y.$count=z;return{value:y};});}});if(P.isFulfilled()&&R){P=Promise.resolve(P);}P.then(function(x){var y;if(!w.bRelative||w.oContext===p){y=w.createContexts(u,n,x.value);if(w.bUseExtendedChangeDetection){w.oDiff={aDiff:w.getDiff(x.value,u),iLength:n};}if(t){if(y){w._fireChange({reason:o});}else{w.oDiff=undefined;}}}if(D){w.fireDataReceived({data:{}});}},function(E){if(D){w.fireDataReceived(E.canceled?{data:{}}:{error:E});}throw E;}).catch(function(E){if(G){G.unlock(true);}w.oModel.reportError("Failed to get contexts for "+w.oModel.sServiceUrl+w.oModel.resolve(w.sPath,w.oContext).slice(1)+" with start index "+i+" and length "+n,s,E);});t=true;}this.iCurrentBegin=u;this.iCurrentEnd=u+n;if(u===-1){r=this.aContexts.slice(0,u+n);r.unshift(this.aContexts[-1]);}else{r=this.aContexts.slice(u,u+n);}if(this.bUseExtendedChangeDetection){if(this.oDiff&&n!==this.oDiff.iLength){throw new Error("Extended change detection protocol violation: Expected "+"getContexts(0,"+this.oDiff.iLength+"), but got getContexts(0,"+n+")");}r.dataRequested=!this.oDiff;r.diff=this.oDiff?this.oDiff.aDiff:[];}this.oDiff=undefined;return r;};l.prototype.getCurrentContexts=function(){var i,n=Math.min(this.iCurrentEnd,this.iMaxLength)-this.iCurrentBegin;if(this.iCurrentBegin===-1){i=this.aContexts.slice(0,this.iCurrentBegin+n);i.unshift(this.aContexts[-1]);}else{i=this.aContexts.slice(this.iCurrentBegin,this.iCurrentBegin+n);}while(i.length<n){i.push(undefined);}return i;};l.prototype.getDependentBindings=function(){var t=this;return this.oModel.getDependentBindings(this).filter(function(D){return!(D.oContext.getPath()in t.mPreviousContextsByPath);});};l.prototype.getDiff=function(r,n){var D,N,t=this;N=r.map(function(E,i){return t.bDetectUpdates?JSON.stringify(E):t.aContexts[n+i].getPath();});D=q.sap.arraySymbolDiff(this.aPreviousData,N);this.aPreviousData=N;return D;};l.prototype.getDistinctValues=function(){throw new Error("Unsupported operation: v4.ODataListBinding#getDistinctValues");};l.prototype.getFilterInfo=function(i){var o=g.combineFilters(this.aFilters,this.aApplicationFilters),r=null,n;if(o){r=o.getAST(i);}if(this.mQueryOptions.$filter){n={expression:this.mQueryOptions.$filter,syntax:"OData "+this.oModel.getODataVersion(),type:"Custom"};if(r){r={left:r,op:"&&",right:n,type:"Logical"};}else{r=n;}}return r;};l.prototype.getHeaderContext=function(){return(this.bRelative&&!this.oContext)?null:this.oHeaderContext;};l.prototype.getLength=function(){var i;if(this.bLengthFinal){i=this.iMaxLength;}else{i=this.aContexts.length?this.aContexts.length+10:0;}if(this.aContexts[-1]){i+=1;}return i;};l.prototype.getOrderby=function(o){var i=[],t=this;this.aSorters.forEach(function(n){if(n instanceof k){i.push(n.sPath+(n.bDescending?" desc":""));}else{throw new Error("Unsupported sorter: "+n+" - "+t);}});if(o){i.push(o);}return i.join(',');};l.prototype.inheritQueryOptions=function(Q,o){var i;if(!Object.keys(this.mParameters).length){i=this.getQueryOptionsForPath("",o);if(Q.$orderby&&i.$orderby){Q.$orderby+=","+i.$orderby;}if(Q.$filter&&i.$filter){Q.$filter="("+Q.$filter+") and ("+i.$filter+")";}Q=q.extend({},i,Q);}return Q;};l.prototype.isLengthFinal=function(){return this.bLengthFinal;};l.prototype.mergeQueryOptions=function(Q,o,i){var r;function n(p,v){if(v&&(!Q||Q[p]!==v)){if(!r){r=Q?e.clone(Q):{};}r[p]=v;}}n("$orderby",o);n("$filter",i);return r||Q;};l.prototype.refreshInternal=function(G){var i=this.aContexts,t=this;this.createReadGroupLock(G,this.isRefreshable());this.oCachePromise.then(function(o){if(o){t.removeCachesAndMessages();t.fetchCache(t.oContext);}t.reset(f.Refresh);i.forEach(function(n){t.oModel.getDependentBindings(n).forEach(function(D){D.refreshInternal(G,false);});});});};l.prototype.refreshSingle=function(o,G,A){var t=this;if(!this.isRefreshable()){throw new Error("Binding is not refreshable; cannot refresh entity: "+o);}if(this.hasPendingChangesForPath(o.getPath())||this.hasPendingChangesInDependents(o)){throw new Error("Cannot refresh entity due to pending changes: "+o);}return this.oCachePromise.then(function(n){var D=false,p;function r(i){if(D){t.fireDataReceived(i);}}function u(){D=true;t.fireDataRequested();}function v(){t.oModel.getDependentBindings(o).forEach(function(i){i.refreshInternal(G.getGroupId(),false);});}function w(I){var x=t.aContexts[I],i;if(I===-1){delete t.aContexts[-1];}else{t.aContexts.splice(I,1);for(i=I;i<t.aContexts.length;i+=1){if(t.aContexts[i]){t.aContexts[i].setIndex(i);}}}x.destroy();t.iMaxLength-=1;t._fireChange({reason:f.Remove});}G.setGroupId(t.getGroupId());p=(A?n.refreshSingleWithRemove(G,o.iIndex,u,w):n.refreshSingle(G,o.iIndex,u)).then(function(E){r({data:{}});if(o.oBinding){o.checkUpdate();if(A){v();}}return E;},function(E){r({error:E});throw E;}).catch(function(E){G.unlock(true);t.oModel.reportError("Failed to refresh entity: "+o,s,E);});if(!A){v();}return p;});};l.prototype.reset=function(i){var E=this.iCurrentEnd===0,t=this;if(this.aContexts){this.aContexts.forEach(function(o){t.mPreviousContextsByPath[o.getPath()]=o;});if(this.aContexts[-1]){this.aContexts[-1].destroy();}}this.aContexts=[];this.iCurrentBegin=this.iCurrentEnd=0;this.iMaxLength=Infinity;this.bLengthFinal=false;if(i&&!(E&&i===f.Change)){this.sChangeReason=i;this._fireRefresh({reason:i});}if(this.getHeaderContext()){this.oModel.getDependentBindings(this.oHeaderContext).forEach(function(o){o.checkUpdate();});}};l.prototype.resumeInternal=function(){var i=this.getDependentBindings();this.reset();this.fetchCache(this.oContext);i.forEach(function(D){D.resumeInternal(false);});this._fireChange({reason:f.Change});};l.prototype.setAggregation=function(A){this.checkSuspended();if(this.hasPendingChanges()){throw new Error("Cannot set $$aggregation due to pending changes");}if(!this.oAggregation&&"$apply"in this.mQueryOptions){throw new Error("Cannot override existing $apply : '"+this.mQueryOptions.$apply+"'");}A=e.clone(A);this.mQueryOptions.$apply=b.buildApply(A).$apply;this.oAggregation=A;this.removeCachesAndMessages();this.fetchCache(this.oContext);this.reset(f.Change);};l.prototype.setContext=function(o){var r;if(this.oContext!==o){if(this.bRelative){if(this.aContexts[-1]&&this.aContexts[-1].isTransient()){throw new Error("setContext on relative binding is forbidden if a transient "+"entity exists: "+this);}this.reset();this.fetchCache(o);if(o){r=this.oModel.resolve(this.sPath,o);if(this.oHeaderContext&&this.oHeaderContext.getPath()!==r){this.oHeaderContext.destroy();this.oHeaderContext=null;}if(!this.oHeaderContext){this.oHeaderContext=C.create(this.oModel,this,r);}}B.prototype.setContext.call(this,o);}else{this.oContext=o;}}};l.prototype.sort=function(v){this.checkSuspended();if(this.sOperationMode!==O.Server){throw new Error("Operation mode has to be sap.ui.model.odata.OperationMode.Server");}if(this.hasPendingChanges()){throw new Error("Cannot sort due to pending changes");}this.aSorters=e.toArray(v);this.removeCachesAndMessages();this.createReadGroupLock(this.getGroupId(),true);this.fetchCache(this.oContext);this.reset(f.Sort);return this;};l.prototype.updateAnalyticalInfo=function(A){var o={aggregate:{},group:{}},H=false;A.forEach(function(i){var D={};if("total"in i){if("grouped"in i){throw new Error("Both dimension and measure: "+i.name);}if(i.as){D.name=i.name;o.aggregate[i.as]=D;}else{o.aggregate[i.name]=D;}if(i.min){D.min=true;H=true;}if(i.max){D.max=true;H=true;}if(i.with){D.with=i.with;}}else if(!("grouped"in i)||i.inResult||i.visible){o.group[i.name]=D;}});this.oAggregation=o;this.changeParameters(b.buildApply(o));this.bHasAnalyticalInfo=true;if(H){return{measureRangePromise:Promise.resolve(this.oCachePromise.then(function(i){return i.getMeasureRangePromise();}))};}};return l;});
