/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_Batch","./_GroupLock","./_Helper","./_V2Requestor","sap/base/util/deepEqual","sap/ui/base/SyncPromise","sap/ui/thirdparty/jquery"],function(_,a,b,c,d,S,q){"use strict";var B={"Accept":"multipart/mixed"},e;function g(h){var r;h=h.toLowerCase();for(r in this.headers){if(r.toLowerCase()===h){return this.headers[r];}}}function R(s,h,Q,m){this.mBatchQueue={};this.mHeaders=h||{};this.oModelInterface=m;this.sQueryParams=b.buildQuery(Q);this.mRunningChangeRequests={};this.oSecurityTokenPromise=null;this.iSerialNumber=0;this.sServiceUrl=s;}R.prototype.mFinalHeaders={"Content-Type":"application/json;charset=UTF-8;IEEE754Compatible=true"};R.prototype.mPredefinedPartHeaders={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true"};R.prototype.mPredefinedRequestHeaders={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true","OData-MaxVersion":"4.0","OData-Version":"4.0","X-CSRF-Token":"Fetch"};R.prototype.addChangeSet=function(G){var C=[],r=this.getOrCreateBatchQueue(G);C.iSerialNumber=this.getSerialNumber();r.iChangeSet+=1;r.splice(r.iChangeSet,0,C);};R.prototype.batchRequestSent=function(G,h){if(h){if(G in this.mRunningChangeRequests){this.mRunningChangeRequests[G]+=1;}else{this.mRunningChangeRequests[G]=1;}}};R.prototype.batchResponseReceived=function(G,h){if(h){this.mRunningChangeRequests[G]-=1;if(this.mRunningChangeRequests[G]===0){delete this.mRunningChangeRequests[G];}}};R.prototype.buildQueryString=function(m,Q,D,s){return b.buildQuery(this.convertQueryOptions(m,Q,D,s));};R.prototype.cancelChanges=function(G){if(this.mRunningChangeRequests[G]){throw new Error("Cannot cancel the changes for group '"+G+"', the batch request is running");}this.cancelChangesByFilter(function(){return true;},G);};R.prototype.cancelChangesByFilter=function(f,G){var C=false,t=this;function h(s){var j=t.mBatchQueue[s],o,k,E,i;k=j[0];for(i=k.length-1;i>=0;i--){o=k[i];if(o.$cancel&&f(o)){o.$cancel();E=new Error("Request canceled: "+o.method+" "+o.url+"; group: "+s);E.canceled=true;o.$reject(E);k.splice(i,1);C=true;}}}if(G){if(this.mBatchQueue[G]){h(G);}}else{for(G in this.mBatchQueue){h(G);}}return C;};R.prototype.cleanUpChangeSets=function(r){var C,h=false,i;function f(o){if(!m(o)){C.push(o);}}function m(o){if(o.method!=="PATCH"){return false;}return C.some(function(j){if(j.method==="PATCH"&&j.headers["If-Match"]===o.headers["If-Match"]){q.extend(true,j.body,o.body);o.$resolve(j.$promise);return true;}});}for(i=r.iChangeSet;i>=0;i-=1){C=[];r[i].forEach(f);if(C.length===0){r.splice(i,1);}else if(C.length===1&&this.isChangeSetOptional()){r[i]=C[0];}else{r[i]=C;}h=h||C.length>0;}return h;};R.prototype.convertExpand=function(E,s){var k,r=[],t=this;if(!E||typeof E!=="object"){throw new Error("$expand must be a valid object");}k=Object.keys(E);if(s){k=k.sort();}k.forEach(function(f){var v=E[f];if(v&&typeof v==="object"){r.push(t.convertExpandOptions(f,v,s));}else{r.push(f);}});return r.join(",");};R.prototype.convertExpandOptions=function(E,v,s){var f=[];this.doConvertSystemQueryOptions(undefined,v,function(o,O){f.push(o+'='+O);},undefined,s);return f.length?E+"("+f.join(";")+")":E;};R.prototype.convertQueryOptions=function(m,Q,D,s){var C={};if(!Q){return undefined;}this.doConvertSystemQueryOptions(m,Q,function(k,v){C[k]=v;},D,s);return C;};R.prototype.convertResourcePath=function(r){return r;};R.prototype.doCheckVersionHeader=function(G,r,v){var o=G("OData-Version"),D=!o&&G("DataServiceVersion");if(D){throw new Error("Expected 'OData-Version' header with value '4.0' but received"+" 'DataServiceVersion' header with value '"+D+"' in response for "+this.sServiceUrl+r);}if(o==="4.0"||!o&&v){return;}throw new Error("Expected 'OData-Version' header with value '4.0' but received value '"+o+"' in response for "+this.sServiceUrl+r);};R.prototype.doConvertResponse=function(r,m){return r;};R.prototype.doConvertSystemQueryOptions=function(m,Q,r,D,s){var t=this;Object.keys(Q).forEach(function(k){var v=Q[k];if(D&&k[0]==='$'){return;}switch(k){case"$expand":v=t.convertExpand(v,s);break;case"$select":if(Array.isArray(v)){v=s?v.sort().join(","):v.join(",");}break;default:}r(k,v);});};R.prototype.fetchMetadata=function(m){return this.oModelInterface.fnFetchMetadata(m);};R.prototype.fetchTypeForPath=function(m,A){return this.fetchMetadata(m+(A?"/$Type":"/"));};R.prototype.formatPropertyAsLiteral=function(v,p){return b.formatLiteral(v,p.$Type);};R.prototype.getGroupSubmitMode=function(G){return this.oModelInterface.fnGetGroupProperty(G,"submit");};R.prototype.getModelInterface=function(){return this.oModelInterface;};R.prototype.getOrCreateBatchQueue=function(G){var C,r=this.mBatchQueue[G];if(!r){C=[];C.iSerialNumber=0;r=this.mBatchQueue[G]=[C];r.iChangeSet=0;if(this.oModelInterface.fnOnCreateGroup){this.oModelInterface.fnOnCreateGroup(G);}}return r;};R.prototype.getPathAndAddQueryOptions=function(p,o,P){var A=[],n,N={},f,t=this;p=p.slice(1,-5);if(o.$Parameter){o.$Parameter.forEach(function(f){N[f.$Name]=f;});}if(o.$kind==="Function"){for(n in P){f=N[n];if(f){if(f.$IsCollection){throw new Error("Unsupported collection-valued parameter: "+n);}A.push(encodeURIComponent(n)+"="+encodeURIComponent(t.formatPropertyAsLiteral(P[n],f)));}}p+="("+A.join(",")+")";}else{for(n in P){if(!(n in N)){delete P[n];}}}return p;};R.prototype.getSerialNumber=function(){this.iSerialNumber+=1;return this.iSerialNumber;};R.prototype.getServiceUrl=function(){return this.sServiceUrl;};R.prototype.hasChanges=function(G,E){var r=this.mBatchQueue[G];if(r){return r[0].some(function(o){return o.headers["If-Match"]===E;});}return false;};R.prototype.hasPendingChanges=function(){var G,p;for(G in this.mBatchQueue){p=this.mBatchQueue[G][0].some(function(r){return r.$cancel;});if(p){return true;}}return Object.keys(this.mRunningChangeRequests).length>0;};R.prototype.isActionBodyOptional=function(){return false;};R.prototype.isChangeSetOptional=function(){return true;};R.prototype.ready=function(){return S.resolve();};R.prototype.refreshSecurityToken=function(o){var t=this;if(!this.oSecurityTokenPromise){if(o!==this.mHeaders["X-CSRF-Token"]){return Promise.resolve();}this.oSecurityTokenPromise=new Promise(function(r,f){q.ajax(t.sServiceUrl+t.sQueryParams,{method:"HEAD",headers:{"X-CSRF-Token":"Fetch"}}).then(function(D,T,j){t.mHeaders["X-CSRF-Token"]=j.getResponseHeader("X-CSRF-Token");t.oSecurityTokenPromise=null;r();},function(j,T,E){t.oSecurityTokenPromise=null;f(b.createError(j,"Could not refresh security token"));});});}return this.oSecurityTokenPromise;};R.prototype.relocate=function(C,o,n){var r=this.mBatchQueue[C],t=this,f=r&&r[0].some(function(h,i){if(h.body===o){t.request(h.method,h.url,new a(n),h.headers,o,h.$submit,h.$cancel).then(h.$resolve,h.$reject);r[0].splice(i,1);return true;}});if(!f){throw new Error("Request not found in group '"+C+"'");}};R.prototype.relocateAll=function(C,E,n){var j=0,r=this.mBatchQueue[C],t=this;if(r){r[0].slice().forEach(function(o){if(o.headers["If-Match"]===E){r[0].splice(j,1);t.request(o.method,o.url,new a(n),o.headers,o.body,o.$submit,o.$cancel).then(o.$resolve,o.$reject);}else{j+=1;}});}};R.prototype.removePatch=function(p){var C=this.cancelChangesByFilter(function(o){return o.$promise===p;});if(!C){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.removePost=function(G,o){var C=this.cancelChangesByFilter(function(f){return f.body===o;},G);if(!C){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.reportBoundMessages=function(r,p,C){this.oModelInterface.fnReportBoundMessages(r,p,C);};R.prototype.reportUnboundMessages=function(r,m){this.oModelInterface.fnReportUnboundMessages(r,JSON.parse(m||null));};R.prototype.request=function(m,r,G,h,p,s,C,M,o,A){var i,E,f=G&&G.getGroupId()||"$direct",P,j=Infinity,k,t=this;if(f==="$cached"){E=new Error("Unexpected request: "+m+" "+r);E.$cached=true;throw E;}if(G){G.unlock();j=G.getSerialNumber();}r=this.convertResourcePath(r);o=o||r;if(this.getGroupSubmitMode(f)!=="Direct"){P=new Promise(function(l,n){var u=t.getOrCreateBatchQueue(f);k={method:m,url:r,headers:q.extend({},t.mPredefinedPartHeaders,t.mHeaders,h,t.mFinalHeaders),body:p,$cancel:C,$metaPath:M,$reject:n,$resolve:l,$resourcePath:o,$submit:s};if(m==="GET"){u.push(k);}else if(A){u[0].unshift(k);}else{i=u.iChangeSet;while(u[i].iSerialNumber>j){i-=1;}u[i].push(k);}});k.$promise=P;return P;}if(s){s();}return this.sendRequest(m,r,q.extend({},h,this.mFinalHeaders),JSON.stringify(e.cleanPayload(p)),o).then(function(l){t.reportUnboundMessages(l.resourcePath,l.messages);return t.doConvertResponse(l.body,M);});};R.prototype.sendBatch=function(r){var o=_.serializeBatchRequest(r);return this.sendRequest("POST","$batch"+this.sQueryParams,q.extend(o.headers,B),o.body).then(function(f){if(f.messages!==null){throw new Error("Unexpected 'sap-messages' response header for batch request");}return _.deserializeBatchResponse(f.contentType,f.body);});};R.prototype.sendRequest=function(m,r,h,p,o){var s=this.sServiceUrl+r,t=this;return new Promise(function(f,i){function j(I){var O=t.mHeaders["X-CSRF-Token"];return q.ajax(s,{data:p,headers:q.extend({},t.mPredefinedRequestHeaders,t.mHeaders,b.resolveIfMatchHeader(h)),method:m}).then(function(k,T,l){try{t.doCheckVersionHeader(l.getResponseHeader,r,!k);}catch(E){i(E);return;}t.mHeaders["X-CSRF-Token"]=l.getResponseHeader("X-CSRF-Token")||t.mHeaders["X-CSRF-Token"];f({body:k,contentType:l.getResponseHeader("Content-Type"),messages:l.getResponseHeader("sap-messages"),resourcePath:r});},function(k,T,E){var C=k.getResponseHeader("X-CSRF-Token");if(!I&&k.status===403&&C&&C.toLowerCase()==="required"){t.refreshSecurityToken(O).then(function(){j(true);},i);}else{i(b.createError(k,"Communication error",s,o));}});}if(t.oSecurityTokenPromise&&m!=="GET"){return t.oSecurityTokenPromise.then(j);}return j();});};R.prototype.submitBatch=function(G){var h,r=this.mBatchQueue[G]||[],t=this;function v(r,i){var C;r.forEach(function(j,k){var E,l,m=i[k];if(Array.isArray(m)){v(j,m);}else if(!m){E=new Error("HTTP request was not processed because the previous request failed");E.cause=C;j.$reject(E);}else if(m.status>=400){m.getResponseHeader=g;C=b.createError(m,"Communication error",j.url,j.$resourcePath);f(C,j);}else if(m.responseText){l=JSON.parse(m.responseText);try{t.doCheckVersionHeader(g.bind(m),j.url,true);t.reportUnboundMessages(j.url,m.headers["sap-messages"]);j.$resolve(t.doConvertResponse(l,j.$metaPath));}catch(n){j.$reject(n);}}else{t.reportUnboundMessages(j.url,m.headers["sap-messages"]);j.$resolve();}});}function o(i){if(Array.isArray(i)){i.forEach(o);}else if(i.$submit){i.$submit();}}function f(E,i){if(Array.isArray(i)){i.forEach(f.bind(null,E));}else{i.$reject(E);}}delete this.mBatchQueue[G];o(r);h=this.cleanUpChangeSets(r);if(r.length===0){return Promise.resolve();}this.batchRequestSent(G,h);return this.sendBatch(e.cleanBatch(r)).then(function(i){t.batchResponseReceived(G,h);v(r,i);}).catch(function(E){var i=new Error("HTTP request was not processed because $batch failed");function j(r){r.forEach(function(k){if(Array.isArray(k)){j(k);}else{k.$reject(i);}});}t.batchResponseReceived(G,h);i.cause=E;j(r);throw E;});};e={cleanBatch:function(r){r.forEach(function(o){if(Array.isArray(o)){e.cleanBatch(o);}else{o.body=e.cleanPayload(o.body);}});return r;},cleanPayload:function(p){var r=p;if(r){Object.keys(r).forEach(function(k){if(k.indexOf("@$ui5.")===0){if(r===p){r=q.extend({},p);}delete r[k];}});}return r;},create:function(s,m,h,Q,o){var r=new R(s,h,Q,m);if(o==="2.0"){c(r);}return r;}};return e;},false);
