/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/dt/DesignTime","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/CommandFactory","sap/ui/rta/command/LREPSerializer","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/Stretch","sap/ui/rta/plugin/ControlVariant","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/fl/FlexControllerFactory","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/dt/ElementUtil","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/appVariant/Feature","sap/ui/Device","sap/ui/rta/service/index","sap/ui/rta/util/ServiceEventBus","sap/ui/dt/OverlayRegistry","sap/base/strings/capitalize","sap/base/util/UriParameters","sap/ui/performance/Measurement","sap/base/Log","sap/ui/events/KeyCodes"],function(q,M,F,S,P,D,O,C,a,L,R,b,c,d,e,f,A,g,h,j,k,l,m,n,o,p,T,r,U,s,E,t,u,v,w,x,B,y,z,G,H,I,J,K,N,Q,V,W,X){"use strict";var Y="sap-ui-fl-max-layer";var Z="STARTING";var $="STARTED";var _="STOPPED";var a1="FAILED";var b1="SERVICE_STARTING";var c1="SERVICE_STARTED";var d1="SERVICE_FAILED";var e1=M.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{"rootControl":{type:"sap.ui.base.ManagedObject"}},properties:{"customFieldUrl":"string","showCreateCustomField":"boolean","showToolbars":{type:"boolean",defaultValue:true},"triggeredFromDialog":{type:"boolean",defaultValue:false},"showWindowUnloadDialog":{type:"boolean",defaultValue:true},"commandStack":{type:"any"},"plugins":{type:"any",defaultValue:{}},"flexSettings":{type:"object",defaultValue:{layer:"CUSTOMER",developerMode:true}},"mode":{type:"string",defaultValue:"adaptation"},"metadataScope":{type:"string",defaultValue:"default"},"validateAppVersion":{type:"boolean",defaultValue:false}},events:{"start":{parameters:{editablePluginsCount:{type:"int"}}},"stop":{},"failed":{},"selectionChange":{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},"modeChanged":{},"undoRedoStackModified":{}}},_sAppTitle:null,_dependents:null,_sStatus:_,constructor:function(){M.apply(this,arguments);this._dependents={};this._mServices={};this._mCustomServicesDictinary={};this.iEditableOverlaysCount=0;this.addDependent(new x(),'popupManager');if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);}if(window.parent!==window){this.startService('receiver');}},_RESTART:{NOT_NEEDED:"no restart",VIA_HASH:"without max layer",RELOAD_PAGE:"reload"}});e1.prototype.getDefaultPlugins=function(){if(!this._mDefaultPlugins){var i=new a({flexSettings:this.getFlexSettings()});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new l({commandFactory:i,multiSelectionRequiredPlugins:[j.getMetadata().getName(),e.getMetadata().getName()],elementEditableChange:this._onElementEditableChange.bind(this)});var i1=new c({commandFactory:i});this._mDefaultPlugins["dragDrop"]=new b({elementMover:i1,commandFactory:i,dragStarted:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["rename"]=new R({commandFactory:i,editable:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:i,analyzer:h,dialog:new g()});this._mDefaultPlugins["createContainer"]=new f({commandFactory:i});this._mDefaultPlugins["remove"]=new e({commandFactory:i});this._mDefaultPlugins["cutPaste"]=new d({elementMover:i1,commandFactory:i});this._mDefaultPlugins["settings"]=new m({commandFactory:i});this._mDefaultPlugins["combine"]=new j({commandFactory:i});this._mDefaultPlugins["split"]=new k({commandFactory:i});this._mDefaultPlugins["contextMenu"]=new p({styleClass:U.getRtaStyleClassName()});this._mDefaultPlugins["tabHandling"]=new T();this._mDefaultPlugins["stretch"]=new n();this._mDefaultPlugins["controlVariant"]=new o({commandFactory:i});}return q.extend({},this._mDefaultPlugins);};e1.prototype.addDependent=function(i,i1,j1){j1=typeof j1==='undefined'?true:!!j1;if(!(i1 in this._dependents)){if(i1&&j1){this['get'+N(i1,0)]=this.getDependent.bind(this,i1);}this._dependents[i1||i.getId()]=i;}else{throw s.createError("RuntimeAuthoring#addDependent",s.printf("Can't add dependency with same key '{0}'",i1),"sap.ui.rta");}};e1.prototype.getDependent=function(i){return this._dependents[i];};e1.prototype.getDependents=function(){return this._dependents;};e1.prototype.removeDependent=function(i){delete this._dependents[i];};e1.prototype._destroyDefaultPlugins=function(i){for(var i1 in this._mDefaultPlugins){var j1=this._mDefaultPlugins[i1];if(j1&&!j1.bIsDestroyed){if(!i||i[i1]!==j1){j1.destroy();}}}if(!i){this._mDefaultPlugins=null;}};e1.prototype.onPopupOpen=function(i){if(i.getParameters()instanceof sap.m.Dialog&&this.getToolbar()instanceof F){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};e1.prototype.onPopupClose=function(i){if(i.getParameters()instanceof sap.m.Dialog){this.getToolbar().setColor();}};e1.prototype.setPlugins=function(i){if(this._oDesignTime){throw new Error('Cannot replace plugins: runtime authoring already started');}this.setProperty("plugins",i);};e1.prototype.setFlexSettings=function(i){var i1=new Q(window.location.href);var j1=i1.get("sap-ui-layer");i=q.extend({},this.getFlexSettings(),i);if(j1){i.layer=j1;}if(i.scenario||i.baseId){var k1=t.buildLrepRootNamespace(i.baseId,i.scenario,i.projectId);i.rootNamespace=k1;i.namespace=k1+"changes/";}U.setRtaStyleClassName(i.layer);this.setProperty("flexSettings",i);};e1.prototype.getLayer=function(){return this.getFlexSettings().layer;};e1.prototype.getRootControlInstance=function(){if(!this._oRootControl){this._oRootControl=E.getElementInstance(this.getRootControl());}return this._oRootControl;};e1.prototype._getFlexController=function(){var i=this.getRootControlInstance();return r.createForControl(i);};e1.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};e1.prototype.start=function(){this._sStatus=Z;var i;var i1;if(!this._oDesignTime){if(!this.getRootControlInstance()){i1=new Error("Root control not found");t.log.error(i1);return Promise.reject(i1);}if(this.getValidateAppVersion()&&!t.isCorrectAppVersionFormat(this._getFlexController().getAppVersion())){i1=this._getTextResources().getText("MSG_INCORRECT_APP_VERSION_ERROR");t.log.error(i1);return Promise.reject(i1);}return this._handleHigherLayerChangesOnStart().then(function(j1){if(j1){return Promise.reject("Reload triggered");}if(!this.getPlugins()||!Object.keys(this.getPlugins()).length){this.setPlugins(this.getDefaultPlugins());}this._destroyDefaultPlugins(this.getPlugins());Object.keys(this.getPlugins()).forEach(function(m1){if(this.getPlugins()[m1].attachElementModified){this.getPlugins()[m1].attachElementModified(this._handleElementModified,this);}}.bind(this));if(this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(this.getCommandStack());}this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});var k1=Object.keys(this.getPlugins());var l1=k1.map(function(m1){return this.getPlugins()[m1];},this);i=new Promise(function(m1,n1){V.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:l1});this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()==="USER"){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}this._oDesignTime.getSelectionManager().attachChange(function(o1){this.fireSelectionChange({selection:o1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){m1();V.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",function(o1){n1(o1.getParameter("error"));});}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getPublishAndAppVariantSupportVisibility().then(function(j1){var k1=j1[0];var l1=j1[1];this._createToolsMenu(k1,l1);}.bind(this));}}.bind(this)).then(function(){this._onStackModified();}.bind(this)).then(function(){z.loadStyles('InPageStyles').then(function(j1){var k1=j1.replace(/%scrollWidth%/g,y.getScrollbarWidth()+'px');y.insertStyles(k1,O.getOverlayContainer().get(0));});}).then(function(){return i;}).then(function(){if(this.getShowToolbars()){return this.getToolbar().show();}}.bind(this)).then(function(){this.getPopupManager().setRta(this);if(H.browser.name==="ff"){q(document).on('contextmenu',f1);}}.bind(this)).then(function(){this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);var j1=K.getOverlay(this.getRootControl());this._$RootControl=j1.getAssociatedDomRef();if(this._$RootControl){this._$RootControl.addClass("sapUiRtaRoot");}}.bind(this)).then(function(){this._sStatus=$;this.fireStart({editablePluginsCount:this.iEditableOverlaysCount});}.bind(this),function(i1){if(i1!=="Reload triggered"){this._sStatus=a1;this.fireFailed(i1);}if(i1){return Promise.reject(i1);}}.bind(this));}};function f1(){return false;}e1.prototype._getPublishAndAppVariantSupportVisibility=function(){return u.getInstance().then(function(i){var i1=G.isPlatFormEnabled(this.getRootControlInstance(),this.getLayer(),this._oSerializer);return[!i.isProductiveSystem()&&!i.hasMergeErrorOccured(),!i.isProductiveSystem()&&i1];}.bind(this)).catch(function(){return false;});};var g1=function(i1){B.hide();var j1="";if(i1.messages&&Array.isArray(i1.messages)){for(var i=0;i<i1.messages.length;i++){j1=(i1.messages[i].severity==="Error")?j1+i1.messages[i].text+"\n":j1;}}else{j1=i1.stack||i1.message||i1.status||i1;}var k1=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");W.error("Failed to transfer runtime adaptation changes to layered repository",j1);var l1=k1.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+k1.getText("MSG_ERROR_REASON",j1);v.error(l1,{styleClass:U.getRtaStyleClassName()});};e1.prototype.setCommandStack=function(i){var i1=this.getProperty("commandStack");if(i1){i1.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var j1=this.setProperty("commandStack",i);if(i){i.attachModified(this._onStackModified,this);}if(this.getPlugins()&&this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(i);}return j1;};e1.prototype.getCommandStack=function(){var i=this.getProperty("commandStack");if(!i){i=new C();this._oInternalCommandStack=i;this.setCommandStack(i);}return i;};e1.prototype._onStackModified=function(){var i=this.getCommandStack();var i1=i.canUndo();var j1=i.canRedo();if(this.getShowToolbars()){this.getToolbar().setUndoRedoEnabled(i1,j1);this.getToolbar().setPublishEnabled(this._bChangesExist||i1);this.getToolbar().setRestoreEnabled(this._bChangesExist||i1);}this.fireUndoRedoStackModified();};e1.prototype._closeToolbar=function(){if(this.getShowToolbars()&&this.getToolbar){return this.getToolbar().hide();}};e1.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}else{return[];}};e1.prototype.stop=function(i,i1){return((i1)?Promise.resolve(this._RESTART.NOT_NEEDED):this._handleReloadOnExit()).then(function(j1){return((i)?Promise.resolve():this._serializeToLrep(this)).then(this._closeToolbar.bind(this)).then(function(){this.fireStop();if(j1!==this._RESTART.NOT_NEEDED){this._removeMaxLayerParameter();if(j1===this._RESTART.RELOAD_PAGE){this._reloadPage();}}}.bind(this));}.bind(this)).catch(g1).then(function(){this._sStatus=_;}.bind(this));};e1.prototype.restore=function(){this._onRestore();};e1.prototype.transport=function(){return this._onTransport();};e1.prototype.undo=function(){return this._onUndo();};e1.prototype.redo=function(){return this._onRedo();};e1.prototype.canUndo=function(){return this.getCommandStack().canUndo();};e1.prototype.canRedo=function(){return this.getCommandStack().canRedo();};e1.prototype._onKeyDown=function(i){var i1=H.os.macintosh;var j1=O.getOverlayContainer().get(0).contains(document.activeElement);var k1=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var l1=false;q(".sapUiDtContextMenu").each(function(p1,q1){if(q1.contains(document.activeElement)){l1=true;}});var m1=document.body===document.activeElement;var n1=q(document.activeElement).parents('.sapUiRtaEditableField').length>0;if((j1||k1||l1||m1)&&!n1){var o1=i1?i.metaKey:i.ctrlKey;if(i.keyCode===X.Z&&i.shiftKey===false&&i.altKey===false&&o1===true){this._onUndo().then(i.stopPropagation.bind(i));}else if(((i1&&i.keyCode===X.Z&&i.shiftKey===true)||(!i1&&i.keyCode===X.Y&&i.shiftKey===false))&&i.altKey===false&&o1===true){this._onRedo().then(i.stopPropagation.bind(i));}}};e1.prototype._onUnload=function(){var i=this.getCommandStack();var i1=i.canUndo()||i.canRedo();if(i1&&this.getShowWindowUnloadDialog()){var j1=this._getTextResources().getText("MSG_UNSAVED_CHANGES");return j1;}else{window.onbeforeunload=this._oldUnloadHandler;}};e1.prototype._serializeToLrep=function(){return this._oSerializer.saveCommands().then(this._invalidateCache.bind(this));};e1.prototype._invalidateCache=function(){return this._getFlexController().getComponentChanges(undefined,true);};e1.prototype._onUndo=function(){this._handleStopCutPaste();return this.getCommandStack().undo();};e1.prototype._onRedo=function(){this._handleStopCutPaste();return this.getCommandStack().redo();};e1.prototype._createToolsMenu=function(i,i1){if(!this.getDependent('toolbar')){var j1;if(this.getLayer()==="USER"){j1=P;}else if(U.getFiori2Renderer()){j1=F;}else{j1=S;}if(this.getLayer()==="USER"){this.addDependent(new j1({textResources:this._getTextResources(),exit:this.stop.bind(this,false,true),restore:this._onRestore.bind(this)}),'toolbar');}else{this.addDependent(new j1({modeSwitcher:this.getMode(),publishVisible:i,textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),transport:this._onTransport.bind(this),restore:this._onRestore.bind(this),undo:this._onUndo.bind(this),redo:this._onRedo.bind(this),modeChange:this._onModeChange.bind(this),manageApps:G.onGetOverview.bind(null,true),appVariantOverview:this._onGetAppVariantOverview.bind(this),saveAs:G.onSaveAsFromRtaToolbar.bind(null,true,true)}),'toolbar');}var k1;if(i1){this.getToolbar().getControl('saveAs').setVisible(i1);k1=G.isOverviewExtended();if(k1){this.getToolbar().getControl('appVariantOverview').setVisible(i1);}else{this.getToolbar().getControl('manageApps').setVisible(i1);}G.isManifestSupported().then(function(l1){if(k1){this.getToolbar().getControl('appVariantOverview').setEnabled(l1);}else{this.getToolbar().getControl('manageApps').setEnabled(l1);}this.getToolbar().getControl('saveAs').setEnabled(l1);}.bind(this));}this._checkChangesExist().then(function(l1){if(!this.bIsDestroyed){this._bChangesExist=l1;this.getToolbar().setPublishEnabled(l1);this.getToolbar().setRestoreEnabled(l1);}}.bind(this));}};e1.prototype._onGetAppVariantOverview=function(i){var i1=i.getParameter("item");var j1=i1.getId()==='keyUser';return G.onGetOverview(j1);};e1.prototype.destroy=function(){q.map(this._dependents,function(i,i1){this.removeDependent(i1);i.destroy(true);}.bind(this));Object.keys(this._mServices).forEach(function(i){this.stopService(i);},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);this._destroyDefaultPlugins();this.setPlugins(null);}if(this._$RootControl){this._$RootControl.removeClass("sapUiRtaRoot");}this.setCommandStack(null);if(this._oServiceEventBus){this._oServiceEventBus.destroy();}if(H.browser.name==="ff"){q(document).off("contextmenu",f1);}window.onbeforeunload=this._oldUnloadHandler;M.prototype.destroy.apply(this,arguments);};e1.prototype._onTransport=function(){this._handleStopCutPaste();B.show(500);return this._serializeToLrep().then(function(){B.hide();return this._getFlexController()._oChangePersistence.transportAllUIChanges(this._oRootControl,U.getRtaStyleClassName(),this.getLayer()).then(function(i){if(i!=="Error"&&i!=="Cancel"){this._showMessageToast("MSG_TRANSPORT_SUCCESS");}}.bind(this));}.bind(this))['catch'](g1);};e1.prototype._deleteChanges=function(){return this._getFlexController().resetChanges(this.getLayer(),"Change.createInitialFileContent",t.getAppComponentForControl(this.getRootControlInstance())).then(function(){this._reloadPage();}.bind(this))["catch"](function(i){return U._showMessageBox(v.Icon.ERROR,"HEADER_RESTORE_FAILED","MSG_RESTORE_FAILED",i);});};e1.prototype._reloadPage=function(){window.location.reload();};e1.prototype._showMessageToast=function(i){var i1=this._getTextResources().getText(i);w.show(i1);};e1.needsRestart=function(i){var i1=!!window.sessionStorage.getItem("sap.ui.rta.restart."+i);return i1;};e1.enableRestart=function(i){window.sessionStorage.setItem("sap.ui.rta.restart."+i,true);};e1.disableRestart=function(i){window.sessionStorage.removeItem("sap.ui.rta.restart."+i);};e1.prototype._onRestore=function(){var i=this.getLayer()==="USER"?this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION"):this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");var i1=this.getLayer()==="USER"?this._getTextResources().getText("BTN_RESTORE"):this._getTextResources().getText("FORM_PERS_RESET_TITLE");var j1=function(k1){if(k1==="OK"){e1.enableRestart(this.getLayer());this._deleteChanges();this.getCommandStack().removeAllCommands();}}.bind(this);this._handleStopCutPaste();v.confirm(i,{icon:v.Icon.WARNING,title:i1,onClose:j1,styleClass:U.getRtaStyleClassName()});};e1.prototype._scheduleRenameOnCreatedContainer=function(i,i1){var j1=function(n1){var o1=this.getPlugins()["createContainer"].getCreatedContainerId(i,n1.getElement().getId());var p1=K.getOverlay(o1);p1.setSelected(true);this.getPlugins()["rename"].startEdit(p1);};var k1=function(n1){var o1=n1.getSource();if(o1.getGeometry()&&o1.getGeometry().visible){j1.call(this,o1);o1.detachEvent('geometryChanged',k1,this);}};var l1=function(n1){if(!n1.getGeometry()||!n1.getGeometry().visible){n1.attachEvent('geometryChanged',k1,this);}else{j1.call(this,n1);}};var m1=function(n1){var o1=n1.getParameter("elementOverlay");if(o1.getElement().getId()===i1){this._oDesignTime.detachEvent("elementOverlayCreated",m1,this);if(o1.isRendered()){l1.call(this,o1);}else{o1.attachEventOnce('afterRendering',function(n1){l1.call(this,n1.getSource());},this);}}};this._oDesignTime.attachEvent("elementOverlayCreated",m1,this);};e1.prototype._handleElementModified=function(i){this._handleStopCutPaste();var i1=i.getParameter("action");var j1=i.getParameter("newControlId");var k1=i.getParameter("command");if(k1 instanceof sap.ui.rta.command.BaseCommand){if(i1&&j1){this._scheduleRenameOnCreatedContainer(i1,j1);}return this.getCommandStack().pushAndExecute(k1).catch(function(l1){if(l1&&l1.message&&l1.message.indexOf("The following Change cannot be applied because of a dependency")>-1){U._showMessageBox(v.Icon.ERROR,"HEADER_DEPENDENCY_ERROR","MSG_DEPENDENCY_ERROR",l1);}t.log.error("sap.ui.rta: "+l1.message);});}return Promise.resolve();};e1.prototype._onElementEditableChange=function(i){var i1=i.getParameter("editable");if(i1){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};e1.prototype._handleStopCutPaste=function(){if(this.getPlugins()["cutPaste"]){this.getPlugins()["cutPaste"].stopCutAndPaste();}};e1.prototype._checkChangesExist=function(){if(this._getFlexController().getComponentName().length>0){return this._getFlexController().getComponentChanges({currentLayer:this.getLayer(),includeCtrlVariants:true}).then(function(i){return i.length>0;});}else{return Promise.resolve(false);}};e1.prototype._buildNavigationArguments=function(i){return{target:{semanticObject:i.semanticObject,action:i.action,context:i.contextRaw},params:i.params,appSpecificRoute:i.appSpecificRoute,writeHistory:false};};e1.prototype._hasMaxLayerParameter=function(i){var i1=this.getLayer();return i.params&&i.params[Y]&&i.params[Y][0]===i1;};e1.prototype._reloadWithoutHigherLayerChangesOnStart=function(i,i1){var j1=this.getLayer();if(!this._hasMaxLayerParameter(i)){if(!i.params){i.params={};}i.params[Y]=[j1];e1.enableRestart(j1);i1.toExternal(this._buildNavigationArguments(i));return Promise.resolve(true);}};e1.prototype._removeMaxLayerParameter=function(){if(U.getUshellContainer()&&this.getLayer()!=="USER"){var i=U.getUshellContainer().getService("CrossApplicationNavigation");var i1=t.getParsedURLHash();if(i.toExternal&&i1){if(this._hasMaxLayerParameter(i1)){delete i1.params[Y];i.toExternal(this._buildNavigationArguments(i1));}}}};e1.prototype._handleReloadWithoutHigherLayerChangesMessageBoxOnStart=function(){var i=this.getLayer();var i1=i==="CUSTOMER"?"MSG_PERSONALIZATION_EXISTS":"MSG_HIGHER_LAYER_CHANGES_EXIST";return U._showMessageBox(v.Icon.INFORMATION,"HEADER_PERSONALIZATION_EXISTS",i1);};e1.prototype._handleReloadMessageBox=function(i){return U._showMessageBox(v.Icon.INFORMATION,"HEADER_RELOAD_NEEDED",i,undefined,"BUTTON_RELOAD_NEEDED");};e1.prototype._handleHigherLayerChangesOnStart=function(){var i=U.getUshellContainer();if(i&&this.getLayer()!=="USER"){var i1=t.getParsedURLHash();return this._getFlexController().hasHigherLayerChanges({ignoreMaxLayerParameter:false}).then(function(j1){if(j1){return this._handleReloadWithoutHigherLayerChangesMessageBoxOnStart().then(function(){var k1=sap.ushell.Container.getService("CrossApplicationNavigation");if(k1.toExternal&&i1){return this._reloadWithoutHigherLayerChangesOnStart(i1,k1);}}.bind(this));}}.bind(this));}else{return Promise.resolve(false);}};e1.prototype._handleReloadOnExit=function(){return Promise.all([this._oSerializer.needsReload(),this._getFlexController().hasHigherLayerChanges({ignoreMaxLayerParameter:true})]).then(function(i){var i1=i[0],j1=i[1];if(i1||j1){var k1=this._RESTART.RELOAD_PAGE;var l1,m1;if(j1){var n1=this.getLayer();l1=n1==="CUSTOMER"?"MSG_RELOAD_WITH_PERSONALIZATION":"MSG_RELOAD_WITH_ALL_CHANGES";m1=U.getUshellContainer();if(!i1&&m1){k1=this._RESTART.VIA_HASH;}}else if(i1){l1="MSG_RELOAD_NEEDED";}return this._handleReloadMessageBox(l1).then(function(){return k1;});}else{return this._RESTART.NOT_NEEDED;}}.bind(this));};e1.prototype._onModeChange=function(i){this.setMode(i.getParameter("item").getKey());};e1.prototype.setMode=function(i){if(this.getProperty('mode')!==i){var i1=this.getShowToolbars()&&this.getToolbar().getControl('modeSwitcher');var j1=i==='adaptation';if(i1){i1.setSelectedButton(i1.getItems().filter(function(k1){return k1.getKey()===i;}).pop().getId());}this._oDesignTime.setEnabled(j1);this.getPlugins()['tabHandling'][j1?'removeTabIndex':'restoreTabIndex']();this.setProperty('mode',i);this.fireModeChanged({mode:i});}};e1.prototype.setMetadataScope=function(i){if(this._oDesignTime){W.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty('metadataScope',i);};function h1(i){if(I.hasOwnProperty(i)){return I[i].replace(/\./g,'/');}}e1.prototype.startService=function(i){if(this._sStatus!==$){return new Promise(function(k1,l1){this.attachEventOnce('start',k1);this.attachEventOnce('failed',l1);}.bind(this)).then(function(){return this.startService(i);}.bind(this),function(){return Promise.reject(s.createError("RuntimeAuthoring#startService",s.printf("Can't start the service '{0}' while RTA has been failed during a startup",i),"sap.ui.rta"));});}var i1=h1(i);var j1;if(!i1){return Promise.reject(s.createError("RuntimeAuthoring#startService",s.printf("Unknown service. Can't find any registered service by name '{0}'",i),"sap.ui.rta"));}else{j1=this._mServices[i];if(j1){switch(j1.status){case c1:{return Promise.resolve(j1.exports);}case b1:{return j1.initPromise;}case d1:{return j1.initPromise;}default:{return Promise.reject(s.createError("RuntimeAuthoring#startService",s.printf("Unknown service status. Service name = '{0}'",i),"sap.ui.rta"));}}}else{this._mServices[i]=j1={status:b1,location:i1,initPromise:new Promise(function(k1,l1){sap.ui.require([i1],function(m1){j1.factory=m1;if(!this._oServiceEventBus){this._oServiceEventBus=new J();}s.wrapIntoPromise(m1)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,i)).then(function(n1){if(this.bIsDestroyed){throw s.createError("RuntimeAuthoring#startService",s.printf("RuntimeAuthoring instance is destroyed while initialising the service '{0}'",i),"sap.ui.rta");}if(!q.isPlainObject(n1)){throw s.createError("RuntimeAuthoring#startService",s.printf("Invalid service format. Service should return simple javascript object after initialisation. Service name = '{0}'",i),"sap.ui.rta");}j1.service=n1;j1.exports={};if(Array.isArray(n1.events)&&n1.events.length>0){q.extend(j1.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,i),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,i),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,i)});}var o1=n1.exports||{};q.extend(j1.exports,Object.keys(o1).reduce(function(p1,q1){var r1=o1[q1];p1[q1]=typeof r1==="function"?s.waitForSynced(r1,this._oDesignTime):r1;return p1;}.bind(this),{}));j1.status=c1;k1(Object.freeze(j1.exports));}.bind(this)).catch(l1);}.bind(this),function(m1){j1.status=d1;l1(s.propagateError(m1,"RuntimeAuthoring#startService",s.printf("Can't load service '{0}' by its name: {1}",i,i1),"sap.ui.rta"));});}.bind(this)).catch(function(k1){j1.status=d1;return Promise.reject(s.propagateError(k1,"RuntimeAuthoring#startService",s.printf("Error during service '{0}' initialisation.",i),"sap.ui.rta"));})};return j1.initPromise;}}};e1.prototype.stopService=function(i){var i1=this._mServices[i];if(i1){if(i1.status===c1){if(typeof i1.service.destroy==="function"){i1.service.destroy();}}delete this._mServices[i];}else{throw s.createError("RuntimeAuthoring#stopService",s.printf("Can't destroy service: unable to find service with name '{0}'",i),"sap.ui.rta");}};e1.prototype.getService=function(i){return this.startService(i);};return e1;},true);
