/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/rta/Client',["sap/ui/base/ManagedObject","sap/ui/core/postmessage/Bus","sap/base/util/uid","sap/base/util/merge","sap/ui/rta/util/ServiceEventBus","sap/ui/thirdparty/URI"],function(M,P,u,m,S,U){"use strict";var C='sap.ui.rta.service.receiver';var a='pending';var b='accepted';var c='declined';
var d=M.extend("sap.ui.rta.Client",{
metadata:{library:"sap.ui.rta",properties:{"window":"object","origin":"string"}},
_bInit:false,
constructor:function(){M.apply(this,arguments);if(!this.getWindow()){throw new TypeError("sap.ui.rta.Client: window parameter is required");}if(!this.getOrigin()){throw new TypeError("sap.ui.rta.Client: origin parameter is required");}this._oPostMessageBus=P.getInstance();this._sStatus=a;this._mPendingRequests={};this._aRequestQueue=[];this._oServiceEventBus=null;this._mEventHandlerIds={};this._oPostMessageBus.subscribeOnce(C,P.event.READY,function(e){if(!this._isValidMessage(e)){return;}this._oPostMessageBus.subscribeOnce(C,P.event.ACCEPTED,function(e){if(!this._isValidMessage(e)){return;}this._sStatus=b;var r=this._aRequestQueue.slice();this._aRequestQueue=[];r.forEach(this._sendRequest,this);this._oPostMessageBus.subscribe(C,'getService',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'callMethod',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'subscribe',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'unsubscribe',this._receiverMethods,this);this._oPostMessageBus.subscribe(C,'event',this._receiverEvents,this);},this);this._oPostMessageBus.subscribeOnce(C,P.event.DECLINED,function(e){if(!this._isValidMessage(e)){return;}this._sStatus=c;var r=this._aRequestQueue.slice();this._aRequestQueue=[];r.forEach(function(R){R.reject(new Error('sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused'));});},this);this._oPostMessageBus.publish({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:P.event.CONNECT,data:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("SERVICE_NAME")});},this);this._bInit=true;}
});
d.prototype.destroy=function(){this._oPostMessageBus.unsubscribe(C,'getService',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'callMethod',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'subscribe',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'unsubscribe',this._receiverMethods,this);this._oPostMessageBus.unsubscribe(C,'event',this._receiverEvents,this);M.prototype.destroy.apply(this,arguments);};
d.prototype.getService=function(s){if(typeof s!=="string"){throw new TypeError('sap.ui.rta.Client.getService(): invalid service name specified');}return this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:'getService',data:{arguments:[s]}}));};
d.prototype._createRequest=function(p){var r=u();var R={id:r,request:{target:p.target,origin:p.origin,channelId:C,eventId:p.eventId,data:{id:r,type:'request',body:p.data}}};R.promise=new Promise(function(f,e){R.resolve=f;R.reject=e;});return R;};
d.prototype._sendRequest=function(r){switch(this._sStatus){case b:this._mPendingRequests[r.id]=r;this._oPostMessageBus.publish(r.request);break;case a:this._aRequestQueue.push(r);break;case c:r.reject(new Error('sap.ui.rta.Client.getService(): connection to RuntimeAuthoring instance has been refused'));break;}return r.promise;};
d.prototype._isValidMessage=function(e){return this.getWindow()===e.source&&this.getOrigin()===e.origin;};
d.prototype._receiverMethods=function(e){if(!this._isValidMessage(e)){return;}var D=e.data;if(D.type!=='response'){return;}var r=this._mPendingRequests[D.id];switch(e.eventId){case'getService':var s=r.request.data.body.arguments[0];var f=D.body.methods||[];var E=D.body.events;var g=m(f.reduce(function(R,h){R[h]=function(){return this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:C,eventId:'callMethod',data:{service:s,method:h,arguments:Array.prototype.slice.call(arguments)}}));}.bind(this);return R;}.bind(this),{}),D.body.properties);if(Array.isArray(E)&&E.length>0){if(!this._oServiceEventBus){this._oServiceEventBus=new S();}m(g,{attachEvent:function(h,i,o){if(typeof(h)!=="string"||!h){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling attachEvent() for a service");}if(typeof i!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling attachEvent() for a service");}var j=this._oServiceEventBus.getChannel(s);var k=!j||!j.hasListeners(h);this._oServiceEventBus.subscribe(s,h,i,o);if(k){this._sendRequest(this._createRequest({target:e.source,origin:e.origin,channelId:C,eventId:'subscribe',data:{service:s,event:h}})).then(function(R){this._mEventHandlerIds[s+','+h]=R.id;this._checkIfEventAlive(s,h);}.bind(this));}}.bind(this),detachEvent:function(h,i,o){if(typeof(h)!=="string"||!h){throw new TypeError("sap.ui.rta.Client: sEventName must be a non-empty string when calling detachEvent() for a service");}if(typeof i!=="function"){throw new TypeError("sap.ui.rta.Client: fnFunction must be a function when calling detachEvent() for a service");}this._oServiceEventBus.unsubscribe(s,h,i,o);this._checkIfEventAlive(s,h);}.bind(this),attachEventOnce:function(h,i,o){function O(){g.detachEvent(h,O);i.apply(o,arguments);}g.attachEvent(h,O);}});}r.resolve(g);delete this._mPendingRequests[D.id];break;case'callMethod':if(D.status==='success'){r.resolve(D.body);}else{r.reject(D.body);}delete this._mPendingRequests[D.id];break;case'subscribe':case'unsubscribe':r.resolve(D.body);delete this._mPendingRequests[D.id];break;}};
d.prototype._checkIfEventAlive=function(s,e){var E=this._oServiceEventBus.getChannel(s);var f=this._mEventHandlerIds[s+','+e];if((!E||!E.hasListeners(e))&&f){this._sendRequest(this._createRequest({target:this.getWindow(),origin:this.getOrigin(),channelId:C,eventId:'unsubscribe',data:{service:s,event:e,id:f}}));}};
d.prototype._receiverEvents=function(e){if(!this._isValidMessage(e)){return;}var r=e.data.body;this._oServiceEventBus.publish(r.service,r.event,r.data);};
d.prototype.setWindow=function(v){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Window parameter cannot be changed at runtime; recreate instance of the Client.");}if(!v){throw new TypeError("sap.ui.rta.Client: Window parameter is required");}if(v===window){throw new TypeError("sap.ui.rta.Client: Window object has to be different from the one where Client is running");}this.setProperty('window',v);return this;};
d.prototype.setOrigin=function(v){if(this._bInit){throw new TypeError("sap.ui.rta.Client: Cannot change origin parameter at runtime; recreate instance of the Client.");}if(!v){throw new TypeError("sap.ui.rta.Client: Origin parameter is required");}if(typeof v!=='string'){throw new TypeError("sap.ui.rta.Client: Origin parameter has to be a string");}if(new U(v).origin()!==v){throw new TypeError("sap.ui.rta.Client: Origin string is invalid");}this.setProperty('origin',v);return this;};
return d;});
sap.ui.predefine('sap/ui/rta/ControlTreeModifier',["sap/ui/core/util/reflection/JsControlTreeModifier","sap/base/util/merge"],function(J,m){"use strict";var _;var R={startRecordingUndo:function(){_=[];},stopRecordingUndo:function(){var r=_;_=undefined;return r;},performUndo:function(u){while(u.length){var o=u.pop();this[o.name].apply(this,o.properties);}},_saveUndoOperation:function(f,p){if(_){_.push({name:f,properties:p});}},setVisible:function(c,v){var o=this.getVisible(c);var r=J.setVisible.apply(this,arguments);if(o!==this.getVisible(c)){this._saveUndoOperation("setVisible",[c,o]);}return r;},setStashed:function(c,s){var o;var C=c.getId();if(c.getVisible){o=!c.getVisible();}else{o=c.getStashed();}J.setStashed.apply(this,arguments);var S=sap.ui.getCore().byId(C);if(o!==s){this._saveUndoOperation("setStashed",[S,!s]);}},bindProperty:function(c,p,b){var o=c.getBindingInfo(p);var O;var M=c.getMetadata().getPropertyLikeSetting(p);if(M){var P=M._sGetter;O=c[P]();}J.bindProperty.apply(this,arguments);if(o){this._saveUndoOperation("bindProperty",[c,p,o]);}else{this._saveUndoOperation("unbindProperty",[c,p]);}if(O){this._saveUndoOperation("setProperty",[c,p,O]);}},unbindProperty:function(c,p){var o=c.getBindingInfo(p);J.unbindProperty.apply(this,arguments);if(o){this._saveUndoOperation("bindProperty",[c,p,o]);}},setProperty:function(c,p,P){var o;var M=c.getMetadata().getPropertyLikeSetting(p);if(M){var s=M._sGetter;o=c[s]();}var r=J.setProperty.apply(this,arguments);if(o!==P){this._saveUndoOperation("setProperty",[c,p,o]);}return r;},setPropertyBinding:function(c,p,P){var o;var M=c.getMetadata().getPropertyLikeSetting(p);if(M){var s=M._sGetter;o=c[s]();}J.setPropertyBinding.apply(this,arguments);if(o!==P){this._saveUndoOperation("setPropertyBinding",[c,p,o]);}},createControl:function(c,a,v,s,S,A){var e=this.bySelector(s,a);var C=function(){if(!e){var o=this.bySelector(s,a);R._saveUndoOperation("destroy",[o]);}}.bind(this);var r=J.createControl.apply(this,arguments);if(A){return r.then(function(o){C();return o;});}C();return r;},instantiateFragment:function(f,c,v,C){var a=J.instantiateFragment.apply(this,arguments);a.forEach(function(o){this._saveUndoOperation("destroy",[o]);}.bind(this));return a;},destroy:function(c){if(c){c.destroy();}},insertAggregation:function(p,n,o,i){var O=J.getAggregation.call(this,p,n);J.insertAggregation.apply(this,arguments);if(p){if(p.getMetadata){var M=p.getMetadata();var a=M.getAllAggregations();if(a){var A=a[n];if(A){if(A.multiple){this._saveUndoOperation("removeAggregation",[p,n,o]);}else{this._saveUndoOperation("insertAggregation",[p,n,O]);}}}}}},removeAggregation:function(p,n,o){var O;var a;if(p&&o){a=J.getAggregation.call(this,p,n);if(a){a.some(function(e,i){if(e===o){O=i;return true;}});}}J.removeAggregation.apply(this,arguments);if(O||O===0){this._saveUndoOperation("insertAggregation",[p,n,o,O]);}},removeAllAggregation:function(p,n){var o=[];var a;if(p){a=J.getAggregation.call(this,p,n);}if(a&&a instanceof Array){o=a.slice();}else if(a&&a instanceof Object){o[0]=a;}J.removeAllAggregation(p,n);if(o){o.forEach(function(e){this._saveUndoOperation("insertAggregation",[p,n,e]);},this);}}};return m({},J,R);},true);
sap.ui.predefine('sap/ui/rta/RuntimeAuthoring',["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/dt/DesignTime","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/CommandFactory","sap/ui/rta/command/LREPSerializer","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/Stretch","sap/ui/rta/plugin/ControlVariant","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/fl/FlexControllerFactory","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/dt/ElementUtil","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/appVariant/Feature","sap/ui/Device","sap/ui/rta/service/index","sap/ui/rta/util/ServiceEventBus","sap/ui/dt/OverlayRegistry","sap/base/strings/capitalize","sap/base/util/UriParameters","sap/ui/performance/Measurement","sap/base/Log","sap/ui/events/KeyCodes"],function(q,M,F,S,P,D,O,C,a,L,R,b,c,d,e,f,A,g,h,j,k,l,m,n,o,p,T,r,U,s,E,t,u,v,w,x,B,y,z,G,H,I,J,K,N,Q,V,W,X){"use strict";var Y="sap-ui-fl-max-layer";var Z="STARTING";var $="STARTED";var _="STOPPED";var a1="FAILED";var b1="SERVICE_STARTING";var c1="SERVICE_STARTED";var d1="SERVICE_FAILED";
var e1=M.extend("sap.ui.rta.RuntimeAuthoring",{
metadata:{library:"sap.ui.rta",associations:{"rootControl":{type:"sap.ui.base.ManagedObject"}},properties:{"customFieldUrl":"string","showCreateCustomField":"boolean","showToolbars":{type:"boolean",defaultValue:true},"triggeredFromDialog":{type:"boolean",defaultValue:false},"showWindowUnloadDialog":{type:"boolean",defaultValue:true},"commandStack":{type:"any"},"plugins":{type:"any",defaultValue:{}},"flexSettings":{type:"object",defaultValue:{layer:"CUSTOMER",developerMode:true}},"mode":{type:"string",defaultValue:"adaptation"},"metadataScope":{type:"string",defaultValue:"default"},"validateAppVersion":{type:"boolean",defaultValue:false}},events:{"start":{parameters:{editablePluginsCount:{type:"int"}}},"stop":{},"failed":{},"selectionChange":{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},"modeChanged":{},"undoRedoStackModified":{}}},
_sAppTitle:null,
_dependents:null,
_sStatus:_,
constructor:function(){M.apply(this,arguments);this._dependents={};this._mServices={};this._mCustomServicesDictinary={};this.iEditableOverlaysCount=0;this.addDependent(new x(),'popupManager');if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);}if(window.parent!==window){this.startService('receiver');}},
_RESTART:{NOT_NEEDED:"no restart",VIA_HASH:"without max layer",RELOAD_PAGE:"reload"}
});
e1.prototype.getDefaultPlugins=function(){if(!this._mDefaultPlugins){var i=new a({flexSettings:this.getFlexSettings()});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new l({commandFactory:i,multiSelectionRequiredPlugins:[j.getMetadata().getName(),e.getMetadata().getName()],elementEditableChange:this._onElementEditableChange.bind(this)});var i1=new c({commandFactory:i});this._mDefaultPlugins["dragDrop"]=new b({elementMover:i1,commandFactory:i,dragStarted:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["rename"]=new R({commandFactory:i,editable:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:i,analyzer:h,dialog:new g()});this._mDefaultPlugins["createContainer"]=new f({commandFactory:i});this._mDefaultPlugins["remove"]=new e({commandFactory:i});this._mDefaultPlugins["cutPaste"]=new d({elementMover:i1,commandFactory:i});this._mDefaultPlugins["settings"]=new m({commandFactory:i});this._mDefaultPlugins["combine"]=new j({commandFactory:i});this._mDefaultPlugins["split"]=new k({commandFactory:i});this._mDefaultPlugins["contextMenu"]=new p({styleClass:U.getRtaStyleClassName()});this._mDefaultPlugins["tabHandling"]=new T();this._mDefaultPlugins["stretch"]=new n();this._mDefaultPlugins["controlVariant"]=new o({commandFactory:i});}return q.extend({},this._mDefaultPlugins);};
e1.prototype.addDependent=function(i,i1,j1){j1=typeof j1==='undefined'?true:!!j1;if(!(i1 in this._dependents)){if(i1&&j1){this['get'+N(i1,0)]=this.getDependent.bind(this,i1);}this._dependents[i1||i.getId()]=i;}else{throw s.createError("RuntimeAuthoring#addDependent",s.printf("Can't add dependency with same key '{0}'",i1),"sap.ui.rta");}};
e1.prototype.getDependent=function(i){return this._dependents[i];};
e1.prototype.getDependents=function(){return this._dependents;};
e1.prototype.removeDependent=function(i){delete this._dependents[i];};
e1.prototype._destroyDefaultPlugins=function(i){for(var i1 in this._mDefaultPlugins){var j1=this._mDefaultPlugins[i1];if(j1&&!j1.bIsDestroyed){if(!i||i[i1]!==j1){j1.destroy();}}}if(!i){this._mDefaultPlugins=null;}};
e1.prototype.onPopupOpen=function(i){if(i.getParameters()instanceof sap.m.Dialog&&this.getToolbar()instanceof F){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};
e1.prototype.onPopupClose=function(i){if(i.getParameters()instanceof sap.m.Dialog){this.getToolbar().setColor();}};
e1.prototype.setPlugins=function(i){if(this._oDesignTime){throw new Error('Cannot replace plugins: runtime authoring already started');}this.setProperty("plugins",i);};
e1.prototype.setFlexSettings=function(i){var i1=new Q(window.location.href);var j1=i1.get("sap-ui-layer");i=q.extend({},this.getFlexSettings(),i);if(j1){i.layer=j1;}if(i.scenario||i.baseId){var k1=t.buildLrepRootNamespace(i.baseId,i.scenario,i.projectId);i.rootNamespace=k1;i.namespace=k1+"changes/";}U.setRtaStyleClassName(i.layer);this.setProperty("flexSettings",i);};
e1.prototype.getLayer=function(){return this.getFlexSettings().layer;};
e1.prototype.getRootControlInstance=function(){if(!this._oRootControl){this._oRootControl=E.getElementInstance(this.getRootControl());}return this._oRootControl;};
e1.prototype._getFlexController=function(){var i=this.getRootControlInstance();return r.createForControl(i);};
e1.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};
e1.prototype.start=function(){this._sStatus=Z;var i;var i1;if(!this._oDesignTime){if(!this.getRootControlInstance()){i1=new Error("Root control not found");t.log.error(i1);return Promise.reject(i1);}if(this.getValidateAppVersion()&&!t.isCorrectAppVersionFormat(this._getFlexController().getAppVersion())){i1=this._getTextResources().getText("MSG_INCORRECT_APP_VERSION_ERROR");t.log.error(i1);return Promise.reject(i1);}return this._handleHigherLayerChangesOnStart().then(function(j1){if(j1){return Promise.reject("Reload triggered");}if(!this.getPlugins()||!Object.keys(this.getPlugins()).length){this.setPlugins(this.getDefaultPlugins());}this._destroyDefaultPlugins(this.getPlugins());Object.keys(this.getPlugins()).forEach(function(m1){if(this.getPlugins()[m1].attachElementModified){this.getPlugins()[m1].attachElementModified(this._handleElementModified,this);}}.bind(this));if(this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(this.getCommandStack());}this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});var k1=Object.keys(this.getPlugins());var l1=k1.map(function(m1){return this.getPlugins()[m1];},this);i=new Promise(function(m1,n1){V.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:l1});this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()==="USER"){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}this._oDesignTime.getSelectionManager().attachChange(function(o1){this.fireSelectionChange({selection:o1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){m1();V.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",function(o1){n1(o1.getParameter("error"));});}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getPublishAndAppVariantSupportVisibility().then(function(j1){var k1=j1[0];var l1=j1[1];this._createToolsMenu(k1,l1);}.bind(this));}}.bind(this)).then(function(){this._onStackModified();}.bind(this)).then(function(){z.loadStyles('InPageStyles').then(function(j1){var k1=j1.replace(/%scrollWidth%/g,y.getScrollbarWidth()+'px');y.insertStyles(k1,O.getOverlayContainer().get(0));});}).then(function(){return i;}).then(function(){if(this.getShowToolbars()){return this.getToolbar().show();}}.bind(this)).then(function(){this.getPopupManager().setRta(this);if(H.browser.name==="ff"){q(document).on('contextmenu',f1);}}.bind(this)).then(function(){this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);var j1=K.getOverlay(this.getRootControl());this._$RootControl=j1.getAssociatedDomRef();if(this._$RootControl){this._$RootControl.addClass("sapUiRtaRoot");}}.bind(this)).then(function(){this._sStatus=$;this.fireStart({editablePluginsCount:this.iEditableOverlaysCount});}.bind(this),function(i1){if(i1!=="Reload triggered"){this._sStatus=a1;this.fireFailed(i1);}if(i1){return Promise.reject(i1);}}.bind(this));}};
function f1(){return false;}
e1.prototype._getPublishAndAppVariantSupportVisibility=function(){return u.getInstance().then(function(i){var i1=G.isPlatFormEnabled(this.getRootControlInstance(),this.getLayer(),this._oSerializer);return[!i.isProductiveSystem()&&!i.hasMergeErrorOccured(),!i.isProductiveSystem()&&i1];}.bind(this)).catch(function(){return false;});};
var g1=function(i1){B.hide();var j1="";if(i1.messages&&Array.isArray(i1.messages)){for(var i=0;i<i1.messages.length;i++){j1=(i1.messages[i].severity==="Error")?j1+i1.messages[i].text+"\n":j1;}}else{j1=i1.stack||i1.message||i1.status||i1;}var k1=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");W.error("Failed to transfer runtime adaptation changes to layered repository",j1);var l1=k1.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+k1.getText("MSG_ERROR_REASON",j1);v.error(l1,{styleClass:U.getRtaStyleClassName()});};
e1.prototype.setCommandStack=function(i){var i1=this.getProperty("commandStack");if(i1){i1.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var j1=this.setProperty("commandStack",i);if(i){i.attachModified(this._onStackModified,this);}if(this.getPlugins()&&this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(i);}return j1;};
e1.prototype.getCommandStack=function(){var i=this.getProperty("commandStack");if(!i){i=new C();this._oInternalCommandStack=i;this.setCommandStack(i);}return i;};
e1.prototype._onStackModified=function(){var i=this.getCommandStack();var i1=i.canUndo();var j1=i.canRedo();if(this.getShowToolbars()){this.getToolbar().setUndoRedoEnabled(i1,j1);this.getToolbar().setPublishEnabled(this._bChangesExist||i1);this.getToolbar().setRestoreEnabled(this._bChangesExist||i1);}this.fireUndoRedoStackModified();};
e1.prototype._closeToolbar=function(){if(this.getShowToolbars()&&this.getToolbar){return this.getToolbar().hide();}};
e1.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}else{return[];}};
e1.prototype.stop=function(i,i1){return((i1)?Promise.resolve(this._RESTART.NOT_NEEDED):this._handleReloadOnExit()).then(function(j1){return((i)?Promise.resolve():this._serializeToLrep(this)).then(this._closeToolbar.bind(this)).then(function(){this.fireStop();if(j1!==this._RESTART.NOT_NEEDED){this._removeMaxLayerParameter();if(j1===this._RESTART.RELOAD_PAGE){this._reloadPage();}}}.bind(this));}.bind(this)).catch(g1).then(function(){this._sStatus=_;}.bind(this));};
e1.prototype.restore=function(){this._onRestore();};
e1.prototype.transport=function(){return this._onTransport();};
e1.prototype.undo=function(){return this._onUndo();};
e1.prototype.redo=function(){return this._onRedo();};
e1.prototype.canUndo=function(){return this.getCommandStack().canUndo();};
e1.prototype.canRedo=function(){return this.getCommandStack().canRedo();};
e1.prototype._onKeyDown=function(i){var i1=H.os.macintosh;var j1=O.getOverlayContainer().get(0).contains(document.activeElement);var k1=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var l1=false;q(".sapUiDtContextMenu").each(function(p1,q1){if(q1.contains(document.activeElement)){l1=true;}});var m1=document.body===document.activeElement;var n1=q(document.activeElement).parents('.sapUiRtaEditableField').length>0;if((j1||k1||l1||m1)&&!n1){var o1=i1?i.metaKey:i.ctrlKey;if(i.keyCode===X.Z&&i.shiftKey===false&&i.altKey===false&&o1===true){this._onUndo().then(i.stopPropagation.bind(i));}else if(((i1&&i.keyCode===X.Z&&i.shiftKey===true)||(!i1&&i.keyCode===X.Y&&i.shiftKey===false))&&i.altKey===false&&o1===true){this._onRedo().then(i.stopPropagation.bind(i));}}};
e1.prototype._onUnload=function(){var i=this.getCommandStack();var i1=i.canUndo()||i.canRedo();if(i1&&this.getShowWindowUnloadDialog()){var j1=this._getTextResources().getText("MSG_UNSAVED_CHANGES");return j1;}else{window.onbeforeunload=this._oldUnloadHandler;}};
e1.prototype._serializeToLrep=function(){return this._oSerializer.saveCommands().then(this._invalidateCache.bind(this));};
e1.prototype._invalidateCache=function(){return this._getFlexController().getComponentChanges(undefined,true);};
e1.prototype._onUndo=function(){this._handleStopCutPaste();return this.getCommandStack().undo();};
e1.prototype._onRedo=function(){this._handleStopCutPaste();return this.getCommandStack().redo();};
e1.prototype._createToolsMenu=function(i,i1){if(!this.getDependent('toolbar')){var j1;if(this.getLayer()==="USER"){j1=P;}else if(U.getFiori2Renderer()){j1=F;}else{j1=S;}if(this.getLayer()==="USER"){this.addDependent(new j1({textResources:this._getTextResources(),exit:this.stop.bind(this,false,true),restore:this._onRestore.bind(this)}),'toolbar');}else{this.addDependent(new j1({modeSwitcher:this.getMode(),publishVisible:i,textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),transport:this._onTransport.bind(this),restore:this._onRestore.bind(this),undo:this._onUndo.bind(this),redo:this._onRedo.bind(this),modeChange:this._onModeChange.bind(this),manageApps:G.onGetOverview.bind(null,true),appVariantOverview:this._onGetAppVariantOverview.bind(this),saveAs:G.onSaveAsFromRtaToolbar.bind(null,true,true)}),'toolbar');}var k1;if(i1){this.getToolbar().getControl('saveAs').setVisible(i1);k1=G.isOverviewExtended();if(k1){this.getToolbar().getControl('appVariantOverview').setVisible(i1);}else{this.getToolbar().getControl('manageApps').setVisible(i1);}G.isManifestSupported().then(function(l1){if(k1){this.getToolbar().getControl('appVariantOverview').setEnabled(l1);}else{this.getToolbar().getControl('manageApps').setEnabled(l1);}this.getToolbar().getControl('saveAs').setEnabled(l1);}.bind(this));}this._checkChangesExist().then(function(l1){if(!this.bIsDestroyed){this._bChangesExist=l1;this.getToolbar().setPublishEnabled(l1);this.getToolbar().setRestoreEnabled(l1);}}.bind(this));}};
e1.prototype._onGetAppVariantOverview=function(i){var i1=i.getParameter("item");var j1=i1.getId()==='keyUser';return G.onGetOverview(j1);};
e1.prototype.destroy=function(){q.map(this._dependents,function(i,i1){this.removeDependent(i1);i.destroy(true);}.bind(this));Object.keys(this._mServices).forEach(function(i){this.stopService(i);},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);this._destroyDefaultPlugins();this.setPlugins(null);}if(this._$RootControl){this._$RootControl.removeClass("sapUiRtaRoot");}this.setCommandStack(null);if(this._oServiceEventBus){this._oServiceEventBus.destroy();}if(H.browser.name==="ff"){q(document).off("contextmenu",f1);}window.onbeforeunload=this._oldUnloadHandler;M.prototype.destroy.apply(this,arguments);};
e1.prototype._onTransport=function(){this._handleStopCutPaste();B.show(500);return this._serializeToLrep().then(function(){B.hide();return this._getFlexController()._oChangePersistence.transportAllUIChanges(this._oRootControl,U.getRtaStyleClassName(),this.getLayer()).then(function(i){if(i!=="Error"&&i!=="Cancel"){this._showMessageToast("MSG_TRANSPORT_SUCCESS");}}.bind(this));}.bind(this))['catch'](g1);};
e1.prototype._deleteChanges=function(){return this._getFlexController().resetChanges(this.getLayer(),"Change.createInitialFileContent",t.getAppComponentForControl(this.getRootControlInstance())).then(function(){this._reloadPage();}.bind(this))["catch"](function(i){return U._showMessageBox(v.Icon.ERROR,"HEADER_RESTORE_FAILED","MSG_RESTORE_FAILED",i);});};
e1.prototype._reloadPage=function(){window.location.reload();};
e1.prototype._showMessageToast=function(i){var i1=this._getTextResources().getText(i);w.show(i1);};
e1.needsRestart=function(i){var i1=!!window.sessionStorage.getItem("sap.ui.rta.restart."+i);return i1;};
e1.enableRestart=function(i){window.sessionStorage.setItem("sap.ui.rta.restart."+i,true);};
e1.disableRestart=function(i){window.sessionStorage.removeItem("sap.ui.rta.restart."+i);};
e1.prototype._onRestore=function(){var i=this.getLayer()==="USER"?this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION"):this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");var i1=this.getLayer()==="USER"?this._getTextResources().getText("BTN_RESTORE"):this._getTextResources().getText("FORM_PERS_RESET_TITLE");var j1=function(k1){if(k1==="OK"){e1.enableRestart(this.getLayer());this._deleteChanges();this.getCommandStack().removeAllCommands();}}.bind(this);this._handleStopCutPaste();v.confirm(i,{icon:v.Icon.WARNING,title:i1,onClose:j1,styleClass:U.getRtaStyleClassName()});};
e1.prototype._scheduleRenameOnCreatedContainer=function(i,i1){var j1=function(n1){var o1=this.getPlugins()["createContainer"].getCreatedContainerId(i,n1.getElement().getId());var p1=K.getOverlay(o1);p1.setSelected(true);this.getPlugins()["rename"].startEdit(p1);};var k1=function(n1){var o1=n1.getSource();if(o1.getGeometry()&&o1.getGeometry().visible){j1.call(this,o1);o1.detachEvent('geometryChanged',k1,this);}};var l1=function(n1){if(!n1.getGeometry()||!n1.getGeometry().visible){n1.attachEvent('geometryChanged',k1,this);}else{j1.call(this,n1);}};var m1=function(n1){var o1=n1.getParameter("elementOverlay");if(o1.getElement().getId()===i1){this._oDesignTime.detachEvent("elementOverlayCreated",m1,this);if(o1.isRendered()){l1.call(this,o1);}else{o1.attachEventOnce('afterRendering',function(n1){l1.call(this,n1.getSource());},this);}}};this._oDesignTime.attachEvent("elementOverlayCreated",m1,this);};
e1.prototype._handleElementModified=function(i){this._handleStopCutPaste();var i1=i.getParameter("action");var j1=i.getParameter("newControlId");var k1=i.getParameter("command");if(k1 instanceof sap.ui.rta.command.BaseCommand){if(i1&&j1){this._scheduleRenameOnCreatedContainer(i1,j1);}return this.getCommandStack().pushAndExecute(k1).catch(function(l1){if(l1&&l1.message&&l1.message.indexOf("The following Change cannot be applied because of a dependency")>-1){U._showMessageBox(v.Icon.ERROR,"HEADER_DEPENDENCY_ERROR","MSG_DEPENDENCY_ERROR",l1);}t.log.error("sap.ui.rta: "+l1.message);});}return Promise.resolve();};
e1.prototype._onElementEditableChange=function(i){var i1=i.getParameter("editable");if(i1){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};
e1.prototype._handleStopCutPaste=function(){if(this.getPlugins()["cutPaste"]){this.getPlugins()["cutPaste"].stopCutAndPaste();}};
e1.prototype._checkChangesExist=function(){if(this._getFlexController().getComponentName().length>0){return this._getFlexController().getComponentChanges({currentLayer:this.getLayer(),includeCtrlVariants:true}).then(function(i){return i.length>0;});}else{return Promise.resolve(false);}};
e1.prototype._buildNavigationArguments=function(i){return{target:{semanticObject:i.semanticObject,action:i.action,context:i.contextRaw},params:i.params,appSpecificRoute:i.appSpecificRoute,writeHistory:false};};
e1.prototype._hasMaxLayerParameter=function(i){var i1=this.getLayer();return i.params&&i.params[Y]&&i.params[Y][0]===i1;};
e1.prototype._reloadWithoutHigherLayerChangesOnStart=function(i,i1){var j1=this.getLayer();if(!this._hasMaxLayerParameter(i)){if(!i.params){i.params={};}i.params[Y]=[j1];e1.enableRestart(j1);i1.toExternal(this._buildNavigationArguments(i));return Promise.resolve(true);}};
e1.prototype._removeMaxLayerParameter=function(){if(U.getUshellContainer()&&this.getLayer()!=="USER"){var i=U.getUshellContainer().getService("CrossApplicationNavigation");var i1=t.getParsedURLHash();if(i.toExternal&&i1){if(this._hasMaxLayerParameter(i1)){delete i1.params[Y];i.toExternal(this._buildNavigationArguments(i1));}}}};
e1.prototype._handleReloadWithoutHigherLayerChangesMessageBoxOnStart=function(){var i=this.getLayer();var i1=i==="CUSTOMER"?"MSG_PERSONALIZATION_EXISTS":"MSG_HIGHER_LAYER_CHANGES_EXIST";return U._showMessageBox(v.Icon.INFORMATION,"HEADER_PERSONALIZATION_EXISTS",i1);};
e1.prototype._handleReloadMessageBox=function(i){return U._showMessageBox(v.Icon.INFORMATION,"HEADER_RELOAD_NEEDED",i,undefined,"BUTTON_RELOAD_NEEDED");};
e1.prototype._handleHigherLayerChangesOnStart=function(){var i=U.getUshellContainer();if(i&&this.getLayer()!=="USER"){var i1=t.getParsedURLHash();return this._getFlexController().hasHigherLayerChanges({ignoreMaxLayerParameter:false}).then(function(j1){if(j1){return this._handleReloadWithoutHigherLayerChangesMessageBoxOnStart().then(function(){var k1=sap.ushell.Container.getService("CrossApplicationNavigation");if(k1.toExternal&&i1){return this._reloadWithoutHigherLayerChangesOnStart(i1,k1);}}.bind(this));}}.bind(this));}else{return Promise.resolve(false);}};
e1.prototype._handleReloadOnExit=function(){return Promise.all([this._oSerializer.needsReload(),this._getFlexController().hasHigherLayerChanges({ignoreMaxLayerParameter:true})]).then(function(i){var i1=i[0],j1=i[1];if(i1||j1){var k1=this._RESTART.RELOAD_PAGE;var l1,m1;if(j1){var n1=this.getLayer();l1=n1==="CUSTOMER"?"MSG_RELOAD_WITH_PERSONALIZATION":"MSG_RELOAD_WITH_ALL_CHANGES";m1=U.getUshellContainer();if(!i1&&m1){k1=this._RESTART.VIA_HASH;}}else if(i1){l1="MSG_RELOAD_NEEDED";}return this._handleReloadMessageBox(l1).then(function(){return k1;});}else{return this._RESTART.NOT_NEEDED;}}.bind(this));};
e1.prototype._onModeChange=function(i){this.setMode(i.getParameter("item").getKey());};
e1.prototype.setMode=function(i){if(this.getProperty('mode')!==i){var i1=this.getShowToolbars()&&this.getToolbar().getControl('modeSwitcher');var j1=i==='adaptation';if(i1){i1.setSelectedButton(i1.getItems().filter(function(k1){return k1.getKey()===i;}).pop().getId());}this._oDesignTime.setEnabled(j1);this.getPlugins()['tabHandling'][j1?'removeTabIndex':'restoreTabIndex']();this.setProperty('mode',i);this.fireModeChanged({mode:i});}};
e1.prototype.setMetadataScope=function(i){if(this._oDesignTime){W.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty('metadataScope',i);};
function h1(i){if(I.hasOwnProperty(i)){return I[i].replace(/\./g,'/');}}
e1.prototype.startService=function(i){if(this._sStatus!==$){return new Promise(function(k1,l1){this.attachEventOnce('start',k1);this.attachEventOnce('failed',l1);}.bind(this)).then(function(){return this.startService(i);}.bind(this),function(){return Promise.reject(s.createError("RuntimeAuthoring#startService",s.printf("Can't start the service '{0}' while RTA has been failed during a startup",i),"sap.ui.rta"));});}var i1=h1(i);var j1;if(!i1){return Promise.reject(s.createError("RuntimeAuthoring#startService",s.printf("Unknown service. Can't find any registered service by name '{0}'",i),"sap.ui.rta"));}else{j1=this._mServices[i];if(j1){switch(j1.status){case c1:{return Promise.resolve(j1.exports);}case b1:{return j1.initPromise;}case d1:{return j1.initPromise;}default:{return Promise.reject(s.createError("RuntimeAuthoring#startService",s.printf("Unknown service status. Service name = '{0}'",i),"sap.ui.rta"));}}}else{this._mServices[i]=j1={status:b1,location:i1,initPromise:new Promise(function(k1,l1){sap.ui.require([i1],function(m1){j1.factory=m1;if(!this._oServiceEventBus){this._oServiceEventBus=new J();}s.wrapIntoPromise(m1)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,i)).then(function(n1){if(this.bIsDestroyed){throw s.createError("RuntimeAuthoring#startService",s.printf("RuntimeAuthoring instance is destroyed while initialising the service '{0}'",i),"sap.ui.rta");}if(!q.isPlainObject(n1)){throw s.createError("RuntimeAuthoring#startService",s.printf("Invalid service format. Service should return simple javascript object after initialisation. Service name = '{0}'",i),"sap.ui.rta");}j1.service=n1;j1.exports={};if(Array.isArray(n1.events)&&n1.events.length>0){q.extend(j1.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,i),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,i),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,i)});}var o1=n1.exports||{};q.extend(j1.exports,Object.keys(o1).reduce(function(p1,q1){var r1=o1[q1];p1[q1]=typeof r1==="function"?s.waitForSynced(r1,this._oDesignTime):r1;return p1;}.bind(this),{}));j1.status=c1;k1(Object.freeze(j1.exports));}.bind(this)).catch(l1);}.bind(this),function(m1){j1.status=d1;l1(s.propagateError(m1,"RuntimeAuthoring#startService",s.printf("Can't load service '{0}' by its name: {1}",i,i1),"sap.ui.rta"));});}.bind(this)).catch(function(k1){j1.status=d1;return Promise.reject(s.propagateError(k1,"RuntimeAuthoring#startService",s.printf("Error during service '{0}' initialisation.",i),"sap.ui.rta"));})};return j1.initPromise;}}};
e1.prototype.stopService=function(i){var i1=this._mServices[i];if(i1){if(i1.status===c1){if(typeof i1.service.destroy==="function"){i1.service.destroy();}}delete this._mServices[i];}else{throw s.createError("RuntimeAuthoring#stopService",s.printf("Can't destroy service: unable to find service with name '{0}'",i),"sap.ui.rta");}};
e1.prototype.getService=function(i){return this.startService(i);};
return e1;},true);
sap.ui.predefine('sap/ui/rta/Utils',["sap/ui/thirdparty/jquery","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/ui/dt/OverlayUtil","sap/ui/dt/DOMUtil","sap/m/MessageBox","sap/base/Log"],function(q,F,S,O,D,M,L){"use strict";var U={};U.RESOLVED_PROMISE=Promise.resolve(true);U._sFocusableOverlayClass=".sapUiDtOverlaySelectable";U._sRtaStyleClassName='';
U.getRtaStyleClassName=function(){return U._sRtaStyleClassName;};
U.setRtaStyleClassName=function(l){if(l==="USER"){U._sRtaStyleClassName="";}else if(F.getLayerIndex(l)>-1){U._sRtaStyleClassName="sapContrast sapContrastPlus";}};
U.isExtensibilityEnabledInSystem=function(c){var C=F.getComponentClassName(c);if(!C||C==""){return Promise.resolve(false);}return S.getInstance(C).then(function(s){if(s.isModelS){return s.isModelS();}return false;});};
U.isServiceUpToDate=function(c){return this.isExtensibilityEnabledInSystem(c).then(function(e){if(e){return new Promise(function(r,R){sap.ui.require(["sap/ui/fl/fieldExt/Access"],function(A){var m=c.getModel();if(m){var s=A.isServiceOutdated(m.sServiceUrl);if(s){A.setServiceValid(m.sServiceUrl);sap.ui.getCore().getEventBus().publish("sap.ui.core.UnrecoverableClientStateCorruption","RequestReload",{});return R();}}return r();});});}});};
U.isCustomFieldAvailable=function(c){return this.isExtensibilityEnabledInSystem(c).then(function(s){if(!s){return false;}else if(!c.getModel()){return false;}else{return new Promise(function(r,R){sap.ui.require(["sap/ui/fl/fieldExt/Access"],function(A){var a=c.getModel().sServiceUrl;var e=this.getBoundEntityType(c).name;var d;try{d=A.getBusinessContexts(a,e);}catch(E){L.error("exception occured in sap.ui.fl.fieldExt.Access.getBusinessContexts",E);r(false);}return Promise.resolve(d).then(function(o){if(o&&Array.isArray(o.BusinessContexts)&&o.BusinessContexts.length>0){o.EntityType=e;return r(o);}return r(false);}).catch(function(E){if(E){if(Array.isArray(E.errorMessages)){for(var i=0;i<E.errorMessages.length;i++){L.error(E.errorMessages[i].text);}}}return r(false);});}.bind(this),R);}.bind(this));}}.bind(this));};
U.openRemoveConfirmationDialog=function(e,t){var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var s;return new Promise(function(r,a){s=T.getText("CTX_REMOVE_TITLE");var d={messageText:t,titleText:s,icon:"sap-icon://question-mark",removeText:T.getText("BTN_FREP_REMOVE"),cancelText:T.getText("BTN_FREP_CANCEL")};var m=new sap.ui.model.json.JSONModel();m.setData(d);var f;var c=function(){if(f){f.close();f.destroy();f=null;}};var o={removeField:function(){c();r(true);},closeDialog:function(){c();r(false);}};if(!f){f=sap.ui.xmlfragment("sap.ui.rta.view.RemoveElementDialog",o);f.setModel(m);}f.addStyleClass(U.getRtaStyleClassName());f.open();});};
U.isOverlaySelectable=function(o){return o.isSelectable()&&D.isVisible(o.getDomRef());};
U.getPropertyValue=function(e,p){var m=e.getMetadata().getPropertyLikeSetting(p);var P=m._sGetter;return e[P]();};
U.getOverlayInstanceForDom=function(d){var i=q(d).attr("id");if(i){return sap.ui.getCore().byId(i);}};
U.getFocusedOverlay=function(){if(document.activeElement){var e=sap.ui.getCore().byId(document.activeElement.id);if(e instanceof sap.ui.dt.ElementOverlay){return e;}}};
U.getFocusableParentOverlay=function(o){if(!o){return undefined;}var f=o.getParentElementOverlay();while(f&&!f.getSelectable()){f=f.getParentElementOverlay();}return f;};
U.getFirstFocusableDescendantOverlay=function(o){return O.getFirstDescendantByCondition(o,this.isOverlaySelectable);};
U.getLastFocusableDescendantOverlay=function(o){return O.getLastDescendantByCondition(o,this.isOverlaySelectable);};
U.getNextFocusableSiblingOverlay=function(o){var N=true;var n=O.getNextSiblingOverlay(o);while(n&&!this.isOverlaySelectable(n)){n=O.getNextSiblingOverlay(n);}if(!n){n=this._findSiblingOverlay(o,N);}return n;};
U.getPreviousFocusableSiblingOverlay=function(o){var P=false;var p=O.getPreviousSiblingOverlay(o);while(p&&!this.isOverlaySelectable(p)){p=O.getPreviousSiblingOverlay(p);}if(!p){p=this._findSiblingOverlay(o,P);}return p;};
U._findSiblingOverlay=function(o,n){var p=o.getParentElementOverlay();if(p){var s=n?O.getNextSiblingOverlay(p):O.getPreviousSiblingOverlay(p);if(!s){return this._findSiblingOverlay(p,n);}else{var d=n?this.getFirstFocusableDescendantOverlay(s):this.getLastFocusableDescendantOverlay(s);return d;}}else{return undefined;}};
U.getIndex=function(p,c,a,g){var i;if(g&&typeof g==="function"){i=g.call(null,p,c);}else{var m=p.getMetadata();var A=m.getAggregation(a);var G=A._sGetter;var C=p[G]();if(Array.isArray(C)){if(c){i=C.indexOf(c)+1;}else{i=C.length;}}else{i=0;}}return i;};
U.createFieldLabelId=function(p,e,b){return(p.getId()+"_"+e+"_"+b).replace("/","_");};
U.getBoundEntityType=function(e,m){m||(m=e.getModel());var b=e.getBindingContext();if(b){return U.getEntityTypeByPath(m,b.getPath())||{};}return{};};
U.openNewWindow=function(u){window.open(u,"_blank");};
U.getElementBindingPaths=function(e){var p={};if(e.mBindingInfos){for(var i in e.mBindingInfos){var P=e.mBindingInfos[i].parts[0].path?e.mBindingInfos[i].parts[0].path:"";P=P.split("/")[P.split("/").length-1];p[P]={valueProperty:i};}}return p;};
U.getFiori2Renderer=function(){var c=U.getUshellContainer()||{};return typeof c.getRenderer==="function"?c.getRenderer("fiori2"):undefined;};
U.getUshellContainer=function(){return sap.ushell&&sap.ushell.Container;};
U.getEntityTypeByPath=function(m,p){return m.oMetadata&&m.oMetadata._getEntityTypeByPath(p);};
U.mergeWith=function(d,s,c){if(!(typeof c==="function")){throw new Error('In order to use mergeWith() utility function fnCustomizer should be provided!');}for(var a in s){if(s.hasOwnProperty(a)){d[a]=d.hasOwnProperty(a)?c(d[a],s[a],a,d,s):s[a];}}return d;};
U.extendWith=function(d,s,c){if(!(typeof c==="function")){throw new Error('In order to use extendWith() utility function fnCustomizer should be provided!');}for(var a in s){if(s.hasOwnProperty(a)){if(c(d[a],s[a],a,d,s)){d[a]=s[a];}}}};
U.isElementInViewport=function(d){if(d instanceof q){d=d.get(0);}var r=d.getBoundingClientRect();return(r.top>=0&&r.left>=0&&r.bottom<=(window.innerHeight||document.documentElement.clientHeight)&&r.right<=(window.innerWidth||document.documentElement.clientWidth));};
U._showMessageBox=function(m,t,s,e,a){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var b=r.getText(s,e?[e.message||e]:undefined);var T=r.getText(t);var A=a?r.getText(a):M.Action.OK;return new Promise(function(c){M.show(b,{icon:m,title:T,onClose:c,actions:A,styleClass:U.getRtaStyleClassName()});});};
U.omit=function(o,p){var n=Object.assign({},o);p.forEach(function(P){delete n[P];});return n;};
return U;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantDialog',['sap/m/Dialog','sap/m/DialogRenderer','sap/ui/layout/form/SimpleForm','sap/ui/layout/form/ResponsiveGridLayout','sap/ui/rta/Utils'],function(D,a,S,R,b){"use strict";var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var d,t,T,s,o,c,e,i,I,f,g,C,h;
function _(){d=new sap.m.GenericTile("tile",{header:"{/title}",subheader:"{/subtitle}",ariaLabel:r.getText("APP_VARIANT_TILE_ARIA_LABEL"),tileContent:[new sap.m.TileContent({content:[new sap.m.ImageContent({src:"{/icon}"})]})]}).addStyleClass("sapUiMediumMarginBegin").addStyleClass("sapUiTinyMarginTop").addStyleClass("sapUiTinyMarginBottom");}
function j(E){var v=E.getParameter("value");var F=new sap.ui.model.Filter("name",sap.ui.model.FilterOperator.Contains,v);var B=E.getSource().getBinding("items");B.filter([F]);}
function k(E){var q=E.getParameter("selectedContexts");if(q&&q.length){q.forEach(function(u){var v=u.getObject().name;I.setValue(v);C.setProperty("/icon",u.getObject().icon);});}E.getSource().getBinding("items").filter([]);}
function l(){if(!g){g=new sap.m.SelectDialog("selectDialog",{noDataText:r.getText("APP_VARIANT_ICON_NO_DATA"),title:r.getText("APP_VARIANT_ICON_SELECT_ICON"),search:function(E){j(E);},confirm:function(E){k(E);},cancel:function(E){k(E);}});}g.addStyleClass(b.getRtaStyleClassName());g.bindAggregation("items",{path:"/icons",template:new sap.m.StandardListItem({title:"{name}",description:"",icon:"{icon}",iconDensityAware:false,iconInset:false,type:"Active"})});var u=sap.ui.core.IconPool.getIconNames();var q=[];u.forEach(function(N){q.push({icon:sap.ui.core.IconPool.getIconInfo(N).uri,name:N.toLowerCase()});});h.setProperty("/icons",q);g.setModel(h);g.getBinding("items").filter([]);g.open();}
function m(){t=new sap.m.Label({required:true,text:r.getText("APP_DIALOG_TITLE_TEXT"),textAlign:"Left"});T=new sap.m.Input("titleInput",{value:"{/title}",valueLiveUpdate:true,placeholder:r.getText("SAVE_AS_DIALOG_PLACEHOLDER_TITLE_TEXT"),liveChange:function(){var q=sap.ui.getCore().byId("saveButton");if(this.getValue()===""){this.setValueState(sap.ui.core.ValueState.Error);q.setEnabled(false);}else{this.setValueState(sap.ui.core.ValueState.None);q.setEnabled(true);}}});s=new sap.m.Label({text:r.getText("APP_DIALOG_SUB_TITLE_TEXT"),textAlign:"Left"});o=new sap.m.Input({value:"{/subtitle}",valueLiveUpdate:true});c=new sap.m.Label({text:r.getText("APP_DIALOG_DESCRIPTION_TEXT"),textAlign:"Left"});e=new sap.m.TextArea({rows:4});i=new sap.m.Label({text:r.getText("APP_DIALOG_ICON_TEXT"),textAlign:"Left"});I=new sap.m.Input("selectInput",{showValueHelp:true,liveChange:function(E){l(E);},valueHelpRequest:function(E){l(E);},value:"{/iconname}",valueLiveUpdate:true});}
function n(){f=new sap.ui.layout.form.SimpleForm({editable:true,layout:"ResponsiveGridLayout",labelSpanXL:4,labelSpanL:4,labelSpanM:4,labelSpanS:4,adjustLabelSpan:false,emptySpanXL:0,emptySpanL:0,emptySpanM:0,emptySpanS:0,columnsXL:2,columnsL:2,columnsM:2,singleContainerFullSize:false,content:[new sap.ui.core.Title("title1"),t,T,s,o,i,I,c,e,new sap.ui.core.Title("title2"),d]});return f;}
function p(){var v=new sap.m.VBox({items:[n()]}).addStyleClass("sapUISmallMargin");return v;}
var A=D.extend("sap.ui.rta.appVariant.AppVariantDialog",{
metadata:{library:"sap.ui.rta",events:{create:{},cancel:{}}},
init:function(){D.prototype.init.apply(this);this.setTitle(r.getText("CREATE_APP_VARIANT_DIALOG_TITLE"));this.setContentWidth("620px");this.setContentHeight("250px");C=new sap.ui.model.json.JSONModel({title:null,subtitle:null,icon:" ",iconname:null});h=new sap.ui.model.json.JSONModel({icons:null});sap.ui.getCore().setModel(C);_();m();this.addContent(p());this._createButtons();this.addStyleClass(b.getRtaStyleClassName());},
onAfterRendering:function(){document.getElementById('title1').style.height="0px";document.getElementById('title2').style.height="0px";document.getElementById('tile').style.float="left";},
_onCreate:function(){var q=T.getValue()||" ";var u=o.getValue()||" ";var v=e.getValue()||" ";var w=I.getValue()?sap.ui.core.IconPool.getIconInfo(I.getValue()).uri:" ";this.fireCreate({title:q,subTitle:u,description:v,icon:w});this.close();this.destroy();},
_createButtons:function(){this.addButton(new sap.m.Button("saveButton",{text:r.getText("APP_VARIANT_DIALOG_SAVE"),tooltip:r.getText("TOOLTIP_APP_VARIANT_DIALOG_SAVE"),enabled:false,press:function(){this._onCreate();}.bind(this)}));this.addButton(new sap.m.Button({text:r.getText("SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),tooltip:r.getText("TOOLTIP_SAVE_AS_APP_VARIANT_DIALOG_CANCEL"),press:function(){this.fireCancel();this.close();this.destroy();}.bind(this)}));},
destroy:function(){if(C){C.destroy();}D.prototype.destroy.apply(this,arguments);},
renderer:a.render
});
return A;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantManager',["sap/ui/base/ManagedObject","sap/ui/rta/appVariant/AppVariantDialog","sap/ui/rta/appVariant/AppVariantUtils","sap/m/MessageBox","sap/ui/rta/appVariant/Feature","sap/ui/fl/transport/TransportSelection","sap/ui/rta/appVariant/S4HanaCloudBackend","sap/ui/rta/Utils","sap/ui/core/BusyIndicator"],function(M,A,a,b,R,T,S,c,B){"use strict";
var d=M.extend("sap.ui.rta.appVariant.AppVariantManager",{metadata:{library:"sap.ui.rta",properties:{"rootControl":{type:"sap.ui.core.Control"},"commandSerializer":{type:"object"}}}});
d.prototype._openDialog=function(C,f){var D=new A("appVariantDialog");D.attachCreate(C);D.attachCancel(f);D.attachAfterClose(function(){this.destroy();});D.open();return D;};
d.prototype._prepareAppVariantData=function(D,p){return{idRunningApp:D["sap.app"].id,title:p.title,subTitle:p.subTitle,description:p.description,icon:p.icon,inbounds:D["sap.app"].crossNavigation&&D["sap.app"].crossNavigation.inbounds?D["sap.app"].crossNavigation.inbounds:null};};
d.prototype.createAllInlineChanges=function(o){var s,e=[],p;s=a.getId(o.idRunningApp);var f={id:s,reference:o.idRunningApp};e.push(a.createDescriptorVariant(f));p=a.getInlinePropertyChange("title",o.title);e.push(a.createInlineChange(p,"title"));p=a.getInlinePropertyChange("subtitle",o.subTitle);e.push(a.createInlineChange(p,"subtitle"));p=a.getInlinePropertyChange("description",o.description);e.push(a.createInlineChange(p,"description"));p=a.getInlineChangeInputIcon(o.icon);e.push(a.createInlineChange(p,"icon"));var i=a.getInboundInfo(o.inbounds);var C=i.currentRunningInbound;var g=i.addNewInboundRequired;if(C==="customer.savedAsAppVariant"&&g){p=a.getInlineChangeCreateInbound(C);e.push(a.createInlineChange(p,"createInbound"));}p=a.getInlineChangeForInboundPropertySaveAs(C);e.push(a.createInlineChange(p,"inbound"));p=a.getInlineChangeRemoveInbounds(C);e.push(a.createInlineChange(p,"removeInbound"));p=a.getInlineChangesForInboundProperties(C,s,"title",o.title);e.push(a.createInlineChange(p,"inboundTitle"));p=a.getInlineChangesForInboundProperties(C,s,"subTitle",o.subTitle);e.push(a.createInlineChange(p,"inboundSubtitle"));p=a.getInlineChangesForInboundProperties(C,s,"icon",o.icon);e.push(a.createInlineChange(p,"inboundIcon"));return e;};
d.prototype._onTransportInDialogSelected=function(o,t){if(t){if(t.transport&&t.packageName!=="$TMP"){var p=[];if(t.transport){p.push(o.setTransportRequest(t.transport));}if(p.length){return Promise.all(p).then(function(){return Promise.resolve(o);});}}return Promise.resolve(o);}return Promise.resolve(false);};
d.prototype.createDescriptor=function(o){var i=this.createAllInlineChanges(o);var O=function(t){var f=new T();return f.openTransportSelection(t,this,c.getRtaStyleClassName());};var e;return Promise.all(i).then(function(r){e=r.shift();i=[];r.forEach(function(I){i.push(e.addDescriptorInlineChange(I));});return Promise.all(i);}).then(function(){var n=e.getNamespace();var t=a.getTransportInput("",n,"manifest","appdescr_variant");return O.call(this,t);}.bind(this)).then(function(t){return this._onTransportInDialogSelected(e,t);}.bind(this))["catch"](function(E){var f=a.buildErrorInfo("MSG_CREATE_DESCRIPTOR_FAILED",E,e.getId());B.hide();return a.showRelevantDialog(f,false);});};
d.prototype.processSaveAsDialog=function(D,s){return new Promise(function(r){var C=function(o){var p=o.getParameters();var e=this._prepareAppVariantData(D,p);r(e);}.bind(this);var f=function(){if(!s){return R.onGetOverview(true);}};return this._openDialog(C,f);}.bind(this));};
d.prototype.saveAppVariantToLREP=function(o){return o.submit()["catch"](function(e){B.hide();var E=a.buildErrorInfo("MSG_SAVE_APP_VARIANT_FAILED",e,o.getId());return a.showRelevantDialog(E,false);});};
d.prototype._takeOverDirtyChangesByAppVariant=function(r){return this.getCommandSerializer().saveAsCommands(r);};
d.prototype._deleteAppVariantFromLREP=function(s){return a.triggerDeleteAppVariantFromLREP(s);};
d.prototype.copyUnsavedChangesToLREP=function(s,C){var o=this.getCommandSerializer().getCommandStack();if(C&&o.getAllExecutedCommands().length){return this._takeOverDirtyChangesByAppVariant(s)["catch"](function(e){return this._deleteAppVariantFromLREP(s)["catch"](function(e){B.hide();var E=a.buildErrorInfo("SAVE_AS_MSG_DELETE_APP_VARIANT",e,s);return a.showRelevantDialog(E,false);}).then(function(){B.hide();var E=a.buildErrorInfo("MSG_COPY_UNSAVED_CHANGES_FAILED",e);return a.showRelevantDialog(E,false);});}.bind(this));}return Promise.resolve();};
d.prototype.triggerCatalogAssignment=function(o){if(a.isS4HanaCloud(o.getSettings())){return a.triggerCatalogAssignment(o.getId(),o.getReference())["catch"](function(e){B.hide();var E=a.buildErrorInfo("MSG_CATALOG_ASSIGNMENT_FAILED",e,o.getId());return a.showRelevantDialog(E,false);});}return Promise.resolve();};
d.prototype.notifyKeyUserWhenTileIsReady=function(i,s){var o=new S();return o.notifyFlpCustomizingIsReady(i,function(I){var m=a.getText("MSG_SAVE_APP_VARIANT_NEW_TILE_AVAILABLE");var t=a.getText("SAVE_APP_VARIANT_NEW_TILE_AVAILABLE_TITLE");return new Promise(function(r){b.show(m,{icon:b.Icon.INFORMATION,title:t,onClose:r,styleClass:c.getRtaStyleClassName()});});})["catch"](function(e){B.hide();var E=a.buildErrorInfo("MSG_TILE_CREATION_FAILED",e,s);E.copyId=true;return a.showRelevantDialog(E,false);});};
d.prototype._buildSuccessInfo=function(o,s){var C=false;var m=a.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE")+"\n\n";if(a.isS4HanaCloud(o.getSettings())){if(s){m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_CLOUD_MESSAGE");}else{m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_CLOUD_MESSAGE_OVERVIEW_LIST");}}else if(s){m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_ON_PREMISE_MESSAGE",o.getId());C=true;}else{m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_ON_PREMISE_MESSAGE_OVERVIEW_LIST",o.getId());C=true;}return{text:m,appVariantId:o.getId(),copyId:C};};
d.prototype._navigateToFLPHomepage=function(){var o=sap.ushell.services.AppConfiguration.getCurrentApplication();var C=o.componentHandle.getInstance();if(C){var e=sap.ushell.Container.getService("CrossApplicationNavigation");if(e.toExternal){e.toExternal({target:{shellHash:"#"}},C);return Promise.resolve();}}return Promise.resolve();};
d.prototype.showSuccessMessageAndTriggerActionFlow=function(o,s){var e=this._buildSuccessInfo(o,s);B.hide();return a.showRelevantDialog(e,true).then(function(){return s?this._navigateToFLPHomepage():R.onGetOverview(true);}.bind(this));};
return d;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantOverviewDialog',['sap/ui/core/ComponentContainer','sap/m/Dialog','sap/m/DialogRenderer','sap/ui/rta/appVariant/manageApps/webapp/Component',"sap/ui/fl/Utils","sap/ui/rta/Utils","sap/ui/rta/appVariant/AppVariantUtils"],function(C,D,a,M,F,R,A){"use strict";
var b=D.extend("sap.ui.rta.appVariant.AppVariantOverviewDialog",{
metadata:{properties:{"idRunningApp":"string",isOverviewForKeyUser:{type:"boolean"}},events:{cancel:{}}},
constructor:function(){D.prototype.constructor.apply(this,arguments);this._oTextResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");this.oManageAppsComponent=new M("manageApps",{idRunningApp:this.getIdRunningApp(),isOverviewForKeyUser:this.getIsOverviewForKeyUser()});this.oManageAppsComponentContainer=new C({component:this.oManageAppsComponent});this.addContent(this.oManageAppsComponentContainer);this._createButton();this.setContentWidth("1000px");this.setContentHeight("450px");this.setHorizontalScrolling(false);this.setTitle(this._oTextResources.getText("APP_VARIANT_OVERVIEW_DIALOG_TITLE"));this.addStyleClass(R.getRtaStyleClassName());},
destroy:function(){var n=A.getNewAppVariantId();if(n){A.setNewAppVariantId(null);}D.prototype.destroy.apply(this,arguments);},
renderer:a.render
});
b.prototype._createButton=function(){this.addButton(new sap.m.Button({text:this._oTextResources.getText("APP_VARIANT_DIALOG_CLOSE"),press:function(){this.close();this.fireCancel();}.bind(this)}));};
return b;},true);
sap.ui.predefine('sap/ui/rta/appVariant/AppVariantUtils',["sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory","sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory","sap/ui/fl/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/fl/descriptorRelated/internal/Utils","sap/base/util/uid","sap/base/Log","sap/ui/thirdparty/hasher"],function(D,a,F,M,R,b,u,L,h){"use strict";var A={};var H=56;A._newAppVariantId=null;
A.getManifirstSupport=function(r){var s='/sap/bc/ui2/app_index/ui5_app_mani_first_supported/?id='+r;return b.sendRequest(s,'GET');};
A.isStandAloneApp=function(){if(sap.ushell_abap){return false;}else{return true;}};
A.getNewAppVariantId=function(){return A._newAppVariantId;};
A.setNewAppVariantId=function(n){A._newAppVariantId=n;};
A.trimIdIfRequired=function(i){if(i.length>H){var I=i.split('.');var t;var g=I[I.length-1].length;var G=I.pop();t=I.join(".");if(t.length>g){t=t.substring(0,t.length-g);}else{return i.substr(0,H);}if(t[t.length-1]==='.'){t=t+G;}else{t=t+"."+G;}return this.trimIdIfRequired(t);}return i;};
A.getId=function(B){var c;var i=B.split('.');if(i[0]!=="customer"){i[0]="customer."+i[0];}var r=false;var d=/^id.*/i;i.forEach(function(s,e,f){if(s.match(d)){s=s.replace(d,u().replace(/-/g,"_"));f[e]=s;r=true;}});c=i.join(".");if(!r){c=c+"."+u().replace(/-/g,"_");}c=this.trimIdIfRequired(c);this.setNewAppVariantId(c);return c;};
A.createDescriptorVariant=function(p){p.layer=F.getCurrentLayer(false);return D.createNew(p);};
A.getInlineChangeInput=function(v,c){return{"type":"XTIT","maxLength":50,"comment":c,"value":{"":v}};};
A.getInlinePropertyChange=function(p,P){var c="New "+p+" entered by a key user via RTA tool";return this.getInlineChangeInput(P,c);};
A.getInlineChangeInputIcon=function(i){return{icon:i};};
A.getInlineChangeRemoveInbounds=function(i){return{"inboundId":i};};
A.getURLParsedHash=function(){var U=sap.ushell.Container.getService("URLParsing");if(U.parseShellHash&&U.getHash){return U.parseShellHash(h.getHash());}};
A.getInboundInfo=function(i){var I={};if(!i){I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;return I;}var p=this.getURLParsedHash();var c=Object.keys(i);var d=[];c.forEach(function(s){if((i[s].action===p.action)&&(i[s].semanticObject===p.semanticObject)){d.push(s);}});switch(d.length){case 0:I.currentRunningInbound="customer.savedAsAppVariant";I.addNewInboundRequired=true;break;case 1:I.currentRunningInbound=d[0];I.addNewInboundRequired=false;break;default:I=undefined;break;}return I;};
A.getInboundPropertiesKey=function(s,c,p){return s+"_sap.app.crossNavigation.inbounds."+c+"."+p;};
A.getInlineChangesForInboundProperties=function(c,s,p,P){var C={"inboundId":c,"entityPropertyChange":{"propertyPath":p,"operation":"UPSERT","propertyValue":{}},"texts":{}};if(p==="title"||p==="subTitle"){var k=this.getInboundPropertiesKey(s,c,p);C.entityPropertyChange.propertyValue="{{"+k+"}}";C.texts[k]=this.getInlinePropertyChange(p,P);}else if(p==="icon"){C.entityPropertyChange.propertyValue=P;}return C;};
A.getInlineChangeForInboundPropertySaveAs=function(c){return{"inboundId":c,"entityPropertyChange":{"propertyPath":"signature/parameters/sap-appvar-id","operation":"UPSERT","propertyValue":{"required":true,"filter":{"value":this.getNewAppVariantId(),"format":"plain"},"launcherValue":{"value":this.getNewAppVariantId()}}}};};
A.getInlineChangeCreateInbound=function(c){var p=this.getURLParsedHash();var P={"inbound":{}};P.inbound[c]={"semanticObject":p.semanticObject,"action":p.action};return P;};
A.createInlineChange=function(p,c){var t;if(c==="title"){return a.create_app_setTitle(p);}else if(c==="description"){return a.create_app_setDescription(p);}else if(c==="subtitle"){return a.create_app_setSubTitle(p);}else if(c==="icon"){return a.create_ui_setIcon(p);}else if(c==="inbound"){return a.create_app_changeInbound(p);}else if(c==="createInbound"){return a.create_app_addNewInbound(p);}else if(c==="inboundTitle"){t=p.texts;delete p.texts;return a.create_app_changeInbound(p,t);}else if(c==="inboundSubtitle"){t=p.texts;delete p.texts;return a.create_app_changeInbound(p,t);}else if(c==="inboundIcon"){delete p.texts;return a.create_app_changeInbound(p);}else if(c==="removeInbound"){return a.create_app_removeAllInboundsExceptOne(p);}};
A.getTransportInput=function(p,n,N,t){return{getPackage:function(){return p;},getNamespace:function(){return n;},getId:function(){return N;},getDefinition:function(){return{fileType:t};}};};
A.triggerCatalogAssignment=function(s,o){var r='/sap/bc/lrep/appdescr_variants/'+s+'?action=assignCatalogs&assignFromAppId='+o;return b.sendRequest(r,'POST');};
A.isS4HanaCloud=function(s){return s.isAtoEnabled()&&s.isAtoAvailable();};
A.copyId=function(i){var t=document.createElement("textarea");t.value=i;document.body.appendChild(t);t.select();document.execCommand('copy');document.body.removeChild(t);return true;};
A.getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};
A.getText=function(m,t){var T=this.getTextResources();return t?T.getText(m,t):T.getText(m);};
A._getErrorMessageText=function(e){var E;if(e.messages&&e.messages.length){E=e.messages.map(function(e){return e.text;}).join("\n");}else if(e.iamAppId){E="IAM App Id: "+e.iamAppId;}else{E=e.stack||e.message||e.status||e;}return E;};
A.buildErrorInfo=function(m,e,s){var E=this._getErrorMessageText(e);var c=A.getText(m)+"\n\n";if(s){c+=A.getText("MSG_APP_VARIANT_ID",s)+"\n";}c+=A.getText("MSG_TECHNICAL_ERROR",E);L.error("App variant error: ",E);return{text:c,appVariantId:s};};
A.showRelevantDialog=function(i,s){var t,r;if(s){t=this.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE_TITLE");r=this.getText("SAVE_APP_VARIANT_OK_TEXT");}else{t=this.getText("HEADER_SAVE_APP_VARIANT_FAILED");r=this.getText("SAVE_APP_VARIANT_CLOSE_TEXT");}var c;var d=[];if(i.copyId){c=this.getText("SAVE_APP_VARIANT_COPY_ID_TEXT");d.push(c);}d.push(r);return new Promise(function(e,f){var C=function(g){if(s&&g===r){e();}else if(s&&g===c){A.copyId(i.appVariantId);e();}else if(i.overviewDialog&&g===r){e(false);}else if(g===r){f();}else if(g===c){A.copyId(i.appVariantId);f();}};M.show(i.text,{icon:s?M.Icon.INFORMATION:M.Icon.ERROR,onClose:C,title:t,actions:d,styleClass:R.getRtaStyleClassName()});});};
A.publishEventBus=function(){sap.ui.getCore().getEventBus().publish("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate");};
A.triggerDeleteAppVariantFromLREP=function(s){return D.createDeletion(s).then(function(o){return o.submit();});};
return A;},true);
sap.ui.predefine('sap/ui/rta/appVariant/Feature',["sap/ui/rta/Utils","sap/ui/fl/Utils","sap/ui/rta/appVariant/AppVariantUtils","sap/m/MessageBox","sap/ui/core/BusyIndicator","sap/ui/thirdparty/jquery","sap/base/util/UriParameters"],function(R,F,A,M,B,q,U){"use strict";var a,o,r,c,C,d;var g=function(){return F.getAppDescriptor(r);};var t=function(e){return o.createDescriptor(e);};var T=function(D){if(D){d=null;B.show();d=q.extend({},D);return o.saveAppVariantToLREP(D);}else{return Promise.reject();}};var f=function(){return o.triggerCatalogAssignment(d);};var b=function(e){if(e&&e.response&&e.response.IAMId){return o.notifyKeyUserWhenTileIsReady(e.response.IAMId,d.getId());}return Promise.resolve();};sap.ui.getCore().getEventBus().subscribe("sap.ui.rta.appVariant.manageApps.controller.ManageApps","navigate",function(){if(a){a.destroy();a=null;}});return{onGetOverview:function(e){var D=g();return new Promise(function(h){var i=function(){A.publishEventBus();};sap.ui.require(["sap/ui/rta/appVariant/AppVariantOverviewDialog"],function(j){if(!a){a=new j({idRunningApp:D["sap.app"].id,isOverviewForKeyUser:e});}a.attachCancel(i);a.oPopup.attachOpened(function(){h(a);});a.open();});});},isOverviewExtended:function(){var u=new U(window.location.href);if(!u.get("sap-ui-xx-app-variant-overview-extended")){return false;}else{var m=u.get("sap-ui-xx-app-variant-overview-extended",true);if(m&&m.length){var s=m[0].toLowerCase();return s==='true';}}},isManifestSupported:function(){var D=g();return A.getManifirstSupport(D["sap.app"].id).then(function(e){return e.response;}).catch(function(e){var E=A.buildErrorInfo("MSG_APP_VARIANT_FEATURE_FAILED",e);E.overviewDialog=true;return A.showRelevantDialog(E,false);});},isPlatFormEnabled:function(e,s,l){r=e;c=l;var D=g();if(D["sap.app"]&&D["sap.app"].id){if(R.getUshellContainer()&&!A.isStandAloneApp()&&s==="CUSTOMER"){var i;if(D["sap.app"].crossNavigation&&D["sap.app"].crossNavigation.inbounds){i=A.getInboundInfo(D["sap.app"].crossNavigation.inbounds);}else{i=A.getInboundInfo();}if(i){return true;}}}return false;},onSaveAsFromRtaToolbar:function(s,e){var D;if(s){D=g();}else{D=q.extend(true,{},C);C=null;}return new Promise(function(h){var p=function(){return o.processSaveAsDialog(D,s);};var i=function(){if(e){return o.copyUnsavedChangesToLREP(d.getId(),e);}return Promise.resolve();};var j=function(k){var u=R.getUshellContainer();if(u&&e){u.setDirtyFlag(false);}return o.showSuccessMessageAndTriggerActionFlow(d,s).then(function(){return b(k).then(h);});};sap.ui.require(["sap/ui/rta/appVariant/AppVariantManager"],function(k){if(!o){o=new k({rootControl:r,commandSerializer:c});}var P=[p,t,T,i,f,j];function l(m){return m.reduce(function(n,u){return n.then(u);},Promise.resolve()).catch(function(){return Promise.resolve(false);});}l(P);});});},onSaveAsFromOverviewDialog:function(e,s){var h=false;var D=g();if(e["sap.app"].id===D["sap.app"].id){h=true;}C=q.extend(true,{},e);e=null;return this.onSaveAsFromRtaToolbar(s,h);}};});
sap.ui.predefine('sap/ui/rta/appVariant/S4HanaCloudBackend',["sap/ui/base/ManagedObject","sap/ui/model/odata/v2/ODataModel"],function(M,O){"use strict";
var S=M.extend("sap.ui.rta.appVariant.S4HanaCloudBackend",{constructor:function(){M.apply(this,arguments);}});
S.prototype.notifyFlpCustomizingIsReady=function(i,I,c,m){var t=this;return new Promise(function(r,a){function b(n){return!isNaN(parseFloat(n))&&isFinite(n);}var d=b(c)?c:2500;var R=b(m)?m:-1;function e(){if(R==0){r({iamAppId:i,flpCustomizingIsReady:false});return;}else if(R>0){R=R-1;}t.checkFlpCustomizingIsReady(i).then(function(f){if(f){r({iamAppId:i,flpCustomizingIsReady:true});I(i);}else{setTimeout(e.bind(t),d);}}).catch(function(){a({iamAppId:i});});}setTimeout(e.bind(t),d);});};
S._evaluateAppIntegrityEstimation=function(a){var m=(a&&a.AppStatusTable&&JSON.parse(a.AppStatusTable)&&JSON.parse(a.AppStatusTable).ITAB);if(!Array.isArray(m)){throw("Error: /sap/opu/odata/sap/APS_IAM_APP_SRV/checkAppIntegrity() returned unexpected result"+"for IAM app ID "+a.AppID);}var c=m.filter(function(o){return(o.TYPE=='W'&&o.ID=="CM_APS_IAM_APP"&&o.NUMBER=="057");}).length>=1;var C=m.filter(function(o){return(o.TYPE=='E'&&o.ID=="CM_APS_IAM_APP"&&o.NUMBER=="058");}).length>=1;var e=m.filter(function(o){return(o.TYPE=='E');}).length>=1;if((e&&!c)||C){throw("Error: Tile generation for app variant with IAM app ID "+a.AppID+" failed");}return(!c&&!e&&!a.AppStatus);};
S.prototype.checkFlpCustomizingIsReady=function(i){return new Promise(function(r,a){var m=new O("/sap/opu/odata/sap/APS_IAM_APP_SRV");m.attachMetadataFailed(function(e){a(e);});m.metadataLoaded().then(function(){m.callFunction("/checkAppIntegrity",{method:"POST",urlParameters:{AppID:i},error:a,success:r});});}).then(S._evaluateAppIntegrityEstimation);};
return S;});
sap.ui.predefine('sap/ui/rta/appVariant/Utils',["sap/ui/fl/LrepConnector","sap/ui/rta/appVariant/AppVariantUtils","sap/base/i18n/ResourceBundle"],function(L,A,R){"use strict";var U={};var m=sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")+"webapp";var i=R.create({url:m+"/i18n/i18n.properties"});
U.sendRequest=function(r,o){var l=L.createConnector();return l.send(r,o);};
U.getAppVariantOverviewAttributes=function(a,k){var o;var c=function(){if(a.isOriginal&&a.isAppVariant){return i.getText("MAA_ORIGINAL_TYPE");}else if(a.isAppVariant){return i.getText("MAA_APP_VARIANT_TYPE");}else if(a.isOriginal){return i.getText("MAA_ORIGINAL_TYPE");}};var f=function(N){var b=sap.ushell.Container.getService("CrossApplicationNavigation");return b.getLinks(N);};var g=function(o){if(a.hasStartableIntent){var s=a.startWith.semanticObject;var b=a.startWith.action;var p=a.startWith.parameters;var N={semanticObject:s,action:b,params:p};return f(N).then(function(r){if(r.length&&k){o.adaptUIButtonVisibility=true;}else{o.adaptUIButtonVisibility=false;}o.semanticObject=s;o.action=b;if(p){Object.keys(p).forEach(function(P){if(p[P].value){p[P]=p[P].value;}});o.params=p;}return Promise.resolve(o);});}else{o.adaptUIButtonVisibility=false;return Promise.resolve(o);}};var I=a.iconUrl;if(I&&sap.ui.core.IconPool.isIconURI(I)){a.iconText=I.split('//')[1];}o={appId:a.appId,title:a.title||'',subTitle:a.subTitle||'',description:a.description||'',icon:a.iconUrl||'',iconText:a.iconText,isOriginal:a.isOriginal,typeOfApp:c(),descriptorUrl:a.descriptorUrl,isKeyUser:k};var n=A.getNewAppVariantId();if(n===a.appId){o.currentStatus=i.getText("MAA_NEW_APP_VARIANT");}return g(o);};
U.getAppVariantOverview=function(r,k){var l=k?'CUSTOMER*':'VENDOR';var s='/sap/bc/lrep/app_variant_overview/?sap.app/id='+r+'&layer='+l;return this.sendRequest(s,'GET').then(function(o){var a=[];var b;if(o.response&&o.response.items){b=o.response.items;}else{return Promise.resolve([]);}b.forEach(function(c){if(!c.isDescriptorVariant){a.push(this.getAppVariantOverviewAttributes(c,k));}},this);return Promise.all(a).then(function(c){return c;});}.bind(this));};
U.getDescriptor=function(d){return this.sendRequest(d,'GET').then(function(r){return r.response;});};
return U;},true);
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/Component',["sap/ui/core/UIComponent"],function(U){"use strict";var _,a;return U.extend("sap.ui.rta.appVariant.manageApps.webapp.Component",{metadata:{"manifest":"json","library":"sap.ui.rta","version":"0.9","properties":{"idRunningApp":"string",isOverviewForKeyUser:{type:"boolean"}}},constructor:function(){_=arguments[1].idRunningApp;a=arguments[1].isOverviewForKeyUser;U.prototype.constructor.apply(this,arguments);},init:function(){this.setIdRunningApp(_);this.setIsOverviewForKeyUser(a);U.prototype.init.apply(this,arguments);}});});
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/controller/ManageApps.controller',["sap/ui/core/mvc/Controller","sap/ui/rta/appVariant/manageApps/webapp/model/models","sap/ui/rta/appVariant/Utils","sap/m/MessageBox","sap/ui/rta/Utils","sap/ui/rta/appVariant/Feature","sap/ui/rta/RuntimeAuthoring","sap/ui/core/BusyIndicator","sap/ui/rta/appVariant/AppVariantUtils","sap/base/i18n/ResourceBundle"],function(C,M,A,a,R,b,c,B,d,e){"use strict";var _,f,m,i;return C.extend("sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps",{onInit:function(){_=this.getOwnerComponent().getIdRunningApp();f=this.getOwnerComponent().getIsOverviewForKeyUser();m=sap.ui.require.toUrl("sap/ui/rta/appVariant/manageApps/")+"webapp";i=e.create({url:m+"/i18n/i18n.properties"});B.show();return A.getAppVariantOverview(_,f).then(function(g){B.hide();if(g.length){return this._arrangeOverviewDataAndBindToModel(g).then(function(g){return this._highlightNewCreatedAppVariant(g);}.bind(this));}else{d.publishEventBus();return this._showMessageWhenNoAppVariantsExist();}}.bind(this))["catch"](function(E){d.publishEventBus();var o=d.buildErrorInfo("MSG_MANAGE_APPS_FAILED",E);o.overviewDialog=true;B.hide();return d.showRelevantDialog(o,false);});},_showMessageWhenNoAppVariantsExist:function(){var s=i.getText("MSG_APP_VARIANT_OVERVIEW_SAP_DEVELOPER");var t=i.getText("TITLE_APP_VARIANT_OVERVIEW_SAP_DEVELOPER");return new Promise(function(r){a.show(s,{icon:a.Icon.INFORMATION,title:t,onClose:r,styleClass:R.getRtaStyleClassName()});});},_highlightNewCreatedAppVariant:function(g){var t=this.byId("Table1");g.forEach(function(o,h){if(o.currentStatus){if(t.getItems().length>=h){t.getItems()[h].focus();}}});return Promise.resolve();},_arrangeOverviewDataAndBindToModel:function(g){var h=g.filter(function(n){return n.appId===_;});var o=h[0];if(o){o.currentStatus=i.getText("MAA_CURRENTLY_ADAPTING");}g=g.filter(function(n){return n.appId!==_;});g.unshift(o);var r=g.filter(function(n){return n.isOriginal;});var j=r[0];g=g.filter(function(n){return!n.isOriginal;});g.unshift(j);var k={appVariants:g};var l=M.createModel(k);this.getView().setModel(l);return Promise.resolve(g);},formatRowHighlight:function(v){if(v===i.getText("MAA_CURRENTLY_ADAPTING")){return"Success";}else if(v===i.getText("MAA_NEW_APP_VARIANT")){return"Information";}return"None";},getModelProperty:function(s,g){return this.getView().getModel().getProperty(s,g);},handleUiAdaptation:function(E){var n=sap.ushell.Container.getService("CrossApplicationNavigation");var s=this.getModelProperty("semanticObject",E.getSource().getBindingContext());var g=this.getModelProperty("action",E.getSource().getBindingContext());var p=this.getModelProperty("params",E.getSource().getBindingContext());var N;if(s&&g&&p){N={target:{semanticObject:s,action:g},params:p};c.enableRestart("CUSTOMER");n.toExternal(N);d.publishEventBus();return true;}else{return false;}},saveAsAppVariant:function(E){d.publishEventBus();var D=this.getModelProperty("descriptorUrl",E.getSource().getBindingContext());B.show();return A.getDescriptor(D).then(function(o){B.hide();return b.onSaveAsFromOverviewDialog(o,false);});},copyId:function(E){var s=this.getModelProperty("appId",E.getSource().getBindingContext());d.copyId(s);}});});
sap.ui.predefine('sap/ui/rta/appVariant/manageApps/webapp/model/models',["sap/ui/model/json/JSONModel"],function(J){"use strict";return{createModel:function(d){var m=new J(d);m.setDefaultBindingMode("OneWay");return m;}};});
sap.ui.predefine('sap/ui/rta/command/AddODataProperty',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var A=F.extend("sap.ui.rta.command.AddODataProperty",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int"},newControlId:{type:"string"},bindingString:{type:"string"},entityType:{type:"string"},parentId:{type:"string"},oDataServiceVersion:{type:"string"},oDataServiceUri:{type:"string"},propertyName:{type:"string"}}}});
A.prototype._getChangeSpecificData=function(){return{changeType:this.getChangeType(),index:this.getIndex(),newControlId:this.getNewControlId(),bindingPath:this.getBindingString(),parentId:this.getParentId(),oDataServiceVersion:this.getODataServiceVersion(),oDataInformation:{oDataServiceUri:this.getODataServiceUri(),propertyName:this.getPropertyName(),entityType:this.getEntityType()}};};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AddXML',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var A=F.extend("sap.ui.rta.command.AddXML",{metadata:{library:"sap.ui.rta",properties:{fragment:{type:"string"},fragmentPath:{type:"string"},targetAggregation:{type:"string"},index:{type:"int"},changeType:{type:"string",defaultValue:"addXML"}},associations:{},events:{}}});
A.prototype.bindProperty=function(n,b){if(n==="fragment"){return this.setFragment(b.bindingString);}return F.prototype.bindProperty.apply(this,arguments);};
A.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType(),fragmentPath:this.getFragmentPath(),targetAggregation:this.getTargetAggregation(),index:this.getIndex()};return s;};
A.prototype._applyChange=function(c){var m={};m[c.getModuleName()]=this.getFragment();sap.ui.require.preload(m);return F.prototype._applyChange.apply(this,arguments);};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/AppDescriptorCommand',['sap/ui/rta/command/BaseCommand','sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory','sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory'],function(B,D,a){"use strict";
var A=B.extend("sap.ui.rta.command.AppDescriptor",{metadata:{library:"sap.ui.rta",properties:{reference:{type:"string"},appComponent:{type:"object"},layer:{type:"string"},changeType:{type:"string"},parameters:{type:"object"},texts:{type:"object"}},events:{}}});
A.prototype.needsReload=true;
A.prototype.prepare=function(f){this.setLayer(f.layer);return true;};
A.prototype.getPreparedChange=function(){return this._oPreparedChange;};
A.prototype.createAndStoreChange=function(){return D.createDescriptorInlineChange(this.getChangeType(),this.getParameters(),this.getTexts()).then(function(o){return new a().createNew(this.getReference(),o,this.getLayer(),this.getAppComponent());}.bind(this)).then(function(o){var c=o.store();this._oPreparedChange=c;}.bind(this));};
return A;},true);
sap.ui.predefine('sap/ui/rta/command/BaseCommand',['sap/ui/base/ManagedObject'],function(M){"use strict";
var B=M.extend("sap.ui.rta.command.BaseCommand",{metadata:{library:"sap.ui.rta",properties:{name:{type:"string"},runtimeOnly:{type:"boolean"}},associations:{element:{type:"sap.ui.core.Element"}},events:{}}});
B.prototype.getElement=function(){var i=this.getAssociation("element");return sap.ui.getCore().byId(i);};
B.prototype.prepare=function(){return true;};
B.prototype.execute=function(){return Promise.resolve();};
B.prototype.getVariantChange=function(){return this._oVariantChange;};
B.prototype.undo=function(){return Promise.resolve();};
B.prototype.isEnabled=function(){return true;};
return B;},true);
sap.ui.predefine('sap/ui/rta/command/BindProperty',['sap/ui/rta/command/FlexCommand',"sap/ui/rta/Utils"],function(F,U){"use strict";
var B=F.extend("sap.ui.rta.command.BindProperty",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string"},newBinding:{type:"string"},changeType:{type:"string",defaultValue:"propertyBindingChange"}},associations:{},events:{}}});
B.prototype.bindProperty=function(n,b){if(n==="newBinding"){return this.setNewBinding(b.bindingString);}return F.prototype.bindProperty.apply(this,arguments);};
B.prototype._getChangeSpecificData=function(){var e=this.getElement();var s={changeType:this.getChangeType(),selector:{id:e.getId(),type:e.getMetadata().getName()},content:{property:this.getPropertyName(),newBinding:this.getNewBinding()}};return s;};
return B;},true);
sap.ui.predefine('sap/ui/rta/command/Combine',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var C=F.extend("sap.ui.rta.command.Combine",{metadata:{library:"sap.ui.rta",properties:{source:{type:"any"},combineFields:{type:"any[]"}},associations:{},events:{}}});
C.prototype._getChangeSpecificData=function(){var f=[];this.getCombineFields().forEach(function(o){f.push(o.getId());});var s={changeType:this.getChangeType(),sourceControlId:this.getSource().getId(),combineFieldIds:f};return s;};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/CommandFactory',['sap/ui/base/ManagedObject','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/OverlayRegistry','sap/ui/fl/Utils','sap/ui/dt/Util','sap/base/util/merge','sap/ui/rta/command/AppDescriptorCommand'],function(M,E,O,a,F,D,m,A){"use strict";
function e(x,y){var B=O.getAggregationInformation(x);if(B.elementId){var z=a.getOverlay(B.elementId);var P=z.getParentElementOverlay();var G=P?O.isInAggregationBinding(P,P.sParentAggregationName):false;if(G){throw D.createError("CommandFactory#evaluateTemplateBinding","Multiple template bindings are not supported","sap.ui.rta");}var T=E.extractTemplateId(B);if(T){return{templateSelector:B.elementId,originalSelector:T,content:{boundAggregation:B.aggregation}};}}return undefined;}
function g(x){var y=(typeof x==="string")?sap.ui.getCore().byId(x):x;var z=a.getOverlay(y);if(z){var B=O.getAggregationInformation(z);return E.extractTemplateId(B);}else{return y.getId();}}
function b(x){if(!x){throw new Error("adjustment for template failed");}}
function c(x,y,z){var B;var J=false;if(typeof(z)==="string"){B=z;}else{B=z&&z.changeType;J=z&&z.jsOnly;}if(!B){return false;}y.setChangeType(B);y.setJsOnly(J);return true;}
function d(x,S,y){var z={changeType:"addXML"};if(y){jQuery.extend(z,y.getAction("addXML",x));}return z;}
function f(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);}
function h(x,S,y){var N=S.element||sap.ui.getCore().byId(S.element.id);var z=y.getActionDataFromAggregations("createContainer",N)[0];return z;}
function i(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);S.parentId=g(S.parentId);b(S.parentId);}
function j(x,S,y){var z=S.movedElements[0].element||sap.ui.getCore().byId(S.movedElements[0].id);var B=y.getAction("move",z);if(!B&&y.getMetadata().getName()==="sap.ui.dt.ElementDesignTimeMetadata"){B=y.getActionDataFromAggregations("move",x).filter(function(G){return G.aggregation===S.source.aggregation;})[0];}return B;}
function k(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);S.source.parent=sap.ui.getCore().byId(g(S.source.parent));b(S.source.parent);S.target.parent=sap.ui.getCore().byId(g(S.target.parent));b(S.target.parent);S.movedElements.forEach(function(x){x.element=sap.ui.getCore().byId(g(x.element));b(x.element);});}
function l(x,S,y){var R=S.renamedElement;var z=y.getAction("rename",R);return z;}
function n(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);S.renamedElement=sap.ui.getCore().byId(g(S.renamedElement));b(S.renamedElement);}
function o(x,S,y){var R=S.removedElement;if(!R){R=x;}else if(!(R instanceof M)){throw new Error("No valid 'removedElement' found");}var z=y.getAction("remove",R);return z;}
function p(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);S.removedElement=sap.ui.getCore().byId(g(S.removedElement));b(S.removedElement);}
function q(x,S,y){var z=S.source;var B=y.getAction("combine",z);return B;}
function r(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);S.source=sap.ui.getCore().byId(g(S.source));b(S.source);S.combineFields.forEach(function(x){x=sap.ui.getCore().byId(g(x));b(x);});}
function s(x,S,y){var z=S.source;var B=y.getAction("split",z);return B;}
function t(S){S.element=sap.ui.getCore().byId(g(S.element));b(S.element);S.parentElement=sap.ui.getCore().byId(g(S.parentElement));b(S.parentElement);S.source=sap.ui.getCore().byId(g(S.source));b(S.source);}
function u(x,S,y){var N=S.element;var z=y.getAction("addODataProperty",N);return z;}
function v(x,S,y){var R=S.element;var z=y.getAction("reveal",R);return z;}
var C={"composite":{clazz:'sap.ui.rta.command.CompositeCommand'},"property":{clazz:'sap.ui.rta.command.Property'},"bindProperty":{clazz:'sap.ui.rta.command.BindProperty'},"addXML":{clazz:'sap.ui.rta.command.AddXML',configure:d,adjustForBinding:f},"createContainer":{clazz:'sap.ui.rta.command.CreateContainer',configure:h,adjustForBinding:i},"move":{clazz:'sap.ui.rta.command.Move',configure:j,adjustForBinding:k},"remove":{clazz:'sap.ui.rta.command.Remove',configure:o,adjustForBinding:p},"rename":{clazz:'sap.ui.rta.command.Rename',configure:l,adjustForBinding:n},"addODataProperty":{clazz:'sap.ui.rta.command.AddODataProperty',configure:u},"reveal":{clazz:'sap.ui.rta.command.Reveal',configure:v},"combine":{clazz:'sap.ui.rta.command.Combine',configure:q,adjustForBinding:r},"split":{clazz:'sap.ui.rta.command.Split',configure:s,adjustForBinding:t},"switch":{clazz:'sap.ui.rta.command.ControlVariantSwitch'},"duplicate":{clazz:'sap.ui.rta.command.ControlVariantDuplicate'},"setTitle":{clazz:'sap.ui.rta.command.ControlVariantSetTitle'},"configure":{clazz:'sap.ui.rta.command.ControlVariantConfigure'},"settings":{clazz:'sap.ui.rta.command.Settings'},"addLibrary":{clazz:'sap.ui.rta.command.appDescriptor.AddLibrary'},"appDescriptor":{clazz:'sap.ui.rta.command.AppDescriptorCommand'}};
function _(x,y,S,z,B,V){y=y[0].toLowerCase()+y.slice(1);var G=C[y];var H=B;if(!G){return Promise.reject(D.createError("CommandFactory#_getCommandFor","Command '"+y+"' doesn't exist, check typing","sap.ui.rta"));}return new Promise(function(R){var I=G.clazz;sap.ui.require([I.replace(/\./g,"/")],function(J){R(J);});}).then(function(I){var J,K,P,L,T;var N=x instanceof M;if(y!=="appDescriptor"&&y!=="composite"){S=Object.assign({},S,{selector:N?null:x});}S=Object.assign({},S,{element:N?x:undefined,name:y});if(G.configure){J=G.configure(x,S,z);}if(N){K=a.getOverlay(x);}if(J&&J.changeOnRelevantContainer){Object.assign(S,{element:K.getRelevantContainer()});x=S.element;}if(K&&x.sParentAggregationName){T=e(K,x);}if(T){if(G.adjustForBinding){G.adjustForBinding(S);}H=m(T,H);}L=new I(S);var Q=true;if(G.configure){Q=c(x,L,J);}P=Q&&L.prepare(H,V);if(P){return L;}else{L.destroy();return undefined;}});}
var w=M.extend("sap.ui.rta.command.CommandFactory",{metadata:{library:"sap.ui.rta",properties:{"flexSettings":{type:"object"}},associations:{},events:{}}});
w.prototype.init=function(){this.setProperty("flexSettings",{layer:"CUSTOMER",developerMode:true});};
w.prototype.setFlexSettings=function(x){this.setProperty("flexSettings",jQuery.extend(this.getFlexSettings(),x));};
w.prototype.getCommandFor=function(x,y,S,z,V){return _(x,y,S,z,this.getFlexSettings(),V);};
w.getCommandFor=function(x,y,S,z,B){if(!B){B={layer:"CUSTOMER",developerMode:true};}if(B.scenario||B.baseId){var L=F.buildLrepRootNamespace(B.baseId,B.scenario,B.projectId);B.rootNamespace=L;B.namespace=L+"changes/";}return _(x,y,S,z,B);};
return w;},true);
sap.ui.predefine('sap/ui/rta/command/CompositeCommand',['sap/ui/rta/command/BaseCommand','sap/ui/fl/Utils'],function(B,F){"use strict";
var C=B.extend("sap.ui.rta.command.CompositeCommand",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{}}});
C.prototype.execute=function(){var p=[];this._forEachCommand(function(c){p.push(c.execute.bind(c));});return F.execPromiseQueueSequentially(p,true).catch(function(e){var c=this.getCommands();c.forEach(function(o){if(o instanceof sap.ui.rta.command.FlexCommand){if(!o._aRecordedUndo){this.removeCommand(o);}}}.bind(this));return this.undo().then(function(){return Promise.reject(e);});}.bind(this));};
C.prototype.undo=function(){var p=[];this._forEachCommandInReverseOrder(function(c){p.push(c.undo.bind(c));});return F.execPromiseQueueSequentially(p);};
C.prototype._forEachCommand=function(d){var c=this.getCommands();c.forEach(d,this);};
C.prototype._forEachCommandInReverseOrder=function(d){var c=this.getCommands();for(var i=c.length-1;i>=0;i--){d.call(this,c[i]);}};
C.prototype._addCompositeIdToChange=function(c){if(c.getPreparedChange&&c.getPreparedChange()){var o=c.getPreparedChange().getDefinition();if(!o.support.compositeCommand){if(!this._sCompositeId){this._sCompositeId=F.createDefaultFileName("composite");}o.support.compositeCommand=this._sCompositeId;}}};
C.prototype.addCommand=function(c,s){this._addCompositeIdToChange(c);return this.addAggregation("commands",c,s);};
C.prototype.insertCommand=function(c,i,s){this._addCompositeIdToChange(c);return this.insertAggregation("commands",c,i,s);};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/ControlVariantConfigure',['sap/ui/rta/command/BaseCommand','sap/ui/core/util/reflection/JsControlTreeModifier','sap/ui/fl/Utils'],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantConfigure",{metadata:{library:"sap.ui.rta",properties:{control:{type:"any"},changes:{type:"array"}},associations:{},events:{}}});
C.prototype.MODEL_NAME="$FlexVariants";
C.prototype.prepare=function(F,v){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined;}return this._aPreparedChanges;};
C.prototype.execute=function(){var v=this.getControl();this.oAppComponent=f.getAppComponentForControl(v);this.oModel=this.oAppComponent.getModel(this.MODEL_NAME);this.sVariantManagementReference=J.getSelector(v,this.oAppComponent).id;this._aPreparedChanges=[];this.getChanges().forEach(function(c){c.appComponent=this.oAppComponent;this._aPreparedChanges.push(this.oModel.setVariantProperties(this.sVariantManagementReference,c,true));}.bind(this));return Promise.resolve().then(function(){this.oModel.checkUpdate(true);}.bind(this));};
C.prototype.undo=function(){var p;this.getChanges().forEach(function(c,i){p={};Object.keys(c).forEach(function(P){var o="original"+P.charAt(0).toUpperCase()+P.substr(1);if(P==="visible"){p[P]=true;}else if(c[o]){p[P]=c[o];p[o]=c[P];}else if(P.indexOf("original")===-1){p[P]=c[P];}});p.change=this._aPreparedChanges[i];this.oModel.setVariantProperties(this.sVariantManagementReference,p,false);}.bind(this));return Promise.resolve().then(function(){this.oModel.checkUpdate(true);this._aPreparedChanges=null;}.bind(this));};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/ControlVariantDuplicate',['sap/ui/rta/command/BaseCommand','sap/ui/core/util/reflection/JsControlTreeModifier','sap/ui/fl/Utils'],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantDuplicate",{metadata:{library:"sap.ui.rta",properties:{sourceVariantReference:{type:"string"},newVariantReference:{type:"string"},newVariantTitle:{type:"string"}},associations:{},events:{}}});
C.prototype.MODEL_NAME="$FlexVariants";
C.prototype.prepare=function(F,v){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){if(!this._aPreparedChanges){return undefined;}return this._aPreparedChanges;};
C.prototype.execute=function(){var v=this.getElement(),s=this.getSourceVariantReference(),n=this.getNewVariantReference();this.oAppComponent=f.getAppComponentForControl(v);if(!n){n=f.createDefaultFileName("Copy");this.setNewVariantReference(n);}this.sVariantManagementReference=J.getSelector(v,this.oAppComponent).id;this.oModel=this.oAppComponent.getModel(this.MODEL_NAME);var p={variantManagementReference:this.sVariantManagementReference,appComponent:this.oAppComponent,layer:this.sLayer,newVariantReference:n,sourceVariantReference:s,title:this.getNewVariantTitle()};return this.oModel._copyVariant(p).then(function(c){this._oVariantChange=c[0];this._aPreparedChanges=c;}.bind(this));};
C.prototype.undo=function(){if(this._oVariantChange){var p={variant:this._oVariantChange,sourceVariantReference:this.getSourceVariantReference(),variantManagementReference:this.sVariantManagementReference,component:this.oAppComponent};return this.oModel.removeVariant(p).then(function(){this._oVariantChange=null;this._aPreparedChanges=null;}.bind(this));}};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/ControlVariantSetTitle',['sap/ui/rta/command/BaseCommand','sap/ui/core/util/reflection/JsControlTreeModifier','sap/ui/fl/Utils'],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantSetTitle",{metadata:{library:"sap.ui.rta",properties:{oldText:{type:"string"},newText:{type:"string"}},associations:{},events:{}}});
C.prototype.MODEL_NAME="$FlexVariants";
C.prototype.prepare=function(F,v){this.sLayer=F.layer;return true;};
C.prototype.getPreparedChange=function(){this._oPreparedChange=this.getVariantChange();if(!this._oPreparedChange){return undefined;}return this._oPreparedChange;};
C.prototype.execute=function(){var v=this.getElement(),V=v.getTitle().getBinding("text");this.oAppComponent=f.getAppComponentForControl(v);this.oModel=this.oAppComponent.getModel(this.MODEL_NAME);this.sVariantManagementReference=J.getSelector(v,this.oAppComponent).id;this.sCurrentVariant=this.oModel.getCurrentVariantReference(this.sVariantManagementReference);var c=this.oModel.getVariantProperty(this.sCurrentVariant,"title");this.setOldText(c);var p={appComponent:this.oAppComponent,variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getNewText(),layer:this.sLayer};return Promise.resolve(this.oModel.setVariantProperties(this.sVariantManagementReference,p,true)).then(function(o){this._oVariantChange=o;V.checkUpdate(true);}.bind(this));};
C.prototype.undo=function(){var v=this.getElement().getTitle().getBinding("text"),p={variantReference:this.sCurrentVariant,changeType:"setTitle",title:this.getOldText(),change:this._oVariantChange};return Promise.resolve(this.oModel.setVariantProperties(this.sVariantManagementReference,p,false)).then(function(c){this._oVariantChange=c;v.checkUpdate(true);}.bind(this));};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/ControlVariantSwitch',['sap/ui/rta/command/BaseCommand','sap/ui/core/util/reflection/JsControlTreeModifier','sap/ui/fl/Utils'],function(B,J,f){"use strict";
var C=B.extend("sap.ui.rta.command.ControlVariantSwitch",{metadata:{library:"sap.ui.rta",properties:{targetVariantReference:{type:"string"},sourceVariantReference:{type:"string"}},associations:{},events:{}}});
C.prototype.MODEL_NAME="$FlexVariants";
C.prototype._getAppComponent=function(){var e=this.getElement();return e?f.getAppComponentForControl(e):this.getSelector().appComponent;};
C.prototype.execute=function(){var e=this.getElement(),a=this._getAppComponent(),n=this.getTargetVariantReference();this.oModel=a.getModel(this.MODEL_NAME);this.sVariantManagementReference=J.getSelector(e,a).id;return this._updateModelVariant(n,a);};
C.prototype.undo=function(){var o=this.getSourceVariantReference();var a=this._getAppComponent();return this._updateModelVariant(o,a);};
C.prototype._updateModelVariant=function(v,a){if(this.getTargetVariantReference()!==this.getSourceVariantReference()){return Promise.resolve(this.oModel.updateCurrentVariant(this.sVariantManagementReference,v,a));}return Promise.resolve();};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/CreateContainer',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var C=F.extend("sap.ui.rta.command.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{index:{type:"int"},newControlId:{type:"string"},label:{type:"string"},parentId:{type:"string"}},associations:{},events:{}}});
C.prototype._getChangeSpecificData=function(f){var s={changeType:this.getChangeType(),index:this.getIndex(),newControlId:this.getNewControlId(),newLabel:this.getLabel(),parentId:this.getParentId()};return s;};
return C;},true);
sap.ui.predefine('sap/ui/rta/command/FlexCommand',["sap/ui/rta/command/BaseCommand","sap/ui/rta/ControlTreeModifier","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Utils","sap/base/Log","sap/base/util/merge"],function(B,R,J,F,a,L,m){"use strict";
var b=B.extend("sap.ui.rta.command.FlexCommand",{metadata:{library:"sap.ui.rta",properties:{changeType:{type:"string"},jsOnly:{type:"boolean"},selector:{type:"object"}},associations:{},events:{}}});
b.prototype.getElementId=function(){var e=this.getElement();return e?e.getId():this.getSelector().id;};
b.prototype.getAppComponent=function(){var e=this.getElement();return e?a.getAppComponentForControl(e):this.getSelector().appComponent;};
b.prototype.prepare=function(f,v){if(!this.getSelector()&&f&&f.templateSelector){var s={id:f.templateSelector,appComponent:this.getAppComponent(),controlType:a.getControlType(sap.ui.getCore().byId(f.templateSelector))};this.setSelector(s);}else if(!this.getSelector()&&this.getElement()){var s={id:this.getElement().getId(),appComponent:this.getAppComponent(),controlType:a.getControlType(this.getElement())};this.setSelector(s);}try{this._oPreparedChange=this._createChange(f,v);}catch(e){L.error(e.message||e.name);return false;}return true;};
b.prototype.getPreparedChange=function(){if(!this._oPreparedChange){this.prepare();}return this._oPreparedChange;};
b.prototype.execute=function(){var c=this.getPreparedChange();return this._applyChange(c);};
b.prototype._getChangeSpecificData=function(){return{changeType:this.getChangeType(),selector:{id:this.getElementId()}};};
b.prototype._createChange=function(f,v){return this._createChangeFromData(this._getChangeSpecificData(),f,v);};
b.prototype._createChangeFromData=function(c,f,v){if(f){c=m({},c,f);}c.jsOnly=this.getJsOnly();var M=this.getAppComponent().getModel("$FlexVariants");var V;if(M&&v){V=M.getCurrentVariantReference(v);}var o=F.createForControl(this.getAppComponent());var d={"variantManagementReference":v,"variantReference":V};if(V){c=Object.assign({},c,d);}var C=o.createChange(c,this._validateControlForChange(f));if(f&&f.originalSelector){C.addDependentControl(f.originalSelector,"originalSelector",{modifier:J,appComponent:this.getAppComponent()});C.getDefinition().selector=J.getSelector(this.getSelector().id,this.getSelector().appComponent);C.setContent(Object.assign({},C.getContent(),f.content));}return C;};
b.prototype.undo=function(){return Promise.resolve().then(function(){var c=this.getElement()||this.getSelector();var C=this.getPreparedChange();if(C.getRevertData()){var f=F.createForControl(this.getAppComponent());var r=f.isChangeHandlerRevertible(C,c);if(!r){L.error("No revert change function available to handle revert data for "+c);return;}return f.revertChangesOnControl([C],this.getAppComponent(true));}else if(this._aRecordedUndo){R.performUndo(this._aRecordedUndo);}else{L.warning("Undo is not available for "+c);}}.bind(this));};
b.prototype._applyChange=function(c,n){var C=c.change||c;var A=this.getAppComponent();var s=R.bySelector(C.getSelector(),A);var f=F.createForControl(A);var d=f._getControlIfTemplateAffected(C,s,s.getMetadata().getName(),{modifier:J,appComponent:A});var r=f.isChangeHandlerRevertible(C,d.control);var p={modifier:r?J:R,appComponent:A,view:a.getViewForControl(s)};if(!r){R.startRecordingUndo();}return Promise.resolve().then(function(){if(f.checkForOpenDependenciesForControl(C.getSelector(),p.modifier,A)){throw Error("The following Change cannot be applied because of a dependency: "+C.getId());}}).then(function(){return f.checkTargetAndApplyChange(C,s,p);}).then(function(o){if(o.success){if(n){f.removeFromAppliedChangesOnControl(C,A,s);}}return o;}).then(function(o){if(!r){if(!C.getUndoOperations()){this._aRecordedUndo=R.stopRecordingUndo();}else{this._aRecordedUndo=C.getUndoOperations();C.resetUndoOperations();}}if(!o.success){return Promise.reject(o.error);}}.bind(this));};
b.prototype._validateControlForChange=function(f){if(f&&f.originalSelector&&f.content&&f.content.boundAggregation){return{id:f.originalSelector,appComponent:this.getAppComponent(),controlType:a.getControlType(sap.ui.getCore().byId(f.originalSelector))};}else{return this.getElement()||this.getSelector();}};
return b;},true);
sap.ui.predefine('sap/ui/rta/command/LREPSerializer',['sap/ui/base/ManagedObject','sap/ui/rta/command/FlexCommand','sap/ui/rta/command/AppDescriptorCommand','sap/ui/fl/FlexControllerFactory','sap/ui/fl/Utils','sap/ui/fl/Change','sap/ui/rta/ControlTreeModifier','sap/ui/fl/registry/Settings','sap/ui/dt/ElementUtil',"sap/base/Log"],function(M,F,A,a,b,C,R,S,E,L){"use strict";
var c=M.extend("sap.ui.rta.command.LREPSerializer",{metadata:{library:"sap.ui.rta",associations:{"rootControl":{type:"sap.ui.core.Control"}},properties:{"commandStack":{type:"object"}},aggregations:{}}});
function g(r){return E.getElementInstance(r);}
c.prototype._lastPromise=Promise.resolve();
c.prototype.setCommandStack=function(o){if(this.getCommandStack()){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);}this.setProperty("commandStack",o);o.addCommandExecutionHandler(this._fnHandleCommandExecuted);};
c.prototype.init=function(){this._fnHandleCommandExecuted=this.handleCommandExecuted.bind(this);};
c.prototype.exit=function(){this.getCommandStack().removeCommandExecutionHandler(this._fnHandleCommandExecuted);};
c.prototype._isPersistedChange=function(p){return!!this.getCommandStack()._aPersistedChanges&&this.getCommandStack()._aPersistedChanges.indexOf(p.getId())!==-1;};
c.prototype.handleCommandExecuted=function(e){return(function(e){var p=e;this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var d=this.getCommandStack().getSubCommands(p.command);var f;if(p.undo){d.forEach(function(o){if(!(o instanceof F||o instanceof A)||o.getRuntimeOnly()){return;}var h=o.getPreparedChange();var i=o.getAppComponent();if(i){if(o instanceof F){f=a.createForControl(i);var j=R.bySelector(h.getSelector(),i);f.removeFromAppliedChangesOnControl(h,i,j);}else if(o instanceof A){f=this._getAppDescriptorFlexController(i);}f.deleteChange(h,i);}}.bind(this));}else{var D=[];d.forEach(function(o){if(o.getRuntimeOnly()){return;}if(o instanceof F){var h=o.getAppComponent(true);if(h){var f=a.createForControl(h);var P=o.getPreparedChange();if(P.getState()===C.states.DELETED){P.setState(C.states.NEW);}if(!this._isPersistedChange(P)){f.addPreparedChange(o.getPreparedChange(),h);}}}else if(o instanceof A){D.push(o.createAndStoreChange());}}.bind(this));return Promise.all(D);}}.bind(this));return this._lastPromise;}.bind(this))(e);};
c.prototype.needsReload=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var d=this.getCommandStack().getAllExecutedCommands();return d.some(function(o){return!!o.needsReload;});}.bind(this));return this._lastPromise;};
c.prototype.saveCommands=function(){this._lastPromise=this._lastPromise.catch(function(){}).then(function(){var r=g(this.getRootControl());if(!r){throw new Error("Can't save commands without root control instance!");}var f=a.createForControl(r);return f.saveAll();}.bind(this)).then(function(){var r=g(this.getRootControl());var f=this._getAppDescriptorFlexController(r);return f.saveAll();}.bind(this)).then(function(){L.info("UI adaptation successfully transfered changes to layered repository");this.getCommandStack().removeAllCommands();}.bind(this));return this._lastPromise;};
c.prototype._getAppDescriptorFlexController=function(o){var d=b.getAppComponentForControl(o);var s=b.getComponentClassName(d).replace(".Component","");var e=b.getAppVersionFromManifest(d.getManifest());return a.create(s,e);};
c.prototype._moveChangeToAppVariant=function(r,f){return S.getInstance().then(function(s){var p={reference:r};var n=b.createNamespace(p,"changes");var d=this.getCommandStack().getAllExecutedCommands();d.forEach(function(o){if(o.getPreparedChange&&!o.getRuntimeOnly()){var v=o.getPreparedChange();if(!Array.isArray(v)){v=[v];}v.forEach(function(e){if(s.isAtoEnabled()){e.setRequest("ATO_NOTIFICATION");}e.setNamespace(n);e.setComponent(r);});}});return f.saveAll(true);}.bind(this));};
c.prototype._triggerUndoChanges=function(){var o=this.getCommandStack();var p=[];var d=o.getAllExecutedCommands();d.forEach(function(e){p.push(e.undo.bind(e));});p=p.reverse();return b.execPromiseQueueSequentially(p,false,true);};
c.prototype._removeCommands=function(f){var o=this.getCommandStack();var d=o.getAllExecutedCommands();d.forEach(function(e){if(e instanceof F){var h=e.getPreparedChange();var i=e.getAppComponent();var j=R.bySelector(h.getSelector(),i);f.removeFromAppliedChangesOnControl(h,i,j);}});o.removeAllCommands();};
c.prototype.saveAsCommands=function(r){if(!r){throw new Error("The id of the new app variant is required");}var o=g(this.getRootControl());if(!o){throw new Error("Can't save commands without root control instance!");}var d=b.getAppDescriptor(o);if(d["sap.app"].id===r){throw new Error("The id of the app variant should be different from the current app id");}var f=a.createForControl(o);var e=this.getCommandStack();return this._moveChangeToAppVariant(r,f).then(function(){e.detachCommandExecuted(this.handleCommandExecuted.bind(this));return this._triggerUndoChanges();}.bind(this)).then(function(){this._removeCommands(f);e.attachCommandExecuted(this.handleCommandExecuted.bind(this));return true;}.bind(this));};
return c;},true);
sap.ui.predefine('sap/ui/rta/command/Move',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var M=F.extend("sap.ui.rta.command.Move",{metadata:{library:"sap.ui.rta",properties:{movedElements:{type:"any[]"},target:{type:"any"},source:{type:"any"}},associations:{},events:{}}});
M.prototype._getChangeSpecificData=function(i){var s=i?this.getTarget():this.getSource();var t=i?this.getSource():this.getTarget();if(s.parent){s.id=s.parent.getId();delete s.parent;}if(t.parent){t.id=t.parent.getId();delete t.parent;}var S={changeType:this.getChangeType(),source:s,target:t,movedElements:[]};this.getMovedElements().forEach(function(m){S.movedElements.push({id:m.id||(m.element&&m.element.getId()),sourceIndex:i?m.targetIndex:m.sourceIndex,targetIndex:i?m.sourceIndex:m.targetIndex});});return S;};
M.prototype.prepare=function(l,d){var s=F.prototype.prepare.apply(this,arguments);if(s){this._oPreparedUndoChange=this._createChangeFromData(this._getChangeSpecificData(true),l,d);}return s;};
M.prototype.undo=function(){return this._applyChange(this._oPreparedUndoChange,true);};
return M;},true);
sap.ui.predefine('sap/ui/rta/command/Property',['sap/ui/rta/command/FlexCommand',"sap/ui/rta/Utils"],function(F,U){"use strict";
var P=F.extend("sap.ui.rta.command.Property",{metadata:{library:"sap.ui.rta",properties:{propertyName:{type:"string"},newValue:{type:"any"},semanticMeaning:{type:"string"},changeType:{type:"string",defaultValue:"propertyChange"}},associations:{},events:{}}});
P.prototype._getChangeSpecificData=function(){var e=this.getElement();return{changeType:this.getChangeType(),selector:{id:e.getId(),type:e.getMetadata().getName()},content:{property:this.getPropertyName(),newValue:this.getNewValue(),semantic:this.getSemanticMeaning()}};};
return P;},true);
sap.ui.predefine('sap/ui/rta/command/Remove',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Remove",{metadata:{library:"sap.ui.rta",properties:{removedElement:{type:"any"}},associations:{},events:{}}});
R.prototype._getChangeSpecificData=function(){var e=this.getRemovedElement()||this.getElement();var s={changeType:this.getChangeType(),removedElement:{id:e.getId()}};return s;};
return R;},true);
sap.ui.predefine('sap/ui/rta/command/Rename',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Rename",{metadata:{library:"sap.ui.rta",properties:{renamedElement:{type:"object"},newValue:{type:"string",defaultValue:"new text"}},associations:{},events:{}}});
R.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType(),selector:{id:this.getElement().getId()},renamedElement:{id:this.getRenamedElement().getId()},value:this.getNewValue()};return s;};
return R;},true);
sap.ui.predefine('sap/ui/rta/command/Reveal',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var R=F.extend("sap.ui.rta.command.Reveal",{metadata:{library:"sap.ui.rta",properties:{revealedElementId:{type:"string"},directParent:"object"}}});
R.prototype._getChangeSpecificData=function(){var s={changeType:this.getChangeType()};if(this.getRevealedElementId()){s.revealedElementId=this.getRevealedElementId();}return s;};
return R;},true);
sap.ui.predefine('sap/ui/rta/command/Settings',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var S=F.extend("sap.ui.rta.command.Settings",{metadata:{library:"sap.ui.rta",properties:{content:{type:"any"}},associations:{},events:{}}});
S.prototype._getChangeSpecificData=function(f){var s={changeType:this.getChangeType(),content:this.getContent()};return s;};
S.prototype.execute=function(){if(this.getElement()){return F.prototype.execute.apply(this,arguments);}else{return Promise.resolve();}};
S.prototype.undo=function(){if(this.getElement()){return F.prototype.undo.apply(this,arguments);}else{return Promise.resolve();}};
return S;},true);
sap.ui.predefine('sap/ui/rta/command/Split',['sap/ui/rta/command/FlexCommand'],function(F){"use strict";
var S=F.extend("sap.ui.rta.command.Split",{metadata:{library:"sap.ui.rta",properties:{newElementIds:{type:"string[]"},source:{type:"any"},parentElement:{type:"any"}},associations:{},events:{}}});
S.prototype._getChangeSpecificData=function(){var s={newElementIds:this.getNewElementIds(),sourceControlId:this.getSource().getId(),changeType:this.getChangeType(),parentId:this.getParentElement().getId()};return s;};
return S;},true);
sap.ui.predefine('sap/ui/rta/command/Stack',['sap/ui/base/ManagedObject','sap/ui/fl/ChangePersistenceFactory','sap/ui/fl/Utils','sap/ui/rta/command/Settings','sap/ui/rta/command/CompositeCommand','sap/ui/rta/ControlTreeModifier'],function(M,C,F,S,a,b){"use strict";
var c=M.extend("sap.ui.rta.command.Stack",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{modified:{},commandExecuted:{parameters:{command:{type:"object"},undo:{type:"boolean"}}}}}});
c.initializeWithChanges=function(o,f){var s=new c();s._aPersistedChanges=f;var m={};if(f&&f.length>0){var d=C.getChangePersistenceForControl(o);var e=F.getComponentForControl(o);var A=sap.ui.fl.Utils.getAppDescriptor(e)["sap.app"].id;var p={oComponent:e,appName:A};return d.getChangesForComponent(p).then(function(g){var h={};g.forEach(function(i){h[i.getDefinition().fileName]=i;});f.forEach(function(i){var j=h[i];var k=j.getSelector();var l=new S({selector:k,changeType:j.getDefinition().changeType,element:b.bySelector(k,e)});l._oPreparedChange=j;if(j.getUndoOperations()){l._aRecordedUndo=j.getUndoOperations();j.resetUndoOperations();}var n=j.getDefinition().support.compositeCommand;if(n){if(!m[n]){m[n]=new a();s.pushExecutedCommand(m[n]);}m[n].addCommand(l);}else{s.pushExecutedCommand(l);}});return s;});}else{return Promise.resolve(s);}};
c.prototype.addCommandExecutionHandler=function(h){this._aCommandExecutionHandler.push(h);};
c.prototype.removeCommandExecutionHandler=function(h){var i=this._aCommandExecutionHandler.indexOf(h);if(i>-1){this._aCommandExecutionHandler.splice(i,1);}};
c.prototype.init=function(){this._aCommandExecutionHandler=[];this._toBeExecuted=-1;this._oLastCommand=Promise.resolve();};
c.prototype._waitForCommandExecutionHandler=function(p){return Promise.all(this._aCommandExecutionHandler.map(function(h){return h(p);}));};
c.prototype._getCommandToBeExecuted=function(){return this.getCommands()[this._toBeExecuted];};
c.prototype.pushExecutedCommand=function(o){this.push(o,true);};
c.prototype.push=function(o,e){if(this._bUndoneCommands){this._bUndoneCommands=false;while(this._toBeExecuted>-1){this.pop();}}this.insertCommand(o,0);if(!e){this._toBeExecuted++;}this.fireModified();};
c.prototype.top=function(){return this.getCommands()[0];};
c.prototype.pop=function(){if(this._toBeExecuted>-1){this._toBeExecuted--;}return this.removeCommand(0);};
c.prototype.removeCommand=function(o,s){var r=this.removeAggregation("commands",o,s);this.fireModified();return r;};
c.prototype.removeAllCommands=function(s){var d=this.removeAllAggregation("commands",s);this._toBeExecuted=-1;this.fireModified();return d;};
c.prototype.isEmpty=function(){return this.getCommands().length===0;};
c.prototype.execute=function(){this._oLastCommand=this._oLastCommand.catch(function(){}).then(function(){var o=this._getCommandToBeExecuted();if(o){return o.execute().then(function(){this._toBeExecuted--;var p={command:o,undo:false};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this)).catch(function(e){e=e||new Error("Executing of the change failed.");e.index=this._toBeExecuted;e.command=this.removeCommand(this._toBeExecuted);this._toBeExecuted--;return Promise.reject(e);}.bind(this));}}.bind(this));return this._oLastCommand;};
c.prototype._unExecute=function(){if(this.canUndo()){this._bUndoneCommands=true;this._toBeExecuted++;var o=this._getCommandToBeExecuted();if(o){return o.undo().then(function(){var p={command:o,undo:true};this.fireCommandExecuted(p);this.fireModified();return this._waitForCommandExecutionHandler(p);}.bind(this));}else{return Promise.resolve();}}else{return Promise.resolve();}};
c.prototype.canUndo=function(){return(this._toBeExecuted+1)<this.getCommands().length;};
c.prototype.undo=function(){return this._unExecute();};
c.prototype.canRedo=function(){return!!this._getCommandToBeExecuted();};
c.prototype.redo=function(){return this.execute();};
c.prototype.pushAndExecute=function(o){this.push(o);return this.execute();};
c.prototype.getAllExecutedCommands=function(){var A=[];var d=this.getCommands();for(var i=d.length-1;i>this._toBeExecuted;i--){var s=this.getSubCommands(d[i]);A=A.concat(s);}return A;};
c.prototype.getSubCommands=function(o){var d=[];if(o.getCommands){o.getCommands().forEach(function(s){var e=this.getSubCommands(s);d=d.concat(e);},this);}else{d.push(o);}return d;};
return c;},true);
sap.ui.predefine('sap/ui/rta/command/appDescriptor/AddLibrary',['sap/ui/rta/command/AppDescriptorCommand'],function(A){"use strict";
var a=A.extend("sap.ui.rta.command.appDescriptor.AddLibrary",{metadata:{library:"sap.ui.rta",events:{}}});
a.prototype.init=function(){this.setChangeType("appdescr_ui5_addLibraries");};
a.prototype.execute=function(){var p=[];if(this.getParameters().libraries){var l=Object.keys(this.getParameters().libraries);l.forEach(function(L){p.push(sap.ui.getCore().loadLibrary(L,true));});}return Promise.all(p);};
return a;},true);
sap.ui.predefine('sap/ui/rta/library',['sap/ui/core/Core','sap/ui/core/library','sap/m/library','sap/ui/fl/library','sap/ui/dt/library'],function(C,c){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.rta",version:"1.60.20",dependencies:["sap.ui.core","sap.m","sap.ui.fl","sap.ui.dt"],types:[],interfaces:[],controls:[],elements:[]});return sap.ui.rta;});
sap.ui.predefine('sap/ui/rta/plugin/Combine',['sap/ui/rta/plugin/Plugin','sap/ui/rta/Utils','sap/ui/rta/util/BindingsExtractor','sap/ui/dt/Util'],function(P,U,B,D){"use strict";
var C=P.extend("sap.ui.rta.plugin.Combine",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
C.prototype._isEditable=function(o){var c=this.getAction(o);if(c&&c.changeType&&c.changeOnRelevantContainer){var r=o.getRelevantContainer();return this.hasChangeHandler(c.changeType,r)&&this.hasStableId(o)&&this._checkRelevantContainerStableID(c,o);}else{return false;}};
C.prototype._checkForSameRelevantContainer=function(e){var r=[];for(var i=0,n=e.length;i<n;i++){r[i]=e[i].getRelevantContainer();var c=this.getAction(e[i]);if(!c||!c.changeType){return false;}if(i>0){if((r[0]!==r[i])||(this.getAction(e[0]).changeType!==c.changeType)){return false;}}}return true;};
C.prototype.isAvailable=function(e){if(e.length<=1){return false;}return(e.every(function(E){return this._isEditableByPlugin(E);},this)&&this._checkForSameRelevantContainer(e));};
C.prototype.isEnabled=function(e){if(!this.isAvailable(e)||e.length<=1){return false;}var c=e.map(function(E){return E.getElement();});var a=e.every(function(E){var A=this.getAction(E);if(!A){return false;}if(typeof A.isEnabled!=="undefined"){if(typeof A.isEnabled==="function"){return A.isEnabled(c);}else{return A.isEnabled;}}return true;},this);if(a){var f=c.shift();var b=B.getBindings(f,f.getModel());if(b.length>0&&f.getBindingContext()){var F=U.getEntityTypeByPath(f.getModel(),f.getBindingContext().getPath());a=c.some(function(o){if(o.getBindingContext()){var s=U.getEntityTypeByPath(o.getModel(),o.getBindingContext().getPath());return F===s;}else{return false;}});}}return a;};
C.prototype.handleCombine=function(e,c){var o;var E=e.map(function(b){if(b.getElement().getId()===c.getId()){o=b;}return b.getElement();});var d=o.getDesignTimeMetadata();var a=this.getAction(o);var v=this.getVariantManagementReference(o,a);return this.getCommandFactory().getCommandFor(c,"combine",{source:c,combineFields:E},d,v).then(function(b){this.fireElementModified({"command":b});}.bind(this)).catch(function(m){throw D.createError("Combine#handleCombine",m,"sap.ui.rta");});};
C.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_GROUP_FIELDS",rank:90,icon:"sap-icon://combine"});};
C.prototype.getActionName=function(){return"combine";};
C.prototype.handler=function(e,p){this.handleCombine(e,p.contextElement);};
return C;},true);
sap.ui.predefine('sap/ui/rta/plugin/ControlVariant',['sap/ui/rta/plugin/Plugin','sap/ui/rta/plugin/RenameHandler','sap/ui/rta/Utils','sap/ui/dt/ElementOverlay','sap/ui/dt/OverlayRegistry','sap/ui/dt/OverlayUtil','sap/ui/dt/Util','sap/ui/core/util/reflection/JsControlTreeModifier','sap/ui/fl/Utils','sap/ui/fl/variants/VariantManagement','sap/ui/base/ManagedObject','sap/m/delegate/ValueStateMessage','sap/ui/rta/command/CompositeCommand',"sap/base/Log"],function(P,R,U,E,O,a,D,J,f,V,M,b,C,L){"use strict";E.prototype._variantManagement=undefined;
E.prototype.getVariantManagement=function(){return this._variantManagement;};
E.prototype.setVariantManagement=function(k){this._variantManagement=k;};
E.prototype.hasVariantManagement=function(){return this._variantManagement?true:false;};
var c=P.extend("sap.ui.rta.plugin.ControlVariant",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string",variantManagementControlOverlay:{type:"any"}},associations:{},events:{}}});
c.MODEL_NAME="$FlexVariants";
c.prototype.registerElementOverlay=function(o){var d=o.getElement(),m=this._getVariantModel(d),v;P.prototype.registerElementOverlay.apply(this,arguments);if(!m){return;}if(d instanceof V){var A=d.getFor(),e;v=J.getSelector(d,f.getAppComponentForControl(d)).id;if(!A||(Array.isArray(A)&&A.length===0)){o.setVariantManagement(v);return;}if(!this._isPersonalizationMode()){m._setModelPropertiesForControl(v,true,d);m.checkUpdate(true);}e=!Array.isArray(A)?[A]:A;e.forEach(function(s){var g=s instanceof M?s:sap.ui.getCore().byId(s),h=O.getOverlay(g);this._propagateVariantManagement(h,v);}.bind(this));o.attachEvent("editableChange",R._manageClickEvent,this);}else if(!o.getVariantManagement()){v=this._getVariantManagementFromParent(o);if(v){o.setVariantManagement(v);o.attachEvent("editableChange",R._manageClickEvent,this);}}};
c.prototype._isPersonalizationMode=function(){return this.getCommandFactory().getFlexSettings().layer==="USER";};
c.prototype._propagateVariantManagement=function(p,v){var e=[];p.setVariantManagement(v);e=a.getAllChildOverlays(p);e.forEach(function(o){e=e.concat(this._propagateVariantManagement(o,v));}.bind(this));return e;};
c.prototype._getVariantManagementFromParent=function(o){var v=o.getVariantManagement();if(!v&&o.getParentElementOverlay()){return this._getVariantManagementFromParent(o.getParentElementOverlay());}return v;};
c.prototype.deregisterElementOverlay=function(o){o.detachEvent("editableChange",R._manageClickEvent,this);o.detachBrowserEvent("click",R._onClick,this);var m;var v;var d=o.getElement();if(d instanceof V){m=this._getVariantModel(d);v=o.getVariantManagement();m._setModelPropertiesForControl(v,false,d);m.checkUpdate(true);}this.removeFromPluginsList(o);P.prototype.deregisterElementOverlay.apply(this,arguments);};
c.prototype._getVariantModel=function(e){var A=f.getAppComponentForControl(e);return A?A.getModel(c.MODEL_NAME):undefined;};
c.prototype._isEditable=function(o){if(this._isPersonalizationMode()){return false;}return this._isVariantManagementControl(o);};
c.prototype._isVariantManagementControl=function(o){var e=o.getElement();var A=e.getAssociation("for");return!!(A&&e instanceof V);};
c.prototype.isVariantSwitchAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isVariantSwitchEnabled=function(e){var o=e[0];var v=[];if(this._isVariantManagementControl(o)){var d=o.getElement(),s=o.getVariantManagement?o.getVariantManagement():undefined;if(!s){return false;}var m=this._getVariantModel(d);if(m){v=m.getData()[s].variants.reduce(function(r,h){if(h.visible){return r.concat(h);}else{return r;}},[]);}var g=v.length>1;return g;}else{return false;}};
c.prototype.setDesignTime=function(d){R._setDesignTime.call(this,d);};
c.prototype.isRenameAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isRenameEnabled=function(e){return this._isVariantManagementControl(e[0]);};
c.prototype.isVariantDuplicateAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isVariantDuplicateEnabled=function(e){var o=e[0];var v=o.getVariantManagement?o.getVariantManagement():undefined;if(!v||!this._isVariantManagementControl(o)){return false;}return true;};
c.prototype.isVariantConfigureAvailable=function(e){return this._isVariantManagementControl(e);};
c.prototype.isVariantConfigureEnabled=function(e){return this._isVariantManagementControl(e[0]);};
c.prototype.switchVariant=function(t,n,s){var d=t.getDesignTimeMetadata(),T=t.getElement();this.getCommandFactory().getCommandFor(T,"switch",{targetVariantReference:n,sourceVariantReference:s},d).then(function(S){this.fireElementModified({"command":S});}.bind(this)).catch(function(m){throw D.createError("ControlVariant#switchVariant",m,"sap.ui.rta");});};
c.prototype.renameVariant=function(e){var o=e[0];this.setVariantManagementControlOverlay(o);this.startEdit(o);};
c.prototype.startEdit=function(v){var o=v.getElement(),d=v.getDesignTimeMetadata().getData().variantRenameDomRef;var e=o.getTitle();var p=e.getText();var h=R.startEdit.bind(this,{overlay:v,domRef:d,pluginMethodName:"plugin.ControlVariant.startEdit"});if(v._triggerDuplicate){var s=this._getVariantTitleForCopy(p,v.getVariantManagement(),this._getVariantModel(o).getData());o.getTitle().setText(s);v.attachEventOnce("geometryChanged",function(){h();},this);}else{h();}};
c.prototype.stopEdit=function(r){if(this._oEditedOverlay._triggerDuplicate){this._oEditedOverlay.getElementInstance().getTitle().getBinding("text").refresh(true);if(!this._oEditedOverlay.hasStyleClass("sapUiRtaErrorBg")){delete this._oEditedOverlay._triggerDuplicate;}}R._stopEdit.call(this,r,"plugin.ControlVariant.stopEdit");};
c.prototype.isBusy=function(){return this._bPreventMenu;};
c.prototype._createDuplicateCommand=function(p){return this.getCommandFactory().getCommandFor(p.element,"duplicate",{sourceVariantReference:p.currentVariantReference,newVariantTitle:p.newVariantTitle},p.designTimeMetadata,p.variantManagementReference);};
c.prototype._emitLabelChangeEvent=function(){var t=R._getCurrentEditableFieldText.call(this),o=this._oEditedOverlay,d=o.getDesignTimeMetadata(),r=o.getElement(),m=this._getVariantModel(r),e,v=o.getVariantManagement(),T=this.getOldValue()!==t,n=T||o._triggerDuplicate,i=n?m._getVariantTitleCount(t,v):0,g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta"),s=m.getCurrentVariantReference(v);o.removeStyleClass("sapUiRtaErrorBg");if(this._oValueStateMessage){this._oValueStateMessage.getPopup().attachEventOnce("closed",function(){r.$().css("z-index",1);this._oValueStateMessage.destroy();delete this._oValueStateMessage;},this);this._oValueStateMessage.close();}if(t==='\xa0'){e="BLANK_ERROR_TEXT";}else if(i>0){e="DUPLICATE_ERROR_TEXT";}else if(n){return this._createSetTitleCommand({text:t,element:r,designTimeMetadata:d,variantManagementReference:v}).then(function(S){if(o._triggerDuplicate){return this._createDuplicateCommand({currentVariantReference:s,designTimeMetadata:d,variantManagementReference:v,element:r,newVariantTitle:this.getOldValue()}).then(function(j){return new C({commands:[j]});}).then(function(j){return T?j.addCommand(S):j;});}else{return S;}}.bind(this)).then(function(j){this.fireElementModified({"command":j});}.bind(this)).catch(function(j){throw D.createError("ControlVariant#_emitLabelChangeEvent",j,"sap.ui.rta");});}else{L.info("Control Variant title unchanged");return Promise.resolve();}if(e){var h=g.getText(e);this._prepareOverlayForValueState(o,h);o.addStyleClass("sapUiRtaErrorBg");return Promise.resolve(U._showMessageBox("ERROR","BLANK_DUPLICATE_TITLE_TEXT",e).then(function(){var j=function(){this._oValueStateMessage=new b(o);this._oValueStateMessage.getPopup().attachEventOnce("opened",function(k){k.getSource()._deactivateFocusHandle();});this._oValueStateMessage.open();this.startEdit(o);}.bind(this);return j;}.bind(this)));}};
c.prototype._getVariantTitleForCopy=function(s,v,d){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");var e=r.getText("VARIANT_COPY_SINGLE_TEXT").replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&").replace("\\{0\\}","(.*)");var g=r.getText("VARIANT_COPY_MULTIPLE_TEXT").replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&").replace("\\{0\\}","(.*)").replace("\\{1\\}","([0-9]+)");var h=new RegExp(e+"+");var i=new RegExp(g);var t;var I=g.lastIndexOf("(.*)")>g.lastIndexOf("([0-9]+)")?1:2;var j=(I===1)?2:1;var T=0;if(i.test(s)){t=i.exec(s)[j];}else{t=h.test(s)?h.exec(s)[1]:s;}var k=[];d[v].variants.forEach(function(o){if(o.visible){k=i.test(o.title)?i.exec(o.title):h.exec(o.title);if(!k){return;}if(k.length===3&&t===k[j]&&T<=parseInt(k[I],10)){T=k[I]?(parseInt(k[I],10)+1):T;}else if(k.length===2&&t===k[1]){T=T===0?1:T;}}});return T>0?r.getText("VARIANT_COPY_MULTIPLE_TEXT",[t,T]):r.getText("VARIANT_COPY_SINGLE_TEXT",[t]);};
c.prototype._createSetTitleCommand=function(p){this._$oEditableControlDomRef.text(p.text);return this.getCommandFactory().getCommandFor(p.element,"setTitle",{newText:p.text},p.designTimeMetadata,p.variantManagementReference).catch(function(m){L.error("Error during rename : ",m);});};
c.prototype._prepareOverlayForValueState=function(o,v){o.getValueState=function(){return"Error";};o.getValueStateText=function(){return v;};o.getDomRefForValueStateMessage=function(){return this.$();};};
c.prototype.configureVariants=function(e){var o=e[0];var v=o.getElement();var s=o.getVariantManagement();var m=this._getVariantModel(v);var d=o.getDesignTimeMetadata();m.manageVariants(v,s,this.getCommandFactory().getFlexSettings().layer).then(function(g){return this.getCommandFactory().getCommandFor(v,"configure",{control:v,changes:g},d,s);}.bind(this)).then(function(g){this.fireElementModified({"command":g});}.bind(this)).catch(function(g){throw D.createError("ControlVariant#configureVariants",g,"sap.ui.rta");});};
c.prototype.getMenuItems=function(e){var o=e[0];var m=[];if(this.isRenameAvailable(o)){m.push({id:"CTX_VARIANT_SET_TITLE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_RENAME'),handler:this.renameVariant.bind(this),enabled:this.isRenameEnabled.bind(this),rank:210,icon:"sap-icon://edit"});}if(this.isVariantDuplicateAvailable(o)){m.push({id:"CTX_VARIANT_DUPLICATE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_DUPLICATE'),handler:function(e){e[0]._triggerDuplicate=true;this.renameVariant(e);}.bind(this),enabled:this.isVariantDuplicateEnabled.bind(this),rank:220,icon:"sap-icon://duplicate"});}if(this.isVariantConfigureAvailable(o)){m.push({id:"CTX_VARIANT_MANAGE",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_MANAGE'),handler:this.configureVariants.bind(this),enabled:this.isVariantConfigureEnabled.bind(this),startSection:true,rank:230,icon:"sap-icon://action-settings"});}if(this.isVariantSwitchAvailable(o)){var d=this._getVariantModel(o.getElement());var s=o.getVariantManagement();var S=d.getData()[s].variants.reduce(function(r,v){if(v.visible){var g=d.getData()[s].currentVariant===v.key;var i={id:v.key,text:v.title,icon:g?"sap-icon://accept":"blank",enabled:!g};return r.concat(i);}else{return r;}},[]);m.push({id:"CTX_VARIANT_SWITCH_SUBMENU",text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_VARIANT_SWITCH'),handler:function(e,p){var g=p.eventItem.data();var t=e[0];var n=g.key;var h=d.getData()[s].currentVariant;return this.switchVariant(t,n,h);}.bind(this),enabled:this.isVariantSwitchEnabled.bind(this),submenu:S,rank:240,icon:"sap-icon://switch-views"});}return m;};
return c;},true);
sap.ui.predefine('sap/ui/rta/plugin/CreateContainer',['sap/ui/rta/plugin/Plugin','sap/ui/fl/Utils','sap/ui/rta/Utils','sap/ui/dt/Util','sap/base/util/uid'],function(P,F,R,D,u){"use strict";
var C=P.extend("sap.ui.rta.plugin.CreateContainer",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
C.prototype._isEditable=function(o){return{asSibling:this._isEditableCheck(o,true),asChild:this._isEditableCheck(o,false)};};
C.prototype._isEditableCheck=function(o,O){var e=false;var p=this._getParentOverlay(O,o);var a;if(!p||!p.getParentElementOverlay()){return false;}if(O){a=o.getParentAggregationOverlay().getAggregationName();}e=this.checkAggregationsOnSelf(p,"createContainer",a);if(e){var b=F.getViewForControl(p.getElement());return this.hasStableId(o)&&F.checkControlId(b);}else{return false;}};
C.prototype._getParentOverlay=function(s,o){var p;if(s){p=o.getParentElementOverlay();}else{p=o;}return p;};
C.prototype.getCreateAction=function(s,o){var p=this._getParentOverlay(s,o);var d=p.getDesignTimeMetadata();var a=d.getActionDataFromAggregations("createContainer",o.getElement());return a[0];};
C.prototype.isAvailable=function(s,e){return this._isEditableByPlugin(e[0],s);};
C.prototype.isEnabled=function(s,e){var E=e[0];var a=this.getCreateAction(s,E);if(!a){return false;}if(a.isEnabled&&typeof a.isEnabled==="function"){var i=a.isEnabled;var p=this._getParentOverlay(s,E);return i(p.getElement());}else{return true;}};
C.prototype.getCreatedContainerId=function(a,n){var i=n;if(a.getCreatedContainerId&&typeof a.getCreatedContainerId==="function"){var m=a.getCreatedContainerId;i=m.call(null,n);}return i;};
C.prototype._determineIndex=function(p,s,a,g){return R.getIndex(p,s,a,g);};
C.prototype._getText=function(a,e,d,t){if(!a){return t;}var c=d.getAggregationDescription(a.aggregation,e).singular;var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");return T.getText(t,c);};
C.prototype.getCreateContainerText=function(s,o){var a=this.getCreateAction(s,o);var p=this._getParentOverlay(s,o);var d=p.getDesignTimeMetadata();var e=p.getElement();var t="CTX_CREATE_CONTAINER";return this._getText(a,e,d,t);};
C.prototype._getContainerTitle=function(a,e,d){var t="TITLE_CREATE_CONTAINER";return this._getText(a,e,d,t);};
C.prototype.handleCreate=function(s,o){var a=this.getCreateAction(s,o);var p=this._getParentOverlay(s,o);var b=p.getElement();var d=p.getDesignTimeMetadata();var v=F.getViewForControl(b);var S;if(s){S=o.getElement();}var n=v.createId(u());var g=d.getAggregation(a.aggregation).getIndex;var i=this._determineIndex(b,S,a.aggregation,g);var V=this.getVariantManagementReference(p,a);return this.getCommandFactory().getCommandFor(b,"createContainer",{newControlId:n,label:this._getContainerTitle(a,b,d),index:i,parentId:b.getId()},d,V).then(function(c){this.fireElementModified({"command":c,"action":a,"newControlId":n});}.bind(this)).catch(function(m){throw D.createError("CreateContainer#handleCreate",m,"sap.ui.rta");});};
C.prototype.getMenuItems=function(e){var o=true;var p="CTX_CREATE_SIBLING_CONTAINER";var r=40;var m=[];for(var i=0;i<2;i++){if(this.isAvailable(o,e)){var M=this.getCreateContainerText.bind(this,o);m.push({id:p,text:M,handler:this.handler.bind(this,o),enabled:this.isEnabled.bind(this,o),icon:"sap-icon://add-folder",rank:r,group:"Add"});}o=false;p="CTX_CREATE_CHILD_CONTAINER";r=50;}return m;};
C.prototype.getActionName=function(){return"createContainer";};
C.prototype.handler=function(o,e){this.handleCreate(o,e[0]);};
return C;},true);
sap.ui.predefine('sap/ui/rta/plugin/CutPaste',['sap/ui/dt/plugin/CutPaste','sap/ui/dt/Util','sap/ui/rta/plugin/Plugin','sap/ui/rta/plugin/RTAElementMover','sap/ui/rta/Utils'],function(C,D,P,R,U){"use strict";
var a=C.extend("sap.ui.rta.plugin.CutPaste",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
U.extendWith(a.prototype,P.prototype,function(d,s,p){return p!=="getMetadata";});
a.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setElementMover(new R({commandFactory:this.getCommandFactory()}));};
a.prototype._isEditable=function(o,p){return this.getElementMover().isEditable(o,p.onRegistration)||this._isPasteEditable(o);};
a.prototype._isPasteEditable=function(o){var d=o.getDesignTimeMetadata();return this.hasStableId(o)&&this.getElementMover()._isMoveAvailableOnRelevantContainer(o)&&d.isActionAvailableOnAggregations("move");};
a.prototype.isAvailable=function(e){return e.every(function(E){return E.getMovable();});};
a.prototype.registerElementOverlay=function(o){C.prototype.registerElementOverlay.apply(this,arguments);P.prototype.registerElementOverlay.apply(this,arguments);};
a.prototype.deregisterElementOverlay=function(o){C.prototype.deregisterElementOverlay.apply(this,arguments);P.prototype.removeFromPluginsList.apply(this,arguments);};
a.prototype.paste=function(t){this._executePaste(t);this.getElementMover().buildMoveCommand().then(function(m){this.fireElementModified({"command":m});this.stopCutAndPaste();}.bind(this)).catch(function(m){throw D.createError("CutPaste#paste",m,"sap.ui.rta");});};
a.prototype.cut=function(o){C.prototype.cut.apply(this,arguments);o.setSelected(false);};
a.prototype.getMenuItems=function(e){var m=[],c={id:'CTX_CUT',text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_CUT'),handler:function(e){return this.cut(e[0]);}.bind(this),enabled:function(e){return e.length===1;},rank:70,icon:"sap-icon://scissors"},p={id:'CTX_PASTE',text:sap.ui.getCore().getLibraryResourceBundle('sap.ui.rta').getText('CTX_PASTE'),handler:function(e){return this.paste(e[0]);}.bind(this),enabled:function(e){return this.isElementPasteable(e[0]);}.bind(this),rank:80,icon:"sap-icon://paste"};if(this.isAvailable(e)){m.push(c,p);}else if(this._isPasteEditable(e[0])){m.push(p);}return m;};
return a;},true);
sap.ui.predefine('sap/ui/rta/plugin/DragDrop',['sap/ui/dt/plugin/ControlDragDrop','sap/ui/dt/Util','sap/ui/rta/plugin/RTAElementMover','sap/ui/rta/plugin/Plugin','sap/ui/rta/Utils'],function(C,D,R,P,U){"use strict";
var a=C.extend("sap.ui.rta.plugin.DragDrop",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{dragStarted:{},elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
U.extendWith(a.prototype,P.prototype,function(d,s,p,m,S){return p!=="getMetadata";});
a.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setElementMover(new R({commandFactory:this.getCommandFactory()}));};
a.prototype.setCommandFactory=function(c){this.setProperty("commandFactory",c);this.getElementMover().setCommandFactory(c);};
a.prototype._isEditable=function(o,p){return this.getElementMover().isEditable(o,p.onRegistration);};
a.prototype.registerElementOverlay=function(o){C.prototype.registerElementOverlay.apply(this,arguments);P.prototype.registerElementOverlay.apply(this,arguments);};
a.prototype.deregisterElementOverlay=function(o){C.prototype.deregisterElementOverlay.apply(this,arguments);P.prototype.removeFromPluginsList.apply(this,arguments);};
a.prototype.onDragStart=function(o){this.fireDragStarted();C.prototype.onDragStart.apply(this,arguments);this.getSelectedOverlays().forEach(function(o){o.setSelected(false);});o.$().addClass("sapUiRtaOverlayPlaceholder");};
a.prototype.onDragEnd=function(o){this.getElementMover().buildMoveCommand().then(function(c){this.fireElementModified({"command":c});o.$().removeClass("sapUiRtaOverlayPlaceholder");o.setSelected(true);o.focus();C.prototype.onDragEnd.apply(this,arguments);}.bind(this)).catch(function(e){throw D.propagateError(e,"DragDrop#onDragEnd","Error accured during onDragEnd execution","sap.ui.rta.plugin");});};
a.prototype.onMovableChange=function(o){C.prototype.onMovableChange.apply(this,arguments);};
return a;},true);
sap.ui.predefine('sap/ui/rta/plugin/EasyAdd',["sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/dt/OverlayRegistry","sap/m/Button","sap/ui/thirdparty/jquery"],function(A,O,B,q){"use strict";
var E=A.extend("sap.ui.rta.plugin.EasyAdd",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
E.prototype.registerElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersAdd");c.addStyleClass("sapUiRtaMarginBottom");}else if(c.getMetadata().getName()==="sap.uxap.ObjectPageLayout"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersAddTop");c.$("sectionsContainer").addClass("sapUiRtaPaddingTop");}var a=function(d,o,i){var C;if(d){C=o.getDesignTimeMetadata().getName().plural;}else{C=o.getDesignTimeMetadata().getAggregation("sections").childNames.plural();}this.showAvailableElements(d,[o],i,C);}.bind(this);var f=function(o,d,S,C,i){var e=function(h){var o=O.getOverlay(h.currentTarget.id.replace("-AddButton",""));a(S,o,i);h.stopPropagation();};var g=typeof C==="function"?C():C;this._addButton(o,e,d,g,S);}.bind(this);if(o.hasStyleClass("sapUiRtaPersAdd")){var b=o.hasStyleClass("sapUiRtaPersAdd")&&o.$().children(".sapUiRtaPersAddIconOuter").length<=0;if(b){f(o,o.$(),true,o.getDesignTimeMetadata().getName().singular);}}else if(o.hasStyleClass("sapUiRtaPersAddTop")){if(o.getAggregationOverlay("sections").$().children(".sapUiRtaPersAddIconOuter").length<=0){var s=o.getAggregationOverlay("sections").$();f(o,s,false,o.getDesignTimeMetadata().getAggregation("sections").childNames.singular,0);}}A.prototype.registerElementOverlay.apply(this,arguments);};
E.prototype.deregisterElementOverlay=function(o){var c=o.getElement();if(o._oAddButton){o._oAddButton.destroy();}if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"){o.removeStyleClass("sapUiRtaPersAdd");c.removeStyleClass("sapUiRtaMarginBottom");}else if(c.getMetadata().getName()==="sap.uxap.ObjectPageLayout"){o.removeStyleClass("sapUiRtaPersAddTop");c.$("sectionsContainer").removeClass("sapUiRtaPaddingTop");}};
E.prototype._isEditable=function(o){var i=A.prototype._isEditable.apply(this,arguments);if(o._oAddButton){var I=o.hasStyleClass("sapUiRtaPersAddTop");var s=I?"asChild":"asSibling";o._oAddButton.setEnabled(i[s]);if(I){var l=o.getElement();l.attachEventOnce("onAfterRenderingDOMReady",function(){l.$("sectionsContainer").addClass("sapUiRtaPaddingTop");});}}return i;};
E.prototype._addButton=function(o,c,a,C,b){var i=o.getEditableByPlugins().indexOf(this._retrievePluginName(b))>-1;var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");var I=o.getId()+"-AddButton";var h=q("<div class='sapUiRtaPersAddIconOuter' draggable='true' tabIndex='-1'> </div>");o._oAddButton=new B(I,{text:t.getText("CTX_ADD_ELEMENTS",C),icon:"sap-icon://add",enabled:i}).placeAt(h.get(0)).attachBrowserEvent('click',c).attachBrowserEvent('tap',c);a.append(h);h[0].addEventListener("mouseover",function(e){e.stopPropagation();var o=e.fromElement?O.getOverlay(e.fromElement.id):null;if(o&&o.getMetadata().getName()==="sap.ui.dt.ElementOverlay"){var p=o.getParentElementOverlay();p.removeStyleClass("sapUiRtaOverlayHover");}});h[0].addEventListener("mouseleave",function(e){e.stopPropagation();var o=e.toElement?O.getOverlay(e.toElement.id):null;if(o&&o.getMetadata().getName()==="sap.ui.dt.ElementOverlay"){var p=o.getParentElementOverlay();if(p.getMovable()){p.addStyleClass("sapUiRtaOverlayHover");}}});h[0].addEventListener("click",function(e){e.stopPropagation();});h[0].addEventListener("contextmenu",function(e){e.stopPropagation();e.preventDefault();});h[0].addEventListener("dragstart",function(e){e.stopPropagation();e.preventDefault();});};
return E;},true);
sap.ui.predefine('sap/ui/rta/plugin/EasyRemove',['sap/ui/rta/plugin/Remove','sap/ui/dt/OverlayRegistry','sap/m/Button',"sap/ui/thirdparty/jquery"],function(R,O,B,q){"use strict";
var E=R.extend("sap.ui.rta.plugin.EasyRemove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
E.prototype.registerElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"&&this.hasStableId(o)){o.addStyleClass("sapUiRtaPersDelete");}if(o.hasStyleClass("sapUiRtaPersDelete")&&o.$().children(".sapUiRtaPersDeleteClick").length<=0){var a=function(o){this.handler([o]);}.bind(this);var d=this._addButton(o);d.attachBrowserEvent("contextmenu",function(e){e.stopPropagation();e.preventDefault();});var f=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id.replace("-DeleteIcon",""));a(o);e.stopPropagation();e.preventDefault();};d.attachBrowserEvent("click",f).attachBrowserEvent("tap",f);}R.prototype.registerElementOverlay.apply(this,arguments);};
E.prototype._isEditable=function(o){if(o._oDeleteButton){o._oDeleteButton.setEnabled(this.isEnabled([o]));}return R.prototype._isEditable.apply(this,arguments);};
E.prototype._addButton=function(o){var e=this.isEnabled([o]);var i=o.getId()+"-DeleteIcon";var h=q("<div class='sapUiRtaPersDeleteClick' draggable='true'> </div>");var H=q("<div class='sapUiRtaPersDeleteIconOuter'> </div>");o._oDeleteButton=new B(i,{icon:"sap-icon://decline",tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta").getText("CTX_REMOVE"),enabled:e}).placeAt(H.get(0));h.append(H);o.$().append(h);h[0].addEventListener("dragstart",function(a){a.stopPropagation();a.preventDefault();});return o._oDeleteButton;};
E.prototype.deregisterElementOverlay=function(o){var c=o.getElement();if(c.getMetadata().getName()==="sap.uxap.ObjectPageSection"){o.removeStyleClass("sapUiRtaPersDelete");if(o._oDeleteButton){o._oDeleteButton.destroy();}}};
return E;},true);
sap.ui.predefine('sap/ui/rta/plugin/Plugin',['sap/ui/dt/Plugin','sap/ui/fl/Utils','sap/ui/fl/registry/ChangeRegistry','sap/ui/dt/OverlayRegistry','sap/ui/dt/OverlayUtil','sap/ui/dt/ElementOverlay','sap/ui/fl/changeHandler/JsControlTreeModifier','sap/ui/base/ManagedObject'],function(P,F,C,O,a,E,J,M){"use strict";E.prototype._bElementHasStableId=undefined;
E.prototype.getElementHasStableId=function(){return this._bElementHasStableId;};
E.prototype.setElementHasStableId=function(h){this._bElementHasStableId=h;};
E.prototype.hasElementStableId=function(){return this._bElementHasStableId?true:false;};
var B=P.extend("sap.ui.rta.plugin.Plugin",{metadata:{"abstract":true,library:"sap.ui.rta",properties:{commandFactory:{type:"object",multiple:false}},events:{elementModified:{command:{type:"sap.ui.rta.command.BaseCommand"}}}}});
B.prototype._isEditable=function(){};
var _=function(e){var p=e.getParameters();var r;var o=sap.ui.getCore().byId(p.id);if((p.type==="propertyChanged"&&p.name==="visible")){r=this._getRelevantOverlays(o);this.evaluateEditable(r,{onRegistration:false});}else if(p.type==="overlayRendered"){this.evaluateEditable([o],{onRegistration:true});}else if(p.type==="insertAggregation"||p.type==="removeAggregation"){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});}else if(p.type==="addOrSetAggregation"){if(this.getDesignTime().getStatus()==='synced'){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});}else{this.getDesignTime().attachEventOnce("synced",function(){r=this._getRelevantOverlays(o,p.name);this.evaluateEditable(r,{onRegistration:false});},this);}}};
B.prototype._detachReevaluationEditable=function(o){o.detachElementModified(_,this);};
B.prototype._attachReevaluationEditable=function(o){var g=function(e){if(e.getSource().getGeometry()&&e.getSource().getGeometry().visible){this.evaluateEditable([o],{onRegistration:true});o.detachEvent('geometryChanged',g,this);}};o.attachElementModified(_,this);if(!o.getGeometry()||!o.getGeometry().visible){o.attachEvent('geometryChanged',g,this);}};
B.prototype._getRelevantOverlays=function(o,A){var d=o.getRelevantOverlays();if(d.length===0){var r=a.findAllOverlaysInContainer(o);if(A){var e=o.getAggregationOverlay(A);var f=e?e.getChildren():[];f=f.filter(function(g){return r.indexOf(g)===-1;});r=r.concat(f);}o.setRelevantOverlays(r);return r;}return d;};
function b(e){return e.some(function(s){var S=O.getOverlay(s);return S&&a.isInAggregationBinding(S,s.sParentAggregationName);});}
B.prototype.evaluateEditable=function(o,p){var d=this.getDesignTime()?this.getDesignTime().getPlugins():[];var s=d.some(function(f){return f.isBusy&&f.isBusy();});if(s){return;}var e;o.forEach(function(f){var i=false;var S=f.getDesignTimeMetadata().getStableElements(f);if(S[0]instanceof M){i=b(S);}if(i){e=false;}else{e=f.getElement()&&f.getDesignTimeMetadata()&&!f.getDesignTimeMetadata().markedAsNotAdaptable()&&this._isEditable(f,p);}if(e!==undefined&&e!==null){if(typeof e==="boolean"){this._modifyPluginList(f,e);}else{this._modifyPluginList(f,e.asChild,false);this._modifyPluginList(f,e.asSibling,true);}}}.bind(this));};
B.prototype._modifyPluginList=function(o,i,d){if(i){this.addToPluginsList(o,d);}else{this.removeFromPluginsList(o,d);}};
B.prototype._retrievePluginName=function(s){var n=this.getMetadata().getName();if(s!==undefined){n+=s?".asSibling":".asChild";}return n;};
B.prototype._isEditableByPlugin=function(o,s){var p=this._retrievePluginName(s);var d=o.getEditableByPlugins();return d.indexOf(p)>-1;};
B.prototype.registerElementOverlay=function(o){this.evaluateEditable([o],{onRegistration:true});this._attachReevaluationEditable(o);};
B.prototype.deregisterElementOverlay=function(o){this.removeFromPluginsList(o);this.removeFromPluginsList(o,true);this.removeFromPluginsList(o,false);this._detachReevaluationEditable(o);};
B.prototype.hasStableId=function(o){if(!o){return false;}if(!o.getDesignTimeMetadata()){return false;}if(o.getElementHasStableId()===undefined){var s=o.getDesignTimeMetadata().getStableElements(o);var u=s.length>0?s.some(function(S){var d=S.id||S;if(!F.checkControlId(d,S.appComponent)){return c(o,S);}}):true;o.setElementHasStableId(!u);}return o.hasElementStableId();};
function c(o,s){var A=a.getAggregationInformation(o,o.getElement().sParentAggregationName);if(!A.templateId){return true;}else{return!F.checkControlId(A.templateId,s.appComponent);}}
B.prototype.getVariantManagementReference=function(o,A,f,s){var e;if(!s){e=o.getElement();}else{e=s;}var r;if((A.changeOnRelevantContainer||f)&&!s){r=o.getRelevantContainer();}else{r=e;}var v;if(o.getVariantManagement&&this._hasVariantChangeHandler(A.changeType,r)){v=o.getVariantManagement();}return v;};
B.prototype._hasVariantChangeHandler=function(s,e){var o=this._getChangeHandler(s,e);return(o&&o.revertChange);};
B.prototype.checkAggregationsOnSelf=function(o,A,p){var d=o.getDesignTimeMetadata();var e=o.getElement();var i=false;var f=d.getActionDataFromAggregations(A,o.getElement());var g=f.filter(function(j){if(j&&p){return j.aggregation===p;}else{return true;}})[0];var s=g?g.changeType:null;var h=g&&g.changeOnRelevantContainer;if(h){e=o.getRelevantContainer();var r=O.getOverlay(e);if(!this.hasStableId(r)){return false;}}if(s&&this.hasChangeHandler(s,e)){i=true;}return i;};
B.prototype.removeFromPluginsList=function(o,s){var n=this._retrievePluginName(s);o.removeEditableByPlugin(n);if(!o.getEditableByPlugins().length){o.setEditable(false);}};
B.prototype.addToPluginsList=function(o,s){var n=this._retrievePluginName(s);var p=o.getEditableByPlugins();if(p.indexOf(n)===-1){o.addEditableByPlugin(n);o.setEditable(true);}};
B.prototype.hasChangeHandler=function(s,e){return!!this._getChangeHandler(s,e);};
B.prototype._getChangeHandler=function(s,e,d){if(!d){d=e.getMetadata().getName();}var l=this.getCommandFactory().getFlexSettings().layer;return C.getInstance().getChangeHandler(s,d,e,J,l);};
B.prototype.isAvailable=function(){return P.prototype.isAvailable.apply(this,arguments);};
B.prototype._checkRelevantContainerStableID=function(A,e){if(A.changeOnRelevantContainer){var r=e.getRelevantContainer();var R=O.getOverlay(r);if(!this.hasStableId(R)){return false;}}return true;};
return B;},true);
sap.ui.predefine('sap/ui/rta/plugin/RTAElementMover',['sap/ui/dt/plugin/ElementMover','sap/ui/dt/OverlayUtil','sap/ui/dt/ElementUtil','sap/ui/fl/Utils','sap/ui/rta/Utils','sap/ui/rta/command/CommandFactory','sap/ui/rta/plugin/Plugin','sap/ui/dt/OverlayRegistry','sap/ui/rta/util/BindingsExtractor','sap/ui/dt/MetadataPropagationUtil'],function(E,O,a,F,U,C,P,b,B,M){"use strict";
var R=E.extend("sap.ui.rta.plugin.RTAElementMover",{metadata:{library:"sap.ui.rta",properties:{commandFactory:{type:"any",defaultValue:C},movableTypes:{type:"string[]",defaultValue:["sap.ui.core.Element"]}},associations:{},events:{}}});
R.prototype.init=function(){this.oBasePlugin=new P({commandFactory:this.getCommandFactory()});};
R.prototype.exit=function(){this.oBasePlugin.destroy();};
R.prototype.setCommandFactory=function(c){this.setProperty("commandFactory",c);this.oBasePlugin.setCommandFactory(c);};
R.prototype.isEditable=function(o,c){var e=o.getElement();var m=false;if(this.isMovableType(e)&&this.checkMovable(o,c)&&!O.isInAggregationBinding(o,e.sParentAggregationName)){m=true;}o.setMovable(m);return m;};
function i(o,c){var v=false,d=o.getDesignTimeMetadata(),p=o.getParentElementOverlay();if(!d||!p){return false;}var r=o.getRelevantContainer();var e=b.getOverlay(r);if(!e){return false;}v=this._isMoveAvailableOnRelevantContainer(o);if(v){v=this.oBasePlugin.hasStableId(o)&&this.oBasePlugin.hasStableId(p)&&this.oBasePlugin.hasStableId(e);}if(v){var f=O.findAllUniqueAggregationOverlaysInContainer(o,e);var V=f.filter(function(A){return this.checkTargetZone(A,o,c);}.bind(this));if(V.length<1){v=false;}else if(V.length===1){var g=V[0].getChildren().filter(function(j){var k=j.getElement();return(k&&k.getVisible()&&k.getParent());});v=g.length>1;}}return v;}
function h(A,e,r){var o=A.getDesignTimeMetadata();var m=o.getAction("move",e);if(!m){return false;}return this.oBasePlugin.hasChangeHandler(m.changeType,r);}
E.prototype._getMoveAction=function(o){var p,c=o.getParentAggregationOverlay();if(c){p=c.getDesignTimeMetadata();}return p?p.getAction("move",o.getElement()):undefined;};
E.prototype.isMovableType=function(e){return true;};
R.prototype.checkMovable=function(o,c){return i.call(this,o,c);};
R.prototype.checkTargetZone=function(A,o,c){var m=o?o:this.getMovedOverlay();var t=E.prototype.checkTargetZone.call(this,A,m,c);if(!t){return false;}var d=m.getElement();var T=A.getParent();var e=m.getRelevantContainer();var f=T.getElement();var g=A.getDesignTimeMetadata();var v=M.getRelevantContainerForPropagation(g.getData(),d);v=v?v:f;if(!e||!v||!this.oBasePlugin.hasStableId(T)||e!==v){return false;}if(m.getParent().getElement()!==f){var j=B.getBindings(d,d.getModel());if(Object.keys(j).length>0&&d.getBindingContext()&&f.getBindingContext()){var s=U.getEntityTypeByPath(d.getModel(),d.getBindingContext().getPath());var k=U.getEntityTypeByPath(f.getModel(),f.getBindingContext().getPath());if(!(s===k)){return false;}}}return h.call(this,A,d,v);};
R.prototype._isMoveAvailableOnRelevantContainer=function(o){var c,m=this._getMoveAction(o);if(m&&m.changeType){c=o.getRelevantContainer();var r=b.getOverlay(c);if(!this.oBasePlugin.hasStableId(r)){return false;}return this.oBasePlugin.hasChangeHandler(m.changeType,c);}return false;};
R.prototype.buildMoveCommand=function(){var m=this.getMovedOverlay();var p=m.getParentAggregationOverlay();var o=m.getElement();var s=this._getSource();var r=m.getRelevantContainer();var t=O.getParentInformation(m);var S=s.index;var T=t.index;var c=this._compareSourceAndTarget(s,t);if(c){return Promise.resolve();}delete s.index;delete t.index;var d=this._getMoveAction(m);var v=this.oBasePlugin.getVariantManagementReference(m,d,true);return this.getCommandFactory().getCommandFor(r,"Move",{movedElements:[{element:o,sourceIndex:S,targetIndex:T}],source:s,target:t},p.getDesignTimeMetadata(),v);};
return R;},true);
sap.ui.predefine('sap/ui/rta/plugin/Remove',['sap/ui/rta/plugin/Plugin','sap/ui/rta/Utils','sap/ui/rta/command/CompositeCommand','sap/ui/dt/OverlayRegistry',"sap/ui/events/KeyCodes","sap/base/Log"],function(P,U,C,O,K,L){"use strict";
var R=P.extend("sap.ui.rta.plugin.Remove",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
R.prototype.registerElementOverlay=function(o){if(this.isEnabled([o])){o.attachBrowserEvent("keydown",this._onKeyDown,this);}P.prototype.registerElementOverlay.apply(this,arguments);};
R.prototype._isEditable=function(e){var E=false;var o=e.getElement();var r=this.getAction(e);if(r&&r.changeType){if(r.changeOnRelevantContainer){o=e.getRelevantContainer();}E=this.hasChangeHandler(r.changeType,o)&&this._checkRelevantContainerStableID(r,e);}if(E){return this.hasStableId(e);}return E;};
R.prototype.isEnabled=function(e){var E=e[0];var a=this.getAction(E);var i=false;if(!a){return i;}if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){i=a.isEnabled(E.getElement());}else{i=a.isEnabled;}}else{i=true;}return i&&this._canBeRemovedFromAggregation(e);};
R.prototype._canBeRemovedFromAggregation=function(e){var o=e[0];var E=o.getElement();var p=E.getParent();if(!p){return false;}var a=p.getAggregation(E.sParentAggregationName);if(!Array.isArray(a)){return true;}if(a.length===1){return false;}var n=e.length;var i=a.filter(function(E){var b=O.getOverlay(E);return!(b&&b.getElementVisibility());});return!(i.length===(a.length-n));};
R.prototype._getConfirmationText=function(o){var a=this.getAction(o);if(a&&a.getConfirmationText){return a.getConfirmationText(o.getElement());}};
R.prototype.deregisterElementOverlay=function(o){if(this.isEnabled([o])){o.detachBrowserEvent("keydown",this._onKeyDown,this);}P.prototype.deregisterElementOverlay.apply(this,arguments);};
R.prototype._onKeyDown=function(e){if(e.keyCode===K.DELETE){e.stopPropagation();this.removeElement();}};
R.prototype.removeElement=function(e){var t=e?e:this.getSelectedOverlays();t=t.filter(function(E){return this.isEnabled([E]);},this);if(t.length>0){this.handler(t);}};
R.prototype._getRemoveCommand=function(r,d,v){return this.getCommandFactory().getCommandFor(r,"Remove",{removedElement:r},d,v);};
R.prototype._fireElementModified=function(c){if(c.getCommands().length){this.fireElementModified({"command":c});}};
R.prototype.handler=function(e){var p=[];var c=new C();var s=function(o){o.setSelected(true);setTimeout(function(){o.focus();},0);};var n=R._getElementToFocus(e);e.forEach(function(o){var a;var r=o.getElement();var d=o.getDesignTimeMetadata();var b=this.getAction(o);var v=this.getVariantManagementReference(o,b);var f=this._getConfirmationText(o);a=Promise.resolve().then(function(){if(f){return U.openRemoveConfirmationDialog(r,f);}return true;}).then(function(g){if(g){return this._getRemoveCommand(r,d,v);}return undefined;}.bind(this)).then(function(g){if(g){c.addCommand(g);}});p.push(a);o.setSelected(false);},this);if(p.length){Promise.all(p).then(function(){this._fireElementModified(c);s(n);}.bind(this)).catch(function(E){L.error("Error during remove: ",E);});}else{this._fireElementModified(c);s(n);}};
R._getElementToFocus=function(s){var n;if(s.length===1){var o=s[0];var S=o.getParent().getAggregation(o.sParentAggregationName);if(S.length>1){var i=S.indexOf(o);var c=S.slice(i+1);if(i!==0){c=c.concat(S.slice(0,i).reverse());}n=c.filter(function(a){return a.getElement().getVisible();}).shift();}}if(!n){n=O.getOverlay(s[0].getRelevantContainer());}return n;};
R.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_REMOVE",rank:60,icon:"sap-icon://hide"});};
R.prototype.getActionName=function(){return"remove";};
return R;},true);
sap.ui.predefine('sap/ui/rta/plugin/Rename',['sap/ui/rta/plugin/Plugin','sap/ui/rta/plugin/RenameHandler',"sap/base/Log"],function(P,R,L){"use strict";
var a=P.extend("sap.ui.rta.plugin.Rename",{metadata:{library:"sap.ui.rta",properties:{oldValue:"string"},associations:{},events:{"editable":{},"nonEditable":{}}}});
a.prototype.exit=function(){P.prototype.exit.apply(this,arguments);this._bPreventMenu=false;R._exit.call(this);};
a.prototype.setDesignTime=function(d){R._setDesignTime.call(this,d);};
a.prototype.startEdit=function(o){var e=o.getElement(),d=o.getDesignTimeMetadata(),D=d.getAction("rename",e).domRef;R.startEdit.call(this,{overlay:o,domRef:D,pluginMethodName:"plugin.Rename.startEdit"});};
a.prototype.stopEdit=function(r){R._stopEdit.call(this,r,"plugin.Rename.stopEdit");};
a.prototype.handler=function(e){this.startEdit(e[0]);};
a.prototype.isRenameAvailable=function(o){return this._isEditableByPlugin(o);};
a.prototype.isRenameEnabled=function(o){return this.isEnabled(o);};
a.prototype.isEnabled=function(e){if(e.length>1){return false;}var o=e[0];var i=true;var A=this.getAction(o);if(!A){i=false;}if(i&&typeof A.isEnabled!=="undefined"){if(typeof A.isEnabled==="function"){i=A.isEnabled(o.getElement());}else{i=A.isEnabled;}}if(i){var d=o.getDesignTimeMetadata();if(!d.getAssociatedDomRef(o.getElement(),A.domRef)){i=false;}}return i;};
a.prototype.registerElementOverlay=function(o){o.attachEvent("editableChange",R._manageClickEvent,this);P.prototype.registerElementOverlay.apply(this,arguments);};
a.prototype._isEditable=function(o){var e=false;var E=o.getElement();var r=this.getAction(o);if(r&&r.changeType){if(r.changeOnRelevantContainer){E=o.getRelevantContainer();}e=this.hasChangeHandler(r.changeType,E)&&this._checkRelevantContainerStableID(r,o);}if(e){return this.hasStableId(o);}return e;};
a.prototype.deregisterElementOverlay=function(o){o.detachEvent("editableChange",R._manageClickEvent,this);o.detachBrowserEvent("click",R._onClick,this);this.removeFromPluginsList(o);};
a.prototype._emitLabelChangeEvent=function(){var t=R._getCurrentEditableFieldText.call(this);if(this.getOldValue()!==t){this._$oEditableControlDomRef.text(t);return Promise.resolve(this._oEditedOverlay).then(function(e){var r=e.getElement();var d=e.getDesignTimeMetadata();var o=this.getAction(e);var v=this.getVariantManagementReference(e,o);return this.getCommandFactory().getCommandFor(r,"rename",{renamedElement:r,newValue:t},d,v);}.bind(this)).then(function(r){this.fireElementModified({"command":r});}.bind(this)).catch(function(e){L.error("Error during rename : ",e);});}return Promise.resolve();};
a.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_RENAME",rank:10,icon:"sap-icon://edit"});};
a.prototype.getActionName=function(){return"rename";};
a.prototype.isBusy=function(){return this._bPreventMenu;};
return a;},true);
sap.ui.predefine('sap/ui/rta/plugin/RenameHandler',["sap/ui/thirdparty/jquery",'sap/ui/rta/plugin/Plugin','sap/ui/dt/Overlay','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/OverlayRegistry','sap/ui/rta/Utils','sap/ui/dt/DOMUtil',"sap/ui/events/KeyCodes"],function(q,P,O,E,a,b,U,D,K){"use strict";var R={_manageClickEvent:function(e){var o=e.getSource?e.getSource():e;if(o.isSelected()&&this.isRenameAvailable(o)&&this.isRenameEnabled([o])){o.attachBrowserEvent("click",R._onClick,this);}else{o.detachBrowserEvent("click",R._onClick,this);}},startEdit:function(p){this._bPreventMenu=true;this._oEditedOverlay=p.overlay;var e=p.overlay.getElement();var d=this._oEditedOverlay.getDesignTimeMetadata();var v=d.getAssociatedDomRef(e,p.domRef);if(!U.isElementInViewport(v)){v.get(0).scrollIntoView();}this._$oEditableControlDomRef=q(v);var w=0;var o=b.getOverlay(v instanceof q?v.get(0).id:v.id);if(!o){o=this._oEditedOverlay;var _=q(E.getDomRef(e));var c=this._$oEditableControlDomRef.parent();var C=parseInt(_.outerWidth(),10);if(!isNaN(C)){var i=parseInt(this._$oEditableControlDomRef.outerWidth(),10);var f=parseInt(c.outerWidth(),10);w=C-i;if(w<0&&f){if(c.get(0).id!==_.get(0).id&&c.children(":visible").length===1&&c.children(":visible").get(0).id===this._$oEditableControlDomRef.get(0).id&&C>f){w=C-f;}else{w=0;}}}}var g=q("<div class='sapUiRtaEditableField'></div>").css({"white-space":"nowrap","overflow":"hidden","width":"calc(100% - ("+w+"px))"}).appendTo(o.$());this._$editableField=q("<div contentEditable='true'></div>").appendTo(g);if(this._$oEditableControlDomRef.text()===""){this._$oEditableControlDomRef.text("_?_");this._$editableField.text("");}else{this._$editableField.text(this._$oEditableControlDomRef.text());}this.setOldValue(R._getCurrentEditableFieldText.call(this));D.copyComputedStyle(this._$oEditableControlDomRef,this._$editableField);this._$editableField.children().remove();this._$editableField.css('visibility','hidden');this._$editableField.css({"-moz-user-modify":"read-write","-webkit-user-modify":"read-write","-ms-user-modify":"read-write","user-modify":"read-write","text-overflow":"clip","white-space":"nowrap"});if(sap.ui.Device.browser.name=="ed"&&e.getMetadata().getName()=="sap.ui.fl.variants.VariantManagement"){this._$editableField.css({"line-height":"normal"});}O.getMutationObserver().ignoreOnce({target:this._$oEditableControlDomRef.get(0)});this._$editableField.one("focus",R._onEditableFieldFocus.bind(this));this._$editableField.on("blur",R._onEditableFieldBlur.bind(this));this._$editableField.on("keydown",R._onEditableFieldKeydown.bind(this));this._$editableField.on("dragstart",R._stopPropagation.bind(this));this._$editableField.on("drag",R._stopPropagation.bind(this));this._$editableField.on("dragend",R._stopPropagation.bind(this));this._$editableField.on("click",R._stopPropagation.bind(this));this._$editableField.on("mousedown",R._stopPropagation.bind(this));setTimeout(function(){this._$oEditableControlDomRef.css("visibility","hidden");g.offset({left:this._$oEditableControlDomRef.offset().left});this._$editableField.offset({left:this._$oEditableControlDomRef.offset().left});this._$editableField.offset({top:this._$oEditableControlDomRef.offset().top});this._$editableField.css('visibility','');this._$editableField.focus();p.overlay.setSelected(true);sap.ui.getCore().getEventBus().publish('sap.ui.rta',p.pluginMethodName,{overlay:p.overlay,editableField:this._$editableField});}.bind(this),0);},_setDesignTime:function(d){this._aSelection=[];var o=this.getDesignTime();if(o){o.getSelectionManager().detachChange(R._onDesignTimeSelectionChange,this);}P.prototype.setDesignTime.apply(this,arguments);if(d){d.getSelectionManager().attachChange(R._onDesignTimeSelectionChange,this);this._aSelection=this.getSelectedOverlays();}},_onDesignTimeSelectionChange:function(e){var s=e.getParameter("selection");this._aSelection.forEach(R._manageClickEvent,this);s.forEach(R._manageClickEvent,this);this._aSelection=s;},_stopPropagation:function(e){e.stopPropagation();},_preventDefault:function(e){e.preventDefault();},_onEditableFieldFocus:function(e){var c=e.target;var r=document.createRange();r.selectNodeContents(c);var s=window.getSelection();s.removeAllRanges();s.addRange(r);},_stopEdit:function(r,p){var o;this._bPreventMenu=false;if(this._$oEditableControlDomRef.text()==="_?_"){this._$oEditableControlDomRef.text("");}this._oEditedOverlay.$().find(".sapUiRtaEditableField").remove();O.getMutationObserver().ignoreOnce({target:this._$oEditableControlDomRef.get(0)});this._$oEditableControlDomRef.css("visibility","visible");if(r){o=this._oEditedOverlay;o.setSelected(true);o.focus();}delete this._$editableField;delete this._$oEditableControlDomRef;delete this._oEditedOverlay;delete this._bBlurOrKeyDownStarted;sap.ui.getCore().getEventBus().publish('sap.ui.rta',p,{overlay:o});},_onEditableFieldBlur:function(e){return R._handlePostRename.call(this,false);},_handlePostRename:function(r,e){if(!this._bBlurOrKeyDownStarted){this._bBlurOrKeyDownStarted=true;if(e){R._preventDefault.call(this,e);R._stopPropagation.call(this,e);}return this._emitLabelChangeEvent().then(function(f){this.stopEdit(r);if(typeof f==="function"){f();}}.bind(this));}return Promise.resolve();},_onEditableFieldKeydown:function(e){switch(e.keyCode){case K.ENTER:return R._handlePostRename.call(this,true,e);case K.ESCAPE:this.stopEdit(true);R._preventDefault.call(this,e);break;case K.DELETE:R._stopPropagation.call(this,e);break;default:}return Promise.resolve();},_getCurrentEditableFieldText:function(){var t=this._$editableField.text().trim();return t===""?'\xa0':t;},_onClick:function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);if(this.isRenameEnabled([o])&&!e.metaKey&&!e.ctrlKey){this.startEdit(o);R._preventDefault.call(this,e);}},_exit:function(){if(this._$oEditableControlDomRef){this.stopEdit(false);}}};return R;},true);
sap.ui.predefine('sap/ui/rta/plugin/Selection',['sap/ui/rta/plugin/Plugin','sap/ui/rta/Utils','sap/ui/fl/Utils','sap/ui/dt/OverlayRegistry',"sap/ui/events/KeyCodes","sap/ui/dt/Overlay","sap/ui/dt/Util","sap/ui/Device"],function(P,U,F,O,K,a,D,b){"use strict";
var S=P.extend("sap.ui.rta.plugin.Selection",{metadata:{library:"sap.ui.rta",properties:{multiSelectionRequiredPlugins:{type:"string[]"}},associations:{},events:{elementEditableChange:{parameters:{editable:{type:"boolean"}}}}}});
S.prototype.init=function(){this._multiSelectionValidator=this._multiSelectionValidator.bind(this);P.prototype.init.apply(this,arguments);};
S.prototype._checkDeveloperMode=function(o,f){if(f){var g=this.getCommandFactory().getFlexSettings().developerMode;if(g&&this.hasStableId(o)){o.setEditable(true);o.setSelectable(true);this.fireElementEditableChange({editable:true});return true;}}return false;};
S.prototype.registerElementOverlay=function(o){var f=o.getDesignTimeMetadata();if(!f.markedAsNotAdaptable()&&!this._checkDeveloperMode(o,f)){o.attachEditableChange(this._onEditableChange,this);this._adaptSelectable(o);}o.attachBrowserEvent("click",this._selectOverlay,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);o.attachBrowserEvent("mousedown",this._onMouseDown,this);o.attachBrowserEvent("mouseover",this._onMouseover,this);o.attachBrowserEvent("mouseleave",this._onMouseleave,this);};
S.prototype._onEditableChange=function(E){var o=E.getSource();this._adaptSelectable(o);};
S.prototype._adaptSelectable=function(o){var s=o.getEditable();if(o.getSelectable()!==s){o.setSelectable(s);if(!s){this._removePreviousHover();}this.fireElementEditableChange({editable:s});}};
S.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("click",this._selectOverlay,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);o.detachBrowserEvent("mousedown",this._onMouseDown,this);o.detachBrowserEvent("mouseover",this._onMouseover,this);o.detachBrowserEvent("mouseleave",this._onMouseleave,this);o.detachEditableChange(this._onEditableChange,this);};
S.prototype._setFocusOnOverlay=function(o,E){if(o&&o.getSelectable()){o.focus();E.stopPropagation();}};
S.prototype._onKeyDown=function(E){var o=U.getFocusedOverlay();if(E.keyCode===K.ENTER){this._selectOverlay(E);}else if(E.keyCode===K.ARROW_UP&&E.shiftKey===false&&E.altKey===false){if(o){var p=U.getFocusableParentOverlay(o);this._setFocusOnOverlay(p,E);E.preventDefault();}}else if(E.keyCode===K.ARROW_DOWN&&E.shiftKey===false&&E.altKey===false){if(o){var f=U.getFirstFocusableDescendantOverlay(o);this._setFocusOnOverlay(f,E);E.preventDefault();}}else if(E.keyCode===K.ARROW_LEFT&&E.shiftKey===false&&E.altKey===false){if(o){var g=U.getPreviousFocusableSiblingOverlay(o);this._setFocusOnOverlay(g,E);E.preventDefault();}}else if(E.keyCode===K.ARROW_RIGHT&&E.shiftKey===false&&E.altKey===false){if(o){var n=U.getNextFocusableSiblingOverlay(o);this._setFocusOnOverlay(n,E);E.preventDefault();}}};
S.prototype._selectOverlay=function(E){var o=O.getOverlay(E.currentTarget.id);var m=E.metaKey||E.ctrlKey;if(o&&o.getSelectable()){if(o.isSelected()){this.getDesignTime().getSelectionManager().remove(o);}else{if(m){this.getDesignTime().getSelectionManager().add(o);}else{this.getDesignTime().getSelectionManager().set(o);}}E.preventDefault();E.stopPropagation();}};
S.prototype._onMouseDown=function(E){if(b.browser.name=="ie"){var t=O.getOverlay(E.target.id);var T=jQuery(E.target).hasClass("sapUiDtOverlayScrollContainer");var o=O.getOverlay(E.currentTarget.id);if(o&&(T||t instanceof a)){if(o.getSelectable()){o.focus();E.stopPropagation();}else{o.getDomRef().blur();}}}};
S.prototype._onMouseover=function(E){var o=O.getOverlay(E.currentTarget.id);if(o.isSelectable()){if(o!==this._oHoverTarget){this._removePreviousHover();this._oHoverTarget=o;o.addStyleClass("sapUiRtaOverlayHover");}E.preventDefault();E.stopPropagation();}};
S.prototype._onMouseleave=function(E){var o=O.getOverlay(E.currentTarget.id);if(o.isSelectable()){this._removePreviousHover();E.preventDefault();E.stopPropagation();}};
S.prototype._removePreviousHover=function(){if(this._oHoverTarget){this._oHoverTarget.removeStyleClass("sapUiRtaOverlayHover");}delete this._oHoverTarget;};
S.prototype.setDesignTime=function(o){if(this.getDesignTime()){this.getDesignTime().getSelectionManager().removeValidator(this._multiSelectionValidator);}P.prototype.setDesignTime.apply(this,arguments);if(this.getDesignTime()){this.getDesignTime().getSelectionManager().addValidator(this._multiSelectionValidator);}};
S.prototype._multiSelectionValidator=function(E){return(E.length===1||(_(E,this.getMultiSelectionRequiredPlugins())&&c(E)&&(d(E)||e(E))));};
function _(E,m){var s=m.slice();E.forEach(function(o){s=D.intersection(s,o.getEditableByPlugins());});return s.length>0;}
function c(E){return E.every(function(o){return o.getRelevantContainer()===E[0].getRelevantContainer();});}
function d(E){return E.every(function(o){return o.getParentElementOverlay()===E[0].getParentElementOverlay();});}
function e(E){return E.every(function(o){return o.getElement().getMetadata().getName()===E[0].getElement().getMetadata().getName();});}
return S;},true);
sap.ui.predefine('sap/ui/rta/plugin/Settings',['sap/ui/rta/plugin/Plugin','sap/ui/rta/Utils','sap/ui/dt/Util','sap/base/Log'],function(P,U,D,B){"use strict";
var S=P.extend("sap.ui.rta.plugin.Settings",{metadata:{library:"sap.ui.rta",properties:{commandStack:{type:"any"}},associations:{},events:{}}});
S.prototype._isEditable=function(o){var s=this.getAction(o);if(s){if(s.handler){return this.hasStableId(o);}else{var h=Object.keys(s).some(function(a){var b=s[a];return b.handler&&this._checkRelevantContainerStableID(b,o);}.bind(this));if(h){return this.hasStableId(o);}}}return false;};
S.prototype.isEnabled=function(e){var E=e[0];var a=this.getAction(E);if(!a){return false;}if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){return a.isEnabled(E.getElement());}else{return a.isEnabled;}}return true;};
S.prototype._getUnsavedChanges=function(i,c){var e;var u=this.getCommandStack().getAllExecutedCommands().filter(function(C){e=C.getElementId&&C.getElementId()||C.getElement&&C.getElement().getId();if(e===i&&c.indexOf(C.getChangeType())>=0){return true;}}).map(function(C){return C.getPreparedChange();});return u;};
S.prototype._handleFlexChangeCommand=function(c,s,C){var m=c.changeSpecificData;var v;var a=c.selectorControl;var b;var o;if(a.controlType){b=a.controlType;}else{o=a;}var d=this._getChangeHandler(m.changeType,o,b);if(s[0].getVariantManagement&&d&&d.revertChange){v=s[0].getVariantManagement();}return this.getCommandFactory().getCommandFor(a,"settings",m,undefined,v).then(function(e){return C.addCommand(e);});};
S.prototype._handleAppDescriptorChangeCommand=function(c,e,C){var m=c.changeSpecificData;var o=c.appComponent;var M=o.getManifest();var r=M["sap.app"].id;return this.getCommandFactory().getCommandFor(e,"appDescriptor",{reference:r,appComponent:o,changeType:m.appDescriptorChangeType,parameters:m.content.parameters,texts:m.content.texts}).then(function(a){return C.addCommand(a);});};
S.prototype._handleCompositeCommand=function(e,E,c){var C;return this.getCommandFactory().getCommandFor(E,"composite").then(function(_){C=_;}).then(function(){return c.map(function(m){var a=m.changeSpecificData;if(a.changeType){return this._handleFlexChangeCommand(m,e,C);}else if(a.appDescriptorChangeType){return this._handleAppDescriptorChangeCommand(m,E,C);}},this);}.bind(this)).then(function(p){return Promise.all(p);}).then(function(){if(C.getCommands().length>0){this.fireElementModified({"command":C});}}.bind(this));};
S.prototype.handler=function(e,p){p=p||{};var E=e[0].getElement();var h=p.fnHandler;if(!h){h=e[0].getDesignTimeMetadata().getAction("settings").handler;if(!h){throw new Error("Handler not found for settings action");}}p.getUnsavedChanges=this._getUnsavedChanges.bind(this);p.styleClass=U.getRtaStyleClassName();return h(E,p).then(function(c){if(c.length>0){return this._handleCompositeCommand(e,E,c);}}.bind(this)).catch(function(v){throw D.propagateError(v,"Settings#handler","Error occured during handler execution","sap.ui.rta.plugin");});};
S.prototype.getMenuItems=function(e){var E=e[0];var s=this.getAction(E);var r=110;var p="CTX_SETTINGS";if(s){if(s.handler&&this._checkRelevantContainerStableID(s,E)){return this._getMenuItems([E],{pluginId:p,rank:r,icon:this._getActionIcon(s)});}else{var m=[];var a=Object.keys(s);var A=0;a.forEach(function(b){var o=s[b];var c=this.getActionText(E,o,o.name);if(o.handler&&this._checkRelevantContainerStableID(o,E)){m.push({id:p+A,text:c,icon:this._getActionIcon(o),enabled:(typeof o.isEnabled==='function'&&(function(e){return o.isEnabled(e[0].getElement());})||o.isEnabled),handler:function(h,e,d){d=d||{};d.fnHandler=h;return this.handler(e,d);}.bind(this,o.handler),rank:r+A});A++;}else{B.warning("Handler not found for settings action '"+c+"' or relevant container has no stable id");}},this);return m;}}};
S.prototype._getActionIcon=function(s){var d="sap-icon://key-user-settings",a=s.icon;if(!a){return d;}if(typeof a!=="string"){B.error("Icon setting for settingsAction should be a string");return d;}return a;};
S.prototype.getActionName=function(){return"settings";};
return S;},true);
sap.ui.predefine('sap/ui/rta/plugin/Split',['sap/ui/rta/plugin/Plugin','sap/ui/dt/Util','sap/ui/fl/Utils',"sap/base/util/uid"],function(P,D,F,u){"use strict";
var S=P.extend("sap.ui.rta.plugin.Split",{metadata:{library:"sap.ui.rta",properties:{},associations:{},events:{}}});
S.prototype._isEditable=function(o){var s=this.getAction(o);if(s&&s.changeType&&s.changeOnRelevantContainer){return this.hasChangeHandler(s.changeType,o.getRelevantContainer())&&this.hasStableId(o)&&this._checkRelevantContainerStableID(s,o);}else{return false;}};
S.prototype.isAvailable=function(e){if(e.length!==1){return false;}var E=e[0];if(!this._isEditableByPlugin(E)){return false;}var s=this.getAction(E);var o=E.getElement();if(s&&s.getControlsCount(o)<=1){return false;}return true;};
S.prototype.isEnabled=function(e){var E=e[0];var a=this.getAction(E);if(!a||!this.isAvailable(e)){return false;}var A=true;if(typeof a.isEnabled!=="undefined"){if(typeof a.isEnabled==="function"){A=a.isEnabled(E.getElement());}else{A=a.isEnabled;}}return A;};
S.prototype.handleSplit=function(e){var s=e.getElement();var p=s.getParent();var d=e.getDesignTimeMetadata();var f=this.getAction(e).getControlsCount(s);var v=F.getViewForControl(s);var n=[];for(var i=0;i<f-1;i++){n.push(v.createId(u()));}var o=this.getAction(e);var V=this.getVariantManagementReference(e,o);return this.getCommandFactory().getCommandFor(s,"split",{newElementIds:n,source:s,parentElement:p},d,V).then(function(a){this.fireElementModified({"command":a});}.bind(this)).catch(function(E){throw D.propagateError(E,"Split#handleSplit","Error occured during handleSplit execution","sap.ui.rta.plugin");});};
S.prototype.getMenuItems=function(e){return this._getMenuItems(e,{pluginId:"CTX_UNGROUP_FIELDS",rank:100,icon:"sap-icon://split"});};
S.prototype.getActionName=function(){return"split";};
S.prototype.handler=function(e){this.handleSplit(e[0]);};
return S;},true);
sap.ui.predefine('sap/ui/rta/plugin/Stretch',["sap/ui/rta/plugin/Plugin","sap/ui/dt/OverlayUtil","sap/ui/core/Control"],function(P,O,C){"use strict";
var S=P.extend("sap.ui.rta.plugin.Stretch",{metadata:{library:"sap.ui.rta",properties:{},associations:{stretchCandidates:{type:"sap.ui.dt.ElementOverlay",multiple:true}},events:{}}});
S.prototype.setDesignTime=function(d){P.prototype.setDesignTime.apply(this,arguments);if(d){d.attachEventOnce("synced",this._setStyleClassForAllStretchCandidates,this);}};
S.prototype.registerElementOverlay=function(o){this._checkAndAddToStretchCandidates(o);P.prototype.registerElementOverlay.apply(this,arguments);};
S.prototype.deregisterElementOverlay=function(o){if(o.getElement()instanceof C){o.getElement().removeStyleClass("sapUiRtaStretchPaddingTop");}o.detachEditableChange(this._toggleStyleClass,this);};
S.prototype._isEditable=function(){return false;};
S.prototype._checkAndAddToStretchCandidates=function(o){var p=o.getParentElementOverlay();if(p&&p.getElement()instanceof C){if(this._startAtSamePosition(p,o)){if(this._childrenAreSameSize(p)){this.addStretchCandidate(p);}}}};
S.prototype._startAtSamePosition=function(p,o){if(p&&p.getGeometry()&&o.getGeometry()){if(p.getGeometry().position.top===o.getGeometry().position.top&&p.getGeometry().position.left===o.getGeometry().position.left){return true;}}};
S.prototype._childrenAreSameSize=function(r,c){var p=r.getGeometry().size.width*r.getGeometry().size.height;c=c||O.getAllChildOverlays(r);var a=c.map(function(b){return b.getGeometry();});var o=O.getGeometry(a);if(!o){return false;}var i=o.size.width*o.size.height;return i===p;};
S.prototype._atLeastOneDescendantEditable=function(r,c){var a=c.some(function(o){return o.getEditable()&&o.getGeometry();});if(a){return true;}else{var b=[];c.forEach(function(o){b=b.concat(O.getAllChildOverlays(o));});if(!b.length>0){return false;}if(this._childrenAreSameSize(r,b)){return this._atLeastOneDescendantEditable(r,b);}}};
S.prototype._setStyleClassForAllStretchCandidates=function(){this.getStretchCandidates().forEach(function(o){var a=sap.ui.getCore().byId(o);var A=false;var c=O.getAllChildOverlays(a);var b=this._atLeastOneDescendantEditable(a,c);if(a.getEditable()&&b){A=true;}if(A){this._toggleStyleClass({},true,a);}a.attachEditableChange(this._toggleStyleClass,this);},this);};
S.prototype._toggleStyleClass=function(p,f,o){o=o||p.getSource();if(f||p.getParameters().editable){o.getElement().addStyleClass("sapUiRtaStretchPaddingTop");}else{o.getElement().removeStyleClass("sapUiRtaStretchPaddingTop");}};
return S;},true);
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AddElementsDialog',['sap/ui/base/ManagedObject','sap/m/Label','sap/m/Dialog','sap/ui/model/json/JSONModel','sap/m/SearchField','sap/m/Button','sap/m/Toolbar','sap/m/ToolbarSpacer','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/rta/command/CommandFactory','sap/ui/rta/command/CompositeCommand','sap/m/List','sap/m/CustomListItem','sap/m/ScrollContainer','sap/ui/model/Sorter','sap/ui/dt/ElementUtil','sap/m/VBox','sap/ui/rta/Utils','sap/m/library'],function(M,L,D,J,S,B,T,a,F,b,C,c,d,e,f,g,E,V,U,m){"use strict";var h=m.ListType;var i=m.LabelDesign;
var A=M.extend("sap.ui.rta.plugin.additionalElements.AddElementsDialog",{metadata:{library:"sap.ui.rta",properties:{"customFieldEnabled":{type:"boolean",defaultValue:false},"title":{type:"string"}},events:{"opened":{},"openCustomField":{}}}});
A.prototype.init=function(){this._oTextResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");this._bAscendingSortOrder=false;this._oDialog=new D().addStyleClass("sapUIRtaFieldRepositoryDialog");this._oDialog.addStyleClass(U.getRtaStyleClassName());this._oDialog.removeStyleClass("sapUiPopupWithPadding");this._oDialog.setModel(new J({elements:[]}));var j=this._createContent();var k=this._createButtons();j.forEach(function(o){this._oDialog.addContent(o);},this);k.forEach(function(o){this._oDialog.addButton(o);},this);this._oDialog.setInitialFocus(this._oInput);};
A.prototype._createContent=function(){this._oInput=new S({width:"100%",liveChange:[this._updateModelFilter,this]});var r=new B({text:"",icon:"sap-icon://sort",press:[this._resortList,this]});this._oCustomFieldButton=new B({text:"",icon:"sap-icon://add",tooltip:this._oTextResources.getText("BTN_FREP_CCF"),enabled:this.getCustomFieldEnabled(),press:[this._redirectToCustomFieldCreation,this]});this._oToolbarSpacer1=new a();this.oInputFields=new T({content:[this._oInput,r,this._oToolbarSpacer1,this._oCustomFieldButton]});var o=new L({design:i.Standard,tooltip:"{tooltip}",text:{parts:[{path:"label"},{path:"referencedComplexPropertyName"},{path:"duplicateComplexName"}],formatter:function(n,R,p){if(p&&R){n+=" ("+R+")";}return n;}}});var j=new L({text:{parts:[{path:"originalLabel"}],formatter:function(O){if(O){return this._oTextResources.getText("LBL_FREP",O);}return"";}.bind(this)},visible:{parts:[{path:"originalLabel"}],formatter:function(O){if(O){return true;}return false;}}});var v=new V();v.addItem(o);v.addItem(j);var s=new g("label",this._bAscendingSortOrder);this._oList=new d({mode:"MultiSelect",includeItemInSelection:true,growing:true,growingScrollToLoad:true}).setNoDataText(this._oTextResources.getText("MSG_NO_FIELDS",this._oTextResources.getText("MULTIPLE_CONTROL_NAME").toLowerCase()));var l=new e({type:h.Active,selected:"{selected}",content:[v]});this._oList.bindItems({path:"/elements",template:l,sorter:s});var k=new f({content:this._oList,vertical:true,horizontal:false}).addStyleClass("sapUIRtaCCDialogScrollContainer");return[this.oInputFields,k];};
A.prototype._createButtons=function(){this._oOKButton=new B({text:this._oTextResources.getText("BTN_FREP_OK"),press:[this._submitDialog,this]});var o=new B({text:this._oTextResources.getText("BTN_FREP_CANCEL"),press:[this._cancelDialog,this]});return[this._oOKButton,o];};
A.prototype._submitDialog=function(){this._oDialog.close();this._fnResolve();};
A.prototype._cancelDialog=function(){this._oList.removeSelections();this._oDialog.close();this._fnReject();};
A.prototype.setElements=function(j){this._oDialog.getModel().setProperty("/elements",j);};
A.prototype.getElements=function(){return this._oDialog.getModel().getProperty("/elements");};
A.prototype.getSelectedElements=function(){return this._oDialog.getModel().getObject("/elements").filter(function(o){return o.selected;});};
A.prototype.open=function(o){return new Promise(function(r,j){this._fnResolve=r;this._fnReject=j;this._oDialog.oPopup.attachOpened(function(){this.fireOpened();}.bind(this));this._oDialog.open();}.bind(this));};
A.prototype._resortList=function(o){this._bAscendingSortOrder=!this._bAscendingSortOrder;var j=this._oList.getBinding("items");var s=[];s.push(new g("label",this._bAscendingSortOrder));j.sort(s);};
A.prototype._updateModelFilter=function(o){var v=o.getParameter("newValue");var j=this._oList.getBinding("items");if((typeof v)==="string"){var k=new F("label",b.Contains,v);var O=new F("originalLabel",b.Contains,v);var r=new F("referencedComplexPropertyName",b.Contains,v);var l=new F("duplicateComplexName",b.EQ,true);var n=new F({filters:[r,l],and:true});var p=new F({filters:[k,O,n],and:false});j.filter([p]);}else{j.filter([]);}};
A.prototype._redirectToCustomFieldCreation=function(o){this.fireOpenCustomField();this._oDialog.close();};
A.prototype.setTitle=function(t){M.prototype.setProperty.call(this,"title",t,true);this._oDialog.setTitle(t);};
A.prototype.setCustomFieldEnabled=function(j){M.prototype.setProperty.call(this,"customFieldEnabled",j,true);this._oCustomFieldButton.setEnabled(j);};
return A;},true);
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer',["sap/ui/thirdparty/jquery",'sap/ui/core/StashedControlSupport','sap/ui/dt/ElementUtil','sap/ui/rta/Utils','sap/ui/rta/util/BindingsExtractor'],function(q,S,E,R,B){"use strict";
function _(P,i){var j=q.extend({},P);j.entityName=i.name;var l=P["com.sap.vocabularies.Common.v1.Label"];j.fieldLabel=l&&l.String;var Q=P["com.sap.vocabularies.Common.v1.QuickInfo"];j.quickInfo=Q&&Q.String;var H=P["com.sap.vocabularies.UI.v1.Hidden"];j.hidden=H&&H.Bool==="true";if(!j.hidden){var F=P["com.sap.vocabularies.Common.v1.FieldControl"];if(F){j.hidden=F.EnumMember==="com.sap.vocabularies.Common.v1.FieldControlType/Hidden";}}return j;}
function a(P){if(P&&P.type){if(P.type.toLowerCase().indexOf("edm")!==0){return true;}}return false;}
function b(O,M,i){return O.reduce(function(j,P){var l=_(P,i);if(a(l)){var C=M.getODataComplexType(l.type);if(C){l=C.property.map(function(w){w=_(w,i);w.bindingPath=l.name+"/"+w.name;w.referencedComplexPropertyName=l.fieldLabel||l.name;return w;});}}else{l.bindingPath=P.name;}return j.concat(l);},[]);}
function c(O,i,j){return O.filter(function(P){return!P.hidden;}).filter(function(P){var F=P["com.sap.vocabularies.Common.v1.FieldControl"];var l=F&&F.Path;if(l){var L=i.getBinding(j)instanceof sap.ui.model.ListBinding;if(L){return true;}var w=i.getBindingContext().getProperty(l);return w!==0;}return true;});}
function d(i,j){if(!i){return false;}var l=i.getBindingInfo(j);var P=l&&l.path;if(!P){return false;}if(P.indexOf(">")>-1){P=P.split(">").pop();}return P.indexOf("/")===0;}
function e(i,j,l){var w;if(j){w=i.getBindingInfo(l);if(typeof w.model==="string"&&w.model!==""){w=undefined;}}else{w=i.getBindingContext();}return w;}
function f(i,j){var l=d(i,j);var w=e(i,l,j);if(w){return l?w.path:w.getPath();}}
function g(i,j){var M=i.getModel();var D={property:[],navigationProperty:[],navigationEntityNames:[]};if(M){var l=M.getMetadata().getName();if(l==="sap.ui.model.odata.ODataModel"||l==="sap.ui.model.odata.v2.ODataModel"){var w=M.getMetaModel();return w.loaded().then(function(){var x=f(i,j);if(x){var y=w.getMetaContext(x);var O=y.getObject();var z=i.getMetadata().getAggregation();if(z){var C=i.getBindingInfo(z.name);var T=C&&C.template;if(T){var P=i.getBindingPath(z.name);var F=w.getODataAssociationEnd(O,P);var G=F&&F.type;if(G){var H=w.getODataEntityType(G);O=H;}}}D.property=O.property||[];D.property=b(D.property,w,O);D.property=c(D.property,i,j);if(O.navigationProperty){D.navigationProperty=O.navigationProperty;O.navigationProperty.forEach(function(N){var G=(w.getODataAssociationEnd(O,N.name)&&w.getODataAssociationEnd(O,N.name).type);var H=w.getODataEntityType(G);if(H&&H.name){if(D.navigationEntityNames.indexOf(H.name)===-1){D.navigationEntityNames.push(H.name);}}});}}return D;});}}return Promise.resolve(D);}
function h(O){return{selected:false,label:O.fieldLabel||O.name,referencedComplexPropertyName:O.referencedComplexPropertyName?O.referencedComplexPropertyName:"",duplicateComplexName:O.duplicateComplexName?O.duplicateComplexName:false,tooltip:O.quickInfo||O.fieldLabel,originalLabel:"",type:"odata",entityType:O.entityName,name:O.name,bindingPath:O.bindingPath};}
function k(D){var i=D.element;var j=D.action;return{selected:false,label:E.getLabelForElement(i,j.getLabel),tooltip:i.quickInfoFromOData||i.name||E.getLabelForElement(i,j.getLabel),referencedComplexPropertyName:i.referencedComplexPropertyName?i.referencedComplexPropertyName:"",duplicateComplexName:i.duplicateComplexName?i.duplicateComplexName:false,bindingPaths:i.bindingPaths,originalLabel:i.renamedLabel&&i.fieldLabel!==i.labelFromOData?i.labelFromOData:"",type:"invisible",elementId:i.getId()};}
function m(i,j,l){if(j&&j!==i){var w=R.getEntityTypeByPath(i.getModel(),f(i,l));return E.findAllSiblingsInContainer(i,j).filter(function(x){var P=f(x,l);if(P){return R.getEntityTypeByPath(x.getModel(),P)===w;}return false;});}else{return[i];}}
function n(O){O.forEach(function(i,l,O){if(i["duplicateComplexName"]!==true){for(var j=l+1;j<O.length-1;j++){if(i.fieldLabel===O[j].fieldLabel){i["duplicateComplexName"]=true;O[j]["duplicateComplexName"]=true;}}}});return O;}
function o(i,O){return O.some(function(D){return D.fieldLabel===i.fieldLabel;});}
function p(I,M){I.bindingPaths=[];I.bindingContextPaths=[];var j=I.sParentAggregationName;var P=I.getParent();var w=B.getBindings(I,M);if(P){var D=P.getMetadata().getAggregation();if(D){var x=E.getAggregation(P,j).indexOf(I);var y=D.name;var z=P.getBindingInfo(y);var T=z&&z.template;if(T){var C=T.getMetadata().getAggregation();if(C){var F=C.name;var G=E.getAggregation(T,F)[x];w=w.concat(B.getBindings(G,null,true));}}}}for(var i=0,l=w.length;i<l;i++){if(w[i].getPath&&w[i].getPath()){if(I.bindingPaths.indexOf(w[i].getPath())===-1){I.bindingPaths.push(w[i].getPath());}}if(w[i].getContext&&w[i].getContext()){if(I.bindingContextPaths.indexOf(w[i].getContext().getPath())===-1){I.bindingContextPaths.push(w[i].getContext().getPath());}}if(q.isPlainObject(w[i])){if(I.bindingPaths.indexOf(w[i].parts[0].path)===-1){I.bindingPaths.push(w[i].parts[0].path);}}}return I;}
function r(i){return Array.isArray(i)&&i.length>0;}
function s(i,N,j,l){var w=r(i)&&i.some(function(P){var y=P.trim().replace(/^\//gi,'').split('/');if(y.length>1){return N.indexOf(y.shift())!==-1;}});var x=l.some(function(C){C=C.match(/^\/?([A-Za-z0-9_]+)/)[0];return(j.indexOf(C)>=0);});return w||x;}
function t(i,O){return O.filter(function(D){return i.indexOf(D.bindingPath)!==-1;}).pop();}
function u(i,O){i.labelFromOData=O.fieldLabel;i.quickInfoFromOData=O.quickInfo;i.name=O.name;if(i.fieldLabel!==i.labelFromOData){i.renamedLabel=true;}if(O.referencedComplexPropertyName){i.referencedComplexPropertyName=O.referencedComplexPropertyName;}}
function v(i,O,N,j){var l=i.bindingPaths,w=i.bindingContextPaths,x;return(!r(l)||s(l,N,j,w)||((x=t(l,O))&&(u(i,x)||true)));}
var A={enhanceInvisibleElements:function(i,j){var M=i.getModel();var l=j.reveal;var w=j.addODataProperty;var D=i.getMetadata().getAggregation();var x=D?D.name:j.aggregation;return Promise.resolve().then(function(){return g(i,x);}).then(function(y){var O=y.property;var z=y.navigationProperty.map(function(N){return N.name;});var C=y.navigationEntityNames;O=n(O);var F=[];var I=l.elements||[];I.forEach(function(G){var H=G.element;var J=G.action;var K=true;if(w){if(f(i,x)===f(H,x)){H=p(H,M);H.fieldLabel=E.getLabelForElement(H,J.getLabel);H.duplicateComplexName=o(H,O);if(O.length>0){K=v(H,O,z,C);}}else if(B.getBindings(H,M).length>0){K=false;}}if(K){F.push({element:H,action:J});}});return F;}).then(function(y){return y.map(k);});},getUnboundODataProperties:function(i,j){var D=i.getMetadata().getAggregation();var l=D?D.name:j.action.aggregation;var M=i.getModel();return Promise.resolve().then(function(){return g(i,l);}).then(function(w){var O=w.property;var x=m(i,j.relevantContainer,l);var y=[];x.forEach(function(i){y=y.concat(B.getBindings(i,M));});var F=j.action.filter?j.action.filter:function(){return true;};O=O.filter(function(z){var H=false;if(y){H=y.some(function(C){return(q.isPlainObject(C)?C.parts[0].path:!!C.getPath&&C.getPath())===z.bindingPath;});}return!H&&F(j.relevantContainer,z);});O=n(O);return O;}).then(function(U){return U.map(h);});}};return A;});
sap.ui.predefine('sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin',["sap/ui/thirdparty/jquery","sap/ui/rta/plugin/Plugin",'sap/ui/dt/ElementUtil','sap/ui/dt/OverlayRegistry','sap/ui/rta/Utils','sap/ui/fl/Utils','sap/ui/dt/Util','sap/ui/core/StashedControlSupport','sap/ui/dt/ElementDesignTimeMetadata',"sap/base/Log"],function(q,P,E,O,U,F,D,S,a,L){"use strict";
function _(s,o){var p,r=o.getRelevantContainer(!s),R=O.getOverlay(r);if(s){p=o.getParentElementOverlay();}else{p=o;}return{relevantContainerOverlay:R,parentOverlay:p,relevantContainer:r,parent:p&&p.getElement()};}
function b(p,C){return C.sParentAggregationName;}
function c(p,s){var o=p.getElement();var i=E.getAggregation(o,s).filter(function(C){var n=O.getOverlay(C);if(!this.hasStableId(n)){return false;}var r=p.getRelevantContainer(true);var R=O.getOverlay(r);var t=p;var u=false;do{u=!t.getElementVisibility();if(u){break;}if(t===R){break;}else{t=t.getParentElementOverlay();}}while(t);if(u){return true;}return n.getElementVisibility()===false;},this);var m=S.getStashedControls(o.getId());return i.concat(m);}
var d=true,e=false;
function f(r,m,p,s,C){var n=[];var i;var o;if(m.addODataProperty){var t=m.aggregation;var u=m.addODataProperty.designTimeMetadata;i=u.getAggregationDescription(t,p);if(i){o=s?i.singular:i.plural;n.push(o);}}if(m.reveal){m.reveal.controlTypeNames.forEach(function(i){o=s?i.singular:i.plural;n.push(o);});}var N=n.reduce(function(v,w){if(v.indexOf(w)===-1){v.push(w);}return v;},[]);var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");if(N.length===1){o=N[0];}else if(C){o=C;}else{o=T.getText("MULTIPLE_CONTROL_NAME");}return T.getText(r,[o]);}
function g(){return{designTimeMetadata:new a({data:{name:{singular:function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("SECTION_CONTROL_NAME");},plural:function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap").getText("SECTION_CONTROL_NAME_PLURAL");}},actions:{reveal:{changeType:"unstashControl",getAggregationName:b}}}}),action:{changeType:"unstashControl",getAggregationName:b}};}
function h(m,r){var R;m.reveal.elements.some(function(i){if(i.element.getId()===r.getId()){R=i;return false;}});return R;}
var A=P.extend("sap.ui.rta.plugin.additionalElements.AdditionalElementsPlugin",{
metadata:{library:"sap.ui.rta",properties:{analyzer:"object",dialog:"object",commandFactory:"object"},associations:{},events:{}},
getContextMenuTitle:function(o,i){var p=_(o,i);var m=this._getActions(o,i);return f("CTX_ADD_ELEMENTS",m,p.parent,d);},
isAvailable:function(o,i){return i.every(function(m){return this._isEditableByPlugin(m,o);},this);},
isEnabled:function(o,i){if(i.length>1){return false;}var m=i[0];var p;var I;if(o){p=m.getParentElementOverlay();if(p){I=true;}else{I=false;}}else{var n=this._getActions(o,m);if(n.reveal&&n.reveal.elements.length===0&&!n.addODataProperty){I=false;}else{I=true;}}return I;},
registerElementOverlay:function(o){var m=o.getElement().getModel();if(m){var M=m.getMetaModel();if(M&&M.loaded){M.loaded().then(function(){this.evaluateEditable([o],{onRegistration:true});}.bind(this));}}P.prototype.registerElementOverlay.apply(this,arguments);},
_getRevealActions:function(s,o){var p=_(s,o);var i=[p.parentOverlay];if(p.relevantContainer!==p.parent){i=E.findAllSiblingsInContainer(p.parent,p.relevantContainer).map(function(n){return O.getOverlay(n);}).filter(function(o){return o;});}var m;if(s){m=[o.getParentAggregationOverlay().getAggregationName()];}else{m=p.parentOverlay.getAggregationOverlays().filter(function(n){return!n.getDesignTimeMetadata().isIgnored(p.parent);}).map(function(n){return n.getAggregationName();});}var r=m.reduce(this._getRevealActionFromAggregations.bind(this,i),{});return r;},
_getRevealActionFromAggregations:function(p,i,s){var I=p.reduce(function(m,o){return o?m.concat(c.call(this,o,s)):m;}.bind(this),[]);var r=I.reduce(this._invisibleToReveal.bind(this),{elements:[],controlTypeNames:[]});if(r.elements.length>0){i[s]={reveal:r};}return i;},
_invisibleToReveal:function(r,i){var t=i.getMetadata().getName();var o;var R;var m=false;if(t==="sap.ui.core._StashedControl"){var s=g();o=s.designTimeMetadata;R=s.action;m=true;}else{var n=O.getOverlay(i);if(n){o=n.getDesignTimeMetadata();R=o&&o.getAction("reveal",i);if(R&&R.changeType){var p=i;if(R.changeOnRelevantContainer){p=n.getRelevantContainer();}if(this.hasChangeHandler(R.changeType,p)){if(R.changeOnRelevantContainer){var u=_(true,n);m=this.hasStableId(u.relevantContainerOverlay)&&this.hasStableId(u.parentOverlay);}else{m=true;}if(!R.getAggregationName){R.getAggregationName=b;}}}}}if(m){r.elements.push({element:i,designTimeMetadata:o,action:R});var N=o.getName(i);if(N){r.controlTypeNames.push(N);}}return r;},
_getAddODataPropertyActions:function(s,o){var p=_(s,o);var i=p.parentOverlay.getDesignTimeMetadata();var m=i.getActionDataFromAggregations("addODataProperty",p.parent);var C=p.parent;var n=function(r,t){if(t){if(t.changeOnRelevantContainer){C=p.relevantContainer;}var u=O.getOverlay(C);if(t.changeType&&this.hasChangeHandler(t.changeType,C)&&this.hasStableId(u)){r[t.aggregation]={addODataProperty:{designTimeMetadata:i,action:t}};}return r;}};if(m&&m.length>0){return m.reduce(n.bind(this),{});}},
_getActions:function(s,o){var r=this._getRevealActions(s,o);var m=this._getAddODataPropertyActions(s,o);var i=q.extend(true,r,m);var n=Object.keys(i);if(n.length===0){return{};}else if(n.length>1){L.error("reveal or addODataProperty action defined for more than 1 aggregation, that is not yet possible");}var p=n[0];i[p].aggregation=p;return i[p];},
_hasRevealActionsOnChildren:function(o){var r=this._getRevealActions(false,o);return Object.keys(r).length>0;},
showAvailableElements:function(o,i,I,C){var m=i[0];var p=_(o,m);var s=o&&m.getElement();var n=[];var r=this._getActions(o,m);if(r.reveal){n.push(this.getAnalyzer().enhanceInvisibleElements(p.parent,r));}if(r.addODataProperty){r.addODataProperty.relevantContainer=m.getRelevantContainer(!o);n.push(this.getAnalyzer().getUnboundODataProperties(p.parent,r.addODataProperty));}if(r.aggregation||C){this._setDialogTitle(r,p.parent,C);}return Promise.resolve().then(function(){if(r.addODataProperty){return U.isServiceUpToDate(p.parent);}}).then(function(){if(r.addODataProperty){this.getDialog()._oCustomFieldButton.setVisible(true);return U.isCustomFieldAvailable(p.parent);}else{this.getDialog()._oCustomFieldButton.setVisible(false);}}.bind(this)).then(function(t){if(t){this._oCurrentFieldExtInfo=t;this.getDialog().setCustomFieldEnabled(true);this.getDialog().detachEvent('openCustomField',this._onOpenCustomField,this);this.getDialog().attachEvent('openCustomField',null,this._onOpenCustomField,this);}}.bind(this)).then(j.bind(null,n)).then(function(t){this.getDialog().setElements(t);return this.getDialog().open().then(function(){return this._createCommands(p,s,r,I);}.bind(this)).catch(function(u){if(u instanceof Error){throw u;}});}.bind(this)).catch(function(t){if(t instanceof Error){throw t;}else{L.info("Service not up to date, skipping add dialog","sap.ui.rta");}});},
_setDialogTitle:function(m,p,C){var s=f("HEADER_ADDITIONAL_ELEMENTS",m,p,e,C);this.getDialog().setTitle(s);if(C){this.getDialog()._oList.setNoDataText(this.getDialog()._oTextResources.getText("MSG_NO_FIELDS",C.toLowerCase()));}},
_onOpenCustomField:function(o){var C=sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getService("CrossApplicationNavigation");var H=(C&&C.hrefForExternal({target:{semanticObject:"CustomField",action:"develop"},params:{businessContexts:this._oCurrentFieldExtInfo.BusinessContexts,serviceName:this._oCurrentFieldExtInfo.ServiceName,serviceVersion:this._oCurrentFieldExtInfo.ServiceVersion,entityType:this._oCurrentFieldExtInfo.EntityType}}));U.openNewWindow(H);},
_createCommands:function(p,s,m,i){var n=this.getDialog().getSelectedElements();if(n.length>0){return this.getCommandFactory().getCommandFor(p.parent,"composite").then(function(C){var o=Promise.resolve();n.forEach(function(r){switch(r.type){case"invisible":o=o.then(this._createCommandsForInvisibleElement.bind(this,C,r,p,s,m,i));break;case"odata":o=o.then(this._createCommandsForODataElement.bind(this,C,r,p,s,m,i));break;default:L.error("Can't create command for untreated element.type "+r.type);}},this);return o.then(function(){return C;});}.bind(this)).then(function(C){this.fireElementModified({"command":C});}.bind(this)).catch(function(M){throw D.propagateError(M,"AdditionalElementsPlugin#_createCommands","Error occured during _createCommands execution","sap.ui.rta.plugin");});}return Promise.resolve();},
_createCommandsForInvisibleElement:function(C,s,p,o,m,i){return this._createRevealCommandForInvisible(s,m,p,o).then(function(r){C.addCommand(r);return this._createMoveCommandForInvisible(s,m,p,o,i);}.bind(this)).then(function(M){if(M){C.addCommand(M);}else{L.warning("No move action configured for "+p.parent.getMetadata().getName()+", aggregation: "+m.aggregation,"sap.ui.rta");}return C;});},
_createCommandsForODataElement:function(C,s,p,o,m,i){var n=p.parentOverlay.getAggregationOverlay(m.aggregation);var r=n.getDesignTimeMetadata();var t=r.getAction("addODataProperty",p.parent);var u=t.changeHandlerSettings;var R;if(u&&u.content){R=u.content.requiredLibraries;}return Promise.resolve().then(function(){if(R){return this._createCommandForAddLibrary(p,m,R,r).then(function(v){C.addCommand(v);});}}.bind(this)).then(this._createCommandForOData.bind(this,s,m,p,o,i)).then(function(v){C.addCommand(v);return C;});},
_createCommandForOData:function(s,m,p,o,i){var n=p.parentOverlay.getAggregationOverlay(m.aggregation);var r=n.getDesignTimeMetadata();var t=r.getAction("addODataProperty",p.parent);var C=t.changeHandlerSettings;var u;if(C&&C.key){u=C.key.oDataServiceVersion;}var R=p.parent;if(t.changeOnRelevantContainer){R=p.relevantContainer;}var v=U.getIndex(p.parent,o,m.aggregation,r.getData().getIndex);var w=this._getChangeHandler(t.changeType,R);var V;if(p.parentOverlay.getVariantManagement&&w&&w.revertChange){V=p.parentOverlay.getVariantManagement();}var M=F.getAppComponentForControl(p.parent).getManifest();var x=F.getODataServiceUriFromManifest(M);return this.getCommandFactory().getCommandFor(p.parent,"addODataProperty",{newControlId:U.createFieldLabelId(R,s.entityType,s.bindingPath),index:i!==undefined?i:v,bindingString:s.bindingPath,entityType:s.entityType,parentId:p.parent.getId(),oDataServiceVersion:u,oDataServiceUri:x,propertyName:s.name},r,V);},
_createCommandForAddLibrary:function(p,m,r,o){var C=F.getAppComponentForControl(p.relevantContainer);var M=C.getManifest();var R=M["sap.app"].id;return this.getCommandFactory().getCommandFor(p.publicParent,"addLibrary",{reference:R,parameters:{libraries:r},appComponent:C},o);},
_createRevealCommandForInvisible:function(s,m,p,o){var r=E.getElementInstance(s.elementId);var R=O.getOverlay(r);var i=h(m,r);var n=i.designTimeMetadata;var t=i.action;if(!R){var u=k(r,p,R);R=O.getOverlay(u);}var v;var w;var T=r.getMetadata().getName();if(T==="sap.ui.core._StashedControl"){w=r;}if(R){v=this.getVariantManagementReference(R,t,false,w);}if(t.changeOnRelevantContainer){return this.getCommandFactory().getCommandFor(r,"reveal",{revealedElementId:r.getId(),directParent:p.parent},n,v);}return this.getCommandFactory().getCommandFor(r,"reveal",{},n,v);},
_createMoveCommandForInvisible:function(s,m,p,o,i){var r=E.getElementInstance(s.elementId);var R=O.getOverlay(r);var n;if(R){n=R.getParentAggregationOverlay().getAggregationName();}else{var t=h(m,r);n=t.action.getAggregationName(p.parent,r);}var u=k(r,p,R);var T=p.parent;var v=U.getIndex(p.parent,o,n);var w=U.getIndex(u,r,n)-1;v=i!==undefined?i:l(u,T,w,v);if(v!==w||p.parent!==r.getParent()){var x=O.getOverlay(r)?O.getOverlay(r).getParentAggregationOverlay():p.relevantContainerOverlay;var y=x.getDesignTimeMetadata();var M=y.getAction("move",r);var V;if(M){V=this.getVariantManagementReference(O.getOverlay(r),M,true);}return this.getCommandFactory().getCommandFor(p.relevantContainer,"move",{movedElements:[{element:r,sourceIndex:w,targetIndex:v}],source:{parent:u,aggregation:n},target:{parent:T,aggregation:n}},y,V);}return Promise.resolve();},
_isEditable:function(o){return{asSibling:this._isEditableCheck.call(this,o,true),asChild:this._isEditableCheck.call(this,o,false)};},
_isEditableCheck:function(o,i){var m=false;var p=_(i,o);if(!p.relevantContainerOverlay){return false;}var n=this._getActions(i,o);if(n.addODataProperty){var r=n.addODataProperty.action;m=r&&r.aggregation===o.getParentAggregationOverlay().getAggregationName();}if(!m&&n.reveal){m=true;}if(!m&&!i){m=this._hasRevealActionsOnChildren(o)||this.checkAggregationsOnSelf(p.parentOverlay,"addODataProperty");}if(m){m=this.hasStableId(o)&&this.hasStableId(p.parentOverlay);}return m;},
getMenuItems:function(m){var o=true;var p="CTX_ADD_ELEMENTS_AS_SIBLING";var r=20;var I="sap-icon://add";var M=[];for(var i=0;i<2;i++){if(this.isAvailable(o,m)){var s=this.getContextMenuTitle.bind(this,o);M.push({id:p,text:s,handler:function(o,m){return this.showAvailableElements(o,m);}.bind(this,o),enabled:this.isEnabled.bind(this,o),rank:r,icon:I,group:"Add"});}o=false;p="CTX_ADD_ELEMENTS_AS_CHILD";r=30;}return M;}
});
function j(p){return Promise.all(p).then(function(i){var m=i[0]||[];if(m&&i[1]){m=m.concat(i[1]);}return m;});}
function k(r,p,R){var o;if(R){o=R.getParentElementOverlay().getElement();}if(!o&&r.sParentId){o=sap.ui.getCore().byId(r.sParentId);}else if(!o){o=p.parent;}return o;}
function l(s,t,i,T){if(s===t&&i<T&&i>-1){return T-1;}return T;}
return A;});
sap.ui.predefine('sap/ui/rta/service/Action',["sap/ui/dt/OverlayRegistry","sap/ui/dt/Util"],function(O,D){"use strict";return function(r){function i(v,o){return typeof v==='function'?v(o):v;}function g(E){return r._oDesignTime.getPlugins().map(function(p){return p.getMenuItems(E);}).reduce(function(R,m){return m?R.concat(m):R;},[]).map(function(m){return Object.assign({},m,{enabled:i(m.enabled,E),text:i(m.text,E[0])});});}function a(c){var C=D.castArray(c);var E=C.map(function(s){var o=O.getOverlay(s);if(!o){throw new Error(D.printf('Control with id="{0}" is not under the one of root elements or ignored.',s));}return o;});return g(E).map(function(m){return D.pick(m,['id','icon','rank','group','enabled','text']);});}function e(c,A){var C=D.castArray(c);var E=C.map(function(s){var o=O.getOverlay(s);if(!o){throw new Error(D.printf('Control with id="{0}" is not under the one of root elements or ignored.',s));}return o;});var b=g(E);var m=b.filter(function(m){return m.id===A;}).pop();if(!m){throw new Error('No action found by specified ID');}else{return m.handler(E,{});}}return{exports:{get:a,execute:e}};};});
sap.ui.predefine('sap/ui/rta/service/ControllerExtension',["sap/ui/dt/Util","sap/ui/dt/OverlayRegistry","sap/ui/fl/Utils","sap/ui/thirdparty/jquery"],function(D,O,F,q){"use strict";return function(r){function m(p){return new Promise(function(a,b){var u;q.ajax({url:u=sap.ui.require.toUrl(p)+".js",async:true,success:function(d){a(d);},error:function(x,t,e){var E=new Error("resource "+p+" could not be loaded from "+u+". Check for 'file not found' or parse errors. Reason: "+e);E.status=t;E.error=e;E.statusCode=x.status;b(e);},dataType:"text"});});}return{exports:{add:function(c,v){var f=r.getFlexSettings();if(!f.developerMode){throw D.createError("service.ControllerExtension#add","code extensions can only be created in developer mode","sap.ui.rta");}if(!c){throw D.createError("service.ControllerExtension#add","can't create controller extension without codeRef","sap.ui.rta");}if(!c.endsWith(".js")){throw D.createError("service.ControllerExtension#add","codeRef has to end with 'js'");}var o=r._getFlexController();var V=sap.ui.getCore().byId(v);var a=F.getAppComponentForControl(V);var C=V.getControllerName&&V.getControllerName()||V.getController()&&V.getController().getMetadata().getName();var b={content:{codeRef:c},selector:{controllerName:C},changeType:"codeExt",namespace:f.namespace};var p=o.createBaseChange(b,a);o.addPreparedChange(p,a);return p.getDefinition();},getTemplate:function(v){var V=O.getOverlay(v);if(!V){throw D.createError("service.ControllerExtension#getTemplate","no overlay found for the given view ID","sap.ui.rta");}var c=V.getDesignTimeMetadata().getControllerExtensionTemplate();return m(c+"-dbg").catch(function(){return m(c);});}}};};});
sap.ui.predefine('sap/ui/rta/service/Outline',["sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementOverlay","sap/ui/dt/AggregationOverlay","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/dt/Overlay","sap/ui/dt/ElementUtil","sap/base/util/deepEqual","sap/base/Log","sap/base/util/merge","sap/ui/thirdparty/jquery"],function(O,E,A,R,D,a,b,d,L,m,q){"use strict";return function(r,p){var o={};o._getOutline=function(i,c){var e;if(!c&&D.isInteger(i)){c=i;i=undefined;}var I=[];if(!i){I=r._oDesignTime.getRootElements().map(function(s){return O.getOverlay(s);});}else{var P=O.getOverlay(i);if(!P){throw D.createError("services.Outline#get","Cannot find element with id= "+i+". A valid or empty value for the initial element id should be provided.","sap.ui.rta");}I.push(P);}e=I.map(function(f){return this._getChildrenNodes(f,c);},this);return e;};o._getChildrenNodes=function(c,i,P){var v=D.isInteger(i);if(c.getShouldBeDestroyed()){return{};}var e=this._getNodeProperties(c,P)||{};var C=c.getChildren();if((!v||(v&&i>0))&&C.length>0&&!q.isEmptyObject(e)){i=v?i-1:i;e.elements=C.map(function(f){return this._getChildrenNodes(f,i,f.getParent());},this).filter(function(f){return!q.isEmptyObject(f);});}return e;};o._getNodeProperties=function(c,P){var e;var s;var i;var t;var I=false;var f=c.getElement();var g=f.getId();var h=f.getMetadata().getName();var j=c.getDesignTimeMetadata();var k=j.getData();var l=(k.palette&&k.palette.icons&&k.palette.icons.svg||undefined);if(c instanceof E){t="element";i=j.getLabel(f);I=c.getEditable();e=j.getName(f);}else{t="aggregation";s=c.getAggregationName();i=j.getLabel(f);e=P.getAggregation(s)?P.getDesignTimeMetadata().getAggregationDescription(s,f):undefined;}var n={id:g,technicalName:s?s:h,editable:I,type:t};if(i!==g&&i!==undefined){n.instanceName=i;}if(e&&e.singular){n.name=e.singular;}if(l!==undefined){n.icon=l;}return n;};o._removeDuplicate=function(c,e){return c.filter(function(u){return!d(e,u,Infinity);});};o._updatesHandler=function(e){var P=e.getParameters();if(this.sStatus==="initial"){this.aUpdates=[];}var c=m({},P);var s=c.id?O.getOverlay(c.id).getElement().getId():undefined;var t=c.targetId?O.getOverlay(c.targetId).getElement().getId():undefined;switch(e.getId()){case"elementOverlayCreated":if(P.elementOverlay.isRoot()){var f=P.elementOverlay.getElement().getId();c.element=o._getOutline(f)[0];c.type="new";break;}return;case"elementOverlayAdded":c.element=o._getOutline(s)[0];c.targetId=t;c.type="new";break;case"elementOverlayMoved":c.element=o._getOutline(s,0)[0];c.targetId=t;c.type="move";break;case"elementOverlayDestroyed":var g=c.elementOverlay.getParentAggregationOverlay();if((g instanceof A&&!g._bIsBeingDestroyed)||c.elementOverlay.isRoot()){c.element={};c.element.id=c.elementOverlay.getElement()?c.elementOverlay.getElement().getId():c.elementOverlay.getAssociation("element");c.type="destroy";break;}return;case"elementOverlayEditableChanged":c.element={id:s,editable:c.editable};c.type="editableChange";break;case"elementPropertyChanged":c.element=o._getOutline(s,0)[0];c.type="elementPropertyChange";break;}c=R.omit(c,["elementOverlay","editable","target","id","elementId"]);this.aUpdates=o._removeDuplicate(this.aUpdates,c);this.aUpdates.push(c);if(this.sStatus==="initial"){setTimeout(function(){if(Array.isArray(this.aUpdates)&&this.aUpdates.length>0){this.sStatus="initial";p("update",this.aUpdates);}}.bind(o),200);}this.sStatus="processing";};o.destroy=function(){r._oDesignTime.detachEvent("elementOverlayCreated",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayAdded",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayMoved",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayDestroyed",this._updatesHandler,this);r._oDesignTime.detachEvent("elementPropertyChanged",this._updatesHandler,this);r._oDesignTime.detachEvent("elementOverlayEditableChanged",this._updatesHandler,this);delete this.aUpdates;delete this.sStatus;};o.aUpdates=[];o.sStatus="initial";r._oDesignTime.attachEvent("elementOverlayCreated",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayAdded",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayMoved",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayDestroyed",o._updatesHandler,o);r._oDesignTime.attachEvent("elementPropertyChanged",o._updatesHandler,o);r._oDesignTime.attachEvent("elementOverlayEditableChanged",o._updatesHandler,o);return{events:["update"],exports:{get:o._getOutline.bind(o)},destroy:o.destroy.bind(o)};};});
sap.ui.predefine('sap/ui/rta/service/Property',["sap/ui/dt/OverlayRegistry","sap/ui/dt/Util","sap/ui/dt/Overlay","sap/ui/dt/ElementUtil","sap/base/util/merge"],function(O,D,a,E,m){"use strict";return function(r){var p={};p._getDesignTimeProperties=function(c){var o=O.getOverlay(c);if(!o){return D.createError("services.Property#get","A valid control id was not passed","sap.ui.rta");}var e=E.getElementInstance(c);var M=e.getMetadata().getAllProperties();var d=o.getDesignTimeMetadata();var b=m({},d.getData());var f=b.properties||{};var g=b.annotations||{};var l=b.getLabel;return Promise.all([p._getConsolidatedAnnotations(g,e),p._getConsolidatedProperties(f||{},M,e),p._getResolvedFunction(l,e),p._getResolvedLinks(b.links,e)]).then(function(P){return Object.assign({},P[0]&&!jQuery.isEmptyObject(P[0])&&{annotations:P[0]},P[1]&&{properties:P[1]},P[2]&&{label:P[2]},b.name&&{name:d.getName(e)},!jQuery.isEmptyObject(P[3])&&{links:P[3]});});};p._getConsolidatedProperties=function(d,M,e){var f=Object.keys(M).reduce(function(F,k){F[k]={value:e.getProperty(k),virtual:false,type:M[k].type,name:M[k].name,ignore:false,group:M[k].group,deprecated:M[k].deprecated,defaultValue:M[k].defaultValue,visibility:M[k].visibility};var b=p._getBindingInfo(k,e);Object.assign(F[k],b&&{binding:b});return F;},{});return Promise.all(Object.keys(d).map(function(k){return p._getResolvedFunction(d[k].ignore,e).then(function(i){if(typeof i!=="boolean"||typeof i==="undefined"){throw D.createError("services.Property#get","Invalid ignore property value found in designtime for element with id "+e.getId()+" .","sap.ui.rta");}if(i){delete f[k];}else if(!f[k]){if(d[k].virtual===true){return p._getEvaluatedVirtualProperty(d,k,e);}else{var b={};b[k]={value:d[k],virtual:false,ignore:i};return b;}}return{};});})).then(function(F){return F.reduce(function(c,o){return Object.assign(c,o);},f);});};p._getEvaluatedVirtualProperty=function(d,P,e){var b={};b[P]={value:d[P].get(e),virtual:true,type:d[P].type,name:d[P].name,group:d[P].group,ignore:false};var B=p._getBindingInfo(P,e);return p._getResolvedFunction(d[P].possibleValues,e).then(function(v){Object.assign(b[P],B&&{binding:B},v&&{possibleValues:v});return b;});};p._getConsolidatedAnnotations=function(d,e){return Promise.all(Object.keys(d).map(function(k){return p._getResolvedFunction(d[k].ignore,e).then(function(i){var f={};if(typeof i!=="boolean"&&typeof i!=="undefined"){throw D.createError("services.Property#get","Invalid ignore property value found in designtime for element with id "+e.getId()+" .","sap.ui.rta");}d[k].ignore=i;if(!i){f[k]=Object.assign({},d[k]);return p._getResolvedLinks(f[k].links,e).then(function(l){if(!jQuery.isEmptyObject(l)){f[k].links=l;}return f;});}});})).then(function(f){return f.reduce(function(c,F){return Object.assign(c,F);},{});});};p._getResolvedLinks=function(l,e){var t=[];var R=Object.assign({},l);Object.keys(R).forEach(function(L){if(Array.isArray(R[L])){R[L].forEach(function(o){t.push(D.wrapIntoPromise(function(){if(typeof o.text==="function"){return o.text(e);}})(o).then(function(s){o.text=s?s:o.text;}));});}});return Promise.all(t).then(function(){return R;});};p._getBindingInfo=function(k,e){var P=e.getBindingInfo(k);if(!P){return;}return m({parts:P.parts,bindingValues:{values:P.binding.getValue()}},P.binding.getOriginalValue&&{bindingValues:{originalValues:P.binding.getOriginalValue()}},P.bindingString&&{bindingString:P.bindingString});};p._getResolvedFunction=function(P,e){return D.wrapIntoPromise(function(){return typeof P==="function"?P(e):(P||false);})(P,e);};return{exports:{get:p._getDesignTimeProperties.bind(p)}};};});
sap.ui.predefine('sap/ui/rta/service/Receiver',["sap/ui/core/postmessage/Bus","sap/ui/dt/Util","sap/base/util/uid"],function(P,D,u){"use strict";var C='sap.ui.rta.service.receiver';var p;return function(r){var e={};var R=function(E){var d=E.data;var m=d.body;switch(E.eventId){case"getService":var s=m.arguments[0];r.getService(s).then(function(S){var a={};var M=[];Object.keys(S).forEach(function(k){if(typeof S[k]==='function'){if(!/^(at|de)tach/.test(k)){M.push(k);}}else{a[k]=S[k];}});p.publish({target:E.source,origin:E.origin,channelId:C,eventId:"getService",data:{id:d.id,type:"response",body:{methods:M,properties:a,events:r._mServices[s].service.events}}});});break;case'callMethod':r.getService(m.service).then(function(S){S[m.method].apply(null,m.arguments).then(function(v){p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'callMethod',data:{type:'response',status:'success',id:d.id,body:v}});});}).catch(function(v){var o=D.propagateError(v,"service.Receiver",D.printf("Can't execute method {0} of service {1} due unexpected error.",m.method,m.service),"sap.ui.rta");p.publish({target:E.source,origin:E.origin,channelId:C,eventId:"callMethod",data:{type:"response",status:"error",id:d.id,body:o.toString()}});});break;case'subscribe':r.getService(m.service).then(function(S){var h=function(v){p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'event',data:{body:{service:m.service,event:m.event,data:v}}});};var H=u();e[H]=h;S.attachEvent(m.event,h);p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'subscribe',data:{type:'response',status:'success',id:d.id,body:{id:H}}});});break;case'unsubscribe':r.getService(m.service).then(function(S){S.detachEvent(m.event,e[m.id]);delete e[m.id];p.publish({target:E.source,origin:E.origin,channelId:C,eventId:'unsubscribe',data:{type:'response',status:'success',id:d.id}});});break;}};p=P.getInstance();p.publish({channelId:C,eventId:P.event.READY});p.subscribe(C,"getService",R);p.subscribe(C,"callMethod",R);p.subscribe(C,"subscribe",R);p.subscribe(C,"unsubscribe",R);return{destroy:function(){if(p){p.unsubscribe(C,"getService",R);p.unsubscribe(C,"callMethod",R);p.unsubscribe(C,"subscribe",R);p.unsubscribe(C,"unsubscribe",R);}}};};});
sap.ui.predefine('sap/ui/rta/service/Selection',function(){"use strict";return function(r,p){var s=r._oDesignTime.getSelectionManager();function g(e){return e.map(function(E){return E.getElement().getId();});}s.attachEvent("change",function(e){p("change",g(e.getParameter("selection")));});return{events:["change"],exports:{get:function(){return g(s.get());},set:s.set.bind(s),add:s.add.bind(s),remove:s.remove.bind(s),reset:s.reset.bind(s)}};};});
sap.ui.predefine('sap/ui/rta/service/index',function(){"use strict";return Object.freeze({selection:'sap.ui.rta.service.Selection',receiver:'sap.ui.rta.service.Receiver',controllerExtension:'sap.ui.rta.service.ControllerExtension',outline:'sap.ui.rta.service.Outline',action:'sap.ui.rta.service.Action',property:'sap.ui.rta.service.Property'});});
sap.ui.predefine('sap/ui/rta/toolbar/Adaptation',['sap/m/ToolbarSpacer','sap/m/Button','sap/m/SegmentedButton','sap/m/SegmentedButtonItem','sap/m/MenuButton','sap/m/MenuItem','sap/m/Menu','sap/m/HBox','sap/m/OverflowToolbar','sap/m/OverflowToolbarLayoutData','sap/ui/Device','sap/m/FlexItemData','./Base'],function(T,B,S,a,M,b,c,H,O,d,D,F,e){"use strict";
var A=e.extend("sap.ui.rta.toolbar.Adaptation",{
renderer:'sap.ui.rta.toolbar.AdaptationRenderer',
animation:true,
metadata:{events:{"undo":{},"redo":{},"exit":{},"restore":{},"transport":{},"modeChange":{},"manageApps":{},"appVariantOverview":{},"saveAs":{}},properties:{"publishVisible":{"type":"boolean","defaultValue":false},"modeSwitcher":{type:"string",defaultValue:"adaptation"}}}
});
A.modes={MOBILE:"sapUiRtaToolbarMobile",TABLET:"sapUiRtaToolbarTablet",DESKTOP:"sapUiRtaToolbarDesktop"};var f="sapUiRtaToolbar";
A.prototype.onAfterRendering=function(){if(!D.media.hasRangeSet(f)){D.media.initRangeSet(f,[600,900],"px",[A.modes.MOBILE,A.modes.TABLET,A.modes.DESKTOP]);}D.media.attachHandler(this._onSizeChanged,this,f);this._onSizeChanged(D.media.getCurrentRange(f));e.prototype.onAfterRendering.apply(this,arguments);};
A.prototype.exit=function(){D.media.detachHandler(this._onSizeChanged,this,f);e.prototype.exit.apply(this,arguments);};
A.prototype._onSizeChanged=function(p){function s(C,i,t){var j=C.filter(function(k){return k.getLayoutData()&&k.getLayoutData().getPriority()===i;});j.forEach(function(k){k.getLayoutData().setPriority(t);});}var m=p.name;this.sMode=m;var o=this.getControl('exit');var h=this.getControl("overflowToolbar").getContent();switch(m){case A.modes.MOBILE:o.setIcon("sap-icon://decline");o.setText("");s(h,"Low","AlwaysOverflow");this._setWidthOfHBoxes(false);break;case A.modes.TABLET:o.setIcon("");o.setText(this.getTextResources().getText("BTN_EXIT"));s(h,"Low","AlwaysOverflow");this._setWidthOfHBoxes(false);break;case A.modes.DESKTOP:o.setIcon("");o.setText(this.getTextResources().getText("BTN_EXIT"));s(h,"AlwaysOverflow","Low");this._setWidthOfHBoxes(true);break;default:}};
function g(C){var o=this.getItems();if(C){var w=this.getControl('modeSwitcher').$().outerWidth();var h=w&&Math.floor(w/2);if(!h){o[1].setWidth("50%");}else{o[1].setWidth("calc(50% + "+h+"px)");}}else{o[1].setWidth("100%");}}
A.prototype._setWidthOfHBoxes=function(C){if(C){var m=this.getControl('modeSwitcher').getDomRef();if(!m){this._oDelegate={"onAfterRendering":function(){g.call(this,C);this.getControl("modeSwitcher").removeEventDelegate(this._oDelegate,this);}};this.getControl('modeSwitcher').addEventDelegate(this._oDelegate,this);g.call(this,C);}else{g.call(this,C);}}else{g.call(this,C);}};
A.prototype.getControl=function(n){return this._mControls[n];};
A.prototype.buildControls=function(){this._mControls={};return[new H({alignItems:"Center",layoutData:new F({baseSize:"0",growFactor:1,minWidth:"0"})}),new H({alignItems:"Center",items:[this._mControls["overflowToolbar"]=new O({content:[this._mControls["modeSwitcher"]=new S({width:"auto",selectedKey:this.getModeSwitcher(),items:[new a({text:this.getTextResources().getText("BTN_ADAPTATION"),tooltip:this.getTextResources().getText("BTN_ADAPTATION"),width:"auto",key:"adaptation"}),new a({text:this.getTextResources().getText("BTN_NAVIGATION"),tooltip:this.getTextResources().getText("BTN_NAVIGATION"),width:"auto",key:"navigation"})],selectionChange:this.eventHandler.bind(this,'ModeChange'),layoutData:new d({priority:"High"})}),new T(),this._mControls["undo"]=new B({type:"Transparent",icon:"sap-icon://undo",enabled:false,tooltip:this.getTextResources().getText("BTN_UNDO"),press:this.eventHandler.bind(this,'Undo'),layoutData:new d({priority:"NeverOverflow"})}),this._mControls["redo"]=new B({type:"Transparent",icon:"sap-icon://redo",iconFirst:false,enabled:false,tooltip:this.getTextResources().getText("BTN_REDO"),press:this.eventHandler.bind(this,'Redo'),layoutData:new d({priority:"NeverOverflow"})}),this._mControls["manageApps"]=new B({type:"Transparent",icon:"sap-icon://message-information",enabled:false,visible:false,tooltip:this.getTextResources().getText("BTN_MANAGE_APPS"),press:this.eventHandler.bind(this,'ManageApps'),layoutData:new d({priority:"Low"})}),this._mControls["appVariantOverview"]=new M({type:"Transparent",icon:"sap-icon://message-information",enabled:false,visible:false,tooltip:this.getTextResources().getText("BTN_MANAGE_APPS"),menu:new c({itemSelected:this.eventHandler.bind(this,'AppVariantOverview'),items:[new b('keyUser',{text:this.getTextResources().getText("MENU_ITEM_KEY_USER")}),new b('developer',{text:this.getTextResources().getText("MENU_ITEM_SAP_DEVELOPER")})]}),layoutData:new d({priority:"Low"})}),this._mControls["restore"]=new B({type:"Transparent",text:this.getTextResources().getText("BTN_RESTORE"),visible:true,enabled:false,tooltip:this.getTextResources().getText("BTN_RESTORE"),press:this.eventHandler.bind(this,'Restore'),layoutData:new d({priority:"Low"})}),this._mControls["publish"]=new B({type:"Transparent",enabled:false,visible:this.getPublishVisible(),text:this.getTextResources().getText("BTN_PUBLISH"),tooltip:this.getTextResources().getText("BTN_PUBLISH"),press:this.eventHandler.bind(this,'Transport'),layoutData:new d({priority:"Low"})}),this._mControls["saveAs"]=new B({type:"Transparent",text:this.getTextResources().getText("BTN_SAVE_AS"),enabled:false,visible:false,tooltip:this.getTextResources().getText("TOOLTIP_SAVE_AS"),press:this.eventHandler.bind(this,'SaveAs'),layoutData:new d({priority:"Low"})})],layoutData:new F({growFactor:1,minWidth:"0"})}),this._mControls["exit"]=new B({type:"Transparent",text:this.getTextResources().getText("BTN_EXIT"),tooltip:this.getTextResources().getText("BTN_EXIT"),press:this.eventHandler.bind(this,'Exit'),icon:"sap-icon://decline"})],layoutData:new F({growFactor:0})})];};
A.prototype.setUndoRedoEnabled=function(C,h){this.getControl('undo').setEnabled(C);this.getControl('redo').setEnabled(h);};
A.prototype.setPublishEnabled=function(E){this.getControl('publish').setEnabled(E);};
A.prototype.setRestoreEnabled=function(E){this.getControl('restore').setEnabled(E);};
A.prototype.show=function(){return e.prototype.show.apply(this,arguments);};
A.prototype.hide=function(){return e.prototype.hide.apply(this,arguments);};
return A;},true);
sap.ui.predefine('sap/ui/rta/toolbar/AdaptationRenderer',['sap/ui/core/Renderer','./BaseRenderer'],function(R,B){"use strict";var A=R.extend('sap.ui.rta.toolbar.AdaptationRenderer',B);
A.render=function(r,c){r.addClass('sapUiRtaToolbarAdaptation');B.render(r,c);};
return A;});
sap.ui.predefine('sap/ui/rta/toolbar/Base',['sap/ui/rta/library','sap/m/HBox','sap/ui/rta/util/Animation','sap/ui/dt/util/getNextZIndex'],function(l,H,A,g){"use strict";
var B=H.extend("sap.ui.rta.toolbar.Base",{
metadata:{library:"sap.ui.rta",properties:{"color":{type:"string",defaultValue:"default"},"zIndex":{type:"int"},"textResources":"object"}},
constructor:function(){H.apply(this,arguments);this.setAlignItems("Center");this.setVisible(false);this.placeToContainer();this.buildContent();},
type:null,
animation:false
});
B.prototype.init=function(){H.prototype.init.apply(this,arguments);};
B.prototype.onBeforeRendering=function(){H.prototype.onBeforeRendering.apply(this,arguments);};
B.prototype.onAfterRendering=function(){H.prototype.onAfterRendering.apply(this,arguments);};
B.prototype.eventHandler=function(e,E){this['fire'+e](E.getParameters());};
B.prototype.buildControls=function(){return[];};
B.prototype.placeToContainer=function(){this.placeAt(sap.ui.getCore().getStaticAreaRef());};
B.prototype.buildContent=function(){this.buildControls().forEach(this.addItem,this);};
B.prototype.show=function(){return new Promise(function(r){var d={onAfterRendering:function(){this.removeEventDelegate(d);r();}};this.addEventDelegate(d,this);this.bringToFront();this.setVisible(true);}.bind(this)).then(function(){return this.animation?A.waitTransition(this.$(),this.addStyleClass.bind(this,'is_visible')):Promise.resolve();}.bind(this)).then(function(){this.focus();}.bind(this));};
B.prototype.hide=function(){return(this.animation?A.waitTransition(this.$(),this.removeStyleClass.bind(this,'is_visible')):Promise.resolve()).then(function(){this.setVisible(false);}.bind(this));};
B.prototype.getControl=function(n){return this.getAggregation('items').filter(function(c){return c.data('name')===n;}).pop();};
B.prototype.bringToFront=function(){this.setZIndex(g());};
B.prototype.setUndoRedoEnabled=function(){};
B.prototype.setPublishEnabled=function(){};
B.prototype.setRestoreEnabled=function(){};
return B;},true);
sap.ui.predefine('sap/ui/rta/toolbar/BaseRenderer',['sap/ui/core/Renderer','sap/m/HBoxRenderer'],function(R,H){"use strict";var B=R.extend('sap.ui.rta.toolbar.BaseRenderer',H);
B.render=function(r,c){r.addClass('sapUiRtaToolbar');r.addClass('sapContrastPlus');r.addClass("color_"+c.getColor());c.type&&r.addClass("type_"+c.type);var z=c.getZIndex();z&&r.addStyle("z-index",z);H.render(r,c);};
return B;});
sap.ui.predefine('sap/ui/rta/toolbar/Fiori',['sap/m/Image','./Adaptation','../Utils',"sap/base/Log"],function(I,A,U,L){"use strict";var F='sapUiRtaFioriHeaderInvisible';
var a=A.extend("sap.ui.rta.toolbar.Fiori",{
renderer:'sap.ui.rta.toolbar.AdaptationRenderer',
type:'fiori'
});
a.prototype.init=function(){A.prototype.init.apply(this,arguments);this._oRenderer=U.getFiori2Renderer();this._oFioriHeader=this._oRenderer.getRootControl().getOUnifiedShell().getHeader();};
a.prototype.show=function(){this._oFioriHeader.addStyleClass(F);return A.prototype.show.apply(this,arguments);};
a.prototype.buildControls=function(){var c=A.prototype.buildControls.apply(this,arguments);var l=this._oFioriHeader.getLogo();if(this._oFioriHeader.getShowLogo()&&l){var $=this._oFioriHeader.$().find('#shell-header-icon');var w,h;if($.length){w=$.width();h=$.height();this._checkLogoSize($,w,h);}c[0].addItem(this._mControls["logo"]=new I({src:l,width:w?w+'px':w,height:h?h+'px':h}));}return c;};
a.prototype.hide=function(){return A.prototype.hide.apply(this,arguments).then(function(){this._oFioriHeader.removeStyleClass(F);}.bind(this));};
a.prototype._checkLogoSize=function($,w,h){var n=$.get(0).naturalWidth;var N=$.get(0).naturalHeight;if(w!==n||h!==N){L.error(["sap.ui.rta: please check Fiori Launchpad logo, expected size is",w+"x"+h+",","but actual is "+n+"x"+N].join(' '));}};
a.prototype.destroy=function(){this._oFioriHeader.removeStyleClass(F);delete this._oRenderer;delete this._oFioriHeader;A.prototype.destroy.apply(this,arguments);};
return a;},true);
sap.ui.predefine('sap/ui/rta/toolbar/Personalization',['./Base','sap/m/Button'],function(B,a){"use strict";
var P=B.extend("sap.ui.rta.toolbar.Personalization",{
renderer:'sap.ui.rta.toolbar.BaseRenderer',
type:'personalization',
metadata:{events:{"exit":{},"restore":{}}},
constructor:function(){B.apply(this,arguments);this.setJustifyContent("End");}
});
P.prototype.buildControls=function(){var c=[new a({type:"Transparent",text:this.getTextResources().getText("BTN_RESTORE"),tooltip:this.getTextResources().getText("BTN_RESTORE"),visible:true,press:this.eventHandler.bind(this,'Restore')}).data('name','restore'),new a({type:"Emphasized",text:this.getTextResources().getText("BTN_DONE"),tooltip:this.getTextResources().getText("BTN_DONE_TOOLTIP"),press:this.eventHandler.bind(this,'Exit')}).data('name','exit')];return c;};
P.prototype.setUndoRedoEnabled=function(){};
P.prototype.setPublishEnabled=function(){};
P.prototype.setRestoreEnabled=function(e){this.getControl('restore').setEnabled(e);};
return P;},true);
sap.ui.predefine('sap/ui/rta/toolbar/Standalone',['./Adaptation'],function(A){"use strict";
var S=A.extend("sap.ui.rta.toolbar.Standalone",{
renderer:'sap.ui.rta.toolbar.AdaptationRenderer',
type:'standalone'
});
return S;},true);
sap.ui.predefine('sap/ui/rta/util/Animation',["sap/ui/thirdparty/jquery"],function(q){"use strict";var m={};
m.waitTransition=function($,c){if(!($ instanceof q)){throw new Error('$element should be wrapped into jQuery object');}if(!q.isFunction(c)){throw new Error('fnCallback should be a function');}return new Promise(function(r){$.one('transitionend',r);var t;var a=function(T){if(!t){t=T;}if(T!==t){c();}else{window.requestAnimationFrame(a);}};window.requestAnimationFrame(a);});};
return m;},true);
sap.ui.predefine('sap/ui/rta/util/BindingsExtractor',['sap/ui/dt/ElementUtil','sap/ui/rta/Utils',"sap/ui/thirdparty/jquery"],function(E,R,q){"use strict";
function g(e,p,t){var B=(t?c(e):b(e,p));for(var A in e.getMetadata().getAllAggregations()){var o=e.getBindingInfo(A);var T=o&&o.template;var d=T?[T]:E.getAggregation(e,A);d.forEach(function(C){if(C.getMetadata){B=B.concat(T||t?c(C):b(C,p),g(C,p,T||t));}});}return B;}
function f(B,p){var d=[];var m=B.getMetadata().getName();if(m==="sap.ui.model.CompositeBinding"){B.getBindings().forEach(function(B){d=d.concat(f(B,p));});}else if((m==="sap.ui.model.odata.ODataPropertyBinding"||m==="sap.ui.model.odata.v2.ODataPropertyBinding"||m==="sap.ui.model.odata.v4.ODataPropertyBinding"||m==="sap.ui.model.json.JSONPropertyBinding"||m==="sap.ui.model.json.XMLPropertyBinding"||m==="sap.ui.model.resource.ResourcePropertyBinding")&&B.getModel()===p&&B.isRelative()&&q.isFunction(B.getPath)&&B.getPath()){d.push(B);}return d;}
function a(B){var d=[];var p=B.parts;p.forEach(function(P){d.push({parts:[P]});});return d;}
function b(e,p){var P=Object.keys(e.getMetadata().getAllProperties());return P.filter(e.getBinding.bind(e)).reduce(function(B,s){return B.concat(f(e.getBinding(s),p));},[]);}
function c(e){var p=Object.keys(e.getMetadata().getAllProperties());return p.filter(function(P){return P in e.mBindingInfos;}).reduce(function(B,P){return B.concat(a(e.mBindingInfos[P]));},[]);}
return{getBindings:g,flattenBindings:f,getBindingsFromProperties:b};},true);
sap.ui.predefine('sap/ui/rta/util/PopupManager',["sap/ui/thirdparty/jquery",'sap/ui/base/ManagedObject','sap/m/InstanceManager','sap/ui/dt/Overlay','sap/ui/dt/Util','sap/ui/fl/Utils','sap/ui/core/Component','sap/ui/core/ComponentContainer','sap/ui/core/Element','sap/ui/dt/ElementUtil'],function(q,M,I,O,d,f,C,a,E,b){"use strict";var F={"add":"_activateFocusHandle","remove":"_deactivateFocusHandle"};
var P=M.extend("sap.ui.rta.util.PopupManager",{metadata:{properties:{rta:"any"},associations:{autoCloseAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"autoCloseArea"}},events:{open:{parameters:{oControl:{type:"sap.ui.core.Control"}}},close:{parameters:{oControl:{type:"sap.ui.core.Control"}}}},library:"sap.ui.rta"}});
P.prototype.init=function(){this._oModalState=new Map();this._calculateMaxAllowedZIndex();};
P.prototype._calculateMaxAllowedZIndex=function(){var o=I.getOpenDialogs().concat(I.getOpenPopovers());var m;if(o.length<1){return;}o.forEach(function(p){var i=parseInt(q(p.getDomRef()).css("z-index"),10);m=(m&&m<i)?m:i-5;});b.setMaxAllowedZIndex(m);};
P.prototype._overrideInstanceFunctions=function(){this._applyPopupAttributes({method:this._createPopupOverlays,setModal:true,bringToTop:true});this._overrideAddPopupInstance();this._overrideRemovePopupInstance();};
P.prototype.getCategorizedOpenPopups=function(){var o,c;o=I.getOpenDialogs();var e=this._getValidatedPopups(o);c=I.getOpenPopovers();var g=this._getValidatedPopups(c);var h={aDialogs:e.relevant,aPopovers:g.relevant,aAllSupportedPopups:e.allSupported.concat(g.allSupported)};return h;};
P.prototype._getValidatedPopups=function(o){var A=[];o=o.filter(function(p){if(this._isPopupAdaptable(p)){A.push(p);return true;}else if(this._isSupportedPopup(p)&&(!(p instanceof sap.m.Popover))){A.push(p);}}.bind(this));return{relevant:o,allSupported:A};};
P.prototype._isComponentInsidePopup=function(p){return q.isArray(p.getContent())?p.getContent().some(function(c){if(c instanceof a){return this.oRtaRootAppComponent===this._getAppComponentForControl(C.get(c.getComponent()));}}.bind(this)):false;};
P.prototype._isSupportedPopup=function(p){return(p instanceof sap.m.Dialog||p instanceof sap.m.Popover);};
P.prototype.setRta=function(r){if(r&&r._oDesignTime){this.setProperty("rta",r);var R=r.getRootControlInstance();this.oRtaRootAppComponent=this._getAppComponentForControl(R);this._overrideInstanceFunctions();var m=this._onModeChange.bind(this);r.attachModeChanged(m);}};
P.prototype._onModeChange=function(e){var n=e.getParameters().mode;var A=function(m,p){if(m==='navigation'){p.oPopup[this._getFocusEventName("add")]();}else{p.oPopup[this._getFocusEventName("remove")]();if(this.getRta().getShowToolbars()){this.getRta().getToolbar().bringToFront();}}};n==='navigation'?this._applyPatchesToOpenPopups(d.curry(A)(n)):this._removePatchesToOpenPopups(d.curry(A)(n));};
P.prototype._applyPatchesToOpenPopups=function(e){this._applyPopupAttributes({method:e,focus:true,setModal:false});};
P.prototype._removePatchesToOpenPopups=function(e){this._applyPopupAttributes({method:e,setModal:true});};
P.prototype._getFocusEventName=function(o){return F[o];};
P.prototype._overrideAddPopupInstance=function(){this._fnOriginalAddDialogInstance=I.addDialogInstance;I.addDialogInstance=this._overrideAddFunctions(this._fnOriginalAddDialogInstance);this._fnOriginalAddPopoverInstance=I.addPopoverInstance;I.addPopoverInstance=this._overrideAddFunctions(this._fnOriginalAddPopoverInstance);};
P.prototype._overrideAddFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isSupportedPopup(p)){if(this._isPopupAdaptable(p)&&this.getRta()._oDesignTime){p.attachAfterOpen(this._createPopupOverlays,this);this._setModal(true,p);this.fireOpen(p);}else if(!(p instanceof sap.m.Popover)){this._setModal(true,p);}}return v;}.bind(this);};
P.prototype._setModal=function(s,p){var o=this._oModalState.get(p.oPopup);if(typeof o!=="boolean"&&s&&this.getRta().getMode()==='adaptation'){this._oModalState.set(p.oPopup,p.oPopup.getModal());p.oPopup.setModal(true);}else if(typeof o==="boolean"&&s===false){p.oPopup.setModal(o);this._oModalState.delete(p.oPopup);}};
P.prototype._applyPopupAttributes=function(p){var r=this.getCategorizedOpenPopups();["aDialogs","aPopovers"].forEach(function(k){if(r[k].length>0){if(p.focus){if(r[k][0].oPopup.oContent){r[k][0].oPopup.oContent.focus();}}r[k].forEach(function(o){p.method.call(this,o);}.bind(this));}}.bind(this));r.aAllSupportedPopups.forEach(this._setModal.bind(this,p.setModal));};
P.prototype._applyPopupPatch=function(p){var o=O.getOverlayContainer();var c=p.oPopup;var A=[c.oContent.getDomRef(),o.get(0)].concat(this.getAutoCloseAreas());if(this.getRta().getShowToolbars()){A.push(this.getRta().getToolbar().getDomRef());}c.setAutoCloseAreas(A);if(!this.fnOriginalPopupOnAfterRendering){this.fnOriginalPopupOnAfterRendering=c.onAfterRendering;}c.onAfterRendering=function(){var v=this.fnOriginalPopupOnAfterRendering.apply(c,arguments);c[this._getFocusEventName("remove")]();return v;}.bind(this);if(this.getRta().getMode()==='adaptation'){c[this._getFocusEventName("remove")]();}};
P.prototype._overrideRemovePopupInstance=function(){this._fnOriginalRemoveDialogInstance=I.removeDialogInstance;I.removeDialogInstance=this._overrideRemoveFunctions(this._fnOriginalRemoveDialogInstance);this._fnOriginalRemovePopoverInstance=I.removePopoverInstance;I.removePopoverInstance=this._overrideRemoveFunctions(this._fnOriginalRemovePopoverInstance);};
P.prototype._overrideRemoveFunctions=function(o){return function(p){var v=o.apply(I,arguments);if(this._isSupportedPopup(p)){if(this._isPopupAdaptable(p,false)&&this.getRta()._oDesignTime){this.getRta()._oDesignTime.removeRootElement(p);}this._oModalState.delete(p.oPopup);this.fireClose(p);}return v;}.bind(this);};
P.prototype._getAppComponentForControl=function(c){var o,A;if(c instanceof C){o=c;}else{o=this._getComponentForControl(c);}if(o){A=f.getAppComponentForControl(o);}return A;};
P.prototype._getComponentForControl=function(c){var o,r,p;if(c){o=C.getOwnerComponentFor(c);if(!o&&typeof c.getParent==="function"&&c.getParent()instanceof E){p=c.getParent();}else if(o){p=o;}if(p){r=this._getComponentForControl(p);}}return r?r:o;};
P.prototype._createPopupOverlays=function(e){if(!e){return;}var p=(e instanceof E)?e:e.getSource();if(this.getRta()._oDesignTime.getRootElements().indexOf(p.getId())===-1&&!this._isComponentInsidePopup(p)){this.getRta()._oDesignTime.addRootElement(p);}p.detachAfterOpen(this._createPopupOverlays,this);this._applyPopupPatch(p);};
P.prototype._restoreInstanceFunctions=function(){if(this._fnOriginalAddDialogInstance){I.addDialogInstance=this._fnOriginalAddDialogInstance;}if(this._fnOriginalRemoveDialogInstance){I.removeDialogInstance=this._fnOriginalRemoveDialogInstance;}if(this._fnOriginalAddPopoverInstance){I.addPopoverInstance=this._fnOriginalAddPopoverInstance;}if(this._fnOriginalRemovePopoverInstance){I.removePopoverInstance=this._fnOriginalRemovePopoverInstance;}this._applyPatchesToOpenPopups(this._removePopupPatch);};
P.prototype._removePopupPatch=function(p){var o=p.oPopup;o[this._getFocusEventName("add")]();if(this.fnOriginalPopupOnAfterRendering){o.onAfterRendering=this.fnOriginalPopupOnAfterRendering;}};
P.prototype._isPopupAdaptable=function(p){if(p.isPopupAdaptationAllowed&&!p.isPopupAdaptationAllowed()){return false;}var o=this._getAppComponentForControl(p);return this.oRtaRootAppComponent===o||this._isComponentInsidePopup(p);};
P.prototype.exit=function(){this._restoreInstanceFunctions();delete this._oModalState;};
return P;},true);
sap.ui.predefine('sap/ui/rta/util/ServiceEventBus',["sap/ui/core/EventBus"],function(E){"use strict";
var S=E.extend("sap.ui.rta.util.ServiceEventBus");
S.prototype._callListener=function(c,l,C,e,d){c.call(l,d);};
S.prototype.getChannel=function(c){return this._mChannels[c];};
return S;});
sap.ui.predefine('sap/ui/rta/util/StylesLoader',["sap/ui/thirdparty/jquery"],function(q){"use strict";var m={};
m.loadStyles=function(f){return q.get(sap.ui.require.toUrl(('sap.ui.rta.assets.'+f).replace(/\./g,"/"))+'.css').then(function(d){if(sap.ui.getCore().getConfiguration().getRTL()){return d.replace(/right/g,'left');}return d;});};
return m;},true);
sap.ui.predefine('sap/ui/rta/util/UrlParser',[],function(q){"use strict";var m={};
m.getParam=function(p){return m.getParams()[p];};
m.getParams=function(){return document.location.search.replace(/^\?/,'').split('&').reduce(function(p,P){var a=P.split('=');var v=a[1];switch(v){case'true':v=true;break;case'false':v=false;break;}p[a[0]]=v;return p;},{});};
return m;},true);
sap.ui.require.preload({
	"sap/ui/rta/appVariant/manageApps/webapp/manifest.json":'{"_version":"1.8.0","sap.app":{"id":"manageApps","type":"application","i18n":"i18n/i18n.properties","applicationVersion":{"version":"1.0.0"},"title":"{{appTitle}}","description":"{{appDescription}}","resources":"resources.json","ach":"ach","sourceTemplate":{"id":"ui5template.basicSAPUI5ApplicationProject","version":"1.40.12"}},"sap.ui":{"technology":"UI5","icons":{"icon":"","favIcon":"","phone":"","phone@2":"","tablet":"","tablet@2":""},"deviceTypes":{"desktop":true,"tablet":true,"phone":true}},"sap.ui5":{"rootView":{"viewName":"sap.ui.rta.appVariant.manageApps.webapp.view.ManageApps","type":"XML","async":true},"dependencies":{"minUI5Version":"1.30.0","libs":{"sap.ui.core":{},"sap.m":{},"sap.ui.layout":{},"sap.ui.rta":{}}},"contentDensities":{"compact":true,"cozy":true},"models":{"i18n":{"type":"sap.ui.model.resource.ResourceModel","settings":{"bundleName":"sap.ui.rta.appVariant.manageApps.webapp.i18n.i18n"}}},"resources":{"css":[{"uri":"css/style.css"}]}}}',
	"sap/ui/rta/appVariant/manageApps/webapp/view/ManageApps.view.xml":'<mvc:View controllerName="sap.ui.rta.appVariant.manageApps.webapp.controller.ManageApps" xmlns:mvc="sap.ui.core.mvc" xmlns:core="sap.ui.core" xmlns="sap.m"><Table id="Table1" showNoData="false" inset="false" growing="true" growingThreshold="500" items="{/appVariants}"><columns><Column width="6em" hAlign="Left"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_APP_TYPE}"/></Column><Column width="2em" minScreenWidth="tablet" demandPopin="true" popinDisplay="WithoutHeader" hAlign="Left"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_ICON}"/></Column><Column width="12em" minScreenWidth="tablet" demandPopin="true" popinDisplay="WithoutHeader" hAlign="Left"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_TITLE_SUBTITLE}"/></Column><Column width="12em" minScreenWidth="tablet" demandPopin="true" popinDisplay="WithoutHeader" hAlign="Left"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_DESCRIPTION}"/></Column><Column width="4em" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader" hAlign="Center"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_COPY_ID_ACTION}"/></Column><Column width="4em" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader" hAlign="Center"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_ADAPT_UI_ACTION}"/></Column><Column width="4em" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader" hAlign="Center"><core:InvisibleText text="{i18n&gt;MAA_DIALOG_SAVE_AS_ACTION}"/></Column></columns><items><ColumnListItem highlight="{path:\'currentStatus\',formatter:\'.formatRowHighlight\'}"><cells><ObjectIdentifier title="{typeOfApp}" text="{currentStatus}"/><core:Icon src="{icon}" tooltip="{iconText}" class="sapUiListTableIconSize"/><ObjectIdentifier title="{title}" text="{subTitle}"/><Text text="{description}"/><Button text="{i18n&gt;MAA_DIALOG_COPY_ID}" press="copyId"/><Button text="{i18n&gt;MAA_DIALOG_ADAPT_UI}" enabled="{adaptUIButtonVisibility}" press="handleUiAdaptation" visible="{isKeyUser}"/><Button text="{i18n&gt;MAA_DIALOG_SAVE_AS_APP}" tooltip="{i18n&gt;TOOLTIP_MAA_DIALOG_SAVE_AS_APP}" press="saveAsAppVariant" visible="{isKeyUser}"/></cells></ColumnListItem></items></Table></mvc:View>',
	"sap/ui/rta/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.rta","type":"library","embeds":["appVariant/manageApps/webapp"],"applicationVersion":{"version":"1.60.20"},"title":"SAPUI5 library with RTA controls.","description":"SAPUI5 library with RTA controls.","ach":"CA-UI5-FL-RTA","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.60","libs":{"sap.ui.core":{"minVersion":"1.60.20"},"sap.ui.layout":{"minVersion":"1.60.20"},"sap.m":{"minVersion":"1.60.20"},"sap.ui.fl":{"minVersion":"1.60.20"},"sap.ui.dt":{"minVersion":"1.60.20"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":[],"elements":[],"types":[],"interfaces":[]}}}}',
	"sap/ui/rta/view/RemoveElementDialog.fragment.xml":'<core:FragmentDefinition xmlns:core="sap.ui.core" xmlns:commons="sap.ui.commons" xmlns:layout="sap.ui.layout" xmlns:sap.m="sap.m"><sap.m:Dialog class="sapUiRtaConfirmationDialog" verticalScrolling="false" title="{/titleText}" icon="{/icon}"><layout:VerticalLayout width="100%"><commons:TextView class="sapUiRtaConfirmationDialogText" text="{/messageText}"/></layout:VerticalLayout><sap.m:beginButton><sap.m:Button class="sapUiRtaConfirmationDialogRemoveButton" text="{/removeText}" press="removeField"/></sap.m:beginButton><sap.m:endButton><sap.m:Button class="sapUiRtaConfirmationDialogCancelButton" text="{/cancelText}" press="closeDialog"/></sap.m:endButton></sap.m:Dialog></core:FragmentDefinition>',
	"sap/ui/rta/appVariant/manageApps/webapp/index.js":function(){sap.ui.require(["sap/m/Shell","sap/ui/core/ComponentContainer"],function(S,C){"use strict";sap.ui.getCore().attachInit(function(){new S({app:new C({height:"100%",name:"manageApps",settings:{id:"manageApps"}})}).placeAt("content");});});
}
},"sap/ui/rta/library-preload"
);
//# sourceMappingURL=library-preload.js.map