/*!
* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/support/supportRules/Analyzer","sap/ui/support/supportRules/CoreFacade","sap/ui/support/supportRules/ExecutionScope","sap/ui/support/supportRules/ui/external/Highlighter","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/History","sap/ui/support/supportRules/report/DataCollector","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants","sap/ui/support/supportRules/RuleSetLoader","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/library"],function(q,M,A,C,E,H,a,I,b,D,c,d,R,f,l){"use strict";var g=null;var m=null;var h=M.extend("sap.ui.support.Main",{constructor:function(){if(!m){this._oCore=null;this._oAnalyzer=new A();this._oAnalyzer.onNotifyProgress=function(i){a.publish(c.ON_PROGRESS_UPDATE,{currentProgress:i});};M.apply(this,arguments);var e=document.createEvent("CustomEvent");e.initCustomEvent("supportToolLoaded",true,true,{});}else{q.sap.log.warning("Only one support tool allowed");return m;}}});h.prototype._isInIframe=function(){try{return window.self!==window.top;}catch(e){return true;}};h.prototype.startPlugin=function(s){if(this._pluginStarted){return;}this._pluginStarted=true;var t=this;sap.ui.getCore().registerPlugin({startPlugin:function(o){t._supportModeConfig=s=s||o.getConfiguration().getSupportMode();t._setCommunicationSubscriptions();var F=t._isInIframe()&&s.indexOf("frame-force-ui")!==-1;t._oCore=o;t._oDataCollector=new D(o);t._oCoreFacade=C(o);t._oExecutionScope=null;t._createCoreSpies();o.attachLibraryChanged(R._onLibraryChanged);if(!s||s.indexOf("silent")===-1||F){sap.ui.require(["sap/ui/support/supportRules/ui/IFrameController"],function(e){g=e;g.injectFrame(s);a.onMessageChecks.push(function(i){return i.origin===g.getFrameOrigin();});a.onMessageChecks.push(function(i){return i.data._frameIdentifier===g.getFrameIdentifier();});a.onMessageChecks.push(function(i){var j=g.getFrameUrl();j=j.replace(/\.\.\//g,'');return i.data._origin.indexOf(j)>-1;});});}else{R.updateRuleSets(function(){t.fireEvent("ready");});}},stopPlugin:function(){g._stop();t._pluginStarted=false;t._oCore=null;t._oCoreFacade=null;t._oDataCollector=null;t._oExecutionScope=null;}});};h.prototype._createCoreSpies=function(){var t=this,n=500;this._fnDirtyTimeoutHandle=null;var s=function(N){var o=t._oCore[N];t._oCore[N]=function(){o.apply(t._oCore,arguments);clearTimeout(t._fnDirtyTimeoutHandle);t._fnDirtyTimeoutHandle=setTimeout(function(){a.publish(c.ON_CORE_STATE_CHANGE);},n);};};s("registerElement");s("deregisterElement");};h.prototype._setCommunicationSubscriptions=function(){if(this._supportModeConfig.indexOf("silent")<0){a.subscribe(c.VERIFY_CREATE_RULE,function(t){var T=f.deserialize(t),o=R.getRuleSet(d.TEMP_RULESETS_NAME).ruleset,r=o.addRule(T);a.publish(c.VERIFY_RULE_CREATE_RESULT,{result:r,newRule:f.serialize(T)});},this);a.subscribe(c.VERIFY_UPDATE_RULE,function(e){var t=f.deserialize(e.updateObj),T=R.getRuleSet(d.TEMP_RULESETS_NAME).ruleset,r=T.updateRule(e.oldId,t);a.publish(c.VERIFY_RULE_UPDATE_RESULT,{result:r,updateRule:f.serialize(t)});},this);a.subscribe(c.DELETE_RULE,function(e){var t=f.deserialize(e),T=R.getRuleSet(d.TEMP_RULESETS_NAME).ruleset;T.removeRule(t);},this);a.subscribe(c.OPEN_URL,function(u){var w=window.open(u,"_blank");w.focus();},this);a.subscribe(c.ON_DOWNLOAD_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(i){i.downloadReportZip(e);});},this);a.subscribe(c.HIGHLIGHT_ELEMENT,function(i){var $=sap.ui.getCore().byId(i).$();$.css("background-color","red");},this);a.subscribe(c.TREE_ELEMENT_MOUSE_ENTER,function(e){H.highlight(e);},this);a.subscribe(c.TREE_ELEMENT_MOUSE_OUT,function(){H.hideHighLighter();},this);a.subscribe(c.TOGGLE_FRAME_HIDDEN,function(e){g.toggleHide(e);},this);}a.subscribe(c.POST_UI_INFORMATION,function(e){this._oDataCollector.setSupportAssistantLocation(e.location);this._oDataCollector.setSupportAssistantVersion(e.version);},this);a.subscribe(c.GET_AVAILABLE_COMPONENTS,function(){a.publish(c.POST_AVAILABLE_COMPONENTS,Object.keys(this._oCore.mObjects.component));},this);a.subscribe(c.ON_ANALYZE_REQUEST,function(e){this.analyze(e.executionContext,e.rulePreset);},this);a.subscribe(c.ON_INIT_ANALYSIS_CTRL,function(){R.updateRuleSets(function(){a.publish(c.POST_APPLICATION_INFORMATION,{versionInfo:sap.ui.getVersionInfo()});this.fireEvent("ready");}.bind(this));},this);a.subscribe(c.ON_SHOW_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(i){i.openReport(e);});},this);a.subscribe(c.LOAD_RULESETS,function(e){R.loadAdditionalRuleSets(e.aLibNames);},this);a.subscribe(c.REQUEST_RULES_MODEL,function(e){if(e){a.publish(c.GET_RULES_MODEL,I.getTreeTableViewModel(e));}},this);a.subscribe(c.REQUEST_ISSUES,function(i){if(i){var e=I.groupIssues(i),j=I.getIssuesViewModel(e);a.publish(c.GET_ISSUES,{groupedIssues:e,issuesModel:j});}},this);a.subscribe(c.GET_NON_LOADED_RULE_SETS,function(e){R.fetchNonLoadedRuleSets(e.loadedRulesets);},this);};h.prototype.analyze=function(e,p){var t=this;if(this._oAnalyzer&&this._oAnalyzer.running()){return;}if(typeof p==="string"){p=l.SystemPresets[p];if(!p){q.sap.log.error("System preset ID is not valid");return;}}e=e||{type:"global"};var r;if(p&&p.selections){this._oSelectedRulePreset=p;r=p.selections;if(!p.id||!p.title){q.sap.log.error("The preset must have an ID and a title");return;}}else{this._oSelectedRulePreset=null;r=p;}r=r||R.getAllRuleDescriptors();if(!this._isExecutionScopeValid(e)){a.publish(c.POST_MESSAGE,{message:"Set a valid element ID."});return;}a.publish(c.ON_ANALYZE_STARTED);if(e.selectors){this._mapExecutionScope(e);}this._oAnalyzer.reset();this.setExecutionScope(e);I.clearIssues();this._setSelectedRules(r);return this._oAnalyzer.start(this._aSelectedRules,this._oCoreFacade,this._oExecutionScope).then(function(){t._done();});};h.prototype._isExecutionScopeValid=function(e){var o=sap.ui.getCore(),s=[],j=false,i;if(E.possibleScopes.indexOf(e.type)===-1){q.sap.log.error("Invalid execution scope type. Type must be one of the following: "+E.possibleScopes.join(", "));return false;}if(e.type==="subtree"){if(e.parentId){s.push(e.parentId);}else if(q.isArray(e.selectors)){q.merge(s,e.selectors);}else if(e.selectors){s.push(e.selectors);}for(i=0;i<s.length;i++){if(o.byId(s[i])){j=true;break;}}if(!j){return false;}}return true;};h.prototype.setExecutionScope=function(s){this._oExecutionScope=E(this._oCore,s);};h.prototype._setSelectedRules=function(r){this._aSelectedRules=[];this._oSelectedRulesIds={};if(!r){return;}if(!Array.isArray(r)){r=[r];}r.forEach(function(o){var e,i;if(!o.libName||!o.ruleId){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Invalid Rule Descriptor.");return;}e=R.getRuleSet(o.libName);if(!e||!e.ruleset){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Could not find Ruleset for library "+o.libName);return;}i=e.ruleset.getRules();if(!i||!i[o.ruleId]){q.sap.log.error("["+d.SUPPORT_ASSISTANT_NAME+"] Could not find Rule with id "+o.ruleId+" for library "+o.libName);return;}this._aSelectedRules.push(i[o.ruleId]);this._oSelectedRulesIds[o.ruleId]=true;},this);};h.prototype._mapExecutionScope=function(e){if(e.type==="subtree"){if(typeof e.selectors==="string"){e.parentId=e.selectors;}else if(Array.isArray(e.selectors)){e.parentId=e.selectors[0];}}else if(e.type==="components"){if(typeof e.selectors==="string"){e.components=[e.selectors];}else if(Array.isArray(e.selectors)){e.components=e.selectors;}}delete e.selectors;};h.prototype._done=function(){a.publish(c.ON_ANALYZE_FINISH,{issues:I.getIssuesModel(),elementTree:this._createElementTree(),elapsedTime:this._oAnalyzer.getElapsedTimeString()});b.saveAnalysis(this);};h.prototype._createElementTree=function(){var e=this._copyElementsStructure(),j=[];this._setContextElementReferences(e);for(var i in e){if(e[i].skip){continue;}j.push(e[i]);}return[{content:j,id:"WEBPAGE",name:"WEBPAGE"}];};h.prototype._setContextElementReferences=function(o){var e=this._oCore.mElements;for(var i in o){var j=o[i],p=e[i]==undefined?undefined:e[i].getParent();if(e[i]instanceof sap.ui.core.ComponentContainer){var k=e[i],n=k.getComponent();if(n){j.content.push(o[n]);o[n].skip=true;}}if(p){var r=p.getId();if(!o[r]){continue;}o[r].content.push(o[i]);o[i].skip=true;}}};h.prototype._copyElementsStructure=function(){var e={},t=this;var j=function(n,o){for(var i in n){if(n.hasOwnProperty(i)){var r=n[i];var s={content:[],id:r.getId(),name:(o==undefined)?r.getMetadata().getName():o};e[r.getId()]=s;}}};j(this._oExecutionScope.getElements());this._oExecutionScope.getElements().forEach(function(i){if(i instanceof sap.ui.core.ComponentContainer){var n=i.getComponent(),o=t._oCore.mObjects.component[n];if(o){j([o],"sap-ui-component");}}});switch(this._oExecutionScope._getType()){case"global":j(this._oCoreFacade.getUIAreas(),"sap-ui-area");j(this._oCoreFacade.getComponents(),"sap-ui-component");break;case"subtree":var p=this._oExecutionScope._getContext().parentId;j([this._oCore.mElements[p]]);break;case"components":var k=this._oExecutionScope._getContext().components;k.forEach(function(i){j([t._oCore.mObjects.component[i]],"sap-ui-component");});break;}return e;};h.prototype._getReportData=function(r){var i=I.groupIssues(I.getIssuesModel()),e=R.getRuleSets(),s=this._oSelectedRulesIds,S=this._oSelectedRulePreset||null;return{issues:i,technical:this._oDataCollector.getTechInfoJSON(),application:this._oDataCollector.getAppInfo(),rules:I.getRulesViewModel(e,s,i),rulePreset:S,scope:{executionScope:this._oExecutionScope,scopeDisplaySettings:{executionScopes:r.executionScopes,executionScopeTitle:r.executionScopeTitle}},analysisDuration:this._oAnalyzer.getElapsedTimeString(),analysisDurationTitle:r.analysisDurationTitle,abap:b.getFormattedHistory(sap.ui.support.HistoryFormats.Abap),name:d.SUPPORT_ASSISTANT_NAME};};h.prototype.getAnalysisHistory=function(){if(this._oAnalyzer.running()){return null;}return b.getHistory();};h.prototype.getFormattedAnalysisHistory=function(F){if(this._oAnalyzer.running()){return"";}return b.getFormattedHistory(F);};h.prototype.getLastAnalysisHistory=function(){var e=this.getAnalysisHistory();if(q.isArray(e)&&e.length>0){return e[e.length-1];}else{return null;}};h.prototype.addRule=function(r){if(!r){return"No rule provided.";}r.selected=r.selected!==undefined?r.selected:true;r.async=r.async||false;var s=R.getRuleSet(d.TEMP_RULESETS_NAME).ruleset.addRule(r);a.publish(c.VERIFY_RULE_CREATE_RESULT,{result:s,newRule:f.serialize(r)});return s;};var m=new h();return m;},true);
