/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/Device","./library","./TableUtils","sap/ui/events/KeyCodes","sap/ui/thirdparty/jquery"],function(B,D,l,T,K,q){"use strict";var C=T.CELLTYPE;var S=l.SelectionMode;var M={CTRL:1,SHIFT:2,ALT:4};var N={LEFT:"Left",RIGHT:"Right",UP:"Up",DOWN:"Down"};var H=5;var a="1em";function p(E,P){E.setMarked("sapUiTableSkipItemNavigation",P!==false);}var b=B.extend("sap.ui.table.TableKeyboardDelegate2",{constructor:function(t){B.call(this);},destroy:function(){B.prototype.destroy.apply(this,arguments);},getInterface:function(){return this;}});b._restoreFocusOnLastFocusedDataCell=function(t,E){var o=T.getFocusedItemInfo(t);var L=t._getKeyboardExtension()._getLastFocusedCellInfo();T.focusItem(t,o.cellInRow+(o.columnCount*L.row),E);};b._setFocusOnColumnHeaderOfLastFocusedDataCell=function(t,E){var o=T.getFocusedItemInfo(t);T.focusItem(t,o.cellInRow,E);};b._forwardFocusToTabDummy=function(t,f){t._getKeyboardExtension()._setSilentFocus(t.$().find("."+f));};b._isKeyCombination=function(E,k,m){if(m==null){m=0;}var f=typeof k==="string"?String.fromCharCode(E.charCode):E.keyCode;var g=0;g|=(D.os.macintosh?E.metaKey:E.ctrlKey)&&k!==K.CONTROL?M.CTRL:0;g|=E.shiftKey&&k!==K.SHIFT?M.SHIFT:0;g|=E.altKey&&k!==K.ALT?M.ALT:0;var v=k==null||f===k;var V=m===g;return v&&V;};b._handleSpaceAndEnter=function(t,E){var o=T.getCellInfo(E.target);if(o.isOfType(C.COLUMNROWHEADER)){t._toggleSelectAll();}else if(b._isElementGroupToggler(t,E.target)){T.Grouping.toggleGroupHeaderByRef(t,E.target);}else if(o.isOfType(C.ROWHEADER)){T.toggleRowSelection(t,E.target);}else if(o.isOfType(C.DATACELL|C.ROWACTION)){var f=!t.hasListeners("cellClick");if(!t._findAndfireCellEvent(t.fireCellClick,E)){if(T.isRowSelectionAllowed(t)){T.toggleRowSelection(t,E.target);f=false;}}if(f){var i=T.getInteractiveElements(E.target);if(i){t._getKeyboardExtension().setActionMode(true);}}}};b._moveColumn=function(o,n){var t=o.getParent();var v=t._getVisibleColumns();var i=v.indexOf(o);var f;if(n&&i<v.length-1){f=t.indexOfColumn(v[i+1])+1;}else if(!n&&i>0){f=t.indexOfColumn(v[i-1]);}if(f!=null){T.Column.moveColumnTo(o,f);}};b._getVisibleAndGroupedColumns=function(t){return t.getColumns().filter(function(o){return o.getVisible()||o.getGrouped();});};b._getColumnIndexInVisibleAndGroupedColumns=function(t,o){var v=b._getVisibleAndGroupedColumns(t);for(var i=0;i<v.length;i++){var V=v[i];if(V===o){return i;}}return-1;};b._focusElement=function(t,E,f){if(!t||!E){return;}if(f==null){f=false;}function h(E){return E instanceof window.HTMLInputElement&&/^(text|password|search|tel|url)$/.test(E.type);}if(h(document.activeElement)){document.activeElement.setSelectionRange(0,0);}if(f){t._getKeyboardExtension()._setSilentFocus(E);}else{E.focus();}if(h(E)){E.select();}};b._focusCell=function(t,i,r,f,F,A){if(!t||i==null||r==null||r<0||r>=t.getRows().length){return;}var R=t.getRows()[r];var o;if(i===C.ROWHEADER){t._getKeyboardExtension()._setFocus(t.getDomRef("rowsel"+r));return;}else if(i===C.ROWACTION){o=t.getDomRef("rowact"+r);}else if(i===C.DATACELL&&(f!=null&&f>=0)){var g=t.getColumns()[f];var h=b._getColumnIndexInVisibleAndGroupedColumns(t,g);if(h>=0){o=R.getDomRef("col"+h);}}if(!o){return;}if(F){var I=T.getInteractiveElements(o);if(I){b._focusElement(t,I[0]);return;}}if(A){t._getKeyboardExtension()._bStayInActionMode=true;}o.focus();};b._navigate=function(t,E,f){if(E.isMarked()){return;}var k=t._getKeyboardExtension();var A=k.isInActionMode();var o=T.getCellInfo(T.getCell(t,E.target));var g=false;if((f===N.UP||f===N.DOWN)&&o.isOfType(C.ANYCONTENTCELL)){var h=b._isKeyCombination(E,null,M.CTRL);var i=h||A;var P=T.getParentCell(t,E.target);var j=A&&o.isOfType(C.DATACELL);if(!h&&(E.target instanceof window.HTMLInputElement||E.target instanceof window.HTMLTextAreaElement)){return;}if(!i&&P){P.focus();return;}p(E);if(f===N.UP){if(T.isFirstScrollableRow(t,o.cell)){g=t._getScrollExtension().scrollVertically(false,false,true,j,function(){if(j){document.activeElement.blur();}});}}else if(T.isLastScrollableRow(t,o.cell)){g=t._getScrollExtension().scrollVertically(true,false,true,j,function(){if(j){document.activeElement.blur();}});}if(g){E.preventDefault();if(i){t.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){b._focusCell(t,o.type,o.rowIndex,o.columnIndex,true);},0);});}}else if(f===N.UP&&o.rowIndex===0){p(E,o.isOfType(C.ROWACTION)||i);if(!A&&P){P.focus();}else{k.setActionMode(false);}}else if(f===N.DOWN&&o.rowIndex===t.getVisibleRowCount()-1){if(!A&&P){P.focus();}else{k.setActionMode(false);}}else{var m=f===N.DOWN?1:-1;b._focusCell(t,o.type,o.rowIndex+m,o.columnIndex,i);E.preventDefault();}}else if(f===N.DOWN&&o.isOfType(C.ANYCOLUMNHEADER)){var n=T.getHeaderRowCount(t);if(T.isNoDataVisible(t)){var F=T.getFocusedItemInfo(t);if(F.row-n<=1){p(E);}}else if(o.isOfType(C.COLUMNROWHEADER)&&n>1){p(E);T.focusItem(t,n*(T.getVisibleColumnCount(t)+1),E);}}else if(f===N.LEFT&&!A){var I=sap.ui.getCore().getConfiguration().getRTL();if(o.isOfType(C.COLUMNHEADER)&&I){var r=T.getFocusedItemInfo(t);var u=r.cellInRow-(T.hasRowHeader(t)?1:0);var v=T.getVisibleColumnCount(t);if(T.hasRowActions(t)&&u===v-1){p(E);}}}};b._isElementGroupToggler=function(t,E){return T.Grouping.isInGroupingRow(E)||(T.Grouping.isTreeMode(t)&&E.classList.contains("sapUiTableTdFirst")&&(E.querySelector(".sapUiTableTreeIconNodeOpen")||E.querySelector(".sapUiTableTreeIconNodeClosed")))||E.classList.contains("sapUiTableTreeIconNodeOpen")||E.classList.contains("sapUiTableTreeIconNodeClosed");};b._isElementInteractive=function(E){if(!E){return false;}return q(E).is(T.INTERACTIVE_ELEMENT_SELECTORS);};b._getFirstInteractiveElement=function(r){if(!r){return null;}var t=r.getParent();var f=r.getCells();var $;var I;if(T.hasRowActions(t)){f.push(r.getAggregation("_rowAction"));}for(var i=0;i<f.length;i++){$=T.getParentCell(t,f[i].getDomRef());I=T.getInteractiveElements($);if(I){return I.first();}}return null;};b._getLastInteractiveElement=function(r){if(!r){return null;}var t=r.getParent();var f=r.getCells();var $;var I;if(T.hasRowActions(t)){f.push(r.getAggregation("_rowAction"));}for(var i=f.length-1;i>=0;i--){$=T.getParentCell(t,f[i].getDomRef());I=T.getInteractiveElements($);if(I){return I.last();}}return null;};b._getPreviousInteractiveElement=function(t,E){if(!t||!E){return null;}var $=q(E);if(!this._isElementInteractive($)){return null;}var f=T.getParentCell(t,E);var I;var o;var g;var h;var j;var k;var m;I=T.getInteractiveElements(f);if(I[0]!==$[0]){return I.eq(I.index(E)-1);}o=T.getCellInfo(f);h=t.getRows()[o.rowIndex].getCells();if(o.isOfType(C.ROWACTION)){m=h.length-1;}else{j=t.getColumns()[o.columnIndex];k=b._getColumnIndexInVisibleAndGroupedColumns(t,j);m=k-1;}for(var i=m;i>=0;i--){g=h[i].getDomRef();f=T.getParentCell(t,g);I=T.getInteractiveElements(f);if(I){return I.last();}}return null;};b._getNextInteractiveElement=function(t,E){if(!t||!E){return null;}var $=q(E);if(!this._isElementInteractive($)){return null;}var f=T.getParentCell(t,E);var I;var o;var g;var h;var j;var r;var k;I=T.getInteractiveElements(f);if(I.get(-1)!==$[0]){return I.eq(I.index(E)+1);}o=T.getCellInfo(f);if(o.isOfType(C.ROWACTION)){return null;}r=t.getRows()[o.rowIndex];h=r.getCells();j=t.getColumns()[o.columnIndex];k=b._getColumnIndexInVisibleAndGroupedColumns(t,j);for(var i=k+1;i<h.length;i++){g=h[i].getDomRef();f=T.getParentCell(t,g);I=T.getInteractiveElements(f);if(I){return I.first();}}if(T.hasRowActions(t)){f=T.getParentCell(t,r.getAggregation("_rowAction").getDomRef());I=T.getInteractiveElements(f);if(I.get(-1)!==$[0]){return I.eq(I.index(E)+1);}}return null;};b.prototype.enterActionMode=function(){var k=this._getKeyboardExtension();var A=document.activeElement;var i=T.getInteractiveElements(A);var $=T.getParentCell(this,A);if(i){k._suspendItemNavigation();A.tabIndex=-1;b._focusElement(this,i[0],true);return true;}else if($){this._getKeyboardExtension()._suspendItemNavigation();return true;}return false;};b.prototype.leaveActionMode=function(A){A=A==null?true:A;var k=this._getKeyboardExtension();var o=document.activeElement;var $=T.getParentCell(this,o);k._resumeItemNavigation();if(A){if($){b._focusElement(this,$[0],true);}else{k._setSilentFocus(o);}}};b.prototype.onfocusin=function(E){if(E.isMarked("sapUiTableIgnoreFocusIn")){return;}var t=q(E.target);if(t.hasClass("sapUiTableOuterBefore")||t.hasClass("sapUiTableOuterAfter")||(E.target!=this.getDomRef("overlay")&&this.getShowOverlay())){this.$("overlay").focus();}else if(t.hasClass("sapUiTableCtrlBefore")){var n=T.isNoDataVisible(this);if(!n||n&&this.getColumnHeaderVisible()){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,E);}else{this._getKeyboardExtension()._setSilentFocus(this.$("noDataCnt"));}}else if(t.hasClass("sapUiTableCtrlAfter")){if(!T.isNoDataVisible(this)){b._restoreFocusOnLastFocusedDataCell(this,E);}}var o=T.getCellInfo(E.target);var i=o.isOfType(C.ROWHEADER)&&T.Grouping.isInGroupingRow(E.target);var I=o.isOfType(C.ROWHEADER)&&!i&&T.isRowSelectorSelectionAllowed(this);var f=o.isOfType(C.DATACELL)&&this._getKeyboardExtension()._bStayInActionMode;var P=T.getCellInfo(T.getParentCell(this,E.target)).isOfType(C.ANYCONTENTCELL);var g=b._isElementInteractive(E.target);var h=this._getKeyboardExtension().isInActionMode();var j=(h&&(i||I||f)||(g&&P));if(f){this._getKeyboardExtension()._bStayInActionMode=false;}this._getKeyboardExtension().setActionMode(j,false);};b.prototype.onkeydown=function(E){var k=this._getKeyboardExtension();if(b._isKeyCombination(E,K.F2)){var i=k.isInActionMode();var P=T.getParentCell(this,E.target);if(!i&&P){P.focus();}else{k.setActionMode(!i);}return;}else if(b._isKeyCombination(E,K.F4)&&b._isElementGroupToggler(this,E.target)){T.Grouping.toggleGroupHeaderByRef(this,E.target);return;}if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,K.SPACE)&&T.getCellInfo(E.target).type){E.preventDefault();}var t=q(E.target);var o=T.getCellInfo(t);var f=this.getSelectionMode();if(b._isKeyCombination(E,K.SHIFT)&&f===S.MultiToggle&&(o.isOfType(C.ROWHEADER)&&T.isRowSelectorSelectionAllowed(this)||(o.isOfType(C.DATACELL|C.ROWACTION))&&T.isRowSelectionAllowed(this))){var F=T.getRowIndexOfFocusedCell(this);var g=this.getRows()[F].getIndex();this._oRangeSelection={startIndex:g,selected:this.isIndexSelected(g)};}else if(b._isKeyCombination(E,K.A,M.CTRL)){E.preventDefault();if(o.isOfType(C.ANYCONTENTCELL|C.COLUMNROWHEADER)&&f===S.MultiToggle){this._toggleSelectAll();}}else if(b._isKeyCombination(E,K.A,M.CTRL+M.SHIFT)){if(o.isOfType(C.ANYCONTENTCELL|C.COLUMNROWHEADER)){this.clearSelection();}}else if(b._isKeyCombination(E,K.F4)){if(o.isOfType(C.DATACELL)){k.setActionMode(true);}}else if(b._isKeyCombination(E,K.F10,M.SHIFT)){E.preventDefault();T.Menu.openContextMenu(this,E.target,true,null,E);}};b.prototype.onkeypress=function(E){var k=this._getKeyboardExtension();var o=T.getCellInfo(E.target);if(b._isKeyCombination(E,"+")){if(b._isElementGroupToggler(this,E.target)){T.Grouping.toggleGroupHeaderByRef(this,E.target,true);}else if(o.isOfType(C.DATACELL|C.ROWACTION)){k.setActionMode(true);}}else if(b._isKeyCombination(E,"-")){if(b._isElementGroupToggler(this,E.target)){T.Grouping.toggleGroupHeaderByRef(this,E.target,false);}else if(o.isOfType(C.DATACELL|C.ROWACTION)){k.setActionMode(true);}}};b.prototype.oncontextmenu=function(E){if(E.isMarked("handledByPointerExtension")){return;}E.preventDefault();var $=T.getCell(this,E.target);var o=T.getCellInfo($);if(o.isOfType(C.COLUMNHEADER|C.ANYCONTENTCELL)){T.Menu.openContextMenu(this,E.target,true,null,E);}};b.prototype.onkeyup=function(E){var o=T.getCellInfo(E.target);if(b._isKeyCombination(E,K.SHIFT)){delete this._oRangeSelection;}if(b._isKeyCombination(E,K.SPACE)){if(o.isOfType(C.COLUMNHEADER)){T.Menu.openContextMenu(this,E.target,true);}else{b._handleSpaceAndEnter(this,E);}}if(b._isKeyCombination(E,K.ENTER)){if(o.isOfType(C.COLUMNHEADER)){T.Menu.openContextMenu(this,E.target,true);}}};b.prototype.onsaptabnext=function(E){var k=this._getKeyboardExtension();var o=T.getCellInfo(E.target);var $;if(k.isInActionMode()){var I;$=T.getCell(this,E.target);o=T.getCellInfo($);if(!o.isOfType(C.ANYCONTENTCELL)){return;}var r=this.getRows()[o.rowIndex];var L=b._getLastInteractiveElement(r);var f=L===null||L[0]===E.target;if(f){var A=r.getIndex();var g=T.isLastScrollableRow(this,$);var h=this._getTotalRowCount()-1===A;var t=T.isRowSelectorSelectionAllowed(this);E.preventDefault();if(h){k.setActionMode(false);}else if(g){s(this,o,t,o.rowIndex,r);}else{var R=o.rowIndex;if(t){b._focusCell(this,C.ROWHEADER,R+1);}else{var v=this.getVisibleRowCount();var j=false;for(var i=o.rowIndex+1;i<v;i++){R=i;r=this.getRows()[R];I=b._getFirstInteractiveElement(r);j=T.Grouping.isGroupingRow(r.getDomRef());if(I||j){break;}}if(I){b._focusElement(this,I[0]);}else if(j){b._focusCell(this,C.ROWHEADER,R);}else{s(this,o,t,R,r);}}}}else if(o.isOfType(C.ROWHEADER)){E.preventDefault();I=b._getFirstInteractiveElement(r);b._focusElement(this,I[0]);}else{E.preventDefault();I=b._getNextInteractiveElement(this,E.target);b._focusElement(this,I[0]);}}else if(o.isOfType(C.ANYCOLUMNHEADER)){if(T.isNoDataVisible(this)){this.$("noDataCnt").focus();}else{b._restoreFocusOnLastFocusedDataCell(this,E);}E.preventDefault();}else if(o.isOfType(C.ANYCONTENTCELL)){b._forwardFocusToTabDummy(this,"sapUiTableCtrlAfter");}else if(E.target===this.getDomRef("overlay")){k._setSilentFocus(this.$().find(".sapUiTableOuterAfter"));}else if(!o.isOfType(C.ANY)){$=T.getParentCell(this,E.target);if($){E.preventDefault();$.focus();}}};function s(t,o,f,r,R){var A=o.isOfType(C.DATACELL);var k=t._getKeyboardExtension();var g=t._getScrollExtension().scrollVertically(true,false,true,A,function(){if(A){document.activeElement.blur();}});if(g){t.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){var I=T.Grouping.isGroupingRow(R.getDomRef());c(t,R,r,f,I);},0);});}else if(R.getIndex()!==t._getTotalRowCount()-1){var n=o.rowIndex+1;var h=t.getRows()[n];var i=T.Grouping.isGroupingRow(h.getDomRef());c(t,h,n,f,i);}else{k.setActionMode(false);}}function c(t,r,R,f,i){var k=t._getKeyboardExtension();if(f||i){b._focusCell(t,C.ROWHEADER,R);}else{var I=b._getFirstInteractiveElement(r);if(I){b._focusElement(t,I[0]);}else{b._focusCell(t,C.DATACELL,R,0,false,true);if(r.getIndex()===t._getTotalRowCount()-1){k.setActionMode(false);}}}}b.prototype.onsaptabprevious=function(E){var k=this._getKeyboardExtension();var o=T.getCellInfo(E.target);var $;if(k.isInActionMode()){var I;$=T.getCell(this,E.target);o=T.getCellInfo($);if(!o.isOfType(C.ANYCONTENTCELL)){return;}var r=this.getRows()[o.rowIndex];var A=r.getIndex();var f=b._getFirstInteractiveElement(r);var g=f!==null&&f[0]===E.target;var t=T.isRowSelectorSelectionAllowed(this);var R=T.Grouping.isGroupingRow(r);var h=t||R;if(g&&h){E.preventDefault();b._focusCell(this,C.ROWHEADER,o.rowIndex);}else if((g&&!h)||o.isOfType(C.ROWHEADER)||f===null){var j=T.isFirstScrollableRow(this,$);var m=A===0;E.preventDefault();if(m){k.setActionMode(false);}else if(j){d(this,o,h,o.rowIndex,r);}else{var n=o.rowIndex;var R=false;for(var i=o.rowIndex-1;i>=0;i--){n=i;r=this.getRows()[n];I=b._getLastInteractiveElement(r);R=T.Grouping.isGroupingRow(r.getDomRef());if(I||h||R){break;}}if(I){b._focusElement(this,I[0]);}else if(R||h){b._focusCell(this,C.ROWHEADER,n);}else{d(this,o,h,n,r);}}}else{E.preventDefault();I=b._getPreviousInteractiveElement(this,E.target);b._focusElement(this,I[0]);}}else if(o.isOfType(C.ANYCONTENTCELL)||E.target===this.getDomRef("noDataCnt")){if(this.getColumnHeaderVisible()&&!o.isOfType(C.ROWACTION)){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,E);E.preventDefault();}else{b._forwardFocusToTabDummy(this,"sapUiTableCtrlBefore");}}else if(E.target===this.getDomRef("overlay")){this._getKeyboardExtension()._setSilentFocus(this.$().find(".sapUiTableOuterBefore"));}else if(!o.isOfType(C.ANY)){$=T.getParentCell(this,E.target);if($){E.preventDefault();$.focus();}}};function d(t,o,r,R,f){var A=o.isOfType(C.DATACELL);var k=t._getKeyboardExtension();var g=t._getScrollExtension().scrollVertically(false,false,true,A,function(){if(A){document.activeElement.blur();}});if(g){t.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){var I=T.Grouping.isGroupingRow(f.getDomRef());e(t,f,R,r,I);},0);});}else if(f.getIndex()!==0){var P=o.rowIndex-1;var h=t.getRows()[P];var i=T.Grouping.isGroupingRow(h.getDomRef());e(t,h,P,r,i);}else{k.setActionMode(false);}}function e(t,r,R,f,i){var k=t._getKeyboardExtension();var I=b._getLastInteractiveElement(r);if(I){b._focusElement(t,I[0]);}else if(f||i){b._focusCell(t,C.ROWHEADER,R);}else{b._focusCell(t,C.DATACELL,R,0,false,true);if(r.getIndex()===0){k.setActionMode(false);}}}b.prototype.onsapdown=function(E){b._navigate(this,E,N.DOWN);};b.prototype.onsapdownmodifiers=function(E){if(b._isKeyCombination(E,null,M.CTRL)){b._navigate(this,E,N.DOWN);return;}var k=this._getKeyboardExtension();if(b._isKeyCombination(E,null,M.ALT)&&b._isElementGroupToggler(this,E.target)){p(E);T.Grouping.toggleGroupHeaderByRef(this,E.target,true);return;}if(k.isInActionMode()){return;}var o=T.getCellInfo(E.target);if(b._isKeyCombination(E,null,M.SHIFT)){E.preventDefault();if(o.isOfType(C.ANYCONTENTCELL)){if(!this._oRangeSelection){p(E);return;}var f=T.getRowIndexOfFocusedCell(this);var i=this.getRows()[f].getIndex();if(i===this._getTotalRowCount()-1){return;}if(T.isLastScrollableRow(this,E.target)){var g=this._getScrollExtension().scrollVertically(true,false,true);if(g){p(E);}}if(this._oRangeSelection.startIndex<=i){i++;if(this._oRangeSelection.selected){T.toggleRowSelection(this,i,true);}else{T.toggleRowSelection(this,i,false);}}else{T.toggleRowSelection(this,i,false);}}else{p(E);}}if(b._isKeyCombination(E,null,M.ALT)){if(o.isOfType(C.DATACELL)){k.setActionMode(true);}p(E);}};b.prototype.onsapup=function(E){b._navigate(this,E,N.UP);};b.prototype.onsapupmodifiers=function(E){var k=this._getKeyboardExtension();if(b._isKeyCombination(E,null,M.CTRL)){b._navigate(this,E,N.UP);return;}if(b._isKeyCombination(E,null,M.ALT)&&b._isElementGroupToggler(this,E.target)){p(E);T.Grouping.toggleGroupHeaderByRef(this,E.target,false);return;}if(k.isInActionMode()){return;}var o=T.getCellInfo(E.target);if(b._isKeyCombination(E,null,M.SHIFT)){E.preventDefault();if(o.isOfType(C.ANYCONTENTCELL)){if(!this._oRangeSelection){p(E);return;}var f=T.getRowIndexOfFocusedCell(this);var i=this.getRows()[f].getIndex();if(i===0){p(E);return;}if(T.isFirstScrollableRow(this,E.target)){var g=this._getScrollExtension().scrollVertically(false,false,true);if(g){p(E);}}if(this._oRangeSelection.startIndex>=i){i--;if(this._oRangeSelection.selected){T.toggleRowSelection(this,i,true);}else{T.toggleRowSelection(this,i,false);}}else{T.toggleRowSelection(this,i,false);}}else{p(E);}}if(b._isKeyCombination(E,null,M.ALT)){if(o.isOfType(C.DATACELL)){k.setActionMode(true);}p(E);}};b.prototype.onsapleft=function(E){b._navigate(this,E,N.LEFT);};b.prototype.onsapleftmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}var o=T.getCellInfo(E.target);var I=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(E,null,M.SHIFT)){E.preventDefault();if(o.isOfType(C.DATACELL)){if(!this._oRangeSelection){p(E);return;}var f=T.getFocusedItemInfo(this);var F=T.hasRowHeader(this)&&f.cellInRow===1;if(F&&!T.isRowSelectorSelectionAllowed(this)){p(E);}}else if(o.isOfType(C.ROWACTION)){if(!this._oRangeSelection){p(E);}}else if(o.isOfType(C.ROWHEADER)&&I){if(!T.isRowSelectionAllowed(this)){p(E);}}else if(o.isOfType(C.COLUMNROWHEADER)&&I){p(E);}else if(o.isOfType(C.COLUMNHEADER)){var r=-this._CSSSizeToPixel(a);var g=0;if(I){r=r*-1;}for(var i=o.columnIndex;i<o.columnIndex+o.columnSpan;i++){g+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,o.columnIndex,g+r,true,o.columnSpan);p(E);}}else if(b._isKeyCombination(E,null,M.CTRL)){if(o.isOfType(C.COLUMNHEADER)){E.preventDefault();E.stopImmediatePropagation();var h=this.getColumns()[o.columnIndex];b._moveColumn(h,I);}}};b.prototype.onsaprightmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}var o=T.getCellInfo(E.target);var I=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(E,null,M.SHIFT)){E.preventDefault();if(o.isOfType(C.DATACELL)){if(!this._oRangeSelection){p(E);}}else if(o.isOfType(C.ROWHEADER)){if(!T.isRowSelectionAllowed(this)){p(E);}}else if(o.isOfType(C.ROWACTION)&&I){if(!this._oRangeSelection){p(E);}}else if(o.isOfType(C.COLUMNHEADER)){var r=this._CSSSizeToPixel(a);var f=0;if(I){r=r*-1;}for(var i=o.columnIndex;i<o.columnIndex+o.columnSpan;i++){f+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,o.columnIndex,f+r,true,o.columnSpan);p(E);}else if(o.isOfType(C.COLUMNROWHEADER)){p(E);}}else if(b._isKeyCombination(E,null,M.CTRL)){if(o.isOfType(C.COLUMNHEADER)){E.preventDefault();E.stopImmediatePropagation();var g=this.getColumns()[o.columnIndex];b._moveColumn(g,!I);}}};b.prototype.onsaphome=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(T.Grouping.isInGroupingRow(E.target)){p(E);E.preventDefault();return;}var o=T.getCellInfo(E.target);if(o.isOfType(C.ANY)){E.preventDefault();}if(o.isOfType(C.DATACELL|C.ROWACTION|C.COLUMNHEADER)){var f=T.getFocusedItemInfo(this);var F=f.cell;var i=f.cellInRow;var g=this.getComputedFixedColumnCount();var h=T.hasRowHeader(this);var r=h?1:0;if(T.hasFixedColumns(this)&&i>g+r){p(E);T.focusItem(this,F-i+g+r,null);}else if(h&&i>1){p(E);T.focusItem(this,F-i+r,null);}}};b.prototype.onsapend=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(T.Grouping.isInGroupingRow(E.target)){E.preventDefault();p(E);return;}var o=T.getCellInfo(E.target);if(o.isOfType(C.ANY)){E.preventDefault();var f=T.getFocusedItemInfo(this);var F=f.cell;var i=f.columnCount;var g=this.getComputedFixedColumnCount();var h=f.cellInRow;var j=T.hasRowHeader(this);var r=j?1:0;var I=false;if(o.isOfType(C.COLUMNHEADER)&&T.hasFixedColumns(this)){var k=parseInt(o.cell.attr("colspan")||1,10);if(k>1&&h+k-r===g){I=true;}}if(j&&h===0){p(E);T.focusItem(this,F+1,null);}else if(T.hasFixedColumns(this)&&h<g-1+r&&!I){p(E);T.focusItem(this,F+g-h,null);}else if(T.hasRowActions(this)&&o.isOfType(C.DATACELL)&&h<i-2){p(E);T.focusItem(this,F-h+i-2,null);}}};b.prototype.onsaphomemodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,null,M.CTRL)){E.preventDefault();var o=T.getCellInfo(E.target);if(o.isOfType(C.ANYCONTENTCELL|C.COLUMNHEADER)){p(E);var f=T.getFocusedItemInfo(this);var F=f.row;if(F>0){var i=f.cell;var g=f.columnCount;var h=T.getHeaderRowCount(this);var j=this.getFixedRowCount();var k=this.getFixedBottomRowCount();if(F<h+j){if(o.isOfType(C.ROWACTION)){T.focusItem(this,i-g*(F-h),E);}else{T.focusItem(this,i-g*F,E);}}else if(F>=h+j&&F<h+T.getNonEmptyVisibleRowCount(this)-k){this._getScrollExtension().scrollVerticallyMax(false,true);if(j>0||o.isOfType(C.ROWACTION)){T.focusItem(this,i-g*(F-h),E);}else{T.focusItem(this,i-g*F,E);}}else{this._getScrollExtension().scrollVerticallyMax(false,true);T.focusItem(this,i-g*(F-h-j),E);}}}}};b.prototype.onsapendmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,null,M.CTRL)){E.preventDefault();var o=T.getCellInfo(E.target);if(o.isOfType(C.ANY)){var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var n=T.getNonEmptyVisibleRowCount(this);var i=this.getFixedRowCount();var g=this.getFixedBottomRowCount();p(E);if(g===0||F<h+n-1||(T.isNoDataVisible(this)&&F<h-1)){var j=f.cell;var k=f.columnCount;if(T.isNoDataVisible(this)){T.focusItem(this,j+k*(h-F-1),E);}else if(F<h){if(i>0){T.focusItem(this,j+k*(h+i-F-1),E);}else{this._getScrollExtension().scrollVerticallyMax(true,true);T.focusItem(this,j+k*(h+n-g-F-1),E);}}else if(F>=h&&F<h+i){this._getScrollExtension().scrollVerticallyMax(true,true);T.focusItem(this,j+k*(h+n-g-F-1),E);}else if(F>=h+i&&F<h+n-g){this._getScrollExtension().scrollVerticallyMax(true,true);T.focusItem(this,j+k*(h+n-F-1),E);}else{T.focusItem(this,j+k*(h+n-F-1),E);}}}}};b.prototype.onsappageup=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}E.preventDefault();var o=T.getCellInfo(E.target);if(o.isOfType(C.ANYCONTENTCELL|C.COLUMNHEADER)){var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var i=this.getFixedRowCount();var g=this.getFixedBottomRowCount();if(i===0&&F>=h||i>0&&F>h){p(E);var j=f.cell;var k=f.columnCount;if(F<h+i){T.focusItem(this,j-k*(F-h),E);}else if(F===h+i){var P=T.getNonEmptyVisibleRowCount(this)-i-g;var r=this.getFirstVisibleRow();this._getScrollExtension().scrollVertically(false,true,true);if(r<P){if(i>0||o.isOfType(C.ROWACTION)){T.focusItem(this,j-k*(F-h),E);}else{T.focusItem(this,j-k*h,E);}}}else if(F>h+i&&F<h+T.getNonEmptyVisibleRowCount(this)){T.focusItem(this,j-k*(F-h-i),E);}else{T.focusItem(this,j-k*(F-h-T.getNonEmptyVisibleRowCount(this)+1),E);}}if(o.isOfType(C.ROWACTION)&&F===h&&i>0){p(E);}}};b.prototype.onsappagedown=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}E.preventDefault();var o=T.getCellInfo(E.target);if(o.isOfType(C.ANY)){var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var n=T.getNonEmptyVisibleRowCount(this);var i=this.getFixedRowCount();var g=this.getFixedBottomRowCount();p(E);if((T.isNoDataVisible(this)&&F<h-1)||g===0||F<h+n-1){var j=f.cell;var k=f.columnCount;if(F<h-1&&!o.isOfType(C.COLUMNROWHEADER)){T.focusItem(this,j+k*(h-F-1),E);}else if(F<h){if(!T.isNoDataVisible(this)){T.focusItem(this,j+k*(h-F),E);}}else if(F>=h&&F<h+n-g-1){T.focusItem(this,j+k*(h+n-g-F-1),E);}else if(F===h+n-g-1){var P=T.getNonEmptyVisibleRowCount(this)-i-g;var r=this._getTotalRowCount()-g-this.getFirstVisibleRow()-P*2;this._getScrollExtension().scrollVertically(true,true,true);if(r<P&&g>0){T.focusItem(this,j+k*(h+n-F-1),E);}}else{T.focusItem(this,j+k*(h+n-F-1),E);}}}};b.prototype.onsappageupmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,null,M.ALT)){var o=T.getCellInfo(E.target);var f=T.getFocusedItemInfo(this);if(o.isOfType(C.DATACELL|C.COLUMNHEADER)){var F=f.cell;var i=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var P=H;p(E);if(h&&(T.Grouping.isInGroupingRow(E.target)||i===1)){T.focusItem(this,F-i,null);}else if(i-r<P){T.focusItem(this,F-i+r,null);}else{T.focusItem(this,F-P,null);}}else if(o.isOfType(C.ROWACTION)){T.focusItem(this,f.cell-1,null);}}};b.prototype.onsappagedownmodifiers=function(E){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(E,null,M.ALT)){var o=T.getCellInfo(E.target);if(o.isOfType(C.DATACELL|C.ROWHEADER|C.ANYCOLUMNHEADER)){var f=T.getFocusedItemInfo(this);var F=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var v=T.getVisibleColumnCount(this);var i=parseInt(o.cell.attr("colspan")||1,10);p(E);if(F+i-r<v){var g=f.cell;var P=H;if(h&&F===0){T.focusItem(this,g+1,null);}else if(i>P){T.focusItem(this,g+i,null);}else if(F+i-r+P>v){T.focusItem(this,g+v-F-1+r,null);}else if(!T.Grouping.isInGroupingRow(E.target)){T.focusItem(this,g+P,null);}}else if(o.isOfType(C.DATACELL)&&T.hasRowActions(this)&&F===f.columnCount-2){T.focusItem(this,f.cell+1,null);}}}};b.prototype.onsapenter=function(E){b._handleSpaceAndEnter(this,E);};return b;});
