/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./TableExtension","./TableUtils","sap/ui/Device","./library","sap/ui/performance/trace/Interaction","sap/base/Log","sap/ui/thirdparty/jquery"],function(T,c,D,l,I,L,q){"use strict";var S=l.SharedDomRef;var M=1000000;var V=2;var d={HORIZONAL:"HORIZONTAL",VERTICAL:"VERTICAL",BOTH:"BOTH"};function e(o){return typeof o.isConnected==="boolean"&&o.isConnected||document.body.contains(o);}var H={onScroll:function(o){var s=this._getScrollExtension();I.notifyScrollEvent&&I.notifyScrollEvent(o);if(this._bOnAfterRendering){return;}var n=o.target.scrollLeft;var O=o.target._scrollLeft;if(n!==O){var a=H.getScrollAreas(this);o.target._scrollLeft=n;for(var i=0;i<a.length;i++){var b=a[i];if(b!==o.target&&b.scrollLeft!==n){b.scrollLeft=n;b._scrollLeft=n;}}s._iHorizontalScrollPosition=n;}},restoreScrollPosition:function(t){var s=t._getScrollExtension();var o=s.getHorizontalScrollbar();if(o&&s._iHorizontalScrollPosition!==null){var a=H.getScrollAreas(t);for(var i=0;i<a.length;i++){var b=a[i];delete b._scrollLeft;}if(o.scrollLeft!==s._iHorizontalScrollPosition){o.scrollLeft=s._iHorizontalScrollPosition;}else{var j=q.Event("scroll");j.target=o;H.onScroll.call(t,j);}}},onScrollbarMouseDown:function(o){this._getKeyboardExtension().setActionMode(false);},addEventListeners:function(t){var s=t._getScrollExtension();var o=s.getHorizontalScrollbar();var a=H.getScrollAreas(t);if(!s._onHorizontalScrollEventHandler){s._onHorizontalScrollEventHandler=H.onScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onHorizontalScrollEventHandler);}if(o){if(!s._onHorizontalScrollbarMouseDownEventHandler){s._onHorizontalScrollbarMouseDownEventHandler=H.onScrollbarMouseDown.bind(t);}o.addEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);}},removeEventListeners:function(t){var s=t._getScrollExtension();var o=s.getHorizontalScrollbar();var a=H.getScrollAreas(t);if(s._onHorizontalScrollEventHandler){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onHorizontalScrollEventHandler);delete a[i]._scrollLeft;}delete s._onHorizontalScrollEventHandler;}if(o&&s._onHorizontalScrollbarMouseDownEventHandler){o.removeEventListener("mousedown",s._onHorizontalScrollbarMouseDownEventHandler);delete s._onHorizontalScrollbarMouseDownEventHandler;}},getScrollAreas:function(t){var s=[t._getScrollExtension().getHorizontalScrollbar(),t.getDomRef("sapUiTableColHdrScr"),t.getDomRef("sapUiTableCtrlScr")];return s.filter(function(o){return o!=null;});}};var f={onScroll:function(o){var s=this._getScrollExtension();I.notifyScrollEvent&&I.notifyScrollEvent(o);if(s._bIsScrolledVerticallyByKeyboard||f.isUpdatePending(this)){L.debug("sap.ui.table.TableScrollExtension","Vertical scroll event handler aborted: "+(s._bIsScrolledVerticallyByKeyboard?"Scrolled by keyboard":"Waiting for pending update"),this);return;}this._getKeyboardExtension().setActionMode(false);var n=o.target.scrollTop;var a=o.target._scrollTop;if(n!==a){L.debug("sap.ui.table.TableScrollExtension","Scroll position changed by setting scrollTop: "+"From "+s._nVerticalScrollPosition+" to "+n,this);delete o.target._scrollTop;s._nVerticalScrollPosition=n;s._iFirstVisibleRowInBuffer=null;}clearTimeout(this._mTimeouts.largeDataScrolling);delete this._mTimeouts.largeDataScrolling;if(this._bLargeDataScrolling&&!s._bIsScrolledVerticallyByWheel){this._mTimeouts.largeDataScrolling=setTimeout(function(){delete this._mTimeouts.largeDataScrolling;f.updateFirstVisibleRow(this);}.bind(this),300);}else{f.updateFirstVisibleRow(this);}s._bIsScrolledVerticallyByWheel=false;},updateFirstVisibleRow:function(t){var s=t._getScrollExtension();var n=s.getRowIndexAtCurrentScrollPosition();var o=t.getFirstVisibleRow();var N=n<0;var O=o>=t._getMaxFirstRenderedRowIndex();var F=n!==o;var r=F&&!(N&&O);if(r){if(N){n=t._getMaxFirstRenderedRowIndex();}L.debug("sap.ui.table.TableScrollExtension","updateFirstVisibleRow: From "+o+" to "+n,t);t.setFirstVisibleRow(n,true);t._bIgnoreOnRowsUpdatedOnScroll=true;t.attachEventOnce("_rowsUpdated",function(){s.updateInnerVerticalScrollPosition();delete t._bIgnoreOnRowsUpdatedOnScroll;});}else if(c.isVariableRowHeightEnabled(t)){L.debug("sap.ui.table.TableScrollExtension","updateFirstVisibleRow: Update inner vertical scroll position",t);s.updateInnerVerticalScrollPosition();}},onScrollbarMouseDown:function(o){var s=this._getScrollExtension();s._bIsScrolledVerticallyByWheel=false;s._bIsScrolledVerticallyByKeyboard=false;},onRowsUpdated:function(o){if(this._bIgnoreOnRowsUpdatedOnScroll){return;}if(c.isVariableRowHeightEnabled(this)){var r=o.getParameters().reason;var s=this._getScrollExtension();var F=this.getFirstVisibleRow()-this._getMaxFirstRenderedRowIndex();if(F>=0&&(r===c.RowsUpdateReason.Expand||r===c.RowsUpdateReason.Collapse)){s._iFirstVisibleRowInBuffer=F;s.updateInnerVerticalScrollPosition();}}},restoreScrollPosition:function(t){var s=t._getScrollExtension();s.updateVerticalScrollPosition(s._nVerticalScrollPosition);},addEventListeners:function(t){var s=t._getScrollExtension();var a=f.getScrollAreas(t);var v=s.getVerticalScrollbar();if(!s._onVerticalScrollEventHandler){s._onVerticalScrollEventHandler=f.onScroll.bind(t);}for(var i=0;i<a.length;i++){a[i].addEventListener("scroll",s._onVerticalScrollEventHandler);}if(v){if(!s._onVerticalScrollbarMouseDownEventHandler){s._onVerticalScrollbarMouseDownEventHandler=f.onScrollbarMouseDown.bind(t);}v.addEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);}t.attachEvent("_rowsUpdated",f.onRowsUpdated);},removeEventListeners:function(t){var s=t._getScrollExtension();var a=f.getScrollAreas(t);var v=s.getVerticalScrollbar();if(s._onVerticalScrollEventHandler){for(var i=0;i<a.length;i++){a[i].removeEventListener("scroll",s._onVerticalScrollEventHandler);}delete s._onVerticalScrollEventHandler;}if(v&&s._onVerticalScrollbarMouseDownEventHandler){v.removeEventListener("mousedown",s._onVerticalScrollbarMouseDownEventHandler);delete s._onVerticalScrollbarMouseDownEventHandler;}t.detachEvent("_rowsUpdated",f.onRowsUpdated);},isUpdatePending:function(t){return!!(t&&(t._mAnimationFrames.verticalScrollUpdate||t._mTimeouts.verticalScrollUpdate));},getScrollAreas:function(t){var s=[t._getScrollExtension().getVerticalScrollbar()];return s.filter(function(o){return o!=null;});}};var g={onMouseWheelScrolling:function(o,a){var s=this._getScrollExtension();var v=Math.abs(a.deltaY)>Math.abs(a.deltaX);var i=v?a.deltaY:a.deltaX;var b=v&&a.shiftKey||!v;var j=i>0;var k=false;if(i===0){return;}if(b&&(o.scrollDirection===d.HORIZONAL||o.scrollDirection===d.BOTH)){var m=s.getHorizontalScrollbar();if(a.deltaMode>0){var n=c.Column.getMinColumnWidth();i=j?n:-n;}if(j){k=m.scrollLeft===m.scrollWidth-m.offsetWidth;}else{k=m.scrollLeft===0;}if(s.isHorizontalScrollbarVisible()&&!k){this._getKeyboardExtension().setActionMode(false);m.scrollLeft=m.scrollLeft+i;}a.preventDefault();a.stopPropagation();}else if(!b&&(o.scrollDirection===d.VERTICAL||o.scrollDirection===d.BOTH)){var p=s.getVerticalScrollbar();if(a.deltaMode===1){i*=s.getVerticalScrollRangeRowFraction();}else if(a.deltaMode===2){i*=s.getVerticalScrollRangeRowFraction()*this.getVisibleRowCount();}if(j){k=p.scrollTop===p.scrollHeight-p.offsetWidth;}else{k=p.scrollTop===0;}if(s.isVerticalScrollbarVisible()&&!k){a.preventDefault();a.stopPropagation();var r=s.getVerticalScrollPosition();var t=i;var u=s.getVerticalScrollRangeRowFraction();if(!s.isVerticalScrollPositionInBuffer()){var w=i/(a.deltaMode===0?this._getDefaultRowHeight():u);if(w>1){w=Math.floor(w);}else if(w<-1){w=Math.ceil(w);}t=w*u;}else if(!j){var x=r-(this._getFirstRenderedRowIndex()*u);if(x<=0){t=-s.getVerticalScrollRangeRowFraction();}else if(x+t<0){t=-x;}}s._bIsScrolledVerticallyByWheel=true;s._bIsScrolledVerticallyByKeyboard=false;this._getKeyboardExtension().setActionMode(false);s.updateVerticalScrollPosition(r+t);}}},onTouchStart:function(o,a){if(a.type==="touchstart"||a.pointerType==="touch"){var s=this._getScrollExtension();var b=s.getHorizontalScrollbar();var v=s.getVerticalScrollbar();var t=a.touches?a.touches[0]:a;s._mTouchSessionData={initialPageX:t.pageX,initialPageY:t.pageY,initialScrollTop:v?v.scrollTop:0,initialScrollLeft:b?b.scrollLeft:0,initialScrolledToEnd:null,touchMoveDirection:null};}},onTouchMoveScrolling:function(o,a){if(a.type==="touchmove"||a.pointerType==="touch"){var s=this._getScrollExtension();var t=s._mTouchSessionData;if(!t){return;}var b=a.touches?a.touches[0]:a;var i=(b.pageX-t.initialPageX);var j=(b.pageY-t.initialPageY);var k=false;var m=false;if(!t.touchMoveDirection){if(i===0&&j===0){return;}t.touchMoveDirection=Math.abs(i)>Math.abs(j)?"horizontal":"vertical";}switch(t.touchMoveDirection){case"horizontal":var n=s.getHorizontalScrollbar();if(n&&(o.scrollDirection===d.HORIZONAL||o.scrollDirection===d.BOTH)){this._getKeyboardExtension().setActionMode(false);if(i<0){k=n.scrollLeft===n.scrollWidth-n.offsetWidth;}else{k=n.scrollLeft===0;}if(!t.initialScrolledToEnd){t.initialScrolledToEnd=k;}if(!k&&!t.initialScrolledToEnd){n.scrollLeft=t.initialScrollLeft-i;m=true;}}break;case"vertical":var v=s.getVerticalScrollbar();if(v&&(o.scrollDirection===d.VERTICAL||o.scrollDirection===d.BOTH)){this._getKeyboardExtension().setActionMode(false);if(j<0){k=v.scrollTop===v.scrollHeight-v.offsetHeight;}else{k=v.scrollTop===0;}if(!t.initialScrolledToEnd){t.initialScrolledToEnd=k;}if(!k&&!t.initialScrolledToEnd){v.scrollTop=t.initialScrollTop-j;m=true;}}break;default:}if(m){a.preventDefault();}}},addEventListeners:function(t){var s=t._getScrollExtension();var a=g.getEventListenerTargets(t);s._mMouseWheelEventListener=this.addMouseWheelEventListener(a,t,{scrollDirection:d.BOTH});s._mTouchEventListener=this.addTouchEventListener(a,t,{scrollDirection:d.BOTH});},addMouseWheelEventListener:function(a,t,o){var O=g.onMouseWheelScrolling.bind(t,o);for(var i=0;i<a.length;i++){a[i].addEventListener("wheel",O);}return{wheel:O};},addTouchEventListener:function(a,t,o){var O=g.onTouchStart.bind(t,o);var b=g.onTouchMoveScrolling.bind(t,o);var m={};for(var i=0;i<a.length;i++){if(D.support.pointer&&D.system.desktop){a[i].addEventListener("pointerdown",O);a[i].addEventListener("pointermove",b,D.browser.chrome?{passive:true}:false);}else if(D.support.touch){a[i].addEventListener("touchstart",O);a[i].addEventListener("touchmove",b);}}if(D.support.pointer&&D.system.desktop){m={pointerdown:O,pointermove:b};}else if(D.support.touch){m={touchstart:O,touchmove:b};}return m;},removeEventListeners:function(t){var s=t._getScrollExtension();var a=g.getEventListenerTargets(t);function r(o,m){for(var b in m){var j=m[b];if(j){o.removeEventListener(b,j);}}}for(var i=0;i<a.length;i++){r(a[i],s._mMouseWheelEventListener);r(a[i],s._mTouchEventListener);}delete s._mMouseWheelEventListener;delete s._mTouchEventListener;},getEventListenerTargets:function(t){var a=[t.getDomRef("tableCCnt")];return a.filter(function(o){return o!=null;});}};var E={onBeforeRendering:function(){this._getScrollExtension()._clearCache();},onAfterRendering:function(o){var s=this._getScrollExtension();var r=o&&o.isMarked("renderRows");if(r){s.updateVerticalScrollbarHeight();s.updateVerticalScrollHeight();}f.restoreScrollPosition(this);H.restoreScrollPosition(this);},onfocusin:function(o){var r;var C=c.getCellInfo(o.target);if(C.isOfType(c.CELLTYPE.DATACELL)){r=this.getDomRef("sapUiTableCtrlScr");}else if(C.isOfType(c.CELLTYPE.COLUMNHEADER)){r=this.getDomRef("sapUiTableColHdrScr");}if(r&&C.columnIndex>=this.getComputedFixedColumnCount()){var a=this._getScrollExtension().getHorizontalScrollbar();var $=q(a);var b=C.cell[0];var i=this._bRtlMode?$.scrollLeftRTL():a.scrollLeft;var R=r.clientWidth;var j=b.offsetLeft;var k=j+b.offsetWidth;var O=j-i;var m=k-R-i;var n;if(O<0&&m<0){n=i+O;}else if(m>0&&O>0){n=i+m;}if(n!=null){if(this._bRtlMode){$.scrollLeftRTL(n);}else{a.scrollLeft=n;}}}var p=c.getParentCell(this,o.target);if(p){Promise.resolve().then(function(){var s=p.find(".sapUiTableCell");if(s.length>0){if(this._bRtlMode){s.scrollLeftRTL(s[0].scrollWidth-s[0].clientWidth);}else{s[0].scrollLeft=0;}s[0].scrollTop=0;}}.bind(this));}}};var h=T.extend("sap.ui.table.TableScrollExtension",{_init:function(t,s,m){this._delegate=E;this._oHorizontalScrollbar=null;this._iHorizontalScrollPosition=null;this._oVerticalScrollbar=null;this._oExternalVerticalScrollbar=null;this._nVerticalScrollPosition=null;this._iVerticalScrollHeight=null;this._iVerticalScrollbarHeight=null;this._iFirstVisibleRowInBuffer=null;this._bIsScrolledVerticallyByWheel=false;this._bIsScrolledVerticallyByKeyboard=false;this._mTouchSessionData=null;this._bIsVerticalScrollbarExternal=false;t.addEventDelegate(this._delegate,t);return"ScrollExtension";},_attachEvents:function(){var t=this.getTable();H.addEventListeners(t);f.addEventListeners(t);g.addEventListeners(t);},_detachEvents:function(){var t=this.getTable();H.removeEventListeners(t);f.removeEventListeners(t);g.removeEventListeners(t);},_debug:function(){this._ScrollingHelper=g;this._ExtensionDelegate=E;this._HorizontalScrollingHelper=H;this._VerticalScrollingHelper=f;},destroy:function(){var t=this.getTable();if(t){t.removeEventDelegate(this._delegate);}this._delegate=null;this._clearCache();this._oExternalVerticalScrollbar=null;T.prototype.destroy.apply(this,arguments);}});h.prototype.scrollVertically=function(b,p,i,a,B){var t=this.getTable();if(!t){return false;}b=b===true;p=p===true;i=i===true;a=a===true;var s=false;var r=t._getTotalRowCount();var v=t.getVisibleRowCount();var j=v-t.getFixedRowCount()-t.getFixedBottomRowCount();var F=t.getFirstVisibleRow();var k=p?j:1;if(b){if(F+v<r){if(B){B();}if(a){setTimeout(function(){t.setFirstVisibleRow(Math.min(F+k,r-v));},0);}else{t.setFirstVisibleRow(Math.min(F+k,r-v));}s=true;}}else if(F>0){if(B){B();}if(a){setTimeout(function(){t.setFirstVisibleRow(Math.max(F-k,0));},0);}else{t.setFirstVisibleRow(Math.max(F-k,0));}s=true;}if(s&&i){this._bIsScrolledVerticallyByKeyboard=true;}return s;};h.prototype.scrollVerticallyMax=function(b,i){var t=this.getTable();if(!t){return false;}if(b==null){b=false;}if(i==null){i=false;}var s=false;var F=t.getFirstVisibleRow();if(b){var a=t._getTotalRowCount()-c.getNonEmptyVisibleRowCount(t);if(F<a){t.setFirstVisibleRow(a);s=true;}}else if(F>0){t.setFirstVisibleRow(0);s=true;}if(s&&i){this._bIsScrolledVerticallyByKeyboard=true;}return s;};h.prototype.getHorizontalScrollbar=function(){var t=this.getTable();if(t&&!t._bInvalid&&!this._oHorizontalScrollbar){this._oHorizontalScrollbar=t.getDomRef(S.HorizontalScrollBar);}return this._oHorizontalScrollbar;};h.prototype.getVerticalScrollbar=function(i){var t=this.getTable();var b=this.isVerticalScrollbarExternal();if(t&&!t._bInvalid&&!this._oVerticalScrollbar){this._oVerticalScrollbar=t.getDomRef(S.VerticalScrollBar);if(!this._oVerticalScrollbar&&b){this._oVerticalScrollbar=this._oExternalVerticalScrollbar;}}if(this._oVerticalScrollbar&&!b&&!i&&!e(this._oVerticalScrollbar)){return null;}return this._oVerticalScrollbar;};h.prototype.isHorizontalScrollbarVisible=function(){var o=this.getHorizontalScrollbar();return o!=null&&!o.classList.contains("sapUiTableHidden");};h.prototype.isVerticalScrollbarVisible=function(){var v=this.getVerticalScrollbar();return v!=null&&!v.classList.contains("sapUiTableHidden");};h.prototype.isVerticalScrollbarExternal=function(){return this._bIsVerticalScrollbarExternal;};h.prototype.markVerticalScrollbarAsExternal=function(s){if(s){this._bIsVerticalScrollbarExternal=true;this._oExternalVerticalScrollbar=s;}};h.prototype.updateHorizontalScrollbar=function(t){var o=this.getTable();var a=this.getHorizontalScrollbar();if(!o||!a||!t){return;}var $=o.$();var C=t.tableCtrlScrollWidth;if(D.browser.safari){C=Math.max(C,o._getColumnsWidth(o.getComputedFixedColumnCount()));}var b=C>t.tableCtrlScrWidth;if(b){if(!this.isHorizontalScrollbarVisible()){$.addClass("sapUiTableHScr");a.classList.remove("sapUiTableHidden");if(D.browser.safari){var i=$.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");i.outerWidth(C);}}var s=t.tableCtrlFixedWidth;if($.find(".sapUiTableRowHdrScr").length>0){s+=t.tableRowHdrScrWidth;}if(o._bRtlMode){a.style.marginRight=s+"px";a.style.marginLeft="";}else{a.style.marginLeft=s+"px";a.style.marginRight="";}var j=o.getDomRef("hsb-content");if(j){j.style.width=C+"px";}}if(!b&&this.isHorizontalScrollbarVisible()){$.removeClass("sapUiTableHScr");a.classList.add("sapUiTableHidden");if(D.browser.safari){$.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width","");}}};h.prototype.updateVerticalScrollbarHeight=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v){return;}var n=this.getVerticalScrollbarHeight();v.style.maxHeight=n+"px";if(this._iVerticalScrollbarHeight!==n){this._iVerticalScrollbarHeight=n;this.updateVerticalScrollPosition();}};h.prototype.getVerticalScrollbarHeight=function(){var t=this.getTable();if(!t){return 0;}var s=Math.max(1,t.getVisibleRowCount()-t.getFixedRowCount()-t.getFixedBottomRowCount());return s*t._getDefaultRowHeight();};h.prototype.updateVerticalScrollbarPosition=function(){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v){return;}var o=t.getDomRef("tableCCnt");if(o){var i=o.offsetTop;var a=t.getDomRef("vsb-bg");if(a){a.style.top=i+"px";}var F=t.getFixedRowCount();if(F>0){i+=t._iVsbTop;}v.style.top=i+"px";}};h.prototype.updateVerticalScrollPosition=function(n){var t=this.getTable();var v=this.getVerticalScrollbar();if(!t||!v||!this.isVerticalScrollbarRequired()){return;}var a=this._nVerticalScrollPosition;var N=0;var i=this.getVerticalScrollRange();if(n==null){var F=t.getFirstVisibleRow();var m=t._getMaxFirstRenderedRowIndex();if(F>m){this._nVerticalScrollPosition=this.getVerticalScrollRange();this._iFirstVisibleRowInBuffer=F-m;}else{this._nVerticalScrollPosition=F*this.getVerticalScrollRangeRowFraction();this._iFirstVisibleRowInBuffer=null;}}else{var b=0;var j=this.getVerticalScrollRange();this._nVerticalScrollPosition=Math.min(Math.max(b,n),j);this._iFirstVisibleRowInBuffer=null;}L.debug("sap.ui.table.TableScrollExtension","updateVerticalScrollPosition: From "+a+" to "+this._nVerticalScrollPosition+" (diff: "+(this._nVerticalScrollPosition-a)+")",t);if(this._nVerticalScrollPosition>0&&this._nVerticalScrollPosition<0.5){N=1;}else if(this._nVerticalScrollPosition>=i-0.5&&this._nVerticalScrollPosition<i){N=i-1;}else{N=Math.round(this._nVerticalScrollPosition);}if(v.scrollTop!==N){if(t._mAnimationFrames.verticalScrollUpdate){window.cancelAnimationFrame(t._mAnimationFrames.verticalScrollUpdate);}clearTimeout(t._mTimeouts.verticalScrollUpdate);delete t._mTimeouts.verticalScrollUpdate;L.debug("sap.ui.table.TableScrollExtension","updateVerticalScrollPosition: scrollTop will be set asynchronously",t);t._mAnimationFrames.verticalScrollUpdate=window.requestAnimationFrame(function(){var k=v.scrollTop;delete t._mAnimationFrames.verticalScrollUpdate;L.debug("sap.ui.table.TableScrollExtension","updateVerticalScrollPosition: (async) Set scrollTop from "+k+" to "+N,t);v.scrollTop=N;v._scrollTop=v.scrollTop;if(N===i&&N!==v.scrollTop){L.debug("updateVerticalScrollPosition: (async) Adjusted from "+this._nVerticalScrollPosition+" to "+v.scrollTop,t);this._nVerticalScrollPosition=v.scrollTop;}if(v.scrollTop===k){f.updateFirstVisibleRow(t);}}.bind(this));}else if(this._nVerticalScrollPosition!==a){if(t._mAnimationFrames.verticalScrollUpdate){window.cancelAnimationFrame(t._mAnimationFrames.verticalScrollUpdate);delete t._mAnimationFrames.verticalScrollUpdate;}clearTimeout(t._mTimeouts.verticalScrollUpdate);L.debug("sap.ui.table.TableScrollExtension","updateVerticalScrollPosition: firstVisibleRow will be set asynchronously",t);t._mTimeouts.verticalScrollUpdate=setTimeout(function(){delete t._mTimeouts.verticalScrollUpdate;f.updateFirstVisibleRow(t);},0);}else{L.debug("sap.ui.table.TableScrollExtension","updateVerticalScrollPosition: scrollTop and nVerticalScrollPosition not changed -> update inner vertical scroll position",t);this.updateInnerVerticalScrollPosition();}};h.prototype.updateVerticalScrollHeight=function(){var v=this.getVerticalScrollbar();var o=v?v.firstChild:null;if(!o){return;}var n=this.getVerticalScrollHeight(true);o.style.height=this.getVerticalScrollHeight()+"px";if(this._iVerticalScrollHeight!==n){this._iVerticalScrollHeight=n;this.updateVerticalScrollPosition();}};h.prototype.getVerticalScrollHeight=function(b){var t=this.getTable();if(!t){return 0;}var i=t._getTotalRowCount();var v=t.getVisibleRowCount();var a=t._getDefaultRowHeight();var r;var s;if(c.isVariableRowHeightEnabled(t)){r=Math.max(i,v+1);s=a*(r-1)+this.getVerticalScrollRangeBuffer();}else{r=Math.max(i,v);s=a*r;}if(b===true){return s;}else{return Math.min(M,s);}};h.prototype.updateVerticalScrollbarVisibility=function(){var t=this.getTable();var o=t?t.getDomRef():null;var v=this.getVerticalScrollbar();if(!o||!v){return;}var b=this.isVerticalScrollbarRequired();if(b&&!this.isVerticalScrollbarVisible()){if(!this.isVerticalScrollbarExternal()){o.classList.add("sapUiTableVScr");}v.classList.remove("sapUiTableHidden");}if(!b&&this.isVerticalScrollbarVisible()){o.classList.remove("sapUiTableVScr");v.classList.add("sapUiTableHidden");}};h.prototype.isVerticalScrollbarRequired=function(){var t=this.getTable();if(!t){return false;}return this.getInnerVerticalScrollRange()>0||(t._getTotalRowCount()>t.getVisibleRowCount());};h.prototype.getRowIndexAtCurrentScrollPosition=function(){var t=this.getTable();if(!t){return-1;}var m=t._getMaxFirstVisibleRowIndex();if(m===0){return 0;}else{var n=this.getVerticalScrollPosition();var s=this.getVerticalScrollRange();var a=this.getVerticalScrollRangeRowFraction();if(c.isVariableRowHeightEnabled(t)){if(this.isVerticalScrollPositionInBuffer()){return-1;}else{return Math.min(m,Math.floor(n/a));}}else{var r=Math.floor(n/a);var b=s-n;var i=this.getVerticalScrollbar(true)._scrollTop==null||this._bIsScrolledVerticallyByWheel;var j=b<1;if(j&&i){this._nVerticalScrollPosition=s;}return j&&i?m:Math.min(m,r);}}};h.prototype.getVerticalScrollRange=function(){var v=this.getVerticalScrollHeight()-this.getVerticalScrollbarHeight();return Math.max(0,v);};h.prototype.getVerticalScrollRangeBuffer=function(){var t=this.getTable();if(!c.isVariableRowHeightEnabled(t)){return 0;}return V*t._getDefaultRowHeight();};h.prototype.getVerticalScrollPosition=function(){if(this._nVerticalScrollPosition!=null){return this._nVerticalScrollPosition;}else if(this.isVerticalScrollbarVisible()){return this.getVerticalScrollbar().scrollTop;}else{return 0;}};h.prototype.getVerticalScrollRangeRowFraction=function(){var t=this.getTable();if(!t){return 0;}var v=t._getTotalRowCount()-t.getVisibleRowCount();var s;if(c.isVariableRowHeightEnabled(t)){s=this.getVerticalScrollRange()-this.getVerticalScrollRangeBuffer();var b=this.getVerticalScrollHeight()===M;if(!b){s+=t._getDefaultRowHeight();}}else{s=this.getVerticalScrollRange();}return s/Math.max(1,v);};h.prototype.updateInnerVerticalScrollPosition=function(){var t=this.getTable();var C=t?t.getDomRef("tableCCnt"):null;if(!c.isVariableRowHeightEnabled(t)||!C||f.isUpdatePending(t)){return;}var a=this.getInnerVerticalScrollRange();if(a===0){L.debug("sap.ui.table.TableScrollExtension","updateInnerVerticalScrollPosition: 0",t);t.setFirstVisibleRow(0,true);this._nVerticalScrollPosition=0;C.scrollTop=0;return;}if(t._getFirstRenderedRowIndex()!==t._iRenderedFirstVisibleRow){L.debug("sap.ui.table.TableScrollExtension","updateInnerVerticalScrollPosition: Skipped, because rows will be updated",t);return;}var F=t.getFirstVisibleRow();var n=this.getVerticalScrollPosition();var s=this.isVerticalScrollPositionInBuffer();var b=0;var j;var k;var m=null;var r=t._aRowHeights;if(!s){var o=this.getVerticalScrollRangeRowFraction();b=n-(F*o);j=r[0];k=Math.max(0,Math.min(b/o,1));m=Math.round(j*k);}else{var p=0;var u=0;var i;for(i=0;i<r.length&&u<a;i++){p++;u+=r[i];}var v=this.getVerticalScrollRange();var B=this.getVerticalScrollRangeBuffer();var w=B/p;if(this._iFirstVisibleRowInBuffer==null){b=n-v+B;var x=Math.min(Math.floor(b/w),p);j=r[x]||0;k=Math.max(0,Math.min((b-(w*x))/w,1));for(i=0;i<x;i++){m+=r[i];}m+=j*k;m=Math.min(m,a);var N=t._getMaxFirstRenderedRowIndex()+x;if(N!==F){L.debug("sap.ui.table.TableScrollExtension","updateInnerVerticalScrollPosition: Set firstVisibleRow from "+F+" to "+N,t);t.setFirstVisibleRow(N,true);}}else{var y=v-B;b=this._iFirstVisibleRowInBuffer*w;var z=y+b;k=0;L.debug("sap.ui.table.TableScrollExtension","updateInnerVerticalScrollPosition: Set scroll position to "+z,t);this.updateVerticalScrollPosition(z);return;}}L.debug("sap.ui.table.TableScrollExtension","updateInnerVerticalScrollPosition: "+m+" of "+j+" ("+(k*100)+"%)"+" (in buffer: "+s+")",t);C.scrollTop=m;};h.prototype.isVerticalScrollPositionInBuffer=function(){var t=this.getTable();if(!c.isVariableRowHeightEnabled(t)){return false;}return this.getVerticalScrollRange()-this.getVerticalScrollPosition()<=this.getVerticalScrollRangeBuffer();};h.prototype.getInnerVerticalScrollRange=function(){var t=this.getTable();if(!t||!t._aRowHeights){return 0;}var r=t._aRowHeights;var i=t._getDefaultRowHeight()*t.getVisibleRowCount();if(t.getVisibleRowCount()>=t._getTotalRowCount()){r=r.slice(0,t._getTotalRowCount());}var j=r.reduce(function(a,b){return a+b;},0)-i;if(j>0){j=Math.ceil(j);}return Math.max(0,j);};h.prototype.registerForMouseWheel=function(a,o){var t=this.getTable();if(T.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){return g.addMouseWheelEventListener(a,t,o);}else{L.error("This method can only be used with synchronization enabled.",t,"TableScrollExtension#registerForMouseWheel");return null;}};h.prototype.registerForTouch=function(a,o){var t=this.getTable();if(T.isEnrichedWith(t,"sap.ui.table.TableSyncExtension")){return g.addTouchEventListener(a,t,o);}else{L.error("This method can only be used with synchronization enabled.",t,"TableScrollExtension#registerForTouch");return null;}};h.prototype._clearCache=function(){this._oVerticalScrollbar=null;this._oHorizontalScrollbar=null;};h.ScrollDirection=d;return h;});
