/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(g){"use strict";var o;if(g.module){o=g.module;g.module=undefined;}sap.ui.define(['sap/ui/thirdparty/jquery','sap/ui/base/Object','sap/ui/core/mvc/View','sap/ui/test/matchers/Ancestor','sap/ui/test/matchers/MatcherFactory','sap/ui/test/pipelines/MatcherPipeline','sap/ui/test/_opaCorePlugin','sap/ui/test/_OpaLogger'],function($,U,V,A,M,a,_,b){var m=new M();var c=new a();var C=["id","viewName","controlType","searchOpenDialogs"];var O=U.extend("sap.ui.test.OpaPlugin",{constructor:function(){this._oLogger=b.getLogger("sap.ui.test.Opa5");},getAllControls:function(f,s){var d=_.getAllControls(f);this._oLogger.debug("Found "+d.length+" controls"+(f?" of type '"+(s||f)+"'":"")+" in page");return d;},getView:function(v){var d=this.getAllControls(V,"View");return d.filter(function(e){return e.getViewName()===v;})[0];},getControlInView:function(d){var s=(d.viewNamespace||"")+"."+(d.viewName||""),v=s.replace(/\.+/g,'.').replace(/^\.|\.$/g,""),e=this.getView(v),S=typeof d.id==="string";if(!e){this._oLogger.debug("Found no view with the name: '"+v+"'");return S?null:[];}if($.isArray(d.id)){var f=[];var u=[];$.each(d.id,function(I,n){var i=e.byId(n);if(i){f.push(i);}else{u.push(n);}});var h=u.length?". Found no controls matching the subset of IDs "+u:"";this._oLogger.debug("Found "+f.length+" controls with ID contained in "+d.id+" in view '"+v+"'"+h);return f;}if(S){var i=e.byId(d.id)||null;this._oLogger.debug("Found "+(i?"":"no ")+"control with ID '"+d.id+"' in view '"+v+"'");return i;}var j=this.getAllControlsWithTheParent(e,d.controlType,d.sOriginalControlType);var k=$.type(d.id)==="regexp";if(k){var l=e.getId();j=j.filter(function(i){var n=i.getId().replace(l,"");return d.id.test(n);});}this._oLogger.debug("Found "+j.length+" controls of type "+d.sOriginalControlType+(k?" with ID matching "+d.id:"")+" in view '"+v+"'");return j;},getAllControlsWithTheParent:function(p,f,s){var d=new A(p);return this._filterUniqueControlsByCondition(this.getAllControls(f,s),d);},getAllControlsInContainer:function(d,f,s,e){var h=this._filterUniqueControlsByCondition(d.find("*").control(),function(i){return _.checkControlType(i,f);});this._oLogger.debug("Found "+h.length+" controls in "+(e?e:"container")+" with controlType '"+s+"'");return h;},getMatchingControls:function(d){var r=null;d=d||{};var h=this._modifyControlType(d);if(!h){return typeof d.id==="string"?r:[];}if(d.searchOpenDialogs){r=this.getAllControlsInContainer($("#sap-ui-static"),d.controlType,d.sOriginalControlType,"the static UI area");}else if(d.viewName){r=this.getControlInView(d);}else if(d.id){r=this.getControlByGlobalId(d);}else if(d.controlType){r=this.getAllControls(d.controlType,d.sOriginalControlType);}else{r=this.getAllControls();}if(!r||d.visible===false){return r;}var i=m.getInteractabilityMatchers(d.interactable);var p=c.process({control:r,matchers:i});if(!p){if($.isArray(r)){return[];}if(r){return null;}return r;}return p;},_getFilteredControls:function(d){var v=this._filterControlsByCondition(d);return v===O.FILTER_FOUND_NO_CONTROLS?O.FILTER_FOUND_NO_CONTROLS:this._filterControlsByMatchers(d,v);},_getFilteredControlsByDeclaration:function(d){var v=this._filterControlsByCondition(d);var e=$.extend({},d,{useDeclarativeMatchers:true});return v===O.FILTER_FOUND_NO_CONTROLS?O.FILTER_FOUND_NO_CONTROLS:this._filterControlsByMatchers(e,v);},_filterControlsByCondition:function(d){var v=null;var p=this._isLookingForAControl(d);if(p){v=this.getMatchingControls(d);}var e=[typeof d.id==="string"&&!v,!d.id&&(d.viewName||d.searchOpenDialogs)&&!v.length,$.type(d.id)==="regexp"&&!v.length,$.isArray(d.id)&&(!v||v.length!==d.id.length),d.controlType&&$.isArray(v)&&!v.length];return e.some(Boolean)?O.FILTER_FOUND_NO_CONTROLS:v;},_filterControlsByMatchers:function(d,v){var e=d.useDeclarativeMatchers?m.getFilteringMatchers(d):d.matchers;var p=this._isLookingForAControl(d);var r=null;if((v||!p)&&e){r=c.process({matchers:e,control:v});if(!r){return O.FILTER_FOUND_NO_CONTROLS;}}else{r=v;}return r;},getControlByGlobalId:function(d){var e=_.getCoreElements();if(typeof d.id==="string"){var f=e[d.id]||null;if(f&&!_.checkControlType(f,d.controlType)){this._oLogger.error("A control with global ID '"+d.id+"' is found but does not have required controlType '"+d.sOriginalControlType+"'. Found control is '"+f+"' but null is returned instead");return null;}this._oLogger.debug("Found "+(f?"":"no ")+"control with the global ID '"+d.id+"'");return f;}var h=[];var i=$.type(d.id)==="regexp";if(i){for(var p in e){if(!e.hasOwnProperty(p)||!d.id.test(p)){continue;}h.push(p);}}else if($.isArray(d.id)){h=d.id;}var j=[];var u=[];h.forEach(function(I){var f=e[I];if(f&&_.checkControlType(f,d.controlType)&&!f.bIsDestroyed){j.push(f);}else{u.push(I);}});var s=!i&&u.length?". Found no controls of matching the subset of IDs "+u:"";this._oLogger.debug("Found "+j.length+" controls of type "+d.sOriginalControlType+(i?" with ID matching '":" with ID contained in '")+d.id+s);return j;},getControlConstructor:function(s){if(sap.ui.lazyRequire._isStub(s)){this._oLogger.debug("The control type "+s+" is currently a lazy stub.");return null;}var f=$.sap.getObject(s);if(!f){this._oLogger.debug("The control type "+s+" is undefined.");return null;}return f;},_isLookingForAControl:function(d){return Object.keys(d).some(function(k){return C.indexOf(k)!==-1&&!!d[k];});},_filterUniqueControlsByCondition:function(d,f){return d.filter(function(e,p,h){var k=!!f(e);return k&&h.indexOf(e)===p;});},_modifyControlType:function(d){var v=d.controlType;if(typeof v!=="string"){if(v&&v._sapUiLazyLoader){this._oLogger.debug("The control type is currently a lazy stub");return false;}return true;}var f=this.getControlConstructor(v);if(!f){return false;}d.sOriginalControlType=v;d.controlType=f;return true;}});O.FILTER_FOUND_NO_CONTROLS="FILTER_FOUND_NO_CONTROL";return O;});if(o){g.module=o;}})(window);
