/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/DateRange','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/CalendarDate','./library','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRenderer","sap/ui/dom/containsOrEquals","sap/base/util/deepEqual","sap/base/Log","sap/ui/thirdparty/jquery"],function(C,L,a,D,H,M,b,Y,c,l,d,e,R,f,g,h,j,k,q){"use strict";var s=sap.ui.getCore().getConfiguration().getLocale().getLanguage();var m=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},secondMonthHeader:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{},weekNumberSelect:{allowPreventDefault:true,parameters:{weekNumber:{type:"int"},weekDays:{type:"sap.ui.unified.DateRange"}}}}}});m.prototype.init=function(){this._iBreakPointTablet=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=d.media._predefinedRangeSets[d.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._iColumns=1;this._oYearFormat=e.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());this._initializeHeader();this._initializeSecondMonthHeader();var y=this._createMonth(this.getId()+"--Month0");y.attachEvent("focus",this._handleFocus,this);y.attachEvent("select",t,this);y.attachEvent("_renderMonth",r,this);y.attachEvent("_bindMousemove",u,this);y.attachEvent("_unbindMousemove",v,this);y._bNoThemeChange=true;this.addAggregation("month",y);this._initilizeMonthPicker();this._initilizeYearPicker();this._resizeProxy=q.proxy(w,this);this._oSelectedMonth;};m.prototype.exit=function(){if(this._sInvalidateMonth){clearTimeout(this._sInvalidateMonth);}if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}this._oSelectedMonth=null;};m.prototype._initializeHeader=function(){var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",this._handleButton1,this);i.attachEvent("pressButton2",this._handleButton2,this);i.attachEvent("pressButton3",this._handleButton1,this);i.attachEvent("pressButton4",this._handleButton2,this);this.setAggregation("header",i);};m.prototype._initializeSecondMonthHeader=function(){var S=new H(this.getId()+"--SecondMonthHead");S.addStyleClass("sapUiCalHeadSecondMonth");S.attachEvent("pressPrevious",this._handlePrevious,this);S.attachEvent("pressNext",this._handleNext,this);S.attachEvent("pressButton1",this._handleButton1,this);S.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("secondMonthHeader",S);};m.prototype._initilizeMonthPicker=function(){var i=new b(this.getId()+"--MP");i.attachEvent("select",this._selectMonth,this);i._bNoThemeChange=true;this.setAggregation("monthPicker",i);};m.prototype._initilizeYearPicker=function(){var y=new Y(this.getId()+"--YP");y.attachEvent("select",this._selectYear,this);this.setAggregation("yearPicker",y);};m.prototype._createMonth=function(i){var y=new M(i,{width:"100%"});y.attachEvent("datehovered",this._handleDateHovered,this);y.attachEvent("weekNumberSelect",this._handleWeekNumberSelect,this);return y;};m.prototype._handleWeekNumberSelect=function(E){var i=this.fireWeekNumberSelect({weekNumber:E.getParameter("weekNumber"),weekDays:E.getParameter("weekDays")});if(!i){E.preventDefault();}return this;};m.prototype._handleDateHovered=function(E){var y=this.getAggregation("month"),z=E.getParameter("date1"),A=E.getParameter("date2"),i;for(i=0;i<y.length;i++){y[i]._markDatesBetweenStartAndHoveredDate(z,A);}};m.prototype.onBeforeRendering=function(){var y=this.getAggregation("month");var z;var A=y[0].getDate();var F=this._getFocusedDate();if(y.length>1&&A){z=c.fromLocalJSDate(A,this.getPrimaryCalendarType());}else if(y.length>1){z=x.call(this,this._getFocusedDate());}else{z=F;}for(var i=0;i<y.length;i++){A=new c(z);if(i>0){A.setDate(1);A.setMonth(A.getMonth()+i);}var B=A;if(F.getYear()===A.getYear()&&F.getMonth()===A.getMonth()){B=F;}y[i].displayDate(B.toLocalJSDate());y[i].setShowWeekNumbers(this.getShowWeekNumbers());}this._updateHeader(z);this._iSize=0;};m.prototype.onAfterRendering=function(E){if(!this._getSucessorsPickerPopup()){n.call(this);}if(p.call(this)>1||this._bInitMonth){E.size={width:this.getDomRef().offsetWidth};w.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};m.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof D))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=setTimeout(this._invalidateMonth.bind(this,O),0);}};m.prototype.removeSelectedDate=function(S){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",S);};m.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("selectedDates");return i;};m.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};m.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("specialDates");return i;};m.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};m.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};m.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("disabledDates");return i;};m.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};m.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};m.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};m.prototype._getFocusedDate=function(){if(!this._oFocusedDate){_.call(this);}return this._oFocusedDate;};m.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new c(i,this.getPrimaryCalendarType());};m.prototype.focusDate=function(i){o.call(this,i,false);return this;};m.prototype.displayDate=function(i){o.call(this,i,true);return this;};m.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=c.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new c(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};m.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};m.prototype.setMonths=function(y){this._bDateRangeChanged=undefined;this.setProperty("months",y,false);y=p.call(this);var z=this.getAggregation("month");var i=0;var A;if(z.length<y){for(i=z.length;i<y;i++){A=this._createMonth(this.getId()+"--Month"+i);A.attachEvent("focus",this._handleFocus,this);A.attachEvent("select",t,this);A.attachEvent("_renderMonth",r,this);A.attachEvent("_bindMousemove",u,this);A.attachEvent("_unbindMousemove",v,this);A._bNoThemeChange=true;this.addAggregation("month",A);}}else if(z.length>y){for(i=z.length;i>y;i--){A=this.removeAggregation("month",i-1);A.destroy();}if(y==1){this._bInitMonth=true;}}if(y>1&&z[0].getDate()){z[0].setProperty("date",null,true);}return this;};m.prototype.setPrimaryCalendarType=function(y){var z=this.getAggregation("month");var A=false;if(z.length>1){A=true;}this.setProperty("primaryCalendarType",y,!A);this._oYearFormat=e.getDateInstance({format:"y",calendarType:y});if(this._oFocusedDate){this._oFocusedDate=new c(this._oFocusedDate,y);}this._oMinDate=new c(this._oMinDate,y);this._oMaxDate=new c(this._oMaxDate,y);for(var i=0;i<z.length;i++){var B=z[i];B.setPrimaryCalendarType(y);}if(!this._getSucessorsPickerPopup()){var E=this.getAggregation("monthPicker");E.setPrimaryCalendarType(y);var F=this.getAggregation("yearPicker");F.setPrimaryCalendarType(y);}if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(!this._getSucessorsPickerPopup()){if(this.iMode!=1&&E.getDomRef()){E.$().remove();}if(this.iMode!=2&&F.getDomRef()){F.$().remove();}}}return this;};m.prototype.setSecondaryCalendarType=function(y){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",y,true);this._oYearFormatSecondary=e.getDateInstance({format:"y",calendarType:y});var z=this.getAggregation("month");for(var i=0;i<z.length;i++){var A=z[i];A.setSecondaryCalendarType(y);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};m.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};m.prototype.setMinDate=function(i){if(j(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=this._oMinDate.getYear();a._checkYearInValidRange(y);if(this._oMaxDate.isBefore(this._oMinDate)){k.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("minDate",i,false);if(!this._getSucessorsPickerPopup()){var z=this.getAggregation("yearPicker");z._oMinDate.setYear(this._oMinDate.getYear());}return this;};m.prototype.setMaxDate=function(i){if(j(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=this._oMaxDate.getYear();a._checkYearInValidRange(y);if(this._oMinDate.isAfter(this._oMaxDate)){k.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("maxDate",i,false);if(!this._getSucessorsPickerPopup()){var z=this.getAggregation("yearPicker");z._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};m.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){k.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};m.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var y=new f(i);this._oLocaleData=L.getInstance(y);}return this._oLocaleData;};m.prototype._getShowMonthHeader=function(){var i=p.call(this);if(i>2){return true;}else{return false;}};m.prototype.setWidth=function(W){this.setProperty("width",W,true);if(this.getDomRef()){W=this.getWidth();this.$().css("width",W);if(W){this.$().addClass("sapUiCalWidth");}else{this.$().removeClass("sapUiCalWidth");}}return this;};m.prototype.onclick=function(E){var i=E.target;if(E.isMarked("delayedMouseEvent")){return;}if(i.id==this.getId()+"-cancel"){this.onsapescape(E);}};m.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};m.prototype.onsapescape=function(E){if(this._iMode==0){this.fireCancel();}this._closedPickers();};m.prototype.onsapshow=function(E){if(this._bPoupupMode){this._closedPickers();this.fireCancel();E.preventDefault();}};m.prototype.onsaphide=m.prototype.onsapshow;m.prototype.onsaptabnext=function(E){var y=this.getAggregation("header");if(h(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabNext(E)){var z=y.getDomRef("B2");if(z){z.focus();}}else{var A=y.getDomRef("B1");if(A){A.focus();}}if(!this._bPoupupMode){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var F=B[i];q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var G=this.getAggregation("monthPicker");var I=this.getAggregation("yearPicker");if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(I.getDomRef()){q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}E.preventDefault();}else if(this._shouldFocusB2OnTabNext(E)){var z=y.getDomRef("B2");if(z){z.focus();}E.preventDefault();}};m.prototype._shouldFocusB2OnTabNext=function(E){var i=this.getAggregation("header");return(E.target.id==i.getId()+"-B1");};m.prototype._shouldFocusB2OnTabPrevious=function(E){return this._bPoupupMode;};m.prototype.onsaptabprevious=function(E){var y=this.getAggregation("header");if(h(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabPrevious()){var z=y.getDomRef("B2");if(z){z.focus();}E.preventDefault();}}else if(E.target.id==y.getId()+"-B1"){var A=this.getAggregation("month");var F;switch(this._iMode){case 0:F=this._getFocusedDate();for(var i=0;i<A.length;i++){var B=A[i];var G=c.fromLocalJSDate(B.getDate(),this.getPrimaryCalendarType());if(F.isSame(G)){B._oItemNavigation.focusItem(B._oItemNavigation.getFocusedIndex());}else{q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){var I=this.getAggregation("monthPicker");I._oItemNavigation.focusItem(I._oItemNavigation.getFocusedIndex());}break;case 2:if(!this._getSucessorsPickerPopup()){var J=this.getAggregation("yearPicker");J._oItemNavigation.focusItem(J._oItemNavigation.getFocusedIndex());}break;}E.preventDefault();}else if(E.target.id==y.getId()+"-B2"){var K=y.getDomRef("B1");if(K){K.focus();}E.preventDefault();}};m.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var y=this.getAggregation("month");this._focusOnShiftTab();if(!this._bPoupupMode){for(var i=0;i<y.length;i++){var z=y[i];q(z._oItemNavigation.getItemDomRefs()[z._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var A=this.getAggregation("monthPicker");var B=this.getAggregation("yearPicker");if(A.getDomRef()){q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(B.getDomRef()){q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};m.prototype._focusOnShiftTab=function(){var i=this.getAggregation("header");var y=i.getDomRef("B2");if(y){y.focus();}};m.prototype.onsapfocusleave=function(E){var y,z,A,B;if(!E.relatedControlId||!h(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){y=this.getAggregation("month");switch(this._iMode){case 0:for(var i=0;i<y.length;i++){z=y[i];q(z._oItemNavigation.getItemDomRefs()[z._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:if(!this._getSucessorsPickerPopup()){A=this.getAggregation("monthPicker");q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 2:if(!this._getSucessorsPickerPopup()){B=this.getAggregation("yearPicker");q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};m.prototype.getFocusDomRef=function(){var i=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0];return i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()];};m.prototype.onThemeChanged=function(){var y;if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){y=this.getAggregation("monthPicker");this._showMonthPicker(true);y._bNoThemeChange=false;y.onThemeChanged(arguments);y._bNoThemeChange=true;this._bLongMonth=y._bLongMonth;this._hideMonthPicker(true);}var z=this.getAggregation("month");for(var i=0;i<z.length;i++){var A=z[i];A._bNoThemeChange=false;A.onThemeChanged(arguments);A._bNoThemeChange=true;}var B;if(z.length>1){B=c.fromLocalJSDate(z[0].getDate(),this.getPrimaryCalendarType());}else{B=this._getFocusedDate();}this._setHeaderText(B);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!this._getSucessorsPickerPopup()){n.call(this);}};m.prototype._updateHeader=function(i){this._setHeaderText(i);this._togglePrevNext(i,true);};m.prototype._togglePrevNext=function(i,y){var z=this._oMaxDate.getYear();var A=this._oMinDate.getYear();var B=this._oMaxDate.getMonth();var E=this._oMinDate.getMonth();var F=this.getAggregation("header");var G=p.call(this);var I=new c(i,this.getPrimaryCalendarType());if(this._iMode==0&&G>1){I=x.call(this,i);I.setMonth(I.getMonth()+G-1);I.setDate(a._daysInMonth(I));}else{I.setDate(a._daysInMonth(I));}var J=I.getYear();var K=I.getMonth();if(J>z||(J==z&&(!y||K>=B))||(this._iMode==1&&this._getSucessorsPickerPopup())){F.setEnabledNext(false);}else{F.setEnabledNext(true);}if(this._iMode==0&&G>1){I.setMonth(I.getMonth()-G+1);I.setDate(1);}else{I.setDate(1);}J=I.getYear();K=I.getMonth();if(J<A||(J==A&&(!y||K<=E))||(this._iMode==1&&this._getSucessorsPickerPopup())){F.setEnabledPrevious(false);}else{F.setEnabledPrevious(true);}};m.prototype._togglePrevNexYearPicker=function(){var y=this.getAggregation("yearPicker");var i=y.getYears();var z=c.fromLocalJSDate(y.getFirstRenderedDate());z.setYear(z.getYear()+Math.floor(i/2));var A=this.getAggregation("header");var B=new c(this._oMaxDate,this.getPrimaryCalendarType());B.setYear(B.getYear()-Math.ceil(i/2));B.setMonth(11);B.setDate(31);var E=new c(this._oMinDate,this.getPrimaryCalendarType());E.setYear(E.getYear()+Math.floor(i/2)+1);E.setMonth(0);E.setDate(1);A.setEnabledNext(z.isSameOrBefore(B));A.setEnabledPrevious(z.isSameOrAfter(E));};m.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var y=this.getAggregation("yearPicker");var i=p.call(this);var z;var A;var S=false;switch(this._iMode){case 0:if(i>1){z=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());z.setDate(1);this._setFocusedDate(z);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);this._renderMonth(S,true);break;case 1:F.setYear(F.getYear()-1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var B=this._getSecondaryCalendarType();if(B){A=new c(F,B);A.setMonth(0);A.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(A.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:y.previousPage();this._togglePrevNexYearPicker();break;}};m.prototype._handleNext=function(E){var F=this._getFocusedDate();var y=this.getAggregation("yearPicker");var i=p.call(this);var z;var A;switch(this._iMode){case 0:if(i>1){z=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());this._setFocusedDate(z);F=this._getFocusedDate();}F.setDate(1);F.setMonth(F.getMonth()+i);this._renderMonth();break;case 1:F.setYear(F.getYear()+1);this._updateHeadersYearPrimaryText(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){A=new c(F,S);A.setMonth(0);A.setDate(1);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(A.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:y.nextPage();this._togglePrevNexYearPicker();break;}};m.prototype._getDisplayedMonths=function(y){var z=[];var A=y.getMonth();var B=p.call(this);if(B>1){for(var i=0;i<B;i++){z.push((A+i)%12);}}else{z.push(A);}return z;};m.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=c.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new c(F,S);var y=F.getMonth();var z=c.fromLocalJSDate(i[i.length-1].getDate(),P);z.setDate(a._daysInMonth(z));z=new c(z,S);var E=z.getMonth();return{start:y,end:E};};m.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:this._hideMonthPicker();break;case 2:this._hideYearPicker();break;}};m.prototype._setDisabledMonths=function(y,i){var z=0;var A=11;if(y==this._oMinDate.getYear()){z=this._oMinDate.getMonth();}if(y==this._oMaxDate.getYear()){A=this._oMaxDate.getMonth();}if(!i){i=this.getAggregation("monthPicker");}i.setMinMax(z,A);};m.prototype._handleFocus=function(E){var i=c.fromLocalJSDate(E.getParameter("date"),this.getPrimaryCalendarType());var O=E.getParameter("otherMonth");var y=E.getParameter("restoreOldDate");if(y){if(!j(this._getFocusedDate(),i)){this._renderMonth(false,false,true);}}else{this._focusDate(i,O);}};m.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};m.prototype._renderMonth=function(S,I,N){var y=this._getFocusedDate();var z=this.getAggregation("month");var F=false;var A;var B;var E;var i=0;for(i=0;i<z.length;i++){A=z[i];if(A.checkDateFocusable(y.toLocalJSDate())){F=true;}if(F||z.length==1){if(!S){A.setDate(y.toLocalJSDate());}else{A.displayDate(y.toLocalJSDate());}break;}}if(!F){E=new c(y,this.getPrimaryCalendarType());if(z.length>1){E=x.call(this,E);for(i=0;i<z.length;i++){A=z[i];B=new c(E,this.getPrimaryCalendarType());B.setMonth(E.getMonth()+i);if(!S&&a._isSameMonthAndYear(B,y)){A.setDate(y.toLocalJSDate());}else{A.displayDate(B.toLocalJSDate());}}}this._updateHeader(E);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();if(!N){this.fireStartDateChange();}}};function _(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=c.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate,i);}}m.prototype._showMonthPicker=function(S){if(this._iMode==2){this._hideYearPicker(true);}var y=this._getFocusedDate();var z=this.getAggregation("monthPicker");if(z.getDomRef()){z.$().css("display","");}else{var A=sap.ui.getCore().createRenderManager();var $=this.$("content");A.renderControl(z);A.flush($[0],false,true);A.destroy();}this._showOverlay();if(!S){z.setMonth(y.getMonth());this._setDisabledMonths(y.getYear(),z);if(this._iMode==0){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;this._togglePrevNext(y,false);};m.prototype._hideMonthPicker=function(S){this._iMode=0;var y=this.getAggregation("monthPicker");y.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(p.call(this)>1){var z=this.getAggregation("month");for(var i=0;i<z.length;i++){var A=z[i];q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};m.prototype._showYearPicker=function(){if(this._iMode==1){this._hideMonthPicker(true);}var y=this._getFocusedDate();var z=this.getAggregation("yearPicker");if(z.getDomRef()){z.$().css("display","");}else{var A=sap.ui.getCore().createRenderManager();var $=this.$("content");A.renderControl(z);A.flush($[0],false,true);A.destroy();}this._showOverlay();z.setDate(y.toLocalJSDate());var B;if(p.call(this)==1){B=this.getAggregation("month")[0];var E=B.$("days").find(".sapUiCalItem");if(E.length==28){z.$().addClass("sapUiCalYearNoTop");}else{z.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){var F=this.getAggregation("month");for(var i=0;i<F.length;i++){B=F[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._togglePrevNexYearPicker();this._iMode=2;};m.prototype._hideYearPicker=function(S){this._iMode=0;var y=this.getAggregation("yearPicker");y.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(p.call(this)>1){var z=this.getAggregation("month");for(var i=0;i<z.length;i++){var A=z[i];q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};function n(){if(!this._bNamesLengthChecked){this._showMonthPicker(true);this._hideMonthPicker(true);var i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){var y=this.getAggregation("month");var z;if(y.length>1){z=c.fromLocalJSDate(y[0].getDate(),this.getPrimaryCalendarType());}else{z=this._getFocusedDate();}this._setHeaderText(z);this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}}else if(p.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}m.prototype._focusDate=function(i,O,N){var F;var y=false;var z=false;if(i.isBefore(this._oMinDate)){F=this._oMinDate;y=true;}else if(i.isAfter(this._oMaxDate)){F=this._oMaxDate;y=true;}else{F=i;}if(this._focusDateExtend){z=this._focusDateExtend(i,O,N);}var I=F.isBefore(this._getFocusedDate());this._setFocusedDate(F);if(y||O){this._renderMonth(false,I,N);}if(z){this.fireStartDateChange();}};m.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var y=this.getAggregation("month");if(y){for(var i=0;i<y.length;i++){var z=y[i];z._bDateRangeChanged=true;z._bInvalidateSync=true;z._bNoFocus=true;z.invalidate(O);z._bInvalidateSync=undefined;}}this._bDateRangeChanged=undefined;};m.prototype._setHeaderText=function(i){var y=this.getAggregation("header");var S=this.getAggregation("secondMonthHeader");var z=this._getLocaleData();var A=[];var B=[];var E=[];var F;var G=false;var I;var J;var T;var K;var P;var N=this.getPrimaryCalendarType();var O=this._getSecondaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){A=z.getMonthsStandAlone("wide",N);}else{G=true;A=z.getMonthsStandAlone("abbreviated",N);B=z.getMonthsStandAlone("wide",N);}if(O){E=z.getMonthsStandAlone("abbreviated",O);var Q=this._getDisplayedSecondaryMonths(N,O);if(Q.start==Q.end){T=E[Q.start];}else{P=z.getIntervalPattern();T=P.replace(/\{0\}/,E[Q.start]).replace(/\{1\}/,E[Q.end]);}}y.setAdditionalTextButton1(T);y._setAdditionalTextButton3(T);S.setAdditionalTextButton1(T);var U=this._getDisplayedMonths(i);this._sFirstMonthName=I=A[U[0]];J=A[U[U.length-1]];if(U.length>1&&!this._bShowOneMonth){if(!P){P=z.getIntervalPattern();}T=P.replace(/\{0\}/,I).replace(/\{1\}/,J);F=B.length?P.replace(/\{0\}/,B[U[0]]).replace(/\{1\}/,B[U[U.length-1]]):T;}else{T=I;F=B[U[0]]||T;}y.setTextButton1(T);y.setAriaLabelButton1(F);y._setTextButton3(J);y._setAriaLabelButton3(J);S.setTextButton1(J);S.setAriaLabelButton1(J);var V=new c(i,N);V.setDate(1);K=this._oYearFormat.format(V.toUTCJSDate(),true);this._updateHeadersYearPrimaryText(K);if(O){V=new c(V,O);this._updateHeadersYearAdditionalText(this._oYearFormatSecondary.format(V.toUTCJSDate(),true));}else{this._updateHeadersYearAdditionalText();}return{sMonth:T,sYear:K,sAriaLabel:F,bShort:G};};function o(i,S){if(!i){return;}var y=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var z=y.getYear();a._checkYearInValidRange(z);if(a._isOutside(y,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(y);if(this.getDomRef()&&this._iMode==0){this._renderMonth(S,false,true);}}function p(){if(d.system.phone){return 1;}else{return this.getMonths();}}m.prototype._handleButton1=function(E){if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}};m.prototype._handleButton2=function(E){if(this._iMode!=2){this._showYearPicker();}else{this._hideYearPicker();}};function r(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}function t(E){if(p.call(this)>1){var y=this.getAggregation("month");for(var i=0;i<y.length;i++){var z=y[i];if(z.getId()!=E.oSource.getId()){z._updateSelection();}}}this._oSelectedMonth=E.oSource;this.fireSelect();}function u(E){if(p.call(this)>1){var y=this.getAggregation("month");for(var i=0;i<y.length;i++){var z=y[i];if(z.getId()!=E.oSource.getId()){z._bindMousemove();}}}}function v(E){if(p.call(this)>1){var y=this.getAggregation("month");for(var i=0;i<y.length;i++){var z=y[i];if(z.getId()!=E.oSource.getId()){z._unbindMousemove();}}}}m.prototype._selectMonth=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this.getAggregation("monthPicker"),y=i.getMonth();F.setMonth(y);if(y!=F.getMonth()){F.setDate(0);}this._focusDate(F,true);this._hideMonthPicker();};m.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup();};m.prototype._selectYear=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType());var y=this.getAggregation("yearPicker");var i=c.fromLocalJSDate(y.getDate(),this.getPrimaryCalendarType());i.setMonth(F.getMonth());i.setDate(F.getDate());F=i;this._focusDate(F,true);this._hideYearPicker();};m.prototype._showOverlay=function(){this.$("contentOver").css("display","");};m.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};m.prototype._setColumns=function(i){this._iColumns=i;return this;};m.prototype._getColumns=function(){return this._iColumns;};m.prototype._updateHeadersButtons=function(){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");if(this._isTwoMonthsInOneColumn()){S.setVisible(true);i._setVisibleButton3(false);i._setVisibleButton4(false);}else if(this._isTwoMonthsInTwoColumns()){S.setVisible(false);i._setVisibleButton3(true);i._setVisibleButton4(true);}else{S.setVisible(false);i._setVisibleButton3(false);i._setVisibleButton4(false);}};m.prototype._setPrimaryHeaderMonthButtonText=function(){var i=this.getAggregation("header");if(this._isTwoMonthsInOneColumn()||this._isTwoMonthsInTwoColumns()){i.setTextButton1(this._sFirstMonthName);}};m.prototype._toggleTwoMonthsInTwoColumnsCSS=function(){if(this._isTwoMonthsInTwoColumns()){if(s.toLowerCase()==="ja"||s.toLowerCase()==="zh"){this.addStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");}else{this.addStyleClass("sapUiCalTwoMonthsTwoColumns");}}else{if(s.toLowerCase()==="ja"||s.toLowerCase()==="zh"){this.removeStyleClass("sapUiCalTwoMonthsTwoColumnsJaZh");}else{this.removeStyleClass("sapUiCalTwoMonthsTwoColumns");}}};m.prototype._isTwoMonthsInOneColumn=function(){var i=p.call(this);return this._getColumns()===1&&i===2;};m.prototype._isTwoMonthsInTwoColumns=function(){var i=p.call(this);return this._getColumns()===2&&i===2;};m.prototype._updateHeadersYearPrimaryText=function(y){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");i.setTextButton2(y);i.setAriaLabelButton2(y);i._setTextButton4(y);i._setAriaLabelButton4(y);S.setTextButton2(y);S.setAriaLabelButton2(y);};m.prototype._updateHeadersYearAdditionalText=function(y){var i=this.getAggregation("header"),S=this.getAggregation("secondMonthHeader");i.setAdditionalTextButton2(y);i._setAdditionalTextButton4(y);S.setAdditionalTextButton2(y);};function w(E){var W=E.size.width;if(W<=0){return;}var O=this._iSize;if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else if(W<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var y=p.call(this);if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:this._setColumns(2);break;case 2:this._setColumns(3);break;case 3:this._setColumns(4);break;default:this._setColumns(1);break;}if(y<this._getColumns()){this._setColumns(y);}if(this._getColumns()>2&&y>this._getColumns()){var z=this._getColumns();var U=0.0;var A=this._getColumns();while(z>=2){var B=y%z;if(B==0){A=z;break;}else{var N=B/z;if(N>U){U=N;A=z;}}z--;}this._setColumns(A);}var F;var G=this.getAggregation("month");if(this._getColumns()>1){F=100/this._getColumns()+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{F="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<G.length;i++){var I=G[i];I.setWidth(F);}}this._updateHeadersButtons();this._setPrimaryHeaderMonthButtonText();this._toggleTwoMonthsInTwoColumnsCSS();}function x(i){var F=new c(i,this.getPrimaryCalendarType());F.setDate(1);var y=p.call(this);if(y<=12){var z=i.getMonth();z=z-z%y;if(12%y>0&&z+y>11){z=12-y;}F.setMonth(z);}return F;}return m;});
