/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Popup','sap/ui/core/theming/Parameters','sap/ui/core/RenderManager','./library',"./ToolPopupRenderer"],function(q,C,I,P,a,R,l,T){"use strict";var b=C.extend("sap.ui.ux3.ToolPopup",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconHover:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconSelected:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},modal:{type:"boolean",group:"Behavior",defaultValue:false},inverted:{type:"boolean",group:"Misc",defaultValue:true},autoClose:{type:"boolean",group:"Misc",defaultValue:false},maxHeight:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},openDuration:{type:"int",group:"Misc",defaultValue:400},closeDuration:{type:"int",group:"Misc",defaultValue:400}},defaultAggregation:"content",aggregations:{buttons:{type:"sap.ui.core.Control",multiple:true,singularName:"button"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{initialFocus:{type:"sap.ui.core.Control",multiple:false},opener:{type:"sap.ui.core.Control",multiple:false},defaultButton:{type:"sap.ui.core.Control",multiple:false}},events:{open:{},close:{allowPreventDefault:true},enter:{parameters:{originalEvent:{type:"object"},originalSrcControl:{type:"sap.ui.core.Control"}}},iconChanged:{},closed:{},opened:{}}}});b.ARROW_LEFT=new RegExp(/my:(left|begin)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(right|end)\|[a-z]+/);b.ARROW_RIGHT=new RegExp(/my:(right|end)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(left|begin)\|[a-z]+/);b.ARROW_UP=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|top([-+]\d*\%?)? at:[a-z]+\|bottom/);b.ARROW_DOWN=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|bottom([-+]\d*\%?)? at:[a-z]+\|top/);(function(){b.prototype.init=function(){this.oPopup=null;this._bPositionSet=false;this._mParameters={};this._mParameters.that=this;this._mParameters.firstFocusable=this.getId()+"-firstFocusable";this._mParameters.lastFocusable=this.getId()+"-lastFocusable";this._bFocusSet=false;this._proxyOpened=q.proxy(p,this);this._proxyClosed=q.proxy(o,this);this._proxyFixSize=q.proxy(f,this);this._proxyOnResize=q.proxy(O,this);s(this);};b.prototype.exit=function(){if(this.oPopup){this.oPopup.detachOpened(this._proxyOpened);this.oPopup.detachClosed(this._proxyClosed);this.oPopup.destroy();delete this.oPopup;}delete this._bPositionSet;delete this._mParameters;delete this._bFocusSet;delete this._bPreventRestoreFocus;delete this._proxyOpened;delete this._proxyClosed;delete this._bRTL;delete this._sArrowDir;delete this._oArrowIcon;delete this._bThemeInverted;delete this._sInitialFocusId;};var _=function(i){var t=i;if(!t._bFocusSet){c(t);}else{t._sInitialFocusId=t.oPopup._sInitialFocusId;}return t._sInitialFocusId;};var c=function(k){var E;var F;var t=k;var m=[t._mParameters.firstFocusable,t._mParameters.lastFocusable];var n=q(":sapTabbable",t.$()).get();for(var i=0;i<n.length;i++){if(m.indexOf(n[i].id)===-1){E=n[i];break;}}F=q(E).control();if(F[0]){var v=F[0].getFocusDomRef();E=v||E;}else{E=q.sap.domById(m[0]);}if(E){q.sap.focus(E);t._sInitialFocusId=E.id;}};function d(t,i){var k,m;if(!i){return null;}k=sap.ui.getCore().byId(i);while(!k&&k!==t){if(!i||!document.getElementById(i)){return null;}m=document.getElementById(i).parentNode;i=m.id;k=sap.ui.getCore().byId(i);}return k;}b.prototype.getFocusDomRef=function(){var i;var k=d(this,this._sInitialFocusId);if(!k){this._bFocusSet=false;i=_(this);k=d(this,i);}return k?k.getDomRef():this.getDomRef();};b.prototype.onfocusin=function(E){this._mParameters.event=E;this._mParameters.$FocusablesContent=q(":sapTabbable",this.$("content"));this._mParameters.$FocusablesFooter=q(":sapTabbable",this.$("buttons"));this.oPopup.focusTabChain(this._mParameters);};var f=function(){var t=this.$();var v=0;var m=this.getMaxHeight();var M=m?parseInt(m,10):0;var i=this.getMaxWidth();if(i){var k=parseInt(i,10);var B=t.css("border-left-width");var n=parseInt(B,10);var w=t.css("border-right-width");var x=parseInt(w,10);var y=t.css("padding-left");var z=parseInt(y,10);var A=t.css("padding-right");var D=parseInt(A,10);k-=n+z+D+x;t.css("max-width",k+"px");}else{t.css("max-width","");}var E=t.css("padding-top");var F=parseInt(E,10);var G=t.css("padding-bottom");var H=parseInt(G,10);var J=t.css("border-top-width");var K=parseInt(J,10);var L=t.css("border-bottom-width");var N=parseInt(L,10);var Q=F+H+K+N;var U=q(document).scrollTop();var V=t.rect();var W=V.top-U+t.outerHeight(true);var X=q(window).height();var Y=(W>X)&&(M===0);var Z=0;if(Y){var $=q.sap.byId(this.getOpener());var a1=$.rect();var b1=a1.top-U+$.outerHeight(true);var c1=this.oPopup._getPositionOffset();if(W>b1&&c1.length>0){Z=Math.abs(parseInt(c1[1],10));if((W-Z)<X){Y=false;var d1="Offset of "+Z+" pushes ToolPopup out of the window";q.sap.log.warning(d1,"","sap.ui.ux3.ToolPopup");}}M=M?M:X-V.top;}t.toggleClass("sapUiUx3TPLargeContent",Y);if(M||Y){t.css("max-height",M+"px");var e1=this.$("title");var f1=this.$("title-separator");var g1=this.$("buttons");var h1=this.$("buttons-separator");v=M>0?M:X-V.top-H-Z;v-=Q;v-=e1.outerHeight(true);v-=f1.outerHeight(true);v-=h1.outerHeight(true);v-=g1.length>0?g1.outerHeight(true):0;v=parseInt(v,10);var i1=this.$("content");i1.css("max-height",v+"px");i1.toggleClass("sapUiUx3TPLargeContent",true);}S(this);};var p=function(){this._proxyFixSize();if(!this._sInitialFocusId){var i=_(this);if(i!==sap.ui.getCore().getCurrentFocusedControlId()){var k=q.sap.byId(i);k.focus();}}if(!this._sResizeID){this._sResizeID=sap.ui.core.ResizeHandler.register(this.$('content')[0],this._proxyOnResize);}this.fireOpened();};b.prototype.isOpen=function(){return this.oPopup&&(this.oPopup.getOpenState()=="OPENING"||this.oPopup.getOpenState()=="OPEN");};b.prototype.willBeClosed=function(){var i=this.oPopup&&this.oPopup.getOpenState();return i!==sap.ui.core.OpenState.OPENING&&i!==sap.ui.core.OpenState.OPEN;};b.prototype.open=function(m,i){this._my=m;this._at=i;this._sArrowDir=g(this);var $=null;this.sOffset="";u(this);if(!this._bPositionSet){var k=0;var n=0;if(!this._my){this._my=P.Dock.BeginTop;}if(!this._at){this._at=P.Dock.EndTop;}$=q.sap.domById(this.getOpener());if($){switch(this._sArrowDir){case"Up":k=0;n=this.iArrowWidth;break;case"Down":k=0;n=-this.iArrowWidth;break;case"Right":k=-this.iArrowWidth;break;default:case"Left":k=this.iArrowWidth;break;}k=parseInt(k,10);n=parseInt(n,10);this.sOffset=""+k+" "+n;this.setPosition(this._my,this._at,$,this.sOffset,"none");}else{this.setPosition(P.Dock.BeginTop,P.Dock.BeginTop,window,"0 0","fit");q.sap.log.warning("No opener set. Using a default position for Popup","","sap.ui.ux3.ToolPopup");}this._bPositionSet=false;}this._ensurePopup();var A=this.getAutoClose();var M=this.getModal();if(A&&M){q.sap.log.warning("A modal & autoclose ToolPopup will not work properly. Therefore 'autoclose' will be deactived!");A=false;}this.oPopup.setAutoClose(A);this.oPopup.setModal(M);this._oPreviousFocus=P.getCurrentFocusInfo();this.fireOpen();e(this);this.oPopup.open(this.getOpenDuration(),this._my,this._at,$,this.sOffset,"",true);S(this);return this;};var e=function(t){if(!t.getOpener()){var i="";if(t.oPopup){if(t.oPopup._oPosition.of instanceof sap.ui.core.Element){i=t.oPopup._oPosition.of.getId();}else{if(t.oPopup._oPosition.of.length>0){i=t.oPopup._oPosition.of[0].id;}else{i=t.oPopup._oPosition.of.id;}}}if(i!==""){t.setAssociation("opener",i,true);}else{q.sap.log.error("Neither an opener was set properly nor a corresponding one can be distinguished","","sap.ui.ux3.ToolPopup");}}};var s=function(t){var i="sapUiUx3ToolPopupArrowWidth";t.sArrowWidth=a.get(i);t.iArrowWidth=parseInt(t.sArrowWidth,10);i="sapUiUx3ToolPopupArrowHeight";t.sArrowHeight=a.get(i);t.iArrowHeight=parseInt(t.sArrowHeight,10);i="sapUiUx3ToolPopupArrowRightMarginCorrection";t.sArrowPadding=a.get(i);t.iArrowPadding=parseInt(t.sArrowPadding,10);i="sapUiUx3ToolPopupArrowRightMarginCorrectionInverted";t.sArrowPaddingInverted=a.get(i);t.iArrowPaddingInverted=parseInt(t.sArrowPaddingInverted,10);};var g=function(t){var D="Left";var m=t._my;var i=t._at;if(!m&&t.oPopup){m=t.oPopup._oPosition.my;}if(!i&&t.oPopup){i=t.oPopup._oPosition.at;}t._bHorizontalArrow=false;if(m&&i){var M=m.split(" ");var A=i.split(" ");var k="my:"+M[0]+"|"+M[1];k+=" at:"+A[0]+"|"+A[1];if(b.ARROW_LEFT.exec(k)){t._bHorizontalArrow=true;D="Left";}else if(b.ARROW_RIGHT.exec(k)){t._bHorizontalArrow=true;D="Right";}else if(b.ARROW_UP.exec(k)){D="Up";}else if(b.ARROW_DOWN.exec(k)){D="Down";}if(t.getDomRef()&&t.isOpen()){var $=t.$();var n=$.rect();var v=q.sap.byId(t.getOpener());var w=v.rect();if(w){if(t._bHorizontalArrow){var x=n.left+$.outerWidth(true)+t.iArrowWidth;var y=w.left+v.outerWidth(true);if(x<=y){D="Right";}else{D="Left";}}else{var z=n.top+$.outerHeight(true)+t.iArrowWidth;var B=w.top+v.outerHeight(true);if(z<=B){D="Down";}else{D="Up";}}}}}return D;};var S=function(t){var k="",v=0,z=0,H=t.iArrowHeight/2,i=sap.ui.getCore().getConfiguration().getRTL(),A,m=t.$().rect(),n=q.sap.byId(t.getOpener()),w=n.rect(),x=0,$=t.$("arrow");if(!t.getDomRef()){return;}t._sArrowDir=g(t);A=t._sArrowDir;if(i){if(t._sArrowDir==="Right"){A="Left";}else if(t._sArrowDir==="Left"){A="Right";}}if(!w){q.sap.log.warning("Opener wasn't set properly. Therefore arrow will be at a default position","","sap.ui.ux3.ToolPopup");}if(!t._my&&t.oPopup){t._my=t.oPopup._oPosition.my;}if(t._bHorizontalArrow){k="top";if(w){x=parseInt(t.$().css('border-top-width'),10)||0;z=parseInt(w.top-x-m.top,10);v=Math.round(z+w.height/2-H);v=v+H>m.height?v-t.iArrowHeight:v;}}else{k="left";if(w){if(i){k="right";x=parseInt(t.$().css('border-right-width'),10)||0;z=parseInt(m.left+m.width-w.left-w.width-x,10);}else{x=parseInt(t.$().css('border-left-width'),10)||0;z=parseInt(w.left-m.left-x,10);}v=Math.round(z+w.width/2-H);v=v+H>m.width?v-t.iArrowHeight:v;}}if(!w){v=t.iArrowHeight;}var y="";if($.hasClass("sapUiUx3TPNewArrow")){y="sapUiUx3TPNewArrow sapUiUx3TPNewArrow";}else{y=t.isInverted()?"sapUiUx3TPArrow sapUiTPInverted sapUiUx3TPArrow":"sapUiUx3TPArrow sapUiUx3TPArrow";}$.attr("class",y+A);if(A==="Right"){var W=m.width;if(t.isInverted()){W+=t.iArrowPaddingInverted;}else{W+=t.iArrowPadding;}if(i){$.css("right",W+"px");}else{$.css("left",W+"px");}}else{$.css({"left":"","right":""});}v=parseInt(v,10);v=v<-x?-x:v;$.css(k,v+"px");};b.prototype.onsapescape=function(){if(this.fireClose()){this.close();}};var o=function(E){if(!this._bPreventRestoreFocus){P.applyFocusInfo(this._oPreviousFocus);}if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}this.fireClosed();};b.prototype.close=function(i){if(this.oPopup&&this.oPopup.isOpen()){if(this._sResizeID){sap.ui.core.ResizeHandler.deregister(this._sResizeID);delete this._sResizeID;}this.oPopup.close(this.getCloseDuration());this._bPreventRestoreFocus=i;}return this;};b.prototype.getEnabled=function(){var i=this.oPopup?this.oPopup.getOpenState():sap.ui.core.OpenState.CLOSED;return i===sap.ui.core.OpenState.OPENING||i===sap.ui.core.OpenState.OPEN;};b.prototype.onsapenter=function(E){var i=this.getDefaultButton();var F=sap.ui.getCore().byId(i);if(i&&F&&q.contains(this.getDomRef(),F.getDomRef())){if(F instanceof sap.ui.commons.Button){var $=F.$();$.click();$.focus();}}E.preventDefault();E.stopPropagation();};b.prototype.onBeforeRendering=function(){var i=this.getInitialFocus()||this._sInitialFocusId;var D=this.getDefaultButton();this._bFocusSet=true;if(i){this.oPopup.setInitialFocusId(i);}else if(D){this.oPopup.setInitialFocusId(D);}else{this._bFocusSet=false;}this._bRTL=sap.ui.getCore().getConfiguration().getRTL();};b.prototype._ensurePopup=function(){if(!this.oPopup){this.oPopup=new P(this,false,true,false);this.oPopup.attachOpened(this._proxyOpened);this.oPopup.attachClosed(this._proxyClosed);var t=this;this.oPopup._applyPosition=function(){P.prototype._applyPosition.apply(t.oPopup,arguments);var i=t.oPopup._oLastPosition.of;if(!i){t.oPopup.close();}else{var $=q.sap.byId(i.id);if(t._bPositionSet){if(!$.hasClass("sapUiUx3ShellTool")){t._my=t.oPopup._oLastPosition.my;t._at=t.oPopup._oLastPosition.at;}}S(t);}};}return this.oPopup;};var O=function(){if(this.getContent().length){this._proxyFixSize();this.oPopup._applyPosition(this.oPopup._oLastPosition);}};b.prototype.setPosition=function(){this._ensurePopup();this.oPopup.setPosition.apply(this.oPopup,arguments);this._bPositionSet=true;e(this);return this;};var h=function(i,t){var k=i;if(t==="content"){r(k);}else if(t==="buttons"){j(k);}k._proxyFixSize();k.oPopup._applyPosition(k.oPopup._oLastPosition);};var r=function(t){var k=t.getDomRef("content");k.innerHTML="";var m=t.getContent();var n=sap.ui.getCore().createRenderManager();for(var i=0;i<m.length;i++){n.renderControl(m[i]);}n.flush(k,true);n.destroy();};var j=function(t){var B=t.getDomRef("buttons");var k=t.getDomRef("buttons-separator");var m=t.getButtons();if(m.length===0){q(B).addClass("sapUiUx3TPButtonRowHidden");q(k).addClass("sapUiUx3TPButtonRowHidden");}else{q(B).removeClass("sapUiUx3TPButtonRowHidden");q(k).removeClass("sapUiUx3TPButtonRowHidden");B.innerHTML="";var n=sap.ui.getCore().createRenderManager();for(var i=0;i<m.length;i++){n.renderControl(m[i]);}n.flush(B,true);n.destroy();}};b.prototype.addContent=function(i){this.addAggregation("content",i,true);if(this.isOpen()){h(this,"content");}return this;};b.prototype.insertContent=function(i,k){this.insertAggregation("content",i,k,true);if(this.isOpen()){h(this,"content");}return this;};b.prototype.removeContent=function(i){this.removeAggregation("content",i,true);if(this.isOpen()){h(this,"content");}return this;};b.prototype.addButton=function(B){this.addAggregation("buttons",B,true);if(this.isOpen()){h(this,"buttons");}return this;};b.prototype.insertButton=function(B,i){this.insertAggregation("buttons",B,i,true);if(this.isOpen()){h(this,"buttons");}return this;};b.prototype.removeButton=function(B){this.removeAggregation("button",B,true);if(this.isOpen()){h(this,"buttons");}return this;};var u=function(t){var i="sapUiUx3ToolPopupInverted";i=a.get(i);t._bThemeInverted=i==="true";};b.prototype.onThemeChanged=function(){u(this);};b.prototype.isInverted=function(){u(this);return this.getInverted()&&this._bThemeInverted;};b.prototype.setAutoCloseAreas=function(A){this._ensurePopup();return this.oPopup.setAutoCloseAreas(A);};b.prototype.addFocusableArea=function(i){this._ensurePopup();if(typeof(i)==="string"){this.oPopup._addFocusableArea("channelId","eventId",{id:i});return this;}else{q.sap.log.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup");}};b.prototype.removeFocusableArea=function(i){this._ensurePopup();if(typeof(i)==="string"){this.oPopup._removeFocusableArea("channelId","eventId",{id:i});return this;}else{q.sap.log.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup");}};}());b.prototype.setIcon=function(i){this.setProperty("icon",i,true);this.fireIconChanged();return this;};b.prototype.setIconHover=function(i){this.setProperty("iconHover",i,true);this.fireIconChanged();return this;};b.prototype.setIconSelected=function(i){this.setProperty("iconSelected",i,true);this.fireIconChanged();return this;};b.prototype.getIconSelected=function(){return this.getProperty("iconSelected")||this.getProperty("iconHover");};b.prototype.setMaxWidth=function(m){var p=/[0-9]+px/;if(p.test(m)){this.setProperty("maxWidth",m);}else{q.sap.log.error("Only values in pixels are possible","","sap.ui.ux3.ToolPopup");}return this;};return b;},true);
