/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObjectObserver","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/ui/Device","sap/ui/core/delegate/ScrollEnablement","./ObjectPageSectionBase","./ObjectPageSection","./ObjectPageSubSection","./ObjectPageHeaderContent","./LazyLoading","./ObjectPageLayoutABHelper","./ThrottledTaskHelper","sap/m/ScrollBar","sap/ui/core/library","./library","./ObjectPageLayoutRenderer","sap/base/Log","sap/ui/dom/getScrollbarSize","sap/base/assert","sap/ui/events/KeyCodes"],function(q,M,R,C,D,S,O,a,b,c,L,A,T,d,e,l,f,g,h,i,K){"use strict";var j=e.TitleLevel;var k=l.ObjectPageSubSectionLayout;var m=C.extend("sap.uxap.ObjectPageLayout",{metadata:{library:"sap.uxap",properties:{showAnchorBar:{type:"boolean",defaultValue:true},showAnchorBarPopover:{type:"boolean",defaultValue:true},upperCaseAnchorBar:{type:"boolean",defaultValue:true},backgroundDesignAnchorBar:{type:"sap.m.BackgroundDesign",group:"Appearance"},height:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},enableLazyLoading:{type:"boolean",defaultValue:false},subSectionLayout:{type:"sap.uxap.ObjectPageSubSectionLayout",defaultValue:k.TitleOnTop},sectionTitleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:j.Auto},useIconTabBar:{type:"boolean",group:"Misc",defaultValue:false},showHeaderContent:{type:"boolean",group:"Misc",defaultValue:true},useTwoColumnsForLargeScreen:{type:"boolean",group:"Appearance",defaultValue:false},showTitleInHeaderContent:{type:"boolean",group:"Appearance",defaultValue:false},showOnlyHighImportance:{type:"boolean",group:"Behavior",defaultValue:false},isChildPage:{type:"boolean",group:"Appearance",defaultValue:false},alwaysShowContentHeader:{type:"boolean",group:"Behavior",defaultValue:false},headerContentPinnable:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},showEditHeaderButton:{type:"boolean",group:"Behavior",defaultValue:false},flexEnabled:{type:"boolean",group:"Misc",defaultValue:false},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},associations:{selectedSection:{type:"sap.uxap.ObjectPageSection",multiple:false}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.uxap.ObjectPageSection",multiple:true,singularName:"section"},headerTitle:{type:"sap.uxap.IHeaderTitle",multiple:false},headerContent:{type:"sap.ui.core.Control",multiple:true,singularName:"headerContent"},footer:{type:"sap.m.IBar",multiple:false},_anchorBar:{type:"sap.uxap.AnchorBar",multiple:false,visibility:"hidden"},_iconTabBar:{type:"sap.m.IconTabBar",multiple:false,visibility:"hidden"},_headerContent:{type:"sap.uxap.IHeaderContent",multiple:false,visibility:"hidden"},_customScrollBar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{toggleAnchorBar:{parameters:{fixed:{type:"boolean"}}},editHeaderButtonPress:{},navigate:{parameters:{section:{type:"sap.uxap.ObjectPageSection"},subSection:{type:"sap.uxap.ObjectPageSubSection"}}}},designtime:"sap/uxap/designtime/ObjectPageLayout.designtime"}});m.HEADER_CALC_DELAY=350;m.DOM_CALC_DELAY=200;m.FOOTER_ANIMATION_DURATION=350;m.MAX_SNAP_POSITION_OFFSET=20;m.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;m.TITLE_LEVEL_AS_ARRAY=Object.keys(j);m.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};m.BREAK_POINTS={TABLET:1024,PHONE:600};m.DYNAMIC_HEADERS_MEDIA={PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};m._getNextTitleLevelEntry=function(t){var o=m.TITLE_LEVEL_AS_ARRAY.indexOf(t),p=o!==-1,H=p&&(o!==m.TITLE_LEVEL_AS_ARRAY.length-1);if(!p){return j.Auto;}return m.TITLE_LEVEL_AS_ARRAY[H?o+1:o];};m._getLibraryResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.uxap");};m.prototype.init=function(){this.oCore=sap.ui.getCore();this._bFirstRendering=true;this._bDomReady=false;this._bPinned=false;this._bStickyAnchorBar=false;this._bHeaderInTitleArea=false;this._bHeaderExpanded=true;this._bHeaderBiggerThanAllowedHeight=false;this._bDelayDOMBasedCalculations=true;this._iStoredScrollPosition=0;this._bInternalAnchorBarVisible=true;this._$opWrapper=[];this._$anchorBar=[];this._$headerTitle=[];this._$stickyAnchorBar=[];this._$headerContent=[];this._$stickyHeaderContent=[];this._bMobileScenario=false;this._oSectionInfo={};this._aSectionBases=[];this._sScrolledSectionId="";this._iScrollToSectionDuration=600;this._$spacer=[];this.iHeaderContentHeight=0;this.iStickyHeaderContentHeight=0;this.iHeaderTitleHeight=0;this.iHeaderTitleHeightStickied=0;this.iAnchorBarHeight=0;this.iTotalHeaderSize=0;this._iREMSize=parseInt(q("body").css("font-size"),10);this._iOffset=parseInt(0.25*this._iREMSize,10);this._iResizeId=R.register(this,this._onUpdateScreenSize.bind(this));this._iAfterRenderingDomReadyTimeout=null;this._oABHelper=new A(this);this._initializeScroller();};m.prototype.onBeforeRendering=function(){var H,p;this._oLazyLoading=new L(this);if(!this.getVisible()){return;}if(!this.getSelectedSection()){this._bHeaderExpanded=true;}this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(this._checkAlwaysShowContentHeader()){this._bHeaderExpanded=true;}this._bHeaderInTitleArea=this._shouldPreserveHeaderInTitleArea();this._createHeaderContent();this._getHeaderContent().setContentDesign(this._getHeaderDesign());this._oABHelper._getAnchorBar().setProperty("upperCase",this.getUpperCaseAnchorBar(),true);this._storeScrollLocation();this._applyUxRules();this._getCustomScrollBar().setScrollPosition(0);if(!q.isEmptyObject(this._oSectionInfo)&&this._bFirstRendering){this._preloadSectionsOnBeforeFirstRendering();this._bFirstRendering=false;}this._bStickyAnchorBar=false;this._handleExpandButtonPressEventLifeCycle(false);this._attachTitlePressHandler();H=this._getHeaderContent();if(H&&H.supportsPinUnpin()){p=this.getHeaderContentPinnable()&&!this.getPreserveHeaderStateOnScroll();this._getHeaderContent().setPinnable(p);if(p){this._attachPinPressHandler();}}this._attachVisualIndicatorsPressHandlers(this._handleDynamicTitlePress,this);this._attachVisualIndicatorMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);this._attachTitleMouseOverHandlers(this._addHoverClass,this._removeHoverClass,this);};m.prototype.setBackgroundDesignAnchorBar=function(B){var s=this.getBackgroundDesignAnchorBar(),o="sapUxAPObjectPageNavigation";if(s===B){return this;}this.setProperty("backgroundDesignAnchorBar",B,true);this._oABHelper._getAnchorBar().setBackgroundDesign(B);if(n(this._$anchorBar)){this._$anchorBar.removeClass(o+s);this._$anchorBar.addClass(o+B);}if(n(this._$stickyAnchorBar)){this._$stickyAnchorBar.removeClass(o+s);this._$stickyAnchorBar.addClass(o+B);}return this;};m.prototype.setToggleHeaderOnTitleClick=function(t){var o=this.getHeaderTitle(),r=this.setProperty("toggleHeaderOnTitleClick",t,true);if(!o||!o.supportsToggleHeaderOnTitleClick()){g.warning("Setting toggleHeaderOnTitleClick will not take effect as it is not supported in the ObjectPageHeader, read the API Doc for more information",this);return r;}t=this.getProperty("toggleHeaderOnTitleClick");this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();return r;};m.prototype._attachTitlePressHandler=function(){var t=this.getHeaderTitle();if(n(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(m.EVENTS.TITLE_PRESS,this._handleDynamicTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};m.prototype._toggleHeaderVisibility=function(s){var H=this._getHeaderContent();if(n(H)){H.$().toggleClass("sapUxAPObjectPageHeaderContentHidden",!s);}};m.prototype._snapHeader=function(o){var I,H=this._getHeaderContent();if(H&&H.supportsPinUnpin()&&this._bPinned){this._unPin();H.getAggregation("_pinButton").setPressed(false);o=true;}this._toggleHeaderTitle(false,true);this._moveAnchorBarToTitleArea();if(o){this._moveHeaderToContentArea();this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout(true);I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));if(I){this._scrollTo(this._getSnapPosition()+1);}return;}this._toggleHeaderVisibility(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();};m.prototype._expandHeader=function(o){this._toggleHeaderTitle(true,true);this._toggleHeaderVisibility(true);if(o){this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();this._adjustHeaderHeights();this._requestAdjustLayout();if(n(this._$stickyAnchorBar)){this._$stickyAnchorBar.addClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}return;}this._moveAnchorBarToContentArea();this._moveHeaderToContentArea();this._scrollTo(0,0,0);this._bHeaderExpanded=true;this._updateToggleHeaderVisualIndicators();if(n(this._$stickyAnchorBar)){this._$stickyAnchorBar.removeClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}};m.prototype._handleDynamicTitlePress=function(){if(!this.getToggleHeaderOnTitleClick()||!this._hasVisibleDynamicTitleAndHeader()){return;}var E=!this._bHeaderExpanded,I,o,p;if(E){I=(this._$opWrapper.scrollTop()<=(this._getSnapPosition()+1));o=!this._headerBiggerThanAllowedToBeExpandedInTitleArea()&&(this._shouldPreserveHeaderInTitleArea()||!I);this._expandHeader(o);if(!o){this._scrollTo(0,0);}}else{p=!this._shouldPreserveHeaderInTitleArea();this._snapHeader(p);}this.getHeaderTitle()._getFocusSpan().$().focus();};m.prototype._attachPinPressHandler=function(){var H=this._getHeaderContent();if(n(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(m.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};m.prototype._handleExpandButtonPressEventLifeCycle=function(o){var H=this.getHeaderTitle(),E;if(H){E=H.getAggregation("_expandButton");if(E){E[o?"attachPress":"detachPress"](this._handleExpandButtonPress,this);}}};m.prototype._adjustSelectedSectionByUXRules=function(){var s=this.oCore.byId(this.getSelectedSection()),v=s&&this._sectionCanBeRenderedByUXRules(s);if(!v){if(this._oFirstVisibleSection){s=this._oFirstVisibleSection;this.setAssociation("selectedSection",s.getId(),true);}else{this.setAssociation("selectedSection",null,true);return;}}var o=this.oCore.byId(this._sStoredScrolledSubSectionId),V=o&&this._sectionCanBeRenderedByUXRules(o)&&(s.indexOfSubSection(o)>=0);if(!V){this._sStoredScrolledSubSectionId=null;}};m.prototype._sectionCanBeRenderedByUXRules=function(s){if(!s||!s.getVisible()||!s._getInternalVisible()){return false;}var o=this._aSectionBases.map(function(p){return p.getId();});return(o.indexOf(s.getId())>-1);};m.prototype._getSectionsToRender=function(){this._adjustSelectedSectionByUXRules();var s=this.oCore.byId(this.getSelectedSection());if(this.getUseIconTabBar()&&s){return[s];}else{return this.getSections();}};m.prototype._preloadSectionsOnBeforeFirstRendering=function(){var t;if(!this.getEnableLazyLoading()){t=this._getSectionsToRender();}else{var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;t=this._oLazyLoading.getSubsectionsToPreload(s);}this._connectModelsForSections(t);};m.prototype._grepCurrentTabSectionBases=function(){var F=[],s,o;this._adjustSelectedSectionByUXRules();s=this.oCore.byId(this.getSelectedSection());if(s){var p=s.getId();this._aSectionBases.forEach(function(r){o=r.getParent();if(o&&o.getId()===p){F.push(r);}});}return F;};m.prototype.onAfterRendering=function(){var H=this._getHeaderContent();this._ensureCorrectParentHeight();this._cacheDomElements();this._$opWrapper.on("scroll",this._onScroll.bind(this));if(this._bDomReady&&this.$().parents(":hidden").length===0){this._onAfterRenderingDomReady();}else{if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}this._iAfterRenderingDomReadyTimeout=setTimeout(this._onAfterRenderingDomReady.bind(this),this._getDOMCalculationDelay());}if(H&&H.supportsPinUnpin()){this.$().toggleClass("sapUxAPObjectPageLayoutHeaderPinnable",H.getPinnable());}this._handleExpandButtonPressEventLifeCycle(true);};m.prototype._onAfterRenderingDomReady=function(){var s,o,p;if(this._bIsBeingDestroyed){return;}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();o=this.oCore.byId(s);this._iAfterRenderingDomReadyTimeout=null;this._bDomReady=true;this._adjustHeaderHeights();this._initAnchorBarScroll();if(s){if(this.getUseIconTabBar()){this._setSelectedSectionId(s);this._setCurrentTabSection(o);}else{this.scrollToSection(s,0);}}if(D.system.desktop){this._$opWrapper.on("scroll",this.onWrapperScroll.bind(this));}this._registerOnContentResize();this.getHeaderTitle()&&this._shiftHeaderTitle();this.getFooter()&&this._shiftFooter();this._setSectionsFocusValues();if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(!this._bHeaderExpanded){p=!this._shouldPreserveHeaderInTitleArea();this._snapHeader(p);}this._restoreScrollPosition();this.oCore.getEventBus().publish("sap.ui","ControlForPersonalizationRendered",this);if(this._hasDynamicTitle()){this._updateMedia(this._getWidth(this));}this._updateToggleHeaderVisualIndicators();this._updateTitleVisualState();this.fireEvent("onAfterRenderingDOMReady");};m.prototype._shiftFooter=function(){var $=this.$("footerWrapper"),s=this._calculateShiftOffset();$.css(s.sStyleAttribute,s.iMarginalsOffset+"px");};m.prototype._calculateShiftOffset=function(){var H=0,s=this.oCore.getConfiguration().getRTL()?"left":"right",o=this._hasVerticalScrollBar(),p=this._iOffset,r;if(D.system.desktop){r=h().width;H=r;if(!o){H=0;p+=r;}}return{"sStyleAttribute":s,"iActionsOffset":p,"iMarginalsOffset":H};};m.prototype._getDOMCalculationDelay=function(){return this._bDelayDOMBasedCalculations?m.HEADER_CALC_DELAY:0;};m.prototype.exit=function(){if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._iResizeId){R.deregister(this._iResizeId);}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}this._oFirstVisibleSection=null;this._oFirstVisibleSubSection=null;};m.prototype._getCustomScrollBar=function(){if(!this.getAggregation("_customScrollBar")){var v=new d(this.getId()+"-vertSB",{scrollPosition:0,scroll:this.onCustomScrollerScroll.bind(this),visible:false});this.setAggregation("_customScrollBar",v,true);}return this.getAggregation("_customScrollBar");};m.prototype.onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(this._getCustomScrollBar()){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getCustomScrollBar().setScrollPosition(s);}};m.prototype.onCustomScrollerScroll=function(E){var s=Math.max(this._getCustomScrollBar().getScrollPosition(),0);if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;q(this._$opWrapper).scrollTop(s);};m.prototype.setShowOnlyHighImportance=function(v){var o=this.getShowOnlyHighImportance();if(o!==v){this.setProperty("showOnlyHighImportance",v,true);this.getSections().forEach(function(s){s._updateImportance();});}return this;};m.prototype.setIsHeaderContentAlwaysExpanded=function(v){var o=this.getAlwaysShowContentHeader();var s=(D.system.phone||D.system.tablet);if(o!==v){this.setProperty("alwaysShowContentHeader",v,s);}return this;};m.prototype.setShowEditHeaderButton=function(v){var o=this.getShowEditHeaderButton(),H=this.getAggregation("_headerContent");if(o!==v){this.setProperty("showEditHeaderButton",v,true);H&&H.invalidate();}return this;};m.prototype._initializeScroller=function(){if(this._oScroller){return;}this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:false,vertical:true});};m.prototype.setSelectedSection=function(I){var v,s;if(I instanceof O){I=I.getId();}else if(I!=null&&typeof I!=="string"){i(false,"setSelectedSection(): sId must be a string, an instance of sap.uxap.ObjectPageSection or null");return this;}if(I===this.getSelectedSection()){return this;}if(I===null){this.setAssociation("selectedSection",null,true);this._expandHeader(this._bHeaderInTitleArea);this._requestAdjustLayoutAndUxRules(true);return this;}this.scrollToSection(I);v=a._getClosestSection(I);s=(v instanceof a)?v.getId():v;return this.setAssociation("selectedSection",s,true);};m.prototype._ensureCorrectParentHeight=function(){if(this._bCorrectParentHeightIsSet){return;}if(this.getParent().getHeight&&["","auto"].indexOf(this.getParent().getHeight())!==-1){this.$().parent().css("height","100%");}this._bCorrectParentHeightIsSet=true;};m.prototype._cacheDomElements=function(){this._$headerTitle=q(document.getElementById(this.getId()+"-headerTitle"));this._$anchorBar=q(document.getElementById(this.getId()+"-anchorBar"));this._$stickyAnchorBar=q(document.getElementById(this.getId()+"-stickyAnchorBar"));this._$opWrapper=q(document.getElementById(this.getId()+"-opwrapper"));this._$spacer=q(document.getElementById(this.getId()+"-spacer"));this._$headerContent=q(document.getElementById(this.getId()+"-headerContent"));this._$stickyHeaderContent=q(document.getElementById(this.getId()+"-stickyHeaderContent"));this._$contentContainer=q(document.getElementById(this.getId()+"-scroll"));this._$sectionsContainer=q(document.getElementById(this.getId()+"-sectionsContainer"));this._oScroller._$Container=this._$opWrapper;this._bDomElementsCached=true;};m.prototype._handleExpandButtonPress=function(E){if(this._bStickyAnchorBar){this._moveHeaderToTitleArea();this._toggleHeaderTitle(true);}};m.prototype._toggleHeaderTitle=function(E,u){var H=this.getHeaderTitle();this._$headerTitle.toggleClass("sapUxAPObjectPageHeaderStickied",!E);if(E){H&&H.unSnap(u);}else{H&&H.snap(u);}};m.prototype._moveHeaderToTitleArea=function(){this._$headerContent.children().appendTo(this._$stickyHeaderContent);this._bHeaderInTitleArea=true;this._bSupressModifyOnScrollOnce=true;};m.prototype._moveHeaderToContentArea=function(){if(this._bHeaderInTitleArea){this._$headerContent.append(this._$stickyHeaderContent.children());this._$stickyHeaderContent.children().remove();this._bHeaderInTitleArea=false;}};m.prototype._updateNavigation=function(){if(this.getShowAnchorBar()){this._oABHelper._buildAnchorBar();}};m.prototype._applyUxRules=function(I){var s,o,v,V,p,r,t,F,u,w,x,y;s=this.getSections()||[];V=0;r=this.getShowAnchorBar();t=this.getUseIconTabBar();F=null;this._cleanMemory();s.forEach(function(z){if(!z.getVisible()){return true;}this._registerSectionBaseInfo(z);o=z.getSubSections()||[];v=0;u=null;o.forEach(function(B){if(!B.getVisible()){return true;}this._registerSectionBaseInfo(B);p=B.getVisibleBlocksCount();if(p===0){B._setInternalVisible(false,I);g.info("ObjectPageLayout :: noVisibleBlock UX rule matched","subSection "+B.getTitle()+" forced to hidden");}else{B._setInternalVisible(true,I);B._setInternalTitleVisible(true,I);v++;if(!u){u=B;}if(this._shouldApplySectionTitleLevel(B)){B._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(B));}}},this);if(v==0){z._setInternalVisible(false,I);g.info("ObjectPageLayout :: noVisibleSubSection UX rule matched","section "+z.getTitle()+" forced to hidden");}else{z._setInternalVisible(true,I);z._setInternalTitleVisible(true,I);if(!F){F=z;y=v;}if(this.getSubSectionLayout()===k.TitleOnTop&&v===1&&u.getTitle().trim()!==""){g.info("ObjectPageLayout :: TitleOnTop.sectionGetSingleSubSectionTitle UX rule matched","section "+z.getTitle()+" is taking its single subsection title "+u.getTitle());z._setInternalTitle(u.getTitle(),I);u._setInternalTitleVisible(false,I);u._setBorrowedTitleDomId(z.getId()+"-title");}else{z._setInternalTitle("",I);}if(v===1&&!u.getTitle().trim()){u._setBorrowedTitleDomId(z.getId()+"-title");}if(this._shouldApplySectionTitleLevel(z)){z._setInternalTitleLevel(this._determineSectionBaseInternalTitleLevel(z));}V++;}if(t){z._setInternalTitleVisible(false,I);}},this);if(V<=1){r=false;g.info("ObjectPageLayout :: notEnoughVisibleSection UX rule matched","anchorBar forced to hidden");}else if(F&&r){w=true;F._setInternalTitleVisible(false,I);g.info("ObjectPageLayout :: firstSectionTitleHidden UX rule matched","section "+F.getTitle()+" title forced to hidden");}if(r){this._oABHelper._buildAnchorBar();}this._setInternalAnchorBarVisible(r,I);this._oFirstVisibleSection=F;this._oFirstVisibleSubSection=this._getFirstVisibleSubSection(F);if(w&&(y===1)){x=this.getAggregation("_anchorBar").getContent();if(x.length){this._oFirstVisibleSubSection._setBorrowedTitleDomId(x[0].getId()+"-content");}}};m.prototype.setUseIconTabBar=function(v){var o=this.getUseIconTabBar();if(v!=o){this._applyUxRules();}this.setProperty("useIconTabBar",v);return this;};m.prototype._setCurrentTabSection=function(s,I){if(!s){return;}var o;if(s instanceof sap.uxap.ObjectPageSubSection){o=s;s=s.getParent();}else{o=this._getFirstVisibleSubSection(s);}if(this._oCurrentTabSection!==s){this._renderSection(s);this._oCurrentTabSection=s;}this._oCurrentTabSubSection=o;};m.prototype._renderSection=function(s){var $=this.$().find(".sapUxAPObjectPageContainer"),r;if(s&&$.length){r=this.oCore.createRenderManager();this.getSections().forEach(function(o){if((o.getId()===s.getId())){r.renderControl(s);}else{r.cleanupControlWithoutRendering(o);}});r.flush($[0]);r.destroy();}};m.prototype.setShowAnchorBarPopover=function(v,s){var o=this.getProperty("showAnchorBarPopover"),v=this.validateProperty("showAnchorBarPopover",v),p=this.getSelectedSection();if(v===o){return this;}this._oABHelper._getAnchorBar().setShowPopover(v);this._oABHelper._buildAnchorBar();this._setSelectedSectionId(p);return this.setProperty("showAnchorBarPopover",v,true);};m.prototype._getInternalAnchorBarVisible=function(){return this._bInternalAnchorBarVisible;};m.prototype._setInternalAnchorBarVisible=function(v,I){if(v!=this._bInternalAnchorBarVisible){this._bInternalAnchorBarVisible=v;if(I===true){this.invalidate();}}};m.prototype.setUpperCaseAnchorBar=function(v){this._oABHelper._getAnchorBar().setProperty("upperCase",v);return this.setProperty("upperCaseAnchorBar",v,true);};m.prototype._requestAdjustLayout=function(I){if(!this._oLayoutTask){this._oLayoutTask=new T(this._updateScreenHeightSectionBasesAndSpacer,m.DOM_CALC_DELAY,this);}if(!I){g.debug("ObjectPageLayout :: _requestAdjustLayout","delayed by "+m.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oLayoutTask.reSchedule(I,{}).catch(function(r){});};m.prototype._requestAdjustLayoutAndUxRules=function(I){this._setSectionInfoIsDirty(true);if(!this._oUxRulesTask){this._oUxRulesTask=new T(this._adjustLayoutAndUxRules,m.DOM_CALC_DELAY,this);}if(!I){g.debug("ObjectPageLayout :: _requestAdjustLayoutAndUxRules","delayed by "+m.DOM_CALC_DELAY+" ms because of dom modifications");}return this._oUxRulesTask.reSchedule(I,{}).catch(function(r){});};m.prototype._adjustLayoutAndUxRules=function(){var s,o;g.debug("ObjectPageLayout :: _requestAdjustLayout","refreshing ux rules");this._applyUxRules(true);this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();o=this.oCore.byId(s);if(o){this._setSelectedSectionId(s);if(this.getUseIconTabBar()){this._setCurrentTabSection(o);}this._requestAdjustLayout(true).then(function(p){if(p){this._oLazyLoading.doLazyLoading();}this._adjustSelectedSectionByUXRules();s=this.getSelectedSection();if(!this._isClosestScrolledSection(s)||this._oScroller._$Container.is(":animated")){this.scrollToSection(s,null,0,false,true);}}.bind(this));}};m.prototype._isClosestScrolledSection=function(s){var o=this._$opWrapper.length>0?this._$opWrapper.scrollTop():0,p=this.iScreenHeight,r=this._getClosestScrolledSectionId(o,p);return r&&(s===r);};m.prototype._setSelectedSectionId=function(s){var o=this.getAggregation("_anchorBar"),p=s&&this._oSectionInfo[s];if(!p){return;}if(o&&p.buttonId){o.setSelectedButton(p.buttonId);this.setAssociation("selectedSection",s,true);}};m.prototype.isFirstRendering=function(){return this._bFirstRendering;};m.prototype._cleanMemory=function(){var o=this.getAggregation("_anchorBar");if(o){o._resetControl();}this._oSectionInfo={};this._aSectionBases=[];};m.prototype._registerSectionBaseInfo=function(s){this._oSectionInfo[s.getId()]={$dom:[],positionTop:0,positionTopMobile:0,buttonId:"",isSection:(s instanceof a),sectionReference:s};this._aSectionBases.push(s);};m.prototype._triggerVisibleSubSectionsEvents=function(){this._bDelayDOMBasedCalculations=false;if(this.getEnableLazyLoading()&&this._oLazyLoading){this._oLazyLoading._triggerVisibleSubSectionsEvents();}};m.prototype.scrollToSection=function(I,o,p,r,s){var t=this.oCore.byId(I);if(!this.getDomRef()){g.warning("scrollToSection can only be used after the ObjectPage is rendered",this);return;}if(!t){g.warning("scrollToSection aborted: unknown section",I,this);return;}if(!this._oSectionInfo[I]){g.warning("scrollToSection aborted: section is hidden by UX rules",I,this);return;}if(this.bIsDestroyed){g.debug("ObjectPageLayout :: scrollToSection","scrolling canceled as page is being destroyed");return;}if(this.getUseIconTabBar()){var u=a._getClosestSection(t);if(this._oCurrentTabSection){this._oCurrentTabSection._allowPropagationToLoadedViews(false);}u._allowPropagationToLoadedViews(true);this._setCurrentTabSection(t);this.getAggregation("_anchorBar").setSelectedButton(this._oSectionInfo[u.getId()].buttonId);this.setAssociation("selectedSection",u.getId(),true);}if(r){this.fireNavigate({section:a._getClosestSection(t),subSection:t instanceof b?t:t.getSubSections()[0]});}if(this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();}p=p||0;t._expandSection();this._requestAdjustLayout(true);o=this._computeScrollDuration(o,t);var v=this._computeScrollPosition(t);if(this._sCurrentScrollId!=I||s){this._sCurrentScrollId=I;if(this._iCurrentScrollTimeout){clearTimeout(this._iCurrentScrollTimeout);if(this._$contentContainer){this._$contentContainer.parent().stop(true,false);}}if(this._bDomElementsCached){this._iCurrentScrollTimeout=setTimeout(function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;}.bind(this),o);}this._preloadSectionsOnScroll(t);this.getHeaderTitle()&&this._shiftHeaderTitle();this._scrollTo(v+p,o);}};m.prototype._computeScrollDuration=function(o,t){var p=parseInt(o,10);p=p>=0?p:this._iScrollToSectionDuration;if(this.getUseIconTabBar()&&((t instanceof a)||this._isFirstVisibleSectionBase(t))&&this._bStickyAnchorBar){p=0;}return p;};m.prototype._computeScrollPosition=function(t){var F=t&&(t instanceof a),I=t.getId(),s=this._bMobileScenario||F?this._oSectionInfo[I].positionTopMobile:this._oSectionInfo[I].positionTop,E=!this._bStickyAnchorBar;if(E&&this._isFirstVisibleSectionBase(t)){s=0;}return s;};m.prototype._preloadSectionsOnScroll=function(t){var I=t.getId(),o;if(!this.getEnableLazyLoading()&&this.getUseIconTabBar()){o=(t instanceof a)?t:t.getParent();this._connectModelsForSections([o]);}if(this.getEnableLazyLoading()){var s=this.getUseIconTabBar()?this._grepCurrentTabSectionBases():this._aSectionBases;o=this._oLazyLoading.getSubsectionsToPreload(s,I);if(D.system.desktop){setTimeout(function(){this._connectModelsForSections(o);}.bind(this),50);}else{this._connectModelsForSections(o);}o.forEach(function(p){this.fireEvent("subSectionEnteredViewPort",{subSection:p});},this);}};m.prototype.getScrollingSectionId=function(){return this._sScrolledSectionId;};m.prototype.setDirectScrollingToSection=function(s){this.sDirectSectionId=s;};m.prototype.getDirectScrollingToSection=function(){return this.sDirectSectionId;};m.prototype.clearDirectScrollingToSection=function(){this.sDirectSectionId=null;};m.prototype._scrollTo=function(y,t){if(this._oScroller&&this._bDomReady&&!this._bSuppressScroll){g.debug("ObjectPageLayout :: scrolling to "+y);if((t===0)&&this._shouldSnapHeaderOnScroll(y)){this._toggleHeader(true);}this._oScroller.scrollTo(0,y,t);}return this;};m.prototype._scrollBelowCollapseVisualIndicator=function(){var H=this._getHeaderContent(),$,o,v,p;if(!n(H)||!n(this._$opWrapper)){return;}$=H._getCollapseButton().getDomRef();o=$.getBoundingClientRect().height;v=this._$opWrapper[0].getBoundingClientRect().height;p=$.offsetTop+o-v;this._scrollTo(p);};m.prototype._updateMedia=function(w){var u=function(s){Object.keys(m.DYNAMIC_HEADERS_MEDIA).forEach(function(p){var r=m.DYNAMIC_HEADERS_MEDIA[p],E=s===r;this.toggleStyleClass(r,E);},this);}.bind(this),o=m.DYNAMIC_HEADERS_MEDIA,B=m.BREAK_POINTS;if(w<=B.PHONE){u(o.PHONE);}else if(w<=B.TABLET){u(o.TABLET);}else{u(o.DESKTOP);}};m.prototype._updateScreenHeightSectionBasesAndSpacer=function(){var o,p,s,P,r,t,u=!this._bHeaderExpanded,v=this.getDomRef();if(!v||!this._bDomReady){return false;}g.debug("ObjectPageLayout :: _updateScreenHeightSectionBasesAndSpacer","re-evaluating dom positions");this.iScreenHeight=this._getDOMRefHeight(v);if(this.iScreenHeight===0){return;}var w=0;this._aSectionBases.forEach(function(x){var I=this._oSectionInfo[x.getId()],$=x.$(),y,z=false;if(!I||!$.length){return;}if(!I.isSection){w++;}I.$dom=$;var B=$.position().top;I.positionTop=Math.ceil(B);if(I.isSection){y=x.$("header");}else{y=x.$("headerTitle");}z=y.length===0;if(!z){I.positionTopMobile=Math.ceil(y.position().top)+y.outerHeight();}else{I.positionTopMobile=I.positionTop;}if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea){I.positionTopMobile-=this.iAnchorBarHeight;I.positionTop-=this.iAnchorBarHeight;}I.sectionReference.toggleStyleClass("sapUxAPObjectPageSubSectionPromoted",z);if(this._bMobileScenario){var E=this.oCore.byId(x.getId()).getParent();if(E instanceof a&&E._getIsHidden()){return;}if(r){this._oSectionInfo[r].positionBottom=I.positionTop;}r=x.getId();p=x;}else{if(I.isSection){if(r){this._oSectionInfo[r].positionBottom=I.positionTop;if(P){this._oSectionInfo[P].positionBottom=I.positionTop;}}r=x.getId();P=null;}else{if(P){this._oSectionInfo[P].positionBottom=I.positionTop;}P=x.getId();p=x;}}},this);if(p){o=this._computeLastVisibleHeight(p);if(this._bMobileScenario&&r){this._oSectionInfo[r].positionBottom=this._oSectionInfo[r].positionTop+o;}else{if(P){this._oSectionInfo[P].positionBottom=this._oSectionInfo[P].positionTop+o;}if(r&&P){this._oSectionInfo[r].positionBottom=this._oSectionInfo[P].positionTop+o;}}t=this._bStickyAnchorBar||(w>1)||this._checkContentBottomRequiresSnap(p);if(t&&!this._shouldPreserveHeaderInTitleArea()){u=true;}s=this._computeSpacerHeight(p,o,t,u);this._$spacer.height(s+"px");g.debug("ObjectPageLayout :: bottom spacer is now "+s+"px");}this._updateCustomScrollerHeight(u);this._setSectionInfoIsDirty(false);return true;};m.prototype._updateCustomScrollerHeight=function(r){if(D.system.desktop&&this.getAggregation("_customScrollBar")){var s=this._computeScrollableContentSize(r);s+=this._getStickyAreaHeight(r);this._getCustomScrollBar().setContentSize(s+"px");var o=(s>Math.ceil(this.iScreenHeight)),v=(o!==this._getCustomScrollBar().getVisible());if(v){this._getCustomScrollBar().setVisible(o);this.getHeaderTitle()&&this._shiftHeaderTitle();}}};m.prototype._computeScrollableContentSize=function(s){var o=0;if(this._$contentContainer&&this._$contentContainer.length){o=this._$contentContainer[0].scrollHeight;}if(!this._bStickyAnchorBar&&s){o-=this.iAnchorBarHeight;}if(this._bStickyAnchorBar&&!s){o+=this.iAnchorBarHeight;}return o;};m.prototype._computeLastVisibleHeight=function(o){var I=this._bStickyAnchorBar||this._bHeaderInTitleArea;var p=this._getSectionPositionTop(o,I);return this._$spacer.position().top-p;};m.prototype._getStickyAreaHeight=function(I){if(I){return this.iHeaderTitleHeightStickied+this.iAnchorBarHeight;}return this.iHeaderTitleHeight;};m.prototype._getScrollableViewportHeight=function(I){return this.getDomRef().getBoundingClientRect().height-this._getStickyAreaHeight(I);};m.prototype._getSectionPositionTop=function(s,o){var p=s.$().position().top;if(!this._bStickyAnchorBar&&!this._bHeaderInTitleArea&&o){p-=this.iAnchorBarHeight;}return p;};m.prototype._getSectionPositionBottom=function(s,o){var p=this._oSectionInfo[s.getId()].positionBottom;if(!o){p+=this.iAnchorBarHeight;}return p;};m.prototype._determineSectionBaseInternalTitleLevel=function(s){var o=this.getSectionTitleLevel(),I=s instanceof a;if(o===j.Auto){return I?j.H3:j.H4;}return I?o:m._getNextTitleLevelEntry(o);};m.prototype._shouldApplySectionTitleLevel=function(s){return s.getTitleLevel()===j.Auto;};m.prototype._checkContentBottomRequiresSnap=function(s){var o=false;return this._getSectionPositionBottom(s,o)>=(this._getScrollableViewportHeight(o)+this._getSnapPosition());};m.prototype._computeSpacerHeight=function(o,p,r,s){var t,u,F;if(this.getFooter()&&this.getShowFooter()){F=this.$("footerWrapper").outerHeight();}u=this._getScrollableViewportHeight(s);if(!r){p=this._getSectionPositionBottom(o,false);}if(p<u){t=u-p;if(this._bMobileScenario){t+=(this._oSectionInfo[o.getId()].positionTopMobile-this._oSectionInfo[o.getId()].positionTop);}}else{t=0;}if(F>t){t+=F;}return t;};m.prototype._isFirstVisibleSectionBase=function(s){var o,p,F,r=this.getSelectedSection(),u=this.getUseIconTabBar();if(!s||!s.getParent()){return;}o=s.getId();if(u&&(o===r)){return true;}if(u&&(s.getParent().getId()===r)){p=sap.ui.getCore().byId(r);F=this._getFirstVisibleSubSection(p);return F&&(F.getId()===o);}if(this._oFirstVisibleSection&&this._oFirstVisibleSubSection){return o===this._oFirstVisibleSection.getId()||o===this._oFirstVisibleSubSection.getId();}return false;};m.prototype._getFirstVisibleSubSection=function(s){if(!s){return;}var F;this._aSectionBases.every(function(o){if(o.getParent()&&(o.getParent().getId()===s.getId())){F=o;return false;}return true;});return F;};m.prototype._initAnchorBarScroll=function(){var s=this.oCore.byId(this.getSelectedSection()),o;this._requestAdjustLayout(true);o=s?this._computeScrollPosition(s):0;this._sScrolledSectionId="";this._sCurrentScrollId="";this._onScroll({target:{scrollTop:o}},true);};m.prototype._setAsCurrentSection=function(s){var o,p,r;if(this._sScrolledSectionId===s){return;}g.debug("ObjectPageLayout :: current section is "+s);this._sScrolledSectionId=s;o=this.getAggregation("_anchorBar");if(o&&this._getInternalAnchorBarVisible()){p=this.oCore.byId(s);r=p&&p instanceof b&&(p.getTitle().trim()===""||!p._getInternalTitleVisible()||p.getParent()._getIsHidden());if(r){s=p.getParent().getId();g.debug("ObjectPageLayout :: current section is a subSection with an empty or hidden title, selecting parent "+s);}if(p&&this._oSectionInfo[s]){o.setSelectedButton(this._oSectionInfo[s].buttonId);this.setAssociation("selectedSection",a._getClosestSection(s).getId(),true);this._setSectionsFocusValues(s);}}};m.prototype._registerOnContentResize=function(){var $=this._$contentContainer.length&&this._$contentContainer[0];if(!$){return;}if(this._iContentResizeId){R.deregister(this._iContentResizeId);}this._iContentResizeId=R.register($,this._onUpdateContentSize.bind(this));};m.prototype._onUpdateContentSize=function(E){var s;if(this._preserveHeaderStateOnScroll()){this._overridePreserveHeaderStateOnScroll();}if(this._hasDynamicTitle()){this._adjustHeaderHeights();}this._requestAdjustLayout().then(function(){s=this._$opWrapper.scrollTop();this._updateSelectionOnScroll(s);}.bind(this));};m.prototype._onUpdateScreenSize=function(E){var t=this.getHeaderTitle(),H=this._getHeaderContent(),o=E.size.width,p=E.size.height,r=E.oldSize.height,s=(p!==r),u,I=H&&H.supportsAlwaysExpanded()&&this.getAlwaysShowContentHeader();if(E.size.height===0||E.size.width===0){g.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){g.info("ObjectPageLayout :: cannot _onUpdateScreenSize before dom is ready");return;}this._oLazyLoading.setLazyLoadingParameters();setTimeout(function(){this._bMobileScenario=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange());this._bTabletScenario=l.Utilities.isTabletScenario(this._getCurrentMediaContainerRange());if(I&&(this._bHeaderInTitleArea!=this._checkAlwaysShowContentHeader())){this.invalidate();}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._scrollTo(0,0);}if(t&&t.isDynamic()){t._onResize(o);this._updateMedia(o);}this._adjustHeaderHeights();this._requestAdjustLayout(true);if(this.getFooter()&&this.getShowFooter()){this._shiftFooter();}u=this.getSelectedSection();if((r===0)&&s&&!this._isClosestScrolledSection(u)){this.scrollToSection(u,0);}this._scrollTo(this._$opWrapper.scrollTop(),0);if((r===0)&&s&&this.getEnableLazyLoading()&&this._oLazyLoading&&!this._bDelayDOMBasedCalculations){this._oLazyLoading.doLazyLoading();}}.bind(this),this._getDOMCalculationDelay());};m.prototype._onUpdateHeaderTitleSize=function(E){if(E.size.height===0||E.size.width===0){g.info("ObjectPageLayout :: not triggering calculations if height or width is 0");return;}if(!this._bDomReady){g.info("ObjectPageLayout :: cannot _onUpdateTitleSize before dom is ready");return;}this._adjustHeaderHeights();this._requestAdjustLayout();};m.prototype._shouldSnapHeaderOnScroll=function(s){return(s>0)&&(s>=this._getSnapPosition())&&!this._shouldPreserveHeaderInTitleArea();};m.prototype._getScrollableContentLength=function(){return this._$contentContainer.length?this._getDOMRefHeight(this._$contentContainer[0]):0;};m.prototype._isContentScrolledToBottom=function(){return this._oLastScrollState.iScrollableContentLength<=(this._oLastScrollState.iScrollTop+this._oLastScrollState.iScrollableViewportHeight);};m.prototype._isContentLengthDecreased=function(p){if(p){return((p.iScrollableContentLength>this._oLastScrollState.iScrollableContentLength)&&(p.iSpacerHeight===this._oLastScrollState.iSpacerHeight));}};m.prototype._canReachScrollTop=function(r,E){var o;E=E||0;o=this._oLastScrollState.iScrollableContentLength+E-this._oLastScrollState.iScrollableViewportHeight;return o>=r;};m.prototype._onScroll=function(E,I){var s=Math.max(Math.ceil(E.target.scrollTop),0),$=this._$opWrapper.length&&this._$opWrapper[0],o=this._$spacer.length&&this._$spacer[0],p=o.offsetHeight,P,H=this.getHeaderTitle(),r=this._shouldSnapHeaderOnScroll(s),t=this._shouldPreserveHeaderInTitleArea(),u=false,v=this._oLastScrollState;this._oLastScrollState={iScrollTop:s,iScrollableContentLength:Math.ceil(this._getScrollableContentLength()),iScrollableViewportHeight:$.offsetHeight,iSpacerHeight:p};if(this._bSupressModifyOnScrollOnce){this._bSupressModifyOnScrollOnce=false;return;}if(!$||!o){return;}P=this.iScreenHeight;if(P===0){return;}if(this._getSectionInfoIsDirty()){return;}if(v&&this._isContentScrolledToBottom()&&this._isContentLengthDecreased(v)){var w=v.iScrollableContentLength-this._oLastScrollState.iScrollableContentLength;if(!this._canReachScrollTop(v.iScrollTop)&&this._canReachScrollTop(v.iScrollTop,w)){var N=p+w;this._$spacer.height(N+"px");this._scrollTo(v.iScrollTop);return;}}if(r&&!t){P-=(this.iAnchorBarHeight+this.iHeaderTitleHeightStickied);}if(this._bHeaderInTitleArea&&!t){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);this._bHeaderExpanded=false;this._updateToggleHeaderVisualIndicators();this._requestAdjustLayout();}if(!t&&((H&&this.getShowHeaderContent())||this.getShowAnchorBar())){this._toggleHeader(r,!!(E&&E.type==="scroll"));}if(!t){this._adjustHeaderTitleBackgroundPosition(s);}g.debug("ObjectPageLayout :: lazy loading : Scrolling at "+s,"----------------------------------------");this._updateSelectionOnScroll(s);if(this.getEnableLazyLoading()){this._oLazyLoading.lazyLoadDuringScroll(I,s,E.timeStamp,P);}if(H&&H.supportsTitleInHeaderContent()&&this.getShowHeaderContent()&&this.getShowTitleInHeaderContent()&&H.getShowTitleSelector()){if(s===0){q(document.getElementById(this.getId()+"-scroll")).css("z-index","1000");u=false;}else if(!u){u=true;q(document.getElementById(this.getId()+"-scroll")).css("z-index","0");}}};m.prototype._updateSelectionOnScroll=function(s){var p=this.iScreenHeight,o,r;if(p===0){return;}o=this._getClosestScrolledSectionId(s,p);r=this._getClosestScrolledSectionId(s,p,true);if(o){var t=this.getDirectScrollingToSection();if(o!==this._sScrolledSectionId){g.debug("ObjectPageLayout :: closest id "+o,"----------------------------------------");var t=this.getDirectScrollingToSection();if(t&&t!==o){return;}this.clearDirectScrollingToSection();this._setAsCurrentSection(o);}else if(o===this.getDirectScrollingToSection()){this.clearDirectScrollingToSection();}if(r!==this._sScrolledSubSectionId){this._sScrolledSubSectionId=r;this.fireEvent("_sectionChange",{section:this.oCore.byId(o),subSection:this.oCore.byId(r)});}}};m.prototype._getSnapPosition=function(){var s=this.iHeaderContentHeight,t=this.iHeaderTitleHeightStickied-this.iHeaderTitleHeight;if(t<m.MAX_SNAP_POSITION_OFFSET){s-=t;}return s;};m.prototype._getClosestScrolledSectionId=function(s,p,o){o=!!o;s=Math.ceil(s);if(this.getUseIconTabBar()&&this._oCurrentTabSection){return this._oCurrentTabSection.getId();}var r=s+p,t,u=o||this._bMobileScenario;q.each(this._oSectionInfo,function(I,v){var w,x,y,z;w=this.oCore.byId(I);if(!w){return;}x=w.getParent();y=x instanceof a&&x._getIsHidden();if(v.isSection||(u&&!y)){if(!t&&(v.sectionReference._getInternalVisible()===true)){z=this._getFirstVisibleSubSection(v.sectionReference);if(v.isSection&&o&&z){t=z.getId();}else{t=I;}}if(v.isSection&&o){return true;}if(v.positionTop<=r&&s<=v.positionBottom){if(v.positionTop<=s&&v.positionBottom>s){t=I;return false;}}}}.bind(this));return t;};m.prototype._toggleHeader=function(s,u){var H;if(s===this._bStickyAnchorBar){return;}H=this.getHeaderTitle();if(!this._shouldPreserveHeaderInTitleArea()&&!this._bHeaderInTitleArea){this._toggleHeaderTitle(!s,u);}if(!this._bStickyAnchorBar&&s){this._restoreFocusAfter(this._moveAnchorBarToTitleArea);H&&H.snap();this._bHeaderExpanded=false;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();}else if(this._bStickyAnchorBar&&!s){this._restoreFocusAfter(this._moveAnchorBarToContentArea);H&&H.unSnap();this._bHeaderExpanded=true;this._adjustHeaderHeights();this._updateToggleHeaderVisualIndicators();if(n(this._$stickyAnchorBar)){this._$stickyAnchorBar.removeClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}}};m.prototype._restoreFocusAfter=function(o){var p=this.oCore.byId(this.oCore.getCurrentFocusedControlId());o.call(this);if(D.system.phone!==true){if(!this.oCore.byId(this.oCore.getCurrentFocusedControlId())){p&&p.$().focus();}}return this;};m.prototype._moveAnchorBarToTitleArea=function(){this._$anchorBar.children().appendTo(this._$stickyAnchorBar);this._toggleHeaderStyleRules(true);if(this.iHeaderTitleHeight!=this.iHeaderTitleHeightStickied){this._adjustHeaderBackgroundSize();}return this;};m.prototype._moveAnchorBarToContentArea=function(){if(!this._shouldPreserveHeaderInTitleArea()){var s=this._$opWrapper.scrollTop();this._$anchorBar.css("height","auto").append(this._$stickyAnchorBar.children());this._$opWrapper.scrollTop(s);this._toggleHeaderStyleRules(false);}return this;};m.prototype._toggleHeaderStyleRules=function(s){s=!!s;var v=s?"hidden":"inherit";this._bStickyAnchorBar=s;this._$headerContent.css("overflow",v);this._$headerContent.toggleClass("sapContrastPlus",!s);this._$headerContent.toggleClass("sapUxAPObjectPageHeaderDetailsHidden",s);this._$anchorBar.css("visibility",v);this._$anchorBar.toggleClass("sapUxAPObjectPageNavigationHidden",s);this.fireToggleAnchorBar({fixed:s});};m.prototype.getScrollDelegate=function(){return this._oScroller;};m.prototype.setHeaderTitle=function(H,s){if(H&&typeof H.addEventDelegate==="function"){H.addEventDelegate({onAfterRendering:this._adjustHeaderHeights.bind(this)});}this.setAggregation("headerTitle",H,s);this._oObserver&&this._oObserver.disconnect();this._oObserver=new M(this._onModifyHeaderTitle.bind(this));this._oObserver.observe(H,{aggregations:["headerTitle"],properties:["backgroundDesign"]});if(H){this._createHeaderContent();}return this;};m.prototype._onModifyHeaderTitle=function(p){var H=this.getAggregation("_headerContent");H&&p.current&&H.setBackgroundDesign(p.current);};m.prototype.invalidate=function(o){if(this.getUseIconTabBar()&&o&&(o instanceof a)&&!o.isActive()){return;}if(this._iAfterRenderingDomReadyTimeout){clearTimeout(this._iAfterRenderingDomReadyTimeout);}C.prototype.invalidate.apply(this,arguments);};m.prototype._createHeaderContent=function(){var H=this.getHeaderTitle(),s=H&&H.supportsBackgroundDesign()&&H.getBackgroundDesign(),o=this.getAggregation("_headerContent"),p,N;var r=H?H.getCompatibleHeaderContentClass():c;if(!(o instanceof r)){p=this.getAggregation("_headerContent");if(p){p.destroy();}N=r.createInstance(this.getAggregation("headerContent"),this.getShowHeaderContent(),this._getHeaderDesign(),this.getHeaderContentPinnable(),this.getId()+"-OPHeaderContent");s&&N.setBackgroundDesign(s);this.setAggregation("_headerContent",N,true);}};m.prototype._adjustHeaderBackgroundSize=function(){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(!this._shouldPreserveHeaderInTitleArea()){this.iTotalHeaderSize=this.iHeaderTitleHeight+this.iHeaderContentHeight;this._$headerContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}else{this.iTotalHeaderSize=this.iHeaderTitleHeight-this._$stickyAnchorBar.height();this._$stickyHeaderContent.css("background-size","100% "+this.iTotalHeaderSize+"px");}H.$().css("background-size","100% "+this.iTotalHeaderSize+"px");this._adjustHeaderTitleBackgroundPosition(0);}};m.prototype._adjustHeaderTitleBackgroundPosition=function(s){var H=this.getHeaderTitle();if(H&&H.getHeaderDesign()=="Dark"){if(this._bStickyAnchorBar){H.$().css("background-position","0px "+((this.iTotalHeaderSize-this.iHeaderTitleHeightStickied)*-1)+"px");}else{if(this._shouldPreserveHeaderInTitleArea()){H.$().css("background-position","0px 0px");}else{H.$().css("background-position","0px "+(this.iHeaderTitleHeight+this.iHeaderContentHeight-this.iTotalHeaderSize-s)+"px");}}}};m.prototype._adjustHeaderHeights=function(){var t=this.getHeaderTitle(),p=true;if(t&&!t.supportsAdaptLayoutForDomElement()){p=false;}if(this._$headerTitle.length>0){this.iHeaderContentHeight=this._$headerContent.length?Math.ceil(this._getDOMRefHeight(this._$headerContent[0])):0;this.iStickyHeaderContentHeight=this._$stickyHeaderContent.height();this.iAnchorBarHeight=this._bStickyAnchorBar?this._$stickyAnchorBar.height():this._$anchorBar.height();if(!this._bHeaderExpanded){this.iHeaderTitleHeightStickied=this._$headerTitle.height()-this.iAnchorBarHeight;this.iHeaderTitleHeight=this._obtainExpandedTitleHeight(p);}else{this.iHeaderTitleHeight=this._$headerTitle.is(":visible")?this._$headerTitle.height():0;this.iHeaderTitleHeightStickied=this._obtainSnappedTitleHeight(p);}this._adjustHeaderBackgroundSize();g.info("ObjectPageLayout :: adjustHeaderHeight","headerTitleHeight: "+this.iHeaderTitleHeight+" - headerTitleStickiedHeight: "+this.iHeaderTitleHeightStickied+" - headerContentHeight: "+this.iHeaderContentHeight);}else{g.debug("ObjectPageLayout :: adjustHeaderHeight","skipped as the objectPageLayout is being rendered");}};m.prototype._appendTitleCloneToDOM=function(E){var $=this._$headerTitle.clone();$.css({left:"-10000px",top:"-10000px",width:this._$headerTitle.width()+"px",position:"absolute"});$.toggleClass("sapUxAPObjectPageHeaderStickied",E);$.appendTo(this._$headerTitle.parent());if(E){this.getHeaderTitle()&&this.getHeaderTitle()._adaptLayoutForDomElement($);}return $;};m.prototype._obtainSnappedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H;this._$opWrapper.css("overflow-y","hidden");if(v){$=this._appendTitleCloneToDOM(true);H=$.height();$.remove();}else if(t&&t.snap){t.snap(false);H=t.$().outerHeight();t.unSnap(false);}this._$opWrapper.css("overflow-y","auto");return H;};m.prototype._obtainExpandedTitleHeight=function(v){var t=this.getHeaderTitle(),$,H;if(v){$=this._appendTitleCloneToDOM(false);H=$.is(":visible")?$.height()-this.iAnchorBarHeight:0;$.remove();}else if(t&&t.unSnap){t.unSnap(false);H=t.$().outerHeight();t.snap(false);}return H;};m.prototype._getHeaderDesign=function(){var H=this.getHeaderTitle(),s=l.ObjectPageHeaderDesign.Light;if(H!=null){s=H.getHeaderDesign();}return s;};m.prototype._getVisibleSections=function(){return this.getSections().filter(function(s){return s.getVisible()&&s._getInternalVisible();});};m.prototype._setSectionsFocusValues=function(s){var o=this._getVisibleSections()||[],$,F='0',N='-1',t="tabIndex",p,r=o[0];o.forEach(function(u){$=u.$();if(s===u.sId){$.attr(t,F);p=u;u._setSubSectionsFocusValues();}else{$.attr(t,N);u._disableSubSectionsFocus();}});if(!p&&o.length>0){r.$().attr(t,F);r._setSubSectionsFocusValues();p=r;}return p;};m.prototype.setShowHeaderContent=function(s){var o=this.getShowHeaderContent(),H;if(o!==s){if(o&&this._bHeaderInTitleArea&&!this._shouldPreserveHeaderInTitleArea()){this._moveHeaderToContentArea();this._toggleHeaderTitle(false);}this.setProperty("showHeaderContent",s);H=this._getHeaderContent();if(H){H.setProperty("visible",s);}}return this;};m.prototype._headerTitleChangeHandler=function(I){var r;if(!this.getShowTitleInHeaderContent()){return;}if(I){this._getHeaderContent()._destroyObjectImage(true);}r=this.oCore.createRenderManager();this.getRenderer()._rerenderHeaderContentArea(r,this);this._getHeaderContent().invalidate();r.destroy();};m.prototype.getHeaderContent=function(){if(!this._getHeaderContent()){return this.getAggregation("headerContent",[]);}return this._getHeaderContent().getAggregation("content",[]);};m.prototype.insertHeaderContent=function(o,I,s){if(!this._getHeaderContent()){return this.insertAggregation("headerContent",o,I,s);}return this._getHeaderContent().insertAggregation("content",o,I,s);};m.prototype.addHeaderContent=function(o,s){if(!this._getHeaderContent()){return this.addAggregation("headerContent",o,s);}return this._getHeaderContent().addAggregation("content",o,s);};m.prototype.removeAllHeaderContent=function(s){if(!this._getHeaderContent()){return this.removeAllAggregation("headerContent",s);}return this._getHeaderContent().removeAllAggregation("content",s);};m.prototype.removeHeaderContent=function(o,s){if(!this._getHeaderContent()){return this.removeAggregation("headerContent",o,s);}return this._getHeaderContent().removeAggregation("content",o,s);};m.prototype.destroyHeaderContent=function(s){if(!this._getHeaderContent()){return this.destroyAggregation("headerContent",s);}return this._getHeaderContent().destroyAggregation("content",s);};m.prototype.indexOfHeaderContent=function(o){if(!this._getHeaderContent()){return this.indexOfAggregation("headerContent",o);}return this._getHeaderContent().indexOfAggregation("content",o);};m.prototype._getHeaderContent=function(){return this.getAggregation("_headerContent");};m.prototype._connectModelsForSections=function(s){s=s||[];s.forEach(function(o){o.connectToModels();});};m.prototype._getHeightRelatedParameters=function(){return{iHeaderContentHeight:this.iHeaderContentHeight,iScreenHeight:this.iScreenHeight,iAnchorBarHeight:this.iAnchorBarHeight,iHeaderTitleHeightStickied:this.iHeaderTitleHeightStickied,iStickyHeaderContentHeight:this.iStickyHeaderContentHeight,iScrollTop:this._$opWrapper.scrollTop()};};m.prototype._hasVerticalScrollBar=function(){return(this._getCustomScrollBar().getVisible()===true);};m.prototype._shiftHeaderTitle=function(){var s=this._calculateShiftOffset(),o=s.sStyleAttribute,p=s.iMarginalsOffset;this.$().find(".sapUxAPObjectPageHeaderTitle").css("padding-"+o,p+"px");};m.prototype._isFirstSection=function(s){var o=this._getVisibleSections();if(s===o[0]){return true;}return false;};m.prototype._isPositionWithinSection=function(s,o){if(!o||!this._bDomReady||!this._oSectionInfo[o.getId()]){return;}var p=this._computeScrollPosition(o),r=q(o.getDomRef()).height(),t=p+r;return((s>=p)&&(s<t));};m.prototype._restoreScrollPosition=function(){var s=this.oCore.byId(this._sStoredScrolledSubSectionId);if(!s){return;}if(this._isPositionWithinSection(this._iStoredScrollPosition,s)){this._scrollTo(this._iStoredScrollPosition,0);}else{this.scrollToSection(s.getId(),0);}};m.prototype._storeScrollLocation=function(){if(!this.getDomRef()||!this._bDomReady){return;}this._iStoredScrollPosition=this._oScroller.getScrollTop();this._sStoredScrolledSubSectionId=this._getClosestScrolledSectionId(this._oScroller.getScrollTop(),this.iScreenHeight,true);this._oCurrentTabSection=null;};m.prototype.onkeyup=function(E){var F,o;if(E.which===K.TAB){F=this.oCore.getCurrentFocusedControlId();o=F&&this.oCore.byId(F);if(o&&this._isFirstSection(o)){this._scrollTo(0,0);}}};m.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};m.prototype._toggleFooter=function(s){var u=this.oCore.getConfiguration().getAnimation(),F=this.getFooter();if(!n(F)){return;}F.toggleStyleClass("sapUxAPObjectPageFloatingFooterShow",s);F.toggleStyleClass("sapUxAPObjectPageFloatingFooterHide",!s);if(this._iFooterWrapperHideTimeout){clearTimeout(this._iFooterWrapperHideTimeout);}if(u){if(!s){this._iFooterWrapperHideTimeout=setTimeout(function(){this.$("footerWrapper").toggleClass("sapUiHidden",!s);}.bind(this),m.FOOTER_ANIMATION_DURATION);}else{this.$("footerWrapper").toggleClass("sapUiHidden",!s);this._iFooterWrapperHideTimeout=null;}setTimeout(function(){F.removeStyleClass("sapUxAPObjectPageFloatingFooterShow");},m.FOOTER_ANIMATION_DURATION);}this._requestAdjustLayout();};m.prototype.clone=function(){var o,H,p;Object.keys(this.mAggregations).forEach(this._cloneProxiedAggregations,this);o=C.prototype.clone.apply(this,arguments);H=this._getHeaderContent();p=o._getHeaderContent();if(p){p.destroy();}if(H){o.setAggregation("_headerContent",H.clone(),true);}return o;};m.prototype._cloneProxiedAggregations=function(s){var o=this.mAggregations[s];if(Array.isArray(o)&&o.length===0){o=this["get"+s.charAt(0).toUpperCase()+s.slice(1)]();}this.mAggregations[s]=o;};m.prototype._shouldPreserveHeaderInTitleArea=function(){return this._bPinned||this._preserveHeaderStateOnScroll()||this._checkAlwaysShowContentHeader();};m.prototype._checkAlwaysShowContentHeader=function(){return!this._hasDynamicTitle()&&!this._bMobileScenario&&!this._bTabletScenario&&this.getShowHeaderContent()&&this.getAlwaysShowContentHeader();};m.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed();};m.prototype._headerBiggerThanAllowedToBeFixed=function(){var o=this._getOwnHeight();return this._getEntireHeaderHeight()>m.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*o;};m.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){return this._getEntireHeaderHeight()>=this._getOwnHeight();};m.prototype._getOwnHeight=function(){return this._getHeight(this);};m.prototype._getHeight=function(o){return!(o instanceof C)?0:o.$().outerHeight()||0;};m.prototype._getEntireHeaderHeight=function(){var t=0,H=0,o=this.getHeaderTitle(),p=this._getHeaderContent();if(n(o)){t=o.$().outerHeight();}if(n(p)){H=p.$().outerHeight();}return t+H;};m.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin();}else{this._pin();}};m.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;this._toggleHeaderTitle(true);this._moveAnchorBarToTitleArea();this._moveHeaderToTitleArea();this._adjustHeaderHeights();this._requestAdjustLayout();this._togglePinButtonARIAState(this._bPinned);this._updateToggleHeaderVisualIndicators();if(n($)){$.addClass("sapUxAPObjectPageLayoutHeaderPinned");}if(n(this._$stickyAnchorBar)){this._$stickyAnchorBar.addClass("sapUxAPObjectPageStickyAnchorBarPaddingTop");}};m.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(n($)){$.removeClass("sapUxAPObjectPageLayoutHeaderPinned");}};m.prototype._togglePinButtonARIAState=function(p){var H=this._getHeaderContent();if(n(H)&&H.supportsPinUnpin()){H._updateARIAPinButtonState(p);}};m.prototype._preserveHeaderStateOnScroll=function(){return this._hasDynamicTitle()&&this.getPreserveHeaderStateOnScroll()&&!this._bHeaderBiggerThanAllowedHeight;};m.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._bHeaderBiggerThanAllowedHeight=false;return;}this._bHeaderBiggerThanAllowedHeight=true;if(this._bHeaderExpanded){this._moveAnchorBarToContentArea();this._moveHeaderToContentArea(true);}else{this._snapHeader(true);}this._adjustHeaderHeights();this._requestAdjustLayout();};m.prototype._hasDynamicTitle=function(){var t=this.getHeaderTitle();return t&&t.isDynamic();};m.prototype._attachVisualIndicatorsPressHandlers=function(p,o){var t=this.getHeaderTitle(),H=this._getHeaderContent();if(n(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(m.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,function(){p.call(o);if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBelowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();},this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(n(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(m.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,function(){p.call(o);this._focusExpandVisualIndicator();},this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};m.prototype._hasVisibleDynamicTitleAndHeader=function(){var t=this.getHeaderTitle(),H=this.getHeaderContent();return n(t)&&t.isDynamic()&&t.getVisible()&&n(H)&&H.length>0;};m.prototype._updateToggleHeaderVisualIndicators=function(){var H,o,E,p=this._hasVisibleDynamicTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||!p){o=false;E=false;}else{H=this._bHeaderExpanded;o=H;E=!H;}this._toggleCollapseVisualIndicator(o);this._toggleExpandVisualIndicator(E);};m.prototype._updateTitleVisualState=function(){var t=this.getHeaderTitle(),o=this._hasVisibleDynamicTitleAndHeader()&&this.getToggleHeaderOnTitleClick();this.$().toggleClass("sapUxAPObjectPageLayoutTitleClickEnabled",o);if(n(t)){t._toggleFocusableState(o);}};m.prototype._focusCollapseVisualIndicator=function(){var o=this._getHeaderContent();if(n(o)){o._focusCollapseButton();}};m.prototype._focusExpandVisualIndicator=function(){var o=this.getHeaderTitle();if(n(o)){o._focusExpandButton();}};m.prototype._toggleExpandVisualIndicator=function(t){var o=this.getHeaderTitle();if(n(o)){o._toggleExpandButton(t);}};m.prototype._toggleCollapseVisualIndicator=function(t){var o=this._getHeaderContent();if(n(o)){o._toggleCollapseButton(t);}};m.prototype._attachVisualIndicatorMouseOverHandlers=function(o,p,r){var H=this._getHeaderContent();if(n(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(m.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,o,r);H.attachEvent(m.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,p,r);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};m.prototype._attachTitleMouseOverHandlers=function(o,p,r){var t=this.getHeaderTitle();if(n(t)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){t.attachEvent(m.EVENTS.TITLE_MOUSE_OVER,o,r);t.attachEvent(m.EVENTS.TITLE_MOUSE_OUT,p,r);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};m.prototype._suppressScroll=function(){this._bSuppressScroll=true;};m.prototype._resumeScroll=function(){this._bSuppressScroll=false;if(this._iStoredScrollPosition){this._scrollTo(this._iStoredScrollPosition,0);}else{this._onScroll({target:{scrollTop:this._$opWrapper.scrollTop()}});}};m.prototype._addHoverClass=function(){var $=this.$();if($){$.addClass("sapUxAPObjectPageLayoutTitleForceHovered");}};m.prototype._removeHoverClass=function(){var $=this.$();if($){$.removeClass("sapUxAPObjectPageLayoutTitleForceHovered");}};m.prototype._getHeight=function(o){return!(o instanceof C)?0:o.$().outerHeight()||0;};m.prototype._getWidth=function(o){return!(o instanceof C)?0:o.$().outerWidth()||0;};m.prototype._getSectionInfoIsDirty=function(){return this.bSectionInfoIsDirty;};m.prototype._setSectionInfoIsDirty=function(o){this.bSectionInfoIsDirty=o;};m.prototype._getRootAriaLabelText=function(){var H=this.getHeaderTitle(),t=H?H.getTitleText():null,s;if(H&&t){s=m._getLibraryResourceBundle().getText("ROOT_ARIA_LABEL_WITH_TITLE")+" "+t;}else{s=m._getLibraryResourceBundle().getText("ROOT_ARIA_LABEL_WITHOUT_TITLE");}return s;};m.prototype._getDOMRefHeight=function(o){return o.parentElement?o.getBoundingClientRect().height:0;};m.prototype._updateRootAriaLabel=function(){var N=this._getRootAriaLabelText(),s=this.$().attr("aria-label");if(N!==s){this.$().attr("aria-label",N);}};function n(o){if(arguments.length===1){return Array.isArray(o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(p){return n(p);});}return m;});
