/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','./InputBase','./DateTimeField','sap/ui/core/date/UniversalDate','./library','sap/ui/core/Control','sap/ui/core/library',"./DatePickerRenderer","sap/base/util/deepEqual","sap/base/assert","sap/base/Log","sap/ui/core/IconPool","sap/ui/core/Popup","./InstanceManager","sap/ui/dom/jquery/cursorPos"],function(q,D,I,a,U,l,C,c,b,d,e,L,f,P,g){"use strict";var T=c.TextAlign;var h=c.CalendarType;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i;var j;var k=a.extend("sap.m.DatePicker",{metadata:{library:"sap.m",properties:{displayFormatType:{type:"string",group:"Appearance",defaultValue:""},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{specialDates:{type:"sap.ui.core.Element",multiple:true,singularName:"specialDate"}},associations:{legend:{type:"sap.ui.core.Control",multiple:false}},events:{navigate:{parameters:{dateRange:{type:"sap.ui.unified.DateRange"},afterPopupOpened:{type:"boolean"}}}},designtime:"sap/m/designtime/DatePicker.designtime",dnd:{draggable:false,droppable:true}}});k.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=false;this._bOnlyCalendar=true;this._bValid=true;this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,999);var y=this.addEndIcon({id:this.getId()+"-icon",src:this.getIconSrc(),noTabStop:true,tooltip:r.getText("OPEN_PICKER_TEXT")});this._bShouldClosePicker=false;y.addEventDelegate({onmousedown:function(E){this._bShouldClosePicker=!!this.isOpen();}},this);y.attachPress(function(){this.toggleOpen(this._bShouldClosePicker);},this);this._popupFollowOf=m.bind(this);};k.prototype.isValidValue=function(){return this._bValid;};k.prototype.isOpen=function(){return this._oPopup&&this._oPopup.isOpen();};k.prototype.toggleOpen=function(O){if(this.getEditable()&&this.getEnabled()){if(O){p.call(this);}else{_.call(this);}}};k.prototype.getIconSrc=function(){return f.getIconURI("appointment-2");};k.prototype.exit=function(){I.prototype.exit.apply(this,arguments);if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close();}delete this._oPopup;}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar;}if(this._iInvalidateCalendar){clearTimeout(this._iInvalidateCalendar);}this._sUsedDisplayPattern=undefined;this._sUsedDisplayCalendarType=undefined;this._oDisplayFormat=undefined;this._sUsedValuePattern=undefined;this._sUsedValueCalendarType=undefined;this._oValueFormat=undefined;};k.prototype.invalidate=function(O){if(!O||O!=this._oCalendar){C.prototype.invalidate.apply(this,arguments);this._iInvalidateCalendar=setTimeout(x.bind(this),0);}};k.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this._checkMinMaxDate();var V=this._getValueHelpIcon();if(V){V.setProperty("visible",this.getEditable(),true);}};k.prototype.setWidth=function(W){return I.prototype.setWidth.call(this,W||"100%");};k.prototype.getWidth=function(W){return this.getProperty("width")||"100%";};k.prototype.applyFocusInfo=function(F){this._bFocusNoPopup=true;I.prototype.applyFocusInfo.apply(this,arguments);};k.prototype.onfocusin=function(E){if(!q(E.target).hasClass("sapUiIcon")){I.prototype.onfocusin.apply(this,arguments);}this._bFocusNoPopup=undefined;};k.prototype.onsapshow=function(E){this.toggleOpen(this.isOpen());E.preventDefault();};k.prototype.onsaphide=k.prototype.onsapshow;k.prototype.onsappageup=function(E){s.call(this,1,"day");E.preventDefault();};k.prototype.onsappageupmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){s.call(this,1,"month");}else{s.call(this,1,"year");}E.preventDefault();};k.prototype.onsappagedown=function(E){s.call(this,-1,"day");E.preventDefault();};k.prototype.onsappagedownmodifiers=function(E){if(!E.ctrlKey&&E.shiftKey){s.call(this,-1,"month");}else{s.call(this,-1,"year");}E.preventDefault();};k.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var F=this._getFormatter(true);var y=String.fromCharCode(E.charCode);if(y&&F.sAllowedCharacters&&F.sAllowedCharacters.indexOf(y)<0){E.preventDefault();}};k.prototype._getValueHelpIcon=function(){var V=this.getAggregation("_endIcon");return V&&V[0];};k.prototype._dateValidation=function(y){this._bValid=true;if(y&&(y.getTime()<this._oMinDate.getTime()||y.getTime()>this._oMaxDate.getTime())){this._bValid=false;e(this._bValid,"Date must be in valid range");}this.setProperty("dateValue",y);return y;};k.prototype.setMinDate=function(y){if(this._isValidDate(y)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMinDate(),y)){return this;}if(y){var Y=y.getFullYear();if(Y<1||Y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMinDate=new Date(y.getTime());var z=this.getDateValue();if(z&&z.getTime()<y.getTime()){this._bValid=false;L.warning("DateValue not in valid date range",this);}}else{this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);}this.setProperty("minDate",y);if(this._oCalendar){this._oCalendar.setMinDate(y);}this._oMinDate.setHours(0,0,0,0);return this;};k.prototype.setMaxDate=function(y){if(this._isValidDate(y)){throw new Error("Date must be a JavaScript date object; "+this);}if(d(this.getMaxDate(),y)){return this;}if(y){var Y=y.getFullYear();if(Y<1||Y>9999){throw new Error("Date must be between 0001-01-01 and 9999-12-31; "+this);}this._oMaxDate=new Date(y.getTime());var z=this.getDateValue();if(z&&z.getTime()>y.getTime()){this._bValid=false;L.warning("DateValue not in valid date",this);}}else{this._oMaxDate=new Date(9999,11,31,23,59,59,999);}this.setProperty("maxDate",y);if(this._oCalendar){this._oCalendar.setMaxDate(y);}this._oMaxDate.setHours(23,59,59,999);return this;};k.prototype._checkMinMaxDate=function(){if(this._oMinDate.getTime()>this._oMaxDate.getTime()){L.warning("minDate > MaxDate -> dates switched",this);var M=new Date(this._oMinDate.getTime());var y=new Date(this._oMaxDate.getTime());this._oMinDate=new Date(y.getTime());this._oMaxDate=new Date(M.getTime());this.setProperty("minDate",y,true);this.setProperty("maxDate",M,true);if(this._oCalendar){this._oCalendar.setMinDate(y);this._oCalendar.setMaxDate(M);}}var z=this.getDateValue();if(z&&(z.getTime()<this._oMinDate.getTime()||z.getTime()>this._oMaxDate.getTime())){this._bValid=false;L.error("dateValue "+z.toString()+"(value="+this.getValue()+") does not match "+"min/max date range("+this._oMinDate.toString()+" - "+this._oMaxDate.toString()+"). App. "+"developers should take care to maintain dateValue/value accordingly.",this);}};k.prototype.getDisplayFormatType=function(){return this.getProperty("displayFormatType");};k.prototype._handleDateValidation=function(y){this._bValid=true;if(!y||y.getTime()<this._oMinDate.getTime()||y.getTime()>this._oMaxDate.getTime()){this._bValid=false;L.warning("Value can not be converted to a valid date",this);}this.setProperty("dateValue",y);};k.prototype.setDisplayFormatType=function(y){if(y){var F=false;for(var z in h){if(z==y){F=true;break;}}if(!F){throw new Error(y+" is not a valid calendar type"+this);}}this.setProperty("displayFormatType",y,true);this.setDisplayFormat(this.getDisplayFormat());return this;};k.prototype.setSecondaryCalendarType=function(y){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",y,true);if(this._oCalendar){this._oCalendar.setSecondaryCalendarType(y);}return this;};k.prototype.addSpecialDate=function(S){w.call(this,S);this.addAggregation("specialDates",S,true);x.call(this);return this;};k.prototype.insertSpecialDate=function(S,y){w.call(this,S);this.insertAggregation("specialDates",S,y,true);x.call(this);return this;};k.prototype.removeSpecialDate=function(S){var R=this.removeAggregation("specialDates",S,true);x.call(this);return R;};k.prototype.removeAllSpecialDates=function(){var R=this.removeAllAggregation("specialDates",true);x.call(this);return R;};k.prototype.destroySpecialDates=function(){this.destroyAggregation("specialDates",true);x.call(this);return this;};k.prototype.setLegend=function(y){this.setAssociation("legend",y,true);var z=this.getLegend();if(z){var A=sap.ui.require("sap/ui/unified/CalendarLegend");y=sap.ui.getCore().byId(z);if(y&&!(typeof A=="function"&&y instanceof A)){throw new Error(y+" is not an sap.ui.unified.CalendarLegend. "+this);}}if(this._oCalendar){this._oCalendar.setLegend(z);}return this;};k.prototype.onChange=function(E){if(!this.getEditable()||!this.getEnabled()){return;}var V=this._$input.val();var O=this._formatValue(this.getDateValue());if(V==O&&this._bValid){return;}var y;this._bValid=true;if(V!=""){y=this._parseValue(V,true);if(!y||y.getTime()<this._oMinDate.getTime()||y.getTime()>this._oMaxDate.getTime()){this._bValid=false;y=undefined;}else{V=this._formatValue(y);}}if(this.getDomRef()&&(this._$input.val()!==V)){this._$input.val(V);this._curpos=this._$input.cursorPos();}if(y){V=this._formatValue(y,true);}if(this._lastValue!==V||(y&&this.getDateValue()&&y.getFullYear()!==this.getDateValue().getFullYear())){this._lastValue=V;this.setProperty("value",V,true);var N=this.getValue();if(this._bValid&&V==N){this.setProperty("dateValue",y,true);}V=N;if(this.isOpen()){if(this._bValid){y=this.getDateValue();}this._oCalendar.focusDate(y);var S=this._oDateRange.getStartDate();if((!S&&y)||(S&&y&&S.getTime()!=y.getTime())){this._oDateRange.setStartDate(new Date(y.getTime()));}else if(S&&!y){this._oDateRange.setStartDate(undefined);}}this.fireChangeEvent(V,{valid:this._bValid});}};k.prototype._getInputValue=function(V){V=(typeof V=="undefined")?this._$input.val():V.toString();var y=this._parseValue(V,true);V=this._formatValue(y,true);return V;};k.prototype.updateDomValue=function(V){if(this.isActive()&&(this._$input.val()!==V)){this._bCheckDomValue=true;V=(typeof V=="undefined")?this._$input.val():V.toString();this._curpos=this._$input.cursorPos();var y=this._parseValue(V,true);V=this._formatValue(y);this._$input.val(V);this._$input.cursorPos(this._curpos);}return this;};k.prototype._storeInputSelection=function(y){if((D.browser.msie||D.browser.edge)&&!D.support.touch){this._oInputSelBeforePopupOpen={iStart:y.selectionStart,iEnd:y.selectionEnd};y.selectionStart=0;y.selectionEnd=0;}};k.prototype._restoreInputSelection=function(y){if((D.browser.msie||D.browser.edge)&&!D.support.touch){y.selectionStart=this._oInputSelBeforePopupOpen.iStart;y.selectionEnd=this._oInputSelBeforePopupOpen.iEnd;}};function _(){this._createPopup();this._createPopupContent();var y;var B=this.getBinding("value");if(B&&B.oType&&B.oType.oOutputFormat){y=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){y=B.oType.oFormat.oFormatOptions.calendarType;}if(!y){y=this.getDisplayFormatType();}if(y){this._oCalendar.setPrimaryCalendarType(y);}var V=this._bValid?this._formatValue(this.getDateValue()):this.getValue();if(V!=this._$input.val()){this.onChange();}this._fillDateRange();this._openPopup();this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar),afterPopupOpened:true});}k.prototype._createPopup=function(){if(!this._oPopup){this._oPopup=new P();this._oPopup.setAutoClose(true);this._oPopup.setDurations(0,0);this._oPopup.attachOpened(t,this);this._oPopup.attachClosed(u,this);}};k.prototype._openPopup=function(){if(!this._oPopup){return;}this._storeInputSelection(this._$input.get(0));this._oPopup.setAutoCloseAreas([this.getDomRef()]);var y=P.Dock;var A;if(this.getTextAlign()==T.End){A=y.EndBottom+"-4";this._oPopup.open(0,y.EndTop,A,this,null,"fit",this._popupFollowOf);}else{A=y.BeginBottom+"-4";this._oPopup.open(0,y.BeginTop,A,this,null,"fit",this._popupFollowOf);}};function m(y){var O=this.getDomRef();if(!O||!q(O).is(":visible")||!n(O)){this._oPopup.close();}else{this._oPopup._applyPosition(y.lastPosition);}}function n(y){var R;if(!y){return false;}if(y instanceof q){y=y.get(0);}R=y.getBoundingClientRect();return(R.top>=0&&R.left>=0&&R.bottom<=(window.innerHeight||document.documentElement.clientHeight)&&R.right<=(window.innerWidth||document.documentElement.clientWidth));}function o(){if(!i||!j){sap.ui.getCore().loadLibrary("sap.ui.unified");i=sap.ui.requireSync("sap/ui/unified/Calendar");j=sap.ui.requireSync("sap/ui/unified/DateRange");}}k.prototype._getVisibleDatesRange=function(y){var V=y._getVisibleDays();o();return new j({startDate:V[0].toLocalJSDate(),endDate:V[V.length-1].toLocalJSDate()});};k.prototype._createPopupContent=function(){if(!this._oCalendar){o();this._oCalendar=new i(this.getId()+"-cal",{intervalSelection:this._bIntervalSelection,minDate:this.getMinDate(),maxDate:this.getMaxDate(),legend:this.getLegend(),startDateChange:function(){this.fireNavigate({dateRange:this._getVisibleDatesRange(this._oCalendar)});}.bind(this)});this._oDateRange=new j();this._oCalendar.addSelectedDate(this._oDateRange);if(this.$().closest(".sapUiSizeCompact").length>0){this._oCalendar.addStyleClass("sapUiSizeCompact");}if(this._bSecondaryCalendarTypeSet){this._oCalendar.setSecondaryCalendarType(this.getSecondaryCalendarType());}if(this._bOnlyCalendar){this._oCalendar.attachSelect(this._selectDate,this);this._oCalendar.attachCancel(p,this);this._oCalendar.attachEvent("_renderMonth",v,this);this._oCalendar.setPopupMode(true);this._oCalendar.setParent(this,undefined,true);this._oPopup.setContent(this._oCalendar);}}};k.prototype._fillDateRange=function(){var y=this.getDateValue();if(y&&y.getTime()>=this._oMinDate.getTime()&&y.getTime()<=this._oMaxDate.getTime()){this._oCalendar.focusDate(new Date(y.getTime()));if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=y.getTime()){this._oDateRange.setStartDate(new Date(y.getTime()));}}else{var z=this.getInitialFocusedDateValue();var F=z?z:new Date();var M=this._oMaxDate.getTime();if(F.getTime()<this._oMinDate.getTime()||F.getTime()>M){F=this._oMinDate;}this._oCalendar.focusDate(F);if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}};k.prototype.getAccessibilityInfo=function(){var R=this.getRenderer();var y=I.prototype.getAccessibilityInfo.apply(this,arguments);var V=this.getValue()||"";if(this._bValid){var z=this.getDateValue();if(z){V=this._formatValue(z);}}y.type=r.getText("ACC_CTR_TYPE_DATEINPUT");y.description=[V,R.getLabelledByAnnouncement(this),R.getDescribedByAnnouncement(this)].join(" ").trim();return y;};k.prototype._selectDate=function(E){var y=this.getDateValue();var z=this._getSelectedDate();var V="";if(!d(z,y)){this.setDateValue(new Date(z.getTime()));V=this.getValue();this.fireChangeEvent(V,{valid:true});this._focusInput();}else if(!this._bValid){V=this._formatValue(z);if(V!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(V);this._lastValue=V;}V=this._formatValue(z,true);this.setProperty("value",V,true);this.fireChangeEvent(V,{valid:true});this._focusInput();}}else if(D.system.desktop||!D.support.touch){this.focus();}this._oPopup.close();};k.prototype._focusInput=function(){if(this.getDomRef()&&(D.system.desktop||!D.support.touch)){this._curpos=this._$input.val().length;this._$input.cursorPos(this._curpos);}return this;};k.prototype._getSelectedDate=function(){var S=this._oCalendar.getSelectedDates();var y;if(S.length>0){y=S[0].getStartDate();}return y;};function p(E){if(this.isOpen()){this._oPopup.close();if((D.system.desktop||!D.support.touch)){this.focus();}}}function s(N,y){var O=this.getDateValue();var z=this._$input.cursorPos();if(O&&this.getEditable()&&this.getEnabled()){var A;var B=this.getBinding("value");if(B&&B.oType&&B.oType.oOutputFormat){A=B.oType.oOutputFormat.oFormatOptions.calendarType;}else if(B&&B.oType&&B.oType.oFormat){A=B.oType.oFormat.oFormatOptions.calendarType;}if(!A){A=this.getDisplayFormatType();}var E=U.getInstance(new Date(O.getTime()),A);O=U.getInstance(new Date(O.getTime()),A);switch(y){case"day":E.setDate(E.getDate()+N);break;case"month":E.setMonth(E.getMonth()+N);var M=(O.getMonth()+N)%12;if(M<0){M=12+M;}while(E.getMonth()!=M){E.setDate(E.getDate()-1);}break;case"year":E.setFullYear(E.getFullYear()+N);while(E.getMonth()!=O.getMonth()){E.setDate(E.getDate()-1);}break;default:break;}if(E.getTime()<this._oMinDate.getTime()){E=new U(this._oMinDate.getTime());}else if(E.getTime()>this._oMaxDate.getTime()){E=new U(this._oMaxDate.getTime());}if(!d(this.getDateValue(),E.getJSDate())){this.setDateValue(new Date(E.getTime()));this._curpos=z;this._$input.cursorPos(this._curpos);var V=this.getValue();this.fireChangeEvent(V,{valid:true});}}}function t(E){this.addStyleClass(I.ICON_PRESSED_CSS_CLASS);this._renderedDays=this._oCalendar.$("-Month0-days").find(".sapUiCalItem").length;this.$("inner").attr("aria-owns",this.getId()+"-cal");this.$("inner").attr("aria-expanded",true);g.addPopoverInstance(this._oPopup);}function u(E){this.removeStyleClass(I.ICON_PRESSED_CSS_CLASS);this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));g.removePopoverInstance(this._oPopup);}function v(E){var y=E.getParameter("days");if(y>this._renderedDays){this._renderedDays=y;this._oPopup._applyPosition(this._oPopup._oLastPosition);}}function w(S){var y=sap.ui.require("sap/ui/unified/DateTypeRange");if(S&&!(y&&S instanceof y)){throw new Error(S+"is not valid for aggregation \"specialDates\" of "+this);}}function x(){if(this.isOpen()){this._oCalendar._bDateRangeChanged=true;this._oCalendar.invalidate();}}return k;});
