/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./InputBase','./Popover','sap/ui/core/Item','./ColumnListItem','./GroupHeaderListItem','./DisplayListItem','./StandardListItem','sap/ui/core/SeparatorItem','./List','./Table','./library','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/Control','./SuggestionsPopover','./Toolbar','./ToolbarSpacer','./Button',"sap/ui/dom/containsOrEquals","sap/base/assert","sap/base/util/deepEqual","./InputRenderer","sap/ui/thirdparty/jquery","sap/ui/dom/jquery/selectText"],function(I,P,a,C,G,D,S,b,L,T,l,c,d,e,f,g,h,B,j,k,m,n,q){"use strict";var o=l.ListType;var p=l.InputTextFormatMode;var r=l.InputType;var s=I.extend("sap.m.Input",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.InputType",group:"Data",defaultValue:r.Text},maxLength:{type:"int",group:"Behavior",defaultValue:0},dateFormat:{type:"string",group:"Misc",defaultValue:'YYYY-MM-dd',deprecated:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:false},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpOnly:{type:"boolean",group:"Behavior",defaultValue:false},filterSuggests:{type:"boolean",group:"Behavior",defaultValue:true},maxSuggestionWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},startSuggestion:{type:"int",group:"Behavior",defaultValue:1},showTableSuggestionValueHelp:{type:"boolean",group:"Behavior",defaultValue:true},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'50%'},valueLiveUpdate:{type:"boolean",group:"Behavior",defaultValue:false},selectedKey:{type:"string",group:"Data",defaultValue:""},textFormatMode:{type:"sap.m.InputTextFormatMode",group:"Misc",defaultValue:p.Value},textFormatter:{type:"any",group:"Misc",defaultValue:""},suggestionRowValidator:{type:"any",group:"Misc",defaultValue:""},enableSuggestionsHighlighting:{type:"boolean",group:"Behavior",defaultValue:true},autocomplete:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"suggestionItems",aggregations:{suggestionItems:{type:"sap.ui.core.Item",multiple:true,singularName:"suggestionItem"},suggestionColumns:{type:"sap.m.Column",multiple:true,singularName:"suggestionColumn",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"columns"}},suggestionRows:{type:"sap.m.ColumnListItem",altTypes:["sap.m.GroupHeaderListItem"],multiple:true,singularName:"suggestionRow",bindable:"bindable",forwarding:{getter:"_getSuggestionsTable",aggregation:"items"}},_suggestionPopup:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_valueHelpIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},selectedRow:{type:"sap.m.ColumnListItem",multiple:false}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},valueHelpRequest:{parameters:{fromSuggestions:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"},suggestionColumns:{type:"sap.m.ListBase"}}},suggestionItemSelected:{parameters:{selectedItem:{type:"sap.ui.core.Item"},selectedRow:{type:"sap.m.ColumnListItem"}}},submit:{parameters:{value:{type:"string"}}}},designtime:"sap/m/designtime/Input.designtime"}});c.insertFontFaceStyle();s.prototype.init=function(){I.prototype.init.call(this);this._fnFilter=f._DEFAULTFILTER;this._bUseDialog=d.system.phone;this._bFullScreen=d.system.phone;this._iSetCount=0;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");};s.prototype.exit=function(){I.prototype.exit.call(this);this._deregisterEvents();this.cancelPendingSuggest();if(this._iRefreshListTimeout){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=null;}if(this._oSuggPopover){this._oSuggPopover.destroy();this._oSuggPopover=null;}if(this._oShowMoreButton){this._oShowMoreButton.destroy();this._oShowMoreButton=null;}if(this._oButtonToolbar){this._oButtonToolbar.destroy();this._oButtonToolbar=null;}};s.prototype.onBeforeRendering=function(){var i=this.getSelectedKey(),t=this.getShowValueHelp()&&this.getEnabled()&&this.getEditable(),E=this.getAggregation("_endIcon")||[],u=E[0],v;I.prototype.onBeforeRendering.call(this);this._deregisterEvents();if(i){this.setSelectedKey(i);}if(this.getShowSuggestion()){if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton();}else{this._removeShowMoreButton();}v=this._oSuggPopover._oPopupInput;if(v){v.setType(this.getType());}}if(t){u=this._getValueHelpIcon();u.setProperty("visible",true,true);}else{if(u){u.setProperty("visible",false,true);}}};s.prototype.onAfterRendering=function(){I.prototype.onAfterRendering.call(this);if(this._oSuggPopover){this._oSuggPopover._resetTypeAhead();}if(this._bUseDialog&&this.getEditable()&&this.getEnabled()){this.$().on("click",q.proxy(function(E){if(this._onclick){this._onclick(E);}if(this.getShowSuggestion()&&this._oSuggPopover&&E.target.id!=this.getId()+"-vhi"){this._openSuggestionsPopover();}},this));}};s.prototype._getDisplayText=function(i){var t=this.getTextFormatter();if(t){return t(i);}var u=i.getText(),K=i.getKey(),v=this.getTextFormatMode();switch(v){case p.Key:return K;case p.ValueKey:return u+' ('+K+')';case p.KeyValue:return'('+K+') '+u;default:return u;}};s.prototype._onValueUpdated=function(i){if(this._bSelectingItem||i===this._sSelectedValue){return;}var K=this.getSelectedKey(),H;if(K===''){return;}if(this._hasTabularSuggestions()){H=this._oSuggPopover._oSuggestionTable&&!!this._oSuggPopover._oSuggestionTable.getSelectedItem();}else{H=this._oSuggPopover._oList&&!!this._oSuggPopover._oList.getSelectedItem();}if(H){return;}this.setProperty("selectedKey",'',true);this.setAssociation("selectedRow",null,true);this.setAssociation("selectedItem",null,true);this.fireSuggestionItemSelected({selectedItem:null,selectedRow:null});};s.prototype._updateSelectionFromList=function(){if(this._oSuggPopover._iPopupListSelectedIndex<0){return false;}var i=this._oSuggPopover._oList.getSelectedItem();if(i){if(this._hasTabularSuggestions()){this.setSelectionRow(i,true);}else{this.setSelectionItem(i._oItem,true);}}return true;};s.prototype.setSelectionItem=function(i,t){this._bSelectingItem=true;if(!i){this.setAssociation("selectedItem",null,true);this.setValue('');return;}var u=this._iSetCount,N;this.setAssociation("selectedItem",i,true);this.setProperty("selectedKey",i.getKey(),true);if(t){this.fireSuggestionItemSelected({selectedItem:i});}if(u!==this._iSetCount){N=this.getValue();}else{N=this._getDisplayText(i);}this._sSelectedValue=N;this.updateInputField(N);if(this.bIsDestroyed){return;}this._oSuggPopover._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput)){this._closeSuggestionPopup();}this._bSelectingItem=false;};s.prototype.addSuggestionRowGroup=function(i,H,t){H=H||new G({title:i.text||i.key});this.addAggregation("suggestionRows",H,t);return H;};s.prototype.addSuggestionItemGroup=function(i,H,t){H=H||new b({text:i.text||i.key});this.addAggregation("suggestionItems",H,t);return H;};s.prototype.setSelectedItem=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof a)){return this;}this.setSelectionItem(i);return this;};s.prototype.setSelectedKey=function(K){K=this.validateProperty("selectedKey",K);this.setProperty("selectedKey",K,true);if(this._hasTabularSuggestions()){return this;}if(!K){this.setSelectionItem();return this;}var i=this.getSuggestionItemByKey(K);this.setSelectionItem(i);return this;};s.prototype.getSuggestionItemByKey=function(K){var t=this.getSuggestionItems()||[],u,i;for(i=0;i<t.length;i++){u=t[i];if(u.getKey()===K){return u;}}};s.prototype.setSelectionRow=function(i,t){if(!i){this.setAssociation("selectedRow",null,true);return;}this._bSelectingItem=true;var u,v=this.getSuggestionRowValidator();if(v){u=v(i);if(!(u instanceof a)){u=null;}}var w=this._iSetCount,K="",N;this.setAssociation("selectedRow",i,true);if(u){K=u.getKey();}this.setProperty("selectedKey",K,true);if(t){this.fireSuggestionItemSelected({selectedRow:i});}if(w!==this._iSetCount){N=this.getValue();}else{if(u){N=this._getDisplayText(u);}else{N=this._fnRowResultFilter?this._fnRowResultFilter(i):f._DEFAULTRESULT_TABULAR(i);}}this._sSelectedValue=N;this.updateInputField(N);if(this.bIsDestroyed){return;}this._oSuggPopover._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}this._bSelectingItem=false;};s.prototype.setSelectedRow=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof C)){return this;}this.setSelectionRow(i);return this;};s.prototype._getValueHelpIcon=function(){var t=this,E=this.getAggregation("_endIcon")||[],v=E[0];if(!v){v=this.addEndIcon({id:this.getId()+"-vhi",src:c.getIconURI("value-help"),useIconTooltip:false,noTabStop:true,press:function(i){if(!t.getValueHelpOnly()){var u=this.getParent(),$;if(d.support.touch){$=u.$('inner');$.attr('readonly','readonly');u.focus();$.removeAttr('readonly');}else{u.focus();}t.bValueHelpRequested=true;t.fireValueHelpRequest({fromSuggestions:false});}}});}return v;};s.prototype._fireValueHelpRequestForValueHelpOnly=function(){if(this.getEnabled()&&this.getEditable()&&this.getShowValueHelp()&&this.getValueHelpOnly()){if(d.system.phone){this.focus();}this.fireValueHelpRequest({fromSuggestions:false});}};s.prototype.ontap=function(E){I.prototype.ontap.call(this,E);this._fireValueHelpRequestForValueHelpOnly();};s.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};s.prototype.getWidth=function(){return this.getProperty("width")||"100%";};s.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this._fnFilter=f._DEFAULTFILTER;return this;}k(typeof(F)==="function","Input.setFilterFunction: first argument fnFilter must be a function on "+this);this._fnFilter=F;return this;};s.prototype.setRowResultFunction=function(F){var i;if(F===null||F===undefined){this._fnRowResultFilter=f._DEFAULTRESULT_TABULAR;return this;}k(typeof(F)==="function","Input.setRowResultFunction: first argument fnFilter must be a function on "+this);this._fnRowResultFilter=F;i=this.getSelectedRow();if(i){this.setSelectedRow(i);}return this;};s.prototype.closeSuggestions=function(){this._closeSuggestionPopup();};s.prototype._doSelect=function(i,E){if(d.support.touch){return;}var t=this._$input[0];if(t){var R=this._$input;t.focus();R.selectText(i?i:0,E?E:R.val().length);}return this;};s.prototype._isIncrementalType=function(){var t=this.getType();if(t==="Number"||t==="Date"||t==="Datetime"||t==="Month"||t==="Time"||t==="Week"){return true;}return false;};s.prototype.onsapescape=function(E){var i;if(this._isSuggestionsPopoverOpen()){E.originalEvent._sapui_handledByControl=true;this._oSuggPopover._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();if(this._sBeforeSuggest!==undefined){if(this._sBeforeSuggest!==this.getValue()){i=this._lastValue;this.setValue(this._sBeforeSuggest);this._lastValue=i;}this._sBeforeSuggest=undefined;}return;}if(this.getValueLiveUpdate()){this.setProperty("value",this._lastValue,true);}if(I.prototype.onsapescape){I.prototype.onsapescape.apply(this,arguments);}};s.prototype.onsapenter=function(E){this.cancelPendingSuggest();if(this._isSuggestionsPopoverOpen()){if(!this._updateSelectionFromList()){this._closeSuggestionPopup();}}if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}if(this.getEnabled()&&this.getEditable()&&!(this.getValueHelpOnly()&&this.getShowValueHelp())){this.fireSubmit({value:this.getValue()});}};s.prototype.onsapfocusleave=function(E){var i=this._oSuggPopover,t=i&&i._oPopover,F=E.relatedControlId&&sap.ui.getCore().byId(E.relatedControlId),u=F&&F.getFocusDomRef(),H=i&&i._sProposedItemText&&this.getAutocomplete(),v=t&&u&&j(t.getDomRef(),u);if(t instanceof P){if(v){this._bPopupHasFocus=true;if(d.system.desktop&&m(t.getFocusDomRef(),u)){this.focus();}}else{if(this.getDOMValue()===this._sSelectedSuggViaKeyboard){this._sSelectedSuggViaKeyboard=null;}}}if(!v&&!H){I.prototype.onsapfocusleave.apply(this,arguments);}this.bValueHelpRequested=false;};s.prototype.onmousedown=function(E){var i=this._oSuggPopover&&this._oSuggPopover._oPopover;if((i instanceof P)&&i.isOpen()){E.stopPropagation();}};s.prototype._deregisterEvents=function(){if(this._oSuggPopover){this._oSuggPopover._deregisterResize();}if(this._bUseDialog&&this._oSuggPopover&&this._oSuggPopover._oPopover){this.$().off("click");}};s.prototype.updateSuggestionItems=function(){this._bSuspendInvalidate=true;this.updateAggregation("suggestionItems");this._synchronizeSuggestions();this._bSuspendInvalidate=false;return this;};s.prototype.invalidate=function(){if(!this._bSuspendInvalidate){e.prototype.invalidate.apply(this,arguments);}};s.prototype.cancelPendingSuggest=function(){if(this._iSuggestDelay){clearTimeout(this._iSuggestDelay);this._iSuggestDelay=null;}};s.prototype._triggerSuggest=function(v){this.cancelPendingSuggest();this._bShouldRefreshListItems=true;if(!v){v="";}if(v.length>=this.getStartSuggestion()){this._iSuggestDelay=setTimeout(function(){if(this._sPrevSuggValue!==v){this._bBindingUpdated=false;this.fireSuggest({suggestValue:v});if(!this._bBindingUpdated){this._refreshItemsDelayed();}this._sPrevSuggValue=v;}}.bind(this),300);}else if(this._bUseDialog){if(this._oSuggPopover._oList instanceof T){this._oSuggPopover._oList.addStyleClass("sapMInputSuggestionTableHidden");}else if(this._oSuggPopover._oList&&this._oSuggPopover._oList.destroyItems){this._oSuggPopover._oList.destroyItems();}}else if(this._isSuggestionsPopoverOpen()){setTimeout(function(){var N=this.getDOMValue()||'';if(N<this.getStartSuggestion()){this._oSuggPopover._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}}.bind(this),0);}};(function(){s.prototype.setShowSuggestion=function(v){this.setProperty("showSuggestion",v,true);if(v){this._oSuggPopover=this._getSuggestionsPopover();this._oSuggPopover._iPopupListSelectedIndex=-1;}else{if(this._oSuggPopover){this._oSuggPopover._destroySuggestionPopup();this._oSuggPopover._iPopupListSelectedIndex=-1;}}return this;};s.prototype.setShowTableSuggestionValueHelp=function(v){this.setProperty("showTableSuggestionValueHelp",v,true);if(!(this._oSuggPopover&&this._oSuggPopover._oPopover)){return this;}if(v){this._addShowMoreButton();}else{this._removeShowMoreButton();}return this;};s.prototype.oninput=function(E){I.prototype.oninput.call(this,E);if(E.isMarked("invalid")){return;}var v=this.getDOMValue();if(this.getValueLiveUpdate()){this.setProperty("value",v,true);this._onValueUpdated(v);}this.fireLiveChange({value:v,newValue:v});if(this.getShowSuggestion()&&!this._bUseDialog){this._triggerSuggest(v);}};s.prototype.getValue=function(){return this.getDomRef("inner")&&this._$input?this.getDOMValue():this.getProperty("value");};s.prototype._refreshItemsDelayed=function(){clearTimeout(this._iRefreshListTimeout);this._iRefreshListTimeout=setTimeout(function(){if(this._oSuggPopover){this._refreshListItems();}}.bind(this),0);};s.prototype._filterListItems=function(t,u){var i,v,w,x=[],H=[],F=this.getFilterSuggests();for(i=0;i<t.length;i++){w=t[i];if(t[i].isA("sap.ui.core.SeparatorItem")){v=new G({id:w.getId()+"-ghli",title:t[i].getText()});x.push({header:v,visible:false});this._configureListItem(w,v);H.push(v);}else if(!F||this._fnFilter(u,w)){if(t[i].isA("sap.ui.core.ListItem")){v=new D(w.getId()+"-dli");v.setLabel(w.getText());v.setValue(w.getAdditionalText());}else{v=new S(w.getId()+"-sli");v.setTitle(w.getText());}if(x.length){x[x.length-1].visible=true;}this._configureListItem(w,v);H.push(v);}}x.forEach(function(y){y.header.setVisible(y.visible);});return{hitItems:H,groups:x};};s.prototype._filterTabularItems=function(t,u){var i,v,F=this.getFilterSuggests(),H=[],w=[];for(i=0;i<t.length;i++){if(t[i].isA("sap.m.GroupHeaderListItem")){w.push({header:t[i],visible:false});}else{v=!F||this._fnFilter(u,t[i]);t[i].setVisible(v);v&&H.push(t[i]);if(w.length&&v){w[w.length-1].visible=true;}}}w.forEach(function(x){x.header.setVisible(x.visible);});this._getSuggestionsTable().invalidate();return{hitItems:H,groups:w};};s.prototype._clearSuggestionPopupItems=function(){if(!this._oSuggPopover._oList){return;}if(this._oSuggPopover._oList instanceof T){this._oSuggPopover._oList.removeSelections(true);}else{this._oSuggPopover._oList.destroyItems();}};s.prototype._hideSuggestionPopup=function(){var i=this._oSuggPopover._oPopover;if(!this._bUseDialog){if(i.isOpen()){this._sCloseTimer=setTimeout(function(){this._oSuggPopover._iPopupListSelectedIndex=-1;this.cancelPendingSuggest();if(this._oSuggPopover._sTypedInValue){this.setDOMValue(this._oSuggPopover._sTypedInValue);}this._oSuggPopover._oProposedItem=null;i.close();}.bind(this),0);}}else if(this._hasTabularSuggestions()&&this._oSuggPopover._oList){this._oSuggPopover._oList.addStyleClass("sapMInputSuggestionTableHidden");}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-haspopup");this.$("inner").removeAttr("aria-activedescendant");};s.prototype._openSuggestionPopup=function(O){var i=this._oSuggPopover._oPopover;if(!this._bUseDialog){if(this._sCloseTimer){clearTimeout(this._sCloseTimer);this._sCloseTimer=null;}if(!i.isOpen()&&!this._sOpenTimer&&O!==false){this._sOpenTimer=setTimeout(function(){this._sOpenTimer=null;this._openSuggestionsPopover();}.bind(this),0);}}this.$("inner").attr("aria-haspopup","true");};s.prototype._getFilteredSuggestionItems=function(t){var F,i=this.getSuggestionItems(),u=this.getSuggestionRows();if(this._hasTabularSuggestions()){if(this._bUseDialog&&this._oSuggPopover._oList){this._oSuggPopover._oList.removeStyleClass("sapMInputSuggestionTableHidden");}F=this._filterTabularItems(u,t);}else{F=this._filterListItems(i,t);}return F;};s.prototype._fillSimpleSuggestionPopupItems=function(F){var i,H=F.hitItems,t=F.groups,u=H.length,v=u;if(!this._hasTabularSuggestions()){for(i=0;i<u;i++){this._oSuggPopover._oList.addItem(H[i]);}v-=t.length;}return v;};s.prototype._applySuggestionAcc=function(N){var A="",R=this._oRb;if(N===1){A=R.getText("INPUT_SUGGESTIONS_ONE_HIT");}else if(N>1){A=R.getText("INPUT_SUGGESTIONS_MORE_HITS",N);}else{A=R.getText("INPUT_SUGGESTIONS_NO_HIT");}this.$("SuggDescr").text(A);};s.prototype._refreshListItems=function(){var i=this.getShowSuggestion(),t=this._oSuggPopover._sTypedInValue||this.getDOMValue()||"",F,u;this._oSuggPopover._iPopupListSelectedIndex=-1;if(!i||!this._bShouldRefreshListItems||!this.getDomRef()||(!this._bUseDialog&&!this.$().hasClass("sapMInputFocused"))){return null;}this._clearSuggestionPopupItems();if(t.length<this.getStartSuggestion()){this._hideSuggestionPopup();return false;}F=this._getFilteredSuggestionItems(t);u=this._fillSimpleSuggestionPopupItems(F);if(u>0){this._openSuggestionPopup(this.getValue().length>=this.getStartSuggestion());}else{this._hideSuggestionPopup();}this._applySuggestionAcc(u);};s.prototype._configureListItem=function(i,t){var u=o.Active;if(!i.getEnabled()||t.isA("sap.m.GroupHeaderListItem")){u=o.Inactive;}t.setType(u);t._oItem=i;t.addEventDelegate({ontouchstart:function(E){(E.originalEvent||E)._sapui_cancelAutoClose=true;}});return t;};s.prototype.addSuggestionItem=function(i){this.addAggregation("suggestionItems",i,true);if(!this._oSuggPopover){this._getSuggestionsPopover();}this._synchronizeSuggestions();this._createSuggestionPopupContent();return this;};s.prototype.insertSuggestionItem=function(i,t){this.insertAggregation("suggestionItems",t,i,true);if(!this._oSuggPopover){this._getSuggestionsPopover();}this._synchronizeSuggestions();this._createSuggestionPopupContent();return this;};s.prototype.removeSuggestionItem=function(i){var t=this.removeAggregation("suggestionItems",i,true);this._synchronizeSuggestions();return t;};s.prototype.removeAllSuggestionItems=function(){var i=this.removeAllAggregation("suggestionItems",true);this._synchronizeSuggestions();return i;};s.prototype.destroySuggestionItems=function(){this.destroyAggregation("suggestionItems",true);this._synchronizeSuggestions();return this;};s.prototype.addSuggestionRow=function(i){i.setType(o.Active);this.addAggregation("suggestionRows",i);this._synchronizeSuggestions();this._createSuggestionPopupContent();return this;};s.prototype.insertSuggestionRow=function(i,t){i.setType(o.Active);this.insertAggregation("suggestionRows",i,t);this._synchronizeSuggestions();this._createSuggestionPopupContent();return this;};s.prototype.removeSuggestionRow=function(i){var t=this.removeAggregation("suggestionRows",i);this._synchronizeSuggestions();return t;};s.prototype.removeAllSuggestionRows=function(){var i=this.removeAllAggregation("suggestionRows");this._synchronizeSuggestions();return i;};s.prototype.destroySuggestionRows=function(){this.destroyAggregation("suggestionRows");this._synchronizeSuggestions();return this;};s.prototype.bindAggregation=function(){if(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns"||arguments[0]==="suggestionItems"){this._createSuggestionPopupContent(arguments[0]==="suggestionRows"||arguments[0]==="suggestionColumns");this._bBindingUpdated=true;}return I.prototype.bindAggregation.apply(this,arguments);};s.prototype._closeSuggestionPopup=function(){if(this._oSuggPopover){this._bShouldRefreshListItems=false;this.cancelPendingSuggest();this._oSuggPopover._oPopover.close();if(!this._bUseDialog&&this.$().hasClass("sapMInputFocused")){this.openValueStateMessage();}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-haspopup");this.$("inner").removeAttr("aria-activedescendant");this._sPrevSuggValue=null;}};s.prototype._synchronizeSuggestions=function(){this._bShouldRefreshListItems=true;this._refreshItemsDelayed();if(!this.getDomRef()||this._isSuggestionsPopoverOpen()){return;}this._synchronizeSelection();};s.prototype._synchronizeSelection=function(){var i=this.getSelectedKey();if(!i){return;}if(this.getValue()&&!this.getSelectedItem()&&!this.getSelectedRow()){return;}this.setSelectedKey(i);};})();s.prototype.onfocusin=function(E){I.prototype.onfocusin.apply(this,arguments);this.$().addClass("sapMInputFocused");if(!this._bUseDialog&&this._isSuggestionsPopoverOpen()){this.closeValueStateMessage();}if(!this._bPopupHasFocus&&!this.getStartSuggestion()&&!this.getValue()){this._triggerSuggest(this.getValue());}this._bPopupHasFocus=undefined;this._sPrevSuggValue=null;};s.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()||!this.getShowValueHelp()){return;}this.bValueHelpRequested=true;this.fireValueHelpRequest({fromSuggestions:false});E.preventDefault();E.stopPropagation();};s.prototype.onsaphide=s.prototype.onsapshow;s.prototype.onsapselect=function(E){this._fireValueHelpRequestForValueHelpOnly();};s.prototype.onfocusout=function(E){I.prototype.onfocusout.apply(this,arguments);this.$().removeClass("sapMInputFocused");this.closeValueStateMessage(this);};s.prototype._hasTabularSuggestions=function(){return!!(this.getAggregation("suggestionColumns")&&this.getAggregation("suggestionColumns").length);};s.prototype._getSuggestionsTable=function(){return this._getSuggestionsPopover()._getSuggestionsTable();};s.prototype.clone=function(){var i=e.prototype.clone.apply(this,arguments),t;t=this.getBindingInfo("suggestionColumns");if(t){i.bindAggregation("suggestionColumns",q.extend({},t));}t=this.getBindingInfo("suggestionRows");if(t){i.bindAggregation("suggestionRows",q.extend({},t));}i.setRowResultFunction(this._fnRowResultFilter);i.setValue(this.getValue());return i;};s.prototype.setValue=function(v){this._iSetCount++;I.prototype.setValue.call(this,v);this._onValueUpdated(v);return this;};s.prototype.setDOMValue=function(v){this._$input.val(v);};s.prototype.getDOMValue=function(){return this._$input.val();};s.prototype.updateInputField=function(N){if(this._isSuggestionsPopoverOpen()&&this._bUseDialog){this._oSuggPopover._oPopupInput.setValue(N);this._oSuggPopover._oPopupInput._doSelect();}else{N=this._getInputValue(N);this.setDOMValue(N);this.onChange(null,null,N);}};s.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.description=((i.description||"")+" "+this.getDescription()).trim();return i;};s.prototype.preventChangeOnFocusLeave=function(E){return this.bFocusoutDueRendering||this.bValueHelpRequested;};s.prototype._getShowMoreButton=function(){return this._oShowMoreButton||(this._oShowMoreButton=new B({text:this._oRb.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:function(){if(this.getShowTableSuggestionValueHelp()){this.fireValueHelpRequest({fromSuggestions:true});this._oSuggPopover._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}}.bind(this)}));};s.prototype._addShowMoreButton=function(t){var i=this._oSuggPopover&&this._oSuggPopover._oPopover;if(!i||!t&&!this._hasTabularSuggestions()){return;}if(i.isA("sap.m.Dialog")){var u=this._getShowMoreButton();i.setEndButton(u);}else{var v=this._getButtonToolbar();i.setFooter(v);}};s.prototype._removeShowMoreButton=function(){var i=this._oSuggPopover&&this._oSuggPopover._oPopover;if(!i||!this._hasTabularSuggestions()){return;}if(i.isA("sap.m.Dialog")){i.setEndButton(null);}else{i.setFooter(null);}};s.prototype._getButtonToolbar=function(){var i=this._getShowMoreButton();return this._oButtonToolbar||(this._oButtonToolbar=new g({content:[new h(),i]}));};s.prototype._hasShowSelectedButton=function(){return false;};s.prototype._createSuggestionPopupContent=function(t){if(this._bIsBeingDestroyed||this._getSuggestionsPopover()._oList){return;}this._oSuggPopover._createSuggestionPopupContent(t,this._hasTabularSuggestions());if(!this._hasTabularSuggestions()&&!t){this._oSuggPopover._oList.attachItemPress(function(E){if(d.system.desktop){this.focus();}var i=E.getParameter("listItem");if(!i.isA("sap.m.GroupHeaderListItem")){this._oSuggPopover._bSuggestionItemTapped=true;this.setSelectionItem(i._oItem,true);}},this);}else{if(this._fnFilter===f._DEFAULTFILTER){this._fnFilter=f._DEFAULTFILTER_TABULAR;}if(!this._fnRowResultFilter){this._fnRowResultFilter=f._DEFAULTRESULT_TABULAR;}if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton(t);}}};s.prototype._createPopupInput=function(){var i=new s(this.getId()+"-popup-input",{width:"100%",valueLiveUpdate:true,showValueStateMessage:false,valueState:this.getValueState(),showValueHelp:this.getShowValueHelp(),valueHelpRequest:function(E){this.fireValueHelpRequest({fromSuggestions:true});this._oSuggPopover._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}.bind(this),liveChange:function(E){var v=E.getParameter("newValue");this.setDOMValue(this._getInputValue(this._oSuggPopover._oPopupInput.getValue()));this._triggerSuggest(v);this.fireLiveChange({value:v,newValue:v});}.bind(this)});return i;};s.prototype._modifyPopupInput=function(i){i.addEventDelegate({onsapenter:function(){if(this.getAutocomplete()){this._oSuggPopover._finalizeAutocomplete();}this._closeSuggestionPopup();}},this);return i;};s.prototype.forwardEventHandlersToSuggPopover=function(i){i.setOkPressHandler(this._closeSuggestionPopup.bind(this));i.setCancelPressHandler(this._closeSuggestionPopup.bind(this));};s.prototype._getSuggestionsPopover=function(){if(!this._oSuggPopover){var i=this._oSuggPopover=new f(this);if(this._bUseDialog){var t=this._createPopupInput();i._oPopupInput=this._modifyPopupInput(t);}this._oSuggPopover.setInputLabels(this.getLabels.bind(this));i._createSuggestionPopup({showSelectedButton:this._hasShowSelectedButton()});this.forwardEventHandlersToSuggPopover(i);var u=i._oPopover;this._updateSuggestionsPopoverValueState();i._bAutocompleteEnabled=this.getAutocomplete();i.attachEvent(f.M_EVENTS.SELECTION_CHANGE,function(E){var N=E.getParameter("newValue");this.setDOMValue(N);this._sSelectedSuggViaKeyboard=N;this._doSelect();},this);if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton();}if(this._bUseDialog){u.attachBeforeClose(function(){this.setDOMValue(this._getInputValue(i._oPopupInput.getValue()));this.onChange();if(this instanceof sap.m.MultiInput&&this._bUseDialog){this._onDialogClose();}},this).attachAfterClose(function(){var v=i._oList;if(!v){return;}if(T&&!(v instanceof T)){v.destroyItems();}else{v.removeSelections(true);}}).attachAfterOpen(function(){this._triggerSuggest(this.getValue());this._refreshListItems();},this).attachBeforeOpen(function(){i._oPopupInput.setPlaceholder(this.getPlaceholder());i._oPopupInput.setMaxLength(this.getMaxLength());i._oPopupInput.setValue(this.getValue());},this);}else{u.attachAfterClose(function(){this._updateSelectionFromList();var v=i._oList;if(v instanceof T){v.removeSelections(true);}else{v.destroyItems();}i._deregisterResize();},this).attachBeforeOpen(function(){i._sPopoverContentWidth=this.getMaxSuggestionWidth();i._bEnableHighlighting=this.getEnableSuggestionsHighlighting();i._bAutocompleteEnabled=this.getAutocomplete();i._bIsInputIncrementalType=this._isIncrementalType();this._sBeforeSuggest=this.getValue();i._resizePopup();i._registerResize();},this);}this.setAggregation("_suggestionPopup",u);this._oSuggestionPopup=u;}return this._oSuggPopover;};s.prototype.showItems=function(F){var i,t,u=this._fnFilter;if(!this.getEnabled()||!this.getEditable()){return;}this.setFilterFunction(F||function(){return true;});this._clearSuggestionPopupItems();i=this._getFilteredSuggestionItems(this.getDOMValue());t=this._fillSimpleSuggestionPopupItems(i);if(t>0){this._openSuggestionPopup();}else{this._hideSuggestionPopup();}this._applySuggestionAcc(t);this.setFilterFunction(u);};s.prototype.shouldValueStateMessageBeOpened=function(){var i=I.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);if(!i||this._isSuggestionsPopoverOpen()){return false;}return true;};s.prototype._isSuggestionsPopoverOpen=function(){return this._oSuggPopover&&this._oSuggPopover.isOpen();};s.prototype._openSuggestionsPopover=function(){this.closeValueStateMessage();this._updateSuggestionsPopoverValueState();this._oSuggPopover._oPopover.open();};s.prototype._updateSuggestionsPopoverValueState=function(){var i=this._oSuggPopover,v=this.getValueState();if(i){i.updateValueState(v,this.getValueStateText(),this.getShowValueStateMessage());if(this._bUseDialog){i._oPopupInput.setValueState(v);}}};s.prototype.setShowValueHelp=function(i){this.setProperty("showValueHelp",i);if(this._oSuggPopover&&this._oSuggPopover._oPopupInput){this._oSuggPopover._oPopupInput.setShowValueHelp(i);}return this;};s.prototype.setValueState=function(v){I.prototype.setValueState.apply(this,arguments);this._updateSuggestionsPopoverValueState();return this;};s.prototype.setValueStateText=function(v){I.prototype.setValueStateText.apply(this,arguments);this._updateSuggestionsPopoverValueState();return this;};s.prototype.setShowValueStateMessage=function(i){I.prototype.setShowValueStateMessage.apply(this,arguments);this._updateSuggestionsPopoverValueState();return this;};return s;});
