/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Control','./library','./Toolbar','./AssociativeOverflowToolbar','./Button','./AccButton','./Title','./ToolbarSpacer','./SegmentedButton','sap/ui/unified/Calendar','sap/ui/unified/calendar/CalendarDate','sap/ui/core/format/DateFormat','sap/ui/core/Popup','sap/ui/core/IconPool','sap/ui/core/InvisibleText',"./PlanningCalendarHeaderRenderer"],function(C,l,T,A,B,a,b,c,S,d,e,D,P,I,f,g){"use strict";var h=l.ToolbarDesign;var j=C.extend("sap.m.PlanningCalendarHeader",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Appearance",defaultValue:""},startDate:{type:"object",group:"Data"},pickerText:{type:"string",group:"Data"}},aggregations:{actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},_actionsToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_navigationToolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},_calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}},events:{pressPrevious:{},pressToday:{},pressNext:{},dateSelect:{},cancel:{}}}});var R=3;j.prototype.init=function(){var o=this.getId(),n=o+"-NavToolbar",r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),p,N,i;this.setAggregation("_actionsToolbar",new A(o+"-ActionsToolbar",{design:h.Transparent}).addStyleClass("sapMPCHeadActionsToolbar").addContent(this._getOrCreateTitleControl()).addContent(this._getOrCreateToolbarSpacer()).addContent(this._getOrCreateViewSwitch()));p=new B(n+"-PrevBtn",{icon:I.getIconURI('slim-arrow-left'),tooltip:r.getText("PCH_NAVIGATE_BACKWARDS"),press:function(){this.firePressPrevious();}.bind(this)});this._oTodayBtn=new B(n+"-TodayBtn",{text:r.getText("PLANNINGCALENDAR_TODAY"),ariaLabelledBy:f.getStaticId("sap.m","PCH_NAVIGATE_TO_TODAY"),press:function(){this.firePressToday();}.bind(this)});N=new B(n+"-NextBtn",{icon:I.getIconURI('slim-arrow-right'),tooltip:r.getText("PCH_NAVIGATE_FORWARD"),press:function(){this.firePressNext();}.bind(this)});i=new d(o+"-Cal",{ariaLabelledBy:f.getStaticId("sap.ui.unified","CALENDAR_DIALOG")});i.attachEvent("select",this._handlePickerDateSelect,this);i.attachEvent("cancel",function(E){var k=this._oPickerBtn.getDomRef();this.fireCancel();k&&k.focus();},this);this.setAggregation("_calendarPicker",i);this._oPickerBtn=new a(n+"-PickerBtn",{text:this.getPickerText(),ariaHaspopup:"dialog",ariaLabelledBy:f.getStaticId("sap.m","PCH_SELECT_RANGE"),press:function(){var k=this.getStartDate()||new Date();i.displayDate(k);this._openCalendarPickerPopup(i);}.bind(this)});this.setAggregation("_navigationToolbar",new T(n,{design:h.Transparent,content:[p,this._oTodayBtn,N,this._oPickerBtn]}).addStyleClass("sapMPCHeadNavToolbar"));};j.prototype.exit=function(){if(this._oTitle){this._getActionsToolbar().removeContent(this._oTitle);this._oTitle.destroy();this._oTitle=null;}if(this._oToolbarSpacer){this._getActionsToolbar().removeContent(this._oToolbarSpacer);this._oToolbarSpacer.destroy();this._oToolbarSpacer=null;}if(this._oViewSwitch){this._getActionsToolbar().removeContent(this._oViewSwitch);this._oViewSwitch.destroy();this._oViewSwitch=null;}if(this._oPopup){this._oPopup.destroy();this._oPopup=null;}};j.prototype.onBeforeRendering=function(){var v=!!this.getActions().length||!!this.getTitle()||this._getOrCreateViewSwitch().getItems().length>1;this._getActionsToolbar().setProperty("visible",v,true);};j.prototype.setTitle=function(t){this._getOrCreateTitleControl().setText(t).setVisible(!!t);return this.setProperty("title",t);};j.prototype.addAction=function(o){if(!o){return this;}this._getActionsToolbar().addContent(o);return this.addAggregation("actions",o);};j.prototype.insertAction=function(o,i){if(!o){return this;}this._getActionsToolbar().insertContent(o,i+R);return this.insertAggregation("actions",o,i);};j.prototype.removeAction=function(o){if(!o){return this;}this._getActionsToolbar().removeContent(o);return this.removeAggregation("actions",o);};j.prototype.removeAllActions=function(){var o=this._getActionsToolbar(),k=o.getContent();for(var i=R;i<k.length;i++){o.removeContent(k[i]);}return this.removeAllAggregation("actions");};j.prototype.destroyActions=function(){var o=this._getActionsToolbar(),k=o.getContent();for(var i=R;i<k.length;i++){o.removeContent(k[i]);}return this.destroyAggregation("actions");};j.prototype.setPickerText=function(t){this.setProperty("pickerText",t);this._oPickerBtn.setText(t);return this;};j.prototype._getOrCreateTitleControl=function(){if(!this._oTitle){this._oTitle=new b(this.getId()+"-Title",{visible:false});}return this._oTitle;};j.prototype._getOrCreateToolbarSpacer=function(){if(!this._oToolbarSpacer){this._oToolbarSpacer=new c(this.getId()+"-Spacer");}return this._oToolbarSpacer;};j.prototype._getOrCreateViewSwitch=function(){if(!this._oViewSwitch){this._oViewSwitch=new S(this.getId()+"-ViewSwitch");}return this._oViewSwitch;};j.prototype._convertViewSwitchToSelect=function(){this._oViewSwitch._toSelectMode();};j.prototype._convertViewSwitchToSegmentedButton=function(){this._oViewSwitch._toNormalMode();};j.prototype._getTodayButton=function(){return this._oTodayBtn;};j.prototype._handlePickerDateSelect=function(E){var s=this.getAggregation("_calendarPicker").getSelectedDates()[0].getStartDate();this.setStartDate(s);this._closeCalendarPickerPopup();this.fireDateSelect();};j.prototype._openCalendarPickerPopup=function(p){var i;if(!this._oPopup){this._oPopup=this._createPopup();}this._oPopup.setContent(p);i=P.Dock;this._oPopup.open(0,i.CenterTop,i.CenterTop,this._oPickerBtn,null,"flipfit",true);};j.prototype._createPopup=function(){var p=new P();p.setAutoClose(true);p.setDurations(0,0);p.onsapescape=function(E){this.onsapescape(E);}.bind(this);return p;};j.prototype.onsapescape=function(){if(this._oPopup){this._closeCalendarPickerPopup();if(this._oPickerBtn.getDomRef()){this._oPickerBtn.getDomRef().focus();}}};j.prototype._closeCalendarPickerPopup=function(){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}};j.prototype._getActionsToolbar=function(){return this.getAggregation("_actionsToolbar");};j.prototype._getNavigationToolbar=function(){return this.getAggregation("_navigationToolbar");};return j;});
