/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./SinglePlanningCalendarUtilities','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/Locale','sap/ui/core/InvisibleText','sap/ui/core/format/DateFormat','sap/ui/core/date/UniversalDate','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo','sap/ui/core/dnd/DragDropInfo','sap/ui/unified/library','sap/ui/unified/CalendarAppointment','sap/ui/unified/calendar/DatesRow','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/CalendarUtils','sap/ui/events/KeyCodes','./SinglePlanningCalendarGridRenderer','sap/ui/Device','sap/ui/core/delegate/ItemNavigation'],function(S,C,L,a,I,D,U,b,c,d,u,e,f,g,h,K,k,l,m){"use strict";var R=69,n=48,B=34,o=25,H=3600000/2,O=60*1000,M=86400000,p=7;var q=C.extend("sap.m.SinglePlanningCalendarGrid",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},enableAppointmentsDragAndDrop:{type:"boolean",group:"Misc",defaultValue:false},enableAppointmentsResize:{type:"boolean",group:"Misc",defaultValue:false},enableAppointmentsCreate:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment",dnd:{draggable:true}},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},_columnHeaders:{type:"sap.ui.unified.calendar.DatesRow",multiple:false,visibility:"hidden"},_intervalPlaceholders:{type:"sap.m.SinglePlanningCalendarGrid._internal.IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}},_blockersPlaceholders:{type:"sap.m.SinglePlanningCalendarGrid._internal.IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}}},dnd:true,associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.m.PlanningCalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"}}},appointmentDrop:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},startDate:{type:"object"},endDate:{type:"object"},copy:{type:"boolean"}}},appointmentResize:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},startDate:{type:"object"},endDate:{type:"object"}}},appointmentCreate:{parameters:{startDate:{type:"object"},endDate:{type:"object"}}},cellPress:{parameters:{startDate:{type:"object"},endDate:{type:"object"}}}}}});q.prototype.init=function(){var i=new Date(),j=new f(this.getId()+"-columnHeaders",{showDayNamesLine:false,showWeekNumbers:false,startDate:i}).addStyleClass("sapMSinglePCColumnHeader"),t=(60-i.getSeconds())*1000;this.setAggregation("_columnHeaders",j);this.setStartDate(i);this._setColumns(7);this._configureBlockersDragAndDrop();this._configureAppointmentsDragAndDrop();this._configureAppointmentsResize();this._configureAppointmentsCreate();this._oUnifiedRB=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this._oFormatAriaApp=D.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' HH:mm:ss a"});this._oFormatAriaFullDayCell=D.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY"});this._oFormatAriaCell=D.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' HH"});this._sLegendId=undefined;setTimeout(this._updateRowHeaderAndNowMarker.bind(this),t);};q.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};q.prototype.onBeforeRendering=function(){var A=this._createAppointmentsMap(this.getAppointments()),i=this.getStartDate(),j=g.fromLocalJSDate(i),t=this._getColumns();this._oVisibleAppointments=this._calculateVisibleAppointments(A.appointments,this.getStartDate(),t);this._oAppointmentsToRender=this._calculateAppointmentsLevelsAndWidth(this._oVisibleAppointments);this._aVisibleBlockers=this._calculateVisibleBlockers(A.blockers,j,t);this._oBlockersToRender=this._calculateBlockersLevelsAndWidth(this._aVisibleBlockers);if(this._iOldColumns!==t||this._oOldStartDate!==i){this._createBlockersDndPlaceholders(i,t);this._createAppointmentsDndPlaceholders(i,t);}};q.prototype.onmousedown=function(E){var i=E.target.classList;this._isResizeHandleBottomMouseDownTarget=i.contains("sapMSinglePCAppResizeHandleBottom");this._isResizeHandleTopMouseDownTarget=i.contains("sapMSinglePCAppResizeHandleTop");};q.prototype._isResizingPerformed=function(){return this._isResizeHandleBottomMouseDownTarget||this._isResizeHandleTopMouseDownTarget;};q.prototype._configureBlockersDragAndDrop=function(){this.addDragDropConfig(new d({sourceAggregation:"appointments",targetAggregation:"_blockersPlaceholders",dragStart:function(E){if(!this.getEnableAppointmentsDragAndDrop()){E.preventDefault();return false;}var i=function(){var $=jQuery(".sapMSinglePCOverlay");setTimeout(function(){$.addClass("sapMSinglePCOverlayDragging");});jQuery(document).one("dragend",function(){$.removeClass("sapMSinglePCOverlayDragging");});};i();}.bind(this),dragEnter:function(E){var i=E.getParameter("dragSession"),A=i.getDragControl(),j=i.getDropControl(),t=this.isAllDayAppointment(A.getStartDate(),A.getEndDate()),v=function(){var $=jQuery(i.getIndicator()),w=A.$().outerHeight(),x=A.$().outerWidth(),G=j.$().closest(".sapMSinglePCBlockersColumns").get(0).getBoundingClientRect(),y=j.getDomRef().getBoundingClientRect(),z=(y.left+x)-(G.left+G.width);if(t){$.css("min-height",w);$.css("min-width",Math.min(x,x-z));}else{$.css("min-height",i.getDropControl().$().outerHeight());$.css("min-width",i.getDropControl().$().outerWidth());}};if(!i.getIndicator()){setTimeout(v,0);}else{v();}}.bind(this),drop:function(E){var i=E.getParameter("dragSession"),A=i.getDragControl(),P=i.getDropControl(),j=P.getDate().getJSDate(),t,v=E.getParameter("browserEvent"),w=(v.metaKey||v.ctrlKey),x=this.isAllDayAppointment(A.getStartDate(),A.getEndDate());t=new Date(j);if(x){t.setMilliseconds(A.getEndDate().getTime()-A.getStartDate().getTime());}this.$().find(".sapMSinglePCOverlay").removeClass("sapMSinglePCOverlayDragging");if(x&&A.getStartDate().getTime()===j.getTime()){return;}this.fireAppointmentDrop({appointment:A,startDate:j,endDate:t,copy:w});}.bind(this)}));};q.prototype._configureAppointmentsDragAndDrop=function(){this.addDragDropConfig(new d({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",dragStart:function(E){if(!this.getEnableAppointmentsDragAndDrop()||this._isResizingPerformed()){E.preventDefault();return false;}var i=function(){var $=jQuery(".sapMSinglePCOverlay");setTimeout(function(){$.addClass("sapMSinglePCOverlayDragging");});jQuery(document).one("dragend",function(){$.removeClass("sapMSinglePCOverlayDragging");});};i();}.bind(this),dragEnter:function(E){var i=E.getParameter("dragSession"),A=i.getDragControl(),j=i.getDropControl(),t=this.isAllDayAppointment(A.getStartDate(),A.getEndDate()),v=function(){var $=jQuery(i.getIndicator()),w=A.$().outerHeight(),G=j.$().closest(".sapMSinglePCColumn").get(0).getBoundingClientRect(),x=i.getDropControl().getDomRef().getBoundingClientRect(),y=(x.top+w)-(G.top+G.height);if(t){$.css("min-height",2*i.getDropControl().$().outerHeight());}else{$.css("min-height",Math.min(w,w-y));}};if(!i.getIndicator()){setTimeout(v,0);}else{v();}}.bind(this),drop:function(E){var i=E.getParameter("dragSession"),A=i.getDragControl(),P=i.getDropControl(),j=P.getDate().getJSDate(),t,v=E.getParameter("browserEvent"),w=(v.metaKey||v.ctrlKey),x=this.isAllDayAppointment(A.getStartDate(),A.getEndDate());t=new Date(j);if(x){t.setHours(t.getHours()+1);}else{t.setMilliseconds(A.getEndDate().getTime()-A.getStartDate().getTime());}this.$().find(".sapMSinglePCOverlay").removeClass("sapMSinglePCOverlayDragging");if(!x&&A.getStartDate().getTime()===j.getTime()){return;}this.fireAppointmentDrop({appointment:A,startDate:j,endDate:t,copy:w});}.bind(this)}));};q.prototype._configureAppointmentsResize=function(){var i=new d({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",dragStart:function(E){if(!this.getEnableAppointmentsResize()||!this._isResizingPerformed()){E.preventDefault();return;}var j=E.getParameter("dragSession"),$=this.$().find(".sapMSinglePCOverlay"),t=jQuery(j.getIndicator()),v=j.getDragControl().$();if(this._isResizeHandleBottomMouseDownTarget){j.setData("bottomHandle","true");}if(this._isResizeHandleTopMouseDownTarget){j.setData("topHandle","true");}t.addClass("sapUiDnDIndicatorHide");setTimeout(function(){$.addClass("sapMSinglePCOverlayDragging");},0);jQuery(document).one("dragend",function(){var A=j.getComplexData("appointmentStartingBoundaries");$.removeClass("sapMSinglePCOverlayDragging");t.removeClass("sapUiDnDIndicatorHide");v.css({top:A.top,height:A.height,"z-index":"auto",opacity:1});});if(!l.browser.msie&&!l.browser.edge){E.getParameter("browserEvent").dataTransfer.setDragImage(r(),0,0);}}.bind(this),dragEnter:function(E){var j=E.getParameter("dragSession"),A=j.getDragControl().$().get(0),t=j.getDropControl().getDomRef(),v=j.getComplexData("appointmentStartingBoundaries"),w=function(){var $=jQuery(j.getIndicator());$.addClass("sapUiDnDIndicatorHide");},T,x,y,V,z;if(!v){v={top:A.offsetTop,bottom:A.offsetTop+A.getBoundingClientRect().height,height:A.getBoundingClientRect().height};j.setComplexData("appointmentStartingBoundaries",v);}V=j.getData("bottomHandle")?v.top:v.bottom;T=Math.min(V,t.offsetTop);x=Math.max(V,t.offsetTop+t.getBoundingClientRect().height);y=x-T;z={top:T,height:y,"z-index":1,opacity:0.8};j.getDragControl().$().css(z);if(!j.getIndicator()){setTimeout(w,0);}else{w();}},drop:function(E){var j=E.getParameter("dragSession"),A=j.getDragControl(),t=this.indexOfAggregation("_intervalPlaceholders",j.getDropControl()),v=j.getComplexData("appointmentStartingBoundaries"),w;w=this._calcResizeNewHoursAppPos(A.getStartDate(),A.getEndDate(),t,j.getData("bottomHandle"));this.$().find(".sapMSinglePCOverlay").removeClass("sapMSinglePCOverlayDragging");jQuery(j.getIndicator()).removeClass("sapUiDnDIndicatorHide");A.$().css({top:v.top,height:v.height,"z-index":"auto",opacity:1});if(A.getEndDate().getTime()===w.endDate.getTime()&&A.getStartDate().getTime()===w.startDate.getTime()){return;}this.fireAppointmentResize({appointment:A,startDate:w.startDate,endDate:w.endDate});}.bind(this)});this.addDragDropConfig(i);};q.prototype._configureAppointmentsCreate=function(){this.addDragDropConfig(new d({targetAggregation:"_intervalPlaceholders",dragStart:function(E){if(!this.getEnableAppointmentsCreate()){E.preventDefault();return;}var $=this.$().find(".sapMSinglePCOverlay");setTimeout(function(){$.addClass("sapMSinglePCOverlayDragging");});jQuery(document).one("dragend",function(){$.removeClass("sapMSinglePCOverlayDragging");jQuery(".sapUiAppCreate").remove();jQuery(".sapUiDnDDragging").removeClass("sapUiDnDDragging");});if(!l.browser.msie&&!l.browser.edge){E.getParameter("browserEvent").dataTransfer.setDragImage(r(),0,0);}}.bind(this),dragEnter:function(E){var i=E.getParameter("dragSession"),j=i.getDropControl(),t=j.getDomRef(),v=t.offsetHeight,w=t.offsetTop,x=w,y=t.getBoundingClientRect().left,z=y,A=j.$().parents(".sapMSinglePCColumn").get(0),$=jQuery(".sapUiAppCreate");if(!$.get(0)){$=jQuery("<div></div>").addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");$.appendTo(A);}jQuery(".sapUiDnDDragging").removeClass("sapUiDnDDragging");if(!i.getComplexData("startingRectsDropArea")){i.setComplexData("startingRectsDropArea",{top:w,left:y});i.setComplexData("startingDropDate",j.getDate());}else{x=i.getComplexData("startingRectsDropArea").top;z=i.getComplexData("startingRectsDropArea").left;}if(y!==z){E.preventDefault();return false;}j.$().closest(".sapMSinglePCColumn").find(".sapMSinglePCAppointments").addClass("sapUiDnDDragging");$.css({top:Math.min(x,w)+2,height:Math.abs(x-w)+v-4,left:3,right:3,"z-index":2});i.setIndicatorConfig({display:"none"});},drop:function(E){var i=E.getParameter("dragSession"),j=i.getDropControl(),T=30*60*1000,t=i.getComplexData("startingDropDate").getTime(),v=j.getDate().getJSDate().getTime(),w=Math.min(t,v),x=Math.max(t,v)+T;this.fireAppointmentCreate({startDate:new Date(w),endDate:new Date(x)});jQuery(".sapUiAppCreate").remove();jQuery(".sapUiDnDDragging").removeClass("sapUiDnDDragging");}.bind(this)}));};q.prototype._calcResizeNewHoursAppPos=function(A,i,j,t){var v=new Date(this.getStartDate().getFullYear(),this.getStartDate().getMonth(),this.getStartDate().getDate()),w=30*60*1000,P=v.getTime()+j*w,x=P+w,V=t?A.getTime():i.getTime(),y=Math.min(V,P),E=Math.max(V,x);return{startDate:new Date(y),endDate:new Date(E)};};q.prototype._adjustAppointmentsHeightforCompact=function(i,j,t){var A,$,v,w,x,y,z,E,F=this._getRowHeight(),G=this;if(this._oAppointmentsToRender[i]){this._oAppointmentsToRender[i].oAppointmentsList.getIterator().forEach(function(J){A=J.getData();$=jQuery("div[data-sap-day='"+i+"'].sapMSinglePCColumn #"+A.getId());v=A.getStartDate();w=A.getEndDate();z=j.getTime()>v.getTime();E=t.getTime()<w.getTime();x=z?0:G._calculateTopPosition(v);y=E?0:G._calculateBottomPosition(w);$.css("top",x);$.css("bottom",y);$.find(".sapUiCalendarApp").css("min-height",F/2-3);});}};q.prototype._adjustBlockersHeightforCompact=function(){var i=this._getBlockersToRender().iMaxlevel,j=(i+1)*this._getBlockerRowHeight(),t=this._getColumns()===1?j+p:j,v=this._getBlockerRowHeight();if(i>0){t=t+3;}this.$().find(".sapMSinglePCBlockersColumns").css("height",t);this._oBlockersToRender.oBlockersList.getIterator().forEach(function(w){w.getData().$().css("top",v*w.level+1);});};q.prototype._adjustBlockersHeightforCozy=function(){var i=this._getBlockersToRender()&&this._getBlockersToRender().iMaxlevel,j;if(this._getColumns()===1){j=(i+1)*this._getBlockerRowHeight();this.$().find(".sapMSinglePCBlockersColumns").css("height",j+p);}};q.prototype.onAfterRendering=function(){var j=this._getColumns(),t=this.getStartDate(),v=this._getRowHeight();if(v===n){for(var i=0;i<j;i++){var w=new g(t.getFullYear(),t.getMonth(),t.getDate()+i),x=this._getDateFormatter().format(w.toLocalJSDate()),y=new U(w.getYear(),w.getMonth(),w.getDate(),this._getVisibleStartHour()),z=new U(w.getYear(),w.getMonth(),w.getDate(),this._getVisibleEndHour(),59,59);this._adjustAppointmentsHeightforCompact(x,y,z);}this._adjustBlockersHeightforCompact();}else{this._adjustBlockersHeightforCozy();}this._updateRowHeaderAndNowMarker();_.call(this);};q.prototype.onkeydown=function(E){var A=E.srcControl,i=!(E.ctrlKey||E.metaKey),G;if(E.which===K.SPACE||E.which===K.ENTER){if(A&&A.isA("sap.ui.unified.CalendarAppointment")){this.fireAppointmentSelect({appointment:A,appointments:this._toggleAppointmentSelection(A,i)});}else if(E.target.classList.contains("sapMSinglePCRow")||E.target.classList.contains("sapMSinglePCBlockersColumn")){G=E.target;this.fireEvent("cellPress",{startDate:this._getDateFormatter().parse(G.getAttribute("data-sap-start-date")),endDate:this._getDateFormatter().parse(G.getAttribute("data-sap-end-date"))});}E.preventDefault();}};q.prototype._appFocusHandler=function(E,i){var A=sap.ui.getCore().byId(E.target.id),j=A&&A.isA("sap.ui.unified.CalendarAppointment");if(j){this.fireAppointmentSelect({appointment:undefined,appointments:this._toggleAppointmentSelection(undefined,true)});this._focusCellWithKeyboard(A,i);E.preventDefault();}};q.prototype._cellFocusHandler=function(E,i){var G=E.target,F=this._getDateFormatter(),j;if(G.classList.contains("sapMSinglePCRow")||G.classList.contains("sapMSinglePCBlockersColumn")){j=F.parse(G.getAttribute("data-sap-start-date"));if(this._isBorderReached(j,i)){this.fireEvent("borderReached",{startDate:j,next:i===K.ARROW_RIGHT,fullDay:G.classList.contains("sapMSinglePCBlockersColumn")});}}};q.prototype.onsapup=function(E){this._appFocusHandler(E,K.ARROW_UP);};q.prototype.onsapdown=function(E){this._appFocusHandler(E,K.ARROW_DOWN);};q.prototype.onsapright=function(E){this._appFocusHandler(E,K.ARROW_RIGHT);this._cellFocusHandler(E,K.ARROW_RIGHT);};q.prototype.onsapleft=function(E){this._appFocusHandler(E,K.ARROW_LEFT);this._cellFocusHandler(E,K.ARROW_LEFT);};q.prototype.setStartDate=function(i){this._oOldStartDate=this.getStartDate();this.getAggregation("_columnHeaders").setStartDate(i);return this.setProperty("startDate",i);};q.prototype.getSelectedAppointments=function(){return this.getAppointments().filter(function(A){return A.getSelected();});};q.prototype._toggleAppointmentSelection=function(A,j){var t=[],v,w,i;if(j){v=this.getAppointments();for(i=0,w=v.length;i<w;i++){if((!A||v[i].getId()!==A.getId())&&v[i].getSelected()){v[i].setProperty("selected",false,true);t.push(v[i]);jQuery('[data-sap-ui='+v[i].getId()+']').find(".sapUiCalendarApp").removeClass("sapUiCalendarAppSel");}}}if(A){A.setProperty("selected",!A.getSelected(),true);t.push(A);jQuery('[data-sap-ui='+A.getId()+']').find(".sapUiCalendarApp").toggleClass("sapUiCalendarAppSel",A.getSelected());}return t;};q.prototype._isBorderReached=function(F,i){var G=g.fromLocalJSDate(this.getStartDate()),j=new g(G.getYear(),G.getMonth(),G.getDate()+this._getColumns()-1),t=g.fromLocalJSDate(F),v=i===K.ARROW_LEFT&&t.isSame(G),w=i===K.ARROW_RIGHT&&t.isSame(j);return v||w;};q.prototype._focusCellWithKeyboard=function(A,i){var F=this.isAllDayAppointment(A.getStartDate(),A.getEndDate()),j=this._getDateFormatter(),t=new Date(A.getStartDate().getFullYear(),A.getStartDate().getMonth(),A.getStartDate().getDate(),A.getStartDate().getHours()),G=new Date(this.getStartDate().getFullYear(),this.getStartDate().getMonth(),this.getStartDate().getDate(),this.getStartDate().getHours());if(t<G){t=G;}if(this._isBorderReached(t,i)){this.fireEvent("borderReached",{startDate:t,next:i===K.ARROW_RIGHT,fullDay:F});return;}switch(i){case K.ARROW_UP:if(!F){t.setHours(t.getHours()-1);}break;case K.ARROW_DOWN:if(!F){t.setHours(t.getHours()+1);}break;case K.ARROW_LEFT:t.setDate(t.getDate()-1);break;case K.ARROW_RIGHT:t.setDate(t.getDate()+1);break;default:}if(F&&i!==K.ARROW_DOWN){jQuery("[data-sap-start-date='"+j.format(t)+"'].sapMSinglePCBlockersColumn").focus();}else{jQuery("[data-sap-start-date='"+j.format(t)+"'].sapMSinglePCRow").focus();}};q.prototype.ontap=function(E){var A=E.srcControl,i=!(E.ctrlKey||E.metaKey);if(A&&A.isA("sap.ui.unified.CalendarAppointment")){this.fireAppointmentSelect({appointment:A,appointments:this._toggleAppointmentSelection(A,i)});}else if(E.target.classList.contains("sapMSinglePCRow")||E.target.classList.contains("sapMSinglePCBlockersColumn")){this.fireAppointmentSelect({appointment:undefined,appointments:this._toggleAppointmentSelection(undefined,true)});}};q.prototype._getVisibleStartHour=function(){return 0;};q.prototype._getVisibleEndHour=function(){return 23;};q.prototype._isVisibleHour=function(){return true;};q.prototype._isOutsideVisibleHours=function(){return false;};q.prototype._shouldHideRowHeader=function(i){var j=new Date().getHours(),t=h._areCurrentMinutesLessThan(15)&&j===i,v=h._areCurrentMinutesMoreThan(45)&&j===i-1;return t||v;};q.prototype._parseDateStringAndHours=function(i,j){var t=this._getDateFormatter().parse(i);if(j){t.setHours(j);}return t;};q.prototype._getDateFormatter=function(){if(!(this._oDateFormat instanceof D)){this._oDateFormat=D.getDateTimeInstance({pattern:"YYYYMMdd-HHmm"});}return this._oDateFormat;};q.prototype._formatTimeAsString=function(i){var P=this._getHoursPattern()+":mm",F=D.getDateTimeInstance({pattern:P},new a(this._getCoreLocaleId()));return F.format(i);};q.prototype._addAMPM=function(i){var A=this._getAMPMFormat();return" "+A.format(i);};q.prototype._calculateTopPosition=function(i){var j=i.getHours()-this._getVisibleStartHour(),t=i.getMinutes(),v=this._getRowHeight();return Math.floor((v*j)+(v/60)*t);};q.prototype._calculateBottomPosition=function(i){var j=this._getVisibleEndHour()+1-i.getHours(),t=i.getMinutes(),v=this._getRowHeight();return Math.floor((v*j)-(v/60)*t);};q.prototype._updateRowHeaderAndNowMarker=function(){var i=new Date();this._updateNowMarker(i);this._updateRowHeaders(i);setTimeout(this._updateRowHeaderAndNowMarker.bind(this),O);};q.prototype._updateNowMarker=function(i){var $=this.$("nowMarker"),j=this.$("nowMarkerText"),t=this.$("nowMarkerAMPM"),v=this._isOutsideVisibleHours(i.getHours());$.toggleClass("sapMSinglePCNowMarkerHidden",v);$.css("top",this._calculateTopPosition(i)+"px");j.text(this._formatTimeAsString(i));t.text(this._addAMPM(i));j.append(t);};q.prototype._updateRowHeaders=function(i){var $=this.$(),j=i.getHours(),N=j+1;$.find(".sapMSinglePCRowHeader").removeClass("sapMSinglePCRowHeaderHidden");if(this._shouldHideRowHeader(j)){$.find(".sapMSinglePCRowHeader"+j).addClass("sapMSinglePCRowHeaderHidden");}else if(this._shouldHideRowHeader(N)){$.find(".sapMSinglePCRowHeader"+N).addClass("sapMSinglePCRowHeaderHidden");}};q.prototype._createAppointmentsMap=function(A){var t=this;return A.reduce(function(i,j){var v=j.getStartDate(),w=j.getEndDate(),x,y,z;if(!v||!w){return i;}if(!t.isAllDayAppointment(v,w)){x=g.fromLocalJSDate(v);y=g.fromLocalJSDate(w);while(x.isSameOrBefore(y)){z=t._getDateFormatter().format(x.toLocalJSDate());if(!i.appointments[z]){i.appointments[z]=[];}i.appointments[z].push(j);x.setDate(x.getDate()+1);}}else{i.blockers.push(j);}return i;},{appointments:{},blockers:[]});};q.prototype._calculateVisibleAppointments=function(A,j,t){var v={},w,x,y;for(var i=0;i<t;i++){w=new g(j.getFullYear(),j.getMonth(),j.getDate()+i);x=this._getDateFormatter().format(w.toLocalJSDate());y=this._isAppointmentFitInVisibleHours(w);if(A[x]){v[x]=A[x].filter(y,this).sort(this._sortAppointmentsByStartHourCallBack);}}return v;};q.prototype._isAppointmentFitInVisibleHours=function(i){return function(A){var j=A.getStartDate().getTime(),t=A.getEndDate().getTime(),v=(new U(i.getYear(),i.getMonth(),i.getDate(),this._getVisibleStartHour())).getTime(),w=(new U(i.getYear(),i.getMonth(),i.getDate(),this._getVisibleEndHour(),59,59)).getTime();var x=j<v&&t>w,y=j>=v&&j<w,E=t>v&&t<=w;return x||y||E;};};q.prototype._calculateAppointmentsLevelsAndWidth=function(v){var t=this;return Object.keys(v).reduce(function(A,i){var j=0,w=new S.list(),x=v[i];x.forEach(function(y){var z=new S.node(y),E=y.getStartDate().getTime();if(w.getSize()===0){w.add(z);return;}w.getIterator().forEach(function(F){var G=true,J=F.getData(),N=J.getStartDate().getTime(),P=J.getEndDate().getTime(),Q=P-N;if(Q<H){P=P+(H-Q);}if(E>=N&&E<P){z.level++;j=Math.max(j,z.level);}if(F.next&&F.next.level===z.level){G=false;}if(E>=P&&G){this.interrupt();}});w.insertAfterLevel(z.level,z);});A[i]={oAppointmentsList:t._calculateAppointmentsWidth(w),iMaxLevel:j};return A;},{});};q.prototype._calculateAppointmentsWidth=function(A){A.getIterator().forEach(function(i){var j=i.getData(),t=i.level,v=i.level,w=j.getStartDate().getTime(),x=j.getEndDate().getTime(),y=x-w;if(y<H){x=x+(H-y);}new S.iterator(A).forEach(function(z){var E=z.getData(),F=z.level,G=E.getStartDate().getTime(),J=E.getEndDate().getTime(),N=J-G;if(N<H){J=J+(H-N);}if(v>=F){return;}if(w>=G&&w<J||x>G&&x<J||w<=G&&x>=J){i.width=F-v;this.interrupt();return;}if(t<F){t=F;i.width++;}});});return A;};q.prototype._calculateVisibleBlockers=function(i,j,t){var v=new g(j.getYear(),j.getMonth(),j.getDate()+t-1),w=this._isBlockerVisible(j,v);return i.filter(w).sort(this._sortAppointmentsByStartHourCallBack);};q.prototype._isBlockerVisible=function(v,V){return function(A){var i=g.fromLocalJSDate(A.getStartDate()),j=g.fromLocalJSDate(A.getEndDate());var t=i.isBefore(v)&&j.isAfter(V),w=h._isBetween(i,v,V,true),E=h._isBetween(j,v,V,true);return t||w||E;};};q.prototype._calculateBlockersLevelsAndWidth=function(v){var i=0,j=new S.list();v.forEach(function(t){var w=new S.node(t),x=g.fromLocalJSDate(t.getStartDate()),y=g.fromLocalJSDate(t.getEndDate());w.width=h._daysBetween(y,x);if(j.getSize()===0){j.add(w);return;}j.getIterator().forEach(function(z){var A=true,E=z.getData(),F=g.fromLocalJSDate(E.getStartDate()),G=g.fromLocalJSDate(E.getEndDate());if(x.isSameOrAfter(F)&&x.isSameOrBefore(G)){w.level++;i=Math.max(i,w.level);}if(z.next&&z.next.level===w.level){A=false;}if(x.isSameOrAfter(G)&&A){this.interrupt();}});j.insertAfterLevel(w.level,w);},this);return{oBlockersList:j,iMaxlevel:i};};q.prototype._sortAppointmentsByStartHourCallBack=function(A,i){return A.getStartDate().getTime()-i.getStartDate().getTime()||i.getEndDate().getTime()-A.getEndDate().getTime();};q.prototype._getVisibleAppointments=function(){return this._oVisibleAppointments;};q.prototype._getAppointmentsToRender=function(){return this._oAppointmentsToRender;};q.prototype._getVisibleBlockers=function(){return this._aVisibleBlockers;};q.prototype._getBlockersToRender=function(){return this._oBlockersToRender;};q.prototype._setColumns=function(i){this._iOldColumns=this._iColumns;this._iColumns=i;this.getAggregation("_columnHeaders").setDays(i);this.invalidate();return this;};q.prototype._getColumns=function(){return this._iColumns;};q.prototype._getRowHeight=function(){return this._isCompact()?n:R;};q.prototype._getBlockerRowHeight=function(){return this._isCompact()?o:B;};q.prototype._isCompact=function(){var i=this.getDomRef();while(i&&i.classList){if(i.classList.contains("sapUiSizeCompact")){return true;}i=i.parentNode;}return false;};q.prototype._getCoreLocaleId=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};q.prototype._getCoreLocaleData=function(){var i,j;if(!this._oLocaleData){i=this._getCoreLocaleId();j=new a(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;};q.prototype._hasAMPM=function(){var i=this._getCoreLocaleData();return i.getTimePattern("short").search("a")>=0;};q.prototype._getHoursFormat=function(){var i=this._getCoreLocaleId();if(!this._oHoursFormat||this._oHoursFormat.oLocale.toString()!==i){var j=new a(i),P=this._getHoursPattern();this._oHoursFormat=D.getTimeInstance({pattern:P},j);}return this._oHoursFormat;};q.prototype._getHoursPattern=function(){return this._hasAMPM()?"h":"H";};q.prototype._getAMPMFormat=function(){var i=this._getCoreLocaleId(),j=new a(i);if(!this._oAMPMFormat||this._oAMPMFormat.oLocale.toString()!==i){this._oAMPMFormat=D.getTimeInstance({pattern:"a"},j);}return this._oAMPMFormat;};q.prototype._getColumnHeaders=function(){return this.getAggregation("_columnHeaders");};q.prototype._getAppointmentStartEndInfo=function(A){var i=this._oUnifiedRB.getText("CALENDAR_START_TIME"),E=this._oUnifiedRB.getText("CALENDAR_END_TIME"),F=this._oFormatAriaApp.format(A.getStartDate()),j=this._oFormatAriaApp.format(A.getEndDate());return i+": "+F+"; "+E+": "+j+"; ";};q.prototype.enhanceAccessibilityState=function(i,A){if(i.getId()===this._getColumnHeaders().getId()){A.labelledby=I.getStaticId("sap.m","PLANNINGCALENDAR_DAYS");}};q.prototype._getCellStartEndInfo=function(i,E){var j=this._oUnifiedRB.getText("CALENDAR_START_TIME"),t=this._oUnifiedRB.getText("CALENDAR_END_TIME"),F=!E;if(F){return j+": "+this._oFormatAriaFullDayCell.format(i)+"; ";}return j+": "+this._oFormatAriaCell.format(i)+"; "+t+": "+this._oFormatAriaCell.format(E)+"; ";};q.prototype.isAllDayAppointment=function(A,i){var j=A.getHours()===0,t=A.getMinutes()===0,v=A.getSeconds()===0,w=A.getMilliseconds()===0,x=j&&t&&v&&w,y=false;if(x){y=this._isEndTime0000(A,i);}return y;};q.prototype._isEndTime0000=function(A,i){return(i.getTime()-A.getTime())%M===0;};q.prototype._createBlockersDndPlaceholders=function(j,t){this.destroyAggregation("_blockersPlaceholders");for(var i=0;i<t;i++){var v=new U(j.getFullYear(),j.getMonth(),j.getDate()+i);var P=new s({date:v});this.addAggregation("_blockersPlaceholders",P,true);}};q.prototype._createAppointmentsDndPlaceholders=function(t,v){var w=this._getVisibleStartHour(),E=this._getVisibleEndHour();this._dndPlaceholdersMap={};this.destroyAggregation("_intervalPlaceholders");for(var i=0;i<v;i++){var x=new g(t.getFullYear(),t.getMonth(),t.getDate()+i);if(!this._dndPlaceholdersMap[x]){this._dndPlaceholdersMap[x]=[];}for(var j=w;j<=E;j++){var y=this._dndPlaceholdersMap[x],Y=x.getYear(),z=x.getMonth(),A=x.getDate();y.push(this._createAppointmentsDndPlaceHolder(new U(Y,z,A,j)));y.push(this._createAppointmentsDndPlaceHolder(new U(Y,z,A,j,30)));}}};q.prototype._createAppointmentsDndPlaceHolder=function(i){var P=new s({date:i});this.addAggregation("_intervalPlaceholders",P,true);return P;};function r(){var $=jQuery("<span></span>").addClass("sapUiCalAppResizeGhost");$.appendTo(document.body);setTimeout(function(){$.remove();},0);return $.get(0);}var s=C.extend("sap.m.SinglePlanningCalendarGrid._internal.IntervalPlaceholder",{metadata:{properties:{date:{type:"object",group:"Data"}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addClass("sapMSinglePCPlaceholder");i.writeClasses();i.write("></div>");}});q.prototype._findCorrespondingLegendItem=function(j,t){var v=j._sLegendId,w=sap.ui.getCore().byId(v),x=w?w.getAppointmentItems():null,y=w?w.getItems():null,A=t instanceof e,z=A?x:y,E=A?t.getType():t.type,F,G;if(z&&z.length){for(var i=0;i<z.length;i++){F=z[i];if(F.getType()===E){G=F.getText();break;}}}if(!G){G=E;}return G;};function _(){var i=this.getDomRef(),j=this.$().find(".sapMSinglePCBlockersColumn").toArray();this._aGridCells=Array.prototype.concat(j);for(var t=0;t<=this._getVisibleEndHour();++t){j=this.$().find("div[data-sap-hour='"+t+"']").toArray();this._aGridCells=this._aGridCells.concat(j);}if(!this._oItemNavigation){this._oItemNavigation=new m();this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(i);this._oItemNavigation.setItemDomRefs(this._aGridCells);this._oItemNavigation.setCycling(false);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"],saphome:["alt","meta"],sapend:["meta"]});this._oItemNavigation.setTableMode(true,true).setColumns(this._getColumns());this._oItemNavigation.setPageSize(this._aGridCells.length);}return q;});
