/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./library","sap/m/library","sap/m/MessageBox","sap/m/Dialog","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/core/IconPool","sap/m/Image","sap/m/Text","sap/m/Title","sap/m/Button","sap/m/List","sap/m/BusyIndicator","sap/m/StandardListItem","sap/ui/unified/FileUploaderParameter","sap/ui/unified/FileUploader","sap/ui/core/format/FileSizeFormat","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/ObjectAttribute","sap/m/UploadCollectionItem","sap/m/UploadCollectionParameter","sap/m/UploadCollectionToolbarPlaceholder","sap/ui/core/HTML","sap/m/CustomListItem","sap/ui/core/ResizeHandler","sap/ui/Device","./UploadCollectionRenderer","sap/ui/thirdparty/jquery","sap/ui/events/KeyCodes","sap/base/Log","sap/ui/dom/jquery/selectText"],function(L,M,a,D,C,I,b,c,T,d,B,f,g,S,F,h,k,O,l,m,U,n,o,H,p,R,q,r,Q,K,s){"use strict";var t=C.extend("sap.m.UploadCollection",{constructor:function(i,j){var u;if(j&&j.instantUpload!==undefined){if(j.instantUpload===false){u=j.instantUpload;}delete j.instantUpload;}else if(i&&i.instantUpload!==undefined){if(i.instantUpload===false){u=i.instantUpload;}delete i.instantUpload;}if(j&&j.mode===L.ListMode.MultiSelect&&u===false){j.mode=L.ListMode.None;s.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Upload Pending scenario. Value has been resetted to 'None'");}else if(i&&i.mode===L.ListMode.MultiSelect&&u===false){i.mode=L.ListMode.None;s.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Upload Pending scenario. Value has been resetted to 'None'");}try{C.apply(this,arguments);if(u===false){this.bInstantUpload=u;this._oFormatDecimal=k.getInstance({binaryFilesize:true,maxFractionDigits:1,maxIntegerDigits:3});}}catch(e){this.destroy();throw e;}},metadata:{library:"sap.m",properties:{fileType:{type:"string[]",group:"Data",defaultValue:null},maximumFilenameLength:{type:"int",group:"Data",defaultValue:null},maximumFileSize:{type:"float",group:"Data",defaultValue:null},mimeType:{type:"string[]",group:"Data",defaultValue:null},multiple:{type:"boolean",group:"Behavior",defaultValue:false},noDataText:{type:"string",group:"Appearance",defaultValue:null},noDataDescription:{type:"string",group:"Appearance",defaultValue:null},sameFilenameAllowed:{type:"boolean",group:"Behavior",defaultValue:false},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:"All"},uploadEnabled:{type:"boolean",group:"Behavior",defaultValue:true},uploadUrl:{type:"string",group:"Data",defaultValue:"../../../upload"},instantUpload:{type:"boolean",group:"Behavior",defaultValue:true},numberOfAttachmentsText:{type:"string",group:"Appearance",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:"None"},uploadButtonInvisible:{type:"boolean",group:"Appearance",defaultValue:false},terminationEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.UploadCollectionItem",multiple:true,singularName:"item",bindable:"bindable"},headerParameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"headerParameter"},parameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"parameter"},toolbar:{type:"sap.m.OverflowToolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false,forwarding:{idSuffix:"-list",aggregation:"infoToolbar"}},_list:{type:"sap.m.List",multiple:false,visibility:"hidden"},_noDataIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_dragDropIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_dragDropText:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{change:{parameters:{documentId:{type:"string"},files:{type:"object[]"}}},fileDeleted:{parameters:{documentId:{type:"string"},item:{type:"sap.m.UploadCollectionItem"}}},filenameLengthExceed:{parameters:{documentId:{type:"string"},files:{type:"object[]"}}},fileRenamed:{parameters:{documentId:{type:"string"},fileName:{type:"string"},item:{type:"sap.m.UploadCollectionItem"}}},fileSizeExceed:{parameters:{documentId:{type:"string"},fileSize:{type:"string"},files:{type:"object[]"}}},typeMissmatch:{parameters:{documentId:{type:"string"},fileType:{type:"string"},mimeType:{type:"string"},files:{type:"object[]"}}},uploadComplete:{parameters:{readyStateXHR:{type:"string"},response:{type:"string"},status:{type:"string"},files:{type:"object[]"}}},uploadTerminated:{parameters:{fileName:{type:"string"},getHeaderParameter:{type:"function",parameters:{headerParameterName:{type:"string"}}}}},beforeUploadStarts:{parameters:{fileName:{type:"string"},addHeaderParameter:{type:"function",parameters:{headerParameter:{type:"sap.m.UploadCollectionParameter"}}},getHeaderParameter:{type:"function",parameters:{headerParameterName:{type:"string"}}}}},selectionChange:{parameters:{selectedItem:{type:"sap.m.UploadCollectionItem"},selectedItems:{type:"sap.m.UploadCollectionItem[]"},selected:{type:"boolean"}}}}}});t._uploadingStatus="uploading";t._displayStatus="display";t._toBeDeletedStatus="toBeDeleted";t._pendingUploadStatus="pendingUploadStatus";t._placeholderCamera="sap-icon://card";t._markerMargin=8;if(q.system.phone){t._resizeTimeoutInterval=500;}else{t._resizeTimeoutInterval=100;}t.prototype.init=function(){t.prototype._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._headerParamConst={requestIdName:"requestId"+Q.now(),fileNameRequestIdName:"fileNameRequestId"+Q.now()};this._requestIdValue=0;this._iFUCounter=0;this._oList=new f(this.getId()+"-list",{selectionChange:[this._handleSelectionChange,this]});this.setAggregation("_list",this._oList,true);this._oList.addStyleClass("sapMUCList");this.setAggregation("_noDataIcon",new I(this.getId()+"-no-data-icon",{src:"sap-icon://document",size:"6rem",noTabStop:true}),true);this.setAggregation("_dragDropIcon",new I(this.getId()+"-drag-drop-icon",{src:"sap-icon://upload-to-cloud",size:"4rem",noTabStop:true}),true);this.setAggregation("_dragDropText",new T(this.getId()+"-drag-drop-text",{text:this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR")}),true);this._iUploadStartCallCounter=0;this.aItems=[];this._aDeletedItemForPendingUpload=[];this._aFileUploadersForPendingUpload=[];this._aFilesFromDragAndDropForPendingUpload=[];this._iFileUploaderPH=null;this._oListEventDelegate=null;this._oItemToUpdate=null;this._sReziseHandlerId=null;};t.prototype.setFileType=function(e){if(!e){return this;}if(!this.getInstantUpload()){s.info("As property instantUpload is false it is not allowed to change fileType at runtime.");}else{var j=e.length;for(var i=0;i<j;i++){e[i]=e[i].toLowerCase();}if(this.getFileType()!==e){this.setProperty("fileType",e,true);this._getFileUploader().setFileType(e);}}return this;};t.prototype.setMaximumFilenameLength=function(i){if(!this.getInstantUpload()){s.info("As property instantUpload is false it is not allowed to change maximumFilenameLength at runtime.");}else if(this.getMaximumFilenameLength()!==i){this.setProperty("maximumFilenameLength",i,true);this._getFileUploader().setMaximumFilenameLength(i);}return this;};t.prototype.setMaximumFileSize=function(i){if(!this.getInstantUpload()){s.info("As property instantUpload is false it is not allowed to change maximumFileSize at runtime.");}else if(this.getMaximumFileSize()!==i){this.setProperty("maximumFileSize",i,true);this._getFileUploader().setMaximumFileSize(i);}return this;};t.prototype.setMimeType=function(e){if(!this.getInstantUpload()){s.info("As property instantUpload is false it is not allowed to change mimeType at runtime.");}else if(this.getMimeType()!==e){this.setProperty("mimeType",e,true);this._getFileUploader().setMimeType(e);}return this;};t.prototype.setMultiple=function(e){if(!this.getInstantUpload()){s.info("As property instantUpload is false it is not allowed to change multiple at runtime.");}else if(this.getMultiple()!==e){this.setProperty("multiple",e);this._getFileUploader().setMultiple(e);}return this;};t.prototype.setShowSeparators=function(e){if(this.getShowSeparators()!==e){this.setProperty("showSeparators",e);this._oList.setShowSeparators(e);}return this;};t.prototype.setUploadEnabled=function(u){if(!this.getInstantUpload()){s.info("As property instantUpload is false it is not allowed to change uploadEnabled at runtime.");}else if(this.getUploadEnabled()!==u){this.setProperty("uploadEnabled",u);this._getFileUploader().setEnabled(u);}return this;};t.prototype.setUploadUrl=function(u){if(!this.getInstantUpload()){s.info("As property instantUpload is false it is not allowed to change uploadUrl at runtime.");}else if(this.getUploadUrl()!==u){this.setProperty("uploadUrl",u);this._getFileUploader().setUploadUrl(u);}return this;};t.prototype.setInstantUpload=function(){s.error("It is not supported to change the behavior at runtime.");return this;};t.prototype.setMode=function(e){if(e===L.ListMode.Delete){this._oList.setMode(L.ListMode.None);s.info("sap.m.ListMode.Delete is not supported by UploadCollection. Value has been resetted to 'None'");}else if(e===L.ListMode.MultiSelect&&!this.getInstantUpload()){this._oList.setMode(L.ListMode.None);s.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Pending Upload. Value has been resetted to 'None'");}else{this._oList.setMode(e);}return this;};t.prototype.getMode=function(){return this._oList.getMode();};t.prototype.getToolbar=function(){return this._oHeaderToolbar;};t.prototype.getNoDataText=function(){var N=this.getProperty("noDataText");N=N||this._oRb.getText("UPLOADCOLLECTION_NO_DATA_TEXT");return N;};t.prototype.getNoDataDescription=function(){var N=this.getProperty("noDataDescription");N=N||this._oRb.getText("UPLOADCOLLECTION_NO_DATA_DESCRIPTION");return N;};t.prototype.setUploadButtonInvisible=function(u){if(this.getUploadButtonInvisible()===u){return this;}this.setProperty("uploadButtonInvisible",u,true);if(this.getInstantUpload()){this._getFileUploader().setVisible(!u);}else{this._setFileUploaderVisibility(u);}if(this._bDragDropEnabled){this._unbindDragEnterLeave();this._bDragDropEnabled=false;}else{this._bindDragEnterLeave();}return this;};t.prototype.getInternalRequestHeaderNames=function(){return[this._headerParamConst.fileNameRequestIdName,this._headerParamConst.requestIdName];};t.prototype.upload=function(){if(this.getInstantUpload()){s.error("Not a valid API call. 'instantUpload' should be set to 'false'.");}var e=this._aFileUploadersForPendingUpload.length;for(var i=0;i<e;i++){this._iUploadStartCallCounter=0;if(this._aFileUploadersForPendingUpload[i].getValue()){this._aFileUploadersForPendingUpload[i].upload();}}if(this._aFilesFromDragAndDropForPendingUpload.length>0){this._oFileUploader._sendFilesFromDragAndDrop(this._aFilesFromDragAndDropForPendingUpload);this._aFilesFromDragAndDropForPendingUpload=[];}};t.prototype.getSelectedItems=function(){var e=this._oList.getSelectedItems();return this._getUploadCollectionItemsByListItems(e);};t.prototype.getSelectedItem=function(){var e=this._oList.getSelectedItem();if(e){return this._getUploadCollectionItemByListItem(e);}return null;};t.prototype.setSelectedItemById=function(i,e){this._oList.setSelectedItemById(i+"-cli",e);this._setSelectedForItems([this._getUploadCollectionItemById(i)],e);return this;};t.prototype.setSelectedItem=function(u,e){return this.setSelectedItemById(u.getId(),e);};t.prototype.selectAll=function(){var e=this._oList.selectAll();if(e.getItems().length!==this.getItems().length){s.info("Internal 'List' and external 'UploadCollection' are not in sync.");}this._setSelectedForItems(this.getItems(),true);return this;};t.prototype.downloadItem=function(u,e){if(!this.getInstantUpload()){s.info("Download is not possible on Pending Upload mode");return false;}else{return u.download(e);}};t.prototype.openFileDialog=function(i){if(this._oFileUploader){if(i){if(!this._oFileUploader.getMultiple()){this._oItemToUpdate=i;this._oFileUploader.$().find("input[type=file]").trigger("click");}else{s.warning("Version Upload cannot be used in multiple upload mode");}}else{this._oFileUploader.$().find("input[type=file]").trigger("click");}}return this;};t.prototype.removeAggregation=function(A,v,e){var i,j,u;if(!this.getInstantUpload()&&A==="items"&&v){i=v._internalFileIdWithinDragDropArray;if(i){j=this._aFilesFromDragAndDropForPendingUpload.indexOf(i);if(j!==-1){this._aFilesFromDragAndDropForPendingUpload.splice(j,1);}}else if(Q.isNumeric(v)){u=this.getItems();this._aDeletedItemForPendingUpload.push(u[v]);}else{this._aDeletedItemForPendingUpload.push(v);}}return C.prototype.removeAggregation.apply(this,arguments);};t.prototype.removeAllAggregation=function(A,e){if(!this.getInstantUpload()&&A==="items"){if(this._aFileUploadersForPendingUpload){for(var i=0;i<this._aFileUploadersForPendingUpload.length;i++){this._aFileUploadersForPendingUpload[i].destroy();this._aFileUploadersForPendingUpload[i]=null;}this._aFileUploadersForPendingUpload=[];}}return C.prototype.removeAllAggregation.apply(this,arguments);};t.prototype.onBeforeRendering=function(){this._RenderManager=this._RenderManager||sap.ui.getCore().createRenderManager();var i,e;if(this._oListEventDelegate){this._oList.removeEventDelegate(this._oListEventDelegate);this._oListEventDelegate=null;}this._deregisterSizeHandler();this._unbindDragEnterLeave();j.bind(this)();if(!this.getInstantUpload()){this.aItems=this.getItems();this._getListHeader(this.aItems.length);this._clearList();this._fillList(this.aItems);this._oList.setHeaderToolbar(this._oHeaderToolbar);return;}if(this.aItems.length>0){e=this.aItems.length;var u=[];for(i=0;i<e;i++){if(this.aItems[i]&&this.aItems[i]._status===t._uploadingStatus){u.push(this.aItems[i]);}else if(this.aItems[i]&&this.aItems[i]._status!==t._uploadingStatus&&this.aItems[i]._percentUploaded===100&&this.getItems().length===0){u.push(this.aItems[i]);}}if(u.length!==0){this.aItems=[];this.aItems=this.getItems();this.aItems=u.concat(this.aItems);}else{this.aItems=this.getItems();}}else{this.aItems=this.getItems();}this._getListHeader(this.aItems.length);this._clearList();this._fillList(this.aItems);this._oList.setAggregation("headerToolbar",this._oHeaderToolbar,true);if(this.sErrorState!=="Error"){if(this.getUploadEnabled()!==this._oFileUploader.getEnabled()){this._oFileUploader.setEnabled(this.getUploadEnabled());}}else{this._oFileUploader.setEnabled(false);}if(this.sDeletedItemId){Q(document.activeElement).blur();}function j(){if(this.bInstantUpload===false){this.setProperty("instantUpload",this.bInstantUpload,true);delete this.bInstantUpload;}}};t.prototype.onAfterRendering=function(){this._bindDragEnterLeave();if(this.getInstantUpload()){if(this.aItems||(this.aItems===this.getItems())){if(this.editModeItem){var $=Q(document.getElementById(this.editModeItem+"-ta_editFileName-inner"));if($){var i=this.editModeItem;if(!q.os.ios){$.focus(function(){$.selectText(0,$.val().length);});}$.focus();this._oListEventDelegate={onclick:function(e){this._handleClick(e,i);}.bind(this)};this._oList.addDelegate(this._oListEventDelegate);}}else if(this.sFocusId){this._setFocusToLineItem(this.sFocusId);this.sFocusId=null;}else if(this.sDeletedItemId){this._setFocusAfterDeletion();}}}else if(this.sFocusId){this._setFocusToLineItem(this.sFocusId);this.sFocusId=null;}};t.prototype.exit=function(){var i,P,e;this._unbindDragEnterLeave();if(this._$RootNode){this._$RootNode=null;}if(this._oFileUploader){this._oFileUploader.destroy();this._oFileUploader=null;}if(this._oHeaderToolbar){this._oHeaderToolbar.destroy();this._oHeaderToolbar=null;}if(this._oNumberOfAttachmentsTitle){this._oNumberOfAttachmentsTitle.destroy();this._oNumberOfAttachmentsTitle=null;}if(this._RenderManager){this._RenderManager.destroy();}if(this._aFileUploadersForPendingUpload){P=this._aFileUploadersForPendingUpload.length;for(i=0;i<P;i++){this._aFileUploadersForPendingUpload[i].destroy();this._aFileUploadersForPendingUpload[i]=null;}this._aFileUploadersForPendingUpload=null;}for(i=0;i<this.aItems.length;i++){if(this.aItems[i]._status===t._uploadingStatus){e=this.aItems.splice(i,1)[0];if(e.destroy){e.destroy();}}}this._deregisterSizeHandler();};t.prototype._bindDragEnterLeave=function(){this._bDragDropEnabled=this._isDragAndDropAllowed();if(!this._bDragDropEnabled){return;}if(!this._oDragDropHandler){this._oDragDropHandler={dragEnterUIArea:this._onDragEnterUIArea.bind(this),dragLeaveUIArea:this._onDragLeaveUIArea.bind(this),dragOverUIArea:this._onDragOverUIArea.bind(this),dropOnUIArea:this._onDropOnUIArea.bind(this),dragEnterUploadCollection:this._onDragEnterUploadCollection.bind(this),dragLeaveUploadCollection:this._onDragLeaveUploadCollection.bind(this),dragOverUploadCollection:this._onDragOverUploadCollection.bind(this),dropOnUploadCollection:this._onDropOnUploadCollection.bind(this)};}this._$RootNode=Q(document.body);this._$RootNode.bind("dragenter",this._oDragDropHandler.dragEnterUIArea);this._$RootNode.bind("dragleave",this._oDragDropHandler.dragLeaveUIArea);this._$RootNode.bind("dragover",this._oDragDropHandler.dragOverUIArea);this._$RootNode.bind("drop",this._oDragDropHandler.dropOnUIArea);this._$DragDropArea=this.$("drag-drop-area");this.$().bind("dragenter",this._oDragDropHandler.dragEnterUploadCollection);this.$().bind("dragleave",this._oDragDropHandler.dragLeaveUploadCollection);this.$().bind("dragover",this._oDragDropHandler.dragOverUploadCollection);this.$().bind("drop",this._oDragDropHandler.dropOnUploadCollection);};t.prototype._unbindDragEnterLeave=function(){if(!this._bDragDropEnabled&&!this._oDragDropHandler){return;}if(this._$RootNode){this._$RootNode.unbind("dragenter",this._oDragDropHandler.dragEnterUIArea);this._$RootNode.unbind("dragleave",this._oDragDropHandler.dragLeaveUIArea);this._$RootNode.unbind("dragover",this._oDragDropHandler.dragOverUIArea);this._$RootNode.unbind("drop",this._oDragDropHandler.dropOnUIArea);}this.$().unbind("dragenter",this._oDragDropHandler.dragEnterUploadCollection);this.$().unbind("dragleave",this._oDragDropHandler.dragLeaveUploadCollection);this.$().unbind("dragover",this._oDragDropHandler.dragOverUploadCollection);this.$().unbind("drop",this._oDragDropHandler.dropOnUploadCollection);};t.prototype._onDragEnterUIArea=function(e){if(!this._checkForFiles(e)){return;}this._oLastEnterUIArea=e.target;this._$DragDropArea.removeClass("sapMUCDragDropOverlayHide");this._adjustDragDropIcon();};t.prototype._onDragOverUIArea=function(e){e.preventDefault();if(!this._checkForFiles(e)){return;}this._$DragDropArea.removeClass("sapMUCDragDropOverlayHide");};t.prototype._onDragLeaveUIArea=function(e){if(this._oLastEnterUIArea===e.target){this._$DragDropArea.addClass("sapMUCDragDropOverlayHide");}};t.prototype._onDropOnUIArea=function(e){this._$DragDropArea.addClass("sapMUCDragDropOverlayHide");};t.prototype._onDragEnterUploadCollection=function(e){if(!this._checkForFiles(e)){return;}if(e.target===this._$DragDropArea[0]){this._$DragDropArea.addClass("sapMUCDropIndicator");this._adjustDragDropIcon();this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DROP_FILE_INDICATOR"));}};t.prototype._onDragOverUploadCollection=function(e){e.preventDefault();};t.prototype._onDragLeaveUploadCollection=function(e){if(e.target===this._$DragDropArea[0]){this._$DragDropArea.removeClass("sapMUCDropIndicator");this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR"));}};t.prototype._checkForFiles=function(e){var j=e.originalEvent.dataTransfer.types;if(j){for(var i=0;i<j.length;i++){if(j[i]==="Files"){return true;}}}return false;};t.prototype._isDragAndDropAllowed=function(){return this.getUploadEnabled()&&!this.getUploadButtonInvisible();};t.prototype._onDropOnUploadCollection=function(e){if(!this._checkForFiles(e)){e.preventDefault();return;}if(e.target===this._$DragDropArea[0]){e.preventDefault();this._$DragDropArea.removeClass("sapMUCDropIndicator");this._$DragDropArea.addClass("sapMUCDragDropOverlayHide");this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR"));var j=e.originalEvent.dataTransfer.files;if(j.length>1&&!this.getMultiple()){var u=this._oRb.getText("UPLOADCOLLECTION_MULTIPLE_FALSE");a.error(u);return;}if(!this._oFileUploader._areFilesAllowed(j)){return;}if(!this.getInstantUpload()){for(var i=0;i<j.length;i++){this._oFileUploader.fireChange({files:[j[i]],fromDragDrop:true});this._aFilesFromDragAndDropForPendingUpload.push(j[i]);}}else{this._oFileUploader.fireChange({files:j});this._oFileUploader._sendFilesFromDragAndDrop(j);}}};t.prototype._adjustDragDropIcon=function(){if(this._$DragDropArea[0].offsetHeight<160){this.getAggregation("_dragDropIcon").$().hide();}};t.prototype._deregisterSizeHandler=function(){q.orientation.detachHandler(this._onResize,this);R.deregister(this._sReziseHandlerId);};t.prototype._hideFileUploaders=function(){var e,i;if(!this.getInstantUpload()){e=this._oHeaderToolbar.getContent().length;if(this._aFileUploadersForPendingUpload.length){for(i=0;i<e;i++){if(this._oHeaderToolbar.getContent()[i]instanceof h){if(i===this._iFileUploaderPH&&this._bFocusFileUploader){this._oHeaderToolbar.getContent()[i].$().find("button").focus();}else{this._oHeaderToolbar.getContent()[i].$().hide();}}}}}};t.prototype._truncateFileName=function(e){if(!e){return;}if(e._status==="Edit"){e._oListItem.$().find(".sapMUCObjectMarkerContainer").attr("style","display: none");return;}var j=0;var u=e.getMarkers();var v;for(var i=0;i<u.length;i++){j=j+u[i].$().width()+t._markerMargin;}if(j>0){var $=e._oFileNameLink.$();if($){v="max-width: calc(100% - "+j+"px)";if($.attr("style")!==v){$.attr("style",v);}}}};t.prototype._getListHeader=function(e){var j,i;this._setNumberOfAttachmentsTitle(e);if(!this._oHeaderToolbar){if(!!this._oFileUploader&&!this.getInstantUpload()){this._oFileUploader.destroy();}j=this._getFileUploader();this._oHeaderToolbar=this.getAggregation("toolbar");if(!this._oHeaderToolbar){this._oHeaderToolbar=new O(this.getId()+"-toolbar",{content:[this._oNumberOfAttachmentsTitle,new l(),j]}).addEventDelegate({onAfterRendering:this._hideFileUploaders},this);this._iFileUploaderPH=2;}else{this._oHeaderToolbar.addEventDelegate({onAfterRendering:this._hideFileUploaders},this);this._iFileUploaderPH=this._getFileUploaderPlaceHolderPosition(this._oHeaderToolbar);if(this._oHeaderToolbar&&this._iFileUploaderPH>-1){this._setFileUploaderInToolbar(j);}else{s.info("A place holder of type 'sap.m.UploadCollectionPlaceholder' needs to be provided.");}}}else if(!this.getInstantUpload()){var P=this._aFileUploadersForPendingUpload.length;for(i=P-1;i>=0;i--){if(this._aFileUploadersForPendingUpload[i].getId()===this._oFileUploader.getId()){j=this._getFileUploader();this._oHeaderToolbar.insertAggregation("content",j,this._iFileUploaderPH,true);break;}}}};t.prototype._getFileUploaderPlaceHolderPosition=function(e){for(var i=0;i<e.getContent().length;i++){if(e.getContent()[i]instanceof o){return i;}}return-1;};t.prototype._setFileUploaderInToolbar=function(e){this._oHeaderToolbar.getContent()[this._iFileUploaderPH].setVisible(false);this._oHeaderToolbar.insertContent(e,this._iFileUploaderPH);};t.prototype._mapItemToListItem=function(i){if(!i||(this._oItemToUpdate&&i.getId()===this._oItemToUpdate.getId())){return null;}var e,j,u,v,w,x,$,y,z;e=i.getId();j=i._status;u=i.getFileName();if(j===t._uploadingStatus){v=new g({id:e+"-ia_indicator"});v.addStyleClass("sapMUCloadingIcon");}else{z=this._createIcon(i,e,u);}x=e+"-container";$=Q(document.getElementById(x));if($){$.remove();$=null;}y=new H({content:"<span id="+x+" class='sapMUCTextButtonContainer'></span>",afterRendering:this._renderContent.bind(this,i,x)});w=new p(e+"-cli",{content:[v,z,y],selected:i.getSelected()});w._oUploadCollectionItem=i;w._status=j;w.addStyleClass("sapMUCItem");w.setTooltip(i.getTooltip_Text());i._oListItem=w;return w;};t.prototype._renderContent=function(e,j){var u,i,A,v,w,P,x,y,z,E,G;P=e._percentUploaded;x=e.getAllAttributes();y=e.getStatuses();G=e.getMarkers();u=e.getId();A=x.length;v=y.length;w=G.length;E=e._status;z=this._RenderManager;z.write("<div class=\"sapMUCTextContainer ");if(E==="Edit"){z.write("sapMUCEditMode ");}z.write("\" >");z.renderControl(this._getFileNameControl(e));if(E===t._uploadingStatus){z.renderControl(this._createProgressLabel(e,P));}else{if(w>0){z.write("<div class=\"sapMUCObjectMarkerContainer\">");for(i=0;i<w;i++){z.renderControl(G[i].addStyleClass("sapMUCObjectMarker"));}z.write("</div>");}if(A>0){z.write("<div class=\"sapMUCAttrContainer\">");for(i=0;i<A;i++){x[i].addStyleClass("sapMUCAttr");z.renderControl(x[i]);if((i+1)<A){z.write("<div class=\"sapMUCSeparator\">&nbsp&#x00B7&#160</div>");}}z.write("</div>");}if(v>0){z.write("<div class=\"sapMUCStatusContainer\">");for(i=0;i<v;i++){y[i].detachBrowserEvent("hover");z.renderControl(y[i]);if((i+1)<v){z.write("<div class=\"sapMUCSeparator\">&nbsp&#x00B7&#160</div>");}}z.write("</div>");}}z.write("</div>");this._renderButtons(z,e,E,u);z.flush(Q(document.getElementById(j))[0],true);this._truncateFileName(e);this._sReziseHandlerId=R.register(this,this._onResize.bind(this));q.orientation.attachHandler(this._onResize,this);};t.prototype._renderButtons=function(e,j,u,v){var w,x;w=this._getButtons(j,u,v);if(w){x=w.length;}if(x>0){e.write("<div class=\"sapMUCButtonContainer\">");for(var i=0;i<x;i++){if((i+1)<x){w[i].addStyleClass("sapMUCFirstButton");}e.renderControl(w[i]);}e.write("</div>");}};t.prototype._getFileNameControl=function(i){var e,j,u,v,w,x,y,V,z,A,E;v=i.getFileName();w=i.getId();x=i._status;if(x!=="Edit"){e=i._getFileNameLink?i._getFileNameLink():i._getControl("sap.m.Link",{id:w+"-ta_filenameHL",press:[i,this._onItemPressed,this]},"FileNameLink");e.setEnabled(this._getItemPressEnabled(i));e.addStyleClass("sapMUCFileName");e.setModel(i.getModel());e.setText(v);i._oFileNameLink=e;return e;}else{j=t._splitFilename(v);y=this.getMaximumFilenameLength();V="None";z=false;u=j.name;if(i.errorState==="Error"){z=true;V="Error";u=i.changedFileName;if(u.length===0){E=this._oRb.getText("UPLOADCOLLECTION_TYPE_FILENAME");}else{E=this._oRb.getText("UPLOADCOLLECTION_EXISTS");}}A=i._getFileNameEditBox?i._getFileNameEditBox():i._getControl("sap.m.Input",{id:w+"-ta_editFileName",type:L.InputType.Text},"FileNameEditBox");A.addStyleClass("sapMUCEditBox");A.setModel(i.getModel());A.setValue(u);A.setValueState(V);A.setFieldWidth("75%");A.setValueStateText(E);A.setDescription(j.extension);A.setShowValueStateMessage(z);if((y-j.extension.length)>0){A.setProperty("maxLength",y-j.extension.length,true);}return A;}};t.prototype._getItemPressEnabled=function(i){return i._getPressEnabled()&&this.sErrorState!=="Error";};t.prototype._onItemPressed=function(e,i){if(i.hasListeners("press")){i.firePress();}else if(this.sErrorState!=="Error"&&Q.trim(i.getProperty("url"))){this._triggerLink(e);}};t.prototype._createProgressLabel=function(i,e){var P,j=i.getId();P=i._getProgressLabel?i._getProgressLabel():i._getControl("sap.m.Label",{id:j+"-ta_progress"},"ProgressLabel").addStyleClass("sapMUCProgress");P.setText(this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[e]));return P;};t.prototype._createIcon=function(i,e,j){var u,v,w,x;u=i.getThumbnailUrl();if(u){w=b.createControlByURI({id:e+"-ia_imageHL",src:this._getThumbnail(u,j),decorative:false},c).addStyleClass("sapMUCItemImage sapMUCItemIcon");w.setAlt(this._getAriaLabelForPicture(i));}else{v=this._getThumbnail(undefined,j);w=new I(e+"-ia_iconHL",{src:v,decorative:false,useIconTooltip:false});w.setAlt(this._getAriaLabelForPicture(i));if(this.sErrorState!=="Error"&&Q.trim(i.getProperty("url"))){x="sapMUCItemIcon";}else{x="sapMUCItemIconInactive";}if(v===t._placeholderCamera){if(this.sErrorState!=="Error"&&Q.trim(i.getProperty("url"))){x=x+" sapMUCItemPlaceholder";}else{x=x+" sapMUCItemPlaceholderInactive";}}w.addStyleClass(x);}if(this._getItemPressEnabled(i)){w.attachPress(i,this._onItemPressed,this);}return w;};t.prototype._getButtons=function(i,e,j){var u,v,w,x,y,E,z;u=[];if(!this.getInstantUpload()){x="deleteButton";y=this._createDeleteButton(j,x,i,this.sErrorState);u.push(y);return u;}if(e==="Edit"){v=i._getOkButton?i._getOkButton():i._getControl("sap.m.Button",{id:j+"-okButton",text:this._oRb.getText("UPLOADCOLLECTION_RENAMEBUTTON_TEXT"),type:L.ButtonType.Transparent},"OkButton").addStyleClass("sapMUCOkBtn");w=i._getCancelButton?i._getCancelButton():i._getControl("sap.m.Button",{id:j+"-cancelButton",text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),type:L.ButtonType.Transparent},"CancelButton").addStyleClass("sapMUCCancelBtn");u.push(v);u.push(w);}else if(e===t._uploadingStatus){x="terminateButton";y=this._createDeleteButton(j,x,i,this.sErrorState);u.push(y);}else{E=i.getEnableEdit();if(this.sErrorState==="Error"){E=false;}if(i.getVisibleEdit()){z=i._getEditButton?i._getEditButton():i._getControl("sap.m.Button",{id:j+"-editButton",icon:"sap-icon://edit",type:L.ButtonType.Standard,tooltip:this._oRb.getText("UPLOADCOLLECTION_EDITBUTTON_TEXT"),press:[i,this._handleEdit,this]},"EditButton").addStyleClass("sapMUCEditBtn");z.setEnabled(E);z.setVisible(i.getVisibleEdit());u.push(z);}x="deleteButton";if(i.getVisibleDelete()){y=this._createDeleteButton(j,x,i,this.sErrorState);u.push(y);}}return u;};t.prototype._createDeleteButton=function(i,e,j,u){var E,v,G,w,x,V,P;E=j.getEnableDelete();if(u==="Error"){E=false;}if(e==="deleteButton"){G="DeleteButton";x=j._getDeleteButton;w=this._oRb.getText("UPLOADCOLLECTION_DELETEBUTTON_TEXT");V=j.getVisibleDelete();P=[this,this._handleDelete,this];}else{G="TerminateButton";x=j._getTerminateButton;w=this._oRb.getText("UPLOADCOLLECTION_TERMINATEBUTTON_TEXT");V=this.getTerminationEnabled();P=[j,this._handleTerminate,this];}v=x?x():j._getControl("sap.m.Button",{id:i+"-"+e,icon:"sap-icon://sys-cancel",type:L.ButtonType.Standard,press:P},G).addStyleClass("sapMUCDeleteBtn");v.setVisible(V);v.setEnabled(E);v.setTooltip(w);return v;};t.prototype._fillList=function(i){var e=this,j=i.length-1,u=this.getBinding("items"),G=false,v,w=this.getBindingInfo("items")?this.getBindingInfo("items").model:undefined,x=this.getBindingInfo("items")?this.getBindingInfo("items").groupHeaderFactory:null;var y=function(A){return A.getBindingContext(w)?u.getGroup(A.getBindingContext(w)):null;};var z=function(A){return y(A)&&y(A).key;};Q.each(i,function(A,E){if(u&&u.isGrouped()&&E){if(!G||v!==z(E)){if(x){e._oList.addItemGroup(y(E),x(y(E)),true);}else if(y(E)){e._oList.addItemGroup(y(E),null,true);}G=true;v=z(E);}}if(!E._status){E._status=t._displayStatus;}else if(e.getInstantUpload()&&e._oItemForDelete&&e._oItemForDelete._status===t._toBeDeletedStatus&&E.getDocumentId()===e._oItemForDelete.documentId){return false;}if(!E._percentUploaded&&E._status===t._uploadingStatus){E._percentUploaded=0;}var J=e._mapItemToListItem(E);if(J){if(A===0&&j===0){J.addStyleClass("sapMUCListSingleItem");}else if(A===0){J.addStyleClass("sapMUCListFirstItem");}else if(A===j){J.addStyleClass("sapMUCListLastItem");}else{J.addStyleClass("sapMUCListItem");}e._oList.addAggregation("items",J,true);E.attachEvent("selected",e._handleItemSetSelected,e);}return true;});};t.prototype._clearList=function(){if(this._oList){this._oList.destroyAggregation("items",true);}};t.prototype._setNumberOfAttachmentsTitle=function(e){var i=e||0;var j;if(this._oItemToUpdate){i--;}if(this.getNumberOfAttachmentsText()){j=this.getNumberOfAttachmentsText();}else{j=this._oRb.getText("UPLOADCOLLECTION_ATTACHMENTS",[i]);}if(!this._oNumberOfAttachmentsTitle){this._oNumberOfAttachmentsTitle=new d(this.getId()+"-numberOfAttachmentsTitle",{text:j});}else{this._oNumberOfAttachmentsTitle.setText(j);}};t.prototype._setFileUploaderVisibility=function(u){var e=this._oHeaderToolbar.getContent();if(e){var P=e[this._iFileUploaderPH];if(P instanceof h){P.setVisible(!u);}}};t.prototype._handleDelete=function(e){var P=e.getParameters();var j=this.getItems();var u=P.id.split("-deleteButton")[0];var v;var w;var x="";var y;var z;for(var i=0;i<j.length;i++){if(j[i].sId===u){w=i;v={documentId:j[i].getDocumentId(),_iLineNumber:w};break;}}if(j[w].hasListeners("deletePress")){j[w].fireDeletePress();return;}this.sDeletedItemId=u;if(Q(document.getElementById(this.sId)).hasClass("sapUiSizeCompact")){x="sapUiSizeCompact";}if(this.editModeItem){this._handleOk(e,this.editModeItem,true);if(this.sErrorState==="Error"){return;}}if(j[w]&&j[w].getEnableDelete()){y=j[w].getFileName();if(!y){z=this._oRb.getText("UPLOADCOLLECTION_DELETE_WITHOUT_FILENAME_TEXT");}else{z=this._oRb.getText("UPLOADCOLLECTION_DELETE_TEXT",y);}this._oItemForDelete=v;a.show(z,{title:this._oRb.getText("UPLOADCOLLECTION_DELETE_TITLE"),actions:[a.Action.OK,a.Action.CANCEL],onClose:this._onCloseMessageBoxDeleteItem.bind(this),dialogId:"messageBoxDeleteFile",styleClass:x});}};t.prototype._onCloseMessageBoxDeleteItem=function(e){var j=this.getItems();var u;if(this.getInstantUpload()){for(var i=0;i<j.length;i++){if(j[i].getDocumentId()===this._oItemForDelete.documentId){u=j[i];}}}else{u=j[this._oItemForDelete._iLineNumber];}if(e===a.Action.OK){this._oItemForDelete._status=t._toBeDeletedStatus;if(this.getInstantUpload()){this.fireFileDeleted({documentId:this._oItemForDelete.documentId,item:u});this._oItemForDelete=null;}else{if(this.aItems.length===1){if(!this.getUploadButtonInvisible()){this.sFocusId=this._oFileUploader.$().find(":button")[0].id;}}else if(this._oItemForDelete._iLineNumber<this.aItems.length-1){this.sFocusId=this.aItems[this._oItemForDelete._iLineNumber+1].getId()+"-cli";}else{this.sFocusId=this.aItems[0].getId()+"-cli";}this._aDeletedItemForPendingUpload.push(u);this.aItems.splice(this._oItemForDelete._iLineNumber,1);this.removeAggregation("items",u,false);}}};t.prototype._handleTerminate=function(e,j){var u,v;u=new f({items:[new S({title:j.getFileName(),icon:this._getIconFromFilename(j.getFileName())})]});v=new D({id:this.getId()+"deleteDialog",title:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TITLE"),content:[new T({text:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TEXT")}),u],buttons:[new B({text:this._oRb.getText("UPLOADCOLLECTION_OKBUTTON_TEXT"),press:[w,this]}),new B({text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),press:function(){v.close();}})],afterClose:function(){v.destroy();}}).open();function w(){var A=false;for(var i=0;i<this.aItems.length;i++){if(this.aItems[i]._status===t._uploadingStatus&&this.aItems[i]._requestIdName===j._requestIdName){this.aItems[i]._status=t._toBeDeletedStatus;this._oItemForDelete=this.aItems[i];A=true;break;}else if(j.getFileName()===this.aItems[i].getFileName()&&this.aItems[i]._status===t._displayStatus){this.aItems[i]._status=t._toBeDeletedStatus;this._oItemForDelete=this.aItems[i];this.fireFileDeleted({documentId:this.aItems[i].getDocumentId(),item:this.aItems[i]});break;}}if(A){this._getFileUploader().abort(this._headerParamConst.fileNameRequestIdName,this._encodeToAscii(j.getFileName())+this._oItemForDelete._requestIdName);}v.close();this.invalidate();}};t.prototype._handleEdit=function(e,j){var i,u=j.getId(),v=this.aItems.length;if(this.editModeItem){this._handleOk(e,this.editModeItem,false);}if(this.sErrorState!=="Error"){for(i=0;i<v;i++){if(this.aItems[i].getId()===u){this.aItems[i]._status="Edit";break;}}j._status="Edit";this.editModeItem=e.getSource().getId().split("-editButton")[0];this.invalidate();}};t.prototype._handleClick=function(e,i){var $=Q(e.target).closest("button");var j="";if($.length){j=$.prop("id");}if(j.lastIndexOf("editButton")===-1){if(j.lastIndexOf("cancelButton")!==-1){this._handleCancel(e,i);}else if(e.target.id.lastIndexOf("ia_imageHL")<0&&e.target.id.lastIndexOf("ia_iconHL")<0&&e.target.id.lastIndexOf("deleteButton")<0&&e.target.id.lastIndexOf("ta_editFileName-inner")<0){if(e.target.id.lastIndexOf("cli")>0){this.sFocusId=e.target.id;}this._handleOk(e,i,true);}}};t.prototype._handleOk=function(e,i,j){var E=document.getElementById(i+"-ta_editFileName-inner");var N;var u=t._findById(i,this.aItems);var v=u.getProperty("fileName");var w=t._splitFilename(v);var x=sap.ui.getCore().byId(i+"-ta_editFileName");var y=u.errorState;var z=u.changedFileName;if(E!==null){N=E.value.replace(/^\s+/,"");}this.sFocusId=i+"-cli";if(!N||N.length===0){if(E!==null){this._setErrorStateOnItem(this,u,N,z,y);}return;}u._status=t._displayStatus;if(w.name===N){this._removeErrorStateFromItem(this,u);if(j){this.invalidate();}return;}if(this.getSameFilenameAllowed()){this._removeErrorStateFromItem(this,u);this._oItemForRename=u;this._onEditItemOk.bind(this)(N+w.extension);return;}if(t._checkDoubleFileName(N+w.extension,this.aItems)){x.setProperty("valueState","Error",true);this._setErrorStateOnItem(this,u,N,z,y);}else{x.setProperty("valueState","None",true);u.changedFileName=null;this._removeErrorStateFromItem(this,u);if(j){this.invalidate();}this._oItemForRename=u;this._onEditItemOk.bind(this)(N+w.extension);}};t.prototype._setErrorStateOnItem=function(e,i,N,j,E){i._status="Edit";i.errorState="Error";e.sErrorState="Error";i.changedFileName=N;if(E!=="Error"||j!==N){e.invalidate();}};t.prototype._removeErrorStateFromItem=function(e,i){i.errorState=null;e.sErrorState=null;e.editModeItem=null;};t.prototype._onEditItemOk=function(N){if(this._oItemForRename){this._oItemForRename.setFileName(N);this.fireFileRenamed({documentId:this._oItemForRename.getProperty("documentId"),fileName:N,item:this._oItemForRename});}delete this._oItemForRename;};t.prototype._handleCancel=function(e,i){var j=t._findById(i,this.aItems);j._status=t._displayStatus;j.errorState=null;j.changedFileName=j._getFileNameEditBox().getValue();this.sFocusId=this.editModeItem+"-cli";this.sErrorState=null;this.editModeItem=null;this.invalidate();};t.prototype._onChange=function(e){if(e){var j,u=e.getParameter("files").length,i,v,w,x,A;if(u===0){return;}this._oFileUploader.removeAllAggregation("headerParameters",true);this.removeAllAggregation("headerParameters",true);this._oFileUploader.removeAllAggregation("parameters",true);this.removeAllAggregation("parameters",true);this.fireChange({getParameter:function(z){if(z){return e.getParameter(z);}return null;},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:e.getParameter("files")});var P=this.getAggregation("parameters");if(P){Q.each(P,function(z,E){var G=new F({name:E.getProperty("name"),value:E.getProperty("value")});this._oFileUploader.addParameter(G);}.bind(this));}if(!this.getInstantUpload()){this._bFocusFileUploader=true;w=t._pendingUploadStatus;}else{w=t._uploadingStatus;}this._requestIdValue++;j=this._requestIdValue.toString();var y=this.getAggregation("headerParameters");if(!this.getInstantUpload()){this._aFileUploadersForPendingUpload.push(this._oFileUploader);}for(i=0;i<u;i++){v=new U({fileName:e.getParameter("files")[i].name});if(e.getParameter("fromDragDrop")){v._internalFileIdWithinDragDropArray=e.getParameter("files")[i];}v._status=w;v._internalFileIndexWithinFileUploader=i+1;v._requestIdName=j;if(!this.getInstantUpload()){v.setAssociation("fileUploader",this._oFileUploader,true);x=this._oFormatDecimal.format(e.getParameter("files")[i].size);A=new m({text:x});v.insertAggregation("attributes",A,true);this.insertItem(v);}else{v._percentUploaded=0;}this.aItems.unshift(v);}if(y){Q.each(y,function(z,E){this._oFileUploader.addHeaderParameter(new F({name:E.getProperty("name"),value:E.getProperty("value")}));}.bind(this));}this._oFileUploader.addHeaderParameter(new F({name:this._headerParamConst.requestIdName,value:j}));}};t.prototype._onFilenameLengthExceed=function(e){var i={name:e.getParameter("fileName")};var j=[i];this.fireFilenameLengthExceed({getParameter:function(P){if(P){return e.getParameter(P);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:j});};t.prototype._onFileSizeExceed=function(e){var i={name:e.getParameter("fileName"),fileSize:e.getParameter("fileSize")};this.fireFileSizeExceed({getParameter:function(P){if(P){return e.getParameter(P);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:[i]});};t.prototype._onTypeMissmatch=function(e){var i={name:e.getParameter("fileName"),fileType:e.getParameter("fileType"),mimeType:e.getParameter("mimeType")};var j=[i];this.fireTypeMissmatch({getParameter:function(P){if(P){return e.getParameter(P);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:j});};t.prototype._onUploadTerminated=function(e){var i;var j=this._getRequestId(e);var u=e.getParameter("fileName");var v=this.aItems.length;for(i=0;i<v;i++){if(this.aItems[i]&&this.aItems[i].getFileName()===u&&this.aItems[i]._requestIdName===j&&(this.aItems[i]._status===t._uploadingStatus||this.aItems[i]._status===t._toBeDeletedStatus)){this.aItems.splice(i,1);this.removeItem(i);break;}}this.fireUploadTerminated({fileName:u,getHeaderParameter:this._getHeaderParameterWithinEvent.bind(e)});};t.prototype._onUploadComplete=function(e){if(e){var i,j=this._getRequestId(e),u=e.getParameter("fileName"),v,w,x,y=z();v=this.aItems.length;x=[t._uploadingStatus,t._pendingUploadStatus];for(i=0;i<v;i++){if((!j||this.aItems[i]._requestIdName===j)&&this.aItems[i].getProperty("fileName")===u&&(x.indexOf(this.aItems[i]._status)>=0)){if(y&&this.aItems[i]._status!==t._pendingUploadStatus){this.aItems[i]._percentUploaded=100;this.aItems[i]._status=t._displayStatus;}w=this.aItems.splice(i,1)[0];if(w.destroy){w.destroy();}this._oItemToUpdate=null;break;}}this.fireUploadComplete({getParameter:e.getParameter,getParameters:e.getParameters,mParameters:e.getParameters(),files:[{fileName:e.getParameter("fileName")||u,responseRaw:e.getParameter("responseRaw"),reponse:e.getParameter("response"),response:e.getParameter("response"),status:e.getParameter("status"),headers:e.getParameter("headers")}]});}this.invalidate();function z(){var A=e.getParameter("status").toString()||"200";return A[0]==="2"||A[0]==="3";}};t.prototype._onUploadProgress=function(e){if(!e||!this.getInstantUpload()){return;}var u=e.getParameter("fileName"),P,j=Math.round(e.getParameter("loaded")/e.getParameter("total")*100),v=this._getRequestId(e),w=this.aItems.length,x,$,y;if(j===100){P=this._oRb.getText("UPLOADCOLLECTION_UPLOAD_COMPLETED");}else{P=this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[j]);}for(var i=0;i<w;i++){y=this.aItems[i];if(y.getProperty("fileName")===u&&y._requestIdName===v&&y._status===t._uploadingStatus){x=y._getProgressLabel?y._getProgressLabel():y._getControl("sap.m.Label",{id:y.getId()+"-ta_progress"},"ProgressLabel");if(x){x.setText(P);y._percentUploaded=j;$=Q(document.getElementById(y.getId()+"-ia_indicator"));if(j===100){$.attr("aria-label",P);}else{$.attr("aria-valuenow",j);}break;}}}};t.prototype._getRequestId=function(e){var i;i=e.getParameter("requestHeaders");if(!i){return null;}for(var j=0;j<i.length;j++){if(i[j].name===this._headerParamConst.requestIdName){return i[j].value;}}return null;};t.prototype._getFileUploader=function(){var u=this.getInstantUpload();if(!u||!this._oFileUploader){var e=this.getInstantUpload()?this._oRb.getText("UPLOADCOLLECTION_UPLOAD"):this._oRb.getText("UPLOADCOLLECTION_ADD");this._iFUCounter=this._iFUCounter+1;this._oFileUploader=new h(this.getId()+"-"+this._iFUCounter+"-uploader",{buttonOnly:true,buttonText:e,tooltip:e,iconOnly:true,enabled:this.getUploadEnabled(),fileType:this.getFileType(),icon:"sap-icon://add",iconFirst:false,style:"Transparent",maximumFilenameLength:this.getMaximumFilenameLength(),maximumFileSize:this.getMaximumFileSize(),mimeType:this.getMimeType(),multiple:this.getMultiple(),name:"uploadCollection",uploadOnChange:u,sameFilenameAllowed:true,uploadUrl:this.getUploadUrl(),useMultipart:false,sendXHR:true,change:[this._onChange,this],filenameLengthExceed:[this._onFilenameLengthExceed,this],fileSizeExceed:[this._onFileSizeExceed,this],typeMissmatch:[this._onTypeMissmatch,this],uploadAborted:[this._onUploadTerminated,this],uploadComplete:[this._onUploadComplete,this],uploadProgress:[this._onUploadProgress,this],uploadStart:[this._onUploadStart,this],visible:!this.getUploadButtonInvisible()});}return this._oFileUploader;};t.prototype._onUploadStart=function(e){var j,i,u,P,v,G;this._iUploadStartCallCounter++;P=e.getParameter("requestHeaders").length;for(i=0;i<P;i++){if(e.getParameter("requestHeaders")[i].name===this._headerParamConst.requestIdName){u=e.getParameter("requestHeaders")[i].value;break;}}v=e.getParameter("fileName");j={name:this._headerParamConst.fileNameRequestIdName,value:this._encodeToAscii(v)+u};e.getParameter("requestHeaders").push(j);for(i=0;i<this._aDeletedItemForPendingUpload.length;i++){if(this._aDeletedItemForPendingUpload[i].getAssociation("fileUploader")===e.oSource.sId&&this._aDeletedItemForPendingUpload[i].getFileName()===v&&this._aDeletedItemForPendingUpload[i]._internalFileIndexWithinFileUploader===this._iUploadStartCallCounter){e.getSource().abort(this._headerParamConst.fileNameRequestIdName,this._encodeToAscii(v)+u);return;}}this.fireBeforeUploadStarts({fileName:v,addHeaderParameter:w,getHeaderParameter:x.bind(this)});if(Array.isArray(G)){for(i=0;i<G.length;i++){if(e.getParameter("requestHeaders")[i].name===G[i].getName()){e.getParameter("requestHeaders")[i].value=G[i].getValue();}}}else if(G instanceof n){for(i=0;i<e.getParameter("requestHeaders").length;i++){if(e.getParameter("requestHeaders")[i].name===G.getName()){e.getParameter("requestHeaders")[i].value=G.getValue();break;}}}function w(y){var j={name:y.getName(),value:y.getValue()};e.getParameter("requestHeaders").push(j);}function x(y){G=this._getHeaderParameterWithinEvent.bind(e)(y);return G;}};t.prototype._getIconFromFilename=function(e){var i=t._splitFilename(e).extension;if(Q.type(i)==="string"){i=i.toLowerCase();}switch(i){case".bmp":case".jpg":case".jpeg":case".png":return t._placeholderCamera;case".csv":case".xls":case".xlsx":return"sap-icon://excel-attachment";case".doc":case".docx":case".odt":return"sap-icon://doc-attachment";case".pdf":return"sap-icon://pdf-attachment";case".ppt":case".pptx":return"sap-icon://ppt-attachment";case".txt":return"sap-icon://document-text";default:return"sap-icon://document";}};t.prototype._getThumbnail=function(e,i){if(e){return e;}else{return this._getIconFromFilename(i);}};t.prototype._triggerLink=function(e){var i,j;if(this.editModeItem){this._handleOk(e,this.editModeItem,true);if(this.sErrorState==="Error"){return;}this.sFocusId=e.getParameter("id");}j=e.oSource.getId().split("-");i=j[j.length-2];M.URLHelper.redirect(this.aItems[i].getProperty("url"),true);};t.prototype.onkeydown=function(e){switch(e.keyCode){case K.F2:this._handleF2(e);break;case K.ESCAPE:this._handleESC(e);break;case K.DELETE:this._handleDEL(e);break;case K.ENTER:this._handleENTER(e);break;default:return;}e.setMarked();};t.prototype._setFocusAfterDeletion=function(){var i=this.aItems.length;var e;if(i===0){this._oFileUploader.focus();}else{var j=this.sDeletedItemId.split("-").pop();if(j<=i-1){e=this.sDeletedItemId+"-cli";}else{e=this.aItems[this.aItems.length-1].sId+"-cli";}this._setFocusToLineItem(e);}this.sDeletedItemId=null;};t.prototype._setFocusToLineItem=function(i){Q(document.getElementById(i)).focus();};t.prototype._handleENTER=function(e){var i,j,u,v;if(this.editModeItem){i=e.target.id.split(this.editModeItem).pop();}else{i=e.target.id.split("-").pop();}switch(i){case"-ta_editFileName-inner":case"-okButton":this._handleOk(e,this.editModeItem,true);break;case"-cancelButton":e.preventDefault();this._handleCancel(e,this.editModeItem);break;case"-ia_iconHL":case"-ia_imageHL":v=this.editModeItem.split("-").pop();M.URLHelper.redirect(this.aItems[v].getProperty("url"),true);break;case"ia_iconHL":case"ia_imageHL":case"cli":j=e.target.id.split(i)[0]+"ta_filenameHL";u=sap.ui.getCore().byId(j);if(u.getEnabled()){v=e.target.id.split("-")[2];M.URLHelper.redirect(this.aItems[v].getProperty("url"),true);}break;default:break;}};t.prototype._handleDEL=function(e){if(!this.editModeItem){var i=e.target.id.slice(0,-4),j=sap.ui.getCore().byId(i),u=j&&j._getDeleteButton&&j._getDeleteButton();if(u){u.firePress();}}};t.prototype._handleESC=function(e){if(this.editModeItem){this.sFocusId=this.editModeItem+"-cli";this.aItems[this.editModeItem.split("-").pop()]._status=t._displayStatus;this._handleCancel(e,this.editModeItem);}};t.prototype._handleF2=function(e){var i=sap.ui.getCore().byId(e.target.id);if(i!==undefined){if(i._status===t._displayStatus){var j=Q(document.getElementById(e.target.id));var u=j.find("[id$='-editButton']");var E=sap.ui.getCore().byId(u[0].id);if(E.getEnabled()){if(this.editModeItem){this._handleClick(e,this.editModeItem);}if(this.sErrorState!=="Error"){E.firePress();}}}else{this._handleClick(e,this.editModeItem);}}else if(e.target.id.search(this.editModeItem)===0){this._handleOk(e,this.editModeItem,true);}};t._checkDoubleFileName=function(e,j){if(j.length===0||!e){return false;}var u=j.length;e=e.replace(/^\s+/,"");for(var i=0;i<u;i++){if(e===j[i].getProperty("fileName")){return true;}}return false;};t._splitFilename=function(e){var i={};var N=e.split(".");if(N.length===1){i.extension="";i.name=N.pop();return i;}i.extension="."+N.pop();i.name=N.join(".");return i;};t.prototype._getAriaLabelForPicture=function(i){var e;e=(i.getAriaLabelForPicture()||i.getFileName());return e;};t.prototype._getHeaderParameterWithinEvent=function(e){var u=[];var j=this.getParameter("requestHeaders");var P=j.length;var i;if(j&&e){for(i=0;i<P;i++){if(j[i].name===e){return new n({name:j[i].name,value:j[i].value});}}return null;}else if(j){for(i=0;i<P;i++){u.push(new n({name:j[i].name,value:j[i].value}));}return u;}};t.prototype._encodeToAscii=function(v){var e="";for(var i=0;i<v.length;i++){e=e+v.charCodeAt(i);}return e;};t.prototype._onResize=function(){var e=this._oList.getItems();for(var i=0;i<e.length;i++){var j=e[i];setTimeout(function(){var u=this._truncateFileName.bind(this);if(typeof u==="string"||u instanceof String){u=this[u];}u.apply(this,[j._oUploadCollectionItem]||[]);}.bind(this),t._resizeTimeoutInterval);}};t.prototype._getUploadCollectionItemByListItem=function(e){var A=this.getItems();for(var i=0;i<A.length;i++){if(A[i].getId()===e.getId().replace("-cli","")){return A[i];}}return null;};t.prototype._getUploadCollectionItemById=function(u){var A=this.getItems();for(var i=0;i<A.length;i++){if(A[i].getId()===u){return A[i];}}return null;};t.prototype._getUploadCollectionItemsByListItems=function(e){var u=[];var v=this.getItems();if(e){for(var i=0;i<e.length;i++){for(var j=0;j<v.length;j++){if(e[i].getId().replace("-cli","")===v[j].getId()){u.push(v[j]);break;}}}return u;}return null;};t.prototype._setSelectedForItems=function(u,e){if(this.getMode()!==L.ListMode.MultiSelect&&e){var v=this.getItems();for(var j=0;j<v.length;j++){v[j].setSelected(false);}}for(var i=0;i<u.length;i++){u[i].setSelected(e);}};t.prototype._handleItemSetSelected=function(e){var i=e.getSource();if(i instanceof U){var j=this._getListItemById(i.getId()+"-cli");if(j){j.setSelected(i.getSelected());}}};t.prototype._handleSelectionChange=function(e){var i=e.getParameter("listItem");var j=e.getParameter("selected");var u=this._getUploadCollectionItemsByListItems(e.getParameter("listItems"));var v=this._getUploadCollectionItemByListItem(i);if(v&&i&&u){this.fireSelectionChange({selectedItem:v,selectedItems:u,selected:j});v.setSelected(i.getSelected());}};t.prototype._getListItemById=function(e){var i=this._oList.getItems();return t._findById(e,i);};t._findById=function(e,j){for(var i=0;i<j.length;i++){if(j[i].getId()===e){return j[i];}}return null;};return t;});
