/*
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/thirdparty/jquery','./Manifest','./ComponentMetadata','./Element','sap/base/util/merge','sap/ui/base/ManagedObject','sap/ui/base/ManagedObjectRegistry','sap/ui/thirdparty/URI','sap/ui/performance/trace/Interaction','sap/base/assert','sap/base/Log','sap/base/util/ObjectPath','sap/base/util/UriParameters','sap/base/util/isPlainObject','sap/base/util/LoaderExtensions','sap/ui/VersionInfo'],function(q,M,C,E,a,b,c,U,I,d,L,O,f,g,h,V){"use strict";var j={JSON:"JSON",XML:"XML",HTML:"HTML",JS:"JS",Template:"Template"};function k(e){['sap-client','sap-server'].forEach(function(N){if(!e.hasSearch(N)){var v=sap.ui.getCore().getConfiguration().getSAPParam(N);if(v){e.addSearch(N,v);}}});}function l(D,m,S,e){if(S){for(var N in D){if(!m[N]&&S[N]&&S[N].uri){m[N]=e;}}}}function n(m,e,K,i){var D=e.getEntry(K);if(D!==undefined&&!g(D)){return D;}var P,v;if(i&&(P=m.getParent())instanceof C){v=P.getManifestEntry(K,i);}if(v||D){D=q.extend(true,{},v,D);}return D;}function o(e,i){var v=Object.create(Object.getPrototypeOf(e));v._oMetadata=e;v._oManifest=i;for(var m in e){if(!/^(getManifest|getManifestObject|getManifestEntry|getMetadataVersion)$/.test(m)&&typeof e[m]==="function"){v[m]=e[m].bind(e);}}v.getManifest=function(){return i&&i.getJson();};v.getManifestObject=function(){return i;};v.getManifestEntry=function(K,A){return n(e,i,K,A);};v.getMetadataVersion=function(){return 2;};return v;}function r(e,i,T){d(typeof e==="function","fn must be a function");var m=b._sOwnerId;try{b._sOwnerId=i;return e.call(T);}finally{b._sOwnerId=m;}}var p=b.extend("sap.ui.core.Component",{constructor:function(i,S){var e=Array.prototype.slice.call(arguments);if(typeof i!=="string"){S=i;i=undefined;}if(S&&typeof S._metadataProxy==="object"){this._oMetadataProxy=S._metadataProxy;this._oManifest=S._metadataProxy._oManifest;delete S._metadataProxy;this.getMetadata=function(){return this._oMetadataProxy;};}if(S&&typeof S._cacheTokens==="object"){this._mCacheTokens=S._cacheTokens;delete S._cacheTokens;}if(S&&typeof S._manifestModels==="object"){this._mManifestModels=S._manifestModels;delete S._manifestModels;}else{this._mManifestModels={};}this._mServices={};b.apply(this,e);},metadata:{stereotype:"component","abstract":true,specialSettings:{componentData:'any'},version:"0.0",includes:[],dependencies:{libs:[],components:[],ui5version:""},config:{},customizing:{},library:"sap.ui.core"}},C);c.apply(p,{onDeregister:function(e){E.registry.forEach(function(i){if(i._sapui_candidateForDestroy&&i._sOwnerId===e&&!i.getParent()){L.debug("destroying dangling template "+i+" when destroying the owner component");i.destroy();}});}});p.prototype.getManifest=function(){if(!this._oManifest){return this.getMetadata().getManifest();}else{return this._oManifest.getJson();}};p.prototype.getManifestEntry=function(K){return this._getManifestEntry(K);};p.prototype._getManifestEntry=function(K,m){if(!this._oManifest){return this.getMetadata().getManifestEntry(K,m);}else{return n(this.getMetadata(),this._oManifest,K,m);}};p.prototype.getManifestObject=function(){if(!this._oManifest){return this.getMetadata().getManifestObject();}else{return this._oManifest;}};p.prototype._isVariant=function(){if(this._oManifest){var e=this.getManifestEntry("/sap.ui5/componentName");return e&&e!==this.getManifestEntry("/sap.app/id");}else{return false;}};p.activateCustomizing=function(e){};p.deactivateCustomizing=function(e){};p.getOwnerIdFor=function(e){d(e instanceof b,"oObject must be given and must be a ManagedObject");var i=(e instanceof b)&&e._sOwnerId;return i||undefined;};p.getOwnerComponentFor=function(e){return p.get(p.getOwnerIdFor(e));};p.prototype.runAsOwner=function(e){return r(e,this.getId());};p.prototype.getInterface=function(){return this;};p.prototype._initCompositeSupport=function(S){this.oComponentData=S&&S.componentData;if(!this._isVariant()){this.getMetadata().init();}else{this._oManifest.init(this);var A=this._oManifest.getEntry("/sap.app/id");if(A){w(A,this._oManifest.resolveUri("./","manifest"));}}this.initComponentModels();if(this.onWindowError){this._fnWindowErrorHandler=q.proxy(function(e){var i=e.originalEvent;this.onWindowError(i.message,i.filename,i.lineno);},this);q(window).bind("error",this._fnWindowErrorHandler);}if(this.onWindowBeforeUnload){this._fnWindowBeforeUnloadHandler=q.proxy(this.onWindowBeforeUnload,this);q(window).bind("beforeunload",this._fnWindowBeforeUnloadHandler);}if(this.onWindowUnload){this._fnWindowUnloadHandler=q.proxy(this.onWindowUnload,this);q(window).bind("unload",this._fnWindowUnloadHandler);}};p.prototype.destroy=function(){for(var e in this._mServices){if(this._mServices[e].instance){this._mServices[e].instance.destroy();}}delete this._mServices;for(var m in this._mManifestModels){this._mManifestModels[m].destroy();}delete this._mManifestModels;if(this._fnWindowErrorHandler){q(window).unbind("error",this._fnWindowErrorHandler);delete this._fnWindowErrorHandler;}if(this._fnWindowBeforeUnloadHandler){q(window).unbind("beforeunload",this._fnWindowBeforeUnloadHandler);delete this._fnWindowBeforeUnloadHandler;}if(this._fnWindowUnloadHandler){q(window).unbind("unload",this._fnWindowUnloadHandler);delete this._fnWindowUnloadHandler;}if(this._oEventBus){this._oEventBus.destroy();delete this._oEventBus;}b.prototype.destroy.apply(this,arguments);sap.ui.getCore().getMessageManager().unregisterObject(this);if(!this._isVariant()){this.getMetadata().exit();}else{this._oManifest.exit(this);delete this._oManifest;}};p.prototype.getComponentData=function(){return this.oComponentData;};p.prototype.getEventBus=function(){if(!this._oEventBus){var e=this.getMetadata().getName();L.warning("Synchronous loading of EventBus, due to #getEventBus() call on Component '"+e+"'.","SyncXHR",null,function(){return{type:"SyncXHR",name:e};});var i=sap.ui.requireSync("sap/ui/core/EventBus");this._oEventBus=new i();}return this._oEventBus;};p.prototype.initComponentModels=function(){var m=this.getMetadata();if(m.isBaseClass()){return;}var e=this._getManifestEntry("/sap.app/dataSources",true)||{};var i=this._getManifestEntry("/sap.ui5/models",true)||{};this._initComponentModels(i,e,this._mCacheTokens);};p.prototype._initComponentModels=function(m,D,e){var A=p._createManifestModelConfigurations({models:m,dataSources:D,component:this,mergeParent:true,cacheTokens:e});if(!A){return;}var i={};for(var v in A){if(!this._mManifestModels[v]){i[v]=A[v];}}var B=p._createManifestModels(i,this.toString());for(var v in B){this._mManifestModels[v]=B[v];}for(var v in this._mManifestModels){var F=this._mManifestModels[v];this.setModel(F,v||undefined);}};p.prototype.getService=function(e){if(!this._mServices[e]){this._mServices[e]={};this._mServices[e].promise=new Promise(function(R,i){sap.ui.require(["sap/ui/core/service/ServiceFactoryRegistry"],function(S){var m=this.getManifestEntry("/sap.ui5/services/"+e);var v=m&&m.factoryName;if(!v){i(new Error("Service "+e+" not declared!"));return;}var A=S.get(v);if(A){A.createInstance({scopeObject:this,scopeType:"component",settings:m.settings||{}}).then(function(F){if(!this.bIsDestroyed){this._mServices[e].instance=F;this._mServices[e].interface=F.getInterface();R(this._mServices[e].interface);}else{i(new Error("Service "+e+" could not be loaded as its Component was destroyed."));}}.bind(this)).catch(i);}else{var B="The ServiceFactory "+v+" for Service "+e+" not found in ServiceFactoryRegistry!";var D=this.getManifestEntry("/sap.ui5/services/"+e+"/optional");if(!D){L.error(B);}i(new Error(B));}}.bind(this),i);}.bind(this));}return this._mServices[e].promise;};function s(e){var S=e.getManifestEntry("/sap.ui5/services");for(var i in S){if(S[i].lazy===false){e.getService(i);}}}p.prototype.createComponent=function(v){d((typeof v==='string'&&v)||(typeof v==='object'&&typeof v.usage==='string'&&v.usage),"vUsage either must be a non-empty string or an object with a non-empty usage id");var m={async:true};if(v){var e;if(typeof v==="object"){e=v.usage;["id","async","settings","componentData"].forEach(function(N){if(v[N]!==undefined){m[N]=v[N];}});}else if(typeof v==="string"){e=v;}m=this._enhanceWithUsageConfig(e,m);}return p._createComponent(m,this);};p.prototype._enhanceWithUsageConfig=function(e,m){var i=this.getManifestEntry("/sap.ui5/componentUsages/"+e);if(!i){throw new Error("Component usage \""+e+"\" not declared in Component \""+this.getManifestObject().getComponentName()+"\"!");}return q.extend(true,i,m);};p._createComponent=function(m,e){function i(){if(m.async===true){return p.create(m);}else{return sap.ui.component(m);}}if(e){return e.runAsOwner(i);}else{return i();}};p._createManifestModelConfigurations=function(m){var e=m.component;var v=m.manifest||e.getManifestObject();var A=m.mergeParent;var B=m.cacheTokens||{};var D=e?e.toString():v.getComponentName();var F=sap.ui.getCore().getConfiguration();if(!m.models){return null;}var G={models:m.models,dataSources:m.dataSources||{},origin:{dataSources:{},models:{}}};if(e&&A){var H=e.getMetadata();while(H instanceof C){var J=H.getManifestObject();var K=H.getManifestEntry("/sap.app/dataSources");l(G.dataSources,G.origin.dataSources,K,J);var N=H.getManifestEntry("/sap.ui5/models");l(G.models,G.origin.models,N,J);H=H.getParent();}}var P={};for(var Q in G.models){var R=G.models[Q];var S=false;var T=null;if(typeof R==='string'){R={dataSource:R};}if(R.dataSource){var W=G.dataSources&&G.dataSources[R.dataSource];if(typeof W==='object'){if(W.type===undefined){W.type='OData';}var X;if(!R.type){switch(W.type){case'OData':X=W.settings&&W.settings.odataVersion;if(X==="4.0"){R.type='sap.ui.model.odata.v4.ODataModel';}else if(!X||X==="2.0"){R.type='sap.ui.model.odata.v2.ODataModel';}else{L.error('Component Manifest: Provided OData version "'+X+'" in '+'dataSource "'+R.dataSource+'" for model "'+Q+'" is unknown. '+'Falling back to default model type "sap.ui.model.odata.v2.ODataModel".','["sap.app"]["dataSources"]["'+R.dataSource+'"]',D);R.type='sap.ui.model.odata.v2.ODataModel';}break;case'JSON':R.type='sap.ui.model.json.JSONModel';break;case'XML':R.type='sap.ui.model.xml.XMLModel';break;default:}}if(R.type==='sap.ui.model.odata.v4.ODataModel'&&W.settings&&W.settings.odataVersion){R.settings=R.settings||{};R.settings.odataVersion=W.settings.odataVersion;}if(!R.uri){R.uri=W.uri;S=true;}if(W.type==='OData'&&W.settings&&typeof W.settings.maxAge==="number"){R.settings=R.settings||{};R.settings.headers=R.settings.headers||{};R.settings.headers["Cache-Control"]="max-age="+W.settings.maxAge;}if(W.type==='OData'&&W.settings&&W.settings.annotations){var Y=W.settings.annotations;for(var i=0;i<Y.length;i++){var Z=G.dataSources[Y[i]];if(!Z){L.error("Component Manifest: ODataAnnotation \""+Y[i]+"\" for dataSource \""+R.dataSource+"\" could not be found in manifest","[\"sap.app\"][\"dataSources\"][\""+Y[i]+"\"]",D);continue;}if(Z.type!=='ODataAnnotation'){L.error("Component Manifest: dataSource \""+Y[i]+"\" was expected to have type \"ODataAnnotation\" but was \""+Z.type+"\"","[\"sap.app\"][\"dataSources\"][\""+Y[i]+"\"]",D);continue;}if(!Z.uri){L.error("Component Manifest: Missing \"uri\" for ODataAnnotation \""+Y[i]+"\"","[\"sap.app\"][\"dataSources\"][\""+Y[i]+"\"]",D);continue;}var $=new U(Z.uri);if(R.type==='sap.ui.model.odata.v2.ODataModel'){["sap-language","sap-client"].forEach(function(m1){if(!$.hasQuery(m1)&&F.getSAPParam(m1)){$.setQuery(m1,F.getSAPParam(m1));}});var _=B.dataSources&&B.dataSources[Z.uri];if(_){var a1=function(){if(!$.hasQuery("sap-language")){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+_+"\" for ODataAnnotation \""+Y[i]+"\" ("+$.toString()+"). "+"Missing \"sap-language\" URI parameter","[\"sap.app\"][\"dataSources\"][\""+Y[i]+"\"]",D);return;}if(!$.hasQuery("sap-client")){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+_+"\" for ODataAnnotation \""+Y[i]+"\" ("+$.toString()+"). "+"Missing \"sap-client\" URI parameter","[\"sap.app\"][\"dataSources\"][\""+Y[i]+"\"]",D);return;}if(!$.hasQuery("sap-client",F.getSAPParam("sap-client"))){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+_+"\" for ODataAnnotation \""+Y[i]+"\" ("+$.toString()+"). "+"URI parameter \"sap-client="+$.query(true)["sap-client"]+"\" must be identical with configuration \"sap-client="+F.getSAPParam("sap-client")+"\"","[\"sap.app\"][\"dataSources\"][\""+Y[i]+"\"]",D);return;}if($.hasQuery("sap-context-token")&&!$.hasQuery("sap-context-token",_)){var m1=$.query(true)["sap-context-token"];L.warning("Component Manifest: Overriding existing \"sap-context-token="+m1+"\" with provided value \""+_+"\" for ODataAnnotation \""+Y[i]+"\" ("+$.toString()+").","[\"sap.app\"][\"dataSources\"][\""+Y[i]+"\"]",D);}$.setQuery("sap-context-token",_);};a1();}}var b1=G.origin.dataSources[Y[i]]||v;var c1=b1._resolveUri($).toString();R.settings=R.settings||{};R.settings.annotationURI=R.settings.annotationURI||[];R.settings.annotationURI.push(c1);}}}else{L.error("Component Manifest: dataSource \""+R.dataSource+"\" for model \""+Q+"\" not found or invalid","[\"sap.app\"][\"dataSources\"][\""+R.dataSource+"\"]",D);}}if(!R.type){L.error("Component Manifest: Missing \"type\" for model \""+Q+"\"","[\"sap.ui5\"][\"models\"][\""+Q+"\"]",D);continue;}if(R.type==='sap.ui.model.odata.ODataModel'&&(!R.settings||R.settings.json===undefined)){R.settings=R.settings||{};R.settings.json=true;}if(R.uri){var d1=new U(R.uri);var e1=(S?G.origin.dataSources[R.dataSource]:G.origin.models[Q])||v;d1=e1._resolveUri(d1);if(R.dataSource){k(d1);if(R.type==='sap.ui.model.odata.v2.ODataModel'){T=R.settings&&R.settings.metadataUrlParams;if((!T||typeof T['sap-language']==='undefined')&&!d1.hasQuery('sap-language')&&F.getSAPParam('sap-language')){R.settings=R.settings||{};T=R.settings.metadataUrlParams=R.settings.metadataUrlParams||{};T['sap-language']=F.getSAPParam('sap-language');}if(B.dataSources){var _=B.dataSources[W.uri];if(_){var f1=function(){if(d1.hasQuery("sap-context-token")){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+_+"\" for model \""+Q+"\" ("+d1.toString()+"). "+"Model URI already contains parameter \"sap-context-token="+d1.query(true)["sap-context-token"]+"\"","[\"sap.ui5\"][\"models\"][\""+Q+"\"]",D);return;}if((!T||typeof T["sap-language"]==="undefined")&&!d1.hasQuery("sap-language")){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+_+"\" for model \""+Q+"\" ("+d1.toString()+"). "+"Missing \"sap-language\" parameter","[\"sap.ui5\"][\"models\"][\""+Q+"\"]",D);return;}if(!d1.hasQuery("sap-client")){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+_+"\" for model \""+Q+"\" ("+d1.toString()+"). "+"Missing \"sap-client\" parameter","[\"sap.ui5\"][\"models\"][\""+Q+"\"]",D);return;}if(!d1.hasQuery("sap-client",F.getSAPParam("sap-client"))){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+_+"\" for model \""+Q+"\" ("+d1.toString()+"). "+"URI parameter \"sap-client="+d1.query(true)["sap-client"]+"\" must be identical with configuration \"sap-client="+F.getSAPParam("sap-client")+"\"","[\"sap.ui5\"][\"models\"][\""+Q+"\"]",D);return;}if(T&&typeof T["sap-client"]!=="undefined"){if(T["sap-client"]!==F.getSAPParam("sap-client")){L.warning("Component Manifest: Ignoring provided \"sap-context-token="+_+"\" for model \""+Q+"\" ("+d1.toString()+"). "+"Parameter metadataUrlParams[\"sap-client\"] = \""+T["sap-client"]+"\" must be identical with configuration \"sap-client="+F.getSAPParam("sap-client")+"\"","[\"sap.ui5\"][\"models\"][\""+Q+"\"]",D);return;}}if(T&&T["sap-context-token"]&&T["sap-context-token"]!==_){L.warning("Component Manifest: Overriding existing \"sap-context-token="+T["sap-context-token"]+"\" with provided value \""+_+"\" for model \""+Q+"\" ("+d1.toString()+").","[\"sap.ui5\"][\"models\"][\""+Q+"\"]",D);}if(!T){R.settings=R.settings||{};T=R.settings.metadataUrlParams=R.settings.metadataUrlParams||{};}T["sap-context-token"]=_;};f1();}}}}R.uri=d1.toString();}if(R.uriSettingName===undefined){switch(R.type){case'sap.ui.model.odata.ODataModel':case'sap.ui.model.odata.v2.ODataModel':case'sap.ui.model.odata.v4.ODataModel':R.uriSettingName='serviceUrl';break;case'sap.ui.model.resource.ResourceModel':R.uriSettingName='bundleUrl';break;default:}}var g1;var h1;if(e){h1=e.getComponentData();}else{h1=m.componentData;}g1=h1&&h1.startupParameters&&h1.startupParameters["sap-system"];if(!g1){g1=F.getSAPParam("sap-system");}var i1=false;var j1;if(g1&&["sap.ui.model.odata.ODataModel","sap.ui.model.odata.v2.ODataModel"].indexOf(R.type)!=-1){i1=true;j1=sap.ui.requireSync("sap/ui/model/odata/ODataUtils");}if(R.uri){if(i1){R.preOriginBaseUri=R.uri.split("?")[0];R.uri=j1.setOrigin(R.uri,{alias:g1});R.postOriginBaseUri=R.uri.split("?")[0];}if(R.uriSettingName!==undefined){R.settings=R.settings||{};if(!R.settings[R.uriSettingName]){R.settings[R.uriSettingName]=R.uri;}}else if(R.settings){R.settings=[R.uri,R.settings];}else{R.settings=[R.uri];}}else{if(i1&&R.uriSettingName!==undefined&&R.settings&&R.settings[R.uriSettingName]){R.preOriginBaseUri=R.settings[R.uriSettingName].split("?")[0];R.settings[R.uriSettingName]=j1.setOrigin(R.settings[R.uriSettingName],{alias:g1});R.postOriginUri=R.settings[R.uriSettingName].split("?")[0];}}if(i1&&R.settings&&R.settings.annotationURI){var k1=[].concat(R.settings.annotationURI);var l1=[];for(var i=0;i<k1.length;i++){l1.push(j1.setAnnotationOrigin(k1[i],{alias:g1,preOriginBaseUri:R.preOriginBaseUri,postOriginBaseUri:R.postOriginBaseUri}));}R.settings.annotationURI=l1;}if(R.type==='sap.ui.model.resource.ResourceModel'&&R.settings&&Array.isArray(R.settings.enhanceWith)){R.settings.enhanceWith.forEach(function(m1){if(m1.bundleUrl){m1.bundleUrl=v.resolveUri(m1.bundleUrl,m1.bundleUrlRelativeTo);}});}if(R.settings&&!Array.isArray(R.settings)){R.settings=[R.settings];}P[Q]=R;}return P;};p._createManifestModels=function(m,e){var i={};for(var v in m){var A=m[v];try{sap.ui.requireSync(A.type.replace(/\./g,"/"));}catch(B){L.error("Component Manifest: Class \""+A.type+"\" for model \""+v+"\" could not be loaded. "+B,"[\"sap.ui5\"][\"models\"][\""+v+"\"]",e);continue;}var D=O.get(A.type);if(!D){L.error("Component Manifest: Class \""+A.type+"\" for model \""+v+"\" could not be found","[\"sap.ui5\"][\"models\"][\""+v+"\"]",e);continue;}var F=[null].concat(A.settings||[]);var G=D.bind.apply(D,F);var H=new G();i[v]=H;}return i;};function t(m,e,i){var v={afterManifest:{},afterPreload:{}};var A=q.extend(true,{},m.getEntry("/sap.app/dataSources"));var B=q.extend(true,{},m.getEntry("/sap.ui5/models"));var D=p._createManifestModelConfigurations({models:B,dataSources:A,manifest:m,componentData:e,cacheTokens:i});var P=new f(window.location.href).get("sap-ui-xx-preload-component-models-"+m.getComponentName());var F=P&&P.split(",");for(var G in D){var H=D[G];if(!H.preload&&F&&F.indexOf(G)>-1){H.preload=true;L.warning("FOR TESTING ONLY!!! Activating preload for model \""+G+"\" ("+H.type+")",m.getComponentName(),"sap.ui.core.Component");}if(H.type==="sap.ui.model.resource.ResourceModel"&&Array.isArray(H.settings)&&H.settings.length>0&&H.settings[0].async!==true){v.afterPreload[G]=H;}else if(H.preload){if(sap.ui.loader._.getModuleState(H.type.replace(/\./g,"/")+".js")){v.afterManifest[G]=H;}else{L.warning("Can not preload model \""+G+"\" as required class has not been loaded: \""+H.type+"\"",m.getComponentName(),"sap.ui.core.Component");}}}return v;}function u(e){return sap.ui.require.toUrl(e.replace(/\./g,"/")+"/manifest.json");}function w(m,v){h.registerResourcePath(m.replace(/\./g,"/"),v);}function x(R,e){var m=[];var v=[];function A(i,B){if(!i._oManifest){var N=i.getComponentName();var D=u(N);var F;if(B){F=Promise.resolve(JSON.parse(JSON.stringify(B.getRawJson())));}else{F=h.loadResource({url:D,dataType:"json",async:true}).catch(function(G){L.error("Failed to load component manifest from \""+D+"\" (component "+N+")! Reason: "+G);return{};});}m.push(F);v.push(i);}var P=i.getParent();if(P&&(P instanceof C)&&!P.isBaseClass()){A(P);}}A(R,e);return Promise.all(m).then(function(B){for(var i=0;i<B.length;i++){if(B[i]){v[i]._applyManifest(B[i]);}}});}p._fnLoadComponentCallback=null;p._fnOnInstanceCreated=null;p.create=function(m){if(m==null||typeof m!=="object"){throw new TypeError("Component.create() must be called with a configuration object.");}var P=a({},m);P.async=true;if(P.manifest===undefined){P.manifest=true;}return y(P);};sap.ui.component=function(v){if(!v){throw new Error("sap.ui.component cannot be called without parameter!");}var e=function(i){return{type:"sap.ui.component",name:i};};if(typeof v==='string'){L.warning("Do not use deprecated function 'sap.ui.component' ("+v+") + for Component instance lookup. "+"Use 'Component.get' instead","sap.ui.component",null,e.bind(null,v));return sap.ui.getCore().getComponent(v);}if(v.async){L.info("Do not use deprecated factory function 'sap.ui.component' ("+v["name"]+"). "+"Use 'Component.create' instead","sap.ui.component",null,e.bind(null,v["name"]));}else{L.warning("Do not use synchronous component creation ("+v["name"]+")! "+"Use the new asynchronous factory 'Component.create' instead","sap.ui.component",null,e.bind(null,v["name"]));}return y(v);};function y(v){if(!v.asyncHints||!v.asyncHints.cacheTokens){var e=p.get(b._sOwnerId);var m=e&&e._mCacheTokens;if(typeof m==="object"){v.asyncHints=v.asyncHints||{};v.asyncHints.cacheTokens=m;}}function i(D){var N=v.name,F=v.id,G=v.componentData,H=N+'.Component',S=v.settings;var J=new D(q.extend({},S,{id:F,componentData:G,_cacheTokens:v.asyncHints&&v.asyncHints.cacheTokens}));d(J instanceof p,"The specified component \""+H+"\" must be an instance of sap.ui.core.Component!");L.info("Component instance Id = "+J.getId());var K=J.getMetadata().handleValidation()!==undefined||v.handleValidation;if(K){if(J.getMetadata().handleValidation()!==undefined){K=J.getMetadata().handleValidation();}else{K=v.handleValidation;}sap.ui.getCore().getMessageManager().registerObject(J,K);}s(J);if(typeof p._fnOnInstanceCreated==="function"){var P=p._fnOnInstanceCreated(J,v);if(v.async&&P instanceof Promise){return P.then(function(){return J;});}}return J;}var A=z(v,{failOnError:true,createModels:true,waitFor:v.asyncHints&&v.asyncHints.waitFor});if(v.async){var B=b._sOwnerId;return A.then(function(D){return r(function(){return i(D);},B);});}else{return i(A);}}p.load=function(m){var P=a({},m);P.async=true;if(P.manifest===undefined){P.manifest=true;}return z(P,{preloadOnly:P.asyncHints&&P.asyncHints.preloadOnly});};p.get=function(i){return sap.ui.getCore().getComponent(i);};sap.ui.component.load=function(e,F){L.warning("Do not use deprecated function 'sap.ui.component.load'! Use 'Component.load' instead");return z(e,{failOnError:F,preloadOnly:e.asyncHints&&e.asyncHints.preloadOnly});};function z(m,A){var N=m.name,B=m.url,D=sap.ui.getCore().getConfiguration(),F=/^(sync|async)$/.test(D.getComponentPreload()),G=m.manifest,H,J,K,P,Q,R;function S(e,A){var K=new M(JSON.parse(JSON.stringify(e)),A);return m.async?Promise.resolve(K):K;}d(!B||typeof B==='string',"sUrl must be a string or undefined");if(N&&typeof B==='string'){w(N,B);}I.setStepComponent(N);if(G===undefined){H=m.manifestFirst===undefined?D.getManifestFirst():!!m.manifestFirst;J=m.manifestUrl;}else{if(m.async===undefined){m.async=true;}H=!!G;J=G&&typeof G==='string'?G:undefined;K=G&&typeof G==='object'?S(G,{url:m&&m.altManifestUrl}):undefined;}if(!K&&J){K=M.load({manifestUrl:J,componentName:N,async:m.async});}if(K&&!m.async){N=K.getComponentName();if(N&&typeof B==='string'){w(N,B);}}if(!(K&&m.async)){if(!N){throw new Error("The name of the component is undefined.");}d(typeof N==='string',"sName must be a string");}if(H&&!K){K=M.load({manifestUrl:u(N),componentName:N,async:m.async,failOnError:false});}function T(){return(N+".Component").replace(/\./g,"/");}function W(e){var i=N+'.Component';if(!e){var v="The specified component controller '"+i+"' could not be found!";if(A.failOnError){throw new Error(v);}else{L.warning(v);}}if(K){var $=o(e.getMetadata(),K);var g1=function(){var h1=Array.prototype.slice.call(arguments);var i1;if(h1.length===0||typeof h1[0]==="object"){i1=h1[0]=h1[0]||{};}else if(typeof h1[0]==="string"){i1=h1[1]=h1[1]||{};}i1._metadataProxy=$;if(P){i1._manifestModels=P;}var j1=Object.create(e.prototype);e.apply(j1,h1);return j1;};g1.getMetadata=function(){return $;};g1.extend=function(){throw new Error("Extending Components created by Manifest is not supported!");};return g1;}else{return e;}}function X(v,i){d((typeof v==='string'&&v)||(typeof v==='object'&&typeof v.name==='string'&&v.name),"reference either must be a non-empty string or an object with a non-empty 'name' and an optional 'url' property");if(typeof v==='object'){if(v.url){w(v.name,v.url);}return(v.lazy&&i!==true)?undefined:v.name;}return v;}function Y(i,v){var $=i+'.Component',g1=sap.ui.getCore().getConfiguration().getDepCache(),h1,i1,j1;if(F&&i!=null&&!sap.ui.loader._.getModuleState($.replace(/\./g,"/")+".js")){if(v){i1=V._getTransitiveDependencyForComponent(i);if(i1){j1=[i1.library];Array.prototype.push.apply(j1,i1.dependencies);return sap.ui.getCore().loadLibraries(j1,{preloadOnly:true});}else{h1=$.replace(/\./g,"/")+(g1?'-h2-preload.js':'-preload.js');return sap.ui.loader._.loadJSResourceAsync(h1,true);}}try{h1=$+'-preload';sap.ui.requireSync(h1.replace(/\./g,"/"));}catch(e){L.warning("couldn't preload component from "+h1+": "+((e&&e.message)||e));}}else if(v){return Promise.resolve();}}function Z(e,K,i){var v=[];var $=i?function(o1){v.push(o1);}:function(){};K.defineResourceRoots();var g1=K.getEntry("/sap.ui5/dependencies/libs");if(g1){var h1=[];for(var i1 in g1){if(!g1[i1].lazy){h1.push(i1);}}if(h1.length>0){L.info("Component \""+e+"\" is loading libraries: \""+h1.join(", ")+"\"");$(sap.ui.getCore().loadLibraries(h1,{async:i}));}}var j1=K.getEntry("/sap.ui5/extends/component");if(j1){$(Y(j1,i));}var k1=[];var l1=K.getEntry("/sap.ui5/dependencies/components");if(l1){for(var e in l1){if(!l1[e].lazy){k1.push(e);}}}var m1=K.getEntry("/sap.ui5/componentUsages");if(m1){for(var n1 in m1){if(m1[n1].lazy===false&&k1.indexOf(m1[n1].name)===-1){k1.push(m1[n1].name);}}}if(k1.length>0){k1.forEach(function(e){$(Y(e,i));});}return i?Promise.all(v):undefined;}if(m.async){var _=m.asyncHints||{},a1=[],b1=function(e){e=e.then(function(v){return{result:v,rejected:false};},function(v){return{result:v,rejected:true};});return e;},c1=function(e){if(e){a1.push(b1(e));}},d1=function($){return $;},e1,f1;if(K&&A.createModels){c1(K.then(function(K){Q=t(K,m.componentData,_.cacheTokens);return K;}).then(function(K){if(Object.keys(Q.afterManifest).length>0){P=p._createManifestModels(Q.afterManifest,K.getComponentName());}return K;}));}e1=[];if(Array.isArray(_.preloadBundles)){_.preloadBundles.forEach(function(v){e1.push(sap.ui.loader._.loadJSResourceAsync(X(v,true),true));});}if(Array.isArray(_.libs)){f1=_.libs.map(X).filter(d1);e1.push(sap.ui.getCore().loadLibraries(f1,{preloadOnly:true}));}e1=Promise.all(e1);if(f1&&!A.preloadOnly){e1=e1.then(function(){return sap.ui.getCore().loadLibraries(f1);});}c1(e1);if(!K){c1(Y(N,true));}else{c1(K.then(function(K){var e=K.getComponentName();if(typeof B==='string'){w(e,B);}return Y(e,true).then(function(){return K._processI18n(true);}).then(function(){if(!A.createModels){return null;}var i=Object.keys(Q.afterPreload);if(i.length===0){return null;}return new Promise(function(v,$){sap.ui.require(["sap/ui/model/resource/ResourceModel"],function(g1){v(g1);},$);}).then(function(v){function $(g1){var h1=Q.afterPreload[g1];if(Array.isArray(h1.settings)&&h1.settings.length>0){var i1=h1.settings[0];return v.loadResourceBundle(i1,true).then(function(j1){i1.bundle=j1;},function(j1){L.error("Component Manifest: Could not preload ResourceBundle for ResourceModel. "+"The model will be skipped here and tried to be created on Component initialization.","[\"sap.ui5\"][\"models\"][\""+g1+"\"]",e);L.error(j1);delete Q.afterPreload[g1];});}else{return Promise.resolve();}}return Promise.all(i.map($)).then(function(){if(Object.keys(Q.afterPreload).length>0){var g1=p._createManifestModels(Q.afterPreload,K.getComponentName());if(!P){P={};}for(var h1 in g1){P[h1]=g1[h1];}}});});});}));R=function(e){if(typeof p._fnLoadComponentCallback==="function"){var i=q.extend(true,{},m);var v=q.extend(true,{},e);try{p._fnLoadComponentCallback(i,v);}catch($){L.error("Callback for loading the component \""+K.getComponentName()+"\" run into an error. The callback was skipped and the component loading resumed.",$,"sap.ui.core.Component");}}};}if(_.components){q.each(_.components,function(i,v){c1(Y(X(v),true));});}return Promise.all(a1).then(function(v){var e=[],i=false,$;i=v.some(function(g1){if(g1&&g1.rejected){$=g1.result;return true;}e.push(g1.result);});if(i){return Promise.reject($);}return e;}).then(function(v){if(K&&R){K.then(R);}return v;}).then(function(v){L.debug("Component.load: all promises fulfilled, then "+v);if(K){return K.then(function(e){K=e;N=K.getComponentName();return Z(N,K,true);});}else{return v;}}).then(function(){if(A.preloadOnly){return true;}return new Promise(function(e,i){sap.ui.require([T()],function(v){e(v);},i);}).then(function(e){var i=e.getMetadata();var N=i.getComponentName();var v=u(N);var $;if(K&&typeof G!=="object"&&(typeof J==="undefined"||J===v)){$=x(i,K);}else{$=x(i);}return $.then(function(){return W(e);});});}).then(function(e){if(!K){return e;}var i=[];var v;var $=K.getEntry("/sap.ui5/rootView");if(typeof $==="string"){v="XML";}else if($&&typeof $==="object"&&$.type){v=$.type;}if(v&&j[v]){var g1="sap/ui/core/mvc/"+j[v]+"View";i.push(g1);}var h1=K.getEntry("/sap.ui5/routing");if(h1&&h1.routes){var i1=K.getEntry("/sap.ui5/routing/config/routerClass")||"sap.ui.core.routing.Router";var j1=i1.replace(/\./g,"/");i.push(j1);}var k1=q.extend(true,{},K.getEntry("/sap.ui5/models"));var l1=q.extend(true,{},K.getEntry("/sap.app/dataSources"));var m1=p._createManifestModelConfigurations({models:k1,dataSources:l1,manifest:K,cacheTokens:_.cacheTokens});for(var n1 in m1){if(!m1.hasOwnProperty(n1)){continue;}var o1=m1[n1];if(!o1.type){continue;}var p1=o1.type.replace(/\./g,"/");if(i.indexOf(p1)===-1){i.push(p1);}}if(i.length>0){return Promise.all(i.map(function(p1){return new Promise(function(q1,r1){var s1=false;function t1(u1){if(s1){return;}L.warning("Can not preload module \""+p1+"\". "+"This will most probably cause an error once the module is used later on.",K.getComponentName(),"sap.ui.core.Component");L.warning(u1);s1=true;q1();}sap.ui.require([p1],q1,t1);});})).then(function(){return e;});}else{return e;}}).then(function(e){var i=A.waitFor;if(i){var v=Array.isArray(i)?i:[i];return Promise.all(v).then(function(){return e;});}return e;}).catch(function(e){if(P){for(var N in P){var i=P[N];if(i&&typeof i.destroy==="function"){i.destroy();}}}throw e;});}if(K){Z(N,K);}Y(N);return W(sap.ui.requireSync(T()));}if(Math.sqrt(2)<1){sap.ui.require(["sap/ui/core/Core"],function(){});}return p;});
