/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/Object","sap/ui/dt/Plugin","sap/ui/dt/DOMUtil","sap/ui/dt/OverlayUtil","sap/ui/dt/OverlayRegistry","sap/ui/thirdparty/jquery","sap/ui/qunit/QUnitUtils"],function(B,P,D,O,a,q){"use strict";var b=P.extend("sap.ui.dt.plugin.DragDrop",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{},associations:{},events:{}}});var I=7;var p=false;var o;b.prototype._preventScrollOnTouch=function(E){if(p){E.preventDefault();}};b.prototype.init=function(){P.prototype.init.apply(this,arguments);document.addEventListener('touchmove',this._preventScrollOnTouch,true);this._dragScrollHandler=this._dragScroll.bind(this);this._dragLeaveHandler=this._dragLeave.bind(this);this._mScrollIntervals={};};b.prototype.exit=function(){P.prototype.exit.apply(this,arguments);document.removeEventListener('touchmove',this._preventScrollOnTouch);delete this._mElementOverlayDelegate;delete this._mAggregationOverlayDelegate;delete this._dragScrollHandler;};b.prototype.registerElementOverlay=function(f){f.attachEvent("movableChange",this._onMovableChange,this);if(f.isMovable()){this._attachDragEvents(f);}f.attachBrowserEvent("dragover",this._onDragOver,this);f.attachBrowserEvent("dragenter",this._onDragEnter,this);f.attachBrowserEvent("dragleave",this._onDragLeave,this);};b.prototype.registerAggregationOverlay=function(A){A.attachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!sap.ui.Device.browser.webkit){this._attachDragScrollHandler(A);}};b.prototype.deregisterElementOverlay=function(f){f.detachEvent("movableChange",this._onMovableChange,this);this._detachDragEvents(f);f.detachBrowserEvent("dragover",this._onDragOver,this);f.detachBrowserEvent("dragenter",this._onDragEnter,this);f.detachBrowserEvent("dragleave",this._onDragLeave,this);};b.prototype.deregisterAggregationOverlay=function(A){A.detachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!sap.ui.Device.browser.webkit){this._removeDragScrollHandler(A);this._clearScrollIntervalFor(A.$().attr("id"));}};b.prototype._attachDragEvents=function(f){f.attachBrowserEvent("dragstart",this._onDragStart,this);f.attachBrowserEvent("drag",this._onDrag,this);f.attachBrowserEvent("dragend",this._onDragEnd,this);f.attachBrowserEvent("touchstart",this._onTouchStart,this);};b.prototype._detachDragEvents=function(f){f.detachBrowserEvent("dragstart",this._onDragStart,this);f.detachBrowserEvent("drag",this._onDrag,this);f.detachBrowserEvent("dragend",this._onDragEnd,this);f.detachBrowserEvent("touchstart",this._onTouchStart,this);};b.prototype.onMovableChange=function(){};b.prototype.onDragStart=function(){};b.prototype.onDragEnd=function(){};b.prototype.onDrag=function(){};b.prototype.onDragEnter=function(){};b.prototype.onDragLeave=function(){};b.prototype.onDragOver=function(){};b.prototype.onAggregationDragEnter=function(){};b.prototype.onAggregationDragOver=function(){};b.prototype.onAggregationDragLeave=function(){};b.prototype.onAggregationDrop=function(){};b.prototype._checkMovable=function(f){if(f.isMovable()||D.getDraggable(f.$())!==undefined){D.setDraggable(f.$(),f.isMovable());}};b.prototype._onMovableChange=function(E){var f=E.getSource();if(f.isMovable()){this._attachDragEvents(f);}else{this._detachDragEvents(f);}this.onMovableChange(f);};b.prototype._onDragStart=function(E){var f=a.getOverlay(E.currentTarget.id);E.stopPropagation();if(sap.ui.Device.browser.firefox&&E&&E.originalEvent&&E.originalEvent.dataTransfer&&E.originalEvent.dataTransfer.setData){E.originalEvent.dataTransfer.setData('text/plain','');}this.setBusy(true);this.showGhost(f,E);this.onDragStart(f);};b.prototype._attachTouchDragEvents=function(f){f.attachBrowserEvent("touchmove",this._onTouchMove,this);f.attachBrowserEvent("touchend",this._onTouchEnd,this);};b.prototype._detachTouchDragEvents=function(f){f.detachBrowserEvent("touchmove",this._onTouchMove,this);f.detachBrowserEvent("touchend",this._onTouchEnd,this);};b.prototype._onTouchStart=function(E){var t=E.touches[0].pageX;var f=E.touches[0].pageY;var T=a.getOverlay(E.currentTarget.id);function g(){T.detachBrowserEvent("touchmove",i,this);T.detachBrowserEvent("touchend",j,this);T.detachBrowserEvent("contextmenu",j,this);}function h(k,l){var m=t-k;var n=f-l;return Math.sqrt((m*m)+(n*n));}function i(E){var k=E.touches[0].pageX;var l=E.touches[0].pageY;var m=h(k,l);if(m>I){this.onDragStart(T);g.call(this);this._attachTouchDragEvents(T);}}function j(){g.call(this);p=false;}p=true;E.stopPropagation();T.attachBrowserEvent("touchmove",i,this);T.attachBrowserEvent("contextmenu",j,this);T.attachBrowserEvent("touchend",j,this);};b.prototype._getTargetOverlay=function(E){if(B.isA(E,"sap.ui.dt.Overlay")){var t;if(B.isA(E,"sap.ui.dt.AggregationOverlay")&&E.getTargetZone()){t=E;}else if(B.isA(E,"sap.ui.dt.ElementOverlay")&&O.isInTargetZoneAggregation(E)){t=E;}return t||this._getTargetOverlay(E.getParent());}};b.prototype._findTargetOverlayFromCoordinates=function(f,g){var h=document.elementFromPoint(f,g);var E=h?sap.ui.getCore().byId(h.id):undefined;return this._getTargetOverlay(E);};b.prototype._onTouchMove=function(E){var f=a.getOverlay(E.currentTarget.id);this.onDrag(f);var t=E.touches||E.changedTouches;var g=t[0].pageX;var h=t[0].pageY;var T=this._findTargetOverlayFromCoordinates(g,h);if(!T){return;}if(T!==o){if(o){if(B.isA(o,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragLeave(o);}else{this.onDragLeave(o);}}o=T;if(B.isA(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragEnter(T);}else{this.onDragEnter(T);}}if(B.isA(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragOver(T);}else{this.onDragOver(T);}E.stopPropagation();};b.prototype._getValidTargetZoneAggregationOverlay=function(f){if(B.isA(f,"sap.ui.dt.AggregationOverlay")&&f.getTargetZone()){return f;}return this._getValidTargetZoneAggregationOverlay(f.getParent());};b.prototype._onTouchEnd=function(E){var f=a.getOverlay(E.currentTarget.id);var A=this._getValidTargetZoneAggregationOverlay(f);if(A){this.onAggregationDrop(A);}this.onDragEnd(f);this._detachTouchDragEvents(f);o=undefined;p=false;};b.prototype.showGhost=function(f,E){if(E&&E.originalEvent&&E.originalEvent.dataTransfer){E.originalEvent.dataTransfer.effectAllowed="move";E.originalEvent.dataTransfer.dropEffect="move";if(!sap.ui.Device.browser.internet_explorer&&!sap.ui.Device.browser.edge&&!sap.ui.Device.browser.msie&&E.originalEvent.dataTransfer.setDragImage){this._$ghost=this.createGhost(f,E);this._$ghost.appendTo("#overlay-container");setTimeout(function(){this._removeGhost();}.bind(this),0);E.originalEvent.dataTransfer.setDragImage(this._$ghost.get(0),E.originalEvent.pageX-f.$().offset().left,E.originalEvent.pageY-f.$().offset().top);}}};b.prototype._removeGhost=function(){this.removeGhost();delete this._$ghost;};b.prototype.removeGhost=function(){var $=this.getGhost();if($){$.remove();}};b.prototype.createGhost=function(f){var g=f.getAssociatedDomRef();var $;if(!g){g=this._getAssociatedDomCopy(f);$=g;}else{$=q("<div></div>");q.makeArray(g).forEach(function(n){D.cloneDOMAndStyles(n,$);});}var h=q("<div></div>").addClass("sapUiDtDragGhostWrapper");return h.append($.addClass("sapUiDtDragGhost"));};b.prototype._getAssociatedDomCopy=function(f){var $=q("<div></div>");f.getAggregationOverlays().forEach(function(A){A.getChildren().forEach(function(C){var g=C.getAssociatedDomRef();if(g){D.cloneDOMAndStyles(g,$);}else{D.cloneDOMAndStyles(this._getAssociatedDomCopy(C),$);}},this);},this);return $;};b.prototype.getGhost=function(){return this._$ghost;};b.prototype._onDragEnd=function(E){this.setBusy(false);var f=a.getOverlay(E.currentTarget.id);this._removeGhost();this._clearAllScrollIntervals();this.onDragEnd(f);E.stopPropagation();};b.prototype._onDrag=function(E){var f=a.getOverlay(E.currentTarget.id);this.onDrag(f);E.stopPropagation();};b.prototype._onDragEnter=function(E){var f=a.getOverlay(E.currentTarget.id);if(O.isInTargetZoneAggregation(f)){if(!this.onDragEnter(f)){E.stopPropagation();}}E.preventDefault();};b.prototype._onDragLeave=function(E){var f=a.getOverlay(E.currentTarget.id);if(O.isInTargetZoneAggregation(f)){if(!this.onDragLeave(f)){E.stopPropagation();}}E.preventDefault();};b.prototype._onDragOver=function(E){var f=a.getOverlay(E.currentTarget.id);if(O.isInTargetZoneAggregation(f)){if(!this.onDragOver(f)){E.stopPropagation();}}E.preventDefault();};b.prototype._onAggregationTargetZoneChange=function(E){var A=E.getSource();var t=E.getParameter("targetZone");if(t){this._attachAggregationOverlayEvents(A);}else{this._detachAggregationOverlayEvents(A);}};b.prototype._attachAggregationOverlayEvents=function(A){A.attachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.attachBrowserEvent("dragover",this._onAggregationDragOver,this);A.attachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.attachBrowserEvent("drop",this._onAggregationDrop,this);};b.prototype._detachAggregationOverlayEvents=function(A){A.detachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.detachBrowserEvent("dragover",this._onAggregationDragOver,this);A.detachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.detachBrowserEvent("drop",this._onAggregationDrop,this);};b.prototype._onAggregationDragEnter=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDragEnter(A);E.preventDefault();E.stopPropagation();};b.prototype._onAggregationDragOver=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDragOver(A);E.preventDefault();E.stopPropagation();};b.prototype._onAggregationDragLeave=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDragLeave(A);E.preventDefault();E.stopPropagation();};b.prototype._onAggregationDrop=function(E){var A=a.getOverlay(E.currentTarget.id);this.onAggregationDrop(A);E.preventDefault();E.stopPropagation();};var c=100;var d=20;var e=50;b.prototype._clearScrollInterval=function(E,s){if(this._mScrollIntervals[E]){window.clearInterval(this._mScrollIntervals[E][s]);delete this._mScrollIntervals[E][s];}};b.prototype._clearScrollIntervalFor=function(E){if(this._mScrollIntervals[E]){Object.keys(this._mScrollIntervals[E]).forEach(function(s){this._clearScrollInterval(E,s);},this);}};b.prototype._clearAllScrollIntervals=function(){Object.keys(this._mScrollIntervals).forEach(this._clearScrollIntervalFor.bind(this));};b.prototype._checkScroll=function($,s,E){var S;var f;var i=1;if(s==="top"||s==="bottom"){S=$.height();f=$.scrollTop.bind($);}else{S=$.width();f=$.scrollLeft.bind($);}if(s==="top"||s==="left"){i=-1;}var g=Math.floor(S/4);var t=c;if(g<c){t=g;}if(E<t){this._mScrollIntervals[$.attr("id")]=this._mScrollIntervals[$.attr("id")]||{};if(!this._mScrollIntervals[$.attr("id")][s]){this._mScrollIntervals[$.attr("id")][s]=window.setInterval(function(){var h=f();f(h+i*d);},e);}}else{this._clearScrollInterval($.attr("id"),s);}};b.prototype._dragLeave=function(E){var A=a.getOverlay(E.currentTarget.id);this._clearScrollIntervalFor(A.$().attr("id"));};b.prototype._dragScroll=function(E){var A=a.getOverlay(E.currentTarget.id);var $=A.$();var i=E.clientX;var f=E.clientY;var g=$.offset();var h=$.height();var w=$.width();var t=g.top;var l=g.left;var j=t+h;var r=l+w;this._checkScroll($,"bottom",j-f);this._checkScroll($,"top",f-t);this._checkScroll($,"right",r-i);this._checkScroll($,"left",i-l);};b.prototype._attachDragScrollHandler=function(E){var A;if(B.isA(E,"sap.ui.dt.AggregationOverlay")){A=E;}else{A=E.srcControl;}if(D.hasScrollBar(A.$())){A.getDomRef().addEventListener("dragover",this._dragScrollHandler,true);A.getDomRef().addEventListener("dragleave",this._dragLeaveHandler,true);}};b.prototype._removeDragScrollHandler=function(E){var A;if(B.isA(E,"sap.ui.dt.AggregationOverlay")){A=E;}else{A=E.srcControl;}var f=A.getDomRef();if(f){f.removeEventListener("dragover",this._dragScrollHandler,true);}};return b;},true);
