/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/context/ContextManager","sap/ui/fl/registry/Settings","sap/ui/fl/transport/TransportSelection","sap/ui/fl/variants/VariantController","sap/ui/core/BusyIndicator","sap/ui/core/Component","sap/m/MessageBox","sap/ui/model/json/JSONModel","sap/ui/thirdparty/jquery","sap/base/util/merge","sap/base/util/isEmptyObject"],function(C,V,U,L,a,b,S,T,c,B,d,M,J,q,m,i){"use strict";var e=function(f){this._mComponent=f;this._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{},aChanges:[]};this._mChangesInitial=m({},this._mChanges);this._mVariantsChanges={};if(!this._mComponent||!this._mComponent.name){U.log.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.");}this._oVariantController=new c(this._mComponent.name,this._mComponent.appVersion,{});this._oTransportSelection=new T();this._oConnector=this._createLrepConnector();this._aDirtyChanges=[];this._oMessagebundle=undefined;this._mChangesEntries={};this._bHasChangesOverMaxLayer=false;this.HIGHER_LAYER_CHANGES_EXIST="higher_layer_changes_exist";};e.prototype.getComponentName=function(){return this._mComponent.name;};e.prototype._createLrepConnector=function(){return L.createConnector();};e.prototype.getCacheKey=function(A){return a.getCacheKey(this._mComponent,A);};e.prototype._preconditionsFulfilled=function(A,I,o){var f=o instanceof C?o.getDefinition():o;if(!f.fileName){U.log.warning("A change without fileName is detected and excluded from component: "+this._mComponent.name);return false;}function _(){if(I){return(f.fileType==="change")||(f.fileType==="variant");}return(f.fileType==="change")&&(f.changeType!=="defaultVariant");}function g(){if(I){if((f.fileType==="variant")||(f.changeType==="defaultVariant")){return f.selector&&f.selector.persistencyKey;}}return true;}function h(){return b.doesContextMatch(f,A);}function j(){if((f.fileType==="ctrl_variant")||(f.fileType==="ctrl_variant_change")||(f.fileType==="ctrl_variant_management_change")){return f.variantManagementReference||f.variantReference||(f.selector&&f.selector.id);}}if((_()&&g()&&h())||j()){return true;}return false;};e.prototype.getChangesForComponent=function(p,I){return a.getChangesFillingCache(this._oConnector,this._mComponent,p,I).then(function(w){var o=m({},w);var A=p&&p.component&&U.getAppComponentForControl(p.component);if(o.changes&&o.changes.settings){S._storeInstance(o.changes.settings);}var F=o.changes&&Array.isArray(o.changes.changes)&&o.changes.changes.length!==0;var v=o.changes&&o.changes.variantSection&&!i(o.changes.variantSection);if(!F&&!v){return[];}var h=A?A.getComponentData():(p&&p.componentData||{});var j=o.changes.changes;if(!this._oMessagebundle&&o.messagebundle&&A){if(!A.getModel("i18nFlexVendor")){if(j.some(function(z){return z.layer==="VENDOR";})){this._oMessagebundle=o.messagebundle;var k=new J(this._oMessagebundle);A.setModel(k,"i18nFlexVendor");}}}var l=p&&p.includeCtrlVariants;var s=p&&p.currentLayer;var n=!(p&&p.ignoreMaxLayerParameter);var t=[o.changes.variantSection];if(s){j=j.filter(this._filterChangeForCurrentLayer.bind(this,s));t.push(false,s);}else if(U.isLayerFilteringRequired()&&n){j=j.filter(this._filterChangeForMaxLayer.bind(this));t.push(true);}else if(this._bHasChangesOverMaxLayer&&!n){this._bHasChangesOverMaxLayer=false;return this.HIGHER_LAYER_CHANGES_EXIST;}if(v){if(l||t.length>1){var u=this._getAllCtrlVariantChanges.apply(this,t);j=l?j.concat(u):j;}this._oVariantController.checkAndSetVariantContent(o,h&&h.technicalParameters);}if(!l&&!i(this._oVariantController.getChangeFileContent())){j=j.concat(this._oVariantController.loadInitialChanges());}var x=p&&p.includeVariants;var y=o.changes.contexts||[];return new Promise(function(z){b.getActiveContexts(y).then(function(D){z(j.filter(this._preconditionsFulfilled.bind(this,D,x)).map(g.bind(this,o)));}.bind(this));}.bind(this));}.bind(this));function f(v,o){var F;Object.keys(v).some(function(s){return v[s].variants.some(function(h){if(h.content.fileName===o.getDefinition().variantReference){F=h;return true;}});});return F;}function r(v,o){return v.controlChanges.some(function(h,j){if(h.fileName===o.getDefinition().fileName){v.controlChanges.splice(j,1,o);return true;}});}function g(F,o){var h;if(o instanceof C){h=o;this._mChangesEntries[h.getFileName()]=h;}else{if(!this._mChangesEntries[o.fileName]){this._mChangesEntries[o.fileName]=new C(o);}h=this._mChangesEntries[o.fileName];h.setState(C.states.PERSISTED);if(h.getVariantReference()){var v=this._oVariantController.getChangeFileContent();var j=f.call(this,v,h);if(j&&r(j,h)){a.setVariantManagementSection(this._mComponent,v);}}}return h;}};e.prototype._filterChangeForMaxLayer=function(o){if(U.isOverMaxLayer(this._getLayerFromChangeOrChangeContent(o))){if(!this._bHasChangesOverMaxLayer){this._bHasChangesOverMaxLayer=true;}return false;}return true;};e.prototype._filterChangeForCurrentLayer=function(l,o){return l===this._getLayerFromChangeOrChangeContent(o);};e.prototype._getLayerFromChangeOrChangeContent=function(o){var s;if(o instanceof V||o instanceof C){s=o.getLayer();}else{s=o.layer;}return s;};e.prototype._getAllCtrlVariantChanges=function(v,f,s){var g=[];var F=function(){return true;};if(f){F=this._filterChangeForMaxLayer.bind(this);}else if(typeof s==="string"&&s!==""){F=this._filterChangeForCurrentLayer.bind(this,s);}Object.keys(v).forEach(function(h){var o=v[h];o.variants=o.variants.filter(function(j){return!j.content.layer||F(j.content);});o.variants.forEach(function(j){if(Array.isArray(j.variantChanges.setVisible)){j.variantChanges.setVisible=j.variantChanges.setVisible.filter(F);var A=j.variantChanges.setVisible.slice(-1)[0];if(A&&!A.content.visible&&A.content.createdByReset){return;}g=g.concat(j.variantChanges.setVisible);}Object.keys(j.variantChanges).forEach(function(k){if(k!=="setVisible"){j.variantChanges[k]=j.variantChanges[k].filter(F);g=j.variantChanges[k].length>0?g.concat(j.variantChanges[k].slice(-1)[0]):g;}});g=(j.content.fileName!==h)?g.concat([j.content]):g;j.controlChanges=j.controlChanges.filter(F);g=g.concat(j.controlChanges);});Object.keys(o.variantManagementChanges).forEach(function(j){o.variantManagementChanges[j]=o.variantManagementChanges[j].filter(F);g=o.variantManagementChanges[j].length>0?g.concat(o.variantManagementChanges[j].slice(-1)[0]):g;});});return g;};e.prototype.getChangesForVariant=function(s,f,p){if(this._mVariantsChanges[f]){return Promise.resolve(this._mVariantsChanges[f]);}var g=function(o){var h=false;var j=o._oDefinition.selector;q.each(j,function(k,v){if(k===s&&v===f){h=true;}});return h;};var l=function(k,t){U.log.error("key : "+k+" and text : "+t.value);};return this.getChangesForComponent(p).then(function(h){return h.filter(g);}).then(function(h){if(!this._mVariantsChanges[f]){this._mVariantsChanges[f]={};}if(h&&h.length===0){return L.isFlexServiceAvailable().then(function(j){if(j===false){return Promise.reject();}return Promise.resolve(this._mVariantsChanges[f]);}.bind(this));}var I;h.forEach(function(o){I=o.getId();if(o.isValid()){if(this._mVariantsChanges[f][I]&&o.isVariant()){U.log.error("Id collision - two or more variant files having the same id detected: "+I);q.each(o.getDefinition().texts,l);U.log.error("already exists in variant : ");q.each(this._mVariantsChanges[f][I].getDefinition().texts,l);}this._mVariantsChanges[f][I]=o;}}.bind(this));return this._mVariantsChanges[f];}.bind(this));};e.prototype.addChangeForVariant=function(s,f,p){var F,I,g,o,h;if(!p){return undefined;}if(!p.type){U.log.error("sap.ui.fl.Persistence.addChange : type is not defined");}var j=q.type(p.content);if(j!=='object'&&j!=='array'){U.log.error("mParameters.content is not of expected type object or array, but is: "+j,"sap.ui.fl.Persistence#addChange");}g={};if(typeof(p.texts)==="object"){q.each(p.texts,function(k,t){g[k]={value:t,type:"XFLD"};});}var v={creation:this._mComponent.appVersion,from:this._mComponent.appVersion};if(this._mComponent.appVersion&&p.developerMode){v.to=this._mComponent.appVersion;}I={changeType:p.type,service:p.ODataService,texts:g,content:p.content,reference:this._mComponent.name,isVariant:p.isVariant,packageName:p.packageName,isUserDependent:p.isUserDependent,validAppVersions:v};I.selector={};I.selector[s]=f;F=C.createInitialFileContent(I);if(p.id){F.fileName=p.id;}o=new C(F);h=o.getId();if(!this._mVariantsChanges[f]){this._mVariantsChanges[f]={};}this._mVariantsChanges[f][h]=o;return o.getId();};e.prototype.saveAllChangesForVariant=function(s){var p=[];var t=this;q.each(this._mVariantsChanges[s],function(f,o){var g=o.getId();switch(o.getPendingAction()){case"NEW":p.push(t._oConnector.create(o.getDefinition(),o.getRequest(),o.isVariant()).then(function(r){o.setResponse(r.response);if(a.isActive()){a.addChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},r.response);}return r;}));break;case"UPDATE":p.push(t._oConnector.update(o.getDefinition(),o.getId(),o.getRequest(),o.isVariant()).then(function(r){o.setResponse(r.response);if(a.isActive()){a.updateChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},r.response);}return r;}));break;case"DELETE":p.push(t._oConnector.deleteChange({sChangeName:o.getId(),sLayer:o.getLayer(),sNamespace:o.getNamespace(),sChangelist:o.getRequest()},o.isVariant()).then(function(r){var o=t._mVariantsChanges[s][g];if(o.getPendingAction()==="DELETE"){delete t._mVariantsChanges[s][g];}if(a.isActive()){a.deleteChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},o.getDefinition());}return r;}));break;default:break;}});return Promise.all(p);};e.prototype._addChangeIntoMap=function(A,o){var s=o.getSelector();if(s&&s.id){var f=s.id;if(s.idIsLocal){f=A.createId(f);}this._addMapEntry(f,o);if(s.idIsLocal===undefined&&f.indexOf("---")!==-1){var g=f.split("---")[0];if(g!==A.getId()){f=f.split("---")[1];f=A.createId(f);this._addMapEntry(f,o);}}}return this._mChanges;};e.prototype._addMapEntry=function(s,o){if(!this._mChanges.mChanges[s]){this._mChanges.mChanges[s]=[];}if(this._mChanges.mChanges[s].indexOf(o)===-1){this._mChanges.mChanges[s].push(o);}if(this._mChanges.aChanges.indexOf(o)===-1){this._mChanges.aChanges.push(o);}};e.prototype._addDependency=function(D,o,r){var f=r?this._mChangesInitial:this._mChanges;if(!f.mDependencies[D.getId()]){f.mDependencies[D.getId()]={changeObject:D,dependencies:[]};}f.mDependencies[D.getId()].dependencies.push(o.getId());if(!f.mDependentChangesOnMe[o.getId()]){f.mDependentChangesOnMe[o.getId()]=[];}f.mDependentChangesOnMe[o.getId()].push(D.getId());};e.prototype._addControlsDependencies=function(D,f,r){var g=r?this._mChangesInitial:this._mChanges;if(f.length>0){if(!g.mDependencies[D.getId()]){g.mDependencies[D.getId()]={changeObject:D,dependencies:[],controlsDependencies:[]};}g.mDependencies[D.getId()].controlsDependencies=f;}};e.prototype.loadChangesMapForComponent=function(A,p){p.component=!i(A)&&A;return this.getChangesForComponent(p).then(f.bind(this));function f(g){this._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{},aChanges:[]};g.forEach(this._addChangeAndUpdateDependencies.bind(this,A));this._mChangesInitial=m({},this._mChanges);return this.getChangesMapForComponent.bind(this);}};e.prototype.checkForOpenDependenciesForControl=function(s,o,A){return Object.keys(this._mChanges.mDependencies).some(function(k){return this._mChanges.mDependencies[k].changeObject.getDependentSelectorList().some(function(D){return D===o.getControlIdBySelector(s,A);});},this);};e.prototype.copyDependenciesFromInitialChangesMap=function(o,D){var I=m({},this._mChangesInitial.mDependencies);var f=I[o.getId()];if(f){var n=[];f.dependencies.forEach(function(s){if(D(s)){this._mChanges.mDependentChangesOnMe[s]=this._mChanges.mDependentChangesOnMe[s]||[];this._mChanges.mDependentChangesOnMe[s].push(o.getId());n.push(s);}}.bind(this));f.dependencies=n;this._mChanges.mDependencies[o.getId()]=f;}return this._mChanges;};e.prototype._addChangeAndUpdateDependencies=function(A,o){o.setInitialApplyState();this._addChangeIntoMap(A,o);this._updateDependencies(o,false);};e.prototype._addRunTimeCreatedChangeAndUpdateDependencies=function(A,o){this._addChangeIntoMap(A,o);this._updateDependencies(o,true);};e.prototype._updateDependencies=function(o,r){var f=this.getChangesMapForComponent().aChanges;var D=o.getDependentSelectorList();var g=o.getDependentControlSelectorList();this._addControlsDependencies(o,g,r);f.slice(0,f.length-1).reverse().forEach(function(E){var h=E.getDependentSelectorList();D.some(function(j){var k=U.indexOfObject(h,j);if(k>-1){this._addDependency(o,E,r);return true;}}.bind(this));}.bind(this));};e.prototype.getChangesMapForComponent=function(){return this._mChanges;};e.prototype.getChangesForView=function(v,p){var t=this;return this.getChangesForComponent(p).then(function(g){return g.filter(f.bind(t));});function f(o){var s=o.getSelector();if(!s){return false;}var g=s.id;if(!g||!p){return false;}var h=g.slice(0,g.lastIndexOf("--"));var v;if(o.getSelector().idIsLocal){var j=p.appComponent;if(j){v=j.getLocalId(p.viewId);}}else{v=p.viewId;}return h===v;}};e.prototype.addChange=function(v,A){var o=this.addDirtyChange(v);this._addRunTimeCreatedChangeAndUpdateDependencies(A,o);this._addPropagationListener(A);return o;};e.prototype.addDirtyChange=function(v){var n;if(v instanceof C||v instanceof V){n=v;}else{n=new C(v);}if(this._aDirtyChanges.indexOf(n)===-1){this._aDirtyChanges.push(n);}return n;};e.prototype._addPropagationListener=function(o){var A=U.getAppComponentForControl(o);if(A instanceof d){var f=function(p){return!p._bIsSapUiFlFlexControllerApplyChangesOnControl;};var n=A.getPropagationListeners().every(f);if(n){var g=A.getManifestObject();var v=U.getAppVersionFromManifest(g);var F=sap.ui.require("sap/ui/fl/FlexControllerFactory");var h=F.create(this.getComponentName(),v);var p=h.getBoundApplyChangesOnControl(this.getChangesMapForComponent.bind(this),A);A.addPropagationListener(p);}}};e.prototype.saveDirtyChanges=function(s){var D=this._aDirtyChanges.slice(0);var f=this._aDirtyChanges;var r=this._getRequests(D);var p=this._getPendingActions(D);if(p.length===1&&r.length===1&&p[0]==="NEW"){var R=r[0];var P=this._prepareDirtyChanges(f);return this._oConnector.create(P,R).then(function(o){this._massUpdateCacheAndDirtyState(f,D,s);return o;}.bind(this));}return this.saveSequenceOfDirtyChanges(D,s);};e.prototype.saveSequenceOfDirtyChanges=function(D,s){var A=this.getDirtyChanges();return D.reduce(function(p,o){return p.then(this._performSingleSaveAction(o)).then(this._updateCacheAndDirtyState.bind(this,A,o,s));}.bind(this),Promise.resolve());};e.prototype._performSingleSaveAction=function(D){return function(){if(D.getPendingAction()==="NEW"){return this._oConnector.create(D.getDefinition(),D.getRequest());}if(D.getPendingAction()==="DELETE"){return this._oConnector.deleteChange({sChangeName:D.getId(),sLayer:D.getLayer(),sNamespace:D.getNamespace(),sChangelist:D.getRequest()});}}.bind(this);};e.prototype._updateCacheAndDirtyState=function(D,o,s){if(!s){if(o.getPendingAction()==="NEW"){U.isChangeRelatedToVariants(o)?a.setVariantManagementSection(this._mComponent,m({},this._oVariantController.getChangeFileContent())):a.addChange(this._mComponent,o.getDefinition());}else if(o.getPendingAction()==="DELETE"){U.isChangeRelatedToVariants(o)?a.setVariantManagementSection(this._mComponent,m({},this._oVariantController.getChangeFileContent())):a.deleteChange(this._mComponent,o.getDefinition());}}var I=D.indexOf(o);if(I>-1){D.splice(I,1);}};e.prototype._massUpdateCacheAndDirtyState=function(D,f,s){f.forEach(function(o){this._updateCacheAndDirtyState(D,o,s);},this);};e.prototype._getRequests=function(D){var r=[];D.forEach(function(o){var R=o.getRequest();if(r.indexOf(R)===-1){r.push(R);}});return r;};e.prototype._getPendingActions=function(D){var p=[];D.forEach(function(o){var P=o.getPendingAction();if(p.indexOf(P)===-1){p.push(P);}});return p;};e.prototype._prepareDirtyChanges=function(D){var f=[];D.forEach(function(o){f.push(o.getDefinition());});return f;};e.prototype.getDirtyChanges=function(){return this._aDirtyChanges;};e.prototype.deleteChange=function(o,r){var n=this._aDirtyChanges.indexOf(o);if(n>-1){if(o.getPendingAction()==="DELETE"){return;}this._aDirtyChanges.splice(n,1);this._deleteChangeInMap(o,r);return;}o.markForDeletion();this.addDirtyChange(o);this._deleteChangeInMap(o,r);};e.prototype._deleteChangeInMap=function(o,r){var s=o.getId();var f=this._mChanges.mChanges;var g=r?this._mChangesInitial:this._mChanges;var D=g.mDependencies;var h=g.mDependentChangesOnMe;Object.keys(f).some(function(k){var j=f[k];var n=j.map(function(E){return E.getId();}).indexOf(o.getId());if(n!==-1){j.splice(n,1);return true;}});Object.keys(D).forEach(function(k){if(k===s){delete D[k];}else if(D[k].dependencies&&Array.isArray(D[k].dependencies)&&D[k].dependencies.indexOf(s)!==-1){D[k].dependencies.splice(D[k].dependencies.indexOf(s),1);if(D[k].dependencies.length===0){delete D[k];}}});Object.keys(h).forEach(function(k){if(k===s){delete h[k];}else if(Array.isArray(h[k])&&h[k].indexOf(s)!==-1){h[k].splice(h[k].indexOf(s),1);if(h[k].length===0){delete h[k];}}});var I=this._mChanges.aChanges.indexOf(o);if(I!==-1){this._mChanges.aChanges.splice(I,1);}};e.prototype.loadSwitchChangesMapForComponent=function(p){p.changesMap=this._mChanges.mChanges;return this._oVariantController.getChangesForVariantSwitch(p);};e.prototype.transportAllUIChanges=function(r,s,l,A){var h=function(E){B.hide();var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");var f=R.getText("MSG_TRANSPORT_ERROR",E?[E.message||E]:undefined);var t=R.getText("HEADER_TRANSPORT_ERROR");U.log.error("transport error"+E);M.show(f,{icon:M.Icon.ERROR,title:t,styleClass:s});return"Error";};return this._oTransportSelection.openTransportSelection(null,r,s).then(function(t){if(this._oTransportSelection.checkTransportInfo(t)){B.show(0);return this.getChangesForComponent({currentLayer:l,includeCtrlVariants:true}).then(function(f){return this._oTransportSelection._prepareChangesForTransport(t,f,A).then(function(){B.hide();});}.bind(this));}return"Cancel";}.bind(this))['catch'](h);};e.prototype._getChangesFromMapByNames=function(n){return this._mChanges.aChanges.filter(function(o){return n.indexOf(o.getFileName())!==-1;});};e.prototype.resetChanges=function(l,g,s,f){var h=[];var t;var j=s&&s.length>0;var k=f&&f.length>0;if(!g&&!j&&!k){U.log.error("Of the generator, selector IDs and change types parameters at least one has to filled");return Promise.reject("Of the generator, selector IDs and change types parameters at least one has to filled");}if(l==="USER"){t=Promise.resolve();}else{t=this.getChangesForComponent({currentLayer:l,includeCtrlVariants:true}).then(function(n){h=n;return S.getInstance(this.getComponentName());}.bind(this)).then(function(o){if(!o.isProductiveSystem()&&!o.hasMergeErrorOccured()){return this._oTransportSelection.setTransports(h,d.get(this.getComponentName()));}}.bind(this));}return t.then(function(){var n="";h.some(function(o){if(o.getRequest()){n=o.getRequest();return true;}return false;});var p={sReference:this.getComponentName(),sAppVersion:this._mComponent.appVersion,sLayer:l,sChangelist:n};if(g){p.sGenerator=g;}if(j){p.aSelectorIds=s;}if(k){p.aChangeTypes=f;}return this._oConnector.resetChanges(p);}.bind(this)).then(function(r){var n=[];if(s||f){var N=[];if(r&&r.response&&r.response.length>0){r.response.forEach(function(o){N.push(o.name);});}a.removeChanges(this._mComponent,N);n=this._getChangesFromMapByNames(N);}return n;}.bind(this));};e.prototype.resetVariantMap=function(r){return this._oVariantController.resetMap(r);};return e;},true);
