//@ui5-bundle sap/ui/layout/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/layout/AlignedFlowLayout',["sap/ui/core/Control","./library","sap/ui/core/ResizeHandler","./AlignedFlowLayoutRenderer","sap/ui/dom/units/Rem"],function(C,l,R,A,a){"use strict";
var b=C.extend("sap.ui.layout.AlignedFlowLayout",{metadata:{library:"sap.ui.layout",properties:{minItemWidth:{type:"sap.ui.core.AbsoluteCSSSize",defaultValue:"12rem"},maxItemWidth:{type:"sap.ui.core.AbsoluteCSSSize",defaultValue:"24rem"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},endContent:{type:"sap.ui.core.Control",multiple:true}}}});
b.prototype.init=function(){this._sResizeListenerId=R.register(this,this.onResize.bind(this));};
b.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};
b.prototype._onRenderingOrThemeChanged=function(){var d=this.getDomRef(),e=this.getDomRef("endItem"),E=this.getContent().length&&d&&e;if(E){var L=window.getComputedStyle(d,null),i=L.getPropertyValue("padding-top"),m=e.style;if(sap.ui.getCore().getConfiguration().getRTL()){m.left=L.getPropertyValue("padding-left");}else{m.right=L.getPropertyValue("padding-right");}m.bottom=i;}this.reflow({domRef:d,endItemDomRef:e});};
b.prototype.onAfterRendering=b.prototype._onRenderingOrThemeChanged;b.prototype.onThemeChanged=b.prototype._onRenderingOrThemeChanged;
b.prototype.onResize=function(e){if(e&&(e.size.width===e.oldSize.width)){return;}this.reflow();};
b.prototype.reflow=function(s){if(this.getContent().length===0){return;}s=s||{};var d=s.domRef||this.getDomRef();if(!d||!d.offsetParent){return;}var c=this.getRenderer().CSS_CLASS+"OneLine",e=true;var E=s.endItemDomRef||this.getDomRef("endItem"),L=this.getLastItemDomRef();if(E&&L){var m=d.lastElementChild.style;m.width="";m.height="";m.display="";d.classList.remove(c);var i=E.offsetHeight,f=E.offsetWidth,g=L.offsetLeft,h;if(sap.ui.getCore().getConfiguration().getRTL()){h=g;}else{var r=g+L.offsetWidth;h=d.offsetWidth-r;}e=h>=f;if(e){if(this.checkItemsWrapping(d)){if(E.offsetTop<L.offsetTop){m.height=i+"px";m.display="block";}else{m.height="0";m.display="";}}else{if(E.offsetTop<L.offsetTop){m.height=i+"px";}m.display="block";}}else{m.height=i+"px";m.display="block";}m.width=f+"px";}if(!this.checkItemsWrapping(d)&&e){d.classList.add(c);}else{d.classList.remove(c);}};
b.prototype.checkItemsWrapping=function(d){d=d||this.getDomRef();if(!d){return false;}var f=d.firstElementChild,L=this.getLastItemDomRef();if(!f||!L){return false;}var F=f.offsetTop,i=L.offsetTop,c=f.offsetHeight;if(i>=(F+c)){return true;}L=this.getDomRef("endItem");return!!L&&(i>=(F+c));};
b.prototype.getLastItemDomRef=function(){var c=this.getContent(),i=c.length;if(i){var o=c[i-1],d=o.getDomRef();if(d){return d.parentElement;}}return null;};
b.prototype.getLastVisibleDomRef=function(){return this.getDomRef("endItem")||this.getLastItemDomRef();};
b.prototype.getNumberOfSpacers=function(){var c=this.getContent().length;if(c===0){return 0;}var s=c,m=this.getMinItemWidth(),M;if(m.lastIndexOf("rem")!==-1){M=a.toPx(m);}else if(m.lastIndexOf("px")!==-1){M=parseFloat(m);}if(M){var i=Math.max(document.documentElement.clientWidth,window.screen.width);s=Math.abs(i/M);}s=Math.min(s,c-2);s=Math.max(1,s);return Math.floor(s);};
return b;});
sap.ui.predefine('sap/ui/layout/AlignedFlowLayoutRenderer',['./library'],function(l){"use strict";var A={};A.CSS_CLASS="sapUiAFLayout";
A.render=function(r,c){var C=c.getContent();r.write("<div");r.writeControlData(c);r.addClass(A.CSS_CLASS);r.writeClasses();r.write(">");this.renderItems(r,c,C);this.renderEndItem(r,c);this.renderSpacers(r,c);r.write("</div>");};
A.renderItems=function(r,c,C){C=C||c.getContent();for(var i=0;i<C.length;i++){this.renderItem(r,c,C[i]);}};
A.renderItem=function(r,c,C){r.write("<div");r.addClass(A.CSS_CLASS+"Item");r.addStyle("flex-basis",c.getMinItemWidth());r.addStyle("max-width",c.getMaxItemWidth());r.writeClasses();r.writeStyles();r.write(">");r.renderControl(C);r.write("</div>");};
A.renderEndItem=function(r,c,e){e=e||c.getEndContent();if(e.length){r.write("<div");r.writeAttribute("id",c.getId()+"-endItem");r.addClass(A.CSS_CLASS+"End");if(c.getContent().length){r.addStyle("flex-basis",c.getMinItemWidth());}r.addStyle("max-width",c.getMaxItemWidth());r.writeClasses();r.writeStyles();r.write(">");for(var i=0;i<e.length;i++){this.renderEndContent(r,c,e[i]);}r.write("</div>");}};
A.renderEndContent=function(r,c,C){r.renderControl(C);};
A.renderSpacers=function(r,c){var s=c.getNumberOfSpacers(),m=c.getMinItemWidth(),M=c.getMaxItemWidth(),C=A.CSS_CLASS;for(var i=0;i<s;i++){r.write("<div");if(i===(s-1)){r.writeAttribute("id",c.getId()+"-last");}r.addClass(C+"Item");r.addClass(C+"Spacer");r.addStyle("flex-basis",m);r.addStyle("max-width",M);r.writeClasses();r.writeStyles();r.write("></div>");}};
return A;},true);
sap.ui.predefine('sap/ui/layout/AssociativeSplitter',['./Splitter','./SplitterRenderer',"sap/base/Log","sap/ui/thirdparty/jquery"],function(S,a,L,q){"use strict";
var A=S.extend("sap.ui.layout.AssociativeSplitter",{
metadata:{associations:{associatedContentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"associatedContentArea"}}},
renderer:a
});
A.prototype.init=function(){S.prototype.init.call(this);this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc",1),decrease:this._onKeyboardResize.bind(this,"dec",1),increaseMore:this._onKeyboardResize.bind(this,"incMore",2),decreaseMore:this._onKeyboardResize.bind(this,"decMore",2),max:this._onKeyboardResize.bind(this,"max",1),min:this._onKeyboardResize.bind(this,"min",1)};this._enableKeyboardListeners();};
A.prototype._enableKeyboardListeners=function(){S.prototype._enableKeyboardListeners.call(this);this.onsaprightmodifiers=this._keyListeners.increase;this.onsapleftmodifiers=this._keyListeners.decrease;this.onsapupmodifiers=this._keyListeners.decrease;this.onsapdownmodifiers=this._keyListeners.increase;this.onsapright=this._keyListeners.increaseMore;this.onsapdown=this._keyListeners.increaseMore;this.onsapleft=this._keyListeners.decreaseMore;this.onsapup=this._keyListeners.decreaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true;};
A.prototype.addAssociatedContentArea=function(c){this._needsInvalidation=true;_(c);return this.addAssociation("associatedContentAreas",c);};
A.prototype.indexOfAssociatedContentArea=function(c){var d=this._getContentAreas();for(var i=0;i<d.length;i++){if(c==d[i]){return i;}}return-1;};
A.prototype.insertAssociatedContentArea=function(c,I){var d=c.getId();this._needsInvalidation=true;_(c);var e=this.getAssociatedContentAreas();for(var i=0;i<e.length;i++){if(e[i]===d){e.splice(i,1);}}e.splice(I,0,d);this.setAssociation("associatedContentAreas",null);var t=this;e.forEach(function(d){t.addAssociation("associatedContentAreas",d);});};
A.prototype.removeAssociatedContentArea=function(c){this.removeAssociation("associatedContentAreas",c);};
A.prototype._getContentAreas=function(){var c=this.getAssociatedContentAreas()||[];var C=this.getContentAreas();var v=c.map(function(i){return sap.ui.getCore().byId(i);}).filter(function(o){return o;});return C.concat(v);};
A.prototype.onmousedown=function(j){if(this._ignoreMouse){return;}if(q(j.target).hasClass("sapUiLoSplitterBarIcon")){j.target=j.target.parentElement;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!==0){return;}this._ignoreTouch=true;this._onBarMoveStart(j);this._oLastDOMclicked=j.target;};
A.prototype.ondblclick=function(e){var i=this.getId(),B,c;if(!(e.target.contains(this._oLastDOMclicked)&&(this._oLastDOMclicked.id.indexOf(i+"-splitbar")>-1))){return;}B=parseInt(this._oLastDOMclicked.id.substr((i+"-splitbar-").length));c=this._getContentAreas()[B];c._currentPosition=this.getCalculatedSizes()[B];c._lastPosition=c._lastPosition||c._currentPosition;if(c._currentPosition===c._lastPosition){this._resizeContents(B,(this.getCalculatedSizes()[B])*-1,true);}else{this._resizeContents(B,c._lastPosition,true);c._lastPosition=null;}};
A.prototype.ontouchstart=function(j){if(this._ignoreTouch){return;}if(q(j.target).hasClass("sapUiLoSplitterBarIcon")){j.target=j.target.parentElement;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!==0){return;}if(!j.changedTouches||!j.changedTouches[0]){return;}this._ignoreMouse=true;this._onBarMoveStart(j.changedTouches[0],true);};
A.prototype._onBarMoveStart=function(j,t){var I=this.getId();this.disableAutoResize(true);var p=j[this._moveCord];var s=parseInt(j.target.id.substr((I+"-splitbar-").length));var c=parseInt(j.target.parentElement.id.substr((I+"-splitbar-").length));var B=(s+1)?s:c;var $=q(j.target);if($.attr("class")==="sapUiLoSplitterBarIcon"){$=$.parent();}var C=this.getCalculatedSizes();var d=this._bHorizontal?$.innerWidth():$.innerHeight();var e=this._getContentAreas();var l=e[B].getLayoutData();var o=e[B+1].getLayoutData();if(!l.getResizable()||!o.getResizable()){b(t);return;}var r=0-d;for(var i=0;i<=B;++i){r+=C[i]+d;}this._move={start:p,relStart:r,barNum:B,bar:q(j.target),c1Size:C[B],c1MinSize:l?parseInt(l.getMinSize()):0,c2Size:C[B+1],c2MinSize:o?parseInt(o.getMinSize()):0};if(t){document.addEventListener("touchend",this._boundBarMoveEnd);document.addEventListener("touchmove",this._boundBarMove);}else{document.addEventListener("mouseup",this._boundBarMoveEnd);document.addEventListener("mousemove",this._boundBarMove);}this._$SplitterOverlay.css("display","block");this._$SplitterOverlay.appendTo(this.getDomRef());this._$SplitterOverlayBar.css(this._sizeDirNot,"");this._move["bar"].css("visibility","hidden");this._onBarMove(j);};
A.prototype._resizeContents=function(l,p,f){var c,o,d,s,e,C,$,n,N,m,M,O,i,F,g,D,h=parseFloat(this._move.c1Size).toFixed(5),j=parseFloat(this._move.c2Size).toFixed(5),k=parseFloat(h),r=parseFloat(j);if(isNaN(p)){L.warning("Splitter: Received invalid resizing values - resize aborted.");return;}c=this._getContentAreas();o=c[l].getLayoutData();d=c[l+1].getLayoutData();s=o.getSize();e=d.getSize();C=this.$("content-"+l);$=this.$("content-"+(l+1));n=k+p;N=r-p;m=parseInt(o.getMinSize());M=parseInt(d.getMinSize());O=this.getOrientation();i=O==="Horizontal"?this.$().width():this.$().height();if(n<m){D=m-n;p+=D;n=m;N-=D;}else if(N<M){D=M-N;p-=D;N=M;n-=D;}if(f){if(s==="auto"&&e!=="auto"){g=this._pxToPercent(N,i);d.setSize(g);}else if(s!=="auto"&&e==="auto"){F=this._pxToPercent(n,i);o.setSize(F);}else{F=this._pxToPercent(n,i);g=this._pxToPercent(N,i);o.setSize(F);d.setSize(g);}}else{F=this._pxToPercent(n,i);g=this._pxToPercent(N,i);C.css(this._sizeType,F);$.css(this._sizeType,g);}};
A.prototype._pxToPercent=function(p,f){return(p*100)/f+"%";};
A.prototype._recalculateSizes=function(){var i,s,l,c,d,e,m;var f=[];var C=this._getContentAreas();var o=this.getOrientation();var g=[];var h=[];var p=[];for(i=0;i<C.length;++i){l=C[i].getLayoutData();s=l?l.getSize():"auto";f.push(s);}var j=this._calculateAvailableContentSize(f)+1;this._calculatedSizes=[];for(i=0;i<f.length;++i){s=f[i];if(s.indexOf("px")>-1){e=parseInt(s);j-=e;this._calculatedSizes[i]=e;}else if(s.indexOf("%")>-1){p.push(i);}else if(s==="auto"){l=C[i].getLayoutData();if(l&&parseInt(l.getMinSize())!==0){h.push(i);}else{g.push(i);}}else{L.error("Illegal size value: "+f[i]);}}var w=false;if(j<0){w=true;j=0;}var r=j;j=o==="Horizontal"?this.$().width():this.$().height();var P=p.length;for(i=0;i<P;++i){d=p[i];if(P===1&&C.length===1){c=j;}else{c=parseFloat(f[d])/100*j;m=parseInt(C[d].getLayoutData().getMinSize());if(c<m){c=m;}}this._calculatedSizes[d]=c;r-=c;}j=r;if(j<0){w=true;j=0;}c=Math.floor(j/(h.length+g.length),0);var k=h.length;for(i=0;i<k;++i){d=h[i];m=parseInt(C[d].getLayoutData().getMinSize());if(m>c){this._calculatedSizes[d]=m;j-=m;}else{this._calculatedSizes[d]=c;j-=c;}}if(j<0){w=true;j=0;}r=j;var n=g.length;c=Math.floor(j/n,0);for(i=0;i<n;++i){d=g[i];this._calculatedSizes[d]=c;r-=c;}if(w){L.info("[Splitter] The set sizes and minimal sizes of the splitter contents are bigger "+"than the available space in the UI.");}this._calculatedSizes=this._calculatedSizes;};
A.prototype._ensureAllSplittersCollapsed=function(B){var c=this._getContentAreas();var d=false;for(var i=0;i<c.length;i++){var s=c[i].getLayoutData().getSize().slice(0,-2);if(s==="0"||s==="au"){d=true;continue;}else if(i===(c.length-1)&&d){this._getContentAreas()[B+1].setLayoutData(new sap.ui.layout.SplitterLayoutData({size:"100%"}));}}};
function _(c){var l=c.getLayoutData();if(l&&(!l.getResizable||!l.getSize||!l.getMinSize)){L.warning("Content \""+c.getId()+"\" for the Splitter contained wrong LayoutData. "+"The LayoutData has been replaced with default values.");l=null;}if(!l){c.setLayoutData(new sap.ui.layout.SplitterLayoutData());}}
function b(t){var p=function(e){e.preventDefault();};var f=null;f=function(){document.removeEventListener("touchend",f);document.removeEventListener("touchmove",p);document.removeEventListener("mouseup",f);document.removeEventListener("mousemove",p);};if(t){this._ignoreMouse=true;document.addEventListener("touchend",f);document.addEventListener("touchmove",p);}else{document.addEventListener("mouseup",f);document.addEventListener("mousemove",p);}}
return A;});
sap.ui.predefine('sap/ui/layout/BlockLayout',['sap/ui/core/Control','./library','sap/ui/core/ResizeHandler',"./BlockLayoutRenderer"],function(C,l,R,B){"use strict";
var a=C.extend("sap.ui.layout.BlockLayout",{metadata:{library:"sap.ui.layout",properties:{background:{type:"sap.ui.layout.BlockBackgroundType",group:"Appearance",defaultValue:"Default"},keepFontSize:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.layout.BlockLayoutRow",multiple:true}},designtime:"sap/ui/layout/designtime/BlockLayout.designtime"}});
a.CONSTANTS={SIZES:{S:600,M:1024,L:1440,XL:null}};
a.prototype.init=function(){this._currentBreakpoint=null;};
a.prototype.onBeforeRendering=function(){this._detachResizeHandler();};
a.prototype.onAfterRendering=function(){this._onParentResize();this._notifySizeListeners();};
a.prototype.setBackground=function(n){var c=this.getBackground(),o=C.prototype.setProperty.apply(this,["background"].concat(Array.prototype.slice.call(arguments)));if(this.hasStyleClass("sapUiBlockLayoutBackground"+c)){this.removeStyleClass("sapUiBlockLayoutBackground"+c,true);}n=n?n:"Default";this.addStyleClass("sapUiBlockLayoutBackground"+n,true);this.invalidate();return o;};
a.prototype._onParentResize=function(){var p,d=this.getDomRef(),w=d.clientWidth,s=a.CONSTANTS.SIZES;this._detachResizeHandler();if(w>0){this._removeBreakpointClasses();for(p in s){if(s.hasOwnProperty(p)&&(s[p]===null||s[p]>w)){if(this._currentBreakpoint!=p){this._currentBreakpoint=p;this._notifySizeListeners();}this.addStyleClass("sapUiBlockLayoutSize"+p,true);break;}}}this._attachResizeHandler();};
a.prototype._notifySizeListeners=function(){var t=this;this.getContent().forEach(function(r){r._onParentSizeChange(t._currentBreakpoint);});};
a.prototype._removeBreakpointClasses=function(){var s=a.CONSTANTS.SIZES;for(var p in s){if(s.hasOwnProperty(p)){this.removeStyleClass("sapUiBlockLayoutSize"+p,true);}}};
a.prototype._attachResizeHandler=function(){if(!this._parentResizeHandler){this._parentResizeHandler=R.register(this,this._onParentResize.bind(this));}};
a.prototype._detachResizeHandler=function(){if(this._parentResizeHandler){R.deregister(this._parentResizeHandler);this._parentResizeHandler=null;}};
a.prototype.exit=function(){this._detachResizeHandler();};
return a;});
sap.ui.predefine('sap/ui/layout/BlockLayoutCell',['sap/ui/core/Control','sap/ui/Device','./library',"./BlockLayoutCellRenderer","sap/base/Log","./BlockLayoutCellData","sap/ui/thirdparty/jquery"],function(C,D,l,B,L,a,q){"use strict";
var b=C.extend("sap.ui.layout.BlockLayoutCell",{metadata:{library:"sap.ui.layout",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleAlignment:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:"Begin"},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:"Auto"},width:{type:"int",group:"Appearance",defaultValue:0},backgroundColorSet:{type:"sap.ui.layout.BlockLayoutCellColorSet",group:"Appearance"},backgroundColorShade:{type:"sap.ui.layout.BlockLayoutCellColorShade",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},titleLink:{type:"sap.ui.core.Control",multiple:false}},designtime:"sap/ui/layout/designtime/BlockLayoutCell.designtime"}});
b.prototype.setLayoutData=function(o){this.setAggregation("layoutData",o,true);var r=this.getParent();if(r){var e=q.Event("LayoutDataChange");e.srcControl=this;r._handleEvent(e);}if(o&&this.getWidth()!=0){this.getLayoutData().setSize(this.getWidth());}return this;};
b.prototype.setWidth=function(w){this.setProperty("width",w);if(this.getLayoutData()&&(this.getLayoutData().isA("sap.ui.layout.BlockLayoutCellData"))){this.getLayoutData().setSize(w);}return this;};
b.prototype.setTitleLink=function(o){if(o&&o.getMetadata().getName()!=="sap.m.Link"){L.warning("sap.ui.layout.BlockLayoutCell "+this.getId()+": Can't add value for titleLink aggregation different than sap.m.Link.");return this;}this.setAggregation("titleLink",o);return this;};
b.prototype._setParentRowScrollable=function(s){this._parentRowScrollable=s;};
b.prototype.onAfterRendering=function(e){if(D.browser.internet_explorer){var h=this.$().parents().toArray().some(function(c){if(c.className.indexOf("sapMDialogScroll")!==-1){return true;}});if(h){this.$()[0].style.flex=this._flexWidth+" 1 auto";}}};
b.prototype._getParentRowScrollable=function(){return this._parentRowScrollable;};
b.prototype._setFlexWidth=function(f){this._flexWidth=f;};
b.prototype._getFlexWidth=function(){return this._flexWidth;};
return b;});
sap.ui.predefine('sap/ui/layout/BlockLayoutCellData',['sap/ui/core/LayoutData','./library'],function(L,l){"use strict";
var B=L.extend("sap.ui.layout.BlockLayoutCellData",{metadata:{library:"sap.ui.layout",properties:{sSize:{type:"int",group:"Appearance",defaultValue:1},mSize:{type:"int",group:"Appearance",defaultValue:1},lSize:{type:"int",group:"Appearance",defaultValue:1},xlSize:{type:"int",group:"Appearance",defaultValue:1}}}});
B.prototype.breakRowOnSSize=true;B.prototype.breakRowOnMSize=false;B.prototype.breakRowOnLSize=false;B.prototype.breakRowOnXlSize=false;
B.prototype.setSize=function(v){this.setProperty("mSize",v);this.setProperty("lSize",v);this.setProperty("xlSize",v);var r=this.getParent();if(r&&r.getParent()){r.getParent().invalidate();}return this;};
return B;});
sap.ui.predefine('sap/ui/layout/BlockLayoutCellRenderer',['./library','sap/ui/core/library',"sap/base/Log"],function(l,c,L){"use strict";var T=c.TitleLevel;var B={};
B.render=function(r,b){this.startCell(r,b);this.addContent(r,b);this.endCell(r);};
B.startCell=function(r,b){var C=this.getCellColor(r,b);r.write("<div");r.writeControlData(b);r.addClass("sapUiBlockLayoutCell");C&&r.addClass(C);this.setWidth(r,b);r.writeStyles();r.writeClasses();r.write(">");};
B.getCellColor=function(r,b){var C=b.getBackgroundColorSet(),s=b.getBackgroundColorShade();if(!C&&!s){return"";}else if((C&&!s)||(!C&&s)){L.warning("Both, backgroundColorSet and backgroundColorShade should be defined. ColoSet is not applied to "+b.getId()+".");return"";}C=C.replace("ColorSet","");s=s.replace("Shade","");return"sapUiBlockLayoutCellColor"+C+s;};
B.setWidth=function(r,b){if(b._getParentRowScrollable()){var w=b.getWidth();if(w!==0){r.addStyle("width",w+"%");}}else{this.addFlex(r,b._getFlexWidth());}};
B.addFlex=function(r,f){r.addStyle("-webkit-flex",f);r.addStyle("-ms-flex",f);r.addStyle("flex",f);};
B.addTitle=function(r,b){var t=b.getTitleLink();var s=b.getTitle();if(s||t){var a="sapUiBlockCell"+b.getTitleAlignment(),d="sapUiBlockCellTitle "+a;if(b.getContent().length===0){d+=" sapUiBlockCellTitleNoContent";}var e=b.getTitleLevel(),f=e===T.Auto,g=f?"h2":e;r.write("<"+g+" id='"+this.getTitleId(b)+"' class='"+d+"'>");if(t){r.renderControl(t);}else{r.writeEscaped(s);}r.write("</"+g+">");}};
B.getTitleId=function(b){return b.getId()+"-Title";};
B.hasTitle=function(b){return b.getTitleLink()||b.getTitle();};
B.addContent=function(r,b){var a=b.getContent(),h=this.hasTitle(b);r.write("<div");r.addClass("sapUiBlockCellContent");if(b.getTitleAlignment()==="Center"){r.addClass("sapUiBlockCellCenteredContent");}r.writeClasses();if(h){r.writeAttribute("aria-labelledby",this.getTitleId(b));}r.write(">");if(h){this.addTitle(r,b);}a.forEach(r.renderControl,r);r.write("</div>");};
B.endCell=function(r){r.write("</div>");};
return B;},true);
sap.ui.predefine('sap/ui/layout/BlockLayoutRenderer',['./library'],function(l){"use strict";var B=l.BlockRowColorSets;var a={};
a.render=function(r,b){this.startLayout(r,b);this.addContent(r,b);this.endLayout(r);};
a.startLayout=function(r,b){var c=b.getBackground();b.addStyleClass("sapUiBlockLayoutBackground"+c);r.write("<div");r.writeControlData(b);r.addClass("sapUiBlockLayout");if(b.getKeepFontSize()){r.addClass("sapUiBlockLayoutKeepFontSize");}r.writeStyles();r.writeClasses();r.write(">");};
a.addContent=function(r,b){var c=b.getContent(),o=B,t=Object.keys(o).map(function(k){return o[k];}),n=t.length;c.forEach(function(d,i,R){var T=d.getRowColorSet()||t[i%n],C="sapUiBlockLayoutBackground"+T,p=(i&&R[i-1])||null;if(p&&p.hasStyleClass(C)){d.removeStyleClass(C);C+="Inverted";}if(C){d.addStyleClass(C);}r.renderControl(d);});};
a.endLayout=function(r){r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/ui/layout/BlockLayoutRow',['sap/ui/core/Control','./library','sap/ui/layout/BlockLayoutCellData',"./BlockLayoutRowRenderer","sap/base/Log"],function(C,l,B,a,L){"use strict";var b=l.BlockBackgroundType;var c=l.BlockRowColorSets;
var d=C.extend("sap.ui.layout.BlockLayoutRow",{metadata:{library:"sap.ui.layout",properties:{scrollable:{type:"boolean",group:"Appearance",defaultValue:false},rowColorSet:{type:"sap.ui.layout.BlockRowColorSets",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.layout.BlockLayoutCell",multiple:true,singularName:"content"}},associations:{accentCells:{type:"sap.ui.layout.BlockLayoutCell",multiple:true,singularName:"accentCell"}},designtime:"sap/ui/layout/designtime/BlockLayoutRow.designtime"}});
d.prototype.init=function(){this._applyLayoutData={};};
d.prototype.addContent=function(o){this._ensureLayoutData(o);return this.addAggregation("content",o);};
d.prototype.insertContent=function(o,i){this._ensureLayoutData(o);return this.insertAggregation("content",o,i);};
d.prototype.onBeforeRendering=function(){var e=this.getContent(),t=this;e.forEach(function(o,i){t._ensureLayoutData(o);o._setParentRowScrollable(t.getScrollable());});this._calculateBreakpointRendering();};
d.prototype.setRowColorSet=function(t){var A=Array.prototype.slice.call(arguments),o=C.prototype.setProperty.apply(this,["rowColorSet"].concat(A)),s="sapUiBlockLayoutBackground"+t,e=this.getParent(),f=e&&e.getBackground(),T=e&&e.indexOfAggregation("content",this),p=e&&e.getContent(),P=(T&&p[T-1])||null,n=(p&&p[T+1])||null,g=c,h=Object.keys(g).map(function(k){return g[k];}),i=false;if(P&&P._hasStyleClass(s,f,i,t)){s+="Inverted";i=true;}h.forEach(function(j){var k="sapUiBlockLayoutBackground"+j,I=k+"Inverted";if(this._hasStyleClass(k,f,false,j)){this.removeStyleClass(k,true);}else if(this._hasStyleClass(I,f,true,j)){this.removeStyleClass(I,true);}},this);this.addStyleClass(s,true);if(n&&n._hasStyleClass(s,f,i,t)){n.setRowColorSet.apply(n,A);}this.invalidate();return o;};
d.prototype.addAccentCell=function(i){var o,I=i&&i.getId?i.getId():i,e=Array.prototype.slice.call(arguments),f=b,g=this.getParent(),s=g&&(g.getBackground()||"");o=this.addAssociation.apply(this,["accentCells"].concat(e));if(!g){return this;}if([f.Accent,f.Mixed].indexOf(s)===-1){L.warning(I+" was not se as accent cell. Accent cells could be set only for 'Accent' and 'Mixed' layout backgrounds.");return this;}if(f.Mixed===s){this._processMixedCellStyles(I,this.getContent());}else if(f.Accent===s){this._processAccentCellStyles(this.getAccentCells(),this.getContent());}return o;};
d.prototype._ensureLayoutData=function(o){var O=o.getLayoutData();if(!O||!(O instanceof B)){o.setLayoutData(new B());}};
d.prototype._onParentSizeChange=function(e){this._currentSize=e;this._calculateBreakpointRendering();this.invalidate();};
d.prototype._getCellArangementForCurrentSize=function(){if(!this._arrangements||!this._currentSize){return null;}return this._arrangements[this._currentSize];};
d.prototype._calculateBreakpointRendering=function(){if(!this._currentSize){return;}this._arrangements={"S":this._calcArrangementForSize("S"),"M":this._calcArrangementForSize("M"),"L":this._calcArrangementForSize("L"),"XL":this._calcArrangementForSize("Xl")};};
d.prototype._calcArrangementForSize=function(s){var e=this.getContent();if(e.length>=3&&s==="M"&&e.length<5){return this._generateArrangementForMCase();}else{return this._generateArrangement(s);}};
d.prototype._generateArrangement=function(s){var o,I=0,f=[],e=[],A=[[]],g=this.getContent();g.forEach(function(h){o=h.getLayoutData();e.push(o["breakRowOn"+s+"Size"]);f.push(o["get"+s+"Size"]());});f.forEach(function(D,i){A[I].push(D);if(e[i+1]){I++;A[I]=[];}});return A;};
d.prototype._generateArrangementForMCase=function(){var e=this.getContent();if(e.length===3&&this._isAllCellsHasSameWidth("M")){return[[1,1,1]];}else if(e.length===3){return[[1,1],[1]];}else if(e.length===4){return[[1,1],[1,1]];}};
d.prototype._isAllCellsHasSameWidth=function(s){var e,f=this.getContent(),F=f[0].getLayoutData()["get"+s+"Size"]();for(var i=1;i<f.length;i++){e=f[i].getLayoutData()["get"+s+"Size"]();if(e!==F){return false;}}return true;};
d.prototype._processMixedCellStyles=function(i,e){var o,p;if(!e||!e.length){return this;}o=this.getParent();p=o&&(o.hasStyleClass("sapUiBlockLayoutSizeL")||o.hasStyleClass("sapUiBlockLayoutSizeXL"));e.forEach(function(f){var g,u;if(p&&f.getId()===i&&f.getWidth()===1){f.addStyleClass("sapContrast").addStyleClass("sapContrastPlus");g=c;u=this._hasStyleClass("sapUiBlockLayoutBackground"+g.ColorSet1,b.Mixed,false,g.ColorSet1)||this._hasStyleClass("sapUiBlockLayoutBackground"+g.ColorSet1,b.Mixed,true,g.ColorSet1);if(u){f.addStyleClass("sapUiBlockLayoutBackgroundContrast2");}}else if((!p||f.getId()!==i)&&(f.hasStyleClass("sapContrast")||f.hasStyleClass("sapContrastPlus"))){f.removeStyleClass("sapContrast").removeStyleClass("sapContrastPlus").removeStyleClass("sapUiBlockLayoutBackgroundContrast2");this.removeAssociation("accentCells",f);L.warning(i+" was removed as accent cell. Only one cell at a time could be accented for Mixed layout background");}},this);return this;};
d.prototype._processAccentCellStyles=function(A,r){var o,s,e,i=0,I=0,f=Array.prototype.slice.call(A);if(!A||!A.length){return this;}for(i=0;i<r.length;i++){o=r[i];s=o.getId();if(!f.length){break;}if(f.indexOf(s)>-1){I++;e="sapUiBlockLayoutBackgroundColorSetGray"+((I%2)+1);if(o.hasStyleClass(e)){continue;}f.splice(f.indexOf(s),1);o.removeStyleClass("sapUiBlockLayoutBackgroundColorSetGray1").removeStyleClass("sapUiBlockLayoutBackgroundColorSetGray2").addStyleClass(e);}}return this;};
d.prototype._hasStyleClass=function(s,e,I,t){var o=b,f=c,i,S,E;if([o.Light,o.Mixed].indexOf(e)===-1){return this.hasStyleClass(s);}else if(this.hasStyleClass(s)){return true;}E=[[f.ColorSet1,f.ColorSet3],[f.ColorSet2,f.ColorSet4]];for(i=0;i<=E.length;i++){if(E[i]&&E[i].indexOf(t)>-1){break;}}if(!E[i]){return false;}S=E[i].map(function(g){return"sapUiBlockLayoutBackground"+g+(I?"Inverted":"");});return S.some(this.hasStyleClass,this);};
return d;});
sap.ui.predefine('sap/ui/layout/BlockLayoutRowRenderer',['./library'],function(l){"use strict";var B=l.BlockBackgroundType;var a={};
a.render=function(r,b){this.startRow(r,b);this.renderContent(r,b);this.endRow(r,b);};
a.startRow=function(r,b){r.write("<div");r.writeControlData(b);r.addClass("sapUiBlockLayoutRow");this.addRowRenderingClass(r,b);r.writeStyles();r.writeClasses();r.write(">");};
a.addRowRenderingClass=function(r,b){if(b.getScrollable()){r.addClass("sapUiBlockScrollingRow");if(b.getContent().length>=6){r.addClass("sapUiBlockScrollingNarrowCells");}}else{r.addClass("sapUiBlockHorizontalCellsRow");}};
a.renderContent=function(r,b){var c=b.getContent(),s=b.getScrollable(),o=B,L=b.getParent().getBackground(),A=b.getAccentCells(),C=0,f;c.forEach(function(e,g){(g%2)==0?e.addStyleClass("sapUiBlockLayoutOddCell"):e.addStyleClass("sapUiBlockLayoutEvenCell");if(s){e.addStyleClass("sapUiBlockScrollableCell");}else{e.addStyleClass("sapUiBlockHorizontalCell");}});switch(L){case o.Mixed:b._processMixedCellStyles(A[0],c);break;case o.Accent:b._processAccentCellStyles(A,c);break;}var d=b._getCellArangementForCurrentSize();if(s){c.forEach(r.renderControl,r);}else if(d){for(var i=0;i<d.length;i++){var S=d[i];r.write("<div ");r.addStyle("display","flex");r.writeStyles();r.write(">");for(var j=0;j<S.length;j++){f=S[j];c[C]._setFlexWidth(f);r.renderControl(c[C]);C++;}r.write("</div>");}}};
a.endRow=function(r){r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/ui/layout/DynamicSideContent',['sap/ui/thirdparty/jquery','sap/ui/core/Control','sap/ui/core/ResizeHandler','sap/ui/layout/library','./DynamicSideContentRenderer'],function(q,C,R,l,D){"use strict";var a=l.SideContentPosition;var b=l.SideContentFallDown;var c=l.SideContentVisibility;
var d=C.extend("sap.ui.layout.DynamicSideContent",{metadata:{library:"sap.ui.layout",properties:{showSideContent:{type:"boolean",group:"Appearance",defaultValue:true},showMainContent:{type:"boolean",group:"Appearance",defaultValue:true},sideContentVisibility:{type:"sap.ui.layout.SideContentVisibility",group:"Appearance",defaultValue:c.ShowAboveS},sideContentFallDown:{type:"sap.ui.layout.SideContentFallDown",group:"Appearance",defaultValue:b.OnMinimumWidth},equalSplit:{type:"boolean",group:"Appearance",defaultValue:false},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},sideContentPosition:{type:"sap.ui.layout.SideContentPosition",group:"Appearance",defaultValue:a.End}},defaultAggregation:"mainContent",events:{breakpointChanged:{parameters:{currentBreakpoint:{type:"string"}}}},aggregations:{mainContent:{type:"sap.ui.core.Control",multiple:true},sideContent:{type:"sap.ui.core.Control",multiple:true}},designTime:"sap/ui/layout/designtime/DynamicSideContent.designtime",dnd:{draggable:false,droppable:true}}});
var S="S",M="M",L="L",X="XL",H="sapUiHidden",e="sapUiDSCSpan12",f="sapUiDSCMCFixed",g="sapUiDSCSCFixed",h=3,i=4,j=6,k=8,m=9,n=12,I="Invalid Breakpoint. Expected: S, M, L or XL",o="SCGridCell",p="MCGridCell",r=720,s=1024,t=1440;
d.prototype.init=function(){this._bSuppressInitialFireBreakPointChange=true;};
d.prototype.setSideContentVisibility=function(v,u){this.setProperty("sideContentVisibility",v,true);if(!u&&this.$().length){this._setResizeData(this.getCurrentBreakpoint());this._changeGridState();}return this;};
d.prototype.setShowSideContent=function(v,u){if(v===this.getShowSideContent()){return this;}this.setProperty("showSideContent",v,true);this._SCVisible=v;if(!u&&this.$().length){this._setResizeData(this.getCurrentBreakpoint(),this.getEqualSplit());if(this._currentBreakpoint===S){this._MCVisible=true;}this._changeGridState();}return this;};
d.prototype.setShowMainContent=function(v,u){if(v===this.getShowMainContent()){return this;}this.setProperty("showMainContent",v,true);this._MCVisible=v;if(!u&&this.$().length){this._setResizeData(this.getCurrentBreakpoint(),this.getEqualSplit());if(this._currentBreakpoint===S){this._SCVisible=true;}this._changeGridState();}return this;};
d.prototype.isSideContentVisible=function(){if(this._currentBreakpoint===S){return this._SCVisible&&this.getProperty("showSideContent");}else{return this.getProperty("showSideContent");}};
d.prototype.isMainContentVisible=function(){if(this._currentBreakpoint===S){return this._MCVisible&&this.getProperty("showMainContent");}else{return this.getProperty("showMainContent");}};
d.prototype.setEqualSplit=function(u){this._MCVisible=true;this._SCVisible=true;this.setProperty("equalSplit",u,true);if(this._currentBreakpoint){this._setResizeData(this._currentBreakpoint,u);this._changeGridState();}return this;};
d.prototype.addSideContent=function(u){this.addAggregation("sideContent",u,true);this._rerenderControl(this.getAggregation("sideContent"),this.$(o));return this;};
d.prototype.addMainContent=function(u){this.addAggregation("mainContent",u,true);this._rerenderControl(this.getAggregation("mainContent"),this.$(p));return this;};
d.prototype.toggle=function(){if(this._currentBreakpoint===S){if(!this.getProperty("showMainContent")){this.setShowMainContent(true,true);this._MCVisible=false;}if(!this.getProperty("showSideContent")){this.setShowSideContent(true,true);this._SCVisible=false;}if(this._MCVisible&&!this._SCVisible){this._SCVisible=true;this._MCVisible=false;}else if(!this._MCVisible&&this._SCVisible){this._MCVisible=true;this._SCVisible=false;}this._changeGridState();}return this;};
d.prototype.getCurrentBreakpoint=function(){return this._currentBreakpoint;};
d.prototype.onBeforeRendering=function(){this._detachContainerResizeListener();this._SCVisible=this.getProperty("showSideContent");this._MCVisible=this.getProperty("showMainContent");if(!this.getContainerQuery()){this._iWindowWidth=q(window).width();this._setBreakpointFromWidth(this._iWindowWidth);this._setResizeData(this._currentBreakpoint,this.getEqualSplit());}};
d.prototype.onAfterRendering=function(){if(this.getContainerQuery()){this._attachContainerResizeListener();this._adjustToScreenSize();}else{var u=this;q(window).resize(function(){u._adjustToScreenSize();});}this._changeGridState();this._initScrolling();};
d.prototype.exit=function(){this._detachContainerResizeListener();if(this._oSCScroller){this._oSCScroller.destroy();this._oSCScroller=null;}if(this._oMCScroller){this._oMCScroller.destroy();this._oMCScroller=null;}};
d.prototype._rerenderControl=function(u,$){if(this.getDomRef()){var v=sap.ui.getCore().createRenderManager();this.getRenderer().renderControls(v,u);v.flush($[0]);v.destroy();}return this;};
d.prototype._initScrolling=function(){var u=this.getId(),v=u+"-"+o,w=u+"-"+p;if(!this._oSCScroller&&!this._oMCScroller){var x=sap.ui.requireSync("sap/ui/core/delegate/ScrollEnablement");this._oSCScroller=new x(this,null,{scrollContainerId:v,horizontal:false,vertical:true});this._oMCScroller=new x(this,null,{scrollContainerId:w,horizontal:false,vertical:true});}};
d.prototype._attachContainerResizeListener=function(){if(!this._sContainerResizeListener){this._sContainerResizeListener=R.register(this,q.proxy(this._adjustToScreenSize,this));}};
d.prototype._detachContainerResizeListener=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}};
d.prototype._getBreakPointFromWidth=function(w){if(w<=r&&this._currentBreakpoint!==S){return S;}else if((w>r)&&(w<=s)&&this._currentBreakpoint!==M){return M;}else if((w>s)&&(w<=t)&&this._currentBreakpoint!==L){return L;}else if(w>t&&this._currentBreakpoint!==X){return X;}return this._currentBreakpoint;};
d.prototype._setBreakpointFromWidth=function(w){this._currentBreakpoint=this._getBreakPointFromWidth(w);if(this._bSuppressInitialFireBreakPointChange){this._bSuppressInitialFireBreakPointChange=false;}else{this.fireBreakpointChanged({currentBreakpoint:this._currentBreakpoint});}};
d.prototype._adjustToScreenSize=function(){if(this.getContainerQuery()){this._iWindowWidth=this.$().parent().width();}else{this._iWindowWidth=q(window).width();}if(this._iWindowWidth!==this._iOldWindowWidth){this._iOldWindowWidth=this._iWindowWidth;this._oldBreakPoint=this._currentBreakpoint;this._setBreakpointFromWidth(this._iWindowWidth);if((this._oldBreakPoint!==this._currentBreakpoint)||(this._currentBreakpoint===M&&this.getSideContentFallDown()===b.OnMinimumWidth)){this._setResizeData(this._currentBreakpoint,this.getEqualSplit());this._changeGridState();}}};
d.prototype._setResizeData=function(u,v){var w=this.getSideContentVisibility(),x=this.getSideContentFallDown();if(!v){switch(u){case S:this._setSpanSize(n,n);if(this.getProperty("showSideContent")&&this.getProperty("showMainContent")){this._SCVisible=w===c.AlwaysShow;}this._bFixedSideContent=false;break;case M:var y=Math.ceil((33.333/100)*this._iWindowWidth);if(x===b.BelowL||x===b.BelowXL||(y<=320&&x===b.OnMinimumWidth)){this._setSpanSize(n,n);this._bFixedSideContent=false;}else{this._setSpanSize(i,k);this._bFixedSideContent=true;}this._SCVisible=w===c.ShowAboveS||w===c.AlwaysShow;this._MCVisible=true;break;case L:if(x===b.BelowXL){this._setSpanSize(n,n);}else{this._setSpanSize(i,k);}this._SCVisible=w===c.ShowAboveS||w===c.ShowAboveM||w===c.AlwaysShow;this._MCVisible=true;this._bFixedSideContent=false;break;case X:this._setSpanSize(h,m);this._SCVisible=w!==c.NeverShow;this._MCVisible=true;this._bFixedSideContent=false;break;default:throw new Error(I);}}else{switch(u){case S:this._setSpanSize(n,n);this._SCVisible=false;break;default:this._setSpanSize(j,j);this._SCVisible=true;this._MCVisible=true;}this._bFixedSideContent=false;}return this;};
d.prototype._shouldSetHeight=function(){var u,B,O,v,w,F,x;u=(this._iScSpan+this._iMcSpan)===n;B=this._MCVisible&&this._SCVisible;O=!this._MCVisible&&this._SCVisible;v=this._MCVisible&&!this._SCVisible;w=O||v;F=this._fixedSideContent;x=this.getSideContentVisibility()===c.NeverShow;return((u&&B)||w||F||x);};
d.prototype._changeGridState=function(){var $=this.$(o),u=this.$(p),v=this.getProperty("showMainContent"),w=this.getProperty("showSideContent");if(this._bFixedSideContent){$.removeClass().addClass(g);u.removeClass().addClass(f);}else{$.removeClass(g);u.removeClass(f);}if(this._SCVisible&&this._MCVisible&&w&&v){if(!this._bFixedSideContent){u.removeClass().addClass("sapUiDSCSpan"+this._iMcSpan);$.removeClass().addClass("sapUiDSCSpan"+this._iScSpan);}if(this._shouldSetHeight()){$.css("height","100%").css("float","left");u.css("height","100%").css("float","left");}else{$.css("height","auto").css("float","none");u.css("height","auto").css("float","none");}}else if(!this._SCVisible&&!this._MCVisible){u.addClass(H);$.addClass(H);}else if(!this._SCVisible&&this._MCVisible&&w&&v){$.removeClass().addClass(e);u.addClass(H);}else if(this._MCVisible&&v){u.removeClass().addClass(e);$.addClass(H);}else if(this._SCVisible&&w){$.removeClass().addClass(e);u.addClass(H);}else if(!v&&!w){u.addClass(H);$.addClass(H);}};
d.prototype._setSpanSize=function(u,v){this._iScSpan=u;this._iMcSpan=v;};
return d;});
sap.ui.predefine('sap/ui/layout/DynamicSideContentRenderer',["sap/ui/layout/library","sap/ui/Device"],function(l,D){"use strict";var S=l.SideContentPosition;var a="SIDE_CONTENT_LABEL";var b={};
b.render=function(r,s){r.write("<div");r.writeControlData(s);r.addClass("sapUiDSC");r.writeClasses();r.addStyle("height","100%");r.writeStyles();r.write(">");this.renderSubControls(r,s);r.write("</div>");};
b.renderSubControls=function(r,s){var i=s.getId(),c=s._shouldSetHeight(),p=sap.ui.getCore().getConfiguration().getRTL(),d=s.getSideContentPosition();if((d===S.Begin&&!p)||(p&&d===S.End)){this._renderSideContent(r,s,i,c);this._renderMainContent(r,s,i,c);}else{this._renderMainContent(r,s,i,c);this._renderSideContent(r,s,i,c);}};
b.renderControls=function(r,c){var L=c.length,i=0;for(;i<L;i++){r.renderControl(c[i]);}};
b._renderMainContent=function(r,s,i,c){r.write("<div id='"+i+"-MCGridCell'");if(s._iMcSpan){r.addClass("sapUiDSCSpan"+s._iMcSpan);r.writeClasses();}if(c){r.addStyle("height","100%");r.writeStyles();}r.write(">");this.renderControls(r,s.getMainContent());r.write("</div>");};
b._renderSideContent=function(r,s,i,c){var d=D.browser.firefox?"div":"aside";r.write("<"+d+" id='"+i+"-SCGridCell'");var m=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");r.writeAttribute("aria-label",m.getText(a));r.writeAccessibilityState(s,{role:"complementary"});if(s._iScSpan){r.addClass("sapUiDSCSpan"+s._iScSpan);r.writeClasses();}if(c){r.addStyle("height","100%");r.writeStyles();}r.write(">");this.renderControls(r,s.getSideContent());r.write("</"+d+">");};
return b;},true);
sap.ui.predefine('sap/ui/layout/FixFlex',["sap/ui/core/Control","sap/ui/core/EnabledPropagator","sap/ui/core/ResizeHandler","./library","sap/ui/core/delegate/ScrollEnablement","./FixFlexRenderer","sap/ui/thirdparty/jquery"],function(C,E,R,l,S,F,q){"use strict";
var a=C.extend("sap.ui.layout.FixFlex",{metadata:{library:"sap.ui.layout",properties:{vertical:{type:"boolean",group:"Appearance",defaultValue:true},fixFirst:{type:"boolean",group:"Misc",defaultValue:true},fixContentSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},minFlexSize:{type:"int",defaultValue:0}},aggregations:{fixContent:{type:"sap.ui.core.Control",multiple:true,singularName:"fixContent"},flexContent:{type:"sap.ui.core.Control",multiple:false}},designtime:"sap/ui/layout/designtime/FixFlex.designtime",dnd:{draggable:false,droppable:true}}});
E.call(a.prototype);
a.prototype.init=function(){this._scroller=new S(this,null,{scrollContainerId:this.getId()});this._innerScroller=new S(this,this.getId()+"-FlexibleContainer",{scrollContainerId:this.getId()+"-Flexible"});};
a.prototype.getScrollDelegate=function(){return this._innerScroller;};
a.prototype._handlerResizeNoFlexBoxSupport=function(){var c=this.$(),f,$;if(!c.is(":visible")){return;}f=this.$("Fixed");$=this.$("Flexible");f.removeAttr("style");$.removeAttr("style");if(this.getVertical()){if(this.getFixContentSize()!=='auto'){f.height(this.getFixContentSize());}$.height(Math.floor(c.height()-f.height()));}else{if(this.getFixContentSize()!=='auto'){f.width(this.getFixContentSize());$.width(Math.floor(c.width()-f.width()));}else{$.width(Math.floor(c.width()-f.width()));f.width(Math.floor(f.width()));}}};
a.prototype._deregisterControl=function(){if(this.sResizeListenerNoFlexBoxSupportId){R.deregister(this.sResizeListenerNoFlexBoxSupportId);this.sResizeListenerNoFlexBoxSupportId=null;}if(this.sResizeListenerNoFlexBoxSupportFixedId){R.deregister(this.sResizeListenerNoFlexBoxSupportFixedId);this.sResizeListenerNoFlexBoxSupportFixedId=null;}if(this.sResizeListenerFixFlexScroll){R.deregister(this.sResizeListenerFixFlexScroll);this.sResizeListenerFixFlexScroll=null;}if(this.sResizeListenerFixFlexScrollFlexPart){R.deregister(this.sResizeListenerFixFlexScrollFlexPart);this.sResizeListenerFixFlexScrollFlexPart=null;}if(this.sResizeListenerFixFlexContainerScroll){R.deregister(this.sResizeListenerFixFlexContainerScroll);this.sResizeListenerFixFlexContainerScroll=null;}};
a.prototype._changeScrolling=function(){var n,d,$=this.$(),b=this.getMinFlexSize(),i=this.getVertical();if(i){n=this.$().height()-this.$("Fixed").height();d="height";}else{n=this.$().width()-this.$("Fixed").width();d="width";}if(n<=parseInt(this.getMinFlexSize())){$.addClass("sapUiFixFlexScrolling");$.removeClass("sapUiFixFlexInnerScrolling");if(i){this._scroller.setVertical(true);this._innerScroller.setVertical(false);}else{this._scroller.setHorizontal(true);this._innerScroller.setHorizontal(false);}if(this.$("FlexibleContainer").children().height()>b){this.$("Flexible").attr("style","min-"+d+":"+b+"px");}else{this.$("Flexible").attr("style",d+":"+b+"px");}}else{$.addClass("sapUiFixFlexInnerScrolling");$.removeClass("sapUiFixFlexScrolling");if(i){this._scroller.setVertical(false);this._innerScroller.setVertical(true);}else{this._scroller.setHorizontal(false);this._innerScroller.setHorizontal(true);}this._changeFlexibleContainerScroll();this.$("Flexible").removeAttr("style");}};
a.prototype._changeFlexibleContainerScroll=function(){var $=this.$("FlexibleContainer"),c=$.height(),b=$.children().height();if(c==b){return;}if(c>b){$.removeClass('sapUiFixFlexFlexibleContainerGrowing');}else{$.addClass('sapUiFixFlexFlexibleContainerGrowing');}};
a.prototype.exit=function(){this._deregisterControl();if(this._scroller){this._scroller.destroy();this._scroller=null;}if(this._innerScroller){this._innerScroller.destroy();this._innerScroller=null;}};
a.prototype.onBeforeRendering=function(){var s=this._scroller,i=this._innerScroller,b=this.getMinFlexSize()!=0;this._deregisterControl();s.setVertical(false);s.setHorizontal(false);i.setVertical(b);i.setHorizontal(b);};
a.prototype.onAfterRendering=function(){if(this.getMinFlexSize()!==0){this.sResizeListenerFixFlexScroll=R.register(this.getDomRef(),q.proxy(this._changeScrolling,this));this.sResizeListenerFixFlexScrollFlexPart=R.register(this.getDomRef("Fixed"),q.proxy(this._changeScrolling,this));var f=this.$("FlexibleContainer").children()[0];if(f){this.sResizeListenerFixFlexContainerScroll=R.register(f,q.proxy(this._changeFlexibleContainerScroll,this));}this._changeScrolling();}};
return a;});
sap.ui.predefine('sap/ui/layout/FixFlexRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){r.write('<div');r.writeControlData(c);r.addClass('sapUiFixFlex');if(c.getMinFlexSize()!==0){r.addClass('sapUiFixFlexInnerScrolling');}if(!c.getVertical()){r.addClass('sapUiFixFlexRow');}r.writeClasses();r.write('>');if(c.getFixFirst()){this.renderFixChild(r,c);this.renderFlexChild(r,c);}else{this.renderFlexChild(r,c);this.renderFixChild(r,c);}r.write('</div>');};
F.renderFixChild=function(r,c){var f=c.getFixContent();r.write('<div id="'+c.getId()+'-Fixed" class="sapUiFixFlexFixed"');if(c.getFixContentSize()!=='auto'){if(c.getVertical()){r.addStyle('height',c.getFixContentSize());}else{r.addStyle('width',c.getFixContentSize());}r.writeStyles();}r.write('>');for(var i=0;i<f.length;i++){r.renderControl(f[i]);}r.write('</div>');};
F.renderFlexChild=function(r,c){var f=c.getFlexContent();r.write('<div id="'+c.getId()+'-Flexible" class="sapUiFixFlexFlexible">');r.write('<div id="'+c.getId()+'-FlexibleContainer" class="sapUiFixFlexFlexibleContainer"');if(c.getMinFlexSize()!==0){if(c.getVertical()){r.write('style="min-height:'+c.getMinFlexSize()+'px"');}else{r.write('style="min-width:'+c.getMinFlexSize()+'px"');}}r.write('>');r.renderControl(f);r.write('</div>');r.write('</div>');};
return F;},true);
sap.ui.predefine('sap/ui/layout/Grid',['sap/ui/core/Control','./library','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/base/ManagedObjectObserver',"./GridRenderer","sap/ui/thirdparty/jquery"],function(C,l,D,R,M,G,q){"use strict";
var a=C.extend("sap.ui.layout.Grid",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},vSpacing:{type:"float",group:"Dimension",defaultValue:1},hSpacing:{type:"float",group:"Dimension",defaultValue:1},position:{type:"sap.ui.layout.GridPosition",group:"Dimension",defaultValue:"Left"},defaultSpan:{type:"sap.ui.layout.GridSpan",group:"Behavior",defaultValue:"XL3 L3 M6 S12"},defaultIndent:{type:"sap.ui.layout.GridIndent",group:"Behavior",defaultValue:"XL0 L0 M0 S0"},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/ui/layout/designtime/Grid.designtime"}});
(function(){
a.prototype.init=function(){var c=l.GridHelper.getLibrarySpecificClass();if(c){this.addStyleClass(c);}this._iBreakPointTablet=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];this._indentXLChanged=false;this._spanXLChanged=false;this._oObserver=new M(a.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content"]});};
a.prototype.onAfterRendering=function(){if(this.getContainerQuery()){this._sContainerResizeListener=R.register(this,q.proxy(this._onParentResize,this));this._onParentResize();}else{this._attachMediaContainerWidthChange(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD_EXTENDED);}};
a.prototype.onBeforeRendering=function(){this._cleanup();};
a.prototype.exit=function(){this._cleanup();if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}};
a.prototype._cleanup=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}this._detachMediaContainerWidthChange(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD_EXTENDED);};
a.prototype._observeVisibility=function(c){this._oObserver.observe(c,{properties:["visible"]});};
a.prototype._unobserveVisibility=function(c){this._oObserver.unobserve(c,{properties:["visible"]});};
a.prototype._observeChanges=function(c){var o=c.object,s=c.name,m=c.mutation,b=c.child;if(o===this){if(m==="insert"){this._observeVisibility(b);}else if(m==="remove"){this._unobserveVisibility(b);}}else if(s==="visible"){var e=this.getContent().indexOf(o);q(this.$().children()[e]).toggleClass("sapUiRespGridSpanInvisible",!c.current);}};
a.prototype._handleMediaChange=function(p){this._toggleClass(p.name);};
a.prototype._setBreakPointTablet=function(b){this._iBreakPointTablet=b;};
a.prototype._setBreakPointDesktop=function(b){this._iBreakPointDesktop=b;};
a.prototype._setBreakPointLargeDesktop=function(b){this._iBreakPointLargeDesktop=b;};
a.prototype.setDefaultIndent=function(d){if(/XL/gi.test(d)){this._setIndentXLChanged(true);}return this.setProperty("defaultIndent",d);};
a.prototype._setIndentXLChanged=function(c){this._indentXLChanged=c;};
a.prototype._getIndentXLChanged=function(){return this._indentXLChanged;};
a.prototype.setDefaultSpan=function(d){if(/XL/gi.test(d)){this._setSpanXLChanged(true);}return this.setProperty("defaultSpan",d);};
a.prototype._setSpanXLChanged=function(c){this._spanXLChanged=c;};
a.prototype._getSpanXLChanged=function(){return this._spanXLChanged;};
a.prototype._onParentResize=function(){var d=this.getDomRef();if(!d){this._cleanup();return;}if(!q(d).is(":visible")){return;}var c=d.clientWidth;if(c<=this._iBreakPointTablet){this._toggleClass("Phone");}else if((c>this._iBreakPointTablet)&&(c<=this._iBreakPointDesktop)){this._toggleClass("Tablet");}else if((c>this._iBreakPointDesktop)&&(c<=this._iBreakPointLargeDesktop)){this._toggleClass("Desktop");}else{this._toggleClass("LargeDesktop");}};
a.prototype._toggleClass=function(m){var d=this.$();if(!d){return;}if(d.hasClass("sapUiRespGridMedia-Std-"+m)){return;}d.toggleClass("sapUiRespGridMedia-Std-"+m,true);if(m==="Phone"){d.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false);}else if(m==="Tablet"){d.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false);}else if(m==="LargeDesktop"){d.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false);}else{d.toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false);}this.fireEvent("mediaChanged",{media:m});};
a.prototype._getLayoutDataForControl=function(c){var L=c.getLayoutData();if(!L){return undefined;}else if(L instanceof sap.ui.layout.GridData){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var b=L.getMultipleLayoutData();for(var i=0;i<b.length;i++){var o=b[i];if(o instanceof sap.ui.layout.GridData){return o;}}}};
a.prototype.onLayoutDataChange=function(e){if(this.getDomRef()){this.invalidate();}};
a.prototype._getAccessibleRole=function(){return null;};
a.prototype.getAccessibilityInfo=function(){return{children:this.getContent().filter(function(c){return c.$().is(':visible');})};};
}());return a;});
sap.ui.predefine('sap/ui/layout/GridData',['sap/ui/core/LayoutData','./library',"sap/base/Log"],function(L,l,a){"use strict";
var G=L.extend("sap.ui.layout.GridData",{metadata:{library:"sap.ui.layout",properties:{span:{type:"sap.ui.layout.GridSpan",group:"Behavior",defaultValue:null},spanXL:{type:"int",group:"Behavior",defaultValue:null},spanL:{type:"int",group:"Behavior",defaultValue:null},spanM:{type:"int",group:"Behavior",defaultValue:null},spanS:{type:"int",group:"Behavior",defaultValue:null},indent:{type:"sap.ui.layout.GridIndent",group:"Behavior",defaultValue:null},indentXL:{type:"int",group:"Behavior",defaultValue:null},indentL:{type:"int",group:"Behavior",defaultValue:null},indentM:{type:"int",group:"Behavior",defaultValue:null},indentS:{type:"int",group:"Behavior",defaultValue:null},visibleXL:{type:"boolean",group:"Behavior",defaultValue:true},visibleL:{type:"boolean",group:"Behavior",defaultValue:true},visibleM:{type:"boolean",group:"Behavior",defaultValue:true},visibleS:{type:"boolean",group:"Behavior",defaultValue:true},moveBackwards:{type:"sap.ui.layout.GridIndent",group:"Misc",defaultValue:null},moveForward:{type:"sap.ui.layout.GridIndent",group:"Misc",defaultValue:null},linebreak:{type:"boolean",group:"Misc",defaultValue:false},linebreakXL:{type:"boolean",group:"Misc",defaultValue:false},linebreakL:{type:"boolean",group:"Misc",defaultValue:false},linebreakM:{type:"boolean",group:"Misc",defaultValue:false},linebreakS:{type:"boolean",group:"Misc",defaultValue:false},spanLarge:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},spanMedium:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},spanSmall:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},indentLarge:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},indentMedium:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},indentSmall:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},visibleOnLarge:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},visibleOnMedium:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},visibleOnSmall:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true}}}});
(function(){
G.prototype._setStylesInternal=function(s){if(s&&s.length>0){this._sStylesInternal=s;}else{this._sStylesInternal=undefined;}};
G.prototype._getEffectiveSpanXLarge=function(){var s=this.getSpanXL();if(s&&(s>0)&&(s<13)){return s;}var S=/XL([1-9]|1[0-2])(?:\s|$)/i;var b=S.exec(this.getSpan());if(b){var c=b[0];if(c){c=c.toUpperCase();if(c.substr(0,2)==="XL"){return parseInt(c.substr(2));}}}return undefined;};
G.prototype._getEffectiveSpanLarge=function(){var s=this.getSpanL();if(s&&(s>0)&&(s<13)){return s;}var S=/\bL([1-9]|1[0-2])(?:\s|$)/i;var b=S.exec(this.getSpan());if(b){var c=b[0];if(c){c=c.toUpperCase();if(c.substr(0,1)==="L"){return parseInt(c.substr(1));}}}return undefined;};
G.prototype._getEffectiveSpanMedium=function(){var s=this.getSpanM();if(s&&(s>0)&&(s<13)){return s;}var S=/M([1-9]|1[0-2])(?:\s|$)/i;var b=S.exec(this.getSpan());if(b){var c=b[0];if(c){c=c.toUpperCase();if(c.substr(0,1)==="M"){return parseInt(c.substr(1));}}}return undefined;};
G.prototype._getEffectiveSpanSmall=function(){var s=this.getSpanS();if(s&&(s>0)&&(s<13)){return s;}var S=/S([1-9]|1[0-2])(?:\s|$)/i;var b=S.exec(this.getSpan());if(b){var c=b[0];if(c){c=c.toUpperCase();if(c.substr(0,1)==="S"){return parseInt(c.substr(1));}}}return undefined;};
G.prototype.init=function(){this._bLinebreakXLChanged=false;};
G.prototype.setLinebreakXL=function(b){this.setProperty("linebreakXL",b);this._bLinebreakXLChanged=true;return this;};
G.prototype._getLinebreakXLChanged=function(){return this._bLinebreakXLChanged;};
G.prototype.setSpanLarge=function(s){this.setSpanL(s);a.warning("Deprecated property spanLarge is used, please use spanL instead.");return this;};
G.prototype.setSpanMedium=function(s){a.warning("Deprecated property spanMedium is used, please use spanM instead.");return this.setSpanM(s);};
G.prototype.setSpanSmall=function(s){a.warning("Deprecated property spanSmall is used, please use spanS instead.");return this.setSpanS(s);};
G.prototype.setIndentLarge=function(i){a.warning("Deprecated property indentLarge is used, please use indentL instead.");return this.setIndentL(i);};
G.prototype.setIndentMedium=function(i){a.warning("Deprecated property indentMedium is used, please use indentM instead.");return this.setIndentM(i);};
G.prototype.setIndentSmall=function(i){a.warning("Deprecated property indentSmall is used, please use indentS instead.");return this.setIndentS(i);};
G.prototype.setVisibleOnLarge=function(v){a.warning("Deprecated property visibleOnLarge is used, please use visibleL instead.");return this.setVisibleL(v);};
G.prototype.setVisibleOnMedium=function(v){a.warning("Deprecated property visibleOnMedium is used, please use visibleM instead.");return this.setVisibleM(v);};
G.prototype.setVisibleOnSmall=function(v){a.warning("Deprecated property visibleOnSmall is used, please use visibleS instead.");return this.setVisibleS(v);};
G.prototype.getSpanLarge=function(){a.warning("Deprecated property spanLarge is used, please use spanL instead.");return this.getSpanL();};
G.prototype.getSpanMedium=function(){a.warning("Deprecated property spanMedium is used, please use spanM instead.");return this.getSpanM();};
G.prototype.getSpanSmall=function(){a.warning("Deprecated property spanSmall is used, please use spanS instead.");return this.getSpanS();};
G.prototype.getIndentLarge=function(){a.warning("Deprecated property indentLarge is used, please use indentL instead.");return this.getIndentL();};
G.prototype.getIndentMedium=function(){a.warning("Deprecated property indentMedium is used, please use indentM instead.");return this.getIndentM();};
G.prototype.getIndentSmall=function(){a.warning("Deprecated property indentSmall is used, please use indentS instead.");return this.getIndentS();};
G.prototype.getVisibleOnLarge=function(){a.warning("Deprecated property visibleOnLarge is used, please use visibleL instead.");return this.getVisibleL();};
G.prototype.getVisibleOnMedium=function(){a.warning("Deprecated property visibleOnMedium is used, please use visibleM instead.");return this.getVisibleM();};
G.prototype.getVisibleOnSmall=function(){a.warning("Deprecated property visibleOnSmall is used, please use visibleS instead.");return this.getVisibleS();};
}());return G;},true);
sap.ui.predefine('sap/ui/layout/GridRenderer',["sap/ui/Device","sap/ui/layout/library"],function(D,l){"use strict";var G=l.GridPosition;var a={};
a.render=function(r,c){var I=/^([X][L](?:[0-9]|1[0-1]))? ?([L](?:[0-9]|1[0-1]))? ?([M](?:[0-9]|1[0-1]))? ?([S](?:[0-9]|1[0-1]))?$/i;var S=/^([X][L](?:[1-9]|1[0-2]))? ?([L](?:[1-9]|1[0-2]))? ?([M](?:[1-9]|1[0-2]))? ?([S](?:[1-9]|1[0-2]))?$/i;r.write("<div");r.writeControlData(c);r.addClass("sapUiRespGrid");var m=c._getCurrentMediaContainerRange(D.media.RANGESETS.SAP_STANDARD_EXTENDED).name;r.addClass("sapUiRespGridMedia-Std-"+m);var h=c.getHSpacing();if(h==0.5){h="05";}else if((h!==0)&&(h!==1)&&(h!==2)){h=1;}r.addClass("sapUiRespGridHSpace"+h);var v=c.getVSpacing();if(v==0.5){v="05";}else if((v!==0)&&(v!==1)&&(v!==2)){v=1;}r.addClass("sapUiRespGridVSpace"+v);var p=c.getPosition();if(p){p=p.toUpperCase();if(p===G.Center.toUpperCase()){r.addClass("sapUiRespGridPosCenter");}else if(p===G.Right.toUpperCase()){r.addClass("sapUiRespGridPosRight");}}r.writeClasses();var w=c.getWidth();if(w!=="100%"&&w!=="auto"&&w!=="inherit"){if(h==0){w="width: "+w;}else{w="width: -webkit-calc("+w+" - "+h+"rem); width: calc("+w+" - "+h+"rem); ";}r.writeAttribute("style",w);}var R=c._getAccessibleRole();var A;if(R){A={role:R};}r.writeAccessibilityState(c,A);r.write(">");var b=c.getContent();var d=c.getDefaultSpan();var e=["","XL3","L3","M6","S12"];var f=["","XL0","L0","M0","S0"];var g=S.exec(d);var k=c._getSpanXLChanged();var n=c._getIndentXLChanged();var s=c.getDefaultIndent();var o=I.exec(s);for(var i=0;i<b.length;i++){r.write("<div");var L=c._getLayoutDataForControl(b[i]);var C=false;if(!b[i].getVisible()){r.addClass("sapUiRespGridSpanInvisible");}if(L){var B=false;if(L.getLinebreak()===true){r.addClass("sapUiRespGridBreak");}else{if(L.getLinebreakXL()===true){B=true;r.addClass("sapUiRespGridBreakXL");}if(L.getLinebreakL()===true){if(!B&&!L._getLinebreakXLChanged()){r.addClass("sapUiRespGridBreakXL");}r.addClass("sapUiRespGridBreakL");}if(L.getLinebreakM()===true){r.addClass("sapUiRespGridBreakM");}if(L.getLinebreakS()===true){r.addClass("sapUiRespGridBreakS");}}var q;var t;var u=L.getSpan();if(!u||!u.lenght==0){q=g;}else{q=S.exec(u);if(/XL/gi.test(u)){C=true;}}if(q){for(var j=1;j<q.length;j++){var x=q[j];if(!x){x=g[j];if(!x){x=e[j];}}if(x.substr(0,1)==="L"){t=x.substr(1,2);}var y=L.getSpanXL();var z=L.getSpanL();var E=L.getSpanM();var F=L.getSpanS();x=x.toUpperCase();if((x.substr(0,2)==="XL")&&(y>0)&&(y<13)){r.addClass("sapUiRespGridSpanXL"+y);C=true;}else if((x.substr(0,1)==="L")&&(z>0)&&(z<13)){r.addClass("sapUiRespGridSpanL"+z);t=z;}else if((x.substr(0,1)==="M")&&(E>0)&&(E<13)){r.addClass("sapUiRespGridSpanM"+E);}else if((x.substr(0,1)==="S")&&(F>0)&&(F<13)){r.addClass("sapUiRespGridSpanS"+F);}else{if((x.substr(0,2)!=="XL")||k||C){r.addClass("sapUiRespGridSpan"+x);}}}if(!k&&!C){r.addClass("sapUiRespGridSpanXL"+t);}}var H;var J;var K=L.getIndent();if(!K||K.length==0){H=o;}else{H=I.exec(K);if(/XL/gi.test(K)){n=true;}}if(!H){H=o;if(!H){H=undefined;}}var M=L.getIndentXL();var N=L.getIndentL();var O=L.getIndentM();var P=L.getIndentS();if(H){for(var j=1;j<H.length;j++){var Q=H[j];if(!Q){if(o&&o[j]){Q=o[j];}else{Q=f[j];}}if(Q){Q=Q.toUpperCase();if(Q.substr(0,1)==="L"){J=Q.substr(1,2);}if((Q.substr(0,2)==="XL")&&(M>0)&&(M<12)){r.addClass("sapUiRespGridIndentXL"+M);n=true;}else if((Q.substr(0,1)==="L")&&(N>0)&&(N<12)){r.addClass("sapUiRespGridIndentL"+N);J=N;}else if((Q.substr(0,1)==="M")&&(O>0)&&(O<12)){r.addClass("sapUiRespGridIndentM"+O);}else if((Q.substr(0,1)==="S")&&(P>0)&&(P<12)){r.addClass("sapUiRespGridIndentS"+P);}else{if(!(/^(XL0)? ?(L0)? ?(M0)? ?(S0)?$/.exec(Q))){r.addClass("sapUiRespGridIndent"+Q);}}}}if(!n){if(J&&J>0){r.addClass("sapUiRespGridIndentXL"+J);}}}if(!L.getVisibleXL()){r.addClass("sapUiRespGridHiddenXL");}if(!L.getVisibleL()){r.addClass("sapUiRespGridHiddenL");}if(!L.getVisibleM()){r.addClass("sapUiRespGridHiddenM");}if(!L.getVisibleS()){r.addClass("sapUiRespGridHiddenS");}var T=L.getMoveBackwards();if(T&&T.length>0){var U=I.exec(T);if(U){for(var j=1;j<U.length;j++){var V=U[j];if(V){r.addClass("sapUiRespGridBwd"+V.toUpperCase());}}}}var W=L.getMoveForward();if(W&&W.length>0){var X=I.exec(W);if(X){for(var j=1;j<X.length;j++){var Y=X[j];if(Y){r.addClass("sapUiRespGridFwd"+Y.toUpperCase());}}}}if(L._sStylesInternal){r.addClass(L._sStylesInternal);}}if(!L){var x="";if(g){for(var j=1;j<g.length;j++){x=g[j];if(!x){if((j==1)&&(g[j+1])){x="X"+g[j+1];}else{x=e[j];}}r.addClass("sapUiRespGridSpan"+x.toUpperCase());}}else{for(var j=1;j<e.length;j++){x=e[j];r.addClass("sapUiRespGridSpan"+x.toUpperCase());}}var Q="";if(o){for(var j=1;j<o.length;j++){Q=o[j];if(!Q){if((j==1)&&(o[j+1])){Q="X"+o[j+1];}else{Q=f[j];}}if(((Q.substr(0,1)!=="X")&&(Q.substr(1,1)!=="0"))||((Q.substr(0,1)=="X")&&(Q.substr(2,1)!=="0"))){r.addClass("sapUiRespGridIndent"+Q.toUpperCase());}}}}r.writeClasses();r.write(">");r.renderControl(b[i]);r.write("</div>");}r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/ui/layout/HorizontalLayout',['sap/ui/core/Control','./library',"./HorizontalLayoutRenderer"],function(C,l,H){"use strict";
var a=C.extend("sap.ui.layout.HorizontalLayout",{metadata:{library:"sap.ui.layout",properties:{allowWrapping:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},designtime:"sap/ui/layout/designtime/HorizontalLayout.designtime",dnd:{draggable:false,droppable:true}}});
a.prototype.getAccessibilityInfo=function(){return{children:this.getContent()};};
return a;});
sap.ui.predefine('sap/ui/layout/HorizontalLayoutRenderer',[],function(){"use strict";var H={};
H.render=function(r,c){var a=r;var n=!c.getAllowWrapping();a.write("<div");a.writeControlData(c);a.addClass("sapUiHLayout");if(n){a.addClass("sapUiHLayoutNoWrap");}a.writeClasses();a.write(">");var C=c.getContent();for(var i=0;i<C.length;i++){if(n){a.write("<div class='sapUiHLayoutChildWrapper'>");}a.renderControl(C[i]);if(n){a.write("</div>");}}a.write("</div>");};
return H;},true);
sap.ui.predefine('sap/ui/layout/PaneContainer',['./library','sap/ui/core/Element','./AssociativeSplitter','sap/ui/core/library'],function(l,E,A,c){"use strict";var O=c.Orientation;
var P=E.extend("sap.ui.layout.PaneContainer",{metadata:{library:"sap.ui.layout",properties:{orientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:O.Horizontal}},defaultAggregation:"panes",aggregations:{panes:{type:"sap.ui.core.Element",multiple:true,singularName:"pane"}}}});
P.prototype.init=function(){this._oSplitter=new A({orientation:this.getOrientation(),height:"100%"});this._oSplitter._bUseIconForSeparator=false;};
P.prototype.setOrientation=function(o){this._oSplitter.setOrientation(o);return this.setProperty("orientation",o,true);};
P.prototype._getPanesInInterval=function(f){return this.getPanes().filter(function(p){return p instanceof sap.ui.layout.SplitPane&&p._isInInterval(f);});};
P.prototype.setLayoutData=function(L){this._oSplitter.setLayoutData(L);return this;};
P.prototype.insertPane=function(o,i){var r=this.insertAggregation("panes",o,i),e={onAfterRendering:function(){this.triggerResize();this.removeEventDelegate(e);}};if(o instanceof P&&o._oSplitter){o._oSplitter.addEventDelegate(e,o._oSplitter);}return r;};
P.prototype.removePane=function(o){var r=this.removeAggregation("panes",o),e={onAfterRendering:function(){this.triggerResize();this.removeEventDelegate(e);}};this.getPanes().forEach(function(p){if(p instanceof P&&p._oSplitter){p._oSplitter.addEventDelegate(e,p._oSplitter);}});return r;};
return P;});
sap.ui.predefine('sap/ui/layout/ResponsiveFlowLayout',['sap/ui/core/Control','./ResponsiveFlowLayoutData','./library','sap/ui/core/ResizeHandler','sap/ui/Device','./ResponsiveFlowLayoutRenderer',"sap/ui/thirdparty/jquery",'sap/ui/dom/jquery/rect'],function(C,R,l,a,D,b,q){"use strict";
var c=C.extend("sap.ui.layout.ResponsiveFlowLayout",{metadata:{library:"sap.ui.layout",properties:{responsive:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
(function(){
c.prototype.init=function(){this._rows=[];this._bIsRegistered=false;this._proxyComputeWidths=q.proxy(f,this);this._iRowCounter=0;};
c.prototype.exit=function(){delete this._rows;if(this._IntervalCall){clearTimeout(this._IntervalCall);this._IntervalCall=undefined;}if(this._resizeHandlerComputeWidthsID){a.deregister(this._resizeHandlerComputeWidthsID);}delete this._resizeHandlerComputeWidthsID;delete this._proxyComputeWidths;if(this.oRm){this.oRm.destroy();delete this.oRm;}delete this._$DomRef;delete this._oDomRef;delete this._iRowCounter;};
var u=function(t){var h=t.getContent();var r=[];var j=-1;var I={},L={};var s="";var o;var m=0,w=0,k=0;var B=false,M=false,n=false;for(var i=0;i<h.length;i++){m=R.MIN_WIDTH;w=R.WEIGHT;B=R.LINEBREAK;M=R.MARGIN;n=R.LINEBREAKABLE;o=_(h[i]);if(o instanceof R){B=o.getLinebreak();m=o.getMinWidth();w=o.getWeight();M=o.getMargin();n=o.getLinebreakable();}if(j<0||B){j++;r.push({height:-1,cont:[]});}k=r[j].cont.length;s=h[i].getId()+"-cont"+j+"_"+k;I={minWidth:m,weight:w,linebreakable:n,padding:M,control:h[i],id:s,breakWith:[]};var p=false;if(!n){for(var v=k;v>0;v--){L=r[j].cont[v-1];if(L.linebreakable){L.breakWith.push(I);p=true;break;}}}if(!p){r[j].cont.push(I);}}t._rows=r;};var g=function(o,$,t){var r=[];var h=10000000;var k=-1;var m=function(j){var n=q(document.getElementById(o.cont[j].id));if(n.length>0){var p=n[0].offsetLeft;if(h>=p){r.push({cont:[]});k++;}h=p;r[k].cont.push(o.cont[j]);}};if(sap.ui.getCore().getConfiguration().getRTL()){for(var i=o.cont.length-1;i>=0;i--){m(i);}}else{for(var i=0;i<o.cont.length;i++){m(i);}}return r;};var d=function(o,w){var r=[];var h=-1;var i=0;var t=0;var m=0;var n=0,p=0;var j=0,k=0;for(j=0;j<o.cont.length;j++){i=0;t=0;for(k=m;k<=j;k++){t=t+o.cont[k].weight;}for(k=m;k<=j;k++){n=w/t*o.cont[k].weight;n=Math.floor(n);p=o.cont[k].minWidth;i+=Math.max(n,p);}if(h==-1||i>w){r.push({cont:[]});if(h!==-1){m=j;}h++;}r[h].cont.push(o.cont[j]);}return r;};var e=function(w,h){if(w.length!=h.length){return true;}for(var i=0;i<w.length;i++){if(w[i].cont.length!=h[i].cont.length){return true;}}return false;};
c.prototype.renderContent=function(t,w){var r=t,h=0,W=[],i=0,k=0,j=0,m=0,n=0,p=0,o,s=0,v=0,B=[],x=[],I=this.getId(),H="",y=this._getRenderManager();for(i=0;i<r.length;i++){p=0;W.length=0;h=100;x.length=0;x.push("sapUiRFLRow");if(r[i].cont.length<=1){x.push("sapUiRFLCompleteRow");}var z=I+"-row"+this._iRowCounter;var S={};y.writeHeader(z,S,x);n=0;for(k=0;k<r[i].cont.length;k++){n+=r[i].cont[k].weight;}for(j=0;j<r[i].cont.length;j++){o=r[i].cont[j];s=0;v=0;if(o.breakWith.length>0){s=o.weight;v=o.minWidth;for(var A=0;A<o.breakWith.length;A++){s+=o.breakWith[A].weight;v+=o.breakWith[A].minWidth;}}H=r[i].cont[j].id;x.length=0;S={"min-width":o.breakWith.length>0?v:o.minWidth};p=100/n*o.weight;var P=S["min-width"]/w*100;var E=Math.ceil(P);var F=Math.floor(p);if(F!==100&&E>F){p=E;}else{p=F;}p=h<p?h:p;h-=p;W.push(p);if(h>0&&j===(r[i].cont.length-1)){p+=h;}x.push("sapUiRFLContainer");S["width"]=p+"%";S["min-width"]=S["min-width"]+"px";y.writeHeader(H,S,x);x.length=0;x.push("sapUiRFLContainerContent");if(o.breakWith.length>0){x.push("sapUiRFLMultiContainerContent");}if(o.padding){x.push("sapUiRFLPaddingClass");}var G=this._addContentClass(o.control,j);if(G){x.push(G);}S={};y.writeHeader("",S,x);if(o.breakWith.length>0){H=r[i].cont[j].id+"-multi0";x.length=0;S={"min-width":v+"px"};var J=100/s*o.weight;J=Math.floor(J);B.push(J);x.push("sapUiRFLMultiContent");S["width"]=J+"%";if(r[i].cont[j].padding){x.push("sapUiRFLPaddingClass");}y.writeHeader(H,S,x);var K=J;y.renderControl(o.control);y.write("</div>");for(m=0;m<o.breakWith.length;m++){H=o.breakWith[m].id+'-multi'+(m+1);x.length=0;S={"min-width":o.breakWith[m].minWidth+"px"};J=100/s*o.breakWith[m].weight;J=Math.floor(J);B.push(J);K+=J;if(K<100&&m===(o.breakWith.length-1)){J+=100-K;}x.push("sapUiRFLMultiContent");S["width"]=J+"%";if(o.breakWith[m].padding){x.push("sapUiRFLPaddingClass");}y.writeHeader(H,S,x);y.renderControl(o.breakWith[m].control);y.write("</div>");}}else{y.renderControl(o.control);}y.write("</div>");y.write("</div>");}y.write("</div>");this._iRowCounter++;}};
var f=function(I){this._iRowCounter=0;this._oDomRef=this.getDomRef();if(this._oDomRef){var s=this.getId();var h=q(this._oDomRef).width();var r=false;if(this._rows){for(var i=0;i<this._rows.length;i++){var $=this._$DomRef.find("#"+s+"-row"+i);var t=d(this._rows[i],h);var o=g(this._rows[i],$,this);r=e(o,t);var j=this._getElementRect($);var p=this._rows[i].oRect;if(j&&p){r=r||(j.width!==p.width)&&(j.height!==p.height);}r=r||(typeof(I)==="boolean"&&I);if(this._bLayoutDataChanged||r){if(D.browser.internet_explorer){q(this._oDomRef).empty();}else{this._oDomRef.innerHTML="";}this._bLayoutDataChanged=false;this.renderContent(t,h);}}if(this._oDomRef.innerHTML===""){this._getRenderManager().flush(this._oDomRef);for(var i=0;i<this._rows.length;i++){var T=this._getElementRect(q(document.getElementById(s+"-row"+i)));this._rows[i].oRect=T;}}if(this._rows.length===0){if(this._resizeHandlerComputeWidthsID){a.deregister(this._resizeHandlerComputeWidthsID);delete this._resizeHandlerComputeWidthsID;}}}}};
c.prototype.onBeforeRendering=function(){u(this);if(this._resizeHandlerFullLengthID){a.deregister(this._resizeHandlerFullLengthID);delete this._resizeHandlerFullLengthID;}};
c.prototype.onAfterRendering=function(E){this._oDomRef=this.getDomRef();this._$DomRef=q(this._oDomRef);this._proxyComputeWidths(true);if(this.getResponsive()){if(!this._resizeHandlerComputeWidthsID){this._resizeHandlerComputeWidthsID=a.register(this,this._proxyComputeWidths);}}else{if(this._resizeHandlerComputeWidthsID){a.deregister(this._resizeHandlerComputeWidthsID);delete this._resizeHandlerComputeWidthsID;}}};
c.prototype.onThemeChanged=function(E){if(E.type==="LayoutDataChange"){this._bLayoutDataChanged=true;}if(!this._resizeHandlerComputeWidthsID){this._resizeHandlerComputeWidthsID=a.register(this,this._proxyComputeWidths);}u(this);this._proxyComputeWidths();};
c.prototype.onLayoutDataChange=c.prototype.onThemeChanged;var _=function(o){var L=o.getLayoutData();if(!L){return undefined;}else if(L instanceof R){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var h=L.getMultipleLayoutData();for(var i=0;i<h.length;i++){var j=h[i];if(j instanceof R){return j;}}}};
c.prototype.addContent=function(o){if(o&&this._IntervalCall){clearTimeout(this._IntervalCall);this._IntervalCall=undefined;}this.addAggregation("content",o);return this;};
c.prototype.insertContent=function(o,i){if(o&&this._IntervalCall){clearTimeout(this._IntervalCall);this._IntervalCall=undefined;}this.insertAggregation("content",o,i);return this;};
c.prototype.removeContent=function(o){if(o&&this._IntervalCall){clearTimeout(this._IntervalCall);this._IntervalCall=undefined;}this.removeAggregation("content",o);};
c.prototype._getAccessibleRole=function(){return null;};
c.prototype._addContentClass=function(o,i){return null;};
c.prototype._getElementRect=function(E){var r=E&&E.rect();if(r){r.height=r.height.toFixed(1);r.width=r.width.toFixed(1);}return r;};
c.prototype._getRenderManager=function(){if(!this.oRm){this.oRm=sap.ui.getCore().createRenderManager();this.oRm.writeStylesAndClasses=function(){this.writeStyles();this.writeClasses();};this.oRm.writeHeader=function(I,s,h){this.write('<div id="'+I+'"');if(s){for(var k in s){if(k==="width"&&s[k]==="100%"){this.addClass("sapUiRFLFullLength");}this.addStyle(k,s[k]);}}for(var i=0;i<h.length;i++){this.addClass(h[i]);}this.writeStylesAndClasses();this.write(">");};}return this.oRm;};
}());return c;});
sap.ui.predefine('sap/ui/layout/ResponsiveFlowLayoutData',['sap/ui/core/LayoutData','./library',"sap/base/Log"],function(L,l,a){"use strict";
var R=L.extend("sap.ui.layout.ResponsiveFlowLayoutData",{metadata:{library:"sap.ui.layout",properties:{minWidth:{type:"int",group:"Misc",defaultValue:100},weight:{type:"int",group:"Misc",defaultValue:1},linebreak:{type:"boolean",group:"Misc",defaultValue:false},margin:{type:"boolean",group:"Misc",defaultValue:true},linebreakable:{type:"boolean",group:"Misc",defaultValue:true}}}});
R.MIN_WIDTH=100;R.WEIGHT=1;R.LINEBREAK=false;R.MARGIN=true;R.LINEBREAKABLE=true;
R.prototype.setWeight=function(w){if(w>=1){this.setProperty("weight",w);}else{a.warning("Values smaller than 1 are invalid. Default value '1' is used instead",this);this.setProperty("weight",R.WEIGHT);}return this;};
R.prototype.setLinebreak=function(b){if(this.getLinebreakable()==false&&b){a.warning("Setting 'linebreak' AND 'linebreakable' doesn't make any sense. Please set either 'linebreak' or 'linebreakable'",this);}else{this.setProperty("linebreak",b);}return this;};
R.prototype.setLinebreakable=function(b){if(this.getLinebreak()===true&&b===false){a.warning("Setting 'linebreak' AND 'linebreakable' doesn't make any sense. Please set either 'linebreak' or 'linebreakable'",this);}else{this.setProperty("linebreakable",b);}return this;};
return R;});
sap.ui.predefine('sap/ui/layout/ResponsiveFlowLayoutRenderer',[],function(){"use strict";var R={};(function(){
R.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiRFL");r.writeClasses();var s=c._getAccessibleRole();var a;if(s){a={role:s};}r.writeAccessibilityState(c,a);r.write(">");r.write("</div>");};
}());return R;},true);
sap.ui.predefine('sap/ui/layout/ResponsiveSplitter',["./library","sap/ui/core/Control","./ResponsiveSplitterUtilities","./ResponsiveSplitterPage","./PaneContainer","./SplitPane","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler","./ResponsiveSplitterRenderer","sap/ui/thirdparty/jquery"],function(l,C,R,c,P,S,I,d,e,q){"use strict";
var f=C.extend("sap.ui.layout.ResponsiveSplitter",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'}},defaultAggregation:"rootPaneContainer",aggregations:{rootPaneContainer:{type:"sap.ui.layout.PaneContainer",multiple:false},_pages:{type:"sap.ui.layout.ResponsiveSplitterPage",multiple:true,visibility:"hidden"}},associations:{defaultPane:{type:"sap.ui.layout.SplitPane",multiple:false}},events:{}}});
var g={MAX_VISIBLE_BUTTONS:7};
f.prototype.init=function(){this._aPaneContainers=[];this._aPanes=[];this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");this.addEventDelegate({onAfterRendering:function(){this._initItemNavigation();}},this);};
f.prototype.onBeforeRendering=function(){var r=this.getRootPaneContainer();if(r){r._oSplitter.addEventDelegate({onAfterRendering:function(){this._setSplitterBarsTooltips(r._oSplitter);this._updatePaginatorButtonsTooltips();}},this);this._createWidthIntervals();this._createPages();this._detachResizeHandler();}};
f.prototype.onAfterRendering=function(){this._parentResizeHandler=d.register(this,this._onParentResize.bind(this));var r=this.getRootPaneContainer();if(r){this._onParentResize();}};
f.prototype.exit=function(){this._detachResizeHandler();};
f.prototype._setSplitterBarsTooltips=function(o,p){var s=o.$().find(" > .sapUiLoSplitterBar"),a=o.$().find(" > .sapUiLoSplitterContent"),t="",b,n,A,h;for(var i=0;i<a.length;i++){h=a[i].childNodes[0].id;A=sap.ui.getCore().byId(h);b=i+1;n=i+2;if(p){t+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_RESIZE",[p+"."+b,p+"."+n]);}else{t+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_RESIZE",[b,n]);}if(s[i]){s[i].setAttribute("title",t);t="";}if(A instanceof sap.ui.layout.Splitter){this._setSplitterBarsTooltips(A,b);}}};
f.prototype._updatePaginatorButtonsTooltips=function(){var v=Array.prototype.slice.call(this._getVisibleButtons()),h=this.getRootPaneContainer()._oSplitter.getAssociatedContentAreas().length,H=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_HOME")+" ",a=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_AND"),t="",b=this,o;if(v.length>0){o=v.shift();for(var i=1;i<=h;i++){H+=i;if(i<(h-1)){H+=", ";}else if(i===h-1){H+=" "+a+" ";}}o.setAttribute("title",H);[].forEach.call(v,function(B){t=b._oResourceBundle.getText("RESPONSIVE_SPLITTER_GOTO")+" "+(h+1);h+=1;B.setAttribute("title",t);});}};
f.prototype._handlePaginatorButtonTap=function(E){var o=this._oItemNavigation.getFocusedIndex();if(q(E.target).hasClass("sapUiResponsiveSplitterPaginatorButton")){q(E.target).attr("tabindex",0);var p=parseInt(q(E.target).attr("page-index"));this.getAggregation("_pages").forEach(function(a){a.setVisible(false);});if(p!==0){var D=this._currentInterval.aPages.filter(function(a){return a.demandPane;});p=this._currentInterval.aPages.indexOf(D[p-1]);}this._activatePage(p,parseInt(q(E.target).attr("page-index")));}if(q(E.target).hasClass("sapUiResponsiveSplitterPaginatorNavButton")){if(q(E.target).hasClass("sapUiResponsiveSplitterPaginatorButtonForward")){this._handlePaginatorForward(E);}else{this._handlePaginatorBack(E);}this._setItemNavigation();this._oItemNavigation.focusItem(o);}this._setItemNavigation();};
f.prototype.ontap=f.prototype._handlePaginatorButtonTap;f.prototype.onsapenter=f.prototype._handlePaginatorButtonTap;f.prototype.onsapspace=f.prototype._handlePaginatorButtonTap;
f.prototype.onsapright=function(E){this._handleArrowNavigation(6,"Forward",E);};
f.prototype.onsapleft=function(E){this._handleArrowNavigation(0,"Back",E);};
f.prototype._initItemNavigation=function(){if(this._oItemNavigation){this._bPrevItemNavigation=true;this._clearItemNavigation();}this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigation();if(this._bPrevItemNavigation){this._oItemNavigation.focusItem(0);}};
f.prototype._setItemNavigation=function(){var b=this._getVisibleButtons(),D=[];this._oItemNavigation.setRootDomRef(this.$().find(".sapUiResponsiveSplitterPaginator")[0]);for(var i=0;i<b.length;i++){if(b[i]){D.push(b[i]);}}this._oItemNavigation.setItemDomRefs(D);};
f.prototype._clearItemNavigation=function(){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;};
f.prototype._handleArrowNavigation=function(b,D,E){if(E.target===this._getVisibleButtons()[b]){this["_handlePaginator"+D](E);this._setItemNavigation();}else{return;}};
f.prototype._onParentResize=function(){var i=this._intervalHasChanged(),r=this.getRootPaneContainer();if(i&&r){this._arrangeContent();this._setPaginatorVisibility();}};
f.prototype._detachResizeHandler=function(){if(this._parentResizeHandler){d.deregister(this._parentResizeHandler);this._parentResizeHandler=null;}};
f.prototype._createWidthIntervals=function(){var B=[];this._aIntervals=[];R.visitPanes(this.getRootPaneContainer(),function(p){var r=p.getRequiredParentWidth();if(B.indexOf(r)==-1){B.push(r);}});B.push(Number.NEGATIVE_INFINITY);B.push(Number.POSITIVE_INFINITY);B.sort(function(a,b){return a-b;});for(var i=0;i<B.length-1;i++){var o=new R.splitterInterval(B[i],B[i+1],this.getRootPaneContainer());this._aIntervals.push(o);}};
f.prototype._createPages=function(){var m=this._getMaxPageCount();this.destroyAggregation("_pages",true);for(var i=0;i<m;i++){var p=new c();this.addAggregation("_pages",p,true);}};
f.prototype._intervalHasChanged=function(){var w=this.getDomRef().clientWidth,o=null,a=this._aIntervals;for(var i=0;i<a.length;i++){if(a[i].iFrom<w&&w<=a[i].iTo){o=a[i];break;}}if(this._currentInterval!==o){this._currentInterval=o;return true;}return false;};
f.prototype._setPaginatorVisibility=function(){var b=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),n=this.$().find(".sapUiResponsiveSplitterPaginatorNavButton"),p=this.$().find(".sapUiResponsiveSplitterPaginator"),i=(this._getHiddenPanes().length+1),s=i<g.MAX_VISIBLE_BUTTONS;b.addClass("sapUiResponsiveSplitterHiddenElement");if(i>1){this.getDomRef().classList.add("sapUiRSVisiblePaginator");b=b.slice(0,s?i:g.MAX_VISIBLE_BUTTONS);b.removeClass("sapUiResponsiveSplitterHiddenElement");b.removeClass("sapUiResponsiveSplitterHiddenPaginatorButton");n.toggleClass("sapUiResponsiveSplitterHiddenPaginatorButton",s);p.toggleClass("sapUiResponsiveSplitterWithNavButtons",!s);}else{this.getDomRef().classList.remove("sapUiRSVisiblePaginator");}};
f.prototype._getMaxPageCount=function(){var t=0;this._aIntervals.forEach(function(i){if(i.iPagesCount>t){t=i.iPagesCount;}});return t;};
f.prototype._arrangeContent=function(){var p=this.getAggregation("_pages")||[];this._clearContent();p.forEach(function(o){o.setVisible(false);});this._fillPageContent(this.getRootPaneContainer());this._activatePage(0);};
f.prototype._activatePage=function(p){var $=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),o=this.$().find(".sapUiResponsiveSplitterPaginatorSelectedButton"),O=$.index(o),a=this.getAggregation("_pages")||[];a[O]&&a[O].setVisible(false);a[p]&&a[p].setVisible(true);o.removeClass("sapUiResponsiveSplitterPaginatorSelectedButton");$.eq(p).addClass("sapUiResponsiveSplitterPaginatorSelectedButton");o.attr("aria-checked",false);$.eq(p).attr("aria-checked",true);};
f.prototype._fillPageContent=function(s){var b=s instanceof P,a=s instanceof S,o=s.getParent(),h=o instanceof P,p=this.getAggregation("_pages"),H,j,k,D,m,M;if(b&&p){this._aPaneContainers.push(s);j=this._getAllPanesInInterval(s,this._currentInterval.iFrom).length>0;k=s._oSplitter;if(h&&j){o._oSplitter.addAssociatedContentArea(k);}else if(!h){p[0].setContent(k);}s.getPanes().forEach(function(n){this._fillPageContent(n);},this);}else if(a&&p){this._assignDefault(s);this._aPanes.push(s);D=s.getDemandPane();H=this._getHiddenPanes();m=H.length;M=this._getMaxPageCount();var i;if(s._isInInterval(this._currentInterval.iFrom)){o._oSplitter.addAssociatedContentArea(s.getContent());}else if(D&&(m<M)){for(i=0;i<m;i++){p[i+1].setContent(H[i].getContent());}}else if(D&&m===M){for(i=0;i<m;i++){p[i].setContent(H[i].getContent());}}else if(this._isDefault(s)){p[0].setContent(s.getContent());}}};
f.prototype._isDefault=function(p){return this.getDefaultPane()===p.getId();};
f.prototype._assignDefault=function(p){var D=this.getDefaultPane();this.setDefaultPane(D||p);};
f.prototype._getAllPanesInInterval=function(p,F){var a=[];function v(p){p.getPanes().forEach(function(o){if(o instanceof P){v(o);}else if(o._isInInterval(F)){a.push(o);}});return a;}return v(p,F);};
f.prototype._getHiddenPanes=function(){return this._aPanes.filter(function(p){return p.getDemandPane()&&!p._isInInterval(this._currentInterval.iFrom);},this);};
f.prototype._clearContent=function(){this._aPaneContainers.forEach(function(p){p._oSplitter.removeAllAssociatedContentArea();});this._aPaneContainers=[];this._aPanes=[];};
f.prototype._getVisibleButtons=function(){return this.$().find(".sapUiResponsiveSplitterPaginatorButton:not(.sapUiResponsiveSplitterHiddenElement, .sapUiResponsiveSplitterHiddenPaginatorButton)");};
f.prototype._handlePaginatorButtonTap=function(E){var t=E.target,T=E.target.classList,p;if(T.contains("sapUiResponsiveSplitterPaginatorButton")){p=t.getAttribute("page-index");this._activatePage(p);}else if(T.contains("sapUiResponsiveSplitterPaginatorNavButton")){if(T.contains("sapUiResponsiveSplitterPaginatorButtonForward")){this._handlePaginatorForward(E);}else{this._handlePaginatorBack(E);}}};
f.prototype._handlePaginatorForward=function(E){var v=this._getVisibleButtons(),h=this._getHiddenPanes().length,H=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),$=H.filter(function(){return this.getAttribute("page-index")>=g.MAX_VISIBLE_BUTTONS&&this.getAttribute("page-index")<=h;});if($.length>0){v.first().addClass("sapUiResponsiveSplitterHiddenElement");$.last().removeClass("sapUiResponsiveSplitterHiddenElement");}};
f.prototype._handlePaginatorBack=function(E){var v=this._getVisibleButtons(),m=this._getMaxPageCount()-g.MAX_VISIBLE_BUTTONS,h=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),H=h.filter(function(){return this.getAttribute("page-index")<m;});if(H.length>0){v.last().addClass("sapUiResponsiveSplitterHiddenElement");H.last().removeClass("sapUiResponsiveSplitterHiddenElement");}};
f.prototype.ontap=f.prototype._handlePaginatorButtonTap;f.prototype.onsapenter=f.prototype._handlePaginatorButtonTap;f.prototype.onsapspace=f.prototype._handlePaginatorButtonTap;return f;});
sap.ui.predefine('sap/ui/layout/ResponsiveSplitterPage',["./library","sap/ui/core/Control"],function(l,C){"use strict";
var R=C.extend("sap.ui.layout.ResponsiveSplitterPage",{
metadata:{library:"sap.ui.layout",associations:{content:{type:"sap.ui.core.Control",multiple:false,singularName:"content"}}},
getContent:function(){return sap.ui.getCore().byId(this.getAssociation("content"));},
renderer:function(r,c){r.write("<div");r.addClass("sapUiResponsiveSplitterPage");r.writeControlData(c);r.writeClasses();r.write(">");var a=c.getContent();if(a){r.renderControl(a);}r.write("</div>");}
});
return R;});
sap.ui.predefine('sap/ui/layout/ResponsiveSplitterRenderer',['sap/ui/core/IconPool'],function(I){"use strict";var R={};I.insertFontFaceStyle();
R.render=function(r,c){r.write("<div ");r.addClass("sapUiResponsiveSplitter");r.writeControlData(c);r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());r.writeStyles();r.writeClasses();r.write(">");var p=c.getAggregation("_pages");if(p){c.getAggregation("_pages").forEach(r.renderControl,r);this.renderPaginator(r,c);}r.write("</div>");};
R.renderPaginator=function(r,c){var b=c._getMaxPageCount(),p=c.getAggregation("_pages")||[],B=sap.ui.getCore().getLibraryResourceBundle('sap.ui.layout');r.write("<div ");r.writeAttribute("role","navigation");r.addClass("sapUiResponsiveSplitterPaginator");r.writeClasses();r.write(">");r.write("<div ");r.addClass("sapUiResponsiveSplitterPaginatorNavButton");r.addClass("sapUiResponsiveSplitterHiddenPaginatorButton");r.addClass("sapUiResponsiveSplitterPaginatorButtonBack");r.writeClasses();r.write("></div>");r.write("<div ");r.addClass("sapUiResponsiveSplitterPaginatorButtons");r.writeClasses();r.writeAttribute("role","radiogroup");r.writeAttributeEscaped("aria-label",B.getText("RESPONSIVE_SPLITTER_ARIA_PAGINATOR_LABEL"));if(p.length>0){r.writeAttribute("aria-controls",p[0].getParent().getId());}r.write(">");for(var i=0;i<b;i++){r.write("<div tabindex='0' ");r.write("page-index='"+i+"'");if(i===0){r.addClass("sapUiResponsiveSplitterPaginatorSelectedButton");}r.addClass("sapUiResponsiveSplitterHiddenElement");r.addClass("sapUiResponsiveSplitterPaginatorButton");r.writeClasses();r.writeAttribute("role","radio");r.writeAttribute("aria-checked",false);r.write("></div>");}r.write("</div>");r.write("<div ");r.addClass("sapUiResponsiveSplitterPaginatorNavButton");r.addClass("sapUiResponsiveSplitterHiddenPaginatorButton");r.addClass("sapUiResponsiveSplitterPaginatorButtonForward");r.writeClasses();r.write("></div>");r.write("</div>");};
return R;},true);
sap.ui.predefine('sap/ui/layout/ResponsiveSplitterUtilities',[],function(){"use strict";var R={};
R.visitPanes=function(p,c){var P,o;if(!p){return;}P=p.getPanes();for(var i=0;i<P.length;i++){o=P[i];if(o instanceof sap.ui.layout.SplitPane){c(o);}else{R.visitPanes(o,c);}}};
R.splitterInterval=function(f,t,p){this.iFrom=f;this.iTo=t;this.iPagesCount=0;var m=[],P=[m];R.visitPanes(p,function(a){var w=a.getRequiredParentWidth();var b={demandPane:a.getDemandPane()};if(w<=f){m.push(b);}else{P.push(b);}});if(m.length==0){P.splice(0,1);}this.iPagesCount=P.length;this.aPages=P;};
return R;},true);
sap.ui.predefine('sap/ui/layout/SplitPane',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var S=E.extend("sap.ui.layout.SplitPane",{metadata:{library:"sap.ui.layout",properties:{demandPane:{type:"boolean",group:"Behavior",defaultValue:true},requiredParentWidth:{type:"int",defaultValue:800}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false,singularName:"content"}}}});
S.prototype.setLayoutData=function(L){var c=this.getContent();if(c){return c.setLayoutData(L);}else{this._oLayoutData=L;return this;}};
S.prototype.setContent=function(c){if(this._oLayoutData){c.setLayoutData(this._oLayoutData);this._oLayoutData=null;}return this.setAggregation("content",c);};
S.prototype.onLayoutDataChange=function(){var p=this.getParent();if(p){p._oSplitter._delayedResize();}};
S.prototype._isInInterval=function(f){return this.getRequiredParentWidth()<=f;};
return S;});
sap.ui.predefine('sap/ui/layout/Splitter',['sap/ui/core/Control','./library','sap/ui/core/library','sap/ui/core/ResizeHandler','sap/ui/core/RenderManager','./SplitterRenderer',"sap/base/Log","sap/ui/thirdparty/jquery"],function(C,l,c,R,a,S,L,q){"use strict";var O=c.Orientation;var r=16;
var b=C.extend("sap.ui.layout.Splitter",{metadata:{library:"sap.ui.layout",properties:{orientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:O.Horizontal},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'}},defaultAggregation:"contentAreas",aggregations:{contentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"contentArea"}},events:{resize:{parameters:{id:{type:"string"},oldSizes:{type:"int[]"},newSizes:{type:"int[]"}}}},designtime:"sap/ui/layout/designtime/Splitter.designtime"}});
var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");
b.prototype.init=function(){this._needsInvalidation=false;this._liveResize=true;this._keyboardEnabled=true;this._bHorizontal=true;this._calculatedSizes=[];this._move={};this._resizeTimeout=null;this._resizeCallback=this._delayedResize.bind(this);this._resizeHandlerId=null;this._autoResize=true;this.enableAutoResize();this._boundBarMoveEnd=this._onBarMoveEnd.bind(this);this._boundBarMove=this._onBarMove.bind(this);this._switchOrientation();this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc",20),decrease:this._onKeyboardResize.bind(this,"dec",20),increaseMore:this._onKeyboardResize.bind(this,"incMore",20),decreaseMore:this._onKeyboardResize.bind(this,"decMore",20),max:this._onKeyboardResize.bind(this,"max",20),min:this._onKeyboardResize.bind(this,"min",20)};this._enableKeyboardListeners();this._bUseIconForSeparator=true;};
b.prototype.exit=function(){this.disableAutoResize();delete this._resizeCallback;delete this._boundBarMoveEnd;delete this._boundBarMove;delete this._$SplitterOverlay;delete this._$SplitterOverlayBar;};
b.prototype.triggerResize=function(f){if(f){this._resize();}else{this._delayedResize();}};
b.prototype.getCalculatedSizes=function(){return this._calculatedSizes;};
b.prototype.enableAutoResize=function(t){if(t&&!this._autoResize){return;}this._autoResize=true;var f=this;sap.ui.getCore().attachInit(function(){f._resizeHandlerId=R.register(f,f._resizeCallback);});this._delayedResize();};
b.prototype.disableAutoResize=function(t){R.deregister(this._resizeHandlerId);if(!t){this._autoResize=false;}};
b.prototype.enableLiveResize=function(){this._liveResize=true;this.$().toggleClass("sapUiLoSplitterAnimated",false);};
b.prototype.disableLiveResize=function(){this._liveResize=false;this.$().toggleClass("sapUiLoSplitterAnimated",true);};
b.prototype.enableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","0");this._enableKeyboardListeners();};
b.prototype.disableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","-1");this._disableKeyboardListeners();};
b.prototype.onBeforeRendering=function(){this._switchOrientation();};
b.prototype.onAfterRendering=function(){this._$SplitterOverlay=this.$("overlay");this._$SplitterOverlayBar=this.$("overlayBar");this._$SplitterOverlay.detach();this._resize();};
b.prototype.onLayoutDataChange=function(){this._delayedResize();};
b.prototype.ontouchstart=function(j){if(this._ignoreTouch){return;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}if(!j.changedTouches||!j.changedTouches[0]){return;}this._ignoreMouse=true;this._onBarMoveStart(j.changedTouches[0],true);};
b.prototype.onmousedown=function(j){if(this._ignoreMouse){return;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}this._ignoreTouch=true;this._onBarMoveStart(j);};
b.prototype._onBarMoveStart=function(j,t){var I=this.getId();this.disableAutoResize(true);var p=j[this._moveCord];var B=parseInt(j.target.id.substr((I+"-splitbar-").length));var $=q(j.target);var m=this.getCalculatedSizes();var f=this._bHorizontal?$.innerWidth():$.innerHeight();var g=this._getContentAreas();var h=g[B].getLayoutData();var k=g[B+1].getLayoutData();if(!h.getResizable()||!k.getResizable()){d(t);return;}var n=0-f;for(var i=0;i<=B;++i){n+=m[i]+f;}this._move={start:p,relStart:n,barNum:B,bar:q(j.target),c1Size:m[B],c1MinSize:h?parseInt(h.getMinSize()):0,c2Size:m[B+1],c2MinSize:k?parseInt(k.getMinSize()):0};if(t){document.addEventListener("touchend",this._boundBarMoveEnd);document.addEventListener("touchmove",this._boundBarMove);}else{document.addEventListener("mouseup",this._boundBarMoveEnd);document.addEventListener("mousemove",this._boundBarMove);}this._$SplitterOverlay.css("display","block");this._$SplitterOverlay.appendTo(this.getDomRef());this._$SplitterOverlayBar.css(this._sizeDirNot,"");this._move["bar"].css("visibility","hidden");this._onBarMove(j);};
b.prototype._onBarMove=function(j){if(j.preventDefault){j.preventDefault();}var E=j;if(j.changedTouches&&j.changedTouches[0]){E=j.changedTouches[0];}var p=E[this._moveCord];var D=(p-this._move.start);if(this.getOrientation()==O.Horizontal&&this._bRtl){D=-D;}var f=this._move.c1Size+D;var g=this._move.c2Size-D;var i=(f>=0&&g>=0&&f>=this._move.c1MinSize&&g>=this._move.c2MinSize);if(i){this._$SplitterOverlayBar.css(this._sizeDir,this._move.relStart+D);if(this._liveResize){var m=(this._move["start"]-E[this._moveCord]);if(this.getOrientation()==O.Horizontal&&this._bRtl){m=-m;}this._resizeContents(this._move["barNum"],-m,false);}}};
b.prototype._onBarMoveEnd=function(j){this._ignoreMouse=false;this._ignoreTouch=false;var E=j;if(j.changedTouches&&j.changedTouches[0]){E=j.changedTouches[0];}var p=E[this._moveCord];var m=this._move["start"]-p;if(this.getOrientation()==O.Horizontal&&this._bRtl){m=-m;}this._resizeContents(this._move["barNum"],-m,true);this._move["bar"].css("visibility","");this._$SplitterOverlay.css("display","");document.removeEventListener("mouseup",this._boundBarMoveEnd);document.removeEventListener("mousemove",this._boundBarMove);document.removeEventListener("touchend",this._boundBarMoveEnd);document.removeEventListener("touchmove",this._boundBarMove);this.enableAutoResize(true);if(this._move.bar){this._move.bar.focus();}};
b.prototype._resizeContents=function(i,p,f){if(isNaN(p)){L.warning("Splitter: Received invalid resizing values - resize aborted.");return;}var g=this._getContentAreas();var h=g[i].getLayoutData();var j=g[i+1].getLayoutData();var s=h.getSize();var k=j.getSize();var $=this.$("content-"+i);var m=this.$("content-"+(i+1));var n=this._move.c1Size+p;var N=this._move.c2Size-p;var M=parseInt(h.getMinSize());var t=parseInt(j.getMinSize());var D;if(n<M){D=M-n;p+=D;n=M;N-=D;}else if(N<t){D=t-N;p-=D;N=t;n-=D;}if(f){if(s==="auto"&&k!=="auto"){j.setSize(N+"px");}else if(s!=="auto"&&k==="auto"){h.setSize(n+"px");}else{h.setSize(n+"px");j.setSize(N+"px");}}else{$.css(this._sizeType,n+"px");m.css(this._sizeType,N+"px");}};
b.prototype._delayedResize=function(D){if(D===undefined){D=0;}if(this.getDomRef()){clearTimeout(this._resizeTimeout);setTimeout(this["_resize"].bind(this),D);}};
b.prototype._resizeBars=function(f){var i,B;var $=this.$();for(i=0;i<f.length-1;++i){B=this.$("splitbar-"+i);B.css(this._sizeTypeNot,"");}for(i=0;i<f.length-1;++i){B=this.$("splitbar-"+i);var s=this._bHorizontal?$.height():$.width();B.css(this._sizeType,"");B.css(this._sizeTypeNot,s+"px");}};
b.prototype._resize=function(){var D=this.getDomRef();if(!D||a.getPreserveAreaRef().contains(D)){return;}var i=0,B;var f=this._getContentAreas();this._resizeBars(f);var g=this.getCalculatedSizes();this._recalculateSizes();var n=this.getCalculatedSizes();var s=false;for(i=0;i<n.length;++i){if(n[i]!==0){s=true;break;}}if(!s){this._delayedResize(100);return;}var h=true;for(i=0;i<f.length;++i){var $=this.$("content-"+i);var j=f[i];$.css(this._sizeType,n[i]+"px");$.css(this._sizeTypeNot,"");var k=j.getLayoutData();var m=k&&k.getResizable();if(i>0){var p=m&&h;B=this.$("splitbar-"+(i-1));B.toggleClass("sapUiLoSplitterNoResize",!p);B.attr("tabindex",p&&this._keyboardEnabled?"0":"-1");}h=m;}this._resizeBars(f);if(_(g,n)){this.fireResize({oldSizes:g,newSizes:n});}};
b.prototype._calculateAvailableContentSize=function(s){var i=0;var $=this.$();var f=this._bHorizontal?$.innerWidth():$.innerHeight();var A=0;var h=false;for(i=0;i<s.length;++i){var g=s[i];if(g.indexOf("%")>-1){A++;}if(s[i]=="auto"){h=true;}}A+=h?1:0;if(this.getOrientation()===O.Horizontal){f-=A;}var j=s.length-1;var k=0;for(i=0;i<j;++i){k+=this._bHorizontal?this.$("splitbar-"+i).innerWidth():this.$("splitbar-"+i).innerHeight();}return Math.max(0,f-k);};
b.prototype._recalculateSizes=function(){var i,s,f,g,h;var j=[];var k=this._getContentAreas();for(i=0;i<k.length;++i){f=k[i].getLayoutData();s=f?f.getSize():"auto";j.push(s);}this._calculatedSizes=[];var A=this._calculateAvailableContentSize(j);var m=[];var n=[];var p=[];var t=A;for(i=0;i<j.length;++i){s=j[i];var u;if(s.indexOf("rem")>-1){u=parseFloat(s)*r;t-=u;this._calculatedSizes[i]=u;}else if(s.indexOf("px")>-1){u=parseInt(s);t-=u;this._calculatedSizes[i]=u;}else if(s.indexOf("%")>-1){p.push(i);}else if(j[i]=="auto"){f=k[i].getLayoutData();if(f&&parseInt(f.getMinSize())!=0){n.push(i);}else{m.push(i);}}else{L.error("Illegal size value: "+j[i]);}}var w=false;if(t<0){w=true;t=0;}var P=p.length;for(i=0;i<P;++i){h=p[i];g=Math.floor((parseFloat(j[h])/100)*A);this._calculatedSizes[h]=g;t-=g;}A=t;if(A<0){w=true;A=0;}g=Math.floor(A/(n.length+m.length),0);var v=n.length;for(i=0;i<v;++i){h=n[i];var M=parseInt(k[h].getLayoutData().getMinSize());if(M>g){this._calculatedSizes[h]=M;A-=M;}else{this._calculatedSizes[h]=g;A-=g;}}if(A<0){w=true;A=0;}t=A;var x=m.length;g=Math.floor(A/x,0);for(i=0;i<x;++i){h=m[i];this._calculatedSizes[h]=g;t-=g;}if(w){L.info("[Splitter] The set sizes and minimal sizes of the splitter contents are bigger "+"than the available space in the UI.");}};
b.prototype._switchOrientation=function(){this._bHorizontal=this.getOrientation()===O.Horizontal;if(this._bHorizontal){this._sizeDirNot="top";this._sizeTypeNot="height";this._sizeType="width";this._moveCord="pageX";if(this._bRtl){this._sizeDir="right";}else{this._sizeDir="left";}}else{this._moveCord="pageY";this._sizeType="height";this._sizeTypeNot="width";this._sizeDir="top";this._sizeDirNot="left";}var t=this.$();t.toggleClass("sapUiLoSplitterH",this._bHorizontal);t.toggleClass("sapUiLoSplitterV",!this._bHorizontal);};
b.prototype._onKeyboardResize=function(t,s,E){var B=this.getId()+"-splitbar-";if(!E||!E.target||!E.target.id||E.target.id.indexOf(B)!==0){return;}var i=999999;var f=parseInt(E.target.id.substr(B.length));var m=this.getCalculatedSizes();this._move.c1Size=m[f];this._move.c2Size=m[f+1];var g=0;switch(t){case"inc":g=s;break;case"incMore":g=s*10;break;case"dec":g=0-s;break;case"decMore":g=0-s*10;break;case"max":g=i;break;case"min":g=0-i;break;default:L.warn("[Splitter] Invalid keyboard resize type");break;}this._resizeContents(f,g,true);};
b.prototype._enableKeyboardListeners=function(){this.onsapright=this._keyListeners.increase;this.onsapdown=this._keyListeners.increase;this.onsapleft=this._keyListeners.decrease;this.onsapup=this._keyListeners.decrease;this.onsappageup=this._keyListeners.decreaseMore;this.onsappagedown=this._keyListeners.increaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true;};
b.prototype._disableKeyboardListeners=function(){delete this.onsapincreasemodifiers;delete this.onsapdecreasemodifiers;delete this.onsapendmodifiers;delete this.onsaphomemodifiers;this._keyboardEnabled=false;};
b.prototype._getText=function(k,A){return(o?o.getText(k,A):k);};
function _(s,f){if(s===f){return false;}if(!s||!f||s.length===undefined||f.length===undefined){return true;}if(s.length!=f.length){return true;}for(var i=0;i<s.length;++i){if(s[i]!==f[i]){return true;}}return false;}
function d(t){var p=function(E){E.preventDefault();};var A=null;A=function(){document.removeEventListener("touchend",A);document.removeEventListener("touchmove",p);document.removeEventListener("mouseup",A);document.removeEventListener("mousemove",p);};if(t){this._ignoreMouse=true;document.addEventListener("touchend",A);document.addEventListener("touchmove",p);}else{document.addEventListener("mouseup",A);document.addEventListener("mousemove",p);}}
function e(f){var g=f.getLayoutData();if(g&&(!g.getResizable||!g.getSize||!g.getMinSize)){L.warning("Content \""+f.getId()+"\" for the Splitter contained wrong LayoutData. "+"The LayoutData has been replaced with default values.");g=null;}if(!g){f.setLayoutData(new sap.ui.layout.SplitterLayoutData());}}
b.prototype.invalidate=function(f){var F=(f&&this.indexOfContentArea(f)!=-1)||(f&&f instanceof sap.ui.core.CustomData&&f.getWriteToDom())||(f===undefined);if(F||this._needsInvalidation){this._needsInvalidation=false;C.prototype.invalidate.apply(this,arguments);}};
b.prototype.setOrientation=function(s){var v=this.setProperty("orientation",s,true);this._switchOrientation();this._delayedResize();this.$().find(".sapUiLoSplitterBar").attr("aria-orientation",this._bHorizontal?"vertical":"horizontal");return v;};
b.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",this.getProperty("width"));return this;};
b.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css("height",this.getProperty("height"));return this;};
b.prototype.addContentArea=function(f){this._needsInvalidation=true;e(f);return this.addAggregation("contentAreas",f);};
b.prototype.removeContentArea=function(f){this._needsInvalidation=true;return this.removeAggregation("contentAreas",f);};
b.prototype.removeAllContentArea=function(){this._needsInvalidation=true;return this.removeAllAggregation("contentAreas");};
b.prototype.destroyContentArea=function(){this._needsInvalidation=true;return this.destroyAggregation("contentAreas");};
b.prototype.insertContentArea=function(f,i){this._needsInvalidation=true;e(f);return this.insertAggregation("contentAreas",f,i);};
b.prototype._getContentAreas=function(){return this.getContentAreas();};
return b;});
sap.ui.predefine('sap/ui/layout/SplitterLayoutData',['sap/ui/core/LayoutData','./library'],function(L,l){"use strict";
var S=L.extend("sap.ui.layout.SplitterLayoutData",{metadata:{library:"sap.ui.layout",properties:{resizable:{type:"boolean",group:"Behavior",defaultValue:true},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},minSize:{type:"int",group:"Dimension",defaultValue:0}}}});
return S;});
sap.ui.predefine('sap/ui/layout/SplitterRenderer',["sap/ui/core/library"],function(c){"use strict";var O=c.Orientation;var S={};
S.render=function(r,C){var h=C.getOrientation()===O.Horizontal;var o=h?"sapUiLoSplitterH":"sapUiLoSplitterV";var a=sap.ui.getCore().getConfiguration().getAnimation();r.write("<div");r.writeControlData(C);r.addClass("sapUiLoSplitter");r.addClass(o);if(a&&!C._liveResize){r.addClass("sapUiLoSplitterAnimated");}r.writeClasses();r.addStyle("width",C.getWidth());r.addStyle("height",C.getHeight());r.writeStyles();r.write(">");this.renderInitialContent(r,C);r.write("</div>");};
S.renderInitialContent=function(r,C){var I=C.getId();var h=C.getOrientation()===O.Horizontal;var s=h?"width":"height";var g="sap-icon://"+(h?"horizontal":"vertical")+"-grip";var a=C._getContentAreas();var l=a.length;var b=C.getCalculatedSizes();for(var i=0;i<l;++i){var L=a[i].getLayoutData();var d="0";if(b[i]){d=b[i]+"px";}else if(L){d=L.getSize();}r.write("<section "+"id=\""+I+"-content-"+i+"\" "+"style=\""+s+": "+d+";\" "+"class=\"sapUiLoSplitterContent\">");r.renderControl(a[i]);r.write("</section>");if(i<l-1){r.write("<div id=\""+I+"-splitbar-"+i+"\" "+"role=\"separator\" "+"title=\""+C._getText("SPLITTER_MOVE")+"\" "+"class=\"sapUiLoSplitterBar\" "+"aria-orientation=\""+(h?"vertical":"horizontal")+"\" "+"tabindex=\"0\">");if(C._bUseIconForSeparator){r.writeIcon(g,"sapUiLoSplitterBarIcon",{"id":I+"-splitbar-"+i+"-icon","title":null,"aria-label":null});}else{r.write("<span class='sapUiLoSplitterBarIcon'></span>");}r.write("</div>");}}r.write("<div id=\""+I+"-overlay\" class=\"sapUiLoSplitterOverlay\" style=\"display: none;\">"+"<div id=\""+I+"-overlayBar\" class=\"sapUiLoSplitterOverlayBar\">");if(C._bUseIconForSeparator){r.writeIcon(g,"sapUiLoSplitterBarIcon",{"id":I+"-splitbar-Overlay-icon","title":null,"aria-label":null});}else{r.write("<span class=\"sapUiLoSplitterBarIcon\"></span>");}r.write("</div>"+"</div>");};
return S;},true);
sap.ui.predefine('sap/ui/layout/VerticalLayout',['sap/ui/core/Control','sap/ui/core/EnabledPropagator','./library',"./VerticalLayoutRenderer"],function(C,E,l,V){"use strict";
var a=C.extend("sap.ui.layout.VerticalLayout",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},dnd:{draggable:false,droppable:true},designtime:"sap/ui/layout/designtime/VerticalLayout.designtime"}});
a.prototype.setWidth=function(w){this.setProperty("width",w,true);if(this.getDomRef()){this.getDomRef().style.width=this.getWidth();}return this;};
a.prototype.getAccessibilityInfo=function(){return{children:this.getContent()};};
E.call(a.prototype);return a;});
sap.ui.predefine('sap/ui/layout/VerticalLayoutRenderer',[],function(){"use strict";var V={};
V.render=function(r,v){var a=r;a.write("<div");a.writeControlData(v);a.addClass("sapUiVlt");a.addClass("sapuiVlt");if(v.getWidth()&&v.getWidth()!=''){a.addStyle("width",v.getWidth());}a.writeStyles();a.writeClasses();a.write(">");var c=v.getContent();for(var i=0;i<c.length;i++){a.write("<div class=\"sapUiVltCell sapuiVltCell\">");a.renderControl(c[i]);a.write("</div>");}a.write("</div>");};
return V;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/AddFormContainer',["sap/ui/fl/Utils","sap/ui/fl/changeHandler/Base","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/thirdparty/jquery"],function(F,B,J,q){"use strict";var A={};
A.applyChange=function(c,f,p){var m=p.modifier,a=p.appComponent,v=p.view,C=c.getDefinition(),t,g;if(C.texts&&C.texts.groupLabel&&C.texts.groupLabel.value&&C.content&&C.content.group&&(C.content.group.selector||C.content.group.id)){var T=C.texts.groupLabel.value,i=C.content.group.index,n=C.content.group.selector||{id:C.content.group.id},N=q.extend({},n);N.id=N.id+"--title";c.setRevertData({newGroupSelector:n});if(m.bySelector(N,a)){return B.markAsNotApplicable("Control to be created already exists:"+N);}else if(m.bySelector(n,a)){return B.markAsNotApplicable("Control to be created already exists:"+n);}t=m.createControl("sap.ui.core.Title",a,v,N);g=m.createControl("sap.ui.layout.form.FormContainer",a,v,n);m.setProperty(t,"text",T);m.insertAggregation(g,"title",t,0,v);m.insertAggregation(f,"formContainers",g,i,v);}else{F.log.error("Change does not contain sufficient information to be applied: ["+C.layer+"]"+C.namespace+"/"+C.fileName+"."+C.fileType);}};
A.completeChangeContent=function(c,s,p){var C=c.getDefinition(),a=p.appComponent;if(s.newLabel){B.setTextInChange(C,"groupLabel",s.newLabel,"XFLD");}else{throw new Error("Cannot create a new group: oSpecificChangeInfo.groupLabel attribute required");}if(!C.content){C.content={};}if(!C.content.group){C.content.group={};}if(s.index===undefined){throw new Error("Cannot create a new group: oSpecificChangeInfo.index attribute required");}else{C.content.group.index=s.index;}if(s.newControlId){C.content.group.selector=J.getSelector(s.newControlId,a);}else{throw new Error("Cannot create a new group: oSpecificChangeInfo.newControlId attribute required");}};
A.revertChange=function(c,f,p){var a=p.appComponent;var v=p.view;var m=p.modifier;var n=c.getRevertData().newGroupSelector;var g=m.bySelector(n,a,v);m.removeAggregation(f,"formContainers",g);m.destroy(g);c.resetRevertData();};
return A;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/AddFormField',["sap/ui/fl/Utils","sap/ui/fl/changeHandler/Base","sap/ui/fl/changeHandler/ChangeHandlerMediator","sap/ui/thirdparty/jquery"],function(U,B,C,q){"use strict";var A={};
A.applyChange=function(c,f,p){var o=c.getDefinition();var v=p.view;var i=o.content.newFieldIndex;var m=p.modifier;var P=c.getDependentControl("parentFormContainer",p);var a,b;var d=p.appComponent;var g=function(h){return h&&h.content&&h.content.createFunction;};var e=function(o,h){var j=o.content;if(j){return o.content.newFieldSelector&&(o.content.newFieldIndex!==undefined)&&o.content.bindingPath&&o.content.oDataServiceVersion&&!!g(h);}return false;};return C.getChangeHandlerSettings({"scenario":"addODataFieldWithLabel","oDataServiceVersion":o.content&&o.content.oDataServiceVersion}).then(function(h){if(e(o,h)){var j=o.content;var F=j.newFieldSelector;var s=q.extend({},j.newFieldSelector);s.id=s.id+"-field";var k=j.bindingPath;c.setRevertData({newFieldSelector:F});var l={"appComponent":p.appComponent,"view":p.view,"fieldSelector":s,"bindingPath":k};if(m.bySelector(F,d)){return B.markAsNotApplicable("Control to be created already exists:"+F);}var n=g(h);a=n(m,l);b=m.createControl("sap.ui.layout.form.FormElement",d,v,F);m.insertAggregation(b,"label",a.label,0,v);m.insertAggregation(b,"fields",a.control,0,v);m.insertAggregation(P,"formElements",b,i,v);return true;}else{U.log.error("Change does not contain sufficient information to be applied or ChangeHandlerMediator could not be retrieved: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}});};
A.completeChangeContent=function(c,s,p){var a=p.appComponent;var o=c.getDefinition();if(!o.content){o.content={};}if(s.parentId){c.addDependentControl(s.parentId,"parentFormContainer",p);}else{throw new Error("oSpecificChangeInfo.parentId attribute required");}if(s.bindingPath){o.content.bindingPath=s.bindingPath;}else{throw new Error("oSpecificChangeInfo.bindingPath attribute required");}if(s.newControlId){o.content.newFieldSelector=p.modifier.getSelector(s.newControlId,a);}else{throw new Error("oSpecificChangeInfo.newControlId attribute required");}if(s.index===undefined){throw new Error("oSpecificChangeInfo.targetIndex attribute required");}else{o.content.newFieldIndex=s.index;}if(s.oDataServiceVersion===undefined){throw new Error("oSpecificChangeInfo.oDataServiceVersion attribute required");}else{o.content.oDataServiceVersion=s.oDataServiceVersion;}};
A.revertChange=function(c,f,p){var a=p.appComponent;var v=p.view;var m=p.modifier;var F=c.getRevertData().newFieldSelector;var o=m.bySelector(F,a,v);m.removeAggregation(f,"formElements",o);m.destroy(o);c.resetRevertData();return true;};
return A;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/AddSimpleFormField',["sap/ui/fl/Utils","sap/ui/fl/changeHandler/ChangeHandlerMediator","sap/ui/fl/changeHandler/Base"],function(U,C,B){"use strict";var A={};var t="sap.ui.core.Title";var T="sap.m.Toolbar";var s="sap.m.Label";var a="sap.ui.comp.smartfield.SmartLabel";
A.applyChange=function(c,S,p){var o=c.getDefinition();var b=c.getDependentControl("targetContainerHeader",p);var m=p.modifier;var d=p.appComponent;var g=function(e){return e&&e.content&&e.content.createFunction;};var f=function(o,e){return o.content&&o.content.newFieldSelector&&(o.content.newFieldIndex!==undefined)&&o.content.bindingPath&&o.content.oDataServiceVersion&&!!g(e);};return C.getChangeHandlerSettings({"scenario":"addODataFieldWithLabel","oDataServiceVersion":o.content&&o.content.oDataServiceVersion}).then(function(e){if(f(o,e)){var h=o.content;var F=h.newFieldSelector;var k=h.bindingPath;var l=h.newFieldIndex;var n=m.getAggregation(S,"content");var q=n.slice();var I=n.indexOf(b);var N=0;var r=0;var u,v;if(n.length===1||n.length===I+1){N=n.length;}else{var j=0;for(j=I+1;j<n.length;j++){var w=m.getControlType(n[j]);if(w===s||w===a){if(r==l){N=j;break;}r++;}if(w===t||w===T){N=j;break;}if(j===(n.length-1)){N=n.length;}}}var x={"appComponent":d,"view":p.view,"fieldSelector":F,"bindingPath":k};if(m.bySelector(F,d)){return B.markAsNotApplicable("Control to be created already exists:"+F);}v=g(e);u=v(m,x);var y={};if(u.label&&u.control){y.label=m.getSelector(u.label,d);}y.control=m.getSelector(u.control,d);c.setRevertData(y);q.splice(N,0,u.label,u.control);m.removeAllAggregation(S,"content");for(var i=0;i<q.length;++i){m.insertAggregation(S,"content",q[i],i,p.view);}return true;}else{U.log.error("Change does not contain sufficient information to be applied or ChangeHandlerMediator could not be retrieved: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}});};
A.completeChangeContent=function(c,S,p){var o=p.appComponent;var v=p.view;var b=c.getDefinition();if(!b.content){b.content={};}if(S.parentId){var f=p.modifier.bySelector(S.parentId,o,v);var d=f.getTitle()||f.getToolbar();if(d){c.addDependentControl(d.getId(),"targetContainerHeader",p);}}else{throw new Error("oSpecificChangeInfo.parentId attribute required");}if(S.bindingPath){b.content.bindingPath=S.bindingPath;}else{throw new Error("oSpecificChangeInfo.bindingPath attribute required");}if(S.newControlId){b.content.newFieldSelector=p.modifier.getSelector(S.newControlId,o);}else{throw new Error("oSpecificChangeInfo.newControlId attribute required");}if(S.index===undefined){throw new Error("oSpecificChangeInfo.targetIndex attribute required");}else{b.content.newFieldIndex=S.index;}if(S.oDataServiceVersion===undefined){throw new Error("oSpecificChangeInfo.oDataServiceVersion attribute required");}else{b.content.oDataServiceVersion=S.oDataServiceVersion;}};
A.revertChange=function(c,S,p){var o=p.appComponent;var v=p.view;var m=p.modifier;var b=c.getRevertData();var f=m.bySelector(b.control,o,v);if(b.label){var l=m.bySelector(b.label,o,v);m.removeAggregation(S,"content",l);m.destroy(l);}m.removeAggregation(S,"content",f);m.destroy(f);c.resetRevertData();return true;};
return A;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/AddSimpleFormGroup',['sap/ui/fl/Utils','sap/ui/fl/changeHandler/Base','sap/ui/fl/changeHandler/JsControlTreeModifier'],function(U,B,J){"use strict";var A={};A.CONTENT_AGGREGATION="content";var f=function(M,s,c){for(var i=0;i<c.length;i++){var t=M.getControlType(c[i]);if(s.indexOf(t)===-1){if(M.getVisible(c[i])){return true;}}else{return false;}}};var m=function(M,s,c,g){var r;var C=-1;if(g===0){return g;}if(f(M,s,c)){C++;}for(var i=0;i<c.length;i++){var t=M.getControlType(c[i]);if(s.indexOf(t)>-1){C++;if(C===g){r=c[i];return c.indexOf(r);}}}return c.length;};
A.applyChange=function(c,F,p){var M=p.modifier;var v=p.view;var a=p.appComponent,t;var C=c.getDefinition();if(C.texts&&C.texts.groupLabel&&C.texts.groupLabel.value&&C.content&&C.content.group&&(C.content.group.selector||C.content.group.id)){var g=C.content.group.selector;var G;if(g){if(g.idIsLocal){G=a.createId(g.id);}else{G=g.id;}}else{G=C.content.group.id;}c.setRevertData({groupId:G});var l=C.texts.groupLabel.value;var b=M.getAggregation(F,A.CONTENT_AGGREGATION);var i;var r;if(typeof C.content.group.index==="number"){i=C.content.group.index;}else{r=C.content.group.relativeIndex;i=m(M,["sap.ui.core.Title","sap.m.Title","sap.m.Toolbar","sap.m.OverflowToolbar"],b,r);}if(M.bySelector(G,a)){return B.markAsNotApplicable("Control to be created already exists:"+G);}t=M.createControl("sap.ui.core.Title",a,v,G);M.setProperty(t,"text",l);M.insertAggregation(F,"content",t,i,v);}else{U.log.error("Change does not contain sufficient information to be applied: ["+C.layer+"]"+C.namespace+"/"+C.fileName+"."+C.fileType);}return true;};
A.completeChangeContent=function(c,s,p){var C=c.getDefinition();var a=p.appComponent;if(s.newLabel){B.setTextInChange(C,"groupLabel",s.newLabel,"XFLD");}else{throw new Error("oSpecificChangeInfo.newLabel attribute required");}if(!C.content){C.content={};}if(!C.content.group){C.content.group={};}if(s.newControlId){C.content.group.selector=J.getSelector(s.newControlId,a);}else{throw new Error("oSpecificChangeInfo.newControlId attribute required");}if(s.index===undefined){throw new Error("oSpecificChangeInfo.index attribute required");}else{C.content.group.relativeIndex=s.index;}};
A.getControlIdFromChangeContent=function(c){var C;if(c&&c._oDefinition){C=c._oDefinition.content.group.id;}return C;};
A.revertChange=function(c,F,p){var a=p.appComponent;var v=p.view;var M=p.modifier;var g=c.getRevertData().groupId;var G=M.getSelector(g,a);var o=M.bySelector(G,a,v);M.removeAggregation(F,A.CONTENT_AGGREGATION,o);M.destroy(o);c.resetRevertData();return true;};
return A;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/HideSimpleForm',['sap/ui/fl/changeHandler/JsControlTreeModifier',"sap/base/Log"],function(J,L){"use strict";var H={};var I=function(c,m){var C=m.getControlType(c);return(C==="sap.ui.core.Title")||(C==="sap.m.Title")||(C==="sap.m.Toolbar")||(C==="sap.m.OverflowToolbar");};var g=function(c,m){var i;for(i=0;i<c.length;++i){if(I(c[i],m)){return c[i];}}};
H.applyChange=function(c,C,p){try{var m=p.modifier;var v=p.view;var a=p.appComponent;var o=c.getDefinition();var r=m.bySelector(o.content.elementSelector||o.content.sHideId,a,v);var b=m.getAggregation(C,"content");var s=-1;var S=this._getState(C,m,a);c.setRevertData(S);m.removeAllAggregation(C,"content");for(var i=0;i<b.length;++i){m.insertAggregation(C,"content",b[i],i,v);}if(o.changeType==="hideSimpleFormField"){b.some(function(F,d){if(F===r){s=d;m.setVisible(F,false);}if(s>=0&&d>s){if((m.getControlType(F)==="sap.m.Label")||(m.getControlType(F)==="sap.ui.comp.smartfield.SmartLabel")||I(F,m)){return true;}else{m.setVisible(F,false);}}});}else if(o.changeType==="removeSimpleFormGroup"){var t=g(b,m);var f=t&&!r;b.some(function(F,d){if(!t){m.setVisible(F,false);}else if(f){s=0;m.setVisible(F,false);f=false;}else{if(F===r){s=d;}if(s>=0&&d>s){if(I(F,m)){if(s===0){m.removeAggregation(C,"content",F,v);m.insertAggregation(C,"content",F,0,v);}return true;}else{m.setVisible(F,false);}}}});if(r){m.removeAggregation(C,"content",r,v);}}return true;}catch(e){c.resetRevertData();L.error(e.message||e.name);}};
H._getStableElement=function(e){if(e.getMetadata().getName()==="sap.ui.layout.form.FormContainer"){return e.getTitle()||e.getToolbar();}else if(e.getMetadata().getName()==="sap.ui.layout.form.FormElement"){return e.getLabel();}else{return e;}};
H.completeChangeContent=function(c,s,p){var C=c.getDefinition();if(s.removedElement&&s.removedElement.id){var S=this._getStableElement(sap.ui.getCore().byId(s.removedElement.id));C.content.elementSelector=J.getSelector(S,p.appComponent);c.addDependentControl(S,"elementSelector",p);}else{throw new Error("oSpecificChangeInfo.removedElement.id attribute required");}};
H._getState=function(c,m,a){var C=m.getAggregation(c,"content");return{content:C.map(function(e){return{elementSelector:m.getSelector(m.getId(e),a),visible:e.getVisible?e.getVisible():undefined,index:C.indexOf(e)};})};};
H.revertChange=function(c,C,p){var s=c.getRevertData();var a=p.appComponent;var m=p.modifier;m.removeAllAggregation(C,"content");s.content.forEach(function(e){var E=m.bySelector(e.elementSelector,a);m.insertAggregation(C,"content",E,e.index,p.view);m.setProperty(E,"visible",e.visible);});c.resetRevertData();return true;};
return H;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/MoveSimpleForm',["sap/ui/core/util/reflection/JsControlTreeModifier","sap/base/util/uid","sap/base/Log","sap/ui/thirdparty/jquery"],function(J,u,L,q){"use strict";var M={};M.CHANGE_TYPE_MOVE_FIELD="moveSimpleFormField";M.CHANGE_TYPE_MOVE_GROUP="moveSimpleFormGroup";M.sTypeTitle="sap.ui.core.Title";M.sTypeMTitle="sap.m.Title";M.sTypeToolBar="sap.m.Toolbar";M.sTypeOverflowToolBar="sap.m.OverflowToolbar";M.sTypeLabel="sap.m.Label";M.sTypeSmartLabel="sap.ui.comp.smartfield.SmartLabel";M.CONTENT_AGGREGATION="content";var f=function(o,s,C){for(var i=0;i<C.length;i++){var t=o.getControlType(C[i]);if(s.indexOf(t)===-1){if(o.getVisible(C[i])){return true;}}else{return false;}}};var a=function(o,C,s,p,S,h){if(f(o,S,C)){var v=p.view;var i=p.appComponent;var t=o.createControl("sap.ui.core.Title",i,v,h);o.setProperty(t,"text","");o.insertAggregation(s,"content",t,0,v);}return o.getAggregation(s,"content");};var m=function(o,s,C,h){var R;var j=-1;if(f(o,s,C)){j++;}for(var i=0;i<C.length;i++){var t=o.getControlType(C[i]);if(s.indexOf(t)>-1){j++;if(j===h){R=C[i];break;}}}return C.indexOf(R);};var I=function(E,i,o){if(i>=E.length||i===-1){return true;}var t=o.getControlType(E[i]);return(M.sTypeTitle===t||M.sTypeToolBar===t||M.sTypeMTitle===t||M.sTypeOverflowToolBar===t);};var b=function(o,h,C,s){var i=0;for(i=h+1;i<C.length;++i){var t=o.getControlType(C[i]);if(s.indexOf(t)>-1){break;}}return i-h;};var g=function(o,E,i){return b(o,i,E,[M.sTypeTitle,M.sTypeMTitle,M.sTypeToolBar,M.sTypeOverflowToolBar,M.sTypeLabel,M.sTypeSmartLabel]);};var c=function(o,C,i,F,U){if(!I(C,i,o)){L.error("Illegal argument. iIndex has to point to a Label.");}else{F=U?F+1:F;var h=0;var j=i;var k;while(j<C.length&&h<F){++h;k=g(o,C,j);j+=k;}return j;}};var A=function(s,S,t,T,h){var R=t;for(var i=0;i<h;i++){R.splice(T+i,0,s[S+i]);}return R;};var G=function(h){var R=h.getTitle();if(!R){R=h.getToolbar();}return R;};var d=function(s,h,S,t,p){var o=G(h.element);var i=J.getSelector(s,p.appComponent);var j={elementSelector:J.getSelector(o,p.appComponent),source:{groupIndex:h.sourceIndex},target:{groupIndex:h.targetIndex}};return{changeType:M.CHANGE_TYPE_MOVE_GROUP,targetSelector:i,movedControl:o,movedElements:[j]};};var e=function(s,h,S,t,p){var o=J.getSelector(s,p.appComponent);var l=h.element.getLabel();var i=J.getSelector(l,p.appComponent);var T=G(t.parent);var j=G(S.parent);var k=J.getSelector(T,p.appComponent);var n=J.getSelector(j,p.appComponent);var v={elementSelector:i,source:{groupSelector:n,fieldIndex:h.sourceIndex},target:{groupSelector:k,fieldIndex:h.targetIndex}};return{changeType:M.CHANGE_TYPE_MOVE_FIELD,targetSelector:o,target:T,source:j,movedControl:l,movedElements:[v]};};var r=function(o,s,M,C,v){o.removeAllAggregation(s,M.CONTENT_AGGREGATION);for(var i=0;i<C.length;++i){o.insertAggregation(s,M.CONTENT_AGGREGATION,C[i],i,v);}};
M.applyChange=function(C,s,p){var o=p.modifier;var v=p.view;var h=p.appComponent;var t,i;var j=C.getContent();var k=j.movedElements[0];var l=o.getAggregation(s,M.CONTENT_AGGREGATION);var n=l.map(function(Y){return o.getSelector(Y,h);});var S={content:n};C.setRevertData(S);if(C.getChangeType()===M.CHANGE_TYPE_MOVE_FIELD){var w=o.bySelector(k.elementSelector||k.element,h,v);var x=l.indexOf(w);var y=g(o,l,x);t=o.bySelector(k.target.groupSelector||k.target.groupId,h,v);var T=l.indexOf(t);var z=o.bySelector(k.source.groupSelector||k.source.groupId,h,v);var B=l.indexOf(z);var D=c(o,l,T,k.target.fieldIndex,(B===T)&&(k.source.fieldIndex<k.target.fieldIndex));var E=g(o,l,D);i=l.slice();var F=i.slice(x,x+y);var H,K,N,O;if(x<D){H=i.slice(0,x);N=i.slice(x+y,D+E);O=i.slice(D+E,i.length);i=H.concat(N.concat(F.concat(O)));}else if(x>D){K=i.slice(0,D+E);N=i.slice(D+E,x);O=i.slice(x+y,i.length);i=K.concat(F.concat(N.concat(O)));}if(x!=D){r(o,s,M,i,v);}}else if(C.getChangeType()===M.CHANGE_TYPE_MOVE_GROUP){var P=[M.sTypeTitle,M.sTypeToolBar,M.sTypeMTitle,M.sTypeOverflowToolBar];var Q=o.bySelector(k.elementSelector||k.element,h,v);if(k.target.groupIndex===0||!Q){l=a(o,l,s,p,P,j.newControlId);}var R=Q?l.indexOf(Q):0;var U=m(o,P,l,k.target.groupIndex);t=l[U];var V=b(o,U,l,P);var W=b(o,R,l,P);i=l.slice();i.splice(R,W);U=i.indexOf(t);var X=k.source.groupIndex<k.target.groupIndex?V:0;i=A(l,R,i,U+X,W);r(o,s,M,i,v);}else{L.warning("Unknown change type detected. Cannot apply to SimpleForm");}return true;};
M.completeChangeContent=function(C,s,p){var S;var o=p.modifier;var v=p.view;var h=p.appComponent;var i=o.bySelector(s.selector,h,v);var j=s.movedElements;if(j.length>1){L.warning("Moving more than 1 Formelement is not yet supported.");}var k=j[0];k.element=sap.ui.getCore().byId(k.id);var l=q.extend({},s.source);var t=q.extend({},s.target);if(!t.parent){t.parent=sap.ui.getCore().byId(t.id);}if(!l.parent){l.parent=sap.ui.getCore().byId(l.id);}if(i&&k.element&&t.parent){if(s.changeType==="moveSimpleFormGroup"){S=d(i,k,l,t,p);}else if(s.changeType==="moveSimpleFormField"){S=e(i,k,l,t,p);}}else{L.error("Element not found. This may be caused by an unstable id!");}var n=C.getDefinition();n.content.targetSelector=S.targetSelector;n.content.movedElements=S.movedElements;n.content.newControlId=h.createId(u());if(S.source&&S.target){C.addDependentControl(S.source,"sourceParent",p);C.addDependentControl(S.target,"targetParent",p);}C.addDependentControl([S.movedControl],"movedElements",p);};
M.revertChange=function(C,s,p){var o=p.modifier;var h=p.appComponent;var v=p.view;var i=C.getRevertData().content;var j=i.map(function(S){return o.bySelector(S,h,v);});r(o,s,M,j,v);C.resetRevertData();return true;};
return M;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/RenameFormContainer',["sap/ui/fl/changeHandler/Base","sap/ui/fl/Utils"],function(B,U){"use strict";var R={};var _={TARGET_ALIAS:"target"};
R.applyChange=function(c,C,p){var m=p.modifier,o=c.getDefinition(),r=c.getDependentControl(_.TARGET_ALIAS,p),t=m.getAggregation(r,"title");if(o.texts&&o.texts.formText&&this._isProvided(o.texts.formText.value)){var v=o.texts.formText.value;if(typeof t==="string"){c.setRevertData(m.getProperty(r,"title"));m.setProperty(r,"title",v);}else{c.setRevertData(m.getProperty(t,"text"));m.setProperty(t,"text",v);}return true;}else{U.log.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}};
R.completeChangeContent=function(c,s,p){var C=c.getDefinition();if(!(s.renamedElement&&s.renamedElement.id)){throw new Error("Rename of the group cannot be executed: oSpecificChangeInfo.renamedElement attribute required");}if(!this._isProvided(s.value)){throw new Error("Rename of the group cannot be executed: oSpecificChangeInfo.value attribute required");}c.addDependentControl(s.renamedElement.id,_.TARGET_ALIAS,p);B.setTextInChange(C,"formText",s.value,"XGRP");};
R.revertChange=function(c,C,p){var o=c.getRevertData(),m=p.modifier,r=c.getDependentControl(_.TARGET_ALIAS,p),t=m.getAggregation(r,"title");if(typeof t==="string"){m.setProperty(r,"title",o);}else{m.setProperty(t,"text",o);}c.resetRevertData();return true;};
R._isProvided=function(s){return typeof(s)==="string";};
return R;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/RenameSimpleForm',["sap/ui/fl/changeHandler/Base","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,U){"use strict";var R={};
R.applyChange=function(c,C,p){var m=p.modifier;var v=p.view;var a=p.appComponent;var o=c.getDefinition();var s=o.content.elementSelector||o.content.sRenameId;var r=m.bySelector(s,a,v);if(o.texts&&o.texts.formText&&this._isProvided(o.texts.formText.value)){if(!C){throw new Error("no Control provided for renaming");}c.setRevertData(m.getProperty(r,"text"));var V=o.texts.formText.value;m.setProperty(r,"text",V);return true;}else{U.log.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}};
R.revertChange=function(c,C,p){var o=c.getRevertData();var a=p.appComponent;var b=c.getDefinition();var v=p.view;var m=p.modifier;var s=b.content.elementSelector||b.content.sRenameId;var r=m.bySelector(s,a,v);if(o||o===""){m.setProperty(r,"text",o);r.getParent().invalidate();c.resetRevertData();return true;}else{U.log.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.");}};
R.completeChangeContent=function(c,s,p){var C=c.getDefinition();if(!s.changeType){throw new Error("oSpecificChangeInfo.changeType attribute required");}if(s.renamedElement&&s.renamedElement.id){var r=sap.ui.getCore().byId(s.renamedElement.id);var S;if(s.changeType==="renameLabel"){S=r.getLabel();}else if(s.changeType==="renameTitle"){S=r.getTitle();}C.content.elementSelector=J.getSelector(S,p.appComponent);c.addDependentControl(S,"elementSelector",p);}else{throw new Error("oSpecificChangeInfo.renamedElement attribute required");}if(this._isProvided(s.value)){B.setTextInChange(C,"formText",s.value,"XFLD");}else{throw new Error("oSpecificChangeInfo.value attribute required");}};
R._isProvided=function(s){return typeof(s)==="string";};
return R;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/UnhideSimpleForm',["sap/ui/core/util/reflection/JsControlTreeModifier"],function(J){"use strict";var U={};
U.applyChange=function(c,C,p){var m=p.modifier;var v=p.view;var a=p.appComponent;var o=c.getDefinition();var b=m.bySelector(o.content.elementSelector||o.content.sUnhideId,a,v);var d=m.getAggregation(C,"content");var s=-1;if(o.changeType==="unhideSimpleFormField"){c.setRevertData(true);d.some(function(f,i){if(f===b){s=i;m.setVisible(f,true);}if(s>=0&&i>s){if((m.getControlType(f)==="sap.m.Label")||(m.getControlType(f)==="sap.ui.comp.smartfield.SmartLabel")||(m.getControlType(f)==="sap.ui.core.Title")||(m.getControlType(f)==="sap.m.Title")||(m.getControlType(f)==="sap.m.Toolbar")||(m.getControlType(f)==="sap.m.OverflowToolbar")){return true;}else{m.setVisible(f,true);}}});}return true;};
U.completeChangeContent=function(c,s,p){var C=c.getDefinition();if(s.sUnhideId){var u=sap.ui.getCore().byId(s.sUnhideId);C.content.elementSelector=J.getSelector(u,p.appComponent);c.addDependentControl(u,"elementSelector",p);}else if(s.revealedElementId){var f=sap.ui.getCore().byId(s.revealedElementId||s.sUnhideId);var l=f.getLabel();C.content.elementSelector=J.getSelector(l,p.appComponent);c.addDependentControl(l,"elementSelector",p);}else{throw new Error("oSpecificChangeInfo.revealedElementId attribute required");}};
U.revertChange=function(c,C,p){var m=p.modifier;var v=p.view;var a=p.appComponent;var o=c.getDefinition();var b=m.bySelector(o.content.elementSelector||o.content.sUnhideId,a,v);var d=m.getAggregation(C,"content");var s=-1;if(o.changeType==="unhideSimpleFormField"){d.some(function(f,i){if(f===b){s=i;m.setVisible(f,false);}if(s>=0&&i>s){if((m.getControlType(f)==="sap.m.Label")||(m.getControlType(f)==="sap.ui.comp.smartfield.SmartLabel")||(m.getControlType(f)==="sap.ui.core.Title")||(m.getControlType(f)==="sap.m.Title")||(m.getControlType(f)==="sap.m.Toolbar")||(m.getControlType(f)==="sap.m.OverflowToolbar")){return true;}else{m.setVisible(f,false);}}});c.resetRevertData();}return true;};
return U;},true);
sap.ui.predefine('sap/ui/layout/cssgrid/CSSGrid',["sap/ui/core/Control","sap/ui/layout/cssgrid/GridItemLayoutData","sap/ui/layout/cssgrid/GridBasicLayout","sap/ui/layout/cssgrid/GridLayoutDelegate","sap/ui/base/ManagedObjectObserver","sap/ui/layout/library","./CSSGridRenderer"],function(C,G,a,b,M){"use strict";
var c=C.extend("sap.ui.layout.cssgrid.CSSGrid",{metadata:{library:"sap.ui.layout",defaultAggregation:"items",interfaces:["sap.ui.layout.cssgrid.IGridConfigurable"],properties:{width:{type:"sap.ui.core.CSSSize",defaultValue:"100%"},gridTemplateColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridTemplateRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridRowGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridColumnGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridGap:{type:"sap.ui.layout.cssgrid.CSSGridGapShortHand",defaultValue:""},gridAutoRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoFlow:{type:"sap.ui.layout.cssgrid.CSSGridAutoFlow",defaultValue:"Row"}},aggregations:{customLayout:{type:"sap.ui.layout.cssgrid.GridLayoutBase",multiple:false},items:{type:"sap.ui.core.Control",multiple:true,singularName:"item",dnd:true}},dnd:{draggable:false,droppable:true}}});
c.prototype.setWidth=function(w){this.setProperty("width",w,true);var d=this.getDomRef();if(d){d.style.width=w;}return this;};
c.prototype.getGridDomRefs=function(){return[this.getDomRef()];};
c.prototype.getGridLayoutConfiguration=function(){if(this.getCustomLayout()){return this.getCustomLayout();}else{return this._getDefaultGridLayout();}};
c.prototype._getDefaultGridLayout=function(){var d=new a({gridTemplateColumns:this.getGridTemplateColumns(),gridTemplateRows:this.getGridTemplateRows(),gridRowGap:this.getGridRowGap(),gridColumnGap:this.getGridColumnGap(),gridGap:this.getGridGap(),gridAutoRows:this.getGridAutoRows(),gridAutoColumns:this.getGridAutoColumns(),gridAutoFlow:this.getGridAutoFlow()});return d;};
c.prototype.init=function(){this._oItemDelegate={onAfterRendering:this._onAfterItemRendering};this._oGridObserver=new M(c.prototype._onGridChange.bind(this));this._oGridObserver.observe(this,{aggregations:["items"]});this._addGridLayoutDelegate();};
c.prototype.exit=function(){this._removeGridLayoutDelegate();if(this._oGridObserver){this._oGridObserver.disconnect();this._oGridObserver=null;}};
c.prototype._addGridLayoutDelegate=function(){if(!this.oGridLayoutDelegate){this.oGridLayoutDelegate=new b();this.addDelegate(this.oGridLayoutDelegate,false,this,false);}};
c.prototype._removeGridLayoutDelegate=function(){if(this.oGridLayoutDelegate){this.removeDelegate(this.oGridLayoutDelegate);this.oGridLayoutDelegate.destroy();this.oGridLayoutDelegate=null;}};
c.prototype._onGridChange=function(o){if(o.name!=="items"||!o.child){return;}if(o.mutation==="insert"){o.child.addEventDelegate(this._oItemDelegate,o.child);}else if(o.mutation==="remove"){o.child.removeEventDelegate(this._oItemDelegate,o.child);}};
c.prototype._onAfterItemRendering=function(){G._setItemStyles(this);};
c.prototype.onLayoutDataChange=function(e){G._setItemStyles(e.srcControl);};
return c;});
sap.ui.predefine('sap/ui/layout/cssgrid/CSSGridRenderer',["sap/ui/layout/cssgrid/GridLayoutBase"],function(G){"use strict";var C={};
C.render=function(r,c){r.write("<div");r.addClass("sapUiLayoutCSSGrid");r.writeControlData(c);if(c.getWidth()){r.addStyle("width",c.getWidth());}c.getGridLayoutConfiguration().renderSingleGridLayout(r);r.writeStyles();r.writeClasses();r.write(">");c.getItems().forEach(function(i){if(c._wrapItemsWithDiv){r.write("<div");r.addClass("sapUiLayoutCSSGridItemWrapper");r.writeClasses();r.write(">");}r.renderControl(i);if(c._wrapItemsWithDiv){r.write("</div>");}});r.write("</div>");};
return C;});
sap.ui.predefine('sap/ui/layout/cssgrid/GridBasicLayout',["sap/ui/layout/cssgrid/GridLayoutBase","sap/ui/layout/cssgrid/GridSettings","sap/ui/layout/library"],function(G,a){"use strict";
var b=G.extend("sap.ui.layout.cssgrid.GridBasicLayout",{metadata:{library:"sap.ui.layout",properties:{gridTemplateColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridTemplateRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridRowGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridColumnGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridGap:{type:"sap.ui.layout.cssgrid.CSSGridGapShortHand",defaultValue:""},gridAutoRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoFlow:{type:"sap.ui.layout.cssgrid.CSSGridAutoFlow",defaultValue:"Row"}}}});
b.prototype.getActiveGridSettings=function(){return new a({gridTemplateColumns:this.getGridTemplateColumns(),gridTemplateRows:this.getGridTemplateRows(),gridRowGap:this.getGridRowGap(),gridColumnGap:this.getGridColumnGap(),gridGap:this.getGridGap(),gridAutoRows:this.getGridAutoRows(),gridAutoColumns:this.getGridAutoColumns(),gridAutoFlow:this.getGridAutoFlow()});};
return b;});
sap.ui.predefine('sap/ui/layout/cssgrid/GridBoxLayout',["sap/ui/layout/cssgrid/GridLayoutBase","sap/ui/layout/cssgrid/GridSettings","sap/ui/Device"],function(G,a,D){"use strict";var S=/^([X][L](?:[1-9]|1[0-2]))? ?([L](?:[1-9]|1[0-2]))? ?([M](?:[1-9]|1[0-2]))? ?([S](?:[1-9]|1[0-2]))?$/i;var b=S.exec("XL7 L6 M4 S2");var s={"Phone":"sapUiLayoutCSSGridBoxLayoutSizeS","Tablet":"sapUiLayoutCSSGridBoxLayoutSizeM","Desktop":"sapUiLayoutCSSGridBoxLayoutSizeL","LargeDesktop":"sapUiLayoutCSSGridBoxLayoutSizeXL"};var c={"XL":"sapUiLayoutCSSGridBoxLayoutSpanXL7","L":"sapUiLayoutCSSGridBoxLayoutSpanL6","M":"sapUiLayoutCSSGridBoxLayoutSpanM4","S":"sapUiLayoutCSSGridBoxLayoutSpanS2"};
var d=G.extend("sap.ui.layout.cssgrid.GridBoxLayout",{metadata:{library:"sap.ui.layout",properties:{boxMinWidth:{type:"sap.ui.core.CSSSize",defaultValue:""},boxWidth:{type:"sap.ui.core.CSSSize",defaultValue:""},boxesPerRowConfig:{type:"sap.ui.layout.BoxesPerRowConfig",group:"Behavior",defaultValue:"XL7 L6 M4 S2"}}}});
d.prototype.getActiveGridSettings=function(){return new a({gridTemplateColumns:this._getTemplateColumns(),gridGap:"0.5rem 0.5rem"});};
d.prototype._applySingleGridLayout=function(e){if(this.isGridSupportedByBrowser()){G.prototype._applySingleGridLayout.call(this,e);}};
d.prototype.renderSingleGridLayout=function(r){this._addSpanClasses(r);if(this.isGridSupportedByBrowser()){r.addClass("sapUiLayoutCSSGridBoxLayoutContainer");}else{r.addClass("sapUiLayoutCSSGridBoxLayoutPolyfill");}};
d.prototype.onGridAfterRendering=function(g){G.prototype.onGridAfterRendering.call(this,g);if(!this._hasBoxWidth()){this._applySizeClass(g);}if(!this.isGridSupportedByBrowser()){this._calcWidth(g);this._flattenHeight(g);if(!this._hasBoxWidth()){this._applyClassForLastItem(g);}}if(g.isA("sap.f.GridList")&&g.getGrowing()){var C=g._oGrowingDelegate._onAfterPageLoaded;g._oGrowingDelegate._onAfterPageLoaded=function(){C.call(g._oGrowingDelegate);if(!this.isGridSupportedByBrowser()){this._flattenHeight(g);this._calcWidth(g);this._loopOverGridItems(g,function(o){if(!o.classList.contains("sapMGHLI")){o.classList.add("sapUiLayoutCSSGridItem");}});if(!this._hasBoxWidth()){this._applyClassForLastItem(g);}}else if(g.isA("sap.f.GridList")&&g.isGrouped()){this._flattenHeight(g);}}.bind(this);}};
d.prototype._setGridLayout=function(e,g){var o=sap.ui.getCore().byId(e.parentElement.id);G.prototype._setGridLayout.call(this,e,g);if(this.isGridSupportedByBrowser()&&(o&&o.isA("sap.f.GridList")&&o.isGrouped())){this._flattenHeight(o);}};
d.prototype.isResponsive=function(){return true;};
d.prototype.onGridResize=function(e){if(!this.isGridSupportedByBrowser()||(e.control&&e.control.isA("sap.f.GridList")&&e.control.isGrouped())){this._flattenHeight(e.control);}if(!this.isGridSupportedByBrowser()&&!this._hasBoxWidth()){this._applyClassForLastItem(e.control);}if(e){if(!this._hasBoxWidth()){this._applySizeClass(e.control);}}};
d.prototype._calcWidth=function(C){var w;if(this._hasBoxWidth()){w=this.getBoxWidth()||this.getBoxMinWidth();}this._loopOverGridItems(C,function(g){if(!g.classList.contains("sapMGHLI")){g.style.width=w;}});};
d.prototype._flattenHeight=function(C){var m=0;var $=jQuery('<div style="position:absolute;top=-10000px;left=-10000px"></div>').appendTo(document.body);this._loopOverGridItems(C,function(g){if(!g.classList.contains("sapMGHLI")){var e=jQuery(jQuery.clone(g)).appendTo($);e.css({height:'auto',width:g.getBoundingClientRect().width});m=Math.max(e.outerHeight(),m);e.remove();}});$.remove();this._loopOverGridItems(C,function(g){if(!g.classList.contains("sapMGHLI")){g.style.height=m+"px";}});};
d.prototype._applyClassForLastItem=function(C){var i=0;var B=this.getBoxesPerRowConfig().split(" ");var r=D.media.getCurrentRange("StdExt",C.$().width());var e=s[r.name].substring("sapUiLayoutCSSGridBoxLayoutSize".length);var m;B.forEach(function(f){if(f.indexOf(e)!=-1){m=parseInt(f.substring(e.length));}});this._loopOverGridItems(C,function(g){if(g.classList.contains("sapUiLayoutCSSGridItem")){i++;if(i==m){g.classList.add("sapUiLayoutCSSGridItemLastOnRow");i=0;}else{g.classList.remove("sapUiLayoutCSSGridItemLastOnRow");}}else if(g.classList.contains("sapMGHLI")){i=0;}});};
d.prototype._applySizeClass=function(C){var r=D.media.getCurrentRange("StdExt",C.$().width()),e=s[r.name];C.getGridDomRefs().forEach(function(o){if(!o.classList.contains(e)){Object.keys(s).map(function(f){o.classList.remove(s[f]);});o.classList.add(e);}});};
d.prototype._getTemplateColumns=function(){var t="";if(this.getBoxWidth()){t="repeat(auto-fit, "+this.getBoxWidth()+")";}else if(this.getBoxMinWidth()){t="repeat(auto-fit, minmax("+this.getBoxMinWidth()+", 1fr))";}return t;};
d.prototype._hasBoxWidth=function(){if(this.getBoxWidth()||this.getBoxMinWidth()){return true;}else{return false;}};
d.prototype._addSpanClasses=function(r){var e,f,g=this.getBoxesPerRowConfig(),h,j,k,l;if(this._hasBoxWidth()){return;}if(!g||!g.length===0){e=b;}else{e=S.exec(g);}if(e){for(var i=1;i<e.length;i++){f=e[i];if(f){f=f.toUpperCase();switch(f.substr(0,1)){case"X":if(f.substr(1,1)==="L"){h=this._getBoxesPerRowClass(f,2);}break;case"L":j=this._getBoxesPerRowClass(f,1);break;case"M":k=this._getBoxesPerRowClass(f,1);break;case"S":l=this._getBoxesPerRowClass(f,1);break;default:break;}}}}h=h||c.XL;j=j||c.L;k=k||c.M;l=l||c.S;r.addClass([h,j,k,l].join(" "));};
d.prototype._getBoxesPerRowClass=function(e,i){var f=parseInt(e.substr(i,e.length));if(f&&f>0&&f<13){return"sapUiLayoutCSSGridBoxLayoutSpan"+e;}};
d.prototype._loopOverGridItems=function(C,f){C.getGridDomRefs().forEach(function(o){if(o&&o.children){for(var i=0;i<o.children.length;i++){f(o.children[i]);}}});};
return d;});
sap.ui.predefine('sap/ui/layout/cssgrid/GridItemLayoutData',["sap/ui/core/LayoutData","sap/ui/layout/library"],function(L){"use strict";var g={gridColumnStart:"grid-column-start",gridColumnEnd:"grid-column-end",gridRowStart:"grid-row-start",gridRowEnd:"grid-row-end",gridColumn:"grid-column",gridRow:"grid-row"};
var G=L.extend("sap.ui.layout.cssgrid.GridItemLayoutData",{metadata:{library:"sap.ui.layout",properties:{gridColumnStart:{type:"sap.ui.layout.cssgrid.CSSGridLine",defaultValue:""},gridColumnEnd:{type:"sap.ui.layout.cssgrid.CSSGridLine",defaultValue:""},gridRowStart:{type:"sap.ui.layout.cssgrid.CSSGridLine",defaultValue:""},gridRowEnd:{type:"sap.ui.layout.cssgrid.CSSGridLine",defaultValue:""},gridColumn:{type:"sap.ui.layout.cssgrid.CSSGridLine",defaultValue:""},gridRow:{type:"sap.ui.layout.cssgrid.CSSGridLine",defaultValue:""}}}});
G._setItemStyles=function(i){if(!i){return;}var l=G._getLayoutDataForControl(i),e=G._getElement(i),p,P,s;if(!e){return;}if(!l){G._removeItemStyles(e);return;}p=l.getMetadata().getProperties();for(P in g){if(p[P]){s=l.getProperty(P);if(typeof s!=="undefined"){G._setItemStyle(e,g[P],s);}}}};
G._getElement=function(i){var I=i.getDomRef();if(!I){return undefined;}var w=I.parentNode;if(w&&w.classList.contains("sapUiLayoutCSSGridItemWrapper")){return w;}return I;};
G._removeItemStyles=function(i){for(var p in g){i.style.removeProperty(g[p]);}};
G._setItemStyle=function(i,p,v){if(v!=="0"&&!v){i.style.removeProperty(p);}else{i.style.setProperty(p,v);}};
G._getLayoutDataForControl=function(c){var l,a,I;if(!c){return undefined;}l=c.getLayoutData();if(!l){return undefined;}if(l.isA("sap.ui.layout.cssgrid.GridItemLayoutData")){return l;}if(l.isA("sap.ui.core.VariantLayoutData")){a=l.getMultipleLayoutData();for(var i=0;i<a.length;i++){I=a[i];if(I.isA("sap.ui.layout.cssgrid.GridItemLayoutData")){return I;}}}};
return G;});
sap.ui.predefine('sap/ui/layout/cssgrid/GridLayoutBase',["sap/ui/base/ManagedObject","sap/ui/Device"],function(M,D){"use strict";var g={gridTemplateColumns:"grid-template-columns",gridTemplateRows:"grid-template-rows",gridGap:"grid-gap",gridColumnGap:"grid-column-gap",gridRowGap:"grid-row-gap",gridAutoRows:"grid-auto-rows",gridAutoColumns:"grid-auto-columns",gridAutoFlow:"grid-auto-flow"};var E=16;var G={Row:"row",Column:"column",RowDense:"row dense",ColumnDense:"column dense"};
var a=M.extend("sap.ui.layout.cssgrid.GridLayoutBase",{metadata:{library:"sap.ui.layout","abstract":true}});
a.prototype.applyGridLayout=function(e){if(!e){return;}e.forEach(this._applySingleGridLayout,this);};
a.prototype._applySingleGridLayout=function(e){if(!e){return;}e=e instanceof window.HTMLElement?e:e.getDomRef();var o=this.getActiveGridSettings();e.style.setProperty("display","grid");if(o){this._setGridLayout(e,o);}else{this._removeGridLayout(e);}};
a.prototype._setGridLayout=function(e,o){var p=o.getMetadata().getProperties(),P,s;for(P in g){if(p[P]){s=o.getProperty(P);if(P==="gridAutoFlow"){s=G[s];}if(s===""&&(P==="gridRowGap"||P==="gridColumnGap")){continue;}e.style.setProperty(g[P],s);}}};
a.prototype._removeGridLayout=function(e){for(var p in g){e.style.removeProperty(g[p]);}};
a.prototype.getActiveGridSettings=function(){throw new Error("GridLayoutBase getActiveGridSettings not implemented in child class");};
a.prototype.onGridAfterRendering=function(o){o.getGridDomRefs().forEach(function(d){if(d.children){for(var i=0;i<d.children.length;i++){if(!d.children[i].classList.contains("sapMGHLI")){d.children[i].classList.add("sapUiLayoutCSSGridItem");}}}});};
a.prototype.onGridResize=function(e){};
a.prototype.isResponsive=function(){return false;};
a.prototype.isGridSupportedByBrowser=function(){return!D.browser.msie&&!(D.browser.edge&&D.browser.version<E);};
a.prototype.renderSingleGridLayout=function(r){var o=this&&this.getActiveGridSettings(),p,P;r.addStyle("display","grid");if(!o||this.isResponsive()){return;}var b=o.getMetadata().getProperties();for(p in g){if(b[p]){P=o.getProperty(p);if(p==="gridAutoFlow"){P=G[P];}r.addStyle(g[p],P);}}};
return a;});
sap.ui.predefine('sap/ui/layout/cssgrid/GridLayoutDelegate',["sap/ui/base/Object","sap/ui/core/ResizeHandler"],function(B,R){"use strict";
var G=B.extend("sap.ui.layout.cssgrid.GridLayoutDelegate");
G.prototype.onBeforeRendering=function(){G.deregisterResizeListener(this);};
G.prototype.onAfterRendering=function(){var g=this.getGridLayoutConfiguration();if(!g){return;}g.onGridAfterRendering(this);if(g.isResponsive()){g.applyGridLayout(this.getGridDomRefs());G.registerResizeListener(this);}};
G.prototype.exit=function(){G.deregisterResizeListener(this);};
G.registerResizeListener=function(c){c.__grid__sResizeListenerId=R.register(c,G.onResize.bind(c));};
G.deregisterResizeListener=function(c){if(c.__grid__sResizeListenerId){R.deregister(c.__grid__sResizeListenerId);c.__grid__sResizeListenerId=null;}};
G.onResize=function(e){var g=this.getGridLayoutConfiguration();if(!g){return;}g.onGridResize(e);g.applyGridLayout(this.getGridDomRefs());};
return G;});
sap.ui.predefine('sap/ui/layout/cssgrid/GridResponsiveLayout',["sap/ui/layout/cssgrid/GridLayoutBase","sap/ui/Device"],function(G,D){"use strict";
var a=G.extend("sap.ui.layout.cssgrid.GridResponsiveLayout",{metadata:{library:"sap.ui.layout",properties:{containerQuery:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{layout:{type:"sap.ui.layout.cssgrid.GridSettings",multiple:false},layoutS:{type:"sap.ui.layout.cssgrid.GridSettings",multiple:false},layoutM:{type:"sap.ui.layout.cssgrid.GridSettings",multiple:false},layoutL:{type:"sap.ui.layout.cssgrid.GridSettings",multiple:false},layoutXL:{type:"sap.ui.layout.cssgrid.GridSettings",multiple:false}},events:{layoutChange:{parameters:{layout:{type:"string"}}}}}});
a.prototype.init=function(){this._sActiveLayout="layout";};
a.prototype.getActiveGridSettings=function(){return this.getAggregation(this._sActiveLayout);};
a.prototype.isResponsive=function(){return true;};
a.prototype.onGridAfterRendering=function(g){this.setActiveLayout(g,false);};
a.prototype.onGridResize=function(e){if(!e||e.size.width===0){return;}this.setActiveLayout(e.control,true);};
a.prototype.applySizeClass=function($,s){var c;if($.hasClass(s)){return;}c=Object.keys(a.mSizeClasses).map(function(S){return a.mSizeClasses[S];});$.removeClass(c.join(" "));$.addClass(s);};
a.prototype.setActiveLayout=function(g,t){var w=this.getContainerQuery()?g.$().outerWidth():window.innerWidth;var r=D.media.getCurrentRange("StdExt",w),l=a.mSizeLayouts[r.name],L=this._getLayoutToApply(l);this.applySizeClass(g.$(),a.mSizeClasses[r.name]);if(this._sActiveLayout===L){return;}this._sActiveLayout=L;if(t){this.fireLayoutChange({layout:L});}};
a.prototype._getLayoutToApply=function(l){if(this.getAggregation(l)){return l;}else{return"layout";}};
a.mSizeClasses={"Phone":"sapUiLayoutCSSGridS","Tablet":"sapUiLayoutCSSGridM","Desktop":"sapUiLayoutCSSGridL","LargeDesktop":"sapUiLayoutCSSGridXL"};a.mSizeLayouts={"Phone":"layoutS","Tablet":"layoutM","Desktop":"layoutL","LargeDesktop":"layoutXL"};return a;});
sap.ui.predefine('sap/ui/layout/cssgrid/GridSettings',["sap/ui/base/ManagedObject","sap/ui/layout/library"],function(M){"use strict";
var G=M.extend("sap.ui.layout.cssgrid.GridSettings",{metadata:{library:"sap.ui.layout",properties:{gridTemplateColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridTemplateRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridRowGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridColumnGap:{type:"sap.ui.core.CSSSize",defaultValue:""},gridGap:{type:"sap.ui.layout.cssgrid.CSSGridGapShortHand",defaultValue:""},gridAutoRows:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoColumns:{type:"sap.ui.layout.cssgrid.CSSGridTrack",defaultValue:""},gridAutoFlow:{type:"sap.ui.layout.cssgrid.CSSGridAutoFlow",defaultValue:"Row"}}}});
return G;});
sap.ui.predefine('sap/ui/layout/cssgrid/VirtualGrid',["sap/ui/base/Object","sap/ui/layout/library"],function(B){"use strict";
function e(){var g=0;for(var i=0;i<this.virtualGridMatrix.length;i++){if(this.virtualGridMatrix[i][0]!==0){g++;}}if(g>0){this.addEmptyRows(g);}}
function a(c){return c==0;}
var V=B.extend("sap.f.VirtualGrid");
V.prototype.init=function(s){this.virtualGridMatrix=[[]];this.numberOfCols=s.numberOfCols?s.numberOfCols:1;this.numberOfRows=s.numberOfRows?s.numberOfRows:1;this.cellWidth=s.cellWidth?s.cellWidth:5;this.cellHeight=s.cellHeight?s.cellHeight:5;this.unitOfMeasure=s.unitOfMeasure?s.unitOfMeasure:"rem";this.iGapSize=s.gapSize?s.gapSize:1;this.bAllowDenseFill=s.allowDenseFill?s.allowDenseFill:false;this.items={};this.topOffset=s.topOffset?s.topOffset:0;this.leftOffset=s.topOffset?s.leftOffset:0;for(var r=0;r<this.numberOfRows;r++){for(var c=0;c<this.numberOfCols;c++){this.virtualGridMatrix[r][c]=0;}}this.lastItemPosition={top:-1,left:-1};};
V.prototype.addEmptyRows=function(n){var l=this.virtualGridMatrix.length;for(var i=l;i<l+n;i++){this.virtualGridMatrix[i]=Array.apply(null,Array(this.numberOfCols)).map(Number.prototype.valueOf,0);}};
V.prototype.getItems=function(){return this.items;};
V.prototype.getMatrix=function(){return this.virtualGridMatrix;};
V.prototype.getHeight=function(){var r=0;for(var b=0;b<this.virtualGridMatrix.length;b++){if(!this.virtualGridMatrix[b].every(a)){r++;}}return r*this.cellHeight+(r-1)*this.iGapSize;};
V.prototype.calculatePositions=function(){for(var r=0;r<this.virtualGridMatrix.length;r++){for(var c=0;c<this.virtualGridMatrix[r].length;c++){if(!this.items[parseInt(this.virtualGridMatrix[r][c])].calculatedCoords){var i=this.items[this.virtualGridMatrix[r][c]];i.top=r*(this.cellHeight+this.iGapSize)+this.topOffset+this.unitOfMeasure;i.left=c*(this.cellWidth+this.iGapSize)+this.leftOffset+this.unitOfMeasure;i.width=(i.cols*(this.cellHeight+this.iGapSize)-this.iGapSize)+this.unitOfMeasure;i.height=(i.rows*(this.cellWidth+this.iGapSize)-this.iGapSize)+this.unitOfMeasure;i.calculatedCoords=true;}}}};
V.prototype.fitElement=function(i,w,h,g,s){var p,t=this,b=Math.min(w,this.numberOfCols),l=t.lastItemPosition.top,c=t.lastItemPosition.left;this.items[i]={rows:h,cols:b,calculatedCoords:false};if(h>this.virtualGridMatrix.length){this.addEmptyRows(h-this.virtualGridMatrix.length);}if(g){e.call(this);}this.virtualGridMatrix.forEach(function(d,r,f){d.forEach(function(j,k,m){var n=t.bAllowDenseFill||r>l||(r==l&&k>c);if(n&&t.virtualGridMatrix[r][k]===0&&!p){if(t.shouldElementFit(r,k,b,h)){t.fillElement(r,k,b,h,i);p=true;}}});});if(!p&&!s){this.fitElement(i,w,h,true,true);}};
V.prototype.shouldElementFit=function(r,c,w,h){var t=r+h;var b=c+w;var m=this.virtualGridMatrix;for(var i=r;i<t;i++){for(var j=c;j<b;j++){if((m[i][j]!==0)||(m.length<t)||(m[i].length<c+w)){return false;}}}return true;};
V.prototype.fillElement=function(r,c,w,h,b){for(var i=r;i<r+h;i++){for(var j=c;j<c+w;j++){this.virtualGridMatrix[i][j]=b;}}this.lastItemPosition={top:r,left:c};};
return V;});
sap.ui.predefine('sap/ui/layout/flexibility/BlockLayoutCell.flexibility',["sap/ui/fl/changeHandler/BaseRename"],function(B){"use strict";return{"hideControl":"default","moveControls":"default","rename":B.createRenameChangeHandler({propertyName:"title",translationTextType:"XTIT"}),"unhideControl":"default"};},false);
sap.ui.predefine('sap/ui/layout/flexibility/Form.flexibility',["sap/ui/layout/changeHandler/AddFormContainer","sap/ui/layout/changeHandler/AddFormField"],function(A,a){"use strict";return{"moveControls":"default","addGroup":A,"addFormField":a};},true);
sap.ui.predefine('sap/ui/layout/flexibility/FormContainer.flexibility',["sap/ui/layout/changeHandler/RenameFormContainer","sap/ui/layout/changeHandler/AddFormField"],function(R,A){"use strict";return{"hideControl":"default","renameGroup":R,"moveControls":"default","addFormField":A};},true);
sap.ui.predefine('sap/ui/layout/flexibility/FormElement.flexibility',["sap/ui/fl/changeHandler/BaseRename"],function(B){"use strict";return{"hideControl":"default","unhideControl":"default","renameField":B.createRenameChangeHandler({propertyName:"label",translationTextType:"XFLD",changePropertyName:"fieldLabel"})};},true);
sap.ui.predefine('sap/ui/layout/flexibility/SimpleForm.flexibility',["sap/ui/layout/changeHandler/RenameSimpleForm","sap/ui/layout/changeHandler/MoveSimpleForm","sap/ui/layout/changeHandler/HideSimpleForm","sap/ui/layout/changeHandler/UnhideSimpleForm","sap/ui/layout/changeHandler/AddSimpleFormGroup","sap/ui/layout/changeHandler/AddSimpleFormField"],function(R,M,H,U,A,a){"use strict";return{"renameLabel":R,"renameTitle":R,"moveSimpleFormField":M,"moveSimpleFormGroup":M,"hideSimpleFormField":H,"unhideSimpleFormField":U,"removeSimpleFormGroup":H,"addSimpleFormGroup":A,"addSimpleFormField":a};},true);
sap.ui.predefine('sap/ui/layout/form/ColumnContainerData',['sap/ui/core/LayoutData','sap/ui/layout/library'],function(L,l){"use strict";
var C=L.extend("sap.ui.layout.form.ColumnContainerData",{metadata:{library:"sap.ui.layout",properties:{columnsXL:{type:"sap.ui.layout.form.ColumnsXL",group:"Appearance",defaultValue:2},columnsL:{type:"sap.ui.layout.form.ColumnsL",group:"Appearance",defaultValue:2},columnsM:{type:"sap.ui.layout.form.ColumnsM",group:"Appearance",defaultValue:1}}}});
return C;});
sap.ui.predefine('sap/ui/layout/form/ColumnElementData',['sap/ui/core/LayoutData','sap/ui/layout/library'],function(L,l){"use strict";
var C=L.extend("sap.ui.layout.form.ColumnElementData",{metadata:{library:"sap.ui.layout",properties:{cellsLarge:{type:"sap.ui.layout.form.ColumnCells",group:"Appearance",defaultValue:8},cellsSmall:{type:"sap.ui.layout.form.ColumnCells",group:"Appearance",defaultValue:12}}}});
return C;});
sap.ui.predefine('sap/ui/layout/form/ColumnLayout',['sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/layout/library','./FormLayout','./ColumnLayoutRenderer',"sap/ui/thirdparty/jquery"],function(D,R,l,F,C,q){"use strict";
var a=F.extend("sap.ui.layout.form.ColumnLayout",{metadata:{library:"sap.ui.layout",properties:{columnsXL:{type:"sap.ui.layout.form.ColumnsXL",group:"Appearance",defaultValue:2},columnsL:{type:"sap.ui.layout.form.ColumnsL",group:"Appearance",defaultValue:2},columnsM:{type:"sap.ui.layout.form.ColumnsM",group:"Appearance",defaultValue:1},labelCellsLarge:{type:"sap.ui.layout.form.ColumnCells",group:"Appearance",defaultValue:4},emptyCellsLarge:{type:"sap.ui.layout.form.EmptyCells",group:"Appearance",defaultValue:0}}}});
a.prototype.init=function(){this._iBreakPointTablet=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];this._resizeProxy=q.proxy(b,this);};
a.prototype.exit=function(){_.call(this);};
a.prototype.onBeforeRendering=function(e){if(this.getColumnsM()>this.getColumnsL()||this.getColumnsL()>this.getColumnsXL()){throw new Error("Column size not correct defined for "+this);}_.call(this);};
a.prototype.onAfterRendering=function(e){this._sResizeListener=R.register(this,this._resizeProxy);b.call(this);};
a.prototype.toggleContainerExpanded=function(c){c.$().toggleClass("sapUiFormCLContainerColl",!c.getExpanded());};
a.prototype.onLayoutDataChange=function(e){this.invalidate();};
a.prototype.onsapup=function(e){this.onsapleft(e);};
a.prototype.onsapdown=function(e){this.onsapright(e);};
a.prototype.getContainerRenderedDomRef=function(c){return c.getDomRef();};
a.prototype.getElementRenderedDomRef=function(e){return e.getDomRef();};
a.prototype._getContainerSize=function(c){var f=this.getParent();var L=this.getLayoutDataForElement(c,"sap.ui.layout.form.ColumnContainerData");var d=f.getVisibleFormContainers();var e=d.length;var g=this.getColumnsM();var h=this.getColumnsL();var j=this.getColumnsXL();var o={S:{Size:1,Break:false,FirstRow:false},M:{Size:1,Break:false,FirstRow:false},L:{Size:1,Break:false,FirstRow:false},XL:{Size:1,Break:false,FirstRow:false}};var k=function(w,o,e,I,x){if(e<w){o.Size=Math.floor(w/e);if(x&&o.Size*e<w){o.Size=o.Size+w-o.Size*e;}}o.Break=w>1&&I>0&&(I%w)===0;o.FirstRow=e>1&&I<w;};if(L){o.M.Size=L.getColumnsM();o.L.Size=L.getColumnsL();o.XL.Size=L.getColumnsXL();if(o.M.Size>g||o.L.Size>h||o.XL.Size>j){throw new Error("More cells defined for FormContainer "+c.getId()+" than columns on "+this);}}if(e===1){if(!L){o.M.Size=g;o.L.Size=h;o.XL.Size=j;}o.S.FirstRow=true;o.M.FirstRow=true;o.L.FirstRow=true;o.XL.FirstRow=true;}else{var m=0;var M=0;var n=0;var O;var p=false;var r=0;var s=g;var t=h;var u=j;var i=0;for(i=0;i<e;i++){if(c===d[i]){m=i;O=L;}else{O=this.getLayoutDataForElement(d[i],"sap.ui.layout.form.ColumnContainerData");}if(!O){var E=d[i].getVisibleFormElements();if(M<E.length){M=E.length;n=i;}r++;}else{p=true;s=s-O.getColumnsM();t=t-O.getColumnsL();u=u-O.getColumnsXL();}}o.S.FirstRow=e>1&&m===0;o.S.Break=m>0;if(!p){k(g,o.M,e,m,m===n);k(h,o.L,e,m,m===n);k(j,o.XL,e,m,m===n);}else{if(!L){if(r<s){k(s,o.M,r,m,m===n);}if(r<t){k(t,o.L,r,m,m===n);}if(r<u){k(u,o.XL,r,m,m===n);}}var S={M:{rowColumns:0,lineBreak:false,first:true},L:{rowColumns:0,lineBreak:false,first:true},XL:{rowColumns:0,lineBreak:false,first:true}};var v=function(w,x,U){if(U){if(w.rowColumns+U<=x){w.rowColumns=w.rowColumns+U;w.lineBreak=false;}else{w.rowColumns=U;if(x>1){w.lineBreak=true;}w.first=false;}}else{if(w.rowColumns<x){w.rowColumns++;w.lineBreak=false;}else{w.rowColumns=1;if(x>1){w.lineBreak=true;}w.first=false;}}};for(i=0;i<e;i++){if(c===d[i]){O=L;}else{O=this.getLayoutDataForElement(d[i],"sap.ui.layout.form.ColumnContainerData");}v(S.M,g,(O?O.getColumnsM():0));v(S.L,h,(O?O.getColumnsL():0));v(S.XL,j,(O?O.getColumnsXL():0));if(c===d[i]){o.M.Break=S.M.lineBreak;o.L.Break=S.L.lineBreak;o.XL.Break=S.XL.lineBreak;o.M.FirstRow=S.M.first;o.L.FirstRow=S.L.first;o.XL.FirstRow=S.XL.first;break;}}}}return o;};
a.prototype._getFieldSize=function(f){var c=12;var L=this.getLayoutDataForElement(f,"sap.ui.layout.form.ColumnElementData");var o={S:{Size:c,Break:false,Space:0},L:{Size:c,Break:false,Space:0}};var d=c;var e=this.getLabelCellsLarge();if(L){o.S.Size=L.getCellsSmall();o.L.Size=L.getCellsLarge();}var E=f.getParent();var g=E.getLabelControl();if(g===f){if(!L){o.S.Size=d;o.L.Size=e;}}else{var h=E.getFields();var j=h.length;var k=c;var m=c-this.getEmptyCellsLarge();if(g){var n=this.getLayoutDataForElement(g,"sap.ui.layout.form.ColumnElementData");if(n){d=n.getCellsSmall();e=n.getCellsLarge();}if(d<c){k=k-d;}if(e<c){m=m-e;}}else{d=0;e=0;}if(j===1){if(!L){o.S.Size=k;o.L.Size=m;}else if(g){if(o.S.Size>k){o.S.Break=true;}if(o.L.Size>m){o.L.Break=true;}}}else{var i=0;var r=[];var p=[];var s={availableCells:k,first:0,last:999,firstDefault:-1,defaultFields:0};var t=0;var u=0;var v=0;var O;r.push(q.extend({},s));s.availableCells=m;p.push(q.extend({},s));var w=function(A,B,I,c){A[B].last=I-1;A.push(q.extend({},s));B++;A[B].first=I;A[B].availableCells=c;return B;};var x=function(A,B,G,U,I){if(A[B].availableCells-A[B].defaultFields<G){if(G<=U){B=w(A,B,I,U);}else{B=w(A,B,I,c);}}A[B].availableCells=A[B].availableCells-G;return B;};var y=function(A,B,c,I){if(A[B].availableCells===A[B].defaultFields){B=w(A,B,I,c);}if(A[B].firstDefault<0){A[B].firstDefault=I;}A[B].defaultFields++;return B;};for(i=0;i<j;i++){if(f!==h[i]){O=this.getLayoutDataForElement(h[i],"sap.ui.layout.form.ColumnElementData");}else{O=L;v=i;}if(O){t=x(r,t,O.getCellsSmall(),k,i);u=x(p,u,O.getCellsLarge(),m,i);}else{t=y(r,t,k,i);u=y(p,u,m,i);}}var z=function(A,v,L,o,B){var G=0;var s;for(i=0;i<A.length;i++){if(v>=A[i].first&&v<=A[i].last){s=A[i];break;}}if(!L){o.Size=Math.floor(s.availableCells/s.defaultFields);}if(v===s.first&&v>0){o.Break=true;if(B>0&&B<c&&o.Size<=c-B){o.Space=B;}}if(v===s.firstDefault){G=s.availableCells-s.defaultFields*o.Size;if(G>0){o.Size=o.Size+G;}}};z(r,v,L,o.S,d);z(p,v,L,o.L,e);}}return o;};
function _(){if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}}
function b(e,n){var d=this.getDomRef();if(!d){_.call(this);return;}var $=this.$();if(!$.is(":visible")){return;}var w=d.clientWidth;var c=1;if(w<=this._iBreakPointTablet){$.toggleClass("sapUiFormCLMedia-Std-Phone",true);$.toggleClass("sapUiFormCLMedia-Std-Desktop",false).toggleClass("sapUiFormCLMedia-Std-Tablet",false).toggleClass("sapUiFormCLMedia-Std-LargeDesktop",false);}else if((w>this._iBreakPointTablet)&&(w<=this._iBreakPointDesktop)){$.toggleClass("sapUiFormCLMedia-Std-Tablet",true);$.toggleClass("sapUiFormCLMedia-Std-Desktop",false).toggleClass("sapUiFormCLMedia-Std-Phone",false).toggleClass("sapUiFormCLMedia-Std-LargeDesktop",false);c=this.getColumnsM();}else if((w>this._iBreakPointDesktop)&&(w<=this._iBreakPointLargeDesktop)){$.toggleClass("sapUiFormCLMedia-Std-Desktop",true);$.toggleClass("sapUiFormCLMedia-Std-Phone",false).toggleClass("sapUiFormCLMedia-Std-Tablet",false).toggleClass("sapUiFormCLMedia-Std-LargeDesktop",false);c=this.getColumnsL();}else{$.toggleClass("sapUiFormCLMedia-Std-LargeDesktop",true);$.toggleClass("sapUiFormCLMedia-Std-Desktop",false).toggleClass("sapUiFormCLMedia-Std-Phone",false).toggleClass("sapUiFormCLMedia-Std-Tablet",false);c=this.getColumnsXL();}var W=this.getLabelCellsLarge()<12&&w/c>this._iBreakPointTablet;$.toggleClass("sapUiFormCLWideColumns",W);$.toggleClass("sapUiFormCLSmallColumns",!W);}
return a;});
sap.ui.predefine('sap/ui/layout/form/ColumnLayoutRenderer',['sap/ui/core/Renderer','sap/ui/Device','./FormLayoutRenderer'],function(R,D,F){"use strict";var C=R.extend(F);
C.getMainClass=function(){return"sapUiFormCL";};
C.renderContainers=function(r,l,f){var c=l.getColumnsM();var a=l.getColumnsL();var b=l.getColumnsXL();var d=f.getVisibleFormContainers();var e=d.length;if(e>0){if(e>1||l.getLayoutDataForElement(d[0],"sap.ui.layout.form.ColumnContainerData")){r.write("<div");r.addClass("sapUiFormCLContent");r.addClass("sapUiFormCLColumnsM"+c);r.addClass("sapUiFormCLColumnsL"+a);r.addClass("sapUiFormCLColumnsXL"+b);r.writeClasses();r.write(">");}for(var i=0;i<e;i++){var o=d[i];this.renderContainer(r,l,o);}if(e>1){r.write("</div>");}}};
C.renderContainer=function(r,l,c){var e=c.getExpandable();var t=c.getToolbar();var T=c.getTitle();var o=l._getContainerSize(c);c._checkProperties();r.write("<section");r.writeElementData(c);r.addClass("sapUiFormCLContainer");r.addClass("sapUiFormCLContainerS"+o.S.Size);r.addClass("sapUiFormCLContainerM"+o.M.Size);r.addClass("sapUiFormCLContainerL"+o.L.Size);r.addClass("sapUiFormCLContainerXL"+o.XL.Size);if(o.M.Break){r.addClass("sapUiFormCLContainerMBreak");}if(o.L.Break){r.addClass("sapUiFormCLContainerLBreak");}if(o.XL.Break){r.addClass("sapUiFormCLContainerXLBreak");}if(o.S.FirstRow){r.addClass("sapUiFormCLContainerSFirstRow");}if(o.M.FirstRow){r.addClass("sapUiFormCLContainerMFirstRow");}if(o.L.FirstRow){r.addClass("sapUiFormCLContainerLFirstRow");}if(o.XL.FirstRow){r.addClass("sapUiFormCLContainerXLFirstRow");}if(t){r.addClass("sapUiFormContainerToolbar");}else if(T){r.addClass("sapUiFormContainerTitle");}if(!c.getExpanded()){r.addClass("sapUiFormCLContainerColl");}if(c.getTooltip_AsString()){r.writeAttributeEscaped('title',c.getTooltip_AsString());}r.writeClasses();this.writeAccessibilityStateContainer(r,c);r.write(">");this.renderHeader(r,t,T,c._oExpandButton,e,false,c.getId());r.write("<div id=\""+c.getId()+"-content\" class=\"sapUiFormCLContainerCont\">");var E=c.getVisibleFormElements();for(var i=0;i<E.length;i++){var a=E[i];this.renderElement(r,l,a);if(D.browser.chrome&&i<o.XL.Size&&E.length>1&&E.length<=o.XL.Size){r.write("<div class=\"sapUiFormCLElementDummy\"></div>");}}r.write("</div>");r.write("</section>");};
C.renderElement=function(r,l,e){var L=e.getLabelControl();var o;r.write("<div");r.writeElementData(e);r.addClass("sapUiFormCLElement");if(e.getTooltip_AsString()){r.writeAttributeEscaped('title',e.getTooltip_AsString());}r.writeClasses();r.write(">");if(L){o=l._getFieldSize(L);r.write("<div");r.addClass("sapUiFormElementLbl");r.addClass("sapUiFormCLCellsS"+o.S.Size);r.addClass("sapUiFormCLCellsL"+o.L.Size);r.writeClasses();r.write(">");r.renderControl(L);r.write("</div>");}var f=e.getFields();if(f&&f.length>0){for(var k=0,a=f.length;k<a;k++){var b=f[k];if(!b.isA("sap.ui.core.IFormContent")){throw new Error(b+" is not a valid Form content! Only use valid content in "+l);}o=l._getFieldSize(b);r.write("<div");r.addClass("sapUiFormCLCellsS"+o.S.Size);r.addClass("sapUiFormCLCellsL"+o.L.Size);if(o.S.Break){r.addClass("sapUiFormCLCellSBreak");}if(o.L.Break){r.addClass("sapUiFormCLCellLBreak");}if(o.S.Space){r.addClass("sapUiFormCLCellSSpace"+o.S.Space);}if(o.L.Space){r.addClass("sapUiFormCLCellLSpace"+o.L.Space);}r.writeClasses();r.write(">");r.renderControl(b);r.write("</div>");}}r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/layout/form/Form',['sap/ui/core/Control','sap/ui/layout/library','./FormRenderer'],function(C,l,F){"use strict";
var a=C.extend("sap.ui.layout.form.Form",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},editable:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"formContainers",aggregations:{formContainers:{type:"sap.ui.layout.form.FormContainer",multiple:true,singularName:"formContainer"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},layout:{type:"sap.ui.layout.form.FormLayout",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/ui/layout/designtime/form/Form.designtime"}});
a.prototype.toggleContainerExpanded=function(c){var L=this.getLayout();if(L){L.toggleContainerExpanded(c);}};
a.prototype.contentOnAfterRendering=function(f,c){var L=this.getLayout();if(L&&L.contentOnAfterRendering){L.contentOnAfterRendering(f,c);}};
a.prototype.onLayoutDataChange=function(e){var L=this.getLayout();if(L&&L.onLayoutDataChange){L.onLayoutDataChange(e);}};
a.prototype.onBeforeFastNavigationFocus=function(e){var L=this.getLayout();if(L&&L.onBeforeFastNavigationFocus){L.onBeforeFastNavigationFocus(e);}};
a.prototype.setEditable=function(e){var o=this.getEditable();this.setProperty("editable",e,true);if(e!=o&&this.getDomRef()){if(e){this.$().addClass("sapUiFormEdit").addClass("sapUiFormEdit-CTX");this.$().removeAttr("aria-readonly");}else{this.$().removeClass("sapUiFormEdit").removeClass("sapUiFormEdit-CTX");this.$().attr("aria-readonly","true");}var f=this.getFormContainers();for(var i=0;i<f.length;i++){var b=f[i];b.invalidateLabels();}}return this;};
a.prototype.setToolbar=function(t){t=l.form.FormHelper.setToolbar.call(this,t);this.setAggregation("toolbar",t);return this;};
a.prototype.invalidate=function(o){if(!this._bNoInvalidate){C.prototype.invalidate.apply(this,arguments);}};
a.prototype.getContainerRenderedDomRef=function(c){var L=this.getLayout();if(L&&L.getContainerRenderedDomRef){return L.getContainerRenderedDomRef(c);}else{return null;}};
a.prototype.getElementRenderedDomRef=function(e){var L=this.getLayout();if(L&&L.getElementRenderedDomRef){return L.getElementRenderedDomRef(e);}else{return null;}};
a.prototype.getVisibleFormContainers=function(){var c=this.getFormContainers();var v=[];for(var i=0;i<c.length;i++){var o=c[i];if(o.isVisible()){v.push(o);}}return v;};
a.prototype._suggestTitleId=function(t){this._sSuggestedTitleId=t;if(this.getDomRef()){this.invalidate();}return this;};
return a;});
sap.ui.predefine('sap/ui/layout/form/FormContainer',['sap/ui/core/Element','sap/ui/core/theming/Parameters','sap/ui/layout/library',"sap/base/Log"],function(E,P,l,L){"use strict";
var F=E.extend("sap.ui.layout.form.FormContainer",{metadata:{library:"sap.ui.layout",properties:{expanded:{type:"boolean",group:"Misc",defaultValue:true},expandable:{type:"boolean",group:"Misc",defaultValue:false},visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"formElements",aggregations:{formElements:{type:"sap.ui.layout.form.FormElement",multiple:true,singularName:"formElement"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},_expandButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/ui/layout/designtime/form/FormContainer.designtime"}});
F.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");};
F.prototype.exit=function(){if(this._oExpandButton){delete this._oExpandButton;}this._rb=undefined;};
F.prototype.setExpandable=function(e){this.setProperty("expandable",e);if(e){if(!this._oExpandButton){if(!this._bExpandButtonRequired){this._bExpandButtonRequired=true;l.form.FormHelper.createButton.call(this,this.getId()+"--Exp",b,_);}}else{a.call(this);}}return this;};
function _(B){if(!this._bIsBeingDestroyed){this._oExpandButton=B;this.setAggregation("_expandButton",this._oExpandButton);a.call(this);}}
F.prototype.setExpanded=function(e){this.setProperty("expanded",e,true);a.call(this);var f=this.getParent();if(f&&f.toggleContainerExpanded){f.toggleContainerExpanded(this);}return this;};
F.prototype.setToolbar=function(t){t=l.form.FormHelper.setToolbar.call(this,t);this.setAggregation("toolbar",t);return this;};
F.prototype.contentOnAfterRendering=function(f,c){var p=this.getParent();if(p&&p.contentOnAfterRendering){p.contentOnAfterRendering(f,c);}};
F.prototype.onLayoutDataChange=function(e){var p=this.getParent();if(p&&p.onLayoutDataChange){p.onLayoutDataChange(e);}};
F.prototype._checkProperties=function(){var r=0;if(this.getExpandable()&&(!this.getTitle()||this.getToolbar())){L.warning("Expander only displayed if title is set",this.getId(),"FormContainer");r=1;}return r;};
F.prototype.getRenderedDomRef=function(){var t=this;var f=this.getParent();if(f&&f.getContainerRenderedDomRef){return f.getContainerRenderedDomRef(t);}else{return null;}};
F.prototype.getElementRenderedDomRef=function(e){var f=this.getParent();if(f&&f.getElementRenderedDomRef){return f.getElementRenderedDomRef(e);}else{return null;}};
F.prototype.getVisibleFormElements=function(){var e=this.getFormElements();var v=[];for(var i=0;i<e.length;i++){var o=e[i];if(o.isVisible()){v.push(o);}}return v;};
F.prototype.invalidateLabels=function(){var f=this.getFormElements();for(var i=0;i<f.length;i++){var o=f[i];o.invalidateLabel();}};
F.prototype.isVisible=function(){return this.getVisible();};
function a(){if(!this._oExpandButton){return;}var i,I,t,T;if(this.getExpanded()){i=P._getThemeImage('_sap_ui_layout_Form_FormContainerColImageURL');I=P._getThemeImage('_sap_ui_layout_Form_FormContainerColImageDownURL');t="-";T=this._rb.getText("FORM_COLLAPSE");}else{i=P._getThemeImage('_sap_ui_layout_Form_FormContainerExpImageURL');I=P._getThemeImage('_sap_ui_layout_Form_FormContainerExpImageDownURL');t="+";T=this._rb.getText("FORM_EXPAND");}if(i){t="";}l.form.FormHelper.setButtonContent(this._oExpandButton,t,T,i,I);}
function b(e){this.setExpanded(!this.getExpanded());}
return F;});
sap.ui.predefine('sap/ui/layout/form/FormElement',['sap/ui/core/Element','sap/ui/core/Control','sap/ui/base/ManagedObjectObserver','sap/ui/layout/library',"sap/base/Log"],function(E,C,M,l,L){"use strict";
var F=E.extend("sap.ui.layout.form.FormElement",{metadata:{library:"sap.ui.layout",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"fields",aggregations:{label:{type:"sap.ui.core.Label",altTypes:["string"],multiple:false},_label:{type:"sap.ui.core.Label",multiple:false,visibility:"hidden"},fields:{type:"sap.ui.core.Control",multiple:true,singularName:"field"}},designtime:"sap/ui/layout/designtime/form/FormElement.designtime"}});
F.prototype.init=function(){this._oFieldDelegate={oElement:this,onAfterRendering:h};this._oObserver=new M(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["fields"]});};
F.prototype.exit=function(){if(this._oLabel){delete this._oLabel;}this._oFieldDelegate=undefined;this._oObserver.disconnect();this._oObserver=undefined;};
F.prototype.setLabel=function(A){if(!this._oLabel){var o=this.getLabel();if(o){if(o.setAlternativeLabelFor){o.setAlternativeLabelFor(null);}if(o.isRequired){o.isRequired=o._sapuiIsRequired;o._sapuiIsRequired=undefined;o.disableRequiredChangeCheck(false);}if(o.isDisplayOnly){o.isDisplayOnly=o._sapuiIsDisplayOnly;o._sapuiIsDisplayOnly=undefined;}if(o.isWrapping){o.isWrapping=o._sapuiIsWrapping;o._sapuiIsWrapping=undefined;}}}this.setAggregation("label",A);var i=A;if(typeof i==="string"){if(!this._oLabel){this._oLabel=l.form.FormHelper.createLabel(i,this.getId()+"-label");this.setAggregation("_label",this._oLabel,true);this._oLabel.disableRequiredChangeCheck(true);if(this._oLabel.isRequired){this._oLabel.isRequired=b;}if(this._oLabel.isDisplayOnly){this._oLabel.isDisplayOnly=c;}if(this._oLabel.setWrapping){this._oLabel.setWrapping(true);}}else{this._oLabel.setText(i);}}else{if(this._oLabel){this._oLabel.destroy();delete this._oLabel;}if(i&&i.isRequired){i._sapuiIsRequired=i.isRequired;i.isRequired=b;i.disableRequiredChangeCheck(true);}if(i&&i.isDisplayOnly){i._sapuiIsDisplayOnly=i.isDisplayOnly;i.isDisplayOnly=c;}if(i&&i.isWrapping){i._sapuiIsWrapping=i.isWrapping;i.isWrapping=d;}}e.call(this);return this;};
F.prototype.destroyLabel=function(){this.destroyAggregation("label");if(this._oLabel){this._oLabel.destroy();delete this._oLabel;}return this;};
F.prototype.getLabelControl=function(){if(this._oLabel){return this._oLabel;}else{return this.getLabel();}};
F.prototype.updateFields=function(){var j=this.getFields();var o;var i=0;for(i=0;i<j.length;i++){o=j[i];g.call(this,o);}this.updateAggregation("fields");j=this.getFields();for(i=0;i<j.length;i++){o=j[i];f.call(this,o);}e.call(this);return this;};
F.prototype.enhanceAccessibilityState=function(o,A){var i=this.getLabelControl();if(i&&i!=o){var s=A["labelledby"];if(!s){s=i.getId();}else{var j=s.split(" ");if(j.indexOf(i.getId())<0){j.splice(0,0,i.getId());s=j.join(" ");}}A["labelledby"]=s;}return A;};
F.prototype.onLayoutDataChange=function(o){var p=this.getParent();if(p&&p.onLayoutDataChange){p.onLayoutDataChange(o);}};
F.prototype.getRenderedDomRef=function(){var t=this;var o=this.getParent();if(o&&o.getElementRenderedDomRef){return o.getElementRenderedDomRef(t);}else{return null;}};
F.prototype.invalidateLabel=function(){var o=this.getLabelControl();if(o){o.invalidate();}};
F.prototype.isVisible=function(){return this.getVisible();};
F.prototype._observeChanges=function(o){if(o.object==this){if(o.name=="fields"){_.call(this,o.child,o.mutation);}}else{a.call(this,o);}};
function _(o,m){if(m=="insert"){if(!o.isA("sap.ui.core.IFormContent")){L.warning(o+" is not valid Form content",this);}f.call(this,o);}else{g.call(this,o);}e.call(this);}
function a(o){if(o.name=="required"){this.invalidateLabel();}}
function b(){if(this.getRequired&&this.getRequired()){return true;}var o=this.getParent();var j=o.getFields();for(var i=0;i<j.length;i++){var k=j[i];if(k.getRequired&&k.getRequired()===true&&(!k.getEditable||k.getEditable())){return true;}}return false;}
function c(){if(this.getDisplayOnly){if(!this.isPropertyInitial("displayOnly")){return this.getDisplayOnly();}var o=this.getParent();var i=o.getParent();if(i){var j=i.getParent();if(j){return!j.getEditable();}}}return false;}
function d(){if(this.getWrapping&&!this.isPropertyInitial("wrapping")){return this.getWrapping();}return true;}
function e(){var i=this.getFields();var o=i.length>0?i[0]:null;var j=this._oLabel;if(j){j.setLabelFor(o);}else{j=this.getLabel();if(j instanceof C){j.setAlternativeLabelFor(o);}}}
function f(o){o.addDelegate(this._oFieldDelegate);if(!this._bNoObserverChange&&o.getMetadata().getProperty("required")){this._oObserver.observe(o,{properties:["required"]});}}
function g(o){o.removeDelegate(this._oFieldDelegate);if(!this._bNoObserverChange){this._oObserver.unobserve(o);}}
function h(o){var p=this.oElement.getParent();if(p&&p.contentOnAfterRendering){p.contentOnAfterRendering(this.oElement,o.srcControl);}}
return F;});
sap.ui.predefine('sap/ui/layout/form/FormLayout',['sap/ui/core/Control','sap/ui/layout/library','./FormLayoutRenderer',"sap/ui/thirdparty/jquery",'sap/ui/dom/jquery/Selectors','sap/ui/dom/jquery/control'],function(C,l,F,q){"use strict";var B=l.BackgroundDesign;
var a=C.extend("sap.ui.layout.form.FormLayout",{metadata:{library:"sap.ui.layout",properties:{backgroundDesign:{type:"sap.ui.layout.BackgroundDesign",group:"Appearance",defaultValue:B.Translucent}}}});
a.prototype.contentOnAfterRendering=function(f,c){if(l.form.FormHelper.bArrowKeySupport){q(c.getFocusDomRef()).data("sap.InNavArea",true);}if(c.getWidth&&(!c.getWidth()||c.getWidth()=="auto")&&(!c.getFormDoNotAdjustWidth||!c.getFormDoNotAdjustWidth())){c.$().css("width","100%");}};
a.prototype.toggleContainerExpanded=function(c){var e=c.getExpanded();if(this.getDomRef()){if(e){c.$("content").css("display","");}else{c.$("content").css("display","none");}}};
a.prototype.getLayoutDataForElement=function(e,t){var L=e.getLayoutData();if(!L){return undefined;}else if(L.isA(t)){return L;}else if(L.isA("sap.ui.core.VariantLayoutData")){var b=L.getMultipleLayoutData();for(var i=0;i<b.length;i++){var o=b[i];if(o.isA(t)){return o;}}}};
a.prototype.onsapright=function(e){if(l.form.FormHelper.bArrowKeySupport){var r=sap.ui.getCore().getConfiguration().getRTL();if(!r){this.navigateForward(e);}else{this.navigateBack(e);}}};
a.prototype.onsapleft=function(e){if(l.form.FormHelper.bArrowKeySupport){var r=sap.ui.getCore().getConfiguration().getRTL();if(!r){this.navigateBack(e);}else{this.navigateForward(e);}}};
a.prototype.onsapdown=function(e){if(l.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E.isA("sap.ui.layout.form.FormElement")){n=this.findFieldBelow(c,E);}else if(E&&E.isA("sap.ui.layout.form.FormContainer")){n=this.findFirstFieldOfNextElement(E,0);}if(n){n.focus();e.preventDefault();}}};
a.prototype.onsapup=function(e){if(l.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E.isA("sap.ui.layout.form.FormElement")){n=this.findFieldAbove(c,E);}else if(E&&E.isA("sap.ui.layout.form.FormContainer")){var f=E.getParent();i=f.indexOfFormContainer(E);n=this.findLastFieldOfLastElementInPrevContainer(f,i-1);}if(n){n.focus();e.preventDefault();}}};
a.prototype.onsaphome=function(e){if(l.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;var o=E.getParent();var f=o.getParent();i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i);if(n){n.focus();e.preventDefault();}}};
a.prototype.onsaptop=function(e){if(l.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var r=this.findElement(c);var E=r.element;var n;var o;if(E&&E.isA("sap.ui.layout.form.FormElement")){o=E.getParent();}else if(E&&E.isA("sap.ui.layout.form.FormContainer")){o=E;}var f=o.getParent();n=this.findFirstFieldOfForm(f);if(n){n.focus();e.preventDefault();}}};
a.prototype.onsapend=function(e){if(l.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;var o=E.getParent();var f=o.getParent();i=f.indexOfFormContainer(o);n=this.findLastFieldOfLastElementInPrevContainer(f,i);if(n){n.focus();e.preventDefault();}}};
a.prototype.onsapbottom=function(e){if(l.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var r=this.findElement(c);var E=r.element;var n;var o;if(E&&E.isA("sap.ui.layout.form.FormElement")){o=E.getParent();}else if(E&&E.isA("sap.ui.layout.form.FormContainer")){o=E;}var f=o.getParent();var b=f.getFormContainers();var L=b.length;n=this.findLastFieldOfLastElementInPrevContainer(f,L-1);if(n){n.focus();e.preventDefault();}}};
a.prototype.onsapexpand=function(e){var c=e.srcControl;var r=this.findElement(c);var E=r.element;var o;if(E.isA("sap.ui.layout.form.FormContainer")){o=E;}else{o=E.getParent();}if(o.getExpandable()&&c===o._oExpandButton){o.setExpanded(true);}};
a.prototype.onsapcollapse=function(e){var c=e.srcControl;var r=this.findElement(c);var E=r.element;var o;if(E.isA("sap.ui.layout.form.FormContainer")){o=E;}else{o=E.getParent();}if(o.getExpandable()&&c===o._oExpandButton){o.setExpanded(false);}};
a.prototype.onsapskipforward=function(e){var c=e.srcControl;var r=this.findElement(c);var E=r.element;c=r.rootControl;var n;var o;if(E&&E.isA("sap.ui.layout.form.FormElement")){o=E.getParent();}else if(E&&E.isA("sap.ui.layout.form.FormContainer")){o=E;}var f=o.getParent();var i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1);if(n){n.focus();e.preventDefault();}};
a.prototype.onsapskipback=function(e){var c=e.srcControl;var r=this.findElement(c);var E=r.element;c=r.rootControl;var n;var o;if(E&&E.isA("sap.ui.layout.form.FormElement")){o=E.getParent();}else if(E&&E.isA("sap.ui.layout.form.FormContainer")){o=E;}var f=o.getParent();var b=f.getFormContainers();var i=f.indexOfFormContainer(o);while(!n&&i>0){var p=b[i-1];if(!p.getExpandable()||p.getExpanded()){n=this.findFirstFieldOfFirstElementInPrevContainer(f,i-1);}i=i-1;}if(n&&n!==c.getFocusDomRef()){n.focus();e.preventDefault();}};
a.prototype.onBeforeFastNavigationFocus=function(e){if(q.contains(this.getDomRef(),e.source)){e.srcControl=q(e.source).control(0);if(e.forward){this.onsapskipforward(e);}else{this.onsapskipback(e);}}else{var n=e.forward?this.findFirstFieldOfForm(this.getParent()):this.findFirstFieldOfLastContainerOfForm(this.getParent());if(n){n.focus();e.preventDefault();}}};
a.prototype.findElement=function(c){var e=c.getParent();var r=c;while(e&&!(e.isA("sap.ui.layout.form.FormElement"))&&!(e.isA("sap.ui.layout.form.FormContainer"))&&!(e.isA("sap.ui.layout.form.Form"))){r=e;e=e.getParent();}return({rootControl:r,element:e});};
a.prototype.navigateForward=function(e){var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E.isA("sap.ui.layout.form.FormElement")){if(c==E.getLabelControl()){i=-1;}else{i=E.indexOfField(c);}n=this.findNextFieldOfElement(E,i+1);if(!n){var o=E.getParent();i=o.indexOfFormElement(E);n=this.findFirstFieldOfNextElement(o,i+1);if(!n){var f=o.getParent();i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1);}}}else if(E&&E.isA("sap.ui.layout.form.FormContainer")){n=this.findFirstFieldOfNextElement(E,0);}if(n){n.focus();e.preventDefault();}};
a.prototype.tabForward=function(e){var f;var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E.isA("sap.ui.layout.form.FormElement")){if(c==E.getLabelControl()){i=-1;}else{i=E.indexOfField(c);}n=this.findNextFieldOfElement(E,i+1,true);if(!n){var o=E.getParent();i=o.indexOfFormElement(E);n=this.findFirstFieldOfNextElement(o,i+1,true);if(!n){f=o.getParent();i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1,true);}}}else if(E&&E.isA("sap.ui.layout.form.FormContainer")){n=this.findFirstFieldOfNextElement(E,0,true);if(!n){f=E.getParent();i=f.indexOfFormContainer(E);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1,true);}}if(n){n.focus();e.preventDefault();}};
a.prototype.findNextFieldOfElement=function(e,s,t){var f=e.getFields();var L=f.length;var n;for(var i=s;i<L;i++){var o=f[i];var d=this._getDomRef(o);if(t==true){if((!o.getEditable||o.getEditable())&&(!o.getEnabled||o.getEnabled())&&d){n=d;break;}}else{if((!o.getEnabled||o.getEnabled())&&d){n=d;break;}}}return n;};
a.prototype.findFirstFieldOfNextElement=function(c,s,t){var e=c.getFormElements();var L=e.length;var n;var i=s;while(!n&&i<L){var E=e[i];if(t==true){n=this.findNextFieldOfElement(E,0,true);}else{n=this.findNextFieldOfElement(E,0);}i++;}return n;};
a.prototype.findFirstFieldOfForm=function(f){var n=this.findFirstFieldOfFirstElementInNextContainer(f,0);return n;};
a.prototype.findFirstFieldOfLastContainerOfForm=function(f){var n;var c=f.getFormContainers();var i=c.length;while(!n&&i>0){var p=c[i-1];if(!p.getExpandable()||p.getExpanded()){n=this.findFirstFieldOfFirstElementInPrevContainer(f,i-1);}i=i-1;}return n;};
a.prototype.findFirstFieldOfFirstElementInNextContainer=function(f,s,t){var c=f.getFormContainers();var L=c.length;var n;var i=s;while(!n&&i<L){var o=c[i];if(o.getExpandable()&&t){n=o._oExpandButton.getFocusDomRef();if(n){break;}}if(!o.getExpandable()||o.getExpanded()){if(t==true){n=this.findFirstFieldOfNextElement(o,0,true);}else{n=this.findFirstFieldOfNextElement(o,0);}}i++;}return n;};
a.prototype.findFirstFieldOfFirstElementInPrevContainer=function(f,s){var c=f.getFormContainers();var L=c.length;var n;var i=s;while(!n&&i<L&&i>=0){var o=c[i];if(!o.getExpandable()||o.getExpanded()){n=this.findFirstFieldOfNextElement(o,0);}i++;}return n;};
a.prototype.navigateBack=function(e){var f;var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E.isA("sap.ui.layout.form.FormElement")){if(c==E.getLabelControl()){i=0;}else{i=E.indexOfField(c);}n=this.findPrevFieldOfElement(E,i-1);if(!n){var o=E.getParent();i=o.indexOfFormElement(E);n=this.findLastFieldOfPrevElement(o,i-1);if(!n){f=o.getParent();i=f.indexOfFormContainer(o);n=this.findLastFieldOfLastElementInPrevContainer(f,i-1);}}}else if(E&&E.isA("sap.ui.layout.form.FormContainer")){f=E.getParent();i=f.indexOfFormContainer(E);n=this.findLastFieldOfLastElementInPrevContainer(f,i-1);}if(n){n.focus();e.preventDefault();}};
a.prototype.tabBack=function(e){var f;var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E.isA("sap.ui.layout.form.FormElement")){if(c==E.getLabelControl()){i=0;}else{i=E.indexOfField(c);}n=this.findPrevFieldOfElement(E,i-1,true);if(!n){var o=E.getParent();i=o.indexOfFormElement(E);n=this.findLastFieldOfPrevElement(o,i-1,true);if(!n){f=o.getParent();i=f.indexOfFormContainer(o);if(o.getExpandable()){n=o._oExpandButton.getFocusDomRef();}if(!n){n=this.findLastFieldOfLastElementInPrevContainer(f,i-1,true);}}}}else if(E&&E.isA("sap.ui.layout.form.FormContainer")){f=E.getParent();i=f.indexOfFormContainer(E);n=this.findLastFieldOfLastElementInPrevContainer(f,i-1,true);}if(n){n.focus();e.preventDefault();}};
a.prototype.findPrevFieldOfElement=function(e,s,t){var f=e.getFields();var n;for(var i=s;i>=0;i--){var o=f[i];var d=this._getDomRef(o);if(t==true){if((!o.getEditable||o.getEditable())&&(!o.getEnabled||o.getEnabled())&&d){n=d;break;}}else{if((!o.getEnabled||o.getEnabled())&&d){n=d;break;}}}return n;};
a.prototype.findLastFieldOfPrevElement=function(c,s,t){var e=c.getFormElements();var n;var i=s;while(!n&&i>=0){var E=e[i];var L=E.getFields().length;if(t==true){n=this.findPrevFieldOfElement(E,L-1,true);}else{n=this.findPrevFieldOfElement(E,L-1);}i--;}return n;};
a.prototype.findLastFieldOfLastElementInPrevContainer=function(f,s,t){var c=f.getFormContainers();var n;var i=s;while(!n&&i>=0){var o=c[i];if(o.getExpandable()&&!o.getExpanded()&&t){n=o._oExpandButton.getFocusDomRef();if(n){break;}}if(!o.getExpandable()||o.getExpanded()){var L=o.getFormElements().length;if(t==true){n=this.findLastFieldOfPrevElement(o,L-1,true);}else{n=this.findLastFieldOfPrevElement(o,L-1,0);}}i--;}return n;};
a.prototype.findFieldBelow=function(c,e){var o=e.getParent();var i=o.indexOfFormElement(e);var n=this.findFirstFieldOfNextElement(o,i+1);if(!n){var f=o.getParent();i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1);}return n;};
a.prototype.findFieldAbove=function(c,e){var o=e.getParent();var b=o.indexOfFormElement(e);var E=o.getFormElements();var n;var i=b-1;while(!n&&i>=0){var m=E[i];n=this.findPrevFieldOfElement(m,0);i--;}if(!n){var f=o.getParent();b=f.indexOfFormContainer(o);n=this.findLastFieldOfLastElementInPrevContainer(f,b-1);}return n;};
a.prototype._getDomRef=function(c){var d=c.getFocusDomRef();if(!q(d).is(":sapFocusable")){d=undefined;}return d;};
a.prototype.getContainerRenderedDomRef=function(c){if(this.getDomRef()){return(c.getId()?window.document.getElementById(c.getId()):null);}else{return null;}};
a.prototype.getElementRenderedDomRef=function(e){if(this.getDomRef()){return(e.getId()?window.document.getElementById(e.getId()):null);}else{return null;}};
return a;});
sap.ui.predefine('sap/ui/layout/form/FormLayoutRenderer',['sap/ui/core/library','sap/ui/core/theming/Parameters','sap/ui/layout/library','sap/ui/layout/form/Form'],function(c,t,l,F){"use strict";var T=c.TitleLevel;var B=l.BackgroundDesign;var a={};
a.render=function(r,L){var b=r;var f=L.getParent();if(f&&f instanceof F){this.renderForm(b,L,f);}};
a.renderForm=function(r,L,f){var o=f.getToolbar();r.write("<div");r.writeControlData(L);r.addClass(this.getMainClass());if(o){r.addClass("sapUiFormToolbar");}this.addBackgroundClass(r,L);r.writeClasses();r.write(">");var s;if(!o){s=t.get('sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormTitleSize');}this.renderHeader(r,o,f.getTitle(),undefined,false,s,f.getId());this.renderContainers(r,L,f);r.write("</div>");};
a.getMainClass=function(){return"sapUiFormLayout";};
a.addBackgroundClass=function(r,L){var b=L.getBackgroundDesign();if(b!=B.Transparent){r.addClass("sapUiFormBackgr"+b);}};
a.renderContainers=function(r,L,f){var C=f.getVisibleFormContainers();for(var i=0,b=C.length;i<b;i++){var o=C[i];this.renderContainer(r,L,o);}};
a.renderContainer=function(r,L,C){var e=C.getExpandable();var o=C.getToolbar();var b=C.getTitle();r.write("<section");r.writeElementData(C);r.addClass("sapUiFormContainer");if(o){r.addClass("sapUiFormContainerToolbar");}else if(b){r.addClass("sapUiFormContainerTitle");}if(C.getTooltip_AsString()){r.writeAttributeEscaped('title',C.getTooltip_AsString());}r.writeClasses();this.writeAccessibilityStateContainer(r,C);r.write(">");this.renderHeader(r,o,b,C._oExpandButton,e,T.H4,C.getId());if(e){r.write("<div id='"+C.getId()+"-content'");if(!C.getExpanded()){r.addStyle("display","none");r.writeStyles();}r.write(">");}var E=C.getVisibleFormElements();for(var j=0,d=E.length;j<d;j++){var f=E[j];this.renderElement(r,L,f);}if(e){r.write("</div>");}r.write("</section>");};
a.renderElement=function(r,L,e){var o=e.getLabelControl();r.write("<div");r.writeElementData(e);r.addClass("sapUiFormElement");if(o){r.addClass("sapUiFormElementLbl");}r.writeClasses();r.write(">");if(o){r.renderControl(o);}var f=e.getFields();if(f&&f.length>0){for(var k=0,b=f.length;k<b;k++){var d=f[k];r.renderControl(d);}}r.write("</div>");};
a.renderTitle=function(r,o,e,E,L,C){if(o){var s=t.get('sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormSubTitleSize');if(L){s=L;}if(typeof o!=="string"&&o.getLevel()!=T.Auto){s=o.getLevel();}r.write("<"+s+" ");r.addClass("sapUiFormTitle");r.addClass("sapUiFormTitle"+s);if(typeof o!=="string"){r.writeElementData(o);if(o.getTooltip_AsString()){r.writeAttributeEscaped('title',o.getTooltip_AsString());}if(o.getEmphasized()){r.addClass("sapUiFormTitleEmph");}}else{r.writeAttribute("id",C+"--title");}r.writeClasses();r.write(">");if(E&&e){r.renderControl(e);}if(typeof o==="string"){r.writeEscaped(o,true);}else{var i=o.getIcon();if(i){var b=[];var A={"title":null};A["id"]=o.getId()+"-ico";r.writeIcon(i,b,A);}r.writeEscaped(o.getText(),true);}r.write("</"+s+">");}};
a.renderHeader=function(r,o,b,e,E,L,C){if(o){r.renderControl(o);}else{this.renderTitle(r,b,e,E,L,C);}};
a.writeAccessibilityStateContainer=function(r,C){var A={};var o=C.getTitle();var b=C.getToolbar();if(b){if(!C.getAriaLabelledBy()||C.getAriaLabelledBy().length==0){A["labelledby"]={value:b.getId(),append:true};}}else if(o){var i="";if(typeof o=="string"){i=C.getId()+"--title";}else{i=o.getId();}A["labelledby"]={value:i,append:true};}if(A["labelledby"]||C.getAriaLabelledBy().length>0){A["role"]="form";}r.writeAccessibilityState(C,A);};
return a;},true);
sap.ui.predefine('sap/ui/layout/form/FormRenderer',['sap/ui/layout/library',"sap/base/Log"],function(l,L){"use strict";var F={};
F.render=function(r,f){var a=r;var o=f.getLayout();var A={role:"form"};a.write("<div");a.writeControlData(f);a.addClass("sapUiForm");a.addClass("sapUiFormLblColon");a.writeAttribute("data-sap-ui-customfastnavgroup","true");var c=l.form.FormHelper.addFormClass();if(c){a.addClass(c);}if(f.getEditable()){a.addClass("sapUiFormEdit");a.addClass("sapUiFormEdit-CTX");}else{A.readonly="";}if(f.getWidth()){a.addStyle("width",f.getWidth());}if(f.getTooltip_AsString()){a.writeAttributeEscaped('title',f.getTooltip_AsString());}a.writeClasses();a.writeStyles();var t=f.getTitle();var T=f.getToolbar();if(T){if(!f.getAriaLabelledBy()||f.getAriaLabelledBy().length==0){A["labelledby"]=T.getId();}}else if(t){var i="";if(typeof t=="string"){i=f.getId()+"--title";}else{i=t.getId();}A["labelledby"]={value:i,append:true};}else if(f._sSuggestedTitleId){A["labelledby"]={value:f._sSuggestedTitleId,append:true};}a.writeAccessibilityState(f,A);a.write(">");if(o){a.renderControl(o);}else{L.warning("Form \""+f.getId()+"\" - Layout missing!","Renderer","Form");}a.write("</div>");};
return F;},true);
sap.ui.predefine('sap/ui/layout/form/GridContainerData',['sap/ui/core/LayoutData','sap/ui/layout/library'],function(L,l){"use strict";
var G=L.extend("sap.ui.layout.form.GridContainerData",{metadata:{library:"sap.ui.layout",properties:{halfGrid:{type:"boolean",group:"Misc",defaultValue:false}}}});
return G;});
sap.ui.predefine('sap/ui/layout/form/GridElementData',['sap/ui/core/LayoutData','sap/ui/layout/library'],function(L,l){"use strict";
var G=L.extend("sap.ui.layout.form.GridElementData",{metadata:{library:"sap.ui.layout",properties:{hCells:{type:"sap.ui.layout.form.GridElementCells",group:"Appearance",defaultValue:'auto'},vCells:{type:"int",group:"Appearance",defaultValue:1}}}});
return G;});
sap.ui.predefine('sap/ui/layout/form/GridLayout',['sap/ui/layout/library','./FormLayout','./GridLayoutRenderer'],function(l,F,G){"use strict";
var a=F.extend("sap.ui.layout.form.GridLayout",{metadata:{library:"sap.ui.layout",properties:{singleColumn:{type:"boolean",group:"Misc",defaultValue:false}}}});
a.prototype.toggleContainerExpanded=function(c){this.invalidate();};
a.prototype.onAfterRendering=function(){var f=this.getParent();if(f){var c=f.getVisibleFormContainers();for(var i=0;i<c.length;i++){var C=c[i];if(C.getExpandable()&&C._oExpandButton){C._oExpandButton.$().attr("tabindex","-1");}}}};
a.prototype.onLayoutDataChange=function(e){if(this.getDomRef()){this.invalidate();}};
a.prototype.onsaptabnext=function(e){this.tabForward(e);};
a.prototype.onsaptabprevious=function(e){this.tabBack(e);};
a.prototype.findFieldOfElement=function(e,s,L){if(!L){return F.prototype.findPrevFieldOfElement.apply(this,arguments);}if(!e.isVisible()){return null;}var f=e.getFields();var n;var I=f.length;s=I-1;for(var i=s;i>=0;i--){var o=f[i];var b=o.$().offset().left;if(L<b&&i!=0){continue;}var d=this._getDomRef(o);if((!o.getEnabled||o.getEnabled())&&d){n=d;break;}}return n;};
a.prototype.findFieldBelow=function(c,e){var C=e.getParent();var b=C.indexOfFormElement(e);var n;if(C.isVisible()){var E=C.getFormElements();var m=E.length;var i=b+1;var L=c.$().offset().left;while(!n&&i<m){var N=E[i];n=this.findFieldOfElement(N,0,L);i++;}}if(!n){var f=C.getParent();b=f.indexOfFormContainer(C);n=this.findFirstFieldOfFirstElementInNextContainer(f,b+1);}return n;};
a.prototype.findFieldAbove=function(c,e){var C=e.getParent();var b=C.indexOfFormElement(e);var n;if(C.isVisible()){var E=C.getFormElements();var i=b-1;var L=c.$().offset().left;while(!n&&i>=0){var N=E[i];n=this.findFieldOfElement(N,0,L);i--;}}if(!n){var f=C.getParent();b=f.indexOfFormContainer(C);n=this.findLastFieldOfLastElementInPrevContainer(f,b-1);}return n;};
a.prototype.getContainerRenderedDomRef=function(c){return null;};
a.prototype.getElementRenderedDomRef=function(e){if(this.getDomRef()){var s=this.getSingleColumn();var c=e.getParent();var C=this.getLayoutDataForElement(c,"sap.ui.layout.form.GridContainerData");if((s||!C||!C.getHalfGrid())&&!this.getRenderer().checkFullSizeElement(this,e)){return(e.getId()?window.document.getElementById(e.getId()):null);}}return null;};
return a;});
sap.ui.predefine('sap/ui/layout/form/GridLayoutRenderer',['sap/ui/core/Renderer','sap/ui/core/theming/Parameters','./FormLayoutRenderer',"sap/base/Log"],function(R,t,F,L){"use strict";var G=R.extend(F);
G.renderForm=function(r,l,f){var s=l.getSingleColumn();var c=16;var S=false;var C=0;var a=f.getFormContainers();var b=a.length;var i=0;var o;var d;var T=f.getToolbar();var e=f.getTitle();if(s){c=c/2;C=c;}else{C=c/2;for(i=0;i<b;i++){d=this.getContainerData(l,a[i]);if(d&&d.getHalfGrid()){S=true;break;}}}r.write("<table role=\"presentation\"");r.writeControlData(l);r.write(" cellpadding=\"0\" cellspacing=\"0\"");r.addStyle("border-collapse","collapse");r.addStyle("table-layout","fixed");r.addStyle("width","100%");r.addClass("sapUiGrid");this.addBackgroundClass(r,l);if(T){r.addClass("sapUiFormToolbar");}r.writeStyles();r.writeClasses();r.write(">");r.write("<colgroup>");r.write("<col span="+C+">");if(S){r.write("<col class = \"sapUiGridSpace\"span=1>");}if(!s){r.write("<col span="+C+">");}r.write("</colgroup><tbody>");if(T||e){var g=c;if(S){g++;}r.write("<tr class=\"sapUiGridTitle\"><th colspan="+g+">");var h;if(!T){h=t.get('sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormTitleSize');}this.renderHeader(r,T,e,undefined,false,h,f.getId());r.write("</th></tr>");}i=0;var j;var k;while(i<b){o=a[i];o._checkProperties();if(o.isVisible()){d=this.getContainerData(l,o);if(d&&d.getHalfGrid()&&!s){j=a[i+1];k=undefined;if(j&&j.isVisible()){k=this.getContainerData(l,j);}if(k&&k.getHalfGrid()){j._checkProperties();this.renderContainerHalfSize(r,l,o,j,c);i++;}else{this.renderContainerHalfSize(r,l,o,undefined,c);}}else{this.renderContainerFullSize(r,l,o,c,S);}}i++;}r.write("</tbody></table>");};
G.renderContainerFullSize=function(r,l,c,C,s){var e=c.getExpandable();var T=c.getTooltip_AsString();var o=c.getToolbar();var a=c.getTitle();if(o||a){var b=C;if(s){b++;}r.write("<tr class=\"sapUiGridConteinerFirstRow sapUiGridConteinerHeaderRow\"><td colspan="+b);r.addClass("sapUiGridHeader");if(T){r.writeAttributeEscaped('title',T);}if(o){r.addClass("sapUiFormContainerToolbar");}else if(a){r.addClass("sapUiFormContainerTitle");}r.writeClasses();r.write(">");this.renderHeader(r,o,c.getTitle(),c._oExpandButton,e,false,c.getId());r.write("</td></tr>");}if(!e||c.getExpanded()){var E=c.getFormElements();var d;var f=[];var g;var h=false;for(var j=0,k=E.length;j<k;j++){d=E[j];if(d.isVisible()){g=f[0]&&(f[0][0]==C);r.write("<tr");if(!h){h=true;if(!o&&!a){r.addClass("sapUiGridConteinerFirstRow");}}if(!this.checkFullSizeElement(l,d)&&f[0]!="full"&&!g){r.writeElementData(d);r.addClass("sapUiFormElement");}r.writeClasses();r.write(">");if(!g){f=this.renderElement(r,l,d,false,C,s,f);}else{f.splice(0,1);}r.write("</tr>");if(f[0]=="full"||g){j=j-1;}}}if(f.length>0){for(var i=0;i<f.length;i++){r.write("<tr></tr>");}}}};
G.renderContainerHalfSize=function(r,l,c,C,a){var b=a/2;var e=c.getExpandable();var T=c.getTooltip_AsString();var s;var o=c.getTitle();var d;var f=c.getToolbar();var g;var E=[];if(!e||c.getExpanded()){E=c.getFormElements();}var h=E.length;var j=[];var k=0;var m=false;if(C){m=C.getExpandable();s=C.getTooltip_AsString();d=C.getTitle();g=C.getToolbar();if(!m||C.getExpanded()){j=C.getFormElements();}k=j.length;}if(o||d||f||g){r.write("<tr class=\"sapUiGridConteinerFirstRow sapUiGridConteinerHeaderRow\"><td colspan="+b);r.addClass("sapUiGridHeader");if(T){r.writeAttributeEscaped('title',T);}if(f){r.addClass("sapUiFormContainerToolbar");}else if(o){r.addClass("sapUiFormContainerTitle");}r.writeClasses();r.write(">");if(c){this.renderHeader(r,f,o,c._oExpandButton,e,false,c.getId());}r.write("</td><td></td><td colspan="+b);r.addClass("sapUiGridHeader");if(s){r.writeAttributeEscaped('title',s);}if(g){r.addClass("sapUiFormContainerToolbar");}else if(d){r.addClass("sapUiFormContainerTitle");}r.writeClasses();r.write(">");if(C){this.renderHeader(r,g,d,C._oExpandButton,m,false,C.getId());}r.write("</td></tr>");}if((!e||c.getExpanded())||(!m||C.getExpanded())){var n=[],p=[];var q=0,u=0;var v;var w;var x;var y;var z=false;while(q<h||u<k){v=E[q];w=j[u];x=n[0]&&(n[0][0]==b);y=p[0]&&(p[0][0]==b);if((v&&v.isVisible())||(w&&w.isVisible())||x||y){r.write("<tr");if(!z){z=true;if(!f&&!o&&!g&&!d){r.addClass("sapUiGridConteinerFirstRow");}}r.writeClasses();r.write(">");if(!x){if(v&&v.isVisible()&&(!e||c.getExpanded())){n=this.renderElement(r,l,v,true,b,false,n);}else{r.write("<td colspan="+b+"></td>");}if(n[0]!="full"){q++;}}else{if(n[0][2]>0){r.write("<td colspan="+n[0][2]+"></td>");}n.splice(0,1);}r.write("<td></td>");if(!y){if(w&&w.isVisible()&&(!m||C.getExpanded())){p=this.renderElement(r,l,w,true,b,false,p);}else{r.write("<td colspan="+b+"></td>");}if(p[0]!="full"){u++;}}else{if(p[0][2]>0){r.write("<td colspan="+p[0][2]+"></td>");}p.splice(0,1);}r.write("</tr>");}else{q++;u++;}}if(n.length>0||p.length>0){for(var i=0;i<n.length||i<p.length;i++){r.write("<tr></tr>");}}}};
G.renderElement=function(r,l,e,h,c,s,a){var o=e.getLabelControl();var b=0;var f=e.getFields();var C=0;var A=0;var m=false;var d=1;var g=1;var x=0;if(this.checkFullSizeElement(l,e)){if(a.length>0&&a[0]!="full"){L.error("Element \""+e.getId()+"\" - Too much fields for one row!","Renderer","GridLayout");return a;}if(s){c=c+1;}if(o&&a[0]!="full"){r.write("<td colspan="+c+" class=\"sapUiFormElementLbl sapUiGridLabelFull\">");r.renderControl(o);r.write("</td>");return["full"];}else{a.splice(0,1);g=this.getElementData(l,f[0]).getVCells();r.write("<td colspan="+c);if(g>1&&h){r.write(" rowspan="+g);for(x=0;x<g-1;x++){a.push([c,undefined,false]);}}r.write(" >");r.renderControl(f[0]);r.write("</td>");return a;}}if(a.length>0&&a[0][0]>0){c=c-a[0][0]+a[0][2];m=a[0][1];b=a[0][2];a.splice(0,1);}var j=b;var E;var k="";if(o||b>0){j=3;if(o&&b==0){E=this.getElementData(l,o);if(E){k=E.getHCells();if(k!="auto"&&k!="full"){j=parseInt(k);}}}r.write("<td colspan="+j+" class=\"sapUiFormElementLbl\">");if(o){r.renderControl(o);}c=c-j;r.write("</td>");}if(f&&f.length>0){var n=c;var p=f.length;var q;var i=0;var u=0;for(i=0,u=f.length;i<u;i++){q=f[i];E=this.getElementData(l,q);if(E&&E.getHCells()!="auto"){n=n-parseInt(E.getHCells());p=p-1;}}var v=0;for(i=0,v=0,u=f.length;i<u;i++){q=f[i];E=this.getElementData(l,q);k="auto";d=1;g=1;if(E){k=E.getHCells();g=E.getVCells();}if(k=="auto"){if(n>0){d=Math.floor(n/p);if(d<1){d=1;}v++;A=A+d;if((v==p)&&(n>A)){d=d+(n-A);}}else{d=1;}}else{d=parseInt(k);}C=C+d;if(C>c){L.error("Element \""+e.getId()+"\" - Too much fields for one row!","Renderer","GridLayout");C=C-d;break;}if(g>1){for(x=0;x<g-1;x++){if(o){b=j;}if(a.length>x){a[x][0]=a[x][0]+d;a[x][2]=b;}else{a.push([j+d,undefined,b]);}}}if(s&&C>=Math.floor(c/2)&&!m){d=d+1;m=true;if(g>1){for(x=0;x<g-1;x++){a[x][1]=true;}}}r.write("<td");if(d>1){r.write(" colspan="+d);}if(g>1){r.write(" rowspan="+g);}r.write(" >");r.renderControl(q);r.write("</td>");}}if(C<c){var w=c-C;if(!h&&s&&!m){w++;}r.write("<td colspan="+w+" ></td>");}return a;};
G.checkFullSizeElement=function(l,e){var f=e.getFields();if(f.length==1&&this.getElementData(l,f[0])&&this.getElementData(l,f[0]).getHCells()=="full"){return true;}else{return false;}};
G.getContainerData=function(l,c){return l.getLayoutDataForElement(c,"sap.ui.layout.form.GridContainerData");};
G.getElementData=function(l,c){return l.getLayoutDataForElement(c,"sap.ui.layout.form.GridElementData");};
return G;},true);
sap.ui.predefine('sap/ui/layout/form/ResponsiveGridLayout',['sap/ui/core/Control','sap/ui/core/ResizeHandler','sap/ui/layout/library','sap/ui/layout/Grid','sap/ui/layout/GridData','./Form','./FormContainer','./FormElement','./FormLayout','./ResponsiveGridLayoutRenderer',"sap/ui/thirdparty/jquery"],function(C,R,l,G,a,F,b,c,d,e,q){"use strict";
var f=d.extend("sap.ui.layout.form.ResponsiveGridLayout",{metadata:{library:"sap.ui.layout",properties:{labelSpanXL:{type:"int",group:"Misc",defaultValue:-1},labelSpanL:{type:"int",group:"Misc",defaultValue:4},labelSpanM:{type:"int",group:"Misc",defaultValue:2},labelSpanS:{type:"int",group:"Misc",defaultValue:12},adjustLabelSpan:{type:"boolean",group:"Misc",defaultValue:true},emptySpanXL:{type:"int",group:"Misc",defaultValue:-1},emptySpanL:{type:"int",group:"Misc",defaultValue:0},emptySpanM:{type:"int",group:"Misc",defaultValue:0},emptySpanS:{type:"int",group:"Misc",defaultValue:0},columnsXL:{type:"int",group:"Misc",defaultValue:-1},columnsL:{type:"int",group:"Misc",defaultValue:2},columnsM:{type:"int",group:"Misc",defaultValue:1},singleContainerFullSize:{type:"boolean",group:"Misc",defaultValue:true},breakpointXL:{type:"int",group:"Misc",defaultValue:1440},breakpointL:{type:"int",group:"Misc",defaultValue:1024},breakpointM:{type:"int",group:"Misc",defaultValue:600}}}});
var P=C.extend("sap.ui.layout.form.ResponsiveGridLayoutPanel",{
metadata:{aggregations:{"content":{type:"sap.ui.layout.Grid",multiple:false}},associations:{"container":{type:"sap.ui.layout.form.FormContainer",multiple:false},"layout":{type:"sap.ui.layout.form.ResponsiveGridLayout",multiple:false}}},
getLayoutData:function(){var i=sap.ui.getCore().byId(this.getContainer());var L=sap.ui.getCore().byId(this.getLayout());var j;if(L&&i){j=L.getLayoutDataForElement(i,"sap.ui.layout.GridData");}if(j){return j;}else{return this.getAggregation("layoutData");}},
getCustomData:function(){var i=sap.ui.getCore().byId(this.getContainer());if(i){return i.getCustomData();}},
refreshExpanded:function(){var i=sap.ui.getCore().byId(this.getContainer());if(i){if(i.getExpanded()){this.$().removeClass("sapUiRGLContainerColl");}else{this.$().addClass("sapUiRGLContainerColl");}}},
renderer:function(i,j){var s=sap.ui.getCore().byId(j.getContainer());var L=sap.ui.getCore().byId(j.getLayout());var t=j.getContent();var E=s.getExpandable();var T=s.getTooltip_AsString();var u=s.getToolbar();var v=s.getTitle();i.write("<div");i.writeControlData(j);i.addClass("sapUiRGLContainer");if(E&&!s.getExpanded()){i.addClass("sapUiRGLContainerColl");}if(u){i.addClass("sapUiFormContainerToolbar");}else if(v){i.addClass("sapUiFormContainerTitle");}if(T){i.writeAttributeEscaped('title',T);}i.writeClasses();L.getRenderer().writeAccessibilityStateContainer(i,s);i.write(">");L.getRenderer().renderHeader(i,u,v,s._oExpandButton,E,false,s.getId());if(t){i.write("<div");i.addClass("sapUiRGLContainerCont");i.writeClasses();i.write(">");i.renderControl(t);i.write("</div>");}i.write("</div>");}
});
f.prototype.init=function(){this.mContainers={};this.oDummyLayoutData=new a(this.getId()+"--Dummy");};
f.prototype.exit=function(){for(var s in this.mContainers){p.call(this,s,true);}if(this._mainGrid){this._mainGrid.destroy();delete this._mainGrid;}this.oDummyLayoutData.destroy();this.oDummyLayoutData=undefined;};
f.prototype.onBeforeRendering=function(E){var i=this.getParent();if(!i||!(i instanceof F)){return;}i._bNoInvalidate=true;_.call(this,i);r.call(this,i);i._bNoInvalidate=false;};
f.prototype.onAfterRendering=function(E){if(this._mainGrid&&this._mainGrid.__bIsUsed){for(var s in this.mContainers){if(this.mContainers[s][1]._sContainerResizeListener){R.deregister(this.mContainers[s][1]._sContainerResizeListener);this.mContainers[s][1]._sContainerResizeListener=null;}}}};
f.prototype.toggleContainerExpanded=function(i){var s=i.getId();if(this.mContainers[s]&&this.mContainers[s][0]){var j=this.mContainers[s][0];j.refreshExpanded();}};
f.prototype.onLayoutDataChange=function(E){var s=E.srcControl;if(s instanceof b){if(this._mainGrid){this._mainGrid.onLayoutDataChange(E);this.invalidate();}}else if(!(s instanceof c)){var i=s.getParent();if(i instanceof c){var j=i.getParent();var t=j.getId();if(this.mContainers[t]&&this.mContainers[t][1]){this.mContainers[t][1].onLayoutDataChange(E);}}}};
f.prototype.onsapup=function(E){this.onsapleft(E);};
f.prototype.onsapdown=function(E){this.onsapright(E);};
f.prototype.getContainerRenderedDomRef=function(i){if(this.getDomRef()){var s=i.getId();if(this.mContainers[s]){if(this.mContainers[s][0]){var j=this.mContainers[s][0];return j.getDomRef();}else if(this.mContainers[s][1]){var t=this.mContainers[s][1];return t.getDomRef();}}}return null;};
f.prototype.getElementRenderedDomRef=function(E){return null;};
function _(j){var v=j.getVisibleFormContainers();var V=v.length;var s=0;var t;var u;var w;var x;var i=0;for(i=0;i<V;i++){w=v[i];w._checkProperties();if(w.isVisible()){s++;x=w.getId();t=undefined;u=undefined;var y=v[i+1];if(this.mContainers[x]&&this.mContainers[x][1]){u=this.mContainers[x][1];}else{u=k.call(this,w);}var T=w.getTitle();var z=w.getToolbar();if(z||T||w.getExpandable()){if(this.mContainers[x]&&this.mContainers[x][0]){t=this.mContainers[x][0];}else{t=g.call(this,w,u);n(u,true);}o(t,w,s,y,V);}else{if(this.mContainers[x]&&this.mContainers[x][0]){h(this.mContainers[x][0]);}n(u,false);o(u,w,s,y,V);}this.mContainers[x]=[t,u];}}var O=Object.keys(this.mContainers).length;if(V<O){for(x in this.mContainers){var A=false;for(i=0;i<V;i++){w=v[i];if(x==w.getId()){A=true;break;}}if(!A){p.call(this,x);}}}}
function g(i,j){var s=i.getId();var t=new P(s+"---Panel",{container:i,layout:this,content:j});return t;}
function h(i,D){i.setLayout(null);i.setContainer(null);if(!D||!i.getParent()){i.setContent(null);i.destroy();}}
function k(t){var I=t.getId()+"--Grid";var u=new G(I,{vSpacing:0,hSpacing:0,containerQuery:true});u.__myParentLayout=this;u.__myParentContainerId=t.getId();u.addStyleClass("sapUiFormResGridCont").addStyleClass("sapUiRespGridOverflowHidden");u.getContent=function(){var t=sap.ui.getCore().byId(this.__myParentContainerId);if(t){var s=[];var E=t.getVisibleFormElements();var w;var y;for(var i=0;i<E.length;i++){var z=E[i];y=z.getLabelControl();if(y){s.push(y);}w=z.getFields();for(var j=0;j<w.length;j++){s.push(w[j]);}}return s;}else{return false;}};u.getAriaLabelledBy=function(){var t=sap.ui.getCore().byId(this.__myParentContainerId);if(t&&!t.getToolbar()&&!t.getTitle()&&!t.getExpandable()){return t.getAriaLabelledBy();}return[];};var B={labelSpan:0,span:0,firstField:false,defaultFields:0,row:0,myRow:false,freeFields:0,finished:false};var x={id:"XL",getEffectiveSpan:function(i){var s=i._getEffectiveSpanXLarge();if(!s){s=i._getEffectiveSpanLarge();}return s;},getEmptySpan:function(i){var E=i.getEmptySpanXL();if(E<0){E=i.getEmptySpanL();}return E;},getLabelSpan:function(i){return i.getLabelSpanXL();},setIndent:function(i,j){i.setIndentXL(j);},setLinebreak:function(i,j){i.setLinebreakXL(j);}};q.extend(x,B);var L={id:"L",getEffectiveSpan:function(i){return i._getEffectiveSpanLarge();},getEmptySpan:function(i){return i.getEmptySpanL();},getLabelSpan:function(i){return i.getLabelSpanL();},setIndent:function(i,j){i.setIndentL(j);},setLinebreak:function(i,j){i.setLinebreakL(j);}};q.extend(L,B);var M={id:"M",getEffectiveSpan:function(i){return i._getEffectiveSpanMedium();},getEmptySpan:function(i){return i.getEmptySpanM();},getLabelSpan:function(i){return i.getLabelSpanM();},setIndent:function(i,j){i.setIndentM(j);},setLinebreak:function(i,j){i.setLinebreakM(j);}};q.extend(M,B);var S={id:"S",getEffectiveSpan:function(i){return i._getEffectiveSpanSmall();},getEmptySpan:function(i){return i.getEmptySpanS();},getLabelSpan:function(i){return i.getLabelSpanS();},setIndent:function(i,j){i.setIndentS(j);},setLinebreak:function(i,j){i.setLinebreakS(j);}};q.extend(S,B);var v=[x,L,M,S];u._getLayoutDataForControl=function(j){var w=this.__myParentLayout;var y=w.getLayoutDataForElement(j,"sap.ui.layout.GridData");var E=j.getParent();var z=E.getLabelControl();if(y){if(z==j){y._setStylesInternal("sapUiFormElementLbl");}return y;}else{var t=sap.ui.getCore().byId(this.__myParentContainerId);var A=w.getLayoutDataForElement(t,"sap.ui.layout.GridData");var D=t.getParent();var H;var s=0;for(s=0;s<v.length;s++){H=v[s];q.extend(H,B);H.labelSpan=H.getLabelSpan(w);}if(w.getAdjustLabelSpan()){if(D.getVisibleFormContainers().length>=1&&w.getColumnsM()>1){M.labelSpan=w.getLabelSpanL();}if(A){if(A._getEffectiveSpanLarge()==12){L.labelSpan=w.getLabelSpanM();M.labelSpan=w.getLabelSpanM();}}if(D.getVisibleFormContainers().length==1||w.getColumnsL()==1){L.labelSpan=w.getLabelSpanM();M.labelSpan=w.getLabelSpanM();}}if(x.labelSpan<0){x.labelSpan=L.labelSpan;}if(z==j){w.oDummyLayoutData.setSpan("XL"+x.labelSpan+" L"+L.labelSpan+" M"+M.labelSpan+" S"+S.labelSpan);w.oDummyLayoutData.setLinebreak(true);w.oDummyLayoutData.setIndentXL(0).setIndentL(0).setIndentM(0).setIndentS(0);w.oDummyLayoutData._setStylesInternal("sapUiFormElementLbl");return w.oDummyLayoutData;}else{var J;if(z){J=w.getLayoutDataForElement(z,"sap.ui.layout.GridData");}var K=E.getFields();var N=K.length;var O;var Q;var T=1;var U=false;var V;var i=0;for(s=0;s<v.length;s++){H=v[s];H.span=12-H.getEmptySpan(w);if(z){if(J){V=H.getEffectiveSpan(J);if(V){H.labelSpan=V;}}if(H.labelSpan<12){H.span=H.span-H.labelSpan;}}H.spanFields=H.span;}for(i=0;i<N;i++){O=K[i];if(O!=j){Q=w.getLayoutDataForElement(O,"sap.ui.layout.GridData");if(Q){for(s=0;s<v.length;s++){H=v[s];V=H.getEffectiveSpan(Q);if(V&&V<H.span){H.span=H.span-V;}}}else{T++;}}else{if(T==1){U=true;}}}var W=[];for(s=0;s<v.length;s++){H=v[s];H.firstField=U;H.defaultFields=T;if(H.span<T){H.defaultFields=0;H.row=0;H.myRow=false;H.freeFields=H.spanFields;H.span=H.spanFields;H.finished=false;W.push(H);}}if(W.length>0){for(i=0;i<N;i++){O=K[i];Q=undefined;if(O!=j){Q=w.getLayoutDataForElement(O,"sap.ui.layout.GridData");}for(s=0;s<W.length;s++){H=W[s];if(H.finished){continue;}if(Q){V=H.getEffectiveSpan(Q);H.span=H.span-V;}else{V=1;}if(H.freeFields>=V){H.freeFields=H.freeFields-V;if(!Q){H.defaultFields++;}}else{if(H.myRow){H.finished=true;}else{H.freeFields=H.spanFields-V;H.row++;if(Q){H.defaultFields=0;H.span=H.spanFields-V;}else{H.defaultFields=1;H.span=H.spanFields;}if(O==j){H.firstField=true;}}}if(O==j){H.myRow=true;}}}}var X=0;var Y="";var Z;for(s=0;s<v.length;s++){H=v[s];if(H.id!="S"||H.labelSpan<12){if(H.firstField){X=H.span-Math.floor(H.span/H.defaultFields)*H.defaultFields;Z=Math.floor(H.span/H.defaultFields)+X;}else{Z=Math.floor(H.span/H.defaultFields);}}else{Z=12;}if(Y){Y=Y+" ";}Y=Y+H.id+Z;H.setLinebreak(w.oDummyLayoutData,H.firstField&&(H.row>0));H.setIndent(w.oDummyLayoutData,H.firstField&&(H.row>0)?H.labelSpan:0);}w.oDummyLayoutData.setSpan(Y);w.oDummyLayoutData.setLinebreak(U&&!z);w.oDummyLayoutData._setStylesInternal(undefined);return w.oDummyLayoutData;}return y;}};u._onParentResizeOrig=u._onParentResize;u._onParentResize=function(){if(!this.getDomRef()){this._cleanup();return;}if(!q(this.getDomRef()).is(":visible")){return;}var j=this.__myParentLayout;if(!j._mainGrid||!j._mainGrid.__bIsUsed){var s=j.getParent().getVisibleFormContainers();var w;for(var i=0;i<s.length;i++){w=s[i];break;}if(!w||!j.mContainers[w.getId()]||w.getId()!=this.__myParentContainerId){return;}if(j.mContainers[this.__myParentContainerId][0]){var D=j.mContainers[this.__myParentContainerId][0].getDomRef();var y=D.clientWidth;if(y<=j.getBreakpointM()){this._toggleClass("Phone");}else if((y>j.getBreakpointM())&&(y<=j.getBreakpointL())){this._toggleClass("Tablet");}else if((y>j.getBreakpointL())&&(y<=j.getBreakpointXL())){this._toggleClass("Desktop");}else{this._toggleClass("LargeDesktop");}}else{this._setBreakPointTablet(j.getBreakpointM());this._setBreakPointDesktop(j.getBreakpointL());this._setBreakPointLargeDesktop(j.getBreakpointXL());this._onParentResizeOrig();}}else{var $=j._mainGrid.$();if($.hasClass("sapUiRespGridMedia-Std-Phone")){this._toggleClass("Phone");}else if($.hasClass("sapUiRespGridMedia-Std-Tablet")){this._toggleClass("Tablet");}else if($.hasClass("sapUiRespGridMedia-Std-Desktop")){this._toggleClass("Desktop");}else{this._toggleClass("LargeDesktop");}}};u._getAccessibleRole=function(){var t=sap.ui.getCore().byId(this.__myParentContainerId);var i=this.__myParentLayout;if(i._mainGrid&&i._mainGrid.__bIsUsed&&!t.getToolbar()&&!t.getTitle()&&!t.getExpandable()&&t.getAriaLabelledBy().length>0){return"form";}};u.getUIArea=function(){var i=this.__myParentLayout;if(i){return i.getUIArea();}else{return null;}};return u;}
function m(i,D){if(i.__myParentContainerId){i.__myParentContainerId=undefined;}i.__myParentLayout=undefined;if(!D||!i.getParent()){i.destroy();}}
function n(i,O){if(O){if(i.__originalGetLayoutData){i.getLayoutData=i.__originalGetLayoutData;delete i.__originalGetLayoutData;}}else if(!i.__originalGetLayoutData){i.__originalGetLayoutData=i.getLayoutData;i.getLayoutData=function(){var L=this.__myParentLayout;var j=sap.ui.getCore().byId(this.__myParentContainerId);var s;if(j){s=L.getLayoutDataForElement(j,"sap.ui.layout.GridData");}if(s){return s;}else{return this.getAggregation("layoutData");}};}}
function o(i,j,v,s,V){var L;if(i instanceof P){L=sap.ui.getCore().byId(i.getLayout());}else{L=i.__myParentLayout;}var t=L.getLayoutDataForElement(j,"sap.ui.layout.GridData");if(!t){var u=L.getColumnsM();var w=L.getColumnsL();var x=L.getColumnsXL();var y=(v%w)==1;var z=(v%w)==0;var A=v>(w*(Math.ceil(V/w)-1));var B=v<=w;var D=(v%u)==1;var E=(v%u)==0;var H=v>(u*(Math.ceil(V/u)-1));var I=v<=u;var J=false;var K=z;var M=A;var N=B;if(x>0){J=(v%x)==1;K=(v%x)==0;M=v>(x*(Math.ceil(V/x)-1));N=v<=x;}if(s){var O=L.getLayoutDataForElement(s,"sap.ui.layout.GridData");if(O&&(O.getLinebreak()||O.getLinebreakXL())){K=true;M=false;}if(O&&(O.getLinebreak()||O.getLinebreakL())){z=true;A=false;}if(O&&(O.getLinebreak()||O.getLinebreakM())){E=true;H=false;}}var S="";if(K){S="sapUiFormResGridLastContXL";}if(z){if(S){S=S+" ";}S=S+"sapUiFormResGridLastContL";}if(E){if(S){S=S+" ";}S=S+"sapUiFormResGridLastContM";}if(M){if(S){S=S+" ";}S=S+"sapUiFormResGridLastRowXL";}if(A){if(S){S=S+" ";}S=S+"sapUiFormResGridLastRowL";}if(H){if(S){S=S+" ";}S=S+"sapUiFormResGridLastRowM";}if(N){if(S){S=S+" ";}S=S+"sapUiFormResGridFirstRowXL";}if(B){if(S){S=S+" ";}S=S+"sapUiFormResGridFirstRowL";}if(I){if(S){S=S+" ";}S=S+"sapUiFormResGridFirstRowM";}t=i.getLayoutData();if(!t){t=new a(i.getId()+"--LD",{linebreakL:y,linebreakM:D});i.setLayoutData(t);}else{t.setLinebreakL(y);t.setLinebreakM(D);}if(x>0){t.setLinebreakXL(J);}t._setStylesInternal(S);}}
function p(s,D){var i=this.mContainers[s];var j=i[1];if(j){m(j,D);}var t=i[0];if(t){h(t,D);}delete this.mContainers[s];}
function r(s){var v=s.getVisibleFormContainers();var t;var u;var L=v.length;var w=0;var i=0;var j=0;if(L>1||!this.getSingleContainerFullSize()){var S=Math.floor(12/this.getColumnsM());var x=Math.floor(12/this.getColumnsL());var y;var D="";var z=this.getColumnsXL();if(z>=0){y=Math.floor(12/z);D=D+"XL"+y+" ";}D=D+"L"+x+" M"+S+" S12";if(!this._mainGrid){this._mainGrid=new G(s.getId()+"--Grid",{defaultSpan:D,hSpacing:0,vSpacing:0,containerQuery:true}).setParent(this);this._mainGrid.addStyleClass("sapUiFormResGridMain").addStyleClass("sapUiRespGridOverflowHidden");this._mainGrid._onParentResizeOrig=this._mainGrid._onParentResize;this._mainGrid._onParentResize=function(){this._onParentResizeOrig();var J=this.getParent();for(var u in J.mContainers){J.mContainers[u][1]._onParentResize();}};}else{this._mainGrid.setDefaultSpan(D);var A=this._mainGrid.getContent();w=A.length;var E=false;for(i=0;i<w;i++){var B=A[i];t=undefined;if(B.getContainer){t=sap.ui.getCore().byId(B.getContainer());}else{t=sap.ui.getCore().byId(B.__myParentContainerId);}if(t&&t.isVisible()){var V=v[j];if(t!=V){E=true;break;}var H=this.mContainers[t.getId()];if(H[0]&&H[0]!=B){E=true;break;}if(!H[0]&&H[1]&&H[1]!=B){E=true;break;}j++;}else{this._mainGrid.removeContent(B);}}if(E){this._mainGrid.removeAllContent();w=0;}}this._mainGrid._setBreakPointTablet(this.getBreakpointM());this._mainGrid._setBreakPointDesktop(this.getBreakpointL());this._mainGrid._setBreakPointLargeDesktop(this.getBreakpointXL());this._mainGrid.__bIsUsed=true;if(w<L){var I=0;if(w>0){I=w--;}for(i=I;i<L;i++){t=v[i];u=t.getId();if(this.mContainers[u]){if(this.mContainers[u][0]){this._mainGrid.addContent(this.mContainers[u][0]);}else if(this.mContainers[u][1]){this._mainGrid.addContent(this.mContainers[u][1]);}}}}}else{if(this._mainGrid){this._mainGrid.__bIsUsed=false;}for(i=0;i<L;i++){t=v[i];u=t.getId();if(this.mContainers[u]){if(this.mContainers[u][0]){if(this.mContainers[u][0].getParent()!==this){this.addDependent(this.mContainers[u][0]);}}else if(this.mContainers[u][1]){if(this.mContainers[u][1].getParent()!==this){this.addDependent(this.mContainers[u][1]);}}}}}}
return f;});
sap.ui.predefine('sap/ui/layout/form/ResponsiveGridLayoutRenderer',['sap/ui/core/Renderer','./FormLayoutRenderer'],function(R,F){"use strict";var a=R.extend(F);
a.getMainClass=function(){return"sapUiFormResGrid";};
a.renderContainers=function(r,l,f){var v=f.getVisibleFormContainers();var L=v.length;if(L>0){if(L>1||!l.getSingleContainerFullSize()){r.renderControl(l._mainGrid);}else if(l.mContainers[v[0].getId()][0]){r.renderControl(l.mContainers[v[0].getId()][0]);}else{r.renderControl(l.mContainers[v[0].getId()][1]);}}};
return a;},true);
sap.ui.predefine('sap/ui/layout/form/ResponsiveLayout',['sap/ui/core/Control','sap/ui/layout/library','sap/ui/layout/ResponsiveFlowLayout','sap/ui/layout/ResponsiveFlowLayoutData','./Form','./FormContainer','./FormElement','./FormLayout','./ResponsiveLayoutRenderer'],function(C,l,R,a,F,b,c,d,e){"use strict";
var f=d.extend("sap.ui.layout.form.ResponsiveLayout",{metadata:{library:"sap.ui.layout"}});
var P=C.extend("sap.ui.layout.form.ResponsiveLayoutPanel",{
metadata:{aggregations:{"content":{type:"sap.ui.layout.ResponsiveFlowLayout",multiple:false}},associations:{"container":{type:"sap.ui.layout.form.FormContainer",multiple:false},"layout":{type:"sap.ui.layout.form.ResponsiveLayout",multiple:false}}},
getLayoutData:function(){var i=sap.ui.getCore().byId(this.getContainer());var L=sap.ui.getCore().byId(this.getLayout());var j;if(L&&i){j=L.getLayoutDataForElement(i,"sap.ui.layout.ResponsiveFlowLayoutData");}return j;},
getCustomData:function(){var i=sap.ui.getCore().byId(this.getContainer());if(i){return i.getCustomData();}},
refreshExpanded:function(){var i=sap.ui.getCore().byId(this.getContainer());if(i){if(i.getExpanded()){this.$().removeClass("sapUiRLContainerColl");}else{this.$().addClass("sapUiRLContainerColl");}}},
renderer:function(i,j){var t=sap.ui.getCore().byId(j.getContainer());var L=sap.ui.getCore().byId(j.getLayout());var u=j.getContent();if(!t||!L){return;}var E=t.getExpandable();var T=t.getTooltip_AsString();var v=t.getToolbar();var w=t.getTitle();i.write("<div");i.writeControlData(j);i.addClass("sapUiRLContainer");if(E&&!t.getExpanded()){i.addClass("sapUiRLContainerColl");}if(v){i.addClass("sapUiFormContainerToolbar");}else if(w){i.addClass("sapUiFormContainerTitle");}if(T){i.writeAttributeEscaped('title',T);}i.writeClasses();L.getRenderer().writeAccessibilityStateContainer(i,t);i.write(">");L.getRenderer().renderHeader(i,v,w,t._oExpandButton,E,false,t.getId());if(u){i.write("<div");i.addClass("sapUiRLContainerCont");i.writeClasses();i.write(">");i.renderControl(u);i.write("</div>");}i.write("</div>");}
});
f.prototype.init=function(){this.mContainers={};this._defaultLayoutData=new a({margin:false});};
f.prototype.exit=function(){for(var i in this.mContainers){q.call(this,i);}if(this._mainRFLayout){this._mainRFLayout.destroy();delete this._mainRFLayout;}this._defaultLayoutData.destroy();delete this._defaultLayoutData;};
f.prototype.onBeforeRendering=function(E){var i=this.getParent();if(!i||!(i instanceof F)){return;}i._bNoInvalidate=true;_.call(this,i);s.call(this,i);i._bNoInvalidate=false;};
f.prototype.toggleContainerExpanded=function(i){var j=i.getId();if(this.mContainers[j]&&this.mContainers[j][0]){var t=this.mContainers[j][0];t.refreshExpanded();}};
f.prototype.onLayoutDataChange=function(E){var S=E.srcControl;var i;var j;var t;if(S instanceof b){if(this._mainRFLayout){this._mainRFLayout.onLayoutDataChange(E);}}else if(S instanceof c){j=S.getParent().getId();if(this.mContainers[j]&&this.mContainers[j][1]){this.mContainers[j][1].onLayoutDataChange(E);}}else{var u=S.getParent();if(u instanceof c){i=u.getParent();j=i.getId();t=u.getId();if(this.mContainers[j]&&this.mContainers[j][2]&&this.mContainers[j][2][t]){if(this.mContainers[j][2][t][1]){var v=u.getFields();o.call(this,this.mContainers[j][2][t][1],v);}this.mContainers[j][2][t][0].onLayoutDataChange(E);}}}};
f.prototype.onsapup=function(E){this.onsapleft(E);};
f.prototype.onsapdown=function(E){this.onsapright(E);};
f.prototype.getContainerRenderedDomRef=function(i){if(this.getDomRef()){var j=i.getId();if(this.mContainers[j]){if(this.mContainers[j][0]){var t=this.mContainers[j][0];return t.getDomRef();}else if(this.mContainers[j][1]){var u=this.mContainers[j][1];return u.getDomRef();}}}return null;};
f.prototype.getElementRenderedDomRef=function(E){if(this.getDomRef()){var i=E.getParent();var j=E.getId();var t=i.getId();if(this.mContainers[t]){if(this.mContainers[t][2]){var u=this.mContainers[t][2];if(u[j]){var v=u[j][0];return v.getDomRef();}}}}return null;};
function _(j){var v=j.getVisibleFormContainers();var V=v.length;var t;var u;var w;var x;var i=0;for(i=0;i<V;i++){t=v[i];t._checkProperties();u=t.getId();w=undefined;x=undefined;if(this.mContainers[u]&&this.mContainers[u][1]){x=this.mContainers[u][1];}else{x=m.call(this,t,undefined);}var T=t.getTitle();var y=t.getToolbar();if(y||T||t.getExpandable()){if(this.mContainers[u]&&this.mContainers[u][0]){w=this.mContainers[u][0];}else{w=g.call(this,t,x);n(x,true);}x.removeStyleClass("sapUiRLContainer");}else{if(this.mContainers[u]&&this.mContainers[u][0]){h(this.mContainers[u][0]);n(x,false);}x.addStyleClass("sapUiRLContainer");}var z=k.call(this,t,x);this.mContainers[u]=[w,x,z];}var O=Object.keys(this.mContainers).length;if(V<O){for(u in this.mContainers){var A=false;for(i=0;i<V;i++){t=v[i];if(u==t.getId()){A=true;break;}}if(!A){q.call(this,u);}}}}
function g(i,j){var t=i.getId();var u=new P(t+"--Panel",{container:i,layout:this,content:j});return u;}
function h(i){i.setContent(null);i.setLayout(null);i.setContainer(null);i.destroy();}
function k(j,t){var u=j.getId();var E=j.getVisibleFormElements();var v=E.length;var w={};if(this.mContainers[u]&&this.mContainers[u][2]){w=this.mContainers[u][2];}var x;var y;var L=-1;var z;var A;var i=0;for(i=0;i<v;i++){z=E[i];A=z.getId();r.call(this,j,z,w,t,i);if(w[A]){x=w[A][0];L=t.indexOfContent(x);if(L!=v){t.removeContent(x);t.insertContent(x,v);L=v;}}else{x=m.call(this,j,z);x.addStyleClass("sapUiRLElement");if(z.getLabel()){x.addStyleClass("sapUiRLElementWithLabel");}w[A]=[x,undefined];L++;t.insertContent(x,L);}var B=z.getFields();if(z.getLabel()&&B.length>1){if(w[A][1]){y=w[A][1];}else{y=m.call(this,j,z,true);y.addStyleClass("sapUiRLElementFields");w[A][1]=y;}o.call(this,y,B);}else{if(w[A][1]){y=w[A][1];p(y);w[A][1]=undefined;}}}var O=Object.keys(w).length;if(v<O){for(A in w){var D=false;for(i=0;i<v;i++){z=E[i];if(A==z.getId()){D=true;break;}}if(!D){if(w[A][1]){y=w[A][1];p(y);}x=w[A][0];t.removeContent(x);p(x);delete w[A];}}}return w;}
function m(i,E,j){var I;if(E&&!j){I=E.getId()+"--RFLayout";}else if(E&&j){I=E.getId()+"--content--RFLayout";}else if(i){I=i.getId()+"--RFLayout";}else{return false;}var t=new R(I);t.__myParentLayout=this;t.__myParentContainerId=i.getId();if(E){t.__myParentElementId=E.getId();if(!j){t.getContent=function(){var E=sap.ui.getCore().byId(this.__myParentElementId);if(E){var u=[];var L=E.getLabelControl();var v=E.getFields();if(!L||v.length<=1){u=v;if(L){u.unshift(L);}}else{var w=this.__myParentLayout;var x=this.__myParentContainerId;var y=E.getId();if(L){u.push(L);}if(w.mContainers[x]&&w.mContainers[x][2]&&w.mContainers[x][2][y]&&w.mContainers[x][2][y][1]){u.push(w.mContainers[x][2][y][1]);}}return u;}else{return false;}};t._addContentClass=function(u,v){if(v==0){var E=sap.ui.getCore().byId(this.__myParentElementId);if(E){var L=E.getLabelControl();if(u==L){return"sapUiFormElementLbl";}}}return null;};}else{t.getContent=function(){var E=sap.ui.getCore().byId(this.__myParentElementId);if(E){return E.getFields();}else{return false;}};}}else if(i){t._getAccessibleRole=function(){var i=sap.ui.getCore().byId(this.__myParentContainerId);var L=this.__myParentLayout;if(L._mainRFLayout&&!i.getToolbar()&&!i.getTitle()&&!i.getExpandable()&&i.getAriaLabelledBy().length>0){return"form";}};t.getAriaLabelledBy=function(){var i=sap.ui.getCore().byId(this.__myParentContainerId);if(i&&!i.getToolbar()&&!i.getTitle()&&!i.getExpandable()){return i.getAriaLabelledBy();}return[];};}if((E&&!j)||(!E&&!i.getToolbar()&&!i.getTitle()&&!i.getExpandable())){n(t,false);}else{t.setLayoutData(new a({margin:false}));}return t;}
function n(i,O){if(O){if(i.__originalGetLayoutData){i.getLayoutData=i.__originalGetLayoutData;delete i.__originalGetLayoutData;}}else if(!i.__originalGetLayoutData){i.__originalGetLayoutData=i.getLayoutData;i.getLayoutData=function(){var L=this.__myParentLayout;var j=sap.ui.getCore().byId(this.__myParentContainerId);var E=sap.ui.getCore().byId(this.__myParentElementId);var t;if(E){t=L.getLayoutDataForElement(E,"sap.ui.layout.ResponsiveFlowLayoutData");}else if(j){t=L.getLayoutDataForElement(j,"sap.ui.layout.ResponsiveFlowLayoutData");}if(t){return t;}else if(E){return L._defaultLayoutData;}};}}
function o(j,t){var L;var w=0;for(var i=0;i<t.length;i++){var u=t[i];L=this.getLayoutDataForElement(u,"sap.ui.layout.ResponsiveFlowLayoutData");if(L){w=w+L.getWeight();}else{w++;}}L=j.getLayoutData();if(L){L.setWeight(w);}else{j.setLayoutData(new a({weight:w}));}}
function p(i){if(i.__myParentContainerId){i.__myParentContainerId=undefined;}if(i.__myParentElementId){i.__myParentElementId=undefined;}i.__myParentLayout=undefined;i.destroy();}
function q(i){var j=this.mContainers[i];var t;var E=j[2];if(E){for(var u in E){if(E[u][1]){p(E[u][1]);}t=E[u][0];p(t);delete E[u];}}t=j[1];if(t){t.removeAllContent();p(t);}var v=j[0];if(v){h(v);}delete this.mContainers[i];}
function r(i,E,j,t,I){var u=E.getId();var v=u+"--RFLayout";var w=sap.ui.getCore().byId(v);if(!j[u]&&w){var O=w.__myParentContainerId;j[u]=this.mContainers[O][2][u];t.insertContent(w,I);w.__myParentContainerId=i.getId();if(j[u][1]){j[u][1].__myParentContainerId=i.getId();}delete this.mContainers[O][2][u];}}
function s(t){var v=t.getVisibleFormContainers();var u;var L=v.length;var w=0;var i=0;var j=0;if(L>1){if(!this._mainRFLayout){this._mainRFLayout=new R(t.getId()+"--RFLayout").setParent(this);}else{var x=this._mainRFLayout.getContent();w=x.length;var E=false;for(i=0;i<w;i++){var y=x[i];u=undefined;if(y.getContainer){u=sap.ui.getCore().byId(y.getContainer());}else{u=sap.ui.getCore().byId(y.__myParentContainerId);}if(u&&u.isVisible()){var V=v[j];if(u!=V){E=true;break;}var z=this.mContainers[u.getId()];if(z[0]&&z[0]!=y){E=true;break;}if(!z[0]&&z[1]&&z[1]!=y){E=true;break;}j++;}else{this._mainRFLayout.removeContent(y);}}if(E){this._mainRFLayout.removeAllContent();w=0;}}if(w<L){var S=0;if(w>0){S=w--;}for(i=S;i<L;i++){u=v[i];var A=u.getId();if(this.mContainers[A]){if(this.mContainers[A][0]){this._mainRFLayout.addContent(this.mContainers[A][0]);}else if(this.mContainers[A][1]){this._mainRFLayout.addContent(this.mContainers[A][1]);}}}}}}
return f;});
sap.ui.predefine('sap/ui/layout/form/ResponsiveLayoutRenderer',['sap/ui/core/Renderer','./FormLayoutRenderer'],function(R,F){"use strict";var a=R.extend(F);
a.getMainClass=function(){return"sapUiFormResLayout";};
a.renderContainers=function(r,l,f){var v=f.getVisibleFormContainers();var L=v.length;if(L>0){if(L>1){r.renderControl(l._mainRFLayout);}else if(l.mContainers[v[0].getId()][0]){r.renderControl(l.mContainers[v[0].getId()][0]);}else{r.renderControl(l.mContainers[v[0].getId()][1]);}}};
return a;},true);
sap.ui.predefine('sap/ui/layout/form/SimpleForm',['sap/ui/core/Control','sap/ui/base/ManagedObjectObserver','sap/ui/core/ResizeHandler','sap/ui/layout/library','./Form','./FormContainer','./FormElement','./FormLayout','./SimpleFormRenderer',"sap/base/Log","sap/ui/thirdparty/jquery"],function(C,M,R,l,F,a,b,c,S,L,q){"use strict";var B=l.BackgroundDesign;var d=l.form.SimpleFormLayout;var e;var f;var g;var G;var h;var m;var n;
var o=C.extend("sap.ui.layout.form.SimpleForm",{metadata:{library:"sap.ui.layout",properties:{maxContainerCols:{type:"int",group:"Appearance",defaultValue:2},minWidth:{type:"int",group:"Appearance",defaultValue:-1},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},editable:{type:"boolean",group:"Misc",defaultValue:null},labelMinWidth:{type:"int",group:"Misc",defaultValue:192},layout:{type:"sap.ui.layout.form.SimpleFormLayout",group:"Misc",defaultValue:d.ResponsiveLayout},labelSpanXL:{type:"int",group:"Misc",defaultValue:-1},labelSpanL:{type:"int",group:"Misc",defaultValue:4},labelSpanM:{type:"int",group:"Misc",defaultValue:2},labelSpanS:{type:"int",group:"Misc",defaultValue:12},adjustLabelSpan:{type:"boolean",group:"Misc",defaultValue:true},emptySpanXL:{type:"int",group:"Misc",defaultValue:-1},emptySpanL:{type:"int",group:"Misc",defaultValue:0},emptySpanM:{type:"int",group:"Misc",defaultValue:0},emptySpanS:{type:"int",group:"Misc",defaultValue:0},columnsXL:{type:"int",group:"Misc",defaultValue:-1},columnsL:{type:"int",group:"Misc",defaultValue:2},columnsM:{type:"int",group:"Misc",defaultValue:1},singleContainerFullSize:{type:"boolean",group:"Misc",defaultValue:true},breakpointXL:{type:"int",group:"Misc",defaultValue:1440},breakpointL:{type:"int",group:"Misc",defaultValue:1024},breakpointM:{type:"int",group:"Misc",defaultValue:600},backgroundDesign:{type:"sap.ui.layout.BackgroundDesign",group:"Appearance",defaultValue:B.Translucent}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Element",multiple:true,singularName:"content"},form:{type:"sap.ui.layout.form.Form",multiple:false,visibility:"hidden"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/ui/layout/designtime/form/SimpleForm.designtime"}});
o.prototype.init=function(){this._iMaxWeight=8;this._iLabelWeight=3;this._iCurrentWidth=0;var i=new F(this.getId()+"--Form");i.getTitle=function(){return this.getParent().getTitle();};i._origInvalidate=i.invalidate;i.invalidate=function(j){if(this.bOutput){this._origInvalidate(j);}if(this._bIsBeingDestroyed){return;}var k=this.getParent();if(k){k._formInvalidated(j);}};i.getAriaLabelledBy=function(){var j=this.getParent();if(j){return j.getAriaLabelledBy();}else{return null;}};i._origOnLayoutDataChange=i.onLayoutDataChange;i.onLayoutDataChange=function(j){this._origOnLayoutDataChange(j);var k=this.getParent();if(k){k._onLayoutDataChange(j);}};this.setAggregation("form",i);this._aElements=null;this._aLayouts=[];this._changedFormContainers=[];this._changedFormElements=[];this._oObserver=new M(W.bind(this));};
o.prototype.exit=function(){var j=this.getAggregation("form");j.invalidate=j._origInvalidate;U.call(this);for(var i=0;i<this._aLayouts.length;i++){var k=sap.ui.getCore().byId(this._aLayouts[i]);if(k&&k.destroy){k.destroy();}}this._aLayouts=[];this._aElements=null;this._changedFormContainers=[];this._changedFormElements=[];this._oObserver.disconnect();this._oObserver=undefined;};
o.prototype.onBeforeRendering=function(){U.call(this);var i=this.getAggregation("form");var j=this.getLayout();if((!this._bResponsiveLayoutRequested&&j===d.ResponsiveLayout)||(!this._bGridLayoutRequested&&j===d.GridLayout)||(!this._bResponsiveGridLayoutRequested&&j===d.ResponsiveGridLayout)||(!this._bColumnLayoutRequested&&j===d.ColumnLayout)){var k=true;if(!i.getLayout()){k=_.call(this);}if(k){x.call(this);}}};
o.prototype.onAfterRendering=function(){if(this.getLayout()==d.ResponsiveLayout){this._bChangedByMe=true;this.$().css("visibility","hidden");this._applyLinebreaks();this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._resize,this));this._bChangedByMe=false;}};
o.prototype.setEditable=function(i){this._bChangedByMe=true;this.setProperty("editable",i,true);var j=this.getAggregation("form");j.setEditable(i);this._bChangedByMe=false;return this;};
o.prototype.setToolbar=function(i){this._bChangedByMe=true;var j=this.getAggregation("form");j.setToolbar(i);this._bChangedByMe=false;return this;};
o.prototype.getToolbar=function(){var i=this.getAggregation("form");return i.getToolbar();};
o.prototype.destroyToolbar=function(){this._bChangedByMe=true;var i=this.getAggregation("form");i.destroyToolbar();this._bChangedByMe=false;return this;};
o.prototype.setLabelMinWidth=function(j){this.setProperty("labelMinWidth",j,true);if(this.getLayout()==d.ResponsiveLayout){this._bLayoutDataChangedByMe=true;var k=this.getContent();for(var i=0;i<k.length;i++){var Y=k[i];if(Y.isA("sap.ui.core.Label")){var Z=A.call(this,Y);if(Z&&Z.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&y.call(this,Z)){Z.setMinWidth(j);}}}this._bLayoutDataChangedByMe=false;}return this;};
o.prototype.indexOfContent=function(j){var k=this._aElements;if(k){for(var i=0;i<k.length;i++){if(k[i]==j){return i;}}}return-1;};
o.prototype.addContent=function(i){i=this.validateAggregation("content",i,true);if(this.indexOfContent(i)>=0){L.warning("SimpleForm.addContent: Content element '"+i+"' already assigned. Please remove before adding!",this);this.removeContent(i);}if(!this._aElements){this._aElements=[];}this._bChangedByMe=true;var j=this._aElements.length;var k;var Y=this.getAggregation("form");var Z;var $;var a1;var b1;if(i.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){Z=P.call(this,i);Y.addFormContainer(Z);this._changedFormContainers.push(Z);}else if(i.isA("sap.ui.core.Label")){if(j>0){k=this._aElements[j-1];a1=k.getParent();if(a1 instanceof b){Z=a1.getParent();}else if(a1 instanceof a){Z=a1;}}if(!Z){Z=P.call(this);Y.addFormContainer(Z);this._changedFormContainers.push(Z);}$=K.call(this,Z,i);}else{if(j>0){k=this._aElements[j-1];a1=k.getParent();if(a1 instanceof b){Z=a1.getParent();$=a1;b1=A.call(this,i);if(b1&&b1.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&!y.call(this,b1)&&b1.getLinebreak()){$=K.call(this,Z);}}else if(a1 instanceof a){Z=a1;$=K.call(this,Z);}}else{Z=P.call(this);Y.addFormContainer(Z);this._changedFormContainers.push(Z);$=K.call(this,Z);}E.call(this,i,5,false,true);$.addField(i);V(this._changedFormElements,$);}this._aElements.push(i);this._oObserver.observe(i,{properties:["visible"]});this.invalidate();this._bChangedByMe=false;return this;};
o.prototype.insertContent=function(j,k){j=this.validateAggregation("content",j,true);if(this.indexOfContent(j)>=0){L.warning("SimpleForm.insertContent: Content element '"+j+"' already assigned. Please remove before insert!",this);this.removeContent(j);}if(!this._aElements){this._aElements=[];}var Y=this._aElements.length;var Z;if(k<0){Z=0;}else if(k>Y){Z=Y;}else{Z=k;}if(Z!==k){L.warning("SimpleForm.insertContent: index '"+k+"' out of range [0,"+Y+"], forced to "+Z);}if(Z==Y){this.addContent(j);return this;}this._bChangedByMe=true;var $=this._aElements[Z];var a1=this.getAggregation("form");var b1;var c1;var d1;var e1;var f1;var g1=0;var h1;var i1;var j1;var k1;var i=0;var l1;var m1;if(j.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){if(k==0&&!($.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"]))){b1=$.getParent().getParent();if(j.isA("sap.ui.core.Title")){b1.setTitle(j);}else{b1.setToolbar(j);}}else{b1=P.call(this,j);if($.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){d1=$.getParent();f1=a1.indexOfFormContainer(d1);}else{e1=$.getParent();d1=e1.getParent();f1=a1.indexOfFormContainer(d1)+1;g1=d1.indexOfFormElement(e1);if(!$.isA("sap.ui.core.Label")){h1=e1.indexOfField($);if(h1>0||e1.getLabel()){c1=K.call(this,b1);this._changedFormElements.push(c1);V(this._changedFormElements,e1);i1=e1.getFields();for(i=h1;i<i1.length;i++){l1=i1[i];c1.addField(l1);}g1++;}}j1=d1.getFormElements();for(i=g1;i<j1.length;i++){b1.addFormElement(j1[i]);}}a1.insertFormContainer(b1,f1);}this._changedFormContainers.push(b1);}else if(j.isA("sap.ui.core.Label")){if($.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){d1=$.getParent();f1=a1.indexOfFormContainer(d1);k1=a1.getFormContainers();if(f1==0){b1=P.call(this);a1.insertFormContainer(b1,f1);this._changedFormContainers.push(b1);}else{b1=k1[f1-1];}c1=K.call(this,b1,j);}else if($.isA("sap.ui.core.Label")){d1=$.getParent().getParent();g1=d1.indexOfFormElement($.getParent());c1=N.call(this,d1,j,g1);}else{e1=$.getParent();d1=e1.getParent();g1=d1.indexOfFormElement(e1)+1;h1=e1.indexOfField($);if(h1==0&&!e1.getLabel()){c1=e1;c1.setLabel(j);E.call(this,j,this._iLabelWeight,false,true,this.getLabelMinWidth());}else{c1=N.call(this,d1,j,g1);V(this._changedFormElements,e1);i1=e1.getFields();for(i=h1;i<i1.length;i++){l1=i1[i];c1.addField(l1);}}}this._changedFormElements.push(c1);}else{m1=A.call(this,j);if($.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){d1=$.getParent();f1=a1.indexOfFormContainer(d1);if(f1==0){b1=P.call(this);a1.insertFormContainer(b1,f1);this._changedFormContainers.push(b1);}else{k1=a1.getFormContainers();b1=k1[f1-1];}j1=b1.getFormElements();if(j1.length==0){c1=K.call(this,b1);}else if(m1&&m1.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&!y.call(this,m1)&&m1.getLinebreak()){c1=K.call(this,b1);}else{c1=j1[j1.length-1];}c1.addField(j);}else if($.isA("sap.ui.core.Label")){e1=$.getParent();b1=e1.getParent();g1=b1.indexOfFormElement(e1);if(g1==0){c1=N.call(this,b1,null,0);}else if(m1&&m1.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&!y.call(this,m1)&&m1.getLinebreak()){c1=N.call(this,b1,null,g1);}else{j1=b1.getFormElements();c1=j1[g1-1];}c1.addField(j);}else{c1=$.getParent();h1=c1.indexOfField($);if(m1&&m1.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&!y.call(this,m1)&&m1.getLinebreak()&&h1>0){b1=c1.getParent();g1=b1.indexOfFormElement(c1);V(this._changedFormElements,c1);i1=c1.getFields();c1=N.call(this,b1,undefined,g1+1);c1.addField(j);for(i=h1;i<i1.length;i++){l1=i1[i];c1.addField(l1);}}else{c1.insertField(j,h1);}}V(this._changedFormElements,c1);E.call(this,j,5,false,true);}this._aElements.splice(Z,0,j);this._oObserver.observe(j,{properties:["visible"]});this.invalidate();this._bChangedByMe=false;return this;};
o.prototype.removeContent=function(j){var k=null;var Y=-1;var i=0;if(this._aElements){if(typeof(j)=="string"){j=sap.ui.getCore().byId(j);}if(typeof(j)=="object"){for(i=0;i<this._aElements.length;i++){if(this._aElements[i]==j){j=i;break;}}}if(typeof(j)=="number"){if(j<0||j>=this._aElements.length){L.warning("Element.removeAggregation called with invalid index: Items, "+j);}else{Y=j;k=this._aElements[Y];}}}if(k){this._bChangedByMe=true;var Z=this.getAggregation("form");var $;var a1;var b1;var c1;if(k.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){$=k.getParent();$.setTitle(null);$.setToolbar(null);if(Y>0){b1=$.getFormElements();var d1=Z.indexOfFormContainer($);var e1=Z.getFormContainers()[d1-1];if(b1.length>0&&!b1[0].getLabel()){var f1=e1.getFormElements();var g1=f1[f1.length-1];c1=b1[0].getFields();for(i=0;i<c1.length;i++){g1.addField(c1[i]);}V(this._changedFormElements,g1);$.removeFormElement(b1[0]);b1[0].destroy();b1.splice(0,1);}for(i=0;i<b1.length;i++){e1.addFormElement(b1[i]);}V(this._changedFormContainers,e1);Z.removeFormContainer($);$.destroy();}else if($.getFormElements().length==0){Z.removeFormContainer($);$.destroy();}}else if(k.isA("sap.ui.core.Label")){a1=k.getParent();$=a1.getParent();a1.setLabel(null);var h1=$.indexOfFormElement(a1);if(h1==0){if(a1.getFields().length==0){$.removeFormElement(a1);a1.destroy();if($.getFormElements().length==0&&!$.getTitle()&&!$.getToolbar()){Z.removeFormContainer($);$.destroy();}}else{V(this._changedFormElements,a1);}}else{b1=$.getFormElements();var i1=b1[h1-1];c1=a1.getFields();for(i=0;i<c1.length;i++){i1.addField(c1[i]);}V(this._changedFormElements,i1);$.removeFormElement(a1);a1.destroy();}}else{a1=k.getParent();a1.removeField(k);if(a1.getFields().length==0&&!a1.getLabel()){$=a1.getParent();$.removeFormElement(a1);a1.destroy();if($.getFormElements().length==0&&!$.getTitle()&&!$.getToolbar()){Z.removeFormContainer($);$.destroy();}}else{V(this._changedFormElements,a1);}}this._aElements.splice(Y,1);k.setParent(null);this._oObserver.unobserve(k);J.call(this,k);this.invalidate();this._bChangedByMe=false;return k;}return null;};
o.prototype.removeAllContent=function(){var i=0;if(this._aElements){this._bChangedByMe=true;var k=this.getAggregation("form");var Y=k.getFormContainers();for(i=0;i<Y.length;i++){var Z=Y[i];Z.setTitle(null);Z.setToolbar(null);var $=Z.getFormElements();for(var j=0;j<$.length;j++){var a1=$[j];a1.setLabel(null);a1.removeAllFields();}Z.destroyFormElements();}k.destroyFormContainers();for(i=0;i<this._aElements.length;i++){var b1=this._aElements[i];J.call(this,b1);this._oObserver.unobserve(b1);}var c1=this._aElements;this._aElements=null;this.invalidate();this._bChangedByMe=false;return c1;}else{return[];}};
o.prototype.destroyContent=function(){var j=this.removeAllContent();if(j){this._bChangedByMe=true;for(var i=0;i<j.length;i++){j[i].destroy();}this.invalidate();this._bChangedByMe=false;}return this;};
o.prototype.getContent=function(){if(!this._aElements){this._aElements=this.getAggregation("content",[]);}return this._aElements.slice();};
o.prototype.setLayout=function(i){var j=this.getLayout();if(i!=j){v.call(this);}this.setProperty("layout",i);if(i!=j){var k=_.call(this);if(k){w.call(this);}}return this;};
o.prototype.clone=function(k){this._bChangedByMe=true;var Y=C.prototype.clone.apply(this,arguments);var Z=this.getContent();for(var i=0;i<Z.length;i++){var $=Z[i];var a1=$.getLayoutData();this._oObserver.unobserve($);var b1=$.clone(k);this._oObserver.observe($,{properties:["visible"]});if(a1){if(a1.isA("sap.ui.core.VariantLayoutData")){var c1=a1.getMultipleLayoutData();for(var j=0;j<c1.length;j++){if(y.call(this,c1[j])){Y._aLayouts.push(b1.getLayoutData().getMultipleLayoutData()[j].getId());}}}else if(y.call(this,a1)){Y._aLayouts.push(b1.getLayoutData().getId());}}Y.addContent(b1);}this._bChangedByMe=false;return Y;};
function _(){var i=this.getAggregation("form");if(i.getLayout()){this._bChangedByMe=true;i.destroyLayout();U.call(this);this._bChangedByMe=false;}var j;switch(this.getLayout()){case d.ResponsiveLayout:if((!e||!f)&&!this._bResponsiveLayoutRequested){e=sap.ui.require("sap/ui/layout/form/ResponsiveLayout");f=sap.ui.require("sap/ui/layout/ResponsiveFlowLayoutData");if(!e||!f){sap.ui.require(["sap/ui/layout/form/ResponsiveLayout","sap/ui/layout/ResponsiveFlowLayoutData"],p.bind(this));this._bResponsiveLayoutRequested=true;}}if(e&&f){j=new e(this.getId()+"--Layout");}break;case d.GridLayout:if((!G||!h||!m)&&!this._bGridLayoutRequested){G=sap.ui.require("sap/ui/layout/form/GridLayout");h=sap.ui.require("sap/ui/layout/form/GridContainerData");m=sap.ui.require("sap/ui/layout/form/GridElementData");if(!G||!h||!m){sap.ui.require(["sap/ui/layout/form/GridLayout","sap/ui/layout/form/GridContainerData","sap/ui/layout/form/GridElementData"],r.bind(this));this._bGridLayoutRequested=true;}}if(G&&h&&m){j=new G(this.getId()+"--Layout");}break;case d.ResponsiveGridLayout:if(!g&&!this._bResponsiveGridLayoutRequested){g=sap.ui.require("sap/ui/layout/form/ResponsiveGridLayout");if(!g){sap.ui.require(["sap/ui/layout/form/ResponsiveGridLayout"],s.bind(this));this._bResponsiveGridLayoutRequested=true;}}if(g){j=new g(this.getId()+"--Layout");}break;case d.ColumnLayout:if(!n&&!this._bColumnLayoutRequested){n=sap.ui.require("sap/ui/layout/form/ColumnLayout");if(!n){sap.ui.require(["sap/ui/layout/form/ColumnLayout"],t.bind(this));this._bColumnLayoutRequested=true;}}if(n){j=new n(this.getId()+"--Layout");}break;}if(j){this._bChangedByMe=true;i.setLayout(j);this._bChangedByMe=false;return true;}return false;}
function p(i,j){e=i;f=j;this._bResponsiveLayoutRequested=false;if(this.getLayout()==d.ResponsiveLayout){u.call(this);}}
function r(i,j,k){G=i;h=j;m=k;this._bGridLayoutRequested=false;if(this.getLayout()==d.GridLayout){u.call(this);}}
function s(i){g=i;this._bResponsiveGridLayoutRequested=false;if(this.getLayout()==d.ResponsiveGridLayout){u.call(this);}}
function t(i){n=i;this._bColumnLayoutRequested=false;if(this.getLayout()==d.ColumnLayout){u.call(this);}}
function u(){if(!this._bIsBeingDestroyed){_.call(this);w.call(this);if(this.getDomRef()){x.call(this);}}}
function v(){this._bChangedByMe=true;var Y=this.getAggregation("form");var Z=Y.getFormContainers();for(var i=0;i<Z.length;i++){var $=Z[i];V(this._changedFormContainers,$);if($.getLayoutData()){$.destroyLayoutData();}var a1=$.getFormElements();for(var j=0;j<a1.length;j++){var b1=a1[j];V(this._changedFormElements,b1);if(b1.getLayoutData()){b1.destroyLayoutData();}var c1=b1.getLabel();if(c1){J.call(this,c1);}var d1=b1.getFields();for(var k=0;k<d1.length;k++){var e1=d1[k];J.call(this,e1);}}}this._bChangedByMe=false;}
function w(){this._bChangedByMe=true;var Y=this.getAggregation("form");var Z=Y.getFormContainers();for(var i=0;i<Z.length;i++){var $=Z[i];V(this._changedFormContainers,$);I.call(this,$);var a1=$.getFormElements();for(var j=0;j<a1.length;j++){var b1=a1[j];V(this._changedFormElements,b1);H.call(this,b1);var c1=b1.getLabel();if(c1){E.call(this,c1,this._iLabelWeight,false,true,this.getLabelMinWidth());}var d1=b1.getFields();for(var k=0;k<d1.length;k++){var e1=d1[k];E.call(this,e1,5,false,true);}}}this._bChangedByMe=false;}
function x(){this._bChangedByMe=true;this._changedFormContainers=[];var j=this.getLayout();var k=this.getAggregation("form").getLayout();k.setBackgroundDesign(this.getBackgroundDesign());switch(j){case d.ResponsiveLayout:this._applyLinebreaks();for(var i=0;i<this._changedFormElements.length;i++){var Y=this._changedFormElements[i];Q.call(this,Y);}break;case d.GridLayout:T.call(this);break;case d.ResponsiveGridLayout:k.setLabelSpanXL(this.getLabelSpanXL());k.setLabelSpanL(this.getLabelSpanL());k.setLabelSpanM(this.getLabelSpanM());k.setLabelSpanS(this.getLabelSpanS());k.setAdjustLabelSpan(this.getAdjustLabelSpan());k.setEmptySpanXL(this.getEmptySpanXL());k.setEmptySpanL(this.getEmptySpanL());k.setEmptySpanM(this.getEmptySpanM());k.setEmptySpanS(this.getEmptySpanS());k.setColumnsXL(this.getColumnsXL());k.setColumnsL(this.getColumnsL());k.setColumnsM(this.getColumnsM());k.setSingleContainerFullSize(this.getSingleContainerFullSize());k.setBreakpointXL(this.getBreakpointXL());k.setBreakpointL(this.getBreakpointL());k.setBreakpointM(this.getBreakpointM());break;case d.ColumnLayout:k.setColumnsXL(this.getColumnsXL()>0?this.getColumnsXL():this.getColumnsL());k.setColumnsL(this.getColumnsL());k.setColumnsM(this.getColumnsM());k.setLabelCellsLarge(this.getLabelSpanL());k.setEmptyCellsLarge(this.getEmptySpanL());break;}this._changedFormElements=[];this._bChangedByMe=false;}
function y(i){var j=i.getId(),k=" "+this._aLayouts.join(" ")+" ";return k.indexOf(" "+j+" ")>-1;}
function z(i,j,k,Y){var Z=new f({weight:i,linebreak:j===true,linebreakable:k===true});if(Y){Z.setMinWidth(Y);}this._aLayouts.push(Z.getId());return Z;}
function A(i){var j;switch(this.getLayout()){case d.ResponsiveLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.ResponsiveFlowLayoutData");break;case d.GridLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.form.GridElementData");break;case d.ResponsiveGridLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.GridData");break;case d.ColumnLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.form.ColumnElementData");break;}return j;}
function D(){var i=this.getLayout();if((i===d.ResponsiveLayout&&this._bResponsiveLayoutRequested)||(i===d.GridLayout&&this._bGridLayoutRequested)||(i===d.ResponsiveGridLayout&&this._bResponsiveGridLayoutRequested)||(i===d.ColumnLayout&&this._bColumnLayoutRequested)){return false;}if(!this.getAggregation("form").getLayout()){var j=this._bChangedByMe;var k=_.call(this);this._bChangedByMe=j;if(!k){return false;}}return true;}
function E(i,j,k,Y,Z){if(this.getLayout()!=d.ResponsiveLayout){return;}if(!D.call(this)){return;}this._bLayoutDataChangedByMe=true;var $=A.call(this,i);if(!$||!y.call(this,$)){$=i.getLayoutData();if($&&$.isA("sap.ui.core.VariantLayoutData")){$.addMultipleLayoutData(z.call(this,j,k,Y,Z));}else if(!$){i.setLayoutData(z.call(this,j,k,Y,Z));}else{L.warning("ResponsiveFlowLayoutData can not be set on Field "+i.getId(),"_createFieldLayoutData","SimpleForm");}}this._bLayoutDataChangedByMe=false;}
function H(i){if(this.getLayout()!=d.ResponsiveLayout){return;}if(!D.call(this)){return;}this._bLayoutDataChangedByMe=true;i.setLayoutData(new f({linebreak:true,margin:false}));this._bLayoutDataChangedByMe=false;}
function I(i){var j=this.getLayout();if(j!=d.ResponsiveLayout&&j!=d.GridLayout){return;}if(!D.call(this)){return;}this._bLayoutDataChangedByMe=true;switch(j){case d.ResponsiveLayout:i.setLayoutData(new f({minWidth:280}));break;case d.GridLayout:if(this.getMaxContainerCols()>1){i.setLayoutData(new h({halfGrid:true}));}else{i.setLayoutData(new h({halfGrid:false}));}break;}this._bLayoutDataChangedByMe=false;}
function J(j){this._bLayoutDataChangedByMe=true;var k=A.call(this,j);if(k){var Y=k.getId();for(var i=0;i<this._aLayouts.length;i++){var Z=this._aLayouts[i];if(Y==Z){k.destroy();this._aLayouts.splice(i,1);break;}}}this._bLayoutDataChangedByMe=false;}
function K(i,j){var k=O.call(this,j);i.addFormElement(k);return k;}
function N(i,j,k){var Y=O.call(this,j);i.insertFormElement(Y,k);return Y;}
function O(j){var k=new b();H.call(this,k);if(j){j.addStyleClass("sapUiFormLabel-CTX");k.setLabel(j);if(!A.call(this,j)){E.call(this,j,this._iLabelWeight,false,true,this.getLabelMinWidth());}}k.isVisible=function(){var Y=this.getFields();var Z=false;for(var i=0;i<Y.length;i++){var $=Y[i];if($.getVisible()){Z=true;break;}}return Z;};return k;}
function P(i){var j=new a();I.call(this,j);j.getAriaLabelledBy=function(){var k=this.getToolbar();if(k){return k.getAriaLabelledBy();}else{return[];}};if(i){if(i.isA("sap.ui.core.Title")){j.setTitle(i);}else if(i.isA("sap.ui.core.Toolbar")){j.setToolbar(i);}}return j;}
function Q(j){var k=this._iMaxWeight;var Y=j.getFields();var Z;var $=Y.length;var a1=j.getLabel();var b1;var i=0;this._bLayoutDataChangedByMe=true;if(a1&&A.call(this,a1)){k=k-A.call(this,a1).getWeight();}for(i=0;i<Y.length;i++){Z=Y[i];b1=A.call(this,Z);if(b1&&b1.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&!y.call(this,b1)){k=k-b1.getWeight();$--;}}var c1=Math.floor(k/$);var d1=k%$;for(i=0;i<Y.length;i++){Z=Y[i];b1=A.call(this,Z);var e1=c1;if(!b1){E.call(this,Z,e1,false,i==0);}else if(y.call(this,b1)&&b1.isA("sap.ui.layout.ResponsiveFlowLayoutData")){if(d1>0){e1++;d1--;}b1.setWeight(e1);}}this._bLayoutDataChangedByMe=false;}
o.prototype._applyLinebreaks=function(){if(!e||this._bResponsiveLayoutRequested){return;}this._bLayoutDataChangedByMe=true;var j=this.getAggregation("form"),k=j.getFormContainers();var Y=this.getDomRef();var Z=this.$();for(var i=1;i<k.length;i++){var $=k[i],a1=$.getLayoutData();if(!Y||Z.outerWidth(true)>this.getMinWidth()){if(i%this.getMaxContainerCols()==0){a1.setLinebreak(true);}else{a1.setLinebreak(false);}}else{a1.setLinebreak(true);}}if(Y&&Z.css("visibility")=="hidden"){var b1=this;setTimeout(function(){if(b1.getDomRef()){b1.$().css("visibility","");}},10);}this._bLayoutDataChangedByMe=false;};
function T(){this._bLayoutDataChangedByMe=true;var j=this.getAggregation("form");var k=j.getFormContainers();var Y=k.length;for(var i=0;i<Y;i++){var Z=k[i];if((this.getMaxContainerCols()<=1)||((i==Y-1)&&(Y%2>0))){Z.getLayoutData().setHalfGrid(false);}else if(!Z.getLayoutData().getHalfGrid()){Z.getLayoutData().setHalfGrid(true);}}this._bLayoutDataChangedByMe=false;}
o.prototype._resize=function(i){this._bChangedByMe=true;if(this._iCurrentWidth==i.size.width){return;}this._iCurrentWidth=i.size.width;this._applyLinebreaks();this._bChangedByMe=false;};
function U(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}}
function V(j,k){var Y=false;for(var i=0;i<j.length;i++){var Z=j[i];if(Z==k){Y=true;break;}}if(!Y){j.push(k);}}
function W(i){if(i.name=="visible"){var j=i.object.getParent();j.invalidate();}}
function X(Y){var Z=[];var $=Y.getFormContainers();for(var i=0;i<$.length;i++){var a1=$[i];var b1=a1.getTitle();if(b1){Z.push(b1);}else{var c1=a1.getToolbar();if(c1){Z.push(c1);}}var d1=a1.getFormElements();for(var j=0;j<d1.length;j++){var e1=d1[j];var f1=e1.getLabel();if(f1){Z.push(f1);}var g1=e1.getFields();for(var k=0;k<g1.length;k++){var h1=g1[k];Z.push(h1);}}}return Z;}
o.prototype._formInvalidated=function(k){if(!this._bChangedByMe){var Y=X(this.getAggregation("form"));var i=0;var j=0;var Z=false;if(!this._aElements||Y.length<this._aElements.length){Z=true;}else{for(i=0;i<Y.length;i++){var $=Y[i];var a1=this._aElements[j];if($===a1){j++;}else{var b1=Y[i+1];if(b1===a1){this.insertContent($,i);break;}b1=this._aElements[j+1];if(b1===$){Z=true;break;}break;}}}if(Z){this.removeAllContent();for(i=0;i<Y.length;i++){var c1=Y[i];this.addContent(c1);}}}};
o.prototype._onLayoutDataChange=function(i){if(!this._bLayoutDataChangedByMe&&!this._bIsBeingDestroyed){switch(this.getLayout()){case d.ResponsiveLayout:var j=i.srcControl;var k=j.getParent();if(k instanceof b){var Y=this.indexOfContent(j);this.removeContent(j);this.insertContent(j,Y);}break;}}};
o.prototype._suggestTitleId=function(i){var j=this.getAggregation("form");j._suggestTitleId(i);return this;};
return o;});
sap.ui.predefine('sap/ui/layout/form/SimpleFormRenderer',[],function(){"use strict";var S={};
S.render=function(r,c){c._bChangedByMe=true;r.write("<div");r.writeControlData(c);r.addClass("sapUiSimpleForm");if(c.getWidth()){r.addStyle("width",c.getWidth());}r.writeStyles();r.writeClasses();r.write(">");var f=c.getAggregation("form");r.renderControl(f);r.write("</div>");c._bChangedByMe=false;};
return S;},true);
sap.ui.predefine('sap/ui/layout/library',['sap/ui/base/DataType','sap/ui/core/library'],function(D,l){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.layout",version:"1.67.1",dependencies:["sap.ui.core"],designtime:"sap/ui/layout/designtime/library.designtime",types:["sap.ui.layout.BackgroundDesign","sap.ui.layout.BlockBackgroundType","sap.ui.layout.BlockLayoutCellColorSet","sap.ui.layout.BlockLayoutCellColorShade","sap.ui.layout.BlockRowColorSets","sap.ui.layout.BoxesPerRowConfig","sap.ui.layout.GridIndent","sap.ui.layout.GridPosition","sap.ui.layout.GridSpan","sap.ui.layout.SideContentFallDown","sap.ui.layout.SideContentPosition","sap.ui.layout.SideContentVisibility","sap.ui.layout.form.ColumnsXL","sap.ui.layout.form.ColumnsL","sap.ui.layout.form.ColumnsM","sap.ui.layout.form.ColumnCells","sap.ui.layout.form.EmptyCells","sap.ui.layout.form.GridElementCells","sap.ui.layout.form.SimpleFormLayout","sap.ui.layout.cssgrid.CSSGridAutoFlow","sap.ui.layout.cssgrid.CSSGridTrack","sap.ui.layout.cssgrid.CSSGridLine","sap.ui.layout.cssgrid.CSSGridGapShortHand"],interfaces:["sap.ui.layout.cssgrid.IGridConfigurable"],controls:["sap.ui.layout.AlignedFlowLayout","sap.ui.layout.DynamicSideContent","sap.ui.layout.FixFlex","sap.ui.layout.Grid","sap.ui.layout.HorizontalLayout","sap.ui.layout.ResponsiveFlowLayout","sap.ui.layout.ResponsiveSplitter","sap.ui.layout.ResponsiveSplitterPage","sap.ui.layout.Splitter","sap.ui.layout.VerticalLayout","sap.ui.layout.BlockLayoutCell","sap.ui.layout.BlockLayoutRow","sap.ui.layout.BlockLayout","sap.ui.layout.form.Form","sap.ui.layout.form.FormLayout","sap.ui.layout.form.GridLayout","sap.ui.layout.form.ColumnLayout","sap.ui.layout.form.ResponsiveGridLayout","sap.ui.layout.form.ResponsiveLayout","sap.ui.layout.form.SimpleForm","sap.ui.layout.cssgrid.CSSGrid"],elements:["sap.ui.layout.BlockLayoutCellData","sap.ui.layout.GridData","sap.ui.layout.ResponsiveFlowLayoutData","sap.ui.layout.SplitterLayoutData","sap.ui.layout.form.FormContainer","sap.ui.layout.form.FormElement","sap.ui.layout.form.GridContainerData","sap.ui.layout.PaneContainer","sap.ui.layout.SplitPane","sap.ui.layout.form.GridElementData","sap.ui.layout.form.ColumnElementData","sap.ui.layout.form.ColumnContainerData","sap.ui.layout.cssgrid.GridItemLayoutData"],extensions:{flChangeHandlers:{"sap.ui.layout.BlockLayout":{"moveControls":"default"},"sap.ui.layout.BlockLayoutRow":{"moveControls":"default","hideControl":"default","unhideControl":"default"},"sap.ui.layout.BlockLayoutCell":"sap/ui/layout/flexibility/BlockLayoutCell","sap.ui.layout.DynamicSideContent":{"moveControls":"default","hideControl":"default","unhideControl":"default"},"sap.ui.layout.form.SimpleForm":"sap/ui/layout/flexibility/SimpleForm","sap.ui.layout.Grid":{"moveControls":"default","hideControl":"default","unhideControl":"default"},"sap.ui.layout.FixFlex":{"moveControls":"default","hideControl":"default","unhideControl":"default"},"sap.ui.layout.form.Form":"sap/ui/layout/flexibility/Form","sap.ui.layout.form.FormContainer":"sap/ui/layout/flexibility/FormContainer","sap.ui.layout.form.FormElement":"sap/ui/layout/flexibility/FormElement","sap.ui.layout.HorizontalLayout":{"moveControls":"default","hideControl":"default","unhideControl":"default"},"sap.ui.layout.Splitter":{"moveControls":"default","hideControl":"default","unhideControl":"default"},"sap.ui.layout.VerticalLayout":{"moveControls":"default","hideControl":"default","unhideControl":"default"}},"sap.ui.support":{publicRules:true,internalRules:true}}});sap.ui.layout.BackgroundDesign={Solid:"Solid",Transparent:"Transparent",Translucent:"Translucent"};sap.ui.layout.GridIndent=D.createType('sap.ui.layout.GridIndent',{isValid:function(v){return/^(([Xx][Ll](?:[0-9]|1[0-1]))? ?([Ll](?:[0-9]|1[0-1]))? ?([Mm](?:[0-9]|1[0-1]))? ?([Ss](?:[0-9]|1[0-1]))?)$/.test(v);}},D.getType('string'));sap.ui.layout.GridPosition={Left:"Left",Right:"Right",Center:"Center"};sap.ui.layout.GridSpan=D.createType('sap.ui.layout.GridSpan',{isValid:function(v){return/^(([Xx][Ll](?:[1-9]|1[0-2]))? ?([Ll](?:[1-9]|1[0-2]))? ?([Mm](?:[1-9]|1[0-2]))? ?([Ss](?:[1-9]|1[0-2]))?)$/.test(v);}},D.getType('string'));sap.ui.layout.BlockBackgroundType={Default:"Default",Light:"Light",Mixed:"Mixed",Accent:"Accent",Dashboard:"Dashboard"};sap.ui.layout.BlockRowColorSets={ColorSet1:"ColorSet1",ColorSet2:"ColorSet2",ColorSet3:"ColorSet3",ColorSet4:"ColorSet4"};sap.ui.layout.BlockLayoutCellColorSet={ColorSet1:"ColorSet1",ColorSet2:"ColorSet2",ColorSet3:"ColorSet3",ColorSet4:"ColorSet4",ColorSet5:"ColorSet5",ColorSet6:"ColorSet6",ColorSet7:"ColorSet7",ColorSet8:"ColorSet8",ColorSet9:"ColorSet9",ColorSet10:"ColorSet10",ColorSet11:"ColorSet11"};sap.ui.layout.BlockLayoutCellColorShade={ShadeA:"ShadeA",ShadeB:"ShadeB",ShadeC:"ShadeC",ShadeD:"ShadeD",ShadeE:"ShadeE",ShadeF:"ShadeF"};sap.ui.layout.form=sap.ui.layout.form||{};sap.ui.layout.form.GridElementCells=D.createType('sap.ui.layout.form.GridElementCells',{isValid:function(v){return/^(auto|full|([1-9]|1[0-6]))$/.test(v);}},D.getType('string'));sap.ui.layout.form.SimpleFormLayout={ResponsiveLayout:"ResponsiveLayout",GridLayout:"GridLayout",ResponsiveGridLayout:"ResponsiveGridLayout",ColumnLayout:"ColumnLayout"};sap.ui.layout.SideContentVisibility={AlwaysShow:"AlwaysShow",ShowAboveL:"ShowAboveL",ShowAboveM:"ShowAboveM",ShowAboveS:"ShowAboveS",NeverShow:"NeverShow"};sap.ui.layout.SideContentFallDown={BelowXL:"BelowXL",BelowL:"BelowL",BelowM:"BelowM",OnMinimumWidth:"OnMinimumWidth"};sap.ui.layout.SideContentPosition={End:"End",Begin:"Begin"};sap.ui.layout.form.ColumnsXL=D.createType('sap.ui.layout.form.ColumnsXL',{isValid:function(v){if(v>0&&v<=4){return true;}else{return false;}}},D.getType('int'));sap.ui.layout.form.ColumnsL=D.createType('sap.ui.layout.form.ColumnsL',{isValid:function(v){if(v>0&&v<=3){return true;}else{return false;}}},D.getType('int'));sap.ui.layout.form.ColumnsM=D.createType('sap.ui.layout.form.ColumnsM',{isValid:function(v){if(v>0&&v<=2){return true;}else{return false;}}},D.getType('int'));sap.ui.layout.form.ColumnCells=D.createType('sap.ui.layout.form.ColumnCells',{isValid:function(v){if(v>0&&v<=12){return true;}else{return false;}}},D.getType('int'));sap.ui.layout.form.EmptyCells=D.createType('sap.ui.layout.form.EmptyCells',{isValid:function(v){if(v>=0&&v<12){return true;}else{return false;}}},D.getType('int'));if(!sap.ui.layout.form.FormHelper){sap.ui.layout.form.FormHelper={createLabel:function(t){throw new Error("no Label control available!");},createButton:function(i,p,c){throw new Error("no Button control available!");},setButtonContent:function(b,t,T,i,I){throw new Error("no Button control available!");},addFormClass:function(){return null;},setToolbar:function(t){return t;},bArrowKeySupport:true,bFinal:false};}if(!sap.ui.layout.GridHelper){sap.ui.layout.GridHelper={getLibrarySpecificClass:function(){return"";},bFinal:false};}sap.ui.layout.cssgrid.CSSGridTrack=D.createType("sap.ui.layout.cssgrid.CSSGridTrack",{isValid:function(v){var c=/(auto|inherit|(([0-9]+|[0-9]*\.[0-9]+)([rR][eE][mM]|[eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC]|[vV][wW]|[vV][hH]|[vV][mM][iI][nN]|[vV][mM][aA][xX]|%))|calc\(\s*(\(\s*)*[-+]?(([0-9]+|[0-9]*\.[0-9]+)([rR][eE][mM]|[eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC]|[vV][wW]|[vV][hH]|[vV][mM][iI][nN]|[vV][mM][aA][xX]|%)?)(\s*(\)\s*)*(\s[-+]\s|[*\/])\s*(\(\s*)*([-+]?(([0-9]+|[0-9]*\.[0-9]+)([rR][eE][mM]|[eE][mM]|[eE][xX]|[pP][xX]|[cC][mM]|[mM][mM]|[iI][nN]|[pP][tT]|[pP][cC]|[vV][wW]|[vV][hH]|[vV][mM][iI][nN]|[vV][mM][aA][xX]|%)?)))*\s*(\)\s*)*\))/g;v=v.replace(/(minmax|repeat|fit-content|max-content|min-content|auto-fill|auto-fit|fr|min|max)/g,"");v=v.replace(c,"");v=v.replace(/\(|\)|\+|\-|\*|\/|calc|\%|\,/g,"");v=v.replace(/[0-9]/g,"");v=v.replace(/\s/g,"");return v.length===0;},parseValue:function(v){return v.trim().split(/\s+/).join(" ");}},D.getType("string"));sap.ui.layout.cssgrid.CSSGridGapShortHand=D.createType("sap.ui.layout.cssgrid.CSSGridGapShortHand",{isValid:function(v){var r=true,V=v.split(/\s+/);V.forEach(function(s){if(!l.CSSSize.isValid(s)){r=false;}});return r;},parseValue:function(v){return v.trim().split(/\s+/).join(" ");}},D.getType("string"));sap.ui.layout.cssgrid.CSSGridLine=D.createType("sap.ui.layout.cssgrid.CSSGridLine",{isValid:function(v){return/^(auto|inherit|((span)?(\s)?-?[0-9]+(\s\/\s(span)?(\s)?-?[0-9]*)?)?)$/.test(v);}},D.getType("string"));sap.ui.layout.cssgrid.CSSGridAutoFlow={Row:"Row",Column:"Column",RowDense:"RowDense",ColumnDense:"ColumnDense"};sap.ui.layout.BoxesPerRowConfig=D.createType("sap.ui.layout.BoxesPerRowConfig",{isValid:function(v){return/^(([Xx][Ll](?:[1-9]|1[0-2]))? ?([Ll](?:[1-9]|1[0-2]))? ?([Mm](?:[1-9]|1[0-2]))? ?([Ss](?:[1-9]|1[0-2]))?)$/.test(v);}},D.getType("string"));return sap.ui.layout;});
sap.ui.require.preload({
	"sap/ui/layout/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.layout","type":"library","embeds":[],"applicationVersion":{"version":"1.67.1"},"title":"SAPUI5 library with layout controls.","description":"SAPUI5 library with layout controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.67","libs":{"sap.ui.core":{"minVersion":"1.67.1"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.ui.layout.AlignedFlowLayout","sap.ui.layout.DynamicSideContent","sap.ui.layout.FixFlex","sap.ui.layout.Grid","sap.ui.layout.HorizontalLayout","sap.ui.layout.ResponsiveFlowLayout","sap.ui.layout.ResponsiveSplitter","sap.ui.layout.ResponsiveSplitterPage","sap.ui.layout.Splitter","sap.ui.layout.VerticalLayout","sap.ui.layout.BlockLayoutCell","sap.ui.layout.BlockLayoutRow","sap.ui.layout.BlockLayout","sap.ui.layout.form.Form","sap.ui.layout.form.FormLayout","sap.ui.layout.form.GridLayout","sap.ui.layout.form.ColumnLayout","sap.ui.layout.form.ResponsiveGridLayout","sap.ui.layout.form.ResponsiveLayout","sap.ui.layout.form.SimpleForm","sap.ui.layout.cssgrid.CSSGrid"],"elements":["sap.ui.layout.BlockLayoutCellData","sap.ui.layout.GridData","sap.ui.layout.ResponsiveFlowLayoutData","sap.ui.layout.SplitterLayoutData","sap.ui.layout.form.FormContainer","sap.ui.layout.form.FormElement","sap.ui.layout.form.GridContainerData","sap.ui.layout.PaneContainer","sap.ui.layout.SplitPane","sap.ui.layout.form.GridElementData","sap.ui.layout.form.ColumnElementData","sap.ui.layout.form.ColumnContainerData","sap.ui.layout.cssgrid.GridItemLayoutData"],"types":["sap.ui.layout.BackgroundDesign","sap.ui.layout.BlockBackgroundType","sap.ui.layout.BlockLayoutCellColorSet","sap.ui.layout.BlockLayoutCellColorShade","sap.ui.layout.BlockRowColorSets","sap.ui.layout.BoxesPerRowConfig","sap.ui.layout.GridIndent","sap.ui.layout.GridPosition","sap.ui.layout.GridSpan","sap.ui.layout.SideContentFallDown","sap.ui.layout.SideContentPosition","sap.ui.layout.SideContentVisibility","sap.ui.layout.form.ColumnsXL","sap.ui.layout.form.ColumnsL","sap.ui.layout.form.ColumnsM","sap.ui.layout.form.ColumnCells","sap.ui.layout.form.EmptyCells","sap.ui.layout.form.GridElementCells","sap.ui.layout.form.SimpleFormLayout","sap.ui.layout.cssgrid.CSSGridAutoFlow","sap.ui.layout.cssgrid.CSSGridTrack","sap.ui.layout.cssgrid.CSSGridLine","sap.ui.layout.cssgrid.CSSGridGapShortHand"],"interfaces":["sap.ui.layout.cssgrid.IGridConfigurable"]}}}}'
},"sap/ui/layout/library-preload"
);
//# sourceMappingURL=library-preload.js.map