/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/DataType','./BindingMode','./ChangeReason','./PropertyBinding','./CompositeType','./CompositeDataState',"sap/ui/base/SyncPromise","sap/base/util/deepEqual","sap/base/assert","sap/base/Log"],function(D,B,C,P,a,b,S,d,c,L){"use strict";var e=P.extend("sap.ui.model.CompositeBinding",{constructor:function(f,r,i){P.apply(this,[null,""]);this.aBindings=f;this.aValues=null;this.bRawValues=r;this.bPreventUpdate=false;this.bInternalValues=i;},metadata:{publicMethods:["getBindings","attachChange","detachChange"]}});e.prototype.getPath=function(){c(null,"Composite Binding has no path!");return null;};e.prototype.getModel=function(){c(null,"Composite Binding has no model!");return null;};e.prototype.getContext=function(){c(null,"Composite Binding has no context!");return null;};e.prototype.isResolved=function(){return this.aBindings.every(function(o){return o.isResolved();});};e.prototype.setType=function(t,i){if(t&&!(t instanceof a)){throw new Error("Only CompositeType can be used as type for composite bindings!");}P.prototype.setType.apply(this,arguments);if(this.oType){this.bRawValues=this.oType.getUseRawValues();this.bInternalValues=this.oType.getUseInternalValues();if(this.bRawValues&&this.bInternalValues){throw new Error(this.oType+" has both 'bUseRawValues' & 'bUseInternalValues' set to true. Only one of them is allowed to be true");}}};e.prototype.setContext=function(o){this.aBindings.forEach(function(f){if(!o||f.updateRequired(o.getModel())){f.setContext(o);}});};e.prototype.setValue=function(v){if(this.bSuspended){return;}this.aBindings.forEach(function(o,i){var V=v[i];if(V!==undefined){o.setValue(V);}});this.getDataState().setValue(this.getValue());};e.prototype.getValue=function(){return this.aBindings.map(function(o){return o.getValue();});};e.prototype.getOriginalValue=function(){return this.aBindings.map(function(o){return o.getDataState().getOriginalValue();});};e.prototype.getExternalValue=function(){var v=[],i,V;switch(this.sInternalType){case"raw":return this.getRawValue();case"internal":return this.getInternalValue();default:i=this.sInternalType&&D.getType(this.sInternalType);v=this.getCurrentValues();if(this.fnFormatter){V=this.fnFormatter.apply(this,v);}else if(this.oType){V=this.oType.formatValue(v,this.sInternalType);}else if(i instanceof D&&i.isArrayType()){V=v;}else if(v.length>1){V=v.join(" ");}else{V=v[0];}return V;}};e.prototype.setExternalValue=function(v){var i,o,p,t=this;if(this.sInternalType==="raw"){this.setRawValue(v);return;}else if(this.sInternalType==="internal"){this.setInternalValue(v);return;}i=this.sInternalType&&D.getType(this.sInternalType);if(this.fnFormatter){L.warning("Tried to use twoway binding, but a formatter function is used");return;}o=this.getDataState();if(this.oType){p=S.resolve().then(function(){var f;if(t.oType.getParseWithValues()){f=t.getCurrentValues();}return t.oType.parseValue(v,t.sInternalType,f);}).then(function(V){var f=t.getValidateValues(V);return S.all([V,t.oType.validateValue(f)]);}).then(function(r){return r[0];}).catch(function(E){o.setInvalidValue(v);t.checkDataState();throw E;});}else if(Array.isArray(v)&&i instanceof D&&i.isArrayType()){p=S.resolve(v);}else if(typeof v=="string"){p=S.resolve(v.split(" "));}else{p=S.resolve([v]);}return p.then(function(V){t.aBindings.forEach(function(f,I){v=V[I];if(v!==undefined){if(t.bRawValues){f.setRawValue(v);}else if(t.bInternalValues){f.setInternalValue(v);}else{f.setExternalValue(v);}}});o.setValue(t.getValue());o.setInvalidValue(undefined);}).unwrap();};e.prototype.getInternalValue=function(){return this.aBindings.map(function(o){return o.getInternalValue();});};e.prototype.setInternalValue=function(v){var o=this.getDataState(),p,t=this;if(this.oType){p=S.resolve(v).then(function(V){if(!t.bInternalValues){V=t.aBindings.map(function(f,i){return f._internalToRaw(V[i]);});if(!t.bRawValues){V=t.aBindings.map(function(f,i){return f._rawToExternal(V[i]);});}}return t.oType.validateValue(V);}).then(function(){return v;}).catch(function(E){o.setInvalidValue(v);t.checkDataState();throw E;});}else{p=S.resolve(v);}return p.then(function(){t.aBindings.forEach(function(f,i){var V=v[i];if(V!==undefined){f.setInternalValue(V);}});o.setValue(t.getValue());o.setInvalidValue(undefined);}).unwrap();};e.prototype.getRawValue=function(){return this.aBindings.map(function(o){return o.getRawValue();});};e.prototype.setRawValue=function(v){var o=this.getDataState(),p,t=this;if(this.oType){p=S.resolve(v).then(function(V){if(!t.bRawValues){if(t.bInternalValues){V=t.aBindings.map(function(f,i){return f._rawToInternal(V[i]);});}else{V=t.aBindings.map(function(f,i){return f._rawToExternal(V[i]);});}}return t.oType.validateValue(V);}).then(function(){return v;}).catch(function(E){o.setInvalidValue(v);t.checkDataState();throw E;});}else{p=S.resolve(v);}return p.then(function(){t.aBindings.forEach(function(f,i){var V=v[i];if(V!==undefined){f.setRawValue(V);}});o.setValue(t.getValue());o.setInvalidValue(undefined);}).unwrap();};e.prototype.getCurrentValues=function(){if(this.bRawValues){return this.getRawValue();}else if(this.bInternalValues){return this.getInternalValue();}else{return this.aBindings.map(function(o){return o.getExternalValue();});}};e.prototype.getValidateValues=function(v){var f,p,V=v;p=this.aBindings.some(function(g,i){return v[i]===undefined;});if(p){f=this.getCurrentValues();V=f.map(function(g,i){return v[i]===undefined?g:v[i];});}return V;};e.prototype.getBindings=function(){return this.aBindings;};e.prototype.hasValidation=function(){if(this.getType()){return true;}var f=this.getBindings();for(var i=0;i<f.length;++i){if(f[i].hasValidation()){return true;}}return false;};e.prototype.attachChange=function(f,l){var t=this;this.fChangeHandler=function(E){if(t.bSuspended){return;}var o=E.getSource();if(o.getBindingMode()==B.OneTime){o.detachChange(t.fChangeHandler);}t.checkUpdate(true);};this.attachEvent("change",f,l);if(this.aBindings){this.aBindings.forEach(function(o){o.attachChange(t.fChangeHandler);});}};e.prototype.detachChange=function(f,l){var t=this;this.detachEvent("change",f,l);if(this.aBindings){this.aBindings.forEach(function(o){o.detachChange(t.fChangeHandler);});}};e.prototype.attachDataStateChange=function(f,l){var t=this;this.fDataStateChangeHandler=function(E){var o=E.getSource();if(o.getBindingMode()==B.OneTime){o.detachDataStateChange(t.fChangeHandler);}t.checkDataState();};this.attachEvent("DataStateChange",f,l);if(this.aBindings){this.aBindings.forEach(function(o){o.attachEvent("DataStateChange",t.fDataStateChangeHandler);});}};e.prototype.detachDataStateChange=function(f,l){var t=this;this.detachEvent("DataStateChange",f,l);if(this.aBindings){this.aBindings.forEach(function(o){o.detachEvent("DataStateChange",t.fDataStateChangeHandler);});}};e.prototype.attachAggregatedDataStateChange=function(f,l){var t=this;if(!this.fDataStateChangeHandler){this.fDataStateChangeHandler=function(E){var o=E.getSource();if(o.getBindingMode()==B.OneTime){o.detachDataStateChange(t.fChangeHandler);}t.checkDataState();};}this.attachEvent("AggregatedDataStateChange",f,l);if(this.aBindings){this.aBindings.forEach(function(o){o.attachEvent("DataStateChange",t.fDataStateChangeHandler);});}};e.prototype.detachAggregatedDataStateChange=function(f,l){var t=this;this.detachEvent("AggregatedDataStateChange",f,l);if(this.aBindings){this.aBindings.forEach(function(o){o.detachEvent("DataStateChange",t.fDataStateChangeHandler);});}};e.prototype.updateRequired=function(m){var u=false;this.aBindings.forEach(function(o){u=u||o.updateRequired(m);});return u;};e.prototype.initialize=function(){this.bPreventUpdate=true;if(this.aBindings){this.aBindings.forEach(function(o){o.initialize();});}this.bPreventUpdate=false;if(!this.bSuspended){this.checkUpdate(true);}return this;};e.prototype.getDataState=function(){if(!this.oDataState){this.oDataState=new b(this.aBindings.map(function(o){return o.getDataState();}));}return this.oDataState;};e.prototype.suspend=function(){this.bSuspended=true;this.aBindings.forEach(function(o){o.suspend();});};e.prototype.resume=function(){this.aBindings.forEach(function(o){o.resume();});this.bSuspended=false;this.checkUpdate(true);};e.prototype.checkUpdate=function(f){var g=false;if(this.bPreventUpdate||(this.bSuspended&&!f)){return;}var o=this.getDataState();var O=this.getOriginalValue();if(f||!d(O,this.aOriginalValues)){this.aOriginalValues=O;o.setOriginalValue(O);g=true;}var v=this.getValue();if(!d(v,this.aValues)||f){this.aValues=v;o.setValue(v);this._fireChange({reason:C.Change});g=true;}if(g){this.checkDataState();}};return e;});
