/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/model/Context','sap/ui/model/FilterType','sap/ui/model/ListBinding','sap/ui/model/odata/ODataUtils','sap/ui/model/odata/CountMode','sap/ui/model/odata/Filter','sap/ui/model/odata/OperationMode','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterProcessor','sap/ui/model/Sorter','sap/ui/model/SorterProcessor',"sap/base/util/uid","sap/base/util/deepEqual","sap/base/Log","sap/base/assert","sap/ui/thirdparty/jquery"],function(C,F,L,O,a,b,c,d,e,f,S,g,u,h,k,l,q){"use strict";var m=L.extend("sap.ui.model.odata.v2.ODataListBinding",{constructor:function(M,p,i,s,j,P){L.apply(this,arguments);this.sFilterParams=null;this.sSortParams=null;this.sRangeParams=null;this.sCustomParams=this.oModel.createCustomParams(this.mParameters);this.iStartIndex=0;this.iLength=0;this.bPendingChange=false;this.aAllKeys=null;this.aKeys=[];this.sCountMode=(P&&P.countMode)||this.oModel.sDefaultCountMode;this.sOperationMode=(P&&P.operationMode)||this.oModel.sDefaultOperationMode;this.bCreatePreliminaryContext=(P&&P.createPreliminaryContext)||M.bPreliminaryContext;this.bUsePreliminaryContext=(P&&P.usePreliminaryContext)||M.bPreliminaryContext;this.bRefresh=false;this.bNeedsUpdate=false;this.bDataAvailable=false;this.bIgnoreSuspend=false;this.bPendingRefresh=false;this.sGroupId=undefined;this.sRefreshGroupId=undefined;this.bLengthRequested=false;this.bUseExtendedChangeDetection=true;this.bFaultTolerant=P&&P.faultTolerant;this.bLengthFinal=false;this.iLastEndIndex=0;this.aLastContexts=null;this.aLastContextData=null;this.bInitial=true;this.mRequestHandles={};this.oCountHandle=null;this.bSkipDataEvents=false;this.bUseExpandedList=false;this.oCombinedFilter=null;this.oModel.checkFilterOperation(this.aApplicationFilters);if(P&&(P.batchGroupId||P.groupId)){this.sGroupId=P.groupId||P.batchGroupId;}this.iThreshold=(P&&P.threshold)||0;this.bThresholdRejected=false;if(this.sCountMode==a.None){this.bThresholdRejected=true;}var U=this.checkExpandedList();if(!U){this.resetData();}},metadata:{publicMethods:["getLength"]}});m.prototype.getContexts=function(s,j,t){if(this.bInitial){return[];}if(!this.bLengthFinal&&this.sOperationMode==c.Auto&&(this.sCountMode==a.Request||this.sCountMode==a.Both)){if(!this.bLengthRequested){this._getLength();this.bLengthRequested=true;}return[];}if(!this.bLengthFinal&&!this.bPendingRequest&&!this.bLengthRequested){this._getLength();this.bLengthRequested=true;}this.iLastLength=j;this.iLastStartIndex=s;this.iLastThreshold=t;if(!s){s=0;}if(!j){j=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<j){j=this.iLength;}}if(!t){t=0;}if(this.sOperationMode==c.Auto){if(this.iThreshold>=0){t=Math.max(this.iThreshold,t);}}var p=true,r=this._getContexts(s,j),v=[],w;if(this.useClientMode()){if(!this.aAllKeys&&!this.bPendingRequest&&this.oModel.getServiceMetadata()){this.loadData();r.dataRequested=true;}}else{w=this.calculateSection(s,j,t,r);p=r.length!==j&&!(this.bLengthFinal&&r.length>=this.iLength-s);if(this.oModel.getServiceMetadata()){if(!this.bPendingRequest&&w.length>0&&(p||j<w.length)){this.loadData(w.startIndex,w.length);r.dataRequested=true;}}}if(this.bRefresh){this.bRefresh=false;}else{for(var i=0;i<r.length;i++){v.push(this.getContextData(r[i]));}if(this.bUseExtendedChangeDetection){if(this.aLastContexts&&s<this.iLastEndIndex){r.diff=this.diffData(this.aLastContextData,v);}}this.iLastEndIndex=s+j;this.aLastContexts=r.slice(0);this.aLastContextData=v.slice(0);}return r;};m.prototype.getCurrentContexts=function(){return this.aLastContexts||[];};m.prototype.getEntryKey=function(i){return i.getPath();};m.prototype.getEntryData=function(i){return JSON.stringify(i.getObject(this.mParameters));};m.prototype._getContexts=function(s,j){var p=[],r,K;if(!s){s=0;}if(!j){j=this.oModel.iSizeLimit;if(this.bLengthFinal&&this.iLength<j){j=this.iLength;}}for(var i=s;i<s+j;i++){K=this.aKeys[i];if(!K){break;}r=this.oModel.getContext('/'+K);r.sDeepPath=this.oModel.resolveDeep(this.sPath,this.oContext)+K.substr(K.indexOf("("));p.push(r);}return p;};m.prototype.calculateSection=function(s,p,t,r){var v,w,P,x,R,y={},K;w=s;v=0;for(var i=s;i>=Math.max(s-t,0);i--){K=this.aKeys[i];if(!K){x=i+1;break;}}for(var j=s+p;j<s+p+t;j++){K=this.aKeys[j];if(!K){P=j;break;}}R=s-x;if(x&&s>t&&R<t){if(r.length!==p){w=s-t;}else{w=x-t;}v=t;}w=Math.max(w,0);if(w===s){w+=r.length;}if(r.length!==p){v+=p-r.length;}R=P-s-p;if(R===0){v+=t;}if(P&&R<t&&R>0){if(w>s){w=P;v+=t;}}if(this.bLengthFinal&&this.iLength<(v+w)){v=this.iLength-w;}y.startIndex=w;y.length=v;return y;};m.prototype.setContext=function(i){var r,j=i&&i.bCreated,p=i&&i.isRefreshForced(),U=i&&i.isUpdated(),P=i&&i.isPreliminary();if(this.bInitial||!this.isRelative()){return;}if(P&&!this.bUsePreliminaryContext){return;}if(U&&this.bUsePreliminaryContext){this._fireChange({reason:d.Context});return;}if(C.hasChanged(this.oContext,i)){this.oContext=i;r=this.oModel.resolve(this.sPath,this.oContext);if(!this._checkPathType()){k.error("List Binding is not bound against a list for "+r);}if(!r||j){if(this.aAllKeys||this.aKeys.length>0||this.iLength>0){this.aAllKeys=null;this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this._fireChange({reason:d.Context});}return;}this._initSortersFilters();if(this.checkExpandedList()&&!p){this._fireChange({reason:d.Context});}else{this._refresh();}}};m.prototype.checkExpandedList=function(s){var r=!!this.oModel.resolve(this.sPath,this.oContext),R=this.oModel._getObject(this.sPath,this.oContext);if(!r||R===undefined||(this.sOperationMode===c.Server&&(this.aApplicationFilters.length>0||this.aFilters.length>0||this.aSorters.length>0))){this.bUseExpandedList=false;this.aExpandRefs=undefined;return false;}else{this.bUseExpandedList=true;if(Array.isArray(R)){if(!s&&(this.oModel._isReloadNeeded("/"+R[0],this.mParameters)||this.oModel._isReloadNeeded("/"+R[R.length-1],this.mParameters))){this.bUseExpandedList=false;this.aExpandRefs=undefined;return false;}this.aExpandRefs=R;this.aAllKeys=R;this.iLength=R.length;this.bLengthFinal=true;this.bDataAvailable=true;this._initSortersFilters();this.applyFilter();this.applySort();}else{this.aExpandRefs=undefined;this.aAllKeys=null;this.aKeys=[];this.iLength=0;this.bLengthFinal=true;this.bDataAvailable=true;}return true;}};m.prototype.updateExpandedList=function(K){if(this.aExpandRefs){for(var i=0;i<K.length;i++){this.aExpandRefs[i]=K[i];}this.aExpandRefs.length=K.length;}};m.prototype.useClientMode=function(){return(this.sOperationMode===c.Client||this.sOperationMode===c.Auto&&!this.bThresholdRejected||this.sOperationMode!==c.Server&&this.bUseExpandedList);};m.prototype.loadData=function(s,j){var t=this,I=false,G=u(),p;if(s||j){this.sRangeParams="$skip="+s+"&$top="+j;this.iStartIndex=s;}else{s=this.iStartIndex;}var P=[];if(this.sRangeParams&&!this.useClientMode()){P.push(this.sRangeParams);}if(this.sSortParams){P.push(this.sSortParams);}if(this.sFilterParams&&!this.useClientMode()){P.push(this.sFilterParams);}if(this.sCustomParams){P.push(this.sCustomParams);}if(this.sCountMode==a.InlineRepeat||!this.bLengthFinal&&(this.sCountMode===a.Inline||this.sCountMode===a.Both)){P.push("$inlinecount=allpages");I=true;}function r(D){if(I&&D.__count!==undefined){t.iLength=parseInt(D.__count);t.bLengthFinal=true;if(t.sOperationMode==c.Auto){if(t.iLength<=t.mParameters.threshold){t.bThresholdRejected=false;}else{t.bThresholdRejected=true;delete t.mRequestHandles[G];t.bPendingRequest=false;t.bNeedsUpdate=true;return;}}}if(t.useClientMode()){t.aKeys=[];q.each(D.results,function(i,x){t.aKeys[i]=t.oModel._getKey(x);});t.updateExpandedList(t.aKeys);t.aAllKeys=t.aKeys.slice();t.iLength=t.aKeys.length;t.bLengthFinal=true;t.applyFilter();t.applySort();}else{if(D.results.length>0){q.each(D.results,function(i,x){t.aKeys[s+i]=t.oModel._getKey(x);});if(t.iLength<s+D.results.length){t.iLength=s+D.results.length;t.bLengthFinal=false;}if(!D.__next&&(D.results.length<j||j===undefined)){t.iLength=s+D.results.length;t.bLengthFinal=true;}}else{if(t.bFaultTolerant&&D.__next){t.iLength=s;t.bLengthFinal=true;}if(s===0){t.iLength=0;t.aKeys=[];t.bLengthFinal=true;}if(s===t.iLength){t.bLengthFinal=true;}}}delete t.mRequestHandles[G];t.bPendingRequest=false;t.bNeedsUpdate=true;t.bIgnoreSuspend=true;t.oModel.callAfterUpdate(function(){t.fireDataReceived({data:D});});}function E(i){var A=i.statusCode==0;delete t.mRequestHandles[G];t.bPendingRequest=false;if(t.bFaultTolerant){t.iLength=t.aKeys.length;t.bLengthFinal=true;t.bDataAvailable=true;}else if(!A){t.aKeys=[];t.aAllKeys=[];t.iLength=0;t.bLengthFinal=true;t.bDataAvailable=true;t._fireChange({reason:d.Change});}if(!t.bSkipDataEvents){t.fireDataReceived();}}var v=this.sPath,w=this.oContext;if(this.isRelative()){v=this.oModel.resolve(v,w);}if(v){this.bPendingRequest=true;if(!this.bSkipDataEvents){this.fireDataRequested();}this.bSkipDataEvents=false;p=this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId;this.mRequestHandles[G]=this.oModel.read(v,{groupId:p,urlParameters:P,success:r,error:E});}};m.prototype.isLengthFinal=function(){return this.bLengthFinal;};m.prototype.getLength=function(){if(this.bLengthFinal||this.iLength==0){return this.iLength;}else{var A=this.iLastThreshold||this.iLastLength||10;return this.iLength+A;}};m.prototype._getLength=function(){var t=this;var G;if(this.sCountMode!==a.Request&&this.sCountMode!==a.Both){return;}var p=[];if(this.sFilterParams&&this.sOperationMode!=c.Auto){p.push(this.sFilterParams);}if(this.mParameters&&this.mParameters.custom){var i={custom:{}};q.each(this.mParameters.custom,function(s,v){i.custom[s]=v;});p.push(this.oModel.createCustomParams(i));}function _(D){t.iLength=parseInt(D);t.bLengthFinal=true;t.bLengthRequested=true;t.oCountHandle=null;if(t.sOperationMode==c.Auto){if(t.iLength<=t.mParameters.threshold){t.bThresholdRejected=false;}else{t.bThresholdRejected=true;}t._fireChange({reason:d.Change});}}function j(E){delete t.mRequestHandles[P];var s="Request for $count failed: "+E.message;if(E.response){s+=", "+E.response.statusCode+", "+E.response.statusText+", "+E.response.body;}k.warning(s);}var P=this.oModel.resolve(this.sPath,this.oContext);if(P){P=P+"/$count";G=this.sRefreshGroupId?this.sRefreshGroupId:this.sGroupId;this.oCountHandle=this.oModel.read(P,{withCredentials:this.oModel.bWithCredentials,groupId:G,urlParameters:p,success:_,error:j});}};m.prototype.refresh=function(i,G){if(typeof i==="string"){G=i;i=false;}this.sRefreshGroupId=G;this._refresh(i);this.sRefreshGroupId=undefined;};m.prototype._refresh=function(j,p,E){var r=false,s=this.isRelative()&&this.oContext&&this.oContext.bCreated;if(s){return;}this.bPendingRefresh=false;if(!j){if(E){var R=this.oModel.resolve(this.sPath,this.oContext);if(R){var t=this.oModel.oMetadata._getEntityTypeByPath(R);if(t&&(t.entityType in E)){r=true;}}}if(p&&!r){q.each(this.aKeys,function(i,K){if(K in p){r=true;return false;}});}if(!p&&!E){r=true;}}if(j||r){if(this.bSuspended&&!this.bIgnoreSuspend&&!j){this.bPendingRefresh=true;return;}this.abortPendingRequest(true);this.resetData();this._fireRefresh({reason:d.Refresh});}};m.prototype._fireRefresh=function(p){if(this.oModel.resolve(this.sPath,this.oContext)){this.bRefresh=true;this.fireEvent("refresh",p);}};m.prototype._checkPathType=function(){var p=this.oModel.resolve(this.sPath,this.oContext);if(p){if(!this._mPathType||!this._mPathType[p]){this._mPathType={};var I=p.lastIndexOf("/");var t,E;if(I>1){E=this.oModel.oMetadata._getEntityTypeByPath(p.substring(0,I));if(E){t=this.oModel.oMetadata._getEntityAssociationEnd(E,p.substring(I+1));if(t&&t.multiplicity==="*"){this._mPathType[p]=true;}}}else if(I===0){var M,N=p.substring(1);M=this.oModel.oMetadata._findEntitySetByName(N);if(M){this._mPathType[p]=true;}else{var j=this.oModel.oMetadata._getFunctionImportMetadataByName(N);for(var i=0;i<j.length;i++){var r=j[i];if(r.entitySet){M=this.oModel.oMetadata._findEntitySetByName(r.entitySet);if(M){this._mPathType[p]=true;}}}}}}return!!this._mPathType[p];}return true;};m.prototype.initialize=function(){var i=this.isRelative()&&this.oContext&&this.oContext.bCreated;if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.bInitial&&!i){if(!this._checkPathType()){k.error("List Binding is not bound against a list for "+this.oModel.resolve(this.sPath,this.oContext));}this.bInitial=false;this._initSortersFilters();if(!this.bSuspended){if(this.bDataAvailable){this._fireChange({reason:d.Change});}else{this._fireRefresh({reason:d.Refresh});}}}return this;};m.prototype.checkUpdate=function(i,j){var p=this.sChangeReason?this.sChangeReason:d.Change,r=false,s,t=this,v;if((this.bSuspended&&!this.bIgnoreSuspend&&!i)||this.bPendingRequest){return;}if(this.bInitial){if(this.oContext&&this.oContext.isUpdated()){this.initialize();}return;}this.bIgnoreSuspend=false;if(!i&&!this.bNeedsUpdate){v=this.aExpandRefs;var w=this.aKeys.slice();var E=this.checkExpandedList(true);if(!E&&this.useClientMode()){this.applyFilter();this.applySort();}if(!h(v,this.aExpandRefs)){r=true;}else if(j){if(this.aKeys.length!==w.length){r=true;}else{for(var K in j){if(this.aKeys.indexOf(K)>-1||w.indexOf(K)>-1){r=true;break;}}}}else{r=true;}if(r&&this.aLastContexts){r=false;var x=this._getContexts(this.iLastStartIndex,this.iLastLength,this.iLastThreshold);if(this.aLastContexts.length!==x.length){r=true;}else{q.each(this.aLastContextData,function(I,y){s=t.getContextData(x[I]);if(y!==s){r=true;return false;}});}}}if(i||r||this.bNeedsUpdate){this.bNeedsUpdate=false;this._fireChange({reason:p});}this.sChangeReason=undefined;};m.prototype.resetData=function(){this.aKeys=[];this.aAllKeys=null;this.iLength=0;this.bLengthFinal=false;this.sChangeReason=undefined;this.bDataAvailable=false;this.bLengthRequested=false;this.bThresholdRejected=false;if(this.sCountMode==a.None){this.bThresholdRejected=true;}};m.prototype.abortPendingRequest=function(A){if(!q.isEmptyObject(this.mRequestHandles)){this.bSkipDataEvents=true;q.each(this.mRequestHandles,function(p,r){r.abort();});if(A&&this.oCountHandle){this.oCountHandle.abort();}this.mRequestHandles={};this.bPendingRequest=false;}};m.prototype.getDownloadUrl=function(s){var p=[],P;if(s){p.push("$format="+encodeURIComponent(s));}if(this.sSortParams){p.push(this.sSortParams);}if(this.sFilterParams){p.push(this.sFilterParams);}if(this.sCustomParams){p.push(this.sCustomParams);}P=this.oModel.resolve(this.sPath,this.oContext);if(P){return this.oModel._createRequestUrl(P,null,p);}};m.prototype.sort=function(s,r){var i=false;this.bIgnoreSuspend=true;if(!s){s=[];}if(s instanceof S){s=[s];}this.aSorters=s;if(!this.useClientMode()){this.createSortParams(s);}if(!this.bInitial){this.addComparators(s,true);if(this.useClientMode()){if(this.aAllKeys){if(s.length==0){this.applyFilter();}else{this.applySort();}this._fireChange({reason:d.Sort});}else{this.sChangeReason=d.Sort;}}else{this.aKeys=[];this.abortPendingRequest(false);this.sChangeReason=d.Sort;this._fireRefresh({reason:this.sChangeReason});}this._fireSort({sorter:s});i=true;}if(r){return i;}else{return this;}};m.prototype.addComparators=function(E,s){var p,t,i=this.oEntityType,j;if(!i){k.warning("Cannot determine sort/filter comparators, as entitytype of the collection is unkown!");return;}E.forEach(function(r){if(r.aFilters){this.addComparators(r.aFilters);}else if(!r.fnCompare){p=this.oModel.oMetadata._getPropertyMetadata(i,r.sPath);t=p&&p.type;l(p,"PropertyType for property "+r.sPath+" of EntityType "+i.name+" not found!");j=O.getComparator(t);if(s){r.fnCompare=n(j);}else{r.fnCompare=j;o(t,r);}}}.bind(this));};function n(i){return function(v,V){if(v===V){return 0;}if(v===null){return-1;}if(V===null){return 1;}return i(v,V);};}function o(t,i){switch(t){case"Edm.Decimal":case"Edm.Int64":if(typeof i.oValue1=="number"){i.oValue1=i.oValue1.toString();}if(typeof i.oValue2=="number"){i.oValue2=i.oValue2.toString();}break;case"Edm.Byte":case"Edm.Int16":case"Edm.Int32":case"Edm.SByte":if(typeof i.oValue1=="string"){i.oValue1=parseInt(i.oValue1);}if(typeof i.oValue2=="string"){i.oValue2=parseInt(i.oValue2);}break;case"Edm.Float":case"Edm.Single":case"Edm.Double":if(typeof i.oValue1=="string"){i.oValue1=parseFloat(i.oValue1);}if(typeof i.oValue2=="string"){i.oValue2=parseFloat(i.oValue2);}break;default:}}m.prototype.applySort=function(){var t=this,i;this.aKeys=g.apply(this.aKeys,this.aSorters,function(r,p){i=t.oModel.getContext('/'+r);return t.oModel.getProperty(p,i);});};m.prototype.createSortParams=function(s){this.sSortParams=O.createSortParams(s);};m.prototype.filter=function(i,s,r){var j=false;this.bIgnoreSuspend=true;if(!i){i=[];}if(i instanceof e){i=[i];}this.oModel.checkFilterOperation(i);if(s===F.Application){this.aApplicationFilters=i;}else{this.aFilters=i;}if(!this.aFilters||!Array.isArray(this.aFilters)){this.aFilters=[];}if(!this.aApplicationFilters||!Array.isArray(this.aApplicationFilters)){this.aApplicationFilters=[];}this.convertFilters();this.oCombinedFilter=f.combineFilters(this.aFilters,this.aApplicationFilters);if(!this.useClientMode()){this.createFilterParams(this.oCombinedFilter);}if(!this.bInitial){this.addComparators(this.aFilters);this.addComparators(this.aApplicationFilters);if(this.useClientMode()){if(this.aAllKeys){this.applyFilter();this.applySort();this._fireChange({reason:d.Filter});}else{this.sChangeReason=d.Filter;}}else{this.resetData();this.abortPendingRequest(true);this.sChangeReason=d.Filter;this._fireRefresh({reason:this.sChangeReason});}if(s===F.Application){this._fireFilter({filters:this.aApplicationFilters});}else{this._fireFilter({filters:this.aFilters});}j=true;}if(r){return j;}else{return this;}};m.prototype.convertFilters=function(){this.aFilters=this.aFilters.map(function(i){return i instanceof b?i.convert():i;});this.aApplicationFilters=this.aApplicationFilters.map(function(i){return i instanceof b?i.convert():i;});};m.prototype.applyFilter=function(){var t=this,i;this.oCombinedFilter=f.combineFilters(this.aFilters,this.aApplicationFilters);this.aKeys=f.apply(this.aAllKeys,this.oCombinedFilter,function(r,p){i=t.oModel.getContext('/'+r);return t.oModel.getProperty(p,i);});this.iLength=this.aKeys.length;};m.prototype.createFilterParams=function(i){this.sFilterParams=O.createFilterParams(i,this.oModel.oMetadata,this.oEntityType);};m.prototype._initSortersFilters=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(!r){return;}this.oEntityType=this._getEntityType();this.addComparators(this.aSorters,true);this.addComparators(this.aFilters);this.addComparators(this.aApplicationFilters);this.convertFilters();this.oCombinedFilter=f.combineFilters(this.aFilters,this.aApplicationFilters);if(!this.useClientMode()){this.createSortParams(this.aSorters);this.createFilterParams(this.oCombinedFilter);}};m.prototype._getEntityType=function(){var r=this.oModel.resolve(this.sPath,this.oContext);if(r){var E=this.oModel.oMetadata._getEntityTypeByPath(r);l(E,"EntityType for path "+r+" could not be found!");return E;}return undefined;};m.prototype.resume=function(){this.bIgnoreSuspend=false;this.bSuspended=false;if(this.bPendingRefresh){this._refresh();}else{this.checkUpdate();}};m.prototype.suspend=function(){if(this.bInitial){this.bPendingRefresh=true;}L.prototype.suspend.apply(this,arguments);};return m;});
