/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/thirdparty/jquery","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/dt/DesignTime","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/CommandFactory","sap/ui/rta/command/LREPSerializer","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/Stretch","sap/ui/rta/plugin/ControlVariant","sap/ui/dt/plugin/ToolHooks","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/fl/FlexControllerFactory","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/dt/ElementUtil","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/appVariant/Feature","sap/ui/Device","sap/ui/rta/service/index","sap/ui/rta/util/ServiceEventBus","sap/ui/dt/OverlayRegistry","sap/base/strings/capitalize","sap/base/util/UriParameters","sap/ui/performance/Measurement","sap/base/Log","sap/ui/events/KeyCodes"],function(q,M,F,S,P,D,O,C,a,L,R,b,c,d,e,f,A,g,h,j,k,l,m,n,o,T,p,r,s,U,t,E,u,v,w,x,y,B,z,G,H,I,J,K,N,Q,V,W,X,Y){"use strict";var Z="sap-ui-fl-max-layer";var $="STARTING";var _="STARTED";var a1="STOPPED";var b1="FAILED";var c1="SERVICE_STARTING";var d1="SERVICE_STARTED";var e1="SERVICE_FAILED";var f1=M.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{rootControl:{type:"sap.ui.base.ManagedObject"}},properties:{customFieldUrl:"string",showCreateCustomField:"boolean",showToolbars:{type:"boolean",defaultValue:true},triggeredFromDialog:{type:"boolean",defaultValue:false},showWindowUnloadDialog:{type:"boolean",defaultValue:true},commandStack:{type:"any"},plugins:{type:"any",defaultValue:{}},flexSettings:{type:"object",defaultValue:{layer:"CUSTOMER",developerMode:true}},mode:{type:"string",defaultValue:"adaptation"},metadataScope:{type:"string",defaultValue:"default"},validateAppVersion:{type:"boolean",defaultValue:false}},events:{start:{parameters:{editablePluginsCount:{type:"int"}}},stop:{},failed:{},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},modeChanged:{},undoRedoStackModified:{}}},_sAppTitle:null,_dependents:null,_sStatus:a1,constructor:function(){M.apply(this,arguments);this._dependents={};this._mServices={};this._mCustomServicesDictinary={};this.iEditableOverlaysCount=0;this.addDependent(new y(),'popupManager');if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);}if(window.parent!==window){this.startService('receiver');}},_RESTART:{NOT_NEEDED:"no restart",VIA_HASH:"without max layer",RELOAD_PAGE:"reload"}});f1.prototype.getDefaultPlugins=function(){if(!this._mDefaultPlugins){var i=new a({flexSettings:this.getFlexSettings()});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new l({commandFactory:i,multiSelectionRequiredPlugins:[j.getMetadata().getName(),e.getMetadata().getName()],elementEditableChange:this._onElementEditableChange.bind(this)});var j1=new c({commandFactory:i});this._mDefaultPlugins["dragDrop"]=new b({elementMover:j1,commandFactory:i,dragStarted:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["rename"]=new R({commandFactory:i,editable:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:i,analyzer:h,dialog:new g()});this._mDefaultPlugins["createContainer"]=new f({commandFactory:i});this._mDefaultPlugins["remove"]=new e({commandFactory:i});this._mDefaultPlugins["cutPaste"]=new d({elementMover:j1,commandFactory:i});this._mDefaultPlugins["settings"]=new m({commandFactory:i});this._mDefaultPlugins["combine"]=new j({commandFactory:i});this._mDefaultPlugins["split"]=new k({commandFactory:i});this._mDefaultPlugins["contextMenu"]=new p();this._mDefaultPlugins["tabHandling"]=new r();this._mDefaultPlugins["stretch"]=new n();this._mDefaultPlugins["controlVariant"]=new o({commandFactory:i});this._mDefaultPlugins["toolHooks"]=new T();}return q.extend({},this._mDefaultPlugins);};f1.prototype.addDependent=function(i,j1,k1){k1=typeof k1==='undefined'?true:!!k1;if(!(j1 in this._dependents)){if(j1&&k1){this['get'+Q(j1,0)]=this.getDependent.bind(this,j1);}this._dependents[j1||i.getId()]=i;}else{throw t.createError("RuntimeAuthoring#addDependent",t.printf("Can't add dependency with same key '{0}'",j1),"sap.ui.rta");}};f1.prototype.getDependent=function(i){return this._dependents[i];};f1.prototype.getDependents=function(){return this._dependents;};f1.prototype.removeDependent=function(i){delete this._dependents[i];};f1.prototype._destroyDefaultPlugins=function(i){for(var j1 in this._mDefaultPlugins){var k1=this._mDefaultPlugins[j1];if(k1&&!k1.bIsDestroyed){if(!i||i[j1]!==k1){k1.destroy();}}}if(!i){this._mDefaultPlugins=null;}};f1.prototype.onPopupOpen=function(i){if(i.getParameters()instanceof sap.m.Dialog&&this.getToolbar()instanceof F){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};f1.prototype.onPopupClose=function(i){if(i.getParameters()instanceof sap.m.Dialog){this.getToolbar().setColor();}};f1.prototype.setPlugins=function(i){if(this._oDesignTime){throw new Error('Cannot replace plugins: runtime authoring already started');}this.setProperty("plugins",i);};f1.prototype.setFlexSettings=function(i){var j1=new V(window.location.href);var k1=j1.get("sap-ui-layer");i=q.extend({},this.getFlexSettings(),i);if(k1){i.layer=k1.toUpperCase();}if(i.scenario||i.baseId){var l1=u.buildLrepRootNamespace(i.baseId,i.scenario,i.projectId);i.rootNamespace=l1;i.namespace=l1+"changes/";}U.setRtaStyleClassName(i.layer);this.setProperty("flexSettings",i);};f1.prototype.getLayer=function(){return this.getFlexSettings().layer;};f1.prototype.getRootControlInstance=function(){if(!this._oRootControl){this._oRootControl=E.getElementInstance(this.getRootControl());}return this._oRootControl;};f1.prototype._getFlexController=function(){return s.createForControl(this.getRootControlInstance());};f1.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};f1.prototype.start=function(){this._sStatus=$;var i;var j1;if(!this._oDesignTime){if(!this.getRootControlInstance()){j1=new Error("Root control not found");u.log.error(j1);return Promise.reject(j1);}if(this.getValidateAppVersion()&&!u.isCorrectAppVersionFormat(this._getFlexController().getAppVersion())){j1=this._getTextResources().getText("MSG_INCORRECT_APP_VERSION_ERROR");u.log.error(j1);return Promise.reject(j1);}return this._handleHigherLayerChangesOnStart().then(function(k1){if(k1){return Promise.reject("Reload triggered");}if(!this.getPlugins()||!Object.keys(this.getPlugins()).length){this.setPlugins(this.getDefaultPlugins());}this._destroyDefaultPlugins(this.getPlugins());Object.keys(this.getPlugins()).forEach(function(n1){if(this.getPlugins()[n1].attachElementModified){this.getPlugins()[n1].attachElementModified(this._handleElementModified,this);}}.bind(this));if(this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(this.getCommandStack());}this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});var l1=Object.keys(this.getPlugins());var m1=l1.map(function(n1){return this.getPlugins()[n1];},this);i=new Promise(function(n1,o1){W.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:m1});this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()==="USER"){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}else{q("body").addClass("sapUiRtaMode");}this._oDesignTime.getSelectionManager().attachChange(function(p1){this.fireSelectionChange({selection:p1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){n1();W.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",function(p1){o1(p1.getParameter("error"));});}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getPublishAndAppVariantSupportVisibility().then(function(k1){var l1=k1[0];var m1=k1[1];this._createToolsMenu(l1,m1);}.bind(this));}}.bind(this)).then(function(){this._onStackModified();}.bind(this)).then(function(){G.loadStyles('InPageStyles').then(function(k1){var l1=k1.replace(/%scrollWidth%/g,z.getScrollbarWidth()+'px');z.insertStyles(l1,O.getOverlayContainer().get(0));});}).then(function(){return i;}).then(function(){this.getPopupManager().setRta(this);if(this.getShowToolbars()){return this.getToolbar().show();}}.bind(this)).then(function(){if(I.browser.name==="ff"){q(document).on('contextmenu',g1);}}).then(function(){this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);var k1=N.getOverlay(this.getRootControl());this._$RootControl=k1.getAssociatedDomRef();if(this._$RootControl){this._$RootControl.addClass("sapUiRtaRoot");}}.bind(this)).then(function(){this._sStatus=_;this.fireStart({editablePluginsCount:this.iEditableOverlaysCount});}.bind(this)).catch(function(j1){if(j1!=="Reload triggered"){this._sStatus=b1;this.fireFailed(j1);}if(j1){return Promise.reject(j1);}}.bind(this));}};function g1(){return false;}f1.prototype._getPublishAndAppVariantSupportVisibility=function(){return v.getInstance().then(function(i){var j1=H.isPlatFormEnabled(this.getRootControlInstance(),this.getLayer(),this._oSerializer);return[!i.isProductiveSystem()&&!i.hasMergeErrorOccured(),!i.isProductiveSystem()&&j1];}.bind(this)).catch(function(){return false;});};var h1=function(j1){B.hide();var k1="";if(j1.messages&&Array.isArray(j1.messages)){for(var i=0;i<j1.messages.length;i++){k1=(j1.messages[i].severity==="Error")?k1+j1.messages[i].text+"\n":k1;}}else{k1=j1.stack||j1.message||j1.status||j1;}var l1=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");X.error("Failed to transfer runtime adaptation changes to layered repository",k1);var m1=l1.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+l1.getText("MSG_ERROR_REASON",k1);w.error(m1,{styleClass:U.getRtaStyleClassName()});};f1.prototype.setCommandStack=function(i){var j1=this.getProperty("commandStack");if(j1){j1.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var k1=this.setProperty("commandStack",i);if(i){i.attachModified(this._onStackModified,this);}if(this.getPlugins()&&this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(i);}return k1;};f1.prototype.getCommandStack=function(){var i=this.getProperty("commandStack");if(!i){i=new C();this._oInternalCommandStack=i;this.setCommandStack(i);}return i;};f1.prototype._onStackModified=function(){var i=this.getCommandStack();var j1=i.canUndo();var k1=i.canRedo();if(this.getShowToolbars()){this.getToolbar().setUndoRedoEnabled(j1,k1);this.getToolbar().setPublishEnabled(this._bChangesExist||j1);this.getToolbar().setRestoreEnabled(this._bChangesExist||j1);}this.fireUndoRedoStackModified();};f1.prototype._closeToolbar=function(){if(this.getShowToolbars()&&this.getToolbar){return this.getToolbar().hide();}};f1.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}return[];};f1.prototype.stop=function(i,j1){return((j1)?Promise.resolve(this._RESTART.NOT_NEEDED):this._handleReloadOnExit()).then(function(k1){return((i)?Promise.resolve():this._serializeToLrep(this)).then(this._closeToolbar.bind(this)).then(function(){this.fireStop();if(k1!==this._RESTART.NOT_NEEDED){this._removeMaxLayerParameter();if(k1===this._RESTART.RELOAD_PAGE){this._reloadPage();}}}.bind(this));}.bind(this)).catch(h1).then(function(){this._sStatus=a1;q("body").removeClass("sapUiRtaMode");}.bind(this));};f1.prototype.restore=function(){this._onRestore();};f1.prototype.transport=function(){return this._onTransport();};f1.prototype.undo=function(){return this._onUndo();};f1.prototype.redo=function(){return this._onRedo();};f1.prototype.canUndo=function(){return this.getCommandStack().canUndo();};f1.prototype.canRedo=function(){return this.getCommandStack().canRedo();};f1.prototype._onKeyDown=function(i){var j1=I.os.macintosh;var k1=O.getOverlayContainer().get(0).contains(document.activeElement);var l1=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var m1=false;q(".sapUiDtContextMenu").each(function(q1,r1){if(r1.contains(document.activeElement)){m1=true;}});var n1=document.body===document.activeElement;var o1=q(document.activeElement).parents('.sapUiRtaEditableField').length>0;if((k1||l1||m1||n1)&&!o1){var p1=j1?i.metaKey:i.ctrlKey;if(i.keyCode===Y.Z&&i.shiftKey===false&&i.altKey===false&&p1===true){this._onUndo().then(i.stopPropagation.bind(i));}else if(((j1&&i.keyCode===Y.Z&&i.shiftKey===true)||(!j1&&i.keyCode===Y.Y&&i.shiftKey===false))&&i.altKey===false&&p1===true){this._onRedo().then(i.stopPropagation.bind(i));}}};f1.prototype._onUnload=function(){var i=this.getCommandStack();var j1=i.canUndo()||i.canRedo();if(j1&&this.getShowWindowUnloadDialog()){var k1=this._getTextResources().getText("MSG_UNSAVED_CHANGES");return k1;}window.onbeforeunload=this._oldUnloadHandler;};f1.prototype._serializeToLrep=function(){return this._oSerializer.saveCommands().then(this._invalidateCache.bind(this));};f1.prototype._invalidateCache=function(){return this._getFlexController().getComponentChanges(undefined,true);};f1.prototype._onUndo=function(){this._handleStopCutPaste();return this.getCommandStack().undo();};f1.prototype._onRedo=function(){this._handleStopCutPaste();return this.getCommandStack().redo();};f1.prototype._createToolsMenu=function(i,j1){if(!this.getDependent('toolbar')){var k1;if(this.getLayer()==="USER"){k1=P;}else if(U.getFiori2Renderer()){k1=F;}else{k1=S;}if(this.getLayer()==="USER"){this.addDependent(new k1({textResources:this._getTextResources(),exit:this.stop.bind(this,false,true),restore:this._onRestore.bind(this)}),'toolbar');}else{this.addDependent(new k1({modeSwitcher:this.getMode(),publishVisible:i,textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),transport:this._onTransport.bind(this),restore:this._onRestore.bind(this),undo:this._onUndo.bind(this),redo:this._onRedo.bind(this),modeChange:this._onModeChange.bind(this),manageApps:H.onGetOverview.bind(null,true),appVariantOverview:this._onGetAppVariantOverview.bind(this),saveAs:H.onSaveAsFromRtaToolbar.bind(null,true,true)}),'toolbar');}var l1;if(j1){this.getToolbar().getControl('saveAs').setVisible(j1);l1=H.isOverviewExtended();if(l1){this.getToolbar().getControl('appVariantOverview').setVisible(j1);}else{this.getToolbar().getControl('manageApps').setVisible(j1);}H.isManifestSupported().then(function(m1){if(l1){this.getToolbar().getControl('appVariantOverview').setEnabled(m1);}else{this.getToolbar().getControl('manageApps').setEnabled(m1);}this.getToolbar().getControl('saveAs').setEnabled(m1);}.bind(this));}this._checkChangesExist().then(function(m1){if(!this.bIsDestroyed){this._bChangesExist=m1;this.getToolbar().setPublishEnabled(m1);this.getToolbar().setRestoreEnabled(m1);}}.bind(this));}};f1.prototype._onGetAppVariantOverview=function(i){var j1=i.getParameter("item");var k1=j1.getId()==='keyUser';return H.onGetOverview(k1);};f1.prototype.destroy=function(){q.map(this._dependents,function(i,j1){this.removeDependent(j1);i.destroy(true);}.bind(this));Object.keys(this._mServices).forEach(function(i){this.stopService(i);},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);this._destroyDefaultPlugins();this.setPlugins(null);}if(this._$RootControl){this._$RootControl.removeClass("sapUiRtaRoot");}this.setCommandStack(null);if(this._oServiceEventBus){this._oServiceEventBus.destroy();}if(I.browser.name==="ff"){q(document).off("contextmenu",g1);}window.onbeforeunload=this._oldUnloadHandler;M.prototype.destroy.apply(this,arguments);};f1.prototype._onTransport=function(){this._handleStopCutPaste();B.show(500);return this._serializeToLrep().then(function(){B.hide();var i=u.isApplicationVariant(this._oRootControl)&&!u.isVariantByStartupParameter(this._oRootControl);return((i)?H.getAppVariantDescriptor(this._oRootControl):Promise.resolve()).then(function(j1){var k1=[];if(j1){k1.push(j1);}return this._getFlexController()._oChangePersistence.transportAllUIChanges(this._oRootControl,U.getRtaStyleClassName(),this.getLayer(),k1).then(function(l1){if(l1!=="Error"&&l1!=="Cancel"){this._showMessageToast("MSG_TRANSPORT_SUCCESS");}}.bind(this));}.bind(this));}.bind(this))['catch'](h1);};f1.prototype._deleteChanges=function(){var i=this.getRootControlInstance();var j1=u.isApplicationVariant(i)||u.isVariantByStartupParameter(i);var k1=u.getAppComponentForControl(i);var l1=this._getFlexController();return l1.resetChanges(this.getLayer(),"Change.createInitialFileContent",k1).then(function(){if(!j1){var m1=U.getAppDescriptorFlexController(i);return m1.resetChanges(this.getLayer(),"Change.createInitialFileContent",k1);}}.bind(this)).then(function(){this._reloadPage();}.bind(this)).catch(function(m1){return U._showMessageBox(w.Icon.ERROR,"HEADER_RESTORE_FAILED","MSG_RESTORE_FAILED",m1);});};f1.prototype._reloadPage=function(){window.location.reload();};f1.prototype._showMessageToast=function(i){var j1=this._getTextResources().getText(i);x.show(j1);};f1.needsRestart=function(i){var j1=!!window.sessionStorage.getItem("sap.ui.rta.restart."+i);return j1;};f1.enableRestart=function(i){window.sessionStorage.setItem("sap.ui.rta.restart."+i,true);};f1.disableRestart=function(i){window.sessionStorage.removeItem("sap.ui.rta.restart."+i);};f1.prototype._onRestore=function(){var i=this.getLayer()==="USER"?this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION"):this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");var j1=this.getLayer()==="USER"?this._getTextResources().getText("BTN_RESTORE"):this._getTextResources().getText("FORM_PERS_RESET_TITLE");var k1=function(l1){if(l1==="OK"){f1.enableRestart(this.getLayer());this._deleteChanges();this.getCommandStack().removeAllCommands();}}.bind(this);this._handleStopCutPaste();w.confirm(i,{icon:w.Icon.WARNING,title:j1,onClose:k1,styleClass:U.getRtaStyleClassName()});};f1.prototype._scheduleRenameOnCreatedContainer=function(i,j1){var k1=function(o1){var p1=this.getPlugins()["createContainer"].getCreatedContainerId(i,o1.getElement().getId());var q1=N.getOverlay(p1);q1.setSelected(true);this.getPlugins()["rename"].startEdit(q1);};var l1=function(o1){var p1=o1.getSource();if(p1.getGeometry()&&p1.getGeometry().visible){k1.call(this,p1);p1.detachEvent('geometryChanged',l1,this);}};var m1=function(o1){if(!o1.getGeometry()||!o1.getGeometry().visible){o1.attachEvent('geometryChanged',l1,this);}else{k1.call(this,o1);}};var n1=function(o1){var p1=o1.getParameter("elementOverlay");if(p1.getElement().getId()===j1){this._oDesignTime.detachEvent("elementOverlayCreated",n1,this);if(p1.isRendered()){m1.call(this,p1);}else{p1.attachEventOnce('afterRendering',function(o1){m1.call(this,o1.getSource());},this);}}};this._oDesignTime.attachEvent("elementOverlayCreated",n1,this);};f1.prototype._handleElementModified=function(i){this._handleStopCutPaste();var j1=i.getParameter("action");var k1=i.getParameter("newControlId");var l1=i.getParameter("command");if(l1 instanceof sap.ui.rta.command.BaseCommand){if(j1&&k1){this._scheduleRenameOnCreatedContainer(j1,k1);}return this.getCommandStack().pushAndExecute(l1).catch(function(m1){if(m1&&m1.message&&m1.message.indexOf("The following Change cannot be applied because of a dependency")>-1){U._showMessageBox(w.Icon.ERROR,"HEADER_DEPENDENCY_ERROR","MSG_DEPENDENCY_ERROR",m1);}u.log.error("sap.ui.rta: "+m1.message);});}return Promise.resolve();};f1.prototype._onElementEditableChange=function(i){var j1=i.getParameter("editable");if(j1){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};f1.prototype._handleStopCutPaste=function(){if(this.getPlugins()["cutPaste"]){this.getPlugins()["cutPaste"].stopCutAndPaste();}};f1.prototype._checkChangesExist=function(){if(this._getFlexController().getComponentName().length>0){return this._getFlexController().getComponentChanges({currentLayer:this.getLayer(),includeCtrlVariants:true}).then(function(i){return i.length>0;});}return Promise.resolve(false);};f1.prototype._buildNavigationArguments=function(i){return{target:{semanticObject:i.semanticObject,action:i.action,context:i.contextRaw},params:i.params,appSpecificRoute:i.appSpecificRoute,writeHistory:false};};f1.prototype._hasMaxLayerParameter=function(i){var j1=this.getLayer();return i.params&&i.params[Z]&&i.params[Z][0]===j1;};f1.prototype._reloadWithoutHigherLayerChangesOnStart=function(i,j1){var k1=this.getLayer();if(!this._hasMaxLayerParameter(i)){if(!i.params){i.params={};}i.params[Z]=[k1];f1.enableRestart(k1);j1.toExternal(this._buildNavigationArguments(i));return Promise.resolve(true);}};f1.prototype._removeMaxLayerParameter=function(){if(u.getUshellContainer()&&this.getLayer()!=="USER"){var i=u.getUshellContainer().getService("CrossApplicationNavigation");var j1=u.getParsedURLHash();if(i.toExternal&&j1){if(this._hasMaxLayerParameter(j1)){delete j1.params[Z];i.toExternal(this._buildNavigationArguments(j1));}}}};f1.prototype._handleReloadWithoutHigherLayerChangesMessageBoxOnStart=function(){var i=this.getLayer();var j1=i==="CUSTOMER"?"MSG_PERSONALIZATION_EXISTS":"MSG_HIGHER_LAYER_CHANGES_EXIST";return U._showMessageBox(w.Icon.INFORMATION,"HEADER_PERSONALIZATION_EXISTS",j1);};f1.prototype._handleReloadMessageBox=function(i){return U._showMessageBox(w.Icon.INFORMATION,"HEADER_RELOAD_NEEDED",i,undefined,"BUTTON_RELOAD_NEEDED");};f1.prototype._handleHigherLayerChangesOnStart=function(){var i=u.getUshellContainer();if(i&&this.getLayer()!=="USER"){var j1=u.getParsedURLHash();return this._getFlexController().hasHigherLayerChanges({ignoreMaxLayerParameter:false}).then(function(k1){if(k1){return this._handleReloadWithoutHigherLayerChangesMessageBoxOnStart().then(function(){var l1=i.getService("CrossApplicationNavigation");if(l1.toExternal&&j1){return this._reloadWithoutHigherLayerChangesOnStart(j1,l1);}}.bind(this));}}.bind(this));}return Promise.resolve(false);};f1.prototype._handleReloadOnExit=function(){return Promise.all([this._oSerializer.needsReload(),this._getFlexController().hasHigherLayerChanges({ignoreMaxLayerParameter:true})]).then(function(i){var j1=i[0],k1=i[1];if(j1||k1){var l1=this._RESTART.RELOAD_PAGE;var m1,n1;if(k1){var o1=this.getLayer();m1=o1==="CUSTOMER"?"MSG_RELOAD_WITH_PERSONALIZATION":"MSG_RELOAD_WITH_ALL_CHANGES";n1=u.getUshellContainer();if(!j1&&n1){l1=this._RESTART.VIA_HASH;}}else if(j1){m1="MSG_RELOAD_NEEDED";}return this._handleReloadMessageBox(m1).then(function(){return l1;});}return this._RESTART.NOT_NEEDED;}.bind(this));};f1.prototype._onModeChange=function(i){this.setMode(i.getParameter("item").getKey());};f1.prototype.setMode=function(i){if(this.getProperty('mode')!==i){var j1=this.getShowToolbars()&&this.getToolbar().getControl('modeSwitcher');var k1=i==='adaptation';if(j1){j1.setSelectedButton(j1.getItems().filter(function(l1){return l1.getKey()===i;}).pop().getId());}this._oDesignTime.setEnabled(k1);this.getPlugins()['tabHandling'][k1?'removeTabIndex':'restoreTabIndex']();this.setProperty('mode',i);this.fireModeChanged({mode:i});}};f1.prototype.setMetadataScope=function(i){if(this._oDesignTime){X.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty('metadataScope',i);};function i1(i){if(J.hasOwnProperty(i)){return J[i].replace(/\./g,'/');}}f1.prototype.startService=function(i){if(this._sStatus!==_){return new Promise(function(l1,m1){this.attachEventOnce('start',l1);this.attachEventOnce('failed',m1);}.bind(this)).then(function(){return this.startService(i);}.bind(this),function(){return Promise.reject(t.createError("RuntimeAuthoring#startService",t.printf("Can't start the service '{0}' while RTA has been failed during a startup",i),"sap.ui.rta"));});}var j1=i1(i);var k1;if(!j1){return Promise.reject(t.createError("RuntimeAuthoring#startService",t.printf("Unknown service. Can't find any registered service by name '{0}'",i),"sap.ui.rta"));}k1=this._mServices[i];if(k1){switch(k1.status){case d1:{return Promise.resolve(k1.exports);}case c1:{return k1.initPromise;}case e1:{return k1.initPromise;}default:{return Promise.reject(t.createError("RuntimeAuthoring#startService",t.printf("Unknown service status. Service name = '{0}'",i),"sap.ui.rta"));}}}else{this._mServices[i]=k1={status:c1,location:j1,initPromise:new Promise(function(l1,m1){sap.ui.require([j1],function(n1){k1.factory=n1;if(!this._oServiceEventBus){this._oServiceEventBus=new K();}t.wrapIntoPromise(n1)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,i)).then(function(o1){if(this.bIsDestroyed){throw t.createError("RuntimeAuthoring#startService",t.printf("RuntimeAuthoring instance is destroyed while initialising the service '{0}'",i),"sap.ui.rta");}if(!q.isPlainObject(o1)){throw t.createError("RuntimeAuthoring#startService",t.printf("Invalid service format. Service should return simple javascript object after initialisation. Service name = '{0}'",i),"sap.ui.rta");}k1.service=o1;k1.exports={};if(Array.isArray(o1.events)&&o1.events.length>0){q.extend(k1.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,i),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,i),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,i)});}var p1=o1.exports||{};q.extend(k1.exports,Object.keys(p1).reduce(function(q1,r1){var s1=p1[r1];q1[r1]=typeof s1==="function"?t.waitForSynced(this._oDesignTime,s1):s1;return q1;}.bind(this),{}));k1.status=d1;l1(Object.freeze(k1.exports));}.bind(this)).catch(m1);}.bind(this),function(n1){k1.status=e1;m1(t.propagateError(n1,"RuntimeAuthoring#startService",t.printf("Can't load service '{0}' by its name: {1}",i,j1),"sap.ui.rta"));});}.bind(this)).catch(function(l1){k1.status=e1;return Promise.reject(t.propagateError(l1,"RuntimeAuthoring#startService",t.printf("Error during service '{0}' initialisation.",i),"sap.ui.rta"));})};return k1.initPromise;}};f1.prototype.stopService=function(i){var j1=this._mServices[i];if(j1){if(j1.status===d1){if(typeof j1.service.destroy==="function"){j1.service.destroy();}}delete this._mServices[i];}else{throw t.createError("RuntimeAuthoring#stopService",t.printf("Can't destroy service: unable to find service with name '{0}'",i),"sap.ui.rta");}};f1.prototype.getService=function(i){return this.startService(i);};return f1;},true);
