/*!
 * OpenUI5
 * (c) Copyright 2009-2019 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/base/ManagedObject","sap/ui/rta/appVariant/AppVariantDialog","sap/ui/rta/appVariant/AppVariantUtils","sap/m/MessageBox","sap/ui/rta/appVariant/Feature","sap/ui/rta/appVariant/S4HanaCloudBackend","sap/ui/rta/Utils","sap/ui/core/BusyIndicator"],function(M,A,a,b,R,S,c,B){"use strict";var d=M.extend("sap.ui.rta.appVariant.AppVariantManager",{metadata:{library:"sap.ui.rta",properties:{rootControl:{type:"sap.ui.core.Control"},commandSerializer:{type:"object"}}}});d.prototype._openDialog=function(C,f){var D=new A("appVariantDialog");D.attachCreate(C);D.attachCancel(f);D.attachAfterClose(function(){this.destroy();});D.open();return D;};d.prototype._prepareAppVariantData=function(D,p){return{idRunningApp:D["sap.app"].id,title:p.title,subTitle:p.subTitle,description:p.description,icon:p.icon,inbounds:D["sap.app"].crossNavigation&&D["sap.app"].crossNavigation.inbounds?D["sap.app"].crossNavigation.inbounds:null};};d.prototype.createAllInlineChanges=function(o){var s,e=[],p;s=a.getId(o.idRunningApp);var f={id:s,reference:o.idRunningApp};e.push(a.createDescriptorVariant(f));p=a.getInlinePropertyChange("title",o.title);e.push(a.createInlineChange(p,"title"));p=a.getInlinePropertyChange("subtitle",o.subTitle);e.push(a.createInlineChange(p,"subtitle"));p=a.getInlinePropertyChange("description",o.description);e.push(a.createInlineChange(p,"description"));p=a.getInlineChangeInputIcon(o.icon);e.push(a.createInlineChange(p,"icon"));var i=a.getInboundInfo(o.inbounds);var C=i.currentRunningInbound;var g=i.addNewInboundRequired;if(C==="customer.savedAsAppVariant"&&g){p=a.getInlineChangeCreateInbound(C);e.push(a.createInlineChange(p,"createInbound"));}p=a.getInlineChangeForInboundPropertySaveAs(C);e.push(a.createInlineChange(p,"inbound"));p=a.getInlineChangeRemoveInbounds(C);e.push(a.createInlineChange(p,"removeInbound"));p=a.getInlineChangesForInboundProperties(C,s,"title",o.title);e.push(a.createInlineChange(p,"inboundTitle"));p=a.getInlineChangesForInboundProperties(C,s,"subTitle",o.subTitle);e.push(a.createInlineChange(p,"inboundSubtitle"));p=a.getInlineChangesForInboundProperties(C,s,"icon",o.icon);e.push(a.createInlineChange(p,"inboundIcon"));return e;};d.prototype.createDescriptor=function(o){var i=this.createAllInlineChanges(o);var e;return Promise.all(i).then(function(r){e=r.shift();i=[];r.forEach(function(I){i.push(e.addDescriptorInlineChange(I));});return Promise.all(i);}).then(function(){var n=e.getNamespace();var s=e.getSettings();if(a.isS4HanaCloud(s)){var t=a.getTransportInput("",n,"manifest","appdescr_variant");return a.openTransportSelection(t);}return Promise.resolve({packageName:"$TMP",transport:""});}).then(function(t){return a.onTransportInDialogSelected(e,t);}).catch(function(E){var f=a.buildErrorInfo("MSG_CREATE_DESCRIPTOR_FAILED",E,e.getId());B.hide();return a.showRelevantDialog(f,false);});};d.prototype.processSaveAsDialog=function(D,s){return new Promise(function(r){var C=function(o){var p=o.getParameters();var e=this._prepareAppVariantData(D,p);r(e);}.bind(this);var f=function(){if(!s){return R.onGetOverview(true);}};return this._openDialog(C,f);}.bind(this));};d.prototype.saveAppVariantToLREP=function(o){return o.submit().catch(function(e){B.hide();var E=a.buildErrorInfo("MSG_SAVE_APP_VARIANT_FAILED",e,o.getId());return a.showRelevantDialog(E,false);});};d.prototype._takeOverDirtyChangesByAppVariant=function(r){return this.getCommandSerializer().saveAsCommands(r);};d.prototype._deleteAppVariantFromLREP=function(s){return a.triggerDeleteAppVariantFromLREP(s);};d.prototype.copyUnsavedChangesToLREP=function(s,C){var o=this.getCommandSerializer().getCommandStack();if(C&&o.getAllExecutedCommands().length){return this._takeOverDirtyChangesByAppVariant(s).catch(function(e){return this._deleteAppVariantFromLREP(s).catch(function(e){B.hide();var E=a.buildErrorInfo("SAVE_AS_MSG_DELETE_APP_VARIANT",e,s);return a.showRelevantDialog(E,false);}).then(function(){B.hide();var E=a.buildErrorInfo("MSG_COPY_UNSAVED_CHANGES_FAILED",e);return a.showRelevantDialog(E,false);});}.bind(this));}return Promise.resolve();};d.prototype.triggerCatalogAssignment=function(o){if(a.isS4HanaCloud(o.getSettings())){return a.triggerCatalogAssignment(o.getId(),o.getReference()).catch(function(e){B.hide();var E=a.buildErrorInfo("MSG_CATALOG_ASSIGNMENT_FAILED",e,o.getId());return a.showRelevantDialog(E,false);});}return Promise.resolve();};d.prototype.triggerCatalogUnAssignment=function(o){if(a.isS4HanaCloud(o.getSettings())){return a.triggerCatalogUnAssignment(o.getId()).catch(function(e){B.hide();var E=a.buildErrorInfo("MSG_DELETE_APP_VARIANT_FAILED",e,o.getId());return a.showRelevantDialog(E,false);});}return Promise.resolve();};d.prototype.notifyKeyUserWhenTileIsReady=function(i,s){var o=new S();return o.notifyFlpCustomizingIsReady(i,true).then(function(){return c._showMessageBox(b.Icon.INFORMATION,"SAVE_APP_VARIANT_NEW_TILE_AVAILABLE_TITLE","MSG_SAVE_APP_VARIANT_NEW_TILE_AVAILABLE");}).catch(function(e){B.hide();var E=a.buildErrorInfo("MSG_TILE_CREATION_FAILED",e,s);E.copyId=true;return a.showRelevantDialog(E,false);});};d.prototype.notifyWhenUnpublishingIsReady=function(i,s){var o=new S();return o.notifyFlpCustomizingIsReady(i,false).catch(function(e){B.hide();var E=a.buildErrorInfo("MSG_DELETE_APP_VARIANT_FAILED",e,s);E.copyId=true;return a.showRelevantDialog(E,false);});};d.prototype._buildSuccessInfo=function(o,s){var C=false;var m=a.getText("SAVE_APP_VARIANT_SUCCESS_MESSAGE")+"\n\n";if(a.isS4HanaCloud(o.getSettings())){if(s){m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_CLOUD_MESSAGE");}else{m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_CLOUD_MESSAGE_OVERVIEW_LIST");}}else if(s){m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_ON_PREMISE_MESSAGE",o.getId());C=true;}else{m+=a.getText("SAVE_APP_VARIANT_SUCCESS_S4HANA_ON_PREMISE_MESSAGE_OVERVIEW_LIST",o.getId());C=true;}return{text:m,appVariantId:o.getId(),copyId:C};};d.prototype.showSuccessMessageAndTriggerActionFlow=function(o,s){var e=this._buildSuccessInfo(o,s);B.hide();return a.showRelevantDialog(e,true).then(function(){return s?a.navigateToFLPHomepage():R.onGetOverview(true);});};return d;},true);
